/** @license
 *
 * jsPDF - PDF Document creation from JavaScript
 * Version 3.0.2 Built on 2025-08-26T11:48:30.930Z
 *                      CommitID 00000000
 *
 * Copyright (c) 2010-2021 James Hall <james@parall.ax>, https://github.com/MrRio/jsPDF
 *               2015-2021 yWorks GmbH, http://www.yworks.com
 *               2015-2021 Lukas Holländer <lukas.hollaender@yworks.com>, https://github.com/HackbrettXXX
 *               2016-2018 Aras Abbasi <aras.abbasi@gmail.com>
 *               2010 Aaron Spike, https://github.com/acspike
 *               2012 Willow Systems Corporation, https://github.com/willowsystems
 *               2012 Pablo Hess, https://github.com/pablohess
 *               2012 Florian Jenett, https://github.com/fjenett
 *               2013 Warren Weckesser, https://github.com/warrenweckesser
 *               2013 Youssef Beddad, https://github.com/lifof
 *               2013 Lee Driscoll, https://github.com/lsdriscoll
 *               2013 Stefan Slonevskiy, https://github.com/stefslon
 *               2013 Jeremy Morel, https://github.com/jmorel
 *               2013 Christoph Hartmann, https://github.com/chris-rock
 *               2014 Juan Pablo Gaviria, https://github.com/juanpgaviria
 *               2014 James Makes, https://github.com/dollaruw
 *               2014 Diego Casorran, https://github.com/diegocr
 *               2014 Steven Spungin, https://github.com/Flamenco
 *               2014 Kenneth Glassey, https://github.com/Gavvers
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Contributor(s):
 *    siefkenj, ahwolf, rickygu, Midnith, saintclair, eaparango,
 *    kim3er, mfo, alnorth, Flamenco
 */

import t from"@babel/runtime/helpers/typeof";import{zlibSync as e}from"fflate";import n from"@babel/runtime/helpers/slicedToArray";import{decode as r}from"fast-png";var i=function(){return"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this}();function a(){i.console&&"function"==typeof i.console.log&&i.console.log.apply(i.console,arguments)}var o={log:a,warn:function(t){i.console&&("function"==typeof i.console.warn?i.console.warn.apply(i.console,arguments):a.call(null,arguments))},error:function(t){i.console&&("function"==typeof i.console.error?i.console.error.apply(i.console,arguments):a(t))}};function s(t,e,n){var r=new XMLHttpRequest;r.open("GET",t),r.responseType="blob",r.onload=function(){l(r.response,e,n)},r.onerror=function(){o.error("could not download file")},r.send()}function u(t){var e=new XMLHttpRequest;e.open("HEAD",t,!1);try{e.send()}catch(n){}return e.status>=200&&e.status<=299}function c(t){try{t.dispatchEvent(new MouseEvent("click"))}catch(n){var e=document.createEvent("MouseEvents");e.initMouseEvent("click",!0,!0,window,0,0,0,80,20,!1,!1,!1,!1,0,null),t.dispatchEvent(e)}}var l=i.saveAs||("object"!==("undefined"==typeof window?"undefined":t(window))||window!==i?function(){}:"undefined"!=typeof HTMLAnchorElement&&"download"in HTMLAnchorElement.prototype?function(t,e,n){var r=i.URL||i.webkitURL,a=document.createElement("a");e=e||t.name||"download",a.download=e,a.rel="noopener","string"==typeof t?(a.href=t,a.origin!==location.origin?u(a.href)?s(t,e,n):c(a,a.target="_blank"):c(a)):(a.href=r.createObjectURL(t),setTimeout(function(){r.revokeObjectURL(a.href)},4e4),setTimeout(function(){c(a)},0))}:"msSaveOrOpenBlob"in navigator?function(e,n,r){if(n=n||e.name||"download","string"==typeof e)if(u(e))s(e,n,r);else{var i=document.createElement("a");i.href=e,i.target="_blank",setTimeout(function(){c(i)})}else navigator.msSaveOrOpenBlob(function(e,n){return void 0===n?n={autoBom:!1}:"object"!==t(n)&&(o.warn("Deprecated: Expected third argument to be a object"),n={autoBom:!n}),n.autoBom&&/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(e.type)?new Blob([String.fromCharCode(65279),e],{type:e.type}):e}(e,r),n)}:function(e,n,r,a){if((a=a||open("","_blank"))&&(a.document.title=a.document.body.innerText="downloading..."),"string"==typeof e)return s(e,n,r);var o="application/octet-stream"===e.type,u=/constructor/i.test(i.HTMLElement)||i.safari,c=/CriOS\/[\d]+/.test(navigator.userAgent);if((c||o&&u)&&"object"===("undefined"==typeof FileReader?"undefined":t(FileReader))){var l=new FileReader;l.onloadend=function(){var t=l.result;t=c?t:t.replace(/^data:[^;]*;/,"data:attachment/file;"),a?a.location.href=t:location=t,a=null},l.readAsDataURL(e)}else{var h=i.URL||i.webkitURL,f=h.createObjectURL(e);a?a.location=f:location.href=f,a=null,setTimeout(function(){h.revokeObjectURL(f)},4e4)}});
/**
 * A class to parse color values
 * @author Stoyan Stefanov <sstoo@gmail.com>
 * {@link   http://www.phpied.com/rgb-color-parser-in-javascript/}
 * @license Use it if you like it
 */function h(t){var e;t=t||"",this.ok=!1,"#"==t.charAt(0)&&(t=t.substr(1,6)),t={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dodgerblue:"1e90ff",feldspar:"d19275",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgrey:"d3d3d3",lightgreen:"90ee90",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370d8",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"d87093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",red:"ff0000",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",violetred:"d02090",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32"}[t=(t=t.replace(/ /g,"")).toLowerCase()]||t;for(var n=[{re:/^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,example:["rgb(123, 234, 45)","rgb(255,234,245)"],process:function(t){return[parseInt(t[1]),parseInt(t[2]),parseInt(t[3])]}},{re:/^(\w{2})(\w{2})(\w{2})$/,example:["#00ff00","336699"],process:function(t){return[parseInt(t[1],16),parseInt(t[2],16),parseInt(t[3],16)]}},{re:/^(\w{1})(\w{1})(\w{1})$/,example:["#fb0","f0f"],process:function(t){return[parseInt(t[1]+t[1],16),parseInt(t[2]+t[2],16),parseInt(t[3]+t[3],16)]}}],r=0;r<n.length;r++){var i=n[r].re,a=n[r].process,o=i.exec(t);o&&(e=a(o),this.r=e[0],this.g=e[1],this.b=e[2],this.ok=!0)}this.r=this.r<0||isNaN(this.r)?0:this.r>255?255:this.r,this.g=this.g<0||isNaN(this.g)?0:this.g>255?255:this.g,this.b=this.b<0||isNaN(this.b)?0:this.b>255?255:this.b,this.toRGB=function(){return"rgb("+this.r+", "+this.g+", "+this.b+")"},this.toHex=function(){var t=this.r.toString(16),e=this.g.toString(16),n=this.b.toString(16);return 1==t.length&&(t="0"+t),1==e.length&&(e="0"+e),1==n.length&&(n="0"+n),"#"+t+e+n}}var f=i.atob.bind(i),d=i.btoa.bind(i);
/**
 * @license
 * Joseph Myers does not specify a particular license for his work.
 *
 * Author: Joseph Myers
 * Accessed from: http://www.myersdaily.org/joseph/javascript/md5.js
 *
 * Modified by: Owen Leong
 */
function p(t,e){var n=t[0],r=t[1],i=t[2],a=t[3];n=m(n,r,i,a,e[0],7,-680876936),a=m(a,n,r,i,e[1],12,-389564586),i=m(i,a,n,r,e[2],17,606105819),r=m(r,i,a,n,e[3],22,-1044525330),n=m(n,r,i,a,e[4],7,-176418897),a=m(a,n,r,i,e[5],12,1200080426),i=m(i,a,n,r,e[6],17,-1473231341),r=m(r,i,a,n,e[7],22,-45705983),n=m(n,r,i,a,e[8],7,1770035416),a=m(a,n,r,i,e[9],12,-1958414417),i=m(i,a,n,r,e[10],17,-42063),r=m(r,i,a,n,e[11],22,-1990404162),n=m(n,r,i,a,e[12],7,1804603682),a=m(a,n,r,i,e[13],12,-40341101),i=m(i,a,n,r,e[14],17,-1502002290),n=v(n,r=m(r,i,a,n,e[15],22,1236535329),i,a,e[1],5,-165796510),a=v(a,n,r,i,e[6],9,-1069501632),i=v(i,a,n,r,e[11],14,643717713),r=v(r,i,a,n,e[0],20,-373897302),n=v(n,r,i,a,e[5],5,-701558691),a=v(a,n,r,i,e[10],9,38016083),i=v(i,a,n,r,e[15],14,-660478335),r=v(r,i,a,n,e[4],20,-405537848),n=v(n,r,i,a,e[9],5,568446438),a=v(a,n,r,i,e[14],9,-1019803690),i=v(i,a,n,r,e[3],14,-187363961),r=v(r,i,a,n,e[8],20,1163531501),n=v(n,r,i,a,e[13],5,-1444681467),a=v(a,n,r,i,e[2],9,-51403784),i=v(i,a,n,r,e[7],14,1735328473),n=b(n,r=v(r,i,a,n,e[12],20,-1926607734),i,a,e[5],4,-378558),a=b(a,n,r,i,e[8],11,-2022574463),i=b(i,a,n,r,e[11],16,1839030562),r=b(r,i,a,n,e[14],23,-35309556),n=b(n,r,i,a,e[1],4,-1530992060),a=b(a,n,r,i,e[4],11,1272893353),i=b(i,a,n,r,e[7],16,-155497632),r=b(r,i,a,n,e[10],23,-1094730640),n=b(n,r,i,a,e[13],4,681279174),a=b(a,n,r,i,e[0],11,-358537222),i=b(i,a,n,r,e[3],16,-722521979),r=b(r,i,a,n,e[6],23,76029189),n=b(n,r,i,a,e[9],4,-640364487),a=b(a,n,r,i,e[12],11,-421815835),i=b(i,a,n,r,e[15],16,530742520),n=y(n,r=b(r,i,a,n,e[2],23,-995338651),i,a,e[0],6,-198630844),a=y(a,n,r,i,e[7],10,1126891415),i=y(i,a,n,r,e[14],15,-1416354905),r=y(r,i,a,n,e[5],21,-57434055),n=y(n,r,i,a,e[12],6,1700485571),a=y(a,n,r,i,e[3],10,-1894986606),i=y(i,a,n,r,e[10],15,-1051523),r=y(r,i,a,n,e[1],21,-2054922799),n=y(n,r,i,a,e[8],6,1873313359),a=y(a,n,r,i,e[15],10,-30611744),i=y(i,a,n,r,e[6],15,-1560198380),r=y(r,i,a,n,e[13],21,1309151649),n=y(n,r,i,a,e[4],6,-145523070),a=y(a,n,r,i,e[11],10,-1120210379),i=y(i,a,n,r,e[2],15,718787259),r=y(r,i,a,n,e[9],21,-343485551),t[0]=P(n,t[0]),t[1]=P(r,t[1]),t[2]=P(i,t[2]),t[3]=P(a,t[3])}function g(t,e,n,r,i,a){return e=P(P(e,t),P(r,a)),P(e<<i|e>>>32-i,n)}function m(t,e,n,r,i,a,o){return g(e&n|~e&r,t,e,i,a,o)}function v(t,e,n,r,i,a,o){return g(e&r|n&~r,t,e,i,a,o)}function b(t,e,n,r,i,a,o){return g(e^n^r,t,e,i,a,o)}function y(t,e,n,r,i,a,o){return g(n^(e|~r),t,e,i,a,o)}function w(t){var e,n=t.length,r=[1732584193,-271733879,-1732584194,271733878];for(e=64;e<=t.length;e+=64)p(r,N(t.substring(e-64,e)));t=t.substring(e-64);var i=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];for(e=0;e<t.length;e++)i[e>>2]|=t.charCodeAt(e)<<(e%4<<3);if(i[e>>2]|=128<<(e%4<<3),e>55)for(p(r,i),e=0;e<16;e++)i[e]=0;return i[14]=8*n,p(r,i),r}function N(t){var e,n=[];for(e=0;e<64;e+=4)n[e>>2]=t.charCodeAt(e)+(t.charCodeAt(e+1)<<8)+(t.charCodeAt(e+2)<<16)+(t.charCodeAt(e+3)<<24);return n}var L="0123456789abcdef".split("");function x(t){for(var e="",n=0;n<4;n++)e+=L[t>>8*n+4&15]+L[t>>8*n&15];return e}function A(t){return String.fromCharCode(255&t,(65280&t)>>8,(16711680&t)>>16,(4278190080&t)>>24)}function S(t){return w(t).map(A).join("")}var _="5d41402abc4b2a76b9719d911017c592"!=function(t){for(var e=0;e<t.length;e++)t[e]=x(t[e]);return t.join("")}(w("hello"));function P(t,e){if(_){var n=(65535&t)+(65535&e);return(t>>16)+(e>>16)+(n>>16)<<16|65535&n}return t+e&4294967295}
/**
 * @license
 * FPDF is released under a permissive license: there is no usage restriction.
 * You may embed it freely in your application (commercial or not), with or
 * without modifications.
 *
 * Reference: http://www.fpdf.org/en/script/script37.php
 */function k(t,e){var n,r,i,a;if(t!==n){for(var o=(i=t,a=1+(256/t.length|0),new Array(a+1).join(i)),s=[],u=0;u<256;u++)s[u]=u;var c=0;for(u=0;u<256;u++){var l=s[u];c=(c+l+o.charCodeAt(u))%256,s[u]=s[c],s[c]=l}n=t,r=s}else s=r;var h=e.length,f=0,d=0,p="";for(u=0;u<h;u++)d=(d+(l=s[f=(f+1)%256]))%256,s[f]=s[d],s[d]=l,o=s[(s[f]+s[d])%256],p+=String.fromCharCode(e.charCodeAt(u)^o);return p}
/**
 * @license
 * Licensed under the MIT License.
 * http://opensource.org/licenses/mit-license
 * Author: Owen Leong (@owenl131)
 * Date: 15 Oct 2020
 * References:
 * https://www.cs.cmu.edu/~dst/Adobe/Gallery/anon21jul01-pdf-encryption.txt
 * https://github.com/foliojs/pdfkit/blob/master/lib/security.js
 * http://www.fpdf.org/en/script/script37.php
 */var F={print:4,modify:8,copy:16,"annot-forms":32};function I(t,e,n,r){this.v=1,this.r=2;var i=192;t.forEach(function(t){if(void 0!==F.perm)throw new Error("Invalid permission: "+t);i+=F[t]}),this.padding="(¿N^NuAd\0NVÿú\b..\0¶Ðh>/\f©þdSiz";var a=(e+this.padding).substr(0,32),o=(n+this.padding).substr(0,32);this.O=this.processOwnerPassword(a,o),this.P=-(1+(255^i)),this.encryptionKey=S(a+this.O+this.lsbFirstWord(this.P)+this.hexToBytes(r)).substr(0,5),this.U=k(this.encryptionKey,this.padding)}function j(t){if(/[^\u0000-\u00ff]/.test(t))throw new Error("Invalid PDF Name Object: "+t+", Only accept ASCII characters.");for(var e="",n=t.length,r=0;r<n;r++){var i=t.charCodeAt(r);e+=i<33||35===i||37===i||40===i||41===i||47===i||60===i||62===i||91===i||93===i||123===i||125===i||i>126?"#"+("0"+i.toString(16)).slice(-2):t[r]}return e}function C(e){if("object"!==t(e))throw new Error("Invalid Context passed to initialize PubSub (jsPDF-module)");var n={};this.subscribe=function(t,e,r){if(r=r||!1,"string"!=typeof t||"function"!=typeof e||"boolean"!=typeof r)throw new Error("Invalid arguments passed to PubSub.subscribe (jsPDF-module)");n.hasOwnProperty(t)||(n[t]={});var i=Math.random().toString(35);return n[t][i]=[e,!!r],i},this.unsubscribe=function(t){for(var e in n)if(n[e][t])return delete n[e][t],0===Object.keys(n[e]).length&&delete n[e],!0;return!1},this.publish=function(t){if(n.hasOwnProperty(t)){var r=Array.prototype.slice.call(arguments,1),a=[];for(var s in n[t]){var u=n[t][s];try{u[0].apply(e,r)}catch(c){i.console&&o.error("jsPDF PubSub Error",c.message,c)}u[1]&&a.push(s)}a.length&&a.forEach(this.unsubscribe)}},this.getTopics=function(){return n}}function O(t){if(!(this instanceof O))return new O(t);var e="opacity,stroke-opacity".split(",");for(var n in t)t.hasOwnProperty(n)&&e.indexOf(n)>=0&&(this[n]=t[n]);this.id="",this.objectNumber=-1}function B(t,e){this.gState=t,this.matrix=e,this.id="",this.objectNumber=-1}function M(t,e,n,r,i){if(!(this instanceof M))return new M(t,e,n,r,i);this.type="axial"===t?2:3,this.coords=e,this.colors=n,B.call(this,r,i)}function q(t,e,n,r,i){if(!(this instanceof q))return new q(t,e,n,r,i);this.boundingBox=t,this.xStep=e,this.yStep=n,this.stream="",this.cloneIndex=0,B.call(this,r,i)}function E(e){var n,r="string"==typeof arguments[0]?arguments[0]:"p",a=arguments[1],s=arguments[2],u=arguments[3],c=[],f=1,p=16,g="S",m=null;"object"===t(e=e||{})&&(r=e.orientation,a=e.unit||a,s=e.format||s,u=e.compress||e.compressPdf||u,null!==(m=e.encryption||null)&&(m.userPassword=m.userPassword||"",m.ownerPassword=m.ownerPassword||"",m.userPermissions=m.userPermissions||[]),f="number"==typeof e.userUnit?Math.abs(e.userUnit):1,void 0!==e.precision&&(n=e.precision),void 0!==e.floatPrecision&&(p=e.floatPrecision),g=e.defaultPathOperation||"S"),c=e.filters||(!0===u?["FlateEncode"]:c),a=a||"mm",r=(""+(r||"P")).toLowerCase();var v=e.putOnlyUsedFonts||!1,b={},y={internal:{},__private__:{}};y.__private__.PubSub=C;var w="1.3",N=y.__private__.getPdfVersion=function(){return w};y.__private__.setPdfVersion=function(t){w=t};var L={a0:[2383.94,3370.39],a1:[1683.78,2383.94],a2:[1190.55,1683.78],a3:[841.89,1190.55],a4:[595.28,841.89],a5:[419.53,595.28],a6:[297.64,419.53],a7:[209.76,297.64],a8:[147.4,209.76],a9:[104.88,147.4],a10:[73.7,104.88],b0:[2834.65,4008.19],b1:[2004.09,2834.65],b2:[1417.32,2004.09],b3:[1000.63,1417.32],b4:[708.66,1000.63],b5:[498.9,708.66],b6:[354.33,498.9],b7:[249.45,354.33],b8:[175.75,249.45],b9:[124.72,175.75],b10:[87.87,124.72],c0:[2599.37,3676.54],c1:[1836.85,2599.37],c2:[1298.27,1836.85],c3:[918.43,1298.27],c4:[649.13,918.43],c5:[459.21,649.13],c6:[323.15,459.21],c7:[229.61,323.15],c8:[161.57,229.61],c9:[113.39,161.57],c10:[79.37,113.39],dl:[311.81,623.62],letter:[612,792],"government-letter":[576,756],legal:[612,1008],"junior-legal":[576,360],ledger:[1224,792],tabloid:[792,1224],"credit-card":[153,243]};y.__private__.getPageFormats=function(){return L};var x=y.__private__.getPageFormat=function(t){return L[t]};s=s||"a4";var A="compat",S="advanced",_=A;function P(){this.saveGraphicsState(),lt(new Wt(St,0,0,-St,0,Ln()*St).toString()+" cm"),this.setFontSize(this.getFontSize()/St),g="n",_=S}function k(){this.restoreGraphicsState(),g="S",_=A}var F=y.__private__.combineFontStyleAndFontWeight=function(t,e){if("bold"==t&&"normal"==e||"bold"==t&&400==e||"normal"==t&&"italic"==e||"bold"==t&&"italic"==e)throw new Error("Invalid Combination of fontweight and fontstyle");return e&&(t=400==e||"normal"===e?"italic"===t?"italic":"normal":700!=e&&"bold"!==e||"normal"!==t?(700==e?"bold":e)+""+t:"bold"),t};y.advancedAPI=function(t){var e=_===A;return e&&P.call(this),"function"!=typeof t||(t(this),e&&k.call(this)),this},y.compatAPI=function(t){var e=_===S;return e&&k.call(this),"function"!=typeof t||(t(this),e&&P.call(this)),this},y.isAdvancedAPI=function(){return _===S};var B,R=function(t){if(_!==S)throw new Error(t+" is only available in 'advanced' API mode. You need to call advancedAPI() first.")},D=y.roundToPrecision=y.__private__.roundToPrecision=function(t,e){var r=n||e;if(isNaN(t)||isNaN(r))throw new Error("Invalid argument passed to jsPDF.roundToPrecision");return t.toFixed(r).replace(/0+$/,"")};B=y.hpf=y.__private__.hpf="number"==typeof p?function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.hpf");return D(t,p)}:"smart"===p?function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.hpf");return D(t,t>-1&&t<1?16:5)}:function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.hpf");return D(t,16)};var T=y.f2=y.__private__.f2=function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.f2");return D(t,2)},z=y.__private__.f3=function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.f3");return D(t,3)},U=y.scale=y.__private__.scale=function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.scale");return _===A?t*St:_===S?t:void 0},H=function(t){return U(function(t){return _===A?Ln()-t:_===S?t:void 0}(t))};y.__private__.setPrecision=y.setPrecision=function(t){"number"==typeof parseInt(t,10)&&(n=parseInt(t,10))};var W,V="00000000000000000000000000000000",G=y.__private__.getFileId=function(){return V},Y=y.__private__.setFileId=function(t){return V=void 0!==t&&/^[a-fA-F0-9]{32}$/.test(t)?t.toUpperCase():V.split("").map(function(){return"ABCDEF0123456789".charAt(Math.floor(16*Math.random()))}).join(""),null!==m&&(je=new I(m.userPermissions,m.userPassword,m.ownerPassword,V)),V};y.setFileId=function(t){return Y(t),this},y.getFileId=function(){return G()};var J=y.__private__.convertDateToPDFDate=function(t){var e=t.getTimezoneOffset(),n=e<0?"+":"-",r=Math.floor(Math.abs(e/60)),i=Math.abs(e%60),a=[n,Q(r),"'",Q(i),"'"].join("");return["D:",t.getFullYear(),Q(t.getMonth()+1),Q(t.getDate()),Q(t.getHours()),Q(t.getMinutes()),Q(t.getSeconds()),a].join("")},X=y.__private__.convertPDFDateToDate=function(t){var e=parseInt(t.substr(2,4),10),n=parseInt(t.substr(6,2),10)-1,r=parseInt(t.substr(8,2),10),i=parseInt(t.substr(10,2),10),a=parseInt(t.substr(12,2),10),o=parseInt(t.substr(14,2),10);return new Date(e,n,r,i,a,o,0)},K=y.__private__.setCreationDate=function(t){var e;if(void 0===t&&(t=new Date),t instanceof Date)e=J(t);else{if(!/^D:(20[0-2][0-9]|203[0-7]|19[7-9][0-9])(0[0-9]|1[0-2])([0-2][0-9]|3[0-1])(0[0-9]|1[0-9]|2[0-3])(0[0-9]|[1-5][0-9])(0[0-9]|[1-5][0-9])(\+0[0-9]|\+1[0-4]|-0[0-9]|-1[0-1])'(0[0-9]|[1-5][0-9])'?$/.test(t))throw new Error("Invalid argument passed to jsPDF.setCreationDate");e=t}return W=e},Z=y.__private__.getCreationDate=function(t){var e=W;return"jsDate"===t&&(e=X(W)),e};y.setCreationDate=function(t){return K(t),this},y.getCreationDate=function(t){return Z(t)};var $,Q=y.__private__.padd2=function(t){return("0"+parseInt(t)).slice(-2)},tt=y.__private__.padd2Hex=function(t){return("00"+(t=t.toString())).substr(t.length)},et=0,nt=[],rt=[],it=0,at=[],ot=[],st=!1,ut=rt;y.__private__.setCustomOutputDestination=function(t){st=!0,ut=t};var ct=function(t){st||(ut=t)};y.__private__.resetCustomOutputDestination=function(){st=!1,ut=rt};var lt=y.__private__.out=function(t){return t=t.toString(),it+=t.length+1,ut.push(t),ut},ht=y.__private__.write=function(t){return lt(1===arguments.length?t.toString():Array.prototype.join.call(arguments," "))},ft=y.__private__.getArrayBuffer=function(t){for(var e=t.length,n=new ArrayBuffer(e),r=new Uint8Array(n);e--;)r[e]=t.charCodeAt(e);return n},dt=[["Helvetica","helvetica","normal","WinAnsiEncoding"],["Helvetica-Bold","helvetica","bold","WinAnsiEncoding"],["Helvetica-Oblique","helvetica","italic","WinAnsiEncoding"],["Helvetica-BoldOblique","helvetica","bolditalic","WinAnsiEncoding"],["Courier","courier","normal","WinAnsiEncoding"],["Courier-Bold","courier","bold","WinAnsiEncoding"],["Courier-Oblique","courier","italic","WinAnsiEncoding"],["Courier-BoldOblique","courier","bolditalic","WinAnsiEncoding"],["Times-Roman","times","normal","WinAnsiEncoding"],["Times-Bold","times","bold","WinAnsiEncoding"],["Times-Italic","times","italic","WinAnsiEncoding"],["Times-BoldItalic","times","bolditalic","WinAnsiEncoding"],["ZapfDingbats","zapfdingbats","normal",null],["Symbol","symbol","normal",null]];y.__private__.getStandardFonts=function(){return dt};var pt=e.fontSize||16;y.__private__.setFontSize=y.setFontSize=function(t){return pt=_===S?t/St:t,this};var gt,mt=y.__private__.getFontSize=y.getFontSize=function(){return _===A?pt:pt*St},vt=e.R2L||!1;y.__private__.setR2L=y.setR2L=function(t){return vt=t,this},y.__private__.getR2L=y.getR2L=function(){return vt};var bt,yt=y.__private__.setZoomMode=function(t){if(/^(?:\d+\.\d*|\d*\.\d+|\d+)%$/.test(t))gt=t;else if(isNaN(t)){if(-1===[void 0,null,"fullwidth","fullheight","fullpage","original"].indexOf(t))throw new Error('zoom must be Integer (e.g. 2), a percentage Value (e.g. 300%) or fullwidth, fullheight, fullpage, original. "'+t+'" is not recognized.');gt=t}else gt=parseInt(t,10)};y.__private__.getZoomMode=function(){return gt};var wt,Nt=y.__private__.setPageMode=function(t){if(-1==[void 0,null,"UseNone","UseOutlines","UseThumbs","FullScreen"].indexOf(t))throw new Error('Page mode must be one of UseNone, UseOutlines, UseThumbs, or FullScreen. "'+t+'" is not recognized.');bt=t};y.__private__.getPageMode=function(){return bt};var Lt=y.__private__.setLayoutMode=function(t){if(-1==[void 0,null,"continuous","single","twoleft","tworight","two"].indexOf(t))throw new Error('Layout mode must be one of continuous, single, twoleft, tworight. "'+t+'" is not recognized.');wt=t};y.__private__.getLayoutMode=function(){return wt},y.__private__.setDisplayMode=y.setDisplayMode=function(t,e,n){return yt(t),Lt(e),Nt(n),this};var xt={title:"",subject:"",author:"",keywords:"",creator:""};y.__private__.getDocumentProperty=function(t){if(-1===Object.keys(xt).indexOf(t))throw new Error("Invalid argument passed to jsPDF.getDocumentProperty");return xt[t]},y.__private__.getDocumentProperties=function(){return xt},y.__private__.setDocumentProperties=y.setProperties=y.setDocumentProperties=function(t){for(var e in xt)xt.hasOwnProperty(e)&&t[e]&&(xt[e]=t[e]);return this},y.__private__.setDocumentProperty=function(t,e){if(-1===Object.keys(xt).indexOf(t))throw new Error("Invalid arguments passed to jsPDF.setDocumentProperty");return xt[t]=e};var At,St,_t,Pt,kt,Ft={},It={},jt=[],Ct={},Ot={},Bt={},Mt={},qt=null,Et=0,Rt=[],Dt=new C(y),Tt=e.hotfixes||[],zt={},Ut={},Ht=[],Wt=function t(e,n,r,i,a,o){if(!(this instanceof t))return new t(e,n,r,i,a,o);isNaN(e)&&(e=1),isNaN(n)&&(n=0),isNaN(r)&&(r=0),isNaN(i)&&(i=1),isNaN(a)&&(a=0),isNaN(o)&&(o=0),this._matrix=[e,n,r,i,a,o]};Object.defineProperty(Wt.prototype,"sx",{get:function(){return this._matrix[0]},set:function(t){this._matrix[0]=t}}),Object.defineProperty(Wt.prototype,"shy",{get:function(){return this._matrix[1]},set:function(t){this._matrix[1]=t}}),Object.defineProperty(Wt.prototype,"shx",{get:function(){return this._matrix[2]},set:function(t){this._matrix[2]=t}}),Object.defineProperty(Wt.prototype,"sy",{get:function(){return this._matrix[3]},set:function(t){this._matrix[3]=t}}),Object.defineProperty(Wt.prototype,"tx",{get:function(){return this._matrix[4]},set:function(t){this._matrix[4]=t}}),Object.defineProperty(Wt.prototype,"ty",{get:function(){return this._matrix[5]},set:function(t){this._matrix[5]=t}}),Object.defineProperty(Wt.prototype,"a",{get:function(){return this._matrix[0]},set:function(t){this._matrix[0]=t}}),Object.defineProperty(Wt.prototype,"b",{get:function(){return this._matrix[1]},set:function(t){this._matrix[1]=t}}),Object.defineProperty(Wt.prototype,"c",{get:function(){return this._matrix[2]},set:function(t){this._matrix[2]=t}}),Object.defineProperty(Wt.prototype,"d",{get:function(){return this._matrix[3]},set:function(t){this._matrix[3]=t}}),Object.defineProperty(Wt.prototype,"e",{get:function(){return this._matrix[4]},set:function(t){this._matrix[4]=t}}),Object.defineProperty(Wt.prototype,"f",{get:function(){return this._matrix[5]},set:function(t){this._matrix[5]=t}}),Object.defineProperty(Wt.prototype,"rotation",{get:function(){return Math.atan2(this.shx,this.sx)}}),Object.defineProperty(Wt.prototype,"scaleX",{get:function(){return this.decompose().scale.sx}}),Object.defineProperty(Wt.prototype,"scaleY",{get:function(){return this.decompose().scale.sy}}),Object.defineProperty(Wt.prototype,"isIdentity",{get:function(){return 1===this.sx&&0===this.shy&&0===this.shx&&1===this.sy&&0===this.tx&&0===this.ty}}),Wt.prototype.join=function(t){return[this.sx,this.shy,this.shx,this.sy,this.tx,this.ty].map(B).join(t)},Wt.prototype.multiply=function(t){var e=t.sx*this.sx+t.shy*this.shx,n=t.sx*this.shy+t.shy*this.sy,r=t.shx*this.sx+t.sy*this.shx,i=t.shx*this.shy+t.sy*this.sy,a=t.tx*this.sx+t.ty*this.shx+this.tx,o=t.tx*this.shy+t.ty*this.sy+this.ty;return new Wt(e,n,r,i,a,o)},Wt.prototype.decompose=function(){var t=this.sx,e=this.shy,n=this.shx,r=this.sy,i=this.tx,a=this.ty,o=Math.sqrt(t*t+e*e),s=(t/=o)*n+(e/=o)*r;n-=t*s,r-=e*s;var u=Math.sqrt(n*n+r*r);return s/=u,t*(r/=u)<e*(n/=u)&&(t=-t,e=-e,s=-s,o=-o),{scale:new Wt(o,0,0,u,0,0),translate:new Wt(1,0,0,1,i,a),rotate:new Wt(t,e,-e,t,0,0),skew:new Wt(1,0,s,1,0,0)}},Wt.prototype.toString=function(t){return this.join(" ")},Wt.prototype.inversed=function(){var t=this.sx,e=this.shy,n=this.shx,r=this.sy,i=this.tx,a=this.ty,o=1/(t*r-e*n),s=r*o,u=-e*o,c=-n*o,l=t*o;return new Wt(s,u,c,l,-s*i-c*a,-u*i-l*a)},Wt.prototype.applyToPoint=function(t){var e=t.x*this.sx+t.y*this.shx+this.tx,n=t.x*this.shy+t.y*this.sy+this.ty;return new gn(e,n)},Wt.prototype.applyToRectangle=function(t){var e=this.applyToPoint(t),n=this.applyToPoint(new gn(t.x+t.w,t.y+t.h));return new mn(e.x,e.y,n.x-e.x,n.y-e.y)},Wt.prototype.clone=function(){var t=this.sx,e=this.shy,n=this.shx,r=this.sy,i=this.tx,a=this.ty;return new Wt(t,e,n,r,i,a)},y.Matrix=Wt;var Vt=y.matrixMult=function(t,e){return e.multiply(t)},Gt=new Wt(1,0,0,1,0,0);y.unitMatrix=y.identityMatrix=Gt;var Yt=function(t,e){if(!Ot[t]){var n=(e instanceof M?"Sh":"P")+(Object.keys(Ct).length+1).toString(10);e.id=n,Ot[t]=n,Ct[n]=e,Dt.publish("addPattern",e)}};y.ShadingPattern=M,y.TilingPattern=q,y.addShadingPattern=function(t,e){return R("addShadingPattern()"),Yt(t,e),this},y.beginTilingPattern=function(t){R("beginTilingPattern()"),bn(t.boundingBox[0],t.boundingBox[1],t.boundingBox[2]-t.boundingBox[0],t.boundingBox[3]-t.boundingBox[1],t.matrix)},y.endTilingPattern=function(t,e){R("endTilingPattern()"),e.stream=ot[$].join("\n"),Yt(t,e),Dt.publish("endTilingPattern",e),Ht.pop().restore()};var Jt,Xt=y.__private__.newObject=function(){var t=Kt();return Zt(t,!0),t},Kt=y.__private__.newObjectDeferred=function(){return et++,nt[et]=function(){return it},et},Zt=function(t,e){return e="boolean"==typeof e&&e,nt[t]=it,e&&lt(t+" 0 obj"),t},$t=y.__private__.newAdditionalObject=function(){var t={objId:Kt(),content:""};return at.push(t),t},Qt=Kt(),te=Kt(),ee=y.__private__.decodeColorString=function(t){var e=t.split(" ");if(2!==e.length||"g"!==e[1]&&"G"!==e[1])5!==e.length||"k"!==e[4]&&"K"!==e[4]||(e=[(1-e[0])*(1-e[3]),(1-e[1])*(1-e[3]),(1-e[2])*(1-e[3]),"r"]);else{var n=parseFloat(e[0]);e=[n,n,n,"r"]}for(var r="#",i=0;i<3;i++)r+=("0"+Math.floor(255*parseFloat(e[i])).toString(16)).slice(-2);return r},ne=y.__private__.encodeColorString=function(e){var n;"string"==typeof e&&(e={ch1:e});var r=e.ch1,i=e.ch2,a=e.ch3,o=e.ch4,s="draw"===e.pdfColorType?["G","RG","K"]:["g","rg","k"];if("string"==typeof r&&"#"!==r.charAt(0)){var u=new h(r);if(u.ok)r=u.toHex();else if(!/^\d*\.?\d*$/.test(r))throw new Error('Invalid color "'+r+'" passed to jsPDF.encodeColorString.')}if("string"==typeof r&&/^#[0-9A-Fa-f]{3}$/.test(r)&&(r="#"+r[1]+r[1]+r[2]+r[2]+r[3]+r[3]),"string"==typeof r&&/^#[0-9A-Fa-f]{6}$/.test(r)){var c=parseInt(r.substr(1),16);r=c>>16&255,i=c>>8&255,a=255&c}if(void 0===i||void 0===o&&r===i&&i===a)n="string"==typeof r?r+" "+s[0]:2===e.precision?T(r/255)+" "+s[0]:z(r/255)+" "+s[0];else if(void 0===o||"object"===t(o)){if(o&&!isNaN(o.a)&&0===o.a)return["1.","1.","1.",s[1]].join(" ");n="string"==typeof r?[r,i,a,s[1]].join(" "):2===e.precision?[T(r/255),T(i/255),T(a/255),s[1]].join(" "):[z(r/255),z(i/255),z(a/255),s[1]].join(" ")}else n="string"==typeof r?[r,i,a,o,s[2]].join(" "):2===e.precision?[T(r),T(i),T(a),T(o),s[2]].join(" "):[z(r),z(i),z(a),z(o),s[2]].join(" ");return n},re=y.__private__.getFilters=function(){return c},ie=y.__private__.putStream=function(t){var e=(t=t||{}).data||"",n=t.filters||re(),r=t.alreadyAppliedFilters||[],i=t.addLength1||!1,a=e.length,o=t.objectId,s=function(t){return t};if(null!==m&&void 0===o)throw new Error("ObjectId must be passed to putStream for file encryption");null!==m&&(s=je.encryptor(o,0));var u={};!0===n&&(n=["FlateEncode"]);var c=t.additionalKeyValues||[],l=(u=void 0!==E.API.processDataByFilters?E.API.processDataByFilters(e,n):{data:e,reverseChain:[]}).reverseChain+(Array.isArray(r)?r.join(" "):r.toString());if(0!==u.data.length&&(c.push({key:"Length",value:u.data.length}),!0===i&&c.push({key:"Length1",value:a})),0!=l.length)if(l.split("/").length-1==1)c.push({key:"Filter",value:l});else{c.push({key:"Filter",value:"["+l+"]"});for(var h=0;h<c.length;h+=1)if("DecodeParms"===c[h].key){for(var f=[],d=0;d<u.reverseChain.split("/").length-1;d+=1)f.push("null");f.push(c[h].value),c[h].value="["+f.join(" ")+"]"}}lt("<<");for(var p=0;p<c.length;p++)lt("/"+c[p].key+" "+c[p].value);lt(">>"),0!==u.data.length&&(lt("stream"),lt(s(u.data)),lt("endstream"))},ae=y.__private__.putPage=function(t){var e=t.number,n=t.data,r=t.objId,i=t.contentsObjId;Zt(r,!0),lt("<</Type /Page"),lt("/Parent "+t.rootDictionaryObjId+" 0 R"),lt("/Resources "+t.resourceDictionaryObjId+" 0 R"),lt("/MediaBox ["+parseFloat(B(t.mediaBox.bottomLeftX))+" "+parseFloat(B(t.mediaBox.bottomLeftY))+" "+B(t.mediaBox.topRightX)+" "+B(t.mediaBox.topRightY)+"]"),null!==t.cropBox&&lt("/CropBox ["+B(t.cropBox.bottomLeftX)+" "+B(t.cropBox.bottomLeftY)+" "+B(t.cropBox.topRightX)+" "+B(t.cropBox.topRightY)+"]"),null!==t.bleedBox&&lt("/BleedBox ["+B(t.bleedBox.bottomLeftX)+" "+B(t.bleedBox.bottomLeftY)+" "+B(t.bleedBox.topRightX)+" "+B(t.bleedBox.topRightY)+"]"),null!==t.trimBox&&lt("/TrimBox ["+B(t.trimBox.bottomLeftX)+" "+B(t.trimBox.bottomLeftY)+" "+B(t.trimBox.topRightX)+" "+B(t.trimBox.topRightY)+"]"),null!==t.artBox&&lt("/ArtBox ["+B(t.artBox.bottomLeftX)+" "+B(t.artBox.bottomLeftY)+" "+B(t.artBox.topRightX)+" "+B(t.artBox.topRightY)+"]"),"number"==typeof t.userUnit&&1!==t.userUnit&&lt("/UserUnit "+t.userUnit),Dt.publish("putPage",{objId:r,pageContext:Rt[e],pageNumber:e,page:n}),lt("/Contents "+i+" 0 R"),lt(">>"),lt("endobj");var a=n.join("\n");return _===S&&(a+="\nQ"),Zt(i,!0),ie({data:a,filters:re(),objectId:i}),lt("endobj"),r},oe=y.__private__.putPages=function(){var t,e,n=[];for(t=1;t<=Et;t++)Rt[t].objId=Kt(),Rt[t].contentsObjId=Kt();for(t=1;t<=Et;t++)n.push(ae({number:t,data:ot[t],objId:Rt[t].objId,contentsObjId:Rt[t].contentsObjId,mediaBox:Rt[t].mediaBox,cropBox:Rt[t].cropBox,bleedBox:Rt[t].bleedBox,trimBox:Rt[t].trimBox,artBox:Rt[t].artBox,userUnit:Rt[t].userUnit,rootDictionaryObjId:Qt,resourceDictionaryObjId:te}));Zt(Qt,!0),lt("<</Type /Pages");var r="/Kids [";for(e=0;e<Et;e++)r+=n[e]+" 0 R ";lt(r+"]"),lt("/Count "+Et),lt(">>"),lt("endobj"),Dt.publish("postPutPages")},se=function(t){Dt.publish("putFont",{font:t,out:lt,newObject:Xt,putStream:ie}),!0!==t.isAlreadyPutted&&(t.objectNumber=Xt(),lt("<<"),lt("/Type /Font"),lt("/BaseFont /"+j(t.postScriptName)),lt("/Subtype /Type1"),"string"==typeof t.encoding&&lt("/Encoding /"+t.encoding),lt("/FirstChar 32"),lt("/LastChar 255"),lt(">>"),lt("endobj"))},ue=function(t){t.objectNumber=Xt();var e=[];e.push({key:"Type",value:"/XObject"}),e.push({key:"Subtype",value:"/Form"}),e.push({key:"BBox",value:"["+[B(t.x),B(t.y),B(t.x+t.width),B(t.y+t.height)].join(" ")+"]"}),e.push({key:"Matrix",value:"["+t.matrix.toString()+"]"});var n=t.pages[1].join("\n");ie({data:n,additionalKeyValues:e,objectId:t.objectNumber}),lt("endobj")},ce=function(t,e){e||(e=21);var n=Xt(),r=function(t,e){var n,r=[],i=1/(e-1);for(n=0;n<1;n+=i)r.push(n);if(r.push(1),0!=t[0].offset){var a={offset:0,color:t[0].color};t.unshift(a)}if(1!=t[t.length-1].offset){var o={offset:1,color:t[t.length-1].color};t.push(o)}for(var s="",u=0,c=0;c<r.length;c++){for(n=r[c];n>t[u+1].offset;)u++;var l=t[u].offset,h=(n-l)/(t[u+1].offset-l),f=t[u].color,d=t[u+1].color;s+=tt(Math.round((1-h)*f[0]+h*d[0]).toString(16))+tt(Math.round((1-h)*f[1]+h*d[1]).toString(16))+tt(Math.round((1-h)*f[2]+h*d[2]).toString(16))}return s.trim()}(t.colors,e),i=[];i.push({key:"FunctionType",value:"0"}),i.push({key:"Domain",value:"[0.0 1.0]"}),i.push({key:"Size",value:"["+e+"]"}),i.push({key:"BitsPerSample",value:"8"}),i.push({key:"Range",value:"[0.0 1.0 0.0 1.0 0.0 1.0]"}),i.push({key:"Decode",value:"[0.0 1.0 0.0 1.0 0.0 1.0]"}),ie({data:r,additionalKeyValues:i,alreadyAppliedFilters:["/ASCIIHexDecode"],objectId:n}),lt("endobj"),t.objectNumber=Xt(),lt("<< /ShadingType "+t.type),lt("/ColorSpace /DeviceRGB");var a="/Coords ["+B(parseFloat(t.coords[0]))+" "+B(parseFloat(t.coords[1]))+" ";2===t.type?a+=B(parseFloat(t.coords[2]))+" "+B(parseFloat(t.coords[3])):a+=B(parseFloat(t.coords[2]))+" "+B(parseFloat(t.coords[3]))+" "+B(parseFloat(t.coords[4]))+" "+B(parseFloat(t.coords[5])),lt(a+="]"),t.matrix&&lt("/Matrix ["+t.matrix.toString()+"]"),lt("/Function "+n+" 0 R"),lt("/Extend [true true]"),lt(">>"),lt("endobj")},le=function(t,e){var n=Kt(),r=Xt();e.push({resourcesOid:n,objectOid:r}),t.objectNumber=r;var i=[];i.push({key:"Type",value:"/Pattern"}),i.push({key:"PatternType",value:"1"}),i.push({key:"PaintType",value:"1"}),i.push({key:"TilingType",value:"1"}),i.push({key:"BBox",value:"["+t.boundingBox.map(B).join(" ")+"]"}),i.push({key:"XStep",value:B(t.xStep)}),i.push({key:"YStep",value:B(t.yStep)}),i.push({key:"Resources",value:n+" 0 R"}),t.matrix&&i.push({key:"Matrix",value:"["+t.matrix.toString()+"]"}),ie({data:t.stream,additionalKeyValues:i,objectId:t.objectNumber}),lt("endobj")},he=function(t){for(var e in t.objectNumber=Xt(),lt("<<"),t)switch(e){case"opacity":lt("/ca "+T(t[e]));break;case"stroke-opacity":lt("/CA "+T(t[e]))}lt(">>"),lt("endobj")},fe=function(t){Zt(t.resourcesOid,!0),lt("<<"),lt("/ProcSet [/PDF /Text /ImageB /ImageC /ImageI]"),function(){for(var t in lt("/Font <<"),Ft)Ft.hasOwnProperty(t)&&(!1===v||!0===v&&b.hasOwnProperty(t))&&lt("/"+t+" "+Ft[t].objectNumber+" 0 R");lt(">>")}(),function(){if(Object.keys(Ct).length>0){for(var t in lt("/Shading <<"),Ct)Ct.hasOwnProperty(t)&&Ct[t]instanceof M&&Ct[t].objectNumber>=0&&lt("/"+t+" "+Ct[t].objectNumber+" 0 R");Dt.publish("putShadingPatternDict"),lt(">>")}}(),function(t){if(Object.keys(Ct).length>0){for(var e in lt("/Pattern <<"),Ct)Ct.hasOwnProperty(e)&&Ct[e]instanceof y.TilingPattern&&Ct[e].objectNumber>=0&&Ct[e].objectNumber<t&&lt("/"+e+" "+Ct[e].objectNumber+" 0 R");Dt.publish("putTilingPatternDict"),lt(">>")}}(t.objectOid),function(){if(Object.keys(Bt).length>0){var t;for(t in lt("/ExtGState <<"),Bt)Bt.hasOwnProperty(t)&&Bt[t].objectNumber>=0&&lt("/"+t+" "+Bt[t].objectNumber+" 0 R");Dt.publish("putGStateDict"),lt(">>")}}(),function(){for(var t in lt("/XObject <<"),zt)zt.hasOwnProperty(t)&&zt[t].objectNumber>=0&&lt("/"+t+" "+zt[t].objectNumber+" 0 R");Dt.publish("putXobjectDict"),lt(">>")}(),lt(">>"),lt("endobj")},de=function(t){It[t.fontName]=It[t.fontName]||{},It[t.fontName][t.fontStyle]=t.id},pe=function(t,e,n,r,i){var a={id:"F"+(Object.keys(Ft).length+1).toString(10),postScriptName:t,fontName:e,fontStyle:n,encoding:r,isStandardFont:i||!1,metadata:{}};return Dt.publish("addFont",{font:a,instance:this}),Ft[a.id]=a,de(a),a.id},ge=y.__private__.pdfEscape=y.pdfEscape=function(t,e){return function(t,e){var n,r,i,a,o,s,u,c,l;if(i=(e=e||{}).sourceEncoding||"Unicode",o=e.outputEncoding,(e.autoencode||o)&&Ft[At].metadata&&Ft[At].metadata[i]&&Ft[At].metadata[i].encoding&&(a=Ft[At].metadata[i].encoding,!o&&Ft[At].encoding&&(o=Ft[At].encoding),!o&&a.codePages&&(o=a.codePages[0]),"string"==typeof o&&(o=a[o]),o)){for(u=!1,s=[],n=0,r=t.length;n<r;n++)(c=o[t.charCodeAt(n)])?s.push(String.fromCharCode(c)):s.push(t[n]),s[n].charCodeAt(0)>>8&&(u=!0);t=s.join("")}for(n=t.length;void 0===u&&0!==n;)t.charCodeAt(n-1)>>8&&(u=!0),n--;if(!u)return t;for(s=e.noBOM?[]:[254,255],n=0,r=t.length;n<r;n++){if((l=(c=t.charCodeAt(n))>>8)>>8)throw new Error("Character at position "+n+" of string '"+t+"' exceeds 16bits. Cannot be encoded into UCS-2 BE");s.push(l),s.push(c-(l<<8))}return String.fromCharCode.apply(void 0,s)}(t,e).replace(/\\/g,"\\\\").replace(/\(/g,"\\(").replace(/\)/g,"\\)")},me=y.__private__.beginPage=function(t){ot[++Et]=[],Rt[Et]={objId:0,contentsObjId:0,userUnit:Number(f),artBox:null,bleedBox:null,cropBox:null,trimBox:null,mediaBox:{bottomLeftX:0,bottomLeftY:0,topRightX:Number(t[0]),topRightY:Number(t[1])}},ye(Et),ct(ot[$])},ve=function(t,e){var n,i,a;switch(r=e||r,"string"==typeof t&&(n=x(t.toLowerCase()),Array.isArray(n)&&(i=n[0],a=n[1])),Array.isArray(t)&&(i=t[0]*St,a=t[1]*St),isNaN(i)&&(i=s[0],a=s[1]),(i>14400||a>14400)&&(o.warn("A page in a PDF can not be wider or taller than 14400 userUnit. jsPDF limits the width/height to 14400"),i=Math.min(14400,i),a=Math.min(14400,a)),s=[i,a],r.substr(0,1)){case"l":a>i&&(s=[a,i]);break;case"p":i>a&&(s=[a,i])}me(s),Ze(Xe),lt(on),0!==fn&&lt(fn+" J"),0!==dn&&lt(dn+" j"),Dt.publish("addPage",{pageNumber:Et})},be=function(t){t>0&&t<=Et&&(ot.splice(t,1),Rt.splice(t,1),Et--,$>Et&&($=Et),this.setPage($))},ye=function(t){t>0&&t<=Et&&($=t)},we=y.__private__.getNumberOfPages=y.getNumberOfPages=function(){return ot.length-1},Ne=function(t,e,n){var r,i=void 0;return n=n||{},t=void 0!==t?t:Ft[At].fontName,e=void 0!==e?e:Ft[At].fontStyle,r=t.toLowerCase(),void 0!==It[r]&&void 0!==It[r][e]?i=It[r][e]:void 0!==It[t]&&void 0!==It[t][e]?i=It[t][e]:!1===n.disableWarning&&o.warn("Unable to look up font label for font '"+t+"', '"+e+"'. Refer to getFontList() for available fonts."),i||n.noFallback||null==(i=It.times[e])&&(i=It.times.normal),i},Le=y.__private__.putInfo=function(){var t=Xt(),e=function(t){return t};for(var n in null!==m&&(e=je.encryptor(t,0)),lt("<<"),lt("/Producer ("+ge(e("jsPDF "+E.version))+")"),xt)xt.hasOwnProperty(n)&&xt[n]&&lt("/"+n.substr(0,1).toUpperCase()+n.substr(1)+" ("+ge(e(xt[n]))+")");lt("/CreationDate ("+ge(e(W))+")"),lt(">>"),lt("endobj")},xe=y.__private__.putCatalog=function(t){var e=(t=t||{}).rootDictionaryObjId||Qt;switch(Xt(),lt("<<"),lt("/Type /Catalog"),lt("/Pages "+e+" 0 R"),gt||(gt="fullwidth"),gt){case"fullwidth":lt("/OpenAction [3 0 R /FitH null]");break;case"fullheight":lt("/OpenAction [3 0 R /FitV null]");break;case"fullpage":lt("/OpenAction [3 0 R /Fit]");break;case"original":lt("/OpenAction [3 0 R /XYZ null null 1]");break;default:var n=""+gt;"%"===n.substr(n.length-1)&&(gt=parseInt(gt)/100),"number"==typeof gt&&lt("/OpenAction [3 0 R /XYZ null null "+T(gt)+"]")}switch(wt||(wt="continuous"),wt){case"continuous":lt("/PageLayout /OneColumn");break;case"single":lt("/PageLayout /SinglePage");break;case"two":case"twoleft":lt("/PageLayout /TwoColumnLeft");break;case"tworight":lt("/PageLayout /TwoColumnRight")}bt&&lt("/PageMode /"+bt),Dt.publish("putCatalog"),lt(">>"),lt("endobj")},Ae=y.__private__.putTrailer=function(){lt("trailer"),lt("<<"),lt("/Size "+(et+1)),lt("/Root "+et+" 0 R"),lt("/Info "+(et-1)+" 0 R"),null!==m&&lt("/Encrypt "+je.oid+" 0 R"),lt("/ID [ <"+V+"> <"+V+"> ]"),lt(">>")},Se=y.__private__.putHeader=function(){lt("%PDF-"+w),lt("%ºß¬à")},_e=y.__private__.putXRef=function(){var t="0000000000";lt("xref"),lt("0 "+(et+1)),lt("0000000000 65535 f ");for(var e=1;e<=et;e++)"function"==typeof nt[e]?lt((t+nt[e]()).slice(-10)+" 00000 n "):void 0!==nt[e]?lt((t+nt[e]).slice(-10)+" 00000 n "):lt("0000000000 00000 n ")},Pe=y.__private__.buildDocument=function(){var t;et=0,it=0,rt=[],nt=[],at=[],Qt=Kt(),te=Kt(),ct(rt),Dt.publish("buildDocument"),Se(),oe(),function(){Dt.publish("putAdditionalObjects");for(var t=0;t<at.length;t++){var e=at[t];Zt(e.objId,!0),lt(e.content),lt("endobj")}Dt.publish("postPutAdditionalObjects")}(),t=[],function(){for(var t in Ft)Ft.hasOwnProperty(t)&&(!1===v||!0===v&&b.hasOwnProperty(t))&&se(Ft[t])}(),function(){var t;for(t in Bt)Bt.hasOwnProperty(t)&&he(Bt[t])}(),function(){for(var t in zt)zt.hasOwnProperty(t)&&ue(zt[t])}(),function(t){var e;for(e in Ct)Ct.hasOwnProperty(e)&&(Ct[e]instanceof M?ce(Ct[e]):Ct[e]instanceof q&&le(Ct[e],t))}(t),Dt.publish("putResources"),t.forEach(fe),fe({resourcesOid:te,objectOid:Number.MAX_SAFE_INTEGER}),Dt.publish("postPutResources"),null!==m&&(je.oid=Xt(),lt("<<"),lt("/Filter /Standard"),lt("/V "+je.v),lt("/R "+je.r),lt("/U <"+je.toHexString(je.U)+">"),lt("/O <"+je.toHexString(je.O)+">"),lt("/P "+je.P),lt(">>"),lt("endobj")),Le(),xe();var e=it;return _e(),Ae(),lt("startxref"),lt(""+e),lt("%%EOF"),ct(ot[$]),rt.join("\n")},ke=y.__private__.getBlob=function(t){return new Blob([ft(t)],{type:"application/pdf"})},Fe=y.output=y.__private__.output=(Jt=function(t,e){switch("string"==typeof(e=e||{})?e={filename:e}:e.filename=e.filename||"generated.pdf",t){case void 0:return Pe();case"save":y.save(e.filename);break;case"arraybuffer":return ft(Pe());case"blob":return ke(Pe());case"bloburi":case"bloburl":if(void 0!==i.URL&&"function"==typeof i.URL.createObjectURL)return i.URL&&i.URL.createObjectURL(ke(Pe()))||void 0;o.warn("bloburl is not supported by your system, because URL.createObjectURL is not supported by your browser.");break;case"datauristring":case"dataurlstring":var n="",r=Pe();try{n=d(r)}catch(m){n=d(unescape(encodeURIComponent(r)))}return"data:application/pdf;filename="+e.filename+";base64,"+n;case"pdfobjectnewwindow":if("[object Window]"===Object.prototype.toString.call(i)){var a="https://cdnjs.cloudflare.com/ajax/libs/pdfobject/2.1.1/pdfobject.min.js",s=' integrity="sha512-4ze/a9/4jqu+tX9dfOqJYSvyYd5M6qum/3HpCLr+/Jqf0whc37VUbkpNGHR7/8pSnCFw47T1fmIpwBV7UySh3g==" crossorigin="anonymous"';e.pdfObjectUrl&&(a=e.pdfObjectUrl,s="");var u='<html><style>html, body { padding: 0; margin: 0; } iframe { width: 100%; height: 100%; border: 0;}  </style><body><script src="'+a+'"'+s+'><\/script><script >PDFObject.embed("'+this.output("dataurlstring")+'", '+JSON.stringify(e)+");<\/script></body></html>",c=i.open();return null!==c&&c.document.write(u),c}throw new Error("The option pdfobjectnewwindow just works in a browser-environment.");case"pdfjsnewwindow":if("[object Window]"===Object.prototype.toString.call(i)){var l='<html><style>html, body { padding: 0; margin: 0; } iframe { width: 100%; height: 100%; border: 0;}  </style><body><iframe id="pdfViewer" src="'+(e.pdfJsUrl||"examples/PDF.js/web/viewer.html")+"?file=&downloadName="+e.filename+'" width="500px" height="400px" /></body></html>',h=i.open();if(null!==h){h.document.write(l);var f=this;h.document.documentElement.querySelector("#pdfViewer").onload=function(){h.document.title=e.filename,h.document.documentElement.querySelector("#pdfViewer").contentWindow.PDFViewerApplication.open(f.output("bloburl"))}}return h}throw new Error("The option pdfjsnewwindow just works in a browser-environment.");case"dataurlnewwindow":if("[object Window]"!==Object.prototype.toString.call(i))throw new Error("The option dataurlnewwindow just works in a browser-environment.");var p='<html><style>html, body { padding: 0; margin: 0; } iframe { width: 100%; height: 100%; border: 0;}  </style><body><iframe src="'+this.output("datauristring",e)+'"></iframe></body></html>',g=i.open();if(null!==g&&(g.document.write(p),g.document.title=e.filename),g||"undefined"==typeof safari)return g;break;case"datauri":case"dataurl":return i.document.location.href=this.output("datauristring",e);default:return null}},Jt.foo=function(){try{return Jt.apply(this,arguments)}catch(n){var t=n.stack||"";~t.indexOf(" at ")&&(t=t.split(" at ")[1]);var e="Error in function "+t.split("\n")[0].split("<")[0]+": "+n.message;if(!i.console)throw new Error(e);i.console.error(e,n),i.alert&&alert(e)}},Jt.foo.bar=Jt,Jt.foo),Ie=function(t){return!0===Array.isArray(Tt)&&Tt.indexOf(t)>-1};switch(a){case"pt":St=1;break;case"mm":St=72/25.4;break;case"cm":St=72/2.54;break;case"in":St=72;break;case"px":St=1==Ie("px_scaling")?.75:96/72;break;case"pc":case"em":St=12;break;case"ex":St=6;break;default:if("number"!=typeof a)throw new Error("Invalid unit: "+a);St=a}var je=null;K(),Y();var Ce=y.__private__.getPageInfo=y.getPageInfo=function(t){if(isNaN(t)||t%1!=0)throw new Error("Invalid argument passed to jsPDF.getPageInfo");return{objId:Rt[t].objId,pageNumber:t,pageContext:Rt[t]}},Oe=y.__private__.getPageInfoByObjId=function(t){if(isNaN(t)||t%1!=0)throw new Error("Invalid argument passed to jsPDF.getPageInfoByObjId");for(var e in Rt)if(Rt[e].objId===t)break;return Ce(e)},Be=y.__private__.getCurrentPageInfo=y.getCurrentPageInfo=function(){return{objId:Rt[$].objId,pageNumber:$,pageContext:Rt[$]}};y.addPage=function(){return ve.apply(this,arguments),this},y.setPage=function(){return ye.apply(this,arguments),ct.call(this,ot[$]),this},y.insertPage=function(t){return this.addPage(),this.movePage($,t),this},y.movePage=function(t,e){var n,r;if(t>e){n=ot[t],r=Rt[t];for(var i=t;i>e;i--)ot[i]=ot[i-1],Rt[i]=Rt[i-1];ot[e]=n,Rt[e]=r,this.setPage(e)}else if(t<e){n=ot[t],r=Rt[t];for(var a=t;a<e;a++)ot[a]=ot[a+1],Rt[a]=Rt[a+1];ot[e]=n,Rt[e]=r,this.setPage(e)}return this},y.deletePage=function(){return be.apply(this,arguments),this},y.__private__.text=y.text=function(e,n,r,i,a){var o,s,u,c,l,h,f,d,p,g=(i=i||{}).scope||this;if("number"==typeof e&&"number"==typeof n&&("string"==typeof r||Array.isArray(r))){var m=r;r=n,n=e,e=m}if(arguments[3]instanceof Wt==0?(u=arguments[4],c=arguments[5],"object"===t(f=arguments[3])&&null!==f||("string"==typeof u&&(c=u,u=null),"string"==typeof f&&(c=f,f=null),"number"==typeof f&&(u=f,f=null),i={flags:f,angle:u,align:c})):(R("The transform parameter of text() with a Matrix value"),p=a),isNaN(n)||isNaN(r)||null==e)throw new Error("Invalid arguments passed to jsPDF.text");if(0===e.length)return g;var v,y="",w="number"==typeof i.lineHeightFactor?i.lineHeightFactor:Je,N=g.internal.scaleFactor;function L(t){return t=t.split("\t").join(Array(i.TabLen||9).join(" ")),ge(t,f)}function x(t){for(var e,n=t.concat(),r=[],i=n.length;i--;)"string"==typeof(e=n.shift())?r.push(e):Array.isArray(t)&&(1===e.length||void 0===e[1]&&void 0===e[2])?r.push(e[0]):r.push([e[0],e[1],e[2]]);return r}function A(t,e){var n;if("string"==typeof t)n=e(t)[0];else if(Array.isArray(t)){for(var r,i,a=t.concat(),o=[],s=a.length;s--;)"string"==typeof(r=a.shift())?o.push(e(r)[0]):Array.isArray(r)&&"string"==typeof r[0]&&(i=e(r[0],r[1],r[2]),o.push([i[0],i[1],i[2]]));n=o}return n}var P=!1,k=!0;if("string"==typeof e)P=!0;else if(Array.isArray(e)){var F=e.concat();s=[];for(var I,j=F.length;j--;)("string"!=typeof(I=F.shift())||Array.isArray(I)&&"string"!=typeof I[0])&&(k=!1);P=k}if(!1===P)throw new Error('Type of text must be string or Array. "'+e+'" is not recognized.');"string"==typeof e&&(e=e.match(/[\r?\n]/)?e.split(/\r\n|\r|\n/g):[e]);var C=pt/g.internal.scaleFactor,O=C*(w-1);switch(i.baseline){case"bottom":r-=O;break;case"top":r+=C-O;break;case"hanging":r+=C-2*O;break;case"middle":r+=C/2-O}if((h=i.maxWidth||0)>0&&("string"==typeof e?e=g.splitTextToSize(e,h):"[object Array]"===Object.prototype.toString.call(e)&&(e=e.reduce(function(t,e){return t.concat(g.splitTextToSize(e,h))},[]))),o={text:e,x:n,y:r,options:i,mutex:{pdfEscape:ge,activeFontKey:At,fonts:Ft,activeFontSize:pt}},Dt.publish("preProcessText",o),e=o.text,u=(i=o.options).angle,p instanceof Wt==0&&u&&"number"==typeof u){u*=Math.PI/180,0===i.rotationDirection&&(u=-u),_===S&&(u=-u);var M=Math.cos(u),q=Math.sin(u);p=new Wt(M,q,-q,M,0,0)}else u&&u instanceof Wt&&(p=u);_!==S||p||(p=Gt),void 0!==(l=i.charSpace||ln)&&(y+=B(U(l))+" Tc\n",this.setCharSpace(this.getCharSpace()||0)),void 0!==(d=i.horizontalScale)&&(y+=B(100*d)+" Tz\n"),i.lang;var E=-1,D=void 0!==i.renderingMode?i.renderingMode:i.stroke,T=g.internal.getCurrentPageInfo().pageContext;switch(D){case 0:case!1:case"fill":E=0;break;case 1:case!0:case"stroke":E=1;break;case 2:case"fillThenStroke":E=2;break;case 3:case"invisible":E=3;break;case 4:case"fillAndAddForClipping":E=4;break;case 5:case"strokeAndAddPathForClipping":E=5;break;case 6:case"fillThenStrokeAndAddToPathForClipping":E=6;break;case 7:case"addToPathForClipping":E=7}var z=void 0!==T.usedRenderingMode?T.usedRenderingMode:-1;-1!==E?y+=E+" Tr\n":-1!==z&&(y+="0 Tr\n"),-1!==E&&(T.usedRenderingMode=E),c=i.align||"left";var H,W=pt*w,V=g.internal.pageSize.getWidth(),G=Ft[At];l=i.charSpace||ln,h=i.maxWidth||0,f=Object.assign({autoencode:!0,noBOM:!0},i.flags);var Y=[],J=function(t){return g.getStringUnitWidth(t,{font:G,charSpace:l,fontSize:pt,doKerning:!1})*pt/N};if("[object Array]"===Object.prototype.toString.call(e)){var X;s=x(e),"left"!==c&&(H=s.map(J));var K,Z=0;if("right"===c){n-=H[0],e=[],j=s.length;for(var $=0;$<j;$++)0===$?(K=en(n),X=nn(r)):(K=U(Z-H[$]),X=-W),e.push([s[$],K,X]),Z=H[$]}else if("center"===c){n-=H[0]/2,e=[],j=s.length;for(var Q=0;Q<j;Q++)0===Q?(K=en(n),X=nn(r)):(K=U((Z-H[Q])/2),X=-W),e.push([s[Q],K,X]),Z=H[Q]}else if("left"===c){e=[],j=s.length;for(var tt=0;tt<j;tt++)e.push(s[tt])}else if("justify"===c&&"Identity-H"===G.encoding){e=[],j=s.length,h=0!==h?h:V;for(var et=0,nt=0;nt<j;nt++)if(X=0===nt?nn(r):-W,K=0===nt?en(n):et,nt<j-1){var rt=U((h-H[nt])/(s[nt].split(" ").length-1)),it=s[nt].split(" ");e.push([it[0]+" ",K,X]),et=0;for(var at=1;at<it.length;at++){var ot=(J(it[at-1]+" "+it[at])-J(it[at]))*N+rt;at==it.length-1?e.push([it[at],ot,0]):e.push([it[at]+" ",ot,0]),et-=ot}}else e.push([s[nt],K,X]);e.push(["",et,0])}else{if("justify"!==c)throw new Error('Unrecognized alignment option, use "left", "center", "right" or "justify".');for(e=[],j=s.length,h=0!==h?h:V,nt=0;nt<j;nt++)X=0===nt?nn(r):-W,K=0===nt?en(n):0,nt<j-1?Y.push(B(U((h-H[nt])/(s[nt].split(" ").length-1)))):Y.push(0),e.push([s[nt],K,X])}}!0===("boolean"==typeof i.R2L?i.R2L:vt)&&(e=A(e,function(t,e,n){return[t.split("").reverse().join(""),e,n]})),o={text:e,x:n,y:r,options:i,mutex:{pdfEscape:ge,activeFontKey:At,fonts:Ft,activeFontSize:pt}},Dt.publish("postProcessText",o),e=o.text,v=o.mutex.isHex||!1;var st=Ft[At].encoding;"WinAnsiEncoding"!==st&&"StandardEncoding"!==st||(e=A(e,function(t,e,n){return[L(t),e,n]})),s=x(e),e=[];for(var ut,ct,ht,ft=Array.isArray(s[0])?1:0,dt="",gt=function(t,e,n){var r="";return n instanceof Wt?(n="number"==typeof i.angle?Vt(n,new Wt(1,0,0,1,t,e)):Vt(new Wt(1,0,0,1,t,e),n),_===S&&(n=Vt(new Wt(1,0,0,-1,0,0),n)),r=n.join(" ")+" Tm\n"):r=B(t)+" "+B(e)+" Td\n",r},mt=0;mt<s.length;mt++){switch(dt="",ft){case 1:ht=(v?"<":"(")+s[mt][0]+(v?">":")"),ut=parseFloat(s[mt][1]),ct=parseFloat(s[mt][2]);break;case 0:ht=(v?"<":"(")+s[mt]+(v?">":")"),ut=en(n),ct=nn(r)}void 0!==Y&&void 0!==Y[mt]&&(dt=Y[mt]+" Tw\n"),0===mt?e.push(dt+gt(ut,ct,p)+ht):0===ft?e.push(dt+ht):1===ft&&e.push(dt+gt(ut,ct,p)+ht)}e=0===ft?e.join(" Tj\nT* "):e.join(" Tj\n"),e+=" Tj\n";var bt="BT\n/";return bt+=At+" "+pt+" Tf\n",bt+=B(pt*w)+" TL\n",bt+=un+"\n",bt+=y,bt+=e,lt(bt+="ET"),b[At]=!0,g};var Me=y.__private__.clip=y.clip=function(t){return lt("evenodd"===t?"W*":"W"),this};y.clipEvenOdd=function(){return Me("evenodd")},y.__private__.discardPath=y.discardPath=function(){return lt("n"),this};var qe=y.__private__.isValidStyle=function(t){var e=!1;return-1!==[void 0,null,"S","D","F","DF","FD","f","f*","B","B*","n"].indexOf(t)&&(e=!0),e};y.__private__.setDefaultPathOperation=y.setDefaultPathOperation=function(t){return qe(t)&&(g=t),this};var Ee=y.__private__.getStyle=y.getStyle=function(t){var e=g;switch(t){case"D":case"S":e="S";break;case"F":e="f";break;case"FD":case"DF":e="B";break;case"f":case"f*":case"B":case"B*":e=t}return e},Re=y.close=function(){return lt("h"),this};y.stroke=function(){return lt("S"),this},y.fill=function(t){return De("f",t),this},y.fillEvenOdd=function(t){return De("f*",t),this},y.fillStroke=function(t){return De("B",t),this},y.fillStrokeEvenOdd=function(t){return De("B*",t),this};var De=function(e,n){"object"===t(n)?Ue(n,e):lt(e)},Te=function(t){null===t||_===S&&void 0===t||(t=Ee(t),lt(t))};function ze(t,e,n,r,i){var a=new q(e||this.boundingBox,n||this.xStep,r||this.yStep,this.gState,i||this.matrix);a.stream=this.stream;var o=t+"$$"+this.cloneIndex+++"$$";return Yt(o,a),a}var Ue=function(t,e){var n=Ot[t.key],r=Ct[n];if(r instanceof M)lt("q"),lt(He(e)),r.gState&&y.setGState(r.gState),lt(t.matrix.toString()+" cm"),lt("/"+n+" sh"),lt("Q");else if(r instanceof q){var i=new Wt(1,0,0,-1,0,Ln());t.matrix&&(i=i.multiply(t.matrix||Gt),n=ze.call(r,t.key,t.boundingBox,t.xStep,t.yStep,i).id),lt("q"),lt("/Pattern cs"),lt("/"+n+" scn"),r.gState&&y.setGState(r.gState),lt(e),lt("Q")}},He=function(t){switch(t){case"f":case"F":case"n":return"W n";case"f*":return"W* n";case"B":case"S":return"W S";case"B*":return"W* S"}},We=y.moveTo=function(t,e){return lt(B(U(t))+" "+B(H(e))+" m"),this},Ve=y.lineTo=function(t,e){return lt(B(U(t))+" "+B(H(e))+" l"),this},Ge=y.curveTo=function(t,e,n,r,i,a){return lt([B(U(t)),B(H(e)),B(U(n)),B(H(r)),B(U(i)),B(H(a)),"c"].join(" ")),this};y.__private__.line=y.line=function(t,e,n,r,i){if(isNaN(t)||isNaN(e)||isNaN(n)||isNaN(r)||!qe(i))throw new Error("Invalid arguments passed to jsPDF.line");return _===A?this.lines([[n-t,r-e]],t,e,[1,1],i||"S"):this.lines([[n-t,r-e]],t,e,[1,1]).stroke()},y.__private__.lines=y.lines=function(t,e,n,r,i,a){var o,s,u,c,l,h,f,d,p,g,m,v;if("number"==typeof t&&(v=n,n=e,e=t,t=v),r=r||[1,1],a=a||!1,isNaN(e)||isNaN(n)||!Array.isArray(t)||!Array.isArray(r)||!qe(i)||"boolean"!=typeof a)throw new Error("Invalid arguments passed to jsPDF.lines");for(We(e,n),o=r[0],s=r[1],c=t.length,g=e,m=n,u=0;u<c;u++)2===(l=t[u]).length?(g=l[0]*o+g,m=l[1]*s+m,Ve(g,m)):(h=l[0]*o+g,f=l[1]*s+m,d=l[2]*o+g,p=l[3]*s+m,g=l[4]*o+g,m=l[5]*s+m,Ge(h,f,d,p,g,m));return a&&Re(),Te(i),this},y.path=function(t){for(var e=0;e<t.length;e++){var n=t[e],r=n.c;switch(n.op){case"m":We(r[0],r[1]);break;case"l":Ve(r[0],r[1]);break;case"c":Ge.apply(this,r);break;case"h":Re()}}return this},y.__private__.rect=y.rect=function(t,e,n,r,i){if(isNaN(t)||isNaN(e)||isNaN(n)||isNaN(r)||!qe(i))throw new Error("Invalid arguments passed to jsPDF.rect");return _===A&&(r=-r),lt([B(U(t)),B(H(e)),B(U(n)),B(U(r)),"re"].join(" ")),Te(i),this},y.__private__.triangle=y.triangle=function(t,e,n,r,i,a,o){if(isNaN(t)||isNaN(e)||isNaN(n)||isNaN(r)||isNaN(i)||isNaN(a)||!qe(o))throw new Error("Invalid arguments passed to jsPDF.triangle");return this.lines([[n-t,r-e],[i-n,a-r],[t-i,e-a]],t,e,[1,1],o,!0),this},y.__private__.roundedRect=y.roundedRect=function(t,e,n,r,i,a,o){if(isNaN(t)||isNaN(e)||isNaN(n)||isNaN(r)||isNaN(i)||isNaN(a)||!qe(o))throw new Error("Invalid arguments passed to jsPDF.roundedRect");var s=4/3*(Math.SQRT2-1);return i=Math.min(i,.5*n),a=Math.min(a,.5*r),this.lines([[n-2*i,0],[i*s,0,i,a-a*s,i,a],[0,r-2*a],[0,a*s,-i*s,a,-i,a],[2*i-n,0],[-i*s,0,-i,-a*s,-i,-a],[0,2*a-r],[0,-a*s,i*s,-a,i,-a]],t+i,e,[1,1],o,!0),this},y.__private__.ellipse=y.ellipse=function(t,e,n,r,i){if(isNaN(t)||isNaN(e)||isNaN(n)||isNaN(r)||!qe(i))throw new Error("Invalid arguments passed to jsPDF.ellipse");var a=4/3*(Math.SQRT2-1)*n,o=4/3*(Math.SQRT2-1)*r;return We(t+n,e),Ge(t+n,e-o,t+a,e-r,t,e-r),Ge(t-a,e-r,t-n,e-o,t-n,e),Ge(t-n,e+o,t-a,e+r,t,e+r),Ge(t+a,e+r,t+n,e+o,t+n,e),Te(i),this},y.__private__.circle=y.circle=function(t,e,n,r){if(isNaN(t)||isNaN(e)||isNaN(n)||!qe(r))throw new Error("Invalid arguments passed to jsPDF.circle");return this.ellipse(t,e,n,n,r)},y.setFont=function(t,e,n){return n&&(e=F(e,n)),At=Ne(t,e,{disableWarning:!1}),this};var Ye=y.__private__.getFont=y.getFont=function(){return Ft[Ne.apply(y,arguments)]};y.__private__.getFontList=y.getFontList=function(){var t,e,n={};for(t in It)if(It.hasOwnProperty(t))for(e in n[t]=[],It[t])It[t].hasOwnProperty(e)&&n[t].push(e);return n},y.addFont=function(t,e,n,r,i){var a=["StandardEncoding","MacRomanEncoding","Identity-H","WinAnsiEncoding"];return arguments[3]&&-1!==a.indexOf(arguments[3])?i=arguments[3]:arguments[3]&&-1==a.indexOf(arguments[3])&&(n=F(n,r)),pe.call(this,t,e,n,i=i||"Identity-H")};var Je,Xe=e.lineWidth||.200025,Ke=y.__private__.getLineWidth=y.getLineWidth=function(){return Xe},Ze=y.__private__.setLineWidth=y.setLineWidth=function(t){return Xe=t,lt(B(U(t))+" w"),this};y.__private__.setLineDash=E.API.setLineDash=E.API.setLineDashPattern=function(t,e){if(t=t||[],e=e||0,isNaN(e)||!Array.isArray(t))throw new Error("Invalid arguments passed to jsPDF.setLineDash");return t=t.map(function(t){return B(U(t))}).join(" "),e=B(U(e)),lt("["+t+"] "+e+" d"),this};var $e=y.__private__.getLineHeight=y.getLineHeight=function(){return pt*Je};y.__private__.getLineHeight=y.getLineHeight=function(){return pt*Je};var Qe=y.__private__.setLineHeightFactor=y.setLineHeightFactor=function(t){return"number"==typeof(t=t||1.15)&&(Je=t),this},tn=y.__private__.getLineHeightFactor=y.getLineHeightFactor=function(){return Je};Qe(e.lineHeight);var en=y.__private__.getHorizontalCoordinate=function(t){return U(t)},nn=y.__private__.getVerticalCoordinate=function(t){return _===S?t:Rt[$].mediaBox.topRightY-Rt[$].mediaBox.bottomLeftY-U(t)},rn=y.__private__.getHorizontalCoordinateString=y.getHorizontalCoordinateString=function(t){return B(en(t))},an=y.__private__.getVerticalCoordinateString=y.getVerticalCoordinateString=function(t){return B(nn(t))},on=e.strokeColor||"0 G";y.__private__.getStrokeColor=y.getDrawColor=function(){return ee(on)},y.__private__.setStrokeColor=y.setDrawColor=function(t,e,n,r){return on=ne({ch1:t,ch2:e,ch3:n,ch4:r,pdfColorType:"draw",precision:2}),lt(on),this};var sn=e.fillColor||"0 g";y.__private__.getFillColor=y.getFillColor=function(){return ee(sn)},y.__private__.setFillColor=y.setFillColor=function(t,e,n,r){return sn=ne({ch1:t,ch2:e,ch3:n,ch4:r,pdfColorType:"fill",precision:2}),lt(sn),this};var un=e.textColor||"0 g",cn=y.__private__.getTextColor=y.getTextColor=function(){return ee(un)};y.__private__.setTextColor=y.setTextColor=function(t,e,n,r){return un=ne({ch1:t,ch2:e,ch3:n,ch4:r,pdfColorType:"text",precision:3}),this};var ln=e.charSpace,hn=y.__private__.getCharSpace=y.getCharSpace=function(){return parseFloat(ln||0)};y.__private__.setCharSpace=y.setCharSpace=function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.setCharSpace");return ln=t,this};var fn=0;y.CapJoinStyles={0:0,butt:0,but:0,miter:0,1:1,round:1,rounded:1,circle:1,2:2,projecting:2,project:2,square:2,bevel:2},y.__private__.setLineCap=y.setLineCap=function(t){var e=y.CapJoinStyles[t];if(void 0===e)throw new Error("Line cap style of '"+t+"' is not recognized. See or extend .CapJoinStyles property for valid styles");return fn=e,lt(e+" J"),this};var dn=0;y.__private__.setLineJoin=y.setLineJoin=function(t){var e=y.CapJoinStyles[t];if(void 0===e)throw new Error("Line join style of '"+t+"' is not recognized. See or extend .CapJoinStyles property for valid styles");return dn=e,lt(e+" j"),this},y.__private__.setLineMiterLimit=y.__private__.setMiterLimit=y.setLineMiterLimit=y.setMiterLimit=function(t){if(t=t||0,isNaN(t))throw new Error("Invalid argument passed to jsPDF.setLineMiterLimit");return lt(B(U(t))+" M"),this},y.GState=O,y.setGState=function(t){(t="string"==typeof t?Bt[Mt[t]]:pn(null,t)).equals(qt)||(lt("/"+t.id+" gs"),qt=t)};var pn=function(t,e){if(!t||!Mt[t]){var n=!1;for(var r in Bt)if(Bt.hasOwnProperty(r)&&Bt[r].equals(e)){n=!0;break}if(n)e=Bt[r];else{var i="GS"+(Object.keys(Bt).length+1).toString(10);Bt[i]=e,e.id=i}return t&&(Mt[t]=e.id),Dt.publish("addGState",e),e}};y.addGState=function(t,e){return pn(t,e),this},y.saveGraphicsState=function(){return lt("q"),jt.push({key:At,size:pt,color:un}),this},y.restoreGraphicsState=function(){lt("Q");var t=jt.pop();return At=t.key,pt=t.size,un=t.color,qt=null,this},y.setCurrentTransformationMatrix=function(t){return lt(t.toString()+" cm"),this},y.comment=function(t){return lt("#"+t),this};var gn=function(t,e){var n=t||0;Object.defineProperty(this,"x",{enumerable:!0,get:function(){return n},set:function(t){isNaN(t)||(n=parseFloat(t))}});var r=e||0;Object.defineProperty(this,"y",{enumerable:!0,get:function(){return r},set:function(t){isNaN(t)||(r=parseFloat(t))}});var i="pt";return Object.defineProperty(this,"type",{enumerable:!0,get:function(){return i},set:function(t){i=t.toString()}}),this},mn=function(t,e,n,r){gn.call(this,t,e),this.type="rect";var i=n||0;Object.defineProperty(this,"w",{enumerable:!0,get:function(){return i},set:function(t){isNaN(t)||(i=parseFloat(t))}});var a=r||0;return Object.defineProperty(this,"h",{enumerable:!0,get:function(){return a},set:function(t){isNaN(t)||(a=parseFloat(t))}}),this},vn=function(){this.page=Et,this.currentPage=$,this.pages=ot.slice(0),this.pagesContext=Rt.slice(0),this.x=_t,this.y=Pt,this.matrix=kt,this.width=wn($),this.height=Ln($),this.outputDestination=ut,this.id="",this.objectNumber=-1};vn.prototype.restore=function(){Et=this.page,$=this.currentPage,Rt=this.pagesContext,ot=this.pages,_t=this.x,Pt=this.y,kt=this.matrix,Nn($,this.width),xn($,this.height),ut=this.outputDestination};var bn=function(t,e,n,r,i){Ht.push(new vn),Et=$=0,ot=[],_t=t,Pt=e,kt=i,me([n,r])};for(var yn in y.beginFormObject=function(t,e,n,r,i){return bn(t,e,n,r,i),this},y.endFormObject=function(t){return function(t){if(Ut[t])Ht.pop().restore();else{var e=new vn,n="Xo"+(Object.keys(zt).length+1).toString(10);e.id=n,Ut[t]=n,zt[n]=e,Dt.publish("addFormObject",e),Ht.pop().restore()}}(t),this},y.doFormObject=function(t,e){var n=zt[Ut[t]];return lt("q"),lt(e.toString()+" cm"),lt("/"+n.id+" Do"),lt("Q"),this},y.getFormObject=function(t){var e=zt[Ut[t]];return{x:e.x,y:e.y,width:e.width,height:e.height,matrix:e.matrix}},y.save=function(t,e){return t=t||"generated.pdf",(e=e||{}).returnPromise=e.returnPromise||!1,!1===e.returnPromise?(l(ke(Pe()),t),"function"==typeof l.unload&&i.setTimeout&&setTimeout(l.unload,911),this):new Promise(function(e,n){try{var r=l(ke(Pe()),t);"function"==typeof l.unload&&i.setTimeout&&setTimeout(l.unload,911),e(r)}catch(a){n(a.message)}})},E.API)E.API.hasOwnProperty(yn)&&("events"===yn&&E.API.events.length?function(t,e){var n,r,i;for(i=e.length-1;-1!==i;i--)n=e[i][0],r=e[i][1],t.subscribe.apply(t,[n].concat("function"==typeof r?[r]:r))}(Dt,E.API.events):y[yn]=E.API[yn]);var wn=y.getPageWidth=function(t){return(Rt[t=t||$].mediaBox.topRightX-Rt[t].mediaBox.bottomLeftX)/St},Nn=y.setPageWidth=function(t,e){Rt[t].mediaBox.topRightX=e*St+Rt[t].mediaBox.bottomLeftX},Ln=y.getPageHeight=function(t){return(Rt[t=t||$].mediaBox.topRightY-Rt[t].mediaBox.bottomLeftY)/St},xn=y.setPageHeight=function(t,e){Rt[t].mediaBox.topRightY=e*St+Rt[t].mediaBox.bottomLeftY};return y.internal={pdfEscape:ge,getStyle:Ee,getFont:Ye,getFontSize:mt,getCharSpace:hn,getTextColor:cn,getLineHeight:$e,getLineHeightFactor:tn,getLineWidth:Ke,write:ht,getHorizontalCoordinate:en,getVerticalCoordinate:nn,getCoordinateString:rn,getVerticalCoordinateString:an,collections:{},newObject:Xt,newAdditionalObject:$t,newObjectDeferred:Kt,newObjectDeferredBegin:Zt,getFilters:re,putStream:ie,events:Dt,scaleFactor:St,pageSize:{getWidth:function(){return wn($)},setWidth:function(t){Nn($,t)},getHeight:function(){return Ln($)},setHeight:function(t){xn($,t)}},encryptionOptions:m,encryption:je,getEncryptor:function(t){return null!==m?je.encryptor(t,0):function(t){return t}},output:Fe,getNumberOfPages:we,pages:ot,out:lt,f2:T,f3:z,getPageInfo:Ce,getPageInfoByObjId:Oe,getCurrentPageInfo:Be,getPDFVersion:N,Point:gn,Rectangle:mn,Matrix:Wt,hasHotfix:Ie},Object.defineProperty(y.internal.pageSize,"width",{get:function(){return wn($)},set:function(t){Nn($,t)},enumerable:!0,configurable:!0}),Object.defineProperty(y.internal.pageSize,"height",{get:function(){return Ln($)},set:function(t){xn($,t)},enumerable:!0,configurable:!0}),function(t){for(var e=0,n=dt.length;e<n;e++){var r=pe.call(this,t[e][0],t[e][1],t[e][2],dt[e][3],!0);!1===v&&(b[r]=!0);var i=t[e][0].split("-");de({id:r,fontName:i[0],fontStyle:i[1]||""})}Dt.publish("addFonts",{fonts:Ft,dictionary:It})}.call(y,dt),At="F1",ve(s,r),Dt.publish("initialized"),y}I.prototype.lsbFirstWord=function(t){return String.fromCharCode(255&t,t>>8&255,t>>16&255,t>>24&255)},I.prototype.toHexString=function(t){return t.split("").map(function(t){return("0"+(255&t.charCodeAt(0)).toString(16)).slice(-2)}).join("")},I.prototype.hexToBytes=function(t){for(var e=[],n=0;n<t.length;n+=2)e.push(String.fromCharCode(parseInt(t.substr(n,2),16)));return e.join("")},I.prototype.processOwnerPassword=function(t,e){return k(S(e).substr(0,5),t)},I.prototype.encryptor=function(t,e){var n=S(this.encryptionKey+String.fromCharCode(255&t,t>>8&255,t>>16&255,255&e,e>>8&255)).substr(0,10);return function(t){return k(n,t)}},O.prototype.equals=function(e){var n,r="id,objectNumber,equals";if(!e||t(e)!==t(this))return!1;var i=0;for(n in this)if(!(r.indexOf(n)>=0)){if(this.hasOwnProperty(n)&&!e.hasOwnProperty(n))return!1;if(this[n]!==e[n])return!1;i++}for(n in e)e.hasOwnProperty(n)&&r.indexOf(n)<0&&i--;return 0===i},E.API={events:[]},E.version="3.0.2";var R=E.API,D=1,T=function(t){return t.replace(/\\/g,"\\\\").replace(/\(/g,"\\(").replace(/\)/g,"\\)")},z=function(t){return t.replace(/\\\\/g,"\\").replace(/\\\(/g,"(").replace(/\\\)/g,")")},U=function(t){return t.toFixed(2)},H=function(t){return t.toFixed(5)};R.__acroform__={};var W=function(t,e){t.prototype=Object.create(e.prototype),t.prototype.constructor=t},V=function(t){return t*D},G=function(t){var e=new ct,n=xt.internal.getHeight(t)||0,r=xt.internal.getWidth(t)||0;return e.BBox=[0,0,Number(U(r)),Number(U(n))],e},Y=R.__acroform__.setBit=function(t,e){if(t=t||0,e=e||0,isNaN(t)||isNaN(e))throw new Error("Invalid arguments passed to jsPDF.API.__acroform__.setBit");return t|1<<e},J=R.__acroform__.clearBit=function(t,e){if(t=t||0,e=e||0,isNaN(t)||isNaN(e))throw new Error("Invalid arguments passed to jsPDF.API.__acroform__.clearBit");return t&~(1<<e)},X=R.__acroform__.getBit=function(t,e){if(isNaN(t)||isNaN(e))throw new Error("Invalid arguments passed to jsPDF.API.__acroform__.getBit");return t&1<<e?1:0},K=R.__acroform__.getBitForPdf=function(t,e){if(isNaN(t)||isNaN(e))throw new Error("Invalid arguments passed to jsPDF.API.__acroform__.getBitForPdf");return X(t,e-1)},Z=R.__acroform__.setBitForPdf=function(t,e){if(isNaN(t)||isNaN(e))throw new Error("Invalid arguments passed to jsPDF.API.__acroform__.setBitForPdf");return Y(t,e-1)},$=R.__acroform__.clearBitForPdf=function(t,e){if(isNaN(t)||isNaN(e))throw new Error("Invalid arguments passed to jsPDF.API.__acroform__.clearBitForPdf");return J(t,e-1)},Q=R.__acroform__.calculateCoordinates=function(t,e){var n=e.internal.getHorizontalCoordinate,r=e.internal.getVerticalCoordinate,i=t[0],a=t[1],o=t[2],s=t[3],u={};return u.lowerLeft_X=n(i)||0,u.lowerLeft_Y=r(a+s)||0,u.upperRight_X=n(i+o)||0,u.upperRight_Y=r(a)||0,[Number(U(u.lowerLeft_X)),Number(U(u.lowerLeft_Y)),Number(U(u.upperRight_X)),Number(U(u.upperRight_Y))]},tt=function(t){if(t.appearanceStreamContent)return t.appearanceStreamContent;if(t.V||t.DV){var e=[],n=t._V||t.DV,r=et(t,n),i=t.scope.internal.getFont(t.fontName,t.fontStyle).id;e.push("/Tx BMC"),e.push("q"),e.push("BT"),e.push(t.scope.__private__.encodeColorString(t.color)),e.push("/"+i+" "+U(r.fontSize)+" Tf"),e.push("1 0 0 1 0 0 Tm"),e.push(r.text),e.push("ET"),e.push("Q"),e.push("EMC");var a=G(t);return a.scope=t.scope,a.stream=e.join("\n"),a}},et=function(t,e){var n=0===t.fontSize?t.maxFontSize:t.fontSize,r={text:"",fontSize:""},i=(e=")"==(e="("==e.substr(0,1)?e.substr(1):e).substr(e.length-1)?e.substr(0,e.length-1):e).split(" ");i=t.multiline?i.map(function(t){return t.split("\n")}):i.map(function(t){return[t]});var a=n,o=xt.internal.getHeight(t)||0;o=o<0?-o:o;var s=xt.internal.getWidth(t)||0;s=s<0?-s:s;var u=function(e,n,r){if(e+1<i.length){var a=n+" "+i[e+1][0];return nt(a,t,r).width<=s-4}return!1};a++;t:for(;a>0;){e="",a--;var c,l,h=nt("3",t,a).height,f=t.multiline?o-a:(o-h)/2,d=f+=2,p=0,g=0,m=0;if(a<=0){e="(...) Tj\n",e+="% Width of Text: "+nt(e,t,a=12).width+", FieldWidth:"+s+"\n";break}for(var v="",b=0,y=0;y<i.length;y++)if(i.hasOwnProperty(y)){var w=!1;if(1!==i[y].length&&m!==i[y].length-1){if((h+2)*(b+2)+2>o)continue t;v+=i[y][m],w=!0,g=y,y--}else{v=" "==(v+=i[y][m]+" ").substr(v.length-1)?v.substr(0,v.length-1):v;var N=parseInt(y),L=u(N,v,a),x=y>=i.length-1;if(L&&!x){v+=" ",m=0;continue}if(L||x){if(x)g=N;else if(t.multiline&&(h+2)*(b+2)+2>o)continue t}else{if(!t.multiline)continue t;if((h+2)*(b+2)+2>o)continue t;g=N}}for(var A="",S=p;S<=g;S++){var _=i[S];if(t.multiline){if(S===g){A+=_[m]+" ",m=(m+1)%_.length;continue}if(S===p){A+=_[_.length-1]+" ";continue}}A+=_[0]+" "}switch(A=" "==A.substr(A.length-1)?A.substr(0,A.length-1):A,l=nt(A,t,a).width,t.textAlign){case"right":c=s-l-2;break;case"center":c=(s-l)/2;break;default:c=2}e+=U(c)+" "+U(d)+" Td\n",e+="("+T(A)+") Tj\n",e+=-U(c)+" 0 Td\n",d=-(a+2),l=0,p=w?g:g+1,b++,v=""}break}return r.text=e,r.fontSize=a,r},nt=function(t,e,n){var r=e.scope.internal.getFont(e.fontName,e.fontStyle),i=e.scope.getStringUnitWidth(t,{font:r,fontSize:parseFloat(n),charSpace:0})*parseFloat(n);return{height:e.scope.getStringUnitWidth("3",{font:r,fontSize:parseFloat(n),charSpace:0})*parseFloat(n)*1.5,width:i}},rt={fields:[],xForms:[],acroFormDictionaryRoot:null,printedOut:!1,internal:null,isInitialized:!1},it=function(t,e){var n={type:"reference",object:t};void 0===e.internal.getPageInfo(t.page).pageContext.annotations.find(function(t){return t.type===n.type&&t.object===n.object})&&e.internal.getPageInfo(t.page).pageContext.annotations.push(n)},at=function(e,n){if(n.scope=e,void 0!==e.internal&&(void 0===e.internal.acroformPlugin||!1===e.internal.acroformPlugin.isInitialized)){if(ht.FieldNum=0,e.internal.acroformPlugin=JSON.parse(JSON.stringify(rt)),e.internal.acroformPlugin.acroFormDictionaryRoot)throw new Error("Exception while creating AcroformDictionary");D=e.internal.scaleFactor,e.internal.acroformPlugin.acroFormDictionaryRoot=new lt,e.internal.acroformPlugin.acroFormDictionaryRoot.scope=e,e.internal.acroformPlugin.acroFormDictionaryRoot._eventID=e.internal.events.subscribe("postPutResources",function(){!function(t){t.internal.events.unsubscribe(t.internal.acroformPlugin.acroFormDictionaryRoot._eventID),delete t.internal.acroformPlugin.acroFormDictionaryRoot._eventID,t.internal.acroformPlugin.printedOut=!0}(e)}),e.internal.events.subscribe("buildDocument",function(){!function(t){t.internal.acroformPlugin.acroFormDictionaryRoot.objId=void 0;var e=t.internal.acroformPlugin.acroFormDictionaryRoot.Fields;for(var n in e)if(e.hasOwnProperty(n)){var r=e[n];r.objId=void 0,r.hasAnnotation&&it(r,t)}}(e)}),e.internal.events.subscribe("putCatalog",function(){!function(t){if(void 0===t.internal.acroformPlugin.acroFormDictionaryRoot)throw new Error("putCatalogCallback: Root missing.");t.internal.write("/AcroForm "+t.internal.acroformPlugin.acroFormDictionaryRoot.objId+" 0 R")}(e)}),e.internal.events.subscribe("postPutPages",function(n){!function(e,n){var r=!e;for(var i in e||(n.internal.newObjectDeferredBegin(n.internal.acroformPlugin.acroFormDictionaryRoot.objId,!0),n.internal.acroformPlugin.acroFormDictionaryRoot.putStream()),e=e||n.internal.acroformPlugin.acroFormDictionaryRoot.Kids)if(e.hasOwnProperty(i)){var a=e[i],o=[],s=a.Rect;if(a.Rect&&(a.Rect=Q(a.Rect,n)),n.internal.newObjectDeferredBegin(a.objId,!0),a.DA=xt.createDefaultAppearanceStream(a),"object"===t(a)&&"function"==typeof a.getKeyValueListForStream&&(o=a.getKeyValueListForStream()),a.Rect=s,a.hasAppearanceStream&&!a.appearanceStreamContent){var u=tt(a);o.push({key:"AP",value:"<</N "+u+">>"}),n.internal.acroformPlugin.xForms.push(u)}if(a.appearanceStreamContent){var c="";for(var l in a.appearanceStreamContent)if(a.appearanceStreamContent.hasOwnProperty(l)){var h=a.appearanceStreamContent[l];if(c+="/"+l+" ",c+="<<",Object.keys(h).length>=1||Array.isArray(h)){for(var i in h)if(h.hasOwnProperty(i)){var f=h[i];"function"==typeof f&&(f=f.call(n,a)),c+="/"+i+" "+f+" ",n.internal.acroformPlugin.xForms.indexOf(f)>=0||n.internal.acroformPlugin.xForms.push(f)}}else"function"==typeof(f=h)&&(f=f.call(n,a)),c+="/"+i+" "+f,n.internal.acroformPlugin.xForms.indexOf(f)>=0||n.internal.acroformPlugin.xForms.push(f);c+=">>"}o.push({key:"AP",value:"<<\n"+c+">>"})}n.internal.putStream({additionalKeyValues:o,objectId:a.objId}),n.internal.out("endobj")}r&&function(e,n){for(var r in e)if(e.hasOwnProperty(r)){var i=r,a=e[r];n.internal.newObjectDeferredBegin(a.objId,!0),"object"===t(a)&&"function"==typeof a.putStream&&a.putStream(),delete e[i]}}(n.internal.acroformPlugin.xForms,n)}(n,e)}),e.internal.acroformPlugin.isInitialized=!0}},ot=R.__acroform__.arrayToPdfArray=function(e,n,r){var i=function(t){return t};if(Array.isArray(e)){for(var a="[",o=0;o<e.length;o++)switch(0!==o&&(a+=" "),t(e[o])){case"boolean":case"number":case"object":a+=e[o].toString();break;case"string":"/"!==e[o].substr(0,1)?(void 0!==n&&r&&(i=r.internal.getEncryptor(n)),a+="("+T(i(e[o].toString()))+")"):a+=e[o].toString()}return a+"]"}throw new Error("Invalid argument passed to jsPDF.__acroform__.arrayToPdfArray")},st=function(t,e,n){var r=function(t){return t};return void 0!==e&&n&&(r=n.internal.getEncryptor(e)),(t=t||"").toString(),"("+T(r(t))+")"},ut=function(){this._objId=void 0,this._scope=void 0,Object.defineProperty(this,"objId",{get:function(){if(void 0===this._objId){if(void 0===this.scope)return;this._objId=this.scope.internal.newObjectDeferred()}return this._objId},set:function(t){this._objId=t}}),Object.defineProperty(this,"scope",{value:this._scope,writable:!0})};ut.prototype.toString=function(){return this.objId+" 0 R"},ut.prototype.putStream=function(){var t=this.getKeyValueListForStream();this.scope.internal.putStream({data:this.stream,additionalKeyValues:t,objectId:this.objId}),this.scope.internal.out("endobj")},ut.prototype.getKeyValueListForStream=function(){var t=[],e=Object.getOwnPropertyNames(this).filter(function(t){return"content"!=t&&"appearanceStreamContent"!=t&&"scope"!=t&&"objId"!=t&&"_"!=t.substring(0,1)});for(var n in e)if(!1===Object.getOwnPropertyDescriptor(this,e[n]).configurable){var r=e[n],i=this[r];i&&(Array.isArray(i)?t.push({key:r,value:ot(i,this.objId,this.scope)}):i instanceof ut?(i.scope=this.scope,t.push({key:r,value:i.objId+" 0 R"})):"function"!=typeof i&&t.push({key:r,value:i}))}return t};var ct=function(){ut.call(this),Object.defineProperty(this,"Type",{value:"/XObject",configurable:!1,writable:!0}),Object.defineProperty(this,"Subtype",{value:"/Form",configurable:!1,writable:!0}),Object.defineProperty(this,"FormType",{value:1,configurable:!1,writable:!0});var t,e=[];Object.defineProperty(this,"BBox",{configurable:!1,get:function(){return e},set:function(t){e=t}}),Object.defineProperty(this,"Resources",{value:"2 0 R",configurable:!1,writable:!0}),Object.defineProperty(this,"stream",{enumerable:!1,configurable:!0,set:function(e){t=e.trim()},get:function(){return t||null}})};W(ct,ut);var lt=function(){ut.call(this);var t,e=[];Object.defineProperty(this,"Kids",{enumerable:!1,configurable:!0,get:function(){return e.length>0?e:void 0}}),Object.defineProperty(this,"Fields",{enumerable:!1,configurable:!1,get:function(){return e}}),Object.defineProperty(this,"DA",{enumerable:!1,configurable:!1,get:function(){if(t){var e=function(t){return t};return this.scope&&(e=this.scope.internal.getEncryptor(this.objId)),"("+T(e(t))+")"}},set:function(e){t=e}})};W(lt,ut);var ht=function t(){ut.call(this);var e=4;Object.defineProperty(this,"F",{enumerable:!1,configurable:!1,get:function(){return e},set:function(t){if(isNaN(t))throw new Error('Invalid value "'+t+'" for attribute F supplied.');e=t}}),Object.defineProperty(this,"showWhenPrinted",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(e,3))},set:function(t){!0===Boolean(t)?this.F=Z(e,3):this.F=$(e,3)}});var n=0;Object.defineProperty(this,"Ff",{enumerable:!1,configurable:!1,get:function(){return n},set:function(t){if(isNaN(t))throw new Error('Invalid value "'+t+'" for attribute Ff supplied.');n=t}});var r=[];Object.defineProperty(this,"Rect",{enumerable:!1,configurable:!1,get:function(){if(0!==r.length)return r},set:function(t){r=void 0!==t?t:[]}}),Object.defineProperty(this,"x",{enumerable:!0,configurable:!0,get:function(){return!r||isNaN(r[0])?0:r[0]},set:function(t){r[0]=t}}),Object.defineProperty(this,"y",{enumerable:!0,configurable:!0,get:function(){return!r||isNaN(r[1])?0:r[1]},set:function(t){r[1]=t}}),Object.defineProperty(this,"width",{enumerable:!0,configurable:!0,get:function(){return!r||isNaN(r[2])?0:r[2]},set:function(t){r[2]=t}}),Object.defineProperty(this,"height",{enumerable:!0,configurable:!0,get:function(){return!r||isNaN(r[3])?0:r[3]},set:function(t){r[3]=t}});var i="";Object.defineProperty(this,"FT",{enumerable:!0,configurable:!1,get:function(){return i},set:function(t){switch(t){case"/Btn":case"/Tx":case"/Ch":case"/Sig":i=t;break;default:throw new Error('Invalid value "'+t+'" for attribute FT supplied.')}}});var a=null;Object.defineProperty(this,"T",{enumerable:!0,configurable:!1,get:function(){if(!a||a.length<1){if(this instanceof yt)return;a="FieldObject"+t.FieldNum++}var e=function(t){return t};return this.scope&&(e=this.scope.internal.getEncryptor(this.objId)),"("+T(e(a))+")"},set:function(t){a=t.toString()}}),Object.defineProperty(this,"fieldName",{configurable:!0,enumerable:!0,get:function(){return a},set:function(t){a=t}});var o="helvetica";Object.defineProperty(this,"fontName",{enumerable:!0,configurable:!0,get:function(){return o},set:function(t){o=t}});var s="normal";Object.defineProperty(this,"fontStyle",{enumerable:!0,configurable:!0,get:function(){return s},set:function(t){s=t}});var u=0;Object.defineProperty(this,"fontSize",{enumerable:!0,configurable:!0,get:function(){return u},set:function(t){u=t}});var c=void 0;Object.defineProperty(this,"maxFontSize",{enumerable:!0,configurable:!0,get:function(){return void 0===c?50/D:c},set:function(t){c=t}});var l="black";Object.defineProperty(this,"color",{enumerable:!0,configurable:!0,get:function(){return l},set:function(t){l=t}});var h="/F1 0 Tf 0 g";Object.defineProperty(this,"DA",{enumerable:!0,configurable:!1,get:function(){if(!(!h||this instanceof yt||this instanceof Nt))return st(h,this.objId,this.scope)},set:function(t){t=t.toString(),h=t}});var f=null;Object.defineProperty(this,"DV",{enumerable:!1,configurable:!1,get:function(){if(f)return this instanceof mt==0?st(f,this.objId,this.scope):f},set:function(t){t=t.toString(),f=this instanceof mt==0?"("===t.substr(0,1)?z(t.substr(1,t.length-2)):z(t):t}}),Object.defineProperty(this,"defaultValue",{enumerable:!0,configurable:!0,get:function(){return this instanceof mt==1?z(f.substr(1,f.length-1)):f},set:function(t){t=t.toString(),f=this instanceof mt==1?"/"+t:t}});var d=null;Object.defineProperty(this,"_V",{enumerable:!1,configurable:!1,get:function(){if(d)return d},set:function(t){this.V=t}}),Object.defineProperty(this,"V",{enumerable:!1,configurable:!1,get:function(){if(d)return this instanceof mt==0?st(d,this.objId,this.scope):d},set:function(t){t=t.toString(),d=this instanceof mt==0?"("===t.substr(0,1)?z(t.substr(1,t.length-2)):z(t):t}}),Object.defineProperty(this,"value",{enumerable:!0,configurable:!0,get:function(){return this instanceof mt==1?z(d.substr(1,d.length-1)):d},set:function(t){t=t.toString(),d=this instanceof mt==1?"/"+t:t}}),Object.defineProperty(this,"hasAnnotation",{enumerable:!0,configurable:!0,get:function(){return this.Rect}}),Object.defineProperty(this,"Type",{enumerable:!0,configurable:!1,get:function(){return this.hasAnnotation?"/Annot":null}}),Object.defineProperty(this,"Subtype",{enumerable:!0,configurable:!1,get:function(){return this.hasAnnotation?"/Widget":null}});var p,g=!1;Object.defineProperty(this,"hasAppearanceStream",{enumerable:!0,configurable:!0,get:function(){return g},set:function(t){t=Boolean(t),g=t}}),Object.defineProperty(this,"page",{enumerable:!0,configurable:!0,get:function(){if(p)return p},set:function(t){p=t}}),Object.defineProperty(this,"readOnly",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,1))},set:function(t){!0===Boolean(t)?this.Ff=Z(this.Ff,1):this.Ff=$(this.Ff,1)}}),Object.defineProperty(this,"required",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,2))},set:function(t){!0===Boolean(t)?this.Ff=Z(this.Ff,2):this.Ff=$(this.Ff,2)}}),Object.defineProperty(this,"noExport",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,3))},set:function(t){!0===Boolean(t)?this.Ff=Z(this.Ff,3):this.Ff=$(this.Ff,3)}});var m=null;Object.defineProperty(this,"Q",{enumerable:!0,configurable:!1,get:function(){if(null!==m)return m},set:function(t){if(-1===[0,1,2].indexOf(t))throw new Error('Invalid value "'+t+'" for attribute Q supplied.');m=t}}),Object.defineProperty(this,"textAlign",{get:function(){var t;switch(m){case 0:default:t="left";break;case 1:t="center";break;case 2:t="right"}return t},configurable:!0,enumerable:!0,set:function(t){switch(t){case"right":case 2:m=2;break;case"center":case 1:m=1;break;default:m=0}}})};W(ht,ut);var ft=function(){ht.call(this),this.FT="/Ch",this.V="()",this.fontName="zapfdingbats";var t=0;Object.defineProperty(this,"TI",{enumerable:!0,configurable:!1,get:function(){return t},set:function(e){t=e}}),Object.defineProperty(this,"topIndex",{enumerable:!0,configurable:!0,get:function(){return t},set:function(e){t=e}});var e=[];Object.defineProperty(this,"Opt",{enumerable:!0,configurable:!1,get:function(){return ot(e,this.objId,this.scope)},set:function(t){var n,r;r=[],"string"==typeof(n=t)&&(r=function(t,e,n){n||(n=1);for(var r,i=[];r=e.exec(t);)i.push(r[n]);return i}(n,/\((.*?)\)/g)),e=r}}),this.getOptions=function(){return e},this.setOptions=function(t){e=t,this.sort&&e.sort()},this.addOption=function(t){t=(t=t||"").toString(),e.push(t),this.sort&&e.sort()},this.removeOption=function(t,n){for(n=n||!1,t=(t=t||"").toString();-1!==e.indexOf(t)&&(e.splice(e.indexOf(t),1),!1!==n););},Object.defineProperty(this,"combo",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,18))},set:function(t){!0===Boolean(t)?this.Ff=Z(this.Ff,18):this.Ff=$(this.Ff,18)}}),Object.defineProperty(this,"edit",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,19))},set:function(t){!0===this.combo&&(!0===Boolean(t)?this.Ff=Z(this.Ff,19):this.Ff=$(this.Ff,19))}}),Object.defineProperty(this,"sort",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,20))},set:function(t){!0===Boolean(t)?(this.Ff=Z(this.Ff,20),e.sort()):this.Ff=$(this.Ff,20)}}),Object.defineProperty(this,"multiSelect",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,22))},set:function(t){!0===Boolean(t)?this.Ff=Z(this.Ff,22):this.Ff=$(this.Ff,22)}}),Object.defineProperty(this,"doNotSpellCheck",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,23))},set:function(t){!0===Boolean(t)?this.Ff=Z(this.Ff,23):this.Ff=$(this.Ff,23)}}),Object.defineProperty(this,"commitOnSelChange",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,27))},set:function(t){!0===Boolean(t)?this.Ff=Z(this.Ff,27):this.Ff=$(this.Ff,27)}}),this.hasAppearanceStream=!1};W(ft,ht);var dt=function(){ft.call(this),this.fontName="helvetica",this.combo=!1};W(dt,ft);var pt=function(){dt.call(this),this.combo=!0};W(pt,dt);var gt=function(){pt.call(this),this.edit=!0};W(gt,pt);var mt=function(){ht.call(this),this.FT="/Btn",Object.defineProperty(this,"noToggleToOff",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,15))},set:function(t){!0===Boolean(t)?this.Ff=Z(this.Ff,15):this.Ff=$(this.Ff,15)}}),Object.defineProperty(this,"radio",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,16))},set:function(t){!0===Boolean(t)?this.Ff=Z(this.Ff,16):this.Ff=$(this.Ff,16)}}),Object.defineProperty(this,"pushButton",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,17))},set:function(t){!0===Boolean(t)?this.Ff=Z(this.Ff,17):this.Ff=$(this.Ff,17)}}),Object.defineProperty(this,"radioIsUnison",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,26))},set:function(t){!0===Boolean(t)?this.Ff=Z(this.Ff,26):this.Ff=$(this.Ff,26)}});var e,n={};Object.defineProperty(this,"MK",{enumerable:!1,configurable:!1,get:function(){var t=function(t){return t};if(this.scope&&(t=this.scope.internal.getEncryptor(this.objId)),0!==Object.keys(n).length){var e,r=[];for(e in r.push("<<"),n)r.push("/"+e+" ("+T(t(n[e]))+")");return r.push(">>"),r.join("\n")}},set:function(e){"object"===t(e)&&(n=e)}}),Object.defineProperty(this,"caption",{enumerable:!0,configurable:!0,get:function(){return n.CA||""},set:function(t){"string"==typeof t&&(n.CA=t)}}),Object.defineProperty(this,"AS",{enumerable:!1,configurable:!1,get:function(){return e},set:function(t){e=t}}),Object.defineProperty(this,"appearanceState",{enumerable:!0,configurable:!0,get:function(){return e.substr(1,e.length-1)},set:function(t){e="/"+t}})};W(mt,ht);var vt=function(){mt.call(this),this.pushButton=!0};W(vt,mt);var bt=function(){mt.call(this),this.radio=!0,this.pushButton=!1;var t=[];Object.defineProperty(this,"Kids",{enumerable:!0,configurable:!1,get:function(){return t},set:function(e){t=void 0!==e?e:[]}})};W(bt,mt);var yt=function(){var e,n;ht.call(this),Object.defineProperty(this,"Parent",{enumerable:!1,configurable:!1,get:function(){return e},set:function(t){e=t}}),Object.defineProperty(this,"optionName",{enumerable:!1,configurable:!0,get:function(){return n},set:function(t){n=t}});var r,i={};Object.defineProperty(this,"MK",{enumerable:!1,configurable:!1,get:function(){var t=function(t){return t};this.scope&&(t=this.scope.internal.getEncryptor(this.objId));var e,n=[];for(e in n.push("<<"),i)n.push("/"+e+" ("+T(t(i[e]))+")");return n.push(">>"),n.join("\n")},set:function(e){"object"===t(e)&&(i=e)}}),Object.defineProperty(this,"caption",{enumerable:!0,configurable:!0,get:function(){return i.CA||""},set:function(t){"string"==typeof t&&(i.CA=t)}}),Object.defineProperty(this,"AS",{enumerable:!1,configurable:!1,get:function(){return r},set:function(t){r=t}}),Object.defineProperty(this,"appearanceState",{enumerable:!0,configurable:!0,get:function(){return r.substr(1,r.length-1)},set:function(t){r="/"+t}}),this.caption="l",this.appearanceState="Off",this._AppearanceType=xt.RadioButton.Circle,this.appearanceStreamContent=this._AppearanceType.createAppearanceStream(this.optionName)};W(yt,ht),bt.prototype.setAppearance=function(t){if(!("createAppearanceStream"in t)||!("getCA"in t))throw new Error("Couldn't assign Appearance to RadioButton. Appearance was Invalid!");for(var e in this.Kids)if(this.Kids.hasOwnProperty(e)){var n=this.Kids[e];n.appearanceStreamContent=t.createAppearanceStream(n.optionName),n.caption=t.getCA()}},bt.prototype.createOption=function(t){var e=new yt;return e.Parent=this,e.optionName=t,this.Kids.push(e),At.call(this.scope,e),e};var wt=function(){mt.call(this),this.fontName="zapfdingbats",this.caption="3",this.appearanceState="On",this.value="On",this.textAlign="center",this.appearanceStreamContent=xt.CheckBox.createAppearanceStream()};W(wt,mt);var Nt=function(){ht.call(this),this.FT="/Tx",Object.defineProperty(this,"multiline",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,13))},set:function(t){!0===Boolean(t)?this.Ff=Z(this.Ff,13):this.Ff=$(this.Ff,13)}}),Object.defineProperty(this,"fileSelect",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,21))},set:function(t){!0===Boolean(t)?this.Ff=Z(this.Ff,21):this.Ff=$(this.Ff,21)}}),Object.defineProperty(this,"doNotSpellCheck",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,23))},set:function(t){!0===Boolean(t)?this.Ff=Z(this.Ff,23):this.Ff=$(this.Ff,23)}}),Object.defineProperty(this,"doNotScroll",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,24))},set:function(t){!0===Boolean(t)?this.Ff=Z(this.Ff,24):this.Ff=$(this.Ff,24)}}),Object.defineProperty(this,"comb",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,25))},set:function(t){!0===Boolean(t)?this.Ff=Z(this.Ff,25):this.Ff=$(this.Ff,25)}}),Object.defineProperty(this,"richText",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,26))},set:function(t){!0===Boolean(t)?this.Ff=Z(this.Ff,26):this.Ff=$(this.Ff,26)}});var t=null;Object.defineProperty(this,"MaxLen",{enumerable:!0,configurable:!1,get:function(){return t},set:function(e){t=e}}),Object.defineProperty(this,"maxLength",{enumerable:!0,configurable:!0,get:function(){return t},set:function(e){Number.isInteger(e)&&(t=e)}}),Object.defineProperty(this,"hasAppearanceStream",{enumerable:!0,configurable:!0,get:function(){return this.V||this.DV}})};W(Nt,ht);var Lt=function(){Nt.call(this),Object.defineProperty(this,"password",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,14))},set:function(t){!0===Boolean(t)?this.Ff=Z(this.Ff,14):this.Ff=$(this.Ff,14)}}),this.password=!0};W(Lt,Nt);var xt={CheckBox:{createAppearanceStream:function(){return{N:{On:xt.CheckBox.YesNormal},D:{On:xt.CheckBox.YesPushDown,Off:xt.CheckBox.OffPushDown}}},YesPushDown:function(t){var e=G(t);e.scope=t.scope;var n=[],r=t.scope.internal.getFont(t.fontName,t.fontStyle).id,i=t.scope.__private__.encodeColorString(t.color),a=et(t,t.caption);return n.push("0.749023 g"),n.push("0 0 "+U(xt.internal.getWidth(t))+" "+U(xt.internal.getHeight(t))+" re"),n.push("f"),n.push("BMC"),n.push("q"),n.push("0 0 1 rg"),n.push("/"+r+" "+U(a.fontSize)+" Tf "+i),n.push("BT"),n.push(a.text),n.push("ET"),n.push("Q"),n.push("EMC"),e.stream=n.join("\n"),e},YesNormal:function(t){var e=G(t);e.scope=t.scope;var n=t.scope.internal.getFont(t.fontName,t.fontStyle).id,r=t.scope.__private__.encodeColorString(t.color),i=[],a=xt.internal.getHeight(t),o=xt.internal.getWidth(t),s=et(t,t.caption);return i.push("1 g"),i.push("0 0 "+U(o)+" "+U(a)+" re"),i.push("f"),i.push("q"),i.push("0 0 1 rg"),i.push("0 0 "+U(o-1)+" "+U(a-1)+" re"),i.push("W"),i.push("n"),i.push("0 g"),i.push("BT"),i.push("/"+n+" "+U(s.fontSize)+" Tf "+r),i.push(s.text),i.push("ET"),i.push("Q"),e.stream=i.join("\n"),e},OffPushDown:function(t){var e=G(t);e.scope=t.scope;var n=[];return n.push("0.749023 g"),n.push("0 0 "+U(xt.internal.getWidth(t))+" "+U(xt.internal.getHeight(t))+" re"),n.push("f"),e.stream=n.join("\n"),e}},RadioButton:{Circle:{createAppearanceStream:function(t){var e={D:{Off:xt.RadioButton.Circle.OffPushDown},N:{}};return e.N[t]=xt.RadioButton.Circle.YesNormal,e.D[t]=xt.RadioButton.Circle.YesPushDown,e},getCA:function(){return"l"},YesNormal:function(t){var e=G(t);e.scope=t.scope;var n=[],r=xt.internal.getWidth(t)<=xt.internal.getHeight(t)?xt.internal.getWidth(t)/4:xt.internal.getHeight(t)/4;r=Number((.9*r).toFixed(5));var i=xt.internal.Bezier_C,a=Number((r*i).toFixed(5));return n.push("q"),n.push("1 0 0 1 "+H(xt.internal.getWidth(t)/2)+" "+H(xt.internal.getHeight(t)/2)+" cm"),n.push(r+" 0 m"),n.push(r+" "+a+" "+a+" "+r+" 0 "+r+" c"),n.push("-"+a+" "+r+" -"+r+" "+a+" -"+r+" 0 c"),n.push("-"+r+" -"+a+" -"+a+" -"+r+" 0 -"+r+" c"),n.push(a+" -"+r+" "+r+" -"+a+" "+r+" 0 c"),n.push("f"),n.push("Q"),e.stream=n.join("\n"),e},YesPushDown:function(t){var e=G(t);e.scope=t.scope;var n=[],r=xt.internal.getWidth(t)<=xt.internal.getHeight(t)?xt.internal.getWidth(t)/4:xt.internal.getHeight(t)/4;r=Number((.9*r).toFixed(5));var i=Number((2*r).toFixed(5)),a=Number((i*xt.internal.Bezier_C).toFixed(5)),o=Number((r*xt.internal.Bezier_C).toFixed(5));return n.push("0.749023 g"),n.push("q"),n.push("1 0 0 1 "+H(xt.internal.getWidth(t)/2)+" "+H(xt.internal.getHeight(t)/2)+" cm"),n.push(i+" 0 m"),n.push(i+" "+a+" "+a+" "+i+" 0 "+i+" c"),n.push("-"+a+" "+i+" -"+i+" "+a+" -"+i+" 0 c"),n.push("-"+i+" -"+a+" -"+a+" -"+i+" 0 -"+i+" c"),n.push(a+" -"+i+" "+i+" -"+a+" "+i+" 0 c"),n.push("f"),n.push("Q"),n.push("0 g"),n.push("q"),n.push("1 0 0 1 "+H(xt.internal.getWidth(t)/2)+" "+H(xt.internal.getHeight(t)/2)+" cm"),n.push(r+" 0 m"),n.push(r+" "+o+" "+o+" "+r+" 0 "+r+" c"),n.push("-"+o+" "+r+" -"+r+" "+o+" -"+r+" 0 c"),n.push("-"+r+" -"+o+" -"+o+" -"+r+" 0 -"+r+" c"),n.push(o+" -"+r+" "+r+" -"+o+" "+r+" 0 c"),n.push("f"),n.push("Q"),e.stream=n.join("\n"),e},OffPushDown:function(t){var e=G(t);e.scope=t.scope;var n=[],r=xt.internal.getWidth(t)<=xt.internal.getHeight(t)?xt.internal.getWidth(t)/4:xt.internal.getHeight(t)/4;r=Number((.9*r).toFixed(5));var i=Number((2*r).toFixed(5)),a=Number((i*xt.internal.Bezier_C).toFixed(5));return n.push("0.749023 g"),n.push("q"),n.push("1 0 0 1 "+H(xt.internal.getWidth(t)/2)+" "+H(xt.internal.getHeight(t)/2)+" cm"),n.push(i+" 0 m"),n.push(i+" "+a+" "+a+" "+i+" 0 "+i+" c"),n.push("-"+a+" "+i+" -"+i+" "+a+" -"+i+" 0 c"),n.push("-"+i+" -"+a+" -"+a+" -"+i+" 0 -"+i+" c"),n.push(a+" -"+i+" "+i+" -"+a+" "+i+" 0 c"),n.push("f"),n.push("Q"),e.stream=n.join("\n"),e}},Cross:{createAppearanceStream:function(t){var e={D:{Off:xt.RadioButton.Cross.OffPushDown},N:{}};return e.N[t]=xt.RadioButton.Cross.YesNormal,e.D[t]=xt.RadioButton.Cross.YesPushDown,e},getCA:function(){return"8"},YesNormal:function(t){var e=G(t);e.scope=t.scope;var n=[],r=xt.internal.calculateCross(t);return n.push("q"),n.push("1 1 "+U(xt.internal.getWidth(t)-2)+" "+U(xt.internal.getHeight(t)-2)+" re"),n.push("W"),n.push("n"),n.push(U(r.x1.x)+" "+U(r.x1.y)+" m"),n.push(U(r.x2.x)+" "+U(r.x2.y)+" l"),n.push(U(r.x4.x)+" "+U(r.x4.y)+" m"),n.push(U(r.x3.x)+" "+U(r.x3.y)+" l"),n.push("s"),n.push("Q"),e.stream=n.join("\n"),e},YesPushDown:function(t){var e=G(t);e.scope=t.scope;var n=xt.internal.calculateCross(t),r=[];return r.push("0.749023 g"),r.push("0 0 "+U(xt.internal.getWidth(t))+" "+U(xt.internal.getHeight(t))+" re"),r.push("f"),r.push("q"),r.push("1 1 "+U(xt.internal.getWidth(t)-2)+" "+U(xt.internal.getHeight(t)-2)+" re"),r.push("W"),r.push("n"),r.push(U(n.x1.x)+" "+U(n.x1.y)+" m"),r.push(U(n.x2.x)+" "+U(n.x2.y)+" l"),r.push(U(n.x4.x)+" "+U(n.x4.y)+" m"),r.push(U(n.x3.x)+" "+U(n.x3.y)+" l"),r.push("s"),r.push("Q"),e.stream=r.join("\n"),e},OffPushDown:function(t){var e=G(t);e.scope=t.scope;var n=[];return n.push("0.749023 g"),n.push("0 0 "+U(xt.internal.getWidth(t))+" "+U(xt.internal.getHeight(t))+" re"),n.push("f"),e.stream=n.join("\n"),e}}},createDefaultAppearanceStream:function(t){var e=t.scope.internal.getFont(t.fontName,t.fontStyle).id,n=t.scope.__private__.encodeColorString(t.color);return"/"+e+" "+t.fontSize+" Tf "+n}};xt.internal={Bezier_C:.551915024494,calculateCross:function(t){var e=xt.internal.getWidth(t),n=xt.internal.getHeight(t),r=Math.min(e,n);return{x1:{x:(e-r)/2,y:(n-r)/2+r},x2:{x:(e-r)/2+r,y:(n-r)/2},x3:{x:(e-r)/2,y:(n-r)/2},x4:{x:(e-r)/2+r,y:(n-r)/2+r}}}},xt.internal.getWidth=function(e){var n=0;return"object"===t(e)&&(n=V(e.Rect[2])),n},xt.internal.getHeight=function(e){var n=0;return"object"===t(e)&&(n=V(e.Rect[3])),n};var At=R.addField=function(t){if(at(this,t),!(t instanceof ht))throw new Error("Invalid argument passed to jsPDF.addField.");var e;return(e=t).scope.internal.acroformPlugin.printedOut&&(e.scope.internal.acroformPlugin.printedOut=!1,e.scope.internal.acroformPlugin.acroFormDictionaryRoot=null),e.scope.internal.acroformPlugin.acroFormDictionaryRoot.Fields.push(e),t.page=t.scope.internal.getCurrentPageInfo().pageNumber,this};R.AcroFormChoiceField=ft,R.AcroFormListBox=dt,R.AcroFormComboBox=pt,R.AcroFormEditBox=gt,R.AcroFormButton=mt,R.AcroFormPushButton=vt,R.AcroFormRadioButton=bt,R.AcroFormCheckBox=wt,R.AcroFormTextField=Nt,R.AcroFormPasswordField=Lt,R.AcroFormAppearance=xt,R.AcroForm={ChoiceField:ft,ListBox:dt,ComboBox:pt,EditBox:gt,Button:mt,PushButton:vt,RadioButton:bt,CheckBox:wt,TextField:Nt,PasswordField:Lt,Appearance:xt},E.AcroForm={ChoiceField:ft,ListBox:dt,ComboBox:pt,EditBox:gt,Button:mt,PushButton:vt,RadioButton:bt,CheckBox:wt,TextField:Nt,PasswordField:Lt,Appearance:xt};var St=E.AcroForm;function _t(t){return t.reduce(function(t,e,n){return t[e]=n,t},{})}!function(e){var n="addImage_";e.__addimage__={};var r="UNKNOWN",i={PNG:[[137,80,78,71]],TIFF:[[77,77,0,42],[73,73,42,0]],JPEG:[[255,216,255,224,void 0,void 0,74,70,73,70,0],[255,216,255,225,void 0,void 0,69,120,105,102,0,0],[255,216,255,219],[255,216,255,238]],JPEG2000:[[0,0,0,12,106,80,32,32]],GIF87a:[[71,73,70,56,55,97]],GIF89a:[[71,73,70,56,57,97]],WEBP:[[82,73,70,70,void 0,void 0,void 0,void 0,87,69,66,80]],BMP:[[66,77],[66,65],[67,73],[67,80],[73,67],[80,84]]},a=e.__addimage__.getImageFileTypeByImageData=function(t,e){var n,a,o,s,u,c=r;if("RGBA"===(e=e||r)||void 0!==t.data&&t.data instanceof Uint8ClampedArray&&"height"in t&&"width"in t)return"RGBA";if(A(t))for(u in i)for(o=i[u],n=0;n<o.length;n+=1){for(s=!0,a=0;a<o[n].length;a+=1)if(void 0!==o[n][a]&&o[n][a]!==t[a]){s=!1;break}if(!0===s){c=u;break}}else for(u in i)for(o=i[u],n=0;n<o.length;n+=1){for(s=!0,a=0;a<o[n].length;a+=1)if(void 0!==o[n][a]&&o[n][a]!==t.charCodeAt(a)){s=!1;break}if(!0===s){c=u;break}}return c===r&&e!==r&&(c=e),c},o=function t(e){for(var n=this.internal.write,r=this.internal.putStream,i=(0,this.internal.getFilters)();-1!==i.indexOf("FlateEncode");)i.splice(i.indexOf("FlateEncode"),1);e.objectId=this.internal.newObject();var a=[];if(a.push({key:"Type",value:"/XObject"}),a.push({key:"Subtype",value:"/Image"}),a.push({key:"Width",value:e.width}),a.push({key:"Height",value:e.height}),e.colorSpace===y.INDEXED?a.push({key:"ColorSpace",value:"[/Indexed /DeviceRGB "+(e.palette.length/3-1)+" "+("sMask"in e&&void 0!==e.sMask?e.objectId+2:e.objectId+1)+" 0 R]"}):(a.push({key:"ColorSpace",value:"/"+e.colorSpace}),e.colorSpace===y.DEVICE_CMYK&&a.push({key:"Decode",value:"[1 0 1 0 1 0 1 0]"})),a.push({key:"BitsPerComponent",value:e.bitsPerComponent}),"decodeParameters"in e&&void 0!==e.decodeParameters&&a.push({key:"DecodeParms",value:"<<"+e.decodeParameters+">>"}),"transparency"in e&&Array.isArray(e.transparency)){for(var o="",s=0,u=e.transparency.length;s<u;s++)o+=e.transparency[s]+" "+e.transparency[s]+" ";a.push({key:"Mask",value:"["+o+"]"})}void 0!==e.sMask&&a.push({key:"SMask",value:e.objectId+1+" 0 R"});var c=void 0!==e.filter?["/"+e.filter]:void 0;if(r({data:e.data,additionalKeyValues:a,alreadyAppliedFilters:c,objectId:e.objectId}),n("endobj"),"sMask"in e&&void 0!==e.sMask){var l=(null!=e.predictor?"/Predictor "+e.predictor:"")+" /Colors 1 /BitsPerComponent 8 /Columns "+e.width,h={width:e.width,height:e.height,colorSpace:"DeviceGray",bitsPerComponent:e.bitsPerComponent,decodeParameters:l,data:e.sMask};"filter"in e&&(h.filter=e.filter),t.call(this,h)}if(e.colorSpace===y.INDEXED){var f=this.internal.newObject();r({data:_(new Uint8Array(e.palette)),objectId:f}),n("endobj")}},s=function(){var t=this.internal.collections[n+"images"];for(var e in t)o.call(this,t[e])},u=function(){var t,e=this.internal.collections[n+"images"],r=this.internal.write;for(var i in e)r("/I"+(t=e[i]).index,t.objectId,"0","R")},c=function(){this.internal.collections[n+"images"]||(this.internal.collections[n+"images"]={},this.internal.events.subscribe("putResources",s),this.internal.events.subscribe("putXobjectDict",u))},l=function(){var t=this.internal.collections[n+"images"];return c.call(this),t},h=function(){return Object.keys(this.internal.collections[n+"images"]).length},d=function(t){return"function"==typeof e["process"+t.toUpperCase()]},p=function(e){return"object"===t(e)&&1===e.nodeType},g=function(t,n){if("IMG"===t.nodeName&&t.hasAttribute("src")){var r=""+t.getAttribute("src");if(0===r.indexOf("data:image/"))return f(unescape(r).split("base64,").pop());var i=e.loadFile(r,!0);if(void 0!==i)return i}if("CANVAS"===t.nodeName){if(0===t.width||0===t.height)throw new Error("Given canvas must have data. Canvas width: "+t.width+", height: "+t.height);var a;switch(n){case"PNG":a="image/png";break;case"WEBP":a="image/webp";break;default:a="image/jpeg"}return f(t.toDataURL(a,1).split("base64,").pop())}},m=function(t){var e=this.internal.collections[n+"images"];if(e)for(var r in e)if(t===e[r].alias)return e[r]},v=function(t,e,n){return t||e||(t=-96,e=-96),t<0&&(t=-1*n.width*72/t/this.internal.scaleFactor),e<0&&(e=-1*n.height*72/e/this.internal.scaleFactor),0===t&&(t=e*n.width/n.height),0===e&&(e=t*n.height/n.width),[t,e]},b=function(t,e,n,r,i,a){var o=v.call(this,n,r,i),s=this.internal.getCoordinateString,u=this.internal.getVerticalCoordinateString,c=l.call(this);if(n=o[0],r=o[1],c[i.index]=i,a){a*=Math.PI/180;var h=Math.cos(a),f=Math.sin(a),d=function(t){return t.toFixed(4)},p=[d(h),d(f),d(-1*f),d(h),0,0,"cm"]}this.internal.write("q"),a?(this.internal.write([1,"0","0",1,s(t),u(e+r),"cm"].join(" ")),this.internal.write(p.join(" ")),this.internal.write([s(n),"0","0",s(r),"0","0","cm"].join(" "))):this.internal.write([s(n),"0","0",s(r),s(t),u(e+r),"cm"].join(" ")),this.isAdvancedAPI()&&this.internal.write([1,0,0,-1,0,0,"cm"].join(" ")),this.internal.write("/I"+i.index+" Do"),this.internal.write("Q")},y=e.color_spaces={DEVICE_RGB:"DeviceRGB",DEVICE_GRAY:"DeviceGray",DEVICE_CMYK:"DeviceCMYK",CAL_GREY:"CalGray",CAL_RGB:"CalRGB",LAB:"Lab",ICC_BASED:"ICCBased",INDEXED:"Indexed",PATTERN:"Pattern",SEPARATION:"Separation",DEVICE_N:"DeviceN"};e.decode={DCT_DECODE:"DCTDecode",FLATE_DECODE:"FlateDecode",LZW_DECODE:"LZWDecode",JPX_DECODE:"JPXDecode",JBIG2_DECODE:"JBIG2Decode",ASCII85_DECODE:"ASCII85Decode",ASCII_HEX_DECODE:"ASCIIHexDecode",RUN_LENGTH_DECODE:"RunLengthDecode",CCITT_FAX_DECODE:"CCITTFaxDecode"};var w=e.image_compression={NONE:"NONE",FAST:"FAST",MEDIUM:"MEDIUM",SLOW:"SLOW"},N=e.__addimage__.sHashCode=function(t){var e,n,r=0;if("string"==typeof t)for(n=t.length,e=0;e<n;e++)r=(r<<5)-r+t.charCodeAt(e),r|=0;else if(A(t))for(n=t.byteLength/2,e=0;e<n;e++)r=(r<<5)-r+t[e],r|=0;return r},L=e.__addimage__.validateStringAsBase64=function(t){(t=t||"").toString().trim();var e=!0;return 0===t.length&&(e=!1),t.length%4!=0&&(e=!1),!1===/^[A-Za-z0-9+/]+$/.test(t.substr(0,t.length-2))&&(e=!1),!1===/^[A-Za-z0-9/][A-Za-z0-9+/]|[A-Za-z0-9+/]=|==$/.test(t.substr(-2))&&(e=!1),e},x=e.__addimage__.extractImageFromDataUrl=function(t){if(null==t)return null;if(!(t=t.trim()).startsWith("data:"))return null;var e=t.indexOf(",");return e<0?null:t.substring(0,e).trim().endsWith("base64")?t.substring(e+1):null};e.__addimage__.isArrayBuffer=function(t){return t instanceof ArrayBuffer};var A=e.__addimage__.isArrayBufferView=function(t){return t instanceof Int8Array||t instanceof Uint8Array||t instanceof Uint8ClampedArray||t instanceof Int16Array||t instanceof Uint16Array||t instanceof Int32Array||t instanceof Uint32Array||t instanceof Float32Array||t instanceof Float64Array},S=e.__addimage__.binaryStringToUint8Array=function(t){for(var e=t.length,n=new Uint8Array(e),r=0;r<e;r++)n[r]=t.charCodeAt(r);return n},_=e.__addimage__.arrayBufferToBinaryString=function(t){for(var e="",n=A(t)?t:new Uint8Array(t),r=0;r<n.length;r+=8192)e+=String.fromCharCode.apply(null,n.subarray(r,r+8192));return e};e.addImage=function(){var e,n,i,a,o,s,u,l,h;if("number"==typeof arguments[1]?(n=r,i=arguments[1],a=arguments[2],o=arguments[3],s=arguments[4],u=arguments[5],l=arguments[6],h=arguments[7]):(n=arguments[1],i=arguments[2],a=arguments[3],o=arguments[4],s=arguments[5],u=arguments[6],l=arguments[7],h=arguments[8]),"object"===t(e=arguments[0])&&!p(e)&&"imageData"in e){var f=e;e=f.imageData,n=f.format||n||r,i=f.x||i||0,a=f.y||a||0,o=f.w||f.width||o,s=f.h||f.height||s,u=f.alias||u,l=f.compression||l,h=f.rotation||f.angle||h}var d=this.internal.getFilters();if(void 0===l&&-1!==d.indexOf("FlateEncode")&&(l="SLOW"),isNaN(i)||isNaN(a))throw new Error("Invalid coordinates passed to jsPDF.addImage");c.call(this);var g=P.call(this,e,n,u,l);return b.call(this,i,a,o,s,g,h),this};var P=function(t,n,i,o){var s,u,c;if("string"==typeof t&&a(t)===r){t=unescape(t);var l=k(t,!1);(""!==l||void 0!==(l=e.loadFile(t,!0)))&&(t=l)}if(p(t)&&(t=g(t,n)),n=a(t,n),!d(n))throw new Error("addImage does not support files of type '"+n+"', please ensure that a plugin for '"+n+"' support is added.");if((null==(c=i)||0===c.length)&&(i=function(t){return"string"==typeof t||A(t)?N(t):A(t.data)?N(t.data):null}(t)),(s=m.call(this,i))||(t instanceof Uint8Array||"RGBA"===n||(u=t,t=S(t)),s=this["process"+n.toUpperCase()](t,h.call(this),i,function(t){return t&&"string"==typeof t&&(t=t.toUpperCase()),t in e.image_compression?t:w.NONE}(o),u)),!s)throw new Error("An unknown error occurred whilst processing the image.");return s},k=e.__addimage__.convertBase64ToBinaryString=function(t,e){e="boolean"!=typeof e||e;var n,r="";if("string"==typeof t){var i;n=null!==(i=x(t))&&void 0!==i?i:t;try{r=f(n)}catch(a){if(e)throw L(n)?new Error("atob-Error in jsPDF.convertBase64ToBinaryString "+a.message):new Error("Supplied Data is not a valid base64-String jsPDF.convertBase64ToBinaryString ")}}return r};e.getImageProperties=function(t){var n,i,o="";if(p(t)&&(t=g(t)),"string"==typeof t&&a(t)===r&&(""===(o=k(t,!1))&&(o=e.loadFile(t)||""),t=o),i=a(t),!d(i))throw new Error("addImage does not support files of type '"+i+"', please ensure that a plugin for '"+i+"' support is added.");if(t instanceof Uint8Array||(t=S(t)),!(n=this["process"+i.toUpperCase()](t)))throw new Error("An unknown error occurred whilst processing the image");return n.fileType=i,n}}(E.API),
/**
 * @license
 * Copyright (c) 2014 Steven Spungin (TwelveTone LLC)  steven@twelvetone.tv
 *
 * Licensed under the MIT License.
 * http://opensource.org/licenses/mit-license
 */
function(t){var e=function(t){if(void 0!==t&&""!=t)return!0};E.API.events.push(["addPage",function(t){this.internal.getPageInfo(t.pageNumber).pageContext.annotations=[]}]),t.events.push(["putPage",function(t){for(var n,r,i,a=this.internal.getCoordinateString,o=this.internal.getVerticalCoordinateString,s=this.internal.getPageInfoByObjId(t.objId),u=t.pageContext.annotations,c=!1,l=0;l<u.length&&!c;l++)switch((n=u[l]).type){case"link":(e(n.options.url)||e(n.options.pageNumber))&&(c=!0);break;case"reference":case"text":case"freetext":c=!0}if(0!=c){this.internal.write("/Annots [");for(var h=0;h<u.length;h++){n=u[h];var f=this.internal.pdfEscape,d=this.internal.getEncryptor(t.objId);switch(n.type){case"reference":this.internal.write(" "+n.object.objId+" 0 R ");break;case"text":var p=this.internal.newAdditionalObject(),g=this.internal.newAdditionalObject(),m=this.internal.getEncryptor(p.objId),v=n.title||"Note";i="<</Type /Annot /Subtype /Text "+(r="/Rect ["+a(n.bounds.x)+" "+o(n.bounds.y+n.bounds.h)+" "+a(n.bounds.x+n.bounds.w)+" "+o(n.bounds.y)+"] ")+"/Contents ("+f(m(n.contents))+")",i+=" /Popup "+g.objId+" 0 R",i+=" /P "+s.objId+" 0 R",i+=" /T ("+f(m(v))+") >>",p.content=i;var b=p.objId+" 0 R";i="<</Type /Annot /Subtype /Popup "+(r="/Rect ["+a(n.bounds.x+30)+" "+o(n.bounds.y+n.bounds.h)+" "+a(n.bounds.x+n.bounds.w+30)+" "+o(n.bounds.y)+"] ")+" /Parent "+b,n.open&&(i+=" /Open true"),i+=" >>",g.content=i,this.internal.write(p.objId,"0 R",g.objId,"0 R");break;case"freetext":r="/Rect ["+a(n.bounds.x)+" "+o(n.bounds.y)+" "+a(n.bounds.x+n.bounds.w)+" "+o(n.bounds.y+n.bounds.h)+"] ";var y=n.color||"#000000";i="<</Type /Annot /Subtype /FreeText "+r+"/Contents ("+f(d(n.contents))+")",i+=" /DS(font: Helvetica,sans-serif 12.0pt; text-align:left; color:#"+y+")",i+=" /Border [0 0 0]",i+=" >>",this.internal.write(i);break;case"link":if(n.options.name){var w=this.annotations._nameMap[n.options.name];n.options.pageNumber=w.page,n.options.top=w.y}else n.options.top||(n.options.top=0);if(r="/Rect ["+n.finalBounds.x+" "+n.finalBounds.y+" "+n.finalBounds.w+" "+n.finalBounds.h+"] ",i="",n.options.url)i="<</Type /Annot /Subtype /Link "+r+"/Border [0 0 0] /A <</S /URI /URI ("+f(d(n.options.url))+") >>";else if(n.options.pageNumber)switch(i="<</Type /Annot /Subtype /Link "+r+"/Border [0 0 0] /Dest ["+this.internal.getPageInfo(n.options.pageNumber).objId+" 0 R",n.options.magFactor=n.options.magFactor||"XYZ",n.options.magFactor){case"Fit":i+=" /Fit]";break;case"FitH":i+=" /FitH "+n.options.top+"]";break;case"FitV":n.options.left=n.options.left||0,i+=" /FitV "+n.options.left+"]";break;default:var N=o(n.options.top);n.options.left=n.options.left||0,void 0===n.options.zoom&&(n.options.zoom=0),i+=" /XYZ "+n.options.left+" "+N+" "+n.options.zoom+"]"}""!=i&&(i+=" >>",this.internal.write(i))}}this.internal.write("]")}}]),t.createAnnotation=function(t){var e=this.internal.getCurrentPageInfo();switch(t.type){case"link":this.link(t.bounds.x,t.bounds.y,t.bounds.w,t.bounds.h,t);break;case"text":case"freetext":e.pageContext.annotations.push(t)}},t.link=function(t,e,n,r,i){var a=this.internal.getCurrentPageInfo(),o=this.internal.getCoordinateString,s=this.internal.getVerticalCoordinateString;a.pageContext.annotations.push({finalBounds:{x:o(t),y:s(e),w:o(t+n),h:s(e+r)},options:i,type:"link"})},t.textWithLink=function(t,e,n,r){var i,a,o=this.getTextWidth(t),s=this.internal.getLineHeight()/this.internal.scaleFactor;if(void 0!==r.maxWidth){a=r.maxWidth;var u=this.splitTextToSize(t,a).length;i=Math.ceil(s*u)}else a=o,i=s;return this.text(t,e,n,r),n+=.2*s,"center"===r.align&&(e-=o/2),"right"===r.align&&(e-=o),this.link(e,n-s,a,i,r),o},t.getTextWidth=function(t){var e=this.internal.getFontSize();return this.getStringUnitWidth(t)*e/this.internal.scaleFactor}}(E.API),
/**
 * @license
 * Copyright (c) 2017 Aras Abbasi
 *
 * Licensed under the MIT License.
 * http://opensource.org/licenses/mit-license
 */
function(t){var e={1569:[65152],1570:[65153,65154],1571:[65155,65156],1572:[65157,65158],1573:[65159,65160],1574:[65161,65162,65163,65164],1575:[65165,65166],1576:[65167,65168,65169,65170],1577:[65171,65172],1578:[65173,65174,65175,65176],1579:[65177,65178,65179,65180],1580:[65181,65182,65183,65184],1581:[65185,65186,65187,65188],1582:[65189,65190,65191,65192],1583:[65193,65194],1584:[65195,65196],1585:[65197,65198],1586:[65199,65200],1587:[65201,65202,65203,65204],1588:[65205,65206,65207,65208],1589:[65209,65210,65211,65212],1590:[65213,65214,65215,65216],1591:[65217,65218,65219,65220],1592:[65221,65222,65223,65224],1593:[65225,65226,65227,65228],1594:[65229,65230,65231,65232],1601:[65233,65234,65235,65236],1602:[65237,65238,65239,65240],1603:[65241,65242,65243,65244],1604:[65245,65246,65247,65248],1605:[65249,65250,65251,65252],1606:[65253,65254,65255,65256],1607:[65257,65258,65259,65260],1608:[65261,65262],1609:[65263,65264,64488,64489],1610:[65265,65266,65267,65268],1649:[64336,64337],1655:[64477],1657:[64358,64359,64360,64361],1658:[64350,64351,64352,64353],1659:[64338,64339,64340,64341],1662:[64342,64343,64344,64345],1663:[64354,64355,64356,64357],1664:[64346,64347,64348,64349],1667:[64374,64375,64376,64377],1668:[64370,64371,64372,64373],1670:[64378,64379,64380,64381],1671:[64382,64383,64384,64385],1672:[64392,64393],1676:[64388,64389],1677:[64386,64387],1678:[64390,64391],1681:[64396,64397],1688:[64394,64395],1700:[64362,64363,64364,64365],1702:[64366,64367,64368,64369],1705:[64398,64399,64400,64401],1709:[64467,64468,64469,64470],1711:[64402,64403,64404,64405],1713:[64410,64411,64412,64413],1715:[64406,64407,64408,64409],1722:[64414,64415],1723:[64416,64417,64418,64419],1726:[64426,64427,64428,64429],1728:[64420,64421],1729:[64422,64423,64424,64425],1733:[64480,64481],1734:[64473,64474],1735:[64471,64472],1736:[64475,64476],1737:[64482,64483],1739:[64478,64479],1740:[64508,64509,64510,64511],1744:[64484,64485,64486,64487],1746:[64430,64431],1747:[64432,64433]},n={65247:{65154:65269,65156:65271,65160:65273,65166:65275},65248:{65154:65270,65156:65272,65160:65274,65166:65276},65165:{65247:{65248:{65258:65010}}},1617:{1612:64606,1613:64607,1614:64608,1615:64609,1616:64610}},r={1612:64606,1613:64607,1614:64608,1615:64609,1616:64610},i=[1570,1571,1573,1575];t.__arabicParser__={};var a=t.__arabicParser__.isInArabicSubstitutionA=function(t){return void 0!==e[t.charCodeAt(0)]},o=t.__arabicParser__.isArabicLetter=function(t){return"string"==typeof t&&/^[\u0600-\u06FF\u0750-\u077F\u08A0-\u08FF\uFB50-\uFDFF\uFE70-\uFEFF]+$/.test(t)},s=t.__arabicParser__.isArabicEndLetter=function(t){return o(t)&&a(t)&&e[t.charCodeAt(0)].length<=2},u=t.__arabicParser__.isArabicAlfLetter=function(t){return o(t)&&i.indexOf(t.charCodeAt(0))>=0};t.__arabicParser__.arabicLetterHasIsolatedForm=function(t){return o(t)&&a(t)&&e[t.charCodeAt(0)].length>=1};var c=t.__arabicParser__.arabicLetterHasFinalForm=function(t){return o(t)&&a(t)&&e[t.charCodeAt(0)].length>=2};t.__arabicParser__.arabicLetterHasInitialForm=function(t){return o(t)&&a(t)&&e[t.charCodeAt(0)].length>=3};var l=t.__arabicParser__.arabicLetterHasMedialForm=function(t){return o(t)&&a(t)&&4==e[t.charCodeAt(0)].length},h=t.__arabicParser__.resolveLigatures=function(t){var e=0,r=n,i="",a=0;for(e=0;e<t.length;e+=1)void 0!==r[t.charCodeAt(e)]?(a++,"number"==typeof(r=r[t.charCodeAt(e)])&&(i+=String.fromCharCode(r),r=n,a=0),e===t.length-1&&(r=n,i+=t.charAt(e-(a-1)),e-=a-1,a=0)):(r=n,i+=t.charAt(e-a),e-=a,a=0);return i};t.__arabicParser__.isArabicDiacritic=function(t){return void 0!==t&&void 0!==r[t.charCodeAt(0)]};var f=t.__arabicParser__.getCorrectForm=function(t,e,n){return o(t)?!1===a(t)?-1:!c(t)||!o(e)&&!o(n)||!o(n)&&s(e)||s(t)&&!o(e)||s(t)&&u(e)||s(t)&&s(e)?0:l(t)&&o(e)&&!s(e)&&o(n)&&c(n)?3:s(t)||!o(n)?1:2:-1},d=function(t){var n=0,r=0,i=0,a="",s="",u="",c=(t=t||"").split("\\s+"),l=[];for(n=0;n<c.length;n+=1){for(l.push(""),r=0;r<c[n].length;r+=1)a=c[n][r],s=c[n][r-1],u=c[n][r+1],o(a)?(i=f(a,s,u),l[n]+=-1!==i?String.fromCharCode(e[a.charCodeAt(0)][i]):a):l[n]+=a;l[n]=h(l[n])}return l.join(" ")},p=t.__arabicParser__.processArabic=t.processArabic=function(){var t,e="string"==typeof arguments[0]?arguments[0]:arguments[0].text,n=[];if(Array.isArray(e)){var r=0;for(n=[],r=0;r<e.length;r+=1)Array.isArray(e[r])?n.push([d(e[r][0]),e[r][1],e[r][2]]):n.push([d(e[r])]);t=n}else t=d(e);return"string"==typeof arguments[0]?t:(arguments[0].text=t,arguments[0])};t.events.push(["preProcessText",p])}(E.API),E.API.autoPrint=function(t){var e;return(t=t||{}).variant=t.variant||"non-conform","javascript"===t.variant?this.addJS("print({});"):(this.internal.events.subscribe("postPutResources",function(){e=this.internal.newObject(),this.internal.out("<<"),this.internal.out("/S /Named"),this.internal.out("/Type /Action"),this.internal.out("/N /Print"),this.internal.out(">>"),this.internal.out("endobj")}),this.internal.events.subscribe("putCatalog",function(){this.internal.out("/OpenAction "+e+" 0 R")})),this},
/**
 * @license
 * Copyright (c) 2014 Steven Spungin (TwelveTone LLC)  steven@twelvetone.tv
 *
 * Licensed under the MIT License.
 * http://opensource.org/licenses/mit-license
 */
function(t){var e=function(){var t=void 0;Object.defineProperty(this,"pdf",{get:function(){return t},set:function(e){t=e}});var e=150;Object.defineProperty(this,"width",{get:function(){return e},set:function(t){e=isNaN(t)||!1===Number.isInteger(t)||t<0?150:t,this.getContext("2d").pageWrapXEnabled&&(this.getContext("2d").pageWrapX=e+1)}});var n=300;Object.defineProperty(this,"height",{get:function(){return n},set:function(t){n=isNaN(t)||!1===Number.isInteger(t)||t<0?300:t,this.getContext("2d").pageWrapYEnabled&&(this.getContext("2d").pageWrapY=n+1)}});var r=[];Object.defineProperty(this,"childNodes",{get:function(){return r},set:function(t){r=t}});var i={};Object.defineProperty(this,"style",{get:function(){return i},set:function(t){i=t}}),Object.defineProperty(this,"parentNode",{})};e.prototype.getContext=function(t,e){var n;if("2d"!==(t=t||"2d"))return null;for(n in e)this.pdf.context2d.hasOwnProperty(n)&&(this.pdf.context2d[n]=e[n]);return this.pdf.context2d._canvas=this,this.pdf.context2d},e.prototype.toDataURL=function(){throw new Error("toDataURL is not implemented.")},t.events.push(["initialized",function(){this.canvas=new e,this.canvas.pdf=this}])}(E.API),function(e){var n={left:0,top:0,bottom:0,right:0},r=!1,i=function(){void 0===this.internal.__cell__&&(this.internal.__cell__={},this.internal.__cell__.padding=3,this.internal.__cell__.headerFunction=void 0,this.internal.__cell__.margins=Object.assign({},n),this.internal.__cell__.margins.width=this.getPageWidth(),a.call(this))},a=function(){this.internal.__cell__.lastCell=new o,this.internal.__cell__.pages=1},o=function(){var t=arguments[0];Object.defineProperty(this,"x",{enumerable:!0,get:function(){return t},set:function(e){t=e}});var e=arguments[1];Object.defineProperty(this,"y",{enumerable:!0,get:function(){return e},set:function(t){e=t}});var n=arguments[2];Object.defineProperty(this,"width",{enumerable:!0,get:function(){return n},set:function(t){n=t}});var r=arguments[3];Object.defineProperty(this,"height",{enumerable:!0,get:function(){return r},set:function(t){r=t}});var i=arguments[4];Object.defineProperty(this,"text",{enumerable:!0,get:function(){return i},set:function(t){i=t}});var a=arguments[5];Object.defineProperty(this,"lineNumber",{enumerable:!0,get:function(){return a},set:function(t){a=t}});var o=arguments[6];return Object.defineProperty(this,"align",{enumerable:!0,get:function(){return o},set:function(t){o=t}}),this};o.prototype.clone=function(){return new o(this.x,this.y,this.width,this.height,this.text,this.lineNumber,this.align)},o.prototype.toArray=function(){return[this.x,this.y,this.width,this.height,this.text,this.lineNumber,this.align]},e.setHeaderFunction=function(t){return i.call(this),this.internal.__cell__.headerFunction="function"==typeof t?t:void 0,this},e.getTextDimensions=function(t,e){i.call(this);var n=(e=e||{}).fontSize||this.getFontSize(),r=e.font||this.getFont(),a=e.scaleFactor||this.internal.scaleFactor,o=0,s=0,u=0,c=this;if(!Array.isArray(t)&&"string"!=typeof t){if("number"!=typeof t)throw new Error("getTextDimensions expects text-parameter to be of type String or type Number or an Array of Strings.");t=String(t)}var l=e.maxWidth;l>0?"string"==typeof t?t=this.splitTextToSize(t,l):"[object Array]"===Object.prototype.toString.call(t)&&(t=t.reduce(function(t,e){return t.concat(c.splitTextToSize(e,l))},[])):t=Array.isArray(t)?t:[t];for(var h=0;h<t.length;h++)o<(u=this.getStringUnitWidth(t[h],{font:r})*n)&&(o=u);return 0!==o&&(s=t.length),{w:o/=a,h:Math.max((s*n*this.getLineHeightFactor()-n*(this.getLineHeightFactor()-1))/a,0)}},e.cellAddPage=function(){i.call(this),this.addPage();var t=this.internal.__cell__.margins||n;return this.internal.__cell__.lastCell=new o(t.left,t.top,void 0,void 0),this.internal.__cell__.pages+=1,this};var s=e.cell=function(){var t;t=arguments[0]instanceof o?arguments[0]:new o(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5]),i.call(this);var e=this.internal.__cell__.lastCell,a=this.internal.__cell__.padding,s=this.internal.__cell__.margins||n,u=this.internal.__cell__.tableHeaderRow,c=this.internal.__cell__.printHeaders;return void 0!==e.lineNumber&&(e.lineNumber===t.lineNumber?(t.x=(e.x||0)+(e.width||0),t.y=e.y||0):e.y+e.height+t.height+s.bottom>this.getPageHeight()?(this.cellAddPage(),t.y=s.top,c&&u&&(this.printHeaderRow(t.lineNumber,!0),t.y+=u[0].height)):t.y=e.y+e.height||t.y),void 0!==t.text[0]&&(this.rect(t.x,t.y,t.width,t.height,!0===r?"FD":void 0),"right"===t.align?this.text(t.text,t.x+t.width-a,t.y+a,{align:"right",baseline:"top"}):"center"===t.align?this.text(t.text,t.x+t.width/2,t.y+a,{align:"center",baseline:"top",maxWidth:t.width-a-a}):this.text(t.text,t.x+a,t.y+a,{align:"left",baseline:"top",maxWidth:t.width-a-a})),this.internal.__cell__.lastCell=t,this};e.table=function(e,r,c,l,h){if(i.call(this),!c)throw new Error("No data for PDF table.");var f,d,p,g,m=[],v=[],b=[],y={},w={},N=[],L=[],x=(h=h||{}).autoSize||!1,A=!1!==h.printHeaders,S=h.css&&void 0!==h.css["font-size"]?16*h.css["font-size"]:h.fontSize||12,_=h.margins||Object.assign({width:this.getPageWidth()},n),P="number"==typeof h.padding?h.padding:3,k=h.headerBackgroundColor||"#c8c8c8",F=h.headerTextColor||"#000";if(a.call(this),this.internal.__cell__.printHeaders=A,this.internal.__cell__.margins=_,this.internal.__cell__.table_font_size=S,this.internal.__cell__.padding=P,this.internal.__cell__.headerBackgroundColor=k,this.internal.__cell__.headerTextColor=F,this.setFontSize(S),null==l)v=m=Object.keys(c[0]),b=m.map(function(){return"left"});else if(Array.isArray(l)&&"object"===t(l[0]))for(m=l.map(function(t){return t.name}),v=l.map(function(t){return t.prompt||t.name||""}),b=l.map(function(t){return t.align||"left"}),f=0;f<l.length;f+=1)w[l[f].name]=.7499990551181103*l[f].width;else Array.isArray(l)&&"string"==typeof l[0]&&(v=m=l,b=m.map(function(){return"left"}));if(x||Array.isArray(l)&&"string"==typeof l[0])for(f=0;f<m.length;f+=1){for(y[g=m[f]]=c.map(function(t){return t[g]}),this.setFont(void 0,"bold"),N.push(this.getTextDimensions(v[f],{fontSize:this.internal.__cell__.table_font_size,scaleFactor:this.internal.scaleFactor}).w),d=y[g],this.setFont(void 0,"normal"),p=0;p<d.length;p+=1)N.push(this.getTextDimensions(d[p],{fontSize:this.internal.__cell__.table_font_size,scaleFactor:this.internal.scaleFactor}).w);w[g]=Math.max.apply(null,N)+P+P,N=[]}if(A){var I={};for(f=0;f<m.length;f+=1)I[m[f]]={},I[m[f]].text=v[f],I[m[f]].align=b[f];var j=u.call(this,I,w);L=m.map(function(t){return new o(e,r,w[t],j,I[t].text,void 0,I[t].align)}),this.setTableHeaderRow(L),this.printHeaderRow(1,!1)}var C=l.reduce(function(t,e){return t[e.name]=e.align,t},{});for(f=0;f<c.length;f+=1){"rowStart"in h&&h.rowStart instanceof Function&&h.rowStart({row:f,data:c[f]},this);var O=u.call(this,c[f],w);for(p=0;p<m.length;p+=1){var B=c[f][m[p]];"cellStart"in h&&h.cellStart instanceof Function&&h.cellStart({row:f,col:p,data:B},this),s.call(this,new o(e,r,w[m[p]],O,B,f+2,C[m[p]]))}}return this.internal.__cell__.table_x=e,this.internal.__cell__.table_y=r,this};var u=function(t,e){var n=this.internal.__cell__.padding,r=this.internal.__cell__.table_font_size,i=this.internal.scaleFactor;return Object.keys(t).map(function(r){var i=t[r];return this.splitTextToSize(i.hasOwnProperty("text")?i.text:i,e[r]-n-n)},this).map(function(t){return this.getLineHeightFactor()*t.length*r/i+n+n},this).reduce(function(t,e){return Math.max(t,e)},0)};e.setTableHeaderRow=function(t){i.call(this),this.internal.__cell__.tableHeaderRow=t},e.printHeaderRow=function(t,e){if(i.call(this),!this.internal.__cell__.tableHeaderRow)throw new Error("Property tableHeaderRow does not exist.");var n;if(r=!0,"function"==typeof this.internal.__cell__.headerFunction){var a=this.internal.__cell__.headerFunction(this,this.internal.__cell__.pages);this.internal.__cell__.lastCell=new o(a[0],a[1],a[2],a[3],void 0,-1)}this.setFont(void 0,"bold");for(var u=[],c=0;c<this.internal.__cell__.tableHeaderRow.length;c+=1){n=this.internal.__cell__.tableHeaderRow[c].clone(),e&&(n.y=this.internal.__cell__.margins.top||0,u.push(n)),n.lineNumber=t;var l=this.getTextColor();this.setTextColor(this.internal.__cell__.headerTextColor),this.setFillColor(this.internal.__cell__.headerBackgroundColor),s.call(this,n),this.setTextColor(l)}u.length>0&&this.setTableHeaderRow(u),this.setFont(void 0,"normal"),r=!1}}(E.API);var Pt={italic:["italic","oblique","normal"],oblique:["oblique","italic","normal"],normal:["normal","oblique","italic"]},kt=["ultra-condensed","extra-condensed","condensed","semi-condensed","normal","semi-expanded","expanded","extra-expanded","ultra-expanded"],Ft=_t(kt),It=[100,200,300,400,500,600,700,800,900],jt=_t(It);function Ct(t){var e=t.family.replace(/"|'/g,"").toLowerCase(),n=function(t){return Pt[t=t||"normal"]?t:"normal"}(t.style),r=function(t){return t?"number"==typeof t?t>=100&&t<=900&&t%100==0?t:400:/^\d00$/.test(t)?parseInt(t):"bold"===t?700:400:400}(t.weight),i=function(t){return"number"==typeof Ft[t=t||"normal"]?t:"normal"}(t.stretch);return{family:e,style:n,weight:r,stretch:i,src:t.src||[],ref:t.ref||{name:e,style:[i,n,r].join(" ")}}}function Ot(t,e,n,r){var i;for(i=n;i>=0&&i<e.length;i+=r)if(t[e[i]])return t[e[i]];for(i=n;i>=0&&i<e.length;i-=r)if(t[e[i]])return t[e[i]]}var Bt={"sans-serif":"helvetica",fixed:"courier",monospace:"courier",terminal:"courier",cursive:"times",fantasy:"times",serif:"times"},Mt={caption:"times",icon:"times",menu:"times","message-box":"times","small-caption":"times","status-bar":"times"};function qt(t){return[t.stretch,t.style,t.weight,t.family].join(" ")}function Et(t){return t.trimLeft()}function Rt(t,e){for(var n=0;n<t.length;){if(t.charAt(n)===e)return[t.substring(0,n),t.substring(n+1)];n+=1}return null}function Dt(t){var e=t.match(/^(-[a-z_]|[a-z_])[a-z0-9_-]*/i);return null===e?null:[e[0],t.substring(e[0].length)]}var Tt,zt,Ut,Ht,Wt,Vt,Gt,Yt,Jt=["times"];function Xt(t,n,r,i){var a=4,o=$t;switch(i){case E.API.image_compression.FAST:a=1,o=Zt;break;case E.API.image_compression.MEDIUM:a=6,o=Qt;break;case E.API.image_compression.SLOW:a=9,o=te}t=function(t,e,n,r){for(var i,a=t.length/e,o=new Uint8Array(t.length+a),s=[Kt,Zt,$t,Qt,te],u=0;u<a;u+=1){var c=u*e,l=t.subarray(c,c+e);if(r)o.set(r(l,n,i),c+u);else{for(var h=s.length,f=[],d=0;d<h;d+=1)f[d]=s[d](l,n,i);var p=ne(f.concat());o.set(f[p],c+u)}i=l}return o}(t,n,r,o);var s=e(t,{level:a});return E.API.__addimage__.arrayBufferToBinaryString(s)}function Kt(t){var e=Array.apply([],t);return e.unshift(0),e}function Zt(t,e){var n=t.length,r=[];r[0]=1;for(var i=0;i<n;i+=1){var a=t[i-e]||0;r[i+1]=t[i]-a+256&255}return r}function $t(t,e,n){var r=t.length,i=[];i[0]=2;for(var a=0;a<r;a+=1){var o=n&&n[a]||0;i[a+1]=t[a]-o+256&255}return i}function Qt(t,e,n){var r=t.length,i=[];i[0]=3;for(var a=0;a<r;a+=1){var o=t[a-e]||0,s=n&&n[a]||0;i[a+1]=t[a]+256-(o+s>>>1)&255}return i}function te(t,e,n){var r=t.length,i=[];i[0]=4;for(var a=0;a<r;a+=1){var o=ee(t[a-e]||0,n&&n[a]||0,n&&n[a-e]||0);i[a+1]=t[a]-o+256&255}return i}function ee(t,e,n){if(t===e&&e===n)return t;var r=Math.abs(e-n),i=Math.abs(t-n),a=Math.abs(t+e-n-n);return r<=i&&r<=a?t:i<=a?e:n}function ne(t){var e=t.map(function(t){return t.reduce(function(t,e){return t+Math.abs(e)},0)});return e.indexOf(Math.min.apply(null,e))}function re(t,e,n){var r=e*n,i=Math.floor(r/8),a=16-(r-8*i+n),o=(1<<n)-1;return ae(t,i)>>a&o}function ie(t,e,n,r){var i=n*r,a=Math.floor(i/8),o=16-(i-8*a+r),s=(1<<r)-1,u=(e&s)<<o;!function(t,e,n){if(e+1<t.byteLength)t.setUint16(e,n,!1);else{var r=n>>8&255;t.setUint8(e,r)}}
/**
 * @license
 * (c) Dean McNamee <dean@gmail.com>, 2013.
 *
 * https://github.com/deanm/omggif
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 *
 * omggif is a JavaScript implementation of a GIF 89a encoder and decoder,
 * including animation and compression.  It does not rely on any specific
 * underlying system, so should run in the browser, Node, or Plask.
 */(t,a,ae(t,a)&~(s<<o)&65535|u)}function ae(t,e){return e+1<t.byteLength?t.getUint16(e,!1):t.getUint8(e)<<8}function oe(t){var e=0;if(71!==t[e++]||73!==t[e++]||70!==t[e++]||56!==t[e++]||56!=(t[e++]+1&253)||97!==t[e++])throw new Error("Invalid GIF 87a/89a header.");var n=t[e++]|t[e++]<<8,r=t[e++]|t[e++]<<8,i=t[e++],a=i>>7,o=1<<1+(7&i);t[e++],t[e++];var s=null,u=null;a&&(s=e,u=o,e+=3*o);var c=!0,l=[],h=0,f=null,d=0,p=null;for(this.width=n,this.height=r;c&&e<t.length;)switch(t[e++]){case 33:switch(t[e++]){case 255:if(11!==t[e]||78==t[e+1]&&69==t[e+2]&&84==t[e+3]&&83==t[e+4]&&67==t[e+5]&&65==t[e+6]&&80==t[e+7]&&69==t[e+8]&&50==t[e+9]&&46==t[e+10]&&48==t[e+11]&&3==t[e+12]&&1==t[e+13]&&0==t[e+16])e+=14,p=t[e++]|t[e++]<<8,e++;else for(e+=12;;){if(!((P=t[e++])>=0))throw Error("Invalid block size");if(0===P)break;e+=P}break;case 249:if(4!==t[e++]||0!==t[e+4])throw new Error("Invalid graphics extension block.");var g=t[e++];h=t[e++]|t[e++]<<8,f=t[e++],1&g||(f=null),d=g>>2&7,e++;break;case 254:for(;;){if(!((P=t[e++])>=0))throw Error("Invalid block size");if(0===P)break;e+=P}break;default:throw new Error("Unknown graphic control label: 0x"+t[e-1].toString(16))}break;case 44:var m=t[e++]|t[e++]<<8,v=t[e++]|t[e++]<<8,b=t[e++]|t[e++]<<8,y=t[e++]|t[e++]<<8,w=t[e++],N=w>>6&1,L=1<<1+(7&w),x=s,A=u,S=!1;w>>7&&(S=!0,x=e,A=L,e+=3*L);var _=e;for(e++;;){var P;if(!((P=t[e++])>=0))throw Error("Invalid block size");if(0===P)break;e+=P}l.push({x:m,y:v,width:b,height:y,has_local_palette:S,palette_offset:x,palette_size:A,data_offset:_,data_length:e-_,transparent_index:f,interlaced:!!N,delay:h,disposal:d});break;case 59:c=!1;break;default:throw new Error("Unknown gif block: 0x"+t[e-1].toString(16))}this.numFrames=function(){return l.length},this.loopCount=function(){return p},this.frameInfo=function(t){if(t<0||t>=l.length)throw new Error("Frame index out of range.");return l[t]},this.decodeAndBlitFrameBGRA=function(e,r){var i=this.frameInfo(e),a=i.width*i.height,o=new Uint8Array(a);se(t,i.data_offset,o,a);var s=i.palette_offset,u=i.transparent_index;null===u&&(u=256);var c=i.width,l=n-c,h=c,f=4*(i.y*n+i.x),d=4*((i.y+i.height)*n+i.x),p=f,g=4*l;!0===i.interlaced&&(g+=4*n*7);for(var m=8,v=0,b=o.length;v<b;++v){var y=o[v];if(0===h&&(h=c,(p+=g)>=d&&(g=4*l+4*n*(m-1),p=f+(c+l)*(m<<1),m>>=1)),y===u)p+=4;else{var w=t[s+3*y],N=t[s+3*y+1],L=t[s+3*y+2];r[p++]=L,r[p++]=N,r[p++]=w,r[p++]=255}--h}},this.decodeAndBlitFrameRGBA=function(e,r){var i=this.frameInfo(e),a=i.width*i.height,o=new Uint8Array(a);se(t,i.data_offset,o,a);var s=i.palette_offset,u=i.transparent_index;null===u&&(u=256);var c=i.width,l=n-c,h=c,f=4*(i.y*n+i.x),d=4*((i.y+i.height)*n+i.x),p=f,g=4*l;!0===i.interlaced&&(g+=4*n*7);for(var m=8,v=0,b=o.length;v<b;++v){var y=o[v];if(0===h&&(h=c,(p+=g)>=d&&(g=4*l+4*n*(m-1),p=f+(c+l)*(m<<1),m>>=1)),y===u)p+=4;else{var w=t[s+3*y],N=t[s+3*y+1],L=t[s+3*y+2];r[p++]=w,r[p++]=N,r[p++]=L,r[p++]=255}--h}}}function se(t,e,n,r){for(var i=t[e++],a=1<<i,s=a+1,u=s+1,c=i+1,l=(1<<c)-1,h=0,f=0,d=0,p=t[e++],g=new Int32Array(4096),m=null;;){for(;h<16&&0!==p;)f|=t[e++]<<h,h+=8,1===p?p=t[e++]:--p;if(h<c)break;var v=f&l;if(f>>=c,h-=c,v!==a){if(v===s)break;for(var b=v<u?v:m,y=0,w=b;w>a;)w=g[w]>>8,++y;var N=w;if(d+y+(b!==v?1:0)>r)return void o.log("Warning, gif stream longer than expected.");n[d++]=N;var L=d+=y;for(b!==v&&(n[d++]=N),w=b;y--;)w=g[w],n[--L]=255&w,w>>=8;null!==m&&u<4096&&(g[u++]=m<<8|N,u>=l+1&&c<12&&(++c,l=l<<1|1)),m=v}else u=s+1,l=(1<<(c=i+1))-1,m=null}return d!==r&&o.log("Warning, gif stream shorter than expected."),n}
/**
 * @license
  Copyright (c) 2008, Adobe Systems Incorporated
  All rights reserved.

  Redistribution and use in source and binary forms, with or without 
  modification, are permitted provided that the following conditions are
  met:

  * Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.
  
  * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the 
    documentation and/or other materials provided with the distribution.
  
  * Neither the name of Adobe Systems Incorporated nor the names of its 
    contributors may be used to endorse or promote products derived from 
    this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/function ue(t){var e,n,r,i,a,o=Math.floor,s=new Array(64),u=new Array(64),c=new Array(64),l=new Array(64),h=new Array(65535),f=new Array(65535),d=new Array(64),p=new Array(64),g=[],m=0,v=7,b=new Array(64),y=new Array(64),w=new Array(64),N=new Array(256),L=new Array(2048),x=[0,1,5,6,14,15,27,28,2,4,7,13,16,26,29,42,3,8,12,17,25,30,41,43,9,11,18,24,31,40,44,53,10,19,23,32,39,45,52,54,20,22,33,38,46,51,55,60,21,34,37,47,50,56,59,61,35,36,48,49,57,58,62,63],A=[0,0,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0],S=[0,1,2,3,4,5,6,7,8,9,10,11],_=[0,0,2,1,3,3,2,4,3,5,5,4,4,0,0,1,125],P=[1,2,3,0,4,17,5,18,33,49,65,6,19,81,97,7,34,113,20,50,129,145,161,8,35,66,177,193,21,82,209,240,36,51,98,114,130,9,10,22,23,24,25,26,37,38,39,40,41,42,52,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,225,226,227,228,229,230,231,232,233,234,241,242,243,244,245,246,247,248,249,250],k=[0,0,3,1,1,1,1,1,1,1,1,1,0,0,0,0,0],F=[0,1,2,3,4,5,6,7,8,9,10,11],I=[0,0,2,1,2,4,4,3,4,7,5,4,4,0,1,2,119],j=[0,1,2,3,17,4,5,33,49,6,18,65,81,7,97,113,19,34,50,129,8,20,66,145,161,177,193,9,35,51,82,240,21,98,114,209,10,22,36,52,225,37,241,23,24,25,26,38,39,40,41,42,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,130,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,226,227,228,229,230,231,232,233,234,242,243,244,245,246,247,248,249,250];function C(t,e){for(var n=0,r=0,i=new Array,a=1;a<=16;a++){for(var o=1;o<=t[a];o++)i[e[r]]=[],i[e[r]][0]=n,i[e[r]][1]=a,r++,n++;n*=2}return i}function O(t){for(var e=t[0],n=t[1]-1;n>=0;)e&1<<n&&(m|=1<<v),n--,--v<0&&(255==m?(B(255),B(0)):B(m),v=7,m=0)}function B(t){g.push(t)}function M(t){B(t>>8&255),B(255&t)}function q(t,e,n,r,i){for(var a,o=i[0],s=i[240],u=function(t,e){var n,r,i,a,o,s,u,c,l,h,f=0;for(l=0;l<8;++l){n=t[f],r=t[f+1],i=t[f+2],a=t[f+3],o=t[f+4],s=t[f+5],u=t[f+6];var p=n+(c=t[f+7]),g=n-c,m=r+u,v=r-u,b=i+s,y=i-s,w=a+o,N=a-o,L=p+w,x=p-w,A=m+b,S=m-b;t[f]=L+A,t[f+4]=L-A;var _=.707106781*(S+x);t[f+2]=x+_,t[f+6]=x-_;var P=.382683433*((L=N+y)-(S=v+g)),k=.5411961*L+P,F=1.306562965*S+P,I=.707106781*(A=y+v),j=g+I,C=g-I;t[f+5]=C+k,t[f+3]=C-k,t[f+1]=j+F,t[f+7]=j-F,f+=8}for(f=0,l=0;l<8;++l){n=t[f],r=t[f+8],i=t[f+16],a=t[f+24],o=t[f+32],s=t[f+40],u=t[f+48];var O=n+(c=t[f+56]),B=n-c,M=r+u,q=r-u,E=i+s,R=i-s,D=a+o,T=a-o,z=O+D,U=O-D,H=M+E,W=M-E;t[f]=z+H,t[f+32]=z-H;var V=.707106781*(W+U);t[f+16]=U+V,t[f+48]=U-V;var G=.382683433*((z=T+R)-(W=q+B)),Y=.5411961*z+G,J=1.306562965*W+G,X=.707106781*(H=R+q),K=B+X,Z=B-X;t[f+40]=Z+Y,t[f+24]=Z-Y,t[f+8]=K+J,t[f+56]=K-J,f++}for(l=0;l<64;++l)h=t[l]*e[l],d[l]=h>0?h+.5|0:h-.5|0;return d}(t,e),c=0;c<64;++c)p[x[c]]=u[c];var l=p[0]-n;n=p[0],0==l?O(r[0]):(O(r[f[a=32767+l]]),O(h[a]));for(var g=63;g>0&&0==p[g];)g--;if(0==g)return O(o),n;for(var m,v=1;v<=g;){for(var b=v;0==p[v]&&v<=g;)++v;var y=v-b;if(y>=16){m=y>>4;for(var w=1;w<=m;++w)O(s);y&=15}a=32767+p[v],O(i[(y<<4)+f[a]]),O(h[a]),v++}return 63!=g&&O(o),n}function E(t){t=Math.min(Math.max(t,1),100),a!=t&&(function(t){for(var e=[16,11,10,16,24,40,51,61,12,12,14,19,26,58,60,55,14,13,16,24,40,57,69,56,14,17,22,29,51,87,80,62,18,22,37,56,68,109,103,77,24,35,55,64,81,104,113,92,49,64,78,87,103,121,120,101,72,92,95,98,112,100,103,99],n=0;n<64;n++){var r=o((e[n]*t+50)/100);r=Math.min(Math.max(r,1),255),s[x[n]]=r}for(var i=[17,18,24,47,99,99,99,99,18,21,26,66,99,99,99,99,24,26,56,99,99,99,99,99,47,66,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99],a=0;a<64;a++){var h=o((i[a]*t+50)/100);h=Math.min(Math.max(h,1),255),u[x[a]]=h}for(var f=[1,1.387039845,1.306562965,1.175875602,1,.785694958,.5411961,.275899379],d=0,p=0;p<8;p++)for(var g=0;g<8;g++)c[d]=1/(s[x[d]]*f[p]*f[g]*8),l[d]=1/(u[x[d]]*f[p]*f[g]*8),d++}(t<50?Math.floor(5e3/t):Math.floor(200-2*t)),a=t)}this.encode=function(t,a){a&&E(a),g=new Array,m=0,v=7,M(65496),M(65504),M(16),B(74),B(70),B(73),B(70),B(0),B(1),B(1),B(0),M(1),M(1),B(0),B(0),function(){M(65499),M(132),B(0);for(var t=0;t<64;t++)B(s[t]);B(1);for(var e=0;e<64;e++)B(u[e])}(),function(t,e){M(65472),M(17),B(8),M(e),M(t),B(3),B(1),B(17),B(0),B(2),B(17),B(1),B(3),B(17),B(1)}(t.width,t.height),function(){M(65476),M(418),B(0);for(var t=0;t<16;t++)B(A[t+1]);for(var e=0;e<=11;e++)B(S[e]);B(16);for(var n=0;n<16;n++)B(_[n+1]);for(var r=0;r<=161;r++)B(P[r]);B(1);for(var i=0;i<16;i++)B(k[i+1]);for(var a=0;a<=11;a++)B(F[a]);B(17);for(var o=0;o<16;o++)B(I[o+1]);for(var s=0;s<=161;s++)B(j[s])}(),M(65498),M(12),B(3),B(1),B(0),B(2),B(17),B(3),B(17),B(0),B(63),B(0);var o=0,h=0,f=0;m=0,v=7,this.encode.displayName="_encode_";for(var d,p,N,x,C,R,D,T,z,U=t.data,H=t.width,W=t.height,V=4*H,G=0;G<W;){for(d=0;d<V;){for(C=V*G+d,D=-1,T=0,z=0;z<64;z++)R=C+(T=z>>3)*V+(D=4*(7&z)),G+T>=W&&(R-=V*(G+1+T-W)),d+D>=V&&(R-=d+D-V+4),p=U[R++],N=U[R++],x=U[R++],b[z]=(L[p]+L[N+256|0]+L[x+512|0]>>16)-128,y[z]=(L[p+768|0]+L[N+1024|0]+L[x+1280|0]>>16)-128,w[z]=(L[p+1280|0]+L[N+1536|0]+L[x+1792|0]>>16)-128;o=q(b,c,o,e,r),h=q(y,l,h,n,i),f=q(w,l,f,n,i),d+=32}G+=8}if(v>=0){var Y=[];Y[1]=v+1,Y[0]=(1<<v+1)-1,O(Y)}return M(65497),new Uint8Array(g)},t=t||50,function(){for(var t=String.fromCharCode,e=0;e<256;e++)N[e]=t(e)}(),e=C(A,S),n=C(k,F),r=C(_,P),i=C(I,j),function(){for(var t=1,e=2,n=1;n<=15;n++){for(var r=t;r<e;r++)f[32767+r]=n,h[32767+r]=[],h[32767+r][1]=n,h[32767+r][0]=r;for(var i=-(e-1);i<=-t;i++)f[32767+i]=n,h[32767+i]=[],h[32767+i][1]=n,h[32767+i][0]=e-1+i;t<<=1,e<<=1}}(),function(){for(var t=0;t<256;t++)L[t]=19595*t,L[t+256|0]=38470*t,L[t+512|0]=7471*t+32768,L[t+768|0]=-11059*t,L[t+1024|0]=-21709*t,L[t+1280|0]=32768*t+8421375,L[t+1536|0]=-27439*t,L[t+1792|0]=-5329*t}(),E(t)}
/**
 * @license
 * Copyright (c) 2017 Aras Abbasi
 *
 * Licensed under the MIT License.
 * http://opensource.org/licenses/mit-license
 */function ce(t,e){if(this.pos=0,this.buffer=t,this.datav=new DataView(t.buffer),this.is_with_alpha=!!e,this.bottom_up=!0,this.flag=String.fromCharCode(this.buffer[0])+String.fromCharCode(this.buffer[1]),this.pos+=2,-1===["BM","BA","CI","CP","IC","PT"].indexOf(this.flag))throw new Error("Invalid BMP File");this.parseHeader(),this.parseBGR()}function le(t){function e(t){if(!t)throw Error("assert :P")}function n(t,e,n){for(var r=0;4>r;r++)if(t[e+r]!=n.charCodeAt(r))return!0;return!1}function r(t,e,n,r,i){for(var a=0;a<i;a++)t[e+a]=n[r+a]}function i(t,e,n,r){for(var i=0;i<r;i++)t[e+i]=n}function a(t){return new Int32Array(t)}function o(t,e){for(var n=[],r=0;r<t;r++)n.push(new e);return n}function s(t,e){var n=[];return function t(n,r,i){for(var a=i[r],o=0;o<a&&(n.push(i.length>r+1?[]:new e),!(i.length<r+1));o++)t(n[o],r+1,i)}(n,0,t),n}var u=function(){var t=this;function u(t,e){for(var n=1<<e-1>>>0;t&n;)n>>>=1;return n?(t&n-1)+n:t}function c(t,n,r,i,a){e(!(i%r));do{t[n+(i-=r)]=a}while(0<i)}function l(t,n,r,i,o){if(e(2328>=o),512>=o)var s=a(512);else if(null==(s=a(o)))return 0;return function(t,n,r,i,o,s){var l,f,d=n,p=1<<r,g=a(16),m=a(16);for(e(0!=o),e(null!=i),e(null!=t),e(0<r),f=0;f<o;++f){if(15<i[f])return 0;++g[i[f]]}if(g[0]==o)return 0;for(m[1]=0,l=1;15>l;++l){if(g[l]>1<<l)return 0;m[l+1]=m[l]+g[l]}for(f=0;f<o;++f)l=i[f],0<i[f]&&(s[m[l]++]=f);if(1==m[15])return(i=new h).g=0,i.value=s[0],c(t,d,1,p,i),p;var v,b=-1,y=p-1,w=0,N=1,L=1,x=1<<r;for(f=0,l=1,o=2;l<=r;++l,o<<=1){if(N+=L<<=1,0>(L-=g[l]))return 0;for(;0<g[l];--g[l])(i=new h).g=l,i.value=s[f++],c(t,d+w,o,x,i),w=u(w,l)}for(l=r+1,o=2;15>=l;++l,o<<=1){if(N+=L<<=1,0>(L-=g[l]))return 0;for(;0<g[l];--g[l]){if(i=new h,(w&y)!=b){for(d+=x,v=1<<(b=l)-r;15>b&&!(0>=(v-=g[b]));)++b,v<<=1;p+=x=1<<(v=b-r),t[n+(b=w&y)].g=v+r,t[n+b].value=d-n-b}i.g=l-r,i.value=s[f++],c(t,d+(w>>r),o,x,i),w=u(w,l)}}return N!=2*m[15]-1?0:p}(t,n,r,i,o,s)}function h(){this.value=this.g=0}function f(){this.value=this.g=0}function d(){this.G=o(5,h),this.H=a(5),this.jc=this.Qb=this.qb=this.nd=0,this.pd=o(Rn,f)}function p(t,n,r,i){e(null!=t),e(null!=n),e(2147483648>i),t.Ca=254,t.I=0,t.b=-8,t.Ka=0,t.oa=n,t.pa=r,t.Jd=n,t.Yc=r+i,t.Zc=4<=i?r+i-4+1:r,_(t)}function g(t,e){for(var n=0;0<e--;)n|=k(t,128)<<e;return n}function m(t,e){var n=g(t,e);return P(t)?-n:n}function v(t,n,r,i){var a,o=0;for(e(null!=t),e(null!=n),e(4294967288>i),t.Sb=i,t.Ra=0,t.u=0,t.h=0,4<i&&(i=4),a=0;a<i;++a)o+=n[r+a]<<8*a;t.Ra=o,t.bb=i,t.oa=n,t.pa=r}function b(t){for(;8<=t.u&&t.bb<t.Sb;)t.Ra>>>=8,t.Ra+=t.oa[t.pa+t.bb]<<zn-8>>>0,++t.bb,t.u-=8;x(t)&&(t.h=1,t.u=0)}function y(t,n){if(e(0<=n),!t.h&&n<=Tn){var r=L(t)&Dn[n];return t.u+=n,b(t),r}return t.h=1,t.u=0}function w(){this.b=this.Ca=this.I=0,this.oa=[],this.pa=0,this.Jd=[],this.Yc=0,this.Zc=[],this.Ka=0}function N(){this.Ra=0,this.oa=[],this.h=this.u=this.bb=this.Sb=this.pa=0}function L(t){return t.Ra>>>(t.u&zn-1)>>>0}function x(t){return e(t.bb<=t.Sb),t.h||t.bb==t.Sb&&t.u>zn}function A(t,e){t.u=e,t.h=x(t)}function S(t){t.u>=Un&&(e(t.u>=Un),b(t))}function _(t){e(null!=t&&null!=t.oa),t.pa<t.Zc?(t.I=(t.oa[t.pa++]|t.I<<8)>>>0,t.b+=8):(e(null!=t&&null!=t.oa),t.pa<t.Yc?(t.b+=8,t.I=t.oa[t.pa++]|t.I<<8):t.Ka?t.b=0:(t.I<<=8,t.b+=8,t.Ka=1))}function P(t){return g(t,1)}function k(t,e){var n=t.Ca;0>t.b&&_(t);var r=t.b,i=n*e>>>8,a=(t.I>>>r>i)+0;for(a?(n-=i,t.I-=i+1<<r>>>0):n=i+1,r=n,i=0;256<=r;)i+=8,r>>=8;return r=7^i+Hn[r],t.b-=r,t.Ca=(n<<r)-1,a}function F(t,e,n){t[e+0]=n>>24&255,t[e+1]=n>>16&255,t[e+2]=n>>8&255,t[e+3]=255&n}function I(t,e){return t[e+0]|t[e+1]<<8}function j(t,e){return I(t,e)|t[e+2]<<16}function C(t,e){return I(t,e)|I(t,e+2)<<16}function O(t,n){var r=1<<n;return e(null!=t),e(0<n),t.X=a(r),null==t.X?0:(t.Mb=32-n,t.Xa=n,1)}function B(t,n){e(null!=t),e(null!=n),e(t.Xa==n.Xa),r(n.X,0,t.X,0,1<<n.Xa)}function M(){this.X=[],this.Xa=this.Mb=0}function q(t,n,r,i){e(null!=r),e(null!=i);var a=r[0],o=i[0];return 0==a&&(a=(t*o+n/2)/n),0==o&&(o=(n*a+t/2)/t),0>=a||0>=o?0:(r[0]=a,i[0]=o,1)}function E(t,e){return t+(1<<e)-1>>>e}function R(t,e){return((4278255360&t)+(4278255360&e)>>>0&4278255360)+((16711935&t)+(16711935&e)>>>0&16711935)>>>0}function D(e,n){t[n]=function(n,r,i,a,o,s,u){var c;for(c=0;c<o;++c){var l=t[e](s[u+c-1],i,a+c);s[u+c]=R(n[r+c],l)}}}function T(){this.ud=this.hd=this.jd=0}function z(t,e){return((4278124286&(t^e))>>>1)+(t&e)>>>0}function U(t){return 0<=t&&256>t?t:0>t?0:255<t?255:void 0}function H(t,e){return U(t+(t-e+.5>>1))}function W(t,e,n){return Math.abs(e-n)-Math.abs(t-n)}function V(t,e,n,r,i,a,o){for(r=a[o-1],n=0;n<i;++n)a[o+n]=r=R(t[e+n],r)}function G(t,e,n,r,i){var a;for(a=0;a<n;++a){var o=t[e+a],s=o>>8&255,u=16711935&(u=(u=16711935&o)+((s<<16)+s));r[i+a]=(4278255360&o)+u>>>0}}function Y(t,e){e.jd=255&t,e.hd=t>>8&255,e.ud=t>>16&255}function J(t,e,n,r,i,a){var o;for(o=0;o<r;++o){var s=e[n+o],u=s>>>8,c=s,l=255&(l=(l=s>>>16)+((t.jd<<24>>24)*(u<<24>>24)>>>5));c=255&(c=(c+=(t.hd<<24>>24)*(u<<24>>24)>>>5)+((t.ud<<24>>24)*(l<<24>>24)>>>5)),i[a+o]=(4278255360&s)+(l<<16)+c}}function X(e,n,r,i,a){t[n]=function(t,e,n,r,o,s,u,c,l){for(r=u;r<c;++r)for(u=0;u<l;++u)o[s++]=a(n[i(t[e++])])},t[e]=function(e,n,o,s,u,c,l){var h=8>>e.b,f=e.Ea,d=e.K[0],p=e.w;if(8>h)for(e=(1<<e.b)-1,p=(1<<h)-1;n<o;++n){var g,m=0;for(g=0;g<f;++g)g&e||(m=i(s[u++])),c[l++]=a(d[m&p]),m>>=h}else t["VP8LMapColor"+r](s,u,d,p,c,l,n,o,f)}}function K(t,e,n,r,i){for(n=e+n;e<n;){var a=t[e++];r[i++]=a>>16&255,r[i++]=a>>8&255,r[i++]=255&a}}function Z(t,e,n,r,i){for(n=e+n;e<n;){var a=t[e++];r[i++]=a>>16&255,r[i++]=a>>8&255,r[i++]=255&a,r[i++]=a>>24&255}}function $(t,e,n,r,i){for(n=e+n;e<n;){var a=(o=t[e++])>>16&240|o>>12&15,o=240&o|o>>28&15;r[i++]=a,r[i++]=o}}function Q(t,e,n,r,i){for(n=e+n;e<n;){var a=(o=t[e++])>>16&248|o>>13&7,o=o>>5&224|o>>3&31;r[i++]=a,r[i++]=o}}function tt(t,e,n,r,i){for(n=e+n;e<n;){var a=t[e++];r[i++]=255&a,r[i++]=a>>8&255,r[i++]=a>>16&255}}function et(t,e,n,i,a,o){if(0==o)for(n=e+n;e<n;)F(i,((o=t[e++])[0]>>24|o[1]>>8&65280|o[2]<<8&16711680|o[3]<<24)>>>0),a+=32;else r(i,a,t,e,n)}function nt(e,n){t[n][0]=t[e+"0"],t[n][1]=t[e+"1"],t[n][2]=t[e+"2"],t[n][3]=t[e+"3"],t[n][4]=t[e+"4"],t[n][5]=t[e+"5"],t[n][6]=t[e+"6"],t[n][7]=t[e+"7"],t[n][8]=t[e+"8"],t[n][9]=t[e+"9"],t[n][10]=t[e+"10"],t[n][11]=t[e+"11"],t[n][12]=t[e+"12"],t[n][13]=t[e+"13"],t[n][14]=t[e+"0"],t[n][15]=t[e+"0"]}function rt(t){return t==Ur||t==Hr||t==Wr||t==Vr}function it(){this.eb=[],this.size=this.A=this.fb=0}function at(){this.y=[],this.f=[],this.ea=[],this.F=[],this.Tc=this.Ed=this.Cd=this.Fd=this.lb=this.Db=this.Ab=this.fa=this.J=this.W=this.N=this.O=0}function ot(){this.Rd=this.height=this.width=this.S=0,this.f={},this.f.RGBA=new it,this.f.kb=new at,this.sd=null}function st(){this.width=[0],this.height=[0],this.Pd=[0],this.Qd=[0],this.format=[0]}function ut(){this.Id=this.fd=this.Md=this.hb=this.ib=this.da=this.bd=this.cd=this.j=this.v=this.Da=this.Sd=this.ob=0}function ct(t){return alert("todo:WebPSamplerProcessPlane"),t.T}function lt(t,e){var n=t.T,i=e.ba.f.RGBA,a=i.eb,o=i.fb+t.ka*i.A,s=mi[e.ba.S],u=t.y,c=t.O,l=t.f,h=t.N,f=t.ea,d=t.W,p=e.cc,g=e.dc,m=e.Mc,v=e.Nc,b=t.ka,y=t.ka+t.T,w=t.U,N=w+1>>1;for(0==b?s(u,c,null,null,l,h,f,d,l,h,f,d,a,o,null,null,w):(s(e.ec,e.fc,u,c,p,g,m,v,l,h,f,d,a,o-i.A,a,o,w),++n);b+2<y;b+=2)p=l,g=h,m=f,v=d,h+=t.Rc,d+=t.Rc,o+=2*i.A,s(u,(c+=2*t.fa)-t.fa,u,c,p,g,m,v,l,h,f,d,a,o-i.A,a,o,w);return c+=t.fa,t.j+y<t.o?(r(e.ec,e.fc,u,c,w),r(e.cc,e.dc,l,h,N),r(e.Mc,e.Nc,f,d,N),n--):1&y||s(u,c,null,null,l,h,f,d,l,h,f,d,a,o+i.A,null,null,w),n}function ht(t,n,r){var i=t.F,a=[t.J];if(null!=i){var o=t.U,s=n.ba.S,u=s==Dr||s==Wr;n=n.ba.f.RGBA;var c=[0],l=t.ka;c[0]=t.T,t.Kb&&(0==l?--c[0]:(--l,a[0]-=t.width),t.j+t.ka+t.T==t.o&&(c[0]=t.o-t.j-l));var h=n.eb;l=n.fb+l*n.A,t=Ar(i,a[0],t.width,o,c,h,l+(u?0:3),n.A),e(r==c),t&&rt(s)&&Lr(h,l,u,o,c,n.A)}return 0}function ft(t){var e=t.ma,n=e.ba.S,r=11>n,i=n==qr||n==Rr||n==Dr||n==Tr||12==n||rt(n);if(e.memory=null,e.Ib=null,e.Jb=null,e.Nd=null,!Mn(e.Oa,t,i?11:12))return 0;if(i&&rt(n)&&bn(),t.da)alert("todo:use_scaling");else{if(r){if(e.Ib=ct,t.Kb){if(n=t.U+1>>1,e.memory=a(t.U+2*n),null==e.memory)return 0;e.ec=e.memory,e.fc=0,e.cc=e.ec,e.dc=e.fc+t.U,e.Mc=e.cc,e.Nc=e.dc+n,e.Ib=lt,bn()}}else alert("todo:EmitYUV");i&&(e.Jb=ht,r&&mn())}if(r&&!Ii){for(t=0;256>t;++t)ji[t]=89858*(t-128)+Si>>Ai,Bi[t]=-22014*(t-128)+Si,Oi[t]=-45773*(t-128),Ci[t]=113618*(t-128)+Si>>Ai;for(t=_i;t<Pi;++t)e=76283*(t-16)+Si>>Ai,Mi[t-_i]=Vt(e,255),qi[t-_i]=Vt(e+8>>4,15);Ii=1}return 1}function dt(t){var n=t.ma,r=t.U,i=t.T;return e(!(1&t.ka)),0>=r||0>=i?0:(r=n.Ib(t,n),null!=n.Jb&&n.Jb(t,n,r),n.Dc+=r,1)}function pt(t){t.ma.memory=null}function gt(t,e,n,r){return 47!=y(t,8)?0:(e[0]=y(t,14)+1,n[0]=y(t,14)+1,r[0]=y(t,1),0!=y(t,3)?0:!t.h)}function mt(t,e){if(4>t)return t+1;var n=t-2>>1;return(2+(1&t)<<n)+y(e,n)+1}function vt(t,e){return 120<e?e-120:1<=(n=((n=Zr[e-1])>>4)*t+(8-(15&n)))?n:1;var n}function bt(t,e,n){var r=L(n),i=t[e+=255&r].g-8;return 0<i&&(A(n,n.u+8),r=L(n),e+=t[e].value,e+=r&(1<<i)-1),A(n,n.u+t[e].g),t[e].value}function yt(t,n,r){return r.g+=t.g,r.value+=t.value<<n>>>0,e(8>=r.g),t.g}function wt(t,n,r){var i=t.xc;return e((n=0==i?0:t.vc[t.md*(r>>i)+(n>>i)])<t.Wb),t.Ya[n]}function Nt(t,n,i,a){var o=t.ab,s=t.c*n,u=t.C;n=u+n;var c=i,l=a;for(a=t.Ta,i=t.Ua;0<o--;){var h=t.gc[o],f=u,d=n,p=c,g=l,m=(l=a,c=i,h.Ea);switch(e(f<d),e(d<=h.nc),h.hc){case 2:Gn(p,g,(d-f)*m,l,c);break;case 0:var v=f,b=d,y=l,w=c,N=(_=h).Ea;0==v&&(Wn(p,g,null,null,1,y,w),V(p,g+1,0,0,N-1,y,w+1),g+=N,w+=N,++v);for(var L=1<<_.b,x=L-1,A=E(N,_.b),S=_.K,_=_.w+(v>>_.b)*A;v<b;){var P=S,k=_,F=1;for(Vn(p,g,y,w-N,1,y,w);F<N;){var I=(F&~x)+L;I>N&&(I=N),(0,Zn[P[k++]>>8&15])(p,g+ +F,y,w+F-N,I-F,y,w+F),F=I}g+=N,w+=N,++v&x||(_+=A)}d!=h.nc&&r(l,c-m,l,c+(d-f-1)*m,m);break;case 1:for(m=p,b=g,N=(p=h.Ea)-(w=p&~(y=(g=1<<h.b)-1)),v=E(p,h.b),L=h.K,h=h.w+(f>>h.b)*v;f<d;){for(x=L,A=h,S=new T,_=b+w,P=b+p;b<_;)Y(x[A++],S),$n(S,m,b,g,l,c),b+=g,c+=g;b<P&&(Y(x[A++],S),$n(S,m,b,N,l,c),b+=N,c+=N),++f&y||(h+=v)}break;case 3:if(p==l&&g==c&&0<h.b){for(b=l,p=m=c+(d-f)*m-(w=(d-f)*E(h.Ea,h.b)),g=l,y=c,v=[],w=(N=w)-1;0<=w;--w)v[w]=g[y+w];for(w=N-1;0<=w;--w)b[p+w]=v[w];Yn(h,f,d,l,m,l,c)}else Yn(h,f,d,p,g,l,c)}c=a,l=i}l!=i&&r(a,i,c,l,s)}function Lt(t,n){var r=t.V,i=t.Ba+t.c*t.C,a=n-t.C;if(e(n<=t.l.o),e(16>=a),0<a){var o=t.l,s=t.Ta,u=t.Ua,c=o.width;if(Nt(t,a,r,i),a=u=[u],e((r=t.C)<(i=n)),e(o.v<o.va),i>o.o&&(i=o.o),r<o.j){var l=o.j-r;r=o.j,a[0]+=l*c}if(r>=i?r=0:(a[0]+=4*o.v,o.ka=r-o.j,o.U=o.va-o.v,o.T=i-r,r=1),r){if(u=u[0],11>(r=t.ca).S){var h=r.f.RGBA,f=(i=r.S,a=o.U,o=o.T,l=h.eb,h.A),d=o;for(h=h.fb+t.Ma*h.A;0<d--;){var p=s,g=u,m=a,v=l,b=h;switch(i){case Mr:Qn(p,g,m,v,b);break;case qr:tr(p,g,m,v,b);break;case Ur:tr(p,g,m,v,b),Lr(v,b,0,m,1,0);break;case Er:rr(p,g,m,v,b);break;case Rr:et(p,g,m,v,b,1);break;case Hr:et(p,g,m,v,b,1),Lr(v,b,0,m,1,0);break;case Dr:et(p,g,m,v,b,0);break;case Wr:et(p,g,m,v,b,0),Lr(v,b,1,m,1,0);break;case Tr:er(p,g,m,v,b);break;case Vr:er(p,g,m,v,b),xr(v,b,m,1,0);break;case zr:nr(p,g,m,v,b);break;default:e(0)}u+=c,h+=f}t.Ma+=o}else alert("todo:EmitRescaledRowsYUVA");e(t.Ma<=r.height)}}t.C=n,e(t.C<=t.i)}function xt(t){var e;if(0<t.ua)return 0;for(e=0;e<t.Wb;++e){var n=t.Ya[e].G,r=t.Ya[e].H;if(0<n[1][r[1]+0].g||0<n[2][r[2]+0].g||0<n[3][r[3]+0].g)return 0}return 1}function At(t,n,r,i,a,o){if(0!=t.Z){var s=t.qd,u=t.rd;for(e(null!=gi[t.Z]);n<r;++n)gi[t.Z](s,u,i,a,i,a,o),s=i,u=a,a+=o;t.qd=s,t.rd=u}}function St(t,n){var r=t.l.ma,i=0==r.Z||1==r.Z?t.l.j:t.C;if(i=t.C<i?i:t.C,e(n<=t.l.o),n>i){var a=t.l.width,o=r.ca,s=r.tb+a*i,u=t.V,c=t.Ba+t.c*i,l=t.gc;e(1==t.ab),e(3==l[0].hc),Xn(l[0],i,n,u,c,o,s),At(r,i,n,o,s,a)}t.C=t.Ma=n}function _t(t,n,r,i,a,o,s){var u=t.$/i,c=t.$%i,l=t.m,h=t.s,f=r+t.$,d=f;a=r+i*a;var p=r+i*o,g=280+h.ua,m=t.Pb?u:16777216,v=0<h.ua?h.Wa:null,b=h.wc,y=f<p?wt(h,c,u):null;e(t.C<o),e(p<=a);var w=!1;t:for(;;){for(;w||f<p;){var N=0;if(u>=m){var _=f-r;e((m=t).Pb),m.wd=m.m,m.xd=_,0<m.s.ua&&B(m.s.Wa,m.s.vb),m=u+Qr}if(c&b||(y=wt(h,c,u)),e(null!=y),y.Qb&&(n[f]=y.qb,w=!0),!w)if(S(l),y.jc){N=l,_=n;var P=f,k=y.pd[L(N)&Rn-1];e(y.jc),256>k.g?(A(N,N.u+k.g),_[P]=k.value,N=0):(A(N,N.u+k.g-256),e(256<=k.value),N=k.value),0==N&&(w=!0)}else N=bt(y.G[0],y.H[0],l);if(l.h)break;if(w||256>N){if(!w)if(y.nd)n[f]=(y.qb|N<<8)>>>0;else{if(S(l),w=bt(y.G[1],y.H[1],l),S(l),_=bt(y.G[2],y.H[2],l),P=bt(y.G[3],y.H[3],l),l.h)break;n[f]=(P<<24|w<<16|N<<8|_)>>>0}if(w=!1,++f,++c>=i&&(c=0,++u,null!=s&&u<=o&&!(u%16)&&s(t,u),null!=v))for(;d<f;)N=n[d++],v.X[(506832829*N&4294967295)>>>v.Mb]=N}else if(280>N){if(N=mt(N-256,l),_=bt(y.G[4],y.H[4],l),S(l),_=vt(i,_=mt(_,l)),l.h)break;if(f-r<_||a-f<N)break t;for(P=0;P<N;++P)n[f+P]=n[f+P-_];for(f+=N,c+=N;c>=i;)c-=i,++u,null!=s&&u<=o&&!(u%16)&&s(t,u);if(e(f<=a),c&b&&(y=wt(h,c,u)),null!=v)for(;d<f;)N=n[d++],v.X[(506832829*N&4294967295)>>>v.Mb]=N}else{if(!(N<g))break t;for(w=N-280,e(null!=v);d<f;)N=n[d++],v.X[(506832829*N&4294967295)>>>v.Mb]=N;N=f,e(!(w>>>(_=v).Xa)),n[N]=_.X[w],w=!0}w||e(l.h==x(l))}if(t.Pb&&l.h&&f<a)e(t.m.h),t.a=5,t.m=t.wd,t.$=t.xd,0<t.s.ua&&B(t.s.vb,t.s.Wa);else{if(l.h)break t;null!=s&&s(t,u>o?o:u),t.a=0,t.$=f-r}return 1}return t.a=3,0}function Pt(t){e(null!=t),t.vc=null,t.yc=null,t.Ya=null;var n=t.Wa;null!=n&&(n.X=null),t.vb=null,e(null!=t)}function kt(){var e=new on;return null==e?null:(e.a=0,e.xb=pi,nt("Predictor","VP8LPredictors"),nt("Predictor","VP8LPredictors_C"),nt("PredictorAdd","VP8LPredictorsAdd"),nt("PredictorAdd","VP8LPredictorsAdd_C"),Gn=G,$n=J,Qn=K,tr=Z,er=$,nr=Q,rr=tt,t.VP8LMapColor32b=Jn,t.VP8LMapColor8b=Kn,e)}function Ft(t,n,r,s,u){var c=1,f=[t],p=[n],g=s.m,m=s.s,v=null,b=0;t:for(;;){if(r)for(;c&&y(g,1);){var w=f,N=p,x=s,_=1,P=x.m,k=x.gc[x.ab],F=y(P,2);if(x.Oc&1<<F)c=0;else{switch(x.Oc|=1<<F,k.hc=F,k.Ea=w[0],k.nc=N[0],k.K=[null],++x.ab,e(4>=x.ab),F){case 0:case 1:k.b=y(P,3)+2,_=Ft(E(k.Ea,k.b),E(k.nc,k.b),0,x,k.K),k.K=k.K[0];break;case 3:var I,j=y(P,8)+1,C=16<j?0:4<j?1:2<j?2:3;if(w[0]=E(k.Ea,C),k.b=C,I=_=Ft(j,1,0,x,k.K)){var B,M=j,q=k,D=1<<(8>>q.b),T=a(D);if(null==T)I=0;else{var z=q.K[0],U=q.w;for(T[0]=q.K[0][0],B=1;B<1*M;++B)T[B]=R(z[U+B],T[B-1]);for(;B<4*D;++B)T[B]=0;q.K[0]=null,q.K[0]=T,I=1}}_=I;break;case 2:break;default:e(0)}c=_}}if(f=f[0],p=p[0],c&&y(g,1)&&!(c=1<=(b=y(g,4))&&11>=b)){s.a=3;break t}var H;if(H=c)e:{var W,V,G,Y=s,J=f,X=p,K=b,Z=r,$=Y.m,Q=Y.s,tt=[null],et=1,nt=0,rt=$r[K];n:for(;;){if(Z&&y($,1)){var it=y($,3)+2,at=E(J,it),ot=E(X,it),st=at*ot;if(!Ft(at,ot,0,Y,tt))break n;for(tt=tt[0],Q.xc=it,W=0;W<st;++W){var ut=tt[W]>>8&65535;tt[W]=ut,ut>=et&&(et=ut+1)}}if($.h)break n;for(V=0;5>V;++V){var ct=Jr[V];!V&&0<K&&(ct+=1<<K),nt<ct&&(nt=ct)}var lt=o(et*rt,h),ht=et,ft=o(ht,d);if(null==ft)var dt=null;else e(65536>=ht),dt=ft;var pt=a(nt);if(null==dt||null==pt||null==lt){Y.a=1;break n}var gt=lt;for(W=G=0;W<et;++W){var mt=dt[W],vt=mt.G,bt=mt.H,wt=0,Nt=1,Lt=0;for(V=0;5>V;++V){ct=Jr[V],vt[V]=gt,bt[V]=G,!V&&0<K&&(ct+=1<<K);r:{var xt,At=ct,St=Y,kt=pt,It=gt,jt=G,Ct=0,Ot=St.m,Bt=y(Ot,1);if(i(kt,0,0,At),Bt){var Mt=y(Ot,1)+1,qt=y(Ot,1),Et=y(Ot,0==qt?1:8);kt[Et]=1,2==Mt&&(kt[Et=y(Ot,8)]=1);var Rt=1}else{var Dt=a(19),Tt=y(Ot,4)+4;if(19<Tt){St.a=3;var zt=0;break r}for(xt=0;xt<Tt;++xt)Dt[Kr[xt]]=y(Ot,3);var Ut=void 0,Ht=void 0,Wt=St,Vt=Dt,Gt=At,Yt=kt,Jt=0,Xt=Wt.m,Kt=8,Zt=o(128,h);i:for(;l(Zt,0,7,Vt,19);){if(y(Xt,1)){var $t=2+2*y(Xt,3);if((Ut=2+y(Xt,$t))>Gt)break i}else Ut=Gt;for(Ht=0;Ht<Gt&&Ut--;){S(Xt);var Qt=Zt[0+(127&L(Xt))];A(Xt,Xt.u+Qt.g);var te=Qt.value;if(16>te)Yt[Ht++]=te,0!=te&&(Kt=te);else{var ee=16==te,ne=te-16,re=Yr[ne],ie=y(Xt,Gr[ne])+re;if(Ht+ie>Gt)break i;for(var ae=ee?Kt:0;0<ie--;)Yt[Ht++]=ae}}Jt=1;break i}Jt||(Wt.a=3),Rt=Jt}(Rt=Rt&&!Ot.h)&&(Ct=l(It,jt,8,kt,At)),Rt&&0!=Ct?zt=Ct:(St.a=3,zt=0)}if(0==zt)break n;if(Nt&&1==Xr[V]&&(Nt=0==gt[G].g),wt+=gt[G].g,G+=zt,3>=V){var oe,se=pt[0];for(oe=1;oe<ct;++oe)pt[oe]>se&&(se=pt[oe]);Lt+=se}}if(mt.nd=Nt,mt.Qb=0,Nt&&(mt.qb=(vt[3][bt[3]+0].value<<24|vt[1][bt[1]+0].value<<16|vt[2][bt[2]+0].value)>>>0,0==wt&&256>vt[0][bt[0]+0].value&&(mt.Qb=1,mt.qb+=vt[0][bt[0]+0].value<<8)),mt.jc=!mt.Qb&&6>Lt,mt.jc){var ue,ce=mt;for(ue=0;ue<Rn;++ue){var le=ue,he=ce.pd[le],fe=ce.G[0][ce.H[0]+le];256<=fe.value?(he.g=fe.g+256,he.value=fe.value):(he.g=0,he.value=0,le>>=yt(fe,8,he),le>>=yt(ce.G[1][ce.H[1]+le],16,he),le>>=yt(ce.G[2][ce.H[2]+le],0,he),yt(ce.G[3][ce.H[3]+le],24,he))}}}Q.vc=tt,Q.Wb=et,Q.Ya=dt,Q.yc=lt,H=1;break e}H=0}if(!(c=H)){s.a=3;break t}if(0<b){if(m.ua=1<<b,!O(m.Wa,b)){s.a=1,c=0;break t}}else m.ua=0;var de=s,pe=f,ge=p,me=de.s,ve=me.xc;if(de.c=pe,de.i=ge,me.md=E(pe,ve),me.wc=0==ve?-1:(1<<ve)-1,r){s.xb=di;break t}if(null==(v=a(f*p))){s.a=1,c=0;break t}c=(c=_t(s,v,0,f,p,p,null))&&!g.h;break t}return c?(null!=u?u[0]=v:(e(null==v),e(r)),s.$=0,r||Pt(m)):Pt(m),c}function It(t,n){var r=t.c*t.i,i=r+n+16*n;return e(t.c<=n),t.V=a(i),null==t.V?(t.Ta=null,t.Ua=0,t.a=1,0):(t.Ta=t.V,t.Ua=t.Ba+r+n,1)}function jt(t,n){var r=t.C,i=n-r,a=t.V,o=t.Ba+t.c*r;for(e(n<=t.l.o);0<i;){var s=16<i?16:i,u=t.l.ma,c=t.l.width,l=c*s,h=u.ca,f=u.tb+c*r,d=t.Ta,p=t.Ua;Nt(t,s,a,o),Sr(d,p,h,f,l),At(u,r,r+s,h,f,c),i-=s,a+=s*t.c,r+=s}e(r==n),t.C=t.Ma=n}function Ct(){this.ub=this.yd=this.td=this.Rb=0}function Ot(){this.Kd=this.Ld=this.Ud=this.Td=this.i=this.c=0}function Bt(){this.Fb=this.Bb=this.Cb=0,this.Zb=a(4),this.Lb=a(4)}function Mt(){this.Yb=function(){var t=[];return function t(e,n,r){for(var i=r[n],a=0;a<i&&(e.push(r.length>n+1?[]:0),!(r.length<n+1));a++)t(e[a],n+1,r)}(t,0,[3,11]),t}()}function qt(){this.jb=a(3),this.Wc=s([4,8],Mt),this.Xc=s([4,17],Mt)}function Et(){this.Pc=this.wb=this.Tb=this.zd=0,this.vd=new a(4),this.od=new a(4)}function Rt(){this.ld=this.La=this.dd=this.tc=0}function Dt(){this.Na=this.la=0}function Tt(){this.Sc=[0,0],this.Eb=[0,0],this.Qc=[0,0],this.ia=this.lc=0}function zt(){this.ad=a(384),this.Za=0,this.Ob=a(16),this.$b=this.Ad=this.ia=this.Gc=this.Hc=this.Dd=0}function Ut(){this.uc=this.M=this.Nb=0,this.wa=Array(new Rt),this.Y=0,this.ya=Array(new zt),this.aa=0,this.l=new Gt}function Ht(){this.y=a(16),this.f=a(8),this.ea=a(8)}function Wt(){this.cb=this.a=0,this.sc="",this.m=new w,this.Od=new Ct,this.Kc=new Ot,this.ed=new Et,this.Qa=new Bt,this.Ic=this.$c=this.Aa=0,this.D=new Ut,this.Xb=this.Va=this.Hb=this.zb=this.yb=this.Ub=this.za=0,this.Jc=o(8,w),this.ia=0,this.pb=o(4,Tt),this.Pa=new qt,this.Bd=this.kc=0,this.Ac=[],this.Bc=0,this.zc=[0,0,0,0],this.Gd=Array(new Ht),this.Hd=0,this.rb=Array(new Dt),this.sb=0,this.wa=Array(new Rt),this.Y=0,this.oc=[],this.pc=0,this.sa=[],this.ta=0,this.qa=[],this.ra=0,this.Ha=[],this.B=this.R=this.Ia=0,this.Ec=[],this.M=this.ja=this.Vb=this.Fc=0,this.ya=Array(new zt),this.L=this.aa=0,this.gd=s([4,2],Rt),this.ga=null,this.Fa=[],this.Cc=this.qc=this.P=0,this.Gb=[],this.Uc=0,this.mb=[],this.nb=0,this.rc=[],this.Ga=this.Vc=0}function Vt(t,e){return 0>t?0:t>e?e:t}function Gt(){this.T=this.U=this.ka=this.height=this.width=0,this.y=[],this.f=[],this.ea=[],this.Rc=this.fa=this.W=this.N=this.O=0,this.ma="void",this.put="VP8IoPutHook",this.ac="VP8IoSetupHook",this.bc="VP8IoTeardownHook",this.ha=this.Kb=0,this.data=[],this.hb=this.ib=this.da=this.o=this.j=this.va=this.v=this.Da=this.ob=this.w=0,this.F=[],this.J=0}function Yt(){var t=new Wt;return null!=t&&(t.a=0,t.sc="OK",t.cb=0,t.Xb=0,ni||(ni=Zt)),t}function Jt(t,e,n){return 0==t.a&&(t.a=e,t.sc=n,t.cb=0),0}function Xt(t,e,n){return 3<=n&&157==t[e+0]&&1==t[e+1]&&42==t[e+2]}function Kt(t,n){if(null==t)return 0;if(t.a=0,t.sc="OK",null==n)return Jt(t,2,"null VP8Io passed to VP8GetHeaders()");var r=n.data,a=n.w,o=n.ha;if(4>o)return Jt(t,7,"Truncated header.");var s=r[a+0]|r[a+1]<<8|r[a+2]<<16,u=t.Od;if(u.Rb=!(1&s),u.td=s>>1&7,u.yd=s>>4&1,u.ub=s>>5,3<u.td)return Jt(t,3,"Incorrect keyframe parameters.");if(!u.yd)return Jt(t,4,"Frame not displayable.");a+=3,o-=3;var c=t.Kc;if(u.Rb){if(7>o)return Jt(t,7,"cannot parse picture header");if(!Xt(r,a,o))return Jt(t,3,"Bad code word");c.c=16383&(r[a+4]<<8|r[a+3]),c.Td=r[a+4]>>6,c.i=16383&(r[a+6]<<8|r[a+5]),c.Ud=r[a+6]>>6,a+=7,o-=7,t.za=c.c+15>>4,t.Ub=c.i+15>>4,n.width=c.c,n.height=c.i,n.Da=0,n.j=0,n.v=0,n.va=n.width,n.o=n.height,n.da=0,n.ib=n.width,n.hb=n.height,n.U=n.width,n.T=n.height,i((s=t.Pa).jb,0,255,s.jb.length),e(null!=(s=t.Qa)),s.Cb=0,s.Bb=0,s.Fb=1,i(s.Zb,0,0,s.Zb.length),i(s.Lb,0,0,s.Lb)}if(u.ub>o)return Jt(t,7,"bad partition length");p(s=t.m,r,a,u.ub),a+=u.ub,o-=u.ub,u.Rb&&(c.Ld=P(s),c.Kd=P(s)),c=t.Qa;var l,h=t.Pa;if(e(null!=s),e(null!=c),c.Cb=P(s),c.Cb){if(c.Bb=P(s),P(s)){for(c.Fb=P(s),l=0;4>l;++l)c.Zb[l]=P(s)?m(s,7):0;for(l=0;4>l;++l)c.Lb[l]=P(s)?m(s,6):0}if(c.Bb)for(l=0;3>l;++l)h.jb[l]=P(s)?g(s,8):255}else c.Bb=0;if(s.Ka)return Jt(t,3,"cannot parse segment header");if((c=t.ed).zd=P(s),c.Tb=g(s,6),c.wb=g(s,3),c.Pc=P(s),c.Pc&&P(s)){for(h=0;4>h;++h)P(s)&&(c.vd[h]=m(s,6));for(h=0;4>h;++h)P(s)&&(c.od[h]=m(s,6))}if(t.L=0==c.Tb?0:c.zd?1:2,s.Ka)return Jt(t,3,"cannot parse filter header");var f=o;if(o=l=a,a=l+f,c=f,t.Xb=(1<<g(t.m,2))-1,f<3*(h=t.Xb))r=7;else{for(l+=3*h,c-=3*h,f=0;f<h;++f){var d=r[o+0]|r[o+1]<<8|r[o+2]<<16;d>c&&(d=c),p(t.Jc[+f],r,l,d),l+=d,c-=d,o+=3}p(t.Jc[+h],r,l,c),r=l<a?0:5}if(0!=r)return Jt(t,r,"cannot parse partitions");for(r=g(l=t.m,7),o=P(l)?m(l,4):0,a=P(l)?m(l,4):0,c=P(l)?m(l,4):0,h=P(l)?m(l,4):0,l=P(l)?m(l,4):0,f=t.Qa,d=0;4>d;++d){if(f.Cb){var v=f.Zb[d];f.Fb||(v+=r)}else{if(0<d){t.pb[d]=t.pb[0];continue}v=r}var b=t.pb[d];b.Sc[0]=ti[Vt(v+o,127)],b.Sc[1]=ei[Vt(v+0,127)],b.Eb[0]=2*ti[Vt(v+a,127)],b.Eb[1]=101581*ei[Vt(v+c,127)]>>16,8>b.Eb[1]&&(b.Eb[1]=8),b.Qc[0]=ti[Vt(v+h,117)],b.Qc[1]=ei[Vt(v+l,127)],b.lc=v+l}if(!u.Rb)return Jt(t,4,"Not a key frame.");for(P(s),u=t.Pa,r=0;4>r;++r){for(o=0;8>o;++o)for(a=0;3>a;++a)for(c=0;11>c;++c)h=k(s,ui[r][o][a][c])?g(s,8):oi[r][o][a][c],u.Wc[r][o].Yb[a][c]=h;for(o=0;17>o;++o)u.Xc[r][o]=u.Wc[r][ci[o]]}return t.kc=P(s),t.kc&&(t.Bd=g(s,8)),t.cb=1}function Zt(t,e,n,r,i,a,o){var s=e[i].Yb[n];for(n=0;16>i;++i){if(!k(t,s[n+0]))return i;for(;!k(t,s[n+1]);)if(s=e[++i].Yb[0],n=0,16==i)return 16;var u=e[i+1].Yb;if(k(t,s[n+2])){var c=t,l=0;if(k(c,(f=s)[(h=n)+3]))if(k(c,f[h+6])){for(s=0,h=2*(l=k(c,f[h+8]))+(f=k(c,f[h+9+l])),l=0,f=ri[h];f[s];++s)l+=l+k(c,f[s]);l+=3+(8<<h)}else k(c,f[h+7])?(l=7+2*k(c,165),l+=k(c,145)):l=5+k(c,159);else l=k(c,f[h+4])?3+k(c,f[h+5]):2;s=u[2]}else l=1,s=u[1];u=o+ii[i],0>(c=t).b&&_(c);var h,f=c.b,d=(h=c.Ca>>1)-(c.I>>f)>>31;--c.b,c.Ca+=d,c.Ca|=1,c.I-=(h+1&d)<<f,a[u]=((l^d)-d)*r[(0<i)+0]}return 16}function $t(t){var e=t.rb[t.sb-1];e.la=0,e.Na=0,i(t.zc,0,0,t.zc.length),t.ja=0}function Qt(t,e,n,r,i){i=t[e+n+32*r]+(i>>3),t[e+n+32*r]=-256&i?0>i?0:255:i}function te(t,e,n,r,i,a){Qt(t,e,0,n,r+i),Qt(t,e,1,n,r+a),Qt(t,e,2,n,r-a),Qt(t,e,3,n,r-i)}function ee(t){return(20091*t>>16)+t}function ne(t,e,n,r){var i,o=0,s=a(16);for(i=0;4>i;++i){var u=t[e+0]+t[e+8],c=t[e+0]-t[e+8],l=(35468*t[e+4]>>16)-ee(t[e+12]),h=ee(t[e+4])+(35468*t[e+12]>>16);s[o+0]=u+h,s[o+1]=c+l,s[o+2]=c-l,s[o+3]=u-h,o+=4,e++}for(i=o=0;4>i;++i)u=(t=s[o+0]+4)+s[o+8],c=t-s[o+8],l=(35468*s[o+4]>>16)-ee(s[o+12]),Qt(n,r,0,0,u+(h=ee(s[o+4])+(35468*s[o+12]>>16))),Qt(n,r,1,0,c+l),Qt(n,r,2,0,c-l),Qt(n,r,3,0,u-h),o++,r+=32}function re(t,e,n,r){var i=t[e+0]+4,a=35468*t[e+4]>>16,o=ee(t[e+4]),s=35468*t[e+1]>>16;te(n,r,0,i+o,t=ee(t[e+1]),s),te(n,r,1,i+a,t,s),te(n,r,2,i-a,t,s),te(n,r,3,i-o,t,s)}function ie(t,e,n,r,i){ne(t,e,n,r),i&&ne(t,e+16,n,r+4)}function ae(t,e,n,r){ar(t,e+0,n,r,1),ar(t,e+32,n,r+128,1)}function oe(t,e,n,r){var i;for(t=t[e+0]+4,i=0;4>i;++i)for(e=0;4>e;++e)Qt(n,r,e,i,t)}function se(t,e,n,r){t[e+0]&&ur(t,e+0,n,r),t[e+16]&&ur(t,e+16,n,r+4),t[e+32]&&ur(t,e+32,n,r+128),t[e+48]&&ur(t,e+48,n,r+128+4)}function ue(t,e,n,r){var i,o=a(16);for(i=0;4>i;++i){var s=t[e+0+i]+t[e+12+i],u=t[e+4+i]+t[e+8+i],c=t[e+4+i]-t[e+8+i],l=t[e+0+i]-t[e+12+i];o[0+i]=s+u,o[8+i]=s-u,o[4+i]=l+c,o[12+i]=l-c}for(i=0;4>i;++i)s=(t=o[0+4*i]+3)+o[3+4*i],u=o[1+4*i]+o[2+4*i],c=o[1+4*i]-o[2+4*i],l=t-o[3+4*i],n[r+0]=s+u>>3,n[r+16]=l+c>>3,n[r+32]=s-u>>3,n[r+48]=l-c>>3,r+=64}function ce(t,e,n){var r,i=e-32,a=Or,o=255-t[i-1];for(r=0;r<n;++r){var s,u=a,c=o+t[e-1];for(s=0;s<n;++s)t[e+s]=u[c+t[i+s]];e+=32}}function le(t,e){ce(t,e,4)}function he(t,e){ce(t,e,8)}function fe(t,e){ce(t,e,16)}function de(t,e){var n;for(n=0;16>n;++n)r(t,e+32*n,t,e-32,16)}function pe(t,e){var n;for(n=16;0<n;--n)i(t,e,t[e-1],16),e+=32}function ge(t,e,n){var r;for(r=0;16>r;++r)i(e,n+32*r,t,16)}function me(t,e){var n,r=16;for(n=0;16>n;++n)r+=t[e-1+32*n]+t[e+n-32];ge(r>>5,t,e)}function ve(t,e){var n,r=8;for(n=0;16>n;++n)r+=t[e-1+32*n];ge(r>>4,t,e)}function be(t,e){var n,r=8;for(n=0;16>n;++n)r+=t[e+n-32];ge(r>>4,t,e)}function ye(t,e){ge(128,t,e)}function we(t,e,n){return t+2*e+n+2>>2}function Ne(t,e){var n,i=e-32;for(i=new Uint8Array([we(t[i-1],t[i+0],t[i+1]),we(t[i+0],t[i+1],t[i+2]),we(t[i+1],t[i+2],t[i+3]),we(t[i+2],t[i+3],t[i+4])]),n=0;4>n;++n)r(t,e+32*n,i,0,i.length)}function Le(t,e){var n=t[e-1],r=t[e-1+32],i=t[e-1+64],a=t[e-1+96];F(t,e+0,16843009*we(t[e-1-32],n,r)),F(t,e+32,16843009*we(n,r,i)),F(t,e+64,16843009*we(r,i,a)),F(t,e+96,16843009*we(i,a,a))}function xe(t,e){var n,r=4;for(n=0;4>n;++n)r+=t[e+n-32]+t[e-1+32*n];for(r>>=3,n=0;4>n;++n)i(t,e+32*n,r,4)}function Ae(t,e){var n=t[e-1+0],r=t[e-1+32],i=t[e-1+64],a=t[e-1-32],o=t[e+0-32],s=t[e+1-32],u=t[e+2-32],c=t[e+3-32];t[e+0+96]=we(r,i,t[e-1+96]),t[e+1+96]=t[e+0+64]=we(n,r,i),t[e+2+96]=t[e+1+64]=t[e+0+32]=we(a,n,r),t[e+3+96]=t[e+2+64]=t[e+1+32]=t[e+0+0]=we(o,a,n),t[e+3+64]=t[e+2+32]=t[e+1+0]=we(s,o,a),t[e+3+32]=t[e+2+0]=we(u,s,o),t[e+3+0]=we(c,u,s)}function Se(t,e){var n=t[e+1-32],r=t[e+2-32],i=t[e+3-32],a=t[e+4-32],o=t[e+5-32],s=t[e+6-32],u=t[e+7-32];t[e+0+0]=we(t[e+0-32],n,r),t[e+1+0]=t[e+0+32]=we(n,r,i),t[e+2+0]=t[e+1+32]=t[e+0+64]=we(r,i,a),t[e+3+0]=t[e+2+32]=t[e+1+64]=t[e+0+96]=we(i,a,o),t[e+3+32]=t[e+2+64]=t[e+1+96]=we(a,o,s),t[e+3+64]=t[e+2+96]=we(o,s,u),t[e+3+96]=we(s,u,u)}function _e(t,e){var n=t[e-1+0],r=t[e-1+32],i=t[e-1+64],a=t[e-1-32],o=t[e+0-32],s=t[e+1-32],u=t[e+2-32],c=t[e+3-32];t[e+0+0]=t[e+1+64]=a+o+1>>1,t[e+1+0]=t[e+2+64]=o+s+1>>1,t[e+2+0]=t[e+3+64]=s+u+1>>1,t[e+3+0]=u+c+1>>1,t[e+0+96]=we(i,r,n),t[e+0+64]=we(r,n,a),t[e+0+32]=t[e+1+96]=we(n,a,o),t[e+1+32]=t[e+2+96]=we(a,o,s),t[e+2+32]=t[e+3+96]=we(o,s,u),t[e+3+32]=we(s,u,c)}function Pe(t,e){var n=t[e+0-32],r=t[e+1-32],i=t[e+2-32],a=t[e+3-32],o=t[e+4-32],s=t[e+5-32],u=t[e+6-32],c=t[e+7-32];t[e+0+0]=n+r+1>>1,t[e+1+0]=t[e+0+64]=r+i+1>>1,t[e+2+0]=t[e+1+64]=i+a+1>>1,t[e+3+0]=t[e+2+64]=a+o+1>>1,t[e+0+32]=we(n,r,i),t[e+1+32]=t[e+0+96]=we(r,i,a),t[e+2+32]=t[e+1+96]=we(i,a,o),t[e+3+32]=t[e+2+96]=we(a,o,s),t[e+3+64]=we(o,s,u),t[e+3+96]=we(s,u,c)}function ke(t,e){var n=t[e-1+0],r=t[e-1+32],i=t[e-1+64],a=t[e-1+96];t[e+0+0]=n+r+1>>1,t[e+2+0]=t[e+0+32]=r+i+1>>1,t[e+2+32]=t[e+0+64]=i+a+1>>1,t[e+1+0]=we(n,r,i),t[e+3+0]=t[e+1+32]=we(r,i,a),t[e+3+32]=t[e+1+64]=we(i,a,a),t[e+3+64]=t[e+2+64]=t[e+0+96]=t[e+1+96]=t[e+2+96]=t[e+3+96]=a}function Fe(t,e){var n=t[e-1+0],r=t[e-1+32],i=t[e-1+64],a=t[e-1+96],o=t[e-1-32],s=t[e+0-32],u=t[e+1-32],c=t[e+2-32];t[e+0+0]=t[e+2+32]=n+o+1>>1,t[e+0+32]=t[e+2+64]=r+n+1>>1,t[e+0+64]=t[e+2+96]=i+r+1>>1,t[e+0+96]=a+i+1>>1,t[e+3+0]=we(s,u,c),t[e+2+0]=we(o,s,u),t[e+1+0]=t[e+3+32]=we(n,o,s),t[e+1+32]=t[e+3+64]=we(r,n,o),t[e+1+64]=t[e+3+96]=we(i,r,n),t[e+1+96]=we(a,i,r)}function Ie(t,e){var n;for(n=0;8>n;++n)r(t,e+32*n,t,e-32,8)}function je(t,e){var n;for(n=0;8>n;++n)i(t,e,t[e-1],8),e+=32}function Ce(t,e,n){var r;for(r=0;8>r;++r)i(e,n+32*r,t,8)}function Oe(t,e){var n,r=8;for(n=0;8>n;++n)r+=t[e+n-32]+t[e-1+32*n];Ce(r>>4,t,e)}function Be(t,e){var n,r=4;for(n=0;8>n;++n)r+=t[e+n-32];Ce(r>>3,t,e)}function Me(t,e){var n,r=4;for(n=0;8>n;++n)r+=t[e-1+32*n];Ce(r>>3,t,e)}function qe(t,e){Ce(128,t,e)}function Ee(t,e,n){var r=t[e-n],i=t[e+0],a=3*(i-r)+jr[1020+t[e-2*n]-t[e+n]],o=Cr[112+(a+4>>3)];t[e-n]=Or[255+r+Cr[112+(a+3>>3)]],t[e+0]=Or[255+i-o]}function Re(t,e,n,r){var i=t[e+0],a=t[e+n];return Br[255+t[e-2*n]-t[e-n]]>r||Br[255+a-i]>r}function De(t,e,n,r){return 4*Br[255+t[e-n]-t[e+0]]+Br[255+t[e-2*n]-t[e+n]]<=r}function Te(t,e,n,r,i){var a=t[e-3*n],o=t[e-2*n],s=t[e-n],u=t[e+0],c=t[e+n],l=t[e+2*n],h=t[e+3*n];return 4*Br[255+s-u]+Br[255+o-c]>r?0:Br[255+t[e-4*n]-a]<=i&&Br[255+a-o]<=i&&Br[255+o-s]<=i&&Br[255+h-l]<=i&&Br[255+l-c]<=i&&Br[255+c-u]<=i}function ze(t,e,n,r){var i=2*r+1;for(r=0;16>r;++r)De(t,e+r,n,i)&&Ee(t,e+r,n)}function Ue(t,e,n,r){var i=2*r+1;for(r=0;16>r;++r)De(t,e+r*n,1,i)&&Ee(t,e+r*n,1)}function He(t,e,n,r){var i;for(i=3;0<i;--i)ze(t,e+=4*n,n,r)}function We(t,e,n,r){var i;for(i=3;0<i;--i)Ue(t,e+=4,n,r)}function Ve(t,e,n,r,i,a,o,s){for(a=2*a+1;0<i--;){if(Te(t,e,n,a,o))if(Re(t,e,n,s))Ee(t,e,n);else{var u=t,c=e,l=n,h=u[c-2*l],f=u[c-l],d=u[c+0],p=u[c+l],g=u[c+2*l],m=27*(b=jr[1020+3*(d-f)+jr[1020+h-p]])+63>>7,v=18*b+63>>7,b=9*b+63>>7;u[c-3*l]=Or[255+u[c-3*l]+b],u[c-2*l]=Or[255+h+v],u[c-l]=Or[255+f+m],u[c+0]=Or[255+d-m],u[c+l]=Or[255+p-v],u[c+2*l]=Or[255+g-b]}e+=r}}function Ge(t,e,n,r,i,a,o,s){for(a=2*a+1;0<i--;){if(Te(t,e,n,a,o))if(Re(t,e,n,s))Ee(t,e,n);else{var u=t,c=e,l=n,h=u[c-l],f=u[c+0],d=u[c+l],p=Cr[112+(4+(g=3*(f-h))>>3)],g=Cr[112+(g+3>>3)],m=p+1>>1;u[c-2*l]=Or[255+u[c-2*l]+m],u[c-l]=Or[255+h+g],u[c+0]=Or[255+f-p],u[c+l]=Or[255+d-m]}e+=r}}function Ye(t,e,n,r,i,a){Ve(t,e,n,1,16,r,i,a)}function Je(t,e,n,r,i,a){Ve(t,e,1,n,16,r,i,a)}function Xe(t,e,n,r,i,a){var o;for(o=3;0<o;--o)Ge(t,e+=4*n,n,1,16,r,i,a)}function Ke(t,e,n,r,i,a){var o;for(o=3;0<o;--o)Ge(t,e+=4,1,n,16,r,i,a)}function Ze(t,e,n,r,i,a,o,s){Ve(t,e,i,1,8,a,o,s),Ve(n,r,i,1,8,a,o,s)}function $e(t,e,n,r,i,a,o,s){Ve(t,e,1,i,8,a,o,s),Ve(n,r,1,i,8,a,o,s)}function Qe(t,e,n,r,i,a,o,s){Ge(t,e+4*i,i,1,8,a,o,s),Ge(n,r+4*i,i,1,8,a,o,s)}function tn(t,e,n,r,i,a,o,s){Ge(t,e+4,1,i,8,a,o,s),Ge(n,r+4,1,i,8,a,o,s)}function en(){this.ba=new ot,this.ec=[],this.cc=[],this.Mc=[],this.Dc=this.Nc=this.dc=this.fc=0,this.Oa=new ut,this.memory=0,this.Ib="OutputFunc",this.Jb="OutputAlphaFunc",this.Nd="OutputRowFunc"}function nn(){this.data=[],this.offset=this.kd=this.ha=this.w=0,this.na=[],this.xa=this.gb=this.Ja=this.Sa=this.P=0}function rn(){this.nc=this.Ea=this.b=this.hc=0,this.K=[],this.w=0}function an(){this.ua=0,this.Wa=new M,this.vb=new M,this.md=this.xc=this.wc=0,this.vc=[],this.Wb=0,this.Ya=new d,this.yc=new h}function on(){this.xb=this.a=0,this.l=new Gt,this.ca=new ot,this.V=[],this.Ba=0,this.Ta=[],this.Ua=0,this.m=new N,this.Pb=0,this.wd=new N,this.Ma=this.$=this.C=this.i=this.c=this.xd=0,this.s=new an,this.ab=0,this.gc=o(4,rn),this.Oc=0}function sn(){this.Lc=this.Z=this.$a=this.i=this.c=0,this.l=new Gt,this.ic=0,this.ca=[],this.tb=0,this.qd=null,this.rd=0}function un(t,e,n,r,i,a,o){for(t=null==t?0:t[e+0],e=0;e<o;++e)i[a+e]=t+n[r+e]&255,t=i[a+e]}function cn(t,e,n,r,i,a,o){var s;if(null==t)un(null,null,n,r,i,a,o);else for(s=0;s<o;++s)i[a+s]=t[e+s]+n[r+s]&255}function ln(t,e,n,r,i,a,o){if(null==t)un(null,null,n,r,i,a,o);else{var s,u=t[e+0],c=u,l=u;for(s=0;s<o;++s)c=l+(u=t[e+s])-c,l=n[r+s]+(-256&c?0>c?0:255:c)&255,c=u,i[a+s]=l}}function hn(t,n,i,o){var s=n.width,u=n.o;if(e(null!=t&&null!=n),0>i||0>=o||i+o>u)return null;if(!t.Cc){if(null==t.ga){var c;if(t.ga=new sn,(c=null==t.ga)||(c=n.width*n.o,e(0==t.Gb.length),t.Gb=a(c),t.Uc=0,null==t.Gb?c=0:(t.mb=t.Gb,t.nb=t.Uc,t.rc=null,c=1),c=!c),!c){c=t.ga;var l=t.Fa,h=t.P,f=t.qc,d=t.mb,p=t.nb,g=h+1,m=f-1,b=c.l;if(e(null!=l&&null!=d&&null!=n),gi[0]=null,gi[1]=un,gi[2]=cn,gi[3]=ln,c.ca=d,c.tb=p,c.c=n.width,c.i=n.height,e(0<c.c&&0<c.i),1>=f)n=0;else if(c.$a=3&l[h+0],c.Z=l[h+0]>>2&3,c.Lc=l[h+0]>>4&3,h=l[h+0]>>6&3,0>c.$a||1<c.$a||4<=c.Z||1<c.Lc||h)n=0;else if(b.put=dt,b.ac=ft,b.bc=pt,b.ma=c,b.width=n.width,b.height=n.height,b.Da=n.Da,b.v=n.v,b.va=n.va,b.j=n.j,b.o=n.o,c.$a)t:{e(1==c.$a),n=kt();e:for(;;){if(null==n){n=0;break t}if(e(null!=c),c.mc=n,n.c=c.c,n.i=c.i,n.l=c.l,n.l.ma=c,n.l.width=c.c,n.l.height=c.i,n.a=0,v(n.m,l,g,m),!Ft(c.c,c.i,1,n,null))break e;if(1==n.ab&&3==n.gc[0].hc&&xt(n.s)?(c.ic=1,l=n.c*n.i,n.Ta=null,n.Ua=0,n.V=a(l),n.Ba=0,null==n.V?(n.a=1,n=0):n=1):(c.ic=0,n=It(n,c.c)),!n)break e;n=1;break t}c.mc=null,n=0}else n=m>=c.c*c.i;c=!n}if(c)return null;1!=t.ga.Lc?t.Ga=0:o=u-i}e(null!=t.ga),e(i+o<=u);t:{if(n=(l=t.ga).c,u=l.l.o,0==l.$a){if(g=t.rc,m=t.Vc,b=t.Fa,h=t.P+1+i*n,f=t.mb,d=t.nb+i*n,e(h<=t.P+t.qc),0!=l.Z)for(e(null!=gi[l.Z]),c=0;c<o;++c)gi[l.Z](g,m,b,h,f,d,n),g=f,m=d,d+=n,h+=n;else for(c=0;c<o;++c)r(f,d,b,h,n),g=f,m=d,d+=n,h+=n;t.rc=g,t.Vc=m}else{if(e(null!=l.mc),n=i+o,e(null!=(c=l.mc)),e(n<=c.i),c.C>=n)n=1;else if(l.ic||mn(),l.ic){l=c.V,g=c.Ba,m=c.c;var y=c.i,w=(b=1,h=c.$/m,f=c.$%m,d=c.m,p=c.s,c.$),N=m*y,L=m*n,A=p.wc,_=w<L?wt(p,f,h):null;e(w<=N),e(n<=y),e(xt(p));e:for(;;){for(;!d.h&&w<L;){if(f&A||(_=wt(p,f,h)),e(null!=_),S(d),256>(y=bt(_.G[0],_.H[0],d)))l[g+w]=y,++w,++f>=m&&(f=0,++h<=n&&!(h%16)&&St(c,h));else{if(!(280>y)){b=0;break e}y=mt(y-256,d);var P,k=bt(_.G[4],_.H[4],d);if(S(d),!(w>=(k=vt(m,k=mt(k,d)))&&N-w>=y)){b=0;break e}for(P=0;P<y;++P)l[g+w+P]=l[g+w+P-k];for(w+=y,f+=y;f>=m;)f-=m,++h<=n&&!(h%16)&&St(c,h);w<L&&f&A&&(_=wt(p,f,h))}e(d.h==x(d))}St(c,h>n?n:h);break e}!b||d.h&&w<N?(b=0,c.a=d.h?5:3):c.$=w,n=b}else n=_t(c,c.V,c.Ba,c.c,c.i,n,jt);if(!n){o=0;break t}}i+o>=u&&(t.Cc=1),o=1}if(!o)return null;if(t.Cc&&(null!=(o=t.ga)&&(o.mc=null),t.ga=null,0<t.Ga))return alert("todo:WebPDequantizeLevels"),null}return t.nb+i*s}function fn(t,e,n,r,i,a){for(;0<i--;){var o,s=t,u=e+(n?1:0),c=t,l=e+(n?0:3);for(o=0;o<r;++o){var h=c[l+4*o];255!=h&&(h*=32897,s[u+4*o+0]=s[u+4*o+0]*h>>23,s[u+4*o+1]=s[u+4*o+1]*h>>23,s[u+4*o+2]=s[u+4*o+2]*h>>23)}e+=a}}function dn(t,e,n,r,i){for(;0<r--;){var a;for(a=0;a<n;++a){var o=t[e+2*a+0],s=15&(c=t[e+2*a+1]),u=4369*s,c=(240&c|c>>4)*u>>16;t[e+2*a+0]=(240&o|o>>4)*u>>16&240|(15&o|o<<4)*u>>16>>4&15,t[e+2*a+1]=240&c|s}e+=i}}function pn(t,e,n,r,i,a,o,s){var u,c,l=255;for(c=0;c<i;++c){for(u=0;u<r;++u){var h=t[e+u];a[o+4*u]=h,l&=h}e+=n,o+=s}return 255!=l}function gn(t,e,n,r,i){var a;for(a=0;a<i;++a)n[r+a]=t[e+a]>>8}function mn(){Lr=fn,xr=dn,Ar=pn,Sr=gn}function vn(n,r,i){t[n]=function(t,n,a,o,s,u,c,l,h,f,d,p,g,m,v,b,y){var w,N=y-1>>1,L=s[u+0]|c[l+0]<<16,x=h[f+0]|d[p+0]<<16;e(null!=t);var A=3*L+x+131074>>2;for(r(t[n+0],255&A,A>>16,g,m),null!=a&&(A=3*x+L+131074>>2,r(a[o+0],255&A,A>>16,v,b)),w=1;w<=N;++w){var S=s[u+w]|c[l+w]<<16,_=h[f+w]|d[p+w]<<16,P=L+S+x+_+524296,k=P+2*(S+x)>>3;A=k+L>>1,L=(P=P+2*(L+_)>>3)+S>>1,r(t[n+2*w-1],255&A,A>>16,g,m+(2*w-1)*i),r(t[n+2*w-0],255&L,L>>16,g,m+(2*w-0)*i),null!=a&&(A=P+x>>1,L=k+_>>1,r(a[o+2*w-1],255&A,A>>16,v,b+(2*w-1)*i),r(a[o+2*w+0],255&L,L>>16,v,b+(2*w+0)*i)),L=S,x=_}1&y||(A=3*L+x+131074>>2,r(t[n+y-1],255&A,A>>16,g,m+(y-1)*i),null!=a&&(A=3*x+L+131074>>2,r(a[o+y-1],255&A,A>>16,v,b+(y-1)*i)))}}function bn(){mi[Mr]=vi,mi[qr]=yi,mi[Er]=bi,mi[Rr]=wi,mi[Dr]=Ni,mi[Tr]=Li,mi[zr]=xi,mi[Ur]=yi,mi[Hr]=wi,mi[Wr]=Ni,mi[Vr]=Li}function yn(t){return t&~Fi?0>t?0:255:t>>ki}function wn(t,e){return yn((19077*t>>8)+(26149*e>>8)-14234)}function Nn(t,e,n){return yn((19077*t>>8)-(6419*e>>8)-(13320*n>>8)+8708)}function Ln(t,e){return yn((19077*t>>8)+(33050*e>>8)-17685)}function xn(t,e,n,r,i){r[i+0]=wn(t,n),r[i+1]=Nn(t,e,n),r[i+2]=Ln(t,e)}function An(t,e,n,r,i){r[i+0]=Ln(t,e),r[i+1]=Nn(t,e,n),r[i+2]=wn(t,n)}function Sn(t,e,n,r,i){var a=Nn(t,e,n);e=a<<3&224|Ln(t,e)>>3,r[i+0]=248&wn(t,n)|a>>5,r[i+1]=e}function _n(t,e,n,r,i){var a=240&Ln(t,e)|15;r[i+0]=240&wn(t,n)|Nn(t,e,n)>>4,r[i+1]=a}function Pn(t,e,n,r,i){r[i+0]=255,xn(t,e,n,r,i+1)}function kn(t,e,n,r,i){An(t,e,n,r,i),r[i+3]=255}function Fn(t,e,n,r,i){xn(t,e,n,r,i),r[i+3]=255}function Vt(t,e){return 0>t?0:t>e?e:t}function In(e,n,r){t[e]=function(t,e,i,a,o,s,u,c,l){for(var h=c+(-2&l)*r;c!=h;)n(t[e+0],i[a+0],o[s+0],u,c),n(t[e+1],i[a+0],o[s+0],u,c+r),e+=2,++a,++s,c+=2*r;1&l&&n(t[e+0],i[a+0],o[s+0],u,c)}}function jn(t,e,n){return 0==n?0==t?0==e?6:5:0==e?4:0:n}function Cn(t,e,n,r,i){switch(t>>>30){case 3:ar(e,n,r,i,0);break;case 2:or(e,n,r,i);break;case 1:ur(e,n,r,i)}}function On(t,e){var n,a,o=e.M,s=e.Nb,u=t.oc,c=t.pc+40,l=t.oc,h=t.pc+584,f=t.oc,d=t.pc+600;for(n=0;16>n;++n)u[c+32*n-1]=129;for(n=0;8>n;++n)l[h+32*n-1]=129,f[d+32*n-1]=129;for(0<o?u[c-1-32]=l[h-1-32]=f[d-1-32]=129:(i(u,c-32-1,127,21),i(l,h-32-1,127,9),i(f,d-32-1,127,9)),a=0;a<t.za;++a){var p=e.ya[e.aa+a];if(0<a){for(n=-1;16>n;++n)r(u,c+32*n-4,u,c+32*n+12,4);for(n=-1;8>n;++n)r(l,h+32*n-4,l,h+32*n+4,4),r(f,d+32*n-4,f,d+32*n+4,4)}var g=t.Gd,m=t.Hd+a,v=p.ad,b=p.Hc;if(0<o&&(r(u,c-32,g[m].y,0,16),r(l,h-32,g[m].f,0,8),r(f,d-32,g[m].ea,0,8)),p.Za){var y=u,w=c-32+16;for(0<o&&(a>=t.za-1?i(y,w,g[m].y[15],4):r(y,w,g[m+1].y,0,4)),n=0;4>n;n++)y[w+128+n]=y[w+256+n]=y[w+384+n]=y[w+0+n];for(n=0;16>n;++n,b<<=2)y=u,w=c+Ei[n],hi[p.Ob[n]](y,w),Cn(b,v,16*+n,y,w)}else if(y=jn(a,o,p.Ob[0]),li[y](u,c),0!=b)for(n=0;16>n;++n,b<<=2)Cn(b,v,16*+n,u,c+Ei[n]);for(n=p.Gc,y=jn(a,o,p.Dd),fi[y](l,h),fi[y](f,d),b=v,y=l,w=h,255&(p=0|n)&&(170&p?sr(b,256,y,w):cr(b,256,y,w)),p=f,b=d,255&(n>>=8)&&(170&n?sr(v,320,p,b):cr(v,320,p,b)),o<t.Ub-1&&(r(g[m].y,0,u,c+480,16),r(g[m].f,0,l,h+224,8),r(g[m].ea,0,f,d+224,8)),n=8*s*t.B,g=t.sa,m=t.ta+16*a+16*s*t.R,v=t.qa,p=t.ra+8*a+n,b=t.Ha,y=t.Ia+8*a+n,n=0;16>n;++n)r(g,m+n*t.R,u,c+32*n,16);for(n=0;8>n;++n)r(v,p+n*t.B,l,h+32*n,8),r(b,y+n*t.B,f,d+32*n,8)}}function Bn(t,r,i,a,o,s,u,c,l){var h=[0],f=[0],d=0,p=null!=l?l.kd:0,g=null!=l?l:new nn;if(null==t||12>i)return 7;g.data=t,g.w=r,g.ha=i,r=[r],i=[i],g.gb=[g.gb];t:{var m=r,b=i,y=g.gb;if(e(null!=t),e(null!=b),e(null!=y),y[0]=0,12<=b[0]&&!n(t,m[0],"RIFF")){if(n(t,m[0]+8,"WEBP")){y=3;break t}var w=C(t,m[0]+4);if(12>w||4294967286<w){y=3;break t}if(p&&w>b[0]-8){y=7;break t}y[0]=w,m[0]+=12,b[0]-=12}y=0}if(0!=y)return y;for(w=0<g.gb[0],i=i[0];;){t:{var L=t;b=r,y=i;var x=h,A=f,S=m=[0];if((k=d=[d])[0]=0,8>y[0])y=7;else{if(!n(L,b[0],"VP8X")){if(10!=C(L,b[0]+4)){y=3;break t}if(18>y[0]){y=7;break t}var _=C(L,b[0]+8),P=1+j(L,b[0]+12);if(2147483648<=P*(L=1+j(L,b[0]+15))){y=3;break t}null!=S&&(S[0]=_),null!=x&&(x[0]=P),null!=A&&(A[0]=L),b[0]+=18,y[0]-=18,k[0]=1}y=0}}if(d=d[0],m=m[0],0!=y)return y;if(b=!!(2&m),!w&&d)return 3;if(null!=s&&(s[0]=!!(16&m)),null!=u&&(u[0]=b),null!=c&&(c[0]=0),u=h[0],m=f[0],d&&b&&null==l){y=0;break}if(4>i){y=7;break}if(w&&d||!w&&!d&&!n(t,r[0],"ALPH")){i=[i],g.na=[g.na],g.P=[g.P],g.Sa=[g.Sa];t:{_=t,y=r,w=i;var k=g.gb;x=g.na,A=g.P,S=g.Sa,P=22,e(null!=_),e(null!=w),L=y[0];var F=w[0];for(e(null!=x),e(null!=S),x[0]=null,A[0]=null,S[0]=0;;){if(y[0]=L,w[0]=F,8>F){y=7;break t}var I=C(_,L+4);if(4294967286<I){y=3;break t}var O=8+I+1&-2;if(P+=O,0<k&&P>k){y=3;break t}if(!n(_,L,"VP8 ")||!n(_,L,"VP8L")){y=0;break t}if(F[0]<O){y=7;break t}n(_,L,"ALPH")||(x[0]=_,A[0]=L+8,S[0]=I),L+=O,F-=O}}if(i=i[0],g.na=g.na[0],g.P=g.P[0],g.Sa=g.Sa[0],0!=y)break}i=[i],g.Ja=[g.Ja],g.xa=[g.xa];t:if(k=t,y=r,w=i,x=g.gb[0],A=g.Ja,S=g.xa,_=y[0],L=!n(k,_,"VP8 "),P=!n(k,_,"VP8L"),e(null!=k),e(null!=w),e(null!=A),e(null!=S),8>w[0])y=7;else{if(L||P){if(k=C(k,_+4),12<=x&&k>x-12){y=3;break t}if(p&&k>w[0]-8){y=7;break t}A[0]=k,y[0]+=8,w[0]-=8,S[0]=P}else S[0]=5<=w[0]&&47==k[_+0]&&!(k[_+4]>>5),A[0]=w[0];y=0}if(i=i[0],g.Ja=g.Ja[0],g.xa=g.xa[0],r=r[0],0!=y)break;if(4294967286<g.Ja)return 3;if(null==c||b||(c[0]=g.xa?2:1),u=[u],m=[m],g.xa){if(5>i){y=7;break}c=u,p=m,b=s,null==t||5>i?t=0:5<=i&&47==t[r+0]&&!(t[r+4]>>5)?(w=[0],k=[0],x=[0],v(A=new N,t,r,i),gt(A,w,k,x)?(null!=c&&(c[0]=w[0]),null!=p&&(p[0]=k[0]),null!=b&&(b[0]=x[0]),t=1):t=0):t=0}else{if(10>i){y=7;break}c=m,null==t||10>i||!Xt(t,r+3,i-3)?t=0:(p=t[r+0]|t[r+1]<<8|t[r+2]<<16,b=16383&(t[r+7]<<8|t[r+6]),t=16383&(t[r+9]<<8|t[r+8]),1&p||3<(p>>1&7)||!(p>>4&1)||p>>5>=g.Ja||!b||!t?t=0:(u&&(u[0]=b),c&&(c[0]=t),t=1))}if(!t)return 3;if(u=u[0],m=m[0],d&&(h[0]!=u||f[0]!=m))return 3;null!=l&&(l[0]=g,l.offset=r-l.w,e(4294967286>r-l.w),e(l.offset==l.ha-i));break}return 0==y||7==y&&d&&null==l?(null!=s&&(s[0]|=null!=g.na&&0<g.na.length),null!=a&&(a[0]=u),null!=o&&(o[0]=m),0):y}function Mn(t,e,n){var r=e.width,i=e.height,a=0,o=0,s=r,u=i;if(e.Da=null!=t&&0<t.Da,e.Da&&(s=t.cd,u=t.bd,a=t.v,o=t.j,11>n||(a&=-2,o&=-2),0>a||0>o||0>=s||0>=u||a+s>r||o+u>i))return 0;if(e.v=a,e.j=o,e.va=a+s,e.o=o+u,e.U=s,e.T=u,e.da=null!=t&&0<t.da,e.da){if(!q(s,u,n=[t.ib],a=[t.hb]))return 0;e.ib=n[0],e.hb=a[0]}return e.ob=null!=t&&t.ob,e.Kb=null==t||!t.Sd,e.da&&(e.ob=e.ib<3*r/4&&e.hb<3*i/4,e.Kb=0),1}function qn(t){if(null==t)return 2;if(11>t.S){var e=t.f.RGBA;e.fb+=(t.height-1)*e.A,e.A=-e.A}else e=t.f.kb,t=t.height,e.O+=(t-1)*e.fa,e.fa=-e.fa,e.N+=(t-1>>1)*e.Ab,e.Ab=-e.Ab,e.W+=(t-1>>1)*e.Db,e.Db=-e.Db,null!=e.F&&(e.J+=(t-1)*e.lb,e.lb=-e.lb);return 0}function En(t,e,n,r){if(null==r||0>=t||0>=e)return 2;if(null!=n){if(n.Da){var i=n.cd,o=n.bd,s=-2&n.v,u=-2&n.j;if(0>s||0>u||0>=i||0>=o||s+i>t||u+o>e)return 2;t=i,e=o}if(n.da){if(!q(t,e,i=[n.ib],o=[n.hb]))return 2;t=i[0],e=o[0]}}r.width=t,r.height=e;t:{var c=r.width,l=r.height;if(t=r.S,0>=c||0>=l||!(t>=Mr&&13>t))t=2;else{if(0>=r.Rd&&null==r.sd){s=o=i=e=0;var h=(u=c*zi[t])*l;if(11>t||(o=(l+1)/2*(e=(c+1)/2),12==t&&(s=(i=c)*l)),null==(l=a(h+2*o+s))){t=1;break t}r.sd=l,11>t?((c=r.f.RGBA).eb=l,c.fb=0,c.A=u,c.size=h):((c=r.f.kb).y=l,c.O=0,c.fa=u,c.Fd=h,c.f=l,c.N=0+h,c.Ab=e,c.Cd=o,c.ea=l,c.W=0+h+o,c.Db=e,c.Ed=o,12==t&&(c.F=l,c.J=0+h+2*o),c.Tc=s,c.lb=i)}if(e=1,i=r.S,o=r.width,s=r.height,i>=Mr&&13>i)if(11>i)t=r.f.RGBA,e&=(u=Math.abs(t.A))*(s-1)+o<=t.size,e&=u>=o*zi[i],e&=null!=t.eb;else{t=r.f.kb,u=(o+1)/2,h=(s+1)/2,c=Math.abs(t.fa),l=Math.abs(t.Ab);var f=Math.abs(t.Db),d=Math.abs(t.lb),p=d*(s-1)+o;e&=c*(s-1)+o<=t.Fd,e&=l*(h-1)+u<=t.Cd,e=(e&=f*(h-1)+u<=t.Ed)&c>=o&l>=u&f>=u,e&=null!=t.y,e&=null!=t.f,e&=null!=t.ea,12==i&&(e&=d>=o,e&=p<=t.Tc,e&=null!=t.F)}else e=0;t=e?0:2}}return 0!=t||null!=n&&n.fd&&(t=qn(r)),t}var Rn=64,Dn=[0,1,3,7,15,31,63,127,255,511,1023,2047,4095,8191,16383,32767,65535,131071,262143,524287,1048575,2097151,4194303,8388607,16777215],Tn=24,zn=32,Un=8,Hn=[0,0,1,1,2,2,2,2,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7];D("Predictor0","PredictorAdd0"),t.Predictor0=function(){return 4278190080},t.Predictor1=function(t){return t},t.Predictor2=function(t,e,n){return e[n+0]},t.Predictor3=function(t,e,n){return e[n+1]},t.Predictor4=function(t,e,n){return e[n-1]},t.Predictor5=function(t,e,n){return z(z(t,e[n+1]),e[n+0])},t.Predictor6=function(t,e,n){return z(t,e[n-1])},t.Predictor7=function(t,e,n){return z(t,e[n+0])},t.Predictor8=function(t,e,n){return z(e[n-1],e[n+0])},t.Predictor9=function(t,e,n){return z(e[n+0],e[n+1])},t.Predictor10=function(t,e,n){return z(z(t,e[n-1]),z(e[n+0],e[n+1]))},t.Predictor11=function(t,e,n){var r=e[n+0];return 0>=W(r>>24&255,t>>24&255,(e=e[n-1])>>24&255)+W(r>>16&255,t>>16&255,e>>16&255)+W(r>>8&255,t>>8&255,e>>8&255)+W(255&r,255&t,255&e)?r:t},t.Predictor12=function(t,e,n){var r=e[n+0];return(U((t>>24&255)+(r>>24&255)-((e=e[n-1])>>24&255))<<24|U((t>>16&255)+(r>>16&255)-(e>>16&255))<<16|U((t>>8&255)+(r>>8&255)-(e>>8&255))<<8|U((255&t)+(255&r)-(255&e)))>>>0},t.Predictor13=function(t,e,n){var r=e[n-1];return(H((t=z(t,e[n+0]))>>24&255,r>>24&255)<<24|H(t>>16&255,r>>16&255)<<16|H(t>>8&255,r>>8&255)<<8|H(255&t,255&r))>>>0};var Wn=t.PredictorAdd0;t.PredictorAdd1=V,D("Predictor2","PredictorAdd2"),D("Predictor3","PredictorAdd3"),D("Predictor4","PredictorAdd4"),D("Predictor5","PredictorAdd5"),D("Predictor6","PredictorAdd6"),D("Predictor7","PredictorAdd7"),D("Predictor8","PredictorAdd8"),D("Predictor9","PredictorAdd9"),D("Predictor10","PredictorAdd10"),D("Predictor11","PredictorAdd11"),D("Predictor12","PredictorAdd12"),D("Predictor13","PredictorAdd13");var Vn=t.PredictorAdd2;X("ColorIndexInverseTransform","MapARGB","32b",function(t){return t>>8&255},function(t){return t}),X("VP8LColorIndexInverseTransformAlpha","MapAlpha","8b",function(t){return t},function(t){return t>>8&255});var Gn,Yn=t.ColorIndexInverseTransform,Jn=t.MapARGB,Xn=t.VP8LColorIndexInverseTransformAlpha,Kn=t.MapAlpha,Zn=t.VP8LPredictorsAdd=[];Zn.length=16,(t.VP8LPredictors=[]).length=16,(t.VP8LPredictorsAdd_C=[]).length=16,(t.VP8LPredictors_C=[]).length=16;var $n,Qn,tr,er,nr,rr,ir,ar,or,sr,ur,cr,lr,hr,fr,dr,pr,gr,mr,vr,br,yr,wr,Nr,Lr,xr,Ar,Sr,_r=a(511),Pr=a(2041),kr=a(225),Fr=a(767),Ir=0,jr=Pr,Cr=kr,Or=Fr,Br=_r,Mr=0,qr=1,Er=2,Rr=3,Dr=4,Tr=5,zr=6,Ur=7,Hr=8,Wr=9,Vr=10,Gr=[2,3,7],Yr=[3,3,11],Jr=[280,256,256,256,40],Xr=[0,1,1,1,0],Kr=[17,18,0,1,2,3,4,5,16,6,7,8,9,10,11,12,13,14,15],Zr=[24,7,23,25,40,6,39,41,22,26,38,42,56,5,55,57,21,27,54,58,37,43,72,4,71,73,20,28,53,59,70,74,36,44,88,69,75,52,60,3,87,89,19,29,86,90,35,45,68,76,85,91,51,61,104,2,103,105,18,30,102,106,34,46,84,92,67,77,101,107,50,62,120,1,119,121,83,93,17,31,100,108,66,78,118,122,33,47,117,123,49,63,99,109,82,94,0,116,124,65,79,16,32,98,110,48,115,125,81,95,64,114,126,97,111,80,113,127,96,112],$r=[2954,2956,2958,2962,2970,2986,3018,3082,3212,3468,3980,5004],Qr=8,ti=[4,5,6,7,8,9,10,10,11,12,13,14,15,16,17,17,18,19,20,20,21,21,22,22,23,23,24,25,25,26,27,28,29,30,31,32,33,34,35,36,37,37,38,39,40,41,42,43,44,45,46,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,76,77,78,79,80,81,82,83,84,85,86,87,88,89,91,93,95,96,98,100,101,102,104,106,108,110,112,114,116,118,122,124,126,128,130,132,134,136,138,140,143,145,148,151,154,157],ei=[4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,119,122,125,128,131,134,137,140,143,146,149,152,155,158,161,164,167,170,173,177,181,185,189,193,197,201,205,209,213,217,221,225,229,234,239,245,249,254,259,264,269,274,279,284],ni=null,ri=[[173,148,140,0],[176,155,140,135,0],[180,157,141,134,130,0],[254,254,243,230,196,177,153,140,133,130,129,0]],ii=[0,1,4,8,5,2,3,6,9,12,13,10,7,11,14,15],ai=[-0,1,-1,2,-2,3,4,6,-3,5,-4,-5,-6,7,-7,8,-8,-9],oi=[[[[128,128,128,128,128,128,128,128,128,128,128],[128,128,128,128,128,128,128,128,128,128,128],[128,128,128,128,128,128,128,128,128,128,128]],[[253,136,254,255,228,219,128,128,128,128,128],[189,129,242,255,227,213,255,219,128,128,128],[106,126,227,252,214,209,255,255,128,128,128]],[[1,98,248,255,236,226,255,255,128,128,128],[181,133,238,254,221,234,255,154,128,128,128],[78,134,202,247,198,180,255,219,128,128,128]],[[1,185,249,255,243,255,128,128,128,128,128],[184,150,247,255,236,224,128,128,128,128,128],[77,110,216,255,236,230,128,128,128,128,128]],[[1,101,251,255,241,255,128,128,128,128,128],[170,139,241,252,236,209,255,255,128,128,128],[37,116,196,243,228,255,255,255,128,128,128]],[[1,204,254,255,245,255,128,128,128,128,128],[207,160,250,255,238,128,128,128,128,128,128],[102,103,231,255,211,171,128,128,128,128,128]],[[1,152,252,255,240,255,128,128,128,128,128],[177,135,243,255,234,225,128,128,128,128,128],[80,129,211,255,194,224,128,128,128,128,128]],[[1,1,255,128,128,128,128,128,128,128,128],[246,1,255,128,128,128,128,128,128,128,128],[255,128,128,128,128,128,128,128,128,128,128]]],[[[198,35,237,223,193,187,162,160,145,155,62],[131,45,198,221,172,176,220,157,252,221,1],[68,47,146,208,149,167,221,162,255,223,128]],[[1,149,241,255,221,224,255,255,128,128,128],[184,141,234,253,222,220,255,199,128,128,128],[81,99,181,242,176,190,249,202,255,255,128]],[[1,129,232,253,214,197,242,196,255,255,128],[99,121,210,250,201,198,255,202,128,128,128],[23,91,163,242,170,187,247,210,255,255,128]],[[1,200,246,255,234,255,128,128,128,128,128],[109,178,241,255,231,245,255,255,128,128,128],[44,130,201,253,205,192,255,255,128,128,128]],[[1,132,239,251,219,209,255,165,128,128,128],[94,136,225,251,218,190,255,255,128,128,128],[22,100,174,245,186,161,255,199,128,128,128]],[[1,182,249,255,232,235,128,128,128,128,128],[124,143,241,255,227,234,128,128,128,128,128],[35,77,181,251,193,211,255,205,128,128,128]],[[1,157,247,255,236,231,255,255,128,128,128],[121,141,235,255,225,227,255,255,128,128,128],[45,99,188,251,195,217,255,224,128,128,128]],[[1,1,251,255,213,255,128,128,128,128,128],[203,1,248,255,255,128,128,128,128,128,128],[137,1,177,255,224,255,128,128,128,128,128]]],[[[253,9,248,251,207,208,255,192,128,128,128],[175,13,224,243,193,185,249,198,255,255,128],[73,17,171,221,161,179,236,167,255,234,128]],[[1,95,247,253,212,183,255,255,128,128,128],[239,90,244,250,211,209,255,255,128,128,128],[155,77,195,248,188,195,255,255,128,128,128]],[[1,24,239,251,218,219,255,205,128,128,128],[201,51,219,255,196,186,128,128,128,128,128],[69,46,190,239,201,218,255,228,128,128,128]],[[1,191,251,255,255,128,128,128,128,128,128],[223,165,249,255,213,255,128,128,128,128,128],[141,124,248,255,255,128,128,128,128,128,128]],[[1,16,248,255,255,128,128,128,128,128,128],[190,36,230,255,236,255,128,128,128,128,128],[149,1,255,128,128,128,128,128,128,128,128]],[[1,226,255,128,128,128,128,128,128,128,128],[247,192,255,128,128,128,128,128,128,128,128],[240,128,255,128,128,128,128,128,128,128,128]],[[1,134,252,255,255,128,128,128,128,128,128],[213,62,250,255,255,128,128,128,128,128,128],[55,93,255,128,128,128,128,128,128,128,128]],[[128,128,128,128,128,128,128,128,128,128,128],[128,128,128,128,128,128,128,128,128,128,128],[128,128,128,128,128,128,128,128,128,128,128]]],[[[202,24,213,235,186,191,220,160,240,175,255],[126,38,182,232,169,184,228,174,255,187,128],[61,46,138,219,151,178,240,170,255,216,128]],[[1,112,230,250,199,191,247,159,255,255,128],[166,109,228,252,211,215,255,174,128,128,128],[39,77,162,232,172,180,245,178,255,255,128]],[[1,52,220,246,198,199,249,220,255,255,128],[124,74,191,243,183,193,250,221,255,255,128],[24,71,130,219,154,170,243,182,255,255,128]],[[1,182,225,249,219,240,255,224,128,128,128],[149,150,226,252,216,205,255,171,128,128,128],[28,108,170,242,183,194,254,223,255,255,128]],[[1,81,230,252,204,203,255,192,128,128,128],[123,102,209,247,188,196,255,233,128,128,128],[20,95,153,243,164,173,255,203,128,128,128]],[[1,222,248,255,216,213,128,128,128,128,128],[168,175,246,252,235,205,255,255,128,128,128],[47,116,215,255,211,212,255,255,128,128,128]],[[1,121,236,253,212,214,255,255,128,128,128],[141,84,213,252,201,202,255,219,128,128,128],[42,80,160,240,162,185,255,205,128,128,128]],[[1,1,255,128,128,128,128,128,128,128,128],[244,1,255,128,128,128,128,128,128,128,128],[238,1,255,128,128,128,128,128,128,128,128]]]],si=[[[231,120,48,89,115,113,120,152,112],[152,179,64,126,170,118,46,70,95],[175,69,143,80,85,82,72,155,103],[56,58,10,171,218,189,17,13,152],[114,26,17,163,44,195,21,10,173],[121,24,80,195,26,62,44,64,85],[144,71,10,38,171,213,144,34,26],[170,46,55,19,136,160,33,206,71],[63,20,8,114,114,208,12,9,226],[81,40,11,96,182,84,29,16,36]],[[134,183,89,137,98,101,106,165,148],[72,187,100,130,157,111,32,75,80],[66,102,167,99,74,62,40,234,128],[41,53,9,178,241,141,26,8,107],[74,43,26,146,73,166,49,23,157],[65,38,105,160,51,52,31,115,128],[104,79,12,27,217,255,87,17,7],[87,68,71,44,114,51,15,186,23],[47,41,14,110,182,183,21,17,194],[66,45,25,102,197,189,23,18,22]],[[88,88,147,150,42,46,45,196,205],[43,97,183,117,85,38,35,179,61],[39,53,200,87,26,21,43,232,171],[56,34,51,104,114,102,29,93,77],[39,28,85,171,58,165,90,98,64],[34,22,116,206,23,34,43,166,73],[107,54,32,26,51,1,81,43,31],[68,25,106,22,64,171,36,225,114],[34,19,21,102,132,188,16,76,124],[62,18,78,95,85,57,50,48,51]],[[193,101,35,159,215,111,89,46,111],[60,148,31,172,219,228,21,18,111],[112,113,77,85,179,255,38,120,114],[40,42,1,196,245,209,10,25,109],[88,43,29,140,166,213,37,43,154],[61,63,30,155,67,45,68,1,209],[100,80,8,43,154,1,51,26,71],[142,78,78,16,255,128,34,197,171],[41,40,5,102,211,183,4,1,221],[51,50,17,168,209,192,23,25,82]],[[138,31,36,171,27,166,38,44,229],[67,87,58,169,82,115,26,59,179],[63,59,90,180,59,166,93,73,154],[40,40,21,116,143,209,34,39,175],[47,15,16,183,34,223,49,45,183],[46,17,33,183,6,98,15,32,183],[57,46,22,24,128,1,54,17,37],[65,32,73,115,28,128,23,128,205],[40,3,9,115,51,192,18,6,223],[87,37,9,115,59,77,64,21,47]],[[104,55,44,218,9,54,53,130,226],[64,90,70,205,40,41,23,26,57],[54,57,112,184,5,41,38,166,213],[30,34,26,133,152,116,10,32,134],[39,19,53,221,26,114,32,73,255],[31,9,65,234,2,15,1,118,73],[75,32,12,51,192,255,160,43,51],[88,31,35,67,102,85,55,186,85],[56,21,23,111,59,205,45,37,192],[55,38,70,124,73,102,1,34,98]],[[125,98,42,88,104,85,117,175,82],[95,84,53,89,128,100,113,101,45],[75,79,123,47,51,128,81,171,1],[57,17,5,71,102,57,53,41,49],[38,33,13,121,57,73,26,1,85],[41,10,67,138,77,110,90,47,114],[115,21,2,10,102,255,166,23,6],[101,29,16,10,85,128,101,196,26],[57,18,10,102,102,213,34,20,43],[117,20,15,36,163,128,68,1,26]],[[102,61,71,37,34,53,31,243,192],[69,60,71,38,73,119,28,222,37],[68,45,128,34,1,47,11,245,171],[62,17,19,70,146,85,55,62,70],[37,43,37,154,100,163,85,160,1],[63,9,92,136,28,64,32,201,85],[75,15,9,9,64,255,184,119,16],[86,6,28,5,64,255,25,248,1],[56,8,17,132,137,255,55,116,128],[58,15,20,82,135,57,26,121,40]],[[164,50,31,137,154,133,25,35,218],[51,103,44,131,131,123,31,6,158],[86,40,64,135,148,224,45,183,128],[22,26,17,131,240,154,14,1,209],[45,16,21,91,64,222,7,1,197],[56,21,39,155,60,138,23,102,213],[83,12,13,54,192,255,68,47,28],[85,26,85,85,128,128,32,146,171],[18,11,7,63,144,171,4,4,246],[35,27,10,146,174,171,12,26,128]],[[190,80,35,99,180,80,126,54,45],[85,126,47,87,176,51,41,20,32],[101,75,128,139,118,146,116,128,85],[56,41,15,176,236,85,37,9,62],[71,30,17,119,118,255,17,18,138],[101,38,60,138,55,70,43,26,142],[146,36,19,30,171,255,97,27,20],[138,45,61,62,219,1,81,188,64],[32,41,20,117,151,142,20,21,163],[112,19,12,61,195,128,48,4,24]]],ui=[[[[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[176,246,255,255,255,255,255,255,255,255,255],[223,241,252,255,255,255,255,255,255,255,255],[249,253,253,255,255,255,255,255,255,255,255]],[[255,244,252,255,255,255,255,255,255,255,255],[234,254,254,255,255,255,255,255,255,255,255],[253,255,255,255,255,255,255,255,255,255,255]],[[255,246,254,255,255,255,255,255,255,255,255],[239,253,254,255,255,255,255,255,255,255,255],[254,255,254,255,255,255,255,255,255,255,255]],[[255,248,254,255,255,255,255,255,255,255,255],[251,255,254,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,253,254,255,255,255,255,255,255,255,255],[251,254,254,255,255,255,255,255,255,255,255],[254,255,254,255,255,255,255,255,255,255,255]],[[255,254,253,255,254,255,255,255,255,255,255],[250,255,254,255,254,255,255,255,255,255,255],[254,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]]],[[[217,255,255,255,255,255,255,255,255,255,255],[225,252,241,253,255,255,254,255,255,255,255],[234,250,241,250,253,255,253,254,255,255,255]],[[255,254,255,255,255,255,255,255,255,255,255],[223,254,254,255,255,255,255,255,255,255,255],[238,253,254,254,255,255,255,255,255,255,255]],[[255,248,254,255,255,255,255,255,255,255,255],[249,254,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,253,255,255,255,255,255,255,255,255,255],[247,254,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,253,254,255,255,255,255,255,255,255,255],[252,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,254,254,255,255,255,255,255,255,255,255],[253,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,254,253,255,255,255,255,255,255,255,255],[250,255,255,255,255,255,255,255,255,255,255],[254,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]]],[[[186,251,250,255,255,255,255,255,255,255,255],[234,251,244,254,255,255,255,255,255,255,255],[251,251,243,253,254,255,254,255,255,255,255]],[[255,253,254,255,255,255,255,255,255,255,255],[236,253,254,255,255,255,255,255,255,255,255],[251,253,253,254,254,255,255,255,255,255,255]],[[255,254,254,255,255,255,255,255,255,255,255],[254,254,254,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,254,255,255,255,255,255,255,255,255,255],[254,254,255,255,255,255,255,255,255,255,255],[254,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[254,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]]],[[[248,255,255,255,255,255,255,255,255,255,255],[250,254,252,254,255,255,255,255,255,255,255],[248,254,249,253,255,255,255,255,255,255,255]],[[255,253,253,255,255,255,255,255,255,255,255],[246,253,253,255,255,255,255,255,255,255,255],[252,254,251,254,254,255,255,255,255,255,255]],[[255,254,252,255,255,255,255,255,255,255,255],[248,254,253,255,255,255,255,255,255,255,255],[253,255,254,254,255,255,255,255,255,255,255]],[[255,251,254,255,255,255,255,255,255,255,255],[245,251,254,255,255,255,255,255,255,255,255],[253,253,254,255,255,255,255,255,255,255,255]],[[255,251,253,255,255,255,255,255,255,255,255],[252,253,254,255,255,255,255,255,255,255,255],[255,254,255,255,255,255,255,255,255,255,255]],[[255,252,255,255,255,255,255,255,255,255,255],[249,255,254,255,255,255,255,255,255,255,255],[255,255,254,255,255,255,255,255,255,255,255]],[[255,255,253,255,255,255,255,255,255,255,255],[250,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[254,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]]]],ci=[0,1,2,3,6,4,5,6,6,6,6,6,6,6,6,7,0],li=[],hi=[],fi=[],di=1,pi=2,gi=[],mi=[];vn("UpsampleRgbLinePair",xn,3),vn("UpsampleBgrLinePair",An,3),vn("UpsampleRgbaLinePair",Fn,4),vn("UpsampleBgraLinePair",kn,4),vn("UpsampleArgbLinePair",Pn,4),vn("UpsampleRgba4444LinePair",_n,2),vn("UpsampleRgb565LinePair",Sn,2);var vi=t.UpsampleRgbLinePair,bi=t.UpsampleBgrLinePair,yi=t.UpsampleRgbaLinePair,wi=t.UpsampleBgraLinePair,Ni=t.UpsampleArgbLinePair,Li=t.UpsampleRgba4444LinePair,xi=t.UpsampleRgb565LinePair,Ai=16,Si=1<<Ai-1,_i=-227,Pi=482,ki=6,Fi=(256<<ki)-1,Ii=0,ji=a(256),Ci=a(256),Oi=a(256),Bi=a(256),Mi=a(Pi-_i),qi=a(Pi-_i);In("YuvToRgbRow",xn,3),In("YuvToBgrRow",An,3),In("YuvToRgbaRow",Fn,4),In("YuvToBgraRow",kn,4),In("YuvToArgbRow",Pn,4),In("YuvToRgba4444Row",_n,2),In("YuvToRgb565Row",Sn,2);var Ei=[0,4,8,12,128,132,136,140,256,260,264,268,384,388,392,396],Ri=[0,2,8],Di=[8,7,6,4,4,2,2,2,1,1,1,1],Ti=1;this.WebPDecodeRGBA=function(t,n,s,u,c){var l=qr,h=new en,f=new ot;h.ba=f,f.S=l,f.width=[f.width],f.height=[f.height];var d=f.width,p=f.height,g=new st;if(null==g||null==t)var m=2;else e(null!=g),m=Bn(t,n,s,g.width,g.height,g.Pd,g.Qd,g.format,null);if(0!=m?d=0:(null!=d&&(d[0]=g.width[0]),null!=p&&(p[0]=g.height[0]),d=1),d){f.width=f.width[0],f.height=f.height[0],null!=u&&(u[0]=f.width),null!=c&&(c[0]=f.height);t:{if(u=new Gt,(c=new nn).data=t,c.w=n,c.ha=s,c.kd=1,n=[0],e(null!=c),(0==(t=Bn(c.data,c.w,c.ha,null,null,null,n,null,c))||7==t)&&n[0]&&(t=4),0==(n=t)){if(e(null!=h),u.data=c.data,u.w=c.w+c.offset,u.ha=c.ha-c.offset,u.put=dt,u.ac=ft,u.bc=pt,u.ma=h,c.xa){if(null==(t=kt())){h=1;break t}if(function(t,n){var r=[0],i=[0],a=[0];e:for(;;){if(null==t)return 0;if(null==n)return t.a=2,0;if(t.l=n,t.a=0,v(t.m,n.data,n.w,n.ha),!gt(t.m,r,i,a)){t.a=3;break e}if(t.xb=pi,n.width=r[0],n.height=i[0],!Ft(r[0],i[0],1,t,null))break e;return 1}return e(0!=t.a),0}(t,u)){if(u=0==(n=En(u.width,u.height,h.Oa,h.ba))){e:{u=t;n:for(;;){if(null==u){u=0;break e}if(e(null!=u.s.yc),e(null!=u.s.Ya),e(0<u.s.Wb),e(null!=(s=u.l)),e(null!=(c=s.ma)),0!=u.xb){if(u.ca=c.ba,u.tb=c.tb,e(null!=u.ca),!Mn(c.Oa,s,Rr)){u.a=2;break n}if(!It(u,s.width))break n;if(s.da)break n;if((s.da||rt(u.ca.S))&&mn(),11>u.ca.S||(alert("todo:WebPInitConvertARGBToYUV"),null!=u.ca.f.kb.F&&mn()),u.Pb&&0<u.s.ua&&null==u.s.vb.X&&!O(u.s.vb,u.s.Wa.Xa)){u.a=1;break n}u.xb=0}if(!_t(u,u.V,u.Ba,u.c,u.i,s.o,Lt))break n;c.Dc=u.Ma,u=1;break e}e(0!=u.a),u=0}u=!u}u&&(n=t.a)}else n=t.a}else{if(null==(t=new Yt)){h=1;break t}if(t.Fa=c.na,t.P=c.P,t.qc=c.Sa,Kt(t,u)){if(0==(n=En(u.width,u.height,h.Oa,h.ba))){if(t.Aa=0,s=h.Oa,e(null!=(c=t)),null!=s){if(0<(d=0>(d=s.Md)?0:100<d?255:255*d/100)){for(p=g=0;4>p;++p)12>(m=c.pb[p]).lc&&(m.ia=d*Di[0>m.lc?0:m.lc]>>3),g|=m.ia;g&&(alert("todo:VP8InitRandom"),c.ia=1)}c.Ga=s.Id,100<c.Ga?c.Ga=100:0>c.Ga&&(c.Ga=0)}(function(t,n){if(null==t)return 0;if(null==n)return Jt(t,2,"NULL VP8Io parameter in VP8Decode().");if(!t.cb&&!Kt(t,n))return 0;if(e(t.cb),null==n.ac||n.ac(n)){n.ob&&(t.L=0);var s=Ri[t.L];if(2==t.L?(t.yb=0,t.zb=0):(t.yb=n.v-s>>4,t.zb=n.j-s>>4,0>t.yb&&(t.yb=0),0>t.zb&&(t.zb=0)),t.Va=n.o+15+s>>4,t.Hb=n.va+15+s>>4,t.Hb>t.za&&(t.Hb=t.za),t.Va>t.Ub&&(t.Va=t.Ub),0<t.L){var u=t.ed;for(s=0;4>s;++s){var c;if(t.Qa.Cb){var l=t.Qa.Lb[s];t.Qa.Fb||(l+=u.Tb)}else l=u.Tb;for(c=0;1>=c;++c){var h=t.gd[s][c],f=l;if(u.Pc&&(f+=u.vd[0],c&&(f+=u.od[0])),0<(f=0>f?0:63<f?63:f)){var d=f;0<u.wb&&(d=4<u.wb?d>>2:d>>1)>9-u.wb&&(d=9-u.wb),1>d&&(d=1),h.dd=d,h.tc=2*f+d,h.ld=40<=f?2:15<=f?1:0}else h.tc=0;h.La=c}}}s=0}else Jt(t,6,"Frame setup failed"),s=t.a;if(s=0==s){if(s){t.$c=0,0<t.Aa||(t.Ic=Ti);e:{s=t.Ic,u=4*(d=t.za);var p=32*d,g=d+1,m=0<t.L?d*(0<t.Aa?2:1):0,v=(2==t.Aa?2:1)*d;if((h=u+832+(c=3*(16*s+Ri[t.L])/2*p)+(l=null!=t.Fa&&0<t.Fa.length?t.Kc.c*t.Kc.i:0))!=h)s=0;else{if(h>t.Vb){if(t.Vb=0,t.Ec=a(h),t.Fc=0,null==t.Ec){s=Jt(t,1,"no memory during frame initialization.");break e}t.Vb=h}h=t.Ec,f=t.Fc,t.Ac=h,t.Bc=f,f+=u,t.Gd=o(p,Ht),t.Hd=0,t.rb=o(g+1,Dt),t.sb=1,t.wa=m?o(m,Rt):null,t.Y=0,t.D.Nb=0,t.D.wa=t.wa,t.D.Y=t.Y,0<t.Aa&&(t.D.Y+=d),e(!0),t.oc=h,t.pc=f,f+=832,t.ya=o(v,zt),t.aa=0,t.D.ya=t.ya,t.D.aa=t.aa,2==t.Aa&&(t.D.aa+=d),t.R=16*d,t.B=8*d,d=(p=Ri[t.L])*t.R,p=p/2*t.B,t.sa=h,t.ta=f+d,t.qa=t.sa,t.ra=t.ta+16*s*t.R+p,t.Ha=t.qa,t.Ia=t.ra+8*s*t.B+p,t.$c=0,f+=c,t.mb=l?h:null,t.nb=l?f:null,e(f+l<=t.Fc+t.Vb),$t(t),i(t.Ac,t.Bc,0,u),s=1}}if(s){if(n.ka=0,n.y=t.sa,n.O=t.ta,n.f=t.qa,n.N=t.ra,n.ea=t.Ha,n.Vd=t.Ia,n.fa=t.R,n.Rc=t.B,n.F=null,n.J=0,!Ir){for(s=-255;255>=s;++s)_r[255+s]=0>s?-s:s;for(s=-1020;1020>=s;++s)Pr[1020+s]=-128>s?-128:127<s?127:s;for(s=-112;112>=s;++s)kr[112+s]=-16>s?-16:15<s?15:s;for(s=-255;510>=s;++s)Fr[255+s]=0>s?0:255<s?255:s;Ir=1}ir=ue,ar=ie,sr=ae,ur=oe,cr=se,or=re,lr=Ye,hr=Je,fr=Ze,dr=$e,pr=Xe,gr=Ke,mr=Qe,vr=tn,br=ze,yr=Ue,wr=He,Nr=We,hi[0]=xe,hi[1]=le,hi[2]=Ne,hi[3]=Le,hi[4]=Ae,hi[5]=_e,hi[6]=Se,hi[7]=Pe,hi[8]=Fe,hi[9]=ke,li[0]=me,li[1]=fe,li[2]=de,li[3]=pe,li[4]=ve,li[5]=be,li[6]=ye,fi[0]=Oe,fi[1]=he,fi[2]=Ie,fi[3]=je,fi[4]=Me,fi[5]=Be,fi[6]=qe,s=1}else s=0}s&&(s=function(t,n){for(t.M=0;t.M<t.Va;++t.M){var o,s=t.Jc[t.M&t.Xb],u=t.m,c=t;for(o=0;o<c.za;++o){var l=u,h=c,f=h.Ac,d=h.Bc+4*o,p=h.zc,g=h.ya[h.aa+o];if(h.Qa.Bb?g.$b=k(l,h.Pa.jb[0])?2+k(l,h.Pa.jb[2]):k(l,h.Pa.jb[1]):g.$b=0,h.kc&&(g.Ad=k(l,h.Bd)),g.Za=!k(l,145)+0,g.Za){var m=g.Ob,v=0;for(h=0;4>h;++h){var b,y=p[0+h];for(b=0;4>b;++b){y=si[f[d+b]][y];for(var w=ai[k(l,y[0])];0<w;)w=ai[2*w+k(l,y[w])];y=-w,f[d+b]=y}r(m,v,f,d,4),v+=4,p[0+h]=y}}else y=k(l,156)?k(l,128)?1:3:k(l,163)?2:0,g.Ob[0]=y,i(f,d,y,4),i(p,0,y,4);g.Dd=k(l,142)?k(l,114)?k(l,183)?1:3:2:0}if(c.m.Ka)return Jt(t,7,"Premature end-of-partition0 encountered.");for(;t.ja<t.za;++t.ja){if(c=s,l=(u=t).rb[u.sb-1],f=u.rb[u.sb+u.ja],o=u.ya[u.aa+u.ja],d=u.kc?o.Ad:0)l.la=f.la=0,o.Za||(l.Na=f.Na=0),o.Hc=0,o.Gc=0,o.ia=0;else{var N,L;if(l=f,f=c,d=u.Pa.Xc,p=u.ya[u.aa+u.ja],g=u.pb[p.$b],h=p.ad,m=0,v=u.rb[u.sb-1],y=b=0,i(h,m,0,384),p.Za)var x=0,A=d[3];else{w=a(16);var S=l.Na+v.Na;if(S=ni(f,d[1],S,g.Eb,0,w,0),l.Na=v.Na=(0<S)+0,1<S)ir(w,0,h,m);else{var _=w[0]+3>>3;for(w=0;256>w;w+=16)h[m+w]=_}x=1,A=d[0]}var P=15&l.la,F=15&v.la;for(w=0;4>w;++w){var I=1&F;for(_=L=0;4>_;++_)P=P>>1|(I=(S=ni(f,A,S=I+(1&P),g.Sc,x,h,m))>x)<<7,L=L<<2|(3<S?3:1<S?2:0!=h[m+0]),m+=16;P>>=4,F=F>>1|I<<7,b=(b<<8|L)>>>0}for(A=P,x=F>>4,N=0;4>N;N+=2){for(L=0,P=l.la>>4+N,F=v.la>>4+N,w=0;2>w;++w){for(I=1&F,_=0;2>_;++_)S=I+(1&P),P=P>>1|(I=0<(S=ni(f,d[2],S,g.Qc,0,h,m)))<<3,L=L<<2|(3<S?3:1<S?2:0!=h[m+0]),m+=16;P>>=2,F=F>>1|I<<5}y|=L<<4*N,A|=P<<4<<N,x|=(240&F)<<N}l.la=A,v.la=x,p.Hc=b,p.Gc=y,p.ia=43690&y?0:g.ia,d=!(b|y)}if(0<u.L&&(u.wa[u.Y+u.ja]=u.gd[o.$b][o.Za],u.wa[u.Y+u.ja].La|=!d),c.Ka)return Jt(t,7,"Premature end-of-file encountered.")}if($t(t),u=n,c=1,o=(s=t).D,l=0<s.L&&s.M>=s.zb&&s.M<=s.Va,0==s.Aa)e:{if(o.M=s.M,o.uc=l,On(s,o),c=1,o=(L=s.D).Nb,l=(y=Ri[s.L])*s.R,f=y/2*s.B,w=16*o*s.R,_=8*o*s.B,d=s.sa,p=s.ta-l+w,g=s.qa,h=s.ra-f+_,m=s.Ha,v=s.Ia-f+_,F=0==(P=L.M),b=P>=s.Va-1,2==s.Aa&&On(s,L),L.uc)for(I=(S=s).D.M,e(S.D.uc),L=S.yb;L<S.Hb;++L){x=L,A=I;var j=(C=(z=S).D).Nb;N=z.R;var C=C.wa[C.Y+x],O=z.sa,B=z.ta+16*j*N+16*x,M=C.dd,q=C.tc;if(0!=q)if(e(3<=q),1==z.L)0<x&&yr(O,B,N,q+4),C.La&&Nr(O,B,N,q),0<A&&br(O,B,N,q+4),C.La&&wr(O,B,N,q);else{var E=z.B,R=z.qa,D=z.ra+8*j*E+8*x,T=z.Ha,z=z.Ia+8*j*E+8*x;j=C.ld,0<x&&(hr(O,B,N,q+4,M,j),dr(R,D,T,z,E,q+4,M,j)),C.La&&(gr(O,B,N,q,M,j),vr(R,D,T,z,E,q,M,j)),0<A&&(lr(O,B,N,q+4,M,j),fr(R,D,T,z,E,q+4,M,j)),C.La&&(pr(O,B,N,q,M,j),mr(R,D,T,z,E,q,M,j))}}if(s.ia&&alert("todo:DitherRow"),null!=u.put){if(L=16*P,P=16*(P+1),F?(u.y=s.sa,u.O=s.ta+w,u.f=s.qa,u.N=s.ra+_,u.ea=s.Ha,u.W=s.Ia+_):(L-=y,u.y=d,u.O=p,u.f=g,u.N=h,u.ea=m,u.W=v),b||(P-=y),P>u.o&&(P=u.o),u.F=null,u.J=null,null!=s.Fa&&0<s.Fa.length&&L<P&&(u.J=hn(s,u,L,P-L),u.F=s.mb,null==u.F&&0==u.F.length)){c=Jt(s,3,"Could not decode alpha data.");break e}L<u.j&&(y=u.j-L,L=u.j,e(!(1&y)),u.O+=s.R*y,u.N+=s.B*(y>>1),u.W+=s.B*(y>>1),null!=u.F&&(u.J+=u.width*y)),L<P&&(u.O+=u.v,u.N+=u.v>>1,u.W+=u.v>>1,null!=u.F&&(u.J+=u.v),u.ka=L-u.j,u.U=u.va-u.v,u.T=P-L,c=u.put(u))}o+1!=s.Ic||b||(r(s.sa,s.ta-l,d,p+16*s.R,l),r(s.qa,s.ra-f,g,h+8*s.B,f),r(s.Ha,s.Ia-f,m,v+8*s.B,f))}if(!c)return Jt(t,6,"Output aborted.")}return 1}(t,n)),null!=n.bc&&n.bc(n),s&=1}return s?(t.cb=0,s):0})(t,u)||(n=t.a)}}else n=t.a}0==n&&null!=h.Oa&&h.Oa.fd&&(n=qn(h.ba))}h=n}l=0!=h?null:11>l?f.f.RGBA.eb:f.f.kb.y}else l=null;return l};var zi=[3,4,3,4,4,2,2,4,4,4,2,1,1]};function c(t,e){for(var n="",r=0;r<4;r++)n+=String.fromCharCode(t[e++]);return n}function l(t,e){return t[e+0]|t[e+1]<<8}function h(t,e){return(t[e+0]|t[e+1]<<8|t[e+2]<<16)>>>0}function f(t,e){return(t[e+0]|t[e+1]<<8|t[e+2]<<16|t[e+3]<<24)>>>0}new u;var d=[0],p=[0],g=[],m=new u,v=t,b=function(t,e){var n={},r=0,i=!1,a=0,o=0;if(n.frames=[],!
/** @license
   * Copyright (c) 2017 Dominik Homberger
  Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
  The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
  https://webpjs.appspot.com
  WebPRiffParser dominikhlbg@gmail.com
  */
function(t,e){for(var n=0;n<4;n++)if(t[e+n]!="RIFF".charCodeAt(n))return!0;return!1}(t,e)){for(f(t,e+=4),e+=8;e<t.length;){var s=c(t,e),u=f(t,e+=4);e+=4;var d=u+(1&u);switch(s){case"VP8 ":case"VP8L":void 0===n.frames[r]&&(n.frames[r]={}),(m=n.frames[r]).src_off=i?o:e-8,m.src_size=a+u+8,r++,i&&(i=!1,a=0,o=0);break;case"VP8X":(m=n.header={}).feature_flags=t[e];var p=e+4;m.canvas_width=1+h(t,p),p+=3,m.canvas_height=1+h(t,p),p+=3;break;case"ALPH":i=!0,a=d+8,o=e-8;break;case"ANIM":(m=n.header).bgcolor=f(t,e),p=e+4,m.loop_count=l(t,p),p+=2;break;case"ANMF":var g,m;(m=n.frames[r]={}).offset_x=2*h(t,e),e+=3,m.offset_y=2*h(t,e),e+=3,m.width=1+h(t,e),e+=3,m.height=1+h(t,e),e+=3,m.duration=h(t,e),e+=3,g=t[e++],m.dispose=1&g,m.blend=g>>1&1}"ANMF"!=s&&(e+=d)}return n}}(v,0);b.response=v,b.rgbaoutput=!0,b.dataurl=!1;var y=b.header?b.header:null,w=b.frames?b.frames:null;if(y){y.loop_counter=y.loop_count,d=[y.canvas_height],p=[y.canvas_width];for(var N=0;N<w.length&&0!=w[N].blend;N++);}var L=w[0],x=m.WebPDecodeRGBA(v,L.src_off,L.src_size,p,d);L.rgba=x,L.imgwidth=p[0],L.imgheight=d[0];for(var A=0;A<p[0]*d[0]*4;A++)g[A]=x[A];return this.width=p,this.height=d,this.data=g,this}!function(e){var n,r,i,a,s,u,c,l,f,d=function(t){return t=t||{},this.isStrokeTransparent=t.isStrokeTransparent||!1,this.strokeOpacity=t.strokeOpacity||1,this.strokeStyle=t.strokeStyle||"#000000",this.fillStyle=t.fillStyle||"#000000",this.isFillTransparent=t.isFillTransparent||!1,this.fillOpacity=t.fillOpacity||1,this.font=t.font||"10px sans-serif",this.textBaseline=t.textBaseline||"alphabetic",this.textAlign=t.textAlign||"left",this.lineWidth=t.lineWidth||1,this.lineJoin=t.lineJoin||"miter",this.lineCap=t.lineCap||"butt",this.path=t.path||[],this.transform=void 0!==t.transform?t.transform.clone():new l,this.globalCompositeOperation=t.globalCompositeOperation||"normal",this.globalAlpha=t.globalAlpha||1,this.clip_path=t.clip_path||[],this.currentPoint=t.currentPoint||new u,this.miterLimit=t.miterLimit||10,this.lastPoint=t.lastPoint||new u,this.lineDashOffset=t.lineDashOffset||0,this.lineDash=t.lineDash||[],this.margin=t.margin||[0,0,0,0],this.prevPageLastElemOffset=t.prevPageLastElemOffset||0,this.ignoreClearRect="boolean"!=typeof t.ignoreClearRect||t.ignoreClearRect,this};e.events.push(["initialized",function(){this.context2d=new p(this),n=this.internal.f2,r=this.internal.getCoordinateString,i=this.internal.getVerticalCoordinateString,a=this.internal.getHorizontalCoordinate,s=this.internal.getVerticalCoordinate,u=this.internal.Point,c=this.internal.Rectangle,l=this.internal.Matrix,f=new d}]);var p=function(t){Object.defineProperty(this,"canvas",{get:function(){return{parentNode:!1,style:!1}}});var e=t;Object.defineProperty(this,"pdf",{get:function(){return e}});var n=!1;Object.defineProperty(this,"pageWrapXEnabled",{get:function(){return n},set:function(t){n=Boolean(t)}});var r=!1;Object.defineProperty(this,"pageWrapYEnabled",{get:function(){return r},set:function(t){r=Boolean(t)}});var i=0;Object.defineProperty(this,"posX",{get:function(){return i},set:function(t){isNaN(t)||(i=t)}});var a=0;Object.defineProperty(this,"posY",{get:function(){return a},set:function(t){isNaN(t)||(a=t)}}),Object.defineProperty(this,"margin",{get:function(){return f.margin},set:function(t){var e;"number"==typeof t?e=[t,t,t,t]:((e=new Array(4))[0]=t[0],e[1]=t.length>=2?t[1]:e[0],e[2]=t.length>=3?t[2]:e[0],e[3]=t.length>=4?t[3]:e[1]),f.margin=e}});var o=!1;Object.defineProperty(this,"autoPaging",{get:function(){return o},set:function(t){o=t}});var s=0;Object.defineProperty(this,"lastBreak",{get:function(){return s},set:function(t){s=t}});var u=[];Object.defineProperty(this,"pageBreaks",{get:function(){return u},set:function(t){u=t}}),Object.defineProperty(this,"ctx",{get:function(){return f},set:function(t){t instanceof d&&(f=t)}}),Object.defineProperty(this,"path",{get:function(){return f.path},set:function(t){f.path=t}});var c=[];Object.defineProperty(this,"ctxStack",{get:function(){return c},set:function(t){c=t}}),Object.defineProperty(this,"fillStyle",{get:function(){return this.ctx.fillStyle},set:function(t){var e;e=g(t),this.ctx.fillStyle=e.style,this.ctx.isFillTransparent=0===e.a,this.ctx.fillOpacity=e.a,this.pdf.setFillColor(e.r,e.g,e.b,{a:e.a}),this.pdf.setTextColor(e.r,e.g,e.b,{a:e.a})}}),Object.defineProperty(this,"strokeStyle",{get:function(){return this.ctx.strokeStyle},set:function(t){var e=g(t);this.ctx.strokeStyle=e.style,this.ctx.isStrokeTransparent=0===e.a,this.ctx.strokeOpacity=e.a,0===e.a?this.pdf.setDrawColor(255,255,255):(e.a,this.pdf.setDrawColor(e.r,e.g,e.b))}}),Object.defineProperty(this,"lineCap",{get:function(){return this.ctx.lineCap},set:function(t){-1!==["butt","round","square"].indexOf(t)&&(this.ctx.lineCap=t,this.pdf.setLineCap(t))}}),Object.defineProperty(this,"lineWidth",{get:function(){return this.ctx.lineWidth},set:function(t){isNaN(t)||(this.ctx.lineWidth=t,this.pdf.setLineWidth(t))}}),Object.defineProperty(this,"lineJoin",{get:function(){return this.ctx.lineJoin},set:function(t){-1!==["bevel","round","miter"].indexOf(t)&&(this.ctx.lineJoin=t,this.pdf.setLineJoin(t))}}),Object.defineProperty(this,"miterLimit",{get:function(){return this.ctx.miterLimit},set:function(t){isNaN(t)||(this.ctx.miterLimit=t,this.pdf.setMiterLimit(t))}}),Object.defineProperty(this,"textBaseline",{get:function(){return this.ctx.textBaseline},set:function(t){this.ctx.textBaseline=t}}),Object.defineProperty(this,"textAlign",{get:function(){return this.ctx.textAlign},set:function(t){-1!==["right","end","center","left","start"].indexOf(t)&&(this.ctx.textAlign=t)}});var l=null;var h=null;Object.defineProperty(this,"fontFaces",{get:function(){return h},set:function(t){l=null,h=t}}),Object.defineProperty(this,"font",{get:function(){return this.ctx.font},set:function(t){var e;if(this.ctx.font=t,null!==(e=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-_,\"\'\sa-z]+?)\s*$/i.exec(t))){var n=e[1];e[2];var r=e[3],i=e[4];e[5];var a=e[6],o=/^([.\d]+)((?:%|in|[cem]m|ex|p[ctx]))$/i.exec(i)[2];i="px"===o?Math.floor(parseFloat(i)*this.pdf.internal.scaleFactor):"em"===o?Math.floor(parseFloat(i)*this.pdf.getFontSize()):Math.floor(parseFloat(i)*this.pdf.internal.scaleFactor),this.pdf.setFontSize(i);var s=function(t){var e,n,r=[],i=t.trim();if(""===i)return Jt;if(i in Mt)return[Mt[i]];for(;""!==i;){switch(n=null,e=(i=Et(i)).charAt(0)){case'"':case"'":n=Rt(i.substring(1),e);break;default:n=Dt(i)}if(null===n)return Jt;if(r.push(n[0]),""!==(i=Et(n[1]))&&","!==i.charAt(0))return Jt;i=i.replace(/^,/,"")}return r}(a);if(this.fontFaces){var u=function(t,e){if(null===l){var n=function(t){var e=[];return Object.keys(t).forEach(function(n){t[n].forEach(function(t){var r=null;switch(t){case"bold":r={family:n,weight:"bold"};break;case"italic":r={family:n,style:"italic"};break;case"bolditalic":r={family:n,weight:"bold",style:"italic"};break;case"":case"normal":r={family:n}}null!==r&&(r.ref={name:n,style:t},e.push(r))})}),e}(t.getFontList());l=function(t){for(var e={},n=0;n<t.length;++n){var r=Ct(t[n]),i=r.family,a=r.stretch,o=r.style,s=r.weight;e[i]=e[i]||{},e[i][a]=e[i][a]||{},e[i][a][o]=e[i][a][o]||{},e[i][a][o][s]=r}return e}(n.concat(e))}return l}(this.pdf,this.fontFaces),c=s.map(function(t){return{family:t,stretch:"normal",weight:r,style:n}}),h=function(t,e,n){for(var r=(n=n||{}).defaultFontFamily||"times",i=Object.assign({},Bt,n.genericFontFamilies||{}),a=null,o=null,s=0;s<e.length;++s)if(i[(a=Ct(e[s])).family]&&(a.family=i[a.family]),t.hasOwnProperty(a.family)){o=t[a.family];break}if(!(o=o||t[r]))throw new Error("Could not find a font-family for the rule '"+qt(a)+"' and default family '"+r+"'.");if(o=function(t,e){if(e[t])return e[t];var n=Ft[t],r=n<=Ft.normal?-1:1,i=Ot(e,kt,n,r);if(!i)throw new Error("Could not find a matching font-stretch value for "+t);return i}(a.stretch,o),o=function(t,e){if(e[t])return e[t];for(var n=Pt[t],r=0;r<n.length;++r)if(e[n[r]])return e[n[r]];throw new Error("Could not find a matching font-style for "+t)}(a.style,o),!(o=function(t,e){if(e[t])return e[t];if(400===t&&e[500])return e[500];if(500===t&&e[400])return e[400];var n=jt[t],r=Ot(e,It,n,t<400?-1:1);if(!r)throw new Error("Could not find a matching font-weight for value "+t);return r}(a.weight,o)))throw new Error("Failed to resolve a font for the rule '"+qt(a)+"'.");return o}(u,c);this.pdf.setFont(h.ref.name,h.ref.style)}else{var f="";("bold"===r||parseInt(r,10)>=700||"bold"===n)&&(f="bold"),"italic"===n&&(f+="italic"),0===f.length&&(f="normal");for(var d="",p={arial:"Helvetica",Arial:"Helvetica",verdana:"Helvetica",Verdana:"Helvetica",helvetica:"Helvetica",Helvetica:"Helvetica","sans-serif":"Helvetica",fixed:"Courier",monospace:"Courier",terminal:"Courier",cursive:"Times",fantasy:"Times",serif:"Times"},g=0;g<s.length;g++){if(void 0!==this.pdf.internal.getFont(s[g],f,{noFallback:!0,disableWarning:!0})){d=s[g];break}if("bolditalic"===f&&void 0!==this.pdf.internal.getFont(s[g],"bold",{noFallback:!0,disableWarning:!0}))d=s[g],f="bold";else if(void 0!==this.pdf.internal.getFont(s[g],"normal",{noFallback:!0,disableWarning:!0})){d=s[g],f="normal";break}}if(""===d)for(var m=0;m<s.length;m++)if(p[s[m]]){d=p[s[m]];break}d=""===d?"Times":d,this.pdf.setFont(d,f)}}}}),Object.defineProperty(this,"globalCompositeOperation",{get:function(){return this.ctx.globalCompositeOperation},set:function(t){this.ctx.globalCompositeOperation=t}}),Object.defineProperty(this,"globalAlpha",{get:function(){return this.ctx.globalAlpha},set:function(t){this.ctx.globalAlpha=t}}),Object.defineProperty(this,"lineDashOffset",{get:function(){return this.ctx.lineDashOffset},set:function(t){this.ctx.lineDashOffset=t,T.call(this)}}),Object.defineProperty(this,"lineDash",{get:function(){return this.ctx.lineDash},set:function(t){this.ctx.lineDash=t,T.call(this)}}),Object.defineProperty(this,"ignoreClearRect",{get:function(){return this.ctx.ignoreClearRect},set:function(t){this.ctx.ignoreClearRect=Boolean(t)}})};p.prototype.setLineDash=function(t){this.lineDash=t},p.prototype.getLineDash=function(){return this.lineDash.length%2?this.lineDash.concat(this.lineDash):this.lineDash.slice()},p.prototype.fill=function(){x.call(this,"fill",!1)},p.prototype.stroke=function(){x.call(this,"stroke",!1)},p.prototype.beginPath=function(){this.path=[{type:"begin"}]},p.prototype.moveTo=function(t,e){if(isNaN(t)||isNaN(e))throw o.error("jsPDF.context2d.moveTo: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.moveTo");var n=this.ctx.transform.applyToPoint(new u(t,e));this.path.push({type:"mt",x:n.x,y:n.y}),this.ctx.lastPoint=new u(t,e)},p.prototype.closePath=function(){var e=new u(0,0),n=0;for(n=this.path.length-1;-1!==n;n--)if("begin"===this.path[n].type&&"object"===t(this.path[n+1])&&"number"==typeof this.path[n+1].x){e=new u(this.path[n+1].x,this.path[n+1].y);break}this.path.push({type:"close"}),this.ctx.lastPoint=new u(e.x,e.y)},p.prototype.lineTo=function(t,e){if(isNaN(t)||isNaN(e))throw o.error("jsPDF.context2d.lineTo: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.lineTo");var n=this.ctx.transform.applyToPoint(new u(t,e));this.path.push({type:"lt",x:n.x,y:n.y}),this.ctx.lastPoint=new u(n.x,n.y)},p.prototype.clip=function(){this.ctx.clip_path=JSON.parse(JSON.stringify(this.path)),x.call(this,null,!0)},p.prototype.quadraticCurveTo=function(t,e,n,r){if(isNaN(n)||isNaN(r)||isNaN(t)||isNaN(e))throw o.error("jsPDF.context2d.quadraticCurveTo: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.quadraticCurveTo");var i=this.ctx.transform.applyToPoint(new u(n,r)),a=this.ctx.transform.applyToPoint(new u(t,e));this.path.push({type:"qct",x1:a.x,y1:a.y,x:i.x,y:i.y}),this.ctx.lastPoint=new u(i.x,i.y)},p.prototype.bezierCurveTo=function(t,e,n,r,i,a){if(isNaN(i)||isNaN(a)||isNaN(t)||isNaN(e)||isNaN(n)||isNaN(r))throw o.error("jsPDF.context2d.bezierCurveTo: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.bezierCurveTo");var s=this.ctx.transform.applyToPoint(new u(i,a)),c=this.ctx.transform.applyToPoint(new u(t,e)),l=this.ctx.transform.applyToPoint(new u(n,r));this.path.push({type:"bct",x1:c.x,y1:c.y,x2:l.x,y2:l.y,x:s.x,y:s.y}),this.ctx.lastPoint=new u(s.x,s.y)},p.prototype.arc=function(t,e,n,r,i,a){if(isNaN(t)||isNaN(e)||isNaN(n)||isNaN(r)||isNaN(i))throw o.error("jsPDF.context2d.arc: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.arc");if(a=Boolean(a),!this.ctx.transform.isIdentity){var s=this.ctx.transform.applyToPoint(new u(t,e));t=s.x,e=s.y;var c=this.ctx.transform.applyToPoint(new u(0,n)),l=this.ctx.transform.applyToPoint(new u(0,0));n=Math.sqrt(Math.pow(c.x-l.x,2)+Math.pow(c.y-l.y,2))}Math.abs(i-r)>=2*Math.PI&&(r=0,i=2*Math.PI),this.path.push({type:"arc",x:t,y:e,radius:n,startAngle:r,endAngle:i,counterclockwise:a})},p.prototype.arcTo=function(t,e,n,r,i){throw new Error("arcTo not implemented.")},p.prototype.rect=function(t,e,n,r){if(isNaN(t)||isNaN(e)||isNaN(n)||isNaN(r))throw o.error("jsPDF.context2d.rect: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.rect");this.moveTo(t,e),this.lineTo(t+n,e),this.lineTo(t+n,e+r),this.lineTo(t,e+r),this.lineTo(t,e),this.lineTo(t+n,e),this.lineTo(t,e)},p.prototype.fillRect=function(t,e,n,r){if(isNaN(t)||isNaN(e)||isNaN(n)||isNaN(r))throw o.error("jsPDF.context2d.fillRect: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.fillRect");if(!m.call(this)){var i={};"butt"!==this.lineCap&&(i.lineCap=this.lineCap,this.lineCap="butt"),"miter"!==this.lineJoin&&(i.lineJoin=this.lineJoin,this.lineJoin="miter"),this.beginPath(),this.rect(t,e,n,r),this.fill(),i.hasOwnProperty("lineCap")&&(this.lineCap=i.lineCap),i.hasOwnProperty("lineJoin")&&(this.lineJoin=i.lineJoin)}},p.prototype.strokeRect=function(t,e,n,r){if(isNaN(t)||isNaN(e)||isNaN(n)||isNaN(r))throw o.error("jsPDF.context2d.strokeRect: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.strokeRect");v.call(this)||(this.beginPath(),this.rect(t,e,n,r),this.stroke())},p.prototype.clearRect=function(t,e,n,r){if(isNaN(t)||isNaN(e)||isNaN(n)||isNaN(r))throw o.error("jsPDF.context2d.clearRect: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.clearRect");this.ignoreClearRect||(this.fillStyle="#ffffff",this.fillRect(t,e,n,r))},p.prototype.save=function(t){t="boolean"!=typeof t||t;for(var e=this.pdf.internal.getCurrentPageInfo().pageNumber,n=0;n<this.pdf.internal.getNumberOfPages();n++)this.pdf.setPage(n+1),this.pdf.internal.out("q");if(this.pdf.setPage(e),t){this.ctx.fontSize=this.pdf.internal.getFontSize();var r=new d(this.ctx);this.ctxStack.push(this.ctx),this.ctx=r}},p.prototype.restore=function(t){t="boolean"!=typeof t||t;for(var e=this.pdf.internal.getCurrentPageInfo().pageNumber,n=0;n<this.pdf.internal.getNumberOfPages();n++)this.pdf.setPage(n+1),this.pdf.internal.out("Q");this.pdf.setPage(e),t&&0!==this.ctxStack.length&&(this.ctx=this.ctxStack.pop(),this.fillStyle=this.ctx.fillStyle,this.strokeStyle=this.ctx.strokeStyle,this.font=this.ctx.font,this.lineCap=this.ctx.lineCap,this.lineWidth=this.ctx.lineWidth,this.lineJoin=this.ctx.lineJoin,this.lineDash=this.ctx.lineDash,this.lineDashOffset=this.ctx.lineDashOffset)},p.prototype.toDataURL=function(){throw new Error("toDataUrl not implemented.")};var g=function(t){var e,n,r,i;if(!0===t.isCanvasGradient&&(t=t.getColor()),!t)return{r:0,g:0,b:0,a:0,style:t};if(/transparent|rgba\s*\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*0+\s*\)/.test(t))e=0,n=0,r=0,i=0;else{var a=/rgb\s*\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)/.exec(t);if(null!==a)e=parseInt(a[1]),n=parseInt(a[2]),r=parseInt(a[3]),i=1;else if(null!==(a=/rgba\s*\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*([\d.]+)\s*\)/.exec(t)))e=parseInt(a[1]),n=parseInt(a[2]),r=parseInt(a[3]),i=parseFloat(a[4]);else{if(i=1,"string"==typeof t&&"#"!==t.charAt(0)){var o=new h(t);t=o.ok?o.toHex():"#000000"}4===t.length?(e=t.substring(1,2),e+=e,n=t.substring(2,3),n+=n,r=t.substring(3,4),r+=r):(e=t.substring(1,3),n=t.substring(3,5),r=t.substring(5,7)),e=parseInt(e,16),n=parseInt(n,16),r=parseInt(r,16)}}return{r:e,g:n,b:r,a:i,style:t}},m=function(){return this.ctx.isFillTransparent||0==this.globalAlpha},v=function(){return Boolean(this.ctx.isStrokeTransparent||0==this.globalAlpha)};p.prototype.fillText=function(t,e,n,r){if(isNaN(e)||isNaN(n)||"string"!=typeof t)throw o.error("jsPDF.context2d.fillText: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.fillText");if(r=isNaN(r)?void 0:r,!m.call(this)){var i=E(this.ctx.transform.rotation),a=this.ctx.transform.scaleX;j.call(this,{text:t,x:e,y:n,scale:a,angle:i,align:this.textAlign,maxWidth:r})}},p.prototype.strokeText=function(t,e,n,r){if(isNaN(e)||isNaN(n)||"string"!=typeof t)throw o.error("jsPDF.context2d.strokeText: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.strokeText");if(!v.call(this)){r=isNaN(r)?void 0:r;var i=E(this.ctx.transform.rotation),a=this.ctx.transform.scaleX;j.call(this,{text:t,x:e,y:n,scale:a,renderingMode:"stroke",angle:i,align:this.textAlign,maxWidth:r})}},p.prototype.measureText=function(t){if("string"!=typeof t)throw o.error("jsPDF.context2d.measureText: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.measureText");var e=this.pdf,n=this.pdf.internal.scaleFactor,r=e.internal.getFontSize(),i=e.getStringUnitWidth(t)*r/e.internal.scaleFactor;return new function(t){var e=(t=t||{}).width||0;return Object.defineProperty(this,"width",{get:function(){return e}}),this}({width:i*=Math.round(96*n/72*1e4)/1e4})},p.prototype.scale=function(t,e){if(isNaN(t)||isNaN(e))throw o.error("jsPDF.context2d.scale: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.scale");var n=new l(t,0,0,e,0,0);this.ctx.transform=this.ctx.transform.multiply(n)},p.prototype.rotate=function(t){if(isNaN(t))throw o.error("jsPDF.context2d.rotate: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.rotate");var e=new l(Math.cos(t),Math.sin(t),-Math.sin(t),Math.cos(t),0,0);this.ctx.transform=this.ctx.transform.multiply(e)},p.prototype.translate=function(t,e){if(isNaN(t)||isNaN(e))throw o.error("jsPDF.context2d.translate: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.translate");var n=new l(1,0,0,1,t,e);this.ctx.transform=this.ctx.transform.multiply(n)},p.prototype.transform=function(t,e,n,r,i,a){if(isNaN(t)||isNaN(e)||isNaN(n)||isNaN(r)||isNaN(i)||isNaN(a))throw o.error("jsPDF.context2d.transform: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.transform");var s=new l(t,e,n,r,i,a);this.ctx.transform=this.ctx.transform.multiply(s)},p.prototype.setTransform=function(t,e,n,r,i,a){t=isNaN(t)?1:t,e=isNaN(e)?0:e,n=isNaN(n)?0:n,r=isNaN(r)?1:r,i=isNaN(i)?0:i,a=isNaN(a)?0:a,this.ctx.transform=new l(t,e,n,r,i,a)};var b=function(){return this.margin[0]>0||this.margin[1]>0||this.margin[2]>0||this.margin[3]>0};p.prototype.drawImage=function(t,e,n,r,i,a,o,s,u){var h=this.pdf.getImageProperties(t),f=1,d=1,p=1,g=1;void 0!==r&&void 0!==s&&(p=s/r,g=u/i,f=h.width/r*s/r,d=h.height/i*u/i),void 0===a&&(a=e,o=n,e=0,n=0),void 0!==r&&void 0===s&&(s=r,u=i),void 0===r&&void 0===s&&(s=h.width,u=h.height);for(var m,v=this.ctx.transform.decompose(),w=E(v.rotate.shx),x=new l,S=(x=(x=(x=x.multiply(v.translate)).multiply(v.skew)).multiply(v.scale)).applyToRectangle(new c(a-e*p,o-n*g,r*f,i*d)),_=y.call(this,S),P=[],k=0;k<_.length;k+=1)-1===P.indexOf(_[k])&&P.push(_[k]);if(L(P),this.autoPaging)for(var F=P[0],I=P[P.length-1],j=F;j<I+1;j++){this.pdf.setPage(j);var C=this.pdf.internal.pageSize.width-this.margin[3]-this.margin[1],O=1===j?this.posY+this.margin[0]:this.margin[0],B=this.pdf.internal.pageSize.height-this.posY-this.margin[0]-this.margin[2],M=this.pdf.internal.pageSize.height-this.margin[0]-this.margin[2],q=1===j?0:B+(j-2)*M;if(0!==this.ctx.clip_path.length){var R=this.path;m=JSON.parse(JSON.stringify(this.ctx.clip_path)),this.path=N(m,this.posX+this.margin[3],-q+O+this.ctx.prevPageLastElemOffset),A.call(this,"fill",!0),this.path=R}var D=JSON.parse(JSON.stringify(S));D=N([D],this.posX+this.margin[3],-q+O+this.ctx.prevPageLastElemOffset)[0];var T=(j>F||j<I)&&b.call(this);T&&(this.pdf.saveGraphicsState(),this.pdf.rect(this.margin[3],this.margin[0],C,M,null).clip().discardPath()),this.pdf.addImage(t,"JPEG",D.x,D.y,D.w,D.h,null,null,w),T&&this.pdf.restoreGraphicsState()}else this.pdf.addImage(t,"JPEG",S.x,S.y,S.w,S.h,null,null,w)};var y=function(t,e,n){var r=[];e=e||this.pdf.internal.pageSize.width,n=n||this.pdf.internal.pageSize.height-this.margin[0]-this.margin[2];var i=this.posY+this.ctx.prevPageLastElemOffset;switch(t.type){default:case"mt":case"lt":r.push(Math.floor((t.y+i)/n)+1);break;case"arc":r.push(Math.floor((t.y+i-t.radius)/n)+1),r.push(Math.floor((t.y+i+t.radius)/n)+1);break;case"qct":var a=R(this.ctx.lastPoint.x,this.ctx.lastPoint.y,t.x1,t.y1,t.x,t.y);r.push(Math.floor((a.y+i)/n)+1),r.push(Math.floor((a.y+a.h+i)/n)+1);break;case"bct":var o=D(this.ctx.lastPoint.x,this.ctx.lastPoint.y,t.x1,t.y1,t.x2,t.y2,t.x,t.y);r.push(Math.floor((o.y+i)/n)+1),r.push(Math.floor((o.y+o.h+i)/n)+1);break;case"rect":r.push(Math.floor((t.y+i)/n)+1),r.push(Math.floor((t.y+t.h+i)/n)+1)}for(var s=0;s<r.length;s+=1)for(;this.pdf.internal.getNumberOfPages()<r[s];)w.call(this);return r},w=function(){var t=this.fillStyle,e=this.strokeStyle,n=this.font,r=this.lineCap,i=this.lineWidth,a=this.lineJoin;this.pdf.addPage(),this.fillStyle=t,this.strokeStyle=e,this.font=n,this.lineCap=r,this.lineWidth=i,this.lineJoin=a},N=function(t,e,n){for(var r=0;r<t.length;r++)switch(t[r].type){case"bct":t[r].x2+=e,t[r].y2+=n;case"qct":t[r].x1+=e,t[r].y1+=n;default:t[r].x+=e,t[r].y+=n}return t},L=function(t){return t.sort(function(t,e){return t-e})},x=function(t,e){for(var n,r,i=this.fillStyle,a=this.strokeStyle,o=this.lineCap,s=this.lineWidth,u=Math.abs(s*this.ctx.transform.scaleX),c=this.lineJoin,l=JSON.parse(JSON.stringify(this.path)),h=JSON.parse(JSON.stringify(this.path)),f=[],d=0;d<h.length;d++)if(void 0!==h[d].x)for(var p=y.call(this,h[d]),g=0;g<p.length;g+=1)-1===f.indexOf(p[g])&&f.push(p[g]);for(var m=0;m<f.length;m++)for(;this.pdf.internal.getNumberOfPages()<f[m];)w.call(this);if(L(f),this.autoPaging)for(var v=f[0],x=f[f.length-1],S=v;S<x+1;S++){this.pdf.setPage(S),this.fillStyle=i,this.strokeStyle=a,this.lineCap=o,this.lineWidth=u,this.lineJoin=c;var _=this.pdf.internal.pageSize.width-this.margin[3]-this.margin[1],P=1===S?this.posY+this.margin[0]:this.margin[0],k=this.pdf.internal.pageSize.height-this.posY-this.margin[0]-this.margin[2],F=this.pdf.internal.pageSize.height-this.margin[0]-this.margin[2],I=1===S?0:k+(S-2)*F;if(0!==this.ctx.clip_path.length){var j=this.path;n=JSON.parse(JSON.stringify(this.ctx.clip_path)),this.path=N(n,this.posX+this.margin[3],-I+P+this.ctx.prevPageLastElemOffset),A.call(this,t,!0),this.path=j}if(r=JSON.parse(JSON.stringify(l)),this.path=N(r,this.posX+this.margin[3],-I+P+this.ctx.prevPageLastElemOffset),!1===e||0===S){var C=(S>v||S<x)&&b.call(this);C&&(this.pdf.saveGraphicsState(),this.pdf.rect(this.margin[3],this.margin[0],_,F,null).clip().discardPath()),A.call(this,t,e),C&&this.pdf.restoreGraphicsState()}this.lineWidth=s}else this.lineWidth=u,A.call(this,t,e),this.lineWidth=s;this.path=l},A=function(t,e){if(("stroke"!==t||e||!v.call(this))&&("stroke"===t||e||!m.call(this))){for(var n,r,i=[],a=this.path,o=0;o<a.length;o++){var s=a[o];switch(s.type){case"begin":i.push({begin:!0});break;case"close":i.push({close:!0});break;case"mt":i.push({start:s,deltas:[],abs:[]});break;case"lt":var u=i.length;if(a[o-1]&&!isNaN(a[o-1].x)&&(n=[s.x-a[o-1].x,s.y-a[o-1].y],u>0))for(;u>=0;u--)if(!0!==i[u-1].close&&!0!==i[u-1].begin){i[u-1].deltas.push(n),i[u-1].abs.push(s);break}break;case"bct":n=[s.x1-a[o-1].x,s.y1-a[o-1].y,s.x2-a[o-1].x,s.y2-a[o-1].y,s.x-a[o-1].x,s.y-a[o-1].y],i[i.length-1].deltas.push(n);break;case"qct":var c=a[o-1].x+2/3*(s.x1-a[o-1].x),l=a[o-1].y+2/3*(s.y1-a[o-1].y),h=s.x+2/3*(s.x1-s.x),f=s.y+2/3*(s.y1-s.y),d=s.x,p=s.y;n=[c-a[o-1].x,l-a[o-1].y,h-a[o-1].x,f-a[o-1].y,d-a[o-1].x,p-a[o-1].y],i[i.length-1].deltas.push(n);break;case"arc":i.push({deltas:[],abs:[],arc:!0}),Array.isArray(i[i.length-1].abs)&&i[i.length-1].abs.push(s)}}r=e?null:"stroke"===t?"stroke":"fill";for(var g=!1,b=0;b<i.length;b++)if(i[b].arc)for(var y=i[b].abs,w=0;w<y.length;w++){var N=y[w];"arc"===N.type?P.call(this,N.x,N.y,N.radius,N.startAngle,N.endAngle,N.counterclockwise,void 0,e,!g):C.call(this,N.x,N.y),g=!0}else if(!0===i[b].close)this.pdf.internal.out("h"),g=!1;else if(!0!==i[b].begin){var L=i[b].start.x,x=i[b].start.y;O.call(this,i[b].deltas,L,x),g=!0}r&&k.call(this,r),e&&F.call(this)}},S=function(t){var e=this.pdf.internal.getFontSize()/this.pdf.internal.scaleFactor,n=e*(this.pdf.internal.getLineHeightFactor()-1);switch(this.ctx.textBaseline){case"bottom":return t-n;case"top":return t+e-n;case"hanging":return t+e-2*n;case"middle":return t+e/2-n;default:return t}},_=function(t){return t+this.pdf.internal.getFontSize()/this.pdf.internal.scaleFactor*(this.pdf.internal.getLineHeightFactor()-1)};p.prototype.createLinearGradient=function(){var t=function(){};return t.colorStops=[],t.addColorStop=function(t,e){this.colorStops.push([t,e])},t.getColor=function(){return 0===this.colorStops.length?"#000000":this.colorStops[0][1]},t.isCanvasGradient=!0,t},p.prototype.createPattern=function(){return this.createLinearGradient()},p.prototype.createRadialGradient=function(){return this.createLinearGradient()};var P=function(t,e,n,r,i,a,o,s,u){for(var c=M.call(this,n,r,i,a),l=0;l<c.length;l++){var h=c[l];0===l&&(u?I.call(this,h.x1+t,h.y1+e):C.call(this,h.x1+t,h.y1+e)),B.call(this,t,e,h.x2,h.y2,h.x3,h.y3,h.x4,h.y4)}s?F.call(this):k.call(this,o)},k=function(t){switch(t){case"stroke":this.pdf.internal.out("S");break;case"fill":this.pdf.internal.out("f")}},F=function(){this.pdf.clip(),this.pdf.discardPath()},I=function(t,e){this.pdf.internal.out(r(t)+" "+i(e)+" m")},j=function(t){var e;switch(t.align){case"right":case"end":e="right";break;case"center":e="center";break;default:e="left"}var n=this.pdf.getTextDimensions(t.text),r=S.call(this,t.y),i=_.call(this,r)-n.h,a=this.ctx.transform.applyToPoint(new u(t.x,r)),o=this.ctx.transform.decompose(),s=new l;s=(s=(s=s.multiply(o.translate)).multiply(o.skew)).multiply(o.scale);for(var h,f,d,p=this.ctx.transform.applyToRectangle(new c(t.x,r,n.w,n.h)),g=s.applyToRectangle(new c(t.x,i,n.w,n.h)),m=y.call(this,g),v=[],w=0;w<m.length;w+=1)-1===v.indexOf(m[w])&&v.push(m[w]);if(L(v),this.autoPaging)for(var x=v[0],P=v[v.length-1],k=x;k<P+1;k++){this.pdf.setPage(k);var F=1===k?this.posY+this.margin[0]:this.margin[0],I=this.pdf.internal.pageSize.height-this.posY-this.margin[0]-this.margin[2],j=this.pdf.internal.pageSize.height-this.margin[2],C=j-this.margin[0],O=this.pdf.internal.pageSize.width-this.margin[1],B=O-this.margin[3],M=1===k?0:I+(k-2)*C;if(0!==this.ctx.clip_path.length){var q=this.path;h=JSON.parse(JSON.stringify(this.ctx.clip_path)),this.path=N(h,this.posX+this.margin[3],-1*M+F),A.call(this,"fill",!0),this.path=q}var E=N([JSON.parse(JSON.stringify(g))],this.posX+this.margin[3],-M+F+this.ctx.prevPageLastElemOffset)[0];t.scale>=.01&&(f=this.pdf.internal.getFontSize(),this.pdf.setFontSize(f*t.scale),d=this.lineWidth,this.lineWidth=d*t.scale);var R="text"!==this.autoPaging;if(R||E.y+E.h<=j){if(R||E.y>=F&&E.x<=O){var D=R?t.text:this.pdf.splitTextToSize(t.text,t.maxWidth||O-E.x)[0],T=N([JSON.parse(JSON.stringify(p))],this.posX+this.margin[3],-M+F+this.ctx.prevPageLastElemOffset)[0],z=R&&(k>x||k<P)&&b.call(this);z&&(this.pdf.saveGraphicsState(),this.pdf.rect(this.margin[3],this.margin[0],B,C,null).clip().discardPath()),this.pdf.text(D,T.x,T.y,{angle:t.angle,align:e,renderingMode:t.renderingMode}),z&&this.pdf.restoreGraphicsState()}}else E.y<j&&(this.ctx.prevPageLastElemOffset+=j-E.y);t.scale>=.01&&(this.pdf.setFontSize(f),this.lineWidth=d)}else t.scale>=.01&&(f=this.pdf.internal.getFontSize(),this.pdf.setFontSize(f*t.scale),d=this.lineWidth,this.lineWidth=d*t.scale),this.pdf.text(t.text,a.x+this.posX,a.y+this.posY,{angle:t.angle,align:e,renderingMode:t.renderingMode,maxWidth:t.maxWidth}),t.scale>=.01&&(this.pdf.setFontSize(f),this.lineWidth=d)},C=function(t,e,n,a){n=n||0,a=a||0,this.pdf.internal.out(r(t+n)+" "+i(e+a)+" l")},O=function(t,e,n){return this.pdf.lines(t,e,n,null,null)},B=function(t,e,r,i,o,u,c,l){this.pdf.internal.out([n(a(r+t)),n(s(i+e)),n(a(o+t)),n(s(u+e)),n(a(c+t)),n(s(l+e)),"c"].join(" "))},M=function(t,e,n,r){for(var i=2*Math.PI,a=Math.PI/2;e>n;)e-=i;var o=Math.abs(n-e);o<i&&r&&(o=i-o);for(var s=[],u=r?-1:1,c=e;o>1e-5;){var l=c+u*Math.min(o,a);s.push(q.call(this,t,c,l)),o-=Math.abs(l-c),c=l}return s},q=function(t,e,n){var r=(n-e)/2,i=t*Math.cos(r),a=t*Math.sin(r),o=i,s=-a,u=o*o+s*s,c=u+o*i+s*a,l=4/3*(Math.sqrt(2*u*c)-c)/(o*a-s*i),h=o-l*s,f=s+l*o,d=h,p=-f,g=r+e,m=Math.cos(g),v=Math.sin(g);return{x1:t*Math.cos(e),y1:t*Math.sin(e),x2:h*m-f*v,y2:h*v+f*m,x3:d*m-p*v,y3:d*v+p*m,x4:t*Math.cos(n),y4:t*Math.sin(n)}},E=function(t){return 180*t/Math.PI},R=function(t,e,n,r,i,a){var o=t+.5*(n-t),s=e+.5*(r-e),u=i+.5*(n-i),l=a+.5*(r-a),h=Math.min(t,i,o,u),f=Math.max(t,i,o,u),d=Math.min(e,a,s,l),p=Math.max(e,a,s,l);return new c(h,d,f-h,p-d)},D=function(t,e,n,r,i,a,o,s){var u,l,h,f,d,p,g,m,v,b,y,w,N,L,x=n-t,A=r-e,S=i-n,_=a-r,P=o-i,k=s-a;for(l=0;l<41;l++)v=(g=(h=t+(u=l/40)*x)+u*((d=n+u*S)-h))+u*(d+u*(i+u*P-d)-g),b=(m=(f=e+u*A)+u*((p=r+u*_)-f))+u*(p+u*(a+u*k-p)-m),0==l?(y=v,w=b,N=v,L=b):(y=Math.min(y,v),w=Math.min(w,b),N=Math.max(N,v),L=Math.max(L,b));return new c(Math.round(y),Math.round(w),Math.round(N-y),Math.round(L-w))},T=function(){if(this.prevLineDash||this.ctx.lineDash.length||this.ctx.lineDashOffset){var t,e,n=(t=this.ctx.lineDash,e=this.ctx.lineDashOffset,JSON.stringify({lineDash:t,lineDashOffset:e}));this.prevLineDash!==n&&(this.pdf.setLineDash(this.ctx.lineDash,this.ctx.lineDashOffset),this.prevLineDash=n)}}}(E.API),
/**
 * @license
 * jsPDF filters PlugIn
 * Copyright (c) 2014 Aras Abbasi
 *
 * Licensed under the MIT License.
 * http://opensource.org/licenses/mit-license
 */
function(t){var n=function(t){var e,n,r,i,a,o,s,u,c,l;for(/[^\x00-\xFF]/.test(t),n=[],r=0,i=(t+=e="\0\0\0\0".slice(t.length%4||4)).length;i>r;r+=4)0!==(a=(t.charCodeAt(r)<<24)+(t.charCodeAt(r+1)<<16)+(t.charCodeAt(r+2)<<8)+t.charCodeAt(r+3))?(o=(a=((a=((a=((a=(a-(l=a%85))/85)-(c=a%85))/85)-(u=a%85))/85)-(s=a%85))/85)%85,n.push(o+33,s+33,u+33,c+33,l+33)):n.push(122);return function(t,e){for(var n=e;n>0;n--)t.pop()}(n,e.length),String.fromCharCode.apply(String,n)+"~>"},r=function(t){var e,n,r,i,a,o=String,s="length",u=255,c="charCodeAt",l="slice",h="replace";for(t[l](-2),t=t[l](0,-2)[h](/\s/g,"")[h]("z","!!!!!"),r=[],i=0,a=(t+=e="uuuuu"[l](t[s]%5||5))[s];a>i;i+=5)n=52200625*(t[c](i)-33)+614125*(t[c](i+1)-33)+7225*(t[c](i+2)-33)+85*(t[c](i+3)-33)+(t[c](i+4)-33),r.push(u&n>>24,u&n>>16,u&n>>8,u&n);return function(t,e){for(var n=e;n>0;n--)t.pop()}(r,e[s]),o.fromCharCode.apply(o,r)},i=function(t){return t.split("").map(function(t){return("0"+t.charCodeAt().toString(16)).slice(-2)}).join("")+">"},a=function(t){var e=new RegExp(/^([0-9A-Fa-f]{2})+$/);if(-1!==(t=t.replace(/\s/g,"")).indexOf(">")&&(t=t.substr(0,t.indexOf(">"))),t.length%2&&(t+="0"),!1===e.test(t))return"";for(var n="",r=0;r<t.length;r+=2)n+=String.fromCharCode("0x"+(t[r]+t[r+1]));return n},o=function(t){for(var n=new Uint8Array(t.length),r=t.length;r--;)n[r]=t.charCodeAt(r);return(n=e(n)).reduce(function(t,e){return t+String.fromCharCode(e)},"")};t.processDataByFilters=function(t,e){var s=0,u=t||"",c=[];for("string"==typeof(e=e||[])&&(e=[e]),s=0;s<e.length;s+=1)switch(e[s]){case"ASCII85Decode":case"/ASCII85Decode":u=r(u),c.push("/ASCII85Encode");break;case"ASCII85Encode":case"/ASCII85Encode":u=n(u),c.push("/ASCII85Decode");break;case"ASCIIHexDecode":case"/ASCIIHexDecode":u=a(u),c.push("/ASCIIHexEncode");break;case"ASCIIHexEncode":case"/ASCIIHexEncode":u=i(u),c.push("/ASCIIHexDecode");break;case"FlateEncode":case"/FlateEncode":u=o(u),c.push("/FlateDecode");break;default:throw new Error('The filter: "'+e[s]+'" is not implemented')}return{data:u,reverseChain:c.reverse().join(" ")}}}(E.API),
/**
 * @license
 * jsPDF fileloading PlugIn
 * Copyright (c) 2018 Aras Abbasi (aras.abbasi@gmail.com)
 *
 * Licensed under the MIT License.
 * http://opensource.org/licenses/mit-license
 */
function(t){t.loadFile=function(t,e,n){return function(t,e,n){e=!1!==e,n="function"==typeof n?n:function(){};var r=void 0;try{r=function(t,e,n){var r=new XMLHttpRequest,i=0,a=function(t){var e=t.length,n=[],r=String.fromCharCode;for(i=0;i<e;i+=1)n.push(r(255&t.charCodeAt(i)));return n.join("")};if(r.open("GET",t,!e),r.overrideMimeType("text/plain; charset=x-user-defined"),!1===e&&(r.onload=function(){200===r.status?n(a(this.responseText)):n(void 0)}),r.send(null),e&&200===r.status)return a(r.responseText)}(t,e,n)}catch(i){}return r}(t,e,n)},t.loadImageFile=t.loadFile}(E.API),function(e){function n(){return(i.html2canvas?Promise.resolve(i.html2canvas):import("html2canvas")).catch(function(t){return Promise.reject(new Error("Could not load html2canvas: "+t))}).then(function(t){return t.default?t.default:t})}function r(){return(i.DOMPurify?Promise.resolve(i.DOMPurify):import("dompurify")).catch(function(t){return Promise.reject(new Error("Could not load dompurify: "+t))}).then(function(t){return t.default?t.default:t})}var a=function(e){var n=t(e);return"undefined"===n?"undefined":"string"===n||e instanceof String?"string":"number"===n||e instanceof Number?"number":"function"===n||e instanceof Function?"function":e&&e.constructor===Array?"array":e&&1===e.nodeType?"element":"object"===n?"object":"unknown"},o=function(t,e){var n=document.createElement(t);for(var r in e.className&&(n.className=e.className),e.innerHTML&&e.dompurify&&(n.innerHTML=e.dompurify.sanitize(e.innerHTML)),e.style)n.style[r]=e.style[r];return n},s=function t(e,n){for(var r=3===e.nodeType?document.createTextNode(e.nodeValue):e.cloneNode(!1),i=e.firstChild;i;i=i.nextSibling)!0!==n&&1===i.nodeType&&"SCRIPT"===i.nodeName||r.appendChild(t(i,n));return 1===e.nodeType&&("CANVAS"===e.nodeName?(r.width=e.width,r.height=e.height,r.getContext("2d").drawImage(e,0,0)):"TEXTAREA"!==e.nodeName&&"SELECT"!==e.nodeName||(r.value=e.value),r.addEventListener("load",function(){r.scrollTop=e.scrollTop,r.scrollLeft=e.scrollLeft},!0)),r},u=function t(e){var n=Object.assign(t.convert(Promise.resolve()),JSON.parse(JSON.stringify(t.template))),r=t.convert(Promise.resolve(),n);return(r=r.setProgress(1,t,1,[t])).set(e)};(u.prototype=Object.create(Promise.prototype)).constructor=u,u.convert=function(t,e){return t.__proto__=e||u.prototype,t},u.template={prop:{src:null,container:null,overlay:null,canvas:null,img:null,pdf:null,pageSize:null,callback:function(){}},progress:{val:0,state:null,n:0,stack:[]},opt:{filename:"file.pdf",margin:[0,0,0,0],enableLinks:!0,x:0,y:0,html2canvas:{},jsPDF:{},backgroundColor:"transparent"}},u.prototype.from=function(t,e){return this.then(function(){switch(e=e||function(t){switch(a(t)){case"string":return"string";case"element":return"canvas"===t.nodeName.toLowerCase()?"canvas":"element";default:return"unknown"}}(t),e){case"string":return this.then(r).then(function(e){return this.set({src:o("div",{innerHTML:t,dompurify:e})})});case"element":return this.set({src:t});case"canvas":return this.set({canvas:t});case"img":return this.set({img:t});default:return this.error("Unknown source type.")}})},u.prototype.to=function(t){switch(t){case"container":return this.toContainer();case"canvas":return this.toCanvas();case"img":return this.toImg();case"pdf":return this.toPdf();default:return this.error("Invalid target.")}},u.prototype.toContainer=function(){return this.thenList([function(){return this.prop.src||this.error("Cannot duplicate - no source HTML.")},function(){return this.prop.pageSize||this.setPageSize()}]).then(function(){var t={position:"relative",display:"inline-block",width:("number"!=typeof this.opt.width||isNaN(this.opt.width)||"number"!=typeof this.opt.windowWidth||isNaN(this.opt.windowWidth)?Math.max(this.prop.src.clientWidth,this.prop.src.scrollWidth,this.prop.src.offsetWidth):this.opt.windowWidth)+"px",left:0,right:0,top:0,margin:"auto",backgroundColor:this.opt.backgroundColor},e=s(this.prop.src,this.opt.html2canvas.javascriptEnabled);"BODY"===e.tagName&&(t.height=Math.max(document.body.scrollHeight,document.body.offsetHeight,document.documentElement.clientHeight,document.documentElement.scrollHeight,document.documentElement.offsetHeight)+"px"),this.prop.overlay=o("div",{className:"html2pdf__overlay",style:{position:"fixed",overflow:"hidden",zIndex:1e3,left:"-100000px",right:0,bottom:0,top:0}}),this.prop.container=o("div",{className:"html2pdf__container",style:t}),this.prop.container.appendChild(e),this.prop.container.firstChild.appendChild(o("div",{style:{clear:"both",border:"0 none transparent",margin:0,padding:0,height:0}})),this.prop.container.style.float="none",this.prop.overlay.appendChild(this.prop.container),document.body.appendChild(this.prop.overlay),this.prop.container.firstChild.style.position="relative",this.prop.container.height=Math.max(this.prop.container.firstChild.clientHeight,this.prop.container.firstChild.scrollHeight,this.prop.container.firstChild.offsetHeight)+"px"})},u.prototype.toCanvas=function(){var t=[function(){return document.body.contains(this.prop.container)||this.toContainer()}];return this.thenList(t).then(n).then(function(t){var e=Object.assign({},this.opt.html2canvas);return delete e.onrendered,t(this.prop.container,e)}).then(function(t){(this.opt.html2canvas.onrendered||function(){})(t),this.prop.canvas=t,document.body.removeChild(this.prop.overlay)})},u.prototype.toContext2d=function(){var t=[function(){return document.body.contains(this.prop.container)||this.toContainer()}];return this.thenList(t).then(n).then(function(t){var e=this.opt.jsPDF,n=this.opt.fontFaces,r="number"!=typeof this.opt.width||isNaN(this.opt.width)||"number"!=typeof this.opt.windowWidth||isNaN(this.opt.windowWidth)?1:this.opt.width/this.opt.windowWidth,i=Object.assign({async:!0,allowTaint:!0,scale:r,scrollX:this.opt.scrollX||0,scrollY:this.opt.scrollY||0,backgroundColor:"#ffffff",imageTimeout:15e3,logging:!0,proxy:null,removeContainer:!0,foreignObjectRendering:!1,useCORS:!1},this.opt.html2canvas);if(delete i.onrendered,e.context2d.autoPaging=void 0===this.opt.autoPaging||this.opt.autoPaging,e.context2d.posX=this.opt.x,e.context2d.posY=this.opt.y,e.context2d.margin=this.opt.margin,e.context2d.fontFaces=n,n)for(var a=0;a<n.length;++a){var o=n[a],s=o.src.find(function(t){return"truetype"===t.format});s&&e.addFont(s.url,o.ref.name,o.ref.style)}return i.windowHeight=i.windowHeight||0,i.windowHeight=0==i.windowHeight?Math.max(this.prop.container.clientHeight,this.prop.container.scrollHeight,this.prop.container.offsetHeight):i.windowHeight,e.context2d.save(!0),t(this.prop.container,i)}).then(function(t){this.opt.jsPDF.context2d.restore(!0),(this.opt.html2canvas.onrendered||function(){})(t),this.prop.canvas=t,document.body.removeChild(this.prop.overlay)})},u.prototype.toImg=function(){return this.thenList([function(){return this.prop.canvas||this.toCanvas()}]).then(function(){var t=this.prop.canvas.toDataURL("image/"+this.opt.image.type,this.opt.image.quality);this.prop.img=document.createElement("img"),this.prop.img.src=t})},u.prototype.toPdf=function(){return this.thenList([function(){return this.toContext2d()}]).then(function(){this.prop.pdf=this.prop.pdf||this.opt.jsPDF})},u.prototype.output=function(t,e,n){return"img"===(n=n||"pdf").toLowerCase()||"image"===n.toLowerCase()?this.outputImg(t,e):this.outputPdf(t,e)},u.prototype.outputPdf=function(t,e){return this.thenList([function(){return this.prop.pdf||this.toPdf()}]).then(function(){return this.prop.pdf.output(t,e)})},u.prototype.outputImg=function(t){return this.thenList([function(){return this.prop.img||this.toImg()}]).then(function(){switch(t){case void 0:case"img":return this.prop.img;case"datauristring":case"dataurlstring":return this.prop.img.src;case"datauri":case"dataurl":return document.location.href=this.prop.img.src;default:throw'Image output type "'+t+'" is not supported.'}})},u.prototype.save=function(t){return this.thenList([function(){return this.prop.pdf||this.toPdf()}]).set(t?{filename:t}:null).then(function(){this.prop.pdf.save(this.opt.filename)})},u.prototype.doCallback=function(){return this.thenList([function(){return this.prop.pdf||this.toPdf()}]).then(function(){this.prop.callback(this.prop.pdf)})},u.prototype.set=function(t){if("object"!==a(t))return this;var e=Object.keys(t||{}).map(function(e){if(e in u.template.prop)return function(){this.prop[e]=t[e]};switch(e){case"margin":return this.setMargin.bind(this,t.margin);case"jsPDF":return function(){return this.opt.jsPDF=t.jsPDF,this.setPageSize()};case"pageSize":return this.setPageSize.bind(this,t.pageSize);default:return function(){this.opt[e]=t[e]}}},this);return this.then(function(){return this.thenList(e)})},u.prototype.get=function(t,e){return this.then(function(){var n=t in u.template.prop?this.prop[t]:this.opt[t];return e?e(n):n})},u.prototype.setMargin=function(t){return this.then(function(){switch(a(t)){case"number":t=[t,t,t,t];case"array":if(2===t.length&&(t=[t[0],t[1],t[0],t[1]]),4===t.length)break;default:return this.error("Invalid margin array.")}this.opt.margin=t}).then(this.setPageSize)},u.prototype.setPageSize=function(t){function e(t,e){return Math.floor(t*e/72*96)}return this.then(function(){(t=t||E.getPageSize(this.opt.jsPDF)).hasOwnProperty("inner")||(t.inner={width:t.width-this.opt.margin[1]-this.opt.margin[3],height:t.height-this.opt.margin[0]-this.opt.margin[2]},t.inner.px={width:e(t.inner.width,t.k),height:e(t.inner.height,t.k)},t.inner.ratio=t.inner.height/t.inner.width),this.prop.pageSize=t})},u.prototype.setProgress=function(t,e,n,r){return null!=t&&(this.progress.val=t),null!=e&&(this.progress.state=e),null!=n&&(this.progress.n=n),null!=r&&(this.progress.stack=r),this.progress.ratio=this.progress.val/this.progress.state,this},u.prototype.updateProgress=function(t,e,n,r){return this.setProgress(t?this.progress.val+t:null,e||null,n?this.progress.n+n:null,r?this.progress.stack.concat(r):null)},u.prototype.then=function(t,e){var n=this;return this.thenCore(t,e,function(t,e){return n.updateProgress(null,null,1,[t]),Promise.prototype.then.call(this,function(e){return n.updateProgress(null,t),e}).then(t,e).then(function(t){return n.updateProgress(1),t})})},u.prototype.thenCore=function(t,e,n){n=n||Promise.prototype.then;var r=this;t&&(t=t.bind(r)),e&&(e=e.bind(r));var i=-1!==Promise.toString().indexOf("[native code]")&&"Promise"===Promise.name?r:u.convert(Object.assign({},r),Promise.prototype),a=n.call(i,t,e);return u.convert(a,r.__proto__)},u.prototype.thenExternal=function(t,e){return Promise.prototype.then.call(this,t,e)},u.prototype.thenList=function(t){var e=this;return t.forEach(function(t){e=e.thenCore(t)}),e},u.prototype.catch=function(t){t&&(t=t.bind(this));var e=Promise.prototype.catch.call(this,t);return u.convert(e,this)},u.prototype.catchExternal=function(t){return Promise.prototype.catch.call(this,t)},u.prototype.error=function(t){return this.then(function(){throw new Error(t)})},u.prototype.using=u.prototype.set,u.prototype.saveAs=u.prototype.save,u.prototype.export=u.prototype.output,u.prototype.run=u.prototype.then,E.getPageSize=function(e,n,r){if("object"===t(e)){var i=e;e=i.orientation,n=i.unit||n,r=i.format||r}n=n||"mm",r=r||"a4",e=(""+(e||"P")).toLowerCase();var a,o=(""+r).toLowerCase(),s={a0:[2383.94,3370.39],a1:[1683.78,2383.94],a2:[1190.55,1683.78],a3:[841.89,1190.55],a4:[595.28,841.89],a5:[419.53,595.28],a6:[297.64,419.53],a7:[209.76,297.64],a8:[147.4,209.76],a9:[104.88,147.4],a10:[73.7,104.88],b0:[2834.65,4008.19],b1:[2004.09,2834.65],b2:[1417.32,2004.09],b3:[1000.63,1417.32],b4:[708.66,1000.63],b5:[498.9,708.66],b6:[354.33,498.9],b7:[249.45,354.33],b8:[175.75,249.45],b9:[124.72,175.75],b10:[87.87,124.72],c0:[2599.37,3676.54],c1:[1836.85,2599.37],c2:[1298.27,1836.85],c3:[918.43,1298.27],c4:[649.13,918.43],c5:[459.21,649.13],c6:[323.15,459.21],c7:[229.61,323.15],c8:[161.57,229.61],c9:[113.39,161.57],c10:[79.37,113.39],dl:[311.81,623.62],letter:[612,792],"government-letter":[576,756],legal:[612,1008],"junior-legal":[576,360],ledger:[1224,792],tabloid:[792,1224],"credit-card":[153,243]};switch(n){case"pt":a=1;break;case"mm":a=72/25.4;break;case"cm":a=72/2.54;break;case"in":a=72;break;case"px":a=.75;break;case"pc":case"em":a=12;break;case"ex":a=6;break;default:throw"Invalid unit: "+n}var u,c=0,l=0;if(s.hasOwnProperty(o))c=s[o][1]/a,l=s[o][0]/a;else try{c=r[1],l=r[0]}catch(h){throw new Error("Invalid format: "+r)}if("p"===e||"portrait"===e)e="p",l>c&&(u=l,l=c,c=u);else{if("l"!==e&&"landscape"!==e)throw"Invalid orientation: "+e;e="l",c>l&&(u=l,l=c,c=u)}return{width:l,height:c,unit:n,k:a,orientation:e}},e.html=function(t,e){(e=e||{}).callback=e.callback||function(){},e.html2canvas=e.html2canvas||{},e.html2canvas.canvas=e.html2canvas.canvas||this.canvas,e.jsPDF=e.jsPDF||this,e.fontFaces=e.fontFaces?e.fontFaces.map(Ct):null;var n=new u(e);return e.worker?n:n.from(t).doCallback()}}(E.API),E.API.addJS=function(t){return Ut=t,this.internal.events.subscribe("postPutResources",function(){Tt=this.internal.newObject(),this.internal.out("<<"),this.internal.out("/Names [(EmbeddedJS) "+(Tt+1)+" 0 R]"),this.internal.out(">>"),this.internal.out("endobj"),zt=this.internal.newObject(),this.internal.out("<<"),this.internal.out("/S /JavaScript"),this.internal.out("/JS ("+Ut+")"),this.internal.out(">>"),this.internal.out("endobj")}),this.internal.events.subscribe("putCatalog",function(){void 0!==Tt&&void 0!==zt&&this.internal.out("/Names <</JavaScript "+Tt+" 0 R>>")}),this},
/**
 * @license
 * Copyright (c) 2014 Steven Spungin (TwelveTone LLC)  steven@twelvetone.tv
 *
 * Licensed under the MIT License.
 * http://opensource.org/licenses/mit-license
 */
function(t){var e;t.events.push(["postPutResources",function(){var t=this,n=/^(\d+) 0 obj$/;if(this.outline.root.children.length>0)for(var r=t.outline.render().split(/\r\n/),i=0;i<r.length;i++){var a=r[i],o=n.exec(a);if(null!=o){var s=o[1];t.internal.newObjectDeferredBegin(s,!1)}t.internal.write(a)}if(this.outline.createNamedDestinations){var u=this.internal.pages.length,c=[];for(i=0;i<u;i++){var l=t.internal.newObject();c.push(l);var h=t.internal.getPageInfo(i+1);t.internal.write("<< /D["+h.objId+" 0 R /XYZ null null null]>> endobj")}var f=t.internal.newObject();for(t.internal.write("<< /Names [ "),i=0;i<c.length;i++)t.internal.write("(page_"+(i+1)+")"+c[i]+" 0 R");t.internal.write(" ] >>","endobj"),e=t.internal.newObject(),t.internal.write("<< /Dests "+f+" 0 R"),t.internal.write(">>","endobj")}}]),t.events.push(["putCatalog",function(){var t=this;t.outline.root.children.length>0&&(t.internal.write("/Outlines",this.outline.makeRef(this.outline.root)),this.outline.createNamedDestinations&&t.internal.write("/Names "+e+" 0 R"))}]),t.events.push(["initialized",function(){var t=this;t.outline={createNamedDestinations:!1,root:{children:[]}},t.outline.add=function(t,e,n){var r={title:e,options:n,children:[]};return null==t&&(t=this.root),t.children.push(r),r},t.outline.render=function(){return this.ctx={},this.ctx.val="",this.ctx.pdf=t,this.genIds_r(this.root),this.renderRoot(this.root),this.renderItems(this.root),this.ctx.val},t.outline.genIds_r=function(e){e.id=t.internal.newObjectDeferred();for(var n=0;n<e.children.length;n++)this.genIds_r(e.children[n])},t.outline.renderRoot=function(t){this.objStart(t),this.line("/Type /Outlines"),t.children.length>0&&(this.line("/First "+this.makeRef(t.children[0])),this.line("/Last "+this.makeRef(t.children[t.children.length-1]))),this.line("/Count "+this.count_r({count:0},t)),this.objEnd()},t.outline.renderItems=function(e){for(var n=this.ctx.pdf.internal.getVerticalCoordinateString,r=0;r<e.children.length;r++){var i=e.children[r];this.objStart(i),this.line("/Title "+this.makeString(i.title)),this.line("/Parent "+this.makeRef(e)),r>0&&this.line("/Prev "+this.makeRef(e.children[r-1])),r<e.children.length-1&&this.line("/Next "+this.makeRef(e.children[r+1])),i.children.length>0&&(this.line("/First "+this.makeRef(i.children[0])),this.line("/Last "+this.makeRef(i.children[i.children.length-1])));var a=this.count=this.count_r({count:0},i);if(a>0&&this.line("/Count "+a),i.options&&i.options.pageNumber){var o=t.internal.getPageInfo(i.options.pageNumber);this.line("/Dest ["+o.objId+" 0 R /XYZ 0 "+n(0)+" 0]")}this.objEnd()}for(var s=0;s<e.children.length;s++)this.renderItems(e.children[s])},t.outline.line=function(t){this.ctx.val+=t+"\r\n"},t.outline.makeRef=function(t){return t.id+" 0 R"},t.outline.makeString=function(e){return"("+t.internal.pdfEscape(e)+")"},t.outline.objStart=function(t){this.ctx.val+="\r\n"+t.id+" 0 obj\r\n<<\r\n"},t.outline.objEnd=function(){this.ctx.val+=">> \r\nendobj\r\n"},t.outline.count_r=function(t,e){for(var n=0;n<e.children.length;n++)t.count++,this.count_r(t,e.children[n]);return t.count}}])}(E.API),
/**
 * @license
 *
 * Licensed under the MIT License.
 * http://opensource.org/licenses/mit-license
 */
function(t){var e=[192,193,194,195,196,197,198,199];t.processJPEG=function(t,n,r,i,a,o){var s,u=this.decode.DCT_DECODE,c=null;if("string"==typeof t||this.__addimage__.isArrayBuffer(t)||this.__addimage__.isArrayBufferView(t)){switch(t=a||t,t=this.__addimage__.isArrayBuffer(t)?new Uint8Array(t):t,s=function(t){for(var n,r=256*t.charCodeAt(4)+t.charCodeAt(5),i=t.length,a={width:0,height:0,numcomponents:1},o=4;o<i;o+=2){if(o+=r,-1!==e.indexOf(t.charCodeAt(o+1))){n=256*t.charCodeAt(o+5)+t.charCodeAt(o+6),a={width:256*t.charCodeAt(o+7)+t.charCodeAt(o+8),height:n,numcomponents:t.charCodeAt(o+9)};break}r=256*t.charCodeAt(o+2)+t.charCodeAt(o+3)}return a}(t=this.__addimage__.isArrayBufferView(t)?this.__addimage__.arrayBufferToBinaryString(t):t),s.numcomponents){case 1:o=this.color_spaces.DEVICE_GRAY;break;case 4:o=this.color_spaces.DEVICE_CMYK;break;case 3:o=this.color_spaces.DEVICE_RGB}c={data:t,width:s.width,height:s.height,colorSpace:o,bitsPerComponent:8,filter:u,index:n,alias:r}}return c}}(E.API),E.API.processPNG=function(t,i,a,o){if(this.__addimage__.isArrayBuffer(t)&&(t=new Uint8Array(t)),this.__addimage__.isArrayBufferView(t)){var s,u=r(t,{checkCrc:!0}),c=u.width,l=u.height,h=u.channels,f=u.palette,d=u.depth;s=f&&1===h?function(t){for(var e=t.width,r=t.height,i=t.data,a=t.palette,o=t.depth,s=!1,u=[],c=[],l=void 0,h=!1,f=0,d=0;d<a.length;d++){var p=n(a[d],4),g=p[0],m=p[1],v=p[2],b=p[3];u.push(g,m,v),null!=b&&(0===b?(f++,c.length<1&&c.push(d)):b<255&&(h=!0))}if(h||f>1){s=!0,c=void 0;var y=e*r;l=new Uint8Array(y);for(var w=new DataView(i.buffer),N=0;N<y;N++){var L=re(w,N,o),x=n(a[L],4)[3];l[N]=x}}return{colorSpace:"Indexed",colorsPerPixel:1,colorBytes:i,alphaBytes:l,needSMask:s,palette:u,mask:c}}(u):2===h||4===h?function(t){for(var e=t.data,n=t.width,r=t.height,i=t.channels,a=t.depth,o=2===i?"DeviceGray":"DeviceRGB",s=i-1,u=n*r,c=s,l=u*c,h=1*u,f=Math.ceil(l*a/8),d=Math.ceil(h*a/8),p=new Uint8Array(f),g=new Uint8Array(d),m=new DataView(e.buffer),v=new DataView(p.buffer),b=new DataView(g.buffer),y=!1,w=0;w<u;w++){for(var N=w*i,L=0;L<c;L++)ie(v,re(m,N+L,a),w*c+L,a);var x=re(m,N+c,a);x<(1<<a)-1&&(y=!0),ie(b,x,1*w,a)}return{colorSpace:o,colorsPerPixel:s,colorBytes:p,alphaBytes:g,needSMask:y}}(u):function(t){var e=t.data,n=1===t.channels?"DeviceGray":"DeviceRGB";return{colorSpace:n,colorsPerPixel:"DeviceGray"===n?1:3,colorBytes:e instanceof Uint8Array?e:new Uint8Array(e.buffer),needSMask:!1}}(u);var p,g,m,v=s,b=v.colorSpace,y=v.colorsPerPixel,w=v.colorBytes,N=v.alphaBytes,L=v.needSMask,x=v.palette,A=v.mask,S=null;return o!==E.API.image_compression.NONE&&"function"==typeof e?(S=function(t){var e;switch(t){case E.API.image_compression.FAST:e=11;break;case E.API.image_compression.MEDIUM:e=13;break;case E.API.image_compression.SLOW:e=14;break;default:e=12}return e}(o),p=this.decode.FLATE_DECODE,g="/Predictor ".concat(S," "),t=Xt(w,c*y,y,o),L&&(m=Xt(N,c,1,o))):(p=void 0,g="",t=w,L&&(m=N)),g+="/Colors ".concat(y," /BitsPerComponent ").concat(d," /Columns ").concat(c),(this.__addimage__.isArrayBuffer(t)||this.__addimage__.isArrayBufferView(t))&&(t=this.__addimage__.arrayBufferToBinaryString(t)),(m&&this.__addimage__.isArrayBuffer(m)||this.__addimage__.isArrayBufferView(m))&&(m=this.__addimage__.arrayBufferToBinaryString(m)),{alias:a,data:t,index:i,filter:p,decodeParameters:g,transparency:A,palette:x,sMask:m,predictor:S,width:c,height:l,bitsPerComponent:d,colorSpace:b}}},function(t){t.processGIF89A=function(e,n,r,i){var a=new oe(e),o=a.width,s=a.height,u=[];a.decodeAndBlitFrameRGBA(0,u);var c={data:u,width:o,height:s},l=new ue(100).encode(c,100);return t.processJPEG.call(this,l,n,r,i)},t.processGIF87A=t.processGIF89A}(E.API),ce.prototype.parseHeader=function(){if(this.fileSize=this.datav.getUint32(this.pos,!0),this.pos+=4,this.reserved=this.datav.getUint32(this.pos,!0),this.pos+=4,this.offset=this.datav.getUint32(this.pos,!0),this.pos+=4,this.headerSize=this.datav.getUint32(this.pos,!0),this.pos+=4,this.width=this.datav.getUint32(this.pos,!0),this.pos+=4,this.height=this.datav.getInt32(this.pos,!0),this.pos+=4,this.planes=this.datav.getUint16(this.pos,!0),this.pos+=2,this.bitPP=this.datav.getUint16(this.pos,!0),this.pos+=2,this.compress=this.datav.getUint32(this.pos,!0),this.pos+=4,this.rawSize=this.datav.getUint32(this.pos,!0),this.pos+=4,this.hr=this.datav.getUint32(this.pos,!0),this.pos+=4,this.vr=this.datav.getUint32(this.pos,!0),this.pos+=4,this.colors=this.datav.getUint32(this.pos,!0),this.pos+=4,this.importantColors=this.datav.getUint32(this.pos,!0),this.pos+=4,16===this.bitPP&&this.is_with_alpha&&(this.bitPP=15),this.bitPP<15){var t=0===this.colors?1<<this.bitPP:this.colors;this.palette=new Array(t);for(var e=0;e<t;e++){var n=this.datav.getUint8(this.pos++,!0),r=this.datav.getUint8(this.pos++,!0),i=this.datav.getUint8(this.pos++,!0),a=this.datav.getUint8(this.pos++,!0);this.palette[e]={red:i,green:r,blue:n,quad:a}}}this.height<0&&(this.height*=-1,this.bottom_up=!1)},ce.prototype.parseBGR=function(){this.pos=this.offset;try{var t="bit"+this.bitPP,e=this.width*this.height*4;this.data=new Uint8Array(e),this[t]()}catch(n){o.log("bit decode error:"+n)}},ce.prototype.bit1=function(){var t,e=Math.ceil(this.width/8),n=e%4;for(t=this.height-1;t>=0;t--){for(var r=this.bottom_up?t:this.height-1-t,i=0;i<e;i++)for(var a=this.datav.getUint8(this.pos++,!0),o=r*this.width*4+8*i*4,s=0;s<8&&8*i+s<this.width;s++){var u=this.palette[a>>7-s&1];this.data[o+4*s]=u.blue,this.data[o+4*s+1]=u.green,this.data[o+4*s+2]=u.red,this.data[o+4*s+3]=255}0!==n&&(this.pos+=4-n)}},ce.prototype.bit4=function(){for(var t=Math.ceil(this.width/2),e=t%4,n=this.height-1;n>=0;n--){for(var r=this.bottom_up?n:this.height-1-n,i=0;i<t;i++){var a=this.datav.getUint8(this.pos++,!0),o=r*this.width*4+2*i*4,s=a>>4,u=15&a,c=this.palette[s];if(this.data[o]=c.blue,this.data[o+1]=c.green,this.data[o+2]=c.red,this.data[o+3]=255,2*i+1>=this.width)break;c=this.palette[u],this.data[o+4]=c.blue,this.data[o+4+1]=c.green,this.data[o+4+2]=c.red,this.data[o+4+3]=255}0!==e&&(this.pos+=4-e)}},ce.prototype.bit8=function(){for(var t=this.width%4,e=this.height-1;e>=0;e--){for(var n=this.bottom_up?e:this.height-1-e,r=0;r<this.width;r++){var i=this.datav.getUint8(this.pos++,!0),a=n*this.width*4+4*r;if(i<this.palette.length){var o=this.palette[i];this.data[a]=o.red,this.data[a+1]=o.green,this.data[a+2]=o.blue,this.data[a+3]=255}else this.data[a]=255,this.data[a+1]=255,this.data[a+2]=255,this.data[a+3]=255}0!==t&&(this.pos+=4-t)}},ce.prototype.bit15=function(){for(var t=this.width%3,e=parseInt("11111",2),n=this.height-1;n>=0;n--){for(var r=this.bottom_up?n:this.height-1-n,i=0;i<this.width;i++){var a=this.datav.getUint16(this.pos,!0);this.pos+=2;var o=(a&e)/e*255|0,s=(a>>5&e)/e*255|0,u=(a>>10&e)/e*255|0,c=a>>15?255:0,l=r*this.width*4+4*i;this.data[l]=u,this.data[l+1]=s,this.data[l+2]=o,this.data[l+3]=c}this.pos+=t}},ce.prototype.bit16=function(){for(var t=this.width%3,e=parseInt("11111",2),n=parseInt("111111",2),r=this.height-1;r>=0;r--){for(var i=this.bottom_up?r:this.height-1-r,a=0;a<this.width;a++){var o=this.datav.getUint16(this.pos,!0);this.pos+=2;var s=(o&e)/e*255|0,u=(o>>5&n)/n*255|0,c=(o>>11)/e*255|0,l=i*this.width*4+4*a;this.data[l]=c,this.data[l+1]=u,this.data[l+2]=s,this.data[l+3]=255}this.pos+=t}},ce.prototype.bit24=function(){for(var t=this.height-1;t>=0;t--){for(var e=this.bottom_up?t:this.height-1-t,n=0;n<this.width;n++){var r=this.datav.getUint8(this.pos++,!0),i=this.datav.getUint8(this.pos++,!0),a=this.datav.getUint8(this.pos++,!0),o=e*this.width*4+4*n;this.data[o]=a,this.data[o+1]=i,this.data[o+2]=r,this.data[o+3]=255}this.pos+=this.width%4}},ce.prototype.bit32=function(){for(var t=this.height-1;t>=0;t--)for(var e=this.bottom_up?t:this.height-1-t,n=0;n<this.width;n++){var r=this.datav.getUint8(this.pos++,!0),i=this.datav.getUint8(this.pos++,!0),a=this.datav.getUint8(this.pos++,!0),o=this.datav.getUint8(this.pos++,!0),s=e*this.width*4+4*n;this.data[s]=a,this.data[s+1]=i,this.data[s+2]=r,this.data[s+3]=o}},ce.prototype.getData=function(){return this.data},
/**
 * @license
 * Copyright (c) 2018 Aras Abbasi
 *
 * Licensed under the MIT License.
 * http://opensource.org/licenses/mit-license
 */
function(t){t.processBMP=function(e,n,r,i){var a=new ce(e,!1),o=a.width,s=a.height,u={data:a.getData(),width:o,height:s},c=new ue(100).encode(u,100);return t.processJPEG.call(this,c,n,r,i)}}(E.API),le.prototype.getData=function(){return this.data},
/**
 * @license
 * Copyright (c) 2019 Aras Abbasi
 *
 * Licensed under the MIT License.
 * http://opensource.org/licenses/mit-license
 */
function(t){t.processWEBP=function(e,n,r,i){var a=new le(e),o=a.width,s=a.height,u={data:a.getData(),width:o,height:s},c=new ue(100).encode(u,100);return t.processJPEG.call(this,c,n,r,i)}}(E.API),E.API.processRGBA=function(t,e,n){for(var r=t.data,i=r.length,a=new Uint8Array(i/4*3),o=new Uint8Array(i/4),s=0,u=0,c=0;c<i;c+=4){var l=r[c],h=r[c+1],f=r[c+2],d=r[c+3];a[s++]=l,a[s++]=h,a[s++]=f,o[u++]=d}var p=this.__addimage__.arrayBufferToBinaryString(a);return{alpha:this.__addimage__.arrayBufferToBinaryString(o),data:p,index:e,alias:n,colorSpace:"DeviceRGB",bitsPerComponent:8,width:t.width,height:t.height}},E.API.setLanguage=function(t){return void 0===this.internal.languageSettings&&(this.internal.languageSettings={},this.internal.languageSettings.isSubscribed=!1),void 0!=={af:"Afrikaans",sq:"Albanian",ar:"Arabic (Standard)","ar-DZ":"Arabic (Algeria)","ar-BH":"Arabic (Bahrain)","ar-EG":"Arabic (Egypt)","ar-IQ":"Arabic (Iraq)","ar-JO":"Arabic (Jordan)","ar-KW":"Arabic (Kuwait)","ar-LB":"Arabic (Lebanon)","ar-LY":"Arabic (Libya)","ar-MA":"Arabic (Morocco)","ar-OM":"Arabic (Oman)","ar-QA":"Arabic (Qatar)","ar-SA":"Arabic (Saudi Arabia)","ar-SY":"Arabic (Syria)","ar-TN":"Arabic (Tunisia)","ar-AE":"Arabic (U.A.E.)","ar-YE":"Arabic (Yemen)",an:"Aragonese",hy:"Armenian",as:"Assamese",ast:"Asturian",az:"Azerbaijani",eu:"Basque",be:"Belarusian",bn:"Bengali",bs:"Bosnian",br:"Breton",bg:"Bulgarian",my:"Burmese",ca:"Catalan",ch:"Chamorro",ce:"Chechen",zh:"Chinese","zh-HK":"Chinese (Hong Kong)","zh-CN":"Chinese (PRC)","zh-SG":"Chinese (Singapore)","zh-TW":"Chinese (Taiwan)",cv:"Chuvash",co:"Corsican",cr:"Cree",hr:"Croatian",cs:"Czech",da:"Danish",nl:"Dutch (Standard)","nl-BE":"Dutch (Belgian)",en:"English","en-AU":"English (Australia)","en-BZ":"English (Belize)","en-CA":"English (Canada)","en-IE":"English (Ireland)","en-JM":"English (Jamaica)","en-NZ":"English (New Zealand)","en-PH":"English (Philippines)","en-ZA":"English (South Africa)","en-TT":"English (Trinidad & Tobago)","en-GB":"English (United Kingdom)","en-US":"English (United States)","en-ZW":"English (Zimbabwe)",eo:"Esperanto",et:"Estonian",fo:"Faeroese",fj:"Fijian",fi:"Finnish",fr:"French (Standard)","fr-BE":"French (Belgium)","fr-CA":"French (Canada)","fr-FR":"French (France)","fr-LU":"French (Luxembourg)","fr-MC":"French (Monaco)","fr-CH":"French (Switzerland)",fy:"Frisian",fur:"Friulian",gd:"Gaelic (Scots)","gd-IE":"Gaelic (Irish)",gl:"Galacian",ka:"Georgian",de:"German (Standard)","de-AT":"German (Austria)","de-DE":"German (Germany)","de-LI":"German (Liechtenstein)","de-LU":"German (Luxembourg)","de-CH":"German (Switzerland)",el:"Greek",gu:"Gujurati",ht:"Haitian",he:"Hebrew",hi:"Hindi",hu:"Hungarian",is:"Icelandic",id:"Indonesian",iu:"Inuktitut",ga:"Irish",it:"Italian (Standard)","it-CH":"Italian (Switzerland)",ja:"Japanese",kn:"Kannada",ks:"Kashmiri",kk:"Kazakh",km:"Khmer",ky:"Kirghiz",tlh:"Klingon",ko:"Korean","ko-KP":"Korean (North Korea)","ko-KR":"Korean (South Korea)",la:"Latin",lv:"Latvian",lt:"Lithuanian",lb:"Luxembourgish",mk:"North Macedonia",ms:"Malay",ml:"Malayalam",mt:"Maltese",mi:"Maori",mr:"Marathi",mo:"Moldavian",nv:"Navajo",ng:"Ndonga",ne:"Nepali",no:"Norwegian",nb:"Norwegian (Bokmal)",nn:"Norwegian (Nynorsk)",oc:"Occitan",or:"Oriya",om:"Oromo",fa:"Persian","fa-IR":"Persian/Iran",pl:"Polish",pt:"Portuguese","pt-BR":"Portuguese (Brazil)",pa:"Punjabi","pa-IN":"Punjabi (India)","pa-PK":"Punjabi (Pakistan)",qu:"Quechua",rm:"Rhaeto-Romanic",ro:"Romanian","ro-MO":"Romanian (Moldavia)",ru:"Russian","ru-MO":"Russian (Moldavia)",sz:"Sami (Lappish)",sg:"Sango",sa:"Sanskrit",sc:"Sardinian",sd:"Sindhi",si:"Singhalese",sr:"Serbian",sk:"Slovak",sl:"Slovenian",so:"Somani",sb:"Sorbian",es:"Spanish","es-AR":"Spanish (Argentina)","es-BO":"Spanish (Bolivia)","es-CL":"Spanish (Chile)","es-CO":"Spanish (Colombia)","es-CR":"Spanish (Costa Rica)","es-DO":"Spanish (Dominican Republic)","es-EC":"Spanish (Ecuador)","es-SV":"Spanish (El Salvador)","es-GT":"Spanish (Guatemala)","es-HN":"Spanish (Honduras)","es-MX":"Spanish (Mexico)","es-NI":"Spanish (Nicaragua)","es-PA":"Spanish (Panama)","es-PY":"Spanish (Paraguay)","es-PE":"Spanish (Peru)","es-PR":"Spanish (Puerto Rico)","es-ES":"Spanish (Spain)","es-UY":"Spanish (Uruguay)","es-VE":"Spanish (Venezuela)",sx:"Sutu",sw:"Swahili",sv:"Swedish","sv-FI":"Swedish (Finland)","sv-SV":"Swedish (Sweden)",ta:"Tamil",tt:"Tatar",te:"Teluga",th:"Thai",tig:"Tigre",ts:"Tsonga",tn:"Tswana",tr:"Turkish",tk:"Turkmen",uk:"Ukrainian",hsb:"Upper Sorbian",ur:"Urdu",ve:"Venda",vi:"Vietnamese",vo:"Volapuk",wa:"Walloon",cy:"Welsh",xh:"Xhosa",ji:"Yiddish",zu:"Zulu"}[t]&&(this.internal.languageSettings.languageCode=t,!1===this.internal.languageSettings.isSubscribed&&(this.internal.events.subscribe("putCatalog",function(){this.internal.write("/Lang ("+this.internal.languageSettings.languageCode+")")}),this.internal.languageSettings.isSubscribed=!0)),this},Ht=E.API,Wt=Ht.getCharWidthsArray=function(e,n){var r,i,a=(n=n||{}).font||this.internal.getFont(),o=n.fontSize||this.internal.getFontSize(),s=n.charSpace||this.internal.getCharSpace(),u=n.widths?n.widths:a.metadata.Unicode.widths,c=u.fof?u.fof:1,l=n.kerning?n.kerning:a.metadata.Unicode.kerning,h=l.fof?l.fof:1,f=!1!==n.doKerning,d=0,p=e.length,g=0,m=u[0]||c,v=[];for(r=0;r<p;r++)i=e.charCodeAt(r),"function"==typeof a.metadata.widthOfString?v.push((a.metadata.widthOfGlyph(a.metadata.characterToGlyph(i))+s*(1e3/o)||0)/1e3):(d=f&&"object"===t(l[i])&&!isNaN(parseInt(l[i][g],10))?l[i][g]/h:0,v.push((u[i]||m)/c+d)),g=i;return v},Vt=Ht.getStringUnitWidth=function(t,e){var n=(e=e||{}).fontSize||this.internal.getFontSize(),r=e.font||this.internal.getFont(),i=e.charSpace||this.internal.getCharSpace();return Ht.processArabic&&(t=Ht.processArabic(t)),"function"==typeof r.metadata.widthOfString?r.metadata.widthOfString(t,n,i)/n:Wt.apply(this,arguments).reduce(function(t,e){return t+e},0)},Gt=function(t,e,n,r){for(var i=[],a=0,o=t.length,s=0;a!==o&&s+e[a]<n;)s+=e[a],a++;i.push(t.slice(0,a));var u=a;for(s=0;a!==o;)s+e[a]>r&&(i.push(t.slice(u,a)),s=0,u=a),s+=e[a],a++;return u!==a&&i.push(t.slice(u,a)),i},Yt=function(t,e,n){n||(n={});var r,i,a,o,s,u,c,l=[],h=[l],f=n.textIndent||0,d=0,p=0,g=t.split(" "),m=Wt.apply(this,[" ",n])[0];if(u=-1===n.lineIndent?g[0].length+2:n.lineIndent||0){var v=Array(u).join(" "),b=[];g.map(function(t){(t=t.split(/\s*\n/)).length>1?b=b.concat(t.map(function(t,e){return(e&&t.length?"\n":"")+t})):b.push(t[0])}),g=b,u=Vt.apply(this,[v,n])}for(a=0,o=g.length;a<o;a++){var y=0;if(r=g[a],u&&"\n"==r[0]&&(r=r.substr(1),y=1),f+d+(p=(i=Wt.apply(this,[r,n])).reduce(function(t,e){return t+e},0))>e||y){if(p>e){for(s=Gt.apply(this,[r,i,e-(f+d),e]),l.push(s.shift()),l=[s.pop()];s.length;)h.push([s.shift()]);p=i.slice(r.length-(l[0]?l[0].length:0)).reduce(function(t,e){return t+e},0)}else l=[r];h.push(l),f=p+u,d=m}else l.push(r),f+=d+p,d=m}return c=u?function(t,e){return(e?v:"")+t.join(" ")}:function(t){return t.join(" ")},h.map(c)},Ht.splitTextToSize=function(t,e,n){var r,i=(n=n||{}).fontSize||this.internal.getFontSize(),a=function(t){if(t.widths&&t.kerning)return{widths:t.widths,kerning:t.kerning};var e=this.internal.getFont(t.fontName,t.fontStyle),n="Unicode";return e.metadata[n]?{widths:e.metadata[n].widths||{0:1},kerning:e.metadata[n].kerning||{}}:{font:e.metadata,fontSize:this.internal.getFontSize(),charSpace:this.internal.getCharSpace()}}.call(this,n);r=Array.isArray(t)?t:String(t).split(/\r?\n/);var o=1*this.internal.scaleFactor*e/i;a.textIndent=n.textIndent?1*n.textIndent*this.internal.scaleFactor/i:0,a.lineIndent=n.lineIndent;var s,u,c=[];for(s=0,u=r.length;s<u;s++)c=c.concat(Yt.apply(this,[r[s],o,a]));return c},function(e){e.__fontmetrics__=e.__fontmetrics__||{};for(var n="0123456789abcdef",r="klmnopqrstuvwxyz",i={},a={},o=0;o<16;o++)i[r[o]]=n[o],a[n[o]]=r[o];var s=function(t){return"0x"+parseInt(t,10).toString(16)},u=e.__fontmetrics__.compress=function(e){var n,r,i,o,c=["{"];for(var l in e){if(n=e[l],isNaN(parseInt(l,10))?r="'"+l+"'":(l=parseInt(l,10),r=(r=s(l).slice(2)).slice(0,-1)+a[r.slice(-1)]),"number"==typeof n)n<0?(i=s(n).slice(3),o="-"):(i=s(n).slice(2),o=""),i=o+i.slice(0,-1)+a[i.slice(-1)];else{if("object"!==t(n))throw new Error("Don't know what to do with value type "+t(n)+".");i=u(n)}c.push(r+i)}return c.push("}"),c.join("")},c=e.__fontmetrics__.uncompress=function(t){if("string"!=typeof t)throw new Error("Invalid argument passed to uncompress.");for(var e,n,r,a,o={},s=1,u=o,c=[],l="",h="",f=t.length-1,d=1;d<f;d+=1)"'"==(a=t[d])?e?(r=e.join(""),e=void 0):e=[]:e?e.push(a):"{"==a?(c.push([u,r]),u={},r=void 0):"}"==a?((n=c.pop())[0][n[1]]=u,r=void 0,u=n[0]):"-"==a?s=-1:void 0===r?i.hasOwnProperty(a)?(l+=i[a],r=parseInt(l,16)*s,s=1,l=""):l+=a:i.hasOwnProperty(a)?(h+=i[a],u[r]=parseInt(h,16)*s,s=1,r=void 0,h=""):h+=a;return o},l={codePages:["WinAnsiEncoding"],WinAnsiEncoding:c("{19m8n201n9q201o9r201s9l201t9m201u8m201w9n201x9o201y8o202k8q202l8r202m9p202q8p20aw8k203k8t203t8v203u9v2cq8s212m9t15m8w15n9w2dw9s16k8u16l9u17s9z17x8y17y9y}")},h={Unicode:{Courier:l,"Courier-Bold":l,"Courier-BoldOblique":l,"Courier-Oblique":l,Helvetica:l,"Helvetica-Bold":l,"Helvetica-BoldOblique":l,"Helvetica-Oblique":l,"Times-Roman":l,"Times-Bold":l,"Times-BoldItalic":l,"Times-Italic":l}},f={Unicode:{"Courier-Oblique":c("{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}"),"Times-BoldItalic":c("{'widths'{k3o2q4ycx2r201n3m201o6o201s2l201t2l201u2l201w3m201x3m201y3m2k1t2l2r202m2n2n3m2o3m2p5n202q6o2r1w2s2l2t2l2u3m2v3t2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v2l3w3t3x3t3y3t3z3m4k5n4l4m4m4m4n4m4o4s4p4m4q4m4r4s4s4y4t2r4u3m4v4m4w3x4x5t4y4s4z4s5k3x5l4s5m4m5n3r5o3x5p4s5q4m5r5t5s4m5t3x5u3x5v2l5w1w5x2l5y3t5z3m6k2l6l3m6m3m6n2w6o3m6p2w6q2l6r3m6s3r6t1w6u1w6v3m6w1w6x4y6y3r6z3m7k3m7l3m7m2r7n2r7o1w7p3r7q2w7r4m7s3m7t2w7u2r7v2n7w1q7x2n7y3t202l3mcl4mal2ram3man3mao3map3mar3mas2lat4uau1uav3maw3way4uaz2lbk2sbl3t'fof'6obo2lbp3tbq3mbr1tbs2lbu1ybv3mbz3mck4m202k3mcm4mcn4mco4mcp4mcq5ycr4mcs4mct4mcu4mcv4mcw2r2m3rcy2rcz2rdl4sdm4sdn4sdo4sdp4sdq4sds4sdt4sdu4sdv4sdw4sdz3mek3mel3mem3men3meo3mep3meq4ser2wes2wet2weu2wev2wew1wex1wey1wez1wfl3rfm3mfn3mfo3mfp3mfq3mfr3tfs3mft3rfu3rfv3rfw3rfz2w203k6o212m6o2dw2l2cq2l3t3m3u2l17s3x19m3m}'kerning'{cl{4qu5kt5qt5rs17ss5ts}201s{201ss}201t{cks4lscmscnscoscpscls2wu2yu201ts}201x{2wu2yu}2k{201ts}2w{4qx5kx5ou5qx5rs17su5tu}2x{17su5tu5ou}2y{4qx5kx5ou5qx5rs17ss5ts}'fof'-6ofn{17sw5tw5ou5qw5rs}7t{cksclscmscnscoscps4ls}3u{17su5tu5os5qs}3v{17su5tu5os5qs}7p{17su5tu}ck{4qu5kt5qt5rs17ss5ts}4l{4qu5kt5qt5rs17ss5ts}cm{4qu5kt5qt5rs17ss5ts}cn{4qu5kt5qt5rs17ss5ts}co{4qu5kt5qt5rs17ss5ts}cp{4qu5kt5qt5rs17ss5ts}6l{4qu5ou5qw5rt17su5tu}5q{ckuclucmucnucoucpu4lu}5r{ckuclucmucnucoucpu4lu}7q{cksclscmscnscoscps4ls}6p{4qu5ou5qw5rt17sw5tw}ek{4qu5ou5qw5rt17su5tu}el{4qu5ou5qw5rt17su5tu}em{4qu5ou5qw5rt17su5tu}en{4qu5ou5qw5rt17su5tu}eo{4qu5ou5qw5rt17su5tu}ep{4qu5ou5qw5rt17su5tu}es{17ss5ts5qs4qu}et{4qu5ou5qw5rt17sw5tw}eu{4qu5ou5qw5rt17ss5ts}ev{17ss5ts5qs4qu}6z{17sw5tw5ou5qw5rs}fm{17sw5tw5ou5qw5rs}7n{201ts}fo{17sw5tw5ou5qw5rs}fp{17sw5tw5ou5qw5rs}fq{17sw5tw5ou5qw5rs}7r{cksclscmscnscoscps4ls}fs{17sw5tw5ou5qw5rs}ft{17su5tu}fu{17su5tu}fv{17su5tu}fw{17su5tu}fz{cksclscmscnscoscps4ls}}}"),"Helvetica-Bold":c("{'widths'{k3s2q4scx1w201n3r201o6o201s1w201t1w201u1w201w3m201x3m201y3m2k1w2l2l202m2n2n3r2o3r2p5t202q6o2r1s2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v2l3w3u3x3u3y3u3z3x4k6l4l4s4m4s4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3r4v4s4w3x4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v2l5w1w5x2l5y3u5z3r6k2l6l3r6m3x6n3r6o3x6p3r6q2l6r3x6s3x6t1w6u1w6v3r6w1w6x5t6y3x6z3x7k3x7l3x7m2r7n3r7o2l7p3x7q3r7r4y7s3r7t3r7u3m7v2r7w1w7x2r7y3u202l3rcl4sal2lam3ran3rao3rap3rar3ras2lat4tau2pav3raw3uay4taz2lbk2sbl3u'fof'6obo2lbp3xbq3rbr1wbs2lbu2obv3rbz3xck4s202k3rcm4scn4sco4scp4scq6ocr4scs4mct4mcu4mcv4mcw1w2m2zcy1wcz1wdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3xek3rel3rem3ren3reo3rep3req5ter3res3ret3reu3rev3rew1wex1wey1wez1wfl3xfm3xfn3xfo3xfp3xfq3xfr3ufs3xft3xfu3xfv3xfw3xfz3r203k6o212m6o2dw2l2cq2l3t3r3u2l17s4m19m3r}'kerning'{cl{4qs5ku5ot5qs17sv5tv}201t{2ww4wy2yw}201w{2ks}201x{2ww4wy2yw}2k{201ts201xs}2w{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}2x{5ow5qs}2y{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}'fof'-6o7p{17su5tu5ot}ck{4qs5ku5ot5qs17sv5tv}4l{4qs5ku5ot5qs17sv5tv}cm{4qs5ku5ot5qs17sv5tv}cn{4qs5ku5ot5qs17sv5tv}co{4qs5ku5ot5qs17sv5tv}cp{4qs5ku5ot5qs17sv5tv}6l{17st5tt5os}17s{2kwclvcmvcnvcovcpv4lv4wwckv}5o{2kucltcmtcntcotcpt4lt4wtckt}5q{2ksclscmscnscoscps4ls4wvcks}5r{2ks4ws}5t{2kwclvcmvcnvcovcpv4lv4wwckv}eo{17st5tt5os}fu{17su5tu5ot}6p{17ss5ts}ek{17st5tt5os}el{17st5tt5os}em{17st5tt5os}en{17st5tt5os}6o{201ts}ep{17st5tt5os}es{17ss5ts}et{17ss5ts}eu{17ss5ts}ev{17ss5ts}6z{17su5tu5os5qt}fm{17su5tu5os5qt}fn{17su5tu5os5qt}fo{17su5tu5os5qt}fp{17su5tu5os5qt}fq{17su5tu5os5qt}fs{17su5tu5os5qt}ft{17su5tu5ot}7m{5os}fv{17su5tu5ot}fw{17su5tu5ot}}}"),Courier:c("{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}"),"Courier-BoldOblique":c("{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}"),"Times-Bold":c("{'widths'{k3q2q5ncx2r201n3m201o6o201s2l201t2l201u2l201w3m201x3m201y3m2k1t2l2l202m2n2n3m2o3m2p6o202q6o2r1w2s2l2t2l2u3m2v3t2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v2l3w3t3x3t3y3t3z3m4k5x4l4s4m4m4n4s4o4s4p4m4q3x4r4y4s4y4t2r4u3m4v4y4w4m4x5y4y4s4z4y5k3x5l4y5m4s5n3r5o4m5p4s5q4s5r6o5s4s5t4s5u4m5v2l5w1w5x2l5y3u5z3m6k2l6l3m6m3r6n2w6o3r6p2w6q2l6r3m6s3r6t1w6u2l6v3r6w1w6x5n6y3r6z3m7k3r7l3r7m2w7n2r7o2l7p3r7q3m7r4s7s3m7t3m7u2w7v2r7w1q7x2r7y3o202l3mcl4sal2lam3man3mao3map3mar3mas2lat4uau1yav3maw3tay4uaz2lbk2sbl3t'fof'6obo2lbp3rbr1tbs2lbu2lbv3mbz3mck4s202k3mcm4scn4sco4scp4scq6ocr4scs4mct4mcu4mcv4mcw2r2m3rcy2rcz2rdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3rek3mel3mem3men3meo3mep3meq4ser2wes2wet2weu2wev2wew1wex1wey1wez1wfl3rfm3mfn3mfo3mfp3mfq3mfr3tfs3mft3rfu3rfv3rfw3rfz3m203k6o212m6o2dw2l2cq2l3t3m3u2l17s4s19m3m}'kerning'{cl{4qt5ks5ot5qy5rw17sv5tv}201t{cks4lscmscnscoscpscls4wv}2k{201ts}2w{4qu5ku7mu5os5qx5ru17su5tu}2x{17su5tu5ou5qs}2y{4qv5kv7mu5ot5qz5ru17su5tu}'fof'-6o7t{cksclscmscnscoscps4ls}3u{17su5tu5os5qu}3v{17su5tu5os5qu}fu{17su5tu5ou5qu}7p{17su5tu5ou5qu}ck{4qt5ks5ot5qy5rw17sv5tv}4l{4qt5ks5ot5qy5rw17sv5tv}cm{4qt5ks5ot5qy5rw17sv5tv}cn{4qt5ks5ot5qy5rw17sv5tv}co{4qt5ks5ot5qy5rw17sv5tv}cp{4qt5ks5ot5qy5rw17sv5tv}6l{17st5tt5ou5qu}17s{ckuclucmucnucoucpu4lu4wu}5o{ckuclucmucnucoucpu4lu4wu}5q{ckzclzcmzcnzcozcpz4lz4wu}5r{ckxclxcmxcnxcoxcpx4lx4wu}5t{ckuclucmucnucoucpu4lu4wu}7q{ckuclucmucnucoucpu4lu}6p{17sw5tw5ou5qu}ek{17st5tt5qu}el{17st5tt5ou5qu}em{17st5tt5qu}en{17st5tt5qu}eo{17st5tt5qu}ep{17st5tt5ou5qu}es{17ss5ts5qu}et{17sw5tw5ou5qu}eu{17sw5tw5ou5qu}ev{17ss5ts5qu}6z{17sw5tw5ou5qu5rs}fm{17sw5tw5ou5qu5rs}fn{17sw5tw5ou5qu5rs}fo{17sw5tw5ou5qu5rs}fp{17sw5tw5ou5qu5rs}fq{17sw5tw5ou5qu5rs}7r{cktcltcmtcntcotcpt4lt5os}fs{17sw5tw5ou5qu5rs}ft{17su5tu5ou5qu}7m{5os}fv{17su5tu5ou5qu}fw{17su5tu5ou5qu}fz{cksclscmscnscoscps4ls}}}"),Symbol:c("{'widths'{k3uaw4r19m3m2k1t2l2l202m2y2n3m2p5n202q6o3k3m2s2l2t2l2v3r2w1t3m3m2y1t2z1wbk2sbl3r'fof'6o3n3m3o3m3p3m3q3m3r3m3s3m3t3m3u1w3v1w3w3r3x3r3y3r3z2wbp3t3l3m5v2l5x2l5z3m2q4yfr3r7v3k7w1o7x3k}'kerning'{'fof'-6o}}"),Helvetica:c("{'widths'{k3p2q4mcx1w201n3r201o6o201s1q201t1q201u1q201w2l201x2l201y2l2k1w2l1w202m2n2n3r2o3r2p5t202q6o2r1n2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v1w3w3u3x3u3y3u3z3r4k6p4l4m4m4m4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3m4v4m4w3r4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v1w5w1w5x1w5y2z5z3r6k2l6l3r6m3r6n3m6o3r6p3r6q1w6r3r6s3r6t1q6u1q6v3m6w1q6x5n6y3r6z3r7k3r7l3r7m2l7n3m7o1w7p3r7q3m7r4s7s3m7t3m7u3m7v2l7w1u7x2l7y3u202l3rcl4mal2lam3ran3rao3rap3rar3ras2lat4tau2pav3raw3uay4taz2lbk2sbl3u'fof'6obo2lbp3rbr1wbs2lbu2obv3rbz3xck4m202k3rcm4mcn4mco4mcp4mcq6ocr4scs4mct4mcu4mcv4mcw1w2m2ncy1wcz1wdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3xek3rel3rem3ren3reo3rep3req5ter3mes3ret3reu3rev3rew1wex1wey1wez1wfl3rfm3rfn3rfo3rfp3rfq3rfr3ufs3xft3rfu3rfv3rfw3rfz3m203k6o212m6o2dw2l2cq2l3t3r3u1w17s4m19m3r}'kerning'{5q{4wv}cl{4qs5kw5ow5qs17sv5tv}201t{2wu4w1k2yu}201x{2wu4wy2yu}17s{2ktclucmucnu4otcpu4lu4wycoucku}2w{7qs4qz5k1m17sy5ow5qx5rsfsu5ty7tufzu}2x{17sy5ty5oy5qs}2y{7qs4qz5k1m17sy5ow5qx5rsfsu5ty7tufzu}'fof'-6o7p{17sv5tv5ow}ck{4qs5kw5ow5qs17sv5tv}4l{4qs5kw5ow5qs17sv5tv}cm{4qs5kw5ow5qs17sv5tv}cn{4qs5kw5ow5qs17sv5tv}co{4qs5kw5ow5qs17sv5tv}cp{4qs5kw5ow5qs17sv5tv}6l{17sy5ty5ow}do{17st5tt}4z{17st5tt}7s{fst}dm{17st5tt}dn{17st5tt}5o{ckwclwcmwcnwcowcpw4lw4wv}dp{17st5tt}dq{17st5tt}7t{5ow}ds{17st5tt}5t{2ktclucmucnu4otcpu4lu4wycoucku}fu{17sv5tv5ow}6p{17sy5ty5ow5qs}ek{17sy5ty5ow}el{17sy5ty5ow}em{17sy5ty5ow}en{5ty}eo{17sy5ty5ow}ep{17sy5ty5ow}es{17sy5ty5qs}et{17sy5ty5ow5qs}eu{17sy5ty5ow5qs}ev{17sy5ty5ow5qs}6z{17sy5ty5ow5qs}fm{17sy5ty5ow5qs}fn{17sy5ty5ow5qs}fo{17sy5ty5ow5qs}fp{17sy5ty5qs}fq{17sy5ty5ow5qs}7r{5ow}fs{17sy5ty5ow5qs}ft{17sv5tv5ow}7m{5ow}fv{17sv5tv5ow}fw{17sv5tv5ow}}}"),"Helvetica-BoldOblique":c("{'widths'{k3s2q4scx1w201n3r201o6o201s1w201t1w201u1w201w3m201x3m201y3m2k1w2l2l202m2n2n3r2o3r2p5t202q6o2r1s2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v2l3w3u3x3u3y3u3z3x4k6l4l4s4m4s4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3r4v4s4w3x4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v2l5w1w5x2l5y3u5z3r6k2l6l3r6m3x6n3r6o3x6p3r6q2l6r3x6s3x6t1w6u1w6v3r6w1w6x5t6y3x6z3x7k3x7l3x7m2r7n3r7o2l7p3x7q3r7r4y7s3r7t3r7u3m7v2r7w1w7x2r7y3u202l3rcl4sal2lam3ran3rao3rap3rar3ras2lat4tau2pav3raw3uay4taz2lbk2sbl3u'fof'6obo2lbp3xbq3rbr1wbs2lbu2obv3rbz3xck4s202k3rcm4scn4sco4scp4scq6ocr4scs4mct4mcu4mcv4mcw1w2m2zcy1wcz1wdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3xek3rel3rem3ren3reo3rep3req5ter3res3ret3reu3rev3rew1wex1wey1wez1wfl3xfm3xfn3xfo3xfp3xfq3xfr3ufs3xft3xfu3xfv3xfw3xfz3r203k6o212m6o2dw2l2cq2l3t3r3u2l17s4m19m3r}'kerning'{cl{4qs5ku5ot5qs17sv5tv}201t{2ww4wy2yw}201w{2ks}201x{2ww4wy2yw}2k{201ts201xs}2w{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}2x{5ow5qs}2y{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}'fof'-6o7p{17su5tu5ot}ck{4qs5ku5ot5qs17sv5tv}4l{4qs5ku5ot5qs17sv5tv}cm{4qs5ku5ot5qs17sv5tv}cn{4qs5ku5ot5qs17sv5tv}co{4qs5ku5ot5qs17sv5tv}cp{4qs5ku5ot5qs17sv5tv}6l{17st5tt5os}17s{2kwclvcmvcnvcovcpv4lv4wwckv}5o{2kucltcmtcntcotcpt4lt4wtckt}5q{2ksclscmscnscoscps4ls4wvcks}5r{2ks4ws}5t{2kwclvcmvcnvcovcpv4lv4wwckv}eo{17st5tt5os}fu{17su5tu5ot}6p{17ss5ts}ek{17st5tt5os}el{17st5tt5os}em{17st5tt5os}en{17st5tt5os}6o{201ts}ep{17st5tt5os}es{17ss5ts}et{17ss5ts}eu{17ss5ts}ev{17ss5ts}6z{17su5tu5os5qt}fm{17su5tu5os5qt}fn{17su5tu5os5qt}fo{17su5tu5os5qt}fp{17su5tu5os5qt}fq{17su5tu5os5qt}fs{17su5tu5os5qt}ft{17su5tu5ot}7m{5os}fv{17su5tu5ot}fw{17su5tu5ot}}}"),ZapfDingbats:c("{'widths'{k4u2k1w'fof'6o}'kerning'{'fof'-6o}}"),"Courier-Bold":c("{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}"),"Times-Italic":c("{'widths'{k3n2q4ycx2l201n3m201o5t201s2l201t2l201u2l201w3r201x3r201y3r2k1t2l2l202m2n2n3m2o3m2p5n202q5t2r1p2s2l2t2l2u3m2v4n2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v2l3w4n3x4n3y4n3z3m4k5w4l3x4m3x4n4m4o4s4p3x4q3x4r4s4s4s4t2l4u2w4v4m4w3r4x5n4y4m4z4s5k3x5l4s5m3x5n3m5o3r5p4s5q3x5r5n5s3x5t3r5u3r5v2r5w1w5x2r5y2u5z3m6k2l6l3m6m3m6n2w6o3m6p2w6q1w6r3m6s3m6t1w6u1w6v2w6w1w6x4s6y3m6z3m7k3m7l3m7m2r7n2r7o1w7p3m7q2w7r4m7s2w7t2w7u2r7v2s7w1v7x2s7y3q202l3mcl3xal2ram3man3mao3map3mar3mas2lat4wau1vav3maw4nay4waz2lbk2sbl4n'fof'6obo2lbp3mbq3obr1tbs2lbu1zbv3mbz3mck3x202k3mcm3xcn3xco3xcp3xcq5tcr4mcs3xct3xcu3xcv3xcw2l2m2ucy2lcz2ldl4mdm4sdn4sdo4sdp4sdq4sds4sdt4sdu4sdv4sdw4sdz3mek3mel3mem3men3meo3mep3meq4mer2wes2wet2weu2wev2wew1wex1wey1wez1wfl3mfm3mfn3mfo3mfp3mfq3mfr4nfs3mft3mfu3mfv3mfw3mfz2w203k6o212m6m2dw2l2cq2l3t3m3u2l17s3r19m3m}'kerning'{cl{5kt4qw}201s{201sw}201t{201tw2wy2yy6q-t}201x{2wy2yy}2k{201tw}2w{7qs4qy7rs5ky7mw5os5qx5ru17su5tu}2x{17ss5ts5os}2y{7qs4qy7rs5ky7mw5os5qx5ru17su5tu}'fof'-6o6t{17ss5ts5qs}7t{5os}3v{5qs}7p{17su5tu5qs}ck{5kt4qw}4l{5kt4qw}cm{5kt4qw}cn{5kt4qw}co{5kt4qw}cp{5kt4qw}6l{4qs5ks5ou5qw5ru17su5tu}17s{2ks}5q{ckvclvcmvcnvcovcpv4lv}5r{ckuclucmucnucoucpu4lu}5t{2ks}6p{4qs5ks5ou5qw5ru17su5tu}ek{4qs5ks5ou5qw5ru17su5tu}el{4qs5ks5ou5qw5ru17su5tu}em{4qs5ks5ou5qw5ru17su5tu}en{4qs5ks5ou5qw5ru17su5tu}eo{4qs5ks5ou5qw5ru17su5tu}ep{4qs5ks5ou5qw5ru17su5tu}es{5ks5qs4qs}et{4qs5ks5ou5qw5ru17su5tu}eu{4qs5ks5qw5ru17su5tu}ev{5ks5qs4qs}ex{17ss5ts5qs}6z{4qv5ks5ou5qw5ru17su5tu}fm{4qv5ks5ou5qw5ru17su5tu}fn{4qv5ks5ou5qw5ru17su5tu}fo{4qv5ks5ou5qw5ru17su5tu}fp{4qv5ks5ou5qw5ru17su5tu}fq{4qv5ks5ou5qw5ru17su5tu}7r{5os}fs{4qv5ks5ou5qw5ru17su5tu}ft{17su5tu5qs}fu{17su5tu5qs}fv{17su5tu5qs}fw{17su5tu5qs}}}"),"Times-Roman":c("{'widths'{k3n2q4ycx2l201n3m201o6o201s2l201t2l201u2l201w2w201x2w201y2w2k1t2l2l202m2n2n3m2o3m2p5n202q6o2r1m2s2l2t2l2u3m2v3s2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v1w3w3s3x3s3y3s3z2w4k5w4l4s4m4m4n4m4o4s4p3x4q3r4r4s4s4s4t2l4u2r4v4s4w3x4x5t4y4s4z4s5k3r5l4s5m4m5n3r5o3x5p4s5q4s5r5y5s4s5t4s5u3x5v2l5w1w5x2l5y2z5z3m6k2l6l2w6m3m6n2w6o3m6p2w6q2l6r3m6s3m6t1w6u1w6v3m6w1w6x4y6y3m6z3m7k3m7l3m7m2l7n2r7o1w7p3m7q3m7r4s7s3m7t3m7u2w7v3k7w1o7x3k7y3q202l3mcl4sal2lam3man3mao3map3mar3mas2lat4wau1vav3maw3say4waz2lbk2sbl3s'fof'6obo2lbp3mbq2xbr1tbs2lbu1zbv3mbz2wck4s202k3mcm4scn4sco4scp4scq5tcr4mcs3xct3xcu3xcv3xcw2l2m2tcy2lcz2ldl4sdm4sdn4sdo4sdp4sdq4sds4sdt4sdu4sdv4sdw4sdz3mek2wel2wem2wen2weo2wep2weq4mer2wes2wet2weu2wev2wew1wex1wey1wez1wfl3mfm3mfn3mfo3mfp3mfq3mfr3sfs3mft3mfu3mfv3mfw3mfz3m203k6o212m6m2dw2l2cq2l3t3m3u1w17s4s19m3m}'kerning'{cl{4qs5ku17sw5ou5qy5rw201ss5tw201ws}201s{201ss}201t{ckw4lwcmwcnwcowcpwclw4wu201ts}2k{201ts}2w{4qs5kw5os5qx5ru17sx5tx}2x{17sw5tw5ou5qu}2y{4qs5kw5os5qx5ru17sx5tx}'fof'-6o7t{ckuclucmucnucoucpu4lu5os5rs}3u{17su5tu5qs}3v{17su5tu5qs}7p{17sw5tw5qs}ck{4qs5ku17sw5ou5qy5rw201ss5tw201ws}4l{4qs5ku17sw5ou5qy5rw201ss5tw201ws}cm{4qs5ku17sw5ou5qy5rw201ss5tw201ws}cn{4qs5ku17sw5ou5qy5rw201ss5tw201ws}co{4qs5ku17sw5ou5qy5rw201ss5tw201ws}cp{4qs5ku17sw5ou5qy5rw201ss5tw201ws}6l{17su5tu5os5qw5rs}17s{2ktclvcmvcnvcovcpv4lv4wuckv}5o{ckwclwcmwcnwcowcpw4lw4wu}5q{ckyclycmycnycoycpy4ly4wu5ms}5r{cktcltcmtcntcotcpt4lt4ws}5t{2ktclvcmvcnvcovcpv4lv4wuckv}7q{cksclscmscnscoscps4ls}6p{17su5tu5qw5rs}ek{5qs5rs}el{17su5tu5os5qw5rs}em{17su5tu5os5qs5rs}en{17su5qs5rs}eo{5qs5rs}ep{17su5tu5os5qw5rs}es{5qs}et{17su5tu5qw5rs}eu{17su5tu5qs5rs}ev{5qs}6z{17sv5tv5os5qx5rs}fm{5os5qt5rs}fn{17sv5tv5os5qx5rs}fo{17sv5tv5os5qx5rs}fp{5os5qt5rs}fq{5os5qt5rs}7r{ckuclucmucnucoucpu4lu5os}fs{17sv5tv5os5qx5rs}ft{17ss5ts5qs}fu{17sw5tw5qs}fv{17sw5tw5qs}fw{17ss5ts5qs}fz{ckuclucmucnucoucpu4lu5os5rs}}}"),"Helvetica-Oblique":c("{'widths'{k3p2q4mcx1w201n3r201o6o201s1q201t1q201u1q201w2l201x2l201y2l2k1w2l1w202m2n2n3r2o3r2p5t202q6o2r1n2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v1w3w3u3x3u3y3u3z3r4k6p4l4m4m4m4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3m4v4m4w3r4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v1w5w1w5x1w5y2z5z3r6k2l6l3r6m3r6n3m6o3r6p3r6q1w6r3r6s3r6t1q6u1q6v3m6w1q6x5n6y3r6z3r7k3r7l3r7m2l7n3m7o1w7p3r7q3m7r4s7s3m7t3m7u3m7v2l7w1u7x2l7y3u202l3rcl4mal2lam3ran3rao3rap3rar3ras2lat4tau2pav3raw3uay4taz2lbk2sbl3u'fof'6obo2lbp3rbr1wbs2lbu2obv3rbz3xck4m202k3rcm4mcn4mco4mcp4mcq6ocr4scs4mct4mcu4mcv4mcw1w2m2ncy1wcz1wdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3xek3rel3rem3ren3reo3rep3req5ter3mes3ret3reu3rev3rew1wex1wey1wez1wfl3rfm3rfn3rfo3rfp3rfq3rfr3ufs3xft3rfu3rfv3rfw3rfz3m203k6o212m6o2dw2l2cq2l3t3r3u1w17s4m19m3r}'kerning'{5q{4wv}cl{4qs5kw5ow5qs17sv5tv}201t{2wu4w1k2yu}201x{2wu4wy2yu}17s{2ktclucmucnu4otcpu4lu4wycoucku}2w{7qs4qz5k1m17sy5ow5qx5rsfsu5ty7tufzu}2x{17sy5ty5oy5qs}2y{7qs4qz5k1m17sy5ow5qx5rsfsu5ty7tufzu}'fof'-6o7p{17sv5tv5ow}ck{4qs5kw5ow5qs17sv5tv}4l{4qs5kw5ow5qs17sv5tv}cm{4qs5kw5ow5qs17sv5tv}cn{4qs5kw5ow5qs17sv5tv}co{4qs5kw5ow5qs17sv5tv}cp{4qs5kw5ow5qs17sv5tv}6l{17sy5ty5ow}do{17st5tt}4z{17st5tt}7s{fst}dm{17st5tt}dn{17st5tt}5o{ckwclwcmwcnwcowcpw4lw4wv}dp{17st5tt}dq{17st5tt}7t{5ow}ds{17st5tt}5t{2ktclucmucnu4otcpu4lu4wycoucku}fu{17sv5tv5ow}6p{17sy5ty5ow5qs}ek{17sy5ty5ow}el{17sy5ty5ow}em{17sy5ty5ow}en{5ty}eo{17sy5ty5ow}ep{17sy5ty5ow}es{17sy5ty5qs}et{17sy5ty5ow5qs}eu{17sy5ty5ow5qs}ev{17sy5ty5ow5qs}6z{17sy5ty5ow5qs}fm{17sy5ty5ow5qs}fn{17sy5ty5ow5qs}fo{17sy5ty5ow5qs}fp{17sy5ty5qs}fq{17sy5ty5ow5qs}7r{5ow}fs{17sy5ty5ow5qs}ft{17sv5tv5ow}7m{5ow}fv{17sv5tv5ow}fw{17sv5tv5ow}}}")}};e.events.push(["addFont",function(t){var e=t.font,n=f.Unicode[e.postScriptName];n&&(e.metadata.Unicode={},e.metadata.Unicode.widths=n.widths,e.metadata.Unicode.kerning=n.kerning);var r=h.Unicode[e.postScriptName];r&&(e.metadata.Unicode.encoding=r,e.encoding=r.codePages[0])}])}(E.API),
/**
 * @license
 * Licensed under the MIT License.
 * http://opensource.org/licenses/mit-license
 */
function(t){var e=function(t){for(var e=t.length,n=new Uint8Array(e),r=0;r<e;r++)n[r]=t.charCodeAt(r);return n};t.API.events.push(["addFont",function(n){var r=void 0,i=n.font,a=n.instance;if(!i.isStandardFont){if(void 0===a)throw new Error("Font does not exist in vFS, import fonts or remove declaration doc.addFont('"+i.postScriptName+"').");if("string"!=typeof(r=!1===a.existsFileInVFS(i.postScriptName)?a.loadFile(i.postScriptName):a.getFileFromVFS(i.postScriptName)))throw new Error("Font is not stored as string-data in vFS, import fonts or remove declaration doc.addFont('"+i.postScriptName+"').");!function(n,r){r=/^\x00\x01\x00\x00/.test(r)?e(r):e(f(r)),n.metadata=t.API.TTFFont.open(r),n.metadata.Unicode=n.metadata.Unicode||{encoding:{},kerning:{},widths:[]},n.metadata.glyIdsUsed=[0]}(i,r)}}])}(E),E.API.addSvgAsImage=function(t,e,n,r,a,s,u,c){if(isNaN(e)||isNaN(n))throw o.error("jsPDF.addSvgAsImage: Invalid coordinates",arguments),new Error("Invalid coordinates passed to jsPDF.addSvgAsImage");if(isNaN(r)||isNaN(a))throw o.error("jsPDF.addSvgAsImage: Invalid measurements",arguments),new Error("Invalid measurements (width and/or height) passed to jsPDF.addSvgAsImage");var l=document.createElement("canvas");l.width=r,l.height=a;var h=l.getContext("2d");h.fillStyle="#fff",h.fillRect(0,0,l.width,l.height);var f={ignoreMouse:!0,ignoreAnimation:!0,ignoreDimensions:!0},d=this;return(i.canvg?Promise.resolve(i.canvg):import("canvg")).catch(function(t){return Promise.reject(new Error("Could not load canvg: "+t))}).then(function(t){return t.default?t.default:t}).then(function(e){return e.fromString(h,t,f)},function(){return Promise.reject(new Error("Could not load canvg."))}).then(function(t){return t.render(f)}).then(function(){d.addImage(l.toDataURL("image/jpeg",1),e,n,r,a,u,c)})},E.API.putTotalPages=function(t){var e,n=0;parseInt(this.internal.getFont().id.substr(1),10)<15?(e=new RegExp(t,"g"),n=this.internal.getNumberOfPages()):(e=new RegExp(this.pdfEscape16(t,this.internal.getFont()),"g"),n=this.pdfEscape16(this.internal.getNumberOfPages()+"",this.internal.getFont()));for(var r=1;r<=this.internal.getNumberOfPages();r++)for(var i=0;i<this.internal.pages[r].length;i++)this.internal.pages[r][i]=this.internal.pages[r][i].replace(e,n);return this},E.API.viewerPreferences=function(e,n){var r;e=e||{},n=n||!1;var i,a,o,s={HideToolbar:{defaultValue:!1,value:!1,type:"boolean",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.3},HideMenubar:{defaultValue:!1,value:!1,type:"boolean",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.3},HideWindowUI:{defaultValue:!1,value:!1,type:"boolean",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.3},FitWindow:{defaultValue:!1,value:!1,type:"boolean",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.3},CenterWindow:{defaultValue:!1,value:!1,type:"boolean",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.3},DisplayDocTitle:{defaultValue:!1,value:!1,type:"boolean",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.4},NonFullScreenPageMode:{defaultValue:"UseNone",value:"UseNone",type:"name",explicitSet:!1,valueSet:["UseNone","UseOutlines","UseThumbs","UseOC"],pdfVersion:1.3},Direction:{defaultValue:"L2R",value:"L2R",type:"name",explicitSet:!1,valueSet:["L2R","R2L"],pdfVersion:1.3},ViewArea:{defaultValue:"CropBox",value:"CropBox",type:"name",explicitSet:!1,valueSet:["MediaBox","CropBox","TrimBox","BleedBox","ArtBox"],pdfVersion:1.4},ViewClip:{defaultValue:"CropBox",value:"CropBox",type:"name",explicitSet:!1,valueSet:["MediaBox","CropBox","TrimBox","BleedBox","ArtBox"],pdfVersion:1.4},PrintArea:{defaultValue:"CropBox",value:"CropBox",type:"name",explicitSet:!1,valueSet:["MediaBox","CropBox","TrimBox","BleedBox","ArtBox"],pdfVersion:1.4},PrintClip:{defaultValue:"CropBox",value:"CropBox",type:"name",explicitSet:!1,valueSet:["MediaBox","CropBox","TrimBox","BleedBox","ArtBox"],pdfVersion:1.4},PrintScaling:{defaultValue:"AppDefault",value:"AppDefault",type:"name",explicitSet:!1,valueSet:["AppDefault","None"],pdfVersion:1.6},Duplex:{defaultValue:"",value:"none",type:"name",explicitSet:!1,valueSet:["Simplex","DuplexFlipShortEdge","DuplexFlipLongEdge","none"],pdfVersion:1.7},PickTrayByPDFSize:{defaultValue:!1,value:!1,type:"boolean",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.7},PrintPageRange:{defaultValue:"",value:"",type:"array",explicitSet:!1,valueSet:null,pdfVersion:1.7},NumCopies:{defaultValue:1,value:1,type:"integer",explicitSet:!1,valueSet:null,pdfVersion:1.7}},u=Object.keys(s),c=[],l=0,h=0,f=0;function d(t,e){var n,r=!1;for(n=0;n<t.length;n+=1)t[n]===e&&(r=!0);return r}if(void 0===this.internal.viewerpreferences&&(this.internal.viewerpreferences={},this.internal.viewerpreferences.configuration=JSON.parse(JSON.stringify(s)),this.internal.viewerpreferences.isSubscribed=!1),r=this.internal.viewerpreferences.configuration,"reset"===e||!0===n){var p=u.length;for(f=0;f<p;f+=1)r[u[f]].value=r[u[f]].defaultValue,r[u[f]].explicitSet=!1}if("object"===t(e))for(a in e)if(o=e[a],d(u,a)&&void 0!==o){if("boolean"===r[a].type&&"boolean"==typeof o)r[a].value=o;else if("name"===r[a].type&&d(r[a].valueSet,o))r[a].value=o;else if("integer"===r[a].type&&Number.isInteger(o))r[a].value=o;else if("array"===r[a].type){for(l=0;l<o.length;l+=1)if(i=!0,1===o[l].length&&"number"==typeof o[l][0])c.push(String(o[l]-1));else if(o[l].length>1){for(h=0;h<o[l].length;h+=1)"number"!=typeof o[l][h]&&(i=!1);!0===i&&c.push([o[l][0]-1,o[l][1]-1].join(" "))}r[a].value="["+c.join(" ")+"]"}else r[a].value=r[a].defaultValue;r[a].explicitSet=!0}return!1===this.internal.viewerpreferences.isSubscribed&&(this.internal.events.subscribe("putCatalog",function(){var t,e=[];for(t in r)!0===r[t].explicitSet&&("name"===r[t].type?e.push("/"+t+" /"+r[t].value):e.push("/"+t+" "+r[t].value));0!==e.length&&this.internal.write("/ViewerPreferences\n<<\n"+e.join("\n")+"\n>>")}),this.internal.viewerpreferences.isSubscribed=!0),this.internal.viewerpreferences.configuration=r,this},
/** ====================================================================
 * @license
 * jsPDF XMP metadata plugin
 * Copyright (c) 2016 Jussi Utunen, u-jussi@suomi24.fi
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * ====================================================================
 */
function(t){var e=function(){var t='<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"><rdf:Description rdf:about="" xmlns:jspdf="'+this.internal.__metadata__.namespaceuri+'"><jspdf:metadata>',e=unescape(encodeURIComponent('<x:xmpmeta xmlns:x="adobe:ns:meta/">')),n=unescape(encodeURIComponent(t)),r=unescape(encodeURIComponent(this.internal.__metadata__.metadata)),i=unescape(encodeURIComponent("</jspdf:metadata></rdf:Description></rdf:RDF>")),a=unescape(encodeURIComponent("</x:xmpmeta>")),o=n.length+r.length+i.length+e.length+a.length;this.internal.__metadata__.metadata_object_number=this.internal.newObject(),this.internal.write("<< /Type /Metadata /Subtype /XML /Length "+o+" >>"),this.internal.write("stream"),this.internal.write(e+n+r+i+a),this.internal.write("endstream"),this.internal.write("endobj")},n=function(){this.internal.__metadata__.metadata_object_number&&this.internal.write("/Metadata "+this.internal.__metadata__.metadata_object_number+" 0 R")};t.addMetadata=function(t,r){return void 0===this.internal.__metadata__&&(this.internal.__metadata__={metadata:t,namespaceuri:r||"http://jspdf.default.namespaceuri/"},this.internal.events.subscribe("putCatalog",n),this.internal.events.subscribe("postPutResources",e)),this}}(E.API),function(t){var e=t.API,n=e.pdfEscape16=function(t,e){for(var n,r=e.metadata.Unicode.widths,i=["","0","00","000","0000"],a=[""],o=0,s=t.length;o<s;++o){if(n=e.metadata.characterToGlyph(t.charCodeAt(o)),e.metadata.glyIdsUsed.push(n),e.metadata.toUnicode[n]=t.charCodeAt(o),-1==r.indexOf(n)&&(r.push(n),r.push([parseInt(e.metadata.widthOfGlyph(n),10)])),"0"==n)return a.join("");n=n.toString(16),a.push(i[4-n.length],n)}return a.join("")},r=function(t){var e,n,r,i,a,o,s;for(a="/CIDInit /ProcSet findresource begin\n12 dict begin\nbegincmap\n/CIDSystemInfo <<\n  /Registry (Adobe)\n  /Ordering (UCS)\n  /Supplement 0\n>> def\n/CMapName /Adobe-Identity-UCS def\n/CMapType 2 def\n1 begincodespacerange\n<0000><ffff>\nendcodespacerange",r=[],o=0,s=(n=Object.keys(t).sort(function(t,e){return t-e})).length;o<s;o++)e=n[o],r.length>=100&&(a+="\n"+r.length+" beginbfchar\n"+r.join("\n")+"\nendbfchar",r=[]),void 0!==t[e]&&null!==t[e]&&"function"==typeof t[e].toString&&(i=("0000"+t[e].toString(16)).slice(-4),e=("0000"+(+e).toString(16)).slice(-4),r.push("<"+e+"><"+i+">"));return r.length&&(a+="\n"+r.length+" beginbfchar\n"+r.join("\n")+"\nendbfchar\n"),a+"endcmap\nCMapName currentdict /CMap defineresource pop\nend\nend"};e.events.push(["putFont",function(e){!function(e){var n=e.font,i=e.out,a=e.newObject,o=e.putStream;if(n.metadata instanceof t.API.TTFFont&&"Identity-H"===n.encoding){for(var s=n.metadata.Unicode.widths,u=n.metadata.subset.encode(n.metadata.glyIdsUsed,1),c="",l=0;l<u.length;l++)c+=String.fromCharCode(u[l]);var h=a();o({data:c,addLength1:!0,objectId:h}),i("endobj");var f=a();o({data:r(n.metadata.toUnicode),addLength1:!0,objectId:f}),i("endobj");var d=a();i("<<"),i("/Type /FontDescriptor"),i("/FontName /"+j(n.fontName)),i("/FontFile2 "+h+" 0 R"),i("/FontBBox "+t.API.PDFObject.convert(n.metadata.bbox)),i("/Flags "+n.metadata.flags),i("/StemV "+n.metadata.stemV),i("/ItalicAngle "+n.metadata.italicAngle),i("/Ascent "+n.metadata.ascender),i("/Descent "+n.metadata.decender),i("/CapHeight "+n.metadata.capHeight),i(">>"),i("endobj");var p=a();i("<<"),i("/Type /Font"),i("/BaseFont /"+j(n.fontName)),i("/FontDescriptor "+d+" 0 R"),i("/W "+t.API.PDFObject.convert(s)),i("/CIDToGIDMap /Identity"),i("/DW 1000"),i("/Subtype /CIDFontType2"),i("/CIDSystemInfo"),i("<<"),i("/Supplement 0"),i("/Registry (Adobe)"),i("/Ordering ("+n.encoding+")"),i(">>"),i(">>"),i("endobj"),n.objectNumber=a(),i("<<"),i("/Type /Font"),i("/Subtype /Type0"),i("/ToUnicode "+f+" 0 R"),i("/BaseFont /"+j(n.fontName)),i("/Encoding /"+n.encoding),i("/DescendantFonts ["+p+" 0 R]"),i(">>"),i("endobj"),n.isAlreadyPutted=!0}}(e)}]),e.events.push(["putFont",function(e){!function(e){var n=e.font,i=e.out,a=e.newObject,o=e.putStream;if(n.metadata instanceof t.API.TTFFont&&"WinAnsiEncoding"===n.encoding){for(var s=n.metadata.rawData,u="",c=0;c<s.length;c++)u+=String.fromCharCode(s[c]);var l=a();o({data:u,addLength1:!0,objectId:l}),i("endobj");var h=a();o({data:r(n.metadata.toUnicode),addLength1:!0,objectId:h}),i("endobj");var f=a();i("<<"),i("/Descent "+n.metadata.decender),i("/CapHeight "+n.metadata.capHeight),i("/StemV "+n.metadata.stemV),i("/Type /FontDescriptor"),i("/FontFile2 "+l+" 0 R"),i("/Flags 96"),i("/FontBBox "+t.API.PDFObject.convert(n.metadata.bbox)),i("/FontName /"+j(n.fontName)),i("/ItalicAngle "+n.metadata.italicAngle),i("/Ascent "+n.metadata.ascender),i(">>"),i("endobj"),n.objectNumber=a();for(var d=0;d<n.metadata.hmtx.widths.length;d++)n.metadata.hmtx.widths[d]=parseInt(n.metadata.hmtx.widths[d]*(1e3/n.metadata.head.unitsPerEm));i("<</Subtype/TrueType/Type/Font/ToUnicode "+h+" 0 R/BaseFont/"+j(n.fontName)+"/FontDescriptor "+f+" 0 R/Encoding/"+n.encoding+" /FirstChar 29 /LastChar 255 /Widths "+t.API.PDFObject.convert(n.metadata.hmtx.widths)+">>"),i("endobj"),n.isAlreadyPutted=!0}}(e)}]);var i=function(t){var e,r=t.text||"",i=t.x,a=t.y,o=t.options||{},s=t.mutex||{},u=s.pdfEscape,c=s.activeFontKey,l=s.fonts,h=c,f="",d=0,p="",g=l[h].encoding;if("Identity-H"!==l[h].encoding)return{text:r,x:i,y:a,options:o,mutex:s};for(p=r,h=c,Array.isArray(r)&&(p=r[0]),d=0;d<p.length;d+=1)l[h].metadata.hasOwnProperty("cmap")&&(e=l[h].metadata.cmap.unicode.codeMap[p[d].charCodeAt(0)]),e||p[d].charCodeAt(0)<256&&l[h].metadata.hasOwnProperty("Unicode")?f+=p[d]:f+="";var m="";return parseInt(h.slice(1))<14||"WinAnsiEncoding"===g?m=u(f,h).split("").map(function(t){return t.charCodeAt(0).toString(16)}).join(""):"Identity-H"===g&&(m=n(f,l[h])),s.isHex=!0,{text:m,x:i,y:a,options:o,mutex:s}};e.events.push(["postProcessText",function(t){var e=t.text||"",n=[],r={text:e,x:t.x,y:t.y,options:t.options,mutex:t.mutex};if(Array.isArray(e)){var a=0;for(a=0;a<e.length;a+=1)Array.isArray(e[a])&&3===e[a].length?n.push([i(Object.assign({},r,{text:e[a][0]})).text,e[a][1],e[a][2]]):n.push(i(Object.assign({},r,{text:e[a]})).text);t.text=n}else t.text=i(Object.assign({},r,{text:e})).text}])}(E),
/**
 * @license
 * jsPDF virtual FileSystem functionality
 *
 * Licensed under the MIT License.
 * http://opensource.org/licenses/mit-license
 */
function(t){var e=function(){return void 0===this.internal.vFS&&(this.internal.vFS={}),!0};t.existsFileInVFS=function(t){return e.call(this),void 0!==this.internal.vFS[t]},t.addFileToVFS=function(t,n){return e.call(this),this.internal.vFS[t]=n,this},t.getFileFromVFS=function(t){return e.call(this),void 0!==this.internal.vFS[t]?this.internal.vFS[t]:null}}(E.API),
/**
 * @license
 * Unicode Bidi Engine based on the work of Alex Shensis (@asthensis)
 * MIT License
 */
function(t){t.__bidiEngine__=t.prototype.__bidiEngine__=function(t){var n,r,i,a,o,s,u,c=e,l=[[0,3,0,1,0,0,0],[0,3,0,1,2,2,0],[0,3,0,17,2,0,1],[0,3,5,5,4,1,0],[0,3,21,21,4,0,1],[0,3,5,5,4,2,0]],h=[[2,0,1,1,0,1,0],[2,0,1,1,0,2,0],[2,0,2,1,3,2,0],[2,0,2,33,3,1,1]],f={L:0,R:1,EN:2,AN:3,N:4,B:5,S:6},d={0:0,5:1,6:2,7:3,32:4,251:5,254:6,255:7},p=["(",")","(","<",">","<","[","]","[","{","}","{","«","»","«","‹","›","‹","⁅","⁆","⁅","⁽","⁾","⁽","₍","₎","₍","≤","≥","≤","〈","〉","〈","﹙","﹚","﹙","﹛","﹜","﹛","﹝","﹞","﹝","﹤","﹥","﹤"],g=new RegExp(/^([1-4|9]|1[0-9]|2[0-9]|3[0168]|4[04589]|5[012]|7[78]|159|16[0-9]|17[0-2]|21[569]|22[03489]|250)$/),m=!1,v=0;this.__bidiEngine__={};var b=function(t){var e=t.charCodeAt(),n=e>>8,r=d[n];return void 0!==r?c[256*r+(255&e)]:252===n||253===n?"AL":g.test(n)?"L":8===n?"R":"N"},y=function(t){for(var e,n=0;n<t.length;n++){if("L"===(e=b(t.charAt(n))))return!1;if("R"===e)return!0}return!1},w=function(t,e,o,s){var u,c,l,h,f=e[s];switch(f){case"L":case"R":case"LRE":case"RLE":case"LRO":case"RLO":case"PDF":m=!1;break;case"N":case"AN":break;case"EN":m&&(f="AN");break;case"AL":m=!0,f="R";break;case"WS":case"BN":f="N";break;case"CS":s<1||s+1>=e.length||"EN"!==(u=o[s-1])&&"AN"!==u||"EN"!==(c=e[s+1])&&"AN"!==c?f="N":m&&(c="AN"),f=c===u?c:"N";break;case"ES":f="EN"===(u=s>0?o[s-1]:"B")&&s+1<e.length&&"EN"===e[s+1]?"EN":"N";break;case"ET":if(s>0&&"EN"===o[s-1]){f="EN";break}if(m){f="N";break}for(l=s+1,h=e.length;l<h&&"ET"===e[l];)l++;f=l<h&&"EN"===e[l]?"EN":"N";break;case"NSM":if(i&&!a){for(h=e.length,l=s+1;l<h&&"NSM"===e[l];)l++;if(l<h){var d=t[s],p=d>=1425&&d<=2303||64286===d;if(u=e[l],p&&("R"===u||"AL"===u)){f="R";break}}}f=s<1||"B"===(u=e[s-1])?"N":o[s-1];break;case"B":m=!1,n=!0,f=v;break;case"S":r=!0,f="N"}return f},N=function(t,e,n){var r=t.split("");return n&&L(r,n,{hiLevel:v}),r.reverse(),e&&e.reverse(),r.join("")},L=function(t,e,i){var a,o,s,u,c,d=-1,p=t.length,g=0,y=[],N=v?h:l,L=[];for(m=!1,n=!1,r=!1,o=0;o<p;o++)L[o]=b(t[o]);for(s=0;s<p;s++){if(c=g,y[s]=w(t,L,y,s),a=240&(g=N[c][f[y[s]]]),g&=15,e[s]=u=N[g][5],a>0)if(16===a){for(o=d;o<s;o++)e[o]=1;d=-1}else d=-1;if(N[g][6])-1===d&&(d=s);else if(d>-1){for(o=d;o<s;o++)e[o]=u;d=-1}"B"===L[s]&&(e[s]=0),i.hiLevel|=u}r&&function(t,e,n){for(var r=0;r<n;r++)if("S"===t[r]){e[r]=v;for(var i=r-1;i>=0&&"WS"===t[i];i--)e[i]=v}}(L,e,p)},x=function(t,e,r,i,a){if(!(a.hiLevel<t)){if(1===t&&1===v&&!n)return e.reverse(),void(r&&r.reverse());for(var o,s,u,c,l=e.length,h=0;h<l;){if(i[h]>=t){for(u=h+1;u<l&&i[u]>=t;)u++;for(c=h,s=u-1;c<s;c++,s--)o=e[c],e[c]=e[s],e[s]=o,r&&(o=r[c],r[c]=r[s],r[s]=o);h=u}h++}}},A=function(t,e,n){var r=t.split(""),i={hiLevel:v};return n||(n=[]),L(r,n,i),function(t,e,n){if(0!==n.hiLevel&&u)for(var r,i=0;i<t.length;i++)1===e[i]&&(r=p.indexOf(t[i]))>=0&&(t[i]=p[r+1])}(r,n,i),x(2,r,e,n,i),x(1,r,e,n,i),r.join("")};return this.__bidiEngine__.doBidiReorder=function(t,e,n){if(function(t,e){if(e)for(var n=0;n<t.length;n++)e[n]=n;void 0===a&&(a=y(t)),void 0===s&&(s=y(t))}(t,e),i||!o||s)if(i&&o&&a^s)v=a?1:0,t=N(t,e,n);else if(!i&&o&&s)v=a?1:0,t=A(t,e,n),t=N(t,e);else if(!i||a||o||s){if(i&&!o&&a^s)t=N(t,e),a?(v=0,t=A(t,e,n)):(v=1,t=A(t,e,n),t=N(t,e));else if(i&&a&&!o&&s)v=1,t=A(t,e,n),t=N(t,e);else if(!i&&!o&&a^s){var r=u;a?(v=1,t=A(t,e,n),v=0,u=!1,t=A(t,e,n),u=r):(v=0,t=A(t,e,n),t=N(t,e),v=1,u=!1,t=A(t,e,n),u=r,t=N(t,e))}}else v=0,t=A(t,e,n);else v=a?1:0,t=A(t,e,n);return t},this.__bidiEngine__.setOptions=function(t){t&&(i=t.isInputVisual,o=t.isOutputVisual,a=t.isInputRtl,s=t.isOutputRtl,u=t.isSymmetricSwapping)},this.__bidiEngine__.setOptions(t),this.__bidiEngine__};var e=["BN","BN","BN","BN","BN","BN","BN","BN","BN","S","B","S","WS","B","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","B","B","B","S","WS","N","N","ET","ET","ET","N","N","N","N","N","ES","CS","ES","CS","CS","EN","EN","EN","EN","EN","EN","EN","EN","EN","EN","CS","N","N","N","N","N","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","N","N","N","N","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","N","N","N","BN","BN","BN","BN","BN","BN","B","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","CS","N","ET","ET","ET","ET","N","N","N","N","L","N","N","BN","N","N","ET","ET","EN","EN","N","L","N","N","N","EN","L","N","N","N","N","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","N","L","L","L","L","L","L","L","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","L","N","N","N","N","N","ET","N","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","R","NSM","R","NSM","NSM","R","NSM","NSM","R","NSM","N","N","N","N","N","N","N","N","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","N","N","N","N","N","R","R","R","R","R","N","N","N","N","N","N","N","N","N","N","N","AN","AN","AN","AN","AN","AN","N","N","AL","ET","ET","AL","CS","AL","N","N","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","AL","AL","N","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","AN","AN","AN","AN","AN","AN","AN","AN","AN","AN","ET","AN","AN","AL","AL","AL","NSM","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","NSM","NSM","NSM","NSM","NSM","NSM","NSM","AN","N","NSM","NSM","NSM","NSM","NSM","NSM","AL","AL","NSM","NSM","N","NSM","NSM","NSM","NSM","AL","AL","EN","EN","EN","EN","EN","EN","EN","EN","EN","EN","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","N","AL","AL","NSM","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","N","N","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","AL","N","N","N","N","N","N","N","N","N","N","N","N","N","N","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","R","R","N","N","N","N","R","N","N","N","N","N","WS","WS","WS","WS","WS","WS","WS","WS","WS","WS","WS","BN","BN","BN","L","R","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","WS","B","LRE","RLE","PDF","LRO","RLO","CS","ET","ET","ET","ET","ET","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","CS","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","WS","BN","BN","BN","BN","BN","N","LRI","RLI","FSI","PDI","BN","BN","BN","BN","BN","BN","EN","L","N","N","EN","EN","EN","EN","EN","EN","ES","ES","N","N","N","L","EN","EN","EN","EN","EN","EN","EN","EN","EN","EN","ES","ES","N","N","N","N","L","L","L","L","L","L","L","L","L","L","L","L","L","N","N","N","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","L","L","L","L","L","L","L","N","N","N","N","N","N","N","N","N","N","N","N","L","L","L","L","L","N","N","N","N","N","R","NSM","R","R","R","R","R","R","R","R","R","R","ES","R","R","R","R","R","R","R","R","R","R","R","R","R","N","R","R","R","R","R","N","R","N","R","R","N","R","R","N","R","R","R","R","R","R","R","R","R","R","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","CS","N","CS","N","N","CS","N","N","N","N","N","N","N","N","N","ET","N","N","ES","ES","N","N","N","N","N","ET","ET","N","N","N","N","N","AL","AL","AL","AL","AL","N","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","N","N","BN","N","N","N","ET","ET","ET","N","N","N","N","N","ES","CS","ES","CS","CS","EN","EN","EN","EN","EN","EN","EN","EN","EN","EN","CS","N","N","N","N","N","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","N","N","N","N","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","N","N","N","N","N","N","N","N","N","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","N","N","L","L","L","L","L","L","N","N","L","L","L","L","L","L","N","N","L","L","L","L","L","L","N","N","L","L","L","N","N","N","ET","ET","N","N","N","ET","ET","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N"],n=new t.__bidiEngine__({isInputVisual:!0});t.API.events.push(["postProcessText",function(t){var e=t.text;t.x,t.y;var r=t.options||{};t.mutex,r.lang;var i=[];if(r.isInputVisual="boolean"!=typeof r.isInputVisual||r.isInputVisual,n.setOptions(r),"[object Array]"===Object.prototype.toString.call(e)){var a=0;for(i=[],a=0;a<e.length;a+=1)"[object Array]"===Object.prototype.toString.call(e[a])?i.push([n.doBidiReorder(e[a][0]),e[a][1],e[a][2]]):i.push([n.doBidiReorder(e[a])]);t.text=i}else t.text=n.doBidiReorder(e);n.setOptions({isInputVisual:!0})}])}(E),E.API.TTFFont=function(){function t(t){var e;if(this.rawData=t,e=this.contents=new fe(t),this.contents.pos=4,"ttcf"===e.readString(4))throw new Error("TTCF not supported.");e.pos=0,this.parse(),this.subset=new je(this),this.registerTTF()}return t.open=function(e){return new t(e)},t.prototype.parse=function(){return this.directory=new de(this.contents),this.head=new me(this),this.name=new xe(this),this.cmap=new be(this),this.toUnicode={},this.hhea=new ye(this),this.maxp=new Ae(this),this.hmtx=new Se(this),this.post=new Ne(this),this.os2=new we(this),this.loca=new Ie(this),this.glyf=new Pe(this),this.ascender=this.os2.exists&&this.os2.ascender||this.hhea.ascender,this.decender=this.os2.exists&&this.os2.decender||this.hhea.decender,this.lineGap=this.os2.exists&&this.os2.lineGap||this.hhea.lineGap,this.bbox=[this.head.xMin,this.head.yMin,this.head.xMax,this.head.yMax]},t.prototype.registerTTF=function(){var t,e,n,r,i;if(this.scaleFactor=1e3/this.head.unitsPerEm,this.bbox=function(){var e,n,r,i;for(i=[],e=0,n=(r=this.bbox).length;e<n;e++)t=r[e],i.push(Math.round(t*this.scaleFactor));return i}.call(this),this.stemV=0,this.post.exists?(n=255&(r=this.post.italic_angle),32768&(e=r>>16)&&(e=-(1+(65535^e))),this.italicAngle=+(e+"."+n)):this.italicAngle=0,this.ascender=Math.round(this.ascender*this.scaleFactor),this.decender=Math.round(this.decender*this.scaleFactor),this.lineGap=Math.round(this.lineGap*this.scaleFactor),this.capHeight=this.os2.exists&&this.os2.capHeight||this.ascender,this.xHeight=this.os2.exists&&this.os2.xHeight||0,this.familyClass=(this.os2.exists&&this.os2.familyClass||0)>>8,this.isSerif=1===(i=this.familyClass)||2===i||3===i||4===i||5===i||7===i,this.isScript=10===this.familyClass,this.flags=0,this.post.isFixedPitch&&(this.flags|=1),this.isSerif&&(this.flags|=2),this.isScript&&(this.flags|=8),0!==this.italicAngle&&(this.flags|=64),this.flags|=32,!this.cmap.unicode)throw new Error("No unicode cmap for font")},t.prototype.characterToGlyph=function(t){var e;return(null!=(e=this.cmap.unicode)?e.codeMap[t]:void 0)||0},t.prototype.widthOfGlyph=function(t){var e;return e=1e3/this.head.unitsPerEm,this.hmtx.forGlyph(t).advance*e},t.prototype.widthOfString=function(t,e,n){var r,i,a,o;for(a=0,i=0,o=(t=""+t).length;0<=o?i<o:i>o;i=0<=o?++i:--i)r=t.charCodeAt(i),a+=this.widthOfGlyph(this.characterToGlyph(r))+n*(1e3/e)||0;return a*(e/1e3)},t.prototype.lineHeight=function(t,e){var n;return null==e&&(e=!1),n=e?this.lineGap:0,(this.ascender+n-this.decender)/1e3*t},t}();var he,fe=function(){function t(t){this.data=null!=t?t:[],this.pos=0,this.length=this.data.length}return t.prototype.readByte=function(){return this.data[this.pos++]},t.prototype.writeByte=function(t){return this.data[this.pos++]=t},t.prototype.readUInt32=function(){return 16777216*this.readByte()+(this.readByte()<<16)+(this.readByte()<<8)+this.readByte()},t.prototype.writeUInt32=function(t){return this.writeByte(t>>>24&255),this.writeByte(t>>16&255),this.writeByte(t>>8&255),this.writeByte(255&t)},t.prototype.readInt32=function(){var t;return(t=this.readUInt32())>=2147483648?t-4294967296:t},t.prototype.writeInt32=function(t){return t<0&&(t+=4294967296),this.writeUInt32(t)},t.prototype.readUInt16=function(){return this.readByte()<<8|this.readByte()},t.prototype.writeUInt16=function(t){return this.writeByte(t>>8&255),this.writeByte(255&t)},t.prototype.readInt16=function(){var t;return(t=this.readUInt16())>=32768?t-65536:t},t.prototype.writeInt16=function(t){return t<0&&(t+=65536),this.writeUInt16(t)},t.prototype.readString=function(t){var e,n;for(n=[],e=0;0<=t?e<t:e>t;e=0<=t?++e:--e)n[e]=String.fromCharCode(this.readByte());return n.join("")},t.prototype.writeString=function(t){var e,n,r;for(r=[],e=0,n=t.length;0<=n?e<n:e>n;e=0<=n?++e:--e)r.push(this.writeByte(t.charCodeAt(e)));return r},t.prototype.readShort=function(){return this.readInt16()},t.prototype.writeShort=function(t){return this.writeInt16(t)},t.prototype.readLongLong=function(){var t,e,n,r,i,a,o,s;return t=this.readByte(),e=this.readByte(),n=this.readByte(),r=this.readByte(),i=this.readByte(),a=this.readByte(),o=this.readByte(),s=this.readByte(),128&t?-1*(72057594037927940*(255^t)+281474976710656*(255^e)+1099511627776*(255^n)+4294967296*(255^r)+16777216*(255^i)+65536*(255^a)+256*(255^o)+(255^s)+1):72057594037927940*t+281474976710656*e+1099511627776*n+4294967296*r+16777216*i+65536*a+256*o+s},t.prototype.writeLongLong=function(t){var e,n;return e=Math.floor(t/4294967296),n=4294967295&t,this.writeByte(e>>24&255),this.writeByte(e>>16&255),this.writeByte(e>>8&255),this.writeByte(255&e),this.writeByte(n>>24&255),this.writeByte(n>>16&255),this.writeByte(n>>8&255),this.writeByte(255&n)},t.prototype.readInt=function(){return this.readInt32()},t.prototype.writeInt=function(t){return this.writeInt32(t)},t.prototype.read=function(t){var e,n;for(e=[],n=0;0<=t?n<t:n>t;n=0<=t?++n:--n)e.push(this.readByte());return e},t.prototype.write=function(t){var e,n,r,i;for(i=[],n=0,r=t.length;n<r;n++)e=t[n],i.push(this.writeByte(e));return i},t}(),de=function(){var t;function e(t){var e,n,r;for(this.scalarType=t.readInt(),this.tableCount=t.readShort(),this.searchRange=t.readShort(),this.entrySelector=t.readShort(),this.rangeShift=t.readShort(),this.tables={},n=0,r=this.tableCount;0<=r?n<r:n>r;n=0<=r?++n:--n)e={tag:t.readString(4),checksum:t.readInt(),offset:t.readInt(),length:t.readInt()},this.tables[e.tag]=e}return e.prototype.encode=function(e){var n,r,i,a,o,s,u,c,l,h,f,d,p;for(p in f=Object.keys(e).length,s=Math.log(2),l=16*Math.floor(Math.log(f)/s),a=Math.floor(l/s),c=16*f-l,(r=new fe).writeInt(this.scalarType),r.writeShort(f),r.writeShort(l),r.writeShort(a),r.writeShort(c),i=16*f,u=r.pos+i,o=null,d=[],e)for(h=e[p],r.writeString(p),r.writeInt(t(h)),r.writeInt(u),r.writeInt(h.length),d=d.concat(h),"head"===p&&(o=u),u+=h.length;u%4;)d.push(0),u++;return r.write(d),n=2981146554-t(r.data),r.pos=o+8,r.writeUInt32(n),r.data},t=function(t){var e,n,r,i;for(t=_e.call(t);t.length%4;)t.push(0);for(r=new fe(t),n=0,e=0,i=t.length;e<i;e=e+=4)n+=r.readUInt32();return 4294967295&n},e}(),pe={}.hasOwnProperty,ge=function(t,e){for(var n in e)pe.call(e,n)&&(t[n]=e[n]);function r(){this.constructor=t}return r.prototype=e.prototype,t.prototype=new r,t.__super__=e.prototype,t};he=function(){function t(t){var e;this.file=t,e=this.file.directory.tables[this.tag],this.exists=!!e,e&&(this.offset=e.offset,this.length=e.length,this.parse(this.file.contents))}return t.prototype.parse=function(){},t.prototype.encode=function(){},t.prototype.raw=function(){return this.exists?(this.file.contents.pos=this.offset,this.file.contents.read(this.length)):null},t}();var me=function(){function t(){return t.__super__.constructor.apply(this,arguments)}return ge(t,he),t.prototype.tag="head",t.prototype.parse=function(t){return t.pos=this.offset,this.version=t.readInt(),this.revision=t.readInt(),this.checkSumAdjustment=t.readInt(),this.magicNumber=t.readInt(),this.flags=t.readShort(),this.unitsPerEm=t.readShort(),this.created=t.readLongLong(),this.modified=t.readLongLong(),this.xMin=t.readShort(),this.yMin=t.readShort(),this.xMax=t.readShort(),this.yMax=t.readShort(),this.macStyle=t.readShort(),this.lowestRecPPEM=t.readShort(),this.fontDirectionHint=t.readShort(),this.indexToLocFormat=t.readShort(),this.glyphDataFormat=t.readShort()},t.prototype.encode=function(t){var e;return(e=new fe).writeInt(this.version),e.writeInt(this.revision),e.writeInt(this.checkSumAdjustment),e.writeInt(this.magicNumber),e.writeShort(this.flags),e.writeShort(this.unitsPerEm),e.writeLongLong(this.created),e.writeLongLong(this.modified),e.writeShort(this.xMin),e.writeShort(this.yMin),e.writeShort(this.xMax),e.writeShort(this.yMax),e.writeShort(this.macStyle),e.writeShort(this.lowestRecPPEM),e.writeShort(this.fontDirectionHint),e.writeShort(t),e.writeShort(this.glyphDataFormat),e.data},t}(),ve=function(){function t(t,e){var n,r,i,a,o,s,u,c,l,h,f,d,p,g,m,v,b;switch(this.platformID=t.readUInt16(),this.encodingID=t.readShort(),this.offset=e+t.readInt(),l=t.pos,t.pos=this.offset,this.format=t.readUInt16(),this.length=t.readUInt16(),this.language=t.readUInt16(),this.isUnicode=3===this.platformID&&1===this.encodingID&&4===this.format||0===this.platformID&&4===this.format,this.codeMap={},this.format){case 0:for(s=0;s<256;++s)this.codeMap[s]=t.readByte();break;case 4:for(f=t.readUInt16(),h=f/2,t.pos+=6,i=function(){var e,n;for(n=[],s=e=0;0<=h?e<h:e>h;s=0<=h?++e:--e)n.push(t.readUInt16());return n}(),t.pos+=2,p=function(){var e,n;for(n=[],s=e=0;0<=h?e<h:e>h;s=0<=h?++e:--e)n.push(t.readUInt16());return n}(),u=function(){var e,n;for(n=[],s=e=0;0<=h?e<h:e>h;s=0<=h?++e:--e)n.push(t.readUInt16());return n}(),c=function(){var e,n;for(n=[],s=e=0;0<=h?e<h:e>h;s=0<=h?++e:--e)n.push(t.readUInt16());return n}(),r=(this.length-t.pos+this.offset)/2,o=function(){var e,n;for(n=[],s=e=0;0<=r?e<r:e>r;s=0<=r?++e:--e)n.push(t.readUInt16());return n}(),s=m=0,b=i.length;m<b;s=++m)for(g=i[s],n=v=d=p[s];d<=g?v<=g:v>=g;n=d<=g?++v:--v)0===c[s]?a=n+u[s]:0!==(a=o[c[s]/2+(n-d)-(h-s)]||0)&&(a+=u[s]),this.codeMap[n]=65535&a}t.pos=l}return t.encode=function(t,e){var n,r,i,a,o,s,u,c,l,h,f,d,p,g,m,v,b,y,w,N,L,x,A,S,_,P,k,F,I,j,C,O,B,M,q,E,R,D,T,z,U,H,W,V,G,Y;switch(F=new fe,a=Object.keys(t).sort(function(t,e){return t-e}),e){case"macroman":for(p=0,g=function(){var t=[];for(d=0;d<256;++d)t.push(0);return t}(),v={0:0},i={},I=0,B=a.length;I<B;I++)null==v[W=t[r=a[I]]]&&(v[W]=++p),i[r]={old:t[r],new:v[t[r]]},g[r]=v[t[r]];return F.writeUInt16(1),F.writeUInt16(0),F.writeUInt32(12),F.writeUInt16(0),F.writeUInt16(262),F.writeUInt16(0),F.write(g),{charMap:i,subtable:F.data,maxGlyphID:p+1};case"unicode":for(P=[],l=[],b=0,v={},n={},m=u=null,j=0,M=a.length;j<M;j++)null==v[w=t[r=a[j]]]&&(v[w]=++b),n[r]={old:w,new:v[w]},o=v[w]-r,null!=m&&o===u||(m&&l.push(m),P.push(r),u=o),m=r;for(m&&l.push(m),l.push(65535),P.push(65535),S=2*(A=P.length),x=2*Math.pow(Math.log(A)/Math.LN2,2),h=Math.log(x/2)/Math.LN2,L=2*A-x,s=[],N=[],f=[],d=C=0,q=P.length;C<q;d=++C){if(_=P[d],c=l[d],65535===_){s.push(0),N.push(0);break}if(_-(k=n[_].new)>=32768)for(s.push(0),N.push(2*(f.length+A-d)),r=O=_;_<=c?O<=c:O>=c;r=_<=c?++O:--O)f.push(n[r].new);else s.push(k-_),N.push(0)}for(F.writeUInt16(3),F.writeUInt16(1),F.writeUInt32(12),F.writeUInt16(4),F.writeUInt16(16+8*A+2*f.length),F.writeUInt16(0),F.writeUInt16(S),F.writeUInt16(x),F.writeUInt16(h),F.writeUInt16(L),U=0,E=l.length;U<E;U++)r=l[U],F.writeUInt16(r);for(F.writeUInt16(0),H=0,R=P.length;H<R;H++)r=P[H],F.writeUInt16(r);for(V=0,D=s.length;V<D;V++)o=s[V],F.writeUInt16(o);for(G=0,T=N.length;G<T;G++)y=N[G],F.writeUInt16(y);for(Y=0,z=f.length;Y<z;Y++)p=f[Y],F.writeUInt16(p);return{charMap:n,subtable:F.data,maxGlyphID:b+1}}},t}(),be=function(){function t(){return t.__super__.constructor.apply(this,arguments)}return ge(t,he),t.prototype.tag="cmap",t.prototype.parse=function(t){var e,n,r;for(t.pos=this.offset,this.version=t.readUInt16(),r=t.readUInt16(),this.tables=[],this.unicode=null,n=0;0<=r?n<r:n>r;n=0<=r?++n:--n)e=new ve(t,this.offset),this.tables.push(e),e.isUnicode&&null==this.unicode&&(this.unicode=e);return!0},t.encode=function(t,e){var n,r;return null==e&&(e="macroman"),n=ve.encode(t,e),(r=new fe).writeUInt16(0),r.writeUInt16(1),n.table=r.data.concat(n.subtable),n},t}(),ye=function(){function t(){return t.__super__.constructor.apply(this,arguments)}return ge(t,he),t.prototype.tag="hhea",t.prototype.parse=function(t){return t.pos=this.offset,this.version=t.readInt(),this.ascender=t.readShort(),this.decender=t.readShort(),this.lineGap=t.readShort(),this.advanceWidthMax=t.readShort(),this.minLeftSideBearing=t.readShort(),this.minRightSideBearing=t.readShort(),this.xMaxExtent=t.readShort(),this.caretSlopeRise=t.readShort(),this.caretSlopeRun=t.readShort(),this.caretOffset=t.readShort(),t.pos+=8,this.metricDataFormat=t.readShort(),this.numberOfMetrics=t.readUInt16()},t}(),we=function(){function t(){return t.__super__.constructor.apply(this,arguments)}return ge(t,he),t.prototype.tag="OS/2",t.prototype.parse=function(t){if(t.pos=this.offset,this.version=t.readUInt16(),this.averageCharWidth=t.readShort(),this.weightClass=t.readUInt16(),this.widthClass=t.readUInt16(),this.type=t.readShort(),this.ySubscriptXSize=t.readShort(),this.ySubscriptYSize=t.readShort(),this.ySubscriptXOffset=t.readShort(),this.ySubscriptYOffset=t.readShort(),this.ySuperscriptXSize=t.readShort(),this.ySuperscriptYSize=t.readShort(),this.ySuperscriptXOffset=t.readShort(),this.ySuperscriptYOffset=t.readShort(),this.yStrikeoutSize=t.readShort(),this.yStrikeoutPosition=t.readShort(),this.familyClass=t.readShort(),this.panose=function(){var e,n;for(n=[],e=0;e<10;++e)n.push(t.readByte());return n}(),this.charRange=function(){var e,n;for(n=[],e=0;e<4;++e)n.push(t.readInt());return n}(),this.vendorID=t.readString(4),this.selection=t.readShort(),this.firstCharIndex=t.readShort(),this.lastCharIndex=t.readShort(),this.version>0&&(this.ascent=t.readShort(),this.descent=t.readShort(),this.lineGap=t.readShort(),this.winAscent=t.readShort(),this.winDescent=t.readShort(),this.codePageRange=function(){var e,n;for(n=[],e=0;e<2;e=++e)n.push(t.readInt());return n}(),this.version>1))return this.xHeight=t.readShort(),this.capHeight=t.readShort(),this.defaultChar=t.readShort(),this.breakChar=t.readShort(),this.maxContext=t.readShort()},t}(),Ne=function(){function t(){return t.__super__.constructor.apply(this,arguments)}return ge(t,he),t.prototype.tag="post",t.prototype.parse=function(t){var e,n,r;switch(t.pos=this.offset,this.format=t.readInt(),this.italicAngle=t.readInt(),this.underlinePosition=t.readShort(),this.underlineThickness=t.readShort(),this.isFixedPitch=t.readInt(),this.minMemType42=t.readInt(),this.maxMemType42=t.readInt(),this.minMemType1=t.readInt(),this.maxMemType1=t.readInt(),this.format){case 65536:case 196608:break;case 131072:var i;for(n=t.readUInt16(),this.glyphNameIndex=[],i=0;0<=n?i<n:i>n;i=0<=n?++i:--i)this.glyphNameIndex.push(t.readUInt16());for(this.names=[],r=[];t.pos<this.offset+this.length;)e=t.readByte(),r.push(this.names.push(t.readString(e)));return r;case 151552:return n=t.readUInt16(),this.offsets=t.read(n);case 262144:return this.map=function(){var e,n,r;for(r=[],i=e=0,n=this.file.maxp.numGlyphs;0<=n?e<n:e>n;i=0<=n?++e:--e)r.push(t.readUInt32());return r}.call(this)}},t}(),Le=function(t,e){this.raw=t,this.length=t.length,this.platformID=e.platformID,this.encodingID=e.encodingID,this.languageID=e.languageID},xe=function(){function t(){return t.__super__.constructor.apply(this,arguments)}return ge(t,he),t.prototype.tag="name",t.prototype.parse=function(t){var e,n,r,i,a,o,s,u,c,l,h;for(t.pos=this.offset,t.readShort(),e=t.readShort(),o=t.readShort(),n=[],i=0;0<=e?i<e:i>e;i=0<=e?++i:--i)n.push({platformID:t.readShort(),encodingID:t.readShort(),languageID:t.readShort(),nameID:t.readShort(),length:t.readShort(),offset:this.offset+o+t.readShort()});for(s={},i=c=0,l=n.length;c<l;i=++c)r=n[i],t.pos=r.offset,u=t.readString(r.length),a=new Le(u,r),null==s[h=r.nameID]&&(s[h]=[]),s[r.nameID].push(a);this.strings=s,this.copyright=s[0],this.fontFamily=s[1],this.fontSubfamily=s[2],this.uniqueSubfamily=s[3],this.fontName=s[4],this.version=s[5];try{this.postscriptName=s[6][0].raw.replace(/[\x00-\x19\x80-\xff]/g,"")}catch(f){this.postscriptName=s[4][0].raw.replace(/[\x00-\x19\x80-\xff]/g,"")}return this.trademark=s[7],this.manufacturer=s[8],this.designer=s[9],this.description=s[10],this.vendorUrl=s[11],this.designerUrl=s[12],this.license=s[13],this.licenseUrl=s[14],this.preferredFamily=s[15],this.preferredSubfamily=s[17],this.compatibleFull=s[18],this.sampleText=s[19]},t}(),Ae=function(){function t(){return t.__super__.constructor.apply(this,arguments)}return ge(t,he),t.prototype.tag="maxp",t.prototype.parse=function(t){return t.pos=this.offset,this.version=t.readInt(),this.numGlyphs=t.readUInt16(),this.maxPoints=t.readUInt16(),this.maxContours=t.readUInt16(),this.maxCompositePoints=t.readUInt16(),this.maxComponentContours=t.readUInt16(),this.maxZones=t.readUInt16(),this.maxTwilightPoints=t.readUInt16(),this.maxStorage=t.readUInt16(),this.maxFunctionDefs=t.readUInt16(),this.maxInstructionDefs=t.readUInt16(),this.maxStackElements=t.readUInt16(),this.maxSizeOfInstructions=t.readUInt16(),this.maxComponentElements=t.readUInt16(),this.maxComponentDepth=t.readUInt16()},t}(),Se=function(){function t(){return t.__super__.constructor.apply(this,arguments)}return ge(t,he),t.prototype.tag="hmtx",t.prototype.parse=function(t){var e,n,r,i,a,o,s;for(t.pos=this.offset,this.metrics=[],e=0,o=this.file.hhea.numberOfMetrics;0<=o?e<o:e>o;e=0<=o?++e:--e)this.metrics.push({advance:t.readUInt16(),lsb:t.readInt16()});for(r=this.file.maxp.numGlyphs-this.file.hhea.numberOfMetrics,this.leftSideBearings=function(){var n,i;for(i=[],e=n=0;0<=r?n<r:n>r;e=0<=r?++n:--n)i.push(t.readInt16());return i}(),this.widths=function(){var t,e,n,r;for(r=[],t=0,e=(n=this.metrics).length;t<e;t++)i=n[t],r.push(i.advance);return r}.call(this),n=this.widths[this.widths.length-1],s=[],e=a=0;0<=r?a<r:a>r;e=0<=r?++a:--a)s.push(this.widths.push(n));return s},t.prototype.forGlyph=function(t){return t in this.metrics?this.metrics[t]:{advance:this.metrics[this.metrics.length-1].advance,lsb:this.leftSideBearings[t-this.metrics.length]}},t}(),_e=[].slice,Pe=function(){function t(){return t.__super__.constructor.apply(this,arguments)}return ge(t,he),t.prototype.tag="glyf",t.prototype.parse=function(){return this.cache={}},t.prototype.glyphFor=function(t){var e,n,r,i,a,o,s,u,c,l;return t in this.cache?this.cache[t]:(i=this.file.loca,e=this.file.contents,n=i.indexOf(t),0===(r=i.lengthOf(t))?this.cache[t]=null:(e.pos=this.offset+n,a=(o=new fe(e.read(r))).readShort(),u=o.readShort(),l=o.readShort(),s=o.readShort(),c=o.readShort(),this.cache[t]=-1===a?new Fe(o,u,l,s,c):new ke(o,a,u,l,s,c),this.cache[t]))},t.prototype.encode=function(t,e,n){var r,i,a,o,s;for(a=[],i=[],o=0,s=e.length;o<s;o++)r=t[e[o]],i.push(a.length),r&&(a=a.concat(r.encode(n)));return i.push(a.length),{table:a,offsets:i}},t}(),ke=function(){function t(t,e,n,r,i,a){this.raw=t,this.numberOfContours=e,this.xMin=n,this.yMin=r,this.xMax=i,this.yMax=a,this.compound=!1}return t.prototype.encode=function(){return this.raw.data},t}(),Fe=function(){function t(t,e,n,r,i){var a,o;for(this.raw=t,this.xMin=e,this.yMin=n,this.xMax=r,this.yMax=i,this.compound=!0,this.glyphIDs=[],this.glyphOffsets=[],a=this.raw;o=a.readShort(),this.glyphOffsets.push(a.pos),this.glyphIDs.push(a.readUInt16()),32&o;)a.pos+=1&o?4:2,128&o?a.pos+=8:64&o?a.pos+=4:8&o&&(a.pos+=2)}return t.prototype.encode=function(){var t,e,n;for(e=new fe(_e.call(this.raw.data)),t=0,n=this.glyphIDs.length;t<n;++t)e.pos=this.glyphOffsets[t];return e.data},t}(),Ie=function(){function t(){return t.__super__.constructor.apply(this,arguments)}return ge(t,he),t.prototype.tag="loca",t.prototype.parse=function(t){var e,n;return t.pos=this.offset,e=this.file.head.indexToLocFormat,this.offsets=0===e?function(){var e,r;for(r=[],n=0,e=this.length;n<e;n+=2)r.push(2*t.readUInt16());return r}.call(this):function(){var e,r;for(r=[],n=0,e=this.length;n<e;n+=4)r.push(t.readUInt32());return r}.call(this)},t.prototype.indexOf=function(t){return this.offsets[t]},t.prototype.lengthOf=function(t){return this.offsets[t+1]-this.offsets[t]},t.prototype.encode=function(t,e){for(var n=new Uint32Array(this.offsets.length),r=0,i=0,a=0;a<n.length;++a)if(n[a]=r,i<e.length&&e[i]==a){++i,n[a]=r;var o=this.offsets[a],s=this.offsets[a+1]-o;s>0&&(r+=s)}for(var u=new Array(4*n.length),c=0;c<n.length;++c)u[4*c+3]=255&n[c],u[4*c+2]=(65280&n[c])>>8,u[4*c+1]=(16711680&n[c])>>16,u[4*c]=(4278190080&n[c])>>24;return u},t}(),je=function(){function t(t){this.font=t,this.subset={},this.unicodes={},this.next=33}return t.prototype.generateCmap=function(){var t,e,n,r,i;for(e in r=this.font.cmap.tables[0].codeMap,t={},i=this.subset)n=i[e],t[e]=r[n];return t},t.prototype.glyphsFor=function(t){var e,n,r,i,a,o,s;for(r={},a=0,o=t.length;a<o;a++)r[i=t[a]]=this.font.glyf.glyphFor(i);for(i in e=[],r)(null!=(n=r[i])?n.compound:void 0)&&e.push.apply(e,n.glyphIDs);if(e.length>0)for(i in s=this.glyphsFor(e))n=s[i],r[i]=n;return r},t.prototype.encode=function(t,e){var n,r,i,a,o,s,u,c,l,h,f,d,p,g,m;for(r in n=be.encode(this.generateCmap(),"unicode"),a=this.glyphsFor(t),f={0:0},m=n.charMap)f[(s=m[r]).old]=s.new;for(d in h=n.maxGlyphID,a)d in f||(f[d]=h++);return c=function(t){var e,n;for(e in n={},t)n[t[e]]=e;return n}(f),l=Object.keys(c).sort(function(t,e){return t-e}),p=function(){var t,e,n;for(n=[],t=0,e=l.length;t<e;t++)o=l[t],n.push(c[o]);return n}(),i=this.font.glyf.encode(a,p,f),u=this.font.loca.encode(i.offsets,p),g={cmap:this.font.cmap.raw(),glyf:i.table,loca:u,hmtx:this.font.hmtx.raw(),hhea:this.font.hhea.raw(),maxp:this.font.maxp.raw(),post:this.font.post.raw(),name:this.font.name.raw(),head:this.font.head.encode(e)},this.font.os2.exists&&(g["OS/2"]=this.font.os2.raw()),this.font.directory.encode(g)},t}();E.API.PDFObject=function(){var t;function e(){}return t=function(t,e){return(Array(e+1).join("0")+t).slice(-e)},e.convert=function(n){var r,i,a,o;if(Array.isArray(n))return"["+function(){var t,i,a;for(a=[],t=0,i=n.length;t<i;t++)r=n[t],a.push(e.convert(r));return a}().join(" ")+"]";if("string"==typeof n)return"/"+n;if(null!=n?n.isString:void 0)return"("+n+")";if(n instanceof Date)return"(D:"+t(n.getUTCFullYear(),4)+t(n.getUTCMonth(),2)+t(n.getUTCDate(),2)+t(n.getUTCHours(),2)+t(n.getUTCMinutes(),2)+t(n.getUTCSeconds(),2)+"Z)";if("[object Object]"==={}.toString.call(n)){for(i in a=["<<"],n)o=n[i],a.push("/"+i+" "+e.convert(o));return a.push(">>"),a.join("\n")}return""+n},e}();export{St as AcroForm,xt as AcroFormAppearance,mt as AcroFormButton,wt as AcroFormCheckBox,ft as AcroFormChoiceField,pt as AcroFormComboBox,gt as AcroFormEditBox,dt as AcroFormListBox,Lt as AcroFormPasswordField,vt as AcroFormPushButton,bt as AcroFormRadioButton,Nt as AcroFormTextField,O as GState,M as ShadingPattern,q as TilingPattern,E as default,E as jsPDF};
//# sourceMappingURL=jspdf.es.min.js.map
