<p align="center" style="text-align: center">
  <a href="https://tedirghazali.gitbook.io/algajs/" target="_blank" rel="noopener noreferrer">
    <img width="180" src="alga-js-logo.png" alt="Alga.js logo">
  </a>
</p>

<p align="center" style="text-align: center">
  <a href="https://npmcharts.com/compare/alga-js?minimal=true"><img src="https://img.shields.io/npm/dm/alga-js.svg?sanitize=true" alt="Downloads"></a>
  <a href="https://www.npmjs.com/package/alga-js"><img src="https://img.shields.io/npm/v/alga-js.svg?sanitize=true" alt="Version"></a>
  <a href="https://www.npmjs.com/package/alga-js"><img src="https://img.shields.io/npm/l/alga-js.svg?sanitize=true" alt="License"></a>
</p>
<br/>

# Alga.js
Alga.js is a JavaScript helper to help build UI components by using any of modern web frameworks or libraries, see [the documentation here](https://algajs.tedir.dev) or visit this link `https://algajs.tedir.dev`.

## Installation
This Alga.js is a pure JavaScript plugin, so it doesn't have any dependencies and you can install it by using NPM or Yarn. Don't forget to use `--save-dev` flag when installing it.

```sh
npm install alga-js --save-dev

#or

yarn add alga-js --dev
```

## Usage
You may want to use one of two JS modules either you use ES module or UMD module, ES module is highly recommended for using alongside modern web frameworks, but if you want it to run in the browser or in a server side, UMD module is the option.

```js
// ES modules
import { paginate, pages, pageInfo, pagination, ... } from 'alga-js/array' // highly recommended

import { array, object, string, number, func, date, ...others* } from 'alga-js' // don't use this import
import * as $ from 'alga-js' // don't use this import

// Node/CommonJS modules
const $ = require('alga-js')  // other than $, you can use algaJs or any variable name

// UMD (AMD/IIFE)
//<script src="alga-umd.js"></script>

// Obsolete or deprecated
import { $array, $object, $string, ... } from 'alga-js' // or
import * as _ from 'alga-js' // or
import * as Alga from 'alga-js'

// Tree-shakable // not recommended
import { paginate, pages, ... } from 'alga-js/lib/array.js'
import { weeks } from 'alga-js/lib/date.js' // or
import { ...[helperMethod]* } from 'alga-js/lib/[helperFile].js'
```
