import type { DragAndDropIcon, DragItem, DragSourceType, DraggingEvent, DropTarget } from 'ag-grid-community';
import { Component } from 'ag-grid-community';
import type { PillDragComp } from './pillDragComp';
export interface PillDropZonePanelParams {
    emptyMessage?: string;
    title?: string;
    icon?: Element;
}
export declare abstract class PillDropZonePanel<TPill extends PillDragComp<TItem>, TItem> extends Component {
    protected readonly horizontal: boolean;
    private state;
    private dropTarget;
    private potentialDndItems;
    private guiDestroyFunctions;
    private params;
    private childPillComponents;
    private insertIndex;
    private ePillDropList;
    private positionableFeature;
    private resizeEnabled;
    protected abstract isItemDroppable(item: TItem, draggingEvent: DraggingEvent): boolean;
    protected abstract updateItems(items: TItem[]): void;
    protected abstract getExistingItems(): TItem[];
    protected abstract getIconName(): DragAndDropIcon;
    protected abstract getAriaLabel(): string;
    protected abstract createPillComponent(item: TItem, dropTarget: DropTarget, ghost: boolean, horizontal: boolean): TPill;
    protected abstract getItems(dragItem: DragItem<TItem>): TItem[];
    protected abstract isInterestedIn(type: DragSourceType): boolean;
    constructor(horizontal: boolean);
    toggleResizable(resizable: boolean): void;
    protected isSourceEventFromTarget(draggingEvent: DraggingEvent): boolean;
    destroy(): void;
    private destroyGui;
    init(params?: PillDropZonePanelParams): void;
    private onTabKeyDown;
    private onKeyDown;
    protected addElementClasses(el: Element, suffix?: string): void;
    private setupDropTarget;
    protected minimumAllowedNewInsertIndex(): number;
    private checkInsertIndex;
    private getNewInsertIndex;
    private checkDragStartedBySelf;
    private onDragging;
    protected handleDragEnterEnd(_: DraggingEvent): void;
    private onDragEnter;
    protected isPotentialDndItems(): boolean;
    protected handleDragLeaveEnd(_: DraggingEvent): void;
    private onDragLeave;
    private onDragCancel;
    private onDragStop;
    private removeItems;
    private addItems;
    addItem(item: TItem): void;
    private rearrangeItems;
    refreshGui(): void;
    private getFocusedItem;
    private restoreFocus;
    focusList(fromBottom?: boolean): void;
    private getNonGhostItems;
    private addItemsToGui;
    private addAriaLabelsToComponents;
    private createItemComponent;
    private addIconAndTitleToGui;
    private isExistingItemsEmpty;
    private addEmptyMessageToGui;
    private addArrow;
}
