import type { ComponentSelector } from 'ag-grid-community';
import { Component } from 'ag-grid-community';
type GroupItem = Component<any> | HTMLElement;
type Align = 'start' | 'end' | 'center' | 'stretch';
type Direction = 'horizontal' | 'vertical';
export interface AgGroupComponentParams {
    title?: string;
    enabled?: boolean;
    suppressEnabledCheckbox?: boolean;
    suppressOpenCloseIcons?: boolean;
    suppressToggleExpandOnEnableChange?: boolean;
    cssIdentifier?: string;
    items?: GroupItem[];
    alignItems?: Align;
    direction?: Direction;
    onEnableChange?: (enabled: boolean) => void;
    onExpandedChange?: (expanded: boolean) => void;
    expanded?: boolean;
    useToggle?: boolean;
    suppressKeyboardNavigation?: boolean;
}
export type AgGroupComponentEvent = 'expanded' | 'collapsed' | 'enableChange';
export type ExpandedChangedEventType = 'expandedChanged';
export declare class AgGroupComponent extends Component<AgGroupComponentEvent> {
    private readonly params;
    private items;
    private cssIdentifier;
    private enabled;
    private expanded;
    private suppressEnabledCheckbox;
    private suppressToggleExpandOnEnableChange;
    private alignItems;
    private useToggle;
    private eToggle?;
    private eTitleBar?;
    private readonly eToolbar;
    private readonly cbGroupEnabled;
    private readonly eContainer;
    constructor(params?: AgGroupComponentParams);
    postConstruct(): void;
    private refreshChildDisplay;
    isExpanded(): boolean;
    setAlignItems(alignment: AgGroupComponentParams['alignItems']): this;
    toggleGroupExpand(expanded?: boolean, silent?: boolean): this;
    addItems(items: GroupItem[]): void;
    prependItem(item: GroupItem): void;
    addItem(item: GroupItem): void;
    private insertItem;
    hideItem(hide: boolean, index: number): void;
    getItemIndex(item: GroupItem): number | -1;
    setTitle(title: string): this;
    addTitleBarWidget(el: Element): this;
    addCssClassToTitleBar(cssClass: string): void;
    private dispatchEnableChangeEvent;
    setEnabled(enabled: boolean, skipToggle?: boolean, skipExpand?: boolean): this;
    isEnabled(): boolean;
    onEnableChange(callbackFn: (enabled: boolean) => void): this;
    onExpandedChange(callbackFn: (expanded: boolean) => void): this;
    hideEnabledCheckbox(hide: boolean): this;
    hideOpenCloseIcons(hide: boolean): this;
    private refreshDisabledStyles;
    private setupTitleBar;
    private createDefaultTitleBar;
    private createToggleTitleBar;
}
export declare const AgGroupComponentSelector: ComponentSelector;
export {};
