import type { AgColumn, AgColumnGroup, BeanCollection, CellCtrl, CellPosition, CellRange, CellRangeParams, ClearCellRangeParams, ICellRangeFeature, IHeaderCellComp, IRangeService, NamedBean, PartialCellRange, RowPinnedType, RowPosition } from 'ag-grid-community';
import { AutoScrollService, BeanStub } from 'ag-grid-community';
export declare class RangeService extends BeanStub implements NamedBean, IRangeService {
    beanName: "rangeSvc";
    private rowModel;
    private dragSvc;
    private colModel;
    private visibleCols;
    private cellNavigation;
    private pinnedRowModel?;
    private ctrlsSvc;
    private valueSvc;
    private selectionMode;
    wireBeans(beans: BeanCollection): void;
    private cellRanges;
    private lastMouseEvent;
    private bodyScrollListener;
    private lastCellHovered;
    private cellHasChanged;
    private newestRangeStartCell?;
    private dragging;
    private draggingRange?;
    private intersectionRange;
    autoScrollService: AutoScrollService;
    postConstruct(): void;
    onDragStart(mouseEvent: MouseEvent): void;
    onDragging(mouseEvent: MouseEvent | null): void;
    onDragStop(): void;
    onColumnsChanged(): void;
    refreshLastRangeStart(): void;
    isContiguousRange(cellRange: CellRange): boolean;
    getRangeStartRow(cellRange: PartialCellRange): RowPosition;
    getRangeEndRow(cellRange: PartialCellRange): RowPosition;
    setRangeToCell(cell: CellPosition, appendRange?: boolean): void;
    extendLatestRangeToCell(cellPosition: CellPosition): void;
    updateRangeEnd(cellRange: CellRange, cellPosition: CellPosition, silent?: boolean): void;
    getRangeEdgeColumns(cellRange: CellRange): {
        left: AgColumn;
        right: AgColumn;
    };
    extendLatestRangeInDirection(event: KeyboardEvent): CellPosition | undefined;
    setCellRange(params: CellRangeParams): void;
    setCellRanges(cellRanges: CellRange[]): void;
    clearCellRangeCellValues(params: ClearCellRangeParams): void;
    createCellRangeFromCellRangeParams(params: CellRangeParams): CellRange | undefined;
    createPartialCellRangeFromRangeParams(params: CellRangeParams, allowEmptyColumns: boolean): PartialCellRange | undefined;
    addCellRange(params: CellRangeParams): void;
    getCellRanges(): CellRange[];
    isEmpty(): boolean;
    isMoreThanOneCell(): boolean;
    areAllRangesAbleToMerge(): boolean;
    removeAllCellRanges(silent?: boolean): void;
    isCellInAnyRange(cell: CellPosition): boolean;
    isCellInSpecificRange(cell: CellPosition, range: CellRange): boolean;
    isBottomRightCell(cellRange: CellRange, cell: CellPosition): boolean;
    getCellRangeCount(cell: CellPosition): number;
    isRowInRange(rowIndex: number, rowPinned: RowPinnedType, cellRange: CellRange): boolean;
    intersectLastRange(fromMouseClick?: boolean): void;
    createRangeHighlightFeature(compBean: BeanStub, column: AgColumn<any> | AgColumnGroup, headerComp: IHeaderCellComp): void;
    private setSelectionMode;
    private focusFirstRenderedCellAtRowPosition;
    private refreshRangeStart;
    private setNewestRangeStartCell;
    private getColumnsFromParams;
    private createRowPosition;
    private verifyCellRanges;
    private forEachRowInRange;
    private onBodyScroll;
    private isLastCellOfRange;
    private rowMax;
    private rowMin;
    private updateValuesOnMove;
    private shouldSkipCurrentColumn;
    private dispatchChangedEvent;
    private getColumnFromModel;
    private getColumnsFromModel;
    private calculateColumnsBetween;
    createDragListenerFeature(eContainer: HTMLElement): BeanStub;
    createCellRangeFeature(beans: BeanCollection, ctrl: CellCtrl): ICellRangeFeature;
}
