var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __reExport = (target, mod, secondTarget) => (__copyProps(target, mod, "default"), secondTarget && __copyProps(secondTarget, mod, "default"));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/ag-grid-enterprise/src/main.ts
var main_exports = {};
__export(main_exports, {
  AdvancedFilterModule: () => AdvancedFilterModule,
  AggregationModule: () => AggregationModule,
  AllEnterpriseModule: () => AllEnterpriseModule,
  CellSelectionModule: () => CellSelectionModule,
  ClipboardModule: () => ClipboardModule,
  ColumnMenuModule: () => ColumnMenuModule,
  ColumnsToolPanelModule: () => ColumnsToolPanelModule,
  ContextMenuModule: () => ContextMenuModule,
  ExcelExportModule: () => ExcelExportModule,
  FiltersToolPanelModule: () => FiltersToolPanelModule,
  GridChartsModule: () => GridChartsModule,
  GroupFilterModule: () => GroupFilterModule,
  IntegratedChartsModule: () => IntegratedChartsModule,
  LicenseManager: () => GridLicenseManager,
  MasterDetailModule: () => MasterDetailModule,
  MenuModule: () => MenuModule,
  MultiFilterModule: () => MultiFilterModule,
  PivotModule: () => PivotModule,
  RangeSelectionModule: () => RangeSelectionModule,
  RichSelectModule: () => RichSelectModule,
  RowGroupingModule: () => RowGroupingModule,
  RowGroupingPanelModule: () => RowGroupingPanelModule,
  RowNumbersModule: () => RowNumbersModule,
  ServerSideRowModelApiModule: () => ServerSideRowModelApiModule,
  ServerSideRowModelModule: () => ServerSideRowModelModule,
  SetFilterModule: () => SetFilterModule,
  SideBarModule: () => SideBarModule,
  SparklinesModule: () => SparklinesModule,
  StatusBarModule: () => StatusBarModule,
  TreeDataModule: () => TreeDataModule,
  ViewportRowModelModule: () => ViewportRowModelModule,
  exportMultipleSheetsAsExcel: () => exportMultipleSheetsAsExcel,
  getMultipleSheetsAsExcel: () => getMultipleSheetsAsExcel
});
module.exports = __toCommonJS(main_exports);

// packages/ag-grid-enterprise/src/license/gridLicenseManager.ts
var import_ag_grid_community2 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/license/shared/md5.ts
var MD5 = class {
  constructor() {
    this.ieCompatibility = false;
  }
  init() {
    this.ieCompatibility = this.md5("hello") != "5d41402abc4b2a76b9719d911017c592";
  }
  md5cycle(x, k) {
    let a = x[0], b = x[1], c = x[2], d = x[3];
    a = this.ff(a, b, c, d, k[0], 7, -680876936);
    d = this.ff(d, a, b, c, k[1], 12, -389564586);
    c = this.ff(c, d, a, b, k[2], 17, 606105819);
    b = this.ff(b, c, d, a, k[3], 22, -1044525330);
    a = this.ff(a, b, c, d, k[4], 7, -176418897);
    d = this.ff(d, a, b, c, k[5], 12, 1200080426);
    c = this.ff(c, d, a, b, k[6], 17, -1473231341);
    b = this.ff(b, c, d, a, k[7], 22, -45705983);
    a = this.ff(a, b, c, d, k[8], 7, 1770035416);
    d = this.ff(d, a, b, c, k[9], 12, -1958414417);
    c = this.ff(c, d, a, b, k[10], 17, -42063);
    b = this.ff(b, c, d, a, k[11], 22, -1990404162);
    a = this.ff(a, b, c, d, k[12], 7, 1804603682);
    d = this.ff(d, a, b, c, k[13], 12, -40341101);
    c = this.ff(c, d, a, b, k[14], 17, -1502002290);
    b = this.ff(b, c, d, a, k[15], 22, 1236535329);
    a = this.gg(a, b, c, d, k[1], 5, -165796510);
    d = this.gg(d, a, b, c, k[6], 9, -1069501632);
    c = this.gg(c, d, a, b, k[11], 14, 643717713);
    b = this.gg(b, c, d, a, k[0], 20, -373897302);
    a = this.gg(a, b, c, d, k[5], 5, -701558691);
    d = this.gg(d, a, b, c, k[10], 9, 38016083);
    c = this.gg(c, d, a, b, k[15], 14, -660478335);
    b = this.gg(b, c, d, a, k[4], 20, -405537848);
    a = this.gg(a, b, c, d, k[9], 5, 568446438);
    d = this.gg(d, a, b, c, k[14], 9, -1019803690);
    c = this.gg(c, d, a, b, k[3], 14, -187363961);
    b = this.gg(b, c, d, a, k[8], 20, 1163531501);
    a = this.gg(a, b, c, d, k[13], 5, -1444681467);
    d = this.gg(d, a, b, c, k[2], 9, -51403784);
    c = this.gg(c, d, a, b, k[7], 14, 1735328473);
    b = this.gg(b, c, d, a, k[12], 20, -1926607734);
    a = this.hh(a, b, c, d, k[5], 4, -378558);
    d = this.hh(d, a, b, c, k[8], 11, -2022574463);
    c = this.hh(c, d, a, b, k[11], 16, 1839030562);
    b = this.hh(b, c, d, a, k[14], 23, -35309556);
    a = this.hh(a, b, c, d, k[1], 4, -1530992060);
    d = this.hh(d, a, b, c, k[4], 11, 1272893353);
    c = this.hh(c, d, a, b, k[7], 16, -155497632);
    b = this.hh(b, c, d, a, k[10], 23, -1094730640);
    a = this.hh(a, b, c, d, k[13], 4, 681279174);
    d = this.hh(d, a, b, c, k[0], 11, -358537222);
    c = this.hh(c, d, a, b, k[3], 16, -722521979);
    b = this.hh(b, c, d, a, k[6], 23, 76029189);
    a = this.hh(a, b, c, d, k[9], 4, -640364487);
    d = this.hh(d, a, b, c, k[12], 11, -421815835);
    c = this.hh(c, d, a, b, k[15], 16, 530742520);
    b = this.hh(b, c, d, a, k[2], 23, -995338651);
    a = this.ii(a, b, c, d, k[0], 6, -198630844);
    d = this.ii(d, a, b, c, k[7], 10, 1126891415);
    c = this.ii(c, d, a, b, k[14], 15, -1416354905);
    b = this.ii(b, c, d, a, k[5], 21, -57434055);
    a = this.ii(a, b, c, d, k[12], 6, 1700485571);
    d = this.ii(d, a, b, c, k[3], 10, -1894986606);
    c = this.ii(c, d, a, b, k[10], 15, -1051523);
    b = this.ii(b, c, d, a, k[1], 21, -2054922799);
    a = this.ii(a, b, c, d, k[8], 6, 1873313359);
    d = this.ii(d, a, b, c, k[15], 10, -30611744);
    c = this.ii(c, d, a, b, k[6], 15, -1560198380);
    b = this.ii(b, c, d, a, k[13], 21, 1309151649);
    a = this.ii(a, b, c, d, k[4], 6, -145523070);
    d = this.ii(d, a, b, c, k[11], 10, -1120210379);
    c = this.ii(c, d, a, b, k[2], 15, 718787259);
    b = this.ii(b, c, d, a, k[9], 21, -343485551);
    x[0] = this.add32(a, x[0]);
    x[1] = this.add32(b, x[1]);
    x[2] = this.add32(c, x[2]);
    x[3] = this.add32(d, x[3]);
  }
  cmn(q, a, b, x, s, t) {
    a = this.add32(this.add32(a, q), this.add32(x, t));
    return this.add32(a << s | a >>> 32 - s, b);
  }
  ff(a, b, c, d, x, s, t) {
    return this.cmn(b & c | ~b & d, a, b, x, s, t);
  }
  gg(a, b, c, d, x, s, t) {
    return this.cmn(b & d | c & ~d, a, b, x, s, t);
  }
  hh(a, b, c, d, x, s, t) {
    return this.cmn(b ^ c ^ d, a, b, x, s, t);
  }
  ii(a, b, c, d, x, s, t) {
    return this.cmn(c ^ (b | ~d), a, b, x, s, t);
  }
  md51(s) {
    const n = s.length;
    const state = [1732584193, -271733879, -1732584194, 271733878];
    let i;
    for (i = 64; i <= s.length; i += 64) {
      this.md5cycle(state, this.md5blk(s.substring(i - 64, i)));
    }
    s = s.substring(i - 64);
    const tail = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
    for (i = 0; i < s.length; i++) {
      tail[i >> 2] |= s.charCodeAt(i) << (i % 4 << 3);
    }
    tail[i >> 2] |= 128 << (i % 4 << 3);
    if (i > 55) {
      this.md5cycle(state, tail);
      for (i = 0; i < 16; i++) {
        tail[i] = 0;
      }
    }
    tail[14] = n * 8;
    this.md5cycle(state, tail);
    return state;
  }
  /* there needs to be support for Unicode here, * unless we pretend that we can redefine the MD-5
   * algorithm for multi-byte characters (perhaps by adding every four 16-bit characters and
   * shortening the sum to 32 bits). Otherwise I suthis.ggest performing MD-5 as if every character
   * was two bytes--e.g., 0040 0025 = @%--but then how will an ordinary MD-5 sum be matched?
   * There is no way to standardize text to something like UTF-8 before transformation; speed cost is
   * utterly prohibitive. The JavaScript standard itself needs to look at this: it should start
   * providing access to strings as preformed UTF-8 8-bit unsigned value arrays.
   */
  md5blk(s) {
    const md5blks = [];
    for (let i = 0; i < 64; i += 4) {
      md5blks[i >> 2] = s.charCodeAt(i) + (s.charCodeAt(i + 1) << 8) + (s.charCodeAt(i + 2) << 16) + (s.charCodeAt(i + 3) << 24);
    }
    return md5blks;
  }
  rhex(n) {
    const hex_chr = "0123456789abcdef".split("");
    let s = "", j = 0;
    for (; j < 4; j++) {
      s += hex_chr[n >> j * 8 + 4 & 15] + hex_chr[n >> j * 8 & 15];
    }
    return s;
  }
  hex(x) {
    for (let i = 0; i < x.length; i++) {
      x[i] = this.rhex(x[i]);
    }
    return x.join("");
  }
  md5(s) {
    return this.hex(this.md51(s));
  }
  add32(a, b) {
    return this.ieCompatibility ? this.add32Compat(a, b) : this.add32Std(a, b);
  }
  /* this function is much faster, so if possible we use it. Some IEs are the only ones I know of that
   need the idiotic second function, generated by an if clause.  */
  add32Std(a, b) {
    return a + b & 4294967295;
  }
  add32Compat(x, y) {
    const lsw = (x & 65535) + (y & 65535), msw = (x >> 16) + (y >> 16) + (lsw >> 16);
    return msw << 16 | lsw & 65535;
  }
};

// packages/ag-grid-enterprise/src/license/shared/licenseManager.ts
var LICENSE_TYPES = {
  "01": "GRID",
  "02": "CHARTS",
  "0102": "BOTH"
};
var LICENSING_HELP_URL = "https://www.ag-grid.com/licensing/";
var _LicenseManager = class _LicenseManager {
  constructor(document2) {
    this.watermarkMessage = void 0;
    this.totalMessageLength = 124;
    this.document = document2;
    this.md5 = new MD5();
    this.md5.init();
  }
  validateLicense() {
    const licenseDetails = this.getLicenseDetails(_LicenseManager.licenseKey);
    const currentLicenseName = `AG Grid ${licenseDetails.currentLicenseType === "BOTH" ? "and AG Charts " : ""}Enterprise`;
    const suppliedLicenseName = licenseDetails.suppliedLicenseType === void 0 ? "" : `AG ${licenseDetails.suppliedLicenseType === "BOTH" ? "Grid and AG Charts" : licenseDetails.suppliedLicenseType === "GRID" ? "Grid" : "Charts"} Enterprise`;
    if (licenseDetails.missing) {
      if (!this.isWebsiteUrl() || this.isForceWatermark()) {
        this.outputMissingLicenseKey(currentLicenseName);
      }
    } else if (licenseDetails.expired) {
      const gridReleaseDate = _LicenseManager.getGridReleaseDate();
      const formattedReleaseDate = _LicenseManager.formatDate(gridReleaseDate);
      this.outputExpiredKey(licenseDetails.expiry, formattedReleaseDate, currentLicenseName, suppliedLicenseName);
    } else if (!licenseDetails.valid) {
      this.outputInvalidLicenseKey(
        !!licenseDetails.incorrectLicenseType,
        currentLicenseName,
        suppliedLicenseName
      );
    } else if (licenseDetails.isTrial && licenseDetails.trialExpired) {
      this.outputExpiredTrialKey(licenseDetails.expiry, currentLicenseName, suppliedLicenseName);
    }
  }
  static extractExpiry(license) {
    const restrictionHashed = license.substring(license.lastIndexOf("_") + 1, license.length);
    return new Date(parseInt(_LicenseManager.decode(restrictionHashed), 10));
  }
  static extractLicenseComponents(licenseKey) {
    let cleanedLicenseKey = licenseKey.replace(/[\u200B-\u200D\uFEFF]/g, "");
    cleanedLicenseKey = cleanedLicenseKey.replace(/\r?\n|\r/g, "");
    if (licenseKey.length <= 32) {
      return { md5: null, license: licenseKey, version: null, isTrial: null };
    }
    const hashStart = cleanedLicenseKey.length - 32;
    const md5 = cleanedLicenseKey.substring(hashStart);
    const license = cleanedLicenseKey.substring(0, hashStart);
    const [version, isTrial, type] = _LicenseManager.extractBracketedInformation(cleanedLicenseKey);
    return { md5, license, version, isTrial, type };
  }
  getLicenseDetails(licenseKey) {
    const currentLicenseType = _LicenseManager.chartsLicenseManager ? "BOTH" : "GRID";
    if (!licenseKey?.length) {
      return {
        licenseKey,
        valid: false,
        missing: true,
        currentLicenseType
      };
    }
    const gridReleaseDate = _LicenseManager.getGridReleaseDate();
    const { md5, license, version, isTrial, type } = _LicenseManager.extractLicenseComponents(licenseKey);
    let valid = md5 === this.md5.md5(license) && licenseKey.indexOf("For_Trialing_ag-Grid_Only") === -1;
    let trialExpired = void 0;
    let expired = void 0;
    let expiry = null;
    let incorrectLicenseType = false;
    let suppliedLicenseType = void 0;
    function handleTrial() {
      const now = /* @__PURE__ */ new Date();
      trialExpired = expiry < now;
      expired = void 0;
    }
    if (valid) {
      expiry = _LicenseManager.extractExpiry(license);
      valid = !isNaN(expiry.getTime());
      if (valid) {
        expired = gridReleaseDate > expiry;
        switch (version) {
          case "legacy":
          case "2": {
            if (isTrial) {
              handleTrial();
            }
            break;
          }
          case "3": {
            if (!type?.length) {
              valid = false;
            } else {
              suppliedLicenseType = type;
              if (type !== LICENSE_TYPES["01"] && type !== LICENSE_TYPES["0102"] || currentLicenseType === "BOTH" && suppliedLicenseType !== "BOTH") {
                valid = false;
                incorrectLicenseType = true;
              } else if (isTrial) {
                handleTrial();
              }
            }
          }
        }
      }
    }
    if (!valid) {
      return {
        licenseKey,
        valid,
        incorrectLicenseType,
        currentLicenseType,
        suppliedLicenseType
      };
    }
    return {
      licenseKey,
      valid,
      expiry: _LicenseManager.formatDate(expiry),
      expired,
      version,
      isTrial,
      trialExpired,
      incorrectLicenseType,
      currentLicenseType,
      suppliedLicenseType
    };
  }
  isDisplayWatermark() {
    return this.isForceWatermark() || !this.isLocalhost() && !this.isWebsiteUrl() && !!this.watermarkMessage?.length;
  }
  getWatermarkMessage() {
    return this.watermarkMessage || "";
  }
  getHostname() {
    const win = this.document.defaultView || window;
    const loc = win.location;
    const { hostname = "" } = loc;
    return hostname;
  }
  isForceWatermark() {
    const win = this.document.defaultView || window;
    const loc = win.location;
    const { pathname } = loc;
    return pathname ? pathname.indexOf("forceWatermark") !== -1 : false;
  }
  isWebsiteUrl() {
    const hostname = this.getHostname();
    return hostname.match(/^((?:[\w-]+\.)?ag-grid\.com)$/) !== null;
  }
  isLocalhost() {
    const hostname = this.getHostname();
    return hostname.match(/^(?:127\.0\.0\.1|localhost)$/) !== null;
  }
  static formatDate(date) {
    const monthNames = [
      "January",
      "February",
      "March",
      "April",
      "May",
      "June",
      "July",
      "August",
      "September",
      "October",
      "November",
      "December"
    ];
    const day = date.getDate();
    const monthIndex = date.getMonth();
    const year = date.getFullYear();
    return day + " " + monthNames[monthIndex] + " " + year;
  }
  static getGridReleaseDate() {
    return new Date(parseInt(_LicenseManager.decode(_LicenseManager.RELEASE_INFORMATION), 10));
  }
  static decode(input) {
    const keystr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    let t = "";
    let n, r, i;
    let s, o, u, a;
    let f = 0;
    const e = input.replace(/[^A-Za-z0-9+/=]/g, "");
    while (f < e.length) {
      s = keystr.indexOf(e.charAt(f++));
      o = keystr.indexOf(e.charAt(f++));
      u = keystr.indexOf(e.charAt(f++));
      a = keystr.indexOf(e.charAt(f++));
      n = s << 2 | o >> 4;
      r = (o & 15) << 4 | u >> 2;
      i = (u & 3) << 6 | a;
      t = t + String.fromCharCode(n);
      if (u != 64) {
        t = t + String.fromCharCode(r);
      }
      if (a != 64) {
        t = t + String.fromCharCode(i);
      }
    }
    t = _LicenseManager.utf8_decode(t);
    return t;
  }
  static utf8_decode(input) {
    input = input.replace(/rn/g, "n");
    let t = "";
    for (let n = 0; n < input.length; n++) {
      const r = input.charCodeAt(n);
      if (r < 128) {
        t += String.fromCharCode(r);
      } else if (r > 127 && r < 2048) {
        t += String.fromCharCode(r >> 6 | 192);
        t += String.fromCharCode(r & 63 | 128);
      } else {
        t += String.fromCharCode(r >> 12 | 224);
        t += String.fromCharCode(r >> 6 & 63 | 128);
        t += String.fromCharCode(r & 63 | 128);
      }
    }
    return t;
  }
  static setChartsLicenseManager(dependantLicenseManager) {
    this.chartsLicenseManager = dependantLicenseManager;
  }
  static setLicenseKey(licenseKey) {
    this.licenseKey = licenseKey;
    this.chartsLicenseManager?.setLicenseKey(licenseKey, true);
  }
  static extractBracketedInformation(licenseKey) {
    if (!licenseKey.includes("[")) {
      return ["legacy", false, void 0];
    }
    const matches = licenseKey.match(/\[(.*?)\]/g).map((match) => match.replace("[", "").replace("]", ""));
    if (!matches || matches.length === 0) {
      return ["legacy", false, void 0];
    }
    const isTrial = matches.filter((match) => match === "TRIAL").length === 1;
    const rawVersion = matches.filter((match) => match.indexOf("v") === 0)[0];
    const version = rawVersion ? rawVersion.replace("v", "") : "legacy";
    const type = LICENSE_TYPES[matches.filter((match) => LICENSE_TYPES[match])[0]];
    return [version, isTrial, type];
  }
  centerPadAndOutput(input) {
    const paddingRequired = this.totalMessageLength - input.length;
    console.error(input.padStart(paddingRequired / 2 + input.length, "*").padEnd(this.totalMessageLength, "*"));
  }
  padAndOutput(input, padding = "*", terminateWithPadding = "") {
    console.error(
      input.padEnd(this.totalMessageLength - terminateWithPadding.length, padding) + terminateWithPadding
    );
  }
  outputInvalidLicenseKey(incorrectLicenseType, currentLicenseName, suppliedLicenseName) {
    if (incorrectLicenseType) {
      this.centerPadAndOutput("");
      this.centerPadAndOutput(` ${currentLicenseName} License `);
      this.centerPadAndOutput(" Incompatible License Key ");
      this.padAndOutput(
        `* Your license key is for ${suppliedLicenseName} only and does not cover you for ${currentLicenseName}.`,
        " ",
        "*"
      );
      this.padAndOutput(`* To troubleshoot your license key visit ${LICENSING_HELP_URL}.`, " ", "*");
      this.centerPadAndOutput("");
      this.centerPadAndOutput("");
    } else {
      this.centerPadAndOutput("");
      this.centerPadAndOutput(` ${currentLicenseName} License `);
      this.centerPadAndOutput(" Invalid License Key ");
      this.padAndOutput(`* Your license key is not valid.`, " ", "*");
      this.padAndOutput(`* To troubleshoot your license key visit ${LICENSING_HELP_URL}.`, " ", "*");
      this.centerPadAndOutput("");
      this.centerPadAndOutput("");
    }
    this.watermarkMessage = "Invalid License";
  }
  outputExpiredTrialKey(formattedExpiryDate, currentLicenseName, suppliedLicenseName) {
    this.centerPadAndOutput("");
    this.centerPadAndOutput(` ${currentLicenseName} License `);
    this.centerPadAndOutput(" Trial Period Expired. ");
    this.padAndOutput(
      `* Your trial only license for ${suppliedLicenseName} expired on ${formattedExpiryDate}.`,
      " ",
      "*"
    );
    this.padAndOutput("* Please email info@ag-grid.com to purchase a license.", " ", "*");
    this.centerPadAndOutput("");
    this.centerPadAndOutput("");
    this.watermarkMessage = "Trial Period Expired";
  }
  outputMissingLicenseKey(currentLicenseName) {
    this.centerPadAndOutput("");
    this.centerPadAndOutput(` ${currentLicenseName} License `);
    this.centerPadAndOutput(" License Key Not Found ");
    this.padAndOutput(`* All ${currentLicenseName} features are unlocked for trial.`, " ", "*");
    this.padAndOutput(
      "* If you want to hide the watermark please email info@ag-grid.com for a trial license key.",
      " ",
      "*"
    );
    this.centerPadAndOutput("");
    this.centerPadAndOutput("");
    this.watermarkMessage = "For Trial Use Only";
  }
  outputExpiredKey(formattedExpiryDate, formattedReleaseDate, currentLicenseName, suppliedLicenseName) {
    this.centerPadAndOutput("");
    this.centerPadAndOutput(` ${currentLicenseName} License `);
    this.centerPadAndOutput(" Incompatible Software Version ");
    this.padAndOutput(
      `* Your license key works with versions of ${suppliedLicenseName} released before ${formattedExpiryDate}.`,
      " ",
      "*"
    );
    this.padAndOutput(`* The version you are trying to use was released on ${formattedReleaseDate}.`, " ", "*");
    this.padAndOutput("* Please contact info@ag-grid.com to renew your license key.", " ", "*");
    this.centerPadAndOutput("");
    this.centerPadAndOutput("");
    this.watermarkMessage = "License Expired";
  }
};
_LicenseManager.RELEASE_INFORMATION = "MTczOTgwMzI0NzgzNQ==";
var LicenseManager = _LicenseManager;

// packages/ag-grid-enterprise/src/license/watermark.ts
var import_ag_grid_community = require("ag-grid-community");

// packages/ag-grid-enterprise/src/license/watermark.css-GENERATED.ts
var watermarkCSS = (
  /*css*/
  `.ag-watermark{bottom:20px;color:#9b9b9b;opacity:.7;position:absolute;transition:opacity 1s ease-out 3s;&:before{background-image:url("data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyMDkiIGhlaWdodD0iMzYiIGZpbGw9Im5vbmUiIHZpZXdCb3g9IjAgMCAyMDkgMzYiPjxwYXRoIGZpbGw9IiM5QjlCOUIiIGQ9Ik0xOTIuOTkzIDIzLjY1OHYtNy45NDZoLTEzLjU0MWwtNy45NDcgNy45NDZ6TTIwOC4yNSAzLjk1aC0xNi45NzRsLTguMDEgNy45NDdoMjQuOTg0ek0xNjMuNjIyIDMxLjYwNWw0LjA2OS00LjA2OWgxMy43MzJ2Ny45NDdoLTE3LjgwMXoiLz48cGF0aCBmaWxsPSIjOUI5QjlCIiBkPSJNMTY2LjYxIDE5Ljc4aDguNzczbDguMDEtNy45NDZIMTY2LjYxek0xNTcuMDExIDMxLjYwNWg2LjYxMWw3Ljg4My03Ljk0N2gtMTQuNDk0ek0xOTEuMjc2IDMuOTVsLTQuMDY4IDQuMDdIMTYxLjI3Vi4wNzJoMzAuMDA2ek0yMC44NCAzMC4yMDZIOC4zNzhsLTIuMTYyIDUuMzRILjc1TDEyLjI1NyA4LjU5Mmg0Ljc2OEwyOC41MyAzNS41NDZoLTUuNTN6bS0xLjcxNy00LjI2TDE0LjYwOSAxNC45NWwtNC41MTQgMTAuOTk4ek0xMDQuNDM3IDE4LjUwOWMxLjU4OS0yLjM1MiA1LjU5NC0yLjYwNyA3LjI0Ny0yLjYwN3Y0LjU3OGMtMi4wMzQgMC00LjA2OS4wNjMtNS4yNzcuOTUzLTEuMjA3Ljg5LTEuODQzIDIuMDk4LTEuODQzIDMuNTZ2MTAuNTUzaC00Ljk1OVYxNS45MDJoNC43Njh6TTExOS4zNzYgMTUuOTAyaC00Ljk1OHYxOS42NDRoNC45NTh6TTExOS4zNzYgNy4xM2gtNC45NTh2NS44NDhoNC45NTh6TTE0My45NzkgNy4xM3YyOC40MTZoLTQuNzY4bC0uMTI3LTIuOTg4YTguMyA4LjMgMCAwIDEtMi42NyAyLjQ4Yy0xLjA4MS41NzItMi40MTYuODktMy45NDIuODktMS4zMzUgMC0yLjYwNi0uMjU1LTMuNjg3LS43LTEuMTQ0LS41MDgtMi4xNjItMS4xNDQtMi45ODgtMi4wMzRhOS42IDkuNiAwIDAgMS0xLjk3MS0zLjE3OWMtLjUwOC0xLjIwNy0uNjk5LTIuNjA2LS42OTktNC4xMzJzLjI1NC0yLjkyNC42OTktNC4xOTZjLjUwOS0xLjI3MSAxLjE0NS0yLjM1MiAxLjk3MS0zLjI0MnMxLjg0NC0xLjU4OSAyLjk4OC0yLjA5OCAyLjM1Mi0uNzYzIDMuNjg3LS43NjNjMS41MjYgMCAyLjc5Ny4yNTUgMy44NzguODI3czEuOTcxIDEuMzM1IDIuNjcgMi40MTZWNy4xOTNoNC45NTl6bS0xMC40MjYgMjQuNTM4YzEuNjUzIDAgMi45MjQtLjU3MiAzLjk0MS0xLjY1M3MxLjUyNi0yLjU0MyAxLjUyNi00LjMyMy0uNTA5LTMuMTc4LTEuNTI2LTQuMzIyYy0xLjAxNy0xLjA4MS0yLjI4OC0xLjY1My0zLjk0MS0xLjY1My0xLjU5IDAtMi45MjUuNTcyLTMuODc4IDEuNjUzLTEuMDE3IDEuMDgtMS41MjYgMi41NDMtMS41MjYgNC4zMjIgMCAxLjc4LjUwOSAzLjE4IDEuNTI2IDQuMjYgMS4wMTcgMS4xNDQgMi4yODggMS43MTYgMy44NzggMS43MTZNNTcuMjAyIDIwLjM1M0g0NC45MzN2NC4yNTloNi45OTNjLS4xOSAyLjE2MS0xLjAxNyAzLjgxNC0yLjQxNiA1LjE1LTEuMzk4IDEuMjctMy4xNzggMS45MDYtNS40NjcgMS45MDYtMS4yNzEgMC0yLjQ4LS4yNTQtMy40OTYtLjY5OWE3IDcgMCAwIDEtMi43MzQtMS45N2MtLjc2My0uODI3LTEuMzM1LTEuODQ0LTEuNzgtMy4wNTJzLS42MzYtMi40OC0uNjM2LTMuOTQyLjE5LTIuNzMzLjYzNi0zLjk0MWMuMzgxLTEuMjA4IDEuMDE3LTIuMTYyIDEuNzgtMy4wNTIuNzYzLS44MjYgMS42NTMtMS40NjIgMi43MzMtMS45N2E5LjEgOS4xIDAgMCAxIDMuNTYtLjdxNC4wMDUgMCA2LjEwMyAxLjkwN2wzLjMwNi0zLjMwNWMtMi40OC0xLjkwNy01LjY1OC0yLjkyNS05LjQwOS0yLjkyNS0yLjA5NyAwLTQuMDA0LjMxOC01LjcyMSAxLjAxOC0xLjcxNi42OTktMy4xNzkgMS41ODktNC4zODYgMi43OTdBMTIuMSAxMi4xIDAgMCAwIDMxLjIgMTYuMjJjLS42MzUgMS43MTctLjk1MyAzLjYyNC0uOTUzIDUuNjU4cy4zMTggMy45NDIgMS4wMTcgNS42NThjLjcgMS43MTcgMS41OSAzLjE3OSAyLjc5NyA0LjM4N2ExMi4xIDEyLjEgMCAwIDAgNC4zODcgMi43OTdjMS43MTYuNyAzLjYyMyAxLjAxNyA1LjY1NyAxLjAxNyAyLjAzNSAwIDMuODc4LS4zMTggNS41MzEtMS4wMTcgMS42NTMtLjcgMy4wNTItMS41OSA0LjE5Ni0yLjc5N3ExLjcxNi0xLjgxMiAyLjY3LTQuMzg3Yy42MzYtMS43MTYuOTU0LTMuNjIzLjk1NC01LjY1OHYtLjgyNmMtLjE5MS0uMTI3LS4yNTUtLjQ0NS0uMjU1LS43TTk1Ljk4MiAyMC4zNTNoLTEyLjI3djQuMjU5aDYuOTkzYy0uMTkgMi4xNjEtMS4wMTcgMy44MTQtMi40MTYgNS4xNS0xLjM5OCAxLjI3LTMuMTc4IDEuOTA2LTUuNDY3IDEuOTA2LTEuMjcxIDAtMi40OC0uMjU0LTMuNDk2LS42OTlhNyA3IDAgMCAxLTIuNzM0LTEuOTdjLS43NjMtLjgyNy0xLjMzNS0xLjg0NC0xLjc4LTMuMDUycy0uNjM2LTIuNDgtLjYzNi0zLjk0Mi4xOS0yLjczMy42MzYtMy45NDFjLjM4MS0xLjIwOCAxLjAxNy0yLjE2MiAxLjc4LTMuMDUyLjc2My0uODI2IDEuNjUzLTEuNDYyIDIuNzM0LTEuOTdhOS4xIDkuMSAwIDAgMSAzLjU2LS43cTQuMDA1IDAgNi4xMDMgMS45MDdsMy4zMDUtMy4zMDVjLTIuNDc5LTEuOTA3LTUuNjU4LTIuOTI1LTkuNDA4LTIuOTI1LTIuMDk4IDAtNC4wMDUuMzE4LTUuNzIyIDEuMDE4LTEuNzE2LjY5OS0zLjE3OCAxLjU4OS00LjM4NiAyLjc5N2ExMi4xIDEyLjEgMCAwIDAtMi43OTcgNC4zODZjLS42MzYgMS43MTctLjk1NCAzLjYyNC0uOTU0IDUuNjU4cy4zMTggMy45NDIgMS4wMTcgNS42NThjLjcgMS43MTcgMS41OSAzLjE3OSAyLjc5NyA0LjM4N2ExMi4xIDEyLjEgMCAwIDAgNC4zODcgMi43OTdjMS43MTYuNyAzLjYyMyAxLjAxNyA1LjY1OCAxLjAxNyAyLjAzNCAwIDMuODc4LS4zMTggNS41My0xLjAxNyAxLjY1My0uNyAzLjA1Mi0xLjU5IDQuMTk2LTIuNzk3cTEuNzE4LTEuODEyIDIuNjctNC4zODdjLjYzNi0xLjcxNi45NTQtMy42MjMuOTU0LTUuNjU4di0uODI2Yy0uMTktLjEyNy0uMjU1LS40NDUtLjI1NS0uNyIvPjwvc3ZnPg==");background-repeat:no-repeat;background-size:170px 40px;content:"";display:block;height:40px;width:170px}}:where(.ag-ltr) .ag-watermark{right:25px}:where(.ag-rtl) .ag-watermark{left:25px}.ag-watermark-text{font-family:Impact,sans-serif;font-size:19px;font-weight:700;opacity:.5}:where(.ag-ltr) .ag-watermark-text{padding-left:.7rem}:where(.ag-rtl) .ag-watermark-text{padding-right:.7rem}`
);

// packages/ag-grid-enterprise/src/license/watermark.ts
var AgWatermark = class extends import_ag_grid_community.Component {
  constructor() {
    super(
      /* html*/
      `<div class="ag-watermark">
                <div data-ref="eLicenseTextRef" class="ag-watermark-text"></div>
            </div>`
    );
    this.eLicenseTextRef = import_ag_grid_community.RefPlaceholder;
    this.registerCSS(watermarkCSS);
  }
  wireBeans(beans) {
    this.licenseManager = beans.licenseManager;
  }
  postConstruct() {
    const show = this.shouldDisplayWatermark();
    this.setDisplayed(show);
    if (show) {
      this.eLicenseTextRef.textContent = this.licenseManager.getWatermarkMessage();
      window.setTimeout(() => this.addCssClass("ag-opacity-zero"), 0);
      window.setTimeout(() => this.setDisplayed(false), 5e3);
    }
  }
  shouldDisplayWatermark() {
    return this.licenseManager.isDisplayWatermark();
  }
};
var AgWatermarkSelector = {
  selector: "AG-WATERMARK",
  component: AgWatermark
};

// packages/ag-grid-enterprise/src/license/gridLicenseManager.ts
var GridLicenseManager = class extends import_ag_grid_community2.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "licenseManager";
  }
  postConstruct() {
    this.validateLicense();
  }
  validateLicense() {
    this.licenseManager = new LicenseManager((0, import_ag_grid_community2._getDocument)(this.beans));
    this.licenseManager.validateLicense();
  }
  static getLicenseDetails(licenseKey) {
    return new LicenseManager(null).getLicenseDetails(licenseKey);
  }
  getWatermarkSelector() {
    return AgWatermarkSelector;
  }
  isDisplayWatermark() {
    return this.licenseManager.isDisplayWatermark();
  }
  getWatermarkMessage() {
    return this.licenseManager.getWatermarkMessage();
  }
  static setLicenseKey(licenseKey) {
    LicenseManager.setLicenseKey(licenseKey);
  }
  static setChartsLicenseManager(chartsLicenseManager) {
    LicenseManager.setChartsLicenseManager(chartsLicenseManager);
  }
};

// packages/ag-grid-enterprise/src/excelExport/excelCreator.ts
var import_ag_grid_community10 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/excelExport/excelSerializingSession.ts
var import_ag_grid_community8 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/excelExport/assets/excelUtils.ts
var import_ag_grid_community3 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/excelExport/assets/excelConstants.ts
var INCH_TO_EMU = 9525;
var numberFormatMap = {
  "0": 1,
  "0.00": 2,
  "#,##0": 3,
  "#,##0.00": 4,
  "0%": 9,
  "0.00%": 10,
  "0.00E+00": 11,
  "# ?/?": 12,
  "# ??/??": 13,
  "mm-dd-yy": 14,
  "d-mmm-yy": 15,
  "d-mmm": 16,
  "mmm-yy": 17,
  "h:mm AM/PM": 18,
  "h:mm:ss AM/PM": 19,
  "h:mm": 20,
  "h:mm:ss": 21,
  "m/d/yy h:mm": 22,
  "#,##0 ;(#,##0)": 37,
  "#,##0 ;[Red](#,##0)": 38,
  "#,##0.00;(#,##0.00)": 39,
  "#,##0.00;[Red](#,##0.00)": 40,
  "mm:ss": 45,
  "[h]:mm:ss": 46,
  "mmss.0": 47,
  "##0.0E+0": 48,
  "@": 49
};

// packages/ag-grid-enterprise/src/excelExport/assets/xmlFactory.ts
var LINE_SEPARATOR = "\r\n";
function returnAttributeIfPopulated(key, value, booleanTransformer) {
  if (!value && value !== "" && value !== 0) {
    return "";
  }
  let xmlValue = value;
  if (typeof value === "boolean") {
    if (booleanTransformer) {
      xmlValue = booleanTransformer(value);
    }
  }
  return ` ${key}="${xmlValue}"`;
}
function createXmlHeader(headerElement = {}) {
  const headerStart = "<?";
  const headerEnd = "?>";
  const keys = ["version"];
  if (!headerElement.version) {
    headerElement.version = "1.0";
  }
  if (headerElement.encoding) {
    keys.push("encoding");
  }
  if (headerElement.standalone) {
    keys.push("standalone");
  }
  const att = keys.map((key) => `${key}="${headerElement[key]}"`).join(" ");
  return `${headerStart}xml ${att} ${headerEnd}`;
}
function createXml(xmlElement, booleanTransformer) {
  let props = "";
  if (xmlElement.properties) {
    if (xmlElement.properties.prefixedAttributes) {
      xmlElement.properties.prefixedAttributes.forEach((prefixedSet) => {
        Object.keys(prefixedSet.map).forEach((key) => {
          props += returnAttributeIfPopulated(
            prefixedSet.prefix + key,
            prefixedSet.map[key],
            booleanTransformer
          );
        });
      });
    }
    if (xmlElement.properties.rawMap) {
      Object.keys(xmlElement.properties.rawMap).forEach((key) => {
        props += returnAttributeIfPopulated(key, xmlElement.properties.rawMap[key], booleanTransformer);
      });
    }
  }
  let result = "<" + xmlElement.name + props;
  if (!xmlElement.children && xmlElement.textNode == null) {
    return result + "/>" + LINE_SEPARATOR;
  }
  if (xmlElement.textNode != null) {
    return result + ">" + xmlElement.textNode + "</" + xmlElement.name + ">" + LINE_SEPARATOR;
  }
  result += ">" + LINE_SEPARATOR;
  if (xmlElement.children) {
    xmlElement.children.forEach((it) => {
      result += createXml(it, booleanTransformer);
    });
  }
  return result + "</" + xmlElement.name + ">" + LINE_SEPARATOR;
}

// packages/ag-grid-enterprise/src/excelExport/assets/excelUtils.ts
var pointsToPixel = (points) => {
  return Math.round(points * 96 / 72);
};
var pixelsToEMU = (value) => {
  return Math.ceil(value * INCH_TO_EMU);
};
var getFontFamilyId = (name) => {
  if (name === void 0) {
    return;
  }
  const families = ["Automatic", "Roman", "Swiss", "Modern", "Script", "Decorative"];
  const pos = families.indexOf(name || "Automatic");
  return Math.max(pos, 0);
};
var getHeightFromProperty = (rowIndex, height) => {
  if (!height) {
    return;
  }
  let finalHeight;
  if (typeof height === "number") {
    finalHeight = height;
  } else {
    const heightFunc = height;
    finalHeight = heightFunc({ rowIndex });
  }
  return finalHeight;
};
var setExcelImageTotalWidth = (image, columnsToExport) => {
  const { colSpan, column } = image.position;
  if (!image.width) {
    return;
  }
  if (colSpan) {
    const columnsInSpan = columnsToExport.slice(column - 1, column + colSpan - 1);
    let totalWidth = 0;
    for (let i = 0; i < columnsInSpan.length; i++) {
      const colWidth = columnsInSpan[i].getActualWidth();
      if (image.width < totalWidth + colWidth) {
        image.position.colSpan = i + 1;
        image.totalWidth = image.width;
        image.width = image.totalWidth - totalWidth;
        break;
      }
      totalWidth += colWidth;
    }
  } else {
    image.totalWidth = image.width;
  }
};
var setExcelImageTotalHeight = (image, rowHeight) => {
  const { rowSpan, row } = image.position;
  if (!image.height) {
    return;
  }
  if (rowSpan) {
    let totalHeight = 0;
    let counter = 0;
    for (let i = row; i < row + rowSpan; i++) {
      const nextRowHeight = pointsToPixel(getHeightFromProperty(i, rowHeight) || 20);
      if (image.height < totalHeight + nextRowHeight) {
        image.position.rowSpan = counter + 1;
        image.totalHeight = image.height;
        image.height = image.totalHeight - totalHeight;
        break;
      }
      totalHeight += nextRowHeight;
      counter++;
    }
  } else {
    image.totalHeight = image.height;
  }
};
var createXmlPart = (body, skipHeader) => {
  const header = createXmlHeader({
    encoding: "UTF-8",
    standalone: "yes"
  });
  const xmlBody = createXml(body);
  if (skipHeader) {
    return xmlBody;
  }
  return `${header}${xmlBody}`;
};
var getExcelColumnName = (colIdx) => {
  const startCode = 65;
  const tableWidth = 26;
  const fromCharCode = String.fromCharCode;
  const pos = Math.floor(colIdx / tableWidth);
  const tableIdx = colIdx % tableWidth;
  if (!pos || colIdx === tableWidth) {
    return fromCharCode(startCode + colIdx - 1);
  }
  if (!tableIdx) {
    return getExcelColumnName(pos - 1) + "Z";
  }
  if (pos < tableWidth) {
    return fromCharCode(startCode + pos - 1) + fromCharCode(startCode + tableIdx - 1);
  }
  return getExcelColumnName(pos) + fromCharCode(startCode + tableIdx - 1);
};
var replaceInvisibleCharacters = (str) => {
  if (str == null) {
    return null;
  }
  let newString = "";
  for (let i = 0; i < str.length; i++) {
    const point = str.charCodeAt(i);
    if (point >= 0 && point <= 31 && point !== 10) {
      const convertedCode = point.toString(16).toUpperCase();
      const paddedCode = convertedCode.padStart(4, "0");
      const newValue = `_x${paddedCode}_`;
      newString += newValue;
    } else {
      newString += str[i];
    }
  }
  return newString;
};
var buildSharedString = (strMap) => {
  const ret = [];
  for (const key of strMap.keys()) {
    const textNode = key.toString();
    const child = {
      name: "t",
      textNode: (0, import_ag_grid_community3._escapeString)(replaceInvisibleCharacters(textNode), false)
    };
    const preserveSpaces = textNode.trim().length !== textNode.length;
    if (preserveSpaces) {
      child.properties = {
        rawMap: {
          "xml:space": "preserve"
        }
      };
    }
    ret.push({
      name: "si",
      children: [child]
    });
  }
  return ret;
};

// packages/ag-grid-enterprise/src/excelExport/excelXlsxFactory.ts
var import_ag_grid_community7 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/contentType.ts
var contentTypeFactory = {
  getTemplate(config) {
    const { name, ContentType, Extension, PartName } = config;
    return {
      name,
      properties: {
        rawMap: {
          Extension,
          PartName,
          ContentType
        }
      }
    };
  }
};
var contentType_default = contentTypeFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/contentTypes.ts
var _normaliseImageExtension = (ext) => ext === "jpg" ? "jpeg" : ext;
var contentTypesFactory = {
  getTemplate(sheetLen) {
    const worksheets = new Array(sheetLen).fill(void 0).map((v, i) => ({
      name: "Override",
      ContentType: "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml",
      PartName: `/xl/worksheets/sheet${i + 1}.xml`
    }));
    const sheetsWithImages = XLSX_WORKSHEET_IMAGES.size;
    const headerFooterImages = XLSX_WORKSHEET_HEADER_FOOTER_IMAGES.size;
    const imageTypesObject = {};
    XLSX_WORKBOOK_IMAGE_IDS.forEach((v) => {
      imageTypesObject[_normaliseImageExtension(v.type)] = true;
    });
    const imageDocs = new Array(sheetsWithImages).fill(void 0).map((v, i) => ({
      name: "Override",
      ContentType: "application/vnd.openxmlformats-officedocument.drawing+xml",
      PartName: `/xl/drawings/drawing${i + 1}.xml`
    }));
    const tableDocs = [];
    XLSX_WORKSHEET_DATA_TABLES.forEach(({ name }) => {
      tableDocs.push({
        name: "Override",
        ContentType: "application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml",
        PartName: `/xl/tables/${name}.xml`
      });
    });
    const imageTypes = Object.keys(imageTypesObject).map((ext) => ({
      name: "Default",
      ContentType: `image/${ext}`,
      Extension: ext
    }));
    if (headerFooterImages) {
      imageTypes.push({
        name: "Default",
        Extension: "vml",
        ContentType: "application/vnd.openxmlformats-officedocument.vmlDrawing"
      });
    }
    const children = [
      ...imageTypes,
      {
        name: "Default",
        Extension: "rels",
        ContentType: "application/vnd.openxmlformats-package.relationships+xml"
      },
      {
        name: "Default",
        ContentType: "application/xml",
        Extension: "xml"
      },
      {
        name: "Override",
        ContentType: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml",
        PartName: "/xl/workbook.xml"
      },
      ...worksheets,
      {
        name: "Override",
        ContentType: "application/vnd.openxmlformats-officedocument.theme+xml",
        PartName: "/xl/theme/theme1.xml"
      },
      {
        name: "Override",
        ContentType: "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml",
        PartName: "/xl/styles.xml"
      },
      {
        name: "Override",
        ContentType: "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml",
        PartName: "/xl/sharedStrings.xml"
      },
      ...imageDocs,
      ...tableDocs,
      {
        name: "Override",
        ContentType: "application/vnd.openxmlformats-package.core-properties+xml",
        PartName: "/docProps/core.xml"
      }
    ].map((contentType) => contentType_default.getTemplate(contentType));
    return {
      name: "Types",
      properties: {
        rawMap: {
          xmlns: "http://schemas.openxmlformats.org/package/2006/content-types"
        }
      },
      children
    };
  }
};
var contentTypes_default = contentTypesFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/core.ts
var coreFactory = {
  getTemplate(author) {
    const dt = /* @__PURE__ */ new Date();
    const jsonDate = dt.toJSON();
    return {
      name: "cp:coreProperties",
      properties: {
        prefixedAttributes: [
          {
            prefix: "xmlns:",
            map: {
              cp: "http://schemas.openxmlformats.org/package/2006/metadata/core-properties",
              dc: "http://purl.org/dc/elements/1.1/",
              dcterms: "http://purl.org/dc/terms/",
              dcmitype: "http://purl.org/dc/dcmitype/",
              xsi: "http://www.w3.org/2001/XMLSchema-instance"
            }
          }
        ]
      },
      children: [
        {
          name: "dc:creator",
          textNode: author
        },
        {
          name: "dc:title",
          textNode: "Workbook"
        },
        {
          name: "dcterms:created",
          properties: {
            rawMap: {
              "xsi:type": "dcterms:W3CDTF"
            }
          },
          textNode: jsonDate
        },
        {
          name: "dcterms:modified",
          properties: {
            rawMap: {
              "xsi:type": "dcterms:W3CDTF"
            }
          },
          textNode: jsonDate
        }
      ]
    };
  }
};
var core_default = coreFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/drawing.ts
var getAnchor = (name, imageAnchor) => ({
  name: `xdr:${name}`,
  children: [
    {
      name: "xdr:col",
      textNode: imageAnchor.col.toString()
    },
    {
      name: "xdr:colOff",
      textNode: imageAnchor.offsetX.toString()
    },
    {
      name: "xdr:row",
      textNode: imageAnchor.row.toString()
    },
    {
      name: "xdr:rowOff",
      textNode: imageAnchor.offsetY.toString()
    }
  ]
});
var getExt = (image) => {
  const children = [
    {
      name: "a:ext",
      properties: {
        rawMap: {
          uri: "{FF2B5EF4-FFF2-40B4-BE49-F238E27FC236}"
        }
      },
      children: [
        {
          name: "a16:creationId",
          properties: {
            rawMap: {
              id: "{822E6D20-D7BC-2841-A643-D49A6EF008A2}",
              "xmlns:a16": "http://schemas.microsoft.com/office/drawing/2014/main"
            }
          }
        }
      ]
    }
  ];
  const recolor = image.recolor && image.recolor.toLowerCase();
  switch (recolor) {
    case "grayscale":
    case "sepia":
    case "washout":
      children.push({
        name: "a:ext",
        properties: {
          rawMap: {
            uri: "{C183D7F6-B498-43B3-948B-1728B52AA6E4}"
          }
        },
        children: [
          {
            name: "adec:decorative",
            properties: {
              rawMap: {
                val: "0",
                "xmlns:adec": "http://schemas.microsoft.com/office/drawing/2017/decorative"
              }
            }
          }
        ]
      });
  }
  return {
    name: "a:extLst",
    children
  };
};
var getNvPicPr = (image, index) => ({
  name: "xdr:nvPicPr",
  children: [
    {
      name: "xdr:cNvPr",
      properties: {
        rawMap: {
          id: index,
          name: image.id,
          descr: image.altText != null ? image.altText : void 0
        }
      },
      children: [getExt(image)]
    },
    {
      name: "xdr:cNvPicPr",
      properties: {
        rawMap: {
          preferRelativeResize: "0"
        }
      },
      children: [
        {
          name: "a:picLocks"
        }
      ]
    }
  ]
});
var getColorDetails = (color) => {
  if (!color.saturation && !color.tint) {
    return;
  }
  const ret = [];
  if (color.saturation) {
    ret.push({
      name: "a:satMod",
      properties: {
        rawMap: {
          val: color.saturation * 1e3
        }
      }
    });
  }
  if (color.tint) {
    ret.push({
      name: "a:tint",
      properties: {
        rawMap: {
          val: color.tint * 1e3
        }
      }
    });
  }
  return ret;
};
var getDuoTone = (primaryColor, secondaryColor) => {
  return {
    name: "a:duotone",
    children: [
      {
        name: "a:prstClr",
        properties: {
          rawMap: {
            val: primaryColor.color
          }
        },
        children: getColorDetails(primaryColor)
      },
      {
        name: "a:srgbClr",
        properties: {
          rawMap: {
            val: secondaryColor.color
          }
        },
        children: getColorDetails(secondaryColor)
      }
    ]
  };
};
var getBlipFill = (image, index) => {
  let blipChildren;
  if (image.transparency) {
    const transparency = Math.min(Math.max(image.transparency, 0), 100);
    blipChildren = [
      {
        name: "a:alphaModFix",
        properties: {
          rawMap: {
            amt: 1e5 - Math.round(transparency * 1e3)
          }
        }
      }
    ];
  }
  if (image.recolor) {
    if (!blipChildren) {
      blipChildren = [];
    }
    switch (image.recolor.toLocaleLowerCase()) {
      case "grayscale":
        blipChildren.push({ name: "a:grayscl" });
        break;
      case "sepia":
        blipChildren.push(getDuoTone({ color: "black" }, { color: "D9C3A5", tint: 50, saturation: 180 }));
        break;
      case "washout":
        blipChildren.push({
          name: "a:lum",
          properties: {
            rawMap: {
              bright: "70000",
              contrast: "-70000"
            }
          }
        });
        break;
      default:
    }
  }
  return {
    name: "xdr:blipFill",
    children: [
      {
        name: "a:blip",
        properties: {
          rawMap: {
            cstate: "print",
            "r:embed": `rId${index}`,
            "xmlns:r": "http://schemas.openxmlformats.org/officeDocument/2006/relationships"
          }
        },
        children: blipChildren
      },
      {
        name: "a:stretch",
        children: [
          {
            name: "a:fillRect"
          }
        ]
      }
    ]
  };
};
var getSpPr = (image, imageBoxSize) => {
  const xfrm = {
    name: "a:xfrm",
    children: [
      {
        name: "a:off",
        properties: {
          rawMap: {
            x: 0,
            y: 0
          }
        }
      },
      {
        name: "a:ext",
        properties: {
          rawMap: {
            cx: imageBoxSize.width,
            cy: imageBoxSize.height
          }
        }
      }
    ]
  };
  if (image.rotation) {
    const rotation = image.rotation;
    xfrm.properties = {
      rawMap: {
        rot: Math.min(Math.max(rotation, 0), 360) * 6e4
      }
    };
  }
  const prstGeom = {
    name: "a:prstGeom",
    properties: {
      rawMap: {
        prst: "rect"
      }
    },
    children: [{ name: "a:avLst" }]
  };
  const ret = {
    name: "xdr:spPr",
    children: [xfrm, prstGeom]
  };
  return ret;
};
var getImageBoxSize = (image) => {
  image.fitCell = !!image.fitCell || !image.width || !image.height;
  const { position = {}, fitCell, width = 0, height = 0, totalHeight, totalWidth } = image;
  const { offsetX = 0, offsetY = 0, row = 1, rowSpan = 1, column = 1, colSpan = 1 } = position;
  return {
    from: {
      row: row - 1,
      col: column - 1,
      offsetX: pixelsToEMU(offsetX),
      offsetY: pixelsToEMU(offsetY)
    },
    to: {
      row: row - 1 + (fitCell ? 1 : rowSpan - 1),
      col: column - 1 + (fitCell ? 1 : colSpan - 1),
      offsetX: pixelsToEMU(width + offsetX),
      offsetY: pixelsToEMU(height + offsetY)
    },
    height: pixelsToEMU(totalHeight || height),
    width: pixelsToEMU(totalWidth || width)
  };
};
var getPicture = (image, currentIndex, worksheetImageIndex, imageBoxSize) => {
  return {
    name: "xdr:pic",
    children: [
      getNvPicPr(image, currentIndex + 1),
      getBlipFill(image, worksheetImageIndex + 1),
      getSpPr(image, imageBoxSize)
    ]
  };
};
var drawingFactory = {
  getTemplate(config) {
    const { sheetIndex } = config;
    const sheetImages = XLSX_WORKSHEET_IMAGES.get(sheetIndex);
    const sheetImageIds = XLSX_WORKSHEET_IMAGE_IDS.get(sheetIndex);
    const children = sheetImages.map((image, idx) => {
      const boxSize = getImageBoxSize(image);
      return {
        name: "xdr:twoCellAnchor",
        properties: {
          rawMap: {
            editAs: "absolute"
          }
        },
        children: [
          getAnchor("from", boxSize.from),
          getAnchor("to", boxSize.to),
          getPicture(image, idx, sheetImageIds.get(image.id).index, boxSize),
          { name: "xdr:clientData" }
        ]
      };
    });
    return {
      name: "xdr:wsDr",
      properties: {
        rawMap: {
          "xmlns:a": "http://schemas.openxmlformats.org/drawingml/2006/main",
          "xmlns:xdr": "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing"
        }
      },
      children
    };
  }
};
var drawing_default = drawingFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/relationship.ts
var relationshipFactory = {
  getTemplate(config) {
    const { Id, Type, Target } = config;
    return {
      name: "Relationship",
      properties: {
        rawMap: {
          Id,
          Type,
          Target
        }
      }
    };
  }
};
var relationship_default = relationshipFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/relationships.ts
var relationshipsFactory = {
  getTemplate(c) {
    const children = c.map((relationship) => relationship_default.getTemplate(relationship));
    return {
      name: "Relationships",
      properties: {
        rawMap: {
          xmlns: "http://schemas.openxmlformats.org/package/2006/relationships"
        }
      },
      children
    };
  }
};
var relationships_default = relationshipsFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/sharedStrings.ts
var sharedStrings = {
  getTemplate(strings) {
    return {
      name: "sst",
      properties: {
        rawMap: {
          xmlns: "http://schemas.openxmlformats.org/spreadsheetml/2006/main",
          count: strings.size,
          uniqueCount: strings.size
        }
      },
      children: buildSharedString(strings)
    };
  }
};
var sharedStrings_default = sharedStrings;

// packages/ag-grid-enterprise/src/excelExport/assets/excelLegacyConvert.ts
var getWeightName = (value) => {
  switch (value) {
    case 1:
      return "thin";
    case 2:
      return "medium";
    case 3:
      return "thick";
    default:
      return "hair";
  }
};
var mappedBorderNames = {
  None: "None",
  Dot: "Dotted",
  Dash: "Dashed",
  Double: "Double",
  DashDot: "DashDot",
  DashDotDot: "DashDotDot",
  SlantDashDot: "SlantDashDot",
  Continuous: "Continuous"
};
var mediumBorders = ["Dashed", "DashDot", "DashDotDot"];
var colorMap = {
  None: "none",
  Solid: "solid",
  Gray50: "mediumGray",
  Gray75: "darkGray",
  Gray25: "lightGray",
  HorzStripe: "darkHorizontal",
  VertStripe: "darkVertical",
  ReverseDiagStripe: "darkDown",
  DiagStripe: "darkUp",
  DiagCross: "darkGrid",
  ThickDiagCross: "darkTrellis",
  ThinHorzStripe: "lightHorizontal",
  ThinVertStripe: "lightVertical",
  ThinReverseDiagStripe: "lightDown",
  ThinDiagStripe: "lightUp",
  ThinHorzCross: "lightGrid",
  ThinDiagCross: "lightTrellis",
  Gray125: "gray125",
  Gray0625: "gray0625"
};
var horizontalAlignmentMap = {
  Automatic: "general",
  Left: "left",
  Center: "center",
  Right: "right",
  Fill: "fill",
  Justify: "justify",
  CenterAcrossSelection: "centerContinuous",
  Distributed: "distributed",
  JustifyDistributed: "justify"
};
var verticalAlignmentMap = {
  Automatic: void 0,
  Top: "top",
  Bottom: "bottom",
  Center: "center",
  Justify: "justify",
  Distributed: "distributed",
  JustifyDistributed: "justify"
};
var convertLegacyPattern = (name) => {
  if (!name) {
    return "none";
  }
  return colorMap[name] || name;
};
var convertLegacyColor = (color) => {
  if (color == void 0) {
    return color;
  }
  if (color.charAt(0) === "#") {
    color = color.substring(1);
  }
  return color.length === 6 ? "FF" + color : color;
};
var convertLegacyBorder = (type, weight) => {
  if (!type) {
    return "thin";
  }
  const namedWeight = getWeightName(weight);
  if (type === "Continuous") {
    return namedWeight;
  }
  const mappedName = mappedBorderNames[type];
  if (namedWeight === "medium" && mediumBorders.some((type2) => type2 === mappedName)) {
    return `medium${mappedName}`;
  }
  return `${mappedName.charAt(0).toLowerCase()}${mappedName.substring(1)}`;
};
var convertLegacyHorizontalAlignment = (alignment) => {
  return horizontalAlignmentMap[alignment] || "general";
};
var convertLegacyVerticalAlignment = (alignment) => {
  return verticalAlignmentMap[alignment] || void 0;
};

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/styles/border.ts
var getBorderColor = (color) => {
  return {
    name: "color",
    properties: {
      rawMap: {
        rgb: convertLegacyColor(color || "#000000")
      }
    }
  };
};
var borderFactory = {
  getTemplate(border) {
    const { left, right, top, bottom, diagonal } = border;
    const leftChildren = left ? [getBorderColor(left.color)] : void 0;
    const rightChildren = right ? [getBorderColor(right.color)] : void 0;
    const topChildren = top ? [getBorderColor(top.color)] : void 0;
    const bottomChildren = bottom ? [getBorderColor(bottom.color)] : void 0;
    const diagonalChildren = diagonal ? [getBorderColor(diagonal.color)] : void 0;
    return {
      name: "border",
      children: [
        {
          name: "left",
          properties: { rawMap: { style: left && left.style } },
          children: leftChildren
        },
        {
          name: "right",
          properties: { rawMap: { style: right && right.style } },
          children: rightChildren
        },
        {
          name: "top",
          properties: { rawMap: { style: top && top.style } },
          children: topChildren
        },
        {
          name: "bottom",
          properties: { rawMap: { style: bottom && bottom.style } },
          children: bottomChildren
        },
        {
          name: "diagonal",
          properties: { rawMap: { style: diagonal && diagonal.style } },
          children: diagonalChildren
        }
      ]
    };
  }
};
var border_default = borderFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/styles/borders.ts
var bordersFactory = {
  getTemplate(borders) {
    return {
      name: "borders",
      properties: {
        rawMap: {
          count: borders.length
        }
      },
      children: borders.map((border) => border_default.getTemplate(border))
    };
  }
};
var borders_default = bordersFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/styles/alignment.ts
var getReadingOrderId = (readingOrder) => {
  const order = ["Context", "LeftToRight", "RightToLeft"];
  const pos = order.indexOf(readingOrder);
  return Math.max(pos, 0);
};
var alignmentFactory = {
  getTemplate(alignment) {
    const { horizontal, indent, readingOrder, rotate, shrinkToFit, vertical, wrapText } = alignment;
    return {
      name: "alignment",
      properties: {
        rawMap: {
          horizontal: horizontal && convertLegacyHorizontalAlignment(horizontal),
          indent,
          readingOrder: readingOrder && getReadingOrderId(readingOrder),
          textRotation: rotate,
          shrinkToFit,
          vertical: vertical && convertLegacyVerticalAlignment(vertical),
          wrapText
        }
      }
    };
  }
};
var alignment_default = alignmentFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/styles/protection.ts
var protectionFactory = {
  getTemplate(protection) {
    const locked = protection.protected === false ? 0 : 1;
    const hidden = protection.hideFormula === true ? 1 : 0;
    return {
      name: "protection",
      properties: {
        rawMap: {
          hidden,
          locked
        }
      }
    };
  }
};
var protection_default = protectionFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/styles/xf.ts
var xfFactory = {
  getTemplate(xf) {
    const { alignment, borderId, fillId, fontId, numFmtId, protection, quotePrefix, xfId } = xf;
    const children = [];
    if (alignment) {
      children.push(alignment_default.getTemplate(alignment));
    }
    if (protection) {
      children.push(protection_default.getTemplate(protection));
    }
    return {
      name: "xf",
      properties: {
        rawMap: {
          applyAlignment: alignment ? 1 : void 0,
          applyProtection: protection ? 1 : void 0,
          applyBorder: borderId ? 1 : void 0,
          applyFill: fillId ? 1 : void 0,
          borderId,
          fillId,
          applyFont: fontId ? 1 : void 0,
          fontId,
          applyNumberFormat: numFmtId ? 1 : void 0,
          numFmtId,
          quotePrefix: quotePrefix ? 1 : void 0,
          xfId
        }
      },
      children: children.length ? children : void 0
    };
  }
};
var xf_default = xfFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/styles/cellStyleXfs.ts
var cellStylesXfsFactory = {
  getTemplate(xfs) {
    return {
      name: "cellStyleXfs",
      properties: {
        rawMap: {
          count: xfs.length
        }
      },
      children: xfs.map((xf) => xf_default.getTemplate(xf))
    };
  }
};
var cellStyleXfs_default = cellStylesXfsFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/styles/cellStyle.ts
var borderFactory2 = {
  getTemplate(cellStyle) {
    const { builtinId, name, xfId } = cellStyle;
    return {
      name: "cellStyle",
      properties: {
        rawMap: {
          builtinId,
          name,
          xfId
        }
      }
    };
  }
};
var cellStyle_default = borderFactory2;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/styles/cellStyles.ts
var cellStylesFactory = {
  getTemplate(cellStyles) {
    return {
      name: "cellStyles",
      properties: {
        rawMap: {
          count: cellStyles.length
        }
      },
      children: cellStyles.map((cellStyle) => cellStyle_default.getTemplate(cellStyle))
    };
  }
};
var cellStyles_default = cellStylesFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/styles/cellXfs.ts
var cellXfsFactory = {
  getTemplate(xfs) {
    return {
      name: "cellXfs",
      properties: {
        rawMap: {
          count: xfs.length
        }
      },
      children: xfs.map((xf) => xf_default.getTemplate(xf))
    };
  }
};
var cellXfs_default = cellXfsFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/styles/fill.ts
var fillFactory = {
  getTemplate(fill) {
    const { patternType, fgTheme, fgTint, fgRgb, bgRgb, bgIndexed } = fill;
    const pf = {
      name: "patternFill",
      properties: {
        rawMap: {
          patternType
        }
      }
    };
    if (fgTheme || fgTint || fgRgb) {
      pf.children = [
        {
          name: "fgColor",
          properties: {
            rawMap: {
              theme: fgTheme,
              tint: fgTint,
              rgb: fgRgb
            }
          }
        }
      ];
    }
    if (bgIndexed || bgRgb) {
      if (!pf.children) {
        pf.children = [];
      }
      pf.children.push({
        name: "bgColor",
        properties: {
          rawMap: {
            indexed: bgIndexed,
            rgb: bgRgb
          }
        }
      });
    }
    return {
      name: "fill",
      children: [pf]
    };
  }
};
var fill_default = fillFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/styles/fills.ts
var fillsFactory = {
  getTemplate(fills) {
    return {
      name: "fills",
      properties: {
        rawMap: {
          count: fills.length
        }
      },
      children: fills.map((fill) => fill_default.getTemplate(fill))
    };
  }
};
var fills_default = fillsFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/styles/font.ts
var fontFactory = {
  getTemplate(font) {
    const {
      size,
      colorTheme,
      color = "FF000000",
      fontName = "Calibri",
      family,
      scheme,
      italic,
      bold,
      strikeThrough,
      outline,
      shadow: shadow2,
      underline,
      verticalAlign
    } = font;
    const children = [
      { name: "sz", properties: { rawMap: { val: size } } },
      { name: "color", properties: { rawMap: { theme: colorTheme, rgb: color } } },
      { name: "name", properties: { rawMap: { val: fontName } } }
    ];
    if (family) {
      children.push({ name: "family", properties: { rawMap: { val: family } } });
    }
    if (scheme) {
      children.push({ name: "scheme", properties: { rawMap: { val: scheme } } });
    }
    if (italic) {
      children.push({ name: "i" });
    }
    if (bold) {
      children.push({ name: "b" });
    }
    if (strikeThrough) {
      children.push({ name: "strike" });
    }
    if (outline) {
      children.push({ name: "outline" });
    }
    if (shadow2) {
      children.push({ name: "shadow" });
    }
    if (underline) {
      children.push({ name: "u", properties: { rawMap: { val: underline } } });
    }
    if (verticalAlign) {
      children.push({ name: "vertAlign", properties: { rawMap: { val: verticalAlign } } });
    }
    return { name: "font", children };
  }
};
var font_default = fontFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/styles/fonts.ts
var fontsFactory = {
  getTemplate(fonts) {
    return {
      name: "fonts",
      properties: {
        rawMap: {
          count: fonts.length
        }
      },
      children: fonts.map((font) => font_default.getTemplate(font))
    };
  }
};
var fonts_default = fontsFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/styles/numberFormat.ts
var import_ag_grid_community4 = require("ag-grid-community");
function prepareString(str) {
  const split = str.split(/(\[[^\]]*\])/);
  for (let i = 0; i < split.length; i++) {
    let currentString = split[i];
    if (!currentString.length) {
      continue;
    }
    if (!currentString.startsWith("[")) {
      currentString = currentString.replace(/\$/g, '"$"');
    }
    split[i] = (0, import_ag_grid_community4._escapeString)(currentString);
  }
  return split.join("");
}
var numberFormatFactory = {
  getTemplate(numberFormat) {
    let { formatCode, numFmtId } = numberFormat;
    if (formatCode.length) {
      formatCode = prepareString(formatCode);
    }
    return {
      name: "numFmt",
      properties: {
        rawMap: {
          formatCode,
          numFmtId
        }
      }
    };
  }
};
var numberFormat_default = numberFormatFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/styles/numberFormats.ts
var numberFormatsFactory = {
  getTemplate(numberFormats) {
    return {
      name: "numFmts",
      properties: {
        rawMap: {
          count: numberFormats.length
        }
      },
      children: numberFormats.map((numberFormat) => numberFormat_default.getTemplate(numberFormat))
    };
  }
};
var numberFormats_default = numberFormatsFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/styles/stylesheet.ts
var stylesMap;
var registeredNumberFmts;
var registeredFonts;
var registeredFills;
var registeredBorders;
var registeredCellStyleXfs;
var registeredCellXfs;
var registeredCellStyles;
var currentSheet;
var getStyleName = (name, currentSheet2) => {
  if (name.indexOf("mixedStyle") !== -1 && currentSheet2 > 1) {
    name += `_${currentSheet2}`;
  }
  return name;
};
var resetStylesheetValues = () => {
  stylesMap = { base: 0 };
  registeredNumberFmts = [];
  registeredFonts = [{ fontName: "Calibri", colorTheme: "1", family: "2", scheme: "minor" }];
  registeredFills = [{ patternType: "none" }, { patternType: "gray125" }];
  registeredBorders = [{ left: void 0, right: void 0, top: void 0, bottom: void 0, diagonal: void 0 }];
  registeredCellStyleXfs = [{ borderId: 0, fillId: 0, fontId: 0, numFmtId: 0 }];
  registeredCellXfs = [{ borderId: 0, fillId: 0, fontId: 0, numFmtId: 0, xfId: 0 }];
  registeredCellStyles = [{ builtinId: 0, name: "Normal", xfId: 0 }];
};
var registerFill = (fill) => {
  const convertedPattern = convertLegacyPattern(fill.pattern);
  const convertedFillColor = convertLegacyColor(fill.color);
  const convertedPatternColor = convertLegacyColor(fill.patternColor);
  let pos = registeredFills.findIndex((currentFill) => {
    const { patternType, fgRgb, bgRgb } = currentFill;
    if (patternType != convertedPattern || fgRgb != convertedFillColor || bgRgb != convertedPatternColor) {
      return false;
    }
    return true;
  });
  if (pos === -1) {
    pos = registeredFills.length;
    registeredFills.push({
      patternType: convertedPattern,
      fgRgb: convertedFillColor,
      bgRgb: convertedPatternColor
    });
  }
  return pos;
};
var registerNumberFmt = (format) => {
  if (numberFormatMap[format]) {
    return numberFormatMap[format];
  }
  let pos = registeredNumberFmts.findIndex((currentFormat) => currentFormat.formatCode === format);
  if (pos === -1) {
    pos = registeredNumberFmts.length + 164;
    registeredNumberFmts.push({ formatCode: format, numFmtId: pos });
  } else {
    pos = registeredNumberFmts[pos].numFmtId;
  }
  return pos;
};
var registerBorders = (borders) => {
  const { borderBottom, borderTop, borderLeft, borderRight } = borders;
  let bottomStyle;
  let topStyle;
  let leftStyle;
  let rightStyle;
  let bottomColor;
  let topColor;
  let leftColor;
  let rightColor;
  if (borderLeft) {
    leftStyle = convertLegacyBorder(borderLeft.lineStyle, borderLeft.weight);
    leftColor = convertLegacyColor(borderLeft.color);
  }
  if (borderRight) {
    rightStyle = convertLegacyBorder(borderRight.lineStyle, borderRight.weight);
    rightColor = convertLegacyColor(borderRight.color);
  }
  if (borderBottom) {
    bottomStyle = convertLegacyBorder(borderBottom.lineStyle, borderBottom.weight);
    bottomColor = convertLegacyColor(borderBottom.color);
  }
  if (borderTop) {
    topStyle = convertLegacyBorder(borderTop.lineStyle, borderTop.weight);
    topColor = convertLegacyColor(borderTop.color);
  }
  let pos = registeredBorders.findIndex((currentBorder) => {
    const { left, right, top, bottom } = currentBorder;
    if (!left && (leftStyle || leftColor)) {
      return false;
    }
    if (!right && (rightStyle || rightColor)) {
      return false;
    }
    if (!top && (topStyle || topColor)) {
      return false;
    }
    if (!bottom && (bottomStyle || bottomColor)) {
      return false;
    }
    const { style: clS, color: clC } = left || {};
    const { style: crS, color: crC } = right || {};
    const { style: ctS, color: ctC } = top || {};
    const { style: cbS, color: cbC } = bottom || {};
    if (clS != leftStyle || clC != leftColor) {
      return false;
    }
    if (crS != rightStyle || crC != rightColor) {
      return false;
    }
    if (ctS != topStyle || ctC != topColor) {
      return false;
    }
    if (cbS != bottomStyle || cbC != bottomColor) {
      return false;
    }
    return true;
  });
  if (pos === -1) {
    pos = registeredBorders.length;
    registeredBorders.push({
      left: {
        style: leftStyle,
        color: leftColor
      },
      right: {
        style: rightStyle,
        color: rightColor
      },
      top: {
        style: topStyle,
        color: topColor
      },
      bottom: {
        style: bottomStyle,
        color: bottomColor
      },
      diagonal: {
        style: void 0,
        color: void 0
      }
    });
  }
  return pos;
};
var registerFont = (font) => {
  const {
    fontName: name = "Calibri",
    color,
    size,
    bold,
    italic,
    outline,
    shadow: shadow2,
    strikeThrough,
    underline,
    family,
    verticalAlign
  } = font;
  const convertedColor = convertLegacyColor(color);
  const familyId = getFontFamilyId(family);
  const convertedUnderline = underline ? underline.toLocaleLowerCase() : void 0;
  const convertedVerticalAlign = verticalAlign ? verticalAlign.toLocaleLowerCase() : void 0;
  let pos = registeredFonts.findIndex((currentFont) => {
    if (currentFont.fontName != name || currentFont.color != convertedColor || currentFont.size != size || currentFont.bold != bold || currentFont.italic != italic || currentFont.outline != outline || currentFont.shadow != shadow2 || currentFont.strikeThrough != strikeThrough || currentFont.underline != convertedUnderline || currentFont.verticalAlign != convertedVerticalAlign || currentFont.family != familyId) {
      return false;
    }
    return true;
  });
  if (pos === -1) {
    pos = registeredFonts.length;
    registeredFonts.push({
      fontName: name,
      color: convertedColor,
      size,
      bold,
      italic,
      outline,
      shadow: shadow2,
      strikeThrough,
      underline: convertedUnderline,
      verticalAlign: convertedVerticalAlign,
      family: familyId != null ? familyId.toString() : void 0
    });
  }
  return pos;
};
var registerStyle = (config) => {
  const { alignment, borders, font, interior, numberFormat, protection, quotePrefix } = config;
  let { id } = config;
  let currentFill = 0;
  let currentBorder = 0;
  let currentFont = 0;
  let currentNumberFmt = 0;
  if (!id) {
    return;
  }
  id = getStyleName(id, currentSheet);
  if (stylesMap[id] != void 0) {
    return;
  }
  if (interior) {
    currentFill = registerFill(interior);
  }
  if (borders) {
    currentBorder = registerBorders(borders);
  }
  if (font) {
    currentFont = registerFont(font);
  }
  if (numberFormat) {
    currentNumberFmt = registerNumberFmt(numberFormat.format);
  }
  stylesMap[id] = registeredCellXfs.length;
  registeredCellXfs.push({
    alignment,
    borderId: currentBorder || 0,
    fillId: currentFill || 0,
    fontId: currentFont || 0,
    numFmtId: currentNumberFmt || 0,
    protection,
    quotePrefix,
    xfId: 0
  });
};
var stylesheetFactory = {
  getTemplate(defaultFontSize) {
    const numberFormats = numberFormats_default.getTemplate(registeredNumberFmts);
    const fonts = fonts_default.getTemplate(
      registeredFonts.map((font) => ({ ...font, size: font.size != null ? font.size : defaultFontSize }))
    );
    const fills = fills_default.getTemplate(registeredFills);
    const borders = borders_default.getTemplate(registeredBorders);
    const cellStylesXfs = cellStyleXfs_default.getTemplate(registeredCellStyleXfs);
    const cellXfs = cellXfs_default.getTemplate(registeredCellXfs);
    const cellStyles = cellStyles_default.getTemplate(registeredCellStyles);
    resetStylesheetValues();
    return {
      name: "styleSheet",
      properties: {
        rawMap: {
          "mc:Ignorable": "x14ac x16r2 xr",
          xmlns: "http://schemas.openxmlformats.org/spreadsheetml/2006/main",
          "xmlns:mc": "http://schemas.openxmlformats.org/markup-compatibility/2006",
          "xmlns:x14ac": "http://schemas.microsoft.com/office/spreadsheetml/2009/9/ac",
          "xmlns:x16r2": "http://schemas.microsoft.com/office/spreadsheetml/2015/02/main",
          "xmlns:xr": "http://schemas.microsoft.com/office/spreadsheetml/2014/revision"
        }
      },
      children: [
        numberFormats,
        fonts,
        fills,
        borders,
        cellStylesXfs,
        cellXfs,
        cellStyles,
        {
          name: "tableStyles",
          properties: {
            rawMap: {
              count: 0,
              defaultPivotStyle: "PivotStyleLight16",
              defaultTableStyle: "TableStyleMedium2"
            }
          }
        }
      ]
    };
  }
};
var getStyleId = (name, currentSheet2) => {
  return stylesMap[getStyleName(name, currentSheet2)] || 0;
};
var registerStyles = (styles, _currentSheet) => {
  currentSheet = _currentSheet;
  if (currentSheet === 1) {
    resetStylesheetValues();
  }
  styles.forEach(registerStyle);
};
var stylesheet_default = stylesheetFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/table.ts
var tableFactory = {
  getTemplate(dataTable, idx) {
    const {
      name,
      columns,
      rowRange,
      displayName,
      showRowStripes,
      showColumnStripes,
      showFilterButtons,
      highlightFirstColumn,
      highlightLastColumn
    } = dataTable || {};
    const noRows = !rowRange || rowRange[0] - rowRange[1] === 0;
    if (!dataTable || !name || !Array.isArray(columns) || !columns.length || noRows) {
      return { name: "table" };
    }
    const filterColumns = columns.map((col, idx2) => ({
      name: "filterColumn",
      properties: {
        rawMap: {
          colId: idx2.toString(),
          // For filters, this should start with 0
          hiddenButton: showFilterButtons[idx2] ? 0 : 1
        }
      }
    }));
    const firstCell = `A${rowRange[0]}`;
    const lastCell = `${getExcelColumnName(columns.length)}${rowRange[1]}`;
    const ref = `${firstCell}:${lastCell}`;
    const id = `${idx + 1}`;
    const displayNameToUse = idx ? `${displayName}_${id}` : displayName;
    return {
      name: "table",
      properties: {
        rawMap: {
          xmlns: "http://schemas.openxmlformats.org/spreadsheetml/2006/main",
          "xmlns:mc": "http://schemas.openxmlformats.org/markup-compatibility/2006",
          "mc:Ignorable": "xr xr3",
          "xmlns:xr": "http://schemas.microsoft.com/office/spreadsheetml/2014/revision",
          "xmlns:xr3": "http://schemas.microsoft.com/office/spreadsheetml/2016/revision3",
          name,
          displayName: displayNameToUse,
          ref,
          totalsRowShown: 0,
          id
        }
      },
      children: [
        {
          name: "autoFilter",
          properties: {
            rawMap: {
              ref
            }
          },
          children: filterColumns
        },
        {
          name: "tableColumns",
          properties: {
            rawMap: {
              count: columns.length
            }
          },
          children: columns.map((col, idx2) => ({
            name: "tableColumn",
            properties: {
              rawMap: {
                id: (idx2 + 1).toString(),
                name: col,
                dataCellStyle: "Normal"
              }
            }
          }))
        },
        {
          name: "tableStyleInfo",
          properties: {
            rawMap: {
              name: "TableStyleLight1",
              showFirstColumn: highlightFirstColumn ? 1 : 0,
              showLastColumn: highlightLastColumn ? 1 : 0,
              showRowStripes: showRowStripes ? 1 : 0,
              showColumnStripes: showColumnStripes ? 1 : 0
            }
          }
        }
      ]
    };
  }
};
var table_default = tableFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/themes/office/colorScheme.ts
var getColorChildren = (props) => {
  const [type, innerType, val, lastClr] = props;
  return {
    name: `a:${type}`,
    children: [
      {
        name: `a:${innerType}`,
        properties: {
          rawMap: {
            val,
            lastClr
          }
        }
      }
    ]
  };
};
var colorScheme = {
  getTemplate() {
    return {
      name: "a:clrScheme",
      properties: {
        rawMap: {
          name: "Office"
        }
      },
      children: [
        getColorChildren(["dk1", "sysClr", "windowText", "000000"]),
        getColorChildren(["lt1", "sysClr", "window", "FFFFFF"]),
        getColorChildren(["dk2", "srgbClr", "44546A"]),
        getColorChildren(["lt2", "srgbClr", "E7E6E6"]),
        getColorChildren(["accent1", "srgbClr", "4472C4"]),
        getColorChildren(["accent2", "srgbClr", "ED7D31"]),
        getColorChildren(["accent3", "srgbClr", "A5A5A5"]),
        getColorChildren(["accent4", "srgbClr", "FFC000"]),
        getColorChildren(["accent5", "srgbClr", "5B9BD5"]),
        getColorChildren(["accent6", "srgbClr", "70AD47"]),
        getColorChildren(["hlink", "srgbClr", "0563C1"]),
        getColorChildren(["folHlink", "srgbClr", "954F72"])
      ]
    };
  }
};
var colorScheme_default = colorScheme;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/themes/office/fontScheme.ts
var getFont = (props) => {
  const [type, typeface, script, panose] = props;
  return {
    name: `a:${type}`,
    properties: {
      rawMap: {
        script,
        typeface,
        panose
      }
    }
  };
};
var fontScheme = {
  getTemplate() {
    return {
      name: "a:fontScheme",
      properties: {
        rawMap: {
          name: "Office"
        }
      },
      children: [
        {
          name: "a:majorFont",
          children: [
            getFont(["latin", "Calibri Light", void 0, "020F0302020204030204"]),
            getFont(["ea", ""]),
            getFont(["cs", ""]),
            getFont(["font", "\u6E38\u30B4\u30B7\u30C3\u30AF Light", "Jpan"]),
            getFont(["font", "\uB9D1\uC740 \uACE0\uB515", "Hang"]),
            getFont(["font", "\u7B49\u7EBF Light", "Hans"]),
            getFont(["font", "\u65B0\u7D30\u660E\u9AD4", "Hant"]),
            getFont(["font", "Times New Roman", "Arab"]),
            getFont(["font", "Times New Roman", "Hebr"]),
            getFont(["font", "Tahoma", "Thai"]),
            getFont(["font", "Nyala", "Ethi"]),
            getFont(["font", "Vrinda", "Beng"]),
            getFont(["font", "Shruti", "Gujr"]),
            getFont(["font", "MoolBoran", "Khmr"]),
            getFont(["font", "Tunga", "Knda"]),
            getFont(["font", "Raavi", "Guru"]),
            getFont(["font", "Euphemia", "Cans"]),
            getFont(["font", "Plantagenet Cherokee", "Cher"]),
            getFont(["font", "Microsoft Yi Baiti", "Yiii"]),
            getFont(["font", "Microsoft Himalaya", "Tibt"]),
            getFont(["font", "MV Boli", "Thaa"]),
            getFont(["font", "Mangal", "Deva"]),
            getFont(["font", "Gautami", "Telu"]),
            getFont(["font", "Latha", "Taml"]),
            getFont(["font", "Estrangelo Edessa", "Syrc"]),
            getFont(["font", "Kalinga", "Orya"]),
            getFont(["font", "Kartika", "Mlym"]),
            getFont(["font", "DokChampa", "Laoo"]),
            getFont(["font", "Iskoola Pota", "Sinh"]),
            getFont(["font", "Mongolian Baiti", "Mong"]),
            getFont(["font", "Times New Roman", "Viet"]),
            getFont(["font", "Microsoft Uighur", "Uigh"]),
            getFont(["font", "Sylfaen", "Geor"]),
            getFont(["font", "Arial", "Armn"]),
            getFont(["font", "Leelawadee UI", "Bugi"]),
            getFont(["font", "Microsoft JhengHei", "Bopo"]),
            getFont(["font", "Javanese Text", "Java"]),
            getFont(["font", "Segoe UI", "Lisu"]),
            getFont(["font", "Myanmar Text", "Mymr"]),
            getFont(["font", "Ebrima", "Nkoo"]),
            getFont(["font", "Nirmala UI", "Olck"]),
            getFont(["font", "Ebrima", "Osma"]),
            getFont(["font", "Phagspa", "Phag"]),
            getFont(["font", "Estrangelo Edessa", "Syrn"]),
            getFont(["font", "Estrangelo Edessa", "Syrj"]),
            getFont(["font", "Estrangelo Edessa", "Syre"]),
            getFont(["font", "Nirmala UI", "Sora"]),
            getFont(["font", "Microsoft Tai Le", "Tale"]),
            getFont(["font", "Microsoft New Tai Lue", "Talu"]),
            getFont(["font", "Ebrima", "Tfng"])
          ]
        },
        {
          name: "a:minorFont",
          children: [
            getFont(["latin", "Calibri", void 0, "020F0502020204030204"]),
            getFont(["ea", ""]),
            getFont(["cs", ""]),
            getFont(["font", "\u6E38\u30B4\u30B7\u30C3\u30AF", "Jpan"]),
            getFont(["font", "\uB9D1\uC740 \uACE0\uB515", "Hang"]),
            getFont(["font", "\u7B49\u7EBF", "Hans"]),
            getFont(["font", "\u65B0\u7D30\u660E\u9AD4", "Hant"]),
            getFont(["font", "Arial", "Arab"]),
            getFont(["font", "Arial", "Hebr"]),
            getFont(["font", "Tahoma", "Thai"]),
            getFont(["font", "Nyala", "Ethi"]),
            getFont(["font", "Vrinda", "Beng"]),
            getFont(["font", "Shruti", "Gujr"]),
            getFont(["font", "DaunPenh", "Khmr"]),
            getFont(["font", "Tunga", "Knda"]),
            getFont(["font", "Raavi", "Guru"]),
            getFont(["font", "Euphemia", "Cans"]),
            getFont(["font", "Plantagenet Cherokee", "Cher"]),
            getFont(["font", "Microsoft Yi Baiti", "Yiii"]),
            getFont(["font", "Microsoft Himalaya", "Tibt"]),
            getFont(["font", "MV Boli", "Thaa"]),
            getFont(["font", "Mangal", "Deva"]),
            getFont(["font", "Gautami", "Telu"]),
            getFont(["font", "Latha", "Taml"]),
            getFont(["font", "Estrangelo Edessa", "Syrc"]),
            getFont(["font", "Kalinga", "Orya"]),
            getFont(["font", "Kartika", "Mlym"]),
            getFont(["font", "DokChampa", "Laoo"]),
            getFont(["font", "Iskoola Pota", "Sinh"]),
            getFont(["font", "Mongolian Baiti", "Mong"]),
            getFont(["font", "Arial", "Viet"]),
            getFont(["font", "Microsoft Uighur", "Uigh"]),
            getFont(["font", "Sylfaen", "Geor"]),
            getFont(["font", "Arial", "Armn"]),
            getFont(["font", "Leelawadee UI", "Bugi"]),
            getFont(["font", "Microsoft JhengHei", "Bopo"]),
            getFont(["font", "Javanese Text", "Java"]),
            getFont(["font", "Segoe UI", "Lisu"]),
            getFont(["font", "Myanmar Text", "Mymr"]),
            getFont(["font", "Ebrima", "Nkoo"]),
            getFont(["font", "Nirmala UI", "Olck"]),
            getFont(["font", "Ebrima", "Osma"]),
            getFont(["font", "Phagspa", "Phag"]),
            getFont(["font", "Estrangelo Edessa", "Syrn"]),
            getFont(["font", "Estrangelo Edessa", "Syrj"]),
            getFont(["font", "Estrangelo Edessa", "Syre"]),
            getFont(["font", "Nirmala UI", "Sora"]),
            getFont(["font", "Microsoft Tai Le", "Tale"]),
            getFont(["font", "Microsoft New Tai Lue", "Talu"]),
            getFont(["font", "Ebrima", "Tfng"])
          ]
        }
      ]
    };
  }
};
var fontScheme_default = fontScheme;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/themes/office/formatScheme.ts
var getPropertyVal = (name, val, children) => ({
  name: `a:${name}`,
  properties: {
    rawMap: {
      val
    }
  },
  children
});
var getGs = (props) => {
  const [pos, schemeColor, satMod, lumMod, tint, shade] = props;
  const children = [];
  children.push(getPropertyVal("satMod", satMod));
  if (lumMod) {
    children.push(getPropertyVal("lumMod", lumMod));
  }
  if (tint) {
    children.push(getPropertyVal("tint", tint));
  }
  if (shade) {
    children.push(getPropertyVal("shade", shade));
  }
  return {
    name: "a:gs",
    properties: {
      rawMap: {
        pos
      }
    },
    children: [
      {
        name: "a:schemeClr",
        properties: {
          rawMap: {
            val: schemeColor
          }
        },
        children
      }
    ]
  };
};
var getSolidFill = (val, children) => ({
  name: "a:solidFill",
  children: [getPropertyVal("schemeClr", val, children)]
});
var getGradFill = (props) => {
  const [rotWithShape, gs1, gs2, gs3, lin] = props;
  const [ang, scaled] = lin;
  return {
    name: "a:gradFill",
    properties: {
      rawMap: {
        rotWithShape
      }
    },
    children: [
      {
        name: "a:gsLst",
        children: [getGs(gs1), getGs(gs2), getGs(gs3)]
      },
      {
        name: "a:lin",
        properties: {
          rawMap: {
            ang,
            scaled
          }
        }
      }
    ]
  };
};
var getLine = (props) => {
  const [w, cap, cmpd, algn] = props;
  return {
    name: "a:ln",
    properties: {
      rawMap: { w, cap, cmpd, algn }
    },
    children: [
      getSolidFill("phClr"),
      getPropertyVal("prstDash", "solid"),
      {
        name: "a:miter",
        properties: {
          rawMap: {
            lim: "800000"
          }
        }
      }
    ]
  };
};
var getEffectStyle = (shadow2) => {
  const children = [];
  if (shadow2) {
    const [blurRad, dist, dir, algn, rotWithShape] = shadow2;
    children.push({
      name: "a:outerShdw",
      properties: {
        rawMap: { blurRad, dist, dir, algn, rotWithShape }
      },
      children: [getPropertyVal("srgbClr", "000000", [getPropertyVal("alpha", "63000")])]
    });
  }
  return {
    name: "a:effectStyle",
    children: [
      Object.assign(
        {},
        {
          name: "a:effectLst"
        },
        children.length ? { children } : {}
      )
    ]
  };
};
var getFillStyleList = () => ({
  name: "a:fillStyleLst",
  children: [
    getSolidFill("phClr"),
    getGradFill([
      "1",
      ["0", "phClr", "105000", "110000", "67000"],
      ["50000", "phClr", "103000", "105000", "73000"],
      ["100000", "phClr", "109000", "105000", "81000"],
      ["5400000", "0"]
    ]),
    getGradFill([
      "1",
      ["0", "phClr", "103000", "102000", "94000"],
      ["50000", "phClr", "110000", "100000", void 0, "100000"],
      ["100000", "phClr", "120000", "99000", void 0, "78000"],
      ["5400000", "0"]
    ])
  ]
});
var getLineStyleList = () => ({
  name: "a:lnStyleLst",
  children: [
    getLine(["6350", "flat", "sng", "ctr"]),
    getLine(["12700", "flat", "sng", "ctr"]),
    getLine(["19050", "flat", "sng", "ctr"])
  ]
});
var getEffectStyleList = () => ({
  name: "a:effectStyleLst",
  children: [getEffectStyle(), getEffectStyle(), getEffectStyle(["57150", "19050", "5400000", "ctr", "0"])]
});
var getBgFillStyleList = () => ({
  name: "a:bgFillStyleLst",
  children: [
    getSolidFill("phClr"),
    getSolidFill("phClr", [getPropertyVal("tint", "95000"), getPropertyVal("satMod", "170000")]),
    getGradFill([
      "1",
      ["0", "phClr", "150000", "102000", "93000", "98000"],
      ["50000", "phClr", "130000", "103000", "98000", "90000"],
      ["100000", "phClr", "120000", void 0, void 0, "63000"],
      ["5400000", "0"]
    ])
  ]
});
var formatScheme = {
  getTemplate() {
    return {
      name: "a:fmtScheme",
      properties: {
        rawMap: {
          name: "Office"
        }
      },
      children: [getFillStyleList(), getLineStyleList(), getEffectStyleList(), getBgFillStyleList()]
    };
  }
};
var formatScheme_default = formatScheme;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/themes/office/themeElements.ts
var themeElements = {
  getTemplate() {
    return {
      name: "a:themeElements",
      children: [colorScheme_default.getTemplate(), fontScheme_default.getTemplate(), formatScheme_default.getTemplate()]
    };
  }
};
var themeElements_default = themeElements;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/themes/office.ts
var officeTheme = {
  getTemplate() {
    return {
      name: "a:theme",
      properties: {
        prefixedAttributes: [
          {
            prefix: "xmlns:",
            map: {
              a: "http://schemas.openxmlformats.org/drawingml/2006/main"
            }
          }
        ],
        rawMap: {
          name: "Office Theme"
        }
      },
      children: [
        themeElements_default.getTemplate(),
        {
          name: "a:objectDefaults"
        },
        {
          name: "a:extraClrSchemeLst"
        }
      ]
    };
  }
};
var office_default = officeTheme;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/vmlDrawing.ts
var getShapeLayout = () => ({
  name: "o:shapelayout",
  properties: {
    prefixedAttributes: [
      {
        prefix: "v:",
        map: {
          ext: "edit"
        }
      }
    ]
  },
  children: [
    {
      name: "o:idmap",
      properties: {
        prefixedAttributes: [
          {
            prefix: "v:",
            map: {
              ext: "edit"
            }
          }
        ],
        rawMap: {
          data: "1"
        }
      }
    }
  ]
});
var getStroke = () => ({
  name: "v:stroke",
  properties: {
    rawMap: {
      joinstyle: "miter"
    }
  }
});
var getFormulas = (formulas) => ({
  name: "v:formulas",
  children: formulas.map((formula) => ({
    name: "v:f",
    properties: {
      rawMap: {
        eqn: formula
      }
    }
  }))
});
var getPath = () => ({
  name: "v:path",
  properties: {
    prefixedAttributes: [
      {
        prefix: "o:",
        map: {
          connecttype: "rect",
          extrusionok: "f"
        }
      }
    ],
    rawMap: {
      gradientshapeok: "t"
    }
  }
});
var getLock = (params) => {
  const { aspectratio, rotation } = params || {};
  const rawMap = {};
  if (aspectratio) {
    rawMap.aspectratio = "t";
  }
  if (rotation) {
    rawMap.rotation = "t";
  }
  return {
    name: "o:lock",
    properties: {
      prefixedAttributes: [
        {
          prefix: "v:",
          map: {
            ext: "edit"
          }
        }
      ],
      rawMap
    }
  };
};
function mapNumber(value, startSource, endSource, startTarget, endTarget) {
  return (value - startSource) / (endSource - startSource) * (endTarget - startTarget) + startTarget;
}
var getImageData = (image, idx) => {
  let rawMap;
  const { recolor, brightness, contrast, id } = image;
  if (recolor) {
    rawMap = {};
    if (recolor === "Washout" || recolor === "Grayscale") {
      rawMap.gain = "19661f";
      rawMap.blacklevel = "22938f";
    }
    if (recolor === "Black & White" || recolor === "Grayscale") {
      rawMap.grayscale = "t";
      if (recolor === "Black & White") {
        rawMap.bilevel = "t";
      }
    }
  }
  if (!recolor || recolor === "Grayscale") {
    if (!rawMap) {
      rawMap = {};
    }
    if (contrast != null && contrast !== 50) {
      let gain = "1";
      if (contrast >= 0) {
        if (contrast < 50) {
          gain = String(contrast / 50);
        } else if (contrast < 100) {
          gain = String(50 / (100 - contrast));
        } else if (contrast === 100) {
          gain = "2147483647f";
        }
      }
      rawMap.gain = gain;
    }
    if (brightness != null && brightness !== 50) {
      rawMap.blacklevel = mapNumber(brightness, 0, 100, -0.5, 0.5).toString();
    }
  }
  return {
    name: "v:imagedata",
    properties: {
      prefixedAttributes: [
        {
          prefix: "o:",
          map: {
            relid: `rId${idx}`,
            title: id
          }
        }
      ],
      rawMap
    }
  };
};
var getShapeType = () => {
  const formulas = [
    "if lineDrawn pixelLineWidth 0",
    "sum @0 1 0",
    "sum 0 0 @1",
    "prod @2 1 2",
    "prod @3 21600 pixelWidth",
    "prod @3 21600 pixelHeight",
    "sum @0 0 1",
    "prod @6 1 2",
    "prod @7 21600 pixelWidth",
    "sum @8 21600 0",
    "prod @7 21600 pixelHeight",
    "sum @10 21600 0"
  ];
  return {
    name: "v:shapetype",
    properties: {
      prefixedAttributes: [
        {
          prefix: "o:",
          map: {
            spt: "75",
            preferrelative: "t"
          }
        }
      ],
      rawMap: {
        coordsize: "21600,21600",
        filled: "f",
        id: "_x0000_t75",
        path: "m@4@5l@4@11@9@11@9@5xe",
        stroked: "f"
      }
    },
    children: [getStroke(), getFormulas(formulas), getPath(), getLock({ aspectratio: true })]
  };
};
var pixelToPoint = (value) => Math.floor((value ?? 0) * 0.74999943307122);
var getShape = (image, idx) => {
  const { width = 0, height = 0, altText } = image;
  const imageWidth = pixelToPoint(width);
  const imageHeight = pixelToPoint(height);
  return {
    name: "v:shape",
    properties: {
      rawMap: {
        id: image.headerFooterPosition,
        "o:spid": "_x0000_s1025",
        style: `position: absolute; margin-left: 0; margin-top: 10in; margin-bottom: 0; margin-right: 0; width: ${imageWidth}pt; height: ${imageHeight}pt; z-index: ${idx + 1}`,
        type: "#_x0000_t75",
        alt: altText
      }
    },
    children: [getImageData(image, idx + 1), getLock({ rotation: true })]
  };
};
var vmlDrawingFactory = {
  getTemplate(params) {
    const headerFooterImages = XLSX_WORKSHEET_HEADER_FOOTER_IMAGES.get(params.sheetIndex) || [];
    const children = [
      getShapeLayout(),
      getShapeType(),
      ...headerFooterImages.map((img, idx) => getShape(img, idx))
    ];
    return {
      name: "xml",
      properties: {
        prefixedAttributes: [
          {
            prefix: "xmlns:",
            map: {
              v: "urn:schemas-microsoft-com:vml",
              o: "urn:schemas-microsoft-com:office:office",
              x: "urn:schemas-microsoft-com:office:excel"
            }
          }
        ]
      },
      children
    };
  }
};
var vmlDrawing_default = vmlDrawingFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/sheet.ts
var sheetFactory = {
  getTemplate(name, idx) {
    const sheetId = (idx + 1).toString();
    return {
      name: "sheet",
      properties: {
        rawMap: {
          name,
          sheetId,
          "r:id": `rId${sheetId}`
        }
      }
    };
  }
};
var sheet_default = sheetFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/sheets.ts
var sheetsFactory = {
  getTemplate(names) {
    return {
      name: "sheets",
      children: names.map((sheet, idx) => sheet_default.getTemplate(sheet, idx))
    };
  }
};
var sheets_default = sheetsFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/workbook.ts
var workbookFactory = {
  getTemplate(names, activeTab) {
    return {
      name: "workbook",
      properties: {
        prefixedAttributes: [
          {
            prefix: "xmlns:",
            map: {
              r: "http://schemas.openxmlformats.org/officeDocument/2006/relationships"
            }
          }
        ],
        rawMap: {
          xmlns: "http://schemas.openxmlformats.org/spreadsheetml/2006/main"
        }
      },
      children: [
        {
          name: "bookViews",
          children: [
            {
              name: "workbookView",
              properties: {
                rawMap: {
                  activeTab
                }
              }
            }
          ]
        },
        sheets_default.getTemplate(names)
      ]
    };
  }
};
var workbook_default = workbookFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/worksheet.ts
var import_ag_grid_community6 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/column.ts
var getExcelCellWidth = (width) => Math.ceil((width - 12) / 7 + 1);
var colFactory = {
  getTemplate(config) {
    const { min, max, outlineLevel, s, width, hidden, bestFit } = config;
    let excelWidth = 1;
    let customWidth = "0";
    if (width > 1) {
      excelWidth = getExcelCellWidth(width);
      customWidth = "1";
    }
    return {
      name: "col",
      properties: {
        rawMap: {
          min,
          max,
          outlineLevel: outlineLevel != null ? outlineLevel : void 0,
          width: excelWidth,
          style: s,
          hidden: hidden ? "1" : "0",
          bestFit: bestFit ? "1" : "0",
          customWidth
        }
      }
    };
  }
};
var column_default = colFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/mergeCell.ts
var mergeCellFactory = {
  getTemplate(ref) {
    return {
      name: "mergeCell",
      properties: {
        rawMap: {
          ref
        }
      }
    };
  }
};
var mergeCell_default = mergeCellFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/cell.ts
var import_ag_grid_community5 = require("ag-grid-community");
var convertLegacyType = (type) => {
  const t = type.charAt(0).toLowerCase();
  return t === "s" ? "inlineStr" : t;
};
var cellFactory = {
  getTemplate(config, idx, currentSheet2) {
    const { ref, data, styleId } = config;
    const { type, value } = data || { type: "empty", value: null };
    let convertedType = type;
    if (type === "f") {
      convertedType = "str";
    } else if (type.charAt(0) === type.charAt(0).toUpperCase()) {
      convertedType = convertLegacyType(type);
    }
    const obj = {
      name: "c",
      properties: {
        rawMap: {
          r: ref,
          t: convertedType === "empty" ? void 0 : convertedType,
          s: styleId ? getStyleId(styleId, currentSheet2) : void 0
        }
      }
    };
    if (convertedType === "empty") {
      return obj;
    }
    let children;
    if (convertedType === "str" && type === "f") {
      children = [
        {
          name: "f",
          textNode: (0, import_ag_grid_community5._escapeString)(replaceInvisibleCharacters(value), false)
        }
      ];
    } else if (convertedType === "inlineStr") {
      children = [
        {
          name: "is",
          children: [
            {
              name: "t",
              textNode: (0, import_ag_grid_community5._escapeString)(replaceInvisibleCharacters(value), false)
            }
          ]
        }
      ];
    } else {
      children = [
        {
          name: "v",
          textNode: value
        }
      ];
    }
    return Object.assign({}, obj, { children });
  }
};
var cell_default = cellFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/row.ts
var addEmptyCells = (cells, rowIdx) => {
  const mergeMap = [];
  let posCounter = 0;
  for (let i = 0; i < cells.length; i++) {
    const cell = cells[i];
    if (cell.mergeAcross) {
      mergeMap.push({
        pos: i,
        excelPos: posCounter
      });
      posCounter += cell.mergeAcross;
    }
    posCounter++;
  }
  if (mergeMap.length) {
    for (let i = mergeMap.length - 1; i >= 0; i--) {
      const mergedCells = [];
      const cell = cells[mergeMap[i].pos];
      for (let j = 1; j <= cell.mergeAcross; j++) {
        mergedCells.push({
          ref: `${getExcelColumnName(mergeMap[i].excelPos + 1 + j)}${rowIdx + 1}`,
          styleId: cell.styleId,
          data: { type: "empty", value: null }
        });
      }
      if (mergedCells.length) {
        cells.splice(mergeMap[i].pos + 1, 0, ...mergedCells);
      }
    }
  }
};
var shouldDisplayCell = (cell) => cell.data?.value !== "" || cell.styleId !== void 0;
var rowFactory = {
  getTemplate(config, idx, currentSheet2) {
    const { collapsed, hidden, height, outlineLevel, cells = [] } = config;
    addEmptyCells(cells, idx);
    const children = cells.filter(shouldDisplayCell).map((cell, idx2) => cell_default.getTemplate(cell, idx2, currentSheet2));
    return {
      name: "row",
      properties: {
        rawMap: {
          r: idx + 1,
          collapsed: collapsed ? "1" : "0",
          hidden: hidden ? "1" : "0",
          ht: height,
          customHeight: height != null ? "1" : "0",
          spans: "1:1",
          outlineLevel: outlineLevel || void 0
        }
      },
      children
    };
  }
};
var row_default = rowFactory;

// packages/ag-grid-enterprise/src/excelExport/files/ooxml/worksheet.ts
var getMergedCellsAndAddColumnGroups = (rows, cols, suppressColumnOutline) => {
  const mergedCells = [];
  const cellsWithCollapsibleGroups = [];
  rows.forEach((currentRow, rowIdx) => {
    const cells = currentRow.cells;
    let merges = 0;
    let lastCol;
    cells.forEach((currentCell, cellIdx) => {
      const min = cellIdx + merges + 1;
      const start = getExcelColumnName(min);
      const outputRow = rowIdx + 1;
      if (currentCell.mergeAcross) {
        merges += currentCell.mergeAcross;
        const end = getExcelColumnName(cellIdx + merges + 1);
        mergedCells.push(`${start}${outputRow}:${end}${outputRow}`);
      }
      if (!cols[min - 1]) {
        cols[min - 1] = {};
      }
      const { collapsibleRanges } = currentCell;
      if (collapsibleRanges) {
        collapsibleRanges.forEach((range) => {
          cellsWithCollapsibleGroups.push([min + range[0], min + range[1]]);
        });
      }
      lastCol = cols[min - 1];
      lastCol.min = min;
      lastCol.max = min;
      currentCell.ref = `${start}${outputRow}`;
    });
  });
  cellsWithCollapsibleGroups.sort((a, b) => {
    if (a[0] !== b[0]) {
      return a[0] - b[0];
    }
    return b[1] - a[1];
  });
  const rangeMap = /* @__PURE__ */ new Map();
  const outlineLevel = /* @__PURE__ */ new Map();
  cellsWithCollapsibleGroups.filter((currentRange) => {
    const rangeString = currentRange.toString();
    const inMap = rangeMap.get(rangeString);
    if (inMap) {
      return false;
    }
    rangeMap.set(rangeString, true);
    return true;
  }).forEach((range) => {
    const refCol = cols.find((col) => col.min == range[0] && col.max == range[1]);
    const currentOutlineLevel = outlineLevel.get(range[0]);
    cols.push({
      min: range[0],
      max: range[1],
      outlineLevel: suppressColumnOutline ? void 0 : currentOutlineLevel || 1,
      width: (refCol || { width: 100 }).width
    });
    outlineLevel.set(range[0], (currentOutlineLevel || 0) + 1);
  });
  return mergedCells;
};
var getPageOrientation = (orientation) => {
  if (!orientation || orientation !== "Portrait" && orientation !== "Landscape") {
    return "portrait";
  }
  return orientation.toLocaleLowerCase();
};
var getPageSize = (pageSize) => {
  if (pageSize == null) {
    return 1;
  }
  const positions = [
    "Letter",
    "Letter Small",
    "Tabloid",
    "Ledger",
    "Legal",
    "Statement",
    "Executive",
    "A3",
    "A4",
    "A4 Small",
    "A5",
    "A6",
    "B4",
    "B5",
    "Folio",
    "Envelope",
    "Envelope DL",
    "Envelope C5",
    "Envelope B5",
    "Envelope C3",
    "Envelope C4",
    "Envelope C6",
    "Envelope Monarch",
    "Japanese Postcard",
    "Japanese Double Postcard"
  ];
  const pos = positions.indexOf(pageSize);
  return pos === -1 ? 1 : pos + 1;
};
var replaceHeaderFooterTokens = (value) => {
  const map = {
    "&[Page]": "&P",
    "&[Pages]": "&N",
    "&[Date]": "&D",
    "&[Time]": "&T",
    "&[Tab]": "&A",
    "&[Path]": "&Z",
    "&[File]": "&F",
    "&[Picture]": "&G"
  };
  for (const key of Object.keys(map)) {
    value = value.replace(key, map[key]);
  }
  return value;
};
var getHeaderPosition = (position) => {
  if (position === "Center") {
    return "C";
  }
  if (position === "Right") {
    return "R";
  }
  return "L";
};
var applyHeaderFontStyle = (headerString, font) => {
  if (!font) {
    return headerString;
  }
  headerString += "&amp;&quot;";
  headerString += font.fontName || "Calibri";
  if (font.bold !== font.italic) {
    headerString += font.bold ? ",Bold" : ",Italic";
  } else if (font.bold) {
    headerString += ",Bold Italic";
  } else {
    headerString += ",Regular";
  }
  headerString += "&quot;";
  if (font.size) {
    headerString += `&amp;${font.size}`;
  }
  if (font.strikeThrough) {
    headerString += "&amp;S";
  }
  if (font.underline) {
    headerString += `&amp;${font.underline === "Double" ? "E" : "U"}`;
  }
  if (font.color) {
    headerString += `&amp;K${font.color.replace("#", "").toUpperCase()}`;
  }
  return headerString;
};
var processHeaderFooterContent = (content, location, rule) => content.reduce((prev, curr, idx) => {
  const pos = getHeaderPosition(curr.position);
  const output = applyHeaderFontStyle(`${prev}&amp;${pos}`, curr.font);
  const PositionMap = ["Left", "Center", "Right"];
  if (!curr.position) {
    curr.position = PositionMap[idx];
  }
  const { image } = curr;
  if (curr.value === "&[Picture]" && image) {
    const imagePosition = `${pos}${location}${rule}`;
    addXlsxHeaderFooterImageToMap(image, imagePosition);
  }
  return `${output}${(0, import_ag_grid_community6._escapeString)(replaceHeaderFooterTokens(curr.value))}`;
}, "");
var buildHeaderFooter = (headerFooterConfig) => {
  const rules = ["all", "first", "even"];
  const headersAndFooters = [];
  rules.forEach((rule) => {
    const headerFooter = headerFooterConfig[rule];
    const namePrefix = rule === "all" ? "odd" : rule;
    if (!headerFooter) {
      return;
    }
    for (const key of Object.keys(headerFooter)) {
      const value = headerFooter[key];
      const nameSuffix = `${key.charAt(0).toUpperCase()}${key.slice(1)}`;
      const location = key[0].toUpperCase();
      if (value) {
        const normalizedRule = rule === "all" ? "" : rule.toUpperCase();
        headersAndFooters.push({
          name: `${namePrefix}${nameSuffix}`,
          properties: {
            rawMap: { "xml:space": "preserve" }
          },
          textNode: processHeaderFooterContent(value, location, normalizedRule)
        });
      }
    }
  });
  return headersAndFooters;
};
var addColumns = (columns) => {
  return (params) => {
    if (columns.length) {
      params.children.push({
        name: "cols",
        children: columns.map((column) => column_default.getTemplate(column))
      });
    }
    return params;
  };
};
var addSheetData = (rows, sheetNumber) => {
  return (params) => {
    if (rows.length) {
      params.children.push({
        name: "sheetData",
        children: rows.map((row, idx) => row_default.getTemplate(row, idx, sheetNumber))
      });
    }
    return params;
  };
};
var addMergeCells = (mergeCells) => {
  return (params) => {
    if (mergeCells.length) {
      params.children.push({
        name: "mergeCells",
        properties: {
          rawMap: {
            count: mergeCells.length
          }
        },
        children: mergeCells.map((mergedCell) => mergeCell_default.getTemplate(mergedCell))
      });
    }
    return params;
  };
};
var addPageMargins = (margins) => {
  return (params) => {
    const { top = 0.75, right = 0.7, bottom = 0.75, left = 0.7, header = 0.3, footer = 0.3 } = margins;
    params.children.push({
      name: "pageMargins",
      properties: {
        rawMap: { bottom, footer, header, left, right, top }
      }
    });
    return params;
  };
};
var addPageSetup = (pageSetup) => {
  return (params) => {
    if (pageSetup) {
      params.children.push({
        name: "pageSetup",
        properties: {
          rawMap: {
            horizontalDpi: 0,
            verticalDpi: 0,
            orientation: getPageOrientation(pageSetup.orientation),
            paperSize: getPageSize(pageSetup.pageSize)
          }
        }
      });
    }
    return params;
  };
};
var addHeaderFooter = (headerFooterConfig) => {
  return (params) => {
    if (!headerFooterConfig) {
      return params;
    }
    const differentFirst = headerFooterConfig.first != null ? 1 : 0;
    const differentOddEven = headerFooterConfig.even != null ? 1 : 0;
    params.children.push({
      name: "headerFooter",
      properties: {
        rawMap: {
          differentFirst,
          differentOddEven
        }
      },
      children: buildHeaderFooter(headerFooterConfig)
    });
    return params;
  };
};
var addExcelTableRel = (excelTable) => {
  return (params) => {
    if (excelTable) {
      params.children.push({
        name: "tableParts",
        properties: {
          rawMap: {
            count: "1"
          }
        },
        children: [
          {
            name: "tablePart",
            properties: {
              rawMap: {
                "r:id": `rId${++params.rIdCounter}`
              }
            }
          }
        ]
      });
    }
    return params;
  };
};
var addDrawingRel = (currentSheet2) => {
  return (params) => {
    const worksheetImages = XLSX_WORKSHEET_IMAGES.get(currentSheet2);
    if (worksheetImages?.length) {
      params.children.push({
        name: "drawing",
        properties: {
          rawMap: {
            "r:id": `rId${++params.rIdCounter}`
          }
        }
      });
    }
    return params;
  };
};
var addVmlDrawingRel = (currentSheet2) => {
  return (params) => {
    if (XLSX_WORKSHEET_HEADER_FOOTER_IMAGES.get(currentSheet2)) {
      params.children.push({
        name: "legacyDrawingHF",
        properties: {
          rawMap: {
            "r:id": `rId${++params.rIdCounter}`
          }
        }
      });
    }
    return params;
  };
};
var getPane = (xSplit = 0, ySplit = 0) => {
  const shouldSplit = xSplit > 0 || ySplit > 0;
  return shouldSplit ? [
    {
      name: "pane",
      properties: {
        rawMap: {
          state: shouldSplit ? "frozen" : void 0,
          topLeftCell: shouldSplit ? `${getExcelColumnName(xSplit + 1)}${ySplit + 1}` : void 0,
          xSplit: xSplit === 0 ? void 0 : xSplit,
          ySplit: ySplit === 0 ? void 0 : ySplit
        }
      }
    }
  ] : void 0;
};
var addSheetViews = (rtl = false, xSplit, ySplit) => {
  return (params) => {
    params.children.push({
      name: "sheetViews",
      children: [
        {
          name: "sheetView",
          properties: {
            rawMap: {
              rightToLeft: rtl === true ? "1" : "0",
              workbookViewId: "0"
            }
          },
          children: getPane(xSplit, ySplit)
        }
      ]
    });
    return params;
  };
};
var addSheetPr = () => {
  return (params) => {
    params.children.push({
      name: "sheetPr",
      children: [
        {
          name: "outlinePr",
          properties: {
            rawMap: {
              summaryBelow: 0
            }
          }
        }
      ]
    });
    return params;
  };
};
var addSheetFormatPr = (rows) => {
  return (params) => {
    const maxOutline = rows.reduce((prev, row) => {
      if (row.outlineLevel && row.outlineLevel > prev) {
        return row.outlineLevel;
      }
      return prev;
    }, 0);
    params.children.push({
      name: "sheetFormatPr",
      properties: {
        rawMap: {
          baseColWidth: 10,
          defaultRowHeight: 16,
          outlineLevelRow: maxOutline ? maxOutline : void 0
        }
      }
    });
    return params;
  };
};
var worksheetFactory = {
  getTemplate(params) {
    const { worksheet, currentSheet: currentSheet2, config } = params;
    const {
      margins = {},
      pageSetup,
      headerFooterConfig,
      suppressColumnOutline,
      rightToLeft,
      frozenRowCount,
      frozenColumnCount
    } = config;
    const { table } = worksheet;
    const { rows, columns } = table;
    const mergedCells = columns && columns.length ? getMergedCellsAndAddColumnGroups(rows, columns, !!suppressColumnOutline) : [];
    const worksheetExcelTables = XLSX_WORKSHEET_DATA_TABLES.get(currentSheet2);
    const { children } = [
      addSheetPr(),
      addSheetViews(rightToLeft, frozenColumnCount, frozenRowCount),
      addSheetFormatPr(rows),
      addColumns(columns),
      addSheetData(rows, currentSheet2 + 1),
      addMergeCells(mergedCells),
      addPageMargins(margins),
      addPageSetup(pageSetup),
      addHeaderFooter(headerFooterConfig),
      addDrawingRel(currentSheet2),
      addVmlDrawingRel(currentSheet2),
      addExcelTableRel(worksheetExcelTables)
    ].reduce((composed, f) => f(composed), { children: [], rIdCounter: 0 });
    return {
      name: "worksheet",
      properties: {
        prefixedAttributes: [
          {
            prefix: "xmlns:",
            map: {
              r: "http://schemas.openxmlformats.org/officeDocument/2006/relationships"
            }
          }
        ],
        rawMap: {
          xmlns: "http://schemas.openxmlformats.org/spreadsheetml/2006/main"
        }
      },
      children
    };
  }
};
var worksheet_default = worksheetFactory;

// packages/ag-grid-enterprise/src/excelExport/excelXlsxFactory.ts
var XLSX_SHARED_STRINGS = /* @__PURE__ */ new Map();
var XLSX_SHEET_NAMES = [];
var XLSX_IMAGES = /* @__PURE__ */ new Map();
var XLSX_WORKSHEET_IMAGES = /* @__PURE__ */ new Map();
var XLSX_WORKSHEET_HEADER_FOOTER_IMAGES = /* @__PURE__ */ new Map();
var XLSX_WORKBOOK_IMAGE_IDS = /* @__PURE__ */ new Map();
var XLSX_WORKSHEET_IMAGE_IDS = /* @__PURE__ */ new Map();
var XLSX_WORKSHEET_DATA_TABLES = /* @__PURE__ */ new Map();
var DEFAULT_TABLE_DISPLAY_NAME = "AG-GRID-TABLE";
var XLSX_FACTORY_MODE = "SINGLE_SHEET";
function getXlsxFactoryMode() {
  return XLSX_FACTORY_MODE;
}
function setXlsxFactoryMode(factoryMode) {
  XLSX_FACTORY_MODE = factoryMode;
}
function createXlsxExcel(styles, worksheet, config) {
  addSheetName(worksheet);
  registerStyles(styles, XLSX_SHEET_NAMES.length);
  const newConfig = Object.assign({}, config);
  if (config.exportAsExcelTable) {
    if (config.colModel.isPivotActive()) {
      showExcelTableNonCompatibleFeaturesWarning("pivot mode");
      newConfig.exportAsExcelTable = false;
    }
    if (config.gos.get("masterDetail")) {
      showExcelTableNonCompatibleFeaturesWarning("master/detail");
      newConfig.exportAsExcelTable = false;
    }
  }
  processTableConfig(worksheet, newConfig);
  return createWorksheet(worksheet, newConfig);
}
function showExcelTableNonCompatibleFeaturesWarning(featureName) {
  (0, import_ag_grid_community7._warn)(163, { featureName });
}
function getXlsxSanitizedTableName(name) {
  return name.replace(/^[^a-zA-Z_]+/, "_").replace(/\s/g, "_").replace(/[^a-zA-Z0-9_]/g, "_");
}
function addXlsxTableToSheet(sheetIndex, table) {
  if (XLSX_WORKSHEET_DATA_TABLES.has(sheetIndex)) {
    (0, import_ag_grid_community7._warn)(164);
    return;
  }
  XLSX_WORKSHEET_DATA_TABLES.set(sheetIndex, table);
}
function processTableConfig(worksheet, config) {
  const { exportAsExcelTable, prependContent, appendContent, colModel } = config;
  if (!exportAsExcelTable) {
    return;
  }
  const tableConfig = typeof exportAsExcelTable === "boolean" ? {} : exportAsExcelTable;
  const {
    name: nameFromConfig,
    showColumnStripes,
    showRowStripes,
    showFilterButton,
    highlightFirstColumn,
    highlightLastColumn
  } = tableConfig;
  const tableName = getXlsxSanitizedTableName(nameFromConfig || DEFAULT_TABLE_DISPLAY_NAME);
  const sheetIndex = XLSX_SHEET_NAMES.length - 1;
  const { table } = worksheet;
  const { rows, columns } = table;
  const headerRowCount = (0, import_ag_grid_community7._getHeaderRowCount)(colModel);
  const skipTopRows = prependContent ? prependContent.length : 0;
  const removeFromBottom = appendContent ? appendContent.length : 0;
  const tableRowCount = rows.length;
  const tableColCount = columns.length;
  const tableColumns = [];
  const showFilterButtons = [];
  for (let i = 0; i < tableColCount; i++) {
    const col = columns[i];
    tableColumns.push(col.displayName || "");
    showFilterButtons.push(
      showFilterButton === "match" || showFilterButton === void 0 ? col.filterAllowed ?? false : showFilterButton
    );
  }
  if (!tableColumns || !tableColumns.length || !tableRowCount || !tableName) {
    (0, import_ag_grid_community7._warn)(165);
    return;
  }
  addXlsxTableToSheet(sheetIndex, {
    name: `table${XLSX_WORKSHEET_DATA_TABLES.size + 1}`,
    displayName: tableName,
    columns: tableColumns,
    showFilterButtons,
    rowRange: [headerRowCount + skipTopRows, headerRowCount + (tableRowCount - headerRowCount) - removeFromBottom],
    showRowStripes: showRowStripes ?? true,
    showColumnStripes: showColumnStripes ?? false,
    highlightFirstColumn: highlightFirstColumn ?? false,
    highlightLastColumn: highlightLastColumn ?? false
  });
}
function addXlsxHeaderFooterImageToMap(image, position) {
  const sheetIndex = XLSX_SHEET_NAMES.length - 1;
  const headerFooterImage = image;
  headerFooterImage.headerFooterPosition = position;
  buildImageMap({ imageToAdd: headerFooterImage, idx: sheetIndex });
  let headerFooterImagesForSheet = XLSX_WORKSHEET_HEADER_FOOTER_IMAGES.get(sheetIndex);
  if (!headerFooterImagesForSheet) {
    headerFooterImagesForSheet = [];
    XLSX_WORKSHEET_HEADER_FOOTER_IMAGES.set(sheetIndex, headerFooterImagesForSheet);
  }
  if (!headerFooterImagesForSheet.find((img) => img.id === image.id)) {
    headerFooterImagesForSheet.push(image);
  }
}
function addXlsxBodyImageToMap(image, rowIndex, col, columnsToExport, rowHeight) {
  const sheetIndex = XLSX_SHEET_NAMES.length;
  const { row, column } = image.position || {};
  const calculatedImage = image;
  if (columnsToExport) {
    if (rowIndex != null && col != null && (!row || !column)) {
      if (!image.position) {
        image.position = {};
      }
      image.position = Object.assign({}, image.position, {
        row: rowIndex,
        column: columnsToExport.indexOf(col) + 1
      });
    }
    setExcelImageTotalWidth(calculatedImage, columnsToExport);
    setExcelImageTotalHeight(calculatedImage, rowHeight);
  }
  buildImageMap({ imageToAdd: calculatedImage, idx: sheetIndex });
  let worksheetImageIdMap = XLSX_WORKSHEET_IMAGE_IDS.get(sheetIndex);
  if (!worksheetImageIdMap) {
    worksheetImageIdMap = /* @__PURE__ */ new Map();
    XLSX_WORKSHEET_IMAGE_IDS.set(sheetIndex, worksheetImageIdMap);
  }
  const sheetImages = XLSX_WORKSHEET_IMAGES.get(sheetIndex);
  if (!sheetImages) {
    XLSX_WORKSHEET_IMAGES.set(sheetIndex, [calculatedImage]);
  } else {
    sheetImages.push(calculatedImage);
  }
  if (!worksheetImageIdMap.get(image.id)) {
    worksheetImageIdMap.set(image.id, { index: worksheetImageIdMap.size, type: image.imageType });
  }
}
function buildImageMap(params) {
  const { imageToAdd, idx } = params;
  const mappedImagesToSheet = XLSX_IMAGES.get(imageToAdd.id);
  if (mappedImagesToSheet) {
    const currentSheetImages = mappedImagesToSheet.find((currentImage) => currentImage.sheetId === idx);
    if (currentSheetImages) {
      currentSheetImages.image.push(imageToAdd);
    } else {
      mappedImagesToSheet.push({
        sheetId: idx,
        image: [imageToAdd]
      });
    }
  } else {
    XLSX_IMAGES.set(imageToAdd.id, [{ sheetId: idx, image: [imageToAdd] }]);
    XLSX_WORKBOOK_IMAGE_IDS.set(imageToAdd.id, {
      type: imageToAdd.imageType,
      index: XLSX_WORKBOOK_IMAGE_IDS.size
    });
  }
}
function addSheetName(worksheet) {
  const name = (0, import_ag_grid_community7._escapeString)(worksheet.name) || "";
  let append = "";
  while (XLSX_SHEET_NAMES.indexOf(`${name}${append}`) !== -1) {
    if (append === "") {
      append = "_1";
    } else {
      const curr = parseInt(append.slice(1), 10);
      append = `_${curr + 1}`;
    }
  }
  worksheet.name = `${name}${append}`;
  XLSX_SHEET_NAMES.push(worksheet.name);
}
function getXlsxStringPosition(str) {
  if (XLSX_SHARED_STRINGS.has(str)) {
    return XLSX_SHARED_STRINGS.get(str);
  }
  XLSX_SHARED_STRINGS.set(str, XLSX_SHARED_STRINGS.size);
  return XLSX_SHARED_STRINGS.size - 1;
}
function resetXlsxFactory() {
  XLSX_SHARED_STRINGS.clear();
  XLSX_IMAGES.clear();
  XLSX_WORKSHEET_IMAGES.clear();
  XLSX_WORKSHEET_HEADER_FOOTER_IMAGES.clear();
  XLSX_WORKBOOK_IMAGE_IDS.clear();
  XLSX_WORKSHEET_IMAGE_IDS.clear();
  XLSX_WORKSHEET_DATA_TABLES.clear();
  XLSX_SHEET_NAMES = [];
  XLSX_FACTORY_MODE = "SINGLE_SHEET";
}
function createXlsxWorkbook(currentSheet2) {
  return createXmlPart(workbook_default.getTemplate(XLSX_SHEET_NAMES, currentSheet2));
}
function createXlsxStylesheet(defaultFontSize) {
  return createXmlPart(stylesheet_default.getTemplate(defaultFontSize));
}
function createXlsxSharedStrings() {
  return createXmlPart(sharedStrings_default.getTemplate(XLSX_SHARED_STRINGS));
}
function createXlsxCore(author) {
  return createXmlPart(core_default.getTemplate(author));
}
function createXlsxContentTypes(sheetLen) {
  return createXmlPart(contentTypes_default.getTemplate(sheetLen));
}
function createXlsxRels() {
  const rs = relationships_default.getTemplate([
    {
      Id: "rId1",
      Type: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument",
      Target: "xl/workbook.xml"
    },
    {
      Id: "rId2",
      Type: "http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties",
      Target: "docProps/core.xml"
    }
  ]);
  return createXmlPart(rs);
}
function createXlsxTheme() {
  return createXmlPart(office_default.getTemplate());
}
function createXlsxTable(dataTable, index) {
  return createXmlPart(table_default.getTemplate(dataTable, index));
}
function createXlsxWorkbookRels(sheetLen) {
  const worksheets = new Array(sheetLen).fill(void 0).map((v, i) => ({
    Id: `rId${i + 1}`,
    Type: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet",
    Target: `worksheets/sheet${i + 1}.xml`
  }));
  const rs = relationships_default.getTemplate([
    ...worksheets,
    {
      Id: `rId${sheetLen + 1}`,
      Type: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme",
      Target: "theme/theme1.xml"
    },
    {
      Id: `rId${sheetLen + 2}`,
      Type: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles",
      Target: "styles.xml"
    },
    {
      Id: `rId${sheetLen + 3}`,
      Type: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings",
      Target: "sharedStrings.xml"
    }
  ]);
  return createXmlPart(rs);
}
function createXlsxDrawing(sheetIndex) {
  return createXmlPart(drawing_default.getTemplate({ sheetIndex }));
}
function createXlsxDrawingRel(sheetIndex) {
  const worksheetImageIds = XLSX_WORKSHEET_IMAGE_IDS.get(sheetIndex) || [];
  const XMLArr = [];
  for (const [key, value] of worksheetImageIds) {
    const { index, type } = value;
    XMLArr.push({
      Id: `rId${index + 1}`,
      Type: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image",
      Target: `../media/image${XLSX_WORKBOOK_IMAGE_IDS.get(key).index + 1}.${_normaliseImageExtension(type)}`
    });
  }
  return createXmlPart(relationships_default.getTemplate(XMLArr));
}
function createXlsxVmlDrawing(sheetIndex) {
  return createXmlPart(vmlDrawing_default.getTemplate({ sheetIndex }), true);
}
function createXlsxVmlDrawingRel(sheetIndex) {
  const worksheetHeaderFooterImages = XLSX_WORKSHEET_HEADER_FOOTER_IMAGES.get(sheetIndex) || [];
  const XMLArr = [];
  for (let i = 0; i < worksheetHeaderFooterImages.length; i++) {
    const headerFooterImage = worksheetHeaderFooterImages[i];
    const workbookImage = XLSX_WORKBOOK_IMAGE_IDS.get(headerFooterImage.id);
    if (!workbookImage) {
      continue;
    }
    const { index, type } = workbookImage;
    XMLArr.push({
      Id: `rId${i + 1}`,
      Type: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image",
      Target: `../media/image${index + 1}.${_normaliseImageExtension(type)}`
    });
  }
  return createXmlPart(relationships_default.getTemplate(XMLArr));
}
function createXlsxRelationships({
  drawingIndex,
  vmlDrawingIndex,
  tableName
} = {}) {
  if (drawingIndex === void 0 && vmlDrawingIndex === void 0 && tableName === void 0) {
    return "";
  }
  const config = [];
  if (drawingIndex != null) {
    config.push({
      Id: `rId${config.length + 1}`,
      Type: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing",
      Target: `../drawings/drawing${drawingIndex + 1}.xml`
    });
  }
  if (vmlDrawingIndex != null) {
    config.push({
      Id: `rId${config.length + 1}`,
      Type: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/vmlDrawing",
      Target: `../drawings/vmlDrawing${vmlDrawingIndex + 1}.vml`
    });
  }
  if (tableName != null) {
    config.push({
      Id: `rId${config.length + 1}`,
      Type: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/table",
      Target: `../tables/${tableName}.xml`
    });
  }
  const rs = relationships_default.getTemplate(config);
  return createXmlPart(rs);
}
function createWorksheet(worksheet, config) {
  return createXmlPart(
    worksheet_default.getTemplate({
      worksheet,
      currentSheet: XLSX_SHEET_NAMES.length - 1,
      config
    })
  );
}

// packages/ag-grid-enterprise/src/excelExport/excelSerializingSession.ts
var ExcelSerializingSession = class extends import_ag_grid_community8.BaseGridSerializingSession {
  constructor(config) {
    super(config);
    this.mixedStyles = {};
    this.mixedStyleCounter = 0;
    this.rows = [];
    this.frozenRowCount = 0;
    this.skipFrozenRows = false;
    this.frozenColumnCount = 0;
    this.skipFrozenColumns = false;
    this.config = Object.assign({}, config);
    this.stylesByIds = {};
    this.config.baseExcelStyles.forEach((style) => {
      this.stylesByIds[style.id] = style;
    });
    this.excelStyles = [...this.config.baseExcelStyles, { id: "_quotePrefix", quotePrefix: 1 }];
  }
  addCustomContent(customContent) {
    customContent.forEach((row) => {
      const rowLen = this.rows.length + 1;
      let outlineLevel;
      if (!this.config.suppressRowOutline && row.outlineLevel != null) {
        outlineLevel = row.outlineLevel;
      }
      const rowObj = {
        height: getHeightFromProperty(rowLen, row.height || this.config.rowHeight),
        cells: (row.cells || []).map((cell, idx) => {
          const image = this.addImage(rowLen, this.columnsToExport[idx], cell.data?.value);
          let excelStyles = null;
          if (cell.styleId) {
            excelStyles = typeof cell.styleId === "string" ? [cell.styleId] : cell.styleId;
          }
          const excelStyleId = this.getStyleId(excelStyles);
          if (image) {
            return this.createCell(
              excelStyleId,
              this.getDataTypeForValue(image.value),
              image.value == null ? "" : image.value
            );
          }
          const value = cell.data?.value ?? "";
          const type = this.getDataTypeForValue(value);
          if (cell.mergeAcross) {
            return this.createMergedCell(excelStyleId, type, value, cell.mergeAcross);
          }
          return this.createCell(excelStyleId, type, value);
        }),
        outlineLevel
      };
      if (row.collapsed != null) {
        rowObj.collapsed = row.collapsed;
      }
      if (row.hidden != null) {
        rowObj.hidden = row.hidden;
      }
      this.rows.push(rowObj);
    });
  }
  onNewHeaderGroupingRow() {
    const currentCells = [];
    const { freezeRows, headerRowHeight } = this.config;
    this.rows.push({
      cells: currentCells,
      height: getHeightFromProperty(this.rows.length + 1, headerRowHeight)
    });
    if (freezeRows) {
      this.frozenRowCount++;
    }
    return {
      onColumn: (columnGroup, header, index, span, collapsibleRanges) => {
        const styleIds = this.config.styleLinker({
          rowType: "HEADER_GROUPING",
          rowIndex: 1,
          value: `grouping-${header}`,
          columnGroup
        });
        currentCells.push({
          ...this.createMergedCell(
            this.getStyleId(styleIds),
            this.getDataTypeForValue("string"),
            header,
            span
          ),
          collapsibleRanges
        });
      }
    };
  }
  onNewHeaderRow() {
    const { freezeRows, headerRowHeight } = this.config;
    if (freezeRows) {
      this.frozenRowCount++;
    }
    return this.onNewRow(this.onNewHeaderColumn, headerRowHeight);
  }
  onNewBodyRow(node) {
    const { freezeRows, rowHeight } = this.config;
    if (!this.skipFrozenRows) {
      if (freezeRows === "headersAndPinnedRows" && node?.rowPinned === "top") {
        this.frozenRowCount++;
      } else if (typeof freezeRows === "function") {
        if (freezeRows((0, import_ag_grid_community8._addGridCommonParams)(this.gos, { node }))) {
          this.frozenRowCount++;
        } else {
          this.skipFrozenRows = true;
        }
      } else {
        this.skipFrozenRows = true;
      }
    }
    const rowAccumulator = this.onNewRow(this.onNewBodyColumn, rowHeight);
    if (node) {
      this.addRowOutlineIfNecessary(node);
    }
    return rowAccumulator;
  }
  prepare(columnsToExport) {
    super.prepare(columnsToExport);
    this.columnsToExport = [...columnsToExport];
    this.cols = columnsToExport.map((col, i) => this.convertColumnToExcel(col, i));
  }
  parse() {
    const longestRow = this.rows.reduce((a, b) => Math.max(a, b.cells.length), 0);
    while (this.cols.length < longestRow) {
      this.cols.push(this.convertColumnToExcel(null, this.cols.length + 1));
    }
    const { config } = this;
    let name;
    if (config.sheetName != null) {
      const { sheetName } = config;
      const sheetNameValue = typeof sheetName === "function" ? sheetName((0, import_ag_grid_community8._addGridCommonParams)(this.gos, {})) : sheetName;
      name = String(sheetNameValue).substring(0, 31);
    } else {
      name = "ag-grid";
    }
    const data = {
      name,
      table: {
        columns: this.cols,
        rows: this.rows
      }
    };
    return this.createExcel(data);
  }
  addRowOutlineIfNecessary(node) {
    const { gos, suppressRowOutline, rowGroupExpandState = "expanded" } = this.config;
    const isGroupHideOpenParents = gos.get("groupHideOpenParents");
    if (isGroupHideOpenParents || suppressRowOutline || node.level == null) {
      return;
    }
    const padding = node.footer ? 1 : 0;
    const currentRow = (0, import_ag_grid_community8._last)(this.rows);
    const outlineLevel = Math.min(node.level + padding, 7);
    currentRow.outlineLevel = outlineLevel;
    if (rowGroupExpandState === "expanded") {
      return;
    }
    const collapseAll = rowGroupExpandState === "collapsed";
    if (node.isExpandable()) {
      const isExpanded = !collapseAll && node.expanded;
      currentRow.collapsed = !isExpanded;
    }
    currentRow.hidden = // always show the node if there is no parent to be expanded
    !!node.parent && // or if it is a child of the root node
    node.parent.level !== -1 && (collapseAll || this.isAnyParentCollapsed(node.parent));
  }
  isAnyParentCollapsed(node) {
    while (node && node.level !== -1) {
      if (!node.expanded) {
        return true;
      }
      node = node.parent;
    }
    return false;
  }
  convertColumnToExcel(column, index) {
    const columnWidth = this.config.columnWidth;
    const headerValue = column ? this.extractHeaderValue(column) : void 0;
    const displayName = headerValue ?? "";
    const filterAllowed = column ? column.isFilterAllowed() : false;
    if (columnWidth) {
      if (typeof columnWidth === "number") {
        return { width: columnWidth, displayName, filterAllowed };
      }
      return { width: columnWidth({ column, index }), displayName, filterAllowed };
    }
    if (column) {
      const smallestUsefulWidth = 75;
      return { width: Math.max(column.getActualWidth(), smallestUsefulWidth), displayName, filterAllowed };
    }
    return {
      displayName,
      filterAllowed
    };
  }
  onNewHeaderColumn(rowIndex, currentCells) {
    return (column) => {
      const nameForCol = this.extractHeaderValue(column);
      const styleIds = this.config.styleLinker({
        rowType: "HEADER",
        rowIndex,
        value: nameForCol,
        column
      });
      currentCells.push(
        this.createCell(this.getStyleId(styleIds), this.getDataTypeForValue("string"), nameForCol)
      );
    };
  }
  onNewBodyColumn(rowIndex, currentCells) {
    let skipCols = 0;
    const { freezeColumns, rightToLeft } = this.config;
    return (column, index, node) => {
      if (skipCols > 0) {
        skipCols -= 1;
        return;
      }
      if (!this.skipFrozenColumns) {
        const pinned = column.getPinned();
        const isPinnedLeft = pinned === true || pinned === "left";
        if (freezeColumns === "pinned" && pinned && isPinnedLeft !== rightToLeft) {
          this.frozenColumnCount++;
        } else if (typeof freezeColumns === "function" && freezeColumns((0, import_ag_grid_community8._addGridCommonParams)(this.gos, { column }))) {
          this.frozenColumnCount++;
        } else {
          this.skipFrozenColumns = true;
        }
      }
      const { value: valueForCell, valueFormatted } = this.extractRowCellValue(
        column,
        index,
        rowIndex,
        "excel",
        node
      );
      const styleIds = this.config.styleLinker({
        rowType: "BODY",
        rowIndex,
        value: valueForCell,
        column,
        node
      });
      const excelStyleId = this.getStyleId(styleIds);
      const colSpan = column.getColSpan(node);
      const addedImage = this.addImage(rowIndex, column, valueForCell);
      if (addedImage) {
        currentCells.push(
          this.createCell(
            excelStyleId,
            this.getDataTypeForValue(addedImage.value),
            addedImage.value == null ? "" : addedImage.value
          )
        );
      } else if (colSpan > 1) {
        skipCols = colSpan - 1;
        currentCells.push(
          this.createMergedCell(
            excelStyleId,
            this.getDataTypeForValue(valueForCell),
            valueForCell,
            colSpan - 1
          )
        );
      } else {
        currentCells.push(
          this.createCell(excelStyleId, this.getDataTypeForValue(valueForCell), valueForCell, valueFormatted)
        );
      }
    };
  }
  onNewRow(onNewColumnAccumulator, height) {
    const currentCells = [];
    this.rows.push({
      cells: currentCells,
      height: getHeightFromProperty(this.rows.length + 1, height)
    });
    return {
      onColumn: onNewColumnAccumulator.bind(this, this.rows.length, currentCells)()
    };
  }
  createExcel(data) {
    const { excelStyles, config } = this;
    if (this.frozenColumnCount) {
      config.frozenColumnCount = this.frozenColumnCount;
    }
    if (this.frozenRowCount) {
      config.frozenRowCount = this.frozenRowCount;
    }
    return createXlsxExcel(excelStyles, data, config);
  }
  getDataTypeForValue(valueForCell) {
    if (valueForCell === void 0) {
      return "empty";
    }
    return this.isNumerical(valueForCell) ? "n" : "s";
  }
  getTypeFromStyle(style, value) {
    if (this.isFormula(value)) {
      return "f";
    }
    if (style && style.dataType) {
      switch (style.dataType.toLocaleLowerCase()) {
        case "formula":
          return "f";
        case "string":
          return "s";
        case "number":
          return "n";
        case "datetime":
          return "d";
        case "error":
          return "e";
        case "boolean":
          return "b";
        default:
          (0, import_ag_grid_community8._warn)(162, { id: style.id, dataType: style.dataType });
      }
    }
    return null;
  }
  addImage(rowIndex, column, value) {
    if (!this.config.addImageToCell) {
      return;
    }
    const addedImage = this.config.addImageToCell(rowIndex, column, value);
    if (!addedImage) {
      return;
    }
    addXlsxBodyImageToMap(addedImage.image, rowIndex, column, this.columnsToExport, this.config.rowHeight);
    return addedImage;
  }
  createCell(styleId, type, value, valueFormatted) {
    const actualStyle = this.getStyleById(styleId);
    if (!actualStyle?.dataType && type === "s" && valueFormatted) {
      value = valueFormatted;
    }
    const processedType = this.getTypeFromStyle(actualStyle, value) || type;
    const { value: processedValue, escaped } = this.getCellValue(processedType, value);
    const styles = [];
    if (actualStyle) {
      styles.push(styleId);
    }
    if (escaped) {
      styles.push("_quotePrefix");
    }
    styleId = this.getStyleId(styles) || void 0;
    return {
      styleId,
      data: {
        type: processedType,
        value: processedValue
      }
    };
  }
  createMergedCell(styleId, type, value, numOfCells) {
    const valueToUse = value == null ? "" : value;
    return {
      styleId: this.getStyleById(styleId) ? styleId : void 0,
      data: {
        type,
        value: type === "s" ? getXlsxStringPosition(valueToUse).toString() : value
      },
      mergeAcross: numOfCells
    };
  }
  getCellValue(type, value) {
    let escaped = false;
    if (value == null || type === "s" && value === "") {
      return { value: "", escaped: false };
    }
    if (type === "s") {
      if (value && value[0] === "'") {
        escaped = true;
        value = value.slice(1);
      }
      value = getXlsxStringPosition(value).toString();
    } else if (type === "f") {
      value = value.slice(1);
    } else if (type === "n") {
      const numberValue = Number(value);
      if (isNaN(numberValue)) {
        value = "";
      } else if (value !== "") {
        value = numberValue.toString();
      }
    }
    return { value, escaped };
  }
  getStyleId(styleIds) {
    if (!styleIds || !styleIds.length) {
      return null;
    }
    if (styleIds.length === 1) {
      return styleIds[0];
    }
    const key = styleIds.join("-");
    if (!this.mixedStyles[key]) {
      this.addNewMixedStyle(styleIds);
    }
    return this.mixedStyles[key].excelID;
  }
  deepCloneObject(object) {
    return JSON.parse(JSON.stringify(object));
  }
  addNewMixedStyle(styleIds) {
    this.mixedStyleCounter += 1;
    const excelId = `mixedStyle${this.mixedStyleCounter}`;
    const resultantStyle = {};
    for (const styleId of styleIds) {
      for (const excelStyle of this.excelStyles) {
        if (excelStyle.id === styleId) {
          (0, import_ag_grid_community8._mergeDeep)(resultantStyle, this.deepCloneObject(excelStyle));
        }
      }
    }
    resultantStyle.id = excelId;
    const key = styleIds.join("-");
    this.mixedStyles[key] = {
      excelID: excelId,
      key,
      result: resultantStyle
    };
    this.excelStyles.push(resultantStyle);
    this.stylesByIds[excelId] = resultantStyle;
  }
  isFormula(value) {
    if (value == null) {
      return false;
    }
    return this.config.autoConvertFormulas && value.toString().startsWith("=");
  }
  isNumerical(value) {
    if (typeof value === "bigint") {
      return true;
    }
    return isFinite(value) && value !== "" && !isNaN(parseFloat(value));
  }
  getStyleById(styleId) {
    if (styleId == null) {
      return null;
    }
    return this.stylesByIds[styleId] || null;
  }
};

// packages/ag-grid-enterprise/src/excelExport/zipContainer/zipContainerHelper.ts
var import_ag_grid_community9 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/excelExport/zipContainer/compress.ts
var compressBlob = async (data) => {
  let chunksSize = 0;
  const chunks = [];
  const writeCompressedData = new WritableStream({
    write: (chunk) => {
      chunks.push(chunk);
      chunksSize += chunk.length;
    }
  });
  const readable = new ReadableStream({
    start: (controller) => {
      const reader = new FileReader();
      reader.onload = (e) => {
        if (e.target?.result) {
          controller.enqueue(e.target.result);
        }
        controller.close();
      };
      reader.readAsArrayBuffer(data);
    }
  });
  const compressStream = new window.CompressionStream("deflate-raw");
  await readable.pipeThrough(compressStream).pipeTo(writeCompressedData);
  return {
    size: chunksSize,
    content: new Blob(chunks)
  };
};
var deflateLocalFile = async (rawContent) => {
  const contentAsBlob = new Blob([rawContent]);
  const { size: compressedSize, content: compressedContent } = await compressBlob(contentAsBlob);
  const compressedContentAsUint8Array = new Uint8Array(await compressedContent.arrayBuffer());
  return {
    size: compressedSize,
    content: compressedContentAsUint8Array
  };
};

// packages/ag-grid-enterprise/src/excelExport/zipContainer/convert.ts
var convertTime = (date) => {
  let time = date.getHours();
  time <<= 6;
  time = time | date.getMinutes();
  time <<= 5;
  time = time | date.getSeconds() / 2;
  return time;
};
var convertDate = (date) => {
  let dt = date.getFullYear() - 1980;
  dt <<= 4;
  dt = dt | date.getMonth() + 1;
  dt <<= 5;
  dt = dt | date.getDate();
  return dt;
};
function convertDecToHex(number, bytes) {
  let hex = "";
  for (let i = 0; i < bytes; i++) {
    hex += String.fromCharCode(number & 255);
    number >>>= 8;
  }
  return hex;
}

// packages/ag-grid-enterprise/src/excelExport/zipContainer/crcTable.ts
var getCrcFromCrc32TableAndByteArray = (content) => {
  if (!content.length) {
    return 0;
  }
  let crc = 0 ^ -1;
  let j = 0;
  let k = 0;
  let l = 0;
  for (let i = 0; i < content.length; i++) {
    j = content[i];
    k = (crc ^ j) & 255;
    l = crcTable[k];
    crc = crc >>> 8 ^ l;
  }
  return crc ^ -1;
};
var getCrcFromCrc32Table = (content) => {
  if (!content.length) {
    return 0;
  }
  if (typeof content === "string") {
    return getCrcFromCrc32TableAndByteArray(new TextEncoder().encode(content));
  }
  return getCrcFromCrc32TableAndByteArray(content);
};
var crcTable = /* @__PURE__ */ new Uint32Array([
  0,
  1996959894,
  3993919788,
  2567524794,
  124634137,
  1886057615,
  3915621685,
  2657392035,
  249268274,
  2044508324,
  3772115230,
  2547177864,
  162941995,
  2125561021,
  3887607047,
  2428444049,
  498536548,
  1789927666,
  4089016648,
  2227061214,
  450548861,
  1843258603,
  4107580753,
  2211677639,
  325883990,
  1684777152,
  4251122042,
  2321926636,
  335633487,
  1661365465,
  4195302755,
  2366115317,
  997073096,
  1281953886,
  3579855332,
  2724688242,
  1006888145,
  1258607687,
  3524101629,
  2768942443,
  901097722,
  1119000684,
  3686517206,
  2898065728,
  853044451,
  1172266101,
  3705015759,
  2882616665,
  651767980,
  1373503546,
  3369554304,
  3218104598,
  565507253,
  1454621731,
  3485111705,
  3099436303,
  671266974,
  1594198024,
  3322730930,
  2970347812,
  795835527,
  1483230225,
  3244367275,
  3060149565,
  1994146192,
  31158534,
  2563907772,
  4023717930,
  1907459465,
  112637215,
  2680153253,
  3904427059,
  2013776290,
  251722036,
  2517215374,
  3775830040,
  2137656763,
  141376813,
  2439277719,
  3865271297,
  1802195444,
  476864866,
  2238001368,
  4066508878,
  1812370925,
  453092731,
  2181625025,
  4111451223,
  1706088902,
  314042704,
  2344532202,
  4240017532,
  1658658271,
  366619977,
  2362670323,
  4224994405,
  1303535960,
  984961486,
  2747007092,
  3569037538,
  1256170817,
  1037604311,
  2765210733,
  3554079995,
  1131014506,
  879679996,
  2909243462,
  3663771856,
  1141124467,
  855842277,
  2852801631,
  3708648649,
  1342533948,
  654459306,
  3188396048,
  3373015174,
  1466479909,
  544179635,
  3110523913,
  3462522015,
  1591671054,
  702138776,
  2966460450,
  3352799412,
  1504918807,
  783551873,
  3082640443,
  3233442989,
  3988292384,
  2596254646,
  62317068,
  1957810842,
  3939845945,
  2647816111,
  81470997,
  1943803523,
  3814918930,
  2489596804,
  225274430,
  2053790376,
  3826175755,
  2466906013,
  167816743,
  2097651377,
  4027552580,
  2265490386,
  503444072,
  1762050814,
  4150417245,
  2154129355,
  426522225,
  1852507879,
  4275313526,
  2312317920,
  282753626,
  1742555852,
  4189708143,
  2394877945,
  397917763,
  1622183637,
  3604390888,
  2714866558,
  953729732,
  1340076626,
  3518719985,
  2797360999,
  1068828381,
  1219638859,
  3624741850,
  2936675148,
  906185462,
  1090812512,
  3747672003,
  2825379669,
  829329135,
  1181335161,
  3412177804,
  3160834842,
  628085408,
  1382605366,
  3423369109,
  3138078467,
  570562233,
  1426400815,
  3317316542,
  2998733608,
  733239954,
  1555261956,
  3268935591,
  3050360625,
  752459403,
  1541320221,
  2607071920,
  3965973030,
  1969922972,
  40735498,
  2617837225,
  3943577151,
  1913087877,
  83908371,
  2512341634,
  3803740692,
  2075208622,
  213261112,
  2463272603,
  3855990285,
  2094854071,
  198958881,
  2262029012,
  4057260610,
  1759359992,
  534414190,
  2176718541,
  4139329115,
  1873836001,
  414664567,
  2282248934,
  4279200368,
  1711684554,
  285281116,
  2405801727,
  4167216745,
  1634467795,
  376229701,
  2685067896,
  3608007406,
  1308918612,
  956543938,
  2808555105,
  3495958263,
  1231636301,
  1047427035,
  2932959818,
  3654703836,
  1088359270,
  936918e3,
  2847714899,
  3736837829,
  1202900863,
  817233897,
  3183342108,
  3401237130,
  1404277552,
  615818150,
  3134207493,
  3453421203,
  1423857449,
  601450431,
  3009837614,
  3294710456,
  1567103746,
  711928724,
  3020668471,
  3272380065,
  1510334235,
  755167117
]);

// packages/ag-grid-enterprise/src/excelExport/zipContainer/zipContainerHelper.ts
function _utf8_encode(s) {
  const stringFromCharCode = String.fromCharCode;
  function ucs2decode(string) {
    const output = [];
    if (!string) {
      return [];
    }
    const len = string.length;
    let counter = 0;
    let value;
    let extra;
    while (counter < len) {
      value = string.charCodeAt(counter++);
      if (value >= 55296 && value <= 56319 && counter < len) {
        extra = string.charCodeAt(counter++);
        if ((extra & 64512) == 56320) {
          output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
        } else {
          output.push(value);
          counter--;
        }
      } else {
        output.push(value);
      }
    }
    return output;
  }
  function checkScalarValue(point) {
    if (point >= 55296 && point <= 57343) {
      throw Error((0, import_ag_grid_community9._errMsg)(255, { point }));
    }
  }
  function createByte(point, shift) {
    return stringFromCharCode(point >> shift & 63 | 128);
  }
  function encodeCodePoint(point) {
    if ((point & 4294967168) == 0) {
      return stringFromCharCode(point);
    }
    let symbol = "";
    if ((point & 4294965248) == 0) {
      symbol = stringFromCharCode(point >> 6 & 31 | 192);
    } else if ((point & 4294901760) == 0) {
      checkScalarValue(point);
      symbol = stringFromCharCode(point >> 12 & 15 | 224);
      symbol += createByte(point, 6);
    } else if ((point & 4292870144) == 0) {
      symbol = stringFromCharCode(point >> 18 & 7 | 240);
      symbol += createByte(point, 12);
      symbol += createByte(point, 6);
    }
    symbol += stringFromCharCode(point & 63 | 128);
    return symbol;
  }
  const codePoints = ucs2decode(s);
  const length = codePoints.length;
  let index = -1;
  let codePoint;
  let byteString = "";
  while (++index < length) {
    codePoint = codePoints[index];
    byteString += encodeCodePoint(codePoint);
  }
  return byteString;
}
var getHeaders = (currentFile, isCompressed, offset, rawSize, rawContent, deflatedSize) => {
  const { content, path, created: creationDate } = currentFile;
  const time = convertTime(creationDate);
  const dt = convertDate(creationDate);
  const crcFlag = getCrcFromCrc32Table(rawContent);
  const zipSize = deflatedSize !== void 0 ? deflatedSize : rawSize;
  const utfPath = _utf8_encode(path);
  const isUTF8 = utfPath !== path;
  let extraFields = "";
  if (isUTF8) {
    const uExtraFieldPath = convertDecToHex(1, 1) + convertDecToHex(getCrcFromCrc32Table(utfPath), 4) + utfPath;
    extraFields = "up" + convertDecToHex(uExtraFieldPath.length, 2) + uExtraFieldPath;
  }
  const commonHeader = "\0" + // version needed to extract
  (isUTF8 ? "\0\b" : "\0\0") + // Language encoding flag (EFS) (12th bit turned on)
  convertDecToHex(isCompressed ? 8 : 0, 2) + // As per ECMA-376 Part 2 specs
  convertDecToHex(time, 2) + // last modified time
  convertDecToHex(dt, 2) + // last modified date
  convertDecToHex(zipSize ? crcFlag : 0, 4) + convertDecToHex(deflatedSize ?? rawSize, 4) + // compressed size
  convertDecToHex(rawSize, 4) + // uncompressed size
  convertDecToHex(utfPath.length, 2) + // file name length
  convertDecToHex(extraFields.length, 2);
  const localFileHeader = "PK" + commonHeader + utfPath + extraFields;
  const centralDirectoryHeader = "PK\0" + commonHeader + // file header
  "\0\0\0\0\0\0" + (content ? "\0\0\0\0" : "\0\0\0") + // external file attributes
  convertDecToHex(offset, 4) + // relative offset of local header
  utfPath + // file name
  extraFields;
  return {
    localFileHeader: Uint8Array.from(localFileHeader, (c) => c.charCodeAt(0)),
    centralDirectoryHeader: Uint8Array.from(centralDirectoryHeader, (c) => c.charCodeAt(0))
  };
};
var getDecodedContent = (content) => {
  let contentToUse;
  if (typeof content === "string") {
    const base64String = atob(content.split(";base64,")[1]);
    contentToUse = Uint8Array.from(base64String, (c) => c.charCodeAt(0));
  } else {
    contentToUse = content;
  }
  return {
    size: contentToUse.length,
    content: contentToUse
  };
};
var getDeflatedHeaderAndContent = async (currentFile, offset) => {
  const { content } = currentFile;
  const { size, content: rawContent } = !content ? { size: 0, content: Uint8Array.from([]) } : getDecodedContent(content);
  let deflatedContent = void 0;
  let deflatedSize = void 0;
  let deflationPerformed = false;
  const shouldDeflate = currentFile.type === "file" && rawContent && size > 0;
  if (shouldDeflate) {
    const result = await deflateLocalFile(rawContent);
    deflatedContent = result.content;
    deflatedSize = result.size;
    deflationPerformed = true;
  }
  const headers = getHeaders(currentFile, deflationPerformed, offset, size, rawContent, deflatedSize);
  return {
    ...headers,
    content: deflatedContent || rawContent,
    isCompressed: deflationPerformed
  };
};
var getHeaderAndContent = (currentFile, offset) => {
  const { content } = currentFile;
  const { content: rawContent } = !content ? { content: Uint8Array.from([]) } : getDecodedContent(content);
  const headers = getHeaders(currentFile, false, offset, rawContent.length, rawContent, void 0);
  return {
    ...headers,
    content: rawContent,
    isCompressed: false
  };
};
var buildCentralDirectoryEnd = (tLen, cLen, lLen) => {
  const str = "PK\0\0\0\0" + convertDecToHex(tLen, 2) + // total number of entries in the central folder
  convertDecToHex(tLen, 2) + // total number of entries in the central folder
  convertDecToHex(cLen, 4) + // size of the central folder
  convertDecToHex(lLen, 4) + // central folder start offset
  "\0\0";
  return Uint8Array.from(str, (c) => c.charCodeAt(0));
};

// packages/ag-grid-enterprise/src/excelExport/zipContainer/zipContainer.ts
var ZipContainer = class {
  constructor() {
    this.folders = [];
    this.files = [];
  }
  addFolders(paths) {
    paths.forEach(this.addFolder.bind(this));
  }
  addFolder(path) {
    this.folders.push({
      path,
      created: /* @__PURE__ */ new Date(),
      isBase64: false,
      type: "folder"
    });
  }
  addFile(path, content, isBase64 = false) {
    this.files.push({
      path,
      created: /* @__PURE__ */ new Date(),
      content: isBase64 ? content : new TextEncoder().encode(content),
      isBase64,
      type: "file"
    });
  }
  async getZipFile(mimeType = "application/zip") {
    const textOutput = await this.buildCompressedFileStream();
    this.clearStream();
    return new Blob([textOutput], { type: mimeType });
  }
  getUncompressedZipFile(mimeType = "application/zip") {
    const textOutput = this.buildFileStream();
    this.clearStream();
    return new Blob([textOutput], { type: mimeType });
  }
  clearStream() {
    this.folders = [];
    this.files = [];
  }
  packageFiles(files) {
    let fileLen = 0;
    let folderLen = 0;
    for (const currentFile of files) {
      const { localFileHeader, centralDirectoryHeader, content } = currentFile;
      fileLen += localFileHeader.length + content.length;
      folderLen += centralDirectoryHeader.length;
    }
    const fileData = new Uint8Array(fileLen);
    const folderData = new Uint8Array(folderLen);
    let fileOffset = 0;
    let folderOffset = 0;
    for (const currentFile of files) {
      const { localFileHeader, centralDirectoryHeader, content } = currentFile;
      fileData.set(localFileHeader, fileOffset);
      fileOffset += localFileHeader.length;
      fileData.set(content, fileOffset);
      fileOffset += content.length;
      folderData.set(centralDirectoryHeader, folderOffset);
      folderOffset += centralDirectoryHeader.length;
    }
    const folderEnd = buildCentralDirectoryEnd(files.length, folderLen, fileLen);
    const result = new Uint8Array(fileData.length + folderData.length + folderEnd.length);
    result.set(fileData);
    result.set(folderData, fileData.length);
    result.set(folderEnd, fileData.length + folderData.length);
    return result;
  }
  async buildCompressedFileStream() {
    const totalFiles = [...this.folders, ...this.files];
    const readyFiles = [];
    let lL = 0;
    for (const currentFile of totalFiles) {
      const output = await getDeflatedHeaderAndContent(currentFile, lL);
      const { localFileHeader, content } = output;
      readyFiles.push(output);
      lL += localFileHeader.length + content.length;
    }
    return this.packageFiles(readyFiles);
  }
  buildFileStream() {
    const totalFiles = [...this.folders, ...this.files];
    const readyFiles = [];
    let lL = 0;
    for (const currentFile of totalFiles) {
      const readyFile = getHeaderAndContent(currentFile, lL);
      const { localFileHeader, content } = readyFile;
      readyFiles.push(readyFile);
      lL += localFileHeader.length + content.length;
    }
    return this.packageFiles(readyFiles);
  }
};

// packages/ag-grid-enterprise/src/excelExport/excelCreator.ts
var createExcelXMLCoreFolderStructure = (zipContainer) => {
  zipContainer.addFolders(["_rels/", "docProps/", "xl/", "xl/theme/", "xl/_rels/", "xl/worksheets/"]);
  if (!XLSX_IMAGES.size) {
    return;
  }
  zipContainer.addFolders(["xl/worksheets/_rels", "xl/drawings/", "xl/drawings/_rels", "xl/media/"]);
  let imgCounter = 0;
  XLSX_IMAGES.forEach((value) => {
    const firstImage = value[0].image[0];
    const { base64, imageType } = firstImage;
    zipContainer.addFile(`xl/media/image${++imgCounter}.${_normaliseImageExtension(imageType)}`, base64, true);
  });
};
var createExcelXmlWorksheets = (zipContainer, data) => {
  let imageRelationCounter = 0;
  let headerFooterImageCounter = 0;
  for (let i = 0; i < data.length; i++) {
    const value = data[i];
    zipContainer.addFile(`xl/worksheets/sheet${i + 1}.xml`, value, false);
    const hasImages = XLSX_IMAGES.size > 0 && XLSX_WORKSHEET_IMAGES.has(i);
    const tableData = XLSX_WORKSHEET_DATA_TABLES.size > 0 && XLSX_WORKSHEET_DATA_TABLES.get(i);
    const hasHeaderFooterImages = XLSX_IMAGES.size && XLSX_WORKSHEET_HEADER_FOOTER_IMAGES.has(i);
    if (!hasImages && !tableData && !hasHeaderFooterImages) {
      continue;
    }
    let tableName;
    let drawingIndex;
    let vmlDrawingIndex;
    if (hasImages) {
      createExcelXmlDrawings(zipContainer, i, imageRelationCounter);
      drawingIndex = imageRelationCounter;
      imageRelationCounter++;
    }
    if (hasHeaderFooterImages) {
      createExcelVmlDrawings(zipContainer, i, headerFooterImageCounter);
      vmlDrawingIndex = headerFooterImageCounter;
      headerFooterImageCounter++;
    }
    if (tableData) {
      tableName = tableData.name;
    }
    const worksheetRelFile = `xl/worksheets/_rels/sheet${i + 1}.xml.rels`;
    zipContainer.addFile(
      worksheetRelFile,
      createXlsxRelationships({
        tableName,
        drawingIndex,
        vmlDrawingIndex
      })
    );
  }
};
var createExcelXmlDrawings = (zipContainer, sheetIndex, drawingIndex) => {
  const drawingFolder = "xl/drawings";
  const drawingFileName = `${drawingFolder}/drawing${drawingIndex + 1}.xml`;
  const relFileName = `${drawingFolder}/_rels/drawing${drawingIndex + 1}.xml.rels`;
  zipContainer.addFile(relFileName, createXlsxDrawingRel(sheetIndex));
  zipContainer.addFile(drawingFileName, createXlsxDrawing(sheetIndex));
};
var createExcelVmlDrawings = (zipContainer, sheetIndex, drawingIndex) => {
  const drawingFolder = "xl/drawings";
  const drawingFileName = `${drawingFolder}/vmlDrawing${drawingIndex + 1}.vml`;
  const relFileName = `${drawingFolder}/_rels/vmlDrawing${drawingIndex + 1}.vml.rels`;
  zipContainer.addFile(drawingFileName, createXlsxVmlDrawing(sheetIndex));
  zipContainer.addFile(relFileName, createXlsxVmlDrawingRel(sheetIndex));
};
var createExcelXmlTables = (zipContainer) => {
  const tablesDataByWorksheet = XLSX_WORKSHEET_DATA_TABLES;
  const worksheetKeys = Array.from(tablesDataByWorksheet.keys());
  for (let i = 0; i < worksheetKeys.length; i++) {
    const sheetIndex = worksheetKeys[i];
    const table = tablesDataByWorksheet.get(sheetIndex);
    if (!table) {
      continue;
    }
    zipContainer.addFile(`xl/tables/${table.name}.xml`, createXlsxTable(table, i));
  }
};
var createExcelXmlCoreSheets = (zipContainer, fontSize, author, sheetLen, activeTab) => {
  zipContainer.addFile("xl/workbook.xml", createXlsxWorkbook(activeTab));
  zipContainer.addFile("xl/styles.xml", createXlsxStylesheet(fontSize));
  zipContainer.addFile("xl/sharedStrings.xml", createXlsxSharedStrings());
  zipContainer.addFile("xl/theme/theme1.xml", createXlsxTheme());
  zipContainer.addFile("xl/_rels/workbook.xml.rels", createXlsxWorkbookRels(sheetLen));
  zipContainer.addFile("docProps/core.xml", createXlsxCore(author));
  zipContainer.addFile("[Content_Types].xml", createXlsxContentTypes(sheetLen));
  zipContainer.addFile("_rels/.rels", createXlsxRels());
};
var createExcelFileForExcel = (zipContainer, data, options = {}) => {
  if (!data || data.length === 0) {
    (0, import_ag_grid_community10._warn)(159);
    resetXlsxFactory();
    return false;
  }
  const { fontSize = 11, author = "AG Grid", activeTab = 0 } = options;
  const len = data.length;
  const activeTabWithinBounds = Math.max(Math.min(activeTab, len - 1), 0);
  createExcelXMLCoreFolderStructure(zipContainer);
  createExcelXmlTables(zipContainer);
  createExcelXmlWorksheets(zipContainer, data);
  createExcelXmlCoreSheets(zipContainer, fontSize, author, len, activeTabWithinBounds);
  resetXlsxFactory();
  return true;
};
var getMultipleSheetsAsExcelCompressed = (params) => {
  const { data, fontSize, author, activeSheetIndex } = params;
  const mimeType = params.mimeType || "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
  const zipContainer = new ZipContainer();
  if (!createExcelFileForExcel(zipContainer, data, {
    author,
    fontSize,
    activeTab: activeSheetIndex
  })) {
    return Promise.resolve(void 0);
  }
  return zipContainer.getZipFile(mimeType);
};
var getMultipleSheetsAsExcel = (params) => {
  const { data, fontSize, author, activeSheetIndex } = params;
  const mimeType = params.mimeType || "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
  const zipContainer = new ZipContainer();
  if (!createExcelFileForExcel(zipContainer, data, {
    author,
    fontSize,
    activeTab: activeSheetIndex
  })) {
    return;
  }
  return zipContainer.getUncompressedZipFile(mimeType);
};
var exportMultipleSheetsAsExcel = (params) => {
  const { fileName = "export.xlsx" } = params;
  getMultipleSheetsAsExcelCompressed(params).then((contents) => {
    if (contents) {
      const downloadFileName = typeof fileName === "function" ? fileName() : fileName;
      (0, import_ag_grid_community10._downloadFile)(downloadFileName, contents);
    }
  });
};
var ExcelCreator = class extends import_ag_grid_community10.BaseCreator {
  constructor() {
    super(...arguments);
    this.beanName = "excelCreator";
  }
  getMergedParams(params) {
    const baseParams = this.gos.get("defaultExcelExportParams");
    return Object.assign({}, baseParams, params);
  }
  export(userParams) {
    if (this.isExportSuppressed()) {
      (0, import_ag_grid_community10._warn)(160);
      return;
    }
    const mergedParams = this.getMergedParams(userParams);
    const data = this.getData(mergedParams);
    const exportParams = {
      data: [data],
      fontSize: mergedParams.fontSize,
      author: mergedParams.author,
      mimeType: mergedParams.mimeType
    };
    this.packageCompressedFile(exportParams).then((packageFile) => {
      if (packageFile) {
        const { fileName } = mergedParams;
        const providedFileName = typeof fileName === "function" ? fileName((0, import_ag_grid_community10._addGridCommonParams)(this.gos, {})) : fileName;
        (0, import_ag_grid_community10._downloadFile)(this.getFileName(providedFileName), packageFile);
      }
    });
  }
  exportDataAsExcel(params) {
    this.export(params);
  }
  getDataAsExcel(params) {
    const mergedParams = this.getMergedParams(params);
    const data = this.getData(mergedParams);
    const exportParams = {
      data: [data],
      fontSize: mergedParams.fontSize,
      author: mergedParams.author,
      mimeType: mergedParams.mimeType
    };
    return this.packageFile(exportParams);
  }
  setFactoryMode(factoryMode) {
    setXlsxFactoryMode(factoryMode);
  }
  getFactoryMode() {
    return getXlsxFactoryMode();
  }
  getSheetDataForExcel(params) {
    const mergedParams = this.getMergedParams(params);
    return this.getData(mergedParams);
  }
  getMultipleSheetsAsExcel(params) {
    return getMultipleSheetsAsExcel(params);
  }
  exportMultipleSheetsAsExcel(params) {
    exportMultipleSheetsAsExcel(params);
  }
  getDefaultFileExtension() {
    return "xlsx";
  }
  createSerializingSession(params) {
    const { colModel, colNames, rowGroupColsSvc, valueSvc, gos } = this.beans;
    const config = {
      ...params,
      colModel,
      colNames,
      rowGroupColsSvc,
      valueSvc,
      gos,
      suppressRowOutline: params.suppressRowOutline || params.skipRowGroups,
      headerRowHeight: params.headerRowHeight || params.rowHeight,
      baseExcelStyles: gos.get("excelStyles") || [],
      rightToLeft: params.rightToLeft ?? gos.get("enableRtl"),
      styleLinker: this.styleLinker.bind(this)
    };
    return new ExcelSerializingSession(config);
  }
  styleLinker(params) {
    const { rowType, rowIndex, value, column, columnGroup, node } = params;
    const isHeader = rowType === "HEADER";
    const isGroupHeader = rowType === "HEADER_GROUPING";
    const col = isHeader ? column : columnGroup;
    let headerClasses = [];
    const { gos, cellStyles } = this.beans;
    if (isHeader || isGroupHeader) {
      headerClasses.push("header");
      if (isGroupHeader) {
        headerClasses.push("headerGroup");
      }
      if (col) {
        headerClasses = headerClasses.concat(
          (0, import_ag_grid_community10._getHeaderClassesFromColDef)(
            col.getDefinition(),
            gos,
            column || null,
            columnGroup || null
          )
        );
      }
      return headerClasses;
    }
    const styles = gos.get("excelStyles");
    const applicableStyles = ["cell"];
    if (!styles || !styles.length) {
      return applicableStyles;
    }
    const styleIds = styles.map((it) => {
      return it.id;
    });
    const colDef = column.getDefinition();
    cellStyles?.processAllCellClasses(
      colDef,
      (0, import_ag_grid_community10._addGridCommonParams)(gos, {
        value,
        data: node.data,
        node,
        colDef,
        column,
        rowIndex
      }),
      (className) => {
        if (styleIds.indexOf(className) > -1) {
          applicableStyles.push(className);
        }
      }
    );
    return applicableStyles.sort((left, right) => {
      return styleIds.indexOf(left) < styleIds.indexOf(right) ? -1 : 1;
    });
  }
  isExportSuppressed() {
    return this.gos.get("suppressExcelExport");
  }
  packageCompressedFile(params) {
    return getMultipleSheetsAsExcelCompressed(params);
  }
  packageFile(params) {
    return getMultipleSheetsAsExcel(params);
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/advancedFilterModule.ts
var import_ag_grid_community39 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/version.ts
var VERSION = "33.1.1";

// packages/ag-grid-enterprise/src/agGridEnterpriseModule.ts
var EnterpriseCoreModule = {
  moduleName: "EnterpriseCore",
  version: VERSION,
  beans: [GridLicenseManager],
  icons: {
    // accordion open (filter tool panel group, charts group)
    accordionOpen: "tree-open",
    // accordion closed (filter tool panel group, charts group)
    accordionClosed: "tree-closed",
    // accordion indeterminate - shown when some children are expanded and
    //     others are collapsed (filter tool panel group, charts group)
    accordionIndeterminate: "tree-indeterminate",
    // dialog title bar
    close: "cross",
    // X (remove) on column 'pill' after adding it to a drop zone list
    cancel: "cancel",
    // button in chart regular size window title bar (click to maximise)
    maximize: "maximize",
    // button in chart maximised window title bar (click to make regular size)
    minimize: "minimize",
    // drag handle used to pick up draggable columns
    columnDrag: "grip"
  },
  dependsOn: []
};

// packages/ag-grid-enterprise/src/advancedFilter/advanced-filter.css-GENERATED.ts
var advancedFilterCSS = (
  /*css*/
  `.ag-advanced-filter-header{align-items:center;background-color:var(--ag-header-background-color);border-bottom:var(--ag-header-row-border);display:flex;padding-left:var(--ag-cell-horizontal-padding);padding-right:var(--ag-cell-horizontal-padding);position:relative}.ag-advanced-filter{align-items:center;display:flex;width:100%}.ag-advanced-filter-apply-button,.ag-advanced-filter-builder-button{line-height:normal;white-space:nowrap}:where(.ag-ltr) .ag-advanced-filter-apply-button,:where(.ag-ltr) .ag-advanced-filter-builder-button{margin-left:calc(var(--ag-spacing)*2)}:where(.ag-rtl) .ag-advanced-filter-apply-button,:where(.ag-rtl) .ag-advanced-filter-builder-button{margin-right:calc(var(--ag-spacing)*2)}.ag-advanced-filter-builder-button{align-items:center;background-color:unset;border:0;display:flex;font-size:var(--ag-font-size);font-weight:600;padding:var(--ag-spacing);&:where(:not(:disabled)){cursor:pointer;&:hover{background-color:var(--ag-row-hover-color)}}}:where(.ag-ltr) .ag-advanced-filter-builder-button-label{margin-left:var(--ag-spacing)}:where(.ag-rtl) .ag-advanced-filter-builder-button-label{margin-right:var(--ag-spacing)}.ag-advanced-filter-builder{display:flex;flex-direction:column;-webkit-user-select:none;-moz-user-select:none;user-select:none;width:100%}.ag-advanced-filter-builder-list{flex:1;overflow:auto}.ag-advanced-filter-builder-button-panel{border-top:var(--ag-advanced-filter-builder-button-bar-border);display:flex;justify-content:flex-end;padding:var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding)}:where(.ag-ltr) .ag-advanced-filter-builder-apply-button,:where(.ag-ltr) .ag-advanced-filter-builder-cancel-button{margin-left:calc(var(--ag-spacing)*2)}:where(.ag-rtl) .ag-advanced-filter-builder-apply-button,:where(.ag-rtl) .ag-advanced-filter-builder-cancel-button{margin-right:calc(var(--ag-spacing)*2)}.ag-advanced-filter-builder-item-wrapper{align-items:center;display:flex;flex:1 1 auto;justify-content:space-between;overflow:hidden}:where(.ag-ltr) .ag-advanced-filter-builder-item-wrapper{padding-left:calc(var(--ag-icon-size)/2);padding-right:var(--ag-icon-size)}:where(.ag-rtl) .ag-advanced-filter-builder-item-wrapper{padding-left:var(--ag-icon-size);padding-right:calc(var(--ag-icon-size)/2)}:where(.ag-virtual-list-viewport .ag-advanced-filter-builder-item-wrapper) .ag-tab-guard{position:absolute}.ag-advanced-filter-builder-item-tree-lines>*{width:var(--ag-advanced-filter-builder-indent-size)}.ag-advanced-filter-builder-item-tree-line-root{width:var(--ag-icon-size);&:before{height:50%;top:50%}}.ag-advanced-filter-builder-item-tree-line-horizontal,.ag-advanced-filter-builder-item-tree-line-vertical,.ag-advanced-filter-builder-item-tree-line-vertical-bottom,.ag-advanced-filter-builder-item-tree-line-vertical-top{align-items:center;display:flex;height:100%;position:relative;&:after,&:before{content:"";height:100%;position:absolute}}.ag-advanced-filter-builder-item-tree-line-horizontal:after{border-bottom:1px solid var(--ag-border-color);height:50%;top:0;width:calc(var(--ag-advanced-filter-builder-indent-size) - var(--ag-icon-size))}:where(.ag-ltr) .ag-advanced-filter-builder-item-tree-line-horizontal:after{left:calc(var(--ag-icon-size)/2)}:where(.ag-rtl) .ag-advanced-filter-builder-item-tree-line-horizontal:after{right:calc(var(--ag-icon-size)/2)}.ag-advanced-filter-builder-item-tree-line-vertical:before{top:0;width:calc(var(--ag-advanced-filter-builder-indent-size) - var(--ag-icon-size)/2)}:where(.ag-ltr) .ag-advanced-filter-builder-item-tree-line-vertical:before{border-left:1px solid var(--ag-border-color);left:calc(var(--ag-icon-size)/2)}:where(.ag-rtl) .ag-advanced-filter-builder-item-tree-line-vertical:before{border-right:1px solid var(--ag-border-color);right:calc(var(--ag-icon-size)/2)}.ag-advanced-filter-builder-item-tree-line-vertical-top:before{height:50%;top:0;width:calc(var(--ag-advanced-filter-builder-indent-size) - var(--ag-icon-size)/2)}:where(.ag-ltr) .ag-advanced-filter-builder-item-tree-line-vertical-top:before{border-left:1px solid var(--ag-border-color);left:calc(var(--ag-icon-size)/2)}:where(.ag-rtl) .ag-advanced-filter-builder-item-tree-line-vertical-top:before{border-right:1px solid var(--ag-border-color);right:calc(var(--ag-icon-size)/2)}.ag-advanced-filter-builder-item-tree-line-vertical-bottom:before{height:calc(50% - var(--ag-icon-size)*1.5/2);top:calc(50% + var(--ag-icon-size)*1.5/2);width:calc(var(--ag-icon-size)/2)}:where(.ag-ltr) .ag-advanced-filter-builder-item-tree-line-vertical-bottom:before{border-left:1px solid var(--ag-border-color);left:calc(var(--ag-icon-size)/2)}:where(.ag-rtl) .ag-advanced-filter-builder-item-tree-line-vertical-bottom:before{border-right:1px solid var(--ag-border-color);right:calc(var(--ag-icon-size)/2)}.ag-advanced-filter-builder-item-condition{padding-bottom:var(--ag-spacing);padding-top:var(--ag-spacing)}.ag-advanced-filter-builder-item,.ag-advanced-filter-builder-item-buttons,.ag-advanced-filter-builder-item-condition,.ag-advanced-filter-builder-item-tree-lines,.ag-advanced-filter-builder-pill,.ag-advanced-filter-builder-pill-wrapper{align-items:center;display:flex;height:100%}.ag-advanced-filter-builder-pill-wrapper{margin:0 var(--ag-spacing)}.ag-advanced-filter-builder-pill{border-radius:var(--ag-border-radius);min-height:calc(100% - var(--ag-spacing)*3);min-width:calc(var(--ag-spacing)*2);padding:var(--ag-spacing) calc(var(--ag-spacing)*2);position:relative}:where(.ag-advanced-filter-builder-pill){.ag-advanced-filter-builder-value-number{font-family:monospace;font-weight:700}.ag-advanced-filter-builder-value-empty{color:var(--ag-subtle-text-color)}}:where(.ag-ltr) :where(.ag-advanced-filter-builder-pill){.ag-picker-field-display{margin-right:var(--ag-spacing)}}:where(.ag-rtl) :where(.ag-advanced-filter-builder-pill){.ag-picker-field-display{margin-left:var(--ag-spacing)}}.ag-advanced-filter-builder-pill-display{font-weight:500;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.ag-advanced-filter-builder-join-pill{background-color:var(--ag-advanced-filter-builder-join-pill-color);cursor:pointer}.ag-advanced-filter-builder-column-pill{background-color:var(--ag-advanced-filter-builder-column-pill-color);cursor:pointer}.ag-advanced-filter-builder-option-pill{background-color:var(--ag-advanced-filter-builder-option-pill-color);cursor:pointer}.ag-advanced-filter-builder-value-pill{background-color:var(--ag-advanced-filter-builder-value-pill-color);cursor:text;max-width:140px;:where(.ag-advanced-filter-builder-pill-display){display:block}}.ag-advanced-filter-builder-item-buttons>*{margin:0 calc(var(--ag-spacing)*.5)}.ag-advanced-filter-builder-item-button{color:var(--ag-subtle-text-color);cursor:pointer;position:relative}.ag-advanced-filter-builder-item-button,.ag-advanced-filter-builder-pill{&:focus-visible{box-shadow:var(--ag-focus-shadow)}}.ag-advanced-filter-builder-item-button-disabled{cursor:default;opacity:.5}.ag-advanced-filter-builder-virtual-list-container{top:var(--ag-spacing)}.ag-advanced-filter-builder-virtual-list-item{cursor:default;display:flex;height:var(--ag-list-item-height);&:hover{background-color:var(--ag-row-hover-color);:where(.ag-advanced-filter-builder-item-button){opacity:1}}}.ag-advanced-filter-builder-invalid{color:var(--ag-invalid-color);cursor:default;margin:0 var(--ag-spacing)}:where(.ag-advanced-filter-builder-validation) .ag-advanced-filter-builder-invalid,:where(.ag-advanced-filter-builder-virtual-list-item-highlight) .ag-advanced-filter-builder-item-button:focus-visible{opacity:1}`
);

// packages/ag-grid-enterprise/src/advancedFilter/advancedFilterApi.ts
function getAdvancedFilterModel(beans) {
  return beans.filterManager?.getAdvFilterModel() ?? null;
}
function setAdvancedFilterModel(beans, advancedFilterModel) {
  beans.filterManager?.setAdvFilterModel(advancedFilterModel);
}
function showAdvancedFilterBuilder(beans) {
  beans.filterManager?.toggleAdvFilterBuilder(true, "api");
}
function hideAdvancedFilterBuilder(beans) {
  beans.filterManager?.toggleAdvFilterBuilder(false, "api");
}

// packages/ag-grid-enterprise/src/advancedFilter/advancedFilterExpressionService.ts
var import_ag_grid_community11 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/advancedFilter/advancedFilterLocaleText.ts
var ADVANCED_FILTER_LOCALE_TEXT = {
  ariaAdvancedFilterBuilderItem: (variableValues) => `${variableValues[0]}. Level ${variableValues[1]}. Press ENTER to edit`,
  ariaAdvancedFilterBuilderItemValidation: (variableValues) => `${variableValues[0]}. Level ${variableValues[1]}. ${variableValues[2]} Press ENTER to edit`,
  ariaAdvancedFilterBuilderList: "Advanced Filter Builder List",
  ariaAdvancedFilterBuilderFilterItem: "Filter Condition",
  ariaAdvancedFilterBuilderGroupItem: "Filter Group",
  ariaAdvancedFilterBuilderColumn: "Column",
  ariaAdvancedFilterBuilderOption: "Option",
  ariaAdvancedFilterBuilderValue: "Value",
  ariaAdvancedFilterBuilderJoinOperator: "Join Operator",
  ariaAdvancedFilterInput: "Advanced Filter Input",
  ariaLabelAdvancedFilterAutocomplete: "Advanced Filter Autocomplete",
  advancedFilterContains: "contains",
  advancedFilterNotContains: "does not contain",
  advancedFilterTextEquals: "equals",
  advancedFilterTextNotEqual: "does not equal",
  advancedFilterStartsWith: "begins with",
  advancedFilterEndsWith: "ends with",
  advancedFilterBlank: "is blank",
  advancedFilterNotBlank: "is not blank",
  advancedFilterEquals: "=",
  advancedFilterNotEqual: "!=",
  advancedFilterGreaterThan: ">",
  advancedFilterGreaterThanOrEqual: ">=",
  advancedFilterLessThan: "<",
  advancedFilterLessThanOrEqual: "<=",
  advancedFilterTrue: "is true",
  advancedFilterFalse: "is false",
  advancedFilterAnd: "AND",
  advancedFilterOr: "OR",
  advancedFilterApply: "Apply",
  advancedFilterBuilder: "Builder",
  advancedFilterValidationMissingColumn: "Column is missing",
  advancedFilterValidationMissingOption: "Option is missing",
  advancedFilterValidationMissingValue: "Value is missing",
  advancedFilterValidationInvalidColumn: "Column not found",
  advancedFilterValidationInvalidOption: "Option not found",
  advancedFilterValidationMissingQuote: "Value is missing an end quote",
  advancedFilterValidationNotANumber: "Value is not a number",
  advancedFilterValidationInvalidDate: "Value is not a valid date",
  advancedFilterValidationMissingCondition: "Condition is missing",
  advancedFilterValidationJoinOperatorMismatch: "Join operators within a condition must be the same",
  advancedFilterValidationInvalidJoinOperator: "Join operator not found",
  advancedFilterValidationMissingEndBracket: "Missing end bracket",
  advancedFilterValidationExtraEndBracket: "Too many end brackets",
  advancedFilterValidationMessage: (variableValues) => `Expression has an error. ${variableValues[0]} - ${variableValues[1]}.`,
  advancedFilterValidationMessageAtEnd: (variableValues) => `Expression has an error. ${variableValues[0]} at end of expression.`,
  advancedFilterBuilderTitle: "Advanced Filter",
  advancedFilterBuilderApply: "Apply",
  advancedFilterBuilderCancel: "Cancel",
  advancedFilterBuilderAddButtonTooltip: "Add Filter or Group",
  advancedFilterBuilderRemoveButtonTooltip: "Remove",
  advancedFilterBuilderMoveUpButtonTooltip: "Move Up",
  advancedFilterBuilderMoveDownButtonTooltip: "Move Down",
  advancedFilterBuilderAddJoin: "Add Group",
  advancedFilterBuilderAddCondition: "Add Filter",
  advancedFilterBuilderSelectColumn: "Select a column",
  advancedFilterBuilderSelectOption: "Select an option",
  advancedFilterBuilderEnterValue: "Enter a value...",
  advancedFilterBuilderValidationAlreadyApplied: "Current filter already applied.",
  advancedFilterBuilderValidationIncomplete: "Not all conditions are complete.",
  advancedFilterBuilderValidationSelectColumn: "Must select a column.",
  advancedFilterBuilderValidationSelectOption: "Must select an option.",
  advancedFilterBuilderValidationEnterValue: "Must enter a value."
};

// packages/ag-grid-enterprise/src/advancedFilter/filterExpressionUtils.ts
function getSearchString(value, position, endPosition) {
  if (!value) {
    return "";
  }
  const numChars = endPosition - position;
  return numChars ? value.slice(0, value.length - numChars) : value;
}
function updateExpression(expression, startPosition, endPosition, updatedValuePart, appendSpace, appendQuote, empty) {
  const secondPartStartPosition = endPosition + (!expression.length || empty ? 0 : 1);
  let positionOffset = 0;
  if (appendSpace) {
    if (expression[secondPartStartPosition] === " ") {
      positionOffset = 1;
    } else {
      updatedValuePart += " ";
      if (appendQuote) {
        updatedValuePart += `"`;
      }
    }
  }
  const updatedValue = expression.slice(0, startPosition) + updatedValuePart + expression.slice(secondPartStartPosition);
  return { updatedValue, updatedPosition: startPosition + updatedValuePart.length + positionOffset };
}
function findStartPosition(expression, position, endPosition) {
  let startPosition = position;
  while (startPosition < endPosition) {
    const char = expression[startPosition];
    if (char !== " ") {
      break;
    }
    startPosition++;
  }
  return startPosition;
}
function findEndPosition(expression, position, includeCloseBracket, isStartPositionUnknown) {
  let endPosition = position;
  let isEmpty = false;
  while (endPosition < expression.length) {
    const char = expression[endPosition];
    if (char === "(") {
      if (isStartPositionUnknown && expression[endPosition - 1] === " ") {
        isEmpty = true;
      } else {
        endPosition = endPosition - 1;
      }
      break;
    } else if (char === " " || includeCloseBracket && char === ")") {
      endPosition = endPosition - 1;
      break;
    }
    endPosition++;
  }
  return { endPosition, isEmpty };
}
function checkAndUpdateExpression(params, userValue, displayValue, endPosition) {
  if (displayValue !== userValue) {
    params.expression = updateExpression(
      params.expression,
      endPosition - userValue.length + 1,
      endPosition,
      displayValue
    ).updatedValue;
  }
}
function escapeQuotes(value) {
  return value.replace(/(['"])/, "\\$1");
}

// packages/ag-grid-enterprise/src/advancedFilter/colFilterExpressionParser.ts
var ColumnParser = class {
  constructor(params, startPosition) {
    this.params = params;
    this.startPosition = startPosition;
    this.type = "column";
    this.valid = true;
    this.hasStartChar = false;
    this.hasEndChar = false;
    this.colName = "";
  }
  parse(char, position) {
    if (char === COL_FILTER_EXPRESSION_START_CHAR && !this.colName) {
      this.hasStartChar = true;
    } else if (char === COL_FILTER_EXPRESSION_END_CHAR && this.hasStartChar) {
      const isMatch = this.parseColumn(false, position);
      if (isMatch) {
        this.hasEndChar = true;
        return false;
      } else {
        this.colName += char;
      }
    } else {
      this.colName += char;
    }
    return void 0;
  }
  getDisplayValue() {
    return (this.hasStartChar ? COL_FILTER_EXPRESSION_START_CHAR : "") + this.colName + (this.hasEndChar ? COL_FILTER_EXPRESSION_END_CHAR : "");
  }
  getColId() {
    return this.colId;
  }
  complete(position) {
    this.parseColumn(true, position);
  }
  getValidationError() {
    return this.valid ? null : {
      message: this.params.advFilterExpSvc.translate("advancedFilterValidationInvalidColumn"),
      startPosition: this.startPosition,
      endPosition: this.endPosition ?? this.params.expression.length - 1
    };
  }
  parseColumn(fromComplete, endPosition) {
    this.endPosition = endPosition;
    const colValue = this.params.advFilterExpSvc.getColId(this.colName);
    if (colValue && this.hasStartChar) {
      this.colId = colValue.colId;
      checkAndUpdateExpression(this.params, this.colName, colValue.columnName, endPosition - 1);
      this.colName = colValue.columnName;
      this.column = this.params.colModel.getColDefCol(this.colId);
      if (this.column) {
        this.baseCellDataType = this.params.dataTypeSvc?.getBaseDataType(this.column) ?? "text";
        return true;
      }
    }
    if (fromComplete) {
      this.valid = false;
    }
    this.baseCellDataType = "text";
    return false;
  }
};
var OperatorParser = class {
  constructor(params, startPosition, baseCellDataType) {
    this.params = params;
    this.startPosition = startPosition;
    this.baseCellDataType = baseCellDataType;
    this.type = "operator";
    this.valid = true;
    this.expectedNumOperands = 0;
    this.operator = "";
  }
  parse(char, position) {
    if (char === " " || char === ")") {
      const isMatch = this.parseOperator(false, position - 1);
      if (isMatch) {
        return true;
      } else {
        this.operator += char;
      }
    } else {
      this.operator += char;
    }
    return void 0;
  }
  complete(position) {
    this.parseOperator(true, position);
  }
  getValidationError() {
    return this.valid ? null : {
      message: this.params.advFilterExpSvc.translate("advancedFilterValidationInvalidOption"),
      startPosition: this.startPosition,
      endPosition: this.endPosition ?? this.params.expression.length - 1
    };
  }
  getDisplayValue() {
    return this.operator;
  }
  getOperatorKey() {
    return this.parsedOperator;
  }
  parseOperator(fromComplete, endPosition) {
    const operatorForType = this.params.advFilterExpSvc.getDataTypeExpressionOperator(this.baseCellDataType);
    const parsedOperator = operatorForType.findOperator(this.operator);
    this.endPosition = endPosition;
    if (parsedOperator) {
      this.parsedOperator = parsedOperator;
      const operator = operatorForType.operators[parsedOperator];
      this.expectedNumOperands = operator.numOperands;
      const operatorDisplayValue = operator.displayValue;
      checkAndUpdateExpression(this.params, this.operator, operatorDisplayValue, endPosition);
      this.operator = operatorDisplayValue;
      return true;
    }
    const isPartialMatch = parsedOperator === null;
    if (fromComplete || !isPartialMatch) {
      this.valid = false;
    }
    return false;
  }
};
var OperandParser = class {
  constructor(params, startPosition, baseCellDataType, column) {
    this.params = params;
    this.startPosition = startPosition;
    this.baseCellDataType = baseCellDataType;
    this.column = column;
    this.type = "operand";
    this.valid = true;
    this.operand = "";
    this.validationMessage = null;
  }
  parse(char, position) {
    if (char === " ") {
      if (this.quotes) {
        this.operand += char;
      } else {
        this.parseOperand(false, position);
        return true;
      }
    } else if (char === ")") {
      if (this.baseCellDataType === "number" || !this.quotes) {
        this.parseOperand(false, position - 1);
        return true;
      } else {
        this.operand += char;
      }
    } else if (!this.operand && !this.quotes && (char === `'` || char === `"`)) {
      this.quotes = char;
    } else if (this.quotes && char === this.quotes) {
      this.parseOperand(false, position);
      return false;
    } else {
      this.operand += char;
    }
    return void 0;
  }
  complete(position) {
    this.parseOperand(true, position);
  }
  getValidationError() {
    return this.validationMessage ? {
      message: this.validationMessage,
      startPosition: this.startPosition,
      endPosition: this.endPosition ?? this.params.expression.length - 1
    } : null;
  }
  getRawValue() {
    return this.operand;
  }
  getModelValue() {
    return this.modelValue;
  }
  parseOperand(fromComplete, position) {
    const { advFilterExpSvc } = this.params;
    this.endPosition = position;
    this.modelValue = this.operand;
    if (fromComplete && this.quotes) {
      this.valid = false;
      this.validationMessage = advFilterExpSvc.translate("advancedFilterValidationMissingQuote");
    } else if (this.modelValue === "") {
      this.valid = false;
      this.validationMessage = advFilterExpSvc.translate("advancedFilterValidationMissingValue");
    } else {
      const modelValue = advFilterExpSvc.getOperandModelValue(this.operand, this.baseCellDataType, this.column);
      if (modelValue != null) {
        this.modelValue = modelValue;
      }
      switch (this.baseCellDataType) {
        case "number":
          if (this.quotes || isNaN(this.modelValue)) {
            this.valid = false;
            this.validationMessage = advFilterExpSvc.translate("advancedFilterValidationNotANumber");
          }
          break;
        case "date":
        case "dateString":
          if (modelValue == null) {
            this.valid = false;
            this.validationMessage = advFilterExpSvc.translate("advancedFilterValidationInvalidDate");
          }
          break;
      }
    }
  }
};
var COL_FILTER_EXPRESSION_START_CHAR = "[";
var COL_FILTER_EXPRESSION_END_CHAR = "]";
var ColFilterExpressionParser = class {
  constructor(params, startPosition) {
    this.params = params;
    this.startPosition = startPosition;
    this.isAwaiting = true;
  }
  parseExpression() {
    let i = this.startPosition;
    const { expression } = this.params;
    while (i < expression.length) {
      const char = expression[i];
      if (char === " " && this.isAwaiting) {
      } else {
        this.isAwaiting = false;
        if (!this.parser) {
          let parser;
          if (!this.columnParser) {
            this.columnParser = new ColumnParser(this.params, i);
            parser = this.columnParser;
          } else if (!this.operatorParser) {
            this.operatorParser = new OperatorParser(this.params, i, this.columnParser.baseCellDataType);
            parser = this.operatorParser;
          } else {
            this.operandParser = new OperandParser(
              this.params,
              i,
              this.columnParser.baseCellDataType,
              this.columnParser.column
            );
            parser = this.operandParser;
          }
          this.parser = parser;
        }
        const hasCompletedOnPrevChar = this.parser.parse(char, i);
        if (hasCompletedOnPrevChar != null) {
          if (this.isComplete()) {
            return this.returnEndPosition(hasCompletedOnPrevChar ? i - 1 : i, true);
          }
          this.parser = void 0;
          this.isAwaiting = true;
        }
      }
      i++;
    }
    this.parser?.complete?.(i - 1);
    return this.returnEndPosition(i);
  }
  isValid() {
    return this.isComplete() && this.columnParser.valid && this.operatorParser.valid && (!this.operandParser || this.operandParser.valid);
  }
  getValidationError() {
    const validationError = this.columnParser?.getValidationError() ?? this.operatorParser?.getValidationError() ?? this.operandParser?.getValidationError();
    if (validationError) {
      return validationError;
    }
    const endPosition = this.params.expression.length;
    let translateKey;
    if (!this.columnParser) {
      translateKey = "advancedFilterValidationMissingColumn";
    } else if (!this.operatorParser) {
      translateKey = "advancedFilterValidationMissingOption";
    } else if (this.operatorParser.expectedNumOperands && !this.operandParser) {
      translateKey = "advancedFilterValidationMissingValue";
    }
    if (translateKey) {
      return {
        message: this.params.advFilterExpSvc.translate(translateKey),
        startPosition: endPosition,
        endPosition
      };
    }
    return null;
  }
  getFunctionString(params) {
    return this.getFunctionCommon(params, (operandIndex, operatorIndex, colId, evaluatorParamsIndex) => {
      const escapedColId = escapeQuotes(colId);
      const operand = operandIndex == null ? "" : `, params.operands[${operandIndex}]`;
      return `params.operators[${operatorIndex}].evaluator(expressionProxy.getValue('${escapedColId}', node), node, params.evaluatorParams[${evaluatorParamsIndex}]${operand})`;
    });
  }
  getFunctionParsed(params) {
    return this.getFunctionCommon(params, (operandIndex, operatorIndex, colId, evaluatorParamsIndex) => {
      return (expressionProxy, node, p) => p.operators[operatorIndex].evaluator(
        expressionProxy.getValue(colId, node),
        node,
        p.evaluatorParams[evaluatorParamsIndex],
        operandIndex == null ? void 0 : p.operands[operandIndex]
      );
    });
  }
  getAutocompleteListParams(position) {
    if (this.isColumnPosition(position)) {
      return this.getColumnAutocompleteListParams(position);
    }
    if (this.isOperatorPosition(position)) {
      return this.getOperatorAutocompleteListParams(position);
    }
    if (this.isBeyondEndPosition(position)) {
      return void 0;
    }
    return { enabled: false };
  }
  updateExpression(position, updateEntry, type) {
    const { expression } = this.params;
    if (this.isColumnPosition(position)) {
      return updateExpression(
        this.params.expression,
        this.startPosition,
        this.columnParser?.getColId() ? this.columnParser.endPosition : findEndPosition(expression, position).endPosition,
        this.params.advFilterExpSvc.getColumnValue(updateEntry),
        true
      );
    } else if (this.isOperatorPosition(position)) {
      const baseCellDataType = this.getBaseCellDataTypeFromOperatorAutocompleteType(type);
      const hasOperand = this.hasOperand(baseCellDataType, updateEntry.key);
      const doesOperandNeedQuotes = hasOperand && this.doesOperandNeedQuotes(baseCellDataType);
      let update;
      if (this.operatorParser?.startPosition != null && position < this.operatorParser.startPosition) {
        update = updateExpression(
          expression,
          position,
          position,
          updateEntry.displayValue ?? updateEntry.key,
          hasOperand,
          doesOperandNeedQuotes
        );
      } else {
        let endPosition;
        let empty = false;
        if (this.operatorParser?.getOperatorKey()) {
          endPosition = this.operatorParser.endPosition;
        } else {
          const { endPosition: calculatedEndPosition, isEmpty } = findEndPosition(
            expression,
            position,
            true,
            true
          );
          endPosition = calculatedEndPosition;
          empty = isEmpty;
        }
        update = updateExpression(
          expression,
          findStartPosition(expression, this.columnParser.endPosition + 1, endPosition),
          endPosition,
          updateEntry.displayValue ?? updateEntry.key,
          hasOperand,
          doesOperandNeedQuotes,
          empty
        );
      }
      return { ...update, hideAutocomplete: !hasOperand };
    }
    return null;
  }
  getModel() {
    const colId = this.columnParser.getColId();
    const model = {
      filterType: this.columnParser.baseCellDataType,
      colId,
      type: this.operatorParser.getOperatorKey()
    };
    if (this.operatorParser.expectedNumOperands) {
      model.filter = this.operandParser.getModelValue();
    }
    return model;
  }
  getFunctionCommon(params, processFunc) {
    const colId = this.columnParser.getColId();
    const operator = this.operatorParser?.getOperatorKey();
    const { operators, evaluatorParams, operands } = params;
    const operatorForColumn = this.params.advFilterExpSvc.getExpressionOperator(
      this.columnParser.baseCellDataType,
      operator
    );
    const operatorIndex = this.addToListAndGetIndex(operators, operatorForColumn);
    const evaluatorParamsForColumn = this.params.advFilterExpSvc.getExpressionEvaluatorParams(colId);
    const evaluatorParamsIndex = this.addToListAndGetIndex(evaluatorParams, evaluatorParamsForColumn);
    const operandIndex = this.operatorParser?.expectedNumOperands === 0 ? void 0 : this.addToListAndGetIndex(operands, this.getOperandValue());
    return processFunc(operandIndex, operatorIndex, colId, evaluatorParamsIndex);
  }
  getOperandValue() {
    let operand = this.operandParser.getRawValue();
    const { baseCellDataType, column } = this.columnParser;
    switch (baseCellDataType) {
      case "number":
        operand = Number(operand);
        break;
      case "date":
      case "dateString":
        operand = this.params.valueSvc.parseValue(column, null, operand, void 0);
        break;
    }
    if (baseCellDataType === "dateString") {
      const { dataTypeSvc } = this.params;
      return dataTypeSvc ? dataTypeSvc.getDateParserFunction(column)(operand) : operand;
    }
    return operand;
  }
  isComplete() {
    return !!(this.operatorParser && (!this.operatorParser.expectedNumOperands || this.operatorParser.expectedNumOperands && this.operandParser));
  }
  isColumnPosition(position) {
    return !this.columnParser || this.columnParser.endPosition == null || position <= this.columnParser.endPosition + 1;
  }
  isOperatorPosition(position) {
    return !this.operatorParser || this.operatorParser.endPosition == null || position <= this.operatorParser.endPosition + 1;
  }
  isBeyondEndPosition(position) {
    return this.isComplete() && this.endPosition != null && position > this.endPosition + 1 && this.endPosition + 1 < this.params.expression.length;
  }
  returnEndPosition(returnPosition, treatAsEnd) {
    this.endPosition = treatAsEnd ? returnPosition : returnPosition - 1;
    return returnPosition;
  }
  getColumnAutocompleteListParams(position) {
    return this.params.advFilterExpSvc.generateAutocompleteListParams(
      this.params.advFilterExpSvc.getColumnAutocompleteEntries(),
      "column",
      this.getColumnSearchString(position)
    );
  }
  getColumnSearchString(position) {
    const columnName = this.columnParser?.getDisplayValue() ?? "";
    const searchString = getSearchString(
      columnName,
      position,
      this.columnParser?.endPosition == null ? this.params.expression.length : this.columnParser.endPosition + 1
    );
    const containsStartChar = this.columnParser?.hasStartChar && searchString.length > 0;
    const containsEndChar = this.columnParser?.hasEndChar && searchString.length === columnName.length + 2;
    if (containsStartChar) {
      return searchString.slice(1, containsEndChar ? -1 : void 0);
    }
    return searchString;
  }
  getOperatorAutocompleteListParams(position) {
    const column = this.columnParser?.column;
    if (!column) {
      return { enabled: false };
    }
    const baseCellDataType = this.columnParser.baseCellDataType;
    const searchString = this.operatorParser?.startPosition != null && position < this.operatorParser.startPosition ? "" : getSearchString(
      this.operatorParser?.getDisplayValue() ?? "",
      position,
      this.operatorParser?.endPosition == null ? this.params.expression.length : this.operatorParser.endPosition + 1
    );
    return this.params.advFilterExpSvc.generateAutocompleteListParams(
      this.params.advFilterExpSvc.getOperatorAutocompleteEntries(column, baseCellDataType),
      `operator-${baseCellDataType}`,
      searchString
    );
  }
  getBaseCellDataTypeFromOperatorAutocompleteType(type) {
    return type?.replace("operator-", "");
  }
  hasOperand(baseCellDataType, operator) {
    return !baseCellDataType || !operator || (this.params.advFilterExpSvc.getExpressionOperator(baseCellDataType, operator)?.numOperands ?? 0) > 0;
  }
  doesOperandNeedQuotes(baseCellDataType) {
    return baseCellDataType !== "number";
  }
  addToListAndGetIndex(list, value) {
    const index = list.length;
    list.push(value);
    return index;
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/filterExpressionOperators.ts
function findMatch(searchValue, values, getDisplayValue) {
  let partialMatch = false;
  const searchValueLowerCase = searchValue.toLocaleLowerCase();
  const partialSearchValue = searchValueLowerCase + " ";
  const parsedValue = Object.keys(values).find((key) => {
    const value = values[key];
    const displayValueLowerCase = getDisplayValue(value).toLocaleLowerCase();
    if (displayValueLowerCase.startsWith(partialSearchValue)) {
      partialMatch = true;
    }
    return displayValueLowerCase === searchValueLowerCase;
  });
  if (parsedValue) {
    return parsedValue;
  } else if (partialMatch) {
    return null;
  } else {
    return void 0;
  }
}
function getEntries(operators, activeOperatorKeys) {
  const keys = activeOperatorKeys ?? Object.keys(operators);
  return keys.map((key) => ({
    key,
    displayValue: operators[key].displayValue
  }));
}
var TextFilterExpressionOperators = class {
  constructor(params) {
    this.params = params;
    this.initOperators();
  }
  getEntries(activeOperators) {
    return getEntries(this.operators, activeOperators);
  }
  findOperator(displayValue) {
    return findMatch(displayValue, this.operators, ({ displayValue: displayValue2 }) => displayValue2);
  }
  initOperators() {
    const { translate } = this.params;
    this.operators = {
      contains: {
        displayValue: translate("advancedFilterContains"),
        evaluator: (value, node, params, operand1) => this.evaluateExpression(value, node, params, operand1, false, (v, o) => v.includes(o)),
        numOperands: 1
      },
      notContains: {
        displayValue: translate("advancedFilterNotContains"),
        evaluator: (value, node, params, operand1) => this.evaluateExpression(value, node, params, operand1, true, (v, o) => !v.includes(o)),
        numOperands: 1
      },
      equals: {
        displayValue: translate("advancedFilterTextEquals"),
        evaluator: (value, node, params, operand1) => this.evaluateExpression(value, node, params, operand1, false, (v, o) => v === o),
        numOperands: 1
      },
      notEqual: {
        displayValue: translate("advancedFilterTextNotEqual"),
        evaluator: (value, node, params, operand1) => this.evaluateExpression(value, node, params, operand1, true, (v, o) => v != o),
        numOperands: 1
      },
      startsWith: {
        displayValue: translate("advancedFilterStartsWith"),
        evaluator: (value, node, params, operand1) => this.evaluateExpression(value, node, params, operand1, false, (v, o) => v.startsWith(o)),
        numOperands: 1
      },
      endsWith: {
        displayValue: translate("advancedFilterEndsWith"),
        evaluator: (value, node, params, operand1) => this.evaluateExpression(value, node, params, operand1, false, (v, o) => v.endsWith(o)),
        numOperands: 1
      },
      blank: {
        displayValue: translate("advancedFilterBlank"),
        evaluator: (value) => value == null || typeof value === "string" && value.trim().length === 0,
        numOperands: 0
      },
      notBlank: {
        displayValue: translate("advancedFilterNotBlank"),
        evaluator: (value) => value != null && (typeof value !== "string" || value.trim().length > 0),
        numOperands: 0
      }
    };
  }
  evaluateExpression(value, node, params, operand, nullsMatch, expression) {
    if (value == null) {
      return nullsMatch;
    }
    return params.caseSensitive ? expression(params.valueConverter(value, node), operand) : expression(params.valueConverter(value, node).toLocaleLowerCase(), operand.toLocaleLowerCase());
  }
};
var ScalarFilterExpressionOperators = class {
  constructor(params) {
    this.params = params;
    this.initOperators();
  }
  getEntries(activeOperators) {
    return getEntries(this.operators, activeOperators);
  }
  findOperator(displayValue) {
    return findMatch(displayValue, this.operators, ({ displayValue: displayValue2 }) => displayValue2);
  }
  initOperators() {
    const { translate, equals } = this.params;
    this.operators = {
      equals: {
        displayValue: translate("advancedFilterEquals"),
        evaluator: (value, node, params, operand1) => this.evaluateSingleOperandExpression(
          value,
          node,
          params,
          operand1,
          !!params.includeBlanksInEquals,
          equals
        ),
        numOperands: 1
      },
      notEqual: {
        displayValue: translate("advancedFilterNotEqual"),
        evaluator: (value, node, params, operand1) => this.evaluateSingleOperandExpression(
          value,
          node,
          params,
          operand1,
          !!params.includeBlanksInEquals,
          (v, o) => !equals(v, o)
        ),
        numOperands: 1
      },
      greaterThan: {
        displayValue: translate("advancedFilterGreaterThan"),
        evaluator: (value, node, params, operand1) => this.evaluateSingleOperandExpression(
          value,
          node,
          params,
          operand1,
          !!params.includeBlanksInGreaterThan,
          (v, o) => v > o
        ),
        numOperands: 1
      },
      greaterThanOrEqual: {
        displayValue: translate("advancedFilterGreaterThanOrEqual"),
        evaluator: (value, node, params, operand1) => this.evaluateSingleOperandExpression(
          value,
          node,
          params,
          operand1,
          !!params.includeBlanksInGreaterThan,
          (v, o) => v >= o
        ),
        numOperands: 1
      },
      lessThan: {
        displayValue: translate("advancedFilterLessThan"),
        evaluator: (value, node, params, operand1) => this.evaluateSingleOperandExpression(
          value,
          node,
          params,
          operand1,
          !!params.includeBlanksInLessThan,
          (v, o) => v < o
        ),
        numOperands: 1
      },
      lessThanOrEqual: {
        displayValue: translate("advancedFilterLessThanOrEqual"),
        evaluator: (value, node, params, operand1) => this.evaluateSingleOperandExpression(
          value,
          node,
          params,
          operand1,
          !!params.includeBlanksInLessThan,
          (v, o) => v <= o
        ),
        numOperands: 1
      },
      blank: {
        displayValue: translate("advancedFilterBlank"),
        evaluator: (value) => value == null,
        numOperands: 0
      },
      notBlank: {
        displayValue: translate("advancedFilterNotBlank"),
        evaluator: (value) => value != null,
        numOperands: 0
      }
    };
  }
  evaluateSingleOperandExpression(value, node, params, operand, nullsMatch, expression) {
    if (value == null) {
      return nullsMatch;
    }
    return expression(params.valueConverter(value, node), operand);
  }
};
var BooleanFilterExpressionOperators = class {
  constructor(params) {
    this.params = params;
    this.initOperators();
  }
  getEntries(activeOperators) {
    return getEntries(this.operators, activeOperators);
  }
  findOperator(displayValue) {
    return findMatch(displayValue, this.operators, ({ displayValue: displayValue2 }) => displayValue2);
  }
  initOperators() {
    const { translate } = this.params;
    this.operators = {
      true: {
        displayValue: translate("advancedFilterTrue"),
        evaluator: (value) => !!value,
        numOperands: 0
      },
      false: {
        displayValue: translate("advancedFilterFalse"),
        evaluator: (value) => value === false,
        numOperands: 0
      },
      blank: {
        displayValue: translate("advancedFilterBlank"),
        evaluator: (value) => value == null,
        numOperands: 0
      },
      notBlank: {
        displayValue: translate("advancedFilterNotBlank"),
        evaluator: (value) => value != null,
        numOperands: 0
      }
    };
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/advancedFilterExpressionService.ts
var AdvancedFilterExpressionService = class extends import_ag_grid_community11.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "advFilterExpSvc";
    this.columnNameToIdMap = {};
    this.columnAutocompleteEntries = null;
    this.expressionEvaluatorParams = {};
  }
  wireBeans(beans) {
    this.valueSvc = beans.valueSvc;
    this.colModel = beans.colModel;
    this.colNames = beans.colNames;
    this.dataTypeSvc = beans.dataTypeSvc;
  }
  postConstruct() {
    this.expressionJoinOperators = this.generateExpressionJoinOperators();
    this.expressionOperators = this.generateExpressionOperators();
  }
  parseJoinOperator(model) {
    const { type } = model;
    return this.expressionJoinOperators[type] ?? type;
  }
  getColumnDisplayValue(model) {
    const { colId } = model;
    const columnEntries = this.getColumnAutocompleteEntries();
    const columnEntry = columnEntries.find(({ key }) => key === colId);
    let columnName;
    if (columnEntry) {
      columnName = columnEntry.displayValue;
      this.columnNameToIdMap[columnName.toLocaleUpperCase()] = { colId, columnName };
    } else {
      columnName = colId;
    }
    return columnName;
  }
  getOperatorDisplayValue(model) {
    return this.getExpressionOperator(model.filterType, model.type)?.displayValue ?? model.type;
  }
  getOperandModelValue(operand, baseCellDataType, column) {
    switch (baseCellDataType) {
      case "number":
        return (0, import_ag_grid_community11._exists)(operand) ? Number(operand) : null;
      case "date":
        return (0, import_ag_grid_community11._serialiseDate)(this.valueSvc.parseValue(column, null, operand, void 0), false);
      case "dateString": {
        const parsedDateString = this.valueSvc.parseValue(column, null, operand, void 0);
        return this.dataTypeSvc ? (0, import_ag_grid_community11._serialiseDate)(this.dataTypeSvc.getDateParserFunction(column)(parsedDateString) ?? null, false) : parsedDateString;
      }
    }
    return operand;
  }
  getOperandDisplayValue(model, skipFormatting) {
    const { colId, filter } = model;
    const column = this.colModel.getColDefCol(colId);
    let operand = "";
    if (filter != null) {
      let operand1;
      switch (model.filterType) {
        case "number":
          operand1 = (0, import_ag_grid_community11._toStringOrNull)(filter) ?? "";
          break;
        case "date": {
          const dateValue = (0, import_ag_grid_community11._parseDateTimeFromString)(filter);
          operand1 = column ? this.valueSvc.formatValue(column, null, dateValue) : null;
          break;
        }
        case "dateString": {
          let dateStringStringValue;
          if (this.dataTypeSvc) {
            const dateStringDateValue = (0, import_ag_grid_community11._parseDateTimeFromString)(filter);
            dateStringStringValue = column ? this.dataTypeSvc?.getDateFormatterFunction(column)(dateStringDateValue ?? void 0) : null;
          } else {
            dateStringStringValue = filter;
          }
          operand1 = column ? this.valueSvc.formatValue(column, null, dateStringStringValue) : null;
          break;
        }
      }
      if (model.filterType !== "number") {
        operand1 = operand1 ?? (0, import_ag_grid_community11._toStringOrNull)(filter) ?? "";
        if (!skipFormatting) {
          operand1 = `"${operand1}"`;
        }
      }
      operand = skipFormatting ? operand1 : ` ${operand1}`;
    }
    return operand;
  }
  parseColumnFilterModel(model) {
    const columnName = this.getColumnDisplayValue(model) ?? "";
    const operator = this.getOperatorDisplayValue(model) ?? "";
    const operands = this.getOperandDisplayValue(model);
    return `[${columnName}] ${operator}${operands}`;
  }
  updateAutocompleteCache(updateEntry, type) {
    if (type === "column") {
      const { key: colId, displayValue } = updateEntry;
      this.columnNameToIdMap[updateEntry.displayValue.toLocaleUpperCase()] = {
        colId,
        columnName: displayValue
      };
    }
  }
  translate(key, variableValues) {
    let defaultValue = ADVANCED_FILTER_LOCALE_TEXT[key];
    if (typeof defaultValue === "function") {
      defaultValue = defaultValue(variableValues);
    }
    return this.getLocaleTextFunc()(key, defaultValue, variableValues);
  }
  generateAutocompleteListParams(entries, type, searchString) {
    return {
      enabled: true,
      type,
      searchString,
      entries
    };
  }
  getColumnAutocompleteEntries() {
    if (this.columnAutocompleteEntries) {
      return this.columnAutocompleteEntries;
    }
    const columns = this.colModel.getColDefCols() ?? [];
    const entries = [];
    const includeHiddenColumns = this.gos.get("includeHiddenColumnsInAdvancedFilter");
    columns.forEach((column) => {
      if (column.getColDef().filter && (includeHiddenColumns || column.isVisible() || column.isRowGroupActive())) {
        entries.push({
          key: column.getColId(),
          displayValue: this.colNames.getDisplayNameForColumn(column, "advancedFilter")
        });
      }
    });
    entries.sort((a, b) => {
      const aValue = a.displayValue ?? "";
      const bValue = b.displayValue ?? "";
      if (aValue < bValue) {
        return -1;
      } else if (bValue > aValue) {
        return 1;
      }
      return 0;
    });
    return entries;
  }
  getOperatorAutocompleteEntries(column, baseCellDataType) {
    const activeOperators = this.getActiveOperators(column);
    return this.getDataTypeExpressionOperator(baseCellDataType).getEntries(activeOperators);
  }
  getJoinOperatorAutocompleteEntries() {
    return Object.entries(this.expressionJoinOperators).map(([key, displayValue]) => ({ key, displayValue }));
  }
  getDefaultAutocompleteListParams(searchString) {
    return this.generateAutocompleteListParams(this.getColumnAutocompleteEntries(), "column", searchString);
  }
  getDataTypeExpressionOperator(baseCellDataType) {
    return this.expressionOperators[baseCellDataType];
  }
  getExpressionOperator(baseCellDataType, operator) {
    return this.getDataTypeExpressionOperator(baseCellDataType)?.operators?.[operator];
  }
  getExpressionJoinOperators() {
    return this.expressionJoinOperators;
  }
  getColId(columnName) {
    const upperCaseColumnName = columnName.toLocaleUpperCase();
    const cachedColId = this.columnNameToIdMap[upperCaseColumnName];
    if (cachedColId) {
      return cachedColId;
    }
    const columnAutocompleteEntries = this.getColumnAutocompleteEntries();
    const colEntry = columnAutocompleteEntries.find(
      ({ displayValue }) => displayValue.toLocaleUpperCase() === upperCaseColumnName
    );
    if (colEntry) {
      const { key: colId, displayValue } = colEntry;
      const colValue = { colId, columnName: displayValue };
      this.columnNameToIdMap[upperCaseColumnName] = colValue;
      return colValue;
    }
    return null;
  }
  getExpressionEvaluatorParams(colId) {
    let params = this.expressionEvaluatorParams[colId];
    if (params) {
      return params;
    }
    const column = this.colModel.getColDefCol(colId);
    if (!column) {
      return { valueConverter: (v) => v };
    }
    const baseCellDataType = this.dataTypeSvc?.getBaseDataType(column);
    switch (baseCellDataType) {
      case "dateString":
        params = {
          valueConverter: this.dataTypeSvc?.getDateParserFunction(column) ?? ((v) => v)
        };
        break;
      case "object":
        if (column.getColDef().filterValueGetter) {
          params = { valueConverter: (v) => v };
        } else {
          params = {
            valueConverter: (value, node) => this.valueSvc.formatValue(column, node, value) ?? (typeof value.toString === "function" ? value.toString() : "")
          };
        }
        break;
      case "text":
      case void 0:
        params = { valueConverter: (v) => (0, import_ag_grid_community11._toStringOrNull)(v) };
        break;
      default:
        params = { valueConverter: (v) => v };
        break;
    }
    const { filterParams } = column.getColDef();
    if (filterParams) {
      ["caseSensitive", "includeBlanksInEquals", "includeBlanksInLessThan", "includeBlanksInGreaterThan"].forEach(
        (param) => {
          const paramValue = filterParams[param];
          if (paramValue) {
            params[param] = paramValue;
          }
        }
      );
    }
    this.expressionEvaluatorParams[colId] = params;
    return params;
  }
  getColumnDetails(colId) {
    const column = this.colModel.getColDefCol(colId) ?? void 0;
    const baseCellDataType = (column ? this.dataTypeSvc?.getBaseDataType(column) : void 0) ?? "text";
    return { column, baseCellDataType };
  }
  generateExpressionOperators() {
    const translate = (key, variableValues) => this.translate(key, variableValues);
    return {
      text: new TextFilterExpressionOperators({ translate }),
      boolean: new BooleanFilterExpressionOperators({ translate }),
      object: new TextFilterExpressionOperators({ translate }),
      number: new ScalarFilterExpressionOperators({ translate, equals: (v, o) => v === o }),
      date: new ScalarFilterExpressionOperators({
        translate,
        equals: (v, o) => v.getTime() === o.getTime()
      }),
      dateString: new ScalarFilterExpressionOperators({
        translate,
        equals: (v, o) => v.getTime() === o.getTime()
      })
    };
  }
  getColumnValue({ displayValue }) {
    return `${COL_FILTER_EXPRESSION_START_CHAR}${displayValue}${COL_FILTER_EXPRESSION_END_CHAR}`;
  }
  generateExpressionJoinOperators() {
    return {
      AND: this.translate("advancedFilterAnd"),
      OR: this.translate("advancedFilterOr")
    };
  }
  getActiveOperators(column) {
    const filterOptions = column.getColDef().filterParams?.filterOptions;
    if (!filterOptions) {
      return void 0;
    }
    const isValid = filterOptions.every((filterOption) => typeof filterOption === "string");
    return isValid ? filterOptions : void 0;
  }
  resetColumnCaches() {
    this.columnAutocompleteEntries = null;
    this.columnNameToIdMap = {};
    this.expressionEvaluatorParams = {};
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/advancedFilterService.ts
var import_ag_grid_community38 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/advancedFilter/advancedFilterCtrl.ts
var import_ag_grid_community37 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/widgets/agDialog.ts
var import_ag_grid_community13 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/widgets/agPanel.ts
var import_ag_grid_community12 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/widgets/agPanel.css-GENERATED.ts
var agPanelCSS = (
  /*css*/
  `.ag-panel{background-color:var(--ag-panel-background-color);display:flex;flex-direction:column;overflow:hidden;position:relative}.ag-dialog{border:var(--ag-dialog-border);border-radius:var(--ag-border-radius);box-shadow:var(--ag-dialog-shadow);position:absolute}.ag-panel-title-bar{align-items:center;background-color:var(--ag-panel-title-bar-background-color);border-bottom:var(--ag-panel-title-bar-border);color:var(--ag-panel-title-bar-text-color);cursor:default;display:flex;flex:none;font-weight:var(--ag-panel-title-bar-font-weight);height:var(--ag-header-height);padding:var(--ag-spacing) var(--ag-cell-horizontal-padding)}.ag-panel-title-bar-button{color:var(--ag-panel-title-bar-icon-color);cursor:pointer}:where(.ag-ltr) .ag-panel-title-bar-button{margin-left:calc(var(--ag-spacing)*2);margin-right:var(--ag-spacing)}:where(.ag-rtl) .ag-panel-title-bar-button{margin-left:var(--ag-spacing);margin-right:calc(var(--ag-spacing)*2)}.ag-panel-title-bar-title{flex:1 1 auto}.ag-panel-title-bar-buttons{display:flex}.ag-panel-content-wrapper{display:flex;flex:1 1 auto;overflow:hidden;position:relative}:where(.ag-dragging-fill-handle) .ag-dialog,:where(.ag-dragging-range-handle) .ag-dialog{opacity:.7;pointer-events:none}`
);

// packages/ag-grid-enterprise/src/widgets/agPanel.ts
function getTemplate(config) {
  const cssIdentifier = config.cssIdentifier || "default";
  return (
    /* html */
    `<div class="ag-panel ag-${cssIdentifier}-panel" tabindex="-1">
        <div data-ref="eTitleBar" class="ag-panel-title-bar ag-${cssIdentifier}-panel-title-bar ag-unselectable">
            <span data-ref="eTitle" class="ag-panel-title-bar-title ag-${cssIdentifier}-panel-title-bar-title"></span>
            <div data-ref="eTitleBarButtons" class="ag-panel-title-bar-buttons ag-${cssIdentifier}-panel-title-bar-buttons"></div>
        </div>
        <div data-ref="eContentWrapper" class="ag-panel-content-wrapper ag-${cssIdentifier}-panel-content-wrapper"></div>
    </div>`
  );
}
var CLOSE_BTN_TEMPLATE = (
  /* html */
  `<div class="ag-button"></div>`
);
var AgPanel = class extends import_ag_grid_community12.Component {
  constructor(config) {
    super(getTemplate(config));
    this.config = config;
    this.closable = true;
    this.eContentWrapper = import_ag_grid_community12.RefPlaceholder;
    this.eTitleBar = import_ag_grid_community12.RefPlaceholder;
    this.eTitleBarButtons = import_ag_grid_community12.RefPlaceholder;
    this.eTitle = import_ag_grid_community12.RefPlaceholder;
    this.registerCSS(agPanelCSS);
  }
  postConstruct() {
    const {
      component,
      closable,
      hideTitleBar,
      title,
      minWidth = 250,
      width,
      minHeight = 250,
      height,
      centered,
      popup,
      x,
      y
    } = this.config;
    this.positionableFeature = new import_ag_grid_community12.PositionableFeature(this.getGui(), {
      minWidth,
      width,
      minHeight,
      height,
      centered,
      x,
      y,
      popup,
      calculateTopBuffer: () => this.positionableFeature.getHeight() - this.getBodyHeight()
    });
    this.createManagedBean(this.positionableFeature);
    const eGui = this.getGui();
    if (component) {
      this.setBodyComponent(component);
    }
    if (!hideTitleBar) {
      if (title) {
        this.setTitle(title);
      }
      this.setClosable(closable != null ? closable : this.closable);
    } else {
      (0, import_ag_grid_community12._setDisplayed)(this.eTitleBar, false);
    }
    this.addManagedElementListeners(this.eTitleBar, {
      mousedown: (e) => {
        if (eGui.contains(e.relatedTarget) || eGui.contains((0, import_ag_grid_community12._getActiveDomElement)(this.beans)) || this.eTitleBarButtons.contains(e.target)) {
          e.preventDefault();
          return;
        }
        const focusEl = this.eContentWrapper.querySelector(
          "button, [href], input, select, textarea, [tabindex]"
        );
        if (focusEl) {
          focusEl.focus();
        }
      }
    });
    if (popup && this.positionableFeature.isPositioned()) {
      return;
    }
    if (this.renderComponent) {
      this.renderComponent();
    }
    this.positionableFeature.initialisePosition();
    this.eContentWrapper.style.height = "0";
  }
  renderComponent() {
    const eGui = this.getGui();
    eGui.focus();
    this.close = () => {
      eGui.parentElement.removeChild(eGui);
      this.destroy();
    };
  }
  getHeight() {
    return this.positionableFeature.getHeight();
  }
  setHeight(height) {
    this.positionableFeature.setHeight(height);
  }
  getWidth() {
    return this.positionableFeature.getWidth();
  }
  setWidth(width) {
    this.positionableFeature.setWidth(width);
  }
  setClosable(closable) {
    if (closable !== this.closable) {
      this.closable = closable;
    }
    if (closable) {
      const closeButtonComp = this.closeButtonComp = new import_ag_grid_community12.Component(CLOSE_BTN_TEMPLATE);
      this.createBean(closeButtonComp);
      const eGui = closeButtonComp.getGui();
      const child = (0, import_ag_grid_community12._createIconNoSpan)("close", this.beans);
      child.classList.add("ag-panel-title-bar-button-icon");
      eGui.appendChild(child);
      this.addTitleBarButton(closeButtonComp);
      closeButtonComp.addManagedElementListeners(eGui, { click: this.onBtClose.bind(this) });
    } else if (this.closeButtonComp) {
      const eGui = this.closeButtonComp.getGui();
      eGui.parentElement.removeChild(eGui);
      this.closeButtonComp = this.destroyBean(this.closeButtonComp);
    }
  }
  setBodyComponent(bodyComponent) {
    bodyComponent.setParentComponent(this);
    this.eContentWrapper.appendChild(bodyComponent.getGui());
  }
  addTitleBarButton(button, position) {
    const eTitleBarButtons = this.eTitleBarButtons;
    const buttons = eTitleBarButtons.children;
    const len = buttons.length;
    if (position == null) {
      position = len;
    }
    position = Math.max(0, Math.min(position, len));
    button.addCssClass("ag-panel-title-bar-button");
    const eGui = button.getGui();
    if (position === 0) {
      eTitleBarButtons.insertAdjacentElement("afterbegin", eGui);
    } else if (position === len) {
      eTitleBarButtons.insertAdjacentElement("beforeend", eGui);
    } else {
      buttons[position - 1].insertAdjacentElement("afterend", eGui);
    }
    button.setParentComponent(this);
  }
  getBodyHeight() {
    return (0, import_ag_grid_community12._getInnerHeight)(this.eContentWrapper);
  }
  getBodyWidth() {
    return (0, import_ag_grid_community12._getInnerWidth)(this.eContentWrapper);
  }
  setTitle(title) {
    this.eTitle.innerText = title;
  }
  // called when user hits the 'x' in the top right
  onBtClose() {
    this.close();
  }
  destroy() {
    if (this.closeButtonComp) {
      this.closeButtonComp = this.destroyBean(this.closeButtonComp);
    }
    const eGui = this.getGui();
    if (eGui && (0, import_ag_grid_community12._isVisible)(eGui)) {
      this.close();
    }
    super.destroy();
  }
};

// packages/ag-grid-enterprise/src/widgets/agDialog.ts
var AgDialog = class extends AgPanel {
  constructor(config) {
    super({ ...config, popup: true });
    this.isMaximizable = false;
    this.isMaximized = false;
    this.maximizeListeners = [];
    this.resizeListenerDestroy = null;
    this.lastPosition = {
      x: 0,
      y: 0,
      width: 0,
      height: 0
    };
  }
  wireBeans(beans) {
    this.popupSvc = beans.popupSvc;
  }
  postConstruct() {
    const eGui = this.getGui();
    const { movable, resizable, maximizable, modal, postProcessPopupParams } = this.config;
    this.addCssClass("ag-dialog");
    super.postConstruct();
    if (postProcessPopupParams) {
      const { type, eventSource, column, mouseEvent, rowNode } = postProcessPopupParams;
      this.popupSvc?.callPostProcessPopup(type, eGui, eventSource, mouseEvent, column, rowNode);
    }
    this.tabGuardFeature = this.createManagedBean(new import_ag_grid_community13.TabGuardFeature(this));
    this.tabGuardFeature.initialiseTabGuard({
      isFocusableContainer: true,
      onFocusIn: () => {
        this.popupSvc?.bringPopupToFront(eGui);
      },
      onTabKeyDown: (e) => {
        if (modal) {
          return;
        }
        const backwards = e.shiftKey;
        const nextFocusableElement = (0, import_ag_grid_community13._findNextFocusableElement)(this.beans, eGui, false, backwards);
        if (!nextFocusableElement || this.tabGuardFeature.getTabGuardCtrl().isTabGuard(nextFocusableElement)) {
          if ((0, import_ag_grid_community13._focusNextGridCoreContainer)(this.beans, backwards)) {
            e.preventDefault();
          }
        }
      }
    });
    if (movable) {
      this.setMovable(movable);
    }
    if (maximizable) {
      this.setMaximizable(maximizable);
    }
    if (resizable) {
      this.setResizable(resizable);
    }
    if (!this.config.modal) {
      const gridCtrl = this.beans.ctrlsSvc.get("gridCtrl");
      gridCtrl.addFocusableContainer(this);
      this.addDestroyFunc(() => gridCtrl.removeFocusableContainer(this));
    }
  }
  setAllowFocus(allowFocus) {
    this.tabGuardFeature.getTabGuardCtrl().setAllowFocus(allowFocus);
  }
  renderComponent() {
    const eGui = this.getGui();
    const { alwaysOnTop, modal, title, afterGuiAttached } = this.config;
    const translate = this.getLocaleTextFunc();
    const addPopupRes = this.popupSvc?.addPopup({
      modal,
      eChild: eGui,
      closeOnEsc: true,
      closedCallback: this.onClosed.bind(this),
      alwaysOnTop,
      ariaLabel: title || translate("ariaLabelDialog", "Dialog"),
      afterGuiAttached
    });
    if (addPopupRes) {
      this.close = addPopupRes.hideFunc;
    }
  }
  onClosed(event) {
    this.destroy();
    this.config.closedCallback?.(event);
  }
  toggleMaximize() {
    const position = this.positionableFeature.getPosition();
    if (this.isMaximized) {
      const { x, y, width, height } = this.lastPosition;
      this.setWidth(width);
      this.setHeight(height);
      this.positionableFeature.offsetElement(x, y);
    } else {
      this.lastPosition.width = this.getWidth();
      this.lastPosition.height = this.getHeight();
      this.lastPosition.x = position.x;
      this.lastPosition.y = position.y;
      this.positionableFeature.offsetElement(0, 0);
      this.setHeight("100%");
      this.setWidth("100%");
    }
    this.isMaximized = !this.isMaximized;
    this.refreshMaximizeIcon();
  }
  refreshMaximizeIcon() {
    (0, import_ag_grid_community13._setDisplayed)(this.maximizeIcon, !this.isMaximized);
    (0, import_ag_grid_community13._setDisplayed)(this.minimizeIcon, this.isMaximized);
  }
  clearMaximizebleListeners() {
    if (this.maximizeListeners.length) {
      this.maximizeListeners.forEach((destroyListener) => destroyListener());
      this.maximizeListeners.length = 0;
    }
    if (this.resizeListenerDestroy) {
      this.resizeListenerDestroy();
      this.resizeListenerDestroy = null;
    }
  }
  destroy() {
    this.maximizeButtonComp = this.destroyBean(this.maximizeButtonComp);
    this.clearMaximizebleListeners();
    super.destroy();
  }
  setResizable(resizable) {
    this.positionableFeature.setResizable(resizable);
  }
  setMovable(movable) {
    this.positionableFeature.setMovable(movable, this.eTitleBar);
  }
  setMaximizable(maximizable) {
    if (!maximizable) {
      this.clearMaximizebleListeners();
      if (this.maximizeButtonComp) {
        this.destroyBean(this.maximizeButtonComp);
        this.maximizeButtonComp = this.maximizeIcon = this.minimizeIcon = void 0;
      }
      return;
    }
    const eTitleBar = this.eTitleBar;
    if (!eTitleBar || maximizable === this.isMaximizable) {
      return;
    }
    const maximizeButtonComp = this.buildMaximizeAndMinimizeElements();
    this.refreshMaximizeIcon();
    maximizeButtonComp.addManagedElementListeners(maximizeButtonComp.getGui(), {
      click: this.toggleMaximize.bind(this)
    });
    this.addTitleBarButton(maximizeButtonComp, 0);
    this.maximizeListeners.push(
      ...this.addManagedElementListeners(eTitleBar, {
        dblclick: this.toggleMaximize.bind(this)
      })
    );
    [this.resizeListenerDestroy] = this.addManagedListeners(this.positionableFeature, {
      resize: () => {
        this.isMaximized = false;
        this.refreshMaximizeIcon();
      }
    });
  }
  buildMaximizeAndMinimizeElements() {
    const maximizeButtonComp = this.maximizeButtonComp = this.createBean(
      new import_ag_grid_community13.Component(
        /* html */
        `<div class="ag-dialog-button"></span>`
      )
    );
    const eGui = maximizeButtonComp.getGui();
    this.maximizeIcon = (0, import_ag_grid_community13._createIconNoSpan)("maximize", this.beans);
    eGui.appendChild(this.maximizeIcon);
    this.maximizeIcon.classList.add("ag-panel-title-bar-button-icon");
    this.minimizeIcon = (0, import_ag_grid_community13._createIconNoSpan)("minimize", this.beans);
    eGui.appendChild(this.minimizeIcon);
    this.minimizeIcon.classList.add("ag-panel-title-bar-button-icon");
    return maximizeButtonComp;
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/advancedFilterComp.ts
var import_ag_grid_community18 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/advancedFilter/autocomplete/agAutocomplete.ts
var import_ag_grid_community17 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/advancedFilter/autocomplete/agAutocomplete.css-GENERATED.ts
var agAutocompleteCSS = (
  /*css*/
  `.ag-autocomplete{align-items:center;display:flex;width:100%;>*{flex:1 1 auto}}.ag-autocomplete-list-popup{background-color:var(--ag-background-color);border-radius:var(--ag-border-radius);box-shadow:var(--ag-dropdown-shadow);padding:0;position:absolute;-webkit-user-select:none;-moz-user-select:none;user-select:none}.ag-autocomplete-list{height:calc(var(--ag-row-height)*6.5);min-width:200px;position:relative;width:100%}.ag-autocomplete-virtual-list-item{cursor:default;display:flex;height:var(--ag-list-item-height);&:focus-visible:after{content:none}&:hover{background-color:var(--ag-row-hover-color)}}.ag-autocomplete-row{align-items:center;display:flex;flex:1 1 auto;overflow:hidden}.ag-autocomplete-row-label{margin:0 var(--ag-widget-container-horizontal-padding);overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.ag-autocomplete-row-selected{background-color:var(--ag-selected-row-background-color)}`
);

// packages/ag-grid-enterprise/src/advancedFilter/autocomplete/agAutocompleteList.ts
var import_ag_grid_community16 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/widgets/virtualList.ts
var import_ag_grid_community14 = require("ag-grid-community");
function getVirtualListTemplate(cssIdentifier) {
  return (
    /* html */
    `<div class="ag-virtual-list-viewport ag-${cssIdentifier}-virtual-list-viewport" role="presentation">
            <div class="ag-virtual-list-container ag-${cssIdentifier}-virtual-list-container" data-ref="eContainer"></div>
        </div>`
  );
}
var VirtualList = class extends import_ag_grid_community14.TabGuardComp {
  constructor(params) {
    super(getVirtualListTemplate(params?.cssIdentifier || "default"));
    this.renderedRows = /* @__PURE__ */ new Map();
    this.rowHeight = 20;
    this.pageSize = -1;
    this.isScrolling = false;
    this.isHeightFromTheme = true;
    this.eContainer = import_ag_grid_community14.RefPlaceholder;
    this.awaitStableCallbacks = [];
    const { cssIdentifier = "default", ariaRole = "listbox", listName } = params || {};
    this.cssIdentifier = cssIdentifier;
    this.ariaRole = ariaRole;
    this.listName = listName;
  }
  wireBeans(beans) {
    this.environment = beans.environment;
  }
  postConstruct() {
    this.addScrollListener();
    this.rowHeight = this.getItemHeight();
    this.addResizeObserver();
    this.initialiseTabGuard({
      onFocusIn: (e) => this.onFocusIn(e),
      onFocusOut: (e) => this.onFocusOut(e),
      focusInnerElement: (fromBottom) => this.focusInnerElement(fromBottom),
      onTabKeyDown: (e) => this.onTabKeyDown(e),
      handleKeyDown: (e) => this.handleKeyDown(e)
    });
    this.setAriaProperties();
    this.addManagedEventListeners({ gridStylesChanged: this.onGridStylesChanged.bind(this) });
  }
  onGridStylesChanged(e) {
    if (e.listItemHeightChanged) {
      this.rowHeight = this.getItemHeight();
      this.refresh();
    }
  }
  setAriaProperties() {
    const translate = this.getLocaleTextFunc();
    const listName = translate("ariaDefaultListName", this.listName || "List");
    const ariaEl = this.eContainer;
    (0, import_ag_grid_community14._setAriaRole)(ariaEl, this.ariaRole);
    (0, import_ag_grid_community14._setAriaLabel)(ariaEl, listName);
  }
  addResizeObserver() {
    const listener = () => (0, import_ag_grid_community14._requestAnimationFrame)(this.beans, () => this.drawVirtualRows());
    const destroyObserver = (0, import_ag_grid_community14._observeResize)(this.beans, this.getGui(), listener);
    this.addDestroyFunc(destroyObserver);
  }
  focusInnerElement(fromBottom) {
    this.focusRow(fromBottom ? this.model.getRowCount() - 1 : 0);
    return true;
  }
  onFocusIn(e) {
    const target = e.target;
    if (target.classList.contains("ag-virtual-list-item")) {
      this.lastFocusedRowIndex = (0, import_ag_grid_community14._getAriaPosInSet)(target) - 1;
    }
  }
  onFocusOut(e) {
    if (!this.getFocusableElement().contains(e.relatedTarget)) {
      this.lastFocusedRowIndex = null;
    }
  }
  handleKeyDown(e) {
    switch (e.key) {
      case import_ag_grid_community14.KeyCode.UP:
      case import_ag_grid_community14.KeyCode.DOWN:
        e.preventDefault();
        this.navigate(e.key === import_ag_grid_community14.KeyCode.UP);
        break;
      case import_ag_grid_community14.KeyCode.PAGE_HOME:
      case import_ag_grid_community14.KeyCode.PAGE_END:
      case import_ag_grid_community14.KeyCode.PAGE_UP:
      case import_ag_grid_community14.KeyCode.PAGE_DOWN:
        if (this.navigateToPage(e.key) !== null) {
          e.preventDefault();
        }
        break;
    }
  }
  onTabKeyDown(e) {
    (0, import_ag_grid_community14._stopPropagationForAgGrid)(e);
    this.forceFocusOutOfContainer(e.shiftKey);
  }
  navigate(up) {
    if (this.lastFocusedRowIndex == null) {
      return;
    }
    const nextRow = this.lastFocusedRowIndex + (up ? -1 : 1);
    if (nextRow < 0 || nextRow >= this.model.getRowCount()) {
      return;
    }
    this.focusRow(nextRow);
  }
  navigateToPage(key, fromItem = "focused") {
    let hasFocus = false;
    if (fromItem === "focused") {
      fromItem = this.getLastFocusedRow();
      hasFocus = true;
    }
    const rowCount = this.model.getRowCount() - 1;
    let newIndex = -1;
    if (key === import_ag_grid_community14.KeyCode.PAGE_HOME) {
      newIndex = 0;
    } else if (key === import_ag_grid_community14.KeyCode.PAGE_END) {
      newIndex = rowCount;
    } else if (key === import_ag_grid_community14.KeyCode.PAGE_DOWN) {
      newIndex = Math.min(fromItem + this.pageSize, rowCount);
    } else if (key === import_ag_grid_community14.KeyCode.PAGE_UP) {
      newIndex = Math.max(fromItem - this.pageSize, 0);
    }
    if (newIndex === -1) {
      return null;
    }
    if (hasFocus) {
      this.focusRow(newIndex);
    } else {
      this.ensureIndexVisible(newIndex);
    }
    return newIndex;
  }
  getLastFocusedRow() {
    return this.lastFocusedRowIndex;
  }
  focusRow(rowNumber) {
    if (this.isScrolling) {
      return;
    }
    this.isScrolling = true;
    this.ensureIndexVisible(rowNumber);
    (0, import_ag_grid_community14._requestAnimationFrame)(this.beans, () => {
      this.isScrolling = false;
      if (!this.isAlive()) {
        return;
      }
      const renderedRow = this.renderedRows.get(rowNumber);
      if (renderedRow) {
        renderedRow.eDiv.focus();
      }
    });
  }
  getComponentAt(rowIndex) {
    const comp = this.renderedRows.get(rowIndex);
    return comp && comp.rowComponent;
  }
  forEachRenderedRow(func) {
    this.renderedRows.forEach((value, key) => func(value.rowComponent, key));
  }
  getItemHeight() {
    if (!this.isHeightFromTheme) {
      return this.rowHeight;
    }
    return this.environment.getDefaultListItemHeight();
  }
  /**
   * Returns true if the view had to be scrolled, otherwise, false.
   */
  ensureIndexVisible(index, scrollPartialIntoView = true) {
    const lastRow = this.model.getRowCount();
    if (typeof index !== "number" || index < 0 || index >= lastRow) {
      (0, import_ag_grid_community14._warn)(229, { index });
      return false;
    }
    const rowTopPixel = index * this.rowHeight;
    const rowBottomPixel = rowTopPixel + this.rowHeight;
    const eGui = this.getGui();
    const viewportTopPixel = eGui.scrollTop;
    const viewportHeight = eGui.offsetHeight;
    const viewportBottomPixel = viewportTopPixel + viewportHeight;
    const diff = scrollPartialIntoView ? 0 : this.rowHeight;
    const viewportScrolledPastRow = viewportTopPixel > rowTopPixel + diff;
    const viewportScrolledBeforeRow = viewportBottomPixel < rowBottomPixel - diff;
    if (viewportScrolledPastRow) {
      eGui.scrollTop = rowTopPixel;
      return true;
    }
    if (viewportScrolledBeforeRow) {
      const newScrollPosition = rowBottomPixel - viewportHeight;
      eGui.scrollTop = newScrollPosition;
      return true;
    }
    return false;
  }
  setComponentCreator(componentCreator) {
    this.componentCreator = componentCreator;
  }
  setComponentUpdater(componentUpdater) {
    this.componentUpdater = componentUpdater;
  }
  getRowHeight() {
    return this.rowHeight;
  }
  getScrollTop() {
    return this.getGui().scrollTop;
  }
  setRowHeight(rowHeight) {
    this.isHeightFromTheme = false;
    this.rowHeight = rowHeight;
    this.refresh();
  }
  refresh(softRefresh) {
    if (this.model == null || !this.isAlive()) {
      return;
    }
    const rowCount = this.model.getRowCount();
    this.eContainer.style.height = `${rowCount * this.rowHeight}px`;
    this.awaitStable(() => {
      if (!this.isAlive()) {
        return;
      }
      if (this.canSoftRefresh(softRefresh)) {
        this.drawVirtualRows(true);
      } else {
        this.clearVirtualRows();
        this.drawVirtualRows();
      }
    });
  }
  awaitStable(callback) {
    this.awaitStableCallbacks.push(callback);
    if (this.awaitStableCallbacks.length > 1) {
      return;
    }
    const rowCount = this.model.getRowCount();
    (0, import_ag_grid_community14._waitUntil)(
      () => this.eContainer.clientHeight >= rowCount * this.rowHeight,
      () => {
        if (!this.isAlive()) {
          return;
        }
        const callbacks = this.awaitStableCallbacks;
        this.awaitStableCallbacks = [];
        callbacks.forEach((c) => c());
      }
    );
  }
  canSoftRefresh(softRefresh) {
    return !!(softRefresh && this.renderedRows.size && typeof this.model.areRowsEqual === "function" && this.componentUpdater);
  }
  clearVirtualRows() {
    this.renderedRows.forEach((_, rowIndex) => this.removeRow(rowIndex));
  }
  drawVirtualRows(softRefresh) {
    if (!this.isAlive() || !this.model) {
      return;
    }
    const gui = this.getGui();
    const topPixel = gui.scrollTop;
    const bottomPixel = topPixel + gui.offsetHeight;
    const firstRow = Math.floor(topPixel / this.rowHeight);
    const lastRow = Math.floor(bottomPixel / this.rowHeight);
    this.pageSize = Math.floor((bottomPixel - topPixel) / this.rowHeight);
    this.ensureRowsRendered(firstRow, lastRow, softRefresh);
  }
  ensureRowsRendered(start, finish, softRefresh) {
    this.renderedRows.forEach((_, rowIndex) => {
      if ((rowIndex < start || rowIndex > finish) && rowIndex !== this.lastFocusedRowIndex) {
        this.removeRow(rowIndex);
      }
    });
    if (softRefresh) {
      this.refreshRows();
    }
    for (let rowIndex = start; rowIndex <= finish; rowIndex++) {
      if (this.renderedRows.has(rowIndex)) {
        continue;
      }
      if (rowIndex < this.model.getRowCount()) {
        this.insertRow(rowIndex);
      }
    }
  }
  insertRow(rowIndex) {
    const value = this.model.getRow(rowIndex);
    const eDiv = document.createElement("div");
    eDiv.classList.add("ag-virtual-list-item", `ag-${this.cssIdentifier}-virtual-list-item`);
    (0, import_ag_grid_community14._setAriaRole)(eDiv, this.ariaRole === "tree" ? "treeitem" : "option");
    (0, import_ag_grid_community14._setAriaSetSize)(eDiv, this.model.getRowCount());
    (0, import_ag_grid_community14._setAriaPosInSet)(eDiv, rowIndex + 1);
    eDiv.setAttribute("tabindex", "-1");
    eDiv.style.height = `${this.rowHeight}px`;
    eDiv.style.top = `${this.rowHeight * rowIndex}px`;
    const rowComponent = this.componentCreator(value, eDiv);
    rowComponent.addGuiEventListener("focusin", () => this.lastFocusedRowIndex = rowIndex);
    eDiv.appendChild(rowComponent.getGui());
    if (this.renderedRows.has(rowIndex - 1)) {
      this.renderedRows.get(rowIndex - 1).eDiv.insertAdjacentElement("afterend", eDiv);
    } else if (this.renderedRows.has(rowIndex + 1)) {
      this.renderedRows.get(rowIndex + 1).eDiv.insertAdjacentElement("beforebegin", eDiv);
    } else {
      this.eContainer.appendChild(eDiv);
    }
    this.renderedRows.set(rowIndex, { rowComponent, eDiv, value });
  }
  removeRow(rowIndex) {
    const component = this.renderedRows.get(rowIndex);
    this.eContainer.removeChild(component.eDiv);
    this.destroyBean(component.rowComponent);
    this.renderedRows.delete(rowIndex);
  }
  refreshRows() {
    const rowCount = this.model.getRowCount();
    this.renderedRows.forEach((row, rowIndex) => {
      if (rowIndex >= rowCount) {
        this.removeRow(rowIndex);
      } else {
        const newValue = this.model.getRow(rowIndex);
        if (this.model.areRowsEqual?.(row.value, newValue)) {
          this.componentUpdater(newValue, row.rowComponent);
        } else {
          this.removeRow(rowIndex);
        }
      }
    });
  }
  addScrollListener() {
    this.addGuiEventListener("scroll", () => this.drawVirtualRows(), { passive: true });
  }
  setModel(model) {
    this.model = model;
  }
  getAriaElement() {
    return this.eContainer;
  }
  destroy() {
    if (!this.isAlive()) {
      return;
    }
    this.clearVirtualRows();
    this.awaitStableCallbacks.length = 0;
    super.destroy();
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/autocomplete/agAutocompleteRow.ts
var import_ag_grid_community15 = require("ag-grid-community");
var AgAutocompleteRow = class extends import_ag_grid_community15.Component {
  constructor() {
    super(
      /* html */
      `
        <div class="ag-autocomplete-row" role="presentation">
            <div class="ag-autocomplete-row-label"></div>
        </div>`
    );
    this.hasHighlighting = false;
  }
  setState(value, selected) {
    this.value = value;
    this.render();
    this.updateSelected(selected);
  }
  updateSelected(selected) {
    this.addOrRemoveCssClass("ag-autocomplete-row-selected", selected);
  }
  setSearchString(searchString) {
    let keepHighlighting = false;
    if ((0, import_ag_grid_community15._exists)(searchString)) {
      const index = this.value?.toLocaleLowerCase().indexOf(searchString.toLocaleLowerCase());
      if (index >= 0) {
        keepHighlighting = true;
        this.hasHighlighting = true;
        const highlightEndIndex = index + searchString.length;
        const startPart = (0, import_ag_grid_community15._escapeString)(this.value.slice(0, index));
        const highlightedPart = (0, import_ag_grid_community15._escapeString)(this.value.slice(index, highlightEndIndex));
        const endPart = (0, import_ag_grid_community15._escapeString)(this.value.slice(highlightEndIndex));
        this.getGui().lastElementChild.innerHTML = `${startPart}<b>${highlightedPart}</b>${endPart}`;
      }
    }
    if (!keepHighlighting && this.hasHighlighting) {
      this.hasHighlighting = false;
      this.render();
    }
  }
  render() {
    this.getGui().lastElementChild.innerHTML = (0, import_ag_grid_community15._escapeString)(this.value) ?? "&nbsp;";
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/autocomplete/agAutocompleteList.ts
var AgAutocompleteList = class extends import_ag_grid_community16.PopupComponent {
  constructor(params) {
    super(
      /* html */
      `<div class="ag-autocomplete-list-popup">
            <div data-ref="eList" class="ag-autocomplete-list"></div>
        <div>`
    );
    this.params = params;
    this.eList = import_ag_grid_community16.RefPlaceholder;
    this.searchString = "";
  }
  postConstruct() {
    this.autocompleteEntries = this.params.autocompleteEntries;
    this.virtualList = this.createManagedBean(new VirtualList({ cssIdentifier: "autocomplete" }));
    this.virtualList.setComponentCreator(this.createRowComponent.bind(this));
    this.eList.appendChild(this.virtualList.getGui());
    this.virtualList.setModel({
      getRowCount: () => this.autocompleteEntries.length,
      getRow: (index) => this.autocompleteEntries[index]
    });
    const virtualListGui = this.virtualList.getGui();
    this.addManagedListeners(virtualListGui, {
      click: () => this.params.onConfirmed(),
      mousemove: this.onMouseMove.bind(this),
      mousedown: (e) => e.preventDefault()
    });
    this.setSelectedValue(0);
  }
  onNavigationKeyDown(event, key) {
    event.preventDefault();
    const oldIndex = this.autocompleteEntries.indexOf(this.selectedValue);
    const newIndex = key === import_ag_grid_community16.KeyCode.UP ? oldIndex - 1 : oldIndex + 1;
    this.checkSetSelectedValue(newIndex);
  }
  setSearch(searchString) {
    this.searchString = searchString;
    if ((0, import_ag_grid_community16._exists)(searchString)) {
      this.runSearch();
    } else {
      this.autocompleteEntries = this.params.autocompleteEntries;
      this.virtualList.refresh();
      this.checkSetSelectedValue(0);
    }
    this.updateSearchInList();
  }
  runContainsSearch(searchString, searchStrings) {
    let topMatch;
    let topMatchStartsWithSearchString = false;
    const lowerCaseSearchString = searchString.toLocaleLowerCase();
    const allMatches = searchStrings.filter((string) => {
      const lowerCaseString = string.toLocaleLowerCase();
      const index = lowerCaseString.indexOf(lowerCaseSearchString);
      const startsWithSearchString = index === 0;
      const isMatch = index >= 0;
      if (isMatch && (!topMatch || !topMatchStartsWithSearchString && startsWithSearchString || topMatchStartsWithSearchString === startsWithSearchString && string.length < topMatch.length)) {
        topMatch = string;
        topMatchStartsWithSearchString = startsWithSearchString;
      }
      return isMatch;
    });
    if (!topMatch && allMatches.length) {
      topMatch = allMatches[0];
    }
    return { topMatch, allMatches };
  }
  runSearch() {
    const { autocompleteEntries, useFuzzySearch, forceLastSelection } = this.params;
    const searchStrings = autocompleteEntries.map((v) => v.displayValue ?? v.key);
    let matchingStrings;
    let topSuggestion;
    if (useFuzzySearch) {
      matchingStrings = (0, import_ag_grid_community16._fuzzySuggestions)({
        inputValue: this.searchString,
        allSuggestions: searchStrings,
        hideIrrelevant: true,
        addSequentialWeight: true
      }).values;
      topSuggestion = matchingStrings.length ? matchingStrings[0] : void 0;
    } else {
      const containsMatches = this.runContainsSearch(this.searchString, searchStrings);
      matchingStrings = containsMatches.allMatches;
      topSuggestion = containsMatches.topMatch;
    }
    let filteredEntries = autocompleteEntries.filter(
      ({ key, displayValue }) => matchingStrings.includes(displayValue ?? key)
    );
    if (!filteredEntries.length && this.selectedValue && forceLastSelection?.(this.selectedValue, this.searchString)) {
      filteredEntries = [this.selectedValue];
    }
    this.autocompleteEntries = filteredEntries;
    this.virtualList.refresh();
    if (!topSuggestion) {
      return;
    }
    const topSuggestionIndex = matchingStrings.indexOf(topSuggestion);
    this.checkSetSelectedValue(topSuggestionIndex);
  }
  updateSearchInList() {
    this.virtualList.forEachRenderedRow((row) => row.setSearchString(this.searchString));
  }
  checkSetSelectedValue(index) {
    if (index >= 0 && index < this.autocompleteEntries.length) {
      this.setSelectedValue(index);
    }
  }
  setSelectedValue(index) {
    const value = this.autocompleteEntries[index];
    if (this.selectedValue === value) {
      return;
    }
    this.selectedValue = value;
    this.virtualList.ensureIndexVisible(index);
    this.virtualList.forEachRenderedRow((cmp, idx) => {
      cmp.updateSelected(index === idx);
    });
  }
  createRowComponent(value) {
    const row = new AgAutocompleteRow();
    this.createBean(row);
    row.setState(value.displayValue ?? value.key, value === this.selectedValue);
    return row;
  }
  onMouseMove(mouseEvent) {
    const virtualList = this.virtualList;
    const rect = virtualList.getGui().getBoundingClientRect();
    const scrollTop = virtualList.getScrollTop();
    const mouseY = mouseEvent.clientY - rect.top + scrollTop;
    const row = Math.floor(mouseY / virtualList.getRowHeight());
    this.checkSetSelectedValue(row);
  }
  afterGuiAttached() {
    this.virtualList.refresh();
  }
  getSelectedValue() {
    if (!this.autocompleteEntries.length) {
      return null;
    }
    return this.selectedValue ?? null;
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/autocomplete/agAutocomplete.ts
var AgAutocomplete = class extends import_ag_grid_community17.Component {
  constructor() {
    super(
      /* html */
      `
            <div class="ag-autocomplete" role="presentation">
                <ag-input-text-field data-ref="eAutocompleteInput"></ag-input-text-field>
            </div>`,
      [import_ag_grid_community17.AgInputTextFieldSelector]
    );
    this.eAutocompleteInput = import_ag_grid_community17.RefPlaceholder;
    this.isListOpen = false;
    this.lastPosition = 0;
    this.valid = true;
    this.registerCSS(agAutocompleteCSS);
  }
  wireBeans(beans) {
    this.popupSvc = beans.popupSvc;
  }
  postConstruct() {
    this.eAutocompleteInput.onValueChange((value) => this.onValueChanged(value));
    this.eAutocompleteInput.getInputElement().setAttribute("autocomplete", "off");
    this.addGuiEventListener("keydown", this.onKeyDown.bind(this));
    this.addGuiEventListener("click", this.updatePositionAndList.bind(this));
    this.addDestroyFunc(() => {
      this.destroyBean(this.autocompleteList);
    });
    this.addGuiEventListener("focusout", () => this.onFocusOut());
  }
  onValueChanged(value) {
    const parsedValue = (0, import_ag_grid_community17._makeNull)(value);
    this.updateValue(parsedValue);
    this.updateAutocompleteList(parsedValue);
  }
  updateValue(value) {
    this.updateLastPosition();
    this.dispatchLocalEvent({
      type: "eventValueChanged",
      value
    });
    this.validate(value);
  }
  updateAutocompleteList(value) {
    const autocompleteListParams = this.listGenerator?.(value, this.lastPosition) ?? { enabled: false };
    if (!autocompleteListParams.type || autocompleteListParams.type !== this.autocompleteListParams?.type) {
      if (this.isListOpen) {
        this.closeList();
      }
    }
    const isListOpen = this.isListOpen;
    this.autocompleteListParams = autocompleteListParams;
    if (autocompleteListParams?.enabled) {
      if (!isListOpen) {
        this.openList();
      }
      const { searchString } = autocompleteListParams;
      this.autocompleteList.setSearch(searchString ?? "");
    } else {
      if (isListOpen) {
        this.closeList();
      }
    }
  }
  onKeyDown(event) {
    const key = event.key;
    this.updateLastPosition();
    switch (key) {
      case import_ag_grid_community17.KeyCode.ENTER:
        this.onEnterKeyDown(event);
        break;
      case import_ag_grid_community17.KeyCode.TAB:
        this.onTabKeyDown(event);
        break;
      case import_ag_grid_community17.KeyCode.DOWN:
      case import_ag_grid_community17.KeyCode.UP:
        this.onUpDownKeyDown(event, key);
        break;
      case import_ag_grid_community17.KeyCode.LEFT:
      case import_ag_grid_community17.KeyCode.RIGHT:
      case import_ag_grid_community17.KeyCode.PAGE_HOME:
      case import_ag_grid_community17.KeyCode.PAGE_END:
        setTimeout(() => {
          this.updatePositionAndList();
        });
        break;
      case import_ag_grid_community17.KeyCode.ESCAPE:
        this.onEscapeKeyDown(event);
        break;
      case import_ag_grid_community17.KeyCode.SPACE:
        if (event.ctrlKey && !this.isListOpen) {
          event.preventDefault();
          this.forceOpenList();
        }
        break;
    }
  }
  confirmSelection() {
    const selectedValue = this.autocompleteList?.getSelectedValue();
    if (selectedValue) {
      this.closeList();
      this.dispatchLocalEvent({
        type: "eventOptionSelected",
        value: this.getValue(),
        position: this.lastPosition,
        updateEntry: selectedValue,
        autocompleteType: this.autocompleteListParams.type
      });
    }
  }
  onTabKeyDown(event) {
    if (this.isListOpen) {
      event.preventDefault();
      event.stopPropagation();
      this.confirmSelection();
    }
  }
  onEnterKeyDown(event) {
    event.preventDefault();
    if (this.isListOpen) {
      this.confirmSelection();
    } else {
      this.onCompleted();
    }
  }
  onUpDownKeyDown(event, key) {
    event.preventDefault();
    if (!this.isListOpen) {
      this.forceOpenList();
    } else {
      this.autocompleteList?.onNavigationKeyDown(event, key);
    }
  }
  onEscapeKeyDown(event) {
    if (this.isListOpen) {
      event.preventDefault();
      event.stopPropagation();
      this.closeList();
      this.setCaret(this.lastPosition, true);
    }
  }
  onFocusOut() {
    if (this.isListOpen) {
      this.closeList();
    }
  }
  updatePositionAndList() {
    this.updateLastPosition();
    this.updateAutocompleteList(this.eAutocompleteInput.getValue() ?? null);
  }
  setCaret(position, setFocus) {
    if (setFocus && (0, import_ag_grid_community17._isNothingFocused)(this.beans)) {
      this.eAutocompleteInput.getFocusableElement().focus();
    }
    const eInput = this.eAutocompleteInput.getInputElement();
    eInput.setSelectionRange(position, position);
    if (position === eInput.value.length) {
      eInput.scrollLeft = eInput.scrollWidth;
    }
  }
  forceOpenList() {
    this.onValueChanged(this.eAutocompleteInput.getValue());
  }
  updateLastPosition() {
    this.lastPosition = this.eAutocompleteInput.getInputElement().selectionStart ?? 0;
  }
  validate(value) {
    if (!this.validator) {
      return;
    }
    const validationMessage = this.validationMessage = this.validator(value);
    this.eAutocompleteInput.getInputElement().setCustomValidity(validationMessage ?? "");
    this.valid = !validationMessage;
    this.dispatchLocalEvent({
      type: "eventValidChanged",
      isValid: this.valid,
      validationMessage
    });
  }
  openList() {
    this.isListOpen = true;
    this.autocompleteList = this.createBean(
      new AgAutocompleteList({
        autocompleteEntries: this.autocompleteListParams.entries,
        onConfirmed: () => this.confirmSelection(),
        forceLastSelection: this.forceLastSelection
      })
    );
    const ePopupGui = this.autocompleteList.getGui();
    const positionParams = {
      ePopup: ePopupGui,
      type: "autocomplete",
      eventSource: this.getGui(),
      position: "under",
      alignSide: this.gos.get("enableRtl") ? "right" : "left",
      keepWithinBounds: true
    };
    const addPopupRes = this.popupSvc.addPopup({
      eChild: ePopupGui,
      anchorToElement: this.getGui(),
      positionCallback: () => this.popupSvc.positionPopupByComponent(positionParams),
      ariaLabel: this.listAriaLabel
    });
    this.hidePopup = addPopupRes.hideFunc;
    this.autocompleteList.afterGuiAttached();
  }
  closeList() {
    this.isListOpen = false;
    this.hidePopup();
    this.destroyBean(this.autocompleteList);
    this.autocompleteList = null;
  }
  onCompleted() {
    if (this.isListOpen) {
      this.closeList();
    }
    this.dispatchLocalEvent({
      type: "eventValueConfirmed",
      value: this.getValue(),
      isValid: this.isValid()
    });
  }
  getValue() {
    return (0, import_ag_grid_community17._makeNull)(this.eAutocompleteInput.getValue());
  }
  setInputPlaceholder(placeholder) {
    this.eAutocompleteInput.setInputPlaceholder(placeholder);
    return this;
  }
  setInputAriaLabel(label) {
    this.eAutocompleteInput.setInputAriaLabel(label);
    return this;
  }
  setListAriaLabel(label) {
    this.listAriaLabel = label;
    return this;
  }
  setListGenerator(listGenerator) {
    this.listGenerator = listGenerator;
    return this;
  }
  setValidator(validator) {
    this.validator = validator;
    return this;
  }
  isValid() {
    return this.valid;
  }
  setValue(params) {
    const { value, position, silent, updateListOnlyIfOpen, restoreFocus } = params;
    this.eAutocompleteInput.setValue(value, true);
    this.setCaret(position ?? this.lastPosition, restoreFocus);
    if (!silent) {
      this.updateValue(value);
    }
    if (!updateListOnlyIfOpen || this.isListOpen) {
      this.updateAutocompleteList(value);
    }
  }
  setForceLastSelection(forceLastSelection) {
    this.forceLastSelection = forceLastSelection;
    return this;
  }
  setInputDisabled(disabled) {
    this.eAutocompleteInput.setDisabled(disabled);
    return this;
  }
};
var AgAutocompleteSelector = {
  selector: "AG-AUTOCOMPLETE",
  component: AgAutocomplete
};

// packages/ag-grid-enterprise/src/advancedFilter/advancedFilterComp.ts
var AdvancedFilterComp = class extends import_ag_grid_community18.Component {
  constructor() {
    super(
      /* html */
      `
            <div class="ag-advanced-filter" role="presentation" tabindex="-1">
                <ag-autocomplete data-ref="eAutocomplete"></ag-autocomplete>
                <button class="ag-button ag-standard-button ag-advanced-filter-apply-button" data-ref="eApplyFilterButton"></button>
                <button class="ag-button ag-advanced-filter-builder-button" data-ref="eBuilderFilterButton">
                    <span data-ref="eBuilderFilterButtonIcon" aria-hidden="true"></span>
                    <span class="ag-advanced-filter-builder-button-label" data-ref="eBuilderFilterButtonLabel"></span>
                </button>
            </div>`,
      [AgAutocompleteSelector]
    );
    this.eAutocomplete = import_ag_grid_community18.RefPlaceholder;
    this.eApplyFilterButton = import_ag_grid_community18.RefPlaceholder;
    this.eBuilderFilterButton = import_ag_grid_community18.RefPlaceholder;
    this.eBuilderFilterButtonIcon = import_ag_grid_community18.RefPlaceholder;
    this.eBuilderFilterButtonLabel = import_ag_grid_community18.RefPlaceholder;
    this.expressionParser = null;
    this.isApplyDisabled = true;
    this.builderOpen = false;
  }
  wireBeans(beans) {
    this.advFilterExpSvc = beans.advFilterExpSvc;
    this.advancedFilter = beans.advancedFilter;
    this.filterManager = beans.filterManager;
    this.registry = beans.registry;
  }
  postConstruct() {
    this.tooltipFeature = this.createOptionalManagedBean(
      this.registry.createDynamicBean("tooltipFeature", false, {
        getGui: () => this.getGui(),
        getTooltipShowDelayOverride: () => 1e3,
        getLocation: () => "advancedFilter"
      })
    );
    this.eAutocomplete.setListGenerator((_value, position) => this.generateAutocompleteListParams(position)).setValidator(() => this.validateValue()).setForceLastSelection(
      (lastSelection, searchString) => this.forceLastSelection(lastSelection, searchString)
    ).setInputAriaLabel(this.advFilterExpSvc.translate("ariaAdvancedFilterInput")).setListAriaLabel(this.advFilterExpSvc.translate("ariaLabelAdvancedFilterAutocomplete"));
    this.refresh();
    this.addManagedListeners(this.eAutocomplete, {
      eventValueChanged: ({ value }) => this.onValueChanged(value),
      eventValueConfirmed: ({ isValid }) => this.onValueConfirmed(isValid),
      eventOptionSelected: ({ position, updateEntry, autocompleteType }) => this.onOptionSelected(position, updateEntry, autocompleteType),
      eventValidChanged: ({ isValid, validationMessage }) => this.onValidChanged(isValid, validationMessage)
    });
    this.setupApplyButton();
    this.setupBuilderButton();
  }
  refresh() {
    const expression = this.advancedFilter.getExpressionDisplayValue();
    this.eAutocomplete.setValue({
      value: expression ?? "",
      position: expression?.length,
      updateListOnlyIfOpen: true
    });
  }
  setInputDisabled(disabled) {
    this.eAutocomplete.setInputDisabled(disabled);
    (0, import_ag_grid_community18._setDisabled)(this.eApplyFilterButton, disabled || this.isApplyDisabled);
  }
  setupApplyButton() {
    this.eApplyFilterButton.innerText = this.advFilterExpSvc.translate("advancedFilterApply");
    this.activateTabIndex([this.eApplyFilterButton]);
    this.addManagedElementListeners(this.eApplyFilterButton, {
      click: () => this.onValueConfirmed(this.eAutocomplete.isValid())
    });
    (0, import_ag_grid_community18._setDisabled)(this.eApplyFilterButton, this.isApplyDisabled);
  }
  setupBuilderButton() {
    this.eBuilderFilterButtonIcon.appendChild((0, import_ag_grid_community18._createIconNoSpan)("advancedFilterBuilder", this.beans));
    this.eBuilderFilterButtonLabel.innerText = this.advFilterExpSvc.translate("advancedFilterBuilder");
    this.activateTabIndex([this.eBuilderFilterButton]);
    this.addManagedElementListeners(this.eBuilderFilterButton, { click: () => this.openBuilder() });
    this.addManagedListeners(this.advancedFilter.getCtrl(), {
      advancedFilterBuilderClosed: () => this.closeBuilder()
    });
  }
  onValueChanged(value) {
    value = (0, import_ag_grid_community18._makeNull)(value);
    this.advancedFilter.setExpressionDisplayValue(value);
    this.expressionParser = this.advancedFilter.createExpressionParser(value);
    const updatedExpression = this.expressionParser?.parseExpression();
    if (updatedExpression && updatedExpression !== value) {
      this.eAutocomplete.setValue({ value: updatedExpression, silent: true, restoreFocus: true });
    }
  }
  onValueConfirmed(isValid) {
    if (!isValid || this.isApplyDisabled) {
      return;
    }
    (0, import_ag_grid_community18._setDisabled)(this.eApplyFilterButton, true);
    this.advancedFilter.applyExpression();
    this.filterManager?.onFilterChanged({ source: "advancedFilter" });
  }
  onOptionSelected(position, updateEntry, type) {
    const { updatedValue, updatedPosition, hideAutocomplete } = this.updateExpression(position, updateEntry, type);
    this.eAutocomplete.setValue({
      value: updatedValue,
      position: updatedPosition,
      updateListOnlyIfOpen: hideAutocomplete,
      restoreFocus: true
    });
  }
  validateValue() {
    return this.expressionParser?.isValid() ? null : this.expressionParser?.getValidationMessage() ?? null;
  }
  onValidChanged(isValid, validationMessage) {
    this.isApplyDisabled = !isValid || this.advancedFilter.isCurrentExpressionApplied();
    (0, import_ag_grid_community18._setDisabled)(this.eApplyFilterButton, this.isApplyDisabled);
    this.tooltipFeature?.setTooltipAndRefresh(validationMessage);
  }
  generateAutocompleteListParams(position) {
    return this.expressionParser ? this.expressionParser.getAutocompleteListParams(position) : this.advFilterExpSvc.getDefaultAutocompleteListParams("");
  }
  updateExpression(position, updateEntry, type) {
    this.advFilterExpSvc.updateAutocompleteCache(updateEntry, type);
    return this.expressionParser?.updateExpression(position, updateEntry, type) ?? this.advancedFilter.getDefaultExpression(updateEntry);
  }
  forceLastSelection({ key, displayValue }, searchString) {
    return !!searchString.toLocaleLowerCase().match(`^${(displayValue ?? key).toLocaleLowerCase()}\\s*$`);
  }
  openBuilder() {
    if (this.builderOpen) {
      return;
    }
    this.builderOpen = true;
    (0, import_ag_grid_community18._setDisabled)(this.eBuilderFilterButton, true);
    this.advancedFilter.getCtrl().toggleFilterBuilder({ source: "ui", eventSource: this.eBuilderFilterButton });
  }
  closeBuilder() {
    if (!this.builderOpen) {
      return;
    }
    this.builderOpen = false;
    (0, import_ag_grid_community18._setDisabled)(this.eBuilderFilterButton, false);
    this.eBuilderFilterButton.focus();
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/advancedFilterHeaderComp.ts
var import_ag_grid_community19 = require("ag-grid-community");
var AdvancedFilterHeaderComp = class extends import_ag_grid_community19.Component {
  constructor(enabled) {
    super(
      /* html */
      `
            <div class="ag-advanced-filter-header" role="row">
            </div>`
    );
    this.enabled = enabled;
  }
  wireBeans(beans) {
    this.colModel = beans.colModel;
    this.focusSvc = beans.focusSvc;
    this.ctrlsSvc = beans.ctrlsSvc;
  }
  postConstruct() {
    this.setupAdvancedFilter(this.enabled);
    this.addDestroyFunc(() => this.destroyBean(this.eAdvancedFilter));
    const heightListener = () => {
      if (this.enabled) {
        this.setEnabledHeight();
      }
    };
    this.addManagedEventListeners({
      gridColumnsChanged: () => this.onGridColumnsChanged(),
      columnHeaderHeightChanged: heightListener,
      gridStylesChanged: heightListener
    });
    this.addManagedPropertyListener("headerHeight", heightListener);
    this.addManagedPropertyListener("floatingFiltersHeight", heightListener);
    this.addGuiEventListener("keydown", (event) => this.onKeyDown(event));
    this.addGuiEventListener("focusout", (event) => {
      if (!this.getFocusableElement().contains(event.relatedTarget)) {
        this.focusSvc.clearAdvancedFilterColumn();
      }
    });
  }
  getFocusableElement() {
    return this.eAdvancedFilter?.getGui() ?? this.getGui();
  }
  setEnabled(enabled) {
    if (enabled === this.enabled) {
      return;
    }
    this.setupAdvancedFilter(enabled);
  }
  refresh() {
    this.eAdvancedFilter?.refresh();
  }
  getHeight() {
    return this.height;
  }
  setInputDisabled(disabled) {
    this.eAdvancedFilter?.setInputDisabled(disabled);
  }
  setupAdvancedFilter(enabled) {
    const eGui = this.getGui();
    if (enabled) {
      this.eAdvancedFilter = this.createBean(new AdvancedFilterComp());
      const eAdvancedFilterGui = this.eAdvancedFilter.getGui();
      this.eAdvancedFilter.addCssClass("ag-advanced-filter-header-cell");
      this.setEnabledHeight();
      this.setAriaRowIndex();
      (0, import_ag_grid_community19._setAriaRole)(eAdvancedFilterGui, "gridcell");
      (0, import_ag_grid_community19._setAriaColIndex)(eAdvancedFilterGui, 1);
      this.setAriaColumnCount(eAdvancedFilterGui);
      eGui.appendChild(eAdvancedFilterGui);
    } else {
      (0, import_ag_grid_community19._clearElement)(eGui);
      this.destroyBean(this.eAdvancedFilter);
      this.height = 0;
    }
    (0, import_ag_grid_community19._setDisplayed)(eGui, enabled);
    this.enabled = enabled;
  }
  setEnabledHeight() {
    const eGui = this.getGui();
    this.height = (0, import_ag_grid_community19._getFloatingFiltersHeight)(this.beans);
    const height = `${this.height}px`;
    eGui.style.height = height;
    eGui.style.minHeight = height;
  }
  setAriaColumnCount(eAdvancedFilterGui) {
    (0, import_ag_grid_community19._setAriaColSpan)(eAdvancedFilterGui, this.colModel.getCols().length);
  }
  setAriaRowIndex() {
    (0, import_ag_grid_community19._setAriaRowIndex)(this.getGui(), this.ctrlsSvc.getHeaderRowContainerCtrl()?.getRowCount() ?? 0);
  }
  onGridColumnsChanged() {
    if (!this.eAdvancedFilter) {
      return;
    }
    this.setAriaColumnCount(this.eAdvancedFilter.getGui());
    this.setAriaRowIndex();
  }
  onKeyDown(event) {
    switch (event.key) {
      case import_ag_grid_community19.KeyCode.ENTER: {
        if (this.hasFocus()) {
          if ((0, import_ag_grid_community19._focusInto)(this.getFocusableElement())) {
            event.preventDefault();
          }
        }
        break;
      }
      case import_ag_grid_community19.KeyCode.ESCAPE:
        if (!this.hasFocus()) {
          this.getFocusableElement().focus();
        }
        break;
      case import_ag_grid_community19.KeyCode.UP:
        this.navigateUpDown(true, event);
        break;
      case import_ag_grid_community19.KeyCode.DOWN:
        this.navigateUpDown(false, event);
        break;
      case import_ag_grid_community19.KeyCode.TAB:
        if (this.hasFocus()) {
          this.navigateLeftRight(event);
        } else {
          const nextFocusableEl = (0, import_ag_grid_community19._findNextFocusableElement)(
            this.beans,
            this.getFocusableElement(),
            null,
            event.shiftKey
          );
          if (nextFocusableEl) {
            event.preventDefault();
            nextFocusableEl.focus();
          } else {
            this.navigateLeftRight(event);
          }
        }
        break;
    }
  }
  navigateUpDown(backwards, event) {
    if (this.hasFocus()) {
      if (this.focusSvc.focusNextFromAdvancedFilter(backwards)) {
        event.preventDefault();
      }
    }
  }
  navigateLeftRight(event) {
    if (event.shiftKey ? this.focusSvc.focusLastHeader() : this.focusSvc.focusNextFromAdvancedFilter(false, true)) {
      event.preventDefault();
    }
  }
  hasFocus() {
    return (0, import_ag_grid_community19._getActiveDomElement)(this.beans) === this.getFocusableElement();
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/builder/advancedFilterBuilderComp.ts
var import_ag_grid_community36 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/advancedFilter/builder/advancedFilterBuilderDragFeature.ts
var import_ag_grid_community21 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/features/virtualListDragFeature.ts
var import_ag_grid_community20 = require("ag-grid-community");
var LIST_ITEM_HOVERED = "ag-list-item-hovered";
var VirtualListDragFeature = class extends import_ag_grid_community20.BeanStub {
  constructor(comp, virtualList, params) {
    super();
    this.comp = comp;
    this.virtualList = virtualList;
    this.params = params;
    this.currentDragValue = null;
    this.lastHoveredListItem = null;
  }
  wireBeans(beans) {
    this.dragAndDrop = beans.dragAndDrop;
  }
  postConstruct() {
    this.addManagedListeners(this.params.eventSource, {
      [this.params.listItemDragStartEvent]: this.listItemDragStart.bind(this),
      [this.params.listItemDragEndEvent]: this.listItemDragEnd.bind(this)
    });
    this.createDropTarget();
    this.createAutoScrollService();
  }
  listItemDragStart(event) {
    this.currentDragValue = this.params.getCurrentDragValue(event);
    this.moveBlocked = this.params.isMoveBlocked(this.currentDragValue);
  }
  listItemDragEnd() {
    window.setTimeout(() => {
      this.currentDragValue = null;
      this.moveBlocked = false;
    }, 10);
  }
  createDropTarget() {
    const dropTarget = {
      isInterestedIn: (type) => type === this.params.dragSourceType,
      getIconName: () => this.moveBlocked ? "pinned" : "move",
      getContainer: () => this.comp.getGui(),
      onDragging: (e) => this.onDragging(e),
      onDragStop: () => this.onDragStop(),
      onDragLeave: () => this.onDragLeave(),
      onDragCancel: () => this.onDragCancel()
    };
    this.dragAndDrop?.addDropTarget(dropTarget);
  }
  createAutoScrollService() {
    const virtualListGui = this.virtualList.getGui();
    this.autoScrollService = new import_ag_grid_community20.AutoScrollService({
      scrollContainer: virtualListGui,
      scrollAxis: "y",
      getVerticalPosition: () => virtualListGui.scrollTop,
      setVerticalPosition: (position) => virtualListGui.scrollTop = position
    });
  }
  onDragging(e) {
    if (!this.currentDragValue || this.moveBlocked) {
      return;
    }
    const hoveredListItem = this.getListDragItem(e);
    const comp = this.virtualList.getComponentAt(hoveredListItem.rowIndex);
    if (!comp) {
      return;
    }
    const el = comp.getGui().parentElement;
    if (this.lastHoveredListItem && this.lastHoveredListItem.rowIndex === hoveredListItem.rowIndex && this.lastHoveredListItem.position === hoveredListItem.position) {
      return;
    }
    this.autoScrollService.check(e.event);
    this.clearHoveredItems();
    this.lastHoveredListItem = hoveredListItem;
    (0, import_ag_grid_community20._radioCssClass)(el, LIST_ITEM_HOVERED);
    (0, import_ag_grid_community20._radioCssClass)(el, `ag-item-highlight-${hoveredListItem.position}`);
  }
  getListDragItem(e) {
    const virtualListGui = this.virtualList.getGui();
    const paddingTop = parseFloat(window.getComputedStyle(virtualListGui).paddingTop);
    const rowHeight = this.virtualList.getRowHeight();
    const scrollTop = this.virtualList.getScrollTop();
    const rowIndex = Math.max(0, (e.y - paddingTop + scrollTop) / rowHeight);
    const maxLen = this.params.getNumRows(this.comp) - 1;
    const normalizedRowIndex = Math.min(maxLen, rowIndex) | 0;
    return {
      rowIndex: normalizedRowIndex,
      position: Math.round(rowIndex) > rowIndex || rowIndex > maxLen ? "bottom" : "top",
      component: this.virtualList.getComponentAt(normalizedRowIndex)
    };
  }
  onDragStop() {
    if (this.moveBlocked) {
      return;
    }
    this.params.moveItem(this.currentDragValue, this.lastHoveredListItem);
    this.clearDragProperties();
  }
  onDragCancel() {
    this.clearDragProperties();
  }
  onDragLeave() {
    this.clearDragProperties();
  }
  clearDragProperties() {
    this.clearHoveredItems();
    this.autoScrollService.ensureCleared();
  }
  clearHoveredItems() {
    const virtualListGui = this.virtualList.getGui();
    virtualListGui.querySelectorAll(`.${LIST_ITEM_HOVERED}`).forEach((el) => {
      [LIST_ITEM_HOVERED, "ag-item-highlight-top", "ag-item-highlight-bottom"].forEach((cls) => {
        el.classList.remove(cls);
      });
    });
    this.lastHoveredListItem = null;
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/builder/advancedFilterBuilderDragFeature.ts
var AdvancedFilterBuilderDragFeature = class extends import_ag_grid_community21.BeanStub {
  constructor(comp, virtualList) {
    super();
    this.comp = comp;
    this.virtualList = virtualList;
  }
  postConstruct() {
    this.createManagedBean(
      new VirtualListDragFeature(this.comp, this.virtualList, {
        dragSourceType: import_ag_grid_community21.DragSourceType.AdvancedFilterBuilder,
        listItemDragStartEvent: "advancedFilterBuilderDragStarted",
        listItemDragEndEvent: "advancedFilterBuilderDragEnded",
        eventSource: this,
        getCurrentDragValue: (listItemDragStartEvent) => this.getCurrentDragValue(listItemDragStartEvent),
        isMoveBlocked: () => false,
        getNumRows: (comp) => comp.getNumItems(),
        moveItem: (currentDragValue, lastHoveredListItem) => this.moveItem(currentDragValue, lastHoveredListItem)
      })
    );
  }
  getCurrentDragValue(listItemDragStartEvent) {
    return listItemDragStartEvent.item;
  }
  moveItem(currentDragValue, lastHoveredListItem) {
    this.comp.moveItem(currentDragValue, lastHoveredListItem);
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/builder/advancedFilterBuilderItemAddComp.ts
var import_ag_grid_community30 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/advancedFilter/builder/addDropdownComp.ts
var import_ag_grid_community28 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/widgets/agRichSelect.ts
var import_ag_grid_community27 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/widgets/AgPillContainer.ts
var import_ag_grid_community24 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/widgets/agPill.ts
var import_ag_grid_community22 = require("ag-grid-community");
var import_ag_grid_community23 = require("ag-grid-community");
var AgPill = class extends import_ag_grid_community23.Component {
  constructor(config) {
    super(
      /* html */
      `
            <div class="ag-pill" role="option">
                <span class="ag-pill-text" data-ref="eText"></span>
                <span class="ag-button ag-pill-button" data-ref="eButton" role="presentation"></span>
            </div>
        `
    );
    this.config = config;
    this.eText = import_ag_grid_community22.RefPlaceholder;
    this.eButton = import_ag_grid_community22.RefPlaceholder;
  }
  postConstruct() {
    const { config, eButton } = this;
    const { onKeyDown, onButtonClick } = config;
    this.getGui().setAttribute("tabindex", String(this.gos.get("tabIndex")));
    this.addGuiEventListener("focus", () => {
      this.eButton.focus();
    });
    if (onKeyDown) {
      this.addGuiEventListener("keydown", onKeyDown);
    }
    if (onButtonClick) {
      this.addManagedElementListeners(eButton, {
        click: onButtonClick
      });
    }
  }
  toggleCloseButtonClass(className, force) {
    this.eButton.classList.toggle(className, force);
  }
  setText(text) {
    this.eText.textContent = text;
  }
  getText() {
    return this.eText.textContent;
  }
};

// packages/ag-grid-enterprise/src/widgets/AgPillContainer.ts
var AgPillContainer = class extends import_ag_grid_community24.Component {
  constructor() {
    super(
      /* html */
      `
            <div class="ag-pill-container" role="listbox"></div>
            `
    );
    this.pills = [];
  }
  init(params) {
    this.params = params;
    this.refresh();
  }
  refresh() {
    this.clearPills();
    const { params, onPillKeyDown } = this;
    let values = params.getValue();
    if (!Array.isArray(values)) {
      if (values == null) {
        return;
      }
      values = [values];
    }
    const valueFormatter = params.valueFormatter ?? ((v) => String(v));
    const len = values.length;
    for (let i = 0; i < len; i++) {
      const value = values[i];
      const pill = this.createBean(
        new AgPill({
          onButtonClick: () => this.onPillButtonClick(pill),
          onKeyDown: onPillKeyDown.bind(this)
        })
      );
      const pillGui = pill.getGui();
      (0, import_ag_grid_community24._setAriaPosInSet)(pillGui, i + 1);
      (0, import_ag_grid_community24._setAriaSetSize)(pillGui, len);
      if (params.onPillMouseDown) {
        pill.addGuiEventListener("mousedown", params.onPillMouseDown);
      }
      if (params.announceItemFocus) {
        pill.addGuiEventListener("focus", params.announceItemFocus);
      }
      pill.setText(valueFormatter(value) ?? "");
      pill.toggleCloseButtonClass("ag-icon-cancel", true);
      this.appendChild(pillGui);
      this.pills.push(pill);
    }
  }
  onNavigationKeyDown(e) {
    const { key } = e;
    if (!this.pills.length || key !== import_ag_grid_community24.KeyCode.LEFT && key !== import_ag_grid_community24.KeyCode.RIGHT) {
      return;
    }
    e.preventDefault();
    const { params, beans } = this;
    const activeEl = (0, import_ag_grid_community24._getActiveDomElement)(beans);
    const eGui = this.getGui();
    if (eGui.contains(activeEl)) {
      const nextFocusableEl = (0, import_ag_grid_community24._findNextFocusableElement)(beans, eGui, false, key === import_ag_grid_community24.KeyCode.LEFT);
      if (nextFocusableEl) {
        nextFocusableEl.focus();
      } else if (params.eWrapper) {
        params.eWrapper.focus();
      }
    } else {
      const focusableElements = (0, import_ag_grid_community24._findFocusableElements)(eGui);
      if (focusableElements.length > 0) {
        focusableElements[key === import_ag_grid_community24.KeyCode.RIGHT ? 0 : focusableElements.length - 1].focus();
      }
    }
  }
  clearPills() {
    const eGui = this.getGui();
    if (eGui.contains((0, import_ag_grid_community24._getActiveDomElement)(this.beans)) && this.params.eWrapper) {
      this.params.eWrapper.focus();
    }
    (0, import_ag_grid_community24._clearElement)(eGui);
    this.destroyBeans(this.pills);
    this.pills = [];
  }
  onPillButtonClick(pill) {
    this.deletePill(pill);
  }
  onPillKeyDown(e) {
    const key = e.key;
    if (key !== import_ag_grid_community24.KeyCode.DELETE && key !== import_ag_grid_community24.KeyCode.BACKSPACE) {
      return;
    }
    e.preventDefault();
    const eDoc = (0, import_ag_grid_community24._getDocument)(this.beans);
    const pillIndex = this.pills.findIndex((pill2) => pill2.getGui().contains(eDoc.activeElement));
    if (pillIndex === -1) {
      return;
    }
    const pill = this.pills[pillIndex];
    if (pill) {
      this.deletePill(pill, pillIndex);
    }
  }
  deletePill(pill, restoreFocusToIndex) {
    const value = pill.getText();
    const values = (this.params.getValue() || []).filter((val) => val !== value);
    this.params.setValue(values);
    if (!values.length && this.params.eWrapper) {
      this.params.eWrapper.focus();
    } else if (restoreFocusToIndex != null) {
      const pill2 = this.pills[Math.min(restoreFocusToIndex, this.pills.length - 1)];
      if (pill2) {
        pill2.getFocusableElement().focus();
      }
    }
  }
  destroy() {
    this.clearPills();
    super.destroy();
  }
};

// packages/ag-grid-enterprise/src/widgets/agRichSelect.css-GENERATED.ts
var agRichSelectCSS = (
  /*css*/
  `.ag-rich-select{cursor:default;height:100%}.ag-rich-select-value{align-items:center;background-color:var(--ag-picker-button-background-color);display:flex;height:100%;padding:var(--ag-spacing);:where(.ag-picker-field-display){overflow:hidden;text-overflow:ellipsis;&:where(.ag-display-as-placeholder){opacity:.5}}}.ag-rich-select-list{background-color:var(--ag-picker-list-background-color);border:var(--ag-picker-list-border);border-radius:var(--ag-input-border-radius);box-shadow:var(--ag-dropdown-shadow);height:auto;position:relative;width:100%;:where(.ag-loading-text){padding:var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding)}}.ag-rich-select-row{align-items:center;display:flex;flex:1 1 auto;height:100%;overflow:hidden;padding:0 var(--ag-spacing);white-space:nowrap}.ag-rich-select-row-selected{background-color:var(--ag-selected-row-background-color)}.ag-rich-select-row-highlighted,.ag-rich-select-row:hover{background-image:linear-gradient(var(--ag-row-hover-color),var(--ag-row-hover-color))}.ag-rich-select-row-text-highlight{font-weight:700}.ag-rich-select-field-input{flex:1 1 auto;:where(.ag-input-field-input){border:none!important;box-shadow:none!important;padding:0!important;text-overflow:ellipsis;&::-moz-placeholder{opacity:.8}&::placeholder{opacity:.8}}}:where(.ag-ltr) .ag-rich-select-field-input{left:var(--ag-spacing)}:where(.ag-rtl) .ag-rich-select-field-input{right:var(--ag-spacing)}:where(.ag-popup-editor) .ag-rich-select-value{height:var(--ag-row-height);min-width:200px}.ag-rich-select-virtual-list-item{cursor:default;height:var(--ag-list-item-height)}.ag-pill-container{display:flex;flex-wrap:nowrap;gap:.25rem}.ag-pill{align-items:center;background:var(--ag-select-cell-background-color);border:var(--ag-select-cell-border);border-radius:var(--ag-border-radius);display:flex;padding:0 .25rem;white-space:nowrap}.ag-pill-button{border:none;padding:0;&:hover{color:var(--ag-accent-color);cursor:pointer}}:where(.ag-ltr) .ag-pill-button{margin-left:var(--ag-spacing)}:where(.ag-rtl) .ag-pill-button{margin-right:var(--ag-spacing)}`
);

// packages/ag-grid-enterprise/src/widgets/agRichSelectList.ts
var import_ag_grid_community26 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/widgets/agRichSelectRow.ts
var import_ag_grid_community25 = require("ag-grid-community");
var RichSelectRow = class extends import_ag_grid_community25.Component {
  constructor(params) {
    super(
      /* html */
      `<div class="ag-rich-select-row" role="presentation"></div>`
    );
    this.params = params;
  }
  wireBeans(beans) {
    this.userCompFactory = beans.userCompFactory;
    this.registry = beans.registry;
  }
  postConstruct() {
    this.tooltipFeature = this.createOptionalManagedBean(
      this.registry.createDynamicBean("tooltipFeature", false, {
        getGui: () => this.getGui(),
        shouldDisplayTooltip: () => this.shouldDisplayTooltip?.() ?? true
      })
    );
  }
  setState(value) {
    const { params } = this;
    const formattedValue = params.valueFormatter?.(value) ?? "";
    const rendererSuccessful = this.populateWithRenderer(value, formattedValue);
    if (!rendererSuccessful) {
      this.populateWithoutRenderer(value, formattedValue);
    }
    this.value = value;
  }
  highlightString(matchString) {
    const { parsedValue } = this;
    if (this.params.cellRenderer || !(0, import_ag_grid_community25._exists)(parsedValue)) {
      return;
    }
    let hasMatch = (0, import_ag_grid_community25._exists)(matchString);
    if (hasMatch) {
      const index = parsedValue?.toLocaleLowerCase().indexOf(matchString.toLocaleLowerCase());
      if (index >= 0) {
        const highlightEndIndex = index + matchString.length;
        const startPart = (0, import_ag_grid_community25._escapeString)(parsedValue.slice(0, index), true);
        const highlightedPart = (0, import_ag_grid_community25._escapeString)(parsedValue.slice(index, highlightEndIndex), true);
        const endPart = (0, import_ag_grid_community25._escapeString)(parsedValue.slice(highlightEndIndex));
        this.renderValueWithoutRenderer(
          /* html */
          `${startPart}<span class="ag-rich-select-row-text-highlight">${highlightedPart}</span>${endPart}`
        );
      } else {
        hasMatch = false;
      }
    }
    if (!hasMatch) {
      this.renderValueWithoutRenderer(parsedValue);
    }
  }
  updateSelected(selected) {
    const eGui = this.getGui();
    (0, import_ag_grid_community25._setAriaSelected)(eGui.parentElement, selected);
    this.addOrRemoveCssClass("ag-rich-select-row-selected", selected);
  }
  getValue() {
    return this.value;
  }
  toggleHighlighted(highlighted) {
    this.addOrRemoveCssClass("ag-rich-select-row-highlighted", highlighted);
  }
  populateWithoutRenderer(value, valueFormatted) {
    const eDocument = (0, import_ag_grid_community25._getDocument)(this.beans);
    const eGui = this.getGui();
    const span = eDocument.createElement("span");
    span.style.overflow = "hidden";
    span.style.textOverflow = "ellipsis";
    const parsedValue = (0, import_ag_grid_community25._escapeString)((0, import_ag_grid_community25._exists)(valueFormatted) ? valueFormatted : value, true);
    this.parsedValue = (0, import_ag_grid_community25._exists)(parsedValue) ? parsedValue : null;
    eGui.appendChild(span);
    this.renderValueWithoutRenderer(parsedValue);
    this.shouldDisplayTooltip = (0, import_ag_grid_community25._shouldDisplayTooltip)(() => span);
    this.tooltipFeature?.setTooltipAndRefresh(this.parsedValue);
  }
  renderValueWithoutRenderer(value) {
    const span = this.getGui().querySelector("span");
    if (!span) {
      return;
    }
    span.innerHTML = (0, import_ag_grid_community25._exists)(value) ? value : "&nbsp;";
  }
  populateWithRenderer(value, valueFormatted) {
    let cellRendererPromise;
    let userCompDetails;
    if (this.params.cellRenderer) {
      const richSelect = this.getParentComponent()?.getParentComponent();
      userCompDetails = (0, import_ag_grid_community25._getEditorRendererDetails)(
        this.userCompFactory,
        this.params,
        (0, import_ag_grid_community25._addGridCommonParams)(this.gos, {
          value,
          valueFormatted,
          getValue: () => richSelect?.getValue(),
          setValue: (value2) => {
            richSelect?.setValue(value2, true);
          },
          setTooltip: (value2, shouldDisplayTooltip) => {
            this.gos.assertModuleRegistered("Tooltip", 3);
            this.shouldDisplayTooltip = shouldDisplayTooltip;
            this.tooltipFeature?.setTooltipAndRefresh(value2);
          }
        })
      );
    }
    if (userCompDetails) {
      cellRendererPromise = userCompDetails.newAgStackInstance();
    }
    if (cellRendererPromise) {
      (0, import_ag_grid_community25._bindCellRendererToHtmlElement)(cellRendererPromise, this.getGui());
    }
    if (cellRendererPromise) {
      cellRendererPromise.then((childComponent) => {
        this.addDestroyFunc(() => {
          this.destroyBean(childComponent);
        });
      });
      return true;
    }
    return false;
  }
};

// packages/ag-grid-enterprise/src/widgets/agRichSelectList.ts
var LIST_COMPONENT_NAME = "ag-rich-select-list";
var ROW_COMPONENT_NAME = "ag-rich-select-row";
var AgRichSelectList = class extends VirtualList {
  constructor(params, richSelectWrapper, getSearchString2) {
    super({ cssIdentifier: "rich-select" });
    this.params = params;
    this.richSelectWrapper = richSelectWrapper;
    this.getSearchString = getSearchString2;
    this.lastRowHovered = -1;
    this.selectedItems = /* @__PURE__ */ new Set();
    this.params = params;
    this.setComponentCreator(this.createRowComponent.bind(this));
    this.setComponentUpdater(() => {
    });
  }
  postConstruct() {
    super.postConstruct();
    this.createLoadingElement();
    const { cellRowHeight, pickerAriaLabelKey, pickerAriaLabelValue } = this.params;
    if (cellRowHeight) {
      this.setRowHeight(cellRowHeight);
    }
    const eGui = this.getGui();
    const eListAriaEl = this.getAriaElement();
    this.addManagedListeners(eGui, {
      mousemove: this.onMouseMove.bind(this),
      mouseout: this.onMouseOut.bind(this),
      mousedown: this.onMouseDown.bind(this),
      click: this.onClick.bind(this)
    });
    eGui.classList.add(LIST_COMPONENT_NAME);
    const listId = `${LIST_COMPONENT_NAME}-${this.getCompId()}`;
    eListAriaEl.setAttribute("id", listId);
    const translate = this.getLocaleTextFunc();
    const ariaLabel = translate(pickerAriaLabelKey, pickerAriaLabelValue);
    (0, import_ag_grid_community26._setAriaLabel)(eListAriaEl, ariaLabel);
    (0, import_ag_grid_community26._setAriaControls)(this.richSelectWrapper, eListAriaEl);
  }
  navigateToPage(key) {
    const newIndex = super.navigateToPage(key, this.lastRowHovered);
    if (newIndex != null) {
      (0, import_ag_grid_community26._requestAnimationFrame)(this.beans, () => {
        if (!this.isAlive()) {
          return null;
        }
        this.highlightIndex(newIndex);
      });
    }
    return newIndex;
  }
  drawVirtualRows(softRefresh) {
    super.drawVirtualRows(softRefresh);
    this.refreshSelectedItems();
  }
  highlightFilterMatch(searchString) {
    this.forEachRenderedRow((cmp) => {
      cmp.highlightString(searchString);
    });
  }
  onNavigationKeyDown(key, announceItem) {
    (0, import_ag_grid_community26._requestAnimationFrame)(this.beans, () => {
      if (!this.currentList || !this.isAlive()) {
        return;
      }
      const len = this.currentList.length;
      const oldIndex = this.lastRowHovered;
      const diff = key === import_ag_grid_community26.KeyCode.DOWN ? 1 : -1;
      const newIndex = Math.min(Math.max(oldIndex === -1 ? 0 : oldIndex + diff, 0), len - 1);
      this.highlightIndex(newIndex);
      announceItem();
    });
  }
  selectValue(value) {
    if (!this.currentList) {
      if (this.eLoading) {
        this.appendChild(this.eLoading);
      }
      return false;
    }
    if (this.eLoading?.offsetParent) {
      this.eLoading.parentElement?.removeChild(this.eLoading);
    }
    if (value == null) {
      return false;
    }
    const selectedPositions = this.getIndicesForValues(value);
    const refresh = selectedPositions.length > 0;
    if (refresh) {
      this.refresh();
      this.ensureIndexVisible(selectedPositions[0]);
      this.refresh(true);
    }
    this.selectListItems(Array.isArray(value) ? value : [value]);
    return refresh;
  }
  selectListItems(values, append = false) {
    if (!append) {
      this.selectedItems.clear();
    }
    for (let i = 0; i < values.length; i++) {
      const currentItem = values[i];
      if (this.selectedItems.has(currentItem)) {
        continue;
      }
      this.selectedItems.add(currentItem);
    }
    this.refreshSelectedItems();
  }
  getCurrentList() {
    return this.currentList;
  }
  setCurrentList(list) {
    this.currentList = list;
    this.setModel({
      getRowCount: () => list.length,
      getRow: (index) => list[index],
      areRowsEqual: (oldRow, newRow) => oldRow === newRow
    });
  }
  getSelectedItems() {
    return this.selectedItems;
  }
  getLastItemHovered() {
    return this.currentList[this.lastRowHovered];
  }
  highlightIndex(index, preventUnnecessaryScroll) {
    if (!this.currentList) {
      return;
    }
    if (index < 0 || index >= this.currentList.length) {
      this.lastRowHovered = -1;
    } else {
      this.lastRowHovered = index;
      const wasScrolled = this.ensureIndexVisible(index, !preventUnnecessaryScroll);
      if (wasScrolled && !preventUnnecessaryScroll) {
        this.refresh(true);
      }
    }
    this.forEachRenderedRow((cmp, idx) => {
      const highlighted = index === idx;
      cmp.toggleHighlighted(highlighted);
      if (highlighted) {
        const idForParent = `${ROW_COMPONENT_NAME}-${cmp.getCompId()}`;
        (0, import_ag_grid_community26._setAriaActiveDescendant)(this.richSelectWrapper, idForParent);
        this.richSelectWrapper.setAttribute("data-active-option", idForParent);
      }
    });
  }
  getIndicesForValues(values) {
    const { currentList } = this;
    if (!currentList || currentList.length === 0 || values == null) {
      return [];
    }
    if (!Array.isArray(values)) {
      values = [values];
    }
    if (values.length === 0) {
      return [];
    }
    const { valueFormatter } = this.params;
    const positions = [];
    const isObject = typeof values[0] === "object";
    const formattedList = currentList.map(valueFormatter);
    for (const value of values) {
      let idx = -1;
      if (isObject) {
        idx = formattedList.indexOf(valueFormatter(value));
      } else {
        idx = currentList.indexOf(value);
      }
      if (idx >= 0) {
        positions.push(idx);
      }
    }
    return positions;
  }
  toggleListItemSelection(value) {
    if (this.selectedItems.has(value)) {
      this.selectedItems.delete(value);
    } else {
      this.selectedItems.add(value);
    }
    this.refreshSelectedItems();
    this.dispatchValueSelected();
  }
  refreshSelectedItems() {
    this.forEachRenderedRow((cmp) => {
      const selected = this.selectedItems.has(cmp.getValue());
      cmp.updateSelected(selected);
    });
  }
  createLoadingElement() {
    const eDocument = (0, import_ag_grid_community26._getDocument)(this.beans);
    const translate = this.getLocaleTextFunc();
    const el = eDocument.createElement("div");
    el.classList.add("ag-loading-text");
    el.innerText = translate("loadingOoo", "Loading...");
    this.eLoading = el;
  }
  createRowComponent(value, listItemElement) {
    const row = new RichSelectRow(this.params);
    listItemElement.setAttribute("id", `${ROW_COMPONENT_NAME}-${row.getCompId()}`);
    row.setParentComponent(this);
    this.createBean(row);
    row.setState(value);
    const { highlightMatch, searchType = "fuzzy" } = this.params;
    if (highlightMatch && searchType !== "fuzzy") {
      row.highlightString(this.getSearchString());
    }
    return row;
  }
  getRowForMouseEvent(e) {
    const eGui = this.getGui();
    const rect = eGui.getBoundingClientRect();
    const scrollTop = this.getScrollTop();
    const mouseY = e.clientY - rect.top + scrollTop;
    return Math.floor(mouseY / this.getRowHeight());
  }
  onMouseMove(e) {
    const row = this.getRowForMouseEvent(e);
    if (row !== -1 && row != this.lastRowHovered) {
      this.lastRowHovered = row;
      this.highlightIndex(row, true);
    }
  }
  onMouseDown(e) {
    e.preventDefault();
  }
  onMouseOut(e) {
    if (!this.getGui().contains(e.relatedTarget)) {
      this.highlightIndex(-1);
    }
  }
  onClick(e) {
    const { multiSelect } = this.params;
    if (!this.currentList) {
      return;
    }
    const row = this.getRowForMouseEvent(e);
    const item = this.currentList[row];
    if (multiSelect) {
      this.toggleListItemSelection(item);
    } else {
      this.selectListItems([item]);
      this.dispatchValueSelected();
    }
  }
  dispatchValueSelected() {
    this.dispatchLocalEvent({
      type: "richSelectListRowSelected",
      fromEnterKey: false,
      value: this.selectedItems
    });
  }
  destroy() {
    super.destroy();
    this.eLoading = void 0;
  }
};

// packages/ag-grid-enterprise/src/widgets/agRichSelect.ts
var AgRichSelect = class extends import_ag_grid_community27.AgPickerField {
  constructor(config) {
    super({
      pickerAriaLabelKey: "ariaLabelRichSelectField",
      pickerAriaLabelValue: "Rich Select Field",
      pickerType: "ag-list",
      className: "ag-rich-select",
      pickerIcon: "richSelectOpen",
      ariaRole: "combobox",
      template: config?.template ?? /* html */
      `
            <div class="ag-picker-field" role="presentation">
                <div data-ref="eLabel"></div>
                <div data-ref="eWrapper" class="ag-wrapper ag-picker-field-wrapper ag-rich-select-value ag-picker-collapsed">
                    <span data-ref="eDisplayField" class="ag-picker-field-display"></span>
                    <ag-input-text-field data-ref="eInput" class="ag-rich-select-field-input"></ag-input-text-field>
                    <span data-ref="eDeselect" class="ag-rich-select-deselect-button ag-picker-field-icon" role="presentation"></span>
                    <span data-ref="eIcon" class="ag-picker-field-icon" aria-hidden="true"></span>
                </div>
            </div>`,
      agComponents: [import_ag_grid_community27.AgInputTextFieldSelector],
      modalPicker: false,
      ...config,
      // maxPickerHeight needs to be set after expanding `config`
      maxPickerHeight: config?.maxPickerHeight ?? "calc(var(--ag-row-height) * 6.5)"
    });
    this.searchString = "";
    this.searchStringCreator = null;
    this.eInput = import_ag_grid_community27.RefPlaceholder;
    this.eDeselect = import_ag_grid_community27.RefPlaceholder;
    this.skipWrapperAnnouncement = false;
    const { value, valueList, searchStringCreator } = config || {};
    if (value !== void 0) {
      this.value = value;
    }
    if (searchStringCreator) {
      this.searchStringCreator = searchStringCreator;
    }
    if (valueList != null) {
      this.setValues(valueList);
    }
    this.registerCSS(agRichSelectCSS);
  }
  wireBeans(beans) {
    this.userCompFactory = beans.userCompFactory;
    this.ariaAnnounce = beans.ariaAnnounce;
    this.registry = beans.registry;
  }
  postConstruct() {
    this.tooltipFeature = this.createOptionalManagedBean(
      this.registry.createDynamicBean("tooltipFeature", false, {
        getGui: () => this.getGui(),
        shouldDisplayTooltip: () => this.shouldDisplayTooltip?.() ?? true
      })
    );
    super.postConstruct();
    this.createListComponent();
    this.eDeselect.appendChild((0, import_ag_grid_community27._createIconNoSpan)("richSelectRemove", this.beans));
    const { allowTyping, placeholder, suppressDeselectAll } = this.config;
    this.eDeselect.classList.add("ag-hidden");
    if (allowTyping) {
      this.eInput.setAutoComplete(false).setInputPlaceholder(placeholder);
      this.eDisplayField.classList.add("ag-hidden");
    } else {
      this.eInput.setDisplayed(false);
    }
    this.setupAriaProperties();
    const { searchDebounceDelay = 300 } = this.config;
    this.clearSearchString = (0, import_ag_grid_community27._debounce)(this, this.clearSearchString.bind(this), searchDebounceDelay);
    this.renderSelectedValue();
    if (allowTyping) {
      this.eInput.onValueChange((value) => this.searchTextFromString(value));
    }
    this.addManagedElementListeners(this.eWrapper, { focus: this.onWrapperFocus.bind(this) });
    this.addManagedElementListeners(this.eWrapper, { focusout: this.onWrapperFocusOut.bind(this) });
    if (!suppressDeselectAll) {
      this.addManagedElementListeners(this.eDeselect, {
        mousedown: this.onDeselectAllMouseDown.bind(this),
        click: this.onDeselectAllClick.bind(this)
      });
    }
  }
  setupAriaProperties() {
    const { eWrapper, gos } = this;
    eWrapper.tabIndex = gos.get("tabIndex");
    const translate = this.getLocaleTextFunc();
    this.ariaDeleteSelection = translate("ariaLabelRichSelectDeleteSelection", "Press DELETE to deselect item");
    this.ariaDeselectAllItems = translate(
      "ariaLabelRichSelectDeselectAllItems",
      "Press DELETE to deselect all items"
    );
    this.ariaToggleSelection = translate("ariaLabelRichSelectToggleSelection", "Press SPACE to toggle selection");
  }
  createListComponent() {
    this.listComponent = this.createBean(new AgRichSelectList(this.config, this.eWrapper, () => this.searchString));
    this.listComponent.setParentComponent(this);
    this.addManagedListeners(this.listComponent, {
      richSelectListRowSelected: (e) => {
        this.onListValueSelected(e.value, e.fromEnterKey);
      }
    });
  }
  renderSelectedValue() {
    const { value, eDisplayField, config, gos } = this;
    const {
      allowTyping,
      cellRenderer,
      initialInputValue,
      multiSelect,
      suppressDeselectAll,
      suppressMultiSelectPillRenderer
    } = config;
    const valueFormatted = config.valueFormatter?.(value) ?? String(value);
    if (allowTyping) {
      this.eInput.setValue(initialInputValue ?? valueFormatted);
      return;
    }
    if (multiSelect && !suppressDeselectAll) {
      const isEmpty = value == null || Array.isArray(value) && value.length === 0;
      this.eDeselect.classList.toggle("ag-hidden", isEmpty);
    }
    let userCompDetails;
    if (multiSelect && !suppressMultiSelectPillRenderer) {
      this.createOrUpdatePillContainer(eDisplayField);
      return;
    }
    if (cellRenderer) {
      userCompDetails = (0, import_ag_grid_community27._getEditorRendererDetails)(
        this.userCompFactory,
        config,
        (0, import_ag_grid_community27._addGridCommonParams)(this.gos, {
          value,
          valueFormatted,
          getValue: () => this.getValue(),
          setValue: (value2) => {
            this.setValue(value2, true);
          },
          setTooltip: (value2, shouldDisplayTooltip) => {
            gos.assertModuleRegistered("Tooltip", 3);
            this.shouldDisplayTooltip = shouldDisplayTooltip;
            this.tooltipFeature?.setTooltipAndRefresh(value2);
          }
        })
      );
    }
    let userCompDetailsPromise;
    if (userCompDetails) {
      userCompDetailsPromise = userCompDetails.newAgStackInstance();
    }
    if (userCompDetailsPromise) {
      (0, import_ag_grid_community27._clearElement)(eDisplayField);
      (0, import_ag_grid_community27._bindCellRendererToHtmlElement)(userCompDetailsPromise, eDisplayField);
      userCompDetailsPromise.then((renderer) => {
        this.addDestroyFunc(() => this.destroyBean(renderer));
      });
    } else {
      if ((0, import_ag_grid_community27._exists)(this.value)) {
        eDisplayField.innerText = valueFormatted;
        eDisplayField.classList.remove("ag-display-as-placeholder");
      } else {
        const { placeholder } = config;
        if ((0, import_ag_grid_community27._exists)(placeholder)) {
          eDisplayField.innerHTML = `${(0, import_ag_grid_community27._escapeString)(placeholder)}`;
          eDisplayField.classList.add("ag-display-as-placeholder");
        } else {
          (0, import_ag_grid_community27._clearElement)(eDisplayField);
        }
      }
      this.shouldDisplayTooltip = (0, import_ag_grid_community27._shouldDisplayTooltip)(() => this.eDisplayField);
      this.tooltipFeature?.setTooltipAndRefresh(valueFormatted ?? null);
    }
  }
  createPickerComponent() {
    const { values } = this;
    if (values) {
      this.setValueList({ valueList: values });
    }
    return this.listComponent;
  }
  setSearchStringCreator(searchStringFn) {
    this.searchStringCreator = searchStringFn;
  }
  setValueList(params) {
    const { valueList, refresh } = params;
    if (!this.listComponent || this.listComponent.getCurrentList() === valueList) {
      return;
    }
    this.listComponent.setCurrentList(valueList);
    if (refresh) {
      if (!this.values) {
        this.setValues(valueList);
        if (this.isPickerDisplayed) {
          const hasRefreshed = this.listComponent.selectValue(this.value);
          if (!hasRefreshed) {
            this.listComponent.refresh();
          }
        }
      } else {
        this.listComponent.refresh(true);
      }
      this.alignPickerToComponent();
    }
  }
  /**
   * This method updates the list of values
   */
  setValues(values) {
    this.values = values;
    this.searchStrings = this.getSearchStringsFromValues(values);
  }
  showPicker() {
    super.showPicker();
    const { listComponent, value } = this;
    if (!listComponent) {
      return;
    }
    let idx = null;
    listComponent.selectValue(this.value);
    if (this.value != null) {
      idx = listComponent.getIndicesForValues(Array.isArray(value) ? value : [value])[0];
    }
    if (idx != null) {
      listComponent.highlightIndex(idx);
    } else {
      listComponent.refresh();
    }
    this.displayOrHidePicker();
  }
  beforeHidePicker() {
    super.beforeHidePicker();
  }
  createOrUpdatePillContainer(container) {
    if (!this.pillContainer) {
      const pillContainer = this.pillContainer = this.createBean(new AgPillContainer());
      this.addDestroyFunc(() => {
        this.destroyBean(this.pillContainer);
        this.pillContainer = null;
      });
      (0, import_ag_grid_community27._clearElement)(container);
      container.appendChild(pillContainer.getGui());
      const { config, eWrapper, ariaDeleteSelection } = this;
      const { valueFormatter } = config;
      pillContainer.init({
        eWrapper,
        valueFormatter,
        onPillMouseDown: (e) => {
          e.stopImmediatePropagation();
        },
        announceItemFocus: () => {
          this.announceAriaValue(ariaDeleteSelection);
        },
        getValue: () => this.getValue(),
        setValue: (value) => this.setValue(value, true)
      });
    }
    this.doWhileBlockingAnnouncement(() => this.pillContainer?.refresh());
  }
  doWhileBlockingAnnouncement(func) {
    this.skipWrapperAnnouncement = true;
    func();
    this.skipWrapperAnnouncement = false;
  }
  onWrapperFocus() {
    const { eInput, config } = this;
    const { allowTyping, multiSelect, suppressDeselectAll } = config;
    if (allowTyping) {
      const focusableEl = eInput.getFocusableElement();
      focusableEl.focus();
      focusableEl.select();
    } else if (multiSelect && !suppressDeselectAll && !this.skipWrapperAnnouncement) {
      this.announceAriaValue(this.ariaDeselectAllItems);
    }
  }
  onWrapperFocusOut(e) {
    if (!this.eWrapper.contains(e.relatedTarget)) {
      this.hidePicker();
    }
  }
  onDeselectAllMouseDown(e) {
    e.stopImmediatePropagation();
  }
  onDeselectAllClick() {
    this.setValue([], true);
  }
  buildSearchStringFromKeyboardEvent(searchKey) {
    let { key } = searchKey;
    if (key === import_ag_grid_community27.KeyCode.BACKSPACE) {
      this.searchString = this.searchString.slice(0, -1);
      key = "";
    } else if (!(0, import_ag_grid_community27._isEventFromPrintableCharacter)(searchKey)) {
      return;
    }
    searchKey.preventDefault();
    this.searchTextFromCharacter(key);
  }
  searchTextFromCharacter(char) {
    this.searchString += char;
    this.runSearch();
    this.clearSearchString();
  }
  searchTextFromString(str) {
    if (str == null) {
      str = "";
    }
    this.searchString = str;
    this.runSearch();
  }
  getSearchStringsFromValues(values) {
    const { config } = this;
    const { valueFormatter = (value) => String(value) } = config;
    if (typeof values[0] === "object" && this.searchStringCreator) {
      return this.searchStringCreator(values);
    }
    return values.map((v) => valueFormatter(v));
  }
  filterListModel(filteredValues) {
    const { filterList } = this.config;
    if (!filterList) {
      return;
    }
    this.setValueList({ valueList: filteredValues, refresh: true });
  }
  runSearch() {
    if (!this.listComponent) {
      return;
    }
    const { values } = this;
    const searchStrings = this.searchStrings;
    if (!searchStrings) {
      this.listComponent.highlightIndex(-1);
      return;
    }
    const { suggestions, filteredValues } = this.getSuggestionsAndFilteredValues(this.searchString, searchStrings);
    const { filterList, highlightMatch, searchType = "fuzzy" } = this.config;
    const shouldFilter = !!(filterList && this.searchString !== "");
    this.filterListModel(shouldFilter ? filteredValues : values);
    if (!this.highlightEmptyValue()) {
      this.highlightListValue(suggestions, filteredValues, shouldFilter);
    }
    if (highlightMatch && searchType !== "fuzzy") {
      this.listComponent?.highlightFilterMatch(this.searchString);
    }
    this.displayOrHidePicker();
  }
  highlightEmptyValue() {
    if (this.searchString === "") {
      const emptyIdx = this.searchStrings?.indexOf("");
      if (emptyIdx !== void 0 && emptyIdx !== -1) {
        this.listComponent?.highlightIndex(emptyIdx);
        return true;
      }
    }
    return false;
  }
  highlightListValue(suggestions, filteredValues, shouldFilter) {
    if (suggestions.length) {
      const topSuggestionIndex = shouldFilter ? 0 : this.searchStrings?.indexOf(suggestions[0]);
      if (topSuggestionIndex !== void 0) {
        this.listComponent?.highlightIndex(topSuggestionIndex);
      }
    } else {
      this.listComponent?.highlightIndex(-1);
      if (!shouldFilter || filteredValues.length) {
        this.listComponent?.ensureIndexVisible(0);
      } else if (shouldFilter) {
        this.getAriaElement().removeAttribute("data-active-option");
        const eListAriaEl = this.listComponent?.getAriaElement();
        if (eListAriaEl) {
          (0, import_ag_grid_community27._setAriaActiveDescendant)(eListAriaEl, null);
        }
      }
    }
  }
  getSuggestionsAndFilteredValues(searchValue, valueList) {
    let suggestions = [];
    const filteredValues = [];
    if (!searchValue.length) {
      return { suggestions, filteredValues };
    }
    const { searchType = "fuzzy", filterList } = this.config;
    if (searchType === "fuzzy") {
      const fuzzySearchResult = (0, import_ag_grid_community27._fuzzySuggestions)({
        inputValue: searchValue,
        allSuggestions: valueList,
        hideIrrelevant: true,
        addSequentialWeight: true
      });
      suggestions = fuzzySearchResult.values;
      const indices = fuzzySearchResult.indices;
      if (filterList && indices.length) {
        for (let i = 0; i < indices.length; i++) {
          filteredValues.push(this.values[indices[i]]);
        }
      }
    } else {
      suggestions = valueList.filter((val, idx) => {
        const currentValue = val.toLocaleLowerCase();
        const valueToMatch = this.searchString.toLocaleLowerCase();
        const isMatch = searchType === "match" ? currentValue.startsWith(valueToMatch) : currentValue.indexOf(valueToMatch) !== -1;
        if (filterList && isMatch) {
          filteredValues.push(this.values[idx]);
        }
        return isMatch;
      });
    }
    return { suggestions, filteredValues };
  }
  displayOrHidePicker() {
    if (!this.listComponent) {
      return;
    }
    const eListGui = this.listComponent.getGui();
    const list = this.listComponent.getCurrentList();
    const toggleValue = list ? list.length === 0 : false;
    eListGui.classList.toggle("ag-hidden", toggleValue);
  }
  clearSearchString() {
    this.searchString = "";
  }
  setValue(value, silent, fromPicker, skipRendering) {
    if (this.value === value) {
      return this;
    }
    const isArray = Array.isArray(value);
    if (value != null) {
      if (!isArray) {
        const list = this.listComponent?.getCurrentList();
        const index = list ? list.indexOf(value) : -1;
        if (index === -1) {
          return this;
        }
      }
      if (!fromPicker) {
        this.listComponent?.selectValue(value);
      }
    }
    super.setValue(value, silent);
    if (!skipRendering) {
      this.renderSelectedValue();
    }
    return this;
  }
  onNavigationKeyDown(event, key, announceItem) {
    event.preventDefault();
    const isDown = key === import_ag_grid_community27.KeyCode.DOWN;
    if (!this.isPickerDisplayed && isDown) {
      this.showPicker();
      return;
    }
    this.listComponent?.onNavigationKeyDown(key, announceItem);
  }
  onEnterKeyDown(e) {
    if (!this.isPickerDisplayed) {
      return;
    }
    e.preventDefault();
    if (this.listComponent?.getCurrentList()) {
      const lastRowHovered = this.listComponent.getLastItemHovered();
      if (this.config.multiSelect || lastRowHovered == null) {
        this.dispatchPickerEventAndHidePicker(this.value, true);
      } else {
        this.onListValueSelected(/* @__PURE__ */ new Set([lastRowHovered]), true);
      }
    }
  }
  onDeleteKeyDown(e) {
    const { eWrapper, beans } = this;
    const activeEl = (0, import_ag_grid_community27._getActiveDomElement)(beans);
    if (activeEl === eWrapper) {
      e.preventDefault();
      this.setValue([], true);
    }
  }
  onTabKeyDown() {
    const { config, isPickerDisplayed, listComponent } = this;
    const { multiSelect } = config;
    if (!isPickerDisplayed || !listComponent) {
      return;
    }
    if (multiSelect) {
      const values = this.getValueFromSet(listComponent.getSelectedItems());
      if (values) {
        this.setValue(values, false, true, true);
      }
    } else {
      this.setValue(listComponent.getLastItemHovered(), false, true);
    }
    this.hidePicker();
  }
  getValueFromSet(valueSet) {
    const { multiSelect } = this.config;
    let newValue = null;
    for (const value of valueSet) {
      if (valueSet.size === 1 && !multiSelect) {
        newValue = value;
        break;
      }
      if (!newValue) {
        newValue = [];
      }
      newValue.push(value);
    }
    if (Array.isArray(newValue)) {
      newValue.sort();
    }
    return newValue;
  }
  onListValueSelected(valueSet, fromEnterKey) {
    const newValue = this.getValueFromSet(valueSet);
    this.setValue(newValue, false, true);
    if (!this.config.multiSelect) {
      this.dispatchPickerEventAndHidePicker(newValue, fromEnterKey);
    }
  }
  dispatchPickerEventAndHidePicker(value, fromEnterKey) {
    const event = {
      type: "fieldPickerValueSelected",
      fromEnterKey,
      value
    };
    this.dispatchLocalEvent(event);
    this.hidePicker();
  }
  getFocusableElement() {
    const { allowTyping } = this.config;
    if (allowTyping) {
      return this.eInput.getFocusableElement();
    }
    return super.getFocusableElement();
  }
  onKeyDown(e) {
    const { key } = e;
    const { isPickerDisplayed, config, listComponent, pickerComponent } = this;
    const { allowTyping, multiSelect, suppressDeselectAll } = config;
    switch (key) {
      case import_ag_grid_community27.KeyCode.LEFT:
      case import_ag_grid_community27.KeyCode.RIGHT:
        if (!allowTyping || this.pillContainer) {
          e.preventDefault();
          if (this.pillContainer) {
            this.listComponent?.highlightIndex(-1);
            this.pillContainer.onNavigationKeyDown(e);
          }
        }
        break;
      case import_ag_grid_community27.KeyCode.PAGE_HOME:
      case import_ag_grid_community27.KeyCode.PAGE_END:
        if (allowTyping) {
          e.preventDefault();
          const inputEl = this.eInput.getInputElement();
          const target = key === import_ag_grid_community27.KeyCode.PAGE_HOME ? 0 : inputEl.value.length;
          inputEl.setSelectionRange(target, target);
          break;
        }
      case import_ag_grid_community27.KeyCode.PAGE_UP:
      case import_ag_grid_community27.KeyCode.PAGE_DOWN:
        e.preventDefault();
        if (pickerComponent) {
          listComponent?.navigateToPage(key);
        }
        break;
      case import_ag_grid_community27.KeyCode.DOWN:
      case import_ag_grid_community27.KeyCode.UP:
        this.onNavigationKeyDown(e, key, () => {
          if (multiSelect) {
            this.doWhileBlockingAnnouncement(() => this.eWrapper.focus());
            this.announceAriaValue(this.ariaToggleSelection);
          }
        });
        break;
      case import_ag_grid_community27.KeyCode.ESCAPE:
        if (isPickerDisplayed) {
          if ((0, import_ag_grid_community27._isVisible)(this.listComponent.getGui())) {
            e.preventDefault();
            (0, import_ag_grid_community27._stopPropagationForAgGrid)(e);
          }
          this.hidePicker();
        }
        break;
      case import_ag_grid_community27.KeyCode.ENTER:
        this.onEnterKeyDown(e);
        break;
      case import_ag_grid_community27.KeyCode.SPACE:
        if (isPickerDisplayed && multiSelect && listComponent) {
          e.preventDefault();
          const lastItemHovered = listComponent.getLastItemHovered();
          if (lastItemHovered) {
            listComponent.toggleListItemSelection(lastItemHovered);
          }
        }
        break;
      case import_ag_grid_community27.KeyCode.TAB:
        this.onTabKeyDown();
        break;
      case import_ag_grid_community27.KeyCode.DELETE:
        if (multiSelect && !suppressDeselectAll) {
          this.onDeleteKeyDown(e);
        }
        break;
      default:
        if (!allowTyping) {
          this.buildSearchStringFromKeyboardEvent(e);
        }
    }
  }
  announceAriaValue(value) {
    this.ariaAnnounce?.announceValue(value, "richSelect");
  }
  destroy() {
    if (this.listComponent) {
      this.listComponent = this.destroyBean(this.listComponent);
    }
    this.searchStrings = void 0;
    super.destroy();
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/builder/addDropdownComp.ts
var AddDropdownComp = class extends AgRichSelect {
  constructor(params) {
    super({
      ...params,
      template: (
        /* html */
        `
                <div class="ag-picker-field" role="presentation">
                    <div data-ref="eLabel"></div>
                    <div data-ref="eWrapper" class="ag-wrapper ag-picker-collapsed">
                        <div data-ref="eDisplayField" class="ag-picker-field-display"></div>
                        <ag-input-text-field data-ref="eInput" class="ag-rich-select-field-input"></ag-input-text-field>
                        <span data-ref="eDeselect" class="ag-rich-select-deselect-button ag-picker-field-icon" role="presentation"></span>
                        <div data-ref="eIcon" class="ag-picker-field-icon" aria-hidden="true"></div>
                    </div>
                </div>`
      ),
      agComponents: [import_ag_grid_community28.AgInputTextFieldSelector]
    });
    this.params = params;
  }
  showPicker() {
    setTimeout(() => super.showPicker());
  }
  hidePicker() {
    setTimeout(() => super.hidePicker());
  }
  postConstruct() {
    super.postConstruct();
    const { wrapperClassName, ariaLabel } = this.params;
    (0, import_ag_grid_community28._setDisplayed)(this.eDisplayField, false);
    if (wrapperClassName) {
      this.eWrapper.classList.add(wrapperClassName);
    }
    (0, import_ag_grid_community28._setAriaLabelledBy)(this.eWrapper, "");
    (0, import_ag_grid_community28._setAriaLabel)(this.eWrapper, ariaLabel);
  }
  onEnterKeyDown(event) {
    (0, import_ag_grid_community28._stopPropagationForAgGrid)(event);
    if (this.isPickerDisplayed) {
      super.onEnterKeyDown(event);
    } else {
      event.preventDefault();
      this.showPicker();
    }
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/builder/advancedFilterBuilderItemNavigationFeature.ts
var import_ag_grid_community29 = require("ag-grid-community");
var AdvancedFilterBuilderItemNavigationFeature = class extends import_ag_grid_community29.BeanStub {
  constructor(eGui, focusWrapper, eFocusableComp) {
    super();
    this.eGui = eGui;
    this.focusWrapper = focusWrapper;
    this.eFocusableComp = eFocusableComp;
  }
  postConstruct() {
    this.addManagedElementListeners(this.eGui, {
      keydown: (event) => {
        switch (event.key) {
          case import_ag_grid_community29.KeyCode.TAB:
            if (!event.defaultPrevented) {
              (0, import_ag_grid_community29._stopPropagationForAgGrid)(event);
            }
            break;
          case import_ag_grid_community29.KeyCode.UP:
          case import_ag_grid_community29.KeyCode.DOWN:
            (0, import_ag_grid_community29._stopPropagationForAgGrid)(event);
            break;
          case import_ag_grid_community29.KeyCode.ESCAPE:
            if ((0, import_ag_grid_community29._isStopPropagationForAgGrid)(event)) {
              return;
            }
            if (this.eGui.contains((0, import_ag_grid_community29._getActiveDomElement)(this.beans))) {
              event.preventDefault();
              (0, import_ag_grid_community29._stopPropagationForAgGrid)(event);
              this.focusWrapper.focus();
            }
            break;
        }
      }
    });
    const highlightClass = "ag-advanced-filter-builder-virtual-list-item-highlight";
    this.addManagedListeners(this.focusWrapper, {
      keydown: (event) => {
        switch (event.key) {
          case import_ag_grid_community29.KeyCode.ENTER:
            if ((0, import_ag_grid_community29._isStopPropagationForAgGrid)(event)) {
              return;
            }
            if ((0, import_ag_grid_community29._getActiveDomElement)(this.beans) === this.focusWrapper) {
              event.preventDefault();
              (0, import_ag_grid_community29._stopPropagationForAgGrid)(event);
              this.eFocusableComp.getFocusableElement().focus();
            }
            break;
        }
      },
      focusin: () => {
        this.focusWrapper.classList.add(highlightClass);
      },
      focusout: (event) => {
        if (!this.focusWrapper.contains(event.relatedTarget)) {
          this.focusWrapper.classList.remove(highlightClass);
        }
      }
    });
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/builder/advancedFilterBuilderUtils.ts
function getAdvancedFilterBuilderAddButtonParams(translate, maxPickerWidth) {
  return {
    pickerAriaLabelKey: "ariaLabelAdvancedFilterBuilderAddField",
    pickerAriaLabelValue: "Advanced Filter Builder Add Field",
    pickerType: "ag-list",
    valueList: [
      {
        key: "condition",
        displayValue: translate("advancedFilterBuilderAddCondition")
      },
      {
        key: "join",
        displayValue: translate("advancedFilterBuilderAddJoin")
      }
    ],
    valueFormatter: (value) => value == null ? "" : value.displayValue ?? value.key,
    pickerIcon: "advancedFilterBuilderAdd",
    maxPickerWidth: `${maxPickerWidth ?? 120}px`,
    wrapperClassName: "ag-advanced-filter-builder-item-button",
    ariaLabel: translate("advancedFilterBuilderAddButtonTooltip")
  };
}

// packages/ag-grid-enterprise/src/advancedFilter/builder/advancedFilterBuilderItemAddComp.ts
var AdvancedFilterBuilderItemAddComp = class extends import_ag_grid_community30.Component {
  constructor(item, focusWrapper) {
    super(
      /* html */
      `
            <div class="ag-advanced-filter-builder-item-wrapper" role="presentation">
                <div data-ref="eItem" class="ag-advanced-filter-builder-item" role="presentation">
                    <div class="ag-advanced-filter-builder-item-tree-lines" aria-hidden="true">
                        <div class="ag-advanced-filter-builder-item-tree-line-vertical-top ag-advanced-filter-builder-item-tree-line-horizontal"></div>
                    </div>
                </div>
            </div>
        `
    );
    this.item = item;
    this.focusWrapper = focusWrapper;
    this.eItem = import_ag_grid_community30.RefPlaceholder;
  }
  wireBeans(beans) {
    this.advFilterExpSvc = beans.advFilterExpSvc;
    this.registry = beans.registry;
  }
  postConstruct() {
    (0, import_ag_grid_community30._setAriaLevel)(this.focusWrapper, 2);
    const addButtonParams = getAdvancedFilterBuilderAddButtonParams(
      (key) => this.advFilterExpSvc.translate(key),
      this.gos.get("advancedFilterBuilderParams")?.addSelectWidth
    );
    const eAddButton = this.createManagedBean(new AddDropdownComp(addButtonParams));
    this.addManagedListeners(eAddButton, {
      fieldPickerValueSelected: ({ value }) => {
        this.dispatchLocalEvent({
          type: "advancedFilterBuilderAdded",
          item: this.item,
          isJoin: value.key === "join"
        });
      }
    });
    this.eItem.appendChild(eAddButton.getGui());
    this.createOptionalManagedBean(
      this.registry.createDynamicBean("tooltipFeature", false, {
        getGui: () => eAddButton.getGui(),
        getLocation: () => "advancedFilter",
        getTooltipValue: () => this.advFilterExpSvc.translate("advancedFilterBuilderAddButtonTooltip")
      })
    );
    this.createManagedBean(
      new AdvancedFilterBuilderItemNavigationFeature(this.getGui(), this.focusWrapper, eAddButton)
    );
    (0, import_ag_grid_community30._setAriaLabel)(
      this.focusWrapper,
      this.advFilterExpSvc.translate("ariaAdvancedFilterBuilderItem", [
        this.advFilterExpSvc.translate("advancedFilterBuilderAddButtonTooltip"),
        `${this.item.level + 1}`
      ])
    );
  }
  afterAdd() {
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/builder/advancedFilterBuilderItemComp.ts
var import_ag_grid_community35 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/advancedFilter/builder/conditionPillWrapperComp.ts
var import_ag_grid_community31 = require("ag-grid-community");
var ConditionPillWrapperComp = class extends import_ag_grid_community31.Component {
  constructor() {
    super(
      /* html */
      `
            <div class="ag-advanced-filter-builder-item-condition" role="presentation"></div>
        `
    );
    this.validationMessage = null;
  }
  wireBeans(beans) {
    this.advFilterExpSvc = beans.advFilterExpSvc;
  }
  init(params) {
    const { item, createPill } = params;
    this.item = item;
    this.createPill = createPill;
    this.filterModel = item.filterModel;
    this.setupColumnCondition(this.filterModel);
    this.validate();
    this.addDestroyFunc(() => this.destroyBeans([this.eColumnPill, this.eOperatorPill, this.eOperandPill]));
  }
  getDragName() {
    return this.filterModel.colId ? this.advFilterExpSvc.parseColumnFilterModel(this.filterModel) : this.getDefaultColumnDisplayValue();
  }
  getAriaLabel() {
    return `${this.advFilterExpSvc.translate("ariaAdvancedFilterBuilderFilterItem")} ${this.getDragName()}`;
  }
  getValidationMessage() {
    return this.validationMessage;
  }
  getFocusableElement() {
    return this.eColumnPill.getFocusableElement();
  }
  setupColumnCondition(filterModel) {
    const columnDetails = this.advFilterExpSvc.getColumnDetails(filterModel.colId);
    this.baseCellDataType = columnDetails.baseCellDataType;
    this.column = columnDetails.column;
    this.numOperands = this.getNumOperands(this.getOperatorKey());
    this.eColumnPill = this.createPill({
      key: this.getColumnKey(),
      displayValue: this.getColumnDisplayValue() ?? this.getDefaultColumnDisplayValue(),
      cssClass: "ag-advanced-filter-builder-column-pill",
      isSelect: true,
      getEditorParams: () => ({ values: this.advFilterExpSvc.getColumnAutocompleteEntries() }),
      update: (key) => this.setColumnKey(key),
      pickerAriaLabelKey: "ariaLabelAdvancedFilterBuilderColumnSelectField",
      pickerAriaLabelValue: "Advanced Filter Builder Column Select Field",
      ariaLabel: this.advFilterExpSvc.translate("ariaAdvancedFilterBuilderColumn")
    });
    this.getGui().appendChild(this.eColumnPill.getGui());
    if ((0, import_ag_grid_community31._exists)(this.getColumnKey())) {
      this.createOperatorPill();
      if (this.hasOperand()) {
        this.createOperandPill();
      }
    }
  }
  createOperatorPill() {
    this.eOperatorPill = this.createPill({
      key: this.getOperatorKey(),
      displayValue: this.getOperatorDisplayValue() ?? this.getDefaultOptionSelectValue(),
      cssClass: "ag-advanced-filter-builder-option-pill",
      isSelect: true,
      getEditorParams: () => ({ values: this.getOperatorAutocompleteEntries() }),
      update: (key) => this.setOperatorKey(key),
      pickerAriaLabelKey: "ariaLabelAdvancedFilterBuilderOptionSelectField",
      pickerAriaLabelValue: "Advanced Filter Builder Option Select Field",
      ariaLabel: this.advFilterExpSvc.translate("ariaAdvancedFilterBuilderOption")
    });
    this.eColumnPill.getGui().insertAdjacentElement("afterend", this.eOperatorPill.getGui());
  }
  createOperandPill() {
    const { filter } = this.filterModel;
    const key = (typeof filter === "number" ? (0, import_ag_grid_community31._toStringOrNull)(filter) : filter) ?? "";
    this.eOperandPill = this.createPill({
      key,
      // Convert from the input format to display format.
      // Input format matches model format except for numbers, but these get stringified anyway
      valueFormatter: (value) => this.advFilterExpSvc.getOperandDisplayValue({ ...this.filterModel, filter: value }, true),
      baseCellDataType: this.baseCellDataType,
      cssClass: "ag-advanced-filter-builder-value-pill",
      isSelect: false,
      update: (key2) => this.setOperand(key2),
      ariaLabel: this.advFilterExpSvc.translate("ariaAdvancedFilterBuilderValue")
    });
    this.getGui().appendChild(this.eOperandPill.getGui());
  }
  getColumnKey() {
    return this.filterModel.colId;
  }
  getColumnDisplayValue() {
    return this.advFilterExpSvc.getColumnDisplayValue(this.filterModel);
  }
  getOperatorKey() {
    return this.filterModel.type;
  }
  getOperatorDisplayValue() {
    return this.advFilterExpSvc.getOperatorDisplayValue(this.filterModel);
  }
  getOperandDisplayValue() {
    return this.advFilterExpSvc.getOperandDisplayValue(this.filterModel, true);
  }
  hasOperand() {
    return this.numOperands > 0;
  }
  getOperatorAutocompleteEntries() {
    return this.column ? this.advFilterExpSvc.getOperatorAutocompleteEntries(this.column, this.baseCellDataType) : [];
  }
  setColumnKey(colId) {
    if (!this.eOperatorPill) {
      this.createOperatorPill();
    }
    const newColumnDetails = this.advFilterExpSvc.getColumnDetails(colId);
    this.column = newColumnDetails.column;
    const newBaseCellDataType = newColumnDetails.baseCellDataType;
    if (this.baseCellDataType !== newBaseCellDataType) {
      this.baseCellDataType = newBaseCellDataType;
      this.setOperatorKey(void 0);
      if (this.eOperatorPill) {
        (0, import_ag_grid_community31._removeFromParent)(this.eOperatorPill.getGui());
        this.destroyBean(this.eOperatorPill);
        this.createOperatorPill();
      }
      this.validate();
    }
    this.filterModel.colId = colId;
    this.filterModel.filterType = this.baseCellDataType;
  }
  setOperatorKey(operator) {
    const newNumOperands = this.getNumOperands(operator);
    if (newNumOperands !== this.numOperands) {
      this.numOperands = newNumOperands;
      if (newNumOperands === 0) {
        this.destroyOperandPill();
      } else {
        this.createOperandPill();
        if (this.baseCellDataType !== "number") {
          this.setOperand("");
        }
      }
    }
    this.filterModel.type = operator;
    this.validate();
  }
  setOperand(operand) {
    let parsedOperand = operand;
    if (this.baseCellDataType === "number") {
      parsedOperand = (0, import_ag_grid_community31._exists)(operand) ? Number(operand) : "";
    }
    this.filterModel.filter = parsedOperand;
    this.validate();
  }
  getNumOperands(operator) {
    return this.advFilterExpSvc.getExpressionOperator(this.baseCellDataType, operator)?.numOperands ?? 0;
  }
  destroyOperandPill() {
    delete this.filterModel.filter;
    this.getGui().removeChild(this.eOperandPill.getGui());
    this.destroyBean(this.eOperandPill);
    this.eOperandPill = void 0;
  }
  validate() {
    let validationMessage = null;
    if (!(0, import_ag_grid_community31._exists)(this.getColumnKey())) {
      validationMessage = this.advFilterExpSvc.translate("advancedFilterBuilderValidationSelectColumn");
    } else if (!(0, import_ag_grid_community31._exists)(this.getOperatorKey())) {
      validationMessage = this.advFilterExpSvc.translate("advancedFilterBuilderValidationSelectOption");
    } else if (this.numOperands > 0 && !(0, import_ag_grid_community31._exists)(this.getOperandDisplayValue())) {
      validationMessage = this.advFilterExpSvc.translate("advancedFilterBuilderValidationEnterValue");
    }
    this.item.valid = !validationMessage;
    if (validationMessage !== this.validationMessage) {
      this.validationMessage = validationMessage;
      this.dispatchLocalEvent({
        type: "advancedFilterBuilderValidChanged"
      });
    }
  }
  getDefaultColumnDisplayValue() {
    return this.advFilterExpSvc.translate("advancedFilterBuilderSelectColumn");
  }
  getDefaultOptionSelectValue() {
    return this.advFilterExpSvc.translate("advancedFilterBuilderSelectOption");
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/builder/inputPillComp.ts
var import_ag_grid_community32 = require("ag-grid-community");
var InputPillComp = class extends import_ag_grid_community32.Component {
  constructor(params) {
    super(
      /* html */
      `
            <div class="ag-advanced-filter-builder-pill-wrapper" role="presentation">
                <div data-ref="ePill" class="ag-advanced-filter-builder-pill" role="button">
                    <span data-ref="eLabel" class="ag-advanced-filter-builder-pill-display"></span>
                </div>
            </div>
        `
    );
    this.params = params;
    this.ePill = import_ag_grid_community32.RefPlaceholder;
    this.eLabel = import_ag_grid_community32.RefPlaceholder;
    const { value, valueFormatter } = params;
    this.value = value;
    this.displayValue = valueFormatter(value);
  }
  wireBeans(beans) {
    this.advFilterExpSvc = beans.advFilterExpSvc;
  }
  postConstruct() {
    const { cssClass, ariaLabel } = this.params;
    this.ePill.classList.add(cssClass);
    this.activateTabIndex([this.ePill]);
    this.eLabel.id = `${this.getCompId()}`;
    (0, import_ag_grid_community32._setAriaDescribedBy)(this.ePill, this.eLabel.id);
    (0, import_ag_grid_community32._setAriaLabel)(this.ePill, ariaLabel);
    this.renderValue();
    this.addManagedListeners(this.ePill, {
      click: (event) => {
        event.preventDefault();
        this.showEditor();
      },
      keydown: (event) => {
        switch (event.key) {
          case import_ag_grid_community32.KeyCode.ENTER:
            event.preventDefault();
            (0, import_ag_grid_community32._stopPropagationForAgGrid)(event);
            this.showEditor();
            break;
        }
      }
    });
    this.addDestroyFunc(() => this.destroyBean(this.eEditor));
  }
  getFocusableElement() {
    return this.ePill;
  }
  showEditor() {
    if (this.eEditor) {
      return;
    }
    (0, import_ag_grid_community32._setDisplayed)(this.ePill, false);
    this.eEditor = this.createEditorComp(this.params.type);
    this.eEditor.setValue(this.value);
    const eEditorGui = this.eEditor.getGui();
    this.eEditor.addManagedElementListeners(eEditorGui, {
      keydown: (event) => {
        switch (event.key) {
          case import_ag_grid_community32.KeyCode.ENTER:
            event.preventDefault();
            (0, import_ag_grid_community32._stopPropagationForAgGrid)(event);
            this.updateValue(true);
            break;
          case import_ag_grid_community32.KeyCode.ESCAPE:
            event.preventDefault();
            (0, import_ag_grid_community32._stopPropagationForAgGrid)(event);
            this.hideEditor(true);
            break;
        }
      },
      focusout: () => this.updateValue(false)
    });
    this.getGui().appendChild(eEditorGui);
    this.eEditor.getFocusableElement().focus();
  }
  createEditorComp(type) {
    let comp;
    switch (type) {
      case "text":
        comp = new import_ag_grid_community32.AgInputTextField();
        break;
      case "number":
        comp = new import_ag_grid_community32.AgInputNumberField();
        break;
      case "date":
        comp = new import_ag_grid_community32.AgInputDateField();
        break;
    }
    return this.createBean(comp);
  }
  hideEditor(keepFocus) {
    const { eEditor } = this;
    if (!eEditor) {
      return;
    }
    this.eEditor = void 0;
    this.getGui().removeChild(eEditor.getGui());
    this.destroyBean(eEditor);
    (0, import_ag_grid_community32._setDisplayed)(this.ePill, true);
    if (keepFocus) {
      this.ePill.focus();
    }
  }
  renderValue() {
    let value;
    const { displayValue, eLabel } = this;
    const { classList } = eLabel;
    classList.remove(
      "ag-advanced-filter-builder-value-empty",
      "ag-advanced-filter-builder-value-number",
      "ag-advanced-filter-builder-value-text"
    );
    if (!(0, import_ag_grid_community32._exists)(displayValue)) {
      value = this.advFilterExpSvc.translate("advancedFilterBuilderEnterValue");
      classList.add("ag-advanced-filter-builder-value-empty");
    } else if (this.params.type === "number") {
      value = displayValue;
      classList.add("ag-advanced-filter-builder-value-number");
    } else {
      value = `"${displayValue}"`;
      classList.add("ag-advanced-filter-builder-value-text");
    }
    eLabel.innerText = value;
  }
  updateValue(keepFocus) {
    if (!this.eEditor) {
      return;
    }
    const value = this.eEditor.getValue() ?? "";
    this.dispatchLocalEvent({
      type: "fieldValueChanged",
      value
    });
    this.value = value;
    this.displayValue = this.params.valueFormatter(value);
    this.renderValue();
    this.hideEditor(keepFocus);
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/builder/joinPillWrapperComp.ts
var import_ag_grid_community33 = require("ag-grid-community");
var JoinPillWrapperComp = class extends import_ag_grid_community33.Component {
  wireBeans(beans) {
    this.advFilterExpSvc = beans.advFilterExpSvc;
  }
  constructor() {
    super(
      /* html */
      `
            <div class="ag-advanced-filter-builder-item-condition" role="presentation"></div>
        `
    );
  }
  init(params) {
    const { item, createPill } = params;
    const filterModel = item.filterModel;
    this.filterModel = filterModel;
    this.ePill = createPill({
      key: filterModel.type,
      displayValue: this.advFilterExpSvc.parseJoinOperator(filterModel),
      cssClass: "ag-advanced-filter-builder-join-pill",
      isSelect: true,
      getEditorParams: () => ({
        values: this.advFilterExpSvc.getJoinOperatorAutocompleteEntries()
      }),
      update: (key) => filterModel.type = key,
      pickerAriaLabelKey: "ariaLabelAdvancedFilterBuilderJoinSelectField",
      pickerAriaLabelValue: "Advanced Filter Builder Join Operator Select Field",
      ariaLabel: this.advFilterExpSvc.translate("ariaAdvancedFilterBuilderJoinOperator")
    });
    this.getGui().appendChild(this.ePill.getGui());
    this.addDestroyFunc(() => this.destroyBean(this.ePill));
  }
  getDragName() {
    return this.advFilterExpSvc.parseJoinOperator(this.filterModel);
  }
  getAriaLabel() {
    return `${this.advFilterExpSvc.translate("ariaAdvancedFilterBuilderGroupItem")} ${this.getDragName()}`;
  }
  getValidationMessage() {
    return null;
  }
  getFocusableElement() {
    return this.ePill.getFocusableElement();
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/builder/selectPillComp.ts
var import_ag_grid_community34 = require("ag-grid-community");
var SelectPillComp = class extends AgRichSelect {
  constructor(params) {
    super({
      ...params,
      template: (
        /* html */
        `
                <div class="ag-picker-field ag-advanced-filter-builder-pill-wrapper" role="presentation">
                    <div data-ref="eLabel"></div>
                    <div data-ref="eWrapper" class="ag-wrapper ag-advanced-filter-builder-pill ag-picker-collapsed">
                        <div data-ref="eDisplayField" class="ag-picker-field-display ag-advanced-filter-builder-pill-display"></div>
                        <ag-input-text-field data-ref="eInput" class="ag-rich-select-field-input"></ag-input-text-field>
                        <span data-ref="eDeselect" class="ag-rich-select-deselect-button ag-picker-field-icon" role="presentation"></span>
                        <div data-ref="eIcon" class="ag-picker-field-icon" aria-hidden="true"></div>
                    </div>
                </div>`
      ),
      agComponents: [import_ag_grid_community34.AgInputTextFieldSelector]
    });
    this.params = params;
  }
  getFocusableElement() {
    return this.eWrapper;
  }
  showPicker() {
    setTimeout(() => super.showPicker());
  }
  hidePicker() {
    setTimeout(() => super.hidePicker());
  }
  postConstruct() {
    super.postConstruct();
    const { wrapperClassName, ariaLabel } = this.params;
    this.eWrapper.classList.add(wrapperClassName);
    (0, import_ag_grid_community34._setAriaLabelledBy)(this.eWrapper, "");
    (0, import_ag_grid_community34._setAriaLabel)(this.eWrapper, ariaLabel);
  }
  createPickerComponent() {
    if (!this.values) {
      const { values } = this.params.getEditorParams();
      this.values = values;
      const key = this.value.key;
      const value = values.find((value2) => value2.key === key) ?? {
        key,
        displayValue: this.value.displayValue
      };
      this.value = value;
    }
    return super.createPickerComponent();
  }
  onEnterKeyDown(event) {
    (0, import_ag_grid_community34._stopPropagationForAgGrid)(event);
    if (this.isPickerDisplayed) {
      super.onEnterKeyDown(event);
    } else {
      event.preventDefault();
      this.showPicker();
    }
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/builder/advancedFilterBuilderItemComp.ts
var AdvancedFilterBuilderItemComp = class extends import_ag_grid_community35.TabGuardComp {
  constructor(item, dragFeature, focusWrapper) {
    super(
      /* html */
      `
            <div class="ag-advanced-filter-builder-item-wrapper" role="presentation">
                <div class="ag-advanced-filter-builder-item" role="presentation">
                    <div data-ref="eTreeLines" class="ag-advanced-filter-builder-item-tree-lines" aria-hidden="true"></div>
                    <span data-ref="eDragHandle" class="ag-drag-handle" aria-hidden="true"></span>
                    <span data-ref="eValidation" class="ag-advanced-filter-builder-item-button ag-advanced-filter-builder-invalid" aria-hidden="true"></span>
                </div>
                <div data-ref="eButtons" class="ag-advanced-filter-builder-item-buttons">
                    <span data-ref="eMoveUpButton" class="ag-advanced-filter-builder-item-button" role="button"></span>
                    <span data-ref="eMoveDownButton" class="ag-advanced-filter-builder-item-button" role="button"></span>
                    <div data-ref="eAddButton" role="presentation"></div>
                    <span data-ref="eRemoveButton" class="ag-advanced-filter-builder-item-button" role="button"></span>
                </div>
            </div>
        `
    );
    this.item = item;
    this.dragFeature = dragFeature;
    this.focusWrapper = focusWrapper;
    this.eTreeLines = import_ag_grid_community35.RefPlaceholder;
    this.eDragHandle = import_ag_grid_community35.RefPlaceholder;
    this.eButtons = import_ag_grid_community35.RefPlaceholder;
    this.eValidation = import_ag_grid_community35.RefPlaceholder;
    this.eMoveUpButton = import_ag_grid_community35.RefPlaceholder;
    this.eMoveDownButton = import_ag_grid_community35.RefPlaceholder;
    this.eAddButton = import_ag_grid_community35.RefPlaceholder;
    this.eRemoveButton = import_ag_grid_community35.RefPlaceholder;
    this.moveUpDisabled = false;
    this.moveDownDisabled = false;
  }
  wireBeans(beans) {
    this.dragAndDrop = beans.dragAndDrop;
    this.advFilterExpSvc = beans.advFilterExpSvc;
    this.registry = beans.registry;
  }
  postConstruct() {
    const { filterModel, level, showMove } = this.item;
    const isJoin = filterModel.filterType === "join";
    this.ePillWrapper = this.createManagedBean(isJoin ? new JoinPillWrapperComp() : new ConditionPillWrapperComp());
    this.ePillWrapper.init({ item: this.item, createPill: (params) => this.createPill(params) });
    this.eDragHandle.insertAdjacentElement("afterend", this.ePillWrapper.getGui());
    if (level === 0) {
      const eTreeLine = document.createElement("div");
      eTreeLine.classList.add("ag-advanced-filter-builder-item-tree-line-vertical-bottom");
      eTreeLine.classList.add("ag-advanced-filter-builder-item-tree-line-root");
      this.eTreeLines.appendChild(eTreeLine);
      (0, import_ag_grid_community35._setDisplayed)(this.eDragHandle, false);
      (0, import_ag_grid_community35._setDisplayed)(this.eButtons, false);
      (0, import_ag_grid_community35._setAriaExpanded)(this.focusWrapper, true);
    } else {
      this.setupTreeLines(level);
      this.eDragHandle.appendChild((0, import_ag_grid_community35._createIconNoSpan)("advancedFilterBuilderDrag", this.beans));
      this.setupValidation();
      this.setupMoveButtons(showMove);
      this.setupAddButton();
      this.setupRemoveButton();
      this.setupDragging();
      this.updateAriaExpanded();
    }
    (0, import_ag_grid_community35._setAriaLevel)(this.focusWrapper, level + 1);
    this.initialiseTabGuard({});
    this.createManagedBean(
      new AdvancedFilterBuilderItemNavigationFeature(this.getGui(), this.focusWrapper, this.ePillWrapper)
    );
    this.updateAriaLabel();
    this.addManagedListeners(this.ePillWrapper, {
      advancedFilterBuilderValueChanged: () => this.dispatchLocalEvent({
        type: "advancedFilterBuilderValueChanged"
      }),
      advancedFilterBuilderValidChanged: () => this.updateValidity()
    });
  }
  setState(params) {
    const { level } = this.item;
    if (level === 0) {
      return;
    }
    const { showMove } = this.item;
    const { disableMoveUp, disableMoveDown, treeLines, showStartTreeLine } = params;
    this.updateTreeLines(treeLines, showStartTreeLine);
    this.updateAriaExpanded();
    if (showMove) {
      this.moveUpDisabled = !!disableMoveUp;
      this.moveDownDisabled = !!disableMoveDown;
      this.eMoveUpButton.classList.toggle("ag-advanced-filter-builder-item-button-disabled", disableMoveUp);
      this.eMoveDownButton.classList.toggle("ag-advanced-filter-builder-item-button-disabled", disableMoveDown);
      (0, import_ag_grid_community35._setAriaDisabled)(this.eMoveUpButton, !!disableMoveUp);
      (0, import_ag_grid_community35._setAriaDisabled)(this.eMoveDownButton, !!disableMoveDown);
      this.moveUpTooltipFeature?.refreshTooltip();
      this.moveDownTooltipFeature?.refreshTooltip();
    }
  }
  focusMoveButton(backwards) {
    (backwards ? this.eMoveUpButton : this.eMoveDownButton).focus();
  }
  afterAdd() {
    this.ePillWrapper.getFocusableElement().focus();
  }
  setupTreeLines(level) {
    for (let i = 0; i < level; i++) {
      const eTreeLine = document.createElement("div");
      this.eTreeLines.appendChild(eTreeLine);
    }
  }
  updateTreeLines(treeLines, showStartTreeLine) {
    const lastTreeLineIndex = treeLines.length - 1;
    const { children } = this.eTreeLines;
    for (let i = 0; i < lastTreeLineIndex; i++) {
      const eTreeLine2 = children.item(i);
      if (eTreeLine2) {
        eTreeLine2.classList.toggle("ag-advanced-filter-builder-item-tree-line-vertical", !treeLines[i]);
      }
    }
    const eTreeLine = children.item(lastTreeLineIndex);
    if (eTreeLine) {
      eTreeLine.classList.add("ag-advanced-filter-builder-item-tree-line-horizontal");
      const isLastChild = treeLines[lastTreeLineIndex];
      eTreeLine.classList.toggle("ag-advanced-filter-builder-item-tree-line-vertical-top", isLastChild);
      eTreeLine.classList.toggle("ag-advanced-filter-builder-item-tree-line-vertical", !isLastChild);
    }
    this.eDragHandle.classList.toggle(
      "ag-advanced-filter-builder-item-tree-line-vertical-bottom",
      showStartTreeLine
    );
  }
  setupValidation() {
    this.eValidation.appendChild((0, import_ag_grid_community35._createIconNoSpan)("advancedFilterBuilderInvalid", this.beans));
    this.validationTooltipFeature = this.createOptionalManagedBean(
      this.registry.createDynamicBean("tooltipFeature", false, {
        getGui: () => this.eValidation,
        getLocation: () => "advancedFilter",
        getTooltipValue: () => this.ePillWrapper.getValidationMessage(),
        getTooltipShowDelayOverride: () => 1e3
      })
    );
    this.updateValidity();
  }
  setupAddButton() {
    const addButtonParams = getAdvancedFilterBuilderAddButtonParams(
      (key) => this.advFilterExpSvc.translate(key),
      this.gos.get("advancedFilterBuilderParams")?.addSelectWidth
    );
    const eAddButton = this.createManagedBean(new AddDropdownComp(addButtonParams));
    this.addManagedListeners(eAddButton, {
      fieldPickerValueSelected: ({ value }) => this.dispatchLocalEvent({
        type: "advancedFilterBuilderAdded",
        item: this.item,
        isJoin: value.key === "join"
      })
    });
    this.eAddButton.appendChild(eAddButton.getGui());
    this.createOptionalManagedBean(
      this.registry.createDynamicBean("tooltipFeature", false, {
        getGui: () => this.eAddButton,
        getLocation: () => "advancedFilter",
        getTooltipValue: () => this.advFilterExpSvc.translate("advancedFilterBuilderAddButtonTooltip")
      })
    );
  }
  setupRemoveButton() {
    this.eRemoveButton.appendChild((0, import_ag_grid_community35._createIconNoSpan)("advancedFilterBuilderRemove", this.beans));
    this.addManagedListeners(this.eRemoveButton, {
      click: () => this.removeItem(),
      keydown: (event) => {
        switch (event.key) {
          case import_ag_grid_community35.KeyCode.ENTER:
            event.preventDefault();
            (0, import_ag_grid_community35._stopPropagationForAgGrid)(event);
            this.removeItem();
            break;
        }
      }
    });
    this.createOptionalManagedBean(
      this.registry.createDynamicBean("tooltipFeature", false, {
        getGui: () => this.eRemoveButton,
        getLocation: () => "advancedFilter",
        getTooltipValue: () => this.advFilterExpSvc.translate("advancedFilterBuilderRemoveButtonTooltip")
      })
    );
    (0, import_ag_grid_community35._setAriaLabel)(this.eRemoveButton, this.advFilterExpSvc.translate("advancedFilterBuilderRemoveButtonTooltip"));
    this.activateTabIndex([this.eRemoveButton]);
  }
  setupMoveButtons(showMove) {
    if (showMove) {
      this.eMoveUpButton.appendChild((0, import_ag_grid_community35._createIconNoSpan)("advancedFilterBuilderMoveUp", this.beans));
      this.addManagedListeners(this.eMoveUpButton, {
        click: () => this.moveItem(true),
        keydown: (event) => {
          switch (event.key) {
            case import_ag_grid_community35.KeyCode.ENTER:
              event.preventDefault();
              (0, import_ag_grid_community35._stopPropagationForAgGrid)(event);
              this.moveItem(true);
              break;
          }
        }
      });
      this.moveUpTooltipFeature = this.createOptionalManagedBean(
        this.registry.createDynamicBean("tooltipFeature", false, {
          getGui: () => this.eMoveUpButton,
          getLocation: () => "advancedFilter",
          getTooltipValue: () => this.moveUpDisabled ? null : this.advFilterExpSvc.translate("advancedFilterBuilderMoveUpButtonTooltip")
        })
      );
      (0, import_ag_grid_community35._setAriaLabel)(
        this.eMoveUpButton,
        this.advFilterExpSvc.translate("advancedFilterBuilderMoveUpButtonTooltip")
      );
      this.eMoveDownButton.appendChild((0, import_ag_grid_community35._createIconNoSpan)("advancedFilterBuilderMoveDown", this.beans));
      this.addManagedListeners(this.eMoveDownButton, {
        click: () => this.moveItem(false),
        keydown: (event) => {
          switch (event.key) {
            case import_ag_grid_community35.KeyCode.ENTER:
              event.preventDefault();
              (0, import_ag_grid_community35._stopPropagationForAgGrid)(event);
              this.moveItem(false);
              break;
          }
        }
      });
      this.moveDownTooltipFeature = this.createOptionalManagedBean(
        this.registry.createDynamicBean("tooltipFeature", false, {
          getGui: () => this.eMoveDownButton,
          getLocation: () => "advancedFilter",
          getTooltipValue: () => this.moveDownDisabled ? null : this.advFilterExpSvc.translate("advancedFilterBuilderMoveDownButtonTooltip")
        })
      );
      (0, import_ag_grid_community35._setAriaLabel)(
        this.eMoveDownButton,
        this.advFilterExpSvc.translate("advancedFilterBuilderMoveDownButtonTooltip")
      );
      this.activateTabIndex([this.eMoveUpButton, this.eMoveDownButton]);
    } else {
      (0, import_ag_grid_community35._setDisplayed)(this.eMoveUpButton, false);
      (0, import_ag_grid_community35._setDisplayed)(this.eMoveDownButton, false);
    }
  }
  updateValidity() {
    (0, import_ag_grid_community35._setVisible)(this.eValidation, !this.item.valid);
    this.validationTooltipFeature?.refreshTooltip();
    this.updateAriaLabel();
  }
  createPill(params) {
    const { key, cssClass, update, ariaLabel } = params;
    const onUpdated = (key2) => {
      if (key2 == null) {
        return;
      }
      update(key2);
      this.dispatchLocalEvent({
        type: "advancedFilterBuilderValueChanged"
      });
    };
    if (params.isSelect) {
      const { getEditorParams, pickerAriaLabelKey, pickerAriaLabelValue, displayValue } = params;
      const advancedFilterBuilderParams = this.gos.get("advancedFilterBuilderParams");
      const minPickerWidth = `${advancedFilterBuilderParams?.pillSelectMinWidth ?? 140}px`;
      const maxPickerWidth = `${advancedFilterBuilderParams?.pillSelectMaxWidth ?? 200}px`;
      const comp = this.createBean(
        new SelectPillComp({
          pickerAriaLabelKey,
          pickerAriaLabelValue,
          pickerType: "ag-list",
          value: {
            key,
            displayValue
          },
          valueFormatter: (value) => value == null ? "" : value.displayValue ?? value.key,
          variableWidth: true,
          minPickerWidth,
          maxPickerWidth,
          getEditorParams,
          wrapperClassName: cssClass,
          ariaLabel,
          pickerIcon: "advancedFilterBuilderSelectOpen"
        })
      );
      this.addManagedListeners(comp, {
        fieldPickerValueSelected: ({ value }) => onUpdated(value?.key)
      });
      return comp;
    } else {
      const { baseCellDataType, valueFormatter } = params;
      const comp = this.createBean(
        new InputPillComp({
          value: key,
          valueFormatter,
          cssClass,
          type: this.getInputType(baseCellDataType),
          ariaLabel
        })
      );
      this.addManagedListeners(comp, { fieldValueChanged: ({ value }) => onUpdated(value) });
      return comp;
    }
  }
  getInputType(baseCellDataType) {
    switch (baseCellDataType) {
      case "text":
      case "object":
      case "boolean":
        return "text";
      case "number":
        return "number";
      case "date":
      case "dateString":
        return "date";
    }
  }
  setupDragging() {
    const dragSource = {
      type: import_ag_grid_community35.DragSourceType.AdvancedFilterBuilder,
      eElement: this.eDragHandle,
      dragItemName: () => this.ePillWrapper.getDragName(),
      getDefaultIconName: () => "notAllowed",
      getDragItem: () => ({}),
      onDragStarted: () => this.dragFeature.dispatchLocalEvent({
        type: "advancedFilterBuilderDragStarted",
        item: this.item
      }),
      onDragStopped: () => this.dragFeature.dispatchLocalEvent({
        type: "advancedFilterBuilderDragEnded"
      })
    };
    this.dragAndDrop.addDragSource(dragSource, true);
    this.addDestroyFunc(() => this.dragAndDrop.removeDragSource(dragSource));
  }
  updateAriaLabel() {
    const wrapperLabel = this.ePillWrapper.getAriaLabel();
    const level = `${this.item.level + 1}`;
    const validationMessage = this.ePillWrapper.getValidationMessage();
    let ariaLabel;
    if (validationMessage) {
      ariaLabel = this.advFilterExpSvc.translate("ariaAdvancedFilterBuilderItemValidation", [
        wrapperLabel,
        level,
        validationMessage
      ]);
    } else {
      ariaLabel = this.advFilterExpSvc.translate("ariaAdvancedFilterBuilderItem", [wrapperLabel, level]);
    }
    (0, import_ag_grid_community35._setAriaLabel)(this.focusWrapper, ariaLabel);
  }
  updateAriaExpanded() {
    (0, import_ag_grid_community35._removeAriaExpanded)(this.focusWrapper);
    const { filterModel } = this.item;
    if (filterModel?.filterType === "join" && filterModel.conditions.length) {
      (0, import_ag_grid_community35._setAriaExpanded)(this.focusWrapper, true);
    }
  }
  removeItem() {
    this.dispatchLocalEvent({
      type: "advancedFilterBuilderRemoved",
      item: this.item
    });
  }
  moveItem(backwards) {
    this.dispatchLocalEvent({
      type: "advancedFilterBuilderMoved",
      item: this.item,
      backwards
    });
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/builder/advancedFilterBuilderComp.ts
var AdvancedFilterBuilderComp = class extends import_ag_grid_community36.Component {
  constructor() {
    super(
      /* html */
      `
            <div role="presentation" class="ag-advanced-filter-builder" tabindex="-1">
                <div role="presentation" class="ag-advanced-filter-builder-list" data-ref="eList"></div>
                <div role="presentation" class="ag-advanced-filter-builder-button-panel">
                    <button class="ag-button ag-standard-button ag-advanced-filter-builder-apply-button" data-ref="eApplyFilterButton"></button>
                    <button class="ag-button ag-standard-button ag-advanced-filter-builder-cancel-button" data-ref="eCancelFilterButton"></button>
                </div>
            </div>`
    );
    this.eList = import_ag_grid_community36.RefPlaceholder;
    this.eApplyFilterButton = import_ag_grid_community36.RefPlaceholder;
    this.eCancelFilterButton = import_ag_grid_community36.RefPlaceholder;
    this.validationMessage = null;
  }
  wireBeans(beans) {
    this.filterManager = beans.filterManager;
    this.advancedFilter = beans.advancedFilter;
    this.advFilterExpSvc = beans.advFilterExpSvc;
    this.registry = beans.registry;
  }
  postConstruct() {
    const { showMoveButtons } = this.gos.get("advancedFilterBuilderParams") ?? {};
    this.showMove = !!showMoveButtons;
    this.addManagedPropertyListener("advancedFilterBuilderParams", ({ currentValue }) => {
      this.showMove = !!currentValue?.showMoveButtons;
      this.refreshList(false);
    });
    this.filterModel = this.setupFilterModel();
    this.setupVirtualList();
    this.dragFeature = this.createManagedBean(new AdvancedFilterBuilderDragFeature(this, this.virtualList));
    this.setupButtons();
  }
  refresh() {
    const virtualList = this.virtualList;
    let indexToFocus = virtualList.getLastFocusedRow();
    this.setupFilterModel();
    this.validateItems();
    this.refreshList(false);
    if (indexToFocus != null) {
      if (!virtualList.getComponentAt(indexToFocus)) {
        indexToFocus = 0;
      }
      virtualList.focusRow(indexToFocus);
    }
  }
  getNumItems() {
    return this.items.length;
  }
  moveItem(item, destination) {
    if (!destination || !item) {
      return;
    }
    this.moveItemToIndex(item, destination.rowIndex, destination.position);
  }
  afterGuiAttached() {
    this.virtualList.awaitStable(() => this.virtualList.focusRow(0));
  }
  setupVirtualList() {
    const virtualList = this.virtualList = this.createManagedBean(
      new VirtualList({
        cssIdentifier: "advanced-filter-builder",
        ariaRole: "tree",
        listName: this.advFilterExpSvc.translate("ariaAdvancedFilterBuilderList")
      })
    );
    virtualList.setComponentCreator(this.createItemComponent.bind(this));
    virtualList.setComponentUpdater(this.updateItemComponent.bind(this));
    virtualList.setRowHeight(40);
    this.eList.appendChild(virtualList.getGui());
    virtualList.setModel({
      getRowCount: () => this.items.length,
      getRow: (index) => this.items[index],
      areRowsEqual: (oldRow, newRow) => oldRow === newRow
    });
    this.buildList();
    virtualList.refresh();
  }
  setupButtons() {
    this.eApplyFilterButton.innerText = this.advFilterExpSvc.translate("advancedFilterBuilderApply");
    this.activateTabIndex([this.eApplyFilterButton]);
    this.addManagedElementListeners(this.eApplyFilterButton, {
      click: () => {
        this.advancedFilter.setModel(this.filterModel);
        this.filterManager?.onFilterChanged({ source: "advancedFilter" });
        this.close();
      }
    });
    this.validationTooltipFeature = this.createOptionalManagedBean(
      this.registry.createDynamicBean("tooltipFeature", false, {
        getGui: () => this.eApplyFilterButton,
        getLocation: () => "advancedFilter",
        getTooltipValue: () => this.validationMessage,
        getTooltipShowDelayOverride: () => 1e3
      })
    );
    this.validate();
    const mouseListener = (isEnter) => this.addOrRemoveCssClass("ag-advanced-filter-builder-validation", isEnter);
    this.addManagedListeners(this.eApplyFilterButton, {
      mouseenter: () => mouseListener(true),
      mouseleave: () => mouseListener(false)
    });
    this.eCancelFilterButton.innerText = this.advFilterExpSvc.translate("advancedFilterBuilderCancel");
    this.activateTabIndex([this.eCancelFilterButton]);
    this.addManagedElementListeners(this.eCancelFilterButton, { click: () => this.close() });
  }
  removeItemFromParent(item) {
    const sourceParentIndex = item.parent.conditions.indexOf(item.filterModel);
    item.parent.conditions.splice(sourceParentIndex, 1);
    return sourceParentIndex;
  }
  moveItemToIndex(item, destinationRowIndex, destinationPosition) {
    const destinationItem = this.items[destinationRowIndex];
    const destinationIsParent = destinationItem.filterModel?.filterType === "join" && destinationPosition === "bottom";
    const destinationParent = destinationIsParent ? destinationItem.filterModel : destinationItem.parent;
    if (!destinationParent) {
      return;
    }
    if (this.isChildOrSelf(destinationParent, item.filterModel) || destinationItem === item) {
      return;
    }
    this.removeItemFromParent(item);
    let destinationParentIndex;
    if (destinationIsParent) {
      destinationParentIndex = 0;
    } else {
      destinationParentIndex = destinationParent.conditions.indexOf(destinationItem.filterModel);
      if (destinationParentIndex === -1) {
        destinationParentIndex = destinationParent.conditions.length;
      } else if (destinationPosition === "bottom") {
        destinationParentIndex += 1;
      }
    }
    destinationParent.conditions.splice(destinationParentIndex, 0, item.filterModel);
    this.refreshList(false);
  }
  isChildOrSelf(modelToCheck, potentialParentModel) {
    return modelToCheck === potentialParentModel || potentialParentModel.filterType === "join" && potentialParentModel.conditions.some((condition) => this.isChildOrSelf(modelToCheck, condition));
  }
  setupFilterModel() {
    const filterModel = this.formatFilterModel(this.advancedFilter.getModel());
    this.stringifiedModel = JSON.stringify(filterModel);
    return filterModel;
  }
  formatFilterModel(filterModel) {
    filterModel = filterModel ?? {
      filterType: "join",
      type: "AND",
      conditions: []
    };
    if (filterModel.filterType !== "join") {
      filterModel = {
        filterType: "join",
        type: "AND",
        conditions: [filterModel]
      };
    }
    return filterModel;
  }
  buildList() {
    const parseFilterModel = (filterModel, items, level, parent) => {
      items.push({ filterModel, level, parent, valid: true, showMove: this.showMove });
      if (filterModel.filterType === "join") {
        filterModel.conditions.forEach(
          (childFilterModel) => parseFilterModel(childFilterModel, items, level + 1, filterModel)
        );
        if (level === 0) {
          items.push({ filterModel: null, level: level + 1, parent: filterModel, valid: true });
        }
      }
    };
    this.items = [];
    parseFilterModel(this.filterModel, this.items, 0);
  }
  refreshList(softRefresh) {
    if (!softRefresh) {
      const invalidModels = [];
      this.items.forEach((item) => {
        if (!item.valid) {
          invalidModels.push(item.filterModel);
        }
      });
      this.buildList();
      if (invalidModels.length) {
        this.items.forEach((item) => {
          if (item.filterModel && invalidModels.includes(item.filterModel)) {
            item.valid = false;
          }
        });
      }
    }
    this.virtualList.refresh(softRefresh);
    this.validate();
  }
  updateItemComponent(item, comp) {
    const index = this.items.indexOf(item);
    const populateTreeLines = (filterModel2, treeLines2) => {
      const parentItem = this.items.find((itemToCheck) => itemToCheck.filterModel === filterModel2);
      const parentFilterModel = parentItem?.parent;
      if (parentFilterModel) {
        const { conditions } = parentFilterModel;
        populateTreeLines(parentFilterModel, treeLines2);
        treeLines2.push(conditions[conditions.length - 1] === filterModel2);
      }
    };
    const treeLines = [];
    const { filterModel } = item;
    if (filterModel) {
      populateTreeLines(filterModel, treeLines);
      treeLines[0] = false;
    }
    const showStartTreeLine = filterModel?.filterType === "join" && !!filterModel.conditions.length;
    comp.setState({
      disableMoveUp: index === 1,
      disableMoveDown: !this.canMoveDown(item, index),
      treeLines,
      showStartTreeLine
    });
  }
  createItemComponent(item, focusWrapper) {
    const itemComp = this.createBean(
      item.filterModel ? new AdvancedFilterBuilderItemComp(item, this.dragFeature, focusWrapper) : new AdvancedFilterBuilderItemAddComp(item, focusWrapper)
    );
    itemComp.addManagedListeners(itemComp, {
      advancedFilterBuilderRemoved: ({ item: item2 }) => this.removeItem(item2),
      advancedFilterBuilderValueChanged: () => this.validate(),
      advancedFilterBuilderAdded: ({ item: item2, isJoin }) => this.addItem(item2, isJoin),
      advancedFilterBuilderMoved: ({ item: item2, backwards }) => this.moveItemUpDown(item2, backwards)
    });
    if (itemComp instanceof AdvancedFilterBuilderItemComp) {
      this.updateItemComponent(item, itemComp);
    }
    return itemComp;
  }
  addItem(item, isJoin) {
    const { parent: itemParent, level, filterModel: itemFilterModel } = item;
    const itemIsJoin = itemFilterModel?.filterType === "join";
    const filterModel = isJoin ? {
      filterType: "join",
      type: "AND",
      conditions: []
    } : {};
    const parent = itemIsJoin ? itemFilterModel : itemParent;
    let insertIndex = itemIsJoin ? 0 : parent.conditions.indexOf(itemFilterModel);
    if (insertIndex >= 0) {
      if (!itemIsJoin) {
        insertIndex += 1;
      }
      parent.conditions.splice(insertIndex, 0, filterModel);
    } else {
      parent.conditions.push(filterModel);
    }
    let index = this.items.indexOf(item);
    const softRefresh = index >= 0;
    if (softRefresh) {
      if (item.filterModel) {
        index++;
      }
      const newItems = [
        {
          filterModel,
          level: itemIsJoin ? level + 1 : level,
          parent,
          valid: isJoin,
          showMove: this.showMove
        }
      ];
      this.items.splice(index, 0, ...newItems);
    }
    this.refreshList(softRefresh);
    if (softRefresh) {
      this.virtualList.getComponentAt(index)?.afterAdd();
    }
  }
  removeItem(item) {
    const parent = item.parent;
    const { filterModel } = item;
    const parentIndex = parent.conditions.indexOf(filterModel);
    parent.conditions.splice(parentIndex, 1);
    const isJoin = item.filterModel?.filterType === "join";
    const index = this.items.indexOf(item);
    const softRefresh = !isJoin && index >= 0;
    if (softRefresh) {
      this.items.splice(index, 1);
    }
    this.refreshList(softRefresh);
    if (index >= 0) {
      this.virtualList.focusRow(index);
    }
  }
  moveItemUpDown(item, backwards) {
    const itemIndex = this.items.indexOf(item);
    const destinationIndex = backwards ? itemIndex - 1 : itemIndex + 1;
    if (destinationIndex === 0 || !backwards && !this.canMoveDown(item, itemIndex)) {
      return;
    }
    const destinationItem = this.items[destinationIndex];
    const indexInParent = this.removeItemFromParent(item);
    const { level, filterModel, parent } = item;
    const {
      level: destinationLevel,
      filterModel: destinationFilterModel,
      parent: destinationParent
    } = destinationItem;
    if (backwards) {
      if (destinationLevel === level && destinationFilterModel.filterType === "join") {
        destinationFilterModel.conditions.push(filterModel);
      } else if (destinationLevel <= level) {
        const destinationIndex2 = destinationParent.conditions.indexOf(destinationFilterModel);
        destinationParent.conditions.splice(destinationIndex2, 0, filterModel);
      } else {
        const newParentItem = parent.conditions[indexInParent - 1];
        newParentItem.conditions.push(filterModel);
      }
    } else {
      if (destinationLevel === level) {
        if (destinationFilterModel.filterType === "join") {
          destinationFilterModel.conditions.splice(0, 0, filterModel);
        } else {
          const destinationIndex2 = destinationParent.conditions.indexOf(destinationFilterModel);
          destinationParent.conditions.splice(destinationIndex2 + 1, 0, filterModel);
        }
      } else {
        if (indexInParent < parent.conditions.length) {
          parent.conditions.splice(indexInParent + 1, 0, filterModel);
        } else {
          const parentItem = this.items.find((itemToCheck) => itemToCheck.filterModel === parent);
          const destinationIndex2 = parentItem.parent.conditions.indexOf(parentItem.filterModel) + 1;
          parentItem.parent.conditions.splice(destinationIndex2, 0, filterModel);
        }
      }
    }
    this.refreshList(false);
    const newIndex = this.items.findIndex(
      ({ filterModel: filterModelToCheck }) => filterModelToCheck === filterModel
    );
    if (newIndex >= 0) {
      const comp = this.virtualList.getComponentAt(newIndex);
      if (comp instanceof AdvancedFilterBuilderItemComp) {
        comp.focusMoveButton(backwards);
      }
    }
  }
  canMoveDown(item, index) {
    return !(item.level === 1 && index === this.items.length - 2 || item.level === 1 && item.parent.conditions[item.parent.conditions.length - 1] === item.filterModel);
  }
  close() {
    this.advancedFilter.getCtrl().toggleFilterBuilder({ source: "ui" });
  }
  validate() {
    let disableApply = !this.items.every(({ valid }) => valid);
    if (!disableApply) {
      disableApply = JSON.stringify(this.filterModel) === this.stringifiedModel;
      if (disableApply) {
        this.validationMessage = this.advFilterExpSvc.translate(
          "advancedFilterBuilderValidationAlreadyApplied"
        );
      } else {
        this.validationMessage = null;
      }
    } else {
      this.validationMessage = this.advFilterExpSvc.translate("advancedFilterBuilderValidationIncomplete");
    }
    (0, import_ag_grid_community36._setDisabled)(this.eApplyFilterButton, disableApply);
    this.validationTooltipFeature?.refreshTooltip();
  }
  validateItems() {
    const clearOperator = (filterModel) => {
      filterModel.type = void 0;
    };
    const clearOperand = (filterModel) => {
      delete filterModel.filter;
    };
    this.items.forEach((item) => {
      if (!item.valid || !item.filterModel || item.filterModel.filterType === "join") {
        return;
      }
      const { filterModel } = item;
      const { colId } = filterModel;
      const hasColumn = this.advFilterExpSvc.getColumnAutocompleteEntries().find(({ key }) => key === colId);
      const columnDetails = this.advFilterExpSvc.getColumnDetails(filterModel.colId);
      if (!hasColumn || !columnDetails.column) {
        item.valid = false;
        filterModel.colId = void 0;
        clearOperator(filterModel);
        clearOperand(filterModel);
        return;
      }
      const operatorForType = this.advFilterExpSvc.getDataTypeExpressionOperator(columnDetails.baseCellDataType);
      const operator = operatorForType.operators[filterModel.type];
      if (!operator) {
        item.valid = false;
        clearOperator(filterModel);
        clearOperand(filterModel);
        return;
      }
      if (operator.numOperands > 0 && !(0, import_ag_grid_community36._exists)(filterModel.filter)) {
        item.valid = false;
        return;
      }
    });
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/advancedFilterCtrl.ts
var AdvancedFilterCtrl = class extends import_ag_grid_community37.BeanStub {
  constructor(enabled) {
    super();
    this.enabled = enabled;
  }
  wireBeans(beans) {
    this.ctrlsSvc = beans.ctrlsSvc;
    this.popupSvc = beans.popupSvc;
    this.advFilterExpSvc = beans.advFilterExpSvc;
    this.environment = beans.environment;
  }
  postConstruct() {
    this.hasAdvancedFilterParent = !!this.gos.get("advancedFilterParent");
    this.ctrlsSvc.whenReady(this, () => this.setAdvancedFilterComp());
    this.addManagedEventListeners({
      advancedFilterEnabledChanged: ({ enabled }) => this.onEnabledChanged(enabled)
    });
    this.addManagedPropertyListener("advancedFilterParent", () => this.updateComps());
    this.addDestroyFunc(() => {
      this.destroyAdvancedFilterComp();
      this.destroyBean(this.eBuilderComp);
      if (this.eBuilderDialog && this.eBuilderDialog.isAlive()) {
        this.destroyBean(this.eBuilderDialog);
      }
    });
  }
  setupHeaderComp(eCompToInsertBefore) {
    if (this.eHeaderComp) {
      this.eHeaderComp?.getGui().remove();
      this.destroyBean(this.eHeaderComp);
    }
    this.eHeaderComp = this.createManagedBean(
      new AdvancedFilterHeaderComp(this.enabled && !this.hasAdvancedFilterParent)
    );
    eCompToInsertBefore.insertAdjacentElement("beforebegin", this.eHeaderComp.getGui());
  }
  focusHeaderComp() {
    if (this.eHeaderComp) {
      this.eHeaderComp.getFocusableElement().focus();
      return true;
    }
    return false;
  }
  refreshComp() {
    this.eFilterComp?.refresh();
    this.eHeaderComp?.refresh();
  }
  refreshBuilderComp() {
    this.eBuilderComp?.refresh();
  }
  getHeaderHeight() {
    return this.eHeaderComp?.getHeight() ?? 0;
  }
  setInputDisabled(disabled) {
    this.eFilterComp?.setInputDisabled(disabled);
    this.eHeaderComp?.setInputDisabled(disabled);
  }
  toggleFilterBuilder(params) {
    const { source, force, eventSource } = params;
    if (force && this.eBuilderDialog || force === false && !this.eBuilderDialog) {
      return;
    }
    if (this.eBuilderDialog) {
      this.builderDestroySource = source;
      this.destroyBean(this.eBuilderDialog);
      return;
    }
    this.setInputDisabled(true);
    const { width, height, minWidth } = this.getBuilderDialogSize();
    this.eBuilderComp = this.createBean(new AdvancedFilterBuilderComp());
    this.eBuilderDialog = this.createBean(
      new AgDialog({
        title: this.advFilterExpSvc.translate("advancedFilterBuilderTitle"),
        component: this.eBuilderComp,
        width,
        height,
        resizable: true,
        movable: true,
        maximizable: true,
        centered: true,
        closable: true,
        minWidth,
        afterGuiAttached: () => this.eBuilderComp?.afterGuiAttached(),
        postProcessPopupParams: {
          type: "advancedFilterBuilder",
          eventSource
        }
      })
    );
    this.dispatchFilterBuilderVisibleChangedEvent(source, true);
    this.eBuilderDialog.addEventListener("destroyed", () => {
      this.destroyBean(this.eBuilderComp);
      this.eBuilderComp = void 0;
      this.eBuilderDialog = void 0;
      this.setInputDisabled(false);
      this.dispatchLocalEvent({
        type: "advancedFilterBuilderClosed"
      });
      this.dispatchFilterBuilderVisibleChangedEvent(this.builderDestroySource ?? "ui", false);
      this.builderDestroySource = void 0;
    });
  }
  dispatchFilterBuilderVisibleChangedEvent(source, visible) {
    this.eventSvc.dispatchEvent({
      type: "advancedFilterBuilderVisibleChanged",
      source,
      visible
    });
  }
  getBuilderDialogSize() {
    const minWidth = this.gos.get("advancedFilterBuilderParams")?.minWidth ?? 500;
    const popupParent = this.popupSvc.getPopupParent();
    const maxWidth = Math.round((0, import_ag_grid_community37._getAbsoluteWidth)(popupParent)) - 2;
    const maxHeight = Math.round((0, import_ag_grid_community37._getAbsoluteHeight)(popupParent) * 0.75) - 2;
    const width = Math.min(Math.max(600, minWidth), maxWidth);
    const height = Math.min(600, maxHeight);
    return { width, height, minWidth };
  }
  onEnabledChanged(enabled) {
    this.enabled = enabled;
    this.updateComps();
  }
  updateComps() {
    this.setAdvancedFilterComp();
    this.setHeaderCompEnabled();
    this.eventSvc.dispatchEvent({
      type: "headerHeightChanged"
    });
  }
  setAdvancedFilterComp() {
    this.destroyAdvancedFilterComp();
    if (!this.enabled) {
      return;
    }
    const advancedFilterParent = this.gos.get("advancedFilterParent");
    this.hasAdvancedFilterParent = !!advancedFilterParent;
    if (advancedFilterParent) {
      const eAdvancedFilterComp = this.createBean(new AdvancedFilterComp());
      const eAdvancedFilterCompGui = eAdvancedFilterComp.getGui();
      this.environment.applyThemeClasses(eAdvancedFilterCompGui);
      eAdvancedFilterCompGui.classList.add(this.gos.get("enableRtl") ? "ag-rtl" : "ag-ltr");
      advancedFilterParent.appendChild(eAdvancedFilterCompGui);
      this.eFilterComp = eAdvancedFilterComp;
    }
  }
  setHeaderCompEnabled() {
    this.eHeaderComp?.setEnabled(this.enabled && !this.hasAdvancedFilterParent);
  }
  destroyAdvancedFilterComp() {
    if (this.eFilterComp) {
      (0, import_ag_grid_community37._removeFromParent)(this.eFilterComp.getGui());
      this.destroyBean(this.eFilterComp);
    }
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/joinFilterExpressionParser.ts
var OperatorParser2 = class {
  constructor(params) {
    this.params = params;
    this.operators = [];
    this.operatorStartPositions = [];
    this.operatorEndPositions = [];
    this.activeOperator = 0;
    this.validationError = null;
  }
  parseExpression(i) {
    this.operators.push("");
    this.operatorStartPositions.push(i);
    this.operatorEndPositions.push(void 0);
    const { expression } = this.params;
    while (i < expression.length) {
      const char = expression[i];
      if (char === " ") {
        const isComplete = this.parseOperator(i - 1);
        if (isComplete) {
          this.activeOperator++;
          return i - 1;
        } else {
          this.operators[this.activeOperator] += char;
        }
      } else {
        this.operators[this.activeOperator] += char;
      }
      i++;
    }
    this.parseOperator(i - 1);
    return i;
  }
  isValid() {
    return !this.validationError && (!this.operators.length || !!this.parsedOperator);
  }
  getValidationError() {
    return this.validationError;
  }
  getFunction() {
    return this.parsedOperator === "OR" ? "||" : "&&";
  }
  getModel() {
    return this.parsedOperator === "OR" ? "OR" : "AND";
  }
  getAutocompleteListParams(position, operatorIndex) {
    let searchString;
    if (operatorIndex == null) {
      searchString = "";
    } else {
      const operator = this.operators[operatorIndex];
      const operatorEndPosition = this.operatorEndPositions[operatorIndex];
      searchString = getSearchString(
        operator,
        position,
        operatorEndPosition == null ? this.params.expression.length : operatorEndPosition + 1
      );
    }
    let entries = this.params.advFilterExpSvc.getJoinOperatorAutocompleteEntries();
    if (operatorIndex || operatorIndex == null && this.activeOperator) {
      entries = entries.filter(({ key }) => key === this.parsedOperator);
    }
    return this.params.advFilterExpSvc.generateAutocompleteListParams(entries, "join", searchString);
  }
  updateExpression(position, updateEntry, operatorIndex) {
    let { expression } = this.params;
    const updatedValuePart = updateEntry.displayValue ?? updateEntry.key;
    if (operatorIndex === 0) {
      for (let i = this.operatorEndPositions.length - 1; i > 0; i--) {
        const operatorEndPosition = this.operatorEndPositions[i];
        if (operatorEndPosition == null) {
          continue;
        }
        expression = updateExpression(
          expression,
          this.operatorStartPositions[i],
          operatorEndPosition,
          updatedValuePart
        ).updatedValue;
      }
    }
    const startPosition = this.operatorStartPositions.length > operatorIndex ? this.operatorStartPositions[operatorIndex] : position;
    const endPosition = (this.operatorEndPositions.length > operatorIndex ? this.operatorEndPositions[operatorIndex] : void 0) ?? findEndPosition(expression, position, true).endPosition;
    return updateExpression(expression, startPosition, endPosition, updatedValuePart, true);
  }
  getNumOperators() {
    return this.operators.length;
  }
  getLastOperatorEndPosition() {
    return this.operatorEndPositions[this.operatorEndPositions.length - 1];
  }
  parseOperator(endPosition) {
    const operator = this.operators.length > this.activeOperator ? this.operators[this.activeOperator] : "";
    const joinOperators = this.params.advFilterExpSvc.getExpressionJoinOperators();
    const parsedValue = findMatch(operator, joinOperators, (v) => v);
    if (parsedValue) {
      this.operatorEndPositions[this.activeOperator] = endPosition;
      const displayValue = joinOperators[parsedValue];
      if (this.activeOperator) {
        if (parsedValue !== this.parsedOperator) {
          if (!this.validationError) {
            this.validationError = {
              message: this.params.advFilterExpSvc.translate(
                "advancedFilterValidationJoinOperatorMismatch"
              ),
              startPosition: endPosition - operator.length + 1,
              endPosition
            };
          }
          return false;
        }
      } else {
        this.parsedOperator = parsedValue;
      }
      if (operator !== displayValue) {
        checkAndUpdateExpression(this.params, operator, displayValue, endPosition);
        this.operators[this.activeOperator] = displayValue;
      }
      return true;
    } else if (parsedValue === null) {
      return false;
    } else {
      if (!this.validationError) {
        this.validationError = {
          message: this.params.advFilterExpSvc.translate("advancedFilterValidationInvalidJoinOperator"),
          startPosition: endPosition - operator.length + 1,
          endPosition
        };
      }
      return true;
    }
  }
};
var JoinFilterExpressionParser = class _JoinFilterExpressionParser {
  constructor(params, startPosition) {
    this.params = params;
    this.startPosition = startPosition;
    this.expectingExpression = true;
    this.expectingOperator = false;
    this.expressionParsers = [];
    this.operatorParser = new OperatorParser2(this.params);
    this.missingEndBracket = false;
    this.extraEndBracket = false;
  }
  parseExpression() {
    let i = this.startPosition;
    const { expression } = this.params;
    while (i < expression.length) {
      const char = expression[i];
      if (char === "(" && !this.expectingOperator) {
        const nestedParser = new _JoinFilterExpressionParser(this.params, i + 1);
        i = nestedParser.parseExpression();
        this.expressionParsers.push(nestedParser);
        this.expectingExpression = false;
        this.expectingOperator = true;
      } else if (char === ")") {
        this.endPosition = i - 1;
        if (this.startPosition === 0) {
          this.extraEndBracket = true;
        }
        return i;
      } else if (char === " ") {
      } else if (this.expectingExpression) {
        const nestedParser = new ColFilterExpressionParser(this.params, i);
        i = nestedParser.parseExpression();
        this.expressionParsers.push(nestedParser);
        this.expectingExpression = false;
        this.expectingOperator = true;
      } else if (this.expectingOperator) {
        i = this.operatorParser.parseExpression(i);
        this.expectingOperator = false;
        this.expectingExpression = true;
      }
      i++;
    }
    if (this.startPosition > 0) {
      this.missingEndBracket = true;
    }
    return i;
  }
  isValid() {
    return !this.missingEndBracket && !this.extraEndBracket && this.expressionParsers.length === this.operatorParser.getNumOperators() + 1 && this.operatorParser.isValid() && this.expressionParsers.every((expressionParser) => expressionParser.isValid());
  }
  getValidationError() {
    const operatorError = this.operatorParser.getValidationError();
    for (let i = 0; i < this.expressionParsers.length; i++) {
      const expressionError = this.expressionParsers[i].getValidationError();
      if (expressionError) {
        return operatorError && operatorError.startPosition < expressionError.startPosition ? operatorError : expressionError;
      }
    }
    if (operatorError) {
      return operatorError;
    }
    if (this.extraEndBracket) {
      return {
        message: this.params.advFilterExpSvc.translate("advancedFilterValidationExtraEndBracket"),
        startPosition: this.endPosition + 1,
        endPosition: this.endPosition + 1
      };
    }
    let translateKey;
    if (this.expressionParsers.length === this.operatorParser.getNumOperators()) {
      translateKey = "advancedFilterValidationMissingCondition";
    } else if (this.missingEndBracket) {
      translateKey = "advancedFilterValidationMissingEndBracket";
    }
    if (translateKey) {
      return {
        message: this.params.advFilterExpSvc.translate(translateKey),
        startPosition: this.params.expression.length,
        endPosition: this.params.expression.length
      };
    }
    return null;
  }
  getFunctionString(params) {
    const hasMultipleExpressions = this.expressionParsers.length > 1;
    const expression = this.expressionParsers.map((expressionParser) => expressionParser.getFunctionString(params)).join(` ${this.operatorParser.getFunction()} `);
    return hasMultipleExpressions ? `(${expression})` : expression;
  }
  getFunctionParsed(params) {
    const operator = this.operatorParser.getFunction();
    const funcs = this.expressionParsers.map((expressionParser) => expressionParser.getFunctionParsed(params));
    const arrayFunc = operator === "&&" ? "every" : "some";
    return (expressionProxy, node, p) => funcs[arrayFunc]((func) => func(expressionProxy, node, p));
  }
  getAutocompleteListParams(position) {
    if (this.endPosition != null && position > this.endPosition + 1) {
      return void 0;
    }
    if (!this.expressionParsers.length) {
      return this.getColumnAutocompleteListParams();
    }
    const expressionParserIndex = this.getExpressionParserIndex(position);
    if (expressionParserIndex == null) {
      if (this.params.expression[position] === "(") {
        return { enabled: false };
      }
      return this.getColumnAutocompleteListParams();
    }
    const expressionParser = this.expressionParsers[expressionParserIndex];
    const autocompleteType = expressionParser.getAutocompleteListParams(position);
    if (!autocompleteType) {
      if (expressionParserIndex < this.expressionParsers.length - 1) {
        return this.operatorParser.getAutocompleteListParams(position, expressionParserIndex);
      }
      if (this.expressionParsers.length === this.operatorParser.getNumOperators()) {
        const operatorEndPosition = this.operatorParser.getLastOperatorEndPosition();
        return operatorEndPosition == null || position <= operatorEndPosition + 1 ? this.operatorParser.getAutocompleteListParams(position, this.operatorParser.getNumOperators() - 1) : this.getColumnAutocompleteListParams();
      }
      if (this.params.expression[position - 1] === ")") {
        return { enabled: false };
      }
      return this.operatorParser.getAutocompleteListParams(position);
    }
    return autocompleteType;
  }
  updateExpression(position, updateEntry, type) {
    const expression = this.params.expression;
    const expressionParserIndex = this.getExpressionParserIndex(position);
    if (expressionParserIndex == null) {
      const updatedValuePart = type === "column" ? this.params.advFilterExpSvc.getColumnValue(updateEntry) : updateEntry.displayValue ?? updateEntry.key;
      return updateExpression(expression, this.startPosition, this.startPosition, updatedValuePart, true);
    }
    const expressionParser = this.expressionParsers[expressionParserIndex];
    const updatedExpression = expressionParser.updateExpression(position, updateEntry, type);
    if (updatedExpression == null) {
      if (type === "column") {
        return updateExpression(
          expression,
          position,
          expression.length - 1,
          this.params.advFilterExpSvc.getColumnValue(updateEntry),
          true
        );
      } else if (this.endPosition != null && position > this.endPosition + 1) {
        return null;
      } else {
        return this.operatorParser.updateExpression(position, updateEntry, expressionParserIndex);
      }
    }
    return updatedExpression;
  }
  getModel() {
    if (this.expressionParsers.length > 1) {
      return {
        filterType: "join",
        type: this.operatorParser.getModel(),
        conditions: this.expressionParsers.map((parser) => parser.getModel())
      };
    } else {
      return this.expressionParsers[0].getModel();
    }
  }
  getColumnAutocompleteListParams() {
    return this.params.advFilterExpSvc.generateAutocompleteListParams(
      this.params.advFilterExpSvc.getColumnAutocompleteEntries(),
      "column",
      ""
    );
  }
  getExpressionParserIndex(position) {
    let expressionParserIndex;
    for (let i = 0; i < this.expressionParsers.length; i++) {
      const expressionParserToCheck = this.expressionParsers[i];
      if (expressionParserToCheck.startPosition > position) {
        break;
      }
      expressionParserIndex = i;
    }
    return expressionParserIndex;
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/filterExpressionParser.ts
var FilterExpressionParser = class {
  constructor(params) {
    this.params = params;
    this.valid = false;
  }
  parseExpression() {
    this.joinExpressionParser = new JoinFilterExpressionParser(this.params, 0);
    const i = this.joinExpressionParser.parseExpression();
    this.valid = i >= this.params.expression.length - 1 && this.joinExpressionParser.isValid();
    return this.params.expression;
  }
  isValid() {
    return this.valid;
  }
  getValidationMessage() {
    const error = this.joinExpressionParser.getValidationError();
    if (!error) {
      return null;
    }
    const { message, startPosition, endPosition } = error;
    return startPosition < this.params.expression.length ? this.params.advFilterExpSvc.translate("advancedFilterValidationMessage", [
      message,
      this.params.expression.slice(startPosition, endPosition + 1).trim()
    ]) : this.params.advFilterExpSvc.translate("advancedFilterValidationMessageAtEnd", [message]);
  }
  getFunctionString() {
    const params = this.createFunctionParams();
    return {
      functionString: `return ${this.joinExpressionParser.getFunctionString(params)};`,
      params
    };
  }
  getFunctionParsed() {
    const params = this.createFunctionParams();
    return {
      expressionFunction: this.joinExpressionParser.getFunctionParsed(params),
      params
    };
  }
  getAutocompleteListParams(position) {
    return this.joinExpressionParser.getAutocompleteListParams(position) ?? { enabled: false };
  }
  updateExpression(position, updateEntry, type) {
    return this.joinExpressionParser.updateExpression(position, updateEntry, type);
  }
  getModel() {
    return this.isValid() ? this.joinExpressionParser.getModel() : null;
  }
  createFunctionParams() {
    return {
      operands: [],
      operators: [],
      evaluatorParams: []
    };
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/advancedFilterService.ts
var AdvancedFilterService = class extends import_ag_grid_community38.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "advancedFilter";
    this.appliedExpression = null;
    /** The value displayed in the input, which may be invalid */
    this.expression = null;
    this.isValid = true;
  }
  wireBeans(beans) {
    this.valueSvc = beans.valueSvc;
    this.colModel = beans.colModel;
    this.dataTypeSvc = beans.dataTypeSvc;
    this.advFilterExpSvc = beans.advFilterExpSvc;
    this.filterValueSvc = beans.filterValueSvc;
  }
  postConstruct() {
    this.setEnabled(this.gos.get("enableAdvancedFilter"), true);
    this.ctrl = this.createManagedBean(new AdvancedFilterCtrl(this.enabled));
    this.expressionProxy = {
      getValue: (colId, node) => {
        const column = this.colModel.getColDefCol(colId);
        return column ? this.filterValueSvc.getValue(column, node) : void 0;
      }
    };
    this.addManagedPropertyListener("enableAdvancedFilter", (event) => this.setEnabled(!!event.currentValue));
    this.addManagedEventListeners({
      newColumnsLoaded: (event) => this.onNewColumnsLoaded(event)
    });
    this.addManagedPropertyListener("includeHiddenColumnsInAdvancedFilter", () => this.updateValidity());
  }
  isEnabled() {
    return this.enabled;
  }
  isFilterPresent() {
    return !!this.expressionFunction;
  }
  doesFilterPass(node) {
    return this.expressionFunction(this.expressionProxy, node, this.expressionParams);
  }
  getModel() {
    const expressionParser = this.createExpressionParser(this.appliedExpression);
    expressionParser?.parseExpression();
    return expressionParser?.getModel() ?? null;
  }
  setModel(model) {
    const parseModel = (model2, isFirstParent) => {
      if (model2.filterType === "join") {
        const operator = this.advFilterExpSvc.parseJoinOperator(model2);
        const expression2 = model2.conditions.map((condition) => parseModel(condition)).filter((condition) => (0, import_ag_grid_community38._exists)(condition)).join(` ${operator} `);
        return isFirstParent || model2.conditions.length <= 1 ? expression2 : `(${expression2})`;
      } else {
        return this.advFilterExpSvc.parseColumnFilterModel(model2);
      }
    };
    const expression = model ? parseModel(model, true) : null;
    this.setExpressionDisplayValue(expression);
    this.applyExpression();
    this.ctrl.refreshComp();
    this.ctrl.refreshBuilderComp();
  }
  getExpressionDisplayValue() {
    return this.expression;
  }
  setExpressionDisplayValue(expression) {
    this.expression = expression;
  }
  isCurrentExpressionApplied() {
    return this.appliedExpression === this.expression;
  }
  createExpressionParser(expression) {
    if (!expression) {
      return null;
    }
    return new FilterExpressionParser({
      expression,
      colModel: this.colModel,
      dataTypeSvc: this.dataTypeSvc,
      valueSvc: this.valueSvc,
      advFilterExpSvc: this.advFilterExpSvc
    });
  }
  getDefaultExpression(updateEntry) {
    const updatedValue = this.advFilterExpSvc.getColumnValue(updateEntry) + " ";
    return {
      updatedValue,
      updatedPosition: updatedValue.length
    };
  }
  isHeaderActive() {
    return !this.gos.get("advancedFilterParent");
  }
  getCtrl() {
    return this.ctrl;
  }
  setEnabled(enabled, silent) {
    const previousValue = this.enabled;
    const isValidRowModel = (0, import_ag_grid_community38._isClientSideRowModel)(this.gos) || (0, import_ag_grid_community38._isServerSideRowModel)(this.gos);
    if (enabled && !isValidRowModel) {
      (0, import_ag_grid_community38._warn)(123);
    }
    this.enabled = enabled && isValidRowModel;
    if (!silent && this.enabled !== previousValue) {
      this.eventSvc.dispatchEvent({
        type: "advancedFilterEnabledChanged",
        enabled: this.enabled
      });
    }
  }
  applyExpression() {
    const expressionParser = this.createExpressionParser(this.expression);
    expressionParser?.parseExpression();
    this.applyExpressionFromParser(expressionParser);
  }
  applyExpressionFromParser(expressionParser) {
    this.isValid = !expressionParser || expressionParser.isValid();
    if (!expressionParser || !this.isValid) {
      this.expressionFunction = null;
      this.expressionParams = null;
      this.appliedExpression = null;
      return;
    }
    const { expressionFunction, params } = this.getFunction(expressionParser);
    this.expressionFunction = expressionFunction;
    this.expressionParams = params;
    this.appliedExpression = this.expression;
  }
  getFunction(expressionParser) {
    if (this.gos.get("suppressAdvancedFilterEval")) {
      return expressionParser.getFunctionParsed();
    } else {
      const { functionString, params } = expressionParser.getFunctionString();
      return {
        expressionFunction: new Function(
          "expressionProxy",
          "node",
          "params",
          functionString
        ),
        params
      };
    }
  }
  updateValidity() {
    this.advFilterExpSvc.resetColumnCaches();
    const expressionParser = this.createExpressionParser(this.expression);
    expressionParser?.parseExpression();
    const isValid = !expressionParser || expressionParser.isValid();
    const updatedValidity = isValid !== this.isValid;
    this.applyExpressionFromParser(expressionParser);
    this.ctrl.refreshComp();
    this.ctrl.refreshBuilderComp();
    return updatedValidity;
  }
  onNewColumnsLoaded(event) {
    if (event.source !== "gridInitializing" || !this.dataTypeSvc?.isPendingInference) {
      return;
    }
    this.ctrl.setInputDisabled(true);
    const [destroyFunc] = this.addManagedEventListeners({
      dataTypesInferred: () => {
        destroyFunc?.();
        this.ctrl.setInputDisabled(false);
      }
    });
  }
};

// packages/ag-grid-enterprise/src/advancedFilter/advancedFilterModule.ts
var AdvancedFilterModule = {
  moduleName: "AdvancedFilter",
  version: VERSION,
  beans: [AdvancedFilterService, AdvancedFilterExpressionService],
  icons: {
    // Builder button in Advanced Filter
    advancedFilterBuilder: "group",
    // drag handle used to pick up Advanced Filter Builder rows
    advancedFilterBuilderDrag: "grip",
    // Advanced Filter Builder row validation error
    advancedFilterBuilderInvalid: "not-allowed",
    // shown on Advanced Filter Builder rows to move them up
    advancedFilterBuilderMoveUp: "up",
    // shown on Advanced Filter Builder rows to move them down
    advancedFilterBuilderMoveDown: "down",
    // shown on Advanced Filter Builder rows to add new rows
    advancedFilterBuilderAdd: "plus",
    // shown on Advanced Filter Builder rows to remove row
    advancedFilterBuilderRemove: "minus",
    // shown on Advanced Filter Builder selection pills
    advancedFilterBuilderSelectOpen: "small-down",
    // remove for rich select editor pills
    richSelectRemove: "cancel"
  },
  apiFunctions: {
    getAdvancedFilterModel,
    setAdvancedFilterModel,
    showAdvancedFilterBuilder,
    hideAdvancedFilterBuilder
  },
  dependsOn: [EnterpriseCoreModule, import_ag_grid_community39._FilterCoreModule, import_ag_grid_community39._SharedDragAndDropModule, import_ag_grid_community39._PopupModule, import_ag_grid_community39._FilterValueModule],
  css: [advancedFilterCSS]
};

// packages/ag-grid-enterprise/src/columnToolPanel/columnsToolPanelModule.ts
var import_ag_grid_community75 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/sideBar/sideBarModule.ts
var import_ag_grid_community49 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/sideBar/sideBarApi.ts
var import_ag_grid_community40 = require("ag-grid-community");
function isSideBarVisible(beans) {
  return beans.sideBar?.comp.isDisplayed() ?? false;
}
function setSideBarVisible(beans, show) {
  beans.sideBar?.comp.setDisplayed(show);
}
function setSideBarPosition(beans, position) {
  beans.sideBar?.comp.setSideBarPosition(position);
}
function openToolPanel(beans, key) {
  beans.sideBar?.comp.openToolPanel(key, "api");
}
function closeToolPanel(beans) {
  beans.sideBar?.comp.close("api");
}
function getOpenedToolPanel(beans) {
  return beans.sideBar?.comp.openedItem() ?? null;
}
function refreshToolPanel(beans) {
  beans.sideBar?.comp.refresh();
}
function isToolPanelShowing(beans) {
  return beans.sideBar?.comp.isToolPanelShowing() ?? false;
}
function getToolPanelInstance(beans, id) {
  const comp = beans.sideBar?.comp.getToolPanelInstance(id);
  return (0, import_ag_grid_community40._unwrapUserComp)(comp);
}
function getSideBar(beans) {
  return beans.sideBar?.comp.getDef();
}

// packages/ag-grid-enterprise/src/sideBar/sideBarService.ts
var import_ag_grid_community48 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/sideBar/agSideBar.ts
var import_ag_grid_community47 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/misc/enterpriseFocusUtils.ts
var import_ag_grid_community41 = require("ag-grid-community");
function findFocusableElementBeforeTabGuard(rootNode, referenceElement) {
  if (!referenceElement) {
    return null;
  }
  const focusableElements = (0, import_ag_grid_community41._findFocusableElements)(rootNode);
  const referenceIndex = focusableElements.indexOf(referenceElement);
  if (referenceIndex === -1) {
    return null;
  }
  let lastTabGuardIndex = -1;
  for (let i = referenceIndex - 1; i >= 0; i--) {
    if (focusableElements[i].classList.contains(import_ag_grid_community41.TabGuardClassNames.TAB_GUARD_TOP)) {
      lastTabGuardIndex = i;
      break;
    }
  }
  if (lastTabGuardIndex <= 0) {
    return null;
  }
  return focusableElements[lastTabGuardIndex - 1];
}
function isTargetUnderManagedComponent(rootNode, target) {
  if (!target) {
    return false;
  }
  const managedContainers = rootNode.querySelectorAll(`.${import_ag_grid_community41._FOCUS_MANAGED_CLASS}`);
  if (!managedContainers.length) {
    return false;
  }
  for (let i = 0; i < managedContainers.length; i++) {
    if (managedContainers[i].contains(target)) {
      return true;
    }
  }
  return false;
}

// packages/ag-grid-enterprise/src/sideBar/agSideBar.css-GENERATED.ts
var agSideBarCSS = (
  /*css*/
  `.ag-tool-panel-wrapper{display:flex;overflow:hidden auto;-webkit-user-select:none;-moz-user-select:none;user-select:none;width:var(--ag-side-bar-panel-width)}.ag-select-agg-func-item{align-items:center;display:flex;flex:1 1 auto;flex-flow:row nowrap;height:100%;overflow:hidden;position:relative;text-overflow:ellipsis;white-space:nowrap;>*{flex:none}}.ag-tool-panel-horizontal-resize{cursor:ew-resize;height:100%;position:absolute;top:0;width:5px;z-index:1}.ag-side-bar{background-color:var(--ag-side-bar-background-color);display:flex;flex-direction:row-reverse;position:relative}:where(.ag-ltr) :where(.ag-side-bar-left) .ag-tool-panel-horizontal-resize{right:-3px}:where(.ag-rtl) :where(.ag-side-bar-left) .ag-tool-panel-horizontal-resize{left:-3px}:where(.ag-ltr) :where(.ag-side-bar-right) .ag-tool-panel-horizontal-resize{left:-3px}:where(.ag-rtl) :where(.ag-side-bar-right) .ag-tool-panel-horizontal-resize{right:-3px}.ag-side-bar-left{flex-direction:row;order:-1}.ag-side-buttons{background-color:var(--ag-side-button-bar-background-color);padding-top:var(--ag-side-button-bar-top-padding);position:relative}.ag-side-button{background-color:var(--ag-side-button-background-color);border-bottom:var(--ag-side-button-border);border-top:var(--ag-side-button-border);color:var(--ag-side-button-text-color);margin-top:-1px;position:relative;&:before{background-color:transparent;bottom:0;content:"";display:block;position:absolute;top:0;transition:background-color var(--ag-side-button-selected-underline-transition-duration);width:var(--ag-side-button-selected-underline-width)}&:hover{background-color:var(--ag-side-button-hover-background-color);color:var(--ag-side-button-hover-text-color)}&.ag-selected{background-color:var(--ag-side-button-selected-background-color);border-bottom:var(--ag-side-button-selected-border);border-top:var(--ag-side-button-selected-border);color:var(--ag-side-button-selected-text-color);&:before{background-color:var(--ag-side-button-selected-underline-color)}}}:where(.ag-ltr) .ag-side-button{&:before{left:0}}:where(.ag-rtl) .ag-side-button{&:before{right:0}}.ag-side-button-button{align-items:center;display:flex;flex-direction:column;gap:var(--ag-spacing);position:relative;white-space:nowrap;width:100%;&:focus{box-shadow:none}}:where(.ag-ltr) .ag-side-button-button{padding:var(--ag-side-button-vertical-padding) var(--ag-side-button-right-padding) var(--ag-side-button-vertical-padding) var(--ag-side-button-left-padding)}:where(.ag-rtl) .ag-side-button-button{padding:var(--ag-side-button-vertical-padding) var(--ag-side-button-left-padding) var(--ag-side-button-vertical-padding) var(--ag-side-button-right-padding)}.ag-side-button-button:focus-visible{box-shadow:inset var(--ag-focus-shadow)}.ag-side-button-label{writing-mode:vertical-lr}@media (resolution <= 1.5x){.ag-side-button-label{font-family:"Segoe UI",var(--ag-font-family)}:where(.ag-ltr) .ag-side-button-label{transform:rotate(.05deg)}:where(.ag-rtl) .ag-side-button-label{transform:rotate(-.05deg)}}:where(.ag-ltr) .ag-side-bar-left,:where(.ag-rtl) .ag-side-bar-right{border-right:var(--ag-side-panel-border);:where(.ag-tool-panel-wrapper){border-left:var(--ag-side-panel-border)}}:where(.ag-ltr) .ag-side-bar-right,:where(.ag-rtl) .ag-side-bar-left{border-left:var(--ag-side-panel-border);:where(.ag-tool-panel-wrapper){border-right:var(--ag-side-panel-border)}}`
);

// packages/ag-grid-enterprise/src/sideBar/agSideBarButtons.ts
var import_ag_grid_community43 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/sideBar/sideBarButtonComp.ts
var import_ag_grid_community42 = require("ag-grid-community");
var SideBarButtonComp = class extends import_ag_grid_community42.Component {
  constructor(toolPanelDef) {
    super();
    this.toolPanelDef = toolPanelDef;
    this.eToggleButton = import_ag_grid_community42.RefPlaceholder;
    this.eIconWrapper = import_ag_grid_community42.RefPlaceholder;
    this.eLabel = import_ag_grid_community42.RefPlaceholder;
  }
  getToolPanelId() {
    return this.toolPanelDef.id;
  }
  postConstruct() {
    const template = this.createTemplate();
    this.setTemplate(template, []);
    this.setLabel();
    this.setIcon();
    this.addManagedElementListeners(this.eToggleButton, { click: this.onButtonPressed.bind(this) });
    this.eToggleButton.setAttribute("id", `ag-${this.getCompId()}-button`);
  }
  createTemplate() {
    const res = (
      /* html */
      `<div class="ag-side-button" role="presentation">
                <button type="button" data-ref="eToggleButton" tabindex="-1" role="tab" aria-expanded="false" class="ag-button ag-side-button-button">
                    <div data-ref="eIconWrapper" class="ag-side-button-icon-wrapper" aria-hidden="true"></div>
                    <span data-ref="eLabel" class="ag-side-button-label"></span>
                </button>
            </div>`
    );
    return res;
  }
  setLabel() {
    const translate = this.getLocaleTextFunc();
    const def = this.toolPanelDef;
    const label = translate(def.labelKey, def.labelDefault);
    this.eLabel.innerText = label;
  }
  setIcon() {
    this.eIconWrapper.insertAdjacentElement(
      "afterbegin",
      (0, import_ag_grid_community42._createIconNoSpan)(this.toolPanelDef.iconKey, this.beans)
    );
  }
  onButtonPressed() {
    this.dispatchLocalEvent({ type: "toggleButtonClicked" });
  }
  setSelected(selected) {
    this.addOrRemoveCssClass("ag-selected", selected);
    (0, import_ag_grid_community42._setAriaExpanded)(this.eToggleButton, selected);
  }
};

// packages/ag-grid-enterprise/src/sideBar/agSideBarButtons.ts
var AgSideBarButtons = class extends import_ag_grid_community43.Component {
  constructor() {
    super(
      /* html */
      `<div class="ag-side-buttons" role="tablist"></div>`
    );
    this.buttonComps = [];
  }
  postConstruct() {
    this.addManagedElementListeners(this.getFocusableElement(), { keydown: this.handleKeyDown.bind(this) });
  }
  handleKeyDown(e) {
    if (e.key !== import_ag_grid_community43.KeyCode.TAB || !e.shiftKey) {
      return;
    }
    if ((0, import_ag_grid_community43._focusNextGridCoreContainer)(this.beans, true)) {
      e.preventDefault();
      return;
    }
    (0, import_ag_grid_community43._stopPropagationForAgGrid)(e);
  }
  setActiveButton(id) {
    this.buttonComps.forEach((comp) => {
      comp.setSelected(id === comp.getToolPanelId());
    });
  }
  addButtonComp(def) {
    const buttonComp = this.createBean(new SideBarButtonComp(def));
    this.buttonComps.push(buttonComp);
    this.appendChild(buttonComp);
    buttonComp.addEventListener("toggleButtonClicked", () => {
      this.dispatchLocalEvent({
        type: "sideBarButtonClicked",
        toolPanelId: def.id
      });
    });
    return buttonComp;
  }
  clearButtons() {
    this.buttonComps = this.destroyBeans(this.buttonComps);
    (0, import_ag_grid_community43._clearElement)(this.getGui());
    super.destroy();
  }
  destroy() {
    this.clearButtons();
    super.destroy();
  }
};
var AgSideBarButtonsSelector = {
  selector: "AG-SIDE-BAR-BUTTONS",
  component: AgSideBarButtons
};

// packages/ag-grid-enterprise/src/sideBar/sideBarDefParser.ts
var import_ag_grid_community44 = require("ag-grid-community");
var DEFAULT_COLUMN_COMP = {
  id: "columns",
  labelDefault: "Columns",
  labelKey: "columns",
  iconKey: "columnsToolPanel",
  toolPanel: "agColumnsToolPanel"
};
var DEFAULT_FILTER_COMP = {
  id: "filters",
  labelDefault: "Filters",
  labelKey: "filters",
  iconKey: "filtersToolPanel",
  toolPanel: "agFiltersToolPanel"
};
var DEFAULT_BY_KEY = {
  columns: DEFAULT_COLUMN_COMP,
  filters: DEFAULT_FILTER_COMP
};
function parseSideBarDef(toParse) {
  if (!toParse) {
    return void 0;
  }
  if (toParse === true) {
    return {
      toolPanels: [DEFAULT_COLUMN_COMP, DEFAULT_FILTER_COMP],
      defaultToolPanel: "columns"
    };
  }
  if (typeof toParse === "string") {
    return parseSideBarDef([toParse]);
  }
  if (Array.isArray(toParse)) {
    const comps = [];
    toParse.forEach((key) => {
      const lookupResult = DEFAULT_BY_KEY[key];
      if (!lookupResult) {
        (0, import_ag_grid_community44._warn)(215, { key, defaultByKey: DEFAULT_BY_KEY });
        return;
      }
      comps.push(lookupResult);
    });
    if (comps.length === 0) {
      return void 0;
    }
    return {
      toolPanels: comps,
      defaultToolPanel: comps[0].id
    };
  }
  const result = {
    toolPanels: parseComponents(toParse.toolPanels),
    defaultToolPanel: toParse.defaultToolPanel,
    hiddenByDefault: toParse.hiddenByDefault,
    position: toParse.position
  };
  return result;
}
function parseComponents(from) {
  const result = [];
  if (!from) {
    return result;
  }
  from.forEach((it) => {
    let toAdd = null;
    if (typeof it === "string") {
      const lookupResult = DEFAULT_BY_KEY[it];
      if (!lookupResult) {
        (0, import_ag_grid_community44._warn)(215, { key: it, defaultByKey: DEFAULT_BY_KEY });
        return;
      }
      toAdd = lookupResult;
    } else {
      toAdd = it;
    }
    result.push(toAdd);
  });
  return result;
}

// packages/ag-grid-enterprise/src/sideBar/toolPanelWrapper.ts
var import_ag_grid_community46 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/sideBar/agHorizontalResize.ts
var import_ag_grid_community45 = require("ag-grid-community");
var AgHorizontalResize = class extends import_ag_grid_community45.Component {
  constructor() {
    super(
      /* html */
      `<div class="ag-tool-panel-horizontal-resize"></div>`
    );
    this.minWidth = 100;
    this.maxWidth = null;
  }
  postConstruct() {
    const finishedWithResizeFunc = this.beans.horizontalResizeSvc.addResizeBar({
      eResizeBar: this.getGui(),
      dragStartPixels: 1,
      onResizeStart: this.onResizeStart.bind(this),
      onResizing: this.onResizing.bind(this),
      onResizeEnd: this.onResizeEnd.bind(this)
    });
    this.addDestroyFunc(finishedWithResizeFunc);
    this.inverted = this.gos.get("enableRtl");
  }
  dispatchResizeEvent(start, end, width) {
    this.eventSvc.dispatchEvent({
      type: "toolPanelSizeChanged",
      width,
      started: start,
      ended: end
    });
  }
  onResizeStart() {
    this.startingWidth = this.elementToResize.offsetWidth;
    this.dispatchResizeEvent(true, false, this.startingWidth);
  }
  onResizeEnd(delta) {
    return this.onResizing(delta, true);
  }
  onResizing(delta, isEnd = false) {
    const direction = this.inverted ? -1 : 1;
    let newWidth = Math.max(this.minWidth, Math.floor(this.startingWidth - delta * direction));
    if (this.maxWidth != null) {
      newWidth = Math.min(this.maxWidth, newWidth);
    }
    this.elementToResize.style.width = `${newWidth}px`;
    this.dispatchResizeEvent(false, isEnd, newWidth);
  }
};

// packages/ag-grid-enterprise/src/sideBar/toolPanelWrapper.ts
function getToolPanelCompDetails(userCompFactory, toolPanelDef, params) {
  return userCompFactory.getCompDetails(toolPanelDef, ToolPanelComponent, void 0, params, true);
}
var ToolPanelComponent = {
  name: "toolPanel",
  optionalMethods: ["refresh", "getState"]
};
var ToolPanelWrapper = class extends import_ag_grid_community46.Component {
  constructor() {
    super(
      /* html */
      `<div class="ag-tool-panel-wrapper" role="tabpanel"/>`
    );
  }
  postConstruct() {
    const eGui = this.getGui();
    const resizeBar = this.resizeBar = this.createManagedBean(new AgHorizontalResize());
    eGui.setAttribute("id", `ag-${this.getCompId()}`);
    resizeBar.elementToResize = eGui;
    this.appendChild(resizeBar);
  }
  getToolPanelId() {
    return this.toolPanelId;
  }
  setToolPanelDef(toolPanelDef, params) {
    const { id, minWidth, maxWidth, width } = toolPanelDef;
    this.toolPanelId = id;
    this.width = width;
    const compDetails = getToolPanelCompDetails(this.beans.userCompFactory, toolPanelDef, params);
    if (compDetails == null) {
      return false;
    }
    const componentPromise = compDetails.newAgStackInstance();
    this.params = compDetails.params;
    componentPromise.then(this.setToolPanelComponent.bind(this));
    const resizeBar = this.resizeBar;
    if (minWidth != null) {
      resizeBar.minWidth = minWidth;
    }
    if (maxWidth != null) {
      resizeBar.maxWidth = maxWidth;
    }
    return true;
  }
  setToolPanelComponent(compInstance) {
    this.toolPanelCompInstance = compInstance;
    this.appendChild(compInstance.getGui());
    this.addDestroyFunc(() => {
      this.destroyBean(compInstance);
    });
    const width = this.width;
    if (width) {
      this.getGui().style.width = `${width}px`;
    }
  }
  getToolPanelInstance() {
    return this.toolPanelCompInstance;
  }
  setResizerSizerSide(side) {
    const isRtl = this.gos.get("enableRtl");
    const isLeft = side === "left";
    const inverted = isRtl ? isLeft : !isLeft;
    this.resizeBar.inverted = inverted;
  }
  refresh() {
    this.toolPanelCompInstance?.refresh(this.params);
  }
};

// packages/ag-grid-enterprise/src/sideBar/agSideBar.ts
var AgSideBar = class extends import_ag_grid_community47.Component {
  constructor() {
    super(
      /* html */
      `<div class="ag-side-bar ag-unselectable">
                <ag-side-bar-buttons data-ref="sideBarButtons"></ag-side-bar-buttons>
            </div>`,
      [AgSideBarButtonsSelector]
    );
    this.sideBarButtons = import_ag_grid_community47.RefPlaceholder;
    this.toolPanelWrappers = [];
    this.registerCSS(agSideBarCSS);
  }
  postConstruct() {
    this.sideBarButtons.addEventListener("sideBarButtonClicked", this.onToolPanelButtonClicked.bind(this));
    const { beans, gos } = this;
    const { sideBar: sideBarState } = gos.get("initialState") ?? {};
    this.setSideBarDef({
      sideBarDef: parseSideBarDef(gos.get("sideBar")),
      sideBarState
    });
    this.addManagedPropertyListener("sideBar", this.onSideBarUpdated.bind(this));
    beans.sideBar.comp = this;
    const eGui = this.getFocusableElement();
    this.createManagedBean(
      new import_ag_grid_community47.ManagedFocusFeature(eGui, {
        onTabKeyDown: this.onTabKeyDown.bind(this),
        handleKeyDown: this.handleKeyDown.bind(this)
      })
    );
    (0, import_ag_grid_community47._addFocusableContainerListener)(beans, this, eGui);
  }
  onTabKeyDown(e) {
    if (e.defaultPrevented) {
      return;
    }
    const { beans, sideBarButtons } = this;
    const eGui = this.getGui();
    const sideBarGui = sideBarButtons.getGui();
    const activeElement = (0, import_ag_grid_community47._getActiveDomElement)(beans);
    const openPanel = eGui.querySelector(".ag-tool-panel-wrapper:not(.ag-hidden)");
    const target = e.target;
    const backwards = e.shiftKey;
    if (!openPanel) {
      if ((0, import_ag_grid_community47._focusNextGridCoreContainer)(beans, backwards)) {
        e.preventDefault();
        return true;
      }
      return (0, import_ag_grid_community47._focusNextGridCoreContainer)(beans, backwards, true);
    }
    if (sideBarGui.contains(activeElement)) {
      if ((0, import_ag_grid_community47._focusInto)(openPanel, backwards)) {
        e.preventDefault();
      }
      return;
    }
    if (!backwards) {
      return;
    }
    let nextEl = null;
    if (openPanel.contains(activeElement)) {
      nextEl = (0, import_ag_grid_community47._findNextFocusableElement)(beans, openPanel, void 0, true);
    } else if (isTargetUnderManagedComponent(openPanel, target) && backwards) {
      nextEl = findFocusableElementBeforeTabGuard(openPanel, target);
    }
    if (!nextEl) {
      nextEl = sideBarGui.querySelector(".ag-selected button");
    }
    if (nextEl && nextEl !== e.target) {
      e.preventDefault();
      nextEl.focus();
    }
  }
  handleKeyDown(e) {
    const currentButton = (0, import_ag_grid_community47._getActiveDomElement)(this.beans);
    const sideBarButtons = this.sideBarButtons;
    if (!sideBarButtons.getGui().contains(currentButton)) {
      return;
    }
    const sideBarGui = sideBarButtons.getGui();
    const buttons = Array.prototype.slice.call(sideBarGui.querySelectorAll(".ag-side-button"));
    const currentPos = buttons.findIndex((button) => button.contains(currentButton));
    let nextPos = null;
    switch (e.key) {
      case import_ag_grid_community47.KeyCode.LEFT:
      case import_ag_grid_community47.KeyCode.UP:
        nextPos = Math.max(0, currentPos - 1);
        break;
      case import_ag_grid_community47.KeyCode.RIGHT:
      case import_ag_grid_community47.KeyCode.DOWN:
        nextPos = Math.min(currentPos + 1, buttons.length - 1);
        break;
    }
    if (nextPos === null) {
      return;
    }
    const innerButton = buttons[nextPos].querySelector("button");
    if (innerButton) {
      innerButton.focus();
      e.preventDefault();
    }
  }
  onToolPanelButtonClicked(event) {
    const id = event.toolPanelId;
    const openedItem = this.openedItem();
    if (openedItem === id) {
      this.openToolPanel(void 0, "sideBarButtonClicked");
    } else {
      this.openToolPanel(id, "sideBarButtonClicked");
    }
  }
  clearDownUi() {
    this.sideBarButtons.clearButtons();
    this.destroyToolPanelWrappers();
  }
  setSideBarDef({
    sideBarDef,
    sideBarState,
    existingToolPanelWrappers
  }) {
    this.setDisplayed(false);
    this.sideBar = sideBarDef;
    if (!!sideBarDef && !!sideBarDef.toolPanels) {
      const toolPanelDefs = sideBarDef.toolPanels;
      this.createToolPanelsAndSideButtons(toolPanelDefs, sideBarState, existingToolPanelWrappers);
      if (!this.toolPanelWrappers.length) {
        return;
      }
      const shouldDisplaySideBar = sideBarState ? sideBarState.visible : !sideBarDef.hiddenByDefault;
      this.setDisplayed(shouldDisplaySideBar);
      this.setSideBarPosition(sideBarState ? sideBarState.position : sideBarDef.position);
      if (shouldDisplaySideBar) {
        if (sideBarState) {
          const { openToolPanel: openToolPanel2 } = sideBarState;
          if (openToolPanel2) {
            this.openToolPanel(openToolPanel2, "sideBarInitializing");
          }
        } else {
          this.openToolPanel(sideBarDef.defaultToolPanel, "sideBarInitializing");
        }
      }
    }
  }
  getDef() {
    return this.sideBar;
  }
  setSideBarPosition(position) {
    if (!position) {
      position = "right";
    }
    this.position = position;
    const isLeft = position === "left";
    const resizerSide = isLeft ? "right" : "left";
    this.addOrRemoveCssClass("ag-side-bar-left", isLeft);
    this.addOrRemoveCssClass("ag-side-bar-right", !isLeft);
    this.toolPanelWrappers.forEach((wrapper) => {
      wrapper.setResizerSizerSide(resizerSide);
    });
    this.dispatchSideBarUpdated();
    return this;
  }
  setDisplayed(displayed, options) {
    super.setDisplayed(displayed, options);
    this.dispatchSideBarUpdated();
  }
  getState() {
    const toolPanels = {};
    this.toolPanelWrappers.forEach((wrapper) => {
      toolPanels[wrapper.getToolPanelId()] = wrapper.getToolPanelInstance()?.getState?.();
    });
    return {
      visible: this.isDisplayed(),
      position: this.position,
      openToolPanel: this.openedItem(),
      toolPanels
    };
  }
  createToolPanelsAndSideButtons(defs, sideBarState, existingToolPanelWrappers) {
    for (const def of defs) {
      this.createToolPanelAndSideButton(
        def,
        sideBarState?.toolPanels?.[def.id],
        existingToolPanelWrappers?.[def.id]
      );
    }
  }
  validateDef(def) {
    if (def.id == null) {
      (0, import_ag_grid_community47._warn)(212);
      return false;
    }
    if (def.toolPanel === "agFiltersToolPanel") {
      if (this.beans.filterManager?.isAdvFilterEnabled()) {
        (0, import_ag_grid_community47._warn)(213);
        return false;
      }
    }
    return true;
  }
  createToolPanelAndSideButton(def, initialState, existingToolPanelWrapper) {
    if (!this.validateDef(def)) {
      return;
    }
    let wrapper;
    if (existingToolPanelWrapper) {
      wrapper = existingToolPanelWrapper;
    } else {
      wrapper = this.createBean(new ToolPanelWrapper());
      const created = wrapper.setToolPanelDef(
        def,
        (0, import_ag_grid_community47._addGridCommonParams)(this.gos, {
          initialState,
          onStateUpdated: () => this.dispatchSideBarUpdated()
        })
      );
      if (!created) {
        return;
      }
    }
    wrapper.setDisplayed(false);
    const wrapperGui = wrapper.getGui();
    this.appendChild(wrapperGui);
    this.toolPanelWrappers.push(wrapper);
    const button = this.sideBarButtons.addButtonComp(def);
    (0, import_ag_grid_community47._setAriaControls)(button.eToggleButton, wrapperGui);
  }
  refresh() {
    this.toolPanelWrappers.forEach((wrapper) => wrapper.refresh());
  }
  openToolPanel(key, source = "api") {
    const currentlyOpenedKey = this.openedItem();
    if (currentlyOpenedKey === key) {
      return;
    }
    this.toolPanelWrappers.forEach((wrapper) => {
      const show = key === wrapper.getToolPanelId();
      wrapper.setDisplayed(show);
    });
    const newlyOpenedKey = this.openedItem();
    const openToolPanelChanged = currentlyOpenedKey !== newlyOpenedKey;
    if (openToolPanelChanged) {
      this.sideBarButtons.setActiveButton(key);
      this.raiseToolPanelVisibleEvent(key, currentlyOpenedKey ?? void 0, source);
    }
  }
  getToolPanelInstance(key) {
    const toolPanelWrapper = this.toolPanelWrappers.filter((toolPanel) => toolPanel.getToolPanelId() === key)[0];
    if (!toolPanelWrapper) {
      (0, import_ag_grid_community47._warn)(214, { key });
      return;
    }
    return toolPanelWrapper.getToolPanelInstance();
  }
  raiseToolPanelVisibleEvent(key, previousKey, source) {
    const switchingToolPanel = !!key && !!previousKey;
    const eventSvc = this.eventSvc;
    if (previousKey) {
      eventSvc.dispatchEvent({
        type: "toolPanelVisibleChanged",
        source,
        key: previousKey,
        visible: false,
        switchingToolPanel
      });
    }
    if (key) {
      eventSvc.dispatchEvent({
        type: "toolPanelVisibleChanged",
        source,
        key,
        visible: true,
        switchingToolPanel
      });
    }
  }
  close(source = "api") {
    this.openToolPanel(void 0, source);
  }
  isToolPanelShowing() {
    return !!this.openedItem();
  }
  openedItem() {
    let activeToolPanel = null;
    this.toolPanelWrappers.forEach((wrapper) => {
      if (wrapper.isDisplayed()) {
        activeToolPanel = wrapper.getToolPanelId();
      }
    });
    return activeToolPanel;
  }
  onSideBarUpdated() {
    const sideBarDef = parseSideBarDef(this.gos.get("sideBar"));
    const existingToolPanelWrappers = {};
    if (sideBarDef && this.sideBar) {
      sideBarDef.toolPanels?.forEach((toolPanelDef) => {
        const { id } = toolPanelDef;
        if (!id) {
          return;
        }
        const existingToolPanelDef = this.sideBar.toolPanels?.find(
          (toolPanelDefToCheck) => toolPanelDefToCheck.id === id
        );
        if (!existingToolPanelDef || toolPanelDef.toolPanel !== existingToolPanelDef.toolPanel) {
          return;
        }
        const toolPanelWrapper = this.toolPanelWrappers.find((toolPanel) => toolPanel.getToolPanelId() === id);
        if (!toolPanelWrapper) {
          return;
        }
        const params = (0, import_ag_grid_community47._addGridCommonParams)(this.gos, {
          ...toolPanelDef.toolPanelParams ?? {},
          onStateUpdated: () => this.dispatchSideBarUpdated()
        });
        const hasRefreshed = toolPanelWrapper.getToolPanelInstance()?.refresh(params);
        if (hasRefreshed !== true) {
          return;
        }
        this.toolPanelWrappers = this.toolPanelWrappers.filter((toolPanel) => toolPanel !== toolPanelWrapper);
        (0, import_ag_grid_community47._removeFromParent)(toolPanelWrapper.getGui());
        existingToolPanelWrappers[id] = toolPanelWrapper;
      });
    }
    this.clearDownUi();
    this.setSideBarDef({ sideBarDef, existingToolPanelWrappers });
  }
  dispatchSideBarUpdated() {
    this.eventSvc.dispatchEvent({ type: "sideBarUpdated" });
  }
  destroyToolPanelWrappers() {
    this.toolPanelWrappers.forEach((wrapper) => {
      (0, import_ag_grid_community47._removeFromParent)(wrapper.getGui());
      this.destroyBean(wrapper);
    });
    this.toolPanelWrappers.length = 0;
  }
  destroy() {
    this.destroyToolPanelWrappers();
    super.destroy();
  }
};
var AgSideBarSelector = {
  selector: "AG-SIDE-BAR",
  component: AgSideBar
};

// packages/ag-grid-enterprise/src/sideBar/sideBarService.ts
var SideBarService = class extends import_ag_grid_community48.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "sideBar";
  }
  getSelector() {
    return AgSideBarSelector;
  }
};

// packages/ag-grid-enterprise/src/sideBar/sideBarModule.ts
var SideBarModule = {
  moduleName: "SideBar",
  version: VERSION,
  beans: [SideBarService],
  apiFunctions: {
    isSideBarVisible,
    setSideBarVisible,
    setSideBarPosition,
    openToolPanel,
    closeToolPanel,
    getOpenedToolPanel,
    refreshToolPanel,
    isToolPanelShowing,
    getToolPanelInstance,
    getSideBar
  },
  dependsOn: [EnterpriseCoreModule, import_ag_grid_community49._HorizontalResizeModule]
};

// packages/ag-grid-enterprise/src/widgets/agMenuItemRenderer.ts
var import_ag_grid_community50 = require("ag-grid-community");
var AgMenuItemRenderer = class extends import_ag_grid_community50.Component {
  constructor() {
    super();
    this.setTemplate(
      /* html */
      `<div></div>`
    );
  }
  init(params) {
    this.params = params;
    this.cssClassPrefix = this.params.cssClassPrefix ?? "ag-menu-option";
    this.addAriaAttributes();
    this.addIcon();
    this.addName();
    this.addShortcut();
    this.addSubMenu();
  }
  configureDefaults() {
    return true;
  }
  addAriaAttributes() {
    const { checked, subMenu } = this.params;
    const eGui = this.getGui();
    if (checked) {
      (0, import_ag_grid_community50._setAriaChecked)(eGui, checked);
    }
    if (subMenu) {
      (0, import_ag_grid_community50._setAriaExpanded)(eGui, false);
    }
  }
  addIcon() {
    if (this.params.isCompact) {
      return;
    }
    const iconWrapper = (0, import_ag_grid_community50._loadTemplate)(
      /* html */
      `<span data-ref="eIcon" class="${this.getClassName("part")} ${this.getClassName("icon")}" role="presentation"></span>`
    );
    const { checked, icon } = this.params;
    if (checked) {
      iconWrapper.appendChild((0, import_ag_grid_community50._createIconNoSpan)("check", this.beans));
    } else if (icon) {
      if ((0, import_ag_grid_community50._isNodeOrElement)(icon)) {
        iconWrapper.appendChild(icon);
      } else if (typeof icon === "string") {
        iconWrapper.innerHTML = icon;
      } else {
        (0, import_ag_grid_community50._warn)(227);
      }
    }
    this.getGui().appendChild(iconWrapper);
  }
  addName() {
    const name = (0, import_ag_grid_community50._loadTemplate)(
      /* html */
      `<span data-ref="eName" class="${this.getClassName("part")} ${this.getClassName("text")}">${this.params.name || ""}</span>`
    );
    this.getGui().appendChild(name);
  }
  addShortcut() {
    if (this.params.isCompact) {
      return;
    }
    const shortcut = (0, import_ag_grid_community50._loadTemplate)(
      /* html */
      `<span data-ref="eShortcut" class="${this.getClassName("part")} ${this.getClassName("shortcut")}">${this.params.shortcut || ""}</span>`
    );
    this.getGui().appendChild(shortcut);
  }
  addSubMenu() {
    const pointer = (0, import_ag_grid_community50._loadTemplate)(
      /* html */
      `<span data-ref="ePopupPointer" class="${this.getClassName("part")} ${this.getClassName("popup-pointer")}"></span>`
    );
    const eGui = this.getGui();
    if (this.params.subMenu) {
      const iconName = this.gos.get("enableRtl") ? "subMenuOpenRtl" : "subMenuOpen";
      pointer.appendChild((0, import_ag_grid_community50._createIconNoSpan)(iconName, this.beans));
    }
    eGui.appendChild(pointer);
  }
  getClassName(suffix) {
    return `${this.cssClassPrefix}-${suffix}`;
  }
};

// packages/ag-grid-enterprise/src/widgets/menu.css-GENERATED.ts
var menuCSS = (
  /*css*/
  `.ag-menu-list{cursor:default;display:table;padding:var(--ag-spacing) 0;width:100%}.ag-menu-option,.ag-menu-separator{display:table-row}.ag-menu-option-part,.ag-menu-separator-part{display:table-cell;vertical-align:middle}.ag-menu-option{cursor:pointer;font-weight:500}:where(.ag-ltr) :where(.ag-menu-option-popup-pointer) .ag-icon{text-align:right}:where(.ag-rtl) :where(.ag-menu-option-popup-pointer) .ag-icon{text-align:left}.ag-menu-option-text{white-space:nowrap}.ag-menu-option-custom{display:contents}.ag-compact-menu-option{display:flex;flex-wrap:nowrap;width:100%}.ag-compact-menu-option-text{flex:1 1 auto;white-space:nowrap}.ag-menu-separator{height:calc(var(--ag-spacing)*2 + 1px)}.ag-menu-separator-part:after{border-top:1px solid var(--ag-menu-separator-color);content:"";display:block}.ag-compact-menu-option-active,.ag-menu-option-active{background-color:var(--ag-row-hover-color)}.ag-compact-menu-option-part,.ag-menu-option-part{line-height:var(--ag-icon-size);padding:calc(var(--ag-spacing) + 2px) 0}.ag-compact-menu-option-disabled,.ag-menu-option-disabled{cursor:not-allowed;opacity:.5}.ag-compact-menu-option-icon,.ag-menu-option-icon{width:var(--ag-icon-size)}:where(.ag-ltr) .ag-compact-menu-option-icon,:where(.ag-ltr) .ag-menu-option-icon{padding-left:calc(var(--ag-spacing)*2)}:where(.ag-rtl) .ag-compact-menu-option-icon,:where(.ag-rtl) .ag-menu-option-icon{padding-right:calc(var(--ag-spacing)*2)}.ag-compact-menu-option-text,.ag-menu-option-text{padding-left:calc(var(--ag-spacing)*2);padding-right:calc(var(--ag-spacing)*2)}:where(.ag-ltr) .ag-compact-menu-option-shortcut,:where(.ag-ltr) .ag-menu-option-shortcut{padding-right:var(--ag-spacing)}:where(.ag-rtl) .ag-compact-menu-option-shortcut,:where(.ag-rtl) .ag-menu-option-shortcut{padding-left:var(--ag-spacing)}:where(.ag-ltr) .ag-compact-menu-option-popup-pointer,:where(.ag-ltr) .ag-menu-option-popup-pointer{padding-right:var(--ag-spacing)}:where(.ag-rtl) .ag-compact-menu-option-popup-pointer,:where(.ag-rtl) .ag-menu-option-popup-pointer{padding-left:var(--ag-spacing)}.ag-menu-column-select-wrapper{height:265px;overflow:auto;:where(.ag-column-select){height:100%}}.ag-menu:where(.ag-tabs){min-width:290px}.ag-context-menu-loading-icon{pointer-events:none;position:absolute}`
);

// packages/ag-grid-enterprise/src/widgets/menuItemModule.ts
var MenuItemModule = {
  moduleName: "MenuItem",
  version: VERSION,
  userComponents: {
    agMenuItem: AgMenuItemRenderer
  },
  icons: {
    // indicates the currently active pin state in the "Pin column" sub-menu of the column menu
    check: "tick",
    // icon for sub menu item
    subMenuOpen: "small-right",
    // version of subMenuOpen used in RTL mode
    subMenuOpenRtl: "small-left"
  },
  css: [menuCSS]
};

// packages/ag-grid-enterprise/src/columnToolPanel/columnToolPanel.ts
var import_ag_grid_community65 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/columnToolPanel/agPrimaryCols.ts
var import_ag_grid_community64 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/columnToolPanel/agPrimaryCols.css-GENERATED.ts
var agPrimaryColsCSS = (
  /*css*/
  `.ag-column-select{display:flex;flex:3 1 0px;flex-direction:column;overflow:hidden;position:relative}.ag-column-select-header{align-items:center;display:flex;flex:none;gap:var(--ag-widget-horizontal-spacing);height:var(--ag-header-height);padding-left:var(--ag-widget-container-horizontal-padding);padding-right:var(--ag-widget-container-horizontal-padding);position:relative}.ag-column-select-column,.ag-column-select-column-group{align-items:center;display:flex;gap:var(--ag-widget-horizontal-spacing);height:100%;position:relative;&:where(:not(:last-child)){margin-bottom:var(--ag-widget-vertical-spacing)}}:where(.ag-ltr) .ag-column-select-column,:where(.ag-ltr) .ag-column-select-column-group{padding-left:calc(var(--ag-indentation-level)*var(--ag-column-select-indent-size))}:where(.ag-rtl) .ag-column-select-column,:where(.ag-rtl) .ag-column-select-column-group{padding-right:calc(var(--ag-indentation-level)*var(--ag-column-select-indent-size))}.ag-column-select-header-icon{border-radius:var(--ag-border-radius);cursor:pointer;height:var(--ag-icon-size);position:relative;width:var(--ag-icon-size);&:focus-visible{box-shadow:var(--ag-focus-shadow)}}.ag-column-select-header-filter-wrapper{flex:1 1 auto}.ag-column-select-header-filter{width:100%}.ag-column-select-list{flex:1 1 0px;overflow:hidden}:where(.ag-ltr) .ag-column-select-add-group-indent{margin-left:calc(var(--ag-icon-size) + var(--ag-spacing)*1.5)}:where(.ag-rtl) .ag-column-select-add-group-indent{margin-right:calc(var(--ag-icon-size) + var(--ag-spacing)*1.5)}.ag-column-select-column-group-readonly,.ag-column-select-column-readonly{opacity:.5;pointer-events:none}.ag-column-select-virtual-list-viewport{padding:calc(var(--ag-widget-container-vertical-padding)*.5) 0}.ag-column-select-virtual-list-item{padding:0 var(--ag-widget-container-horizontal-padding)}.ag-column-select-column-label{flex:1 1 auto;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.ag-column-select-checkbox{display:flex}`
);

// packages/ag-grid-enterprise/src/columnToolPanel/agPrimaryColsHeader.ts
var import_ag_grid_community51 = require("ag-grid-community");
var DEBOUNCE_DELAY = 300;
var AgPrimaryColsHeader = class extends import_ag_grid_community51.Component {
  constructor() {
    super(
      /* html */
      `<div class="ag-column-select-header" role="presentation">
            <div data-ref="eExpand" class="ag-column-select-header-icon"></div>
            <ag-checkbox data-ref="eSelect" class="ag-column-select-header-checkbox"></ag-checkbox>
            <ag-input-text-field class="ag-column-select-header-filter-wrapper" data-ref="eFilterTextField"></ag-input-text-field>
        </div>`,
      [import_ag_grid_community51.AgCheckboxSelector, import_ag_grid_community51.AgInputTextFieldSelector]
    );
    this.eExpand = import_ag_grid_community51.RefPlaceholder;
    this.eSelect = import_ag_grid_community51.RefPlaceholder;
    this.eFilterTextField = import_ag_grid_community51.RefPlaceholder;
  }
  postConstruct() {
    this.createExpandIcons();
    this.addManagedListeners(this.eExpand, {
      click: this.onExpandClicked.bind(this),
      keydown: (e) => {
        if (e.key === import_ag_grid_community51.KeyCode.SPACE) {
          e.preventDefault();
          this.onExpandClicked();
        }
      }
    });
    this.addManagedElementListeners(this.eSelect.getInputElement(), { click: this.onSelectClicked.bind(this) });
    this.addManagedPropertyListener("functionsReadOnly", () => this.onFunctionsReadOnlyPropChanged());
    this.eFilterTextField.setAutoComplete(false).onValueChange(() => this.onFilterTextChanged());
    this.addManagedEventListeners({ newColumnsLoaded: this.showOrHideOptions.bind(this) });
    const translate = this.getLocaleTextFunc();
    this.eSelect.setInputAriaLabel(translate("ariaColumnSelectAll", "Toggle All Columns Visibility"));
    this.eFilterTextField.setInputAriaLabel(translate("ariaFilterColumnsInput", "Filter Columns Input"));
    this.activateTabIndex([this.eExpand]);
  }
  onFunctionsReadOnlyPropChanged() {
    const readOnly = this.gos.get("functionsReadOnly");
    this.eSelect.setReadOnly(readOnly);
    this.eSelect.addOrRemoveCssClass("ag-column-select-column-readonly", readOnly);
  }
  init(params) {
    this.params = params;
    const readOnly = this.gos.get("functionsReadOnly");
    this.eSelect.setReadOnly(readOnly);
    this.eSelect.addOrRemoveCssClass("ag-column-select-column-readonly", readOnly);
    if (this.beans.colModel.ready) {
      this.showOrHideOptions();
    }
  }
  createExpandIcons() {
    const beans = this.beans;
    this.eExpand.appendChild(this.eExpandChecked = (0, import_ag_grid_community51._createIconNoSpan)("columnSelectOpen", beans));
    this.eExpand.appendChild(this.eExpandUnchecked = (0, import_ag_grid_community51._createIconNoSpan)("columnSelectClosed", beans));
    this.eExpand.appendChild(this.eExpandIndeterminate = (0, import_ag_grid_community51._createIconNoSpan)("columnSelectIndeterminate", beans));
    this.setExpandState(0 /* EXPANDED */);
  }
  // we only show expand / collapse if we are showing columns
  showOrHideOptions() {
    const params = this.params;
    const showFilter = !params.suppressColumnFilter;
    const showSelect = !params.suppressColumnSelectAll;
    const showExpand = !params.suppressColumnExpandAll;
    const groupsPresent = !!this.beans.colModel.colDefCols?.treeDepth;
    const translate = this.getLocaleTextFunc();
    this.eFilterTextField.setInputPlaceholder(translate("searchOoo", "Search..."));
    (0, import_ag_grid_community51._setDisplayed)(this.eFilterTextField.getGui(), showFilter);
    (0, import_ag_grid_community51._setDisplayed)(this.eSelect.getGui(), showSelect);
    (0, import_ag_grid_community51._setDisplayed)(this.eExpand, showExpand && groupsPresent);
  }
  onFilterTextChanged() {
    if (!this.onFilterTextChangedDebounced) {
      this.onFilterTextChangedDebounced = (0, import_ag_grid_community51._debounce)(
        this,
        () => {
          const filterText = this.eFilterTextField.getValue();
          this.dispatchLocalEvent({ type: "filterChanged", filterText });
        },
        DEBOUNCE_DELAY
      );
    }
    this.onFilterTextChangedDebounced();
  }
  onSelectClicked() {
    this.dispatchLocalEvent({ type: this.selectState ? "unselectAll" : "selectAll" });
  }
  onExpandClicked() {
    this.dispatchLocalEvent({ type: this.expandState === 0 /* EXPANDED */ ? "collapseAll" : "expandAll" });
  }
  setExpandState(state) {
    this.expandState = state;
    (0, import_ag_grid_community51._setDisplayed)(this.eExpandChecked, state === 0 /* EXPANDED */);
    (0, import_ag_grid_community51._setDisplayed)(this.eExpandUnchecked, state === 1 /* COLLAPSED */);
    (0, import_ag_grid_community51._setDisplayed)(this.eExpandIndeterminate, state === 2 /* INDETERMINATE */);
  }
  setSelectionState(state) {
    this.selectState = state;
    this.eSelect.setValue(this.selectState);
  }
};
var AgPrimaryColsHeaderSelector = {
  selector: "AG-PRIMARY-COLS-HEADER",
  component: AgPrimaryColsHeader
};

// packages/ag-grid-enterprise/src/columnToolPanel/agPrimaryColsList.ts
var import_ag_grid_community63 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/sideBar/common/toolPanelColDefService.ts
var import_ag_grid_community53 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/sideBar/common/sideBarUtils.ts
var import_ag_grid_community52 = require("ag-grid-community");
function isColGroupDef(colDef) {
  return !!colDef && typeof colDef.children !== "undefined";
}
function getId(colDef) {
  return isColGroupDef(colDef) ? colDef.groupId : colDef.colId;
}
function addChildrenToGroup(tree, groupId, colDef) {
  const subGroupIsSplit = (currentSubGroup, currentSubGroupToAdd) => {
    const existingChildIds = currentSubGroup.children.map(getId);
    const childGroupAlreadyExists = existingChildIds.includes(getId(currentSubGroupToAdd));
    const lastChild = (0, import_ag_grid_community52._last)(currentSubGroup.children);
    const lastChildIsDifferent = lastChild && getId(lastChild) !== getId(currentSubGroupToAdd);
    return childGroupAlreadyExists && lastChildIsDifferent;
  };
  if (!isColGroupDef(tree)) {
    return true;
  }
  const currentGroup = tree;
  const groupToAdd = colDef;
  if (subGroupIsSplit(currentGroup, groupToAdd)) {
    currentGroup.children.push(groupToAdd);
    return true;
  }
  if (currentGroup.groupId === groupId) {
    const existingChildIds = currentGroup.children.map(getId);
    const colDefAlreadyPresent = existingChildIds.includes(getId(groupToAdd));
    if (!colDefAlreadyPresent) {
      currentGroup.children.push(groupToAdd);
      return true;
    }
  }
  for (let i = currentGroup.children.length - 1; i >= 0; i--) {
    if (addChildrenToGroup(currentGroup.children[i], groupId, colDef)) {
      break;
    }
  }
  return false;
}
function mergeLeafPathTrees(leafPathTrees) {
  const matchingRootGroupIds = (pathA, pathB) => {
    const bothPathsAreGroups = isColGroupDef(pathA) && isColGroupDef(pathB);
    return bothPathsAreGroups && getId(pathA) === getId(pathB);
  };
  const mergeTrees = (treeA, treeB) => {
    if (!isColGroupDef(treeB)) {
      return treeA;
    }
    const mergeResult = treeA;
    const groupToMerge = treeB;
    if (groupToMerge.children && groupToMerge.groupId) {
      const added = addChildrenToGroup(mergeResult, groupToMerge.groupId, groupToMerge.children[0]);
      if (added) {
        return mergeResult;
      }
    }
    groupToMerge.children.forEach((child) => mergeTrees(mergeResult, child));
    return mergeResult;
  };
  const mergeColDefs = [];
  for (let i = 1; i <= leafPathTrees.length; i++) {
    const first = leafPathTrees[i - 1];
    const second = leafPathTrees[i];
    if (matchingRootGroupIds(first, second)) {
      leafPathTrees[i] = mergeTrees(first, second);
    } else {
      mergeColDefs.push(first);
    }
  }
  return mergeColDefs;
}

// packages/ag-grid-enterprise/src/sideBar/common/toolPanelColDefService.ts
function toolPanelCreateColumnTree(colModel, colDefs) {
  const invalidColIds = [];
  const createDummyColGroup = (abstractColDef, depth) => {
    if (isColGroupDef(abstractColDef)) {
      const groupDef = abstractColDef;
      const groupId = typeof groupDef.groupId !== "undefined" ? groupDef.groupId : groupDef.headerName;
      const group = new import_ag_grid_community53.AgProvidedColumnGroup(groupDef, groupId, false, depth);
      const children = [];
      groupDef.children.forEach((def) => {
        const child = createDummyColGroup(def, depth + 1);
        if (child) {
          children.push(child);
        }
      });
      group.setChildren(children);
      return group;
    } else {
      const colDef = abstractColDef;
      const key = colDef.colId ? colDef.colId : colDef.field;
      const column = colModel.getColDefCol(key);
      if (!column) {
        invalidColIds.push(colDef);
      }
      return column;
    }
  };
  const mappedResults = [];
  colDefs.forEach((colDef) => {
    const result = createDummyColGroup(colDef, 0);
    if (result) {
      mappedResults.push(result);
    }
  });
  if (invalidColIds.length > 0) {
    (0, import_ag_grid_community53._warn)(217, { invalidColIds });
  }
  return mappedResults;
}
function syncLayoutWithGrid(colModel, syncLayoutCallback) {
  const leafPathTrees = getLeafPathTrees(colModel);
  const mergedColumnTrees = mergeLeafPathTrees(leafPathTrees);
  syncLayoutCallback(mergedColumnTrees);
}
function getLeafPathTrees(colModel) {
  const getLeafPathTree = (node, childDef) => {
    let leafPathTree;
    if ((0, import_ag_grid_community53.isProvidedColumnGroup)(node)) {
      if (node.isPadding()) {
        leafPathTree = childDef;
      } else {
        const groupDef = Object.assign({}, node.getColGroupDef());
        groupDef.groupId = node.getGroupId();
        groupDef.children = [childDef];
        leafPathTree = groupDef;
      }
    } else {
      const colDef = Object.assign({}, node.getColDef());
      colDef.colId = node.getColId();
      leafPathTree = colDef;
    }
    const parent = node.getOriginalParent();
    if (parent) {
      return getLeafPathTree(parent, leafPathTree);
    } else {
      return leafPathTree;
    }
  };
  const allGridColumns = colModel.getCols();
  const allPrimaryGridColumns = allGridColumns.filter((column) => {
    const colDef = column.getColDef();
    return column.isPrimary() && !colDef.showRowGroup;
  });
  return allPrimaryGridColumns.map((col) => getLeafPathTree(col, col.getColDef()));
}

// packages/ag-grid-enterprise/src/columnToolPanel/columnModelItem.ts
var import_ag_grid_community54 = require("ag-grid-community");
var ColumnModelItem = class {
  constructor(displayName, columnOrGroup, depth, group = false, expanded) {
    this.displayName = displayName;
    this.depth = depth;
    this.group = group;
    this.localEventService = new import_ag_grid_community54.LocalEventService();
    if (group) {
      this.columnGroup = columnOrGroup;
      this._expanded = expanded;
      this.children = [];
    } else {
      this.column = columnOrGroup;
    }
  }
  get expanded() {
    return !!this._expanded;
  }
  set expanded(expanded) {
    if (expanded === this._expanded) {
      return;
    }
    this._expanded = expanded;
    this.localEventService.dispatchEvent({ type: "expandedChanged" });
  }
  addEventListener(eventType, listener) {
    this.localEventService.addEventListener(eventType, listener);
  }
  removeEventListener(eventType, listener) {
    this.localEventService.removeEventListener(eventType, listener);
  }
};

// packages/ag-grid-enterprise/src/columnToolPanel/modelItemUtils.ts
var import_ag_grid_community55 = require("ag-grid-community");
function selectAllChildren(beans, colTree, selectAllChecked, eventType) {
  const cols = extractAllLeafColumns(colTree);
  setAllColumns(beans, cols, selectAllChecked, eventType);
}
function setAllColumns(beans, cols, selectAllChecked, eventType) {
  if (beans.colModel.isPivotMode()) {
    setAllPivot(beans, cols, selectAllChecked, eventType);
  } else {
    setAllVisible(beans, cols, selectAllChecked, eventType);
  }
}
function extractAllLeafColumns(allItems) {
  const res = [];
  const recursiveFunc = (items) => {
    items.forEach((item) => {
      if (!item.passesFilter) {
        return;
      }
      if (item.group) {
        recursiveFunc(item.children);
      } else {
        res.push(item.column);
      }
    });
  };
  recursiveFunc(allItems);
  return res;
}
function setAllVisible(beans, columns, visible, eventType) {
  const colStateItems = [];
  columns.forEach((col) => {
    if (col.getColDef().lockVisible) {
      return;
    }
    if (col.isVisible() != visible) {
      colStateItems.push({
        colId: col.getId(),
        hide: !visible
      });
    }
  });
  if (colStateItems.length > 0) {
    (0, import_ag_grid_community55._applyColumnState)(beans, { state: colStateItems }, eventType);
  }
  beans.selectionColSvc?.refreshVisibility(eventType);
}
function setAllPivot(beans, columns, value, eventType) {
  setAllPivotActive(beans, columns, value, eventType);
}
function setAllPivotActive(beans, columns, value, eventType) {
  const colStateItems = [];
  const turnOnAction = (col) => {
    if (col.isAnyFunctionActive()) {
      return;
    }
    if (col.isAllowValue()) {
      const aggFunc = typeof col.getAggFunc() === "string" ? col.getAggFunc() : beans.aggFuncSvc?.getDefaultAggFunc(col);
      colStateItems.push({
        colId: col.getId(),
        aggFunc
      });
    } else if (col.isAllowRowGroup()) {
      colStateItems.push({
        colId: col.getId(),
        rowGroup: true
      });
    } else if (col.isAllowPivot()) {
      colStateItems.push({
        colId: col.getId(),
        pivot: true
      });
    }
  };
  const turnOffAction = (col) => {
    const isActive = col.isPivotActive() || col.isRowGroupActive() || col.isValueActive();
    if (isActive) {
      colStateItems.push({
        colId: col.getId(),
        pivot: false,
        rowGroup: false,
        aggFunc: null
      });
    }
  };
  const action = value ? turnOnAction : turnOffAction;
  columns.forEach(action);
  if (colStateItems.length > 0) {
    (0, import_ag_grid_community55._applyColumnState)(beans, { state: colStateItems }, eventType);
  }
}
function updateColumns(beans, params) {
  const { columns, visibleState, pivotState, eventType } = params;
  const state = columns.map((column) => {
    const colId = column.getColId();
    if (beans.colModel.isPivotMode()) {
      const pivotStateForColumn = pivotState?.[colId];
      return {
        colId,
        pivot: pivotStateForColumn?.pivot,
        rowGroup: pivotStateForColumn?.rowGroup,
        aggFunc: pivotStateForColumn?.aggFunc
      };
    } else {
      return {
        colId,
        hide: !visibleState?.[colId]
      };
    }
  });
  (0, import_ag_grid_community55._applyColumnState)(beans, { state }, eventType);
}
function createPivotState(column) {
  return {
    pivot: column.isPivotActive(),
    rowGroup: column.isRowGroupActive(),
    aggFunc: column.isValueActive() ? column.getAggFunc() : void 0
  };
}

// packages/ag-grid-enterprise/src/columnToolPanel/primaryColsListPanelItemDragFeature.ts
var import_ag_grid_community61 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/columnToolPanel/toolPanelColumnGroupComp.ts
var import_ag_grid_community60 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/columnToolPanel/toolPanelContextMenu.ts
var import_ag_grid_community59 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/rowGrouping/rowGroupingUtils.ts
function setRowNodeGroupValue(rowNode, colModel, colKey, newValue) {
  const column = colModel.getCol(colKey);
  if (!rowNode.groupData) {
    rowNode.groupData = {};
  }
  const columnId = column.getColId();
  const oldValue = rowNode.groupData[columnId];
  if (oldValue === newValue) {
    return;
  }
  rowNode.groupData[columnId] = newValue;
  rowNode.dispatchCellChangedEvent(column, newValue, oldValue);
}
function setRowNodeGroup(rowNode, beans, group) {
  if (rowNode.group === group) {
    return;
  }
  if (rowNode.group && !group) {
    rowNode.expanded = false;
  }
  rowNode.group = group;
  rowNode.updateHasChildren();
  beans.selectionSvc?.updateRowSelectable(rowNode);
  rowNode.dispatchRowEvent("groupChanged");
}
function isRowGroupColLocked(column, beans) {
  const { gos, rowGroupColsSvc } = beans;
  if (!rowGroupColsSvc || !column) {
    return false;
  }
  const groupLockGroupColumns = gos.get("groupLockGroupColumns");
  if (!column.isRowGroupActive() || groupLockGroupColumns === 0) {
    return false;
  }
  if (groupLockGroupColumns === -1) {
    return true;
  }
  const colIndex = rowGroupColsSvc.columns.findIndex((groupCol) => groupCol.getColId() === column.getColId());
  return groupLockGroupColumns > colIndex;
}

// packages/ag-grid-enterprise/src/widgets/agMenuList.ts
var import_ag_grid_community58 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/widgets/agMenuItemComponent.ts
var import_ag_grid_community57 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/widgets/agMenuPanel.ts
var import_ag_grid_community56 = require("ag-grid-community");
var AgMenuPanel = class extends import_ag_grid_community56.TabGuardComp {
  constructor(wrappedComponent) {
    super();
    this.setTemplateFromElement(wrappedComponent.getGui(), void 0, void 0, true);
  }
  postConstruct() {
    this.initialiseTabGuard({
      onTabKeyDown: (e) => this.onTabKeyDown(e),
      handleKeyDown: (e) => this.handleKeyDown(e)
    });
  }
  handleKeyDown(e) {
    if (e.key === import_ag_grid_community56.KeyCode.ESCAPE) {
      this.closePanel();
    }
  }
  onTabKeyDown(e) {
    if (e.defaultPrevented) {
      return;
    }
    this.closePanel();
    e.preventDefault();
  }
  closePanel() {
    const menuItem = this.parentComponent;
    menuItem.closeSubMenu();
    setTimeout(() => menuItem.getGui().focus(), 0);
  }
};

// packages/ag-grid-enterprise/src/widgets/agMenuItemComponent.ts
function getMenuItemCompDetails(userCompFactory, def, params) {
  return userCompFactory.getCompDetails(def, MenuItemComponent, "agMenuItem", params, true);
}
var MenuItemComponent = {
  name: "menuItem",
  optionalMethods: ["setActive", "select", "setExpanded", "configureDefaults"]
};
var AgMenuItemComponent = class extends import_ag_grid_community57.BeanStub {
  constructor() {
    super(...arguments);
    this.ACTIVATION_DELAY = 80;
    this.isActive = false;
    this.subMenuIsOpen = false;
    this.subMenuIsOpening = false;
    this.suppressRootStyles = true;
    this.suppressAria = true;
    this.suppressFocus = true;
  }
  wireBeans(beans) {
    this.popupSvc = beans.popupSvc;
    this.userCompFactory = beans.userCompFactory;
    this.registry = beans.registry;
  }
  init(params) {
    const { menuItemDef, isAnotherSubMenuOpen, level, childComponent, contextParams } = params;
    this.params = params.menuItemDef;
    this.level = level;
    this.isAnotherSubMenuOpen = isAnotherSubMenuOpen;
    this.childComponent = childComponent;
    this.contextParams = contextParams;
    this.cssClassPrefix = this.params.menuItemParams?.cssClassPrefix ?? "ag-menu-option";
    const compDetails = getMenuItemCompDetails(
      this.userCompFactory,
      this.params,
      (0, import_ag_grid_community57._addGridCommonParams)(this.gos, {
        ...menuItemDef,
        level,
        isAnotherSubMenuOpen,
        openSubMenu: (activateFirstItem) => this.openSubMenu(activateFirstItem),
        closeSubMenu: () => this.closeSubMenu(),
        closeMenu: (event) => this.closeMenu(event),
        updateTooltip: (tooltip, shouldDisplayTooltip) => this.refreshTooltip(tooltip, shouldDisplayTooltip),
        onItemActivated: () => this.onItemActivated()
      })
    );
    return compDetails?.newAgStackInstance().then((comp) => {
      this.menuItemComp = comp;
      const configureDefaults = comp.configureDefaults?.();
      if (configureDefaults) {
        this.configureDefaults(configureDefaults === true ? void 0 : configureDefaults);
      }
    }) ?? import_ag_grid_community57.AgPromise.resolve();
  }
  addListeners(eGui, params) {
    if (!params?.suppressClick) {
      this.addManagedElementListeners(eGui, { click: (e) => this.onItemSelected(e) });
    }
    if (!params?.suppressKeyboardSelect) {
      this.addManagedElementListeners(eGui, {
        keydown: (e) => {
          if (e.key === import_ag_grid_community57.KeyCode.ENTER || e.key === import_ag_grid_community57.KeyCode.SPACE) {
            e.preventDefault();
            this.onItemSelected(e);
          }
        }
      });
    }
    if (!params?.suppressMouseDown) {
      this.addManagedElementListeners(eGui, {
        mousedown: (e) => {
          e.stopPropagation();
          e.preventDefault();
        }
      });
    }
    if (!params?.suppressMouseOver) {
      this.addManagedElementListeners(eGui, {
        mouseenter: () => this.onMouseEnter(),
        mouseleave: () => this.onMouseLeave()
      });
    }
  }
  isDisabled() {
    return !!this.params.disabled;
  }
  openSubMenu(activateFirstItem = false, event) {
    this.closeSubMenu();
    if (!this.params.subMenu) {
      return;
    }
    this.subMenuIsOpening = true;
    const ePopup = (0, import_ag_grid_community57._loadTemplate)(
      /* html */
      `<div class="ag-menu" role="presentation"></div>`
    );
    this.eSubMenuGui = ePopup;
    let destroySubMenu;
    let afterGuiAttached = () => {
      this.subMenuIsOpening = false;
    };
    if (this.childComponent) {
      const menuPanel = this.createBean(new AgMenuPanel(this.childComponent));
      menuPanel.setParentComponent(this);
      const subMenuGui = menuPanel.getGui();
      const mouseEvent = "mouseenter";
      const mouseEnterListener = () => this.cancelDeactivate();
      subMenuGui.addEventListener(mouseEvent, mouseEnterListener);
      destroySubMenu = () => {
        subMenuGui.removeEventListener(mouseEvent, mouseEnterListener);
        this.destroyBean(menuPanel);
      };
      ePopup.appendChild(subMenuGui);
      if (this.childComponent.afterGuiAttached) {
        afterGuiAttached = () => {
          this.childComponent.afterGuiAttached();
          this.subMenuIsOpening = false;
        };
      }
    } else if (this.params.subMenu) {
      const childMenu = this.createBean(new AgMenuList(this.level + 1, this.contextParams));
      childMenu.setParentComponent(this);
      childMenu.addMenuItems(this.params.subMenu);
      ePopup.appendChild(childMenu.getGui());
      this.addManagedListeners(childMenu, { closeMenu: (e) => this.dispatchLocalEvent(e) });
      childMenu.addGuiEventListener("mouseenter", () => this.cancelDeactivate());
      destroySubMenu = () => this.destroyBean(childMenu);
      if (activateFirstItem) {
        afterGuiAttached = () => {
          childMenu.activateFirstItem();
          this.subMenuIsOpening = false;
        };
      }
    }
    const { popupSvc } = this;
    const positionCallback = () => {
      const eventSource = this.eGui;
      const { column, node } = this.contextParams;
      popupSvc?.positionPopupForMenu({
        eventSource,
        ePopup,
        event: event instanceof MouseEvent ? event : void 0,
        column,
        node
      });
    };
    const translate = this.getLocaleTextFunc();
    const addPopupRes = popupSvc?.addPopup({
      modal: true,
      eChild: ePopup,
      positionCallback,
      anchorToElement: this.eGui,
      ariaLabel: translate("ariaLabelSubMenu", "SubMenu"),
      afterGuiAttached
    });
    this.subMenuIsOpen = true;
    this.setAriaExpanded(true);
    this.hideSubMenu = () => {
      if (addPopupRes) {
        addPopupRes.hideFunc();
      }
      this.subMenuIsOpen = false;
      this.setAriaExpanded(false);
      destroySubMenu();
      this.menuItemComp.setExpanded?.(false);
      this.eSubMenuGui = void 0;
    };
    this.menuItemComp.setExpanded?.(true);
  }
  setAriaExpanded(expanded) {
    if (!this.suppressAria) {
      (0, import_ag_grid_community57._setAriaExpanded)(this.eGui, expanded);
    }
  }
  closeSubMenu() {
    if (!this.hideSubMenu) {
      return;
    }
    this.hideSubMenu();
    this.hideSubMenu = null;
    this.setAriaExpanded(false);
  }
  isSubMenuOpen() {
    return this.subMenuIsOpen;
  }
  isSubMenuOpening() {
    return this.subMenuIsOpening;
  }
  activate(openSubMenu, fromKeyNav) {
    this.cancelActivate();
    if (this.params.disabled && !fromKeyNav) {
      return;
    }
    this.isActive = true;
    if (!this.suppressRootStyles) {
      this.eGui.classList.add(`${this.cssClassPrefix}-active`);
    }
    this.menuItemComp.setActive?.(true);
    if (!this.suppressFocus) {
      (0, import_ag_grid_community57._preserveRangesWhile)(this.beans, () => this.eGui.focus({ preventScroll: !fromKeyNav }));
    }
    if (openSubMenu && this.params.subMenu) {
      window.setTimeout(() => {
        if (this.isAlive() && this.isActive) {
          this.openSubMenu();
        }
      }, 300);
    }
    this.onItemActivated();
  }
  deactivate() {
    this.cancelDeactivate();
    if (!this.suppressRootStyles) {
      this.eGui.classList.remove(`${this.cssClassPrefix}-active`);
    }
    this.menuItemComp.setActive?.(false);
    this.isActive = false;
    if (this.subMenuIsOpen) {
      this.closeSubMenu();
    }
  }
  getGui() {
    return this.menuItemComp.getGui();
  }
  getParentComponent() {
    return this.parentComponent;
  }
  setParentComponent(component) {
    this.parentComponent = component;
  }
  getSubMenuGui() {
    return this.eSubMenuGui;
  }
  onItemSelected(event) {
    this.menuItemComp.select?.();
    if (this.params.action) {
      this.beans.frameworkOverrides.wrapOutgoing(
        () => this.params.action(
          (0, import_ag_grid_community57._addGridCommonParams)(this.gos, {
            ...this.contextParams
          })
        )
      );
    } else {
      this.openSubMenu(event && event.type === "keydown", event);
    }
    if (this.params.subMenu && !this.params.action || this.params.suppressCloseOnSelect) {
      return;
    }
    this.closeMenu(event);
  }
  closeMenu(event) {
    const e = {
      type: "closeMenu"
    };
    if (event) {
      if (event instanceof MouseEvent) {
        e.mouseEvent = event;
      } else {
        e.keyboardEvent = event;
      }
    }
    this.dispatchLocalEvent(e);
  }
  onItemActivated() {
    const event = {
      type: "menuItemActivated",
      menuItem: this
    };
    this.dispatchLocalEvent(event);
  }
  cancelActivate() {
    if (this.activateTimeoutId) {
      window.clearTimeout(this.activateTimeoutId);
      this.activateTimeoutId = 0;
    }
  }
  cancelDeactivate() {
    if (this.deactivateTimeoutId) {
      window.clearTimeout(this.deactivateTimeoutId);
      this.deactivateTimeoutId = 0;
    }
  }
  onMouseEnter() {
    this.cancelDeactivate();
    if (this.isAnotherSubMenuOpen()) {
      this.activateTimeoutId = window.setTimeout(() => this.activate(true), this.ACTIVATION_DELAY);
    } else {
      this.activate(true);
    }
  }
  onMouseLeave() {
    this.cancelActivate();
    if (this.isSubMenuOpen()) {
      this.deactivateTimeoutId = window.setTimeout(() => this.deactivate(), this.ACTIVATION_DELAY);
    } else {
      this.deactivate();
    }
  }
  configureDefaults(params) {
    if (!this.menuItemComp) {
      setTimeout(() => this.configureDefaults(params));
      return;
    }
    let eGui = this.menuItemComp.getGui();
    const { suppressRootStyles, suppressTooltip, suppressAria, suppressTabIndex, suppressFocus } = params || {};
    const rootElement = this.menuItemComp.getRootElement?.();
    if (rootElement) {
      if (!suppressRootStyles) {
        eGui.classList.add("ag-menu-option-custom");
      }
      eGui = rootElement;
    }
    this.eGui = eGui;
    this.suppressRootStyles = !!suppressRootStyles;
    if (!this.suppressRootStyles) {
      eGui.classList.add(this.cssClassPrefix);
      this.params.cssClasses?.forEach((it) => eGui.classList.add(it));
      if (this.params.disabled) {
        eGui.classList.add(`${this.cssClassPrefix}-disabled`);
      }
    }
    if (!suppressTooltip) {
      this.refreshTooltip(this.params.tooltip);
    }
    this.suppressAria = !!suppressAria;
    if (!this.suppressAria) {
      (0, import_ag_grid_community57._setAriaRole)(eGui, "menuitem");
      if (this.params.subMenu) {
        (0, import_ag_grid_community57._setAriaHasPopup)(eGui, this.params.subMenuRole ?? "menu");
      }
      if (this.params.disabled) {
        (0, import_ag_grid_community57._setAriaDisabled)(eGui, true);
      }
    }
    if (!suppressTabIndex) {
      eGui.setAttribute("tabindex", "-1");
    }
    if (!this.params.disabled) {
      this.addListeners(eGui, params);
    }
    this.suppressFocus = !!suppressFocus;
  }
  refreshTooltip(tooltip, shouldDisplayTooltip) {
    this.tooltip = tooltip;
    this.tooltipFeature = this.destroyBean(this.tooltipFeature);
    if (!tooltip || !this.menuItemComp) {
      return;
    }
    const tooltipFeature = this.registry.createDynamicBean("tooltipFeature", false, {
      getGui: () => this.getGui(),
      getTooltipValue: () => this.tooltip,
      getLocation: () => "menu",
      shouldDisplayTooltip
    });
    if (tooltipFeature) {
      this.tooltipFeature = this.createBean(tooltipFeature);
    }
  }
  destroy() {
    this.tooltipFeature = this.destroyBean(this.tooltipFeature);
    this.menuItemComp?.destroy?.();
    super.destroy();
  }
};

// packages/ag-grid-enterprise/src/widgets/agMenuList.ts
var AgMenuList = class extends import_ag_grid_community58.TabGuardComp {
  constructor(level = 0, params) {
    super(
      /* html */
      `<div class="ag-menu-list" role="menu"></div>`
    );
    this.level = level;
    this.menuItems = [];
    this.params = params ?? {
      column: null,
      node: null,
      value: null
    };
  }
  postConstruct() {
    this.initialiseTabGuard({
      onTabKeyDown: (e) => this.onTabKeyDown(e),
      handleKeyDown: (e) => (0, import_ag_grid_community58._preserveRangesWhile)(this.beans, () => this.handleKeyDown(e)),
      onFocusIn: (e) => this.handleFocusIn(e),
      onFocusOut: (e) => this.handleFocusOut(e)
    });
  }
  onTabKeyDown(e) {
    const parent = this.getParentComponent();
    const isManaged = parent?.getGui()?.classList.contains("ag-focus-managed");
    if (!isManaged) {
      e.preventDefault();
    }
    if (e.shiftKey) {
      this.closeIfIsChild(e);
    }
  }
  handleKeyDown(e) {
    switch (e.key) {
      case import_ag_grid_community58.KeyCode.UP:
      case import_ag_grid_community58.KeyCode.RIGHT:
      case import_ag_grid_community58.KeyCode.DOWN:
      case import_ag_grid_community58.KeyCode.LEFT:
        e.preventDefault();
        this.handleNavKey(e.key);
        break;
      case import_ag_grid_community58.KeyCode.ESCAPE:
        if (this.closeIfIsChild()) {
          (0, import_ag_grid_community58._stopPropagationForAgGrid)(e);
        }
        break;
    }
  }
  handleFocusIn(e) {
    const oldFocusedElement = e.relatedTarget;
    if (!this.tabGuardFeature.getTabGuardCtrl().isTabGuard(oldFocusedElement) && (this.getGui().contains(oldFocusedElement) || this.activeMenuItem?.getSubMenuGui()?.contains(oldFocusedElement))) {
      return;
    }
    if (this.activeMenuItem) {
      this.activeMenuItem.activate();
    } else {
      this.activateFirstItem();
    }
  }
  handleFocusOut(e) {
    const newFocusedElement = e.relatedTarget;
    if (!this.activeMenuItem || this.getGui().contains(newFocusedElement) || this.activeMenuItem.getSubMenuGui()?.contains(newFocusedElement)) {
      return;
    }
    if (!this.activeMenuItem.isSubMenuOpening()) {
      this.activeMenuItem.deactivate();
    }
  }
  clearActiveItem() {
    if (this.activeMenuItem) {
      this.activeMenuItem.deactivate();
      this.activeMenuItem = null;
    }
  }
  addMenuItems(menuItems) {
    if (menuItems == null) {
      return;
    }
    import_ag_grid_community58.AgPromise.all(
      menuItems.map((menuItemOrString) => {
        if (menuItemOrString === "separator") {
          return import_ag_grid_community58.AgPromise.resolve({ eGui: this.createSeparator() });
        } else if (typeof menuItemOrString === "string") {
          (0, import_ag_grid_community58._warn)(228, { menuItemOrString });
          return import_ag_grid_community58.AgPromise.resolve({ eGui: null });
        } else {
          return this.addItem(menuItemOrString);
        }
      })
    ).then((elements) => {
      (elements ?? []).forEach((element) => {
        if (element?.eGui) {
          this.appendChild(element.eGui);
          if (element.comp) {
            this.menuItems.push(element.comp);
          }
        }
      });
    });
  }
  addItem(menuItemDef) {
    const menuItem = this.createManagedBean(new AgMenuItemComponent());
    return menuItem.init({
      menuItemDef,
      isAnotherSubMenuOpen: () => this.menuItems.some((m) => m.isSubMenuOpen()),
      level: this.level,
      contextParams: this.params
    }).then(() => {
      menuItem.setParentComponent(this);
      this.addManagedListeners(menuItem, {
        closeMenu: (event) => {
          this.dispatchLocalEvent(event);
        },
        menuItemActivated: (event) => {
          if (this.activeMenuItem && this.activeMenuItem !== event.menuItem) {
            this.activeMenuItem.deactivate();
          }
          this.activeMenuItem = event.menuItem;
        }
      });
      return {
        comp: menuItem,
        eGui: menuItem.getGui()
      };
    });
  }
  activateFirstItem() {
    const item = this.menuItems.filter((currentItem) => !currentItem.isDisabled())[0];
    if (!item) {
      return;
    }
    item.activate();
  }
  createSeparator() {
    const separatorHtml = (
      /* html */
      `
            <div class="ag-menu-separator" aria-hidden="true">
                <div class="ag-menu-separator-part"></div>
                <div class="ag-menu-separator-part"></div>
                <div class="ag-menu-separator-part"></div>
                <div class="ag-menu-separator-part"></div>
            </div>`
    );
    return (0, import_ag_grid_community58._loadTemplate)(separatorHtml);
  }
  handleNavKey(key) {
    switch (key) {
      case import_ag_grid_community58.KeyCode.UP:
      case import_ag_grid_community58.KeyCode.DOWN: {
        const nextItem = this.findNextItem(key === import_ag_grid_community58.KeyCode.UP);
        if (nextItem && nextItem !== this.activeMenuItem) {
          nextItem.activate(false, true);
        }
        return;
      }
    }
    const left = this.gos.get("enableRtl") ? import_ag_grid_community58.KeyCode.RIGHT : import_ag_grid_community58.KeyCode.LEFT;
    if (key === left) {
      this.closeIfIsChild();
    } else {
      this.openChild();
    }
  }
  closeIfIsChild(e) {
    const parentItem = this.getParentComponent();
    if (parentItem && parentItem instanceof AgMenuItemComponent) {
      if (e) {
        e.preventDefault();
      }
      parentItem.closeSubMenu();
      parentItem.getGui().focus();
      return true;
    }
    return false;
  }
  openChild() {
    if (this.activeMenuItem) {
      this.activeMenuItem.openSubMenu(true);
    }
  }
  findNextItem(up) {
    const items = [...this.menuItems];
    if (!items.length) {
      return;
    }
    if (!this.activeMenuItem) {
      return up ? (0, import_ag_grid_community58._last)(items) : items[0];
    }
    if (up) {
      items.reverse();
    }
    let nextItem;
    let foundCurrent = false;
    for (const item of items) {
      if (!foundCurrent) {
        if (item === this.activeMenuItem) {
          foundCurrent = true;
        }
        continue;
      }
      nextItem = item;
      break;
    }
    if (foundCurrent && !nextItem) {
      return items[0];
    }
    return nextItem || this.activeMenuItem;
  }
  destroy() {
    this.clearActiveItem();
    super.destroy();
  }
};

// packages/ag-grid-enterprise/src/columnToolPanel/toolPanelContextMenu.ts
var ToolPanelContextMenu = class extends import_ag_grid_community59.Component {
  constructor(column, mouseEvent, parentEl) {
    super(
      /* html */
      `<div class="ag-menu"></div>`
    );
    this.column = column;
    this.mouseEvent = mouseEvent;
    this.parentEl = parentEl;
    this.displayName = null;
  }
  postConstruct() {
    const {
      column,
      beans: { colNames }
    } = this;
    this.initializeProperties(column);
    let displayName;
    if ((0, import_ag_grid_community59.isColumn)(column)) {
      displayName = colNames.getDisplayNameForColumn(column, "columnToolPanel");
    } else {
      displayName = colNames.getDisplayNameForProvidedColumnGroup(null, column, "columnToolPanel");
    }
    this.displayName = displayName;
    this.buildMenuItemMap();
    if (this.isActive()) {
      this.mouseEvent.preventDefault();
      const menuItemsMapped = this.getMappedMenuItems();
      if (menuItemsMapped.length === 0) {
        return;
      }
      this.displayContextMenu(menuItemsMapped);
    }
  }
  initializeProperties(column) {
    let columns;
    if ((0, import_ag_grid_community59.isProvidedColumnGroup)(column)) {
      columns = column.getLeafColumns();
    } else {
      columns = [column];
    }
    this.columns = columns;
    this.allowGrouping = columns.some((col) => col.isPrimary() && col.isAllowRowGroup());
    this.allowValues = columns.some((col) => col.isPrimary() && col.isAllowValue());
    this.allowPivoting = this.beans.colModel.isPivotMode() && columns.some((col) => col.isPrimary() && col.isAllowPivot());
  }
  buildMenuItemMap() {
    const localeTextFunc = this.getLocaleTextFunc();
    const { beans, displayName } = this;
    const { rowGroupColsSvc, valueColsSvc, pivotColsSvc, colModel } = beans;
    const menuItemMap = /* @__PURE__ */ new Map();
    this.menuItemMap = menuItemMap;
    menuItemMap.set("rowGroup", {
      allowedFunction: (col) => col.isPrimary() && col.isAllowRowGroup() && !isRowGroupColLocked(col, beans),
      activeFunction: (col) => col.isRowGroupActive(),
      activateLabel: () => `${localeTextFunc("groupBy", "Group by")} ${displayName}`,
      deactivateLabel: () => `${localeTextFunc("ungroupBy", "Un-Group by")} ${displayName}`,
      activateFunction: () => rowGroupColsSvc?.setColumns(this.addColumnsToList(rowGroupColsSvc.columns), "toolPanelUi"),
      deActivateFunction: () => rowGroupColsSvc?.setColumns(this.removeColumnsFromList(rowGroupColsSvc.columns), "toolPanelUi"),
      addIcon: "menuAddRowGroup",
      removeIcon: "menuRemoveRowGroup"
    });
    menuItemMap.set("value", {
      allowedFunction: (col) => col.isPrimary() && col.isAllowValue(),
      activeFunction: (col) => col.isValueActive(),
      activateLabel: () => localeTextFunc("addToValues", `Add ${displayName} to values`, [displayName]),
      deactivateLabel: () => localeTextFunc("removeFromValues", `Remove ${displayName} from values`, [displayName]),
      activateFunction: () => valueColsSvc?.setColumns(this.addColumnsToList(valueColsSvc.columns), "toolPanelUi"),
      deActivateFunction: () => valueColsSvc?.setColumns(this.removeColumnsFromList(valueColsSvc.columns), "toolPanelUi"),
      addIcon: "valuePanel",
      removeIcon: "valuePanel"
    });
    menuItemMap.set("pivot", {
      allowedFunction: (col) => colModel.isPivotMode() && col.isPrimary() && col.isAllowPivot(),
      activeFunction: (col) => col.isPivotActive(),
      activateLabel: () => localeTextFunc("addToLabels", `Add ${displayName} to labels`, [displayName]),
      deactivateLabel: () => localeTextFunc("removeFromLabels", `Remove ${displayName} from labels`, [displayName]),
      activateFunction: () => pivotColsSvc?.setColumns(this.addColumnsToList(pivotColsSvc.columns), "toolPanelUi"),
      deActivateFunction: () => pivotColsSvc?.setColumns(this.removeColumnsFromList(pivotColsSvc.columns), "toolPanelUi"),
      addIcon: "pivotPanel",
      removeIcon: "pivotPanel"
    });
  }
  addColumnsToList(columnList) {
    return [...columnList].concat(this.columns.filter((col) => columnList.indexOf(col) === -1));
  }
  removeColumnsFromList(columnList) {
    return columnList.filter((col) => this.columns.indexOf(col) === -1);
  }
  displayContextMenu(menuItemsMapped) {
    const eGui = this.getGui();
    const menuList = this.createBean(new AgMenuList());
    const localeTextFunc = this.getLocaleTextFunc();
    let hideFunc = () => {
    };
    eGui.appendChild(menuList.getGui());
    menuList.addMenuItems(menuItemsMapped);
    menuList.addManagedListeners(menuList, {
      closeMenu: () => {
        this.parentEl.focus();
        hideFunc();
      }
    });
    const popupSvc = this.beans.popupSvc;
    const addPopupRes = popupSvc.addPopup({
      modal: true,
      eChild: eGui,
      closeOnEsc: true,
      afterGuiAttached: () => (0, import_ag_grid_community59._focusInto)(menuList.getGui()),
      ariaLabel: localeTextFunc("ariaLabelContextMenu", "Context Menu"),
      closedCallback: (e) => {
        if (e instanceof KeyboardEvent) {
          this.parentEl.focus();
        }
        this.destroyBean(menuList);
      }
    });
    if (addPopupRes) {
      hideFunc = addPopupRes.hideFunc;
    }
    popupSvc.positionPopupUnderMouseEvent({
      type: "columnContextMenu",
      mouseEvent: this.mouseEvent,
      ePopup: eGui
    });
  }
  isActive() {
    return this.allowGrouping || this.allowValues || this.allowPivoting;
  }
  getMappedMenuItems() {
    const ret = [];
    const { menuItemMap, columns, displayName, beans } = this;
    for (const val of menuItemMap.values()) {
      const isInactive = columns.some((col) => val.allowedFunction(col) && !val.activeFunction(col));
      const isActive = columns.some((col) => val.allowedFunction(col) && val.activeFunction(col));
      if (isInactive) {
        ret.push({
          name: val.activateLabel(displayName),
          icon: (0, import_ag_grid_community59._createIconNoSpan)(val.addIcon, beans, null),
          action: () => val.activateFunction()
        });
      }
      if (isActive) {
        ret.push({
          name: val.deactivateLabel(displayName),
          icon: (0, import_ag_grid_community59._createIconNoSpan)(val.removeIcon, beans, null),
          action: () => val.deActivateFunction()
        });
      }
    }
    return ret;
  }
};

// packages/ag-grid-enterprise/src/columnToolPanel/toolPanelColumnGroupComp.ts
var ToolPanelColumnGroupComp = class extends import_ag_grid_community60.Component {
  constructor(modelItem, allowDragging, eventType, focusWrapper) {
    super();
    this.modelItem = modelItem;
    this.allowDragging = allowDragging;
    this.eventType = eventType;
    this.focusWrapper = focusWrapper;
    this.cbSelect = import_ag_grid_community60.RefPlaceholder;
    this.eLabel = import_ag_grid_community60.RefPlaceholder;
    this.eGroupOpenedIcon = import_ag_grid_community60.RefPlaceholder;
    this.eGroupClosedIcon = import_ag_grid_community60.RefPlaceholder;
    this.eColumnGroupIcons = import_ag_grid_community60.RefPlaceholder;
    this.processingColumnStateChange = false;
    const { columnGroup, depth, displayName } = modelItem;
    this.columnGroup = columnGroup;
    this.columnDepth = depth;
    this.displayName = displayName;
  }
  postConstruct() {
    this.setTemplate(
      /* html */
      `<div class="ag-column-select-column-group">
                <span class="ag-column-group-icons" data-ref="eColumnGroupIcons" >
                    <span class="ag-column-group-closed-icon" data-ref="eGroupClosedIcon"></span>
                    <span class="ag-column-group-opened-icon" data-ref="eGroupOpenedIcon"></span>
                </span>
                <ag-checkbox data-ref="cbSelect" class="ag-column-select-checkbox"></ag-checkbox>
                <span class="ag-column-select-column-label" data-ref="eLabel"></span>
            </div>`,
      [import_ag_grid_community60.AgCheckboxSelector]
    );
    const {
      beans,
      cbSelect,
      eLabel,
      displayName,
      columnDepth: columnDept,
      modelItem,
      focusWrapper,
      columnGroup
    } = this;
    const { registry, gos } = beans;
    const eDragHandle = (0, import_ag_grid_community60._createIconNoSpan)("columnDrag", beans);
    this.eDragHandle = eDragHandle;
    eDragHandle.classList.add("ag-drag-handle", "ag-column-select-column-group-drag-handle");
    const checkboxGui = cbSelect.getGui();
    const checkboxInput = cbSelect.getInputElement();
    checkboxGui.insertAdjacentElement("afterend", eDragHandle);
    checkboxInput.setAttribute("tabindex", "-1");
    eLabel.innerHTML = displayName ?? "";
    this.setupExpandContract();
    this.addCssClass("ag-column-select-indent-" + columnDept);
    this.getGui().style.setProperty("--ag-indentation-level", String(columnDept));
    this.tooltipFeature = this.createOptionalManagedBean(
      registry.createDynamicBean("tooltipFeature", false, {
        getGui: () => this.getGui(),
        getLocation: () => "columnToolPanelColumnGroup",
        shouldDisplayTooltip: (0, import_ag_grid_community60._getShouldDisplayTooltip)(gos, () => eLabel)
      })
    );
    this.addManagedEventListeners({ columnPivotModeChanged: this.onColumnStateChanged.bind(this) });
    this.addManagedElementListeners(eLabel, { click: this.onLabelClicked.bind(this) });
    this.addManagedListeners(cbSelect, { fieldValueChanged: this.onCheckboxChanged.bind(this) });
    this.addManagedListeners(modelItem, { expandedChanged: this.onExpandChanged.bind(this) });
    this.addManagedListeners(focusWrapper, {
      keydown: this.handleKeyDown.bind(this),
      contextmenu: this.onContextMenu.bind(this)
    });
    this.setOpenClosedIcons();
    this.setupDragging();
    this.onColumnStateChanged();
    this.addVisibilityListenersToAllChildren();
    this.refreshAriaExpanded();
    this.refreshAriaLabel();
    this.setupTooltip();
    const classes = (0, import_ag_grid_community60._getToolPanelClassesFromColDef)(columnGroup.getColGroupDef(), gos, null, columnGroup);
    classes.forEach((c) => this.addOrRemoveCssClass(c, true));
  }
  getColumns() {
    return this.columnGroup.getLeafColumns();
  }
  setupTooltip() {
    const colGroupDef = this.columnGroup.getColGroupDef();
    if (!colGroupDef) {
      return;
    }
    const refresh = () => this.tooltipFeature?.setTooltipAndRefresh(colGroupDef.headerTooltip);
    refresh();
    this.addManagedEventListeners({ newColumnsLoaded: refresh });
  }
  handleKeyDown(e) {
    switch (e.key) {
      case import_ag_grid_community60.KeyCode.LEFT:
        e.preventDefault();
        this.modelItem.expanded = false;
        break;
      case import_ag_grid_community60.KeyCode.RIGHT:
        e.preventDefault();
        this.modelItem.expanded = true;
        break;
      case import_ag_grid_community60.KeyCode.SPACE:
        e.preventDefault();
        if (this.isSelectable()) {
          this.onSelectAllChanged(!this.isSelected());
        }
        break;
    }
  }
  onContextMenu(e) {
    const { columnGroup, gos } = this;
    if (gos.get("functionsReadOnly")) {
      return;
    }
    const contextMenu = this.createBean(new ToolPanelContextMenu(columnGroup, e, this.focusWrapper));
    this.addDestroyFunc(() => {
      if (contextMenu.isAlive()) {
        this.destroyBean(contextMenu);
      }
    });
  }
  addVisibilityListenersToAllChildren() {
    const listener = this.onColumnStateChanged.bind(this);
    this.columnGroup.getLeafColumns().forEach((column) => {
      this.addManagedListeners(column, {
        visibleChanged: listener,
        columnValueChanged: listener,
        columnPivotChanged: listener,
        columnRowGroupChanged: listener
      });
    });
  }
  setupDragging() {
    if (!this.allowDragging) {
      (0, import_ag_grid_community60._setDisplayed)(this.eDragHandle, false);
      return;
    }
    const beans = this.beans;
    const { gos, eventSvc, dragAndDrop } = beans;
    let hideColumnOnExit = !gos.get("suppressDragLeaveHidesColumns");
    const dragSource = {
      type: import_ag_grid_community60.DragSourceType.ToolPanel,
      eElement: this.eDragHandle,
      dragItemName: this.displayName,
      getDefaultIconName: () => hideColumnOnExit ? "hide" : "notAllowed",
      getDragItem: () => this.createDragItem(),
      onDragStarted: () => {
        hideColumnOnExit = !gos.get("suppressDragLeaveHidesColumns");
        eventSvc.dispatchEvent({
          type: "columnPanelItemDragStart",
          column: this.columnGroup
        });
      },
      onDragStopped: () => {
        eventSvc.dispatchEvent({
          type: "columnPanelItemDragEnd"
        });
      },
      onGridEnter: (dragItem) => {
        if (hideColumnOnExit) {
          updateColumns(beans, {
            columns: this.columnGroup.getLeafColumns(),
            visibleState: dragItem?.visibleState,
            pivotState: dragItem?.pivotState,
            eventType: this.eventType
          });
        }
      },
      onGridExit: () => {
        if (hideColumnOnExit) {
          this.onChangeCommon(false);
        }
      }
    };
    dragAndDrop.addDragSource(dragSource, true);
    this.addDestroyFunc(() => dragAndDrop.removeDragSource(dragSource));
  }
  createDragItem() {
    const columns = this.columnGroup.getLeafColumns();
    const visibleState = {};
    const pivotState = {};
    columns.forEach((col) => {
      const colId = col.getId();
      visibleState[colId] = col.isVisible();
      pivotState[colId] = createPivotState(col);
    });
    return {
      columns,
      visibleState,
      pivotState
    };
  }
  setupExpandContract() {
    const { beans, eGroupClosedIcon, eGroupOpenedIcon, eColumnGroupIcons } = this;
    eGroupClosedIcon.appendChild((0, import_ag_grid_community60._createIcon)("columnSelectClosed", beans, null));
    eGroupOpenedIcon.appendChild((0, import_ag_grid_community60._createIcon)("columnSelectOpen", beans, null));
    const listener = this.onExpandOrContractClicked.bind(this);
    this.addManagedElementListeners(eGroupClosedIcon, { click: listener });
    this.addManagedElementListeners(eGroupOpenedIcon, { click: listener });
    const touchListener = new import_ag_grid_community60.TouchListener(eColumnGroupIcons, true);
    this.addManagedListeners(touchListener, { tap: listener });
    this.addDestroyFunc(touchListener.destroy.bind(touchListener));
  }
  onLabelClicked() {
    const nextState = !this.cbSelect.getValue();
    this.onChangeCommon(nextState);
  }
  onCheckboxChanged(event) {
    this.onChangeCommon(event.selected);
  }
  getVisibleLeafColumns() {
    const childColumns = [];
    const extractCols = (children) => {
      children.forEach((child) => {
        if (!child.passesFilter) {
          return;
        }
        if (child.group) {
          extractCols(child.children);
        } else {
          childColumns.push(child.column);
        }
      });
    };
    extractCols(this.modelItem.children);
    return childColumns;
  }
  onChangeCommon(nextState) {
    this.refreshAriaLabel();
    if (this.processingColumnStateChange) {
      return;
    }
    selectAllChildren(this.beans, this.modelItem.children, nextState, this.eventType);
  }
  refreshAriaLabel() {
    const { cbSelect, focusWrapper, displayName } = this;
    const translate = this.getLocaleTextFunc();
    const columnLabel = translate("ariaColumnGroup", "Column Group");
    const checkboxValue = cbSelect.getValue();
    const state = checkboxValue === void 0 ? translate("ariaIndeterminate", "indeterminate") : checkboxValue ? translate("ariaVisible", "visible") : translate("ariaHidden", "hidden");
    const visibilityLabel = translate("ariaToggleVisibility", "Press SPACE to toggle visibility");
    (0, import_ag_grid_community60._setAriaLabel)(focusWrapper, `${displayName} ${columnLabel}`);
    cbSelect.setInputAriaLabel(`${visibilityLabel} (${state})`);
    (0, import_ag_grid_community60._setAriaDescribedBy)(focusWrapper, cbSelect.getInputElement().id);
  }
  onColumnStateChanged() {
    const selectedValue = this.workOutSelectedValue();
    const readOnlyValue = this.workOutReadOnlyValue();
    this.processingColumnStateChange = true;
    const cbSelect = this.cbSelect;
    cbSelect.setValue(selectedValue);
    cbSelect.setReadOnly(readOnlyValue);
    this.addOrRemoveCssClass("ag-column-select-column-group-readonly", readOnlyValue);
    this.processingColumnStateChange = false;
  }
  workOutSelectedValue() {
    const pivotMode = this.beans.colModel.isPivotMode();
    const visibleLeafColumns = this.getVisibleLeafColumns();
    let checkedCount = 0;
    let uncheckedCount = 0;
    visibleLeafColumns.forEach((column) => {
      if (!pivotMode && column.getColDef().lockVisible) {
        return;
      }
      if (this.isColumnChecked(column, pivotMode)) {
        checkedCount++;
      } else {
        uncheckedCount++;
      }
    });
    if (checkedCount > 0 && uncheckedCount > 0) {
      return void 0;
    }
    return checkedCount > 0;
  }
  workOutReadOnlyValue() {
    const pivotMode = this.beans.colModel.isPivotMode();
    let colsThatCanAction = 0;
    this.columnGroup.getLeafColumns().forEach((col) => {
      if (pivotMode) {
        if (col.isAnyFunctionAllowed()) {
          colsThatCanAction++;
        }
      } else {
        if (!col.getColDef().lockVisible) {
          colsThatCanAction++;
        }
      }
    });
    return colsThatCanAction === 0;
  }
  isColumnChecked(column, pivotMode) {
    if (pivotMode) {
      const pivoted = column.isPivotActive();
      const grouped = column.isRowGroupActive();
      const aggregated = column.isValueActive();
      return pivoted || grouped || aggregated;
    }
    return column.isVisible();
  }
  onExpandOrContractClicked() {
    const modelItem = this.modelItem;
    const oldState = modelItem.expanded;
    modelItem.expanded = !oldState;
  }
  onExpandChanged() {
    this.setOpenClosedIcons();
    this.refreshAriaExpanded();
  }
  setOpenClosedIcons() {
    const folderOpen = this.modelItem.expanded;
    (0, import_ag_grid_community60._setDisplayed)(this.eGroupClosedIcon, !folderOpen);
    (0, import_ag_grid_community60._setDisplayed)(this.eGroupOpenedIcon, folderOpen);
  }
  refreshAriaExpanded() {
    (0, import_ag_grid_community60._setAriaExpanded)(this.focusWrapper, this.modelItem.expanded);
  }
  getDisplayName() {
    return this.displayName;
  }
  onSelectAllChanged(value) {
    const cbSelect = this.cbSelect;
    const cbValue = cbSelect.getValue();
    const readOnly = cbSelect.isReadOnly();
    if (!readOnly && (value && !cbValue || !value && cbValue)) {
      cbSelect.toggle();
    }
  }
  isSelected() {
    return this.cbSelect.getValue();
  }
  isSelectable() {
    return !this.cbSelect.isReadOnly();
  }
  setSelected(selected) {
    this.cbSelect.setValue(selected, true);
  }
};

// packages/ag-grid-enterprise/src/columnToolPanel/primaryColsListPanelItemDragFeature.ts
var PrimaryColsListPanelItemDragFeature = class extends import_ag_grid_community61.BeanStub {
  constructor(comp, virtualList) {
    super();
    this.comp = comp;
    this.virtualList = virtualList;
  }
  postConstruct() {
    this.createManagedBean(
      new VirtualListDragFeature(this.comp, this.virtualList, {
        dragSourceType: import_ag_grid_community61.DragSourceType.ToolPanel,
        listItemDragStartEvent: "columnPanelItemDragStart",
        listItemDragEndEvent: "columnPanelItemDragEnd",
        eventSource: this.eventSvc,
        getCurrentDragValue: (listItemDragStartEvent) => this.getCurrentDragValue(listItemDragStartEvent),
        isMoveBlocked: (currentDragValue) => this.isMoveBlocked(currentDragValue),
        getNumRows: (comp) => comp.getDisplayedColsList().length,
        moveItem: (currentDragValue, lastHoveredListItem) => this.moveItem(this.getCurrentColumnsBeingMoved(currentDragValue), lastHoveredListItem)
      })
    );
  }
  getCurrentDragValue(listItemDragStartEvent) {
    return listItemDragStartEvent.column;
  }
  getCurrentColumnsBeingMoved(column) {
    if ((0, import_ag_grid_community61.isProvidedColumnGroup)(column)) {
      return column.getLeafColumns();
    }
    return column ? [column] : [];
  }
  isMoveBlocked(currentDragValue) {
    const preventMoving = this.gos.get("suppressMovableColumns");
    if (preventMoving) {
      return true;
    }
    const currentColumns = this.getCurrentColumnsBeingMoved(currentDragValue);
    const hasNotMovable = currentColumns.find((col) => {
      const colDef = col.getColDef();
      return !!colDef.suppressMovable || !!colDef.lockPosition;
    });
    return !!hasNotMovable;
  }
  moveItem(currentColumns, lastHoveredListItem) {
    if (!lastHoveredListItem) {
      return;
    }
    const { component } = lastHoveredListItem;
    let lastHoveredColumn = null;
    let isBefore = lastHoveredListItem.position === "top";
    if (component instanceof ToolPanelColumnGroupComp) {
      const columns = component.getColumns();
      lastHoveredColumn = columns[0];
      isBefore = true;
    } else if (component) {
      lastHoveredColumn = component.column;
    }
    if (!lastHoveredColumn) {
      return;
    }
    const targetIndex = this.getMoveTargetIndex({
      currentColumns,
      lastHoveredColumn,
      isBefore
    });
    if (targetIndex != null) {
      this.beans.colMoves?.moveColumns(currentColumns, targetIndex, "toolPanelUi");
    }
  }
  getMoveTargetIndex(params) {
    const { currentColumns, lastHoveredColumn, isBefore } = params;
    if (!lastHoveredColumn || !currentColumns) {
      return null;
    }
    const allColumns = this.beans.colModel.getCols();
    const targetColumnIndex = allColumns.indexOf(lastHoveredColumn);
    const adjustedTarget = isBefore ? targetColumnIndex : targetColumnIndex + 1;
    const diff = this.getMoveDiff(allColumns, currentColumns, adjustedTarget);
    return adjustedTarget - diff;
  }
  getMoveDiff(allColumns, currentColumns, end) {
    if (!currentColumns) {
      return 0;
    }
    const targetColumn = currentColumns[0];
    const span = currentColumns.length;
    const currentIndex = allColumns.indexOf(targetColumn);
    if (currentIndex < end) {
      return span;
    }
    return 0;
  }
};

// packages/ag-grid-enterprise/src/columnToolPanel/toolPanelColumnComp.ts
var import_ag_grid_community62 = require("ag-grid-community");
var ToolPanelColumnComp = class extends import_ag_grid_community62.Component {
  constructor(modelItem, allowDragging, groupsExist, focusWrapper) {
    super();
    this.allowDragging = allowDragging;
    this.groupsExist = groupsExist;
    this.focusWrapper = focusWrapper;
    this.eLabel = import_ag_grid_community62.RefPlaceholder;
    this.cbSelect = import_ag_grid_community62.RefPlaceholder;
    this.processingColumnStateChange = false;
    const { column, depth, displayName } = modelItem;
    this.column = column;
    this.columnDept = depth;
    this.displayName = displayName;
  }
  postConstruct() {
    this.setTemplate(
      /* html */
      `<div class="ag-column-select-column">
                <ag-checkbox data-ref="cbSelect" class="ag-column-select-checkbox"></ag-checkbox>
                <span class="ag-column-select-column-label" data-ref="eLabel"></span>
            </div>`,
      [import_ag_grid_community62.AgCheckboxSelector]
    );
    const {
      beans,
      cbSelect,
      displayName,
      eLabel,
      columnDept: indent,
      groupsExist,
      column,
      gos,
      focusWrapper
    } = this;
    const eDragHandle = (0, import_ag_grid_community62._createIconNoSpan)("columnDrag", beans);
    this.eDragHandle = eDragHandle;
    eDragHandle.classList.add("ag-drag-handle", "ag-column-select-column-drag-handle");
    const checkboxGui = cbSelect.getGui();
    const checkboxInput = cbSelect.getInputElement();
    checkboxGui.insertAdjacentElement("afterend", eDragHandle);
    checkboxInput.setAttribute("tabindex", "-1");
    const displayNameSanitised = (0, import_ag_grid_community62._escapeString)(displayName);
    eLabel.innerHTML = displayNameSanitised;
    if (groupsExist) {
      this.addCssClass("ag-column-select-add-group-indent");
    }
    this.addCssClass(`ag-column-select-indent-${indent}`);
    this.getGui().style.setProperty("--ag-indentation-level", String(indent));
    this.tooltipFeature = this.createOptionalManagedBean(
      beans.registry.createDynamicBean("tooltipFeature", false, {
        getGui: () => this.getGui(),
        getLocation: () => "columnToolPanelColumn",
        getColDef: () => column.getColDef(),
        shouldDisplayTooltip: (0, import_ag_grid_community62._getShouldDisplayTooltip)(gos, () => eLabel)
      })
    );
    this.setupDragging();
    const onColStateChanged = this.onColumnStateChanged.bind(this);
    this.addManagedEventListeners({ columnPivotModeChanged: onColStateChanged });
    this.addManagedListeners(column, {
      columnValueChanged: onColStateChanged,
      columnPivotChanged: onColStateChanged,
      columnRowGroupChanged: onColStateChanged,
      visibleChanged: onColStateChanged
    });
    this.addManagedListeners(focusWrapper, {
      keydown: this.handleKeyDown.bind(this),
      contextmenu: this.onContextMenu.bind(this)
    });
    this.addManagedPropertyListener("functionsReadOnly", this.onColumnStateChanged.bind(this));
    this.addManagedListeners(cbSelect, { fieldValueChanged: this.onCheckboxChanged.bind(this) });
    this.addManagedElementListeners(eLabel, { click: this.onLabelClicked.bind(this) });
    this.onColumnStateChanged();
    this.refreshAriaLabel();
    this.setupTooltip();
    const classes = (0, import_ag_grid_community62._getToolPanelClassesFromColDef)(column.getColDef(), gos, column, null);
    classes.forEach((c) => this.addOrRemoveCssClass(c, true));
  }
  getColumn() {
    return this.column;
  }
  setupTooltip() {
    const refresh = () => this.tooltipFeature?.setTooltipAndRefresh(this.column.getColDef().headerTooltip);
    refresh();
    this.addManagedEventListeners({ newColumnsLoaded: refresh });
  }
  onContextMenu(e) {
    const { column, gos } = this;
    if (gos.get("functionsReadOnly")) {
      return;
    }
    const contextMenu = this.createBean(new ToolPanelContextMenu(column, e, this.focusWrapper));
    this.addDestroyFunc(() => {
      if (contextMenu.isAlive()) {
        this.destroyBean(contextMenu);
      }
    });
  }
  handleKeyDown(e) {
    if (e.key === import_ag_grid_community62.KeyCode.SPACE) {
      e.preventDefault();
      if (this.isSelectable()) {
        this.onSelectAllChanged(!this.isSelected());
      }
    }
  }
  onLabelClicked() {
    if (this.gos.get("functionsReadOnly")) {
      return;
    }
    const nextState = !this.cbSelect.getValue();
    this.onChangeCommon(nextState);
  }
  onCheckboxChanged(event) {
    this.onChangeCommon(event.selected);
  }
  onChangeCommon(nextState) {
    if (this.cbSelect.isReadOnly()) {
      return;
    }
    this.refreshAriaLabel();
    if (this.processingColumnStateChange) {
      return;
    }
    setAllColumns(this.beans, [this.column], nextState, "toolPanelUi");
  }
  refreshAriaLabel() {
    const { cbSelect, focusWrapper, displayName } = this;
    const translate = this.getLocaleTextFunc();
    const columnLabel = translate("ariaColumn", "Column");
    const state = cbSelect.getValue() ? translate("ariaVisible", "visible") : translate("ariaHidden", "hidden");
    const visibilityLabel = translate("ariaToggleVisibility", "Press SPACE to toggle visibility");
    (0, import_ag_grid_community62._setAriaLabel)(focusWrapper, `${displayName} ${columnLabel}`);
    this.cbSelect.setInputAriaLabel(`${visibilityLabel} (${state})`);
    (0, import_ag_grid_community62._setAriaDescribedBy)(focusWrapper, cbSelect.getInputElement().id);
  }
  setupDragging() {
    const eDragHandle = this.eDragHandle;
    if (!this.allowDragging) {
      (0, import_ag_grid_community62._setDisplayed)(eDragHandle, false);
      return;
    }
    const beans = this.beans;
    const { gos, eventSvc, dragAndDrop } = beans;
    let hideColumnOnExit = !gos.get("suppressDragLeaveHidesColumns");
    const dragSource = {
      type: import_ag_grid_community62.DragSourceType.ToolPanel,
      eElement: eDragHandle,
      dragItemName: this.displayName,
      getDefaultIconName: () => hideColumnOnExit ? "hide" : "notAllowed",
      getDragItem: () => this.createDragItem(),
      onDragStarted: () => {
        hideColumnOnExit = !gos.get("suppressDragLeaveHidesColumns");
        eventSvc.dispatchEvent({
          type: "columnPanelItemDragStart",
          column: this.column
        });
      },
      onDragStopped: () => {
        eventSvc.dispatchEvent({
          type: "columnPanelItemDragEnd"
        });
      },
      onGridEnter: (dragItem) => {
        if (hideColumnOnExit) {
          updateColumns(beans, {
            columns: [this.column],
            visibleState: dragItem?.visibleState,
            pivotState: dragItem?.pivotState,
            eventType: "toolPanelUi"
          });
        }
      },
      onGridExit: () => {
        if (hideColumnOnExit) {
          this.onChangeCommon(false);
        }
      }
    };
    dragAndDrop.addDragSource(dragSource, true);
    this.addDestroyFunc(() => dragAndDrop.removeDragSource(dragSource));
  }
  createDragItem() {
    const colId = this.column.getColId();
    const visibleState = { [colId]: this.column.isVisible() };
    const pivotState = { [colId]: createPivotState(this.column) };
    return {
      columns: [this.column],
      visibleState,
      pivotState
    };
  }
  onColumnStateChanged() {
    this.processingColumnStateChange = true;
    const isPivotMode2 = this.beans.colModel.isPivotMode();
    if (isPivotMode2) {
      const anyFunctionActive = this.column.isAnyFunctionActive();
      this.cbSelect.setValue(anyFunctionActive);
    } else {
      this.cbSelect.setValue(this.column.isVisible());
    }
    let canBeToggled = true;
    let canBeDragged = true;
    if (isPivotMode2) {
      const functionsReadOnly = this.gos.get("functionsReadOnly");
      const noFunctionsAllowed = !this.column.isAnyFunctionAllowed();
      canBeToggled = !functionsReadOnly && !noFunctionsAllowed;
      canBeDragged = canBeToggled;
    } else {
      const { enableRowGroup, enableValue, lockPosition, suppressMovable, lockVisible } = this.column.getColDef();
      const forceDraggable = !!enableRowGroup || !!enableValue;
      const disableDraggable = !!lockPosition || !!suppressMovable;
      canBeToggled = !lockVisible;
      canBeDragged = forceDraggable || !disableDraggable;
    }
    this.cbSelect.setReadOnly(!canBeToggled);
    this.eDragHandle.classList.toggle("ag-column-select-column-readonly", !canBeDragged);
    this.addOrRemoveCssClass("ag-column-select-column-readonly", !canBeDragged && !canBeToggled);
    this.cbSelect.setPassive(false);
    this.processingColumnStateChange = false;
  }
  getDisplayName() {
    return this.displayName;
  }
  onSelectAllChanged(value) {
    const cbSelect = this.cbSelect;
    if (value !== cbSelect.getValue()) {
      if (!cbSelect.isReadOnly()) {
        cbSelect.toggle();
      }
    }
  }
  isSelected() {
    return this.cbSelect.getValue();
  }
  isSelectable() {
    return !this.cbSelect.isReadOnly();
  }
  isExpandable() {
    return false;
  }
  setExpanded(_value) {
    (0, import_ag_grid_community62._warn)(158);
  }
};

// packages/ag-grid-enterprise/src/columnToolPanel/agPrimaryColsList.ts
var UIColumnModel = class {
  constructor(items) {
    this.items = items;
  }
  getRowCount() {
    return this.items.length;
  }
  getRow(index) {
    return this.items[index];
  }
};
var PRIMARY_COLS_LIST_PANEL_CLASS = "ag-column-select-list";
var AgPrimaryColsList = class extends import_ag_grid_community63.Component {
  constructor() {
    super(
      /* html */
      `<div class="${PRIMARY_COLS_LIST_PANEL_CLASS}" role="presentation"></div>`
    );
    this.destroyColumnItemFuncs = [];
    this.hasLoadedInitialState = false;
    this.isInitialState = false;
  }
  wireBeans(beans) {
    this.colModel = beans.colModel;
  }
  destroy() {
    this.destroyColumnTree();
    super.destroy();
  }
  destroyColumnTree() {
    this.allColsTree = [];
    this.destroyColumnItemFuncs.forEach((f) => f());
    this.destroyColumnItemFuncs = [];
  }
  init(params, allowDragging, eventType) {
    this.params = params;
    this.allowDragging = allowDragging;
    this.eventType = eventType;
    if (!params.suppressSyncLayoutWithGrid) {
      this.addManagedEventListeners({ columnMoved: this.onColumnsChanged.bind(this) });
    }
    this.addManagedEventListeners({
      newColumnsLoaded: this.onColumnsChanged.bind(this)
    });
    const listener = this.fireSelectionChangedEvent.bind(this);
    this.addManagedEventListeners({
      columnPivotChanged: listener,
      columnPivotModeChanged: listener,
      columnRowGroupChanged: listener,
      columnValueChanged: listener,
      columnVisible: listener,
      newColumnsLoaded: listener
    });
    this.expandGroupsByDefault = !params.contractColumnSelection;
    const virtualList = this.createManagedBean(
      new VirtualList({
        cssIdentifier: "column-select",
        ariaRole: "tree"
      })
    );
    this.virtualList = virtualList;
    this.appendChild(virtualList.getGui());
    virtualList.setComponentCreator((item, listItemElement) => {
      (0, import_ag_grid_community63._setAriaLevel)(listItemElement, item.depth + 1);
      return this.createComponentFromItem(item, listItemElement);
    });
    if (this.colModel.ready) {
      this.onColumnsChanged();
    }
    if (params.suppressColumnMove) {
      return;
    }
    this.createManagedBean(new PrimaryColsListPanelItemDragFeature(this, virtualList));
  }
  createComponentFromItem(item, listItemElement) {
    const allowDragging = this.allowDragging;
    if (item.group) {
      const renderedGroup = new ToolPanelColumnGroupComp(item, allowDragging, this.eventType, listItemElement);
      this.createBean(renderedGroup);
      return renderedGroup;
    }
    const columnComp = new ToolPanelColumnComp(item, allowDragging, this.groupsExist, listItemElement);
    this.createBean(columnComp);
    return columnComp;
  }
  onColumnsChanged() {
    const params = this.params;
    if (!this.hasLoadedInitialState) {
      this.hasLoadedInitialState = true;
      this.isInitialState = !!params.initialState;
    }
    const expandedStates = this.getExpandedStates();
    const pivotModeActive = this.colModel.isPivotMode();
    const shouldSyncColumnLayoutWithGrid = !params.suppressSyncLayoutWithGrid && !pivotModeActive;
    if (shouldSyncColumnLayoutWithGrid) {
      this.buildTreeFromWhatGridIsDisplaying();
    } else {
      this.buildTreeFromProvidedColumnDefs();
    }
    this.setExpandedStates(expandedStates);
    this.markFilteredColumns();
    this.flattenAndFilterModel();
    this.isInitialState = false;
  }
  getDisplayedColsList() {
    return this.displayedColsList;
  }
  getExpandedStates() {
    const res = {};
    if (this.isInitialState) {
      const { expandedGroupIds } = this.params.initialState;
      expandedGroupIds.forEach((id) => {
        res[id] = true;
      });
      return res;
    }
    if (!this.allColsTree) {
      return {};
    }
    this.forEachItem((item) => {
      if (!item.group) {
        return;
      }
      const colGroup = item.columnGroup;
      if (colGroup) {
        res[colGroup.getId()] = item.expanded;
      }
    });
    return res;
  }
  setExpandedStates(states) {
    if (!this.allColsTree) {
      return;
    }
    const { isInitialState } = this;
    this.forEachItem((item) => {
      if (!item.group) {
        return;
      }
      const colGroup = item.columnGroup;
      if (colGroup) {
        const expanded = states[colGroup.getId()];
        const groupExistedLastTime = expanded != null;
        if (groupExistedLastTime || isInitialState) {
          item.expanded = !!expanded;
        }
      }
    });
  }
  buildTreeFromWhatGridIsDisplaying() {
    syncLayoutWithGrid(this.colModel, this.setColumnLayout.bind(this));
  }
  setColumnLayout(colDefs) {
    const columnTree = toolPanelCreateColumnTree(this.colModel, colDefs);
    this.buildListModel(columnTree);
    this.groupsExist = colDefs.some((colDef) => {
      return colDef && typeof colDef.children !== "undefined";
    });
    this.markFilteredColumns();
    this.flattenAndFilterModel();
  }
  buildTreeFromProvidedColumnDefs() {
    const colModel = this.colModel;
    this.buildListModel(colModel.getColDefColTree());
    this.groupsExist = !!colModel.colDefCols?.treeDepth;
  }
  buildListModel(columnTree) {
    const columnExpandedListener = this.onColumnExpanded.bind(this);
    const addListeners = (item) => {
      item.addEventListener("expandedChanged", columnExpandedListener);
      const removeFunc = item.removeEventListener.bind(item, "expandedChanged", columnExpandedListener);
      this.destroyColumnItemFuncs.push(removeFunc);
    };
    const colNames = this.beans.colNames;
    const recursivelyBuild = (tree, dept, parentList) => {
      tree.forEach((child) => {
        if ((0, import_ag_grid_community63.isProvidedColumnGroup)(child)) {
          createGroupItem(child, dept, parentList);
        } else {
          createColumnItem(child, dept, parentList);
        }
      });
    };
    const createGroupItem = (columnGroup, dept, parentList) => {
      const columnGroupDef = columnGroup.getColGroupDef();
      const skipThisGroup = columnGroupDef && columnGroupDef.suppressColumnsToolPanel;
      if (skipThisGroup) {
        return;
      }
      if (columnGroup.isPadding()) {
        recursivelyBuild(columnGroup.getChildren(), dept, parentList);
        return;
      }
      const displayName = colNames.getDisplayNameForProvidedColumnGroup(null, columnGroup, "columnToolPanel");
      const item = new ColumnModelItem(
        displayName,
        columnGroup,
        dept,
        true,
        this.expandGroupsByDefault
      );
      parentList.push(item);
      addListeners(item);
      recursivelyBuild(columnGroup.getChildren(), dept + 1, item.children);
    };
    const createColumnItem = (column, dept, parentList) => {
      const skipThisColumn = column.getColDef() && column.getColDef().suppressColumnsToolPanel;
      if (skipThisColumn) {
        return;
      }
      const displayName = colNames.getDisplayNameForColumn(column, "columnToolPanel");
      parentList.push(new ColumnModelItem(displayName, column, dept));
    };
    this.destroyColumnTree();
    recursivelyBuild(columnTree, 0, this.allColsTree);
  }
  onColumnExpanded() {
    this.flattenAndFilterModel();
  }
  flattenAndFilterModel() {
    this.displayedColsList = [];
    const recursiveFunc = (item) => {
      if (!item.passesFilter) {
        return;
      }
      this.displayedColsList.push(item);
      if (item.group && item.expanded) {
        item.children.forEach(recursiveFunc);
      }
    };
    const virtualList = this.virtualList;
    this.allColsTree.forEach(recursiveFunc);
    virtualList.setModel(new UIColumnModel(this.displayedColsList));
    const focusedRow = virtualList.getLastFocusedRow();
    virtualList.refresh();
    if (focusedRow != null) {
      this.focusRowIfAlive(focusedRow);
    }
    this.notifyListeners();
    this.refreshAriaLabel();
  }
  refreshAriaLabel() {
    const translate = this.getLocaleTextFunc();
    const columnListName = translate("ariaColumnPanelList", "Column List");
    const localeColumns = translate("columns", "Columns");
    const items = this.displayedColsList.length;
    (0, import_ag_grid_community63._setAriaLabel)(this.virtualList.getAriaElement(), `${columnListName} ${items} ${localeColumns}`);
  }
  focusRowIfAlive(rowIndex) {
    window.setTimeout(() => {
      if (this.isAlive()) {
        this.virtualList.focusRow(rowIndex);
      }
    }, 0);
  }
  forEachItem(callback) {
    const recursiveFunc = (items) => {
      items.forEach((item) => {
        callback(item);
        if (item.group) {
          recursiveFunc(item.children);
        }
      });
    };
    const allColsTree = this.allColsTree;
    if (!allColsTree) {
      return;
    }
    recursiveFunc(allColsTree);
  }
  doSetExpandedAll(value) {
    this.forEachItem((item) => {
      if (item.group) {
        item.expanded = value;
      }
    });
  }
  setGroupsExpanded(expand, groupIds) {
    if (!groupIds) {
      this.doSetExpandedAll(expand);
      return;
    }
    const expandedGroupIds = [];
    this.forEachItem((item) => {
      if (!item.group) {
        return;
      }
      const groupId = item.columnGroup.getId();
      if (groupIds.indexOf(groupId) >= 0) {
        item.expanded = expand;
        expandedGroupIds.push(groupId);
      }
    });
    const unrecognisedGroupIds = groupIds.filter((groupId) => !expandedGroupIds.includes(groupId));
    if (unrecognisedGroupIds.length > 0) {
      (0, import_ag_grid_community63._warn)(157, { unrecognisedGroupIds });
    }
  }
  getExpandState() {
    let expandedCount = 0;
    let notExpandedCount = 0;
    this.forEachItem((item) => {
      if (!item.group) {
        return;
      }
      if (item.expanded) {
        expandedCount++;
      } else {
        notExpandedCount++;
      }
    });
    if (expandedCount > 0 && notExpandedCount > 0) {
      return 2 /* INDETERMINATE */;
    }
    if (notExpandedCount > 0) {
      return 1 /* COLLAPSED */;
    }
    return 0 /* EXPANDED */;
  }
  doSetSelectedAll(selectAllChecked) {
    selectAllChildren(this.beans, this.allColsTree, selectAllChecked, this.eventType);
  }
  getSelectionState() {
    let checkedCount = 0;
    let uncheckedCount = 0;
    const pivotMode = this.colModel.isPivotMode();
    this.forEachItem((item) => {
      if (item.group) {
        return;
      }
      if (!item.passesFilter) {
        return;
      }
      const column = item.column;
      const colDef = column.getColDef();
      let checked;
      if (pivotMode) {
        const noPivotModeOptionsAllowed = !column.isAllowPivot() && !column.isAllowRowGroup() && !column.isAllowValue();
        if (noPivotModeOptionsAllowed) {
          return;
        }
        checked = column.isValueActive() || column.isPivotActive() || column.isRowGroupActive();
      } else {
        if (colDef.lockVisible) {
          return;
        }
        checked = column.isVisible();
      }
      checked ? checkedCount++ : uncheckedCount++;
    });
    if (checkedCount > 0 && uncheckedCount > 0) {
      return void 0;
    }
    return !(checkedCount === 0 || uncheckedCount > 0);
  }
  setFilterText(filterText) {
    this.filterText = (0, import_ag_grid_community63._exists)(filterText) ? filterText.toLowerCase() : null;
    this.markFilteredColumns();
    this.flattenAndFilterModel();
  }
  markFilteredColumns() {
    const passesFilter = (item) => {
      if (!(0, import_ag_grid_community63._exists)(this.filterText)) {
        return true;
      }
      const displayName = item.displayName;
      return displayName == null || displayName.toLowerCase().indexOf(this.filterText) !== -1;
    };
    const recursivelyCheckFilter = (item, parentPasses) => {
      let atLeastOneChildPassed = false;
      if (item.group) {
        const groupPasses = passesFilter(item);
        item.children.forEach((child) => {
          const childPasses = recursivelyCheckFilter(child, groupPasses || parentPasses);
          if (childPasses) {
            atLeastOneChildPassed = childPasses;
          }
        });
      }
      const filterPasses = parentPasses || atLeastOneChildPassed ? true : passesFilter(item);
      item.passesFilter = filterPasses;
      return filterPasses;
    };
    this.allColsTree.forEach((item) => recursivelyCheckFilter(item, false));
  }
  notifyListeners() {
    this.fireGroupExpandedEvent();
    this.fireSelectionChangedEvent();
  }
  fireGroupExpandedEvent() {
    const expandState = this.getExpandState();
    this.dispatchLocalEvent({ type: "groupExpanded", state: expandState });
  }
  fireSelectionChangedEvent() {
    if (!this.allColsTree) {
      return;
    }
    const selectionState = this.getSelectionState();
    this.dispatchLocalEvent({ type: "selectionChanged", state: selectionState });
  }
  getExpandedGroups() {
    const expandedGroupIds = [];
    if (!this.allColsTree) {
      return expandedGroupIds;
    }
    this.forEachItem((item) => {
      if (item.group && item.expanded) {
        expandedGroupIds.push(item.columnGroup.getId());
      }
    });
    return expandedGroupIds;
  }
};
var AgPrimaryColsListSelector = {
  selector: "AG-PRIMARY-COLS-LIST",
  component: AgPrimaryColsList
};

// packages/ag-grid-enterprise/src/columnToolPanel/agPrimaryCols.ts
var AgPrimaryCols = class extends import_ag_grid_community64.Component {
  constructor() {
    super(
      /* html */
      `<div class="ag-column-select">
            <ag-primary-cols-header data-ref="primaryColsHeaderPanel"></ag-primary-cols-header>
            <ag-primary-cols-list data-ref="primaryColsListPanel"></ag-primary-cols-list>
        </div>`,
      [AgPrimaryColsHeaderSelector, AgPrimaryColsListSelector]
    );
    this.primaryColsHeaderPanel = import_ag_grid_community64.RefPlaceholder;
    this.primaryColsListPanel = import_ag_grid_community64.RefPlaceholder;
    this.registerCSS(agPrimaryColsCSS);
  }
  // we allow dragging in the toolPanel, but not when this component appears in the column menu
  init(allowDragging, params, eventType) {
    const { primaryColsHeaderPanel, primaryColsListPanel } = this;
    primaryColsHeaderPanel.init(params);
    const hideFilter = params.suppressColumnFilter;
    const hideSelect = params.suppressColumnSelectAll;
    const hideExpand = params.suppressColumnExpandAll;
    if (hideExpand && hideFilter && hideSelect) {
      primaryColsHeaderPanel.setDisplayed(false);
    }
    this.addManagedListeners(primaryColsListPanel, {
      groupExpanded: (event) => {
        primaryColsHeaderPanel.setExpandState(event.state);
        params.onStateUpdated();
      },
      selectionChanged: (event) => primaryColsHeaderPanel.setSelectionState(event.state)
    });
    primaryColsListPanel.init(params, allowDragging, eventType);
    this.addManagedListeners(primaryColsHeaderPanel, {
      expandAll: primaryColsListPanel.doSetExpandedAll.bind(primaryColsListPanel, true),
      collapseAll: primaryColsListPanel.doSetExpandedAll.bind(primaryColsListPanel, false),
      selectAll: primaryColsListPanel.doSetSelectedAll.bind(primaryColsListPanel, true),
      unselectAll: primaryColsListPanel.doSetSelectedAll.bind(primaryColsListPanel, false),
      filterChanged: (event) => primaryColsListPanel.setFilterText(event.filterText)
    });
    this.positionableFeature = this.createManagedBean(new import_ag_grid_community64.PositionableFeature(this.getGui(), { minHeight: 100 }));
  }
  toggleResizable(resizable) {
    this.positionableFeature.setResizable(resizable ? { bottom: true } : false);
  }
  expandGroups(groupIds) {
    this.primaryColsListPanel.setGroupsExpanded(true, groupIds);
  }
  collapseGroups(groupIds) {
    this.primaryColsListPanel.setGroupsExpanded(false, groupIds);
  }
  setColumnLayout(colDefs) {
    this.primaryColsListPanel.setColumnLayout(colDefs);
  }
  syncLayoutWithGrid() {
    this.primaryColsListPanel.onColumnsChanged();
  }
  getExpandedGroups() {
    return this.primaryColsListPanel.getExpandedGroups();
  }
};

// packages/ag-grid-enterprise/src/columnToolPanel/columnToolPanel.css-GENERATED.ts
var columnToolPanelCSS = (
  /*css*/
  `.ag-column-panel{display:flex;flex:1 1 auto;flex-direction:column;overflow:hidden}.ag-pivot-mode-panel{display:flex;height:var(--ag-header-height)}.ag-pivot-mode-select{align-items:center;display:flex}:where(.ag-ltr) .ag-pivot-mode-select{margin-left:var(--ag-widget-container-horizontal-padding)}:where(.ag-rtl) .ag-pivot-mode-select{margin-right:var(--ag-widget-container-horizontal-padding)}.ag-column-panel-column-select{border-bottom:var(--ag-tool-panel-separator-border)}.ag-column-panel-column-select:where(:nth-child(n+2 of :not(.ag-hidden))){border-top:var(--ag-tool-panel-separator-border)}:where(.ag-column-panel) .ag-column-drop-vertical{flex:1 1 0px;min-height:50px;&:where(:not(.ag-last-column-drop)){border-bottom:var(--ag-tool-panel-separator-border)}}`
);

// packages/ag-grid-enterprise/src/columnToolPanel/columnToolPanel.ts
var ColumnToolPanel = class extends import_ag_grid_community65.Component {
  constructor() {
    super(
      /* html */
      `<div class="ag-column-panel"></div>`
    );
    this.initialised = false;
    this.childDestroyFuncs = [];
    this.registerCSS(columnToolPanelCSS);
  }
  wireBeans(beans) {
    this.colToolPanelFactory = beans.colToolPanelFactory;
  }
  // lazy initialise the panel
  setVisible(visible) {
    super.setDisplayed(visible);
    if (visible && !this.initialised) {
      this.init(this.params);
    }
  }
  init(params) {
    const defaultParams = (0, import_ag_grid_community65._addGridCommonParams)(this.gos, {
      suppressColumnMove: false,
      suppressColumnSelectAll: false,
      suppressColumnFilter: false,
      suppressColumnExpandAll: false,
      contractColumnSelection: false,
      suppressPivotMode: false,
      suppressRowGroups: false,
      suppressValues: false,
      suppressPivots: false,
      suppressSyncLayoutWithGrid: false
    });
    const mergedParams = {
      ...defaultParams,
      ...params
    };
    this.params = mergedParams;
    const { childDestroyFuncs, colToolPanelFactory, gos } = this;
    const hasPivotModule = gos.isModuleRegistered("SharedPivot");
    const hasRowGroupingModule = hasPivotModule || gos.isModuleRegistered("SharedRowGrouping");
    if (!mergedParams.suppressPivotMode && colToolPanelFactory && hasPivotModule) {
      this.pivotModePanel = colToolPanelFactory.createPivotModePanel(this, childDestroyFuncs);
    }
    const primaryColsPanel = this.createBean(new AgPrimaryCols());
    this.primaryColsPanel = primaryColsPanel;
    childDestroyFuncs.push(() => this.destroyBean(this.primaryColsPanel));
    primaryColsPanel.init(true, mergedParams, "toolPanelUi");
    primaryColsPanel.addCssClass("ag-column-panel-column-select");
    this.appendChild(primaryColsPanel);
    if (colToolPanelFactory) {
      if (!mergedParams.suppressRowGroups && hasRowGroupingModule) {
        this.rowGroupDropZonePanel = colToolPanelFactory.createRowGroupPanel(this, childDestroyFuncs);
      }
      if (!mergedParams.suppressValues && hasRowGroupingModule) {
        this.valuesDropZonePanel = colToolPanelFactory.createValuesPanel(this, childDestroyFuncs);
      }
      if (!mergedParams.suppressPivots && hasPivotModule) {
        this.pivotDropZonePanel = colToolPanelFactory.createPivotPanel(this, childDestroyFuncs);
      }
      this.setLastVisible();
      const [pivotModeListener] = this.addManagedEventListeners({
        columnPivotModeChanged: () => {
          this.resetChildrenHeight();
          this.setLastVisible();
        }
      });
      childDestroyFuncs.push(() => pivotModeListener());
    }
    this.initialised = true;
  }
  setPivotModeSectionVisible(visible) {
    const colToolPanelFactory = this.colToolPanelFactory;
    if (!colToolPanelFactory) {
      return;
    }
    this.pivotModePanel = colToolPanelFactory.setPanelVisible(
      this.pivotModePanel,
      visible,
      colToolPanelFactory.createPivotModePanel.bind(colToolPanelFactory, this, this.childDestroyFuncs, true)
    );
    this.setLastVisible();
  }
  setRowGroupsSectionVisible(visible) {
    const colToolPanelFactory = this.colToolPanelFactory;
    if (!colToolPanelFactory) {
      return;
    }
    this.rowGroupDropZonePanel = colToolPanelFactory.setPanelVisible(
      this.rowGroupDropZonePanel,
      visible,
      colToolPanelFactory.createRowGroupPanel.bind(colToolPanelFactory, this, this.childDestroyFuncs)
    );
    this.setLastVisible();
  }
  setValuesSectionVisible(visible) {
    const colToolPanelFactory = this.colToolPanelFactory;
    if (!colToolPanelFactory) {
      return;
    }
    this.valuesDropZonePanel = colToolPanelFactory.setPanelVisible(
      this.valuesDropZonePanel,
      visible,
      colToolPanelFactory.createValuesPanel.bind(colToolPanelFactory, this, this.childDestroyFuncs)
    );
    this.setLastVisible();
  }
  setPivotSectionVisible(visible) {
    const colToolPanelFactory = this.colToolPanelFactory;
    if (!colToolPanelFactory) {
      return;
    }
    this.pivotDropZonePanel = colToolPanelFactory.setPanelVisible(
      this.pivotDropZonePanel,
      visible,
      colToolPanelFactory.createPivotPanel.bind(colToolPanelFactory, this, this.childDestroyFuncs)
    );
    this.pivotDropZonePanel?.setDisplayed(visible);
    this.setLastVisible();
  }
  setResizers() {
    [this.primaryColsPanel, this.rowGroupDropZonePanel, this.valuesDropZonePanel, this.pivotDropZonePanel].forEach(
      (panel) => {
        if (!panel) {
          return;
        }
        const eGui = panel.getGui();
        panel.toggleResizable(
          !eGui.classList.contains("ag-last-column-drop") && !eGui.classList.contains("ag-hidden")
        );
      }
    );
  }
  setLastVisible() {
    const eGui = this.getGui();
    const columnDrops = Array.prototype.slice.call(eGui.querySelectorAll(".ag-column-drop"));
    columnDrops.forEach((columnDrop) => columnDrop.classList.remove("ag-last-column-drop"));
    const columnDropEls = eGui.querySelectorAll(".ag-column-drop:not(.ag-hidden)");
    const lastVisible = (0, import_ag_grid_community65._last)(columnDropEls);
    if (lastVisible) {
      lastVisible.classList.add("ag-last-column-drop");
    }
    this.setResizers();
  }
  resetChildrenHeight() {
    const eGui = this.getGui();
    const children = eGui.children;
    for (let i = 0; i < children.length; i++) {
      const { style } = children[i];
      style.removeProperty("height");
      style.removeProperty("flex");
    }
  }
  expandColumnGroups(groupIds) {
    this.primaryColsPanel.expandGroups(groupIds);
  }
  collapseColumnGroups(groupIds) {
    this.primaryColsPanel.collapseGroups(groupIds);
  }
  setColumnLayout(colDefs) {
    this.primaryColsPanel.setColumnLayout(colDefs);
  }
  syncLayoutWithGrid() {
    this.primaryColsPanel.syncLayoutWithGrid();
  }
  destroyChildren() {
    const childDestroyFuncs = this.childDestroyFuncs;
    childDestroyFuncs.forEach((func) => func());
    childDestroyFuncs.length = 0;
    (0, import_ag_grid_community65._clearElement)(this.getGui());
  }
  refresh(params) {
    this.destroyChildren();
    this.init(params);
    return true;
  }
  getState() {
    return {
      expandedGroupIds: this.primaryColsPanel.getExpandedGroups()
    };
  }
  destroy() {
    this.destroyChildren();
    super.destroy();
  }
};

// packages/ag-grid-enterprise/src/columnToolPanel/columnToolPanelFactory.ts
var import_ag_grid_community74 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/rowGrouping/columnDropZones/pivotDropZonePanel.ts
var import_ag_grid_community70 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/rowGrouping/columnDropZones/baseDropZonePanel.ts
var import_ag_grid_community69 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/widgets/pillDropZonePanel.ts
var import_ag_grid_community66 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/widgets/pillDropZonePanel.css-GENERATED.ts
var pillDropZonePanelCSS = (
  /*css*/
  `.ag-column-drop{align-items:center;display:inline-flex;overflow:auto;position:relative;width:100%}.ag-column-drop-list{align-items:center;display:flex}.ag-column-drop-cell{align-items:center;background-color:var(--ag-column-drop-cell-background-color);border:var(--ag-column-drop-cell-border);border-radius:500px;color:var(--ag-column-drop-cell-text-color);display:flex;padding:calc(var(--ag-spacing)*.25);position:relative;&:focus-visible{box-shadow:var(--ag-focus-shadow)}:where(.ag-drag-handle){color:var(--ag-column-drop-cell-drag-handle-color)}}:where(.ag-ltr) .ag-column-drop-cell{padding-left:calc(var(--ag-spacing)*.75)}:where(.ag-rtl) .ag-column-drop-cell{padding-right:calc(var(--ag-spacing)*.75)}.ag-column-drop-cell-text{flex:1 1 auto;margin:0 var(--ag-spacing);overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.ag-column-drop-vertical{align-items:stretch;display:flex;flex-direction:column;min-height:75px;overflow:hidden}.ag-column-drop-vertical-title-bar{align-items:center;display:flex;flex:none;padding:var(--ag-widget-container-vertical-padding) calc(var(--ag-spacing)*2) 0}.ag-column-drop-vertical-list{align-items:stretch;flex-direction:column;flex-grow:1;overflow-x:auto;padding-bottom:var(--ag-spacing);padding-left:var(--ag-spacing);padding-right:var(--ag-spacing);position:relative;>*{flex:none}}:where(.ag-column-drop-empty) .ag-column-drop-vertical-list{overflow:hidden}.ag-column-drop-cell-button{cursor:pointer;min-width:0;opacity:.75;&:hover{opacity:1}}.ag-column-drop-wrapper{display:flex}.ag-column-drop-horizontal-half-width{width:50%!important}.ag-column-drop-cell-ghost{opacity:.5}.ag-column-drop-horizontal{background-color:var(--ag-header-background-color);border-bottom:var(--ag-header-row-border);gap:var(--ag-cell-widget-spacing);height:var(--ag-header-height);overflow:hidden;white-space:nowrap}:where(.ag-ltr) .ag-column-drop-horizontal{padding-left:var(--ag-cell-horizontal-padding)}:where(.ag-rtl) .ag-column-drop-horizontal{padding-right:var(--ag-cell-horizontal-padding)}.ag-column-drop-horizontal-list{gap:var(--ag-cell-widget-spacing)}.ag-column-drop-vertical-cell{margin-top:var(--ag-spacing)}:where(.ag-ltr) .ag-column-drop-vertical-icon{margin-right:var(--ag-widget-horizontal-spacing)}:where(.ag-rtl) .ag-column-drop-vertical-icon{margin-left:var(--ag-widget-horizontal-spacing)}.ag-select-agg-func-popup{background:var(--ag-background-color);border:1px solid var(--ag-border-color);border-radius:var(--ag-border-radius);box-shadow:var(--ag-dropdown-shadow);height:calc(var(--ag-spacing)*5*3.5);padding:0;position:absolute}.ag-select-agg-func-virtual-list-item{cursor:default;&:hover{background-color:var(--ag-selected-row-background-color)}}:where(.ag-ltr) .ag-select-agg-func-virtual-list-item{padding-left:calc(var(--ag-spacing)*2)}:where(.ag-rtl) .ag-select-agg-func-virtual-list-item{padding-right:calc(var(--ag-spacing)*2)}:where(.ag-ltr) .ag-column-drop-horizontal-half-width:where(:not(:last-child)){border-right:1px solid var(--ag-border-color)}:where(.ag-rtl) .ag-column-drop-horizontal-half-width:where(:not(:last-child)){border-left:1px solid var(--ag-border-color)}`
);

// packages/ag-grid-enterprise/src/widgets/pillDropZonePanel.ts
function _insertArrayIntoArray(dest, src, toIndex) {
  if (dest == null || src == null) {
    return;
  }
  dest.splice(toIndex, 0, ...src);
}
var PillDropZonePanel = class extends import_ag_grid_community66.Component {
  constructor(horizontal) {
    super(
      /* html */
      `<div class="ag-unselectable" role="presentation"></div>`
    );
    this.horizontal = horizontal;
    this.state = "notDragging";
    this.guiDestroyFunctions = [];
    this.childPillComponents = [];
    this.resizeEnabled = false;
    this.addElementClasses(this.getGui());
    this.ePillDropList = document.createElement("div");
    this.addElementClasses(this.ePillDropList, "list");
    (0, import_ag_grid_community66._setAriaRole)(this.ePillDropList, "listbox");
    this.registerCSS(pillDropZonePanelCSS);
  }
  toggleResizable(resizable) {
    this.positionableFeature.setResizable(resizable ? { bottom: true } : false);
    this.resizeEnabled = resizable;
  }
  isSourceEventFromTarget(draggingEvent) {
    const { dropZoneTarget, dragSource } = draggingEvent;
    return dropZoneTarget.contains(dragSource.eElement);
  }
  destroy() {
    this.destroyGui();
    super.destroy();
  }
  destroyGui() {
    this.guiDestroyFunctions.forEach((func) => func());
    this.guiDestroyFunctions.length = 0;
    this.childPillComponents.length = 0;
    (0, import_ag_grid_community66._clearElement)(this.getGui());
    (0, import_ag_grid_community66._clearElement)(this.ePillDropList);
  }
  init(params) {
    this.params = params ?? {};
    this.createManagedBean(
      new import_ag_grid_community66.ManagedFocusFeature(this.getFocusableElement(), {
        onTabKeyDown: this.onTabKeyDown.bind(this),
        handleKeyDown: this.onKeyDown.bind(this)
      })
    );
    this.setupDropTarget();
    this.positionableFeature = new import_ag_grid_community66.PositionableFeature(this.getGui());
    this.createManagedBean(this.positionableFeature);
    this.refreshGui();
    (0, import_ag_grid_community66._setAriaLabel)(this.ePillDropList, this.getAriaLabel());
  }
  onTabKeyDown(e) {
    const focusableElements = (0, import_ag_grid_community66._findFocusableElements)(this.getFocusableElement(), null, true);
    const len = focusableElements.length;
    if (len === 0) {
      return;
    }
    const { shiftKey } = e;
    const activeEl = (0, import_ag_grid_community66._getActiveDomElement)(this.beans);
    const isFirstFocused = activeEl === focusableElements[0];
    const isLastFocused = activeEl === (0, import_ag_grid_community66._last)(focusableElements);
    const shouldAllowDefaultTab = len === 1 || isFirstFocused && shiftKey || isLastFocused && !shiftKey;
    if (!shouldAllowDefaultTab) {
      focusableElements[shiftKey ? 0 : len - 1].focus();
    }
  }
  onKeyDown(e) {
    const { key } = e;
    const isVertical = !this.horizontal;
    let isNext = key === import_ag_grid_community66.KeyCode.DOWN;
    let isPrevious = key === import_ag_grid_community66.KeyCode.UP;
    if (!isVertical) {
      const isRtl = this.gos.get("enableRtl");
      isNext = !isRtl && key === import_ag_grid_community66.KeyCode.RIGHT || isRtl && key === import_ag_grid_community66.KeyCode.LEFT;
      isPrevious = !isRtl && key === import_ag_grid_community66.KeyCode.LEFT || isRtl && key === import_ag_grid_community66.KeyCode.RIGHT;
    }
    if (!isNext && !isPrevious) {
      return;
    }
    const el = (0, import_ag_grid_community66._findNextFocusableElement)(this.beans, this.getFocusableElement(), false, isPrevious);
    if (el) {
      e.preventDefault();
      el.focus();
    }
  }
  addElementClasses(el, suffix) {
    suffix = suffix ? `-${suffix}` : "";
    const direction = this.horizontal ? "horizontal" : "vertical";
    el.classList.add(`ag-column-drop${suffix}`, `ag-column-drop-${direction}${suffix}`);
  }
  setupDropTarget() {
    this.dropTarget = {
      getContainer: this.getGui.bind(this),
      getIconName: this.getIconName.bind(this),
      onDragging: this.onDragging.bind(this),
      onDragEnter: this.onDragEnter.bind(this),
      onDragLeave: this.onDragLeave.bind(this),
      onDragStop: this.onDragStop.bind(this),
      onDragCancel: this.onDragCancel.bind(this),
      isInterestedIn: this.isInterestedIn.bind(this)
    };
    this.beans.dragAndDrop?.addDropTarget(this.dropTarget);
  }
  minimumAllowedNewInsertIndex() {
    return 0;
  }
  checkInsertIndex(draggingEvent) {
    const newIndex = this.getNewInsertIndex(draggingEvent);
    if (newIndex < 0) {
      return false;
    }
    const minimumAllowedIndex = this.minimumAllowedNewInsertIndex();
    const newAdjustedIndex = Math.max(minimumAllowedIndex, newIndex);
    const changed = newAdjustedIndex !== this.insertIndex;
    if (changed) {
      this.insertIndex = newAdjustedIndex;
    }
    return changed;
  }
  getNewInsertIndex(draggingEvent) {
    const mouseEvent = draggingEvent.event;
    const mouseLocation = this.horizontal ? mouseEvent.clientX : mouseEvent.clientY;
    const boundsList = this.childPillComponents.map((comp) => comp.getGui().getBoundingClientRect());
    const hoveredIndex = boundsList.findIndex(
      (rect) => this.horizontal ? rect.right > mouseLocation && rect.left < mouseLocation : rect.top < mouseLocation && rect.bottom > mouseLocation
    );
    if (hoveredIndex === -1) {
      const enableRtl = this.gos.get("enableRtl");
      const isLast = boundsList.every((rect) => mouseLocation > (this.horizontal ? rect.right : rect.bottom));
      if (isLast) {
        return enableRtl && this.horizontal ? 0 : this.childPillComponents.length;
      }
      const isFirst = boundsList.every((rect) => mouseLocation < (this.horizontal ? rect.left : rect.top));
      if (isFirst) {
        return enableRtl && this.horizontal ? this.childPillComponents.length : 0;
      }
      return this.insertIndex;
    }
    if (this.insertIndex <= hoveredIndex) {
      return hoveredIndex + 1;
    }
    return hoveredIndex;
  }
  checkDragStartedBySelf(draggingEvent) {
    if (this.state !== "notDragging") {
      return;
    }
    this.state = "rearrangeItems";
    this.potentialDndItems = this.getItems(draggingEvent.dragSource.getDragItem());
    this.refreshGui();
    this.checkInsertIndex(draggingEvent);
    this.refreshGui();
  }
  onDragging(draggingEvent) {
    this.checkDragStartedBySelf(draggingEvent);
    if (this.checkInsertIndex(draggingEvent)) {
      this.refreshGui();
    }
  }
  handleDragEnterEnd(_) {
  }
  onDragEnter(draggingEvent) {
    const dragItems = this.getItems(draggingEvent.dragSource.getDragItem());
    this.state = "newItemsIn";
    const goodDragItems = dragItems.filter((item) => this.isItemDroppable(item, draggingEvent));
    const alreadyPresent = goodDragItems.every(
      (item) => this.childPillComponents.map((cmp) => cmp.getItem()).indexOf(item) !== -1
    );
    if (goodDragItems.length === 0) {
      return;
    }
    this.potentialDndItems = goodDragItems;
    if (alreadyPresent) {
      this.state = "notDragging";
      return;
    }
    this.handleDragEnterEnd(draggingEvent);
    this.checkInsertIndex(draggingEvent);
    this.refreshGui();
  }
  isPotentialDndItems() {
    return !!this.potentialDndItems?.length;
  }
  handleDragLeaveEnd(_) {
  }
  onDragLeave(draggingEvent) {
    if (this.state === "rearrangeItems") {
      const items = this.getItems(draggingEvent.dragSource.getDragItem());
      this.removeItems(items);
    }
    if (this.isPotentialDndItems()) {
      this.handleDragLeaveEnd(draggingEvent);
      this.potentialDndItems = [];
      this.refreshGui();
    }
    this.state = "notDragging";
  }
  onDragCancel(draggingEvent) {
    if (this.isPotentialDndItems()) {
      if (this.state === "newItemsIn") {
        this.handleDragLeaveEnd(draggingEvent);
      }
      this.potentialDndItems = [];
      this.refreshGui();
    }
    this.state = "notDragging";
  }
  onDragStop() {
    if (this.isPotentialDndItems()) {
      if (this.state === "newItemsIn") {
        this.addItems(this.potentialDndItems);
      } else {
        this.rearrangeItems(this.potentialDndItems);
      }
      this.potentialDndItems = [];
      this.refreshGui();
    }
    this.state = "notDragging";
  }
  removeItems(itemsToRemove) {
    const newItemList = this.getExistingItems().filter((item) => !itemsToRemove.includes(item));
    this.updateItems(newItemList);
  }
  addItems(itemsToAdd) {
    if (!itemsToAdd) {
      return;
    }
    const newItemList = this.getExistingItems().slice();
    const itemsToAddNoDuplicates = itemsToAdd.filter((item) => newItemList.indexOf(item) < 0);
    _insertArrayIntoArray(newItemList, itemsToAddNoDuplicates, this.insertIndex);
    this.updateItems(newItemList);
  }
  addItem(item) {
    this.insertIndex = this.getExistingItems().length;
    this.addItems([item]);
    this.refreshGui();
  }
  rearrangeItems(itemsToAdd) {
    const newItemList = this.getNonGhostItems().slice();
    _insertArrayIntoArray(newItemList, itemsToAdd, this.insertIndex);
    if ((0, import_ag_grid_community66._areEqual)(newItemList, this.getExistingItems())) {
      return false;
    }
    this.updateItems(newItemList);
    return true;
  }
  refreshGui() {
    const scrollTop = this.ePillDropList.scrollTop;
    const resizeEnabled = this.resizeEnabled;
    const focusedIndex = this.getFocusedItem();
    const { eGridDiv } = this.beans;
    let alternateElement = (0, import_ag_grid_community66._findNextFocusableElement)(this.beans, eGridDiv);
    if (!alternateElement) {
      alternateElement = (0, import_ag_grid_community66._findNextFocusableElement)(this.beans, eGridDiv, false, true);
    }
    this.toggleResizable(false);
    this.destroyGui();
    this.addIconAndTitleToGui();
    this.addEmptyMessageToGui();
    this.addItemsToGui();
    if (!this.horizontal) {
      this.ePillDropList.scrollTop = scrollTop;
    }
    if (resizeEnabled) {
      this.toggleResizable(resizeEnabled);
    }
    if ((0, import_ag_grid_community66._isKeyboardMode)()) {
      this.restoreFocus(focusedIndex, alternateElement);
    }
  }
  getFocusedItem() {
    const eGui = this.getGui();
    const activeElement = (0, import_ag_grid_community66._getActiveDomElement)(this.beans);
    if (!eGui.contains(activeElement)) {
      return -1;
    }
    const items = Array.from(eGui.querySelectorAll(".ag-column-drop-cell"));
    return items.indexOf(activeElement);
  }
  restoreFocus(index, alternateElement) {
    const eGui = this.getGui();
    const items = Array.from(eGui.querySelectorAll(".ag-column-drop-cell"));
    if (index === -1) {
      return;
    }
    if (items.length === 0) {
      alternateElement.focus();
    }
    const indexToFocus = Math.min(items.length - 1, index);
    const el = items[indexToFocus];
    if (el) {
      el.focus();
    }
  }
  focusList(fromBottom) {
    const index = fromBottom ? this.childPillComponents.length - 1 : 0;
    this.restoreFocus(index, this.getFocusableElement());
  }
  getNonGhostItems() {
    const existingItems = this.getExistingItems();
    if (this.isPotentialDndItems()) {
      return existingItems.filter((item) => !this.potentialDndItems.includes(item));
    }
    return existingItems;
  }
  addItemsToGui() {
    const nonGhostItems = this.getNonGhostItems();
    const itemsToAddToGui = nonGhostItems.map((item) => this.createItemComponent(item, false));
    if (this.isPotentialDndItems()) {
      const dndItems = this.potentialDndItems.map((item) => this.createItemComponent(item, true));
      if (this.insertIndex >= itemsToAddToGui.length) {
        itemsToAddToGui.push(...dndItems);
      } else {
        itemsToAddToGui.splice(this.insertIndex, 0, ...dndItems);
      }
    }
    this.appendChild(this.ePillDropList);
    itemsToAddToGui.forEach((itemComponent, index) => {
      if (index > 0) {
        this.addArrow(this.ePillDropList);
      }
      this.ePillDropList.appendChild(itemComponent.getGui());
    });
    this.addAriaLabelsToComponents();
  }
  addAriaLabelsToComponents() {
    this.childPillComponents.forEach((comp, idx) => {
      const eGui = comp.getGui();
      (0, import_ag_grid_community66._setAriaPosInSet)(eGui, idx + 1);
      (0, import_ag_grid_community66._setAriaSetSize)(eGui, this.childPillComponents.length);
    });
  }
  createItemComponent(item, ghost) {
    const itemComponent = this.createPillComponent(item, this.dropTarget, ghost, this.horizontal);
    itemComponent.addEventListener("columnRemove", this.removeItems.bind(this, [item]));
    this.createBean(itemComponent);
    this.guiDestroyFunctions.push(() => this.destroyBean(itemComponent));
    if (!ghost) {
      this.childPillComponents.push(itemComponent);
    }
    return itemComponent;
  }
  addIconAndTitleToGui() {
    const { title, icon: eGroupIcon } = this.params;
    if (!title || !eGroupIcon) {
      return;
    }
    const eTitleBar = document.createElement("div");
    (0, import_ag_grid_community66._setAriaHidden)(eTitleBar, true);
    this.addElementClasses(eTitleBar, "title-bar");
    this.addElementClasses(eGroupIcon, "icon");
    this.addOrRemoveCssClass("ag-column-drop-empty", this.isExistingItemsEmpty());
    eTitleBar.appendChild(eGroupIcon);
    if (!this.horizontal) {
      const eTitle = document.createElement("span");
      this.addElementClasses(eTitle, "title");
      eTitle.innerHTML = title;
      eTitleBar.appendChild(eTitle);
    }
    this.appendChild(eTitleBar);
  }
  isExistingItemsEmpty() {
    return this.getExistingItems().length === 0;
  }
  addEmptyMessageToGui() {
    const { emptyMessage } = this.params;
    if (!emptyMessage || !this.isExistingItemsEmpty() || this.isPotentialDndItems()) {
      return;
    }
    const eMessage = document.createElement("span");
    eMessage.innerHTML = emptyMessage;
    this.addElementClasses(eMessage, "empty-message");
    this.ePillDropList.appendChild(eMessage);
  }
  addArrow(eParent) {
    if (this.horizontal) {
      const enableRtl = this.gos.get("enableRtl");
      const icon = (0, import_ag_grid_community66._createIconNoSpan)(enableRtl ? "panelDelimiterRtl" : "panelDelimiter", this.beans);
      this.addElementClasses(icon, "cell-separator");
      eParent.appendChild(icon);
    }
  }
};

// packages/ag-grid-enterprise/src/rowGrouping/columnDropZones/dropZoneColumnComp.ts
var import_ag_grid_community68 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/widgets/pillDragComp.ts
var import_ag_grid_community67 = require("ag-grid-community");
var PillDragComp = class extends import_ag_grid_community67.Component {
  constructor(dragSourceDropTarget, ghost, horizontal, template, agComponents) {
    super();
    this.dragSourceDropTarget = dragSourceDropTarget;
    this.ghost = ghost;
    this.horizontal = horizontal;
    this.template = template;
    this.agComponents = agComponents;
    this.eText = import_ag_grid_community67.RefPlaceholder;
    this.eDragHandle = import_ag_grid_community67.RefPlaceholder;
    this.eButton = import_ag_grid_community67.RefPlaceholder;
  }
  postConstruct() {
    this.setTemplate(
      this.template ?? /* html */
      `
            <span role="option">
              <span data-ref="eDragHandle" class="ag-drag-handle ag-column-drop-cell-drag-handle" role="presentation"></span>
              <span data-ref="eText" class="ag-column-drop-cell-text" aria-hidden="true"></span>
              <span data-ref="eButton" class="ag-column-drop-cell-button" role="presentation"></span>
            </span>`,
      this.agComponents
    );
    const eGui = this.getGui();
    const { beans, eDragHandle, eText, eButton } = this;
    this.addElementClasses(eGui);
    this.addElementClasses(eDragHandle, "drag-handle");
    this.addElementClasses(eText, "text");
    this.addElementClasses(eButton, "button");
    eDragHandle.appendChild((0, import_ag_grid_community67._createIconNoSpan)("columnDrag", beans));
    eButton.appendChild((0, import_ag_grid_community67._createIconNoSpan)("cancel", beans));
    this.tooltipFeature = this.createOptionalManagedBean(
      beans.registry.createDynamicBean("tooltipFeature", false, {
        getGui: () => this.getGui()
      })
    );
    this.setupComponents();
    if (!this.ghost && this.isDraggable()) {
      this.addDragSource();
    }
    this.setupAria();
    this.setupTooltip();
    this.activateTabIndex();
    this.refreshDraggable();
  }
  isDraggable() {
    return true;
  }
  refreshDraggable() {
    this.eDragHandle.classList.toggle("ag-column-select-column-readonly", !this.isDraggable());
  }
  setupAria() {
    const translate = this.getLocaleTextFunc();
    const ariaInstructions = [this.getAriaDisplayName()];
    this.addAdditionalAriaInstructions(ariaInstructions, translate);
    (0, import_ag_grid_community67._setAriaLabel)(this.getGui(), ariaInstructions.join(". "));
  }
  addAdditionalAriaInstructions(ariaInstructions, translate) {
    if (this.isRemovable()) {
      const deleteAria = translate("ariaDropZoneColumnComponentDescription", "Press DELETE to remove");
      ariaInstructions.push(deleteAria);
    }
  }
  setupTooltip() {
    const refresh = () => this.tooltipFeature?.setTooltipAndRefresh(this.getTooltip());
    refresh();
    this.addManagedEventListeners({ newColumnsLoaded: refresh });
  }
  getDragSourceId() {
    return void 0;
  }
  getDefaultIconName() {
    return "notAllowed";
  }
  addDragSource() {
    const {
      beans: { dragAndDrop },
      eDragHandle
    } = this;
    const getDragItem = this.createGetDragItem();
    const defaultIconName = this.getDefaultIconName();
    const dragSource = {
      type: this.getDragSourceType(),
      sourceId: this.getDragSourceId(),
      eElement: eDragHandle,
      getDefaultIconName: () => defaultIconName,
      getDragItem,
      dragItemName: this.getDisplayName()
    };
    dragAndDrop?.addDragSource(dragSource, true);
    this.addDestroyFunc(() => dragAndDrop?.removeDragSource(dragSource));
  }
  setupComponents() {
    this.setTextValue();
    this.setupRemove();
    if (this.ghost) {
      this.addCssClass("ag-column-drop-cell-ghost");
    }
  }
  isRemovable() {
    return true;
  }
  refreshRemove() {
    (0, import_ag_grid_community67._setDisplayed)(this.eButton, this.isRemovable());
  }
  setupRemove() {
    this.refreshRemove();
    const agEvent = { type: "columnRemove" };
    this.addGuiEventListener("keydown", (e) => this.onKeyDown(e));
    this.addManagedElementListeners(this.eButton, {
      click: (mouseEvent) => {
        this.dispatchLocalEvent(agEvent);
        mouseEvent.stopPropagation();
      }
    });
    const touchListener = new import_ag_grid_community67.TouchListener(this.eButton);
    this.addManagedListeners(touchListener, {
      tap: () => this.dispatchLocalEvent(agEvent)
    });
    this.addDestroyFunc(touchListener.destroy.bind(touchListener));
  }
  onKeyDown(e) {
    const isDelete = e.key === import_ag_grid_community67.KeyCode.DELETE;
    if (isDelete) {
      if (this.isRemovable()) {
        e.preventDefault();
        this.dispatchLocalEvent({ type: "columnRemove" });
      }
    }
  }
  getDisplayValue() {
    return this.getDisplayName();
  }
  setTextValue() {
    const displayValue = this.getDisplayValue();
    const displayValueSanitised = (0, import_ag_grid_community67._escapeString)(displayValue);
    this.eText.innerHTML = displayValueSanitised;
  }
  addElementClasses(el, suffix) {
    suffix = suffix ? `-${suffix}` : "";
    const direction = this.horizontal ? "horizontal" : "vertical";
    el.classList.add(`ag-column-drop-cell${suffix}`, `ag-column-drop-${direction}-cell${suffix}`);
  }
  destroy() {
    super.destroy();
    this.dragSourceDropTarget = null;
  }
};

// packages/ag-grid-enterprise/src/rowGrouping/columnDropZones/dropZoneColumnComp.ts
var DropZoneColumnComp = class extends PillDragComp {
  constructor(column, dragSourceDropTarget, ghost, dropZonePurpose, horizontal) {
    super(dragSourceDropTarget, ghost, horizontal);
    this.column = column;
    this.dropZonePurpose = dropZonePurpose;
    this.eSortIndicator = import_ag_grid_community68.RefPlaceholder;
    this.popupShowing = false;
  }
  postConstruct() {
    const { sortSvc, colNames } = this.beans;
    this.template = /* html */
    `
            <span role="option">
                <span data-ref="eDragHandle" class="ag-drag-handle ag-column-drop-cell-drag-handle" role="presentation"></span>
                <span data-ref="eText" class="ag-column-drop-cell-text" aria-hidden="true"></span>
                ${sortSvc ? '<ag-sort-indicator data-ref="eSortIndicator"></ag-sort-indicator>' : ""}
                <span data-ref="eButton" class="ag-column-drop-cell-button" role="presentation"></span>
            </span>
        `;
    if (sortSvc) {
      this.agComponents = [sortSvc.getSortIndicatorSelector()];
    }
    this.displayName = colNames.getDisplayNameForColumn(this.column, "columnDrop");
    super.postConstruct();
    if (sortSvc) {
      this.setupSort();
      this.addManagedEventListeners({
        sortChanged: () => {
          this.setupAria();
        }
      });
    }
    if (this.isGroupingZone()) {
      this.addManagedPropertyListener("groupLockGroupColumns", () => {
        this.refreshRemove();
        this.refreshDraggable();
        this.setupAria();
      });
    }
  }
  getItem() {
    return this.column;
  }
  getDisplayName() {
    return this.displayName;
  }
  getTooltip() {
    return this.column.getColDef().headerTooltip;
  }
  addAdditionalAriaInstructions(ariaInstructions, translate) {
    const isSortSuppressed = this.gos.get("rowGroupPanelSuppressSort");
    const isFunctionsReadOnly = this.gos.get("functionsReadOnly");
    if (this.isAggregationZone() && !isFunctionsReadOnly) {
      const aggregationMenuAria = translate(
        "ariaDropZoneColumnValueItemDescription",
        "Press ENTER to change the aggregation type"
      );
      ariaInstructions.push(aggregationMenuAria);
    }
    if (this.isGroupingZone() && this.column.isSortable() && !isSortSuppressed) {
      const sortProgressAria = translate("ariaDropZoneColumnGroupItemDescription", "Press ENTER to sort");
      ariaInstructions.push(sortProgressAria);
    }
    super.addAdditionalAriaInstructions(ariaInstructions, translate);
  }
  isDraggable() {
    return this.isReadOnly();
  }
  isRemovable() {
    return this.isReadOnly();
  }
  isReadOnly() {
    return !this.isGroupingAndLocked() && !this.gos.get("functionsReadOnly");
  }
  getAriaDisplayName() {
    const translate = this.getLocaleTextFunc();
    const { name, aggFuncName } = this.getColumnAndAggFuncName();
    const aggSeparator = translate("ariaDropZoneColumnComponentAggFuncSeparator", " of ");
    const sortDirection = {
      asc: translate("ariaDropZoneColumnComponentSortAscending", "ascending"),
      desc: translate("ariaDropZoneColumnComponentSortDescending", "descending")
    };
    const columnSort = this.column.getSort();
    const isSortSuppressed = this.gos.get("rowGroupPanelSuppressSort");
    return [
      aggFuncName && `${aggFuncName}${aggSeparator}`,
      name,
      this.isGroupingZone() && !isSortSuppressed && columnSort && `, ${sortDirection[columnSort]}`
    ].filter((part) => !!part).join("");
  }
  getColumnAndAggFuncName() {
    const name = this.displayName;
    let aggFuncName = "";
    if (this.isAggregationZone()) {
      const aggFunc = this.column.getAggFunc();
      const aggFuncString = typeof aggFunc === "string" ? aggFunc : "agg";
      const localeTextFunc = this.getLocaleTextFunc();
      aggFuncName = localeTextFunc(aggFuncString, aggFuncString);
    }
    return { name, aggFuncName };
  }
  setupSort() {
    if (!this.column.isSortable() || !this.isGroupingZone()) {
      return;
    }
    if (!this.gos.get("rowGroupPanelSuppressSort")) {
      this.eSortIndicator.setupSort(this.column, true);
      const performSort = (event) => {
        event.preventDefault();
        this.beans.sortSvc.progressSortFromEvent(this.column, event);
      };
      this.addGuiEventListener("click", performSort);
      this.addGuiEventListener("keydown", (e) => {
        const isEnter = e.key === import_ag_grid_community68.KeyCode.ENTER;
        if (isEnter && this.isGroupingZone()) {
          performSort(e);
        }
      });
    }
  }
  getDefaultIconName() {
    return "hide";
  }
  createGetDragItem() {
    const { column } = this;
    return () => {
      const visibleState = {};
      visibleState[column.getId()] = column.isVisible();
      return {
        columns: [column],
        visibleState
      };
    };
  }
  setupComponents() {
    super.setupComponents();
    if (this.isAggregationZone() && !this.gos.get("functionsReadOnly")) {
      this.addGuiEventListener("click", this.onShowAggFuncSelection.bind(this));
    }
  }
  onKeyDown(e) {
    super.onKeyDown(e);
    const isEnter = e.key === import_ag_grid_community68.KeyCode.ENTER;
    if (isEnter && this.isAggregationZone() && !this.gos.get("functionsReadOnly")) {
      e.preventDefault();
      this.onShowAggFuncSelection();
    }
  }
  getDisplayValue() {
    const { name, aggFuncName } = this.getColumnAndAggFuncName();
    return this.isAggregationZone() ? `${aggFuncName}(${name})` : name;
  }
  onShowAggFuncSelection() {
    if (this.popupShowing) {
      return;
    }
    this.popupShowing = true;
    const { aggFuncSvc, popupSvc } = this.beans;
    const virtualList = new VirtualList({ cssIdentifier: "select-agg-func" });
    const rows = aggFuncSvc.getFuncNames(this.column);
    const eGui = this.getGui();
    const virtualListGui = virtualList.getGui();
    virtualList.setModel({
      getRow: function(index) {
        return rows[index];
      },
      getRowCount: function() {
        return rows.length;
      }
    });
    this.createBean(virtualList);
    const ePopup = (0, import_ag_grid_community68._loadTemplate)(
      /* html*/
      `<div class="ag-select-agg-func-popup"></div>`
    );
    ePopup.style.top = "0px";
    ePopup.style.left = "0px";
    ePopup.appendChild(virtualListGui);
    ePopup.style.width = `${eGui.clientWidth}px`;
    const [focusoutListener] = this.addManagedElementListeners(ePopup, {
      focusout: (e) => {
        if (!ePopup.contains(e.relatedTarget) && addPopupRes) {
          addPopupRes.hideFunc();
        }
      }
    });
    const popupHiddenFunc = (callbackEvent) => {
      this.destroyBean(virtualList);
      this.popupShowing = false;
      if (callbackEvent?.key === "Escape") {
        eGui.focus();
      }
      if (focusoutListener) {
        focusoutListener();
      }
    };
    const translate = this.getLocaleTextFunc();
    const addPopupRes = popupSvc.addPopup({
      modal: true,
      eChild: ePopup,
      closeOnEsc: true,
      closedCallback: popupHiddenFunc,
      ariaLabel: translate("ariaLabelAggregationFunction", "Aggregation Function")
    });
    if (addPopupRes) {
      virtualList.setComponentCreator(this.createAggSelect.bind(this, addPopupRes.hideFunc));
    }
    virtualList.addGuiEventListener("keydown", (e) => {
      if (e.key === import_ag_grid_community68.KeyCode.ENTER || e.key === import_ag_grid_community68.KeyCode.SPACE) {
        const row = virtualList.getLastFocusedRow();
        if (row == null) {
          return;
        }
        const comp = virtualList.getComponentAt(row);
        if (comp) {
          comp.selectItem();
        }
      }
    });
    popupSvc.positionPopupByComponent({
      type: "aggFuncSelect",
      eventSource: eGui,
      ePopup,
      keepWithinBounds: true,
      column: this.column,
      position: "under"
    });
    virtualList.refresh();
    let rowToFocus = rows.findIndex((r) => r === this.column.getAggFunc());
    if (rowToFocus === -1) {
      rowToFocus = 0;
    }
    virtualList.focusRow(rowToFocus);
  }
  createAggSelect(hidePopup, value) {
    const itemSelected = () => {
      hidePopup();
      this.getGui().focus();
      this.beans.valueColsSvc?.setColumnAggFunc?.(this.column, value, "toolPanelDragAndDrop");
    };
    const localeTextFunc = this.getLocaleTextFunc();
    const aggFuncString = value.toString();
    const aggFuncStringTranslated = localeTextFunc(aggFuncString, aggFuncString);
    const comp = new AggItemComp(itemSelected, aggFuncStringTranslated);
    return comp;
  }
  isGroupingAndLocked() {
    return this.isGroupingZone() && isRowGroupColLocked(this.column, this.beans);
  }
  isAggregationZone() {
    return this.dropZonePurpose === "aggregation";
  }
  isGroupingZone() {
    return this.dropZonePurpose === "rowGroup";
  }
  getDragSourceType() {
    return import_ag_grid_community68.DragSourceType.ToolPanel;
  }
  destroy() {
    super.destroy();
    this.column = null;
  }
};
var AggItemComp = class extends import_ag_grid_community68.Component {
  constructor(itemSelected, value) {
    super(
      /* html */
      `<div class="ag-select-agg-func-item"/>`
    );
    this.selectItem = itemSelected;
    this.getGui().innerText = value;
    this.addGuiEventListener("click", this.selectItem);
  }
};

// packages/ag-grid-enterprise/src/rowGrouping/columnDropZones/baseDropZonePanel.ts
var BaseDropZonePanel = class extends PillDropZonePanel {
  constructor(horizontal, dropZonePurpose) {
    super(horizontal);
    this.dropZonePurpose = dropZonePurpose;
    this.addElementClasses(this.getGui(), this.dropZonePurpose.toLowerCase());
  }
  init(params) {
    super.init(params);
    this.addManagedEventListeners({ newColumnsLoaded: this.refreshGui.bind(this) });
    this.addManagedPropertyListeners(
      ["functionsReadOnly", "rowGroupPanelSuppressSort", "groupLockGroupColumns"],
      this.refreshGui.bind(this)
    );
  }
  getItems(dragItem) {
    return dragItem.columns ?? [];
  }
  isInterestedIn(type) {
    return type === import_ag_grid_community69.DragSourceType.HeaderCell || type === import_ag_grid_community69.DragSourceType.ToolPanel;
  }
  minimumAllowedNewInsertIndex() {
    const { gos, rowGroupColsSvc } = this.beans;
    const numberOfLockedCols = gos.get("groupLockGroupColumns");
    const numberOfGroupCols = rowGroupColsSvc?.columns.length ?? 0;
    if (numberOfLockedCols === -1) {
      return numberOfGroupCols;
    }
    return Math.min(numberOfLockedCols, numberOfGroupCols);
  }
  showOrHideColumnOnExit(draggingEvent) {
    return this.isRowGroupPanel() && (0, import_ag_grid_community69._shouldUpdateColVisibilityAfterGroup)(this.gos, true) && !draggingEvent.fromNudge;
  }
  handleDragEnterEnd(draggingEvent) {
    const hideColumnOnExit = this.showOrHideColumnOnExit(draggingEvent);
    if (hideColumnOnExit) {
      const dragItem = draggingEvent.dragSource.getDragItem();
      const columns = dragItem.columns;
      this.setColumnsVisible(columns, false, "uiColumnDragged");
    }
  }
  handleDragLeaveEnd(draggingEvent) {
    const showColumnOnExit = this.showOrHideColumnOnExit(draggingEvent);
    if (showColumnOnExit) {
      const dragItem = draggingEvent.dragSource.getDragItem();
      this.setColumnsVisible(dragItem.columns, true, "uiColumnDragged");
    }
  }
  setColumnsVisible(columns, visible, source) {
    if (columns) {
      const allowedCols = columns.filter((c) => !c.getColDef().lockVisible);
      this.beans.colModel.setColsVisible(allowedCols, visible, source);
    }
  }
  isRowGroupPanel() {
    return this.dropZonePurpose === "rowGroup";
  }
  createPillComponent(column, dropTarget, ghost, horizontal) {
    return new DropZoneColumnComp(column, dropTarget, ghost, this.dropZonePurpose, horizontal);
  }
};

// packages/ag-grid-enterprise/src/rowGrouping/columnDropZones/pivotDropZonePanel.ts
var PivotDropZonePanel = class extends BaseDropZonePanel {
  constructor(horizontal) {
    super(horizontal, "pivot");
  }
  postConstruct() {
    const localeTextFunc = this.getLocaleTextFunc();
    const emptyMessage = localeTextFunc("pivotColumnsEmptyMessage", "Drag here to set column labels");
    const title = localeTextFunc("pivots", "Column Labels");
    super.init({
      icon: (0, import_ag_grid_community70._createIconNoSpan)("pivotPanel", this.beans, null),
      emptyMessage,
      title
    });
    this.addManagedEventListeners({
      newColumnsLoaded: this.refresh.bind(this),
      columnPivotChanged: this.refresh.bind(this),
      columnPivotModeChanged: this.checkVisibility.bind(this)
    });
    this.refresh();
  }
  getAriaLabel() {
    const translate = this.getLocaleTextFunc();
    const label = translate("ariaPivotDropZonePanelLabel", "Column Labels");
    return label;
  }
  refresh() {
    this.checkVisibility();
    this.refreshGui();
  }
  checkVisibility() {
    const colModel = this.beans.colModel;
    const pivotMode = colModel.isPivotMode();
    if (this.horizontal) {
      switch (this.gos.get("pivotPanelShow")) {
        case "always":
          this.setDisplayed(pivotMode);
          break;
        case "onlyWhenPivoting": {
          const pivotActive = colModel.isPivotActive();
          this.setDisplayed(pivotMode && pivotActive);
          break;
        }
        default:
          this.setDisplayed(false);
          break;
      }
    } else {
      this.setDisplayed(pivotMode);
    }
  }
  isItemDroppable(column, draggingEvent) {
    if (this.gos.get("functionsReadOnly") || !column.isPrimary()) {
      return false;
    }
    return column.isAllowPivot() && (!column.isPivotActive() || this.isSourceEventFromTarget(draggingEvent));
  }
  updateItems(columns) {
    this.beans.pivotColsSvc?.setColumns(columns, "toolPanelUi");
  }
  getIconName() {
    return this.isPotentialDndItems() ? "pivot" : "notAllowed";
  }
  getExistingItems() {
    return this.beans.pivotColsSvc?.columns ?? [];
  }
};

// packages/ag-grid-enterprise/src/rowGrouping/columnDropZones/rowGroupDropZonePanel.ts
var import_ag_grid_community71 = require("ag-grid-community");
var RowGroupDropZonePanel = class extends BaseDropZonePanel {
  constructor(horizontal) {
    super(horizontal, "rowGroup");
  }
  postConstruct() {
    const localeTextFunc = this.getLocaleTextFunc();
    const emptyMessage = localeTextFunc("rowGroupColumnsEmptyMessage", "Drag here to set row groups");
    const title = localeTextFunc("groups", "Row Groups");
    super.init({
      icon: (0, import_ag_grid_community71._createIconNoSpan)("rowGroupPanel", this.beans, null),
      emptyMessage,
      title
    });
    this.addManagedEventListeners({ columnRowGroupChanged: this.refreshGui.bind(this) });
  }
  getAriaLabel() {
    const translate = this.getLocaleTextFunc();
    const label = translate("ariaRowGroupDropZonePanelLabel", "Row Groups");
    return label;
  }
  isItemDroppable(column, draggingEvent) {
    if (this.gos.get("functionsReadOnly") || !column.isPrimary() || column.colDef.showRowGroup) {
      return false;
    }
    return column.isAllowRowGroup() && (!column.isRowGroupActive() || this.isSourceEventFromTarget(draggingEvent));
  }
  updateItems(columns) {
    this.beans.rowGroupColsSvc?.setColumns(columns, "toolPanelUi");
  }
  getIconName() {
    return this.isPotentialDndItems() ? "group" : "notAllowed";
  }
  getExistingItems() {
    return this.beans.rowGroupColsSvc?.columns ?? [];
  }
};

// packages/ag-grid-enterprise/src/rowGrouping/columnDropZones/valueDropZonePanel.ts
var import_ag_grid_community72 = require("ag-grid-community");
var ValuesDropZonePanel = class extends BaseDropZonePanel {
  constructor(horizontal) {
    super(horizontal, "aggregation");
  }
  postConstruct() {
    const localeTextFunc = this.getLocaleTextFunc();
    const emptyMessage = localeTextFunc("valueColumnsEmptyMessage", "Drag here to aggregate");
    const title = localeTextFunc("values", "Values");
    super.init({
      icon: (0, import_ag_grid_community72._createIconNoSpan)("valuePanel", this.beans, null),
      emptyMessage,
      title
    });
    this.addManagedEventListeners({ columnValueChanged: this.refreshGui.bind(this) });
  }
  getAriaLabel() {
    const translate = this.getLocaleTextFunc();
    const label = translate("ariaValuesDropZonePanelLabel", "Values");
    return label;
  }
  getIconName() {
    return this.isPotentialDndItems() ? "aggregate" : "notAllowed";
  }
  isItemDroppable(column, draggingEvent) {
    if (this.gos.get("functionsReadOnly") || !column.isPrimary()) {
      return false;
    }
    return column.isAllowValue() && (!column.isValueActive() || this.isSourceEventFromTarget(draggingEvent));
  }
  updateItems(columns) {
    this.beans.valueColsSvc?.setColumns(columns, "toolPanelUi");
  }
  getExistingItems() {
    return this.beans.valueColsSvc?.columns ?? [];
  }
};

// packages/ag-grid-enterprise/src/columnToolPanel/pivotModePanel.ts
var import_ag_grid_community73 = require("ag-grid-community");
var PivotModePanel = class extends import_ag_grid_community73.Component {
  constructor() {
    super(...arguments);
    this.cbPivotMode = import_ag_grid_community73.RefPlaceholder;
  }
  createTemplate() {
    return (
      /* html */
      `<div class="ag-pivot-mode-panel">
                <ag-toggle-button data-ref="cbPivotMode" class="ag-pivot-mode-select"></ag-toggle-button>
            </div>`
    );
  }
  postConstruct() {
    this.setTemplate(this.createTemplate(), [import_ag_grid_community73.AgToggleButtonSelector]);
    const cbPivotMode = this.cbPivotMode;
    const { colModel, ctrlsSvc, gos } = this.beans;
    cbPivotMode.setValue(colModel.isPivotMode());
    const localeTextFunc = this.getLocaleTextFunc();
    cbPivotMode.setLabel(localeTextFunc("pivotMode", "Pivot Mode"));
    const onBtPivotMode = () => {
      const newValue = !!cbPivotMode.getValue();
      if (newValue !== colModel.isPivotMode()) {
        gos.updateGridOptions({ options: { pivotMode: newValue }, source: "toolPanelUi" });
        ctrlsSvc.getHeaderRowContainerCtrls().forEach((c) => c.refresh());
      }
    };
    const onPivotModeChanged = () => {
      const pivotModeActive = colModel.isPivotMode();
      cbPivotMode.setValue(pivotModeActive);
    };
    this.addManagedListeners(cbPivotMode, { fieldValueChanged: onBtPivotMode });
    this.addManagedEventListeners({
      newColumnsLoaded: onPivotModeChanged,
      columnPivotModeChanged: onPivotModeChanged
    });
  }
};

// packages/ag-grid-enterprise/src/columnToolPanel/columnToolPanelFactory.ts
var ColumnToolPanelFactory = class extends import_ag_grid_community74.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "colToolPanelFactory";
  }
  setPanelVisible(existingPanel, visible, createFunc) {
    if (existingPanel) {
      existingPanel.setDisplayed(visible);
    } else if (visible) {
      existingPanel = createFunc();
    }
    return existingPanel;
  }
  createRowGroupPanel(parent, destroyFuncs) {
    return this.createPanel(parent, destroyFuncs, new RowGroupDropZonePanel(false));
  }
  createValuesPanel(parent, destroyFuncs) {
    return this.createPanel(parent, destroyFuncs, new ValuesDropZonePanel(false));
  }
  createPivotPanel(parent, destroyFuncs) {
    return this.createPanel(parent, destroyFuncs, new PivotDropZonePanel(false));
  }
  createPivotModePanel(parent, destroyFuncs, prepend) {
    return this.createPanel(parent, destroyFuncs, new PivotModePanel(), prepend);
  }
  createPanel(parent, destroyFuncs, panel, prepend) {
    panel = parent.createBean(panel);
    destroyFuncs.push(() => parent.destroyBean(panel));
    if (prepend) {
      parent.prependChild(panel);
    } else {
      parent.appendChild(panel);
    }
    return panel;
  }
};

// packages/ag-grid-enterprise/src/columnToolPanel/columnsToolPanelModule.ts
var ColumnsToolPanelModule = {
  moduleName: "ColumnsToolPanel",
  version: VERSION,
  beans: [ColumnToolPanelFactory],
  userComponents: { agColumnsToolPanel: ColumnToolPanel },
  icons: {
    // column tool panel tab
    columnsToolPanel: "columns",
    // "Group by {column-name}" item in column header menu
    menuAddRowGroup: "group",
    // "Un-Group by {column-name}" item in column header menu
    menuRemoveRowGroup: "group",
    // identifies the pivot drop zone
    pivotPanel: "pivot",
    // "Row groups" drop zone in column tool panel
    rowGroupPanel: "group",
    // columns tool panel Values drop zone
    valuePanel: "aggregation",
    // column tool panel column group contracted (click to expand)
    columnSelectClosed: "tree-closed",
    // column tool panel column group expanded (click to contract)
    columnSelectOpen: "tree-open",
    // column tool panel header expand/collapse all button, shown when some children are expanded and
    //     others are collapsed
    columnSelectIndeterminate: "tree-indeterminate"
  },
  dependsOn: [
    EnterpriseCoreModule,
    SideBarModule,
    import_ag_grid_community75._ColumnMoveModule,
    import_ag_grid_community75._SharedDragAndDropModule,
    import_ag_grid_community75._PopupModule,
    MenuItemModule
  ]
};

// packages/ag-grid-enterprise/src/menu/menuModule.ts
var import_ag_grid_community84 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/menu/chartMenuItemMapper.ts
var import_ag_grid_community76 = require("ag-grid-community");
var ChartMenuItemMapper = class extends import_ag_grid_community76.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "chartMenuItemMapper";
  }
  getChartItems(key) {
    const beans = this.beans;
    const chartSvc = beans.chartSvc;
    const isPivot = key === "pivotChart";
    if (!chartSvc) {
      return null;
    }
    const getLocaleTextFunc = this.getLocaleTextFunc.bind(this);
    const builder = isPivot ? new PivotMenuItemMapper(beans, chartSvc, getLocaleTextFunc) : new RangeMenuItemMapper(beans, chartSvc, getLocaleTextFunc);
    const isEnterprise = chartSvc.isEnterprise();
    let topLevelMenuItem = builder.getMenuItem();
    if (topLevelMenuItem && topLevelMenuItem.subMenu && !isEnterprise) {
      const filterEnterpriseItems = (m) => ({
        ...m,
        subMenu: m.subMenu?.filter((menu) => !menu._enterprise).map((menu) => filterEnterpriseItems(menu))
      });
      topLevelMenuItem = filterEnterpriseItems(topLevelMenuItem);
    }
    const chartGroupsDef = this.gos.get("chartToolPanelsDef")?.settingsPanel?.chartGroupsDef;
    if (chartGroupsDef) {
      topLevelMenuItem = this.filterAndOrderChartMenu(
        topLevelMenuItem,
        chartGroupsDef,
        builder.getConfigLookup()
      );
    }
    return this.cleanInternals(topLevelMenuItem);
  }
  // Remove our internal _key and _enterprise properties so this does not leak out of the class on the menu items.
  cleanInternals(menuItem) {
    if (!menuItem) {
      return menuItem;
    }
    const removeKeys = (m) => {
      delete m?._key;
      delete m?._enterprise;
      m?.subMenu?.forEach((s) => removeKeys(s));
      return m;
    };
    return removeKeys(menuItem);
  }
  buildLookup(menuItem) {
    const itemLookup = {};
    const addItem = (item) => {
      itemLookup[item._key] = item;
      if (item.subMenu) {
        item.subMenu.forEach((s) => addItem(s));
      }
    };
    addItem(menuItem);
    return itemLookup;
  }
  /**
   * Make the MenuItem match the charts provided and their ordering on the ChartGroupsDef config object as provided by the user.
   */
  filterAndOrderChartMenu(topLevelMenuItem, chartGroupsDef, configLookup) {
    const menuItemLookup = this.buildLookup(topLevelMenuItem);
    const orderedAndFiltered = { ...topLevelMenuItem, subMenu: [] };
    for (const group of Object.keys(chartGroupsDef)) {
      const chartTypes = chartGroupsDef[group];
      const chartConfigGroup = configLookup[group];
      if (chartConfigGroup === null)
        continue;
      if (chartConfigGroup == void 0) {
        (0, import_ag_grid_community76._warn)(173, { group });
        continue;
      }
      const menuItem = menuItemLookup[chartConfigGroup._key];
      if (menuItem) {
        if (menuItem.subMenu) {
          const subMenus = chartTypes.map((chartType) => {
            const itemKey = chartConfigGroup[chartType];
            if (itemKey == void 0) {
              (0, import_ag_grid_community76._warn)(174, { group, chartType });
              return void 0;
            }
            return menuItemLookup[itemKey];
          }).filter((s) => s !== void 0);
          if (subMenus.length > 0) {
            menuItem.subMenu = subMenus;
            orderedAndFiltered.subMenu?.push(menuItem);
          }
        } else {
          orderedAndFiltered.subMenu?.push(menuItem);
        }
      }
    }
    if (orderedAndFiltered.subMenu?.length == 0) {
      return null;
    }
    return orderedAndFiltered;
  }
};
var PivotMenuItemMapper = class {
  constructor(beans, chartSvc, getLocaleTextFunc) {
    this.beans = beans;
    this.chartSvc = chartSvc;
    this.getLocaleTextFunc = getLocaleTextFunc;
  }
  getMenuItem() {
    const localeTextFunc = this.getLocaleTextFunc();
    const getMenuItem = (localeKey, defaultText, chartType, key, enterprise = false) => {
      return {
        name: localeTextFunc(localeKey, defaultText),
        action: () => this.chartSvc.createPivotChart({ chartType }),
        _key: key,
        _enterprise: enterprise
      };
    };
    return {
      name: localeTextFunc("pivotChart", "Pivot Chart"),
      _key: "pivotChart",
      subMenu: [
        {
          _key: "pivotColumnChart",
          name: localeTextFunc("columnChart", "Column"),
          subMenu: [
            getMenuItem("groupedColumn", "Grouped&lrm;", "groupedColumn", "pivotGroupedColumn"),
            getMenuItem("stackedColumn", "Stacked&lrm;", "stackedColumn", "pivotStackedColumn"),
            getMenuItem(
              "normalizedColumn",
              "100% Stacked&lrm;",
              "normalizedColumn",
              "pivotNormalizedColumn"
            )
          ]
        },
        {
          _key: "pivotBarChart",
          name: localeTextFunc("barChart", "Bar"),
          subMenu: [
            getMenuItem("groupedBar", "Grouped&lrm;", "groupedBar", "pivotGroupedBar"),
            getMenuItem("stackedBar", "Stacked&lrm;", "stackedBar", "pivotStackedBar"),
            getMenuItem("normalizedBar", "100% Stacked&lrm;", "normalizedBar", "pivotNormalizedBar")
          ]
        },
        {
          _key: "pivotPieChart",
          name: localeTextFunc("pieChart", "Pie"),
          subMenu: [
            getMenuItem("pie", "Pie&lrm;", "pie", "pivotPie"),
            getMenuItem("donut", "Donut&lrm;", "donut", "pivotDonut")
          ]
        },
        {
          _key: "pivotLineChart",
          name: localeTextFunc("lineChart", "Line"),
          subMenu: [
            getMenuItem("lineChart", "Line&lrm;", "line", "pivotLineChart"),
            getMenuItem("stackedLine", "Stacked&lrm;", "stackedLine", "pivotStackedLine"),
            getMenuItem("normalizedLine", "100% Stacked&lrm;", "normalizedLine", "pivotNormalizedLine")
          ]
        },
        {
          _key: "pivotAreaChart",
          name: localeTextFunc("areaChart", "Area"),
          subMenu: [
            getMenuItem("areaChart", "Area&lrm;", "area", "pivotArea"),
            getMenuItem("stackedArea", "Stacked&lrm;", "stackedArea", "pivotStackedArea"),
            getMenuItem("normalizedArea", "100% Stacked&lrm;", "normalizedArea", "pivotNormalizedArea")
          ]
        },
        {
          _key: "pivotXYChart",
          name: localeTextFunc("xyChart", "X Y (Scatter)"),
          subMenu: [
            getMenuItem("scatter", "Scatter&lrm;", "scatter", "pivotScatter"),
            getMenuItem("bubble", "Bubble&lrm;", "bubble", "pivotBubble")
          ]
        },
        {
          _key: "pivotStatisticalChart",
          _enterprise: false,
          // histogram chart is available in both community and enterprise distributions
          name: localeTextFunc("statisticalChart", "Statistical"),
          subMenu: [getMenuItem("histogramChart", "Histogram&lrm;", "histogram", "pivotHistogram", false)]
        },
        {
          _key: "pivotHierarchicalChart",
          _enterprise: true,
          name: localeTextFunc("hierarchicalChart", "Hierarchical"),
          subMenu: [
            getMenuItem("treemapChart", "Treemap&lrm;", "treemap", "pivotTreemap", true),
            getMenuItem("sunburstChart", "Sunburst&lrm;", "sunburst", "pivotSunburst", true)
          ]
        },
        {
          _key: "pivotFunnel",
          name: localeTextFunc("funnel", "Funnel"),
          subMenu: [
            getMenuItem("funnel", "Funnel&lrm;", "funnel", "pivotFunnel"),
            getMenuItem("coneFunnel", "Cone Funnel&lrm;", "coneFunnel", "pivotConeFunnel"),
            getMenuItem("pyramid", "Pyramid&lrm;", "pyramid", "pivotPyramid")
          ]
        },
        {
          _key: "pivotCombinationChart",
          name: localeTextFunc("combinationChart", "Combination"),
          subMenu: [
            getMenuItem("columnLineCombo", "Column & Line&lrm;", "columnLineCombo", "pivotColumnLineCombo"),
            getMenuItem("AreaColumnCombo", "Area & Column&lrm;", "areaColumnCombo", "pivotAreaColumnCombo")
          ]
        }
      ],
      icon: (0, import_ag_grid_community76._createIconNoSpan)("chart", this.beans, void 0)
    };
  }
  getConfigLookup() {
    return {
      columnGroup: {
        _key: "pivotColumnChart",
        column: "pivotGroupedColumn",
        stackedColumn: "pivotStackedColumn",
        normalizedColumn: "pivotNormalizedColumn"
      },
      barGroup: {
        _key: "pivotBarChart",
        bar: "pivotGroupedBar",
        stackedBar: "pivotStackedBar",
        normalizedBar: "pivotNormalizedBar"
      },
      pieGroup: {
        _key: "pivotPieChart",
        pie: "pivotPie",
        donut: "pivotDonut",
        doughnut: "pivotDonut"
      },
      lineGroup: {
        _key: "pivotLineChart",
        line: "pivotLineChart",
        stackedLine: "pivotStackedLine",
        normalizedLine: "pivotNormalizedLine"
      },
      areaGroup: {
        _key: "pivotAreaChart",
        area: "pivotArea",
        stackedArea: "pivotStackedArea",
        normalizedArea: "pivotNormalizedArea"
      },
      scatterGroup: {
        _key: "pivotXYChart",
        bubble: "pivotBubble",
        scatter: "pivotScatter"
      },
      combinationGroup: {
        _key: "pivotCombinationChart",
        columnLineCombo: "pivotColumnLineCombo",
        areaColumnCombo: "pivotAreaColumnCombo",
        customCombo: null
        // Not currently supported
      },
      hierarchicalGroup: {
        _key: "pivotHierarchicalChart",
        treemap: "pivotTreemap",
        sunburst: "pivotSunburst"
      },
      statisticalGroup: {
        _key: "pivotStatisticalChart",
        histogram: "pivotHistogram",
        // Some statistical charts do not currently support pivot mode
        rangeBar: null,
        rangeArea: null,
        boxPlot: null
      },
      funnelGroup: {
        _key: "pivotFunnel",
        funnel: "pivotFunnel",
        coneFunnel: "pivotConeFunnel",
        pyramid: "pivotPyramid"
      },
      // Polar charts do not support pivot mode
      polarGroup: null,
      // Specialized charts do not currently support pivot mode
      specializedGroup: null
    };
  }
};
var RangeMenuItemMapper = class {
  constructor(beans, chartSvc, getLocaleTextFunc) {
    this.beans = beans;
    this.chartSvc = chartSvc;
    this.getLocaleTextFunc = getLocaleTextFunc;
  }
  getMenuItem() {
    const localeTextFunc = this.getLocaleTextFunc();
    const getMenuItem = (localeKey, defaultText, chartType, key, enterprise = false) => {
      return {
        name: localeTextFunc(localeKey, defaultText),
        action: () => this.chartSvc.createChartFromCurrentRange(chartType),
        _key: key,
        _enterprise: enterprise
      };
    };
    return {
      name: localeTextFunc("chartRange", "Chart Range"),
      _key: "chartRange",
      subMenu: [
        {
          name: localeTextFunc("columnChart", "Column"),
          subMenu: [
            getMenuItem("groupedColumn", "Grouped&lrm;", "groupedColumn", "rangeGroupedColumn"),
            getMenuItem("stackedColumn", "Stacked&lrm;", "stackedColumn", "rangeStackedColumn"),
            getMenuItem(
              "normalizedColumn",
              "100% Stacked&lrm;",
              "normalizedColumn",
              "rangeNormalizedColumn"
            )
          ],
          _key: "rangeColumnChart"
        },
        {
          name: localeTextFunc("barChart", "Bar"),
          subMenu: [
            getMenuItem("groupedBar", "Grouped&lrm;", "groupedBar", "rangeGroupedBar"),
            getMenuItem("stackedBar", "Stacked&lrm;", "stackedBar", "rangeStackedBar"),
            getMenuItem("normalizedBar", "100% Stacked&lrm;", "normalizedBar", "rangeNormalizedBar")
          ],
          _key: "rangeBarChart"
        },
        {
          name: localeTextFunc("pieChart", "Pie"),
          subMenu: [
            getMenuItem("pie", "Pie&lrm;", "pie", "rangePie"),
            getMenuItem("donut", "Donut&lrm;", "donut", "rangeDonut")
          ],
          _key: "rangePieChart"
        },
        {
          name: localeTextFunc("lineChart", "Line"),
          subMenu: [
            getMenuItem("lineChart", "Line&lrm;", "line", "rangeLineChart"),
            getMenuItem("stackedLine", "Stacked&lrm;", "stackedLine", "rangeStackedLine"),
            getMenuItem("normalizedLine", "100% Stacked&lrm;", "normalizedLine", "rangeNormalizedLine")
          ],
          _key: "rangeLineChart"
        },
        {
          name: localeTextFunc("areaChart", "Area"),
          subMenu: [
            getMenuItem("areaChart", "Area&lrm;", "area", "rangeArea"),
            getMenuItem("stackedArea", "Stacked&lrm;", "stackedArea", "rangeStackedArea"),
            getMenuItem("normalizedArea", "100% Stacked&lrm;", "normalizedArea", "rangeNormalizedArea")
          ],
          _key: "rangeAreaChart"
        },
        {
          name: localeTextFunc("xyChart", "X Y (Scatter)"),
          subMenu: [
            getMenuItem("scatter", "Scatter&lrm;", "scatter", "rangeScatter"),
            getMenuItem("bubble", "Bubble&lrm;", "bubble", "rangeBubble")
          ],
          _key: "rangeXYChart"
        },
        {
          name: localeTextFunc("polarChart", "Polar"),
          subMenu: [
            getMenuItem("radarLine", "Radar Line&lrm;", "radarLine", "rangeRadarLine"),
            getMenuItem("radarArea", "Radar Area&lrm;", "radarArea", "rangeRadarArea"),
            getMenuItem("nightingale", "Nightingale&lrm;", "nightingale", "rangeNightingale"),
            getMenuItem("radialColumn", "Radial Column&lrm;", "radialColumn", "rangeRadialColumn"),
            getMenuItem("radialBar", "Radial Bar&lrm;", "radialBar", "rangeRadialBar")
          ],
          _key: "rangePolarChart",
          _enterprise: true
        },
        {
          name: localeTextFunc("statisticalChart", "Statistical"),
          subMenu: [
            getMenuItem("boxPlot", "Box Plot&lrm;", "boxPlot", "rangeBoxPlot", true),
            getMenuItem("histogramChart", "Histogram&lrm;", "histogram", "rangeHistogram", false),
            getMenuItem("rangeBar", "Range Bar&lrm;", "rangeBar", "rangeRangeBar", true),
            getMenuItem("rangeArea", "Range Area&lrm;", "rangeArea", "rangeRangeArea", true)
          ],
          _key: "rangeStatisticalChart",
          _enterprise: false
          // histogram chart is available in both community and enterprise distributions
        },
        {
          name: localeTextFunc("hierarchicalChart", "Hierarchical"),
          subMenu: [
            getMenuItem("treemap", "Treemap&lrm;", "treemap", "rangeTreemap"),
            getMenuItem("sunburst", "Sunburst&lrm;", "sunburst", "rangeSunburst")
          ],
          _key: "rangeHierarchicalChart",
          _enterprise: true
        },
        {
          name: localeTextFunc("specializedChart", "Specialized"),
          subMenu: [
            getMenuItem("heatmap", "Heatmap&lrm;", "heatmap", "rangeHeatmap"),
            getMenuItem("waterfall", "Waterfall&lrm;", "waterfall", "rangeWaterfall")
          ],
          _key: "rangeSpecializedChart",
          _enterprise: true
        },
        {
          name: localeTextFunc("funnel", "Funnel"),
          subMenu: [
            getMenuItem("funnel", "Funnel&lrm;", "funnel", "rangeFunnel"),
            getMenuItem("coneFunnel", "Cone Funnel&lrm;", "coneFunnel", "rangeConeFunnel"),
            getMenuItem("pyramid", "Pyramid&lrm;", "pyramid", "rangePyramid")
          ],
          _key: "rangeFunnel",
          _enterprise: true
        },
        {
          name: localeTextFunc("combinationChart", "Combination"),
          subMenu: [
            getMenuItem("columnLineCombo", "Column & Line&lrm;", "columnLineCombo", "rangeColumnLineCombo"),
            getMenuItem("AreaColumnCombo", "Area & Column&lrm;", "areaColumnCombo", "rangeAreaColumnCombo")
          ],
          _key: "rangeCombinationChart"
        }
      ],
      icon: (0, import_ag_grid_community76._createIconNoSpan)("chart", this.beans, void 0)
    };
  }
  getConfigLookup() {
    return {
      columnGroup: {
        _key: "rangeColumnChart",
        column: "rangeGroupedColumn",
        stackedColumn: "rangeStackedColumn",
        normalizedColumn: "rangeNormalizedColumn"
      },
      barGroup: {
        _key: "rangeBarChart",
        bar: "rangeGroupedBar",
        stackedBar: "rangeStackedBar",
        normalizedBar: "rangeNormalizedBar"
      },
      pieGroup: {
        _key: "rangePieChart",
        pie: "rangePie",
        donut: "rangeDonut",
        doughnut: "rangeDonut"
      },
      lineGroup: {
        _key: "rangeLineChart",
        line: "rangeLineChart",
        stackedLine: "rangeStackedLine",
        normalizedLine: "rangeNormalizedLine"
      },
      areaGroup: {
        _key: "rangeAreaChart",
        area: "rangeArea",
        stackedArea: "rangeStackedArea",
        normalizedArea: "rangeNormalizedArea"
      },
      scatterGroup: {
        _key: "rangeXYChart",
        bubble: "rangeBubble",
        scatter: "rangeScatter"
      },
      polarGroup: {
        _key: "rangePolarChart",
        radarLine: "rangeRadarLine",
        radarArea: "rangeRadarArea",
        nightingale: "rangeNightingale",
        radialColumn: "rangeRadialColumn",
        radialBar: "rangeRadialBar"
      },
      statisticalGroup: {
        _key: "rangeStatisticalChart",
        boxPlot: "rangeBoxPlot",
        histogram: "rangeHistogram",
        rangeBar: "rangeRangeBar",
        rangeArea: "rangeRangeArea"
      },
      hierarchicalGroup: {
        _key: "rangeHierarchicalChart",
        treemap: "rangeTreemap",
        sunburst: "rangeSunburst"
      },
      specializedGroup: {
        _key: "rangeSpecializedChart",
        heatmap: "rangeHeatmap",
        waterfall: "rangeWaterfall"
      },
      funnelGroup: {
        _key: "rangeFunnel",
        funnel: "rangeFunnel",
        coneFunnel: "rangeConeFunnel",
        pyramid: "rangePyramid"
      },
      combinationGroup: {
        _key: "rangeCombinationChart",
        columnLineCombo: "rangeColumnLineCombo",
        areaColumnCombo: "rangeAreaColumnCombo",
        customCombo: null
        // Not currently supported
      }
    };
  }
};

// packages/ag-grid-enterprise/src/menu/columnChooserFactory.ts
var import_ag_grid_community77 = require("ag-grid-community");
var ColumnChooserFactory = class extends import_ag_grid_community77.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "colChooserFactory";
  }
  createColumnSelectPanel(parent, column, draggable, params) {
    const columnSelectPanel = parent.createManagedBean(new AgPrimaryCols());
    const columnChooserParams = params ?? column?.getColDef().columnChooserParams ?? {};
    const {
      contractColumnSelection,
      suppressColumnExpandAll,
      suppressColumnFilter,
      suppressColumnSelectAll,
      suppressSyncLayoutWithGrid,
      columnLayout
    } = columnChooserParams;
    columnSelectPanel.init(
      !!draggable,
      (0, import_ag_grid_community77._addGridCommonParams)(this.gos, {
        suppressColumnMove: false,
        suppressValues: false,
        suppressPivots: false,
        suppressRowGroups: false,
        suppressPivotMode: false,
        contractColumnSelection: !!contractColumnSelection,
        suppressColumnExpandAll: !!suppressColumnExpandAll,
        suppressColumnFilter: !!suppressColumnFilter,
        suppressColumnSelectAll: !!suppressColumnSelectAll,
        suppressSyncLayoutWithGrid: !!columnLayout || !!suppressSyncLayoutWithGrid,
        onStateUpdated: () => {
        }
      }),
      "columnMenu"
    );
    if (columnLayout) {
      columnSelectPanel.setColumnLayout(columnLayout);
    }
    return columnSelectPanel;
  }
  showColumnChooser({
    column,
    chooserParams,
    eventSource,
    headerPosition: providedHeaderPosition
  }) {
    this.hideActiveColumnChooser();
    const columnSelectPanel = this.createColumnSelectPanel(this, column, true, chooserParams);
    const translate = this.getLocaleTextFunc();
    const beans = this.beans;
    const { visibleCols, focusSvc, menuUtils } = beans;
    const columnIndex = visibleCols.allCols.indexOf(column);
    const headerPosition = column ? focusSvc.focusedHeader ?? providedHeaderPosition ?? null : null;
    this.activeColumnChooserDialog = this.createBean(
      new AgDialog({
        title: translate("chooseColumns", "Choose Columns"),
        component: columnSelectPanel,
        width: 300,
        height: 300,
        resizable: true,
        movable: true,
        centered: true,
        closable: true,
        afterGuiAttached: () => {
          (0, import_ag_grid_community77._findNextFocusableElement)(beans, columnSelectPanel.getGui())?.focus({
            preventScroll: true
          });
          this.dispatchVisibleChangedEvent(true, column);
        },
        closedCallback: (event) => {
          const eComp = this.activeColumnChooser.getGui();
          this.destroyBean(this.activeColumnChooser);
          this.activeColumnChooser = void 0;
          this.activeColumnChooserDialog = void 0;
          this.dispatchVisibleChangedEvent(false, column);
          if (column) {
            menuUtils.restoreFocusOnClose(
              { column, headerPosition, columnIndex, eventSource },
              eComp,
              event,
              true
            );
          }
        },
        postProcessPopupParams: {
          type: "columnChooser",
          column,
          eventSource
        }
      })
    );
    this.activeColumnChooser = columnSelectPanel;
  }
  hideActiveColumnChooser() {
    this.destroyBean(this.activeColumnChooserDialog);
  }
  dispatchVisibleChangedEvent(visible, column) {
    this.eventSvc.dispatchEvent({
      type: "columnMenuVisibleChanged",
      visible,
      switchingTab: false,
      key: "columnChooser",
      column: column ?? null
    });
  }
};

// packages/ag-grid-enterprise/src/menu/columnMenuFactory.ts
var import_ag_grid_community79 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/menu/menuItemMapper.ts
var import_ag_grid_community78 = require("ag-grid-community");
var MENU_ITEM_SEPARATOR = "separator";
function _removeRepeatsFromArray(array, object) {
  if (!array) {
    return;
  }
  for (let index = array.length - 2; index >= 0; index--) {
    const thisOneMatches = array[index] === object;
    const nextOneMatches = array[index + 1] === object;
    if (thisOneMatches && nextOneMatches) {
      array.splice(index + 1, 1);
    }
  }
}
var MenuItemMapper = class extends import_ag_grid_community78.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "menuItemMapper";
  }
  mapWithStockItems(originalList, column, sourceElement, source) {
    if (!originalList) {
      return [];
    }
    const resultList = [];
    const localeTextFunc = this.getLocaleTextFunc();
    const { beans, gos } = this;
    const {
      validation,
      pinnedCols,
      colAutosize,
      aggFuncSvc,
      rowGroupColsSvc,
      colNames,
      colModel,
      clipboardSvc,
      expansionSvc,
      focusSvc,
      csvCreator,
      excelCreator,
      menuSvc,
      colChooserFactory,
      sortSvc,
      chartMenuItemMapper,
      valueColsSvc
    } = beans;
    const getStockMenuItem = (key, column2, sourceElement2, source2) => {
      validation?.validateMenuItem(key);
      switch (key) {
        case "pinSubMenu":
          return pinnedCols && column2 ? {
            name: localeTextFunc("pinColumn", "Pin Column"),
            icon: (0, import_ag_grid_community78._createIconNoSpan)("menuPin", beans, null),
            subMenu: ["clearPinned", "pinLeft", "pinRight"]
          } : null;
        case "pinLeft":
          return pinnedCols && column2 ? {
            name: localeTextFunc("pinLeft", "Pin Left"),
            action: () => pinnedCols.setColsPinned([column2], "left", source2),
            checked: !!column2 && column2.isPinnedLeft()
          } : null;
        case "pinRight":
          return pinnedCols && column2 ? {
            name: localeTextFunc("pinRight", "Pin Right"),
            action: () => pinnedCols.setColsPinned([column2], "right", source2),
            checked: !!column2 && column2.isPinnedRight()
          } : null;
        case "clearPinned":
          return pinnedCols && column2 ? {
            name: localeTextFunc("noPin", "No Pin"),
            action: () => pinnedCols.setColsPinned([column2], null, source2),
            checked: !!column2 && !column2.isPinned()
          } : null;
        case "valueAggSubMenu":
          if (aggFuncSvc && valueColsSvc && (column2?.isPrimary() || column2?.getColDef().pivotValueColumn)) {
            return {
              name: localeTextFunc("valueAggregation", "Value Aggregation"),
              icon: (0, import_ag_grid_community78._createIconNoSpan)("menuValue", beans, null),
              subMenu: createAggregationSubMenu(column2, aggFuncSvc, valueColsSvc, localeTextFunc),
              disabled: gos.get("functionsReadOnly")
            };
          } else {
            return null;
          }
        case "autoSizeThis":
          return colAutosize ? {
            name: localeTextFunc("autosizeThisColumn", "Autosize This Column"),
            action: () => colAutosize.autoSizeColumn(column2, source2, gos.get("skipHeaderOnAutoSize"))
          } : null;
        case "autoSizeAll":
          return colAutosize ? {
            name: localeTextFunc("autosizeAllColumns", "Autosize All Columns"),
            action: () => colAutosize.autoSizeAllColumns(source2, gos.get("skipHeaderOnAutoSize"))
          } : null;
        case "rowGroup":
          return rowGroupColsSvc ? {
            name: localeTextFunc("groupBy", "Group by") + " " + (0, import_ag_grid_community78._escapeString)(colNames.getDisplayNameForColumn(column2, "header")),
            disabled: gos.get("functionsReadOnly") || column2?.isRowGroupActive() || !column2?.getColDef().enableRowGroup,
            action: () => rowGroupColsSvc.addColumns([column2], source2),
            icon: (0, import_ag_grid_community78._createIconNoSpan)("menuAddRowGroup", beans, null)
          } : null;
        case "rowUnGroup": {
          if (rowGroupColsSvc && gos.isModuleRegistered("SharedRowGrouping")) {
            const showRowGroup = column2?.getColDef().showRowGroup;
            const lockedGroups = gos.get("groupLockGroupColumns");
            let name;
            let disabled;
            let action;
            if (showRowGroup === true) {
              name = localeTextFunc("ungroupAll", "Un-Group All");
              disabled = gos.get("functionsReadOnly") || lockedGroups === -1 || lockedGroups >= (rowGroupColsSvc.columns.length ?? 0);
              action = () => rowGroupColsSvc.setColumns(rowGroupColsSvc.columns.slice(0, lockedGroups), source2);
            } else if (typeof showRowGroup === "string") {
              const underlyingColumn = colModel.getColDefCol(showRowGroup);
              const ungroupByName = underlyingColumn != null ? (0, import_ag_grid_community78._escapeString)(colNames.getDisplayNameForColumn(underlyingColumn, "header")) : showRowGroup;
              name = localeTextFunc("ungroupBy", "Un-Group by") + " " + ungroupByName;
              disabled = gos.get("functionsReadOnly") || isRowGroupColLocked(underlyingColumn, beans);
              action = () => {
                rowGroupColsSvc.removeColumns([showRowGroup], source2);
              };
            } else {
              name = localeTextFunc("ungroupBy", "Un-Group by") + " " + (0, import_ag_grid_community78._escapeString)(colNames.getDisplayNameForColumn(column2, "header"));
              disabled = gos.get("functionsReadOnly") || !column2?.isRowGroupActive() || !column2?.getColDef().enableRowGroup || isRowGroupColLocked(column2, beans);
              action = () => rowGroupColsSvc.removeColumns([column2], source2);
            }
            return {
              name,
              disabled,
              action,
              icon: (0, import_ag_grid_community78._createIconNoSpan)("menuRemoveRowGroup", beans, null)
            };
          } else {
            return null;
          }
        }
        case "resetColumns":
          return {
            name: localeTextFunc("resetColumns", "Reset Columns"),
            action: () => (0, import_ag_grid_community78._resetColumnState)(beans, source2)
          };
        case "expandAll":
          return expansionSvc ? {
            name: localeTextFunc("expandAll", "Expand All Row Groups"),
            action: () => expansionSvc.expandAll(true)
          } : null;
        case "contractAll":
          return expansionSvc ? {
            name: localeTextFunc("collapseAll", "Collapse All Row Groups"),
            action: () => expansionSvc.expandAll(false)
          } : null;
        case "copy":
          return clipboardSvc ? {
            name: localeTextFunc("copy", "Copy"),
            shortcut: localeTextFunc("ctrlC", "Ctrl+C"),
            icon: (0, import_ag_grid_community78._createIconNoSpan)("clipboardCopy", beans, null),
            action: () => clipboardSvc.copyToClipboard()
          } : null;
        case "copyWithHeaders":
          return clipboardSvc ? {
            name: localeTextFunc("copyWithHeaders", "Copy with Headers"),
            // shortcut: localeTextFunc('ctrlC','Ctrl+C'),
            icon: (0, import_ag_grid_community78._createIconNoSpan)("clipboardCopy", beans, null),
            action: () => clipboardSvc.copyToClipboard({ includeHeaders: true })
          } : null;
        case "copyWithGroupHeaders":
          return clipboardSvc ? {
            name: localeTextFunc("copyWithGroupHeaders", "Copy with Group Headers"),
            // shortcut: localeTextFunc('ctrlC','Ctrl+C'),
            icon: (0, import_ag_grid_community78._createIconNoSpan)("clipboardCopy", beans, null),
            action: () => clipboardSvc.copyToClipboard({ includeHeaders: true, includeGroupHeaders: true })
          } : null;
        case "cut":
          if (clipboardSvc) {
            const focusedCell = focusSvc.getFocusedCell();
            const rowNode = focusedCell ? (0, import_ag_grid_community78._getRowNode)(beans, focusedCell) : null;
            const isEditable = rowNode ? focusedCell?.column.isCellEditable(rowNode) : false;
            return {
              name: localeTextFunc("cut", "Cut"),
              shortcut: localeTextFunc("ctrlX", "Ctrl+X"),
              icon: (0, import_ag_grid_community78._createIconNoSpan)("clipboardCut", beans, null),
              disabled: !isEditable || gos.get("suppressCutToClipboard"),
              action: () => clipboardSvc.cutToClipboard(void 0, "contextMenu")
            };
          } else {
            return null;
          }
        case "paste":
          return clipboardSvc ? {
            name: localeTextFunc("paste", "Paste"),
            shortcut: localeTextFunc("ctrlV", "Ctrl+V"),
            disabled: true,
            icon: (0, import_ag_grid_community78._createIconNoSpan)("clipboardPaste", beans, null),
            action: () => clipboardSvc.pasteFromClipboard()
          } : null;
        case "export": {
          const exportSubMenuItems = [];
          if (!gos.get("suppressCsvExport") && csvCreator) {
            exportSubMenuItems.push("csvExport");
          }
          if (!gos.get("suppressExcelExport") && excelCreator) {
            exportSubMenuItems.push("excelExport");
          }
          return exportSubMenuItems.length ? {
            name: localeTextFunc("export", "Export"),
            subMenu: exportSubMenuItems,
            icon: (0, import_ag_grid_community78._createIconNoSpan)("save", beans, null)
          } : null;
        }
        case "csvExport":
          return csvCreator ? {
            name: localeTextFunc("csvExport", "CSV Export"),
            icon: (0, import_ag_grid_community78._createIconNoSpan)("csvExport", beans, null),
            action: () => csvCreator.exportDataAsCsv()
          } : null;
        case "excelExport":
          return excelCreator ? {
            name: localeTextFunc("excelExport", "Excel Export"),
            icon: (0, import_ag_grid_community78._createIconNoSpan)("excelExport", beans, null),
            action: () => excelCreator.exportDataAsExcel()
          } : null;
        case "separator":
          return "separator";
        case "pivotChart":
        case "chartRange":
          return chartMenuItemMapper.getChartItems(key);
        case "columnFilter":
          return menuSvc && column2 ? {
            name: localeTextFunc("columnFilter", "Column Filter"),
            icon: (0, import_ag_grid_community78._createIconNoSpan)("filter", beans, null),
            action: () => menuSvc.showFilterMenu({
              column: column2,
              buttonElement: sourceElement2(),
              containerType: "columnFilter",
              positionBy: "button"
            })
          } : null;
        case "columnChooser": {
          const headerPosition = focusSvc.focusedHeader;
          return colChooserFactory ? {
            name: localeTextFunc("columnChooser", "Choose Columns"),
            icon: (0, import_ag_grid_community78._createIconNoSpan)("columns", beans, null),
            action: () => colChooserFactory.showColumnChooser({
              column: column2,
              eventSource: sourceElement2(),
              headerPosition
            })
          } : null;
        }
        case "sortAscending":
          return sortSvc ? {
            name: localeTextFunc("sortAscending", "Sort Ascending"),
            icon: (0, import_ag_grid_community78._createIconNoSpan)("sortAscending", beans, null),
            action: () => sortSvc.setSortForColumn(column2, "asc", false, source2)
          } : null;
        case "sortDescending":
          return sortSvc ? {
            name: localeTextFunc("sortDescending", "Sort Descending"),
            icon: (0, import_ag_grid_community78._createIconNoSpan)("sortDescending", beans, null),
            action: () => sortSvc.setSortForColumn(column2, "desc", false, source2)
          } : null;
        case "sortUnSort":
          return sortSvc ? {
            name: localeTextFunc("sortUnSort", "Clear Sort"),
            icon: (0, import_ag_grid_community78._createIconNoSpan)("sortUnSort", beans, null),
            action: () => sortSvc.setSortForColumn(column2, null, false, source2)
          } : null;
        default: {
          (0, import_ag_grid_community78._warn)(176, { key });
          return null;
        }
      }
    };
    originalList.forEach((menuItemOrString) => {
      let result;
      if (typeof menuItemOrString === "string") {
        result = getStockMenuItem(menuItemOrString, column, sourceElement, source);
      } else {
        result = { ...menuItemOrString };
      }
      if (!result) {
        return;
      }
      const resultDef = result;
      const { subMenu } = resultDef;
      if (subMenu && subMenu instanceof Array) {
        resultDef.subMenu = this.mapWithStockItems(
          subMenu,
          column,
          sourceElement,
          source
        );
      }
      if (result != null) {
        resultList.push(result);
      }
    });
    _removeRepeatsFromArray(resultList, MENU_ITEM_SEPARATOR);
    return resultList;
  }
};
function createAggregationSubMenu(column, aggFuncSvc, valueColsSvc, localeTextFunc) {
  let columnToUse;
  if (column.isPrimary()) {
    columnToUse = column;
  } else {
    const pivotValueColumn = column.getColDef().pivotValueColumn;
    columnToUse = (0, import_ag_grid_community78._exists)(pivotValueColumn) ? pivotValueColumn : void 0;
  }
  const result = [];
  if (columnToUse) {
    const columnIsAlreadyAggValue = columnToUse.isValueActive();
    const funcNames = aggFuncSvc.getFuncNames(columnToUse);
    result.push({
      name: localeTextFunc("noAggregation", "None"),
      action: () => {
        valueColsSvc.removeColumns([columnToUse], "contextMenu");
        valueColsSvc.setColumnAggFunc(columnToUse, void 0, "contextMenu");
      },
      checked: !columnIsAlreadyAggValue
    });
    funcNames.forEach((funcName) => {
      result.push({
        name: localeTextFunc(funcName, aggFuncSvc.getDefaultFuncLabel(funcName)),
        action: () => {
          valueColsSvc.setColumnAggFunc(columnToUse, funcName, "contextMenu");
          valueColsSvc.addColumns([columnToUse], "contextMenu");
        },
        checked: columnIsAlreadyAggValue && columnToUse.getAggFunc() === funcName
      });
    });
  }
  return result;
}

// packages/ag-grid-enterprise/src/menu/columnMenuFactory.ts
var ColumnMenuFactory = class extends import_ag_grid_community79.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "colMenuFactory";
  }
  createMenu(parent, menuItems, column, sourceElement) {
    const menuList = parent.createManagedBean(
      new AgMenuList(0, {
        column: column ?? null,
        node: null,
        value: null
      })
    );
    const menuItemsMapped = this.beans.menuItemMapper.mapWithStockItems(
      menuItems,
      column ?? null,
      sourceElement,
      "columnMenu"
    );
    menuList.addMenuItems(menuItemsMapped);
    return menuList;
  }
  getMenuItems(column = null, columnGroup = null) {
    const defaultItems = this.getDefaultMenuOptions(column);
    let result;
    const columnMainMenuItems = (column?.getColDef() ?? columnGroup?.getColGroupDef())?.mainMenuItems;
    if (Array.isArray(columnMainMenuItems)) {
      result = columnMainMenuItems;
    } else if (typeof columnMainMenuItems === "function") {
      result = columnMainMenuItems(
        (0, import_ag_grid_community79._addGridCommonParams)(this.gos, {
          column,
          columnGroup,
          defaultItems
        })
      );
    } else {
      const userFunc = this.gos.getCallback("getMainMenuItems");
      if (userFunc) {
        result = userFunc({
          column,
          columnGroup,
          defaultItems
        });
      } else {
        result = defaultItems;
      }
    }
    _removeRepeatsFromArray(result, MENU_ITEM_SEPARATOR);
    return result;
  }
  getDefaultMenuOptions(column) {
    const result = [];
    const { beans, gos } = this;
    const {
      colChooserFactory,
      rowGroupColsSvc,
      colModel,
      expansionSvc,
      sortSvc,
      menuSvc,
      pinnedCols,
      aggFuncSvc,
      colAutosize
    } = beans;
    const isLegacyMenuEnabled = (0, import_ag_grid_community79._isLegacyMenuEnabled)(gos);
    const addColumnItems = () => {
      if (!isLegacyMenuEnabled && colChooserFactory) {
        result.push("columnChooser");
      }
      result.push("resetColumns");
    };
    if (!column) {
      addColumnItems();
      return result;
    }
    const { colDef } = column;
    const allowPinning = pinnedCols && !colDef.lockPinned;
    const rowGroupCount = rowGroupColsSvc?.columns.length ?? 0;
    const doingGrouping = rowGroupCount > 0;
    const isPrimary = column.isPrimary();
    const allowValueAgg = aggFuncSvc && // if primary, then only allow aggValue if grouping and it's a value columns
    isPrimary && doingGrouping && column.isAllowValue() || // secondary columns can always have aggValue, as it means it's a pivot value column
    !isPrimary;
    if (sortSvc && !isLegacyMenuEnabled && column.isSortable()) {
      const sort = column.getSort();
      if (sort !== "asc") {
        result.push("sortAscending");
      }
      if (sort !== "desc") {
        result.push("sortDescending");
      }
      if (sort) {
        result.push("sortUnSort");
      }
      result.push(MENU_ITEM_SEPARATOR);
    }
    if (menuSvc?.isFilterMenuItemEnabled(column)) {
      result.push("columnFilter");
      result.push(MENU_ITEM_SEPARATOR);
    }
    if (allowPinning) {
      result.push("pinSubMenu");
    }
    if (allowValueAgg) {
      result.push("valueAggSubMenu");
    }
    if (allowPinning || allowValueAgg) {
      result.push(MENU_ITEM_SEPARATOR);
    }
    if (colAutosize) {
      result.push("autoSizeThis");
      result.push("autoSizeAll");
      result.push(MENU_ITEM_SEPARATOR);
    }
    if (rowGroupColsSvc && gos.isModuleRegistered("SharedRowGrouping")) {
      const numItems = result.length;
      const showRowGroup = colDef.showRowGroup;
      if (showRowGroup) {
        result.push("rowUnGroup");
      } else if (column.isAllowRowGroup() && isPrimary) {
        if (column.isRowGroupActive()) {
          const groupLocked = isRowGroupColLocked(column, beans);
          if (!groupLocked) {
            result.push("rowUnGroup");
          }
        } else {
          result.push("rowGroup");
        }
      }
      if (result.length > numItems) {
        result.push(MENU_ITEM_SEPARATOR);
      }
    }
    addColumnItems();
    if (expansionSvc && (0, import_ag_grid_community79._isClientSideRowModel)(gos) && (gos.get("treeData") || rowGroupCount > (colModel.isPivotMode() ? 1 : 0))) {
      result.push("expandAll");
      result.push("contractAll");
    }
    return result;
  }
};

// packages/ag-grid-enterprise/src/menu/contextMenu.ts
var import_ag_grid_community80 = require("ag-grid-community");
var CSS_MENU = "ag-menu";
var CSS_CONTEXT_MENU_OPEN = "ag-context-menu-open";
var CSS_CONTEXT_MENU_LOADING_ICON = "ag-context-menu-loading-icon";
var ContextMenuService = class extends import_ag_grid_community80.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "contextMenuSvc";
    this.destroyLoadingSpinner = null;
    this.lastPromise = 0;
  }
  hideActiveMenu() {
    this.destroyBean(this.activeMenu);
  }
  getMenuItems(node, column, value, mouseEvent) {
    const defaultMenuOptions = [];
    const { clipboardSvc, chartSvc, csvCreator, excelCreator, colModel, rangeSvc, gos } = this.beans;
    if ((0, import_ag_grid_community80._exists)(node) && clipboardSvc) {
      if (column) {
        if (!gos.get("suppressCutToClipboard")) {
          defaultMenuOptions.push("cut");
        }
        defaultMenuOptions.push("copy", "copyWithHeaders", "copyWithGroupHeaders", "paste", "separator");
      }
    }
    if (gos.get("enableCharts") && chartSvc) {
      if (colModel.isPivotMode()) {
        defaultMenuOptions.push("pivotChart");
      }
      if (rangeSvc && !rangeSvc.isEmpty()) {
        defaultMenuOptions.push("chartRange");
      }
    }
    if ((0, import_ag_grid_community80._exists)(node)) {
      const suppressExcel = gos.get("suppressExcelExport") || !excelCreator;
      const suppressCsv = gos.get("suppressCsvExport") || !csvCreator;
      const onIPad = (0, import_ag_grid_community80._isIOSUserAgent)();
      const anyExport = !onIPad && (!suppressExcel || !suppressCsv);
      if (anyExport) {
        defaultMenuOptions.push("export");
      }
    }
    const defaultItems = defaultMenuOptions.length ? defaultMenuOptions : void 0;
    const columnContextMenuItems = column?.getColDef().contextMenuItems;
    if (Array.isArray(columnContextMenuItems)) {
      return columnContextMenuItems;
    }
    if (typeof columnContextMenuItems === "function") {
      return columnContextMenuItems(
        (0, import_ag_grid_community80._addGridCommonParams)(gos, {
          column,
          node,
          value,
          defaultItems,
          event: mouseEvent
        })
      );
    }
    const userFunc = gos.getCallback("getContextMenuItems");
    return userFunc?.({ column, node, value, defaultItems, event: mouseEvent }) ?? defaultMenuOptions;
  }
  getContextMenuPosition(rowNode, column) {
    const rowCtrl = this.getRowCtrl(rowNode);
    const eGui = this.getCellGui(rowCtrl, column);
    if (!eGui) {
      return { x: 0, y: rowCtrl?.getRowYPosition() ?? 0 };
    }
    const rect = eGui.getBoundingClientRect();
    return {
      x: rect.x + rect.width / 2,
      y: rect.y + rect.height / 2
    };
  }
  showContextMenu(params) {
    const rowNode = params.rowNode ?? null;
    const column = params.column ?? null;
    let { anchorToElement, value, source } = params;
    if (rowNode && column && value == null) {
      value = this.beans.valueSvc.getValueForDisplay(column, rowNode);
    }
    if (anchorToElement == null) {
      anchorToElement = this.getContextMenuAnchorElement(rowNode, column);
    }
    this.beans.menuUtils.onContextMenu({
      mouseEvent: params.mouseEvent ?? null,
      touchEvent: params.touchEvent ?? null,
      showMenuCallback: (eventOrTouch) => this.showMenu(rowNode, column, value, eventOrTouch, anchorToElement),
      source
    });
  }
  handleContextMenuMouseEvent(mouseEvent, touchEvent, rowCtrl, cellCtrl) {
    const rowNode = cellCtrl?.rowNode ?? rowCtrl?.rowNode ?? null;
    const column = cellCtrl?.column ?? rowCtrl?.findFullWidthInfoForEvent(mouseEvent || touchEvent)?.column ?? null;
    const { valueSvc, ctrlsSvc } = this.beans;
    const value = column ? valueSvc.getValue(column, rowNode) : null;
    const gridBodyCon = ctrlsSvc.getGridBodyCtrl();
    const anchorToElement = cellCtrl ? cellCtrl.eGui : gridBodyCon.eGridBody;
    this.showContextMenu({
      mouseEvent,
      touchEvent,
      rowNode,
      column,
      value,
      anchorToElement,
      source: "ui"
    });
  }
  showMenu(node, column, value, mouseEvent, anchorToElement) {
    const menuItems = this.getMenuItems(node, column, value, mouseEvent);
    if ((0, import_ag_grid_community80._isPromise)(menuItems)) {
      const currentPromise = this.lastPromise + 1;
      this.lastPromise = currentPromise;
      if (!this.destroyLoadingSpinner) {
        this.createLoadingIcon(mouseEvent);
      }
      menuItems.then((menuItems2) => {
        if (this.lastPromise !== currentPromise) {
          return;
        }
        const shouldShowMenu = (
          // check if there are actual menu items to be displayed
          menuItems2 && menuItems2.length && // check if the element that triggered the context menu was removed from the DOM
          (0, import_ag_grid_community80._isVisible)(mouseEvent.target) && // overlay was displayed
          !this.beans.overlays?.isExclusive()
        );
        if (shouldShowMenu) {
          this.createContextMenu({ menuItems: menuItems2, node, column, value, mouseEvent, anchorToElement });
        }
        this.destroyLoadingSpinner?.();
      });
      return true;
    }
    if (menuItems === void 0 || !menuItems?.length) {
      return false;
    }
    this.createContextMenu({ menuItems, node, column, value, mouseEvent, anchorToElement });
    return true;
  }
  createLoadingIcon(mouseEvent) {
    const { beans } = this;
    const translate = this.getLocaleTextFunc();
    const loadingIcon = (0, import_ag_grid_community80._createIconNoSpan)("loadingMenuItems", beans);
    const wrapperEl = document.createElement("div");
    wrapperEl.classList.add(CSS_CONTEXT_MENU_LOADING_ICON);
    wrapperEl.appendChild(loadingIcon);
    const rootNode = (0, import_ag_grid_community80._getRootNode)(beans);
    const targetEl = (0, import_ag_grid_community80._getPageBody)(beans);
    if (!targetEl) {
      (0, import_ag_grid_community80._warn)(54);
      return;
    }
    targetEl.appendChild(wrapperEl);
    beans.ariaAnnounce?.announceValue(
      translate("ariaLabelLoadingContextMenu", "Loading Context Menu"),
      "contextmenu"
    );
    beans.environment.applyThemeClasses(wrapperEl);
    (0, import_ag_grid_community80._anchorElementToMouseMoveEvent)(wrapperEl, mouseEvent, beans);
    const mouseMoveCallback = (e) => {
      (0, import_ag_grid_community80._anchorElementToMouseMoveEvent)(wrapperEl, e, beans);
    };
    rootNode.addEventListener("mousemove", mouseMoveCallback);
    this.destroyLoadingSpinner = () => {
      rootNode.removeEventListener("mousemove", mouseMoveCallback);
      targetEl.removeChild(wrapperEl);
      this.destroyLoadingSpinner = null;
    };
  }
  createContextMenu(params) {
    const { menuItems, node, column, value, mouseEvent, anchorToElement } = params;
    const { ctrlsSvc, focusSvc, popupSvc } = this.beans;
    const eGridBodyGui = ctrlsSvc.getGridBodyCtrl().eGridBody;
    const menu = new ContextMenu(menuItems, column, node, value);
    this.createBean(menu);
    const eMenuGui = menu.getGui();
    if (!column) {
      focusSvc.clearFocusedCell();
    }
    const positionParams = {
      column,
      rowNode: node,
      type: "contextMenu",
      mouseEvent,
      ePopup: eMenuGui,
      // move one pixel away so that accidentally double clicking
      // won't show the browser's contextmenu
      nudgeY: 1
    };
    const translate = this.getLocaleTextFunc();
    const addPopupRes = popupSvc?.addPopup({
      modal: true,
      eChild: eMenuGui,
      closeOnEsc: true,
      closedCallback: (e) => {
        (0, import_ag_grid_community80._preserveRangesWhile)(this.beans, () => {
          eGridBodyGui.classList.remove(CSS_CONTEXT_MENU_OPEN);
          this.destroyBean(menu);
          this.dispatchVisibleChangedEvent(false, e === void 0 ? "api" : "ui");
        });
      },
      click: mouseEvent,
      positionCallback: () => {
        const isRtl = this.gos.get("enableRtl");
        popupSvc?.positionPopupUnderMouseEvent({
          ...positionParams,
          nudgeX: isRtl ? (eMenuGui.offsetWidth + 1) * -1 : 1
        });
      },
      // so when browser is scrolled down, or grid is scrolled, context menu stays with cell
      anchorToElement,
      ariaLabel: translate("ariaLabelContextMenu", "Context Menu")
    });
    if (addPopupRes) {
      eGridBodyGui.classList.add(CSS_CONTEXT_MENU_OPEN);
      menu.afterGuiAttached({ container: "contextMenu", hidePopup: addPopupRes.hideFunc });
    }
    if (this.activeMenu) {
      this.hideActiveMenu();
    }
    this.activeMenu = menu;
    menu.addEventListener("destroyed", () => {
      if (this.activeMenu === menu) {
        this.activeMenu = null;
      }
    });
    if (addPopupRes) {
      menu.addEventListener(
        "closeMenu",
        (e) => addPopupRes.hideFunc({
          mouseEvent: e.mouseEvent ?? void 0,
          keyboardEvent: e.keyboardEvent ?? void 0,
          forceHide: true
        })
      );
    }
    const isApi = mouseEvent && mouseEvent instanceof MouseEvent && mouseEvent.type === "mousedown";
    this.dispatchVisibleChangedEvent(true, isApi ? "api" : "ui");
  }
  dispatchVisibleChangedEvent(visible, source = "ui") {
    this.eventSvc.dispatchEvent({
      type: "contextMenuVisibleChanged",
      visible,
      source
    });
  }
  getRowCtrl(rowNode) {
    const { rowIndex, rowPinned } = rowNode || {};
    if (rowIndex == null) {
      return;
    }
    return this.beans.rowRenderer.getRowByPosition({ rowIndex, rowPinned }) || void 0;
  }
  getCellGui(rowCtrl, column) {
    if (!rowCtrl || !column) {
      return;
    }
    const cellCtrl = rowCtrl.getCellCtrl(column);
    return cellCtrl?.eGui || void 0;
  }
  getContextMenuAnchorElement(rowNode, column) {
    const gridBodyEl = this.beans.ctrlsSvc.getGridBodyCtrl().eGridBody;
    const rowCtrl = this.getRowCtrl(rowNode);
    if (!rowCtrl) {
      return gridBodyEl;
    }
    const cellGui = this.getCellGui(rowCtrl, column);
    if (cellGui) {
      return cellGui;
    }
    if (rowCtrl.isFullWidth()) {
      return rowCtrl.getFullWidthElement();
    }
    return gridBodyEl;
  }
  destroy() {
    this.destroyLoadingSpinner?.();
    super.destroy();
  }
};
var ContextMenu = class extends import_ag_grid_community80.Component {
  constructor(menuItems, column, node, value) {
    super(
      /* html */
      `<div class="${CSS_MENU}" role="presentation"></div>`
    );
    this.menuItems = menuItems;
    this.column = column;
    this.node = node;
    this.value = value;
    this.menuList = null;
    this.focusedCell = null;
  }
  postConstruct() {
    const menuList = this.createManagedBean(
      new AgMenuList(0, {
        column: this.column,
        node: this.node,
        value: this.value
      })
    );
    const menuItemsMapped = this.beans.menuItemMapper.mapWithStockItems(
      this.menuItems,
      null,
      () => this.getGui(),
      "contextMenu"
    );
    menuList.addMenuItems(menuItemsMapped);
    this.appendChild(menuList);
    this.menuList = menuList;
    menuList.addEventListener("closeMenu", (e) => this.dispatchLocalEvent(e));
  }
  afterGuiAttached({ hidePopup }) {
    if (hidePopup) {
      this.addDestroyFunc(hidePopup);
    }
    this.focusedCell = this.beans.focusSvc.getFocusedCell();
    const menuList = this.menuList;
    if (menuList) {
      (0, import_ag_grid_community80._preserveRangesWhile)(this.beans, () => (0, import_ag_grid_community80._focusInto)(menuList.getGui()));
    }
  }
  restoreFocusedCell() {
    const { beans, focusedCell } = this;
    const focusSvc = beans.focusSvc;
    const currentFocusedCell = focusSvc.getFocusedCell();
    if (currentFocusedCell && focusedCell && (0, import_ag_grid_community80._areCellsEqual)(currentFocusedCell, focusedCell)) {
      const { rowIndex, rowPinned, column } = focusedCell;
      if ((0, import_ag_grid_community80._isNothingFocused)(beans)) {
        focusSvc.setFocusedCell({
          rowIndex,
          column,
          rowPinned,
          forceBrowserFocus: true,
          preventScrollOnBrowserFocus: !(0, import_ag_grid_community80._isKeyboardMode)()
        });
      }
    }
  }
  destroy() {
    super.destroy();
    this.restoreFocusedCell();
  }
};

// packages/ag-grid-enterprise/src/menu/enterpriseMenu.ts
var import_ag_grid_community82 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/widgets/tabbedLayout.ts
var import_ag_grid_community81 = require("ag-grid-community");
function getTabbedLayoutTemplate(cssClass) {
  return (
    /* html */
    `<div class="ag-tabs ${cssClass}">
        <div data-ref="eHeader"></div>
        <div data-ref="eBody" role="presentation" class="ag-tabs-body ${cssClass ? `${cssClass}-body` : ""}"></div>
    </div>`
  );
}
var TabbedLayout = class extends import_ag_grid_community81.TabGuardComp {
  constructor(params) {
    super(getTabbedLayoutTemplate(params.cssClass));
    this.eHeader = import_ag_grid_community81.RefPlaceholder;
    this.eBody = import_ag_grid_community81.RefPlaceholder;
    this.items = [];
    this.tabbedItemScrollMap = /* @__PURE__ */ new Map();
    this.params = params;
  }
  postConstruct() {
    this.setupHeader();
    if (this.params.items) {
      this.params.items.forEach((item) => this.addItem(item));
    }
    this.initialiseTabGuard({
      onTabKeyDown: this.onTabKeyDown.bind(this),
      handleKeyDown: this.handleKeyDown.bind(this),
      focusInnerElement: this.focusInnerElement.bind(this),
      focusTrapActive: true
    });
    this.addDestroyFunc(() => this.activeItem?.tabbedItem?.afterDetachedCallback?.());
  }
  setupHeader() {
    const { enableCloseButton, cssClass } = this.params;
    const addCssClasses = (el, suffix) => {
      el.classList.add(`ag-tabs-${suffix}`);
      if (cssClass) {
        el.classList.add(`${cssClass}-${suffix}`);
      }
    };
    if (enableCloseButton) {
      this.setupCloseButton(addCssClasses);
      this.eTabHeader = (0, import_ag_grid_community81._getDocument)(this.beans).createElement("div");
      addCssClasses(this.eHeader, "header-wrapper");
      (0, import_ag_grid_community81._setAriaRole)(this.eHeader, "presentation");
      this.eHeader.appendChild(this.eTabHeader);
    } else {
      this.eTabHeader = this.eHeader;
    }
    (0, import_ag_grid_community81._setAriaRole)(this.eTabHeader, "tablist");
    addCssClasses(this.eTabHeader, "header");
  }
  setupCloseButton(addCssClasses) {
    const eDocument = (0, import_ag_grid_community81._getDocument)(this.beans);
    const eCloseButton = eDocument.createElement("button");
    addCssClasses(eCloseButton, "close-button");
    const eIcon = (0, import_ag_grid_community81._createIconNoSpan)("close", this.beans);
    (0, import_ag_grid_community81._setAriaLabel)(eCloseButton, this.params.closeButtonAriaLabel);
    eCloseButton.appendChild(eIcon);
    this.addManagedElementListeners(eCloseButton, { click: () => this.params.onCloseClicked?.() });
    const eCloseButtonWrapper = eDocument.createElement("div");
    addCssClasses(eCloseButtonWrapper, "close-button-wrapper");
    (0, import_ag_grid_community81._setAriaRole)(eCloseButtonWrapper, "presentation");
    eCloseButtonWrapper.appendChild(eCloseButton);
    this.eHeader.appendChild(eCloseButtonWrapper);
    this.eCloseButton = eCloseButton;
  }
  handleKeyDown(e) {
    switch (e.key) {
      case import_ag_grid_community81.KeyCode.RIGHT:
      case import_ag_grid_community81.KeyCode.LEFT: {
        if (!this.eTabHeader.contains((0, import_ag_grid_community81._getActiveDomElement)(this.beans))) {
          return;
        }
        const isRightKey = e.key === import_ag_grid_community81.KeyCode.RIGHT;
        const isRtl = this.gos.get("enableRtl");
        const currentPosition = this.items.indexOf(this.activeItem);
        const nextPosition = isRightKey !== isRtl ? Math.min(currentPosition + 1, this.items.length - 1) : Math.max(currentPosition - 1, 0);
        if (currentPosition === nextPosition) {
          return;
        }
        e.preventDefault();
        const nextItem = this.items[nextPosition];
        this.showItemWrapper(nextItem);
        nextItem.eHeaderButton.focus();
        break;
      }
      case import_ag_grid_community81.KeyCode.UP:
      case import_ag_grid_community81.KeyCode.DOWN:
        e.stopPropagation();
        break;
    }
  }
  onTabKeyDown(e) {
    if (e.defaultPrevented) {
      return;
    }
    const { beans, eHeader, eBody, activeItem, params } = this;
    const { suppressTrapFocus, enableCloseButton } = params;
    const activeElement = (0, import_ag_grid_community81._getActiveDomElement)(beans);
    const target = e.target;
    const backwards = e.shiftKey;
    if (eHeader.contains(activeElement)) {
      e.preventDefault();
      if (enableCloseButton && backwards && !this.eCloseButton?.contains(activeElement)) {
        this.eCloseButton?.focus();
      } else if (suppressTrapFocus && backwards) {
        findFocusableElementBeforeTabGuard((0, import_ag_grid_community81._getDocument)(beans).body, target)?.focus();
      } else {
        this.focusBody(e.shiftKey);
      }
      return;
    }
    let nextEl = null;
    if (isTargetUnderManagedComponent(eBody, target)) {
      if (backwards) {
        nextEl = findFocusableElementBeforeTabGuard(eBody, target);
      }
      if (!nextEl && !suppressTrapFocus) {
        nextEl = activeItem.eHeaderButton;
      }
    }
    if (!nextEl && eBody.contains(activeElement)) {
      nextEl = (0, import_ag_grid_community81._findNextFocusableElement)(beans, eBody, false, backwards);
      if (!nextEl) {
        if (suppressTrapFocus && !backwards) {
          this.forceFocusOutOfContainer(backwards);
        } else if (enableCloseButton && !backwards) {
          e.preventDefault();
          this.eCloseButton?.focus();
        } else {
          e.preventDefault();
          this.focusHeader();
        }
        return;
      }
    }
    if (nextEl) {
      e.preventDefault();
      nextEl.focus();
    }
  }
  focusInnerElement(fromBottom) {
    if (fromBottom) {
      return this.focusBody(true);
    } else {
      this.focusHeader();
      return true;
    }
  }
  focusHeader(preventScroll) {
    this.activeItem.eHeaderButton.focus({ preventScroll });
  }
  focusBody(fromBottom) {
    return (0, import_ag_grid_community81._focusInto)(this.eBody, fromBottom);
  }
  setAfterAttachedParams(params) {
    this.afterAttachedParams = params;
  }
  showFirstItem() {
    if (this.items.length > 0) {
      this.showItemWrapper(this.items[0]);
    }
  }
  addItem(item) {
    const eHeaderButton = document.createElement("span");
    (0, import_ag_grid_community81._setAriaRole)(eHeaderButton, "tab");
    eHeaderButton.setAttribute("tabindex", "-1");
    eHeaderButton.appendChild(item.title);
    eHeaderButton.classList.add("ag-tab");
    this.eTabHeader.appendChild(eHeaderButton);
    (0, import_ag_grid_community81._setAriaLabel)(eHeaderButton, item.titleLabel);
    const wrapper = {
      tabbedItem: item,
      eHeaderButton
    };
    this.items.push(wrapper);
    eHeaderButton.addEventListener("click", this.showItemWrapper.bind(this, wrapper));
  }
  showItem(tabbedItem) {
    const itemWrapper = this.items.find((wrapper) => wrapper.tabbedItem === tabbedItem);
    if (itemWrapper) {
      this.showItemWrapper(itemWrapper);
    }
  }
  showItemWrapper(wrapper) {
    const { tabbedItem, eHeaderButton } = wrapper;
    this.params.onItemClicked?.({ item: tabbedItem });
    if (this.activeItem === wrapper) {
      this.params.onActiveItemClicked?.();
      return;
    }
    if (this.lastScrollListener) {
      this.lastScrollListener = this.lastScrollListener();
    }
    (0, import_ag_grid_community81._clearElement)(this.eBody);
    tabbedItem.bodyPromise.then((body) => {
      this.eBody.appendChild(body);
      const onlyUnmanaged = !(0, import_ag_grid_community81._isKeyboardMode)();
      if (!this.params.suppressFocusBodyOnOpen) {
        (0, import_ag_grid_community81._focusInto)(this.eBody, false, onlyUnmanaged);
      }
      if (tabbedItem.afterAttachedCallback) {
        tabbedItem.afterAttachedCallback(this.afterAttachedParams);
      }
      if (this.params.keepScrollPosition) {
        const scrollableContainer = tabbedItem.getScrollableContainer && tabbedItem.getScrollableContainer() || body;
        [this.lastScrollListener] = this.addManagedElementListeners(scrollableContainer, {
          scroll: () => {
            this.tabbedItemScrollMap.set(tabbedItem.name, scrollableContainer.scrollTop);
          }
        });
        const scrollPosition = this.tabbedItemScrollMap.get(tabbedItem.name);
        if (scrollPosition !== void 0) {
          setTimeout(() => {
            scrollableContainer.scrollTop = scrollPosition;
          }, 0);
        }
      }
    });
    if (this.activeItem) {
      this.activeItem.eHeaderButton.classList.remove("ag-tab-selected");
      this.activeItem.tabbedItem.afterDetachedCallback?.();
    }
    eHeaderButton.classList.add("ag-tab-selected");
    this.activeItem = wrapper;
  }
};

// packages/ag-grid-enterprise/src/menu/enterpriseMenu.ts
var TAB_FILTER = "filterMenuTab";
var TAB_GENERAL = "generalMenuTab";
var TAB_COLUMNS = "columnsMenuTab";
var TABS_DEFAULT = [TAB_GENERAL, TAB_FILTER, TAB_COLUMNS];
var EnterpriseMenuFactory = class extends import_ag_grid_community82.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "enterpriseMenuFactory";
  }
  hideActiveMenu() {
    this.destroyBean(this.activeMenu);
  }
  showMenuAfterMouseEvent(columnOrGroup, mouseEvent, containerType, onClosedCallback, filtersOnly) {
    const { column, columnGroup } = this.splitColumnOrGroup(columnOrGroup);
    const defaultTab = filtersOnly ? "filterMenuTab" : void 0;
    this.showMenu(
      column,
      columnGroup,
      (menu) => {
        const ePopup = menu.getGui();
        this.beans.popupSvc.positionPopupUnderMouseEvent({
          type: containerType,
          column,
          mouseEvent,
          ePopup
        });
        if (defaultTab) {
          menu.showTab?.(defaultTab);
        }
        this.dispatchVisibleChangedEvent(true, false, column, columnGroup, defaultTab);
      },
      containerType,
      defaultTab,
      void 0,
      mouseEvent.target,
      onClosedCallback
    );
  }
  splitColumnOrGroup(columnOrGroup) {
    const colIsColumn = columnOrGroup && (0, import_ag_grid_community82.isColumn)(columnOrGroup);
    const column = colIsColumn ? columnOrGroup : void 0;
    const columnGroup = colIsColumn ? void 0 : columnOrGroup;
    return { column, columnGroup };
  }
  showMenuAfterButtonClick(columnOrGroup, eventSource, containerType, onClosedCallback, filtersOnly) {
    let multiplier = -1;
    let alignSide = "left";
    if (this.gos.get("enableRtl")) {
      multiplier = 1;
      alignSide = "right";
    }
    const defaultTab = filtersOnly ? "filterMenuTab" : void 0;
    const restrictToTabs = defaultTab ? [defaultTab] : void 0;
    const isLegacyMenuEnabled = (0, import_ag_grid_community82._isLegacyMenuEnabled)(this.gos);
    const nudgeX = (isLegacyMenuEnabled ? 9 : 4) * multiplier;
    const nudgeY = isLegacyMenuEnabled ? -23 : 4;
    const { column, columnGroup } = this.splitColumnOrGroup(columnOrGroup);
    this.showMenu(
      column,
      columnGroup,
      (menu) => {
        const ePopup = menu.getGui();
        this.beans.popupSvc.positionPopupByComponent({
          type: containerType,
          column,
          eventSource,
          ePopup,
          alignSide,
          nudgeX,
          nudgeY,
          position: "under",
          keepWithinBounds: true
        });
        if (defaultTab) {
          menu.showTab?.(defaultTab);
        }
        this.dispatchVisibleChangedEvent(true, false, column, columnGroup, defaultTab);
      },
      containerType,
      defaultTab,
      restrictToTabs,
      eventSource,
      onClosedCallback
    );
  }
  showMenu(column, columnGroup, positionCallback, containerType, defaultTab, restrictToTabs, eventSource, onClosedCallback) {
    const menuParams = this.getMenuParams(column, columnGroup, restrictToTabs, eventSource);
    if (!menuParams) {
      return;
    }
    const { menu, eMenuGui, anchorToElement, restoreFocusParams } = menuParams;
    const closedFuncs = [];
    const { menuUtils, popupSvc } = this.beans;
    closedFuncs.push((e) => {
      const eComp = menu.getGui();
      this.destroyBean(menu);
      if (column) {
        (0, import_ag_grid_community82._setColMenuVisible)(column, false, "contextMenu");
        menuUtils.restoreFocusOnClose(restoreFocusParams, eComp, e);
      }
      onClosedCallback?.();
    });
    const translate = this.getLocaleTextFunc();
    popupSvc.addPopup({
      modal: true,
      eChild: eMenuGui,
      closeOnEsc: true,
      closedCallback: (e) => {
        closedFuncs.forEach((f) => f(e));
        this.dispatchVisibleChangedEvent(false, false, column, columnGroup, defaultTab);
      },
      afterGuiAttached: (params) => menu.afterGuiAttached(Object.assign({}, { container: containerType }, params)),
      // if defaultTab is not present, positionCallback will be called
      // after `showTabBasedOnPreviousSelection` is called.
      positionCallback: defaultTab ? () => positionCallback(menu) : void 0,
      ariaLabel: translate("ariaLabelColumnMenu", "Column Menu")
    });
    if (!defaultTab) {
      menu.showTabBasedOnPreviousSelection?.();
      positionCallback(menu);
    }
    if ((0, import_ag_grid_community82._isColumnMenuAnchoringEnabled)(this.gos)) {
      const stopAnchoringPromise = popupSvc.setPopupPositionRelatedToElement(eMenuGui, anchorToElement);
      if (stopAnchoringPromise && column) {
        this.addStopAnchoring(stopAnchoringPromise, column, closedFuncs);
      }
    }
    menu.addEventListener("tabSelected", (event) => {
      this.dispatchVisibleChangedEvent(false, true, column);
      this.lastSelectedTab = event.key;
      this.dispatchVisibleChangedEvent(true, true, column);
    });
    if (column) {
      (0, import_ag_grid_community82._setColMenuVisible)(column, true, "contextMenu");
    }
    this.activeMenu = menu;
    menu.addEventListener("destroyed", () => {
      if (this.activeMenu === menu) {
        this.activeMenu = null;
      }
    });
  }
  addStopAnchoring(stopAnchoringPromise, column, closedFuncsArr) {
    stopAnchoringPromise.then((stopAnchoringFunc) => {
      column.__addEventListener("leftChanged", stopAnchoringFunc);
      column.__addEventListener("visibleChanged", stopAnchoringFunc);
      closedFuncsArr.push(() => {
        column.__removeEventListener("leftChanged", stopAnchoringFunc);
        column.__removeEventListener("visibleChanged", stopAnchoringFunc);
      });
    });
  }
  getMenuParams(column, columnGroup, restrictToTabs, eventSource) {
    const { focusSvc, visibleCols, ctrlsSvc } = this.beans;
    const restoreFocusParams = {
      column,
      headerPosition: focusSvc.focusedHeader,
      columnIndex: visibleCols.allCols.indexOf(column),
      eventSource
    };
    const menu = this.createMenu(column, columnGroup, restoreFocusParams, restrictToTabs, eventSource);
    return menu ? {
      menu,
      eMenuGui: menu.getGui(),
      anchorToElement: eventSource || ctrlsSvc.getGridBodyCtrl().eGridBody,
      restoreFocusParams
    } : void 0;
  }
  createMenu(column, columnGroup, restoreFocusParams, restrictToTabs, eventSource) {
    if ((0, import_ag_grid_community82._isLegacyMenuEnabled)(this.gos)) {
      return this.createBean(
        new TabbedColumnMenu(column, restoreFocusParams, this.lastSelectedTab, restrictToTabs, eventSource)
      );
    } else {
      const menuItems = this.beans.colMenuFactory.getMenuItems(column, columnGroup);
      return menuItems.length ? this.createBean(new ColumnContextMenu(menuItems, column, restoreFocusParams, eventSource)) : void 0;
    }
  }
  dispatchVisibleChangedEvent(visible, switchingTab, column, columnGroup, defaultTab) {
    this.eventSvc.dispatchEvent({
      type: "columnMenuVisibleChanged",
      visible,
      switchingTab,
      key: this.lastSelectedTab ?? defaultTab ?? ((0, import_ag_grid_community82._isLegacyMenuEnabled)(this.gos) ? TAB_GENERAL : "columnMenu"),
      column: column ?? null,
      columnGroup: columnGroup ?? null
    });
  }
  isMenuEnabled(column) {
    if (!(0, import_ag_grid_community82._isLegacyMenuEnabled)(this.gos)) {
      return true;
    }
    const isFilterDisabled = !this.beans.filterManager?.isFilterAllowed(column);
    const tabs = column.getColDef().menuTabs ?? TABS_DEFAULT;
    const numActiveTabs = isFilterDisabled && tabs.includes(TAB_FILTER) ? tabs.length - 1 : tabs.length;
    return numActiveTabs > 0;
  }
  showMenuAfterContextMenuEvent(column, mouseEvent, touchEvent) {
    this.beans.menuUtils.onContextMenu({
      mouseEvent,
      touchEvent,
      source: "ui",
      showMenuCallback: (eventOrTouch) => {
        this.showMenuAfterMouseEvent(column, eventOrTouch, "columnMenu");
        return true;
      }
    });
  }
};
var TabbedColumnMenu = class extends import_ag_grid_community82.BeanStub {
  constructor(column, restoreFocusParams, initialSelection, restrictTo, sourceElement) {
    super();
    this.column = column;
    this.restoreFocusParams = restoreFocusParams;
    this.initialSelection = initialSelection;
    this.restrictTo = restrictTo;
    this.sourceElement = sourceElement;
    this.tabFactories = {};
    this.includeChecks = {};
    const { tabFactories, includeChecks } = this;
    tabFactories[TAB_GENERAL] = this.createMainPanel.bind(this);
    tabFactories[TAB_FILTER] = this.createFilterPanel.bind(this);
    tabFactories[TAB_COLUMNS] = this.createColumnsPanel.bind(this);
    includeChecks[TAB_GENERAL] = () => true;
    includeChecks[TAB_FILTER] = () => column ? !!this.beans.filterManager?.isFilterAllowed(column) : false;
    includeChecks[TAB_COLUMNS] = () => true;
  }
  postConstruct() {
    const tabs = this.getTabsToCreate().map((name) => this.createTab(name));
    const tabbedLayout = new TabbedLayout({
      items: tabs,
      cssClass: "ag-menu",
      onActiveItemClicked: this.onHidePopup.bind(this),
      onItemClicked: this.onTabItemClicked.bind(this)
    });
    this.tabbedLayout = this.createBean(tabbedLayout);
    this.mainMenuList?.setParentComponent(tabbedLayout);
    this.addDestroyFunc(() => this.destroyBean(tabbedLayout));
  }
  getTabsToCreate() {
    if (this.restrictTo) {
      return this.restrictTo;
    }
    return (this.column?.getColDef().menuTabs ?? TABS_DEFAULT).filter(
      (tabName) => this.isValidMenuTabItem(tabName) && this.isNotSuppressed(tabName)
    );
  }
  isValidMenuTabItem(menuTabName) {
    let isValid = true;
    let itemsToConsider = TABS_DEFAULT;
    if (this.restrictTo != null) {
      isValid = this.restrictTo.indexOf(menuTabName) > -1;
      itemsToConsider = this.restrictTo;
    }
    isValid = isValid && TABS_DEFAULT.indexOf(menuTabName) > -1;
    if (!isValid) {
      (0, import_ag_grid_community82._warn)(175, { menuTabName, itemsToConsider });
    }
    return isValid;
  }
  isNotSuppressed(menuTabName) {
    return this.includeChecks[menuTabName]();
  }
  createTab(name) {
    return this.tabFactories[name]();
  }
  showTabBasedOnPreviousSelection() {
    this.showTab(this.initialSelection);
  }
  showTab(toShow) {
    const { tabItemColumns, tabbedLayout, tabItemFilter, tabItemGeneral } = this;
    if (tabItemColumns && toShow === TAB_COLUMNS) {
      tabbedLayout.showItem(tabItemColumns);
    } else if (tabItemFilter && toShow === TAB_FILTER) {
      tabbedLayout.showItem(tabItemFilter);
    } else if (tabItemGeneral && toShow === TAB_GENERAL) {
      tabbedLayout.showItem(tabItemGeneral);
    } else {
      tabbedLayout.showFirstItem();
    }
  }
  onTabItemClicked(event) {
    let key = null;
    switch (event.item) {
      case this.tabItemColumns:
        key = TAB_COLUMNS;
        break;
      case this.tabItemFilter:
        key = TAB_FILTER;
        break;
      case this.tabItemGeneral:
        key = TAB_GENERAL;
        break;
    }
    if (key) {
      this.activateTab(key);
    }
  }
  activateTab(tab) {
    const ev = {
      type: "tabSelected",
      key: tab
    };
    this.dispatchLocalEvent(ev);
  }
  createMainPanel() {
    const { beans, column } = this;
    const colMenuFactory = beans.colMenuFactory;
    const mainMenuList = colMenuFactory.createMenu(
      this,
      colMenuFactory.getMenuItems(column),
      this.column,
      () => this.sourceElement ?? this.getGui()
    );
    this.mainMenuList = mainMenuList;
    mainMenuList.addEventListener("closeMenu", this.onHidePopup.bind(this));
    const tabItemGeneral = {
      title: (0, import_ag_grid_community82._createIconNoSpan)("legacyMenu", beans, column),
      titleLabel: TAB_GENERAL.replace("MenuTab", ""),
      bodyPromise: import_ag_grid_community82.AgPromise.resolve(mainMenuList.getGui()),
      name: TAB_GENERAL
    };
    this.tabItemGeneral = tabItemGeneral;
    return tabItemGeneral;
  }
  onHidePopup(event) {
    this.beans.menuUtils.closePopupAndRestoreFocusOnSelect(
      this.hidePopupFunc,
      this.restoreFocusParams,
      event
    );
  }
  createFilterPanel() {
    const comp = this.column ? this.createBean(new import_ag_grid_community82.FilterWrapperComp(this.column, "COLUMN_MENU")) : null;
    this.filterComp = comp;
    if (!comp?.hasFilter()) {
      (0, import_ag_grid_community82._error)(119);
    }
    const afterAttachedCallback = (params) => comp?.afterGuiAttached(params);
    const afterDetachedCallback = () => comp?.afterGuiDetached();
    this.tabItemFilter = {
      title: (0, import_ag_grid_community82._createIconNoSpan)("filterTab", this.beans, this.column),
      titleLabel: TAB_FILTER.replace("MenuTab", ""),
      bodyPromise: import_ag_grid_community82.AgPromise.resolve(comp?.getGui()),
      afterAttachedCallback,
      afterDetachedCallback,
      name: TAB_FILTER
    };
    return this.tabItemFilter;
  }
  createColumnsPanel() {
    const eWrapperDiv = document.createElement("div");
    eWrapperDiv.classList.add("ag-menu-column-select-wrapper");
    const { beans, column } = this;
    const columnSelectPanel = beans.colChooserFactory.createColumnSelectPanel(
      this,
      column
    );
    const columnSelectPanelGui = columnSelectPanel.getGui();
    columnSelectPanelGui.classList.add("ag-menu-column-select");
    eWrapperDiv.appendChild(columnSelectPanelGui);
    const tabItemColumns = {
      title: (0, import_ag_grid_community82._createIconNoSpan)("columns", beans, column),
      //createColumnsIcon(),
      titleLabel: TAB_COLUMNS.replace("MenuTab", ""),
      bodyPromise: import_ag_grid_community82.AgPromise.resolve(eWrapperDiv),
      name: TAB_COLUMNS
    };
    this.tabItemColumns = tabItemColumns;
    return tabItemColumns;
  }
  afterGuiAttached(params) {
    const { container, hidePopup } = params;
    this.tabbedLayout.setAfterAttachedParams({ container, hidePopup });
    if (hidePopup) {
      this.hidePopupFunc = hidePopup;
      this.addDestroyFunc(hidePopup);
    }
  }
  getGui() {
    return this.tabbedLayout.getGui();
  }
  destroy() {
    super.destroy();
    this.destroyBean(this.filterComp);
  }
};
var ColumnContextMenu = class extends import_ag_grid_community82.Component {
  constructor(menuItems, column, restoreFocusParams, sourceElement) {
    super(
      /* html */
      `
            <div data-ref="eColumnMenu" role="presentation" class="ag-menu ag-column-menu"></div>
        `
    );
    this.menuItems = menuItems;
    this.column = column;
    this.restoreFocusParams = restoreFocusParams;
    this.sourceElement = sourceElement;
    this.eColumnMenu = import_ag_grid_community82.RefPlaceholder;
  }
  postConstruct() {
    const mainMenuList = this.beans.colMenuFactory.createMenu(
      this,
      this.menuItems,
      this.column,
      () => this.sourceElement ?? this.getGui()
    );
    this.mainMenuList = mainMenuList;
    mainMenuList.addEventListener("closeMenu", this.onHidePopup.bind(this));
    this.eColumnMenu.appendChild(mainMenuList.getGui());
  }
  onHidePopup(event) {
    this.beans.menuUtils.closePopupAndRestoreFocusOnSelect(
      this.hidePopupFunc,
      this.restoreFocusParams,
      event
    );
  }
  afterGuiAttached({ hidePopup }) {
    if (hidePopup) {
      this.hidePopupFunc = hidePopup;
      this.addDestroyFunc(hidePopup);
    }
    (0, import_ag_grid_community82._focusInto)(this.mainMenuList.getGui());
  }
};

// packages/ag-grid-enterprise/src/menu/menuApi.ts
function showContextMenu(beans, params) {
  const { contextMenuSvc } = beans;
  if (!contextMenuSvc) {
    return;
  }
  const { rowNode, column, value, x, y } = params || {};
  let { x: clientX, y: clientY } = contextMenuSvc.getContextMenuPosition(rowNode, column);
  if (x != null) {
    clientX = x;
  }
  if (y != null) {
    clientY = y;
  }
  contextMenuSvc.showContextMenu({
    mouseEvent: new MouseEvent("mousedown", { clientX, clientY }),
    rowNode,
    column,
    value,
    source: "api"
  });
}
function showColumnChooser(beans, params) {
  beans.colChooserFactory?.showColumnChooser({ chooserParams: params });
}
function hideColumnChooser(beans) {
  beans.colChooserFactory?.hideActiveColumnChooser();
}

// packages/ag-grid-enterprise/src/menu/menuUtils.ts
var import_ag_grid_community83 = require("ag-grid-community");
var MenuUtils = class extends import_ag_grid_community83.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "menuUtils";
  }
  restoreFocusOnClose(restoreFocusParams, eComp, e, restoreIfMouseEvent) {
    const { eventSource } = restoreFocusParams;
    const isKeyboardEvent = e instanceof KeyboardEvent;
    if (!restoreIfMouseEvent && !isKeyboardEvent || !eventSource) {
      return;
    }
    const activeEl = (0, import_ag_grid_community83._getActiveDomElement)(this.beans);
    if (
      // focus is outside of comp
      !eComp.contains(activeEl) && // something else has focus
      !(0, import_ag_grid_community83._isNothingFocused)(this.beans)
    ) {
      return;
    }
    this.focusHeaderCell(restoreFocusParams);
  }
  closePopupAndRestoreFocusOnSelect(hidePopupFunc, restoreFocusParams, event) {
    let keyboardEvent;
    if (event && event.keyboardEvent) {
      keyboardEvent = event.keyboardEvent;
    }
    hidePopupFunc(keyboardEvent && { keyboardEvent });
    const beans = this.beans;
    const focusSvc = beans.focusSvc;
    const focusedCell = focusSvc.getFocusedCell();
    if ((0, import_ag_grid_community83._isNothingFocused)(beans)) {
      if (focusedCell) {
        const { rowIndex, rowPinned, column } = focusedCell;
        focusSvc.setFocusedCell({
          rowIndex,
          column,
          rowPinned,
          forceBrowserFocus: true,
          preventScrollOnBrowserFocus: true
        });
      } else {
        this.focusHeaderCell(restoreFocusParams);
      }
    }
  }
  onContextMenu(params) {
    const { mouseEvent, touchEvent, showMenuCallback, source } = params;
    if (!this.gos.get("allowContextMenuWithControlKey")) {
      if (mouseEvent && (mouseEvent.ctrlKey || mouseEvent.metaKey)) {
        return;
      }
    }
    if (mouseEvent) {
      this.blockMiddleClickScrollsIfNeeded(mouseEvent);
    }
    if (source === "ui" && this.gos.get("suppressContextMenu")) {
      return;
    }
    const eventOrTouch = mouseEvent ?? touchEvent.touches[0];
    if (showMenuCallback(eventOrTouch)) {
      const event = mouseEvent ?? touchEvent;
      if (event && event.cancelable) {
        event.preventDefault();
      }
    }
  }
  // make this async for react
  async focusHeaderCell(restoreFocusParams) {
    const { column, columnIndex, headerPosition, eventSource } = restoreFocusParams;
    const { visibleCols, headerNavigation, focusSvc } = this.beans;
    const isColumnStillVisible = await visibleCols.allCols.some((col) => col === column);
    if (!this.isAlive()) {
      return;
    }
    if (column?.isAlive() && isColumnStillVisible && eventSource && (0, import_ag_grid_community83._isVisible)(eventSource)) {
      const focusableEl = (0, import_ag_grid_community83._findTabbableParent)(eventSource);
      if (focusableEl) {
        headerNavigation?.scrollToColumn(column);
        focusableEl.focus();
      }
    } else if (headerPosition && columnIndex !== -1) {
      const allColumns = visibleCols.allCols;
      const columnToFocus = allColumns[columnIndex] || (0, import_ag_grid_community83._last)(allColumns);
      if (columnToFocus) {
        focusSvc.focusHeaderPosition({
          headerPosition: {
            headerRowIndex: headerPosition.headerRowIndex,
            column: columnToFocus
          }
        });
      }
    }
  }
  blockMiddleClickScrollsIfNeeded(mouseEvent) {
    if (this.gos.get("suppressMiddleClickScrolls") && mouseEvent.which === 2) {
      mouseEvent.preventDefault();
    }
  }
};

// packages/ag-grid-enterprise/src/menu/menuModule.ts
var MenuCoreModule = {
  moduleName: "MenuCore",
  version: VERSION,
  beans: [MenuItemMapper, ChartMenuItemMapper, MenuUtils],
  icons: {
    // context menu chart item
    chart: "chart",
    // columns in menu (column chooser / columns tab)
    columns: "columns",
    // loading async menu items
    loadingMenuItems: "loading",
    // "Pin column" item in column header menu
    menuPin: "pin",
    // "Value aggregation" column menu item (shown on numeric columns when grouping is active)"
    menuValue: "aggregation",
    // "Group by {column-name}" item in column header menu
    menuAddRowGroup: "group",
    // "Un-Group by {column-name}" item in column header menu
    menuRemoveRowGroup: "group",
    // context menu copy item
    clipboardCopy: "copy",
    // context menu cut item
    clipboardCut: "cut",
    // context menu paste item
    clipboardPaste: "paste",
    // context menu export item
    save: "save",
    // csv export
    csvExport: "csv",
    // excel export,
    excelExport: "excel",
    // show on column header when column is sorted ascending
    sortAscending: "asc",
    // show on column header when column is sorted descending
    sortDescending: "desc",
    // show on column header when column has no sort, only when enabled with colDef.unSortIcon=true
    sortUnSort: "none"
  },
  dependsOn: [EnterpriseCoreModule, import_ag_grid_community84._PopupModule, import_ag_grid_community84._SharedMenuModule, MenuItemModule]
};
var ColumnMenuModule = {
  moduleName: "ColumnMenu",
  version: VERSION,
  beans: [EnterpriseMenuFactory, ColumnMenuFactory, ColumnChooserFactory],
  icons: {
    // menu tab icon in legacy tabbed enterprise column menu
    legacyMenu: "menu",
    // filter tab icon in legacy tabbed enterprise column menu
    filterTab: "filter",
    // column tool panel column group contracted (click to expand)
    columnSelectClosed: "tree-closed",
    // column tool panel column group expanded (click to contract)
    columnSelectOpen: "tree-open",
    // column tool panel header expand/collapse all button, shown when some children are expanded and
    //     others are collapsed
    columnSelectIndeterminate: "tree-indeterminate"
  },
  apiFunctions: {
    showColumnChooser,
    hideColumnChooser
  },
  dependsOn: [MenuCoreModule, import_ag_grid_community84._SharedDragAndDropModule, import_ag_grid_community84._ColumnMoveModule]
};
var ContextMenuModule = {
  moduleName: "ContextMenu",
  version: VERSION,
  beans: [ContextMenuService],
  apiFunctions: {
    showContextMenu
  },
  dependsOn: [MenuCoreModule]
};
var MenuModule = {
  moduleName: "Menu",
  version: VERSION,
  dependsOn: [ColumnMenuModule, ContextMenuModule]
};

// packages/ag-grid-enterprise/src/richSelect/richSelectModule.ts
var import_ag_grid_community86 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/richSelect/richSelectCellEditor.ts
var import_ag_grid_community85 = require("ag-grid-community");
var RichSelectCellEditor = class extends import_ag_grid_community85.PopupComponent {
  constructor() {
    super(
      /* html */
      `<div class="ag-cell-edit-wrapper"></div>`
    );
    this.isAsync = false;
  }
  init(params) {
    this.params = params;
    const { cellStartedEdit, values, eventKey } = params;
    if ((0, import_ag_grid_community85._missing)(values)) {
      (0, import_ag_grid_community85._warn)(180);
    }
    const { params: richSelectParams, valuesPromise } = this.buildRichSelectParams();
    const richSelect = this.createManagedBean(new AgRichSelect(richSelectParams));
    this.richSelect = richSelect;
    richSelect.addCssClass("ag-cell-editor");
    this.appendChild(richSelect);
    if (valuesPromise) {
      this.isAsync = true;
      valuesPromise.then((values2) => {
        richSelect.setValueList({ valueList: values2, refresh: true });
        const searchStringCallback = this.getSearchStringCallback(values2);
        if (searchStringCallback) {
          richSelect.setSearchStringCreator(searchStringCallback);
        }
        this.processEventKey(eventKey);
      });
    }
    this.addManagedListeners(richSelect, {
      fieldPickerValueSelected: this.onEditorPickerValueSelected.bind(this)
    });
    this.focusAfterAttached = cellStartedEdit;
  }
  onEditorPickerValueSelected(e) {
    setTimeout(() => this.params.stopEditing(!e.fromEnterKey));
  }
  buildRichSelectParams() {
    const params = this.params;
    const {
      cellRenderer,
      cellHeight,
      value,
      values,
      formatValue,
      searchDebounceDelay,
      valueListGap,
      valueListMaxHeight,
      valueListMaxWidth,
      allowTyping,
      filterList,
      searchType,
      highlightMatch,
      valuePlaceholder,
      eventKey,
      multiSelect,
      suppressDeselectAll,
      suppressMultiSelectPillRenderer
    } = params;
    const ret = {
      value,
      cellRenderer,
      cellRowHeight: cellHeight,
      searchDebounceDelay,
      valueFormatter: formatValue,
      pickerAriaLabelKey: "ariaLabelRichSelectField",
      pickerAriaLabelValue: "Rich Select Field",
      pickerType: "virtual-list",
      pickerGap: valueListGap,
      allowTyping,
      filterList,
      searchType,
      highlightMatch,
      maxPickerHeight: valueListMaxHeight,
      maxPickerWidth: valueListMaxWidth,
      placeholder: valuePlaceholder,
      initialInputValue: eventKey?.length === 1 ? eventKey : void 0,
      multiSelect,
      suppressDeselectAll,
      suppressMultiSelectPillRenderer
    };
    let valuesResult;
    let valuesPromise;
    if (typeof values === "function") {
      valuesResult = values(params);
    } else {
      valuesResult = values ?? [];
    }
    if (Array.isArray(valuesResult)) {
      ret.valueList = valuesResult;
      ret.searchStringCreator = this.getSearchStringCallback(valuesResult);
    } else {
      valuesPromise = valuesResult;
    }
    if (multiSelect && allowTyping) {
      params.allowTyping = ret.allowTyping = false;
      (0, import_ag_grid_community85._warn)(181);
    }
    return { params: ret, valuesPromise };
  }
  getSearchStringCallback(values) {
    if (typeof values[0] !== "object") {
      return;
    }
    const params = this.params;
    const { colDef, formatValue } = params;
    if (colDef.cellEditorParams?.formatValue) {
      return (values2) => values2.map(formatValue);
    }
    const { keyCreator } = colDef;
    if (keyCreator) {
      (0, import_ag_grid_community85._warn)(266);
      const { column, node, data } = params;
      return (values2) => values2.map((value) => {
        const keyParams = (0, import_ag_grid_community85._addGridCommonParams)(this.gos, {
          value,
          colDef,
          column,
          node,
          data
        });
        return keyCreator(keyParams);
      });
    }
    return (values2) => values2.map(formatValue);
  }
  // we need to have the gui attached before we can draw the virtual rows, as the
  // virtual row logic needs info about the gui state
  afterGuiAttached() {
    const { focusAfterAttached, params } = this;
    setTimeout(() => {
      if (!this.isAlive()) {
        return;
      }
      const richSelect = this.richSelect;
      const { allowTyping, eventKey } = params;
      if (focusAfterAttached) {
        const focusableEl = richSelect.getFocusableElement();
        focusableEl.focus();
        if (allowTyping && (!eventKey || eventKey.length !== 1)) {
          focusableEl.select();
        }
      }
      richSelect.showPicker();
      if (!this.isAsync) {
        this.processEventKey(eventKey);
      }
    });
  }
  processEventKey(eventKey) {
    if (!eventKey) {
      return;
    }
    if (eventKey?.length === 1) {
      this.richSelect.searchTextFromString(eventKey);
    }
  }
  focusIn() {
    this.richSelect.getFocusableElement().focus();
  }
  getValue() {
    const { params } = this;
    const value = this.richSelect.getValue();
    return params.parseValue?.(value) ?? value;
  }
  isPopup() {
    return false;
  }
};

// packages/ag-grid-enterprise/src/richSelect/richSelectModule.ts
var RichSelectModule = {
  moduleName: "RichSelect",
  version: VERSION,
  beans: [],
  userComponents: { agRichSelect: RichSelectCellEditor, agRichSelectCellEditor: RichSelectCellEditor },
  icons: {
    // open icon for rich select editor
    richSelectOpen: "small-down",
    // remove for rich select editor pills
    richSelectRemove: "cancel"
  },
  dependsOn: [EnterpriseCoreModule, import_ag_grid_community86._EditCoreModule]
};

// packages/ag-grid-enterprise/src/setFilter/setFilterModule.ts
var import_ag_grid_community94 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/setFilter/setFilter.ts
var import_ag_grid_community92 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/setFilter/iSetDisplayValueModel.ts
var SET_FILTER_SELECT_ALL = "__AG_SELECT_ALL__";
var SET_FILTER_ADD_SELECTION_TO_FILTER = "__AG_ADD_SELECTION_TO_FILTER__";

// packages/ag-grid-enterprise/src/setFilter/localeText.ts
var DEFAULT_LOCALE_TEXT = {
  loadingOoo: "Loading...",
  blanks: "(Blanks)",
  searchOoo: "Search...",
  selectAll: "(Select All)",
  selectAllSearchResults: "(Select All Search Results)",
  addCurrentSelectionToFilter: "Add current selection to filter",
  noMatches: "No matches."
};

// packages/ag-grid-enterprise/src/setFilter/setFilterListItem.ts
var import_ag_grid_community87 = require("ag-grid-community");
var SetFilterListItem = class extends import_ag_grid_community87.Component {
  constructor(params) {
    super(
      params.isGroup ? (
        /* html */
        `
            <div class="ag-set-filter-item" aria-hidden="true">
                <span class="ag-set-filter-group-icons">
                    <span class="ag-set-filter-group-closed-icon" data-ref="eGroupClosedIcon"></span>
                    <span class="ag-set-filter-group-opened-icon" data-ref="eGroupOpenedIcon"></span>
                    <span class="ag-set-filter-group-indeterminate-icon" data-ref="eGroupIndeterminateIcon"></span>
                </span>
                <ag-checkbox data-ref="eCheckbox" class="ag-set-filter-item-checkbox"></ag-checkbox>
            </div>`
      ) : (
        /* html */
        `
            <div class="ag-set-filter-item">
                <ag-checkbox data-ref="eCheckbox" class="ag-set-filter-item-checkbox"></ag-checkbox>
            </div>`
      ),
      [import_ag_grid_community87.AgCheckboxSelector]
    );
    this.eCheckbox = import_ag_grid_community87.RefPlaceholder;
    this.eGroupOpenedIcon = import_ag_grid_community87.RefPlaceholder;
    this.eGroupClosedIcon = import_ag_grid_community87.RefPlaceholder;
    this.eGroupIndeterminateIcon = import_ag_grid_community87.RefPlaceholder;
    this.formattedValue = null;
    this.focusWrapper = params.focusWrapper;
    this.value = params.value;
    this.params = params.params;
    this.translate = params.translate;
    this.valueFormatter = params.valueFormatter;
    this.item = params.item;
    this.isSelected = params.isSelected;
    this.isTree = params.isTree;
    this.depth = params.depth ?? 0;
    this.isGroup = params.isGroup;
    this.groupsExist = params.groupsExist;
    this.isExpanded = params.isExpanded;
    this.hasIndeterminateExpandState = params.hasIndeterminateExpandState;
  }
  postConstruct() {
    this.tooltipFeature = this.createOptionalManagedBean(
      this.beans.registry.createDynamicBean("tooltipFeature", false, {
        getGui: () => this.getGui(),
        getColDef: () => this.params.colDef,
        getColumn: () => this.params.column,
        getLocation: () => "setFilterValue",
        shouldDisplayTooltip: () => this.shouldDisplayTooltip?.() ?? true,
        getValueFormatted: () => this.formattedValue,
        getAdditionalParams: () => this.isTree ? { level: this.depth } : {}
      })
    );
    this.addDestroyFunc(() => this.destroyCellRendererComponent?.());
    this.render();
    this.eCheckbox.setLabelEllipsis(true).setValue(this.isSelected, true).setDisabled(!!this.params.readOnly).getInputElement().setAttribute("tabindex", "-1");
    this.refreshVariableAriaLabels();
    if (this.isTree) {
      if (this.depth > 0) {
        this.addCssClass("ag-set-filter-indent-" + this.depth);
        this.getGui().style.setProperty("--ag-indentation-level", String(this.depth));
      }
      if (this.isGroup) {
        this.setupExpansion();
      } else {
        if (this.groupsExist) {
          this.addCssClass("ag-set-filter-add-group-indent");
        }
      }
      (0, import_ag_grid_community87._setAriaLevel)(this.getAriaElement(), this.depth + 1);
    }
    this.refreshAriaChecked();
    if (this.params.readOnly) {
      return;
    }
    this.eCheckbox.onValueChange((value) => this.onCheckboxChanged(!!value));
  }
  getFocusableElement() {
    return this.focusWrapper;
  }
  setupExpansion() {
    const { eGroupClosedIcon, eGroupOpenedIcon, eGroupIndeterminateIcon, hasIndeterminateExpandState, beans } = this;
    eGroupClosedIcon.appendChild((0, import_ag_grid_community87._createIcon)("setFilterGroupClosed", beans, null));
    eGroupOpenedIcon.appendChild((0, import_ag_grid_community87._createIcon)("setFilterGroupOpen", beans, null));
    const listener = this.onExpandOrContractClicked.bind(this);
    this.addManagedElementListeners(eGroupClosedIcon, { click: listener });
    this.addManagedElementListeners(eGroupOpenedIcon, { click: listener });
    if (hasIndeterminateExpandState) {
      eGroupIndeterminateIcon.appendChild((0, import_ag_grid_community87._createIcon)("setFilterGroupIndeterminate", beans, null));
      this.addManagedElementListeners(eGroupIndeterminateIcon, {
        click: listener
      });
    }
    this.setExpandedIcons();
    this.refreshAriaExpanded();
  }
  onExpandOrContractClicked() {
    this.setExpanded(!this.isExpanded);
  }
  setExpanded(isExpanded, silent) {
    if (this.isGroup && isExpanded !== this.isExpanded) {
      this.isExpanded = isExpanded;
      const event = {
        type: "expandedChanged",
        isExpanded: !!isExpanded,
        item: this.item
      };
      if (!silent) {
        this.dispatchLocalEvent(event);
      }
      this.setExpandedIcons();
      this.refreshAriaExpanded();
    }
  }
  setExpandedIcons() {
    const { isExpanded, hasIndeterminateExpandState, eGroupClosedIcon, eGroupOpenedIcon, eGroupIndeterminateIcon } = this;
    (0, import_ag_grid_community87._setDisplayed)(eGroupClosedIcon, hasIndeterminateExpandState ? isExpanded === false : !isExpanded);
    (0, import_ag_grid_community87._setDisplayed)(eGroupOpenedIcon, isExpanded === true);
    if (hasIndeterminateExpandState) {
      (0, import_ag_grid_community87._setDisplayed)(eGroupIndeterminateIcon, isExpanded === void 0);
    }
  }
  onCheckboxChanged(isSelected) {
    this.isSelected = isSelected;
    const event = {
      type: "selectionChanged",
      isSelected,
      item: this.item
    };
    this.dispatchLocalEvent(event);
    this.refreshVariableAriaLabels();
    this.refreshAriaChecked();
  }
  toggleSelected() {
    if (this.params.readOnly) {
      return;
    }
    this.setSelected(!this.isSelected);
  }
  setSelected(isSelected, silent) {
    this.isSelected = isSelected;
    this.eCheckbox.setValue(isSelected, silent);
    this.refreshAriaChecked();
  }
  refreshVariableAriaLabels() {
    if (!this.isTree) {
      return;
    }
    const translate = this.getLocaleTextFunc();
    const checkboxValue = this.eCheckbox.getValue();
    const state = checkboxValue === void 0 ? translate("ariaIndeterminate", "indeterminate") : checkboxValue ? translate("ariaVisible", "visible") : translate("ariaHidden", "hidden");
    const visibilityLabel = translate("ariaToggleVisibility", "Press SPACE to toggle visibility");
    (0, import_ag_grid_community87._setAriaLabelledBy)(this.eCheckbox.getInputElement(), void 0);
    this.eCheckbox.setInputAriaLabel(`${visibilityLabel} (${state})`);
  }
  setupFixedAriaLabels(value) {
    if (!this.isTree) {
      return;
    }
    const translate = this.getLocaleTextFunc();
    const itemLabel = translate("ariaFilterValue", "Filter Value");
    const ariaEl = this.getAriaElement();
    (0, import_ag_grid_community87._setAriaLabel)(ariaEl, `${value} ${itemLabel}`);
    (0, import_ag_grid_community87._setAriaDescribedBy)(ariaEl, this.eCheckbox.getInputElement().id);
  }
  refreshAriaChecked() {
    const ariaEl = this.getAriaElement();
    (0, import_ag_grid_community87._setAriaChecked)(ariaEl, this.eCheckbox.getValue());
  }
  refreshAriaExpanded() {
    (0, import_ag_grid_community87._setAriaExpanded)(this.getAriaElement(), !!this.isExpanded);
  }
  refresh(item, isSelected, isExpanded) {
    this.item = item;
    if (isSelected !== this.isSelected) {
      this.setSelected(isSelected, true);
    }
    this.setExpanded(isExpanded, true);
    const { cellRendererComponent, cellRendererParams, beans, params } = this;
    if (this.valueFunction) {
      const value = this.valueFunction();
      this.setTooltipAndCellRendererParams(value, value);
      if (!cellRendererComponent) {
        this.renderCellWithoutCellRenderer();
      }
    }
    if (cellRendererComponent) {
      const compDetails = (0, import_ag_grid_community87._getCellRendererDetails)(
        beans.userCompFactory,
        params,
        cellRendererParams
      );
      const success = cellRendererComponent.refresh?.(compDetails?.params ?? cellRendererParams);
      if (!success) {
        const oldComponent = cellRendererComponent;
        this.renderCell();
        this.destroyBean(oldComponent);
      }
    }
  }
  render() {
    const {
      params: { column }
    } = this;
    let { value } = this;
    let formattedValue = null;
    if (typeof value === "function") {
      this.valueFunction = value;
      formattedValue = this.valueFunction();
      value = formattedValue;
    } else if (this.isTree) {
      formattedValue = (0, import_ag_grid_community87._toStringOrNull)(value);
    } else {
      formattedValue = this.getFormattedValue(column, value);
    }
    this.formattedValue = formattedValue;
    this.setTooltipAndCellRendererParams(value, formattedValue);
    this.renderCell();
  }
  setTooltipAndCellRendererParams(value, formattedValue) {
    const gos = this.gos;
    if (this.params.showTooltips && (!(0, import_ag_grid_community87._isShowTooltipWhenTruncated)(gos) || !this.params.cellRenderer)) {
      const newTooltipText = formattedValue != null ? formattedValue : (0, import_ag_grid_community87._toStringOrNull)(value);
      this.shouldDisplayTooltip = (0, import_ag_grid_community87._getShouldDisplayTooltip)(
        gos,
        () => this.eCheckbox.getGui().querySelector(".ag-label")
      );
      this.tooltipFeature?.setTooltipAndRefresh(newTooltipText);
    }
    this.cellRendererParams = (0, import_ag_grid_community87._addGridCommonParams)(gos, {
      value,
      valueFormatted: formattedValue,
      colDef: this.params.colDef,
      column: this.params.column,
      setTooltip: (value2, shouldDisplayTooltip) => {
        gos.assertModuleRegistered("Tooltip", 3);
        this.shouldDisplayTooltip = shouldDisplayTooltip;
        this.tooltipFeature?.setTooltipAndRefresh(value2);
      }
    });
  }
  getFormattedValue(column, value) {
    return this.beans.valueSvc.formatValue(column, null, value, this.valueFormatter, false);
  }
  renderCell() {
    const compDetails = (0, import_ag_grid_community87._getCellRendererDetails)(
      this.beans.userCompFactory,
      this.params,
      this.cellRendererParams
    );
    const cellRendererPromise = compDetails?.newAgStackInstance();
    if (cellRendererPromise == null) {
      this.renderCellWithoutCellRenderer();
      return;
    }
    cellRendererPromise.then((component) => {
      if (component) {
        this.cellRendererComponent = component;
        this.eCheckbox.setLabel(component.getGui());
        this.destroyCellRendererComponent = () => this.destroyBean(component);
      }
    });
  }
  renderCellWithoutCellRenderer() {
    const { valueFormatted, value } = this.cellRendererParams;
    let valueToRender = (valueFormatted == null ? value : valueFormatted) ?? this.translate("blanks");
    if (typeof valueToRender !== "string") {
      (0, import_ag_grid_community87._warn)(208);
      valueToRender = "";
    }
    this.eCheckbox.setLabel(valueToRender);
    this.setupFixedAriaLabels(valueToRender);
  }
  getComponentHolder() {
    return this.params.column.getColDef();
  }
};

// packages/ag-grid-enterprise/src/setFilter/setFilterModelFormatter.ts
var SetFilterModelFormatter = class {
  getModelAsString(model, setFilter) {
    const { values } = model || setFilter.getModel() || {};
    const valueModel = setFilter.getValueModel();
    if (values == null || valueModel == null) {
      return "";
    }
    const availableKeys = values.filter((v) => valueModel.isKeyAvailable(v));
    const numValues = availableKeys.length;
    const formattedValues = availableKeys.slice(0, 10).map((key) => setFilter.getFormattedValue(key));
    return `(${numValues}) ${formattedValues.join(",")}${numValues > 10 ? ",..." : ""}`;
  }
};

// packages/ag-grid-enterprise/src/setFilter/setFilterUtils.ts
var import_ag_grid_community88 = require("ag-grid-community");
function processDataPath(dataPath, treeData, groupAllowUnbalanced) {
  let processedDataPath = dataPath;
  if (!processedDataPath) {
    return null;
  }
  processedDataPath = processedDataPath.map((treeKey) => (0, import_ag_grid_community88._toStringOrNull)((0, import_ag_grid_community88._makeNull)(treeKey)));
  if (!treeData && groupAllowUnbalanced && processedDataPath.some((treeKey) => treeKey == null)) {
    if ((0, import_ag_grid_community88._last)(processedDataPath) == null) {
      return null;
    }
    return processedDataPath.filter((treeKey) => treeKey != null);
  }
  return processedDataPath;
}

// packages/ag-grid-enterprise/src/setFilter/setValueModel.ts
var import_ag_grid_community91 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/setFilter/clientSideValueExtractor.ts
var import_ag_grid_community89 = require("ag-grid-community");
var ClientSideValuesExtractor = class {
  constructor(rowModel, filterParams, createKey, caseFormat, valueSvc, treeDataOrGrouping, treeData, groupAllowUnbalanced, addManagedEventListeners, rowGroupColsSvc) {
    this.rowModel = rowModel;
    this.filterParams = filterParams;
    this.createKey = createKey;
    this.caseFormat = caseFormat;
    this.valueSvc = valueSvc;
    this.treeDataOrGrouping = treeDataOrGrouping;
    this.treeData = treeData;
    this.groupAllowUnbalanced = groupAllowUnbalanced;
    this.addManagedEventListeners = addManagedEventListeners;
    this.rowGroupColsSvc = rowGroupColsSvc;
  }
  extractUniqueValuesAsync(predicate, existingValues) {
    return new import_ag_grid_community89.AgPromise((resolve) => {
      if (this.rowModel.isRowDataLoaded()) {
        resolve(this.extractUniqueValues(predicate, existingValues));
      } else {
        const [destroyFunc] = this.addManagedEventListeners({
          rowCountReady: () => {
            destroyFunc?.();
            resolve(this.extractUniqueValues(predicate, existingValues));
          }
        });
      }
    });
  }
  extractUniqueValues(predicate, existingValues) {
    const values = /* @__PURE__ */ new Map();
    const existingFormattedKeys = this.extractExistingFormattedKeys(existingValues);
    const formattedKeys = /* @__PURE__ */ new Set();
    const treeData = this.treeData;
    const groupedCols = this.rowGroupColsSvc?.columns;
    const addValue = (unformattedKey, value) => {
      const formattedKey = this.caseFormat(unformattedKey);
      if (!formattedKeys.has(formattedKey)) {
        formattedKeys.add(formattedKey);
        let keyToAdd = unformattedKey;
        let valueToAdd = (0, import_ag_grid_community89._makeNull)(value);
        const existingUnformattedKey = existingFormattedKeys?.get(formattedKey);
        if (existingUnformattedKey != null) {
          keyToAdd = existingUnformattedKey;
          valueToAdd = existingValues.get(existingUnformattedKey);
        }
        values.set(keyToAdd, valueToAdd);
      }
    };
    this.rowModel.forEachLeafNode((node) => {
      if (!node.data || !predicate(node)) {
        return;
      }
      if (this.treeDataOrGrouping) {
        this.addValueForTreeDataOrGrouping(node, treeData, groupedCols, addValue);
        return;
      }
      const value = this.getValue(node);
      if (value != null && Array.isArray(value)) {
        value.forEach((x) => {
          addValue(this.createKey(x, node), x);
        });
        if (value.length === 0) {
          addValue(null, null);
        }
      } else {
        addValue(this.createKey(value, node), value);
      }
    });
    return values;
  }
  addValueForTreeDataOrGrouping(node, treeData, groupedCols = [], addValue) {
    let dataPath;
    if (treeData) {
      if (node.childrenAfterGroup?.length) {
        return;
      }
      dataPath = node.getRoute() ?? [node.key ?? node.id];
    } else {
      dataPath = groupedCols.map((groupCol) => this.valueSvc.getKeyForNode(groupCol, node));
      dataPath.push(this.getValue(node));
    }
    const processedDataPath = processDataPath(dataPath, treeData, this.groupAllowUnbalanced);
    addValue(this.createKey(processedDataPath), processedDataPath);
  }
  getValue(node) {
    return this.filterParams.getValue(node);
  }
  extractExistingFormattedKeys(existingValues) {
    if (!existingValues) {
      return null;
    }
    const existingFormattedKeys = /* @__PURE__ */ new Map();
    existingValues.forEach((_value, key) => {
      existingFormattedKeys.set(this.caseFormat(key), key);
    });
    return existingFormattedKeys;
  }
};

// packages/ag-grid-enterprise/src/setFilter/filteringKeys.ts
var SetValueModelFilteringKeys = class {
  constructor({ caseFormat }) {
    // To make the filtering fast, we store the keys in a Set rather than using the default array.
    this.filteringKeys = null;
    // This attribute contains keys that are actually used for filtering.
    // These keys take into account case sensitivity:
    // - When filtering is case-insensitive, all filtering keys are converted to upper case and stored here.
    // - When filtering is case-sensitive, this is the same as filteringKeys.
    this.filteringKeysCaseFormatted = null;
    this.hasNoAppliedFilteringKeys = false;
    this.caseFormat = caseFormat;
  }
  allFilteringKeys() {
    return this.filteringKeys;
  }
  allFilteringKeysCaseFormatted() {
    return this.filteringKeysCaseFormatted;
  }
  setFilteringKeys(filteringKeys) {
    this.filteringKeys = new Set(filteringKeys);
    this.hasNoAppliedFilteringKeys = !this.filteringKeys || this.filteringKeys.size === 0;
    this.filteringKeysCaseFormatted = /* @__PURE__ */ new Set();
    this.filteringKeys.forEach((key) => this.filteringKeysCaseFormatted.add(this.caseFormat(key)));
  }
  addFilteringKey(key) {
    if (this.filteringKeys == null) {
      this.filteringKeys = /* @__PURE__ */ new Set();
      this.filteringKeysCaseFormatted = /* @__PURE__ */ new Set();
    }
    this.filteringKeys.add(key);
    this.filteringKeysCaseFormatted.add(this.caseFormat(key));
    if (this.hasNoAppliedFilteringKeys) {
      this.hasNoAppliedFilteringKeys = false;
    }
  }
  hasCaseFormattedFilteringKey(key) {
    return this.filteringKeysCaseFormatted.has(this.caseFormat(key));
  }
  hasFilteringKey(key) {
    return this.filteringKeys.has(key);
  }
  reset() {
    this.filteringKeys = null;
    this.filteringKeysCaseFormatted = null;
    this.hasNoAppliedFilteringKeys = false;
  }
};

// packages/ag-grid-enterprise/src/setFilter/flatSetDisplayValueModel.ts
var FlatSetDisplayValueModel = class {
  constructor(valueSvc, valueFormatter, formatter, column) {
    this.valueSvc = valueSvc;
    this.valueFormatter = valueFormatter;
    this.formatter = formatter;
    this.column = column;
    /** All keys that are currently displayed, after the mini-filter has been applied. */
    this.displayedKeys = [];
  }
  updateDisplayedValuesToAllAvailable(_getValue, _allKeys, availableKeys) {
    this.displayedKeys = Array.from(availableKeys);
  }
  updateDisplayedValuesToMatchMiniFilter(getValue, _allKeys, availableKeys, matchesFilter, nullMatchesFilter) {
    this.displayedKeys = [];
    for (const key of availableKeys) {
      if (key == null) {
        if (nullMatchesFilter) {
          this.displayedKeys.push(key);
        }
      } else {
        const value = getValue(key);
        const valueFormatterValue = this.valueSvc.formatValue(
          this.column,
          null,
          value,
          this.valueFormatter,
          false
        );
        const textFormatterValue = this.formatter(valueFormatterValue);
        if (matchesFilter(textFormatterValue)) {
          this.displayedKeys.push(key);
        }
      }
    }
  }
  getDisplayedValueCount() {
    return this.displayedKeys.length;
  }
  getDisplayedItem(index) {
    return this.displayedKeys[index];
  }
  getSelectAllItem() {
    return SET_FILTER_SELECT_ALL;
  }
  getAddSelectionToFilterItem() {
    return SET_FILTER_ADD_SELECTION_TO_FILTER;
  }
  getDisplayedKeys() {
    return this.displayedKeys;
  }
  forEachDisplayedKey(func) {
    this.displayedKeys.forEach(func);
  }
  someDisplayedKey(func) {
    return this.displayedKeys.some(func);
  }
  hasGroups() {
    return false;
  }
  refresh() {
  }
};

// packages/ag-grid-enterprise/src/setFilter/treeSetDisplayValueModel.ts
var import_ag_grid_community90 = require("ag-grid-community");
var DATE_TREE_LIST_PATH_GETTER = (date) => {
  if ((0, import_ag_grid_community90._missing)(date)) {
    return null;
  }
  if (!(date instanceof Date) || isNaN(date.getTime())) {
    return ["NaN"];
  }
  return [String(date.getFullYear()), String(date.getMonth() + 1), String(date.getDate())];
};
var TreeSetDisplayValueModel = class {
  constructor(formatter, treeListPathGetter, treeListFormatter, treeDataOrGrouping) {
    this.formatter = formatter;
    this.treeListPathGetter = treeListPathGetter;
    this.treeListFormatter = treeListFormatter;
    this.treeDataOrGrouping = treeDataOrGrouping;
    /** all displayed items in a tree structure */
    this.allDisplayedItemsTree = [];
    /** all displayed items flattened and filtered */
    this.activeDisplayedItemsFlat = [];
    this.selectAllItem = {
      depth: 0,
      filterPasses: true,
      available: true,
      treeKey: SET_FILTER_SELECT_ALL,
      children: this.allDisplayedItemsTree,
      expanded: true,
      key: SET_FILTER_SELECT_ALL,
      parentTreeKeys: []
    };
    this.addSelectionToFilterItem = {
      depth: 0,
      filterPasses: true,
      available: true,
      treeKey: SET_FILTER_ADD_SELECTION_TO_FILTER,
      expanded: true,
      key: SET_FILTER_ADD_SELECTION_TO_FILTER,
      parentTreeKeys: []
    };
  }
  updateOnParamsChange(treeListFormatter) {
    this.treeListFormatter = treeListFormatter;
  }
  updateDisplayedValuesToAllAvailable(getValue, allKeys, availableKeys, source) {
    if (source === "reload") {
      this.generateItemTree(getValue, allKeys, availableKeys);
    } else if (source === "otherFilter") {
      this.updateAvailable(availableKeys);
      this.updateExpandAll();
    } else if (source === "miniFilter") {
      this.resetFilter();
      this.updateExpandAll();
    }
    this.flattenItems();
  }
  updateDisplayedValuesToMatchMiniFilter(getValue, allKeys, availableKeys, matchesFilter, nullMatchesFilter, source) {
    if (source === "reload") {
      this.generateItemTree(getValue, allKeys, availableKeys);
    } else if (source === "otherFilter") {
      this.updateAvailable(availableKeys);
    }
    this.updateFilter(matchesFilter, nullMatchesFilter);
    this.updateExpandAll();
    this.flattenItems();
  }
  generateItemTree(getValue, allKeys, availableKeys) {
    this.allDisplayedItemsTree = [];
    this.groupsExist = false;
    const treeListPathGetter = this.getTreeListPathGetter(getValue, availableKeys);
    for (const key of allKeys) {
      const value = getValue(key);
      const dataPath = treeListPathGetter(value) ?? [null];
      if (dataPath.length > 1) {
        this.groupsExist = true;
      }
      const available = availableKeys.has(key);
      let children = this.allDisplayedItemsTree;
      let item;
      let parentTreeKeys = [];
      dataPath.forEach((treeKey, depth) => {
        if (!children) {
          children = [];
          item.children = children;
        }
        item = children.find((child) => child.treeKey?.toUpperCase() === treeKey?.toUpperCase());
        if (!item) {
          item = { treeKey, depth, filterPasses: true, expanded: false, available, parentTreeKeys };
          if (depth === dataPath.length - 1) {
            item.key = key;
          }
          children.push(item);
        }
        children = item.children;
        parentTreeKeys = [...parentTreeKeys, treeKey];
      });
    }
    this.updateAvailable(availableKeys);
    this.selectAllItem.children = this.allDisplayedItemsTree;
    this.selectAllItem.expanded = false;
  }
  getTreeListPathGetter(getValue, availableKeys) {
    if (this.treeListPathGetter) {
      return this.treeListPathGetter;
    }
    if (this.treeDataOrGrouping) {
      return (value) => value;
    }
    let isDate = false;
    for (const availableKey of availableKeys) {
      const value = getValue(availableKey);
      if (value instanceof Date) {
        isDate = true;
        break;
      } else if (value != null) {
        break;
      }
    }
    if (isDate) {
      return DATE_TREE_LIST_PATH_GETTER;
    }
    (0, import_ag_grid_community90._warn)(211);
    return (value) => [String(value)];
  }
  flattenItems() {
    this.activeDisplayedItemsFlat = [];
    const recursivelyFlattenDisplayedItems = (items) => {
      items.forEach((item) => {
        if (!item.filterPasses || !item.available) {
          return;
        }
        this.activeDisplayedItemsFlat.push(item);
        if (item.children && item.expanded) {
          recursivelyFlattenDisplayedItems(item.children);
        }
      });
    };
    recursivelyFlattenDisplayedItems(this.allDisplayedItemsTree);
  }
  resetFilter() {
    const recursiveFilterReset = (item) => {
      if (item.children) {
        item.children.forEach((child) => {
          recursiveFilterReset(child);
        });
      }
      item.filterPasses = true;
    };
    this.allDisplayedItemsTree.forEach((item) => recursiveFilterReset(item));
  }
  updateFilter(matchesFilter, nullMatchesFilter) {
    const passesFilter = (item) => {
      if (!item.available) {
        return false;
      }
      if (item.treeKey == null) {
        return nullMatchesFilter;
      }
      return matchesFilter(
        this.formatter(
          this.treeListFormatter ? this.treeListFormatter(item.treeKey, item.depth, item.parentTreeKeys) : item.treeKey
        )
      );
    };
    this.allDisplayedItemsTree.forEach(
      (item) => this.recursiveItemCheck(item, false, passesFilter, "filterPasses")
    );
  }
  getDisplayedValueCount() {
    return this.activeDisplayedItemsFlat.length;
  }
  getDisplayedItem(index) {
    return this.activeDisplayedItemsFlat[index];
  }
  getSelectAllItem() {
    return this.selectAllItem;
  }
  getAddSelectionToFilterItem() {
    return this.addSelectionToFilterItem;
  }
  getDisplayedKeys() {
    const displayedKeys = [];
    this.forEachDisplayedKey((key) => displayedKeys.push(key));
    return displayedKeys;
  }
  forEachDisplayedKey(func) {
    const recursiveForEachItem = (item, topParentExpanded) => {
      if (item.children) {
        if (!item.expanded || !topParentExpanded) {
          item.children.forEach((child) => {
            if (child.filterPasses) {
              recursiveForEachItem(child, false);
            }
          });
        }
      } else {
        func(item.key);
      }
    };
    this.activeDisplayedItemsFlat.forEach((item) => recursiveForEachItem(item, true));
  }
  someDisplayedKey(func) {
    const recursiveSomeItem = (item, topParentExpanded) => {
      if (item.children) {
        if (!item.expanded || !topParentExpanded) {
          return item.children.some((child) => {
            if (child.filterPasses) {
              return recursiveSomeItem(child, false);
            }
            return false;
          });
        }
      } else {
        return func(item.key);
      }
      return false;
    };
    return this.activeDisplayedItemsFlat.some((item) => recursiveSomeItem(item, true));
  }
  hasGroups() {
    return this.groupsExist;
  }
  refresh() {
    this.updateExpandAll();
    this.flattenItems();
  }
  updateExpandAll() {
    const recursiveExpansionCheck = (items, someTrue, someFalse) => {
      for (const item2 of items) {
        if (!item2.filterPasses || !item2.available || !item2.children) {
          continue;
        }
        someTrue = someTrue || !!item2.expanded;
        someFalse = someFalse || !item2.expanded;
        if (someTrue && someFalse) {
          return void 0;
        }
        const childExpanded = recursiveExpansionCheck(item2.children, someTrue, someFalse);
        if (childExpanded === void 0) {
          return void 0;
        } else if (childExpanded) {
          someTrue = true;
        } else {
          someFalse = true;
        }
      }
      return someTrue && someFalse ? void 0 : someTrue;
    };
    const item = this.getSelectAllItem();
    item.expanded = recursiveExpansionCheck(item.children, false, false);
  }
  recursiveItemCheck(item, parentPasses, checkFunction, itemProp) {
    let atLeastOneChildPassed = false;
    if (item.children) {
      item.children.forEach((child) => {
        const childPasses = this.recursiveItemCheck(
          child,
          parentPasses || checkFunction(item),
          checkFunction,
          itemProp
        );
        atLeastOneChildPassed = atLeastOneChildPassed || childPasses;
      });
    }
    const itemPasses = parentPasses || atLeastOneChildPassed || checkFunction(item);
    item[itemProp] = itemPasses;
    return itemPasses;
  }
  updateAvailable(availableKeys) {
    const isAvailable = (item) => availableKeys.has(item.key);
    this.allDisplayedItemsTree.forEach((item) => this.recursiveItemCheck(item, false, isAvailable, "available"));
  }
};

// packages/ag-grid-enterprise/src/setFilter/setValueModel.ts
var SetValueModel = class {
  constructor(params) {
    this.localEventService = new import_ag_grid_community91.LocalEventService();
    this.miniFilterText = null;
    /** When true, in excelMode = 'windows', it adds previously selected filter items to newly checked filter selection */
    this.addCurrentSelectionToFilter = false;
    /** Values provided to the filter for use. */
    this.providedValues = null;
    /** All possible values for the filter, sorted if required. */
    this.allValues = /* @__PURE__ */ new Map();
    /** Remaining keys when filters from other columns have been applied. */
    this.availableKeys = /* @__PURE__ */ new Set();
    /** Keys that have been selected for this filter. */
    this.selectedKeys = /* @__PURE__ */ new Set();
    this.initialised = false;
    const {
      usingComplexObjects,
      rowGroupColsSvc,
      valueSvc,
      treeDataTreeList,
      groupingTreeList,
      filterParams,
      gos,
      valueFormatter,
      addManagedEventListeners
    } = params;
    const {
      column,
      colDef,
      textFormatter,
      doesRowPassOtherFilter,
      suppressSorting,
      comparator,
      rowModel,
      values,
      caseSensitive,
      treeList,
      treeListPathGetter,
      treeListFormatter
    } = filterParams;
    this.filterParams = filterParams;
    this.gos = gos;
    this.setIsLoading = params.setIsLoading;
    this.translate = params.translate;
    this.caseFormat = params.caseFormat;
    this.createKey = params.createKey;
    this.usingComplexObjects = !!params.usingComplexObjects;
    this.formatter = textFormatter ?? ((value) => value ?? null);
    this.doesRowPassOtherFilters = doesRowPassOtherFilter;
    this.suppressSorting = suppressSorting || false;
    this.filteringKeys = new SetValueModelFilteringKeys({ caseFormat: this.caseFormat });
    const keyComparator = comparator ?? colDef.comparator;
    const treeDataOrGrouping = !!treeDataTreeList || !!groupingTreeList;
    this.compareByValue = !!(usingComplexObjects && keyComparator || treeDataOrGrouping || treeList && !treeListPathGetter);
    if (treeDataOrGrouping && !keyComparator) {
      this.entryComparator = this.createTreeDataOrGroupingComparator();
    } else if (treeList && !treeListPathGetter && !keyComparator) {
      this.entryComparator = ([_aKey, aValue], [_bKey, bValue]) => (0, import_ag_grid_community91._defaultComparator)(aValue, bValue);
    } else {
      this.entryComparator = ([_aKey, aValue], [_bKey, bValue]) => keyComparator(aValue, bValue);
    }
    this.keyComparator = keyComparator ?? import_ag_grid_community91._defaultComparator;
    this.caseSensitive = !!caseSensitive;
    const groupAllowUnbalanced = gos.get("groupAllowUnbalanced");
    if ((0, import_ag_grid_community91._isClientSideRowModel)(gos, rowModel)) {
      this.clientSideValuesExtractor = new ClientSideValuesExtractor(
        rowModel,
        this.filterParams,
        this.createKey,
        this.caseFormat,
        valueSvc,
        treeDataOrGrouping,
        !!treeDataTreeList,
        groupAllowUnbalanced,
        addManagedEventListeners,
        rowGroupColsSvc
      );
    }
    if (values == null) {
      this.valuesType = 2 /* TAKEN_FROM_GRID_VALUES */;
    } else {
      this.valuesType = Array.isArray(values) ? 0 /* PROVIDED_LIST */ : 1 /* PROVIDED_CALLBACK */;
      this.providedValues = values;
    }
    this.displayValueModel = treeList ? new TreeSetDisplayValueModel(
      this.formatter,
      treeListPathGetter,
      treeListFormatter,
      treeDataTreeList || groupingTreeList
    ) : new FlatSetDisplayValueModel(valueSvc, valueFormatter, this.formatter, column);
    this.updateAllValues().then((updatedKeys) => this.resetSelectionState(updatedKeys || []));
  }
  addEventListener(eventType, listener, async) {
    this.localEventService.addEventListener(eventType, listener, async);
  }
  removeEventListener(eventType, listener, async) {
    this.localEventService.removeEventListener(eventType, listener, async);
  }
  updateOnParamsChange(filterParams) {
    return new import_ag_grid_community91.AgPromise((resolve) => {
      const { values, textFormatter, suppressSorting, treeListFormatter } = filterParams;
      const currentProvidedValues = this.providedValues;
      const currentSuppressSorting = this.suppressSorting;
      this.filterParams = filterParams;
      this.formatter = textFormatter ?? ((value) => value ?? null);
      this.suppressSorting = suppressSorting || false;
      this.providedValues = values ?? null;
      if (this.displayValueModel instanceof TreeSetDisplayValueModel) {
        this.displayValueModel.updateOnParamsChange(treeListFormatter);
      }
      if (this.providedValues !== currentProvidedValues || this.suppressSorting !== currentSuppressSorting) {
        if (!values || values.length === 0) {
          this.valuesType = 2 /* TAKEN_FROM_GRID_VALUES */;
          this.providedValues = null;
        } else {
          this.valuesType = Array.isArray(values) ? 0 /* PROVIDED_LIST */ : 1 /* PROVIDED_CALLBACK */;
        }
        const currentModel = this.getModel();
        this.updateAllValues().then(() => {
          this.setModel(currentModel).then(() => resolve());
        });
      } else {
        resolve();
      }
    });
  }
  /**
   * Re-fetches the values used in the filter from the value source.
   * If keepSelection is false, the filter selection will be reset to everything selected,
   * otherwise the current selection will be preserved.
   */
  refreshValues() {
    return new import_ag_grid_community91.AgPromise((resolve) => {
      this.allValuesPromise.then(() => {
        const currentModel = this.getModel();
        this.updateAllValues();
        this.setModel(currentModel).then(() => resolve());
      });
    });
  }
  /**
   * Overrides the current values being used for the set filter.
   * If keepSelection is false, the filter selection will be reset to everything selected,
   * otherwise the current selection will be preserved.
   */
  overrideValues(valuesToUse) {
    return new import_ag_grid_community91.AgPromise((resolve) => {
      this.allValuesPromise.then(() => {
        this.valuesType = 0 /* PROVIDED_LIST */;
        this.providedValues = valuesToUse;
        this.refreshValues().then(() => resolve());
      });
    });
  }
  /** @return has anything been updated */
  refreshAfterAnyFilterChanged() {
    if (this.showAvailableOnly()) {
      return this.allValuesPromise.then((keys) => {
        this.updateAvailableKeys(keys ?? [], "otherFilter");
        return true;
      });
    }
    return import_ag_grid_community91.AgPromise.resolve(false);
  }
  isInitialised() {
    return this.initialised;
  }
  updateAllValues() {
    this.allValuesPromise = new import_ag_grid_community91.AgPromise((resolve) => {
      switch (this.valuesType) {
        case 2 /* TAKEN_FROM_GRID_VALUES */:
          this.getValuesFromRowsAsync(false).then((values) => resolve(this.processAllValues(values)));
          break;
        case 0 /* PROVIDED_LIST */: {
          resolve(
            this.processAllValues(
              this.uniqueValues(this.validateProvidedValues(this.providedValues))
            )
          );
          break;
        }
        case 1 /* PROVIDED_CALLBACK */: {
          this.setIsLoading(true);
          const callback = this.providedValues;
          const { column, colDef } = this.filterParams;
          const params = (0, import_ag_grid_community91._addGridCommonParams)(this.gos, {
            success: (values) => {
              this.setIsLoading(false);
              resolve(this.processAllValues(this.uniqueValues(this.validateProvidedValues(values))));
            },
            colDef,
            column
          });
          window.setTimeout(() => callback(params), 0);
          break;
        }
      }
    });
    this.allValuesPromise.then((values) => this.updateAvailableKeys(values || [], "reload")).then(() => this.initialised = true);
    return this.allValuesPromise;
  }
  processAllValues(values) {
    const sortedKeys = this.sortKeys(values);
    this.allValues = values ?? /* @__PURE__ */ new Map();
    return sortedKeys;
  }
  validateProvidedValues(values) {
    if (this.usingComplexObjects && values?.length) {
      const firstValue = values[0];
      if (firstValue && typeof firstValue !== "object" && typeof firstValue !== "function") {
        const firstKey = this.createKey(firstValue);
        if (firstKey == null) {
          (0, import_ag_grid_community91._warn)(209);
        } else {
          (0, import_ag_grid_community91._warn)(210);
        }
      }
    }
    return values;
  }
  setValuesType(value) {
    this.valuesType = value;
  }
  getValuesType() {
    return this.valuesType;
  }
  isKeyAvailable(key) {
    return this.availableKeys.has(key);
  }
  showAvailableOnly() {
    return this.valuesType === 2 /* TAKEN_FROM_GRID_VALUES */;
  }
  updateAvailableKeys(allKeys, source) {
    const availableKeys = this.showAvailableOnly() ? this.sortKeys(this.getValuesFromRows(true)) : allKeys;
    this.availableKeys = new Set(availableKeys);
    this.localEventService.dispatchEvent({ type: "availableValuesChanged" });
    this.updateDisplayedValues(source, allKeys);
  }
  sortKeys(nullableValues) {
    const values = nullableValues ?? /* @__PURE__ */ new Map();
    if (this.suppressSorting) {
      return Array.from(values.keys());
    }
    let sortedKeys;
    if (this.compareByValue) {
      sortedKeys = Array.from(values.entries()).sort(this.entryComparator).map(([key]) => key);
    } else {
      sortedKeys = Array.from(values.keys()).sort(this.keyComparator);
    }
    if (this.filterParams.excelMode && values.has(null)) {
      sortedKeys = sortedKeys.filter((v) => v != null);
      sortedKeys.push(null);
    }
    return sortedKeys;
  }
  getParamsForValuesFromRows(removeUnavailableValues = false) {
    if (!this.clientSideValuesExtractor) {
      (0, import_ag_grid_community91._error)(113);
      return null;
    }
    const predicate = (node) => !removeUnavailableValues || this.doesRowPassOtherFilters(node);
    const existingValues = removeUnavailableValues && !this.caseSensitive ? this.allValues : void 0;
    return { predicate, existingValues };
  }
  getValuesFromRows(removeUnavailableValues = false) {
    const params = this.getParamsForValuesFromRows(removeUnavailableValues);
    if (!params) {
      return null;
    }
    return this.clientSideValuesExtractor.extractUniqueValues(params.predicate, params.existingValues);
  }
  getValuesFromRowsAsync(removeUnavailableValues = false) {
    const params = this.getParamsForValuesFromRows(removeUnavailableValues);
    if (!params) {
      return import_ag_grid_community91.AgPromise.resolve(null);
    }
    return this.clientSideValuesExtractor.extractUniqueValuesAsync(params.predicate, params.existingValues);
  }
  /** Sets mini filter value. Returns true if it changed from last value, otherwise false. */
  setMiniFilter(value) {
    value = (0, import_ag_grid_community91._makeNull)(value);
    if (this.miniFilterText === value) {
      return false;
    }
    if (value === null) {
      this.setAddCurrentSelectionToFilter(false);
    }
    this.miniFilterText = value;
    this.updateDisplayedValues("miniFilter");
    return true;
  }
  getMiniFilter() {
    return this.miniFilterText;
  }
  updateDisplayedValues(source, allKeys) {
    if (source === "expansion") {
      this.displayValueModel.refresh();
      return;
    }
    if (this.miniFilterText == null) {
      this.displayValueModel.updateDisplayedValuesToAllAvailable(
        (key) => this.getValue(key),
        allKeys,
        this.availableKeys,
        source
      );
      return;
    }
    const formattedFilterText = this.caseFormat(this.formatter(this.miniFilterText) || "");
    const matchesFilter = (valueToCheck) => valueToCheck != null && this.caseFormat(valueToCheck).indexOf(formattedFilterText) >= 0;
    const nullMatchesFilter = !!this.filterParams.excelMode && matchesFilter(this.translate("blanks"));
    this.displayValueModel.updateDisplayedValuesToMatchMiniFilter(
      (key) => this.getValue(key),
      allKeys,
      this.availableKeys,
      matchesFilter,
      nullMatchesFilter,
      source
    );
  }
  getDisplayedValueCount() {
    return this.displayValueModel.getDisplayedValueCount();
  }
  getDisplayedItem(index) {
    return this.displayValueModel.getDisplayedItem(index);
  }
  getSelectAllItem() {
    return this.displayValueModel.getSelectAllItem();
  }
  getAddSelectionToFilterItem() {
    return this.displayValueModel.getAddSelectionToFilterItem();
  }
  hasSelections() {
    return this.filterParams.defaultToNothingSelected ? this.selectedKeys.size > 0 : this.allValues.size !== this.selectedKeys.size;
  }
  getKeys() {
    return Array.from(this.allValues.keys());
  }
  getValues() {
    return Array.from(this.allValues.values());
  }
  getValue(key) {
    return this.allValues.get(key);
  }
  setAddCurrentSelectionToFilter(value) {
    this.addCurrentSelectionToFilter = value;
  }
  isInWindowsExcelMode() {
    return this.filterParams.excelMode === "windows";
  }
  isAddCurrentSelectionToFilterChecked() {
    return this.isInWindowsExcelMode() && this.addCurrentSelectionToFilter;
  }
  showAddCurrentSelectionToFilter() {
    return this.isInWindowsExcelMode() && (0, import_ag_grid_community91._exists)(this.miniFilterText) && this.miniFilterText.length > 0;
  }
  selectAllMatchingMiniFilter(clearExistingSelection = false) {
    if (this.miniFilterText == null) {
      this.selectedKeys = new Set(this.allValues.keys());
    } else {
      if (clearExistingSelection) {
        this.selectedKeys.clear();
      }
      this.displayValueModel.forEachDisplayedKey((key) => this.selectedKeys.add(key));
    }
  }
  deselectAllMatchingMiniFilter() {
    if (this.miniFilterText == null) {
      this.selectedKeys.clear();
    } else {
      this.displayValueModel.forEachDisplayedKey((key) => this.selectedKeys.delete(key));
    }
  }
  selectKey(key) {
    this.selectedKeys.add(key);
  }
  deselectKey(key) {
    if (this.filterParams.excelMode && this.isEverythingVisibleSelected()) {
      this.resetSelectionState(this.displayValueModel.getDisplayedKeys());
    }
    this.selectedKeys.delete(key);
  }
  isKeySelected(key) {
    return this.selectedKeys.has(key);
  }
  isEverythingVisibleSelected() {
    return !this.displayValueModel.someDisplayedKey((it) => !this.isKeySelected(it));
  }
  isNothingVisibleSelected() {
    return !this.displayValueModel.someDisplayedKey((it) => this.isKeySelected(it));
  }
  getModel() {
    if (!this.hasSelections()) {
      return null;
    }
    const filteringKeys = this.isAddCurrentSelectionToFilterChecked() ? this.filteringKeys.allFilteringKeys() : null;
    if (filteringKeys && filteringKeys.size > 0) {
      if (this.selectedKeys) {
        const modelKeys = /* @__PURE__ */ new Set([
          ...Array.from(filteringKeys),
          ...Array.from(this.selectedKeys).filter((key) => !filteringKeys.has(key))
        ]);
        return Array.from(modelKeys);
      }
      return Array.from(filteringKeys);
    }
    return Array.from(this.selectedKeys);
  }
  setModel(model) {
    return this.allValuesPromise.then((keys) => {
      if (model == null) {
        this.resetSelectionState(keys ?? []);
      } else {
        this.selectedKeys.clear();
        const existingFormattedKeys = /* @__PURE__ */ new Map();
        this.allValues.forEach((_value, key) => {
          existingFormattedKeys.set(this.caseFormat(key), key);
        });
        model.forEach((unformattedKey) => {
          const formattedKey = this.caseFormat((0, import_ag_grid_community91._makeNull)(unformattedKey));
          const existingUnformattedKey = existingFormattedKeys.get(formattedKey);
          if (existingUnformattedKey !== void 0) {
            this.selectKey(existingUnformattedKey);
          }
        });
      }
    });
  }
  uniqueValues(values) {
    const uniqueValues = /* @__PURE__ */ new Map();
    const formattedKeys = /* @__PURE__ */ new Set();
    (values ?? []).forEach((value) => {
      const valueToUse = (0, import_ag_grid_community91._makeNull)(value);
      const unformattedKey = this.createKey(valueToUse);
      const formattedKey = this.caseFormat(unformattedKey);
      if (!formattedKeys.has(formattedKey)) {
        formattedKeys.add(formattedKey);
        uniqueValues.set(unformattedKey, valueToUse);
      }
    });
    return uniqueValues;
  }
  resetSelectionState(keys) {
    if (this.filterParams.defaultToNothingSelected) {
      this.selectedKeys.clear();
    } else {
      this.selectedKeys = new Set(keys);
    }
  }
  hasGroups() {
    return this.displayValueModel.hasGroups();
  }
  createTreeDataOrGroupingComparator() {
    return ([_aKey, aValue], [_bKey, bValue]) => {
      if (aValue == null) {
        return bValue == null ? 0 : -1;
      } else if (bValue == null) {
        return 1;
      }
      for (let i = 0; i < aValue.length; i++) {
        if (i >= bValue.length) {
          return 1;
        }
        const diff = (0, import_ag_grid_community91._defaultComparator)(aValue[i], bValue[i]);
        if (diff !== 0) {
          return diff;
        }
      }
      return 0;
    };
  }
  setAppliedModelKeys(appliedModelKeys) {
    this.filteringKeys.setFilteringKeys(appliedModelKeys);
  }
  addToAppliedModelKeys(appliedModelKey) {
    this.filteringKeys.addFilteringKey(appliedModelKey);
  }
  getAppliedModelKeys() {
    return this.filteringKeys.allFilteringKeys();
  }
  getCaseFormattedAppliedModelKeys() {
    return this.filteringKeys.allFilteringKeysCaseFormatted();
  }
  hasAppliedModelKey(appliedModelKey) {
    return this.filteringKeys.hasCaseFormattedFilteringKey(appliedModelKey);
  }
  hasAnyAppliedModelKey() {
    return !this.filteringKeys.hasNoAppliedFilteringKeys;
  }
};

// packages/ag-grid-enterprise/src/setFilter/setFilter.ts
var SetFilter = class extends import_ag_grid_community92.ProvidedFilter {
  constructor() {
    super("setFilter");
    this.filterType = "set";
    this.eMiniFilter = import_ag_grid_community92.RefPlaceholder;
    this.eFilterLoading = import_ag_grid_community92.RefPlaceholder;
    this.eFilterLoadingIcon = import_ag_grid_community92.RefPlaceholder;
    this.eSetFilterList = import_ag_grid_community92.RefPlaceholder;
    this.eFilterNoMatches = import_ag_grid_community92.RefPlaceholder;
    this.caseSensitive = false;
    this.treeDataTreeList = false;
    this.groupingTreeList = false;
    this.hardRefreshVirtualList = false;
    this.noValueFormatterSupplied = false;
    this.filterModelFormatter = new SetFilterModelFormatter();
    this.updateSetFilterOnParamsChange = (newParams) => {
      this.setFilterParams = newParams;
      this.caseSensitive = !!newParams.caseSensitive;
      const keyCreator = newParams.keyCreator ?? newParams.colDef.keyCreator;
      this.setValueFormatter(newParams.valueFormatter, keyCreator, !!newParams.treeList, !!newParams.colDef.refData);
      const isGroupCol = newParams.column.getId().startsWith(import_ag_grid_community92.GROUP_AUTO_COLUMN_ID);
      this.treeDataTreeList = this.gos.get("treeData") && !!newParams.treeList && isGroupCol;
      this.groupingTreeList = !!this.rowGroupColsSvc?.columns.length && !!newParams.treeList && isGroupCol;
      this.createKey = this.generateCreateKey(keyCreator, this.treeDataTreeList || this.groupingTreeList);
    };
  }
  wireBeans(beans) {
    this.rowGroupColsSvc = beans.rowGroupColsSvc;
    this.valueSvc = beans.valueSvc;
    this.dataTypeSvc = beans.dataTypeSvc;
  }
  postConstruct() {
    super.postConstruct();
  }
  // unlike the simple filters, nothing in the set filter UI shows/hides.
  // maybe this method belongs in abstractSimpleFilter???
  updateUiVisibility() {
  }
  createBodyTemplate() {
    return (
      /* html */
      `
            <div class="ag-set-filter">
                <div data-ref="eFilterLoading" class="ag-filter-loading ag-loading ag-hidden">
                    <span data-ref="eFilterLoadingIcon" class="ag-loading-icon"></span>
                    <span class="ag-loading-text">${this.translateForSetFilter("loadingOoo")}</span>
                </div>
                <ag-input-text-field class="ag-mini-filter" data-ref="eMiniFilter"></ag-input-text-field>
                <div data-ref="eFilterNoMatches" class="ag-filter-no-matches ag-hidden">${this.translateForSetFilter("noMatches")}</div>
                <div data-ref="eSetFilterList" class="ag-set-filter-list" role="presentation"></div>
            </div>`
    );
  }
  getAgComponents() {
    return [import_ag_grid_community92.AgInputTextFieldSelector];
  }
  handleKeyDown(e) {
    super.handleKeyDown(e);
    if (e.defaultPrevented) {
      return;
    }
    switch (e.key) {
      case import_ag_grid_community92.KeyCode.SPACE:
        this.handleKeySpace(e);
        break;
      case import_ag_grid_community92.KeyCode.ENTER:
        this.handleKeyEnter(e);
        break;
      case import_ag_grid_community92.KeyCode.LEFT:
        this.handleKeyLeft(e);
        break;
      case import_ag_grid_community92.KeyCode.RIGHT:
        this.handleKeyRight(e);
        break;
    }
  }
  handleKeySpace(e) {
    this.getComponentForKeyEvent(e)?.toggleSelected();
  }
  handleKeyEnter(e) {
    const { excelMode, readOnly } = this.setFilterParams;
    if (!excelMode || !!readOnly) {
      return;
    }
    e.preventDefault();
    this.onBtApply(false, false, e);
    if (this.setFilterParams.excelMode === "mac") {
      this.eMiniFilter.getInputElement().select();
    }
  }
  handleKeyLeft(e) {
    this.getComponentForKeyEvent(e)?.setExpanded(false);
  }
  handleKeyRight(e) {
    this.getComponentForKeyEvent(e)?.setExpanded(true);
  }
  getComponentForKeyEvent(e) {
    if (!this.eSetFilterList.contains((0, import_ag_grid_community92._getActiveDomElement)(this.beans))) {
      return;
    }
    const currentItem = this.virtualList.getLastFocusedRow();
    if (currentItem == null) {
      return;
    }
    const component = this.virtualList.getComponentAt(currentItem);
    if (component == null) {
      return;
    }
    e.preventDefault();
    const { readOnly } = this.setFilterParams;
    if (readOnly) {
      return;
    }
    return component;
  }
  getCssIdentifier() {
    return "set-filter";
  }
  setModel(model) {
    if (model == null && this.valueModel.getModel() == null) {
      this.setMiniFilter(null);
      return import_ag_grid_community92.AgPromise.resolve();
    }
    return super.setModel(model);
  }
  refresh(params) {
    this.applyExcelModeOptions(params);
    if (!super.refresh(params)) {
      return false;
    }
    const oldParams = this.setFilterParams;
    const paramsThatForceReload = [
      "treeList",
      "treeListPathGetter",
      "caseSensitive",
      "comparator",
      "excelMode"
    ];
    if (paramsThatForceReload.some((param) => params[param] !== oldParams?.[param])) {
      return false;
    }
    if (this.haveColDefParamsChanged(params)) {
      return false;
    }
    super.updateParams(params);
    this.updateSetFilterOnParamsChange(params);
    this.updateMiniFilter();
    if (params.suppressSelectAll !== oldParams?.suppressSelectAll) {
      this.createVirtualListModel(params);
    }
    this.valueModel.updateOnParamsChange(params).then(() => {
      if (this.isAlive()) {
        this.refreshFilterValues();
      }
    });
    return true;
  }
  haveColDefParamsChanged(params) {
    const { colDef, keyCreator } = params;
    const { colDef: existingColDef, keyCreator: existingKeyCreator } = this.setFilterParams;
    const currentKeyCreator = keyCreator ?? colDef.keyCreator;
    const previousKeyCreator = existingKeyCreator ?? existingColDef?.keyCreator;
    const filterValueGetterChanged = colDef.filterValueGetter !== existingColDef?.filterValueGetter;
    const keyCreatorChanged = currentKeyCreator !== previousKeyCreator;
    const valueFormatterIsKeyCreatorAndHasChanged = !!this.dataTypeSvc && !!currentKeyCreator && this.dataTypeSvc.getFormatValue(colDef.cellDataType) === currentKeyCreator && colDef.valueFormatter !== existingColDef?.valueFormatter;
    return filterValueGetterChanged || keyCreatorChanged || valueFormatterIsKeyCreatorAndHasChanged;
  }
  setModelAndRefresh(values) {
    return this.valueModel.setModel(values).then(() => {
      if (this.isAlive()) {
        this.checkAndRefreshVirtualList();
      }
    });
  }
  resetUiToDefaults() {
    this.setMiniFilter(null);
    return this.setModelAndRefresh(null);
  }
  setModelIntoUi(model) {
    this.setMiniFilter(null);
    const values = model == null ? null : model.values;
    return this.setModelAndRefresh(values);
  }
  getModelFromUi() {
    const values = this.valueModel.getModel();
    if (!values) {
      return null;
    }
    return { values, filterType: this.filterType };
  }
  getValueModel() {
    return this.valueModel;
  }
  areModelsEqual(a, b) {
    if (a == null && b == null) {
      return true;
    }
    return a != null && b != null && (0, import_ag_grid_community92._areEqual)(a.values, b.values);
  }
  setParams(params) {
    this.applyExcelModeOptions(params);
    super.setParams(params);
    this.updateSetFilterOnParamsChange(params);
    const keyCreator = params.keyCreator ?? params.colDef.keyCreator;
    this.valueModel = new SetValueModel({
      filterParams: params,
      setIsLoading: (loading) => this.setIsLoading(loading),
      translate: (key) => this.translateForSetFilter(key),
      caseFormat: (v) => this.caseFormat(v),
      createKey: this.createKey,
      valueFormatter: this.valueFormatter,
      usingComplexObjects: !!keyCreator,
      gos: this.gos,
      rowGroupColsSvc: this.rowGroupColsSvc,
      valueSvc: this.valueSvc,
      treeDataTreeList: this.treeDataTreeList,
      groupingTreeList: this.groupingTreeList,
      addManagedEventListeners: (handlers) => this.addManagedEventListeners(handlers)
    });
    this.initialiseFilterBodyUi();
    this.addEventListenersForDataChanges();
  }
  onAddCurrentSelectionToFilterChange(newValue) {
    this.valueModel.setAddCurrentSelectionToFilter(newValue);
  }
  setValueFormatter(providedValueFormatter, keyCreator, treeList, isRefData) {
    let valueFormatter = providedValueFormatter;
    if (!valueFormatter) {
      if (keyCreator && !treeList) {
        (0, import_ag_grid_community92._error)(249);
        return;
      }
      this.noValueFormatterSupplied = true;
      if (!isRefData) {
        valueFormatter = (params) => (0, import_ag_grid_community92._toStringOrNull)(params.value);
      }
    }
    this.valueFormatter = valueFormatter;
  }
  generateCreateKey(keyCreator, treeDataOrGrouping) {
    if (treeDataOrGrouping && !keyCreator) {
      (0, import_ag_grid_community92._error)(250);
      return () => null;
    }
    if (keyCreator) {
      return (value, node = null) => {
        const params = this.getKeyCreatorParams(value, node);
        return (0, import_ag_grid_community92._makeNull)(keyCreator(params));
      };
    }
    return (value) => (0, import_ag_grid_community92._makeNull)((0, import_ag_grid_community92._toStringOrNull)(value));
  }
  getFormattedValue(key) {
    let value = this.valueModel.getValue(key);
    if (this.noValueFormatterSupplied && (this.treeDataTreeList || this.groupingTreeList) && Array.isArray(value)) {
      value = (0, import_ag_grid_community92._last)(value);
    }
    const formattedValue = this.valueSvc.formatValue(
      this.setFilterParams.column,
      null,
      value,
      this.valueFormatter,
      false
    );
    return (formattedValue == null ? (0, import_ag_grid_community92._toStringOrNull)(value) : formattedValue) ?? this.translateForSetFilter("blanks");
  }
  applyExcelModeOptions(params) {
    if (params.excelMode === "windows") {
      if (!params.buttons) {
        params.buttons = ["apply", "cancel"];
      }
      if (params.closeOnApply == null) {
        params.closeOnApply = true;
      }
    } else if (params.excelMode === "mac") {
      if (!params.buttons) {
        params.buttons = ["reset"];
      }
      if (params.applyMiniFilterWhileTyping == null) {
        params.applyMiniFilterWhileTyping = true;
      }
      if (params.debounceMs == null) {
        params.debounceMs = 500;
      }
    }
    if (params.excelMode && params.defaultToNothingSelected) {
      params.defaultToNothingSelected = false;
      (0, import_ag_grid_community92._warn)(207);
    }
  }
  addEventListenersForDataChanges() {
    if (!this.isValuesTakenFromGrid()) {
      return;
    }
    this.addManagedPropertyListeners(["groupAllowUnbalanced"], () => {
      this.syncAfterDataChange();
    });
    this.addManagedEventListeners({
      cellValueChanged: (event) => {
        if (event.column === this.setFilterParams.column) {
          this.syncAfterDataChange();
        }
      }
    });
  }
  syncAfterDataChange() {
    const doApply = !this.applyActive || this.areModelsEqual(this.getModel(), this.getModelFromUi());
    const promise = this.valueModel.refreshValues();
    return promise.then(() => {
      if (this.isAlive()) {
        this.checkAndRefreshVirtualList();
        if (doApply) {
          this.onBtApply(false, true);
        }
      }
    });
  }
  setIsLoading(isLoading) {
    (0, import_ag_grid_community92._setDisplayed)(this.eFilterLoading, isLoading);
    if (!isLoading) {
      this.hardRefreshVirtualList = true;
    }
  }
  initialiseFilterBodyUi() {
    this.initVirtualList();
    this.initMiniFilter();
    this.initLoading();
  }
  initLoading() {
    const loadingIcon = (0, import_ag_grid_community92._createIconNoSpan)("setFilterLoading", this.beans, this.setFilterParams.column);
    if (loadingIcon) {
      this.eFilterLoadingIcon.appendChild(loadingIcon);
    }
  }
  initVirtualList() {
    const translate = this.getLocaleTextFunc();
    const filterListName = translate("ariaFilterList", "Filter List");
    const isTree = !!this.setFilterParams.treeList;
    const virtualList = this.virtualList = this.createBean(
      new VirtualList({
        cssIdentifier: "filter",
        ariaRole: isTree ? "tree" : "listbox",
        listName: filterListName
      })
    );
    const eSetFilterList = this.eSetFilterList;
    if (isTree) {
      eSetFilterList.classList.add("ag-set-filter-tree-list");
    }
    if (eSetFilterList) {
      eSetFilterList.appendChild(virtualList.getGui());
    }
    const { cellHeight } = this.setFilterParams;
    if (cellHeight != null) {
      virtualList.setRowHeight(cellHeight);
    }
    const componentCreator = (item, listItemElement) => this.createSetListItem(item, isTree, listItemElement);
    virtualList.setComponentCreator(componentCreator);
    const componentUpdater = (item, component) => this.updateSetListItem(item, component);
    virtualList.setComponentUpdater(componentUpdater);
    this.createVirtualListModel(this.setFilterParams);
  }
  createVirtualListModel(params) {
    let model;
    if (params.suppressSelectAll) {
      model = new ModelWrapper(this.valueModel);
    } else {
      model = new ModelWrapperWithSelectAll(this.valueModel, () => this.isSelectAllSelected());
    }
    if (params.treeList) {
      model = new TreeModelWrapper(model);
    }
    this.virtualList.setModel(model);
  }
  getSelectAllLabel() {
    const key = this.valueModel.getMiniFilter() == null || !this.setFilterParams.excelMode ? "selectAll" : "selectAllSearchResults";
    return this.translateForSetFilter(key);
  }
  getAddSelectionToFilterLabel() {
    return this.translateForSetFilter("addCurrentSelectionToFilter");
  }
  createSetListItem(item, isTree, focusWrapper) {
    const groupsExist = this.valueModel.hasGroups();
    const { isSelected, isExpanded } = this.isSelectedExpanded(item);
    const { value, depth, isGroup, hasIndeterminateExpandState, selectedListener, expandedListener } = this.newSetListItemAttributes(item);
    const itemParams = {
      focusWrapper,
      value,
      params: this.setFilterParams,
      translate: (translateKey) => this.translateForSetFilter(translateKey),
      valueFormatter: this.valueFormatter,
      item,
      isSelected,
      isTree,
      depth,
      groupsExist,
      isGroup,
      isExpanded,
      hasIndeterminateExpandState
    };
    const listItem = this.createBean(new SetFilterListItem(itemParams));
    listItem.addEventListener("selectionChanged", selectedListener);
    if (expandedListener) {
      listItem.addEventListener("expandedChanged", expandedListener);
    }
    return listItem;
  }
  newSetTreeItemAttributes(item) {
    const groupsExist = this.valueModel.hasGroups();
    if (item.key === SET_FILTER_SELECT_ALL) {
      return {
        value: () => this.getSelectAllLabel(),
        isGroup: groupsExist,
        depth: item.depth,
        hasIndeterminateExpandState: true,
        selectedListener: (e) => this.onSelectAll(e.isSelected),
        expandedListener: (e) => this.onExpandAll(e.item, e.isExpanded)
      };
    }
    if (item.key === SET_FILTER_ADD_SELECTION_TO_FILTER) {
      return {
        value: () => this.getAddSelectionToFilterLabel(),
        depth: item.depth,
        isGroup: false,
        hasIndeterminateExpandState: false,
        selectedListener: (e) => {
          this.onAddCurrentSelectionToFilterChange(e.isSelected);
        }
      };
    }
    if (item.children) {
      return {
        value: this.setFilterParams.treeListFormatter?.(item.treeKey, item.depth, item.parentTreeKeys) ?? item.treeKey,
        depth: item.depth,
        isGroup: true,
        selectedListener: (e) => this.onGroupItemSelected(e.item, e.isSelected),
        expandedListener: (e) => this.onExpandedChanged(e.item, e.isExpanded)
      };
    }
    return {
      value: this.setFilterParams.treeListFormatter?.(item.treeKey, item.depth, item.parentTreeKeys) ?? item.treeKey,
      depth: item.depth,
      selectedListener: (e) => this.onItemSelected(e.item.key, e.isSelected)
    };
  }
  newSetListItemAttributes(item) {
    if (this.isSetFilterModelTreeItem(item)) {
      return this.newSetTreeItemAttributes(item);
    }
    if (item === SET_FILTER_SELECT_ALL) {
      return {
        value: () => this.getSelectAllLabel(),
        selectedListener: (e) => this.onSelectAll(e.isSelected)
      };
    }
    if (item === SET_FILTER_ADD_SELECTION_TO_FILTER) {
      return {
        value: () => this.getAddSelectionToFilterLabel(),
        selectedListener: (e) => {
          this.onAddCurrentSelectionToFilterChange(e.isSelected);
        }
      };
    }
    return {
      value: this.valueModel.getValue(item),
      selectedListener: (e) => this.onItemSelected(e.item, e.isSelected)
    };
  }
  updateSetListItem(item, component) {
    const { isSelected, isExpanded } = this.isSelectedExpanded(item);
    component.refresh(item, isSelected, isExpanded);
  }
  isSelectedExpanded(item) {
    let isSelected;
    let isExpanded;
    if (this.isSetFilterModelTreeItem(item)) {
      isExpanded = item.expanded;
      if (item.key === SET_FILTER_SELECT_ALL) {
        isSelected = this.isSelectAllSelected();
      } else if (item.key === SET_FILTER_ADD_SELECTION_TO_FILTER) {
        isSelected = this.valueModel.isAddCurrentSelectionToFilterChecked();
      } else if (item.children) {
        isSelected = this.areAllChildrenSelected(item);
      } else {
        isSelected = this.valueModel.isKeySelected(item.key);
      }
    } else {
      if (item === SET_FILTER_SELECT_ALL) {
        isSelected = this.isSelectAllSelected();
      } else if (item === SET_FILTER_ADD_SELECTION_TO_FILTER) {
        isSelected = this.valueModel.isAddCurrentSelectionToFilterChecked();
      } else {
        isSelected = this.valueModel.isKeySelected(item);
      }
    }
    return { isSelected, isExpanded };
  }
  isSetFilterModelTreeItem(item) {
    return item?.treeKey !== void 0;
  }
  initMiniFilter() {
    const { eMiniFilter } = this;
    const translate = this.getLocaleTextFunc();
    eMiniFilter.setDisplayed(!this.setFilterParams.suppressMiniFilter);
    eMiniFilter.setValue(this.valueModel.getMiniFilter());
    eMiniFilter.onValueChange(() => this.onMiniFilterInput());
    eMiniFilter.setInputAriaLabel(translate("ariaSearchFilterValues", "Search filter values"));
    this.addManagedElementListeners(eMiniFilter.getInputElement(), {
      keydown: (e) => this.onMiniFilterKeyDown(e)
    });
  }
  updateMiniFilter() {
    const { eMiniFilter } = this;
    if (eMiniFilter.isDisplayed() !== !this.setFilterParams.suppressMiniFilter) {
      eMiniFilter.setDisplayed(!this.setFilterParams.suppressMiniFilter);
    }
    const miniFilterValue = this.valueModel.getMiniFilter();
    if (eMiniFilter.getValue() !== miniFilterValue) {
      eMiniFilter.setValue(miniFilterValue);
    }
  }
  // we need to have the GUI attached before we can draw the virtual rows, as the
  // virtual row logic needs info about the GUI state
  afterGuiAttached(params) {
    super.afterGuiAttached(params);
    this.resetExpansion();
    this.refreshVirtualList();
    const { eMiniFilter } = this;
    eMiniFilter.setInputPlaceholder(this.translateForSetFilter("searchOoo"));
    if (!params || !params.suppressFocus) {
      if (eMiniFilter.isDisplayed()) {
        eMiniFilter.getFocusableElement().focus();
      } else {
        this.virtualList.awaitStable(() => this.virtualList.focusRow(0));
      }
    }
  }
  afterGuiDetached() {
    super.afterGuiDetached();
    if (this.setFilterParams.excelMode) {
      this.resetMiniFilter();
    }
    const appliedModel = this.getModel();
    if (this.setFilterParams.excelMode || !this.areModelsEqual(appliedModel, this.getModelFromUi())) {
      this.resetUiToActiveModel(appliedModel);
      this.showOrHideResults();
    }
  }
  applyModel(source = "api") {
    if (this.setFilterParams.excelMode && source !== "rowDataUpdated" && this.valueModel.isEverythingVisibleSelected()) {
      this.valueModel.selectAllMatchingMiniFilter();
    }
    const shouldKeepCurrentSelection = this.valueModel.showAddCurrentSelectionToFilter() && this.valueModel.isAddCurrentSelectionToFilterChecked();
    if (shouldKeepCurrentSelection && !this.getModel()) {
      return false;
    }
    const result = super.applyModel(source);
    const appliedModel = this.getModel();
    if (appliedModel) {
      if (!shouldKeepCurrentSelection) {
        this.valueModel.setAppliedModelKeys(/* @__PURE__ */ new Set());
      }
      appliedModel.values.forEach((key) => {
        this.valueModel.addToAppliedModelKeys(key);
      });
    } else {
      if (!shouldKeepCurrentSelection) {
        this.valueModel.setAppliedModelKeys(null);
      }
    }
    return result;
  }
  isModelValid(model) {
    return this.setFilterParams.excelMode ? model == null || model.values.length > 0 : true;
  }
  doesFilterPass(params) {
    if (!this.valueModel.getCaseFormattedAppliedModelKeys()) {
      return true;
    }
    if (!this.valueModel.hasAnyAppliedModelKey()) {
      return false;
    }
    const { node } = params;
    if (this.treeDataTreeList) {
      return this.doesFilterPassForTreeData(node);
    }
    if (this.groupingTreeList) {
      return this.doesFilterPassForGrouping(node);
    }
    const value = this.getValueFromNode(node);
    if (value != null && Array.isArray(value)) {
      if (value.length === 0) {
        return this.valueModel.hasAppliedModelKey(null);
      }
      return value.some((v) => this.isInAppliedModel(this.createKey(v, node)));
    }
    return this.isInAppliedModel(this.createKey(value, node));
  }
  doesFilterPassForTreeData(node) {
    if (node.childrenAfterGroup?.length) {
      return false;
    }
    return this.isInAppliedModel(
      this.createKey(
        processDataPath(
          node.getRoute() ?? [node.key ?? node.id],
          true,
          this.gos.get("groupAllowUnbalanced")
        )
      )
    );
  }
  doesFilterPassForGrouping(node) {
    const dataPath = (this.rowGroupColsSvc?.columns ?? []).map(
      (groupCol) => this.valueSvc.getKeyForNode(groupCol, node)
    );
    dataPath.push(this.getValueFromNode(node));
    return this.isInAppliedModel(
      this.createKey(processDataPath(dataPath, false, this.gos.get("groupAllowUnbalanced")))
    );
  }
  isInAppliedModel(key) {
    return this.valueModel.hasAppliedModelKey(key);
  }
  getValueFromNode(node) {
    return this.setFilterParams.getValue(node);
  }
  getKeyCreatorParams(value, node = null) {
    const { colDef, column, api, context } = this.setFilterParams;
    return {
      value,
      colDef,
      column,
      node,
      data: node?.data,
      api,
      context
    };
  }
  onNewRowsLoaded() {
    if (this.isValuesTakenFromGrid()) {
      this.syncAfterDataChange();
    }
  }
  isValuesTakenFromGrid() {
    const valuesType = this.valueModel.getValuesType();
    return valuesType === 2 /* TAKEN_FROM_GRID_VALUES */;
  }
  //noinspection JSUnusedGlobalSymbols
  /**
   * Public method provided so the user can change the value of the filter once
   * the filter has been already started
   * @param values The values to use.
   */
  setFilterValues(values) {
    this.valueModel.overrideValues(values).then(() => {
      if (this.isAlive()) {
        this.checkAndRefreshVirtualList();
        this.onUiChanged();
      }
    });
  }
  //noinspection JSUnusedGlobalSymbols
  /**
   * Public method provided so the user can reset the values of the filter once that it has started.
   */
  resetFilterValues() {
    this.valueModel.setValuesType(2 /* TAKEN_FROM_GRID_VALUES */);
    this.syncAfterDataChange();
  }
  refreshFilterValues() {
    if (!this.valueModel.isInitialised()) {
      return;
    }
    this.valueModel.refreshValues().then(() => {
      if (this.isAlive()) {
        this.hardRefreshVirtualList = true;
        this.checkAndRefreshVirtualList();
        this.onUiChanged();
      }
    });
  }
  onAnyFilterChanged() {
    setTimeout(() => {
      if (!this.isAlive()) {
        return;
      }
      this.valueModel.refreshAfterAnyFilterChanged().then((refresh) => {
        if (refresh && this.isAlive()) {
          this.checkAndRefreshVirtualList();
          this.showOrHideResults();
        }
      });
    }, 0);
  }
  onMiniFilterInput() {
    if (!this.valueModel.setMiniFilter(this.eMiniFilter.getValue())) {
      return;
    }
    const { applyMiniFilterWhileTyping, readOnly } = this.setFilterParams;
    if (!readOnly && applyMiniFilterWhileTyping) {
      this.filterOnAllVisibleValues(false);
    } else {
      this.updateUiAfterMiniFilterChange();
    }
  }
  updateUiAfterMiniFilterChange() {
    const { excelMode, readOnly } = this.setFilterParams;
    if (excelMode == null || !!readOnly) {
      this.checkAndRefreshVirtualList();
    } else if (this.valueModel.getMiniFilter() == null) {
      this.resetUiToActiveModel(this.getModel());
    } else {
      this.valueModel.selectAllMatchingMiniFilter(true);
      this.checkAndRefreshVirtualList();
      this.onUiChanged();
    }
    this.showOrHideResults();
  }
  showOrHideResults() {
    const hideResults = this.valueModel.getMiniFilter() != null && this.valueModel.getDisplayedValueCount() < 1;
    (0, import_ag_grid_community92._setDisplayed)(this.eFilterNoMatches, hideResults);
    (0, import_ag_grid_community92._setDisplayed)(this.eSetFilterList, !hideResults);
  }
  resetMiniFilter() {
    this.eMiniFilter.setValue(null, true);
    this.valueModel.setMiniFilter(null);
  }
  resetUiToActiveModel(currentModel, afterUiUpdatedFunc) {
    this.setModelAndRefresh(currentModel == null ? null : currentModel.values).then(() => {
      if (this.isAlive()) {
        this.onUiChanged(false, "prevent");
        afterUiUpdatedFunc?.();
      }
    });
  }
  handleCancelEnd(e) {
    this.setMiniFilter(null);
    super.handleCancelEnd(e);
  }
  onMiniFilterKeyDown(e) {
    const { excelMode, readOnly } = this.setFilterParams;
    if (e.key === import_ag_grid_community92.KeyCode.ENTER && !excelMode && !readOnly) {
      this.filterOnAllVisibleValues();
    }
  }
  filterOnAllVisibleValues(applyImmediately = true) {
    this.valueModel.selectAllMatchingMiniFilter(true);
    this.checkAndRefreshVirtualList();
    this.onUiChanged(false, applyImmediately ? "immediately" : "debounce");
    this.showOrHideResults();
  }
  focusRowIfAlive(rowIndex) {
    if (rowIndex == null) {
      return;
    }
    window.setTimeout(() => {
      if (this.isAlive()) {
        this.virtualList.focusRow(rowIndex);
      }
    }, 0);
  }
  onSelectAll(isSelected) {
    if (isSelected) {
      this.valueModel.selectAllMatchingMiniFilter();
    } else {
      this.valueModel.deselectAllMatchingMiniFilter();
    }
    this.refreshAfterSelection();
  }
  onGroupItemSelected(item, isSelected) {
    const recursiveGroupSelection = (i) => {
      if (!i.filterPasses) {
        return;
      }
      if (i.children) {
        i.children.forEach((childItem) => recursiveGroupSelection(childItem));
      } else {
        this.selectItem(i.key, isSelected);
      }
    };
    recursiveGroupSelection(item);
    this.refreshAfterSelection();
  }
  onItemSelected(key, isSelected) {
    this.selectItem(key, isSelected);
    this.refreshAfterSelection();
  }
  selectItem(key, isSelected) {
    if (isSelected) {
      this.valueModel.selectKey(key);
    } else {
      this.valueModel.deselectKey(key);
    }
  }
  onExpandAll(item, isExpanded) {
    const recursiveExpansion = (i) => {
      if (i.filterPasses && i.available && i.children) {
        i.children.forEach((childItem) => recursiveExpansion(childItem));
        i.expanded = isExpanded;
      }
    };
    recursiveExpansion(item);
    this.refreshAfterExpansion();
  }
  onExpandedChanged(item, isExpanded) {
    item.expanded = isExpanded;
    this.refreshAfterExpansion();
  }
  refreshAfterExpansion() {
    const focusedRow = this.virtualList.getLastFocusedRow();
    this.valueModel.updateDisplayedValues("expansion");
    this.checkAndRefreshVirtualList();
    this.focusRowIfAlive(focusedRow);
  }
  refreshAfterSelection() {
    const focusedRow = this.virtualList.getLastFocusedRow();
    this.checkAndRefreshVirtualList();
    this.onUiChanged();
    this.focusRowIfAlive(focusedRow);
  }
  setMiniFilter(newMiniFilter) {
    this.eMiniFilter.setValue(newMiniFilter);
    this.onMiniFilterInput();
  }
  getMiniFilter() {
    return this.valueModel.getMiniFilter();
  }
  checkAndRefreshVirtualList() {
    this.virtualList.refresh(!this.hardRefreshVirtualList);
    if (this.hardRefreshVirtualList) {
      this.hardRefreshVirtualList = false;
    }
  }
  getFilterKeys() {
    return this.valueModel.getKeys();
  }
  getFilterValues() {
    return this.valueModel.getValues();
  }
  getValues() {
    return this.getFilterKeys();
  }
  refreshVirtualList() {
    if (this.setFilterParams.refreshValuesOnOpen) {
      this.refreshFilterValues();
    } else {
      this.checkAndRefreshVirtualList();
    }
  }
  translateForSetFilter(key) {
    const translate = this.getLocaleTextFunc();
    return translate(key, DEFAULT_LOCALE_TEXT[key]);
  }
  isSelectAllSelected() {
    if (!this.setFilterParams.defaultToNothingSelected) {
      if (this.valueModel.hasSelections() && this.valueModel.isNothingVisibleSelected()) {
        return false;
      }
      if (this.valueModel.isEverythingVisibleSelected()) {
        return true;
      }
    } else {
      if (this.valueModel.hasSelections() && this.valueModel.isEverythingVisibleSelected()) {
        return true;
      }
      if (this.valueModel.isNothingVisibleSelected()) {
        return false;
      }
    }
    return void 0;
  }
  areAllChildrenSelected(item) {
    const recursiveChildSelectionCheck = (i) => {
      if (i.children) {
        let someTrue = false;
        let someFalse = false;
        const mixed = i.children.some((child) => {
          if (!child.filterPasses || !child.available) {
            return false;
          }
          const childSelected = recursiveChildSelectionCheck(child);
          if (childSelected === void 0) {
            return true;
          }
          if (childSelected) {
            someTrue = true;
          } else {
            someFalse = true;
          }
          return someTrue && someFalse;
        });
        return mixed ? void 0 : someTrue;
      } else {
        return this.valueModel.isKeySelected(i.key);
      }
    };
    if (!this.setFilterParams.defaultToNothingSelected) {
      return recursiveChildSelectionCheck(item);
    } else {
      return this.valueModel.hasSelections() && recursiveChildSelectionCheck(item);
    }
  }
  destroy() {
    this.virtualList = this.destroyBean(this.virtualList);
    super.destroy();
  }
  caseFormat(valueToFormat) {
    if (valueToFormat == null || typeof valueToFormat !== "string") {
      return valueToFormat;
    }
    return this.caseSensitive ? valueToFormat : valueToFormat.toUpperCase();
  }
  resetExpansion() {
    if (!this.setFilterParams.treeList) {
      return;
    }
    const selectAllItem = this.valueModel.getSelectAllItem();
    if (this.isSetFilterModelTreeItem(selectAllItem)) {
      const recursiveCollapse = (i) => {
        if (i.children) {
          i.children.forEach((childItem) => recursiveCollapse(childItem));
          i.expanded = false;
        }
      };
      recursiveCollapse(selectAllItem);
      this.valueModel.updateDisplayedValues("expansion");
    }
  }
  getModelAsString(model) {
    return this.filterModelFormatter.getModelAsString(model, this);
  }
  getPositionableElement() {
    return this.eSetFilterList;
  }
};
var ModelWrapper = class {
  constructor(model) {
    this.model = model;
  }
  getRowCount() {
    return this.model.getDisplayedValueCount();
  }
  getRow(index) {
    return this.model.getDisplayedItem(index);
  }
  areRowsEqual(oldRow, newRow) {
    return oldRow === newRow;
  }
};
var ModelWrapperWithSelectAll = class {
  constructor(model, isSelectAllSelected) {
    this.model = model;
    this.isSelectAllSelected = isSelectAllSelected;
  }
  getRowCount() {
    const showAddCurrentSelectionToFilter = this.model.showAddCurrentSelectionToFilter();
    const outboundItems = showAddCurrentSelectionToFilter ? 2 : 1;
    return this.model.getDisplayedValueCount() + outboundItems;
  }
  getRow(index) {
    if (index === 0) {
      return this.model.getSelectAllItem();
    }
    const showAddCurrentSelectionToFilter = this.model.showAddCurrentSelectionToFilter();
    const outboundItems = showAddCurrentSelectionToFilter ? 2 : 1;
    if (index === 1 && showAddCurrentSelectionToFilter) {
      return this.model.getAddSelectionToFilterItem();
    }
    return this.model.getDisplayedItem(index - outboundItems);
  }
  areRowsEqual(oldRow, newRow) {
    return oldRow === newRow;
  }
};
var TreeModelWrapper = class {
  constructor(model) {
    this.model = model;
  }
  getRowCount() {
    return this.model.getRowCount();
  }
  getRow(index) {
    return this.model.getRow(index);
  }
  areRowsEqual(oldRow, newRow) {
    if (oldRow == null && newRow == null) {
      return true;
    }
    return oldRow != null && newRow != null && oldRow.treeKey === newRow.treeKey && oldRow.depth === newRow.depth;
  }
};

// packages/ag-grid-enterprise/src/setFilter/setFloatingFilter.ts
var import_ag_grid_community93 = require("ag-grid-community");
var SetFloatingFilterComp = class extends import_ag_grid_community93.Component {
  constructor() {
    super(
      /* html */
      `
            <div class="ag-floating-filter-input ag-set-floating-filter-input" role="presentation">
                <ag-input-text-field data-ref="eFloatingFilterText"></ag-input-text-field>
            </div>`,
      [import_ag_grid_community93.AgInputTextFieldSelector]
    );
    this.eFloatingFilterText = import_ag_grid_community93.RefPlaceholder;
    this.availableValuesListenerAdded = false;
    this.filterModelFormatter = new SetFilterModelFormatter();
  }
  wireBeans(beans) {
    this.colNames = beans.colNames;
  }
  init(params) {
    this.params = params;
    this.eFloatingFilterText.setDisabled(true).addGuiEventListener("click", () => this.params.showParentFilter());
    this.setParams(params);
  }
  setParams(params) {
    const displayName = this.colNames.getDisplayNameForColumn(params.column, "header", true);
    const translate = this.getLocaleTextFunc();
    this.eFloatingFilterText.setInputAriaLabel(`${displayName} ${translate("ariaFilterInput", "Filter Input")}`);
  }
  refresh(params) {
    this.params = params;
    this.setParams(params);
  }
  onParentModelChanged(parentModel) {
    this.updateFloatingFilterText(parentModel);
  }
  parentSetFilterInstance(cb) {
    this.params.parentFilterInstance((filter) => {
      if (!(filter instanceof SetFilter)) {
        (0, import_ag_grid_community93._error)(248);
        return;
      }
      cb(filter);
    });
  }
  addAvailableValuesListener() {
    this.parentSetFilterInstance((setFilter) => {
      const setValueModel = setFilter.getValueModel();
      if (!setValueModel) {
        return;
      }
      this.addManagedListeners(setValueModel, { availableValuesChanged: () => this.updateFloatingFilterText() });
    });
    this.availableValuesListenerAdded = true;
  }
  updateFloatingFilterText(parentModel) {
    if (!this.availableValuesListenerAdded) {
      this.addAvailableValuesListener();
    }
    this.parentSetFilterInstance((setFilter) => {
      this.eFloatingFilterText.setValue(this.filterModelFormatter.getModelAsString(parentModel, setFilter));
    });
  }
};

// packages/ag-grid-enterprise/src/setFilter/setFilterModule.ts
var SetFilterModule = {
  moduleName: "SetFilter",
  version: VERSION,
  userComponents: { agSetColumnFilter: SetFilter, agSetColumnFloatingFilter: SetFloatingFilterComp },
  icons: {
    // set filter tree list group contracted (click to expand)
    setFilterGroupClosed: "tree-closed",
    // set filter tree list group expanded (click to contract)
    setFilterGroupOpen: "tree-open",
    // set filter tree list expand/collapse all button, shown when some children are expanded and
    //     others are collapsed
    setFilterGroupIndeterminate: "tree-indeterminate",
    // set filter async values loading
    setFilterLoading: "loading"
  },
  dependsOn: [EnterpriseCoreModule, import_ag_grid_community94._ColumnFilterModule]
};

// packages/ag-grid-enterprise/src/statusBar/statusBarModule.ts
var import_ag_grid_community104 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/statusBar/agStatusBar.ts
var import_ag_grid_community95 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/statusBar/agStatusBar.css-GENERATED.ts
var agStatusBarCSS = (
  /*css*/
  `.ag-status-bar{border-top:var(--ag-footer-row-border);display:flex;justify-content:space-between;line-height:1.5;overflow:hidden;padding-left:calc(var(--ag-spacing)*4);padding-right:calc(var(--ag-spacing)*4)}.ag-status-panel{display:inline-flex}.ag-status-name-value{color:var(--ag-status-bar-label-color);font-weight:var(--ag-status-bar-label-font-weight);margin-left:var(--ag-spacing);margin-right:var(--ag-spacing);padding-bottom:var(--ag-widget-container-vertical-padding);padding-top:var(--ag-widget-container-vertical-padding);white-space:nowrap}.ag-status-name-value-value{color:var(--ag-status-bar-value-color);font-weight:var(--ag-status-bar-value-font-weight)}.ag-status-bar-left{display:inline-flex}.ag-status-bar-center{display:inline-flex;text-align:center}.ag-status-bar-right{display:inline-flex}`
);

// packages/ag-grid-enterprise/src/statusBar/agStatusBar.ts
function getStatusPanelCompDetails(userCompFactory, def, params) {
  return userCompFactory.getCompDetails(def, StatusPanelComponent, void 0, params, true);
}
var StatusPanelComponent = {
  name: "statusPanel",
  optionalMethods: ["refresh"]
};
var AgStatusBar = class extends import_ag_grid_community95.Component {
  constructor() {
    super(
      /* html */
      `<div class="ag-status-bar">
            <div data-ref="eStatusBarLeft" class="ag-status-bar-left" role="status"></div>
            <div data-ref="eStatusBarCenter" class="ag-status-bar-center" role="status"></div>
            <div data-ref="eStatusBarRight" class="ag-status-bar-right" role="status"></div>
        </div>`
    );
    this.updateQueued = false;
    this.panelsPromise = import_ag_grid_community95.AgPromise.resolve();
    this.eStatusBarLeft = import_ag_grid_community95.RefPlaceholder;
    this.eStatusBarCenter = import_ag_grid_community95.RefPlaceholder;
    this.eStatusBarRight = import_ag_grid_community95.RefPlaceholder;
    this.compDestroyFunctions = {};
    this.registerCSS(agStatusBarCSS);
  }
  wireBeans(beans) {
    this.userCompFactory = beans.userCompFactory;
    this.statusBarSvc = beans.statusBarSvc;
  }
  postConstruct() {
    this.processStatusPanels(/* @__PURE__ */ new Map());
    this.addManagedPropertyListeners(["statusBar"], this.handleStatusBarChanged.bind(this));
  }
  processStatusPanels(existingStatusPanelsToReuse) {
    const statusPanels = this.gos.get("statusBar")?.statusPanels;
    if (statusPanels) {
      const leftStatusPanelComponents = statusPanels.filter(
        (componentConfig) => componentConfig.align === "left"
      );
      const centerStatusPanelComponents = statusPanels.filter(
        (componentConfig) => componentConfig.align === "center"
      );
      const rightStatusPanelComponents = statusPanels.filter(
        (componentConfig) => !componentConfig.align || componentConfig.align === "right"
      );
      this.panelsPromise = import_ag_grid_community95.AgPromise.all([
        this.createAndRenderComponents(
          leftStatusPanelComponents,
          this.eStatusBarLeft,
          existingStatusPanelsToReuse
        ),
        this.createAndRenderComponents(
          centerStatusPanelComponents,
          this.eStatusBarCenter,
          existingStatusPanelsToReuse
        ),
        this.createAndRenderComponents(
          rightStatusPanelComponents,
          this.eStatusBarRight,
          existingStatusPanelsToReuse
        )
      ]);
    } else {
      this.setDisplayed(false);
    }
  }
  handleStatusBarChanged() {
    if (this.updateQueued) {
      return;
    }
    this.updateQueued = true;
    this.panelsPromise.then(() => {
      this.updateStatusBar();
      this.updateQueued = false;
    });
  }
  updateStatusBar() {
    const statusPanels = this.gos.get("statusBar")?.statusPanels;
    const validStatusBarPanelsProvided = Array.isArray(statusPanels) && statusPanels.length > 0;
    this.setDisplayed(validStatusBarPanelsProvided);
    const existingStatusPanelsToReuse = /* @__PURE__ */ new Map();
    if (validStatusBarPanelsProvided) {
      statusPanels.forEach((statusPanelConfig) => {
        const key = statusPanelConfig.key ?? statusPanelConfig.statusPanel;
        const existingStatusPanel = this.statusBarSvc.getStatusPanel(key);
        if (existingStatusPanel?.refresh) {
          const newParams = (0, import_ag_grid_community95._addGridCommonParams)(this.gos, statusPanelConfig.statusPanelParams ?? {});
          const hasRefreshed = existingStatusPanel.refresh(newParams);
          if (hasRefreshed) {
            existingStatusPanelsToReuse.set(key, existingStatusPanel);
            delete this.compDestroyFunctions[key];
            (0, import_ag_grid_community95._removeFromParent)(existingStatusPanel.getGui());
          }
        }
      });
    }
    this.resetStatusBar();
    if (validStatusBarPanelsProvided) {
      this.processStatusPanels(existingStatusPanelsToReuse);
    }
  }
  resetStatusBar() {
    this.eStatusBarLeft.innerHTML = "";
    this.eStatusBarCenter.innerHTML = "";
    this.eStatusBarRight.innerHTML = "";
    this.destroyComponents();
    this.statusBarSvc.unregisterAllComponents();
  }
  destroy() {
    this.destroyComponents();
    super.destroy();
  }
  destroyComponents() {
    Object.values(this.compDestroyFunctions).forEach((func) => func());
    this.compDestroyFunctions = {};
  }
  createAndRenderComponents(statusBarComponents, ePanelComponent, existingStatusPanelsToReuse) {
    const componentDetails = [];
    statusBarComponents.forEach((componentConfig) => {
      const key = componentConfig.key || componentConfig.statusPanel;
      const existingStatusPanel = existingStatusPanelsToReuse.get(key);
      let promise;
      if (existingStatusPanel) {
        promise = import_ag_grid_community95.AgPromise.resolve(existingStatusPanel);
      } else {
        const compDetails = getStatusPanelCompDetails(
          this.userCompFactory,
          componentConfig,
          (0, import_ag_grid_community95._addGridCommonParams)(this.gos, {})
        );
        if (compDetails == null) {
          return;
        }
        promise = compDetails.newAgStackInstance();
      }
      componentDetails.push({
        key,
        promise
      });
    });
    return import_ag_grid_community95.AgPromise.all(componentDetails.map((details) => details.promise)).then(() => {
      componentDetails.forEach((componentDetail) => {
        componentDetail.promise.then((component) => {
          const destroyFunc = () => {
            this.destroyBean(component);
          };
          if (this.isAlive()) {
            this.statusBarSvc.registerStatusPanel(componentDetail.key, component);
            ePanelComponent.appendChild(component.getGui());
            this.compDestroyFunctions[componentDetail.key] = destroyFunc;
          } else {
            destroyFunc();
          }
        });
      });
    });
  }
};
var AgStatusBarSelector = {
  selector: "AG-STATUS-BAR",
  component: AgStatusBar
};

// packages/ag-grid-enterprise/src/statusBar/providedPanels/aggregationComp.ts
var import_ag_grid_community97 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/statusBar/providedPanels/agNameValue.ts
var import_ag_grid_community96 = require("ag-grid-community");
var AgNameValue = class extends import_ag_grid_community96.Component {
  constructor() {
    super(
      /* html */
      `<div class="ag-status-name-value">
            <span data-ref="eLabel"></span>:&nbsp;
            <span data-ref="eValue" class="ag-status-name-value-value"></span>
        </div>`
    );
    this.eLabel = import_ag_grid_community96.RefPlaceholder;
    this.eValue = import_ag_grid_community96.RefPlaceholder;
  }
  setLabel(key, defaultValue) {
    this.setDisplayed(false);
    const localeTextFunc = this.getLocaleTextFunc();
    this.eLabel.innerHTML = localeTextFunc(key, defaultValue);
  }
  setValue(value) {
    this.eValue.innerHTML = value;
  }
};
var AgNameValueSelector = {
  selector: "AG-NAME-VALUE",
  component: AgNameValue
};

// packages/ag-grid-enterprise/src/statusBar/providedPanels/aggregationComp.ts
function _formatNumberTwoDecimalPlacesAndCommas(value, getLocaleTextFunc) {
  if (typeof value !== "number") {
    return "";
  }
  return (0, import_ag_grid_community97._formatNumberCommas)(Math.round(value * 100) / 100, getLocaleTextFunc);
}
var AggregationComp = class extends import_ag_grid_community97.Component {
  constructor() {
    super(
      /* html */
      `<div class="ag-status-panel ag-status-panel-aggregations">
            <ag-name-value data-ref="avgAggregationComp"></ag-name-value>
            <ag-name-value data-ref="countAggregationComp"></ag-name-value>
            <ag-name-value data-ref="minAggregationComp"></ag-name-value>
            <ag-name-value data-ref="maxAggregationComp"></ag-name-value>
            <ag-name-value data-ref="sumAggregationComp"></ag-name-value>
        </div>`,
      [AgNameValueSelector]
    );
    this.sumAggregationComp = import_ag_grid_community97.RefPlaceholder;
    this.countAggregationComp = import_ag_grid_community97.RefPlaceholder;
    this.minAggregationComp = import_ag_grid_community97.RefPlaceholder;
    this.maxAggregationComp = import_ag_grid_community97.RefPlaceholder;
    this.avgAggregationComp = import_ag_grid_community97.RefPlaceholder;
  }
  postConstruct() {
    if (!(0, import_ag_grid_community97._isClientSideRowModel)(this.gos) && !(0, import_ag_grid_community97._isServerSideRowModel)(this.gos)) {
      (0, import_ag_grid_community97._warn)(221);
      return;
    }
    this.avgAggregationComp.setLabel("avg", "Average");
    this.countAggregationComp.setLabel("count", "Count");
    this.minAggregationComp.setLabel("min", "Min");
    this.maxAggregationComp.setLabel("max", "Max");
    this.sumAggregationComp.setLabel("sum", "Sum");
    this.addManagedEventListeners({
      cellSelectionChanged: this.onCellSelectionChanged.bind(this),
      modelUpdated: this.onCellSelectionChanged.bind(this)
    });
  }
  init(params) {
    this.refresh(params);
  }
  refresh(params) {
    this.params = params;
    this.onCellSelectionChanged();
    return true;
  }
  setAggregationComponentValue(aggFuncName, value, visible) {
    const statusBarValueComponent = this.getAllowedAggregationValueComponent(aggFuncName);
    if ((0, import_ag_grid_community97._exists)(statusBarValueComponent) && statusBarValueComponent) {
      statusBarValueComponent.setValue(
        _formatNumberTwoDecimalPlacesAndCommas(value, this.getLocaleTextFunc.bind(this))
      );
      statusBarValueComponent.setDisplayed(visible);
    } else {
      this.getAggregationValueComponent(aggFuncName)?.setDisplayed(false);
    }
  }
  getAllowedAggregationValueComponent(aggFuncName) {
    const { aggFuncs } = this.params;
    if (!aggFuncs || aggFuncs.includes(aggFuncName)) {
      return this.getAggregationValueComponent(aggFuncName);
    }
    return null;
  }
  getAggregationValueComponent(aggFuncName) {
    const refComponentName = `${aggFuncName}AggregationComp`;
    return this[refComponentName];
  }
  onCellSelectionChanged() {
    const beans = this.beans;
    const { rangeSvc, valueSvc, cellNavigation } = beans;
    const cellRanges = rangeSvc?.getCellRanges();
    let sum = 0;
    let count = 0;
    let numberCount = 0;
    let min = null;
    let max = null;
    const cellsSoFar = {};
    if (cellRanges?.length && rangeSvc) {
      for (let i = 0; i < cellRanges.length; i++) {
        const cellRange = cellRanges[i];
        let currentRow = rangeSvc.getRangeStartRow(cellRange);
        const lastRow = rangeSvc.getRangeEndRow(cellRange);
        while (true) {
          const finishedAllRows = (0, import_ag_grid_community97._missing)(currentRow) || !currentRow || (0, import_ag_grid_community97._isRowBefore)(lastRow, currentRow);
          if (finishedAllRows || !currentRow || !cellRange.columns) {
            break;
          }
          cellRange.columns.forEach((col) => {
            if (currentRow === null) {
              return;
            }
            const cellId = (0, import_ag_grid_community97._createCellId)({
              rowPinned: currentRow.rowPinned,
              column: col,
              rowIndex: currentRow.rowIndex
            });
            if (cellsSoFar[cellId]) {
              return;
            }
            cellsSoFar[cellId] = true;
            const rowNode = (0, import_ag_grid_community97._getRowNode)(beans, currentRow);
            if ((0, import_ag_grid_community97._missing)(rowNode)) {
              return;
            }
            let value = valueSvc.getValue(col, rowNode);
            if ((0, import_ag_grid_community97._missing)(value) || value === "") {
              return;
            }
            count++;
            if (typeof value === "object" && "value" in value) {
              value = value.value;
              if (value === "") {
                return;
              }
            }
            if (typeof value === "string") {
              value = Number(value);
            }
            if (typeof value === "number" && !isNaN(value)) {
              sum += value;
              if (max === null || value > max) {
                max = value;
              }
              if (min === null || value < min) {
                min = value;
              }
              numberCount++;
            }
          });
          currentRow = cellNavigation.getRowBelow(currentRow);
        }
      }
    }
    const gotResult = count > 1;
    const gotNumberResult = numberCount > 1;
    this.setAggregationComponentValue("count", count, gotResult);
    this.setAggregationComponentValue("sum", sum, gotNumberResult);
    this.setAggregationComponentValue("min", min, gotNumberResult);
    this.setAggregationComponentValue("max", max, gotNumberResult);
    this.setAggregationComponentValue("avg", sum / numberCount, gotNumberResult);
  }
};

// packages/ag-grid-enterprise/src/statusBar/providedPanels/filteredRowsComp.ts
var import_ag_grid_community98 = require("ag-grid-community");
var FilteredRowsComp = class extends AgNameValue {
  postConstruct() {
    this.setLabel("filteredRows", "Filtered");
    if (!(0, import_ag_grid_community98._isClientSideRowModel)(this.gos)) {
      (0, import_ag_grid_community98._warn)(222);
      return;
    }
    this.addCssClass("ag-status-panel");
    this.addCssClass("ag-status-panel-filtered-row-count");
    this.setDisplayed(true);
    const listener = this.onDataChanged.bind(this);
    this.addManagedEventListeners({ modelUpdated: listener });
    listener();
  }
  onDataChanged() {
    const totalRowCountValue = this.getTotalRowCountValue();
    const filteredRowCountValue = this.getFilteredRowCountValue();
    this.setValue((0, import_ag_grid_community98._formatNumberCommas)(filteredRowCountValue, this.getLocaleTextFunc.bind(this)));
    this.setDisplayed(totalRowCountValue !== filteredRowCountValue);
  }
  getTotalRowCountValue() {
    let totalRowCount = 0;
    this.beans.rowModel.forEachNode(() => totalRowCount += 1);
    return totalRowCount;
  }
  getFilteredRowCountValue() {
    let filteredRowCount = 0;
    this.beans.rowModel.forEachNodeAfterFilter((node) => {
      if (!node.group) {
        filteredRowCount += 1;
      }
    });
    return filteredRowCount;
  }
  init() {
  }
  refresh() {
    return true;
  }
};

// packages/ag-grid-enterprise/src/statusBar/providedPanels/selectedRowsComp.ts
var import_ag_grid_community99 = require("ag-grid-community");
var SelectedRowsComp = class extends AgNameValue {
  postConstruct() {
    const gos = this.gos;
    if (!(0, import_ag_grid_community99._isClientSideRowModel)(gos) && !(0, import_ag_grid_community99._isServerSideRowModel)(gos)) {
      (0, import_ag_grid_community99._warn)(223);
      return;
    }
    this.setLabel("selectedRows", "Selected");
    this.addCssClass("ag-status-panel");
    this.addCssClass("ag-status-panel-selected-row-count");
    this.onRowSelectionChanged();
    const eventListener = this.onRowSelectionChanged.bind(this);
    this.addManagedEventListeners({ modelUpdated: eventListener, selectionChanged: eventListener });
  }
  onRowSelectionChanged() {
    const selectedRowCount = this.beans.selectionSvc?.getSelectionCount() ?? 0;
    if (selectedRowCount < 0) {
      this.setValue("?");
      this.setDisplayed(true);
      return;
    }
    this.setValue((0, import_ag_grid_community99._formatNumberCommas)(selectedRowCount, this.getLocaleTextFunc.bind(this)));
    this.setDisplayed(selectedRowCount > 0);
  }
  init() {
  }
  refresh() {
    return true;
  }
};

// packages/ag-grid-enterprise/src/statusBar/providedPanels/totalAndFilteredRowsComp.ts
var import_ag_grid_community100 = require("ag-grid-community");
var TotalAndFilteredRowsComp = class extends AgNameValue {
  postConstruct() {
    if (!(0, import_ag_grid_community100._isClientSideRowModel)(this.gos)) {
      (0, import_ag_grid_community100._warn)(224);
      return;
    }
    this.setLabel("totalAndFilteredRows", "Rows");
    this.addCssClass("ag-status-panel");
    this.addCssClass("ag-status-panel-total-and-filtered-row-count");
    this.setDisplayed(true);
    this.addManagedEventListeners({ modelUpdated: this.onDataChanged.bind(this) });
    this.onDataChanged();
  }
  onDataChanged() {
    const getLocaleTextFunc = this.getLocaleTextFunc.bind(this);
    const rowCount = (0, import_ag_grid_community100._formatNumberCommas)(this.getFilteredRowCountValue(), getLocaleTextFunc);
    const totalRowCount = (0, import_ag_grid_community100._formatNumberCommas)(this.getTotalRowCount(), getLocaleTextFunc);
    if (rowCount === totalRowCount) {
      this.setValue(rowCount);
    } else {
      const localeTextFunc = this.getLocaleTextFunc();
      this.setValue(`${rowCount} ${localeTextFunc("of", "of")} ${totalRowCount}`);
    }
  }
  getFilteredRowCountValue() {
    let filteredRowCount = 0;
    this.beans.rowModel.forEachNodeAfterFilter((node) => {
      if (!node.group) {
        filteredRowCount++;
      }
    });
    return filteredRowCount;
  }
  getTotalRowCount() {
    let totalRowCount = 0;
    this.beans.rowModel.forEachNode((node) => {
      if (!node.group) {
        totalRowCount++;
      }
    });
    return totalRowCount;
  }
  init() {
  }
  refresh() {
    return true;
  }
};

// packages/ag-grid-enterprise/src/statusBar/providedPanels/totalRowsComp.ts
var import_ag_grid_community101 = require("ag-grid-community");
var TotalRowsComp = class extends AgNameValue {
  postConstruct() {
    this.setLabel("totalRows", "Total Rows");
    if (!(0, import_ag_grid_community101._isClientSideRowModel)(this.gos)) {
      (0, import_ag_grid_community101._warn)(225);
      return;
    }
    this.addCssClass("ag-status-panel");
    this.addCssClass("ag-status-panel-total-row-count");
    this.setDisplayed(true);
    this.addManagedEventListeners({ modelUpdated: this.onDataChanged.bind(this) });
    this.onDataChanged();
  }
  onDataChanged() {
    this.setValue((0, import_ag_grid_community101._formatNumberCommas)(this.getRowCountValue(), this.getLocaleTextFunc.bind(this)));
  }
  getRowCountValue() {
    let totalRowCount = 0;
    this.beans.rowModel.forEachLeafNode(() => totalRowCount += 1);
    return totalRowCount;
  }
  init() {
  }
  refresh() {
    return true;
  }
};

// packages/ag-grid-enterprise/src/statusBar/statusBarApi.ts
var import_ag_grid_community102 = require("ag-grid-community");
function getStatusPanel(beans, key) {
  const comp = beans.statusBarSvc?.getStatusPanel(key);
  return (0, import_ag_grid_community102._unwrapUserComp)(comp);
}

// packages/ag-grid-enterprise/src/statusBar/statusBarService.ts
var import_ag_grid_community103 = require("ag-grid-community");
var StatusBarService = class extends import_ag_grid_community103.BeanStub {
  // tslint:disable-next-line
  constructor() {
    super();
    this.beanName = "statusBarSvc";
    this.comps = /* @__PURE__ */ new Map();
  }
  registerStatusPanel(key, component) {
    this.comps.set(key, component);
  }
  unregisterStatusPanel(key) {
    this.comps.delete(key);
  }
  unregisterAllComponents() {
    this.comps.clear();
  }
  getStatusPanel(key) {
    return this.comps.get(key);
  }
  destroy() {
    this.unregisterAllComponents();
    super.destroy();
  }
};

// packages/ag-grid-enterprise/src/statusBar/statusBarModule.ts
var StatusBarModule = {
  moduleName: "StatusBar",
  version: VERSION,
  beans: [StatusBarService],
  userComponents: {
    agAggregationComponent: AggregationComp,
    agTotalRowCountComponent: TotalRowsComp,
    agFilteredRowCountComponent: FilteredRowsComp,
    agTotalAndFilteredRowCountComponent: TotalAndFilteredRowsComp,
    agSelectedRowCountComponent: SelectedRowsComp
  },
  selectors: [AgStatusBarSelector],
  apiFunctions: {
    getStatusPanel
  },
  dependsOn: [EnterpriseCoreModule, import_ag_grid_community104._KeyboardNavigationModule]
};

// packages/ag-grid-enterprise/src/excelExport/excelExportModule.ts
var import_ag_grid_community106 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/excelExport/excelExportApi.ts
var import_ag_grid_community105 = require("ag-grid-community");
function assertNotExcelMultiSheet(beans) {
  if (beans.excelCreator?.getFactoryMode() === "MULTI_SHEET") {
    (0, import_ag_grid_community105._warn)(161);
    return false;
  }
  return true;
}
function getDataAsExcel(beans, params) {
  if (assertNotExcelMultiSheet(beans)) {
    return beans.excelCreator?.getDataAsExcel(params);
  }
  return void 0;
}
function exportDataAsExcel(beans, params) {
  if (assertNotExcelMultiSheet(beans)) {
    beans.excelCreator?.exportDataAsExcel(params);
  }
}
function getSheetDataForExcel(beans, params) {
  beans.excelCreator?.setFactoryMode("MULTI_SHEET");
  return beans.excelCreator?.getSheetDataForExcel(params);
}
function getMultipleSheetsAsExcel2(beans, params) {
  return beans.excelCreator?.getMultipleSheetsAsExcel(params);
}
function exportMultipleSheetsAsExcel2(beans, params) {
  beans.excelCreator?.exportMultipleSheetsAsExcel(params);
}

// packages/ag-grid-enterprise/src/excelExport/excelExportModule.ts
var ExcelExportModule = {
  moduleName: "ExcelExport",
  version: VERSION,
  beans: [ExcelCreator],
  apiFunctions: {
    getDataAsExcel,
    exportDataAsExcel,
    getSheetDataForExcel,
    getMultipleSheetsAsExcel: getMultipleSheetsAsExcel2,
    exportMultipleSheetsAsExcel: exportMultipleSheetsAsExcel2
  },
  dependsOn: [import_ag_grid_community106._SharedExportModule, EnterpriseCoreModule]
};

// packages/ag-grid-enterprise/src/multiFilter/multiFilterModule.ts
var import_ag_grid_community110 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/multiFilter/multiFilter.ts
var import_ag_grid_community108 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/widgets/agGroupComponent.ts
var import_ag_grid_community107 = require("ag-grid-community");
function getAgGroupComponentTemplate(params) {
  const cssIdentifier = params.cssIdentifier || "default";
  const direction = params.direction || "vertical";
  return (
    /* html */
    `
        <div class="ag-group ag-${cssIdentifier}-group" role="presentation">
            <div data-ref="eToolbar" class="ag-group-toolbar ag-${cssIdentifier}-group-toolbar">
                <ag-checkbox data-ref="cbGroupEnabled"></ag-checkbox>
            </div>
            <div data-ref="eContainer" class="ag-group-container ag-group-container-${direction} ag-${cssIdentifier}-group-container"></div>
        </div>
    `
  );
}
var AgGroupComponent = class extends import_ag_grid_community107.Component {
  constructor(params = {}) {
    super(getAgGroupComponentTemplate(params), [import_ag_grid_community107.AgCheckboxSelector]);
    this.params = params;
    this.suppressEnabledCheckbox = true;
    this.suppressToggleExpandOnEnableChange = false;
    this.eToolbar = import_ag_grid_community107.RefPlaceholder;
    this.cbGroupEnabled = import_ag_grid_community107.RefPlaceholder;
    this.eContainer = import_ag_grid_community107.RefPlaceholder;
    const {
      enabled,
      items,
      suppressEnabledCheckbox,
      expanded,
      suppressToggleExpandOnEnableChange,
      useToggle: toggleMode
    } = params;
    this.cssIdentifier = params.cssIdentifier || "default";
    this.enabled = enabled != null ? enabled : true;
    this.items = items || [];
    this.useToggle = toggleMode ?? false;
    this.alignItems = params.alignItems || "center";
    this.expanded = expanded == null ? true : expanded;
    if (suppressEnabledCheckbox != null) {
      this.suppressEnabledCheckbox = suppressEnabledCheckbox;
    }
    if (suppressToggleExpandOnEnableChange != null) {
      this.suppressToggleExpandOnEnableChange = suppressToggleExpandOnEnableChange;
    }
  }
  postConstruct() {
    this.setupTitleBar();
    if (this.items.length) {
      const initialItems = this.items;
      this.items = [];
      this.addItems(initialItems);
    }
    const localeTextFunc = this.getLocaleTextFunc();
    this.cbGroupEnabled.setLabel(localeTextFunc("enabled", "Enabled"));
    if (this.enabled) {
      this.setEnabled(this.enabled, void 0, true);
    }
    this.setAlignItems(this.alignItems);
    const { onEnableChange, onExpandedChange, suppressOpenCloseIcons } = this.params;
    this.hideEnabledCheckbox(this.suppressEnabledCheckbox);
    this.hideOpenCloseIcons(suppressOpenCloseIcons ?? false);
    this.refreshChildDisplay();
    (0, import_ag_grid_community107._setDisplayed)(this.eContainer, this.expanded);
    this.cbGroupEnabled.onValueChange((newSelection) => {
      this.setEnabled(newSelection, true, this.suppressToggleExpandOnEnableChange);
      this.dispatchEnableChangeEvent(newSelection);
    });
    if (onEnableChange != null) {
      this.onEnableChange(onEnableChange);
    }
    if (onExpandedChange != null) {
      this.onExpandedChange(onExpandedChange);
    }
  }
  refreshChildDisplay() {
    (0, import_ag_grid_community107._setDisplayed)(this.eToolbar, this.expanded && !this.suppressEnabledCheckbox);
    this.eTitleBar?.refreshOnExpand(this.expanded);
  }
  isExpanded() {
    return this.expanded;
  }
  setAlignItems(alignment) {
    if (this.alignItems !== alignment) {
      this.removeCssClass(`ag-group-item-alignment-${this.alignItems}`);
    }
    this.alignItems = alignment;
    const newCls = `ag-group-item-alignment-${this.alignItems}`;
    this.addCssClass(newCls);
    return this;
  }
  toggleGroupExpand(expanded, silent) {
    if (this.eTitleBar?.isSuppressCollapse() && !this.useToggle) {
      expanded = true;
      silent = true;
    } else {
      expanded = expanded != null ? expanded : !this.expanded;
      if (this.expanded === expanded) {
        return this;
      }
    }
    this.expanded = expanded;
    this.refreshChildDisplay();
    (0, import_ag_grid_community107._setDisplayed)(this.eContainer, expanded);
    if (!silent) {
      this.dispatchLocalEvent({
        type: expanded ? "expanded" : "collapsed"
      });
    }
    return this;
  }
  addItems(items) {
    items.forEach((item) => this.addItem(item));
  }
  prependItem(item) {
    this.insertItem(item, true);
  }
  addItem(item) {
    this.insertItem(item, false);
  }
  insertItem(item, prepend) {
    const container = this.eContainer;
    const el = item instanceof import_ag_grid_community107.Component ? item.getGui() : item;
    el.classList.add("ag-group-item", `ag-${this.cssIdentifier}-group-item`);
    if (prepend) {
      container.insertAdjacentElement("afterbegin", el);
      this.items.unshift(el);
    } else {
      container.appendChild(el);
      this.items.push(el);
    }
  }
  hideItem(hide, index) {
    const itemToHide = this.items[index];
    (0, import_ag_grid_community107._setDisplayed)(itemToHide, !hide);
  }
  getItemIndex(item) {
    const el = item instanceof import_ag_grid_community107.Component ? item.getGui() : item;
    return this.items.indexOf(el);
  }
  setTitle(title) {
    this.eTitleBar?.setTitle(title);
    return this;
  }
  addTitleBarWidget(el) {
    this.eTitleBar?.addWidget(el);
    return this;
  }
  addCssClassToTitleBar(cssClass) {
    this.eTitleBar?.addCssClass(cssClass);
  }
  dispatchEnableChangeEvent(enabled) {
    const event = {
      type: "enableChange",
      enabled
    };
    this.dispatchLocalEvent(event);
  }
  setEnabled(enabled, skipToggle, skipExpand) {
    this.enabled = enabled;
    this.refreshDisabledStyles();
    if (!skipExpand) {
      this.toggleGroupExpand(enabled);
    }
    if (!skipToggle) {
      this.cbGroupEnabled.setValue(enabled);
      this.eToggle?.setValue(enabled);
    }
    return this;
  }
  isEnabled() {
    return this.enabled;
  }
  onEnableChange(callbackFn) {
    this.addManagedListeners(this, { enableChange: (event) => callbackFn(event.enabled) });
    return this;
  }
  onExpandedChange(callbackFn) {
    this.addManagedListeners(this, {
      expanded: () => callbackFn(true),
      collapsed: () => callbackFn(false)
    });
    return this;
  }
  hideEnabledCheckbox(hide) {
    this.suppressEnabledCheckbox = hide;
    this.refreshChildDisplay();
    this.refreshDisabledStyles();
    return this;
  }
  hideOpenCloseIcons(hide) {
    this.eTitleBar?.hideOpenCloseIcons(hide);
    return this;
  }
  refreshDisabledStyles() {
    const disabled = !this.enabled;
    this.eContainer.classList.toggle("ag-disabled", disabled);
    this.eTitleBar?.refreshDisabledStyles(this.suppressEnabledCheckbox && disabled);
    this.eContainer.classList.toggle("ag-disabled-group-container", disabled);
  }
  setupTitleBar() {
    const titleBar = this.useToggle ? this.createToggleTitleBar() : this.createDefaultTitleBar();
    this.eToolbar.insertAdjacentElement("beforebegin", titleBar.getGui());
  }
  createDefaultTitleBar() {
    const titleBar = this.createManagedBean(new DefaultTitleBar(this.params));
    this.eTitleBar = titleBar;
    titleBar.refreshOnExpand(this.expanded);
    this.addManagedListeners(titleBar, {
      expandedChanged: (event) => this.toggleGroupExpand(event.expanded)
    });
    return titleBar;
  }
  createToggleTitleBar() {
    const eToggle = this.createManagedBean(
      new import_ag_grid_community107.AgToggleButton({
        value: this.enabled,
        label: this.params.title,
        labelAlignment: "left",
        labelWidth: "flex",
        onValueChange: (enabled) => {
          this.setEnabled(enabled, true);
          this.dispatchEnableChangeEvent(enabled);
        }
      })
    );
    eToggle.addCssClass("ag-group-title-bar");
    eToggle.addCssClass(`ag-${this.params.cssIdentifier ?? "default"}-group-title-bar ag-unselectable`);
    this.eToggle = eToggle;
    this.toggleGroupExpand(this.enabled);
    return eToggle;
  }
};
var TITLE_BAR_DISABLED_CLASS = "ag-disabled-group-title-bar";
function getDefaultTitleBarTemplate(params) {
  const cssIdentifier = params.cssIdentifier ?? "default";
  const role = params.suppressKeyboardNavigation ? "presentation" : "role";
  return (
    /* html */
    `
        <div class="ag-group-title-bar ag-${cssIdentifier}-group-title-bar ag-unselectable" role="${role}">
            <span class="ag-group-title-bar-icon ag-${cssIdentifier}-group-title-bar-icon" data-ref="eGroupOpenedIcon" role="presentation"></span>
            <span class="ag-group-title-bar-icon ag-${cssIdentifier}-group-title-bar-icon" data-ref="eGroupClosedIcon" role="presentation"></span>
            <span data-ref="eTitle" class="ag-group-title ag-${cssIdentifier}-group-title"></span>
        </div>
    `
  );
}
var DefaultTitleBar = class extends import_ag_grid_community107.Component {
  constructor(params = {}) {
    super(getDefaultTitleBarTemplate(params));
    this.suppressOpenCloseIcons = false;
    this.suppressKeyboardNavigation = false;
    this.eGroupOpenedIcon = import_ag_grid_community107.RefPlaceholder;
    this.eGroupClosedIcon = import_ag_grid_community107.RefPlaceholder;
    this.eTitle = import_ag_grid_community107.RefPlaceholder;
    const { title, suppressOpenCloseIcons, suppressKeyboardNavigation } = params;
    if (!!title && title.length > 0) {
      this.title = title;
    }
    if (suppressOpenCloseIcons != null) {
      this.suppressOpenCloseIcons = suppressOpenCloseIcons;
    }
    this.suppressKeyboardNavigation = suppressKeyboardNavigation ?? false;
  }
  postConstruct() {
    this.setTitle(this.title);
    this.hideOpenCloseIcons(this.suppressOpenCloseIcons);
    this.setupExpandContract();
  }
  setupExpandContract() {
    this.eGroupClosedIcon.appendChild((0, import_ag_grid_community107._createIcon)("accordionClosed", this.beans, null));
    this.eGroupOpenedIcon.appendChild((0, import_ag_grid_community107._createIcon)("accordionOpen", this.beans, null));
    this.addManagedElementListeners(this.getGui(), {
      click: () => this.dispatchExpandChanged(),
      keydown: (e) => {
        switch (e.key) {
          case import_ag_grid_community107.KeyCode.ENTER:
          case import_ag_grid_community107.KeyCode.SPACE:
            e.preventDefault();
            this.dispatchExpandChanged();
            break;
          case import_ag_grid_community107.KeyCode.RIGHT:
          case import_ag_grid_community107.KeyCode.LEFT:
            e.preventDefault();
            this.dispatchExpandChanged(e.key === import_ag_grid_community107.KeyCode.RIGHT);
            break;
        }
      }
    });
  }
  refreshOnExpand(expanded) {
    this.refreshAriaStatus(expanded);
    this.refreshOpenCloseIcons(expanded);
  }
  refreshAriaStatus(expanded) {
    if (!this.suppressOpenCloseIcons) {
      (0, import_ag_grid_community107._setAriaExpanded)(this.getGui(), expanded);
    }
  }
  refreshOpenCloseIcons(expanded) {
    const showIcon = !this.suppressOpenCloseIcons;
    (0, import_ag_grid_community107._setDisplayed)(this.eGroupOpenedIcon, showIcon && expanded);
    (0, import_ag_grid_community107._setDisplayed)(this.eGroupClosedIcon, showIcon && !expanded);
  }
  isSuppressCollapse() {
    return this.suppressOpenCloseIcons;
  }
  dispatchExpandChanged(expanded) {
    const event = {
      type: "expandedChanged",
      expanded
    };
    this.dispatchLocalEvent(event);
  }
  setTitle(title) {
    const eGui = this.getGui();
    const hasTitle = !!title && title.length > 0;
    title = hasTitle ? title : void 0;
    this.eTitle.textContent = title ?? "";
    (0, import_ag_grid_community107._setDisplayed)(eGui, hasTitle);
    if (title !== this.title) {
      this.title = title;
    }
    const disabled = eGui.classList.contains(TITLE_BAR_DISABLED_CLASS);
    this.refreshDisabledStyles(disabled);
    return this;
  }
  addWidget(el) {
    this.getGui().appendChild(el);
    return this;
  }
  hideOpenCloseIcons(hide) {
    this.suppressOpenCloseIcons = hide;
    if (hide) {
      this.dispatchExpandChanged(true);
    }
    return this;
  }
  refreshDisabledStyles(disabled) {
    const eGui = this.getGui();
    if (disabled) {
      eGui.classList.add(TITLE_BAR_DISABLED_CLASS);
      eGui.removeAttribute("tabindex");
    } else {
      eGui.classList.remove(TITLE_BAR_DISABLED_CLASS);
      if (typeof this.title === "string" && !this.suppressKeyboardNavigation) {
        eGui.setAttribute("tabindex", "0");
      } else {
        eGui.removeAttribute("tabindex");
      }
    }
  }
};
var AgGroupComponentSelector = {
  selector: "AG-GROUP-COMPONENT",
  component: AgGroupComponent
};

// packages/ag-grid-enterprise/src/multiFilter/multiFilter.ts
function getMultiFilterDefs(params) {
  const { filters } = params;
  return filters && filters.length > 0 ? filters : [{ filter: "agTextColumnFilter" }, { filter: "agSetColumnFilter" }];
}
function _forEachReverse(list, action) {
  if (list == null) {
    return;
  }
  for (let i = list.length - 1; i >= 0; i--) {
    action(list[i], i);
  }
}
function getFilterTitle(filter, filterDef) {
  if (filterDef.title != null) {
    return filterDef.title;
  }
  return filter instanceof import_ag_grid_community108.ProvidedFilter ? filter.getFilterTitle() : "Filter";
}
var MultiFilter = class extends import_ag_grid_community108.TabGuardComp {
  constructor() {
    super(
      /* html */
      `<div class="ag-multi-filter ag-menu-list-compact"></div>`
    );
    this.filterType = "multi";
    this.filterDefs = [];
    this.filters = [];
    this.guiDestroyFuncs = [];
    // this could be the accordion/sub menu element depending on the display type
    this.filterGuis = [];
    this.activeFilterIndices = [];
    this.lastActivatedMenuItem = null;
    this.afterFiltersReadyFuncs = [];
  }
  postConstruct() {
    this.initialiseTabGuard({
      onFocusIn: (e) => this.onFocusIn(e)
    });
  }
  init(params) {
    this.params = params;
    this.filterDefs = getMultiFilterDefs(params);
    const { column, filterChangedCallback } = params;
    this.column = column;
    this.filterChangedCallback = filterChangedCallback;
    const filterPromises = [];
    this.filterDefs.forEach((filterDef, index) => {
      const filterPromise = this.createFilter(filterDef, index);
      if (filterPromise != null) {
        filterPromises.push(filterPromise);
      }
    });
    return new import_ag_grid_community108.AgPromise((resolve) => {
      import_ag_grid_community108.AgPromise.all(filterPromises).then((filters) => {
        this.filters = filters;
        this.refreshGui("columnMenu").then(() => {
          resolve();
        });
      });
    }).then(() => {
      this.afterFiltersReadyFuncs.forEach((f) => f());
      this.afterFiltersReadyFuncs.length = 0;
    });
  }
  refreshGui(container) {
    if (container === this.lastOpenedInContainer) {
      return import_ag_grid_community108.AgPromise.resolve();
    }
    this.tabGuardFeature.removeAllChildrenExceptTabGuards();
    this.destroyChildren();
    return import_ag_grid_community108.AgPromise.all(
      this.filters.map((filter, index) => {
        const filterDef = this.filterDefs[index];
        const filterTitle = getFilterTitle(filter, filterDef);
        let filterGuiPromise;
        if (filterDef.display === "subMenu" && container !== "toolPanel") {
          filterGuiPromise = this.insertFilterMenu(filter, filterTitle).then(
            (menuItem) => menuItem.getGui()
          );
        } else if (filterDef.display === "subMenu" || filterDef.display === "accordion") {
          const group = this.insertFilterGroup(filter, filterTitle);
          filterGuiPromise = import_ag_grid_community108.AgPromise.resolve(group.getGui());
        } else {
          filterGuiPromise = import_ag_grid_community108.AgPromise.resolve(filter.getGui());
        }
        return filterGuiPromise;
      })
    ).then((filterGuis) => {
      filterGuis.forEach((filterGui, index) => {
        if (index > 0) {
          this.appendChild((0, import_ag_grid_community108._loadTemplate)(
            /* html */
            `<div class="ag-filter-separator"></div>`
          ));
        }
        this.appendChild(filterGui);
      });
      this.filterGuis = filterGuis;
      this.lastOpenedInContainer = container;
    });
  }
  destroyChildren() {
    this.guiDestroyFuncs.forEach((func) => func());
    this.guiDestroyFuncs.length = 0;
    this.filterGuis.length = 0;
  }
  insertFilterMenu(filter, name) {
    const menuItem = this.createBean(new AgMenuItemComponent());
    return menuItem.init({
      menuItemDef: {
        name,
        subMenu: [],
        subMenuRole: "dialog",
        cssClasses: ["ag-multi-filter-menu-item"],
        menuItem: AgMenuItemRenderer,
        menuItemParams: {
          cssClassPrefix: "ag-compact-menu-option",
          isCompact: true
        }
      },
      level: 0,
      isAnotherSubMenuOpen: () => false,
      childComponent: filter,
      contextParams: {
        column: null,
        node: null,
        value: null
      }
    }).then(() => {
      menuItem.setParentComponent(this);
      this.guiDestroyFuncs.push(() => this.destroyBean(menuItem));
      this.addManagedListeners(menuItem, {
        menuItemActivated: (event) => {
          if (this.lastActivatedMenuItem && this.lastActivatedMenuItem !== event.menuItem) {
            this.lastActivatedMenuItem.deactivate();
          }
          this.lastActivatedMenuItem = event.menuItem;
        }
      });
      const menuItemGui = menuItem.getGui();
      menuItem.addManagedElementListeners(menuItemGui, {
        // `AgMenuList` normally handles keyboard navigation, so need to do here
        keydown: (e) => {
          const { key } = e;
          switch (key) {
            case import_ag_grid_community108.KeyCode.UP:
            case import_ag_grid_community108.KeyCode.RIGHT:
            case import_ag_grid_community108.KeyCode.DOWN:
            case import_ag_grid_community108.KeyCode.LEFT:
              e.preventDefault();
              if (key === import_ag_grid_community108.KeyCode.RIGHT) {
                menuItem.openSubMenu(true);
              }
              break;
          }
        },
        focusin: () => menuItem.activate(),
        focusout: () => {
          if (!menuItem.isSubMenuOpen() && !menuItem.isSubMenuOpening()) {
            menuItem.deactivate();
          }
        }
      });
      return menuItem;
    });
  }
  insertFilterGroup(filter, title) {
    const group = this.createBean(
      new AgGroupComponent({
        title,
        cssIdentifier: "multi-filter"
      })
    );
    this.guiDestroyFuncs.push(() => this.destroyBean(group));
    group.addItem(filter.getGui());
    group.toggleGroupExpand(false);
    if (filter.afterGuiAttached) {
      group.addManagedListeners(group, {
        expanded: () => filter.afterGuiAttached({
          container: this.lastOpenedInContainer,
          suppressFocus: true,
          hidePopup: this.hidePopup
        })
      });
    }
    return group;
  }
  isFilterActive() {
    return this.filters.some((filter) => filter.isFilterActive());
  }
  getLastActiveFilterIndex() {
    const activeFilterIndices = this.activeFilterIndices;
    return activeFilterIndices.length > 0 ? activeFilterIndices[activeFilterIndices.length - 1] : null;
  }
  doesFilterPass(params, filterToSkip) {
    let rowPasses = true;
    this.filters.forEach((filter) => {
      if (!rowPasses || filter === filterToSkip || !filter.isFilterActive()) {
        return;
      }
      rowPasses = filter.doesFilterPass(params);
    });
    return rowPasses;
  }
  getModelFromUi() {
    const model = {
      filterType: this.filterType,
      filterModels: this.filters.map((filter) => {
        const providedFilter = filter;
        if (typeof providedFilter.getModelFromUi === "function") {
          return providedFilter.getModelFromUi();
        }
        return null;
      })
    };
    return model;
  }
  getModel() {
    if (!this.isFilterActive()) {
      return null;
    }
    const model = {
      filterType: this.filterType,
      filterModels: this.filters.map((filter) => {
        if (filter.isFilterActive()) {
          return filter.getModel();
        }
        return null;
      })
    };
    return model;
  }
  setModel(model) {
    const setFilterModel = (filter, filterModel) => {
      return new import_ag_grid_community108.AgPromise((resolve) => {
        const promise = filter.setModel(filterModel);
        promise ? promise.then(() => resolve()) : resolve();
      });
    };
    let promises = [];
    if (model == null) {
      promises = this.filters.map((filter, index) => {
        const res = setFilterModel(filter, null).then(() => {
          this.updateActiveList(index);
        });
        return res;
      });
    } else {
      this.filters.forEach((filter, index) => {
        const filterModel = model.filterModels.length > index ? model.filterModels[index] : null;
        const res = setFilterModel(filter, filterModel).then(() => {
          this.updateActiveList(index);
        });
        promises.push(res);
      });
    }
    return import_ag_grid_community108.AgPromise.all(promises).then(() => {
    });
  }
  applyModel(source = "api") {
    let result = false;
    this.filters.forEach((filter) => {
      if (filter instanceof import_ag_grid_community108.ProvidedFilter) {
        result = filter.applyModel(source) || result;
      }
    });
    return result;
  }
  getChildFilterInstance(index) {
    return this.filters[index];
  }
  afterGuiAttached(params) {
    let refreshPromise;
    if (params) {
      this.hidePopup = params.hidePopup;
      refreshPromise = this.refreshGui(params.container);
    } else {
      this.hidePopup = void 0;
      refreshPromise = import_ag_grid_community108.AgPromise.resolve();
    }
    const suppressFocus = params?.suppressFocus;
    refreshPromise.then(() => {
      const { filterDefs, filters, filterGuis, beans } = this;
      let hasFocused = !!suppressFocus;
      if (filterDefs) {
        _forEachReverse(filterDefs, (filterDef, index) => {
          const isFirst = index === 0;
          const notInlineDisplayType = filterDef.display && filterDef.display !== "inline";
          const suppressFocusForFilter = suppressFocus || !isFirst || notInlineDisplayType;
          const afterGuiAttachedParams = { ...params ?? {}, suppressFocus: suppressFocusForFilter };
          const filter = filters?.[index];
          if (filter) {
            this.executeFunctionIfExistsOnFilter(filter, "afterGuiAttached", afterGuiAttachedParams);
            if (isFirst && !suppressFocusForFilter) {
              hasFocused = true;
            }
          }
          if (!suppressFocus && isFirst && notInlineDisplayType) {
            const filterGui = filterGuis[index];
            if (filterGui) {
              if (!(0, import_ag_grid_community108._focusInto)(filterGui)) {
                filterGui.focus({ preventScroll: true });
              }
              hasFocused = true;
            }
          }
        });
      }
      const activeEl = (0, import_ag_grid_community108._getActiveDomElement)(beans);
      if (!hasFocused && ((0, import_ag_grid_community108._isNothingFocused)(beans) || this.getGui().contains(activeEl))) {
        this.forceFocusOutOfContainer(true);
      }
    });
  }
  afterGuiDetached() {
    this.executeFunctionIfExists("afterGuiDetached");
  }
  onAnyFilterChanged() {
    this.executeFunctionIfExists("onAnyFilterChanged");
  }
  onNewRowsLoaded() {
    this.executeFunctionIfExists("onNewRowsLoaded");
  }
  destroy() {
    this.filters.forEach((filter) => this.destroyBean(filter));
    this.filters.length = 0;
    this.destroyChildren();
    this.hidePopup = void 0;
    super.destroy();
  }
  executeFunctionIfExists(name, ...params) {
    _forEachReverse(this.filters, (filter) => {
      this.executeFunctionIfExistsOnFilter(filter, name, params);
    });
  }
  executeFunctionIfExistsOnFilter(filter, name, ...params) {
    const func = filter[name];
    if (typeof func === "function") {
      func.apply(filter, params);
    }
  }
  createFilter(filterDef, index) {
    const { filterModifiedCallback, doesRowPassOtherFilter } = this.params;
    const { filterManager, userCompFactory } = this.beans;
    let filterInstance;
    const filterParams = {
      ...filterManager.createFilterParams(this.column, this.column.getColDef()),
      filterModifiedCallback,
      filterChangedCallback: (additionalEventAttributes) => {
        this.executeWhenAllFiltersReady(() => this.filterChanged(index, additionalEventAttributes));
      },
      doesRowPassOtherFilter: (node) => doesRowPassOtherFilter(node) && this.doesFilterPass({ node, data: node.data }, filterInstance)
    };
    const compDetails = (0, import_ag_grid_community108._getFilterDetails)(userCompFactory, filterDef, filterParams, "agTextColumnFilter");
    if (!compDetails) {
      return null;
    }
    const filterPromise = compDetails.newAgStackInstance();
    filterPromise.then((filter) => {
      if (!filter) {
        return;
      }
      filterInstance = filter;
      if (filterDef.display === "subMenu") {
        const eGui = filter.getGui();
        (0, import_ag_grid_community108._setAriaRole)(eGui, "dialog");
      }
    });
    return filterPromise;
  }
  executeWhenAllFiltersReady(action) {
    if ((this.filters?.length ?? 0) > 0) {
      action();
    } else {
      this.afterFiltersReadyFuncs.push(action);
    }
  }
  updateActiveList(index) {
    const { filters, activeFilterIndices } = this;
    const changedFilter = filters[index];
    (0, import_ag_grid_community108._removeFromArray)(activeFilterIndices, index);
    if (changedFilter.isFilterActive()) {
      activeFilterIndices.push(index);
    }
  }
  filterChanged(index, additionalEventAttributes) {
    this.updateActiveList(index);
    this.filterChangedCallback(additionalEventAttributes);
    const changedFilter = this.filters[index];
    this.filters.forEach((filter) => {
      if (filter === changedFilter) {
        return;
      }
      if (typeof filter.onAnyFilterChanged === "function") {
        filter.onAnyFilterChanged();
      }
    });
  }
  onFocusIn(e) {
    const lastActivatedMenuItem = this.lastActivatedMenuItem;
    if (lastActivatedMenuItem != null && !lastActivatedMenuItem.getGui().contains(e.target)) {
      lastActivatedMenuItem.deactivate();
      this.lastActivatedMenuItem = null;
    }
  }
  getModelAsString(model) {
    if (!this.filters || !model?.filterModels?.length) {
      return "";
    }
    const lastActiveIndex = this.getLastActiveFilterIndex() ?? 0;
    const activeFilter = this.filters[lastActiveIndex];
    return activeFilter.getModelAsString?.(model.filterModels[lastActiveIndex]) ?? "";
  }
};

// packages/ag-grid-enterprise/src/multiFilter/multiFloatingFilter.ts
var import_ag_grid_community109 = require("ag-grid-community");
var MultiFloatingFilterComp = class extends import_ag_grid_community109.Component {
  constructor() {
    super(
      /* html */
      `<div class="ag-multi-floating-filter ag-floating-filter-input"></div>`
    );
    this.floatingFilters = [];
    this.compDetailsList = [];
  }
  init(params) {
    this.params = params;
    const { compDetailsList } = this.getCompDetailsList(params);
    return this.setParams(compDetailsList);
  }
  setParams(compDetailsList) {
    const floatingFilterPromises = [];
    compDetailsList.forEach((compDetails) => {
      const floatingFilterPromise = compDetails?.newAgStackInstance();
      if (floatingFilterPromise != null) {
        this.compDetailsList.push(compDetails);
        floatingFilterPromises.push(floatingFilterPromise);
      }
    });
    return import_ag_grid_community109.AgPromise.all(floatingFilterPromises).then((floatingFilters) => {
      floatingFilters.forEach((floatingFilter, index) => {
        this.floatingFilters.push(floatingFilter);
        const gui = floatingFilter.getGui();
        this.appendChild(gui);
        if (index > 0) {
          (0, import_ag_grid_community109._setDisplayed)(gui, false);
        }
      });
    });
  }
  refresh(params) {
    this.params = params;
    const { compDetailsList: newCompDetailsList, floatingFilterParamsList } = this.getCompDetailsList(params);
    const allFloatingFilterCompsUnchanged = newCompDetailsList.length === this.compDetailsList.length && newCompDetailsList.every(
      (newCompDetails, index) => !this.beans.filterManager?.areFilterCompsDifferent(this.compDetailsList[index], newCompDetails)
    );
    if (allFloatingFilterCompsUnchanged) {
      floatingFilterParamsList.forEach((floatingFilterParams, index) => {
        const floatingFilter = this.floatingFilters[index];
        floatingFilter.refresh?.(floatingFilterParams);
      });
    } else {
      (0, import_ag_grid_community109._clearElement)(this.getGui());
      this.destroyBeans(this.floatingFilters);
      this.floatingFilters = [];
      this.compDetailsList = [];
      this.setParams(newCompDetailsList);
    }
  }
  getCompDetailsList(params) {
    const compDetailsList = [];
    const floatingFilterParamsList = [];
    const filterParams = params.filterParams;
    const currentParentModel = params.currentParentModel;
    getMultiFilterDefs(filterParams).forEach((filterDef, index) => {
      const floatingFilterParams = {
        ...params,
        // set the parent filter instance for each floating filter to the relevant child filter instance
        parentFilterInstance: (callback) => {
          this.parentMultiFilterInstance((parent) => {
            const child = parent.getChildFilterInstance(index);
            if (child == null) {
              return;
            }
            callback(child);
          });
        },
        // return the parent model for the specific filter
        currentParentModel: () => currentParentModel()?.filterModels?.[index] ?? null
      };
      (0, import_ag_grid_community109._mergeDeep)(floatingFilterParams.filterParams, filterDef.filterParams);
      const compDetails = this.getCompDetails(filterDef, floatingFilterParams);
      if (compDetails) {
        compDetailsList.push(compDetails);
        floatingFilterParamsList.push(floatingFilterParams);
      }
    });
    return { compDetailsList, floatingFilterParamsList };
  }
  onParentModelChanged(model, event) {
    if (event && event.afterFloatingFilter) {
      return;
    }
    this.parentMultiFilterInstance((parent) => {
      if (model == null) {
        this.floatingFilters.forEach((filter, i) => {
          filter.onParentModelChanged(null, event);
          (0, import_ag_grid_community109._setDisplayed)(filter.getGui(), i === 0);
        });
      } else {
        const lastActiveFloatingFilterIndex = parent.getLastActiveFilterIndex();
        this.floatingFilters.forEach((filter, i) => {
          const filterModel = model.filterModels.length > i ? model.filterModels[i] : null;
          filter.onParentModelChanged(filterModel, event);
          const shouldShow = lastActiveFloatingFilterIndex == null ? i === 0 : i === lastActiveFloatingFilterIndex;
          (0, import_ag_grid_community109._setDisplayed)(filter.getGui(), shouldShow);
        });
      }
    });
  }
  destroy() {
    this.destroyBeans(this.floatingFilters);
    this.floatingFilters.length = 0;
    super.destroy();
  }
  getCompDetails(filterDef, params) {
    const { filterManager, frameworkOverrides, userCompFactory } = this.beans;
    const defaultComponentName = (0, import_ag_grid_community109._getDefaultFloatingFilterType)(
      frameworkOverrides,
      filterDef,
      () => filterManager.getDefaultFloatingFilter(this.params.column)
    ) ?? "agReadOnlyFloatingFilter";
    return (0, import_ag_grid_community109._getFloatingFilterCompDetails)(userCompFactory, filterDef, params, defaultComponentName);
  }
  parentMultiFilterInstance(cb) {
    this.params.parentFilterInstance((parent) => {
      if (!(parent instanceof MultiFilter)) {
        (0, import_ag_grid_community109._error)(120);
      }
      cb(parent);
    });
  }
};

// packages/ag-grid-enterprise/src/multiFilter/multiFilterModule.ts
var MultiFilterModule = {
  moduleName: "MultiFilter",
  version: VERSION,
  userComponents: { agMultiColumnFilter: MultiFilter, agMultiColumnFloatingFilter: MultiFloatingFilterComp },
  dependsOn: [EnterpriseCoreModule, import_ag_grid_community110._ColumnFilterModule, MenuItemModule]
};

// packages/ag-grid-enterprise/src/rowGrouping/rowGroupingModule.ts
var import_ag_grid_community134 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/aggregation/aggColumnNameService.ts
var import_ag_grid_community111 = require("ag-grid-community");
var AggColumnNameService = class extends import_ag_grid_community111.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "aggColNameSvc";
  }
  getHeaderName(column, headerName) {
    if (this.gos.get("suppressAggFuncInHeader")) {
      return headerName;
    }
    const { valueColsSvc, colModel, rowGroupColsSvc } = this.beans;
    const pivotValueColumn = column.getColDef().pivotValueColumn;
    const pivotActiveOnThisColumn = (0, import_ag_grid_community111._exists)(pivotValueColumn);
    let aggFunc = null;
    let aggFuncFound;
    if (pivotActiveOnThisColumn) {
      const valueColumns = valueColsSvc?.columns ?? [];
      const isCollapsedHeaderEnabled = this.gos.get("removePivotHeaderRowWhenSingleValueColumn") && valueColumns.length === 1;
      const isTotalColumn = column.getColDef().pivotTotalColumnIds !== void 0;
      if (isCollapsedHeaderEnabled && !isTotalColumn) {
        return headerName;
      }
      aggFunc = pivotValueColumn ? pivotValueColumn.getAggFunc() : null;
      aggFuncFound = true;
    } else {
      const measureActive = column.isValueActive();
      const aggregationPresent = colModel.isPivotMode() || rowGroupColsSvc?.columns.length !== 0;
      if (measureActive && aggregationPresent) {
        aggFunc = column.getAggFunc();
        aggFuncFound = true;
      } else {
        aggFuncFound = false;
      }
    }
    if (aggFuncFound) {
      const aggFuncString = typeof aggFunc === "string" ? aggFunc : "func";
      const localeTextFunc = this.getLocaleTextFunc();
      const aggFuncStringTranslated = localeTextFunc(aggFuncString, aggFuncString);
      return `${aggFuncStringTranslated}(${headerName})`;
    }
    return headerName;
  }
};

// packages/ag-grid-enterprise/src/aggregation/aggFuncService.ts
var import_ag_grid_community112 = require("ag-grid-community");
var defaultAggFuncNames = {
  sum: "Sum",
  first: "First",
  last: "Last",
  min: "Min",
  max: "Max",
  count: "Count",
  avg: "Average"
};
var AggFuncService = class extends import_ag_grid_community112.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "aggFuncSvc";
    this.aggFuncsMap = {};
    this.initialised = false;
  }
  postConstruct() {
    this.init();
  }
  init() {
    if (this.initialised) {
      return;
    }
    this.initialiseWithDefaultAggregations();
    this.addAggFuncs(this.gos.get("aggFuncs"));
  }
  initialiseWithDefaultAggregations() {
    const aggMap = this.aggFuncsMap;
    aggMap["sum"] = aggSum;
    aggMap["first"] = aggFirst;
    aggMap["last"] = aggLast;
    aggMap["min"] = aggMin;
    aggMap["max"] = aggMax;
    aggMap["count"] = aggCount;
    aggMap["avg"] = aggAvg;
    this.initialised = true;
  }
  isAggFuncPossible(column, func) {
    const allKeys = this.getFuncNames(column);
    const allowed = allKeys.includes(func);
    const funcExists = (0, import_ag_grid_community112._exists)(this.aggFuncsMap[func]);
    return allowed && funcExists;
  }
  getDefaultFuncLabel(fctName) {
    return defaultAggFuncNames[fctName] ?? fctName;
  }
  getDefaultAggFunc(column) {
    const defaultAgg = column.getColDef().defaultAggFunc;
    if ((0, import_ag_grid_community112._exists)(defaultAgg) && this.isAggFuncPossible(column, defaultAgg)) {
      return defaultAgg;
    }
    if (this.isAggFuncPossible(column, "sum")) {
      return "sum";
    }
    const allKeys = this.getFuncNames(column);
    return allKeys?.length ? allKeys[0] : null;
  }
  addAggFuncs(aggFuncs) {
    this.init();
    if (!aggFuncs) {
      return;
    }
    for (const key of Object.keys(aggFuncs)) {
      this.aggFuncsMap[key] = aggFuncs[key];
    }
  }
  getAggFunc(name) {
    this.init();
    return this.aggFuncsMap[name];
  }
  getFuncNames(column) {
    const userAllowedFuncs = column.getColDef().allowedAggFuncs;
    return userAllowedFuncs == null ? Object.keys(this.aggFuncsMap).sort() : userAllowedFuncs;
  }
  clear() {
    this.aggFuncsMap = {};
  }
};
function aggSum(params) {
  const { values } = params;
  let result = null;
  for (let i = 0; i < values.length; i++) {
    const value = values[i];
    if (typeof value === "number") {
      if (result === null) {
        result = value;
      } else {
        result += typeof result === "number" ? value : BigInt(value);
      }
    } else if (typeof value === "bigint") {
      if (result === null) {
        result = value;
      } else {
        result = (typeof result === "bigint" ? result : BigInt(result)) + value;
      }
    }
  }
  return result;
}
function aggFirst(params) {
  return params.values.length > 0 ? params.values[0] : null;
}
function aggLast(params) {
  return params.values.length > 0 ? (0, import_ag_grid_community112._last)(params.values) : null;
}
function aggMin(params) {
  const { values } = params;
  let result = null;
  for (let i = 0; i < values.length; i++) {
    const value = values[i];
    if ((typeof value === "number" || typeof value === "bigint") && (result === null || result > value)) {
      result = value;
    }
  }
  return result;
}
function aggMax(params) {
  const { values } = params;
  let result = null;
  for (let i = 0; i < values.length; i++) {
    const value = values[i];
    if ((typeof value === "number" || typeof value === "bigint") && (result === null || result < value)) {
      result = value;
    }
  }
  return result;
}
function aggCount(params) {
  const { values } = params;
  let result = 0;
  for (let i = 0; i < values.length; i++) {
    const value = values[i];
    result += value != null && typeof value.value === "number" ? value.value : 1;
  }
  const existingAggData = params.rowNode?.aggData?.[params.column.getColId()];
  if (existingAggData && existingAggData.value === result) {
    return existingAggData;
  }
  return {
    value: result,
    toString: function() {
      return this.value.toString();
    },
    // used for sorting
    toNumber: function() {
      return this.value;
    }
  };
}
function aggAvg(params) {
  const { values } = params;
  let sum = 0;
  let count = 0;
  for (let i = 0; i < values.length; i++) {
    const currentValue = values[i];
    let valueToAdd = null;
    if (typeof currentValue === "number" || typeof currentValue === "bigint") {
      valueToAdd = currentValue;
      count++;
    } else if (currentValue != null && (typeof currentValue.value === "number" || typeof currentValue.value === "bigint") && typeof currentValue.count === "number") {
      valueToAdd = currentValue.value * (typeof currentValue.value === "number" ? currentValue.count : BigInt(currentValue.count));
      count += currentValue.count;
    }
    if (typeof valueToAdd === "number") {
      sum += typeof sum === "number" ? valueToAdd : BigInt(valueToAdd);
    } else if (typeof valueToAdd === "bigint") {
      sum = (typeof sum === "bigint" ? sum : BigInt(sum)) + valueToAdd;
    }
  }
  let value = null;
  if (count > 0) {
    value = sum / (typeof sum === "number" ? count : BigInt(count));
  }
  const existingAggData = params.rowNode?.aggData?.[params.column?.getColId()];
  if (existingAggData && existingAggData.count === count && existingAggData.value === value) {
    return existingAggData;
  }
  return {
    count,
    value,
    // the grid by default uses toString to render values for an object, so this
    // is a trick to get the default cellRenderer to display the avg value
    toString: function() {
      return typeof this.value === "number" || typeof this.value === "bigint" ? this.value.toString() : "";
    },
    // used for sorting
    toNumber: function() {
      return this.value;
    }
  };
}

// packages/ag-grid-enterprise/src/aggregation/aggregationApi.ts
function addAggFuncs(beans, aggFuncs) {
  if (beans.aggFuncSvc) {
    beans.aggFuncSvc.addAggFuncs(aggFuncs);
  }
}
function clearAggFuncs(beans) {
  if (beans.aggFuncSvc) {
    beans.aggFuncSvc.clear();
  }
}
function setColumnAggFunc(beans, key, aggFunc) {
  beans.valueColsSvc?.setColumnAggFunc?.(key, aggFunc, "api");
}

// packages/ag-grid-enterprise/src/aggregation/aggregationStage.ts
var import_ag_grid_community113 = require("ag-grid-community");
var AggregationStage = class extends import_ag_grid_community113.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "aggStage";
    this.refreshProps = /* @__PURE__ */ new Set([
      "getGroupRowAgg",
      "alwaysAggregateAtRootLevel",
      "suppressAggFilteredOnly",
      "grandTotalRow"
    ]);
    this.step = "aggregate";
  }
  wireBeans(beans) {
    this.colModel = beans.colModel;
    this.aggFuncSvc = beans.aggFuncSvc;
    this.pivotColsSvc = beans.pivotColsSvc;
    this.valueColsSvc = beans.valueColsSvc;
    this.pivotResultCols = beans.pivotResultCols;
    this.valueSvc = beans.valueSvc;
  }
  // it's possible to recompute the aggregate without doing the other parts
  // + api.refreshClientSideRowModel('aggregate')
  execute(params) {
    const noValueColumns = !this.valueColsSvc?.columns?.length;
    const noUserAgg = !this.gos.getCallback("getGroupRowAgg");
    if (noValueColumns && noUserAgg && params.changedPath?.active) {
      return;
    }
    const aggDetails = this.createAggDetails(params);
    this.recursivelyCreateAggData(aggDetails);
  }
  createAggDetails(params) {
    const pivotActive = this.colModel.isPivotActive();
    const measureColumns = this.valueColsSvc?.columns;
    const pivotColumns = pivotActive && this.pivotColsSvc ? this.pivotColsSvc.columns : [];
    const aggDetails = {
      alwaysAggregateAtRootLevel: this.gos.get("alwaysAggregateAtRootLevel"),
      groupIncludeTotalFooter: !!(0, import_ag_grid_community113._getGrandTotalRow)(this.gos),
      changedPath: params.changedPath,
      valueColumns: measureColumns ?? [],
      pivotColumns,
      filteredOnly: !this.isSuppressAggFilteredOnly(),
      userAggFunc: this.gos.getCallback("getGroupRowAgg")
    };
    return aggDetails;
  }
  isSuppressAggFilteredOnly() {
    const isGroupAggFiltering = (0, import_ag_grid_community113._getGroupAggFiltering)(this.gos) !== void 0;
    return isGroupAggFiltering || this.gos.get("suppressAggFilteredOnly");
  }
  recursivelyCreateAggData(aggDetails) {
    const callback = (rowNode) => {
      const hasNoChildren = !rowNode.hasChildren();
      if (hasNoChildren) {
        if (rowNode.aggData) {
          this.setAggData(rowNode, null);
        }
        return;
      }
      const isRootNode = rowNode.level === -1;
      if (isRootNode && !aggDetails.groupIncludeTotalFooter) {
        const notPivoting = !this.colModel.isPivotMode();
        if (!aggDetails.alwaysAggregateAtRootLevel && notPivoting) {
          this.setAggData(rowNode, null);
          return;
        }
      }
      this.aggregateRowNode(rowNode, aggDetails);
    };
    aggDetails.changedPath.forEachChangedNodeDepthFirst(callback, true);
  }
  aggregateRowNode(rowNode, aggDetails) {
    const measureColumnsMissing = aggDetails.valueColumns.length === 0;
    const pivotColumnsMissing = aggDetails.pivotColumns.length === 0;
    let aggResult;
    if (aggDetails.userAggFunc) {
      aggResult = aggDetails.userAggFunc({ nodes: rowNode.childrenAfterFilter });
    } else if (measureColumnsMissing) {
      aggResult = null;
    } else if (pivotColumnsMissing) {
      aggResult = this.aggregateRowNodeUsingValuesOnly(rowNode, aggDetails);
    } else {
      aggResult = this.aggregateRowNodeUsingValuesAndPivot(rowNode);
    }
    this.setAggData(rowNode, aggResult);
    if (rowNode.sibling) {
      this.setAggData(rowNode.sibling, aggResult);
    }
  }
  aggregateRowNodeUsingValuesAndPivot(rowNode) {
    const result = {};
    const secondaryColumns = this.pivotResultCols?.getPivotResultCols()?.list ?? [];
    let canSkipTotalColumns = true;
    for (let i = 0; i < secondaryColumns.length; i++) {
      const secondaryCol = secondaryColumns[i];
      const colDef = secondaryCol.getColDef();
      if (colDef.pivotTotalColumnIds != null) {
        canSkipTotalColumns = false;
        continue;
      }
      const keys = colDef.pivotKeys ?? [];
      let values;
      if (rowNode.leafGroup) {
        values = this.getValuesFromMappedSet(rowNode.childrenMapped, keys, colDef.pivotValueColumn);
      } else {
        values = this.getValuesPivotNonLeaf(rowNode, colDef.colId);
      }
      result[colDef.colId] = this.aggregateValues(
        values,
        colDef.pivotValueColumn.getAggFunc(),
        colDef.pivotValueColumn,
        rowNode,
        secondaryCol
      );
    }
    if (!canSkipTotalColumns) {
      for (let i = 0; i < secondaryColumns.length; i++) {
        const secondaryCol = secondaryColumns[i];
        const colDef = secondaryCol.getColDef();
        if (colDef.pivotTotalColumnIds == null || !colDef.pivotTotalColumnIds.length) {
          continue;
        }
        const aggResults = colDef.pivotTotalColumnIds.map(
          (currentColId) => result[currentColId]
        );
        result[colDef.colId] = this.aggregateValues(
          aggResults,
          colDef.pivotValueColumn.getAggFunc(),
          colDef.pivotValueColumn,
          rowNode,
          secondaryCol
        );
      }
    }
    return result;
  }
  aggregateRowNodeUsingValuesOnly(rowNode, aggDetails) {
    const result = {};
    const { changedPath, valueColumns, filteredOnly } = aggDetails;
    const changedValueColumns = changedPath.active ? changedPath.getValueColumnsForNode(rowNode, valueColumns) : valueColumns;
    const notChangedValueColumns = changedPath.active ? changedPath.getNotValueColumnsForNode(rowNode, valueColumns) : null;
    const values2d = this.getValuesNormal(rowNode, changedValueColumns, filteredOnly);
    const oldValues = rowNode.aggData;
    changedValueColumns.forEach((valueColumn, index) => {
      result[valueColumn.getId()] = this.aggregateValues(
        values2d[index],
        valueColumn.getAggFunc(),
        valueColumn,
        rowNode
      );
    });
    if (notChangedValueColumns && oldValues) {
      notChangedValueColumns.forEach((valueColumn) => {
        result[valueColumn.getId()] = oldValues[valueColumn.getId()];
      });
    }
    return result;
  }
  getValuesPivotNonLeaf(rowNode, colId) {
    return rowNode.childrenAfterFilter.map((childNode) => childNode.aggData[colId]);
  }
  getValuesFromMappedSet(mappedSet, keys, valueColumn) {
    let mapPointer = mappedSet;
    for (let i = 0; i < keys.length; i++) {
      const key = keys[i];
      mapPointer = mapPointer ? mapPointer[key] : null;
    }
    if (!mapPointer) {
      return [];
    }
    return mapPointer.map((rowNode) => this.valueSvc.getValue(valueColumn, rowNode));
  }
  getValuesNormal(rowNode, valueColumns, filteredOnly) {
    const values = [];
    valueColumns.forEach(() => values.push([]));
    const valueColumnCount = valueColumns.length;
    const nodeList = filteredOnly ? rowNode.childrenAfterFilter : rowNode.childrenAfterGroup;
    const rowCount = nodeList.length;
    for (let i = 0; i < rowCount; i++) {
      const childNode = nodeList[i];
      for (let j = 0; j < valueColumnCount; j++) {
        const valueColumn = valueColumns[j];
        const value = this.valueSvc.getValue(valueColumn, childNode);
        values[j].push(value);
      }
    }
    return values;
  }
  aggregateValues(values, aggFuncOrString, column, rowNode, pivotResultColumn) {
    const aggFunc = typeof aggFuncOrString === "string" ? this.aggFuncSvc.getAggFunc(aggFuncOrString) : aggFuncOrString;
    if (typeof aggFunc !== "function") {
      (0, import_ag_grid_community113._error)(109, { aggFuncOrString });
      return null;
    }
    const aggFuncAny = aggFunc;
    const params = (0, import_ag_grid_community113._addGridCommonParams)(this.gos, {
      values,
      column,
      colDef: column ? column.getColDef() : void 0,
      pivotResultColumn,
      rowNode,
      data: rowNode ? rowNode.data : void 0
    });
    return aggFuncAny(params);
  }
  setAggData(rowNode, newAggData) {
    const oldAggData = rowNode.aggData;
    rowNode.aggData = newAggData;
    if (rowNode.__localEventService) {
      const eventFunc = (colId) => {
        const value = rowNode.aggData ? rowNode.aggData[colId] : void 0;
        const oldValue = oldAggData ? oldAggData[colId] : void 0;
        if (value === oldValue) {
          return;
        }
        const column = this.colModel.getCol(colId);
        if (!column) {
          return;
        }
        rowNode.dispatchCellChangedEvent(column, value, oldValue);
      };
      if (oldAggData) {
        for (const key of Object.keys(oldAggData)) {
          eventFunc(key);
        }
      }
      if (newAggData) {
        for (const key of Object.keys(newAggData)) {
          if (!oldAggData || !(key in oldAggData)) {
            eventFunc(key);
          }
        }
      }
    }
  }
};

// packages/ag-grid-enterprise/src/aggregation/filterAggregatesStage.ts
var import_ag_grid_community114 = require("ag-grid-community");
var FilterAggregatesStage = class extends import_ag_grid_community114.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "filterAggStage";
    this.refreshProps = /* @__PURE__ */ new Set([]);
    this.step = "filter_aggregates";
  }
  wireBeans(beans) {
    this.filterManager = beans.filterManager;
  }
  execute(params) {
    const isPivotMode2 = this.beans.colModel.isPivotMode();
    const isAggFilterActive = this.filterManager?.isAggregateFilterPresent() || this.filterManager?.isAggregateQuickFilterPresent();
    const defaultPrimaryColumnPredicate = (params2) => !params2.node.group;
    const defaultSecondaryColumnPredicate = (params2) => params2.node.leafGroup;
    const applyFilterToNode = (0, import_ag_grid_community114._getGroupAggFiltering)(this.gos) || (isPivotMode2 ? defaultSecondaryColumnPredicate : defaultPrimaryColumnPredicate);
    const { changedPath } = params;
    const preserveChildren = (node, recursive = false) => {
      if (node.childrenAfterFilter) {
        node.childrenAfterAggFilter = node.childrenAfterFilter;
        if (recursive) {
          node.childrenAfterAggFilter.forEach((child) => preserveChildren(child, recursive));
        }
        this.setAllChildrenCount(node);
      }
      if (node.sibling) {
        node.sibling.childrenAfterAggFilter = node.childrenAfterAggFilter;
      }
    };
    const filterChildren = (node) => {
      node.childrenAfterAggFilter = node.childrenAfterFilter?.filter((child) => {
        const shouldFilterRow = applyFilterToNode({ node: child });
        if (shouldFilterRow) {
          const doesNodePassFilter = this.filterManager.doesRowPassAggregateFilters({ rowNode: child });
          if (doesNodePassFilter) {
            preserveChildren(child, true);
            return true;
          }
        }
        const hasChildPassed = child.childrenAfterAggFilter?.length;
        return hasChildPassed;
      }) || null;
      this.setAllChildrenCount(node);
      if (node.sibling) {
        node.sibling.childrenAfterAggFilter = node.childrenAfterAggFilter;
      }
    };
    changedPath.forEachChangedNodeDepthFirst(isAggFilterActive ? filterChildren : preserveChildren, true);
  }
  /** for tree data, we include all children, groups and leafs */
  setAllChildrenCountTreeData(rowNode) {
    const childrenAfterAggFilter = rowNode.childrenAfterAggFilter;
    let allChildrenCount = 0;
    if (childrenAfterAggFilter) {
      const length = childrenAfterAggFilter.length;
      allChildrenCount = length;
      for (let i = 0; i < length; ++i) {
        allChildrenCount += childrenAfterAggFilter[i].allChildrenCount ?? 0;
      }
    }
    rowNode.setAllChildrenCount(
      // Maintain the historical behaviour:
      // - allChildrenCount is 0 in the root if there are no children
      // - allChildrenCount is null in any non-root row if there are no children
      allChildrenCount === 0 && rowNode.level >= 0 ? null : allChildrenCount
    );
  }
  /* for grid data, we only count the leafs */
  setAllChildrenCountGridGrouping(rowNode) {
    let allChildrenCount = 0;
    rowNode.childrenAfterAggFilter.forEach((child) => {
      if (child.group) {
        allChildrenCount += child.allChildrenCount;
      } else {
        allChildrenCount++;
      }
    });
    rowNode.setAllChildrenCount(allChildrenCount);
  }
  setAllChildrenCount(rowNode) {
    if (!rowNode.hasChildren()) {
      rowNode.setAllChildrenCount(null);
      return;
    }
    if (this.gos.get("treeData")) {
      this.setAllChildrenCountTreeData(rowNode);
    } else {
      this.setAllChildrenCountGridGrouping(rowNode);
    }
  }
};

// packages/ag-grid-enterprise/src/aggregation/footerService.ts
var import_ag_grid_community116 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/aggregation/footerUtils.ts
var import_ag_grid_community115 = require("ag-grid-community");
var IGNORED_SIBLING_PROPERTIES = /* @__PURE__ */ new Set(["__localEventService", "__objectId", "sticky", "__autoHeights", "__checkAutoHeightsDebounced"]);
function _createRowNodeFooter(rowNode, beans) {
  if (rowNode.sibling) {
    return;
  }
  const footerNode = new import_ag_grid_community115.RowNode(beans);
  Object.keys(rowNode).forEach((key) => {
    if (IGNORED_SIBLING_PROPERTIES.has(key)) {
      return;
    }
    footerNode[key] = rowNode[key];
  });
  footerNode.footer = true;
  footerNode.setRowTop(null);
  footerNode.setRowIndex(null);
  footerNode.oldRowTop = null;
  footerNode.id = "rowGroupFooter_" + rowNode.id;
  footerNode.sibling = rowNode;
  rowNode.sibling = footerNode;
}
function _destroyRowNodeFooter(rowNode) {
  if (!rowNode.sibling) {
    return;
  }
  rowNode.sibling.setRowTop(null);
  rowNode.sibling.setRowIndex(null);
  rowNode.sibling = void 0;
}

// packages/ag-grid-enterprise/src/aggregation/footerService.ts
var FooterService = class extends import_ag_grid_community116.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "footerSvc";
  }
  addTotalRows(startIndex, node, callback, includeFooterNodes, isRootNode, position) {
    let index = startIndex;
    if (isRootNode) {
      const grandTotal = includeFooterNodes && (0, import_ag_grid_community116._getGrandTotalRow)(this.gos);
      if (grandTotal === position) {
        _createRowNodeFooter(node, this.beans);
        callback(node.sibling, index++);
      }
      return index;
    }
    const isGroupIncludeFooter = (0, import_ag_grid_community116._getGroupTotalRowCallback)(this.gos);
    const groupTotal = includeFooterNodes && isGroupIncludeFooter({ node });
    if (groupTotal === position) {
      _createRowNodeFooter(node, this.beans);
      callback(node.sibling, index++);
    }
    return index;
  }
  getTopDisplayIndex(rowsToDisplay, topLevelIndex, childrenAfterSort, getDefaultIndex) {
    let adjustedIndex = topLevelIndex;
    if (rowsToDisplay[0].footer) {
      if (topLevelIndex === 0) {
        return 0;
      }
      adjustedIndex -= 1;
    }
    const lastRow = rowsToDisplay[rowsToDisplay.length - 1];
    const indexOutsideGroupBounds = adjustedIndex >= childrenAfterSort.length;
    if (lastRow.footer && indexOutsideGroupBounds) {
      return lastRow.rowIndex;
    }
    return getDefaultIndex(adjustedIndex);
  }
};

// packages/ag-grid-enterprise/src/aggregation/valueColsSvc.ts
var import_ag_grid_community117 = require("ag-grid-community");
var ValueColsSvc = class extends import_ag_grid_community117.BaseColsService {
  constructor() {
    super(...arguments);
    this.beanName = "valueColsSvc";
    this.eventName = "columnValueChanged";
    this.columnProcessors = {
      set: (column, added, source) => this.setValueActive(added, column, source),
      add: (column, added, source) => this.setValueActive(true, column, source),
      remove: (column, added, source) => this.setValueActive(false, column, source)
    };
    this.columnExtractors = {
      setFlagFunc: (col, flag, source) => this.setColValueActive(col, flag, source),
      getIndexFunc: () => void 0,
      getInitialIndexFunc: () => void 0,
      getValueFunc: (colDef) => {
        const aggFunc = colDef.aggFunc;
        if (aggFunc === null || aggFunc === "") {
          return null;
        }
        if (aggFunc === void 0) {
          return;
        }
        return !!aggFunc;
      },
      getInitialValueFunc: (colDef) => {
        return colDef.initialAggFunc != null && colDef.initialAggFunc != "";
      }
    };
    this.modifyColumnsNoEventsCallbacks = {
      addCol: (column) => this.columns.push(column),
      removeCol: (column) => (0, import_ag_grid_community117._removeFromArray)(this.columns, column)
    };
  }
  extractCols(source, oldProvidedCols) {
    this.columns = super.extractCols(source, oldProvidedCols);
    this.columns.forEach((col) => {
      const colDef = col.getColDef();
      if (colDef.aggFunc != null && colDef.aggFunc != "") {
        this.setColAggFunc(col, colDef.aggFunc);
      } else {
        if (!col.getAggFunc()) {
          this.setColAggFunc(col, colDef.initialAggFunc);
        }
      }
    });
    return this.columns;
  }
  setColumnAggFunc(key, aggFunc, source) {
    if (!key) {
      return;
    }
    const column = this.colModel.getColDefCol(key);
    if (!column) {
      return;
    }
    this.setColAggFunc(column, aggFunc);
    this.dispatchColumnChangedEvent(this.eventSvc, this.eventName, [column], source);
  }
  syncColumnWithState(column, source, getValue) {
    const aggFunc = getValue("aggFunc").value1;
    if (aggFunc !== void 0) {
      if (typeof aggFunc === "string") {
        this.setColAggFunc(column, aggFunc);
        if (!column.isValueActive()) {
          this.setColValueActive(column, true, source);
          this.modifyColumnsNoEventsCallbacks.addCol(column);
        }
      } else {
        if ((0, import_ag_grid_community117._exists)(aggFunc)) {
          (0, import_ag_grid_community117._warn)(33);
        }
        if (column.isValueActive()) {
          this.setColValueActive(column, false, source);
          this.modifyColumnsNoEventsCallbacks.removeCol(column);
        }
      }
    }
  }
  setValueActive(active, column, source) {
    if (active === column.isValueActive()) {
      return;
    }
    this.setColValueActive(column, active, source);
    if (active && !column.getAggFunc() && this.aggFuncSvc) {
      const initialAggFunc = this.aggFuncSvc.getDefaultAggFunc(column);
      this.setColAggFunc(column, initialAggFunc);
    }
  }
  setColAggFunc(column, aggFunc) {
    column.aggFunc = aggFunc;
    column.dispatchStateUpdatedEvent("aggFunc");
  }
  setColValueActive(column, value, source) {
    if (column.aggregationActive !== value) {
      column.aggregationActive = value;
      column.dispatchColEvent("columnValueChanged", source);
    }
  }
};

// packages/ag-grid-enterprise/src/aggregation/aggregationModule.ts
var SharedAggregationModule = {
  moduleName: "SharedAggregation",
  version: VERSION,
  beans: [AggFuncService, AggColumnNameService, FooterService, ValueColsSvc],
  apiFunctions: {
    addAggFuncs,
    clearAggFuncs,
    setColumnAggFunc
  },
  dependsOn: [EnterpriseCoreModule]
};
var AggregationModule = {
  moduleName: "Aggregation",
  version: VERSION,
  beans: [AggregationStage, FilterAggregatesStage],
  rowModels: ["clientSide"],
  dependsOn: [SharedAggregationModule]
};

// packages/ag-grid-enterprise/src/pivot/pivotColsSvc.ts
var import_ag_grid_community118 = require("ag-grid-community");
var PivotColsSvc = class extends import_ag_grid_community118.BaseColsService {
  constructor() {
    super(...arguments);
    this.beanName = "pivotColsSvc";
    this.eventName = "columnPivotChanged";
    this.columnProcessors = {
      set: (column, added, source) => this.setColPivotActive(column, added, source),
      add: (column, added, source) => this.setColPivotActive(column, true, source),
      remove: (column, added, source) => this.setColPivotActive(column, false, source)
    };
    this.columnOrdering = {
      enableProp: "pivot",
      initialEnableProp: "initialPivot",
      indexProp: "pivotIndex",
      initialIndexProp: "initialPivotIndex"
    };
    this.columnExtractors = {
      setFlagFunc: (col, flag, source) => this.setColPivotActive(col, flag, source),
      getIndexFunc: (colDef) => colDef.pivotIndex,
      getInitialIndexFunc: (colDef) => colDef.initialPivotIndex,
      getValueFunc: (colDef) => colDef.pivot,
      getInitialValueFunc: (colDef) => colDef.initialPivot
    };
    this.modifyColumnsNoEventsCallbacks = {
      addCol: (column) => this.columns.push(column),
      removeCol: (column) => (0, import_ag_grid_community118._removeFromArray)(this.columns, column)
    };
  }
  syncColumnWithState(column, source, getValue, rowIndex) {
    const { value1: pivot, value2: pivotIndex } = getValue("pivot", "pivotIndex");
    if (pivot !== void 0 || pivotIndex !== void 0) {
      if (typeof pivotIndex === "number" || pivot) {
        if (!column.isPivotActive()) {
          this.setColPivotActive(column, true, source);
          this.modifyColumnsNoEventsCallbacks.addCol(column);
        }
        if (rowIndex && typeof pivotIndex === "number") {
          rowIndex[column.getId()] = pivotIndex;
        }
      } else {
        if (column.isPivotActive()) {
          this.setColPivotActive(column, false, source);
          this.modifyColumnsNoEventsCallbacks.removeCol(column);
        }
      }
    }
  }
  setColPivotActive(column, pivot, source) {
    if (column.pivotActive !== pivot) {
      column.pivotActive = pivot;
      column.dispatchColEvent("columnPivotChanged", source);
    }
    column.dispatchStateUpdatedEvent("pivot");
  }
};

// packages/ag-grid-enterprise/src/rowGrouping/rowGroupColsSvc.ts
var import_ag_grid_community119 = require("ag-grid-community");
var RowGroupColsSvc = class extends import_ag_grid_community119.BaseColsService {
  constructor() {
    super(...arguments);
    this.beanName = "rowGroupColsSvc";
    this.eventName = "columnRowGroupChanged";
    this.columnProcessors = {
      set: (column, added, source) => this.setActive(added, column, source),
      add: (column, added, source) => this.setActive(true, column, source),
      remove: (column, added, source) => this.setActive(false, column, source)
    };
    this.columnOrdering = {
      enableProp: "rowGroup",
      initialEnableProp: "initialRowGroup",
      indexProp: "rowGroupIndex",
      initialIndexProp: "initialRowGroupIndex"
    };
    this.columnExtractors = {
      setFlagFunc: (col, flag, source) => this.setColRowGroupActive(col, flag, source),
      getIndexFunc: (colDef) => colDef.rowGroupIndex,
      getInitialIndexFunc: (colDef) => colDef.initialRowGroupIndex,
      getValueFunc: (colDef) => colDef.rowGroup,
      getInitialValueFunc: (colDef) => colDef.initialRowGroup
    };
    this.modifyColumnsNoEventsCallbacks = {
      addCol: (column) => this.columns.push(column),
      removeCol: (column) => (0, import_ag_grid_community119._removeFromArray)(this.columns, column)
    };
  }
  moveColumn(fromIndex, toIndex, source) {
    if (this.columns.length === 0) {
      return;
    }
    const column = this.columns[fromIndex];
    const impactedColumns = this.columns.slice(fromIndex, toIndex);
    this.columns.splice(fromIndex, 1);
    this.columns.splice(toIndex, 0, column);
    this.eventSvc.dispatchEvent({
      type: this.eventName,
      columns: impactedColumns,
      column: impactedColumns.length === 1 ? impactedColumns[0] : null,
      source
    });
  }
  syncColumnWithState(column, source, getValue, rowIndex) {
    const { value1: rowGroup, value2: rowGroupIndex } = getValue("rowGroup", "rowGroupIndex");
    if (rowGroup !== void 0 || rowGroupIndex !== void 0) {
      if (typeof rowGroupIndex === "number" || rowGroup) {
        if (!column.isRowGroupActive()) {
          this.setColRowGroupActive(column, true, source);
          this.modifyColumnsNoEventsCallbacks.addCol(column);
        }
        if (rowIndex && typeof rowGroupIndex === "number") {
          rowIndex[column.getId()] = rowGroupIndex;
        }
      } else {
        if (column.isRowGroupActive()) {
          this.setColRowGroupActive(column, false, source);
          this.modifyColumnsNoEventsCallbacks.removeCol(column);
        }
      }
    }
  }
  setActive(active, column, source) {
    if (active === column.isRowGroupActive()) {
      return;
    }
    this.setColRowGroupActive(column, active, source);
    if ((0, import_ag_grid_community119._shouldUpdateColVisibilityAfterGroup)(this.gos, active)) {
      this.colModel.setColsVisible([column], !active, source);
    }
  }
  setColRowGroupActive(column, rowGroup, source) {
    if (column.rowGroupActive !== rowGroup) {
      column.rowGroupActive = rowGroup;
      column.dispatchColEvent("columnRowGroupChanged", source);
    }
    column.dispatchStateUpdatedEvent("rowGroup");
  }
};

// packages/ag-grid-enterprise/src/rowHierarchy/autoColService.ts
var import_ag_grid_community120 = require("ag-grid-community");
var AutoColService = class extends import_ag_grid_community120.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "autoColSvc";
  }
  postConstruct() {
    this.addManagedPropertyListener("autoGroupColumnDef", this.updateColumns.bind(this));
  }
  addColumns(cols) {
    if (this.columns == null) {
      return;
    }
    cols.list = this.columns.list.concat(cols.list);
    cols.tree = this.columns.tree.concat(cols.tree);
    (0, import_ag_grid_community120._updateColsMap)(cols);
  }
  createColumns(cols, updateOrders) {
    const beans = this.beans;
    const { colModel, gos, rowGroupColsSvc, colGroupSvc } = beans;
    const isPivotMode2 = colModel.isPivotMode();
    const groupFullWidthRow = (0, import_ag_grid_community120._isGroupUseEntireRow)(gos, isPivotMode2);
    const suppressAutoColumn = isPivotMode2 ? gos.get("pivotSuppressAutoColumn") : this.isSuppressAutoCol();
    const rowGroupCols = rowGroupColsSvc?.columns;
    const groupingActive = rowGroupCols && rowGroupCols.length > 0 || gos.get("treeData");
    const noAutoCols = !groupingActive || suppressAutoColumn || groupFullWidthRow;
    const destroyPrevious = () => {
      if (this.columns) {
        (0, import_ag_grid_community120._destroyColumnTree)(beans, this.columns.tree);
        this.columns = null;
      }
    };
    if (noAutoCols) {
      destroyPrevious();
      return;
    }
    const list = this.generateAutoCols(rowGroupCols);
    const autoColsSame = (0, import_ag_grid_community120._areColIdsEqual)(list, this.columns?.list || null);
    const newTreeDepth = cols.treeDepth;
    const oldTreeDepth = this.columns ? this.columns.treeDepth : -1;
    const treeDeptSame = oldTreeDepth == newTreeDepth;
    if (autoColsSame && treeDeptSame) {
      return;
    }
    destroyPrevious();
    const treeDepth = colGroupSvc?.findDepth(cols.tree) ?? 0;
    const tree = colGroupSvc?.balanceTreeForAutoCols(list, treeDepth) ?? [];
    this.columns = {
      list,
      tree,
      treeDepth,
      map: {}
    };
    const putAutoColsFirstInList = (cols2) => {
      if (!cols2) {
        return null;
      }
      const colsFiltered = cols2.filter((col) => !(0, import_ag_grid_community120.isColumnGroupAutoCol)(col));
      return [...list, ...colsFiltered];
    };
    updateOrders(putAutoColsFirstInList);
  }
  updateColumns(event) {
    const source = (0, import_ag_grid_community120._convertColumnEventSourceType)(event.source);
    this.columns?.list.forEach((col, index) => this.updateOneAutoCol(col, index, source));
  }
  getColumn(key) {
    return this.columns?.list.find((groupCol) => (0, import_ag_grid_community120._columnsMatch)(groupCol, key)) ?? null;
  }
  getColumns() {
    return this.columns?.list ?? null;
  }
  generateAutoCols(rowGroupCols = []) {
    const autoCols = [];
    const doingTreeData = this.gos.get("treeData");
    let doingMultiAutoColumn = (0, import_ag_grid_community120._isGroupMultiAutoColumn)(this.gos);
    if (doingTreeData && doingMultiAutoColumn) {
      (0, import_ag_grid_community120._warn)(182);
      doingMultiAutoColumn = false;
    }
    if (doingMultiAutoColumn) {
      rowGroupCols.forEach((rowGroupCol, index) => {
        autoCols.push(this.createOneAutoCol(rowGroupCol, index));
      });
    } else {
      autoCols.push(this.createOneAutoCol());
    }
    return autoCols;
  }
  isSuppressAutoCol() {
    const gos = this.gos;
    const groupDisplayType = gos.get("groupDisplayType");
    const isCustomRowGroups = groupDisplayType === "custom";
    if (isCustomRowGroups) {
      return true;
    }
    const treeDataDisplayType = gos.get("treeDataDisplayType");
    return treeDataDisplayType === "custom";
  }
  // rowGroupCol and index are missing if groupDisplayType != "multipleColumns"
  createOneAutoCol(rowGroupCol, index) {
    let colId;
    if (rowGroupCol) {
      colId = `${import_ag_grid_community120.GROUP_AUTO_COLUMN_ID}-${rowGroupCol.getId()}`;
    } else {
      colId = import_ag_grid_community120.GROUP_AUTO_COLUMN_ID;
    }
    const colDef = this.createAutoColDef(colId, rowGroupCol, index);
    colDef.colId = colId;
    const newCol = new import_ag_grid_community120.AgColumn(colDef, null, colId, true);
    this.createBean(newCol);
    return newCol;
  }
  /**
   * Refreshes an auto group col to load changes from defaultColDef or autoGroupColDef
   */
  updateOneAutoCol(colToUpdate, index, source) {
    const oldColDef = colToUpdate.getColDef();
    const underlyingColId = typeof oldColDef.showRowGroup == "string" ? oldColDef.showRowGroup : void 0;
    const beans = this.beans;
    const underlyingColumn = underlyingColId != null ? beans.colModel.getColDefCol(underlyingColId) : void 0;
    const colId = colToUpdate.getId();
    const colDef = this.createAutoColDef(colId, underlyingColumn ?? void 0, index);
    colToUpdate.setColDef(colDef, null, source);
    (0, import_ag_grid_community120._applyColumnState)(beans, { state: [{ colId, ...colDef }] }, source);
  }
  createAutoColDef(colId, underlyingColumn, index) {
    let res = this.createBaseColDef(underlyingColumn);
    const autoGroupColumnDef = this.gos.get("autoGroupColumnDef");
    (0, import_ag_grid_community120._mergeDeep)(res, autoGroupColumnDef);
    res = (0, import_ag_grid_community120._addColumnDefaultAndTypes)(this.beans, res, colId, true);
    if (!this.gos.get("treeData")) {
      const noFieldOrValueGetter = (0, import_ag_grid_community120._missing)(res.field) && (0, import_ag_grid_community120._missing)(res.valueGetter) && (0, import_ag_grid_community120._missing)(res.filterValueGetter) && res.filter !== "agGroupColumnFilter";
      if (noFieldOrValueGetter) {
        res.filter = false;
      }
    }
    if (index && index > 0) {
      res.headerCheckboxSelection = false;
    }
    const isSortingCoupled = (0, import_ag_grid_community120._isColumnsSortingCoupledToGroup)(this.gos);
    const hasOwnData = res.valueGetter || res.field != null;
    if (isSortingCoupled && !hasOwnData) {
      res.sortIndex = void 0;
      res.initialSort = void 0;
    }
    return res;
  }
  createBaseColDef(rowGroupCol) {
    const userDef = this.gos.get("autoGroupColumnDef");
    const localeTextFunc = this.getLocaleTextFunc();
    const res = {
      headerName: localeTextFunc("group", "Group")
    };
    const userHasProvidedGroupCellRenderer = userDef && (userDef.cellRenderer || userDef.cellRendererSelector);
    if (!userHasProvidedGroupCellRenderer) {
      res.cellRenderer = "agGroupCellRenderer";
    }
    if (rowGroupCol) {
      const colDef = rowGroupCol.getColDef();
      Object.assign(res, {
        headerName: this.beans.colNames.getDisplayNameForColumn(rowGroupCol, "header"),
        headerValueGetter: colDef.headerValueGetter
      });
      if (colDef.cellRenderer) {
        Object.assign(res, {
          cellRendererParams: {
            innerRenderer: colDef.cellRenderer,
            innerRendererParams: colDef.cellRendererParams
          }
        });
      }
      res.showRowGroup = rowGroupCol.getColId();
    } else {
      res.showRowGroup = true;
    }
    return res;
  }
  destroy() {
    (0, import_ag_grid_community120._destroyColumnTree)(this.beans, this.columns?.tree);
    super.destroy();
  }
};

// packages/ag-grid-enterprise/src/rowHierarchy/clientSideExpansionService.ts
var import_ag_grid_community122 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/rowHierarchy/baseExpansionService.ts
var import_ag_grid_community121 = require("ag-grid-community");
var BaseExpansionService = class extends import_ag_grid_community121.BeanStub {
  addExpandedCss(classes, rowNode) {
    if (rowNode.isExpandable()) {
      classes.push("ag-row-group");
      classes.push(rowNode.expanded ? "ag-row-group-expanded" : "ag-row-group-contracted");
    }
  }
  getRowExpandedListeners(rowCtrl) {
    const { rowNode } = rowCtrl;
    const updateExpandedCss = this.updateExpandedCss.bind(this, rowCtrl, rowNode);
    return {
      expandedChanged: updateExpandedCss,
      hasChildrenChanged: updateExpandedCss
    };
  }
  setExpanded(rowNode, expanded, e, forceSync) {
    if (rowNode.expanded === expanded) {
      return;
    }
    rowNode.expanded = expanded;
    rowNode.dispatchRowEvent("expandedChanged");
    const event = { ...(0, import_ag_grid_community121._createGlobalRowEvent)(rowNode, this.gos, "rowGroupOpened"), expanded, event: e || null };
    this.dispatchExpandedEvent(event, forceSync);
    this.beans.rowRenderer.refreshCells({ rowNodes: [rowNode] });
  }
  isExpandable(rowNode) {
    if (rowNode.footer) {
      return false;
    }
    if (this.beans.colModel.isPivotMode()) {
      return rowNode.hasChildren() && !rowNode.leafGroup;
    }
    return rowNode.hasChildren() || rowNode.master;
  }
  updateExpandedCss(rowCtrl, rowNode) {
    const expandable = rowNode.isExpandable();
    const expanded = rowNode.expanded == true;
    rowCtrl.forEachGui(void 0, (gui) => {
      const rowComp = gui.rowComp;
      rowComp.addOrRemoveCssClass("ag-row-group", expandable);
      rowComp.addOrRemoveCssClass("ag-row-group-expanded", expandable && expanded);
      rowComp.addOrRemoveCssClass("ag-row-group-contracted", expandable && !expanded);
      (0, import_ag_grid_community121._setAriaExpanded)(gui.element, expandable && expanded);
    });
  }
};

// packages/ag-grid-enterprise/src/rowHierarchy/clientSideExpansionService.ts
var ClientSideExpansionService = class extends BaseExpansionService {
  constructor() {
    super(...arguments);
    this.beanName = "expansionSvc";
    this.events = [];
  }
  wireBeans(beans) {
    this.rowModel = beans.rowModel;
  }
  expandRows(rowIds) {
    const rowIdSet = new Set(rowIds);
    this.rowModel.forEachNode((node) => {
      if (node.id && rowIdSet.has(node.id)) {
        node.expanded = true;
      }
    });
    this.onGroupExpandedOrCollapsed();
  }
  expandAll(expand) {
    const { gos, colModel, eventSvc } = this.beans;
    const rowModel = this.rowModel;
    const usingTreeData = gos.get("treeData");
    const usingPivotMode = colModel.isPivotActive();
    const recursiveExpandOrCollapse = (rowNodes) => {
      if (!rowNodes) {
        return;
      }
      rowNodes.forEach((rowNode) => {
        const actionRow = () => {
          rowNode.expanded = expand;
          recursiveExpandOrCollapse(rowNode.childrenAfterGroup);
        };
        if (usingTreeData) {
          const hasChildren = (0, import_ag_grid_community122._exists)(rowNode.childrenAfterGroup);
          if (hasChildren) {
            actionRow();
          }
          return;
        }
        if (usingPivotMode) {
          const notLeafGroup = !rowNode.leafGroup;
          if (notLeafGroup) {
            actionRow();
          }
          return;
        }
        const isRowGroup = rowNode.group;
        if (isRowGroup) {
          actionRow();
        }
      });
    };
    const rootNode = rowModel.rootNode;
    if (rootNode) {
      recursiveExpandOrCollapse(rootNode.childrenAfterGroup);
    }
    rowModel.refreshModel({ step: "map" });
    eventSvc.dispatchEvent({
      type: "expandOrCollapseAll",
      source: expand ? "expandAll" : "collapseAll"
    });
  }
  onGroupExpandedOrCollapsed() {
    this.rowModel.refreshModel({ step: "map" });
  }
  // because the user can call rowNode.setExpanded() many times in one VM turn,
  // we throttle the calls to ClientSideRowModel using animationFrameSvc. this means for 100
  // row nodes getting expanded, we only update the CSRM once, and then we fire all events after
  // CSRM has updated.
  //
  // if we did not do this, then the user could call setExpanded on 100+ rows, causing the grid
  // to re-render 100+ times, which would be a performance lag.
  //
  // we use animationFrameService
  // rather than debounce() so this will get done if anyone flushes the animationFrameService
  // (eg user calls api.ensureRowVisible(), which in turn flushes ).
  dispatchExpandedEvent(event, forceSync) {
    this.events.push(event);
    const func = () => {
      this.rowModel.onRowGroupOpened();
      this.events.forEach((e) => this.eventSvc.dispatchEvent(e));
      this.events = [];
    };
    if (forceSync) {
      func();
    } else {
      if (this.dispatchExpandedDebounced == null) {
        this.dispatchExpandedDebounced = this.debounce(func);
      }
      this.dispatchExpandedDebounced();
    }
  }
  // the advantage over normal debounce is the client can call flushAllFrames()
  // to make sure all rendering is complete. we don't wait any milliseconds,
  // as this is intended to batch calls in one VM turn.
  debounce(func) {
    const animationFrameSvc = this.beans.animationFrameSvc;
    if (!animationFrameSvc) {
      return () => window.setTimeout(func, 0);
    }
    let pending = false;
    return () => {
      if (!animationFrameSvc.active) {
        window.setTimeout(func, 0);
        return;
      }
      if (pending) {
        return;
      }
      pending = true;
      animationFrameSvc.addDestroyTask(() => {
        pending = false;
        func();
      });
    };
  }
};

// packages/ag-grid-enterprise/src/rowHierarchy/flattenStage.ts
var import_ag_grid_community123 = require("ag-grid-community");
var FlattenStage = class extends import_ag_grid_community123.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "flattenStage";
    this.refreshProps = /* @__PURE__ */ new Set([
      "groupHideParentOfSingleChild",
      "groupRemoveSingleChildren",
      "groupRemoveLowestSingleChildren",
      "groupTotalRow",
      "masterDetail"
    ]);
    this.step = "map";
  }
  execute(params) {
    const rootNode = params.rowNode;
    const result = [];
    const skipLeafNodes = this.beans.colModel.isPivotMode();
    const showRootNode = skipLeafNodes && rootNode.leafGroup;
    const topList = showRootNode ? [rootNode] : rootNode.childrenAfterSort;
    const details = this.getFlattenDetails();
    this.recursivelyAddToRowsToDisplay(details, topList, result, skipLeafNodes, 0);
    const atLeastOneRowPresent = result.length > 0;
    const includeGrandTotalRow = !showRootNode && // don't show total footer when showRootNode is true (i.e. in pivot mode and no groups)
    atLeastOneRowPresent && details.grandTotalRow;
    if (includeGrandTotalRow) {
      _createRowNodeFooter(rootNode, this.beans);
      const addToTop = details.grandTotalRow === "top";
      this.addRowNodeToRowsToDisplay(details, rootNode.sibling, result, 0, addToTop);
    }
    return result;
  }
  getFlattenDetails() {
    let groupHideParentOfSingleChild = this.gos.get("groupHideParentOfSingleChild");
    if (!groupHideParentOfSingleChild) {
      groupHideParentOfSingleChild = this.gos.get("groupRemoveSingleChildren");
      if (!groupHideParentOfSingleChild && this.gos.get("groupRemoveLowestSingleChildren")) {
        groupHideParentOfSingleChild = "leafGroupsOnly";
      }
    }
    return {
      groupHideParentOfSingleChild,
      isGroupMultiAutoColumn: (0, import_ag_grid_community123._isGroupMultiAutoColumn)(this.gos),
      hideOpenParents: this.gos.get("groupHideOpenParents"),
      grandTotalRow: (0, import_ag_grid_community123._getGrandTotalRow)(this.gos),
      groupTotalRow: (0, import_ag_grid_community123._getGroupTotalRowCallback)(this.gos)
    };
  }
  recursivelyAddToRowsToDisplay(details, rowsToFlatten, result, skipLeafNodes, uiLevel) {
    if (!rowsToFlatten?.length) {
      return;
    }
    for (let i = 0; i < rowsToFlatten.length; i++) {
      const rowNode = rowsToFlatten[i];
      const isParent = rowNode.hasChildren();
      const isSkippedLeafNode = skipLeafNodes && !isParent;
      const isRemovedSingleChildrenGroup = details.groupHideParentOfSingleChild === true && isParent && rowNode.childrenAfterGroup.length === 1;
      const isRemovedLowestSingleChildrenGroup = details.groupHideParentOfSingleChild === "leafGroupsOnly" && isParent && rowNode.leafGroup && rowNode.childrenAfterGroup.length === 1;
      const neverAllowToExpand = skipLeafNodes && rowNode.leafGroup;
      const isHiddenOpenParent = details.hideOpenParents && rowNode.expanded && !rowNode.master && !neverAllowToExpand;
      const thisRowShouldBeRendered = !isSkippedLeafNode && !isHiddenOpenParent && !isRemovedSingleChildrenGroup && !isRemovedLowestSingleChildrenGroup;
      if (thisRowShouldBeRendered) {
        this.addRowNodeToRowsToDisplay(details, rowNode, result, uiLevel);
      }
      if (skipLeafNodes && rowNode.leafGroup) {
        continue;
      }
      if (isParent) {
        const excludedParent = isRemovedSingleChildrenGroup || isRemovedLowestSingleChildrenGroup;
        if (rowNode.expanded || excludedParent) {
          const doesRowShowFooter = details.groupTotalRow({ node: rowNode });
          if (!doesRowShowFooter) {
            _destroyRowNodeFooter(rowNode);
          }
          const uiLevelForChildren = excludedParent ? uiLevel : uiLevel + 1;
          if (doesRowShowFooter === "top") {
            _createRowNodeFooter(rowNode, this.beans);
            this.addRowNodeToRowsToDisplay(details, rowNode.sibling, result, uiLevelForChildren);
          }
          this.recursivelyAddToRowsToDisplay(
            details,
            rowNode.childrenAfterSort,
            result,
            skipLeafNodes,
            uiLevelForChildren
          );
          if (doesRowShowFooter === "bottom") {
            _createRowNodeFooter(rowNode, this.beans);
            this.addRowNodeToRowsToDisplay(details, rowNode.sibling, result, uiLevelForChildren);
          }
        }
      } else {
        const detailNode = this.beans.masterDetailSvc?.getDetail(rowNode);
        if (detailNode) {
          this.addRowNodeToRowsToDisplay(details, detailNode, result, uiLevel);
        }
      }
    }
  }
  // duplicated method, it's also in floatingRowModel
  addRowNodeToRowsToDisplay(details, rowNode, result, uiLevel, addToTop) {
    if (addToTop) {
      result.unshift(rowNode);
    } else {
      result.push(rowNode);
    }
    rowNode.setUiLevel(details.isGroupMultiAutoColumn ? 0 : uiLevel);
  }
};

// packages/ag-grid-enterprise/src/rowHierarchy/rendering/groupCellRenderer.ts
var import_ag_grid_community125 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/rowHierarchy/rendering/groupCellRendererCtrl.ts
var import_ag_grid_community124 = require("ag-grid-community");
var GroupCellRendererCtrl = class extends import_ag_grid_community124.BeanStub {
  wireBeans(beans) {
    this.expressionSvc = beans.expressionSvc;
    this.valueSvc = beans.valueSvc;
    this.colModel = beans.colModel;
    this.visibleCols = beans.visibleCols;
    this.userCompFactory = beans.userCompFactory;
    this.ctrlsSvc = beans.ctrlsSvc;
    this.rowGroupColsSvc = beans.rowGroupColsSvc;
    this.selectionSvc = beans.selectionSvc;
    this.groupHideOpenParentsSvc = beans.groupHideOpenParentsSvc;
  }
  init(comp, eGui, eCheckbox, eExpanded, eContracted, compClass, params) {
    this.params = params;
    this.eGui = eGui;
    this.eCheckbox = eCheckbox;
    this.eExpanded = eExpanded;
    this.eContracted = eContracted;
    this.comp = comp;
    this.compClass = compClass;
    const { node, colDef } = params;
    const topLevelFooter = this.isTopLevelFooter();
    if (!topLevelFooter) {
      const embeddedRowMismatch = this.isEmbeddedRowMismatch();
      if (embeddedRowMismatch) {
        return;
      }
      if (node.footer && this.gos.get("groupHideOpenParents")) {
        const showRowGroup = colDef?.showRowGroup;
        const rowGroupColumnId = node.rowGroupColumn?.getColId();
        if (showRowGroup !== rowGroupColumnId) {
          return;
        }
      }
    }
    this.setupShowingValueForOpenedParent();
    this.findDisplayedGroupNode();
    if (!topLevelFooter) {
      const showingFooterTotal = this.rowGroupColsSvc && node.footer && node.rowGroupIndex === this.rowGroupColsSvc.columns.findIndex((c) => c.getColId() === colDef?.showRowGroup);
      const isAlwaysShowing = this.gos.get("groupDisplayType") != "multipleColumns" || this.gos.get("treeData");
      const showOpenGroupValue = isAlwaysShowing || this.gos.get("showOpenedGroup") && this.rowGroupColsSvc && !node.footer && (!node.group || node.rowGroupIndex != null && node.rowGroupIndex > this.rowGroupColsSvc?.columns.findIndex(
        (c) => c.getColId() === colDef?.showRowGroup
      ));
      const leafWithValues = !node.group && (colDef?.field || colDef?.valueGetter);
      const isExpandable = this.isExpandable();
      const showPivotModeLeafValue = this.colModel.isPivotMode() && node.leafGroup && node.rowGroupColumn?.getColId() === colDef?.showRowGroup;
      const canSkipRenderingCell = !this.showingValueForOpenedParent && !isExpandable && !leafWithValues && !showOpenGroupValue && !showingFooterTotal && !showPivotModeLeafValue;
      if (canSkipRenderingCell) {
        return;
      }
    }
    this.addExpandAndContract();
    this.addFullWidthRowDraggerIfNeeded();
    this.addCheckboxIfNeeded();
    this.addValueElement();
    this.setupIndent();
    this.refreshAriaExpanded();
    this.addManagedPropertyListener("rowSelection", ({ currentValue, previousValue }) => {
      const curr = typeof currentValue === "object" ? currentValue : void 0;
      const prev = typeof previousValue === "object" ? previousValue : void 0;
      if (curr?.checkboxLocation !== prev?.checkboxLocation) {
        this.refreshCheckbox();
      }
    });
  }
  getCellAriaRole() {
    const colDefAriaRole = this.params.colDef?.cellAriaRole;
    const columnColDefAriaRole = this.params.column?.getColDef().cellAriaRole;
    return colDefAriaRole || columnColDefAriaRole || "gridcell";
  }
  destroy() {
    super.destroy();
    this.expandListener = null;
    this.destroyCheckbox();
  }
  refreshAriaExpanded() {
    const { node, eGridCell } = this.params;
    if (this.expandListener) {
      this.expandListener = this.expandListener();
    }
    if (!this.isExpandable()) {
      (0, import_ag_grid_community124._removeAriaExpanded)(eGridCell);
      return;
    }
    const listener = () => {
      (0, import_ag_grid_community124._setAriaExpanded)(eGridCell, this.showingValueForOpenedParent || !!node.expanded);
    };
    [this.expandListener] = this.addManagedListeners(node, { expandedChanged: listener }) || null;
    listener();
  }
  isTopLevelFooter() {
    const totalRow = (0, import_ag_grid_community124._getGrandTotalRow)(this.gos);
    if (!totalRow) {
      return false;
    }
    if (this.params.value != null || this.params.node.level != -1) {
      return false;
    }
    const colDef = this.params.colDef;
    const doingFullWidth = colDef == null;
    if (doingFullWidth) {
      return true;
    }
    if (colDef.showRowGroup === true) {
      return true;
    }
    const rowGroupCols = this.rowGroupColsSvc?.columns;
    if (!rowGroupCols || rowGroupCols.length === 0) {
      return true;
    }
    return rowGroupCols[0].getId() === colDef.showRowGroup;
  }
  // if we are doing embedded full width rows, we only show the renderer when
  // in the body, or if pinning in the pinned section, or if pinning and RTL,
  // in the right section. otherwise we would have the cell repeated in each section.
  isEmbeddedRowMismatch() {
    if (!this.params.fullWidth || !this.gos.get("embedFullWidthRows")) {
      return false;
    }
    const pinnedLeftCell = this.params.pinned === "left";
    const pinnedRightCell = this.params.pinned === "right";
    const bodyCell = !pinnedLeftCell && !pinnedRightCell;
    if (this.gos.get("enableRtl")) {
      if (this.visibleCols.isPinningLeft()) {
        return !pinnedRightCell;
      }
      return !bodyCell;
    }
    if (this.visibleCols.isPinningLeft()) {
      return !pinnedLeftCell;
    }
    return !bodyCell;
  }
  findDisplayedGroupNode() {
    const column = this.params.column;
    const rowNode = this.params.node;
    if (this.showingValueForOpenedParent) {
      let pointer = rowNode.parent;
      while (pointer != null) {
        if (pointer.rowGroupColumn && column.isRowGroupDisplayed(pointer.rowGroupColumn.getId())) {
          this.displayedGroupNode = pointer;
          break;
        }
        pointer = pointer.parent;
      }
    }
    if ((0, import_ag_grid_community124._missing)(this.displayedGroupNode)) {
      this.displayedGroupNode = rowNode;
    }
  }
  setupShowingValueForOpenedParent() {
    this.showingValueForOpenedParent = this.groupHideOpenParentsSvc?.isShowingValueForOpenedParent(this.params.node, this.params.column) ?? false;
  }
  addValueElement() {
    if (this.displayedGroupNode.footer) {
      this.addFooterValue();
    } else {
      this.addGroupValue();
      this.addChildCount();
    }
  }
  addGroupValue() {
    const paramsAdjusted = this.adjustParamsWithDetailsFromRelatedColumn();
    const innerCompDetails = this.getInnerCompDetails(paramsAdjusted);
    const { valueFormatted, value } = paramsAdjusted;
    let valueWhenNoRenderer = valueFormatted;
    if (valueWhenNoRenderer == null) {
      const isGroupColForNode = this.displayedGroupNode.rowGroupColumn && this.params.column?.isRowGroupDisplayed(this.displayedGroupNode.rowGroupColumn.getId());
      if (this.displayedGroupNode.key === "" && this.displayedGroupNode.group && isGroupColForNode) {
        const localeTextFunc = this.getLocaleTextFunc();
        valueWhenNoRenderer = localeTextFunc("blanks", "(Blanks)");
      } else {
        valueWhenNoRenderer = value ?? null;
      }
    }
    this.comp.setInnerRenderer(innerCompDetails, valueWhenNoRenderer);
  }
  adjustParamsWithDetailsFromRelatedColumn() {
    const relatedColumn = this.displayedGroupNode.rowGroupColumn;
    const column = this.params.column;
    if (!relatedColumn) {
      return this.params;
    }
    const notFullWidth = column != null;
    if (notFullWidth) {
      const showingThisRowGroup = column.isRowGroupDisplayed(relatedColumn.getId());
      if (!showingThisRowGroup) {
        return this.params;
      }
    }
    const params = this.params;
    const { value, node } = this.params;
    const valueFormatted = this.valueSvc.formatValue(relatedColumn, node, value);
    const paramsAdjusted = {
      ...params,
      valueFormatted
    };
    return paramsAdjusted;
  }
  addFooterValue() {
    const totalValueGetter = this.params.totalValueGetter;
    let footerValue = "";
    if (totalValueGetter) {
      const paramsClone = {
        ...this.params,
        value: this.params.value
      };
      if (typeof totalValueGetter === "function") {
        footerValue = totalValueGetter(paramsClone);
      } else if (typeof totalValueGetter === "string") {
        footerValue = this.expressionSvc ? this.expressionSvc.evaluate(totalValueGetter, paramsClone) : "";
      } else {
        (0, import_ag_grid_community124._warn)(179);
      }
    } else {
      const localeTextFunc = this.getLocaleTextFunc();
      const footerTotalPrefix = localeTextFunc("footerTotal", "Total");
      footerValue = footerTotalPrefix + " " + (this.params.value != null ? this.params.value : "");
    }
    const innerCompDetails = this.getInnerCompDetails(this.params);
    this.comp.setInnerRenderer(innerCompDetails, footerValue);
  }
  getInnerCompDetails(params) {
    if (params.fullWidth) {
      return (0, import_ag_grid_community124._getInnerCellRendererDetails)(this.userCompFactory, this.gos.get("groupRowRendererParams"), params);
    }
    const innerCompDetails = (0, import_ag_grid_community124._getInnerCellRendererDetails)(
      this.userCompFactory,
      params,
      params
    );
    const isGroupRowRenderer = (details) => details && details.componentClass == this.compClass;
    if (innerCompDetails && !isGroupRowRenderer(innerCompDetails)) {
      return innerCompDetails;
    }
    const relatedColumn = this.displayedGroupNode.rowGroupColumn;
    const relatedColDef = relatedColumn?.getColDef();
    if (!relatedColDef) {
      return;
    }
    const relatedCompDetails = (0, import_ag_grid_community124._getCellRendererDetails)(this.userCompFactory, relatedColDef, params);
    if (relatedCompDetails && !isGroupRowRenderer(relatedCompDetails)) {
      return relatedCompDetails;
    }
    if (isGroupRowRenderer(relatedCompDetails) && relatedColDef.cellRendererParams && relatedColDef.cellRendererParams.innerRenderer) {
      return (0, import_ag_grid_community124._getInnerCellRendererDetails)(
        this.userCompFactory,
        relatedColDef.cellRendererParams,
        params
      );
    }
  }
  addChildCount() {
    if (this.params.suppressCount) {
      return;
    }
    this.addManagedListeners(this.displayedGroupNode, {
      allChildrenCountChanged: this.updateChildCount.bind(this)
    });
    this.updateChildCount();
  }
  updateChildCount() {
    const allChildrenCount = this.displayedGroupNode.allChildrenCount;
    const showingGroupForThisNode = this.isShowRowGroupForThisRow();
    const showCount = showingGroupForThisNode && allChildrenCount != null && allChildrenCount >= 0;
    const countString = showCount ? `(${allChildrenCount})` : ``;
    this.comp.setChildCount(countString);
  }
  isShowRowGroupForThisRow() {
    if (this.gos.get("treeData")) {
      return true;
    }
    const rowGroupColumn = this.displayedGroupNode.rowGroupColumn;
    if (!rowGroupColumn) {
      return false;
    }
    const column = this.params.column;
    const thisColumnIsInterested = column == null || column.isRowGroupDisplayed(rowGroupColumn.getId());
    return thisColumnIsInterested;
  }
  addExpandAndContract() {
    const params = this.params;
    const setupIcon = (iconName, element) => {
      const icon = (0, import_ag_grid_community124._createIconNoSpan)(iconName, this.beans, null);
      if (icon) {
        element.appendChild(icon);
        this.addDestroyFunc(() => element.removeChild(icon));
      }
    };
    setupIcon("groupExpanded", this.eExpanded);
    setupIcon("groupContracted", this.eContracted);
    const eGroupCell = params.eGridCell;
    const isDoubleClickEdit = this.params.column?.isCellEditable(params.node) && this.gos.get("enableGroupEdit");
    if (!isDoubleClickEdit && this.isExpandable() && !params.suppressDoubleClickExpand) {
      this.addManagedListeners(eGroupCell, { dblclick: this.onCellDblClicked.bind(this) });
    }
    this.addManagedListeners(this.eExpanded, { click: this.onExpandClicked.bind(this) });
    this.addManagedListeners(this.eContracted, { click: this.onExpandClicked.bind(this) });
    this.addManagedListeners(eGroupCell, { keydown: this.onKeyDown.bind(this) });
    this.addManagedListeners(params.node, { expandedChanged: this.showExpandAndContractIcons.bind(this) });
    this.showExpandAndContractIcons();
    const expandableChangedListener = this.onRowNodeIsExpandableChanged.bind(this);
    this.addManagedListeners(this.displayedGroupNode, {
      allChildrenCountChanged: expandableChangedListener,
      masterChanged: expandableChangedListener,
      groupChanged: expandableChangedListener,
      hasChildrenChanged: expandableChangedListener
    });
  }
  onExpandClicked(mouseEvent) {
    if ((0, import_ag_grid_community124._isStopPropagationForAgGrid)(mouseEvent)) {
      return;
    }
    (0, import_ag_grid_community124._stopPropagationForAgGrid)(mouseEvent);
    this.onExpandOrContract(mouseEvent);
  }
  onExpandOrContract(e) {
    const rowNode = this.displayedGroupNode;
    const nextExpandState = !rowNode.expanded;
    if (!nextExpandState && rowNode.sticky) {
      this.scrollToStickyNode(rowNode);
    }
    rowNode.setExpanded(nextExpandState, e);
  }
  scrollToStickyNode(rowNode) {
    this.ctrlsSvc.getScrollFeature().setVerticalScrollPosition(rowNode.rowTop - rowNode.stickyRowTop);
  }
  isExpandable() {
    if (this.showingValueForOpenedParent) {
      return true;
    }
    const rowNode = this.displayedGroupNode;
    const reducedLeafNode = this.colModel.isPivotMode() && rowNode.leafGroup;
    const expandableGroup = rowNode.isExpandable() && !rowNode.footer && !reducedLeafNode;
    if (!expandableGroup) {
      return false;
    }
    const column = this.params.column;
    const displayingForOneColumnOnly = column != null && typeof column.getColDef().showRowGroup === "string";
    if (displayingForOneColumnOnly) {
      const showing = this.isShowRowGroupForThisRow();
      return showing;
    }
    return true;
  }
  showExpandAndContractIcons() {
    const { params, displayedGroupNode: displayedGroup, colModel } = this;
    const { node } = params;
    const isExpandable = this.isExpandable();
    if (isExpandable) {
      const expanded = this.showingValueForOpenedParent ? true : node.expanded;
      this.comp.setExpandedDisplayed(expanded);
      this.comp.setContractedDisplayed(!expanded);
    } else {
      this.comp.setExpandedDisplayed(false);
      this.comp.setContractedDisplayed(false);
    }
    const pivotMode = colModel.isPivotMode();
    const pivotModeAndLeafGroup = pivotMode && displayedGroup.leafGroup;
    const addExpandableCss = isExpandable && !pivotModeAndLeafGroup;
    const isTotalFooterNode = node.footer && node.level === -1;
    this.comp.addOrRemoveCssClass("ag-cell-expandable", addExpandableCss);
    this.comp.addOrRemoveCssClass("ag-row-group", addExpandableCss);
    if (pivotMode) {
      this.comp.addOrRemoveCssClass("ag-pivot-leaf-group", !!pivotModeAndLeafGroup);
    } else if (!isTotalFooterNode) {
      this.comp.addOrRemoveCssClass("ag-row-group-leaf-indent", !addExpandableCss);
    }
  }
  onRowNodeIsExpandableChanged() {
    this.showExpandAndContractIcons();
    this.setIndent();
    this.refreshAriaExpanded();
  }
  setupIndent() {
    const node = this.params.node;
    const suppressPadding = this.params.suppressPadding;
    if (!suppressPadding) {
      this.addManagedListeners(node, { uiLevelChanged: this.setIndent.bind(this) });
      this.setIndent();
    }
  }
  setIndent() {
    if (this.gos.get("groupHideOpenParents")) {
      return;
    }
    const params = this.params;
    const rowNode = params.node;
    const fullWithRow = !!params.colDef;
    const treeData = this.gos.get("treeData");
    const manyDimensionThisColumn = !fullWithRow || treeData || params.colDef.showRowGroup === true;
    const paddingCount = manyDimensionThisColumn ? rowNode.uiLevel : 0;
    if (this.indentClass) {
      this.comp.addOrRemoveCssClass(this.indentClass, false);
    }
    this.indentClass = "ag-row-group-indent-" + paddingCount;
    this.comp.addOrRemoveCssClass(this.indentClass, true);
    this.eGui.style.setProperty("--ag-indentation-level", String(paddingCount));
  }
  addFullWidthRowDraggerIfNeeded() {
    if (!this.params.fullWidth || !this.params.rowDrag || !this.rowDragSvc) {
      return;
    }
    const rowDragComp = this.rowDragSvc.createRowDragComp(() => this.params.value, this.params.node);
    this.createManagedBean(rowDragComp);
    this.eGui.insertAdjacentElement("afterbegin", rowDragComp.getGui());
  }
  addCheckboxIfNeeded() {
    const rowNode = this.displayedGroupNode;
    const rowSelection = this.gos.get("rowSelection");
    const checkboxLocation = (0, import_ag_grid_community124._getCheckboxLocation)(rowSelection);
    const checkboxes = typeof rowSelection === "object" ? checkboxLocation === "autoGroupColumn" && (0, import_ag_grid_community124._getCheckboxes)(rowSelection) : this.params.checkbox;
    const userWantsSelected = typeof checkboxes === "function" || checkboxes === true;
    const checkboxNeeded = userWantsSelected && // footers cannot be selected
    !rowNode.footer && // pinned rows cannot be selected
    !rowNode.rowPinned && // details cannot be selected
    !rowNode.detail && !!this.selectionSvc && (0, import_ag_grid_community124._isRowSelection)(this.gos);
    if (checkboxNeeded) {
      const cbSelectionComponent = this.selectionSvc.createCheckboxSelectionComponent();
      this.cbComp = cbSelectionComponent;
      this.createBean(cbSelectionComponent);
      cbSelectionComponent.init({
        rowNode: this.params.node,
        // when groupHideOpenParents = true and group expanded, we want the checkbox to refer to leaf node state (not group node state)
        column: this.params.column,
        overrides: {
          isVisible: checkboxes,
          callbackParams: this.params,
          removeHidden: true
        }
      });
      this.eCheckbox.appendChild(cbSelectionComponent.getGui());
    }
    this.comp.setCheckboxVisible(checkboxNeeded);
  }
  destroyCheckbox() {
    this.cbComp && this.eCheckbox.removeChild(this.cbComp.getGui());
    this.cbComp = this.destroyBean(this.cbComp);
  }
  refreshCheckbox() {
    this.destroyCheckbox();
    this.addCheckboxIfNeeded();
  }
  onKeyDown(event) {
    const isEnterKey = event.key === import_ag_grid_community124.KeyCode.ENTER;
    if (!isEnterKey || this.params.suppressEnterExpand) {
      return;
    }
    const cellEditable = this.params.column && this.params.column.isCellEditable(this.params.node);
    if (cellEditable) {
      return;
    }
    this.onExpandOrContract(event);
  }
  onCellDblClicked(mouseEvent) {
    if ((0, import_ag_grid_community124._isStopPropagationForAgGrid)(mouseEvent)) {
      return;
    }
    const targetIsExpandIcon = (0, import_ag_grid_community124._isElementInEventPath)(this.eExpanded, mouseEvent) || (0, import_ag_grid_community124._isElementInEventPath)(this.eContracted, mouseEvent);
    if (!targetIsExpandIcon) {
      this.onExpandOrContract(mouseEvent);
    }
  }
};

// packages/ag-grid-enterprise/src/rowHierarchy/rendering/groupCellRenderer.ts
var groupTemplate = (
  /* html */
  `<span class="ag-cell-wrapper">
        <span class="ag-group-expanded" data-ref="eExpanded"></span>
        <span class="ag-group-contracted" data-ref="eContracted"></span>
        <span class="ag-group-checkbox ag-invisible" data-ref="eCheckbox"></span>
        <span class="ag-group-value" data-ref="eValue"></span>
        <span class="ag-group-child-count" data-ref="eChildCount"></span>
    </span>`
);
var GroupCellRenderer = class extends import_ag_grid_community125.Component {
  constructor() {
    super(groupTemplate);
    this.eExpanded = import_ag_grid_community125.RefPlaceholder;
    this.eContracted = import_ag_grid_community125.RefPlaceholder;
    this.eCheckbox = import_ag_grid_community125.RefPlaceholder;
    this.eValue = import_ag_grid_community125.RefPlaceholder;
    this.eChildCount = import_ag_grid_community125.RefPlaceholder;
  }
  init(params) {
    const compProxy = {
      setInnerRenderer: (compDetails, valueToDisplay) => this.setRenderDetails(compDetails, valueToDisplay),
      setChildCount: (count) => this.eChildCount.textContent = count,
      addOrRemoveCssClass: (cssClass, value) => this.addOrRemoveCssClass(cssClass, value),
      setContractedDisplayed: (expanded) => (0, import_ag_grid_community125._setDisplayed)(this.eContracted, expanded),
      setExpandedDisplayed: (expanded) => (0, import_ag_grid_community125._setDisplayed)(this.eExpanded, expanded),
      setCheckboxVisible: (visible) => this.eCheckbox.classList.toggle("ag-invisible", !visible)
    };
    const ctrl = this.createManagedBean(new GroupCellRendererCtrl());
    const fullWidth = !params.colDef;
    const eGui = this.getGui();
    ctrl.init(compProxy, eGui, this.eCheckbox, this.eExpanded, this.eContracted, this.constructor, params);
    if (fullWidth) {
      (0, import_ag_grid_community125._setAriaRole)(eGui, ctrl.getCellAriaRole());
    }
  }
  setRenderDetails(compDetails, valueToDisplay) {
    if (compDetails) {
      compDetails.newAgStackInstance().then((comp) => {
        if (!comp) {
          return;
        }
        const destroyComp = () => this.destroyBean(comp);
        if (this.isAlive()) {
          this.eValue.appendChild(comp.getGui());
          this.addDestroyFunc(destroyComp);
        } else {
          destroyComp();
        }
      });
    } else {
      this.eValue.innerText = valueToDisplay;
    }
  }
  destroy() {
    this.destroyBean(this.innerCellRenderer);
    super.destroy();
  }
  refresh() {
    return false;
  }
};

// packages/ag-grid-enterprise/src/rowHierarchy/showRowGroupColsService.ts
var import_ag_grid_community126 = require("ag-grid-community");
var ShowRowGroupColsService = class extends import_ag_grid_community126.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "showRowGroupCols";
  }
  refresh() {
    this.showRowGroupCols = [];
    this.showRowGroupColsMap = {};
    const { colModel, rowGroupColsSvc } = this.beans;
    colModel.getCols().forEach((col) => {
      const colDef = col.getColDef();
      const showRowGroup = colDef.showRowGroup;
      const isString2 = typeof showRowGroup === "string";
      const isTrue = showRowGroup === true;
      if (!isString2 && !isTrue) {
        return;
      }
      this.showRowGroupCols.push(col);
      if (isString2) {
        this.showRowGroupColsMap[showRowGroup] = col;
      } else if (rowGroupColsSvc) {
        rowGroupColsSvc.columns.forEach((rowGroupCol) => {
          this.showRowGroupColsMap[rowGroupCol.getId()] = col;
        });
      }
    });
  }
  getShowRowGroupCols() {
    return this.showRowGroupCols;
  }
  getShowRowGroupCol(id) {
    return this.showRowGroupColsMap[id];
  }
  getSourceColumnsForGroupColumn(groupCol) {
    const sourceColumnId = groupCol.getColDef().showRowGroup;
    if (!sourceColumnId) {
      return null;
    }
    const { rowGroupColsSvc, colModel } = this.beans;
    if (sourceColumnId === true && rowGroupColsSvc) {
      return rowGroupColsSvc.columns.slice(0);
    }
    const column = colModel.getColDefCol(sourceColumnId);
    return column ? [column] : null;
  }
  isRowGroupDisplayed(column, colId) {
    const { colDef } = column;
    if (colDef?.showRowGroup == null) {
      return false;
    }
    const showingAllGroups = colDef.showRowGroup === true;
    const showingThisGroup = colDef.showRowGroup === colId;
    return showingAllGroups || showingThisGroup;
  }
};

// packages/ag-grid-enterprise/src/rowHierarchy/stickyRowService.ts
var import_ag_grid_community128 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/rowHierarchy/stickyRowFeature.ts
var import_ag_grid_community127 = require("ag-grid-community");
var StickyRowFeature = class extends import_ag_grid_community127.BeanStub {
  constructor(createRowCon, destroyRowCtrls) {
    super();
    this.createRowCon = createRowCon;
    this.destroyRowCtrls = destroyRowCtrls;
    this.stickyTopRowCtrls = [];
    this.stickyBottomRowCtrls = [];
    // sticky rows pulls in extra rows from other pages which impacts row position
    this.extraTopHeight = 0;
    this.extraBottomHeight = 0;
  }
  postConstruct() {
    this.isClientSide = (0, import_ag_grid_community127._isClientSideRowModel)(this.gos);
    this.beans.ctrlsSvc.whenReady(this, (params) => {
      this.gridBodyCtrl = params.gridBodyCtrl;
    });
    this.resetStickyContainers();
  }
  setOffsetTop(offset) {
    if (this.extraTopHeight === offset) {
      return;
    }
    this.extraTopHeight = offset;
    this.eventSvc.dispatchEvent({
      type: "stickyTopOffsetChanged",
      offset
    });
  }
  setOffsetBottom(offset) {
    if (this.extraBottomHeight === offset) {
      return;
    }
    this.extraBottomHeight = offset;
  }
  resetOffsets() {
    this.setOffsetBottom(0);
    this.setOffsetTop(0);
  }
  /**
   * Get the last pixel of the group, this pixel is used to push the sticky node up out of the viewport.
   */
  getLastPixelOfGroup(row) {
    return this.isClientSide ? getClientSideLastPixelOfGroup(row) : getServerSideLastPixelOfGroup(row);
  }
  /**
   * Get the first pixel of the group, this pixel is used to push the sticky node down out of the viewport
   */
  getFirstPixelOfGroup(row) {
    if (row.footer) {
      return row.sibling.rowTop + row.sibling.rowHeight - 1;
    }
    if (row.hasChildren()) {
      return row.rowTop - 1;
    }
    return 0;
  }
  updateStickyRows(container) {
    const isTop = container === "top";
    let newStickyContainerHeight = 0;
    if (!this.canRowsBeSticky()) {
      return this.refreshNodesAndContainerHeight(container, /* @__PURE__ */ new Set(), newStickyContainerHeight);
    }
    const { rowModel, rowRenderer } = this.beans;
    const pixelAtContainerBoundary = isTop ? rowRenderer.firstVisibleVPixel - this.extraTopHeight : rowRenderer.lastVisibleVPixel - this.extraTopHeight;
    const newStickyRows = /* @__PURE__ */ new Set();
    const addStickyRow = (stickyRow) => {
      newStickyRows.add(stickyRow);
      if (isTop) {
        const lastChildBottom = this.getLastPixelOfGroup(stickyRow);
        const stickRowBottom = pixelAtContainerBoundary + newStickyContainerHeight + stickyRow.rowHeight;
        if (lastChildBottom < stickRowBottom) {
          stickyRow.stickyRowTop = newStickyContainerHeight + (lastChildBottom - stickRowBottom);
        } else {
          stickyRow.stickyRowTop = newStickyContainerHeight;
        }
      } else {
        const lastChildBottom = this.getFirstPixelOfGroup(stickyRow);
        const stickRowTop = pixelAtContainerBoundary - (newStickyContainerHeight + stickyRow.rowHeight);
        if (lastChildBottom > stickRowTop) {
          stickyRow.stickyRowTop = newStickyContainerHeight - (lastChildBottom - stickRowTop);
        } else {
          stickyRow.stickyRowTop = newStickyContainerHeight;
        }
      }
      newStickyContainerHeight = 0;
      newStickyRows.forEach((rowNode) => {
        const thisRowLastPx = rowNode.stickyRowTop + rowNode.rowHeight;
        if (newStickyContainerHeight < thisRowLastPx) {
          newStickyContainerHeight = thisRowLastPx;
        }
      });
    };
    const suppressFootersSticky = this.areFooterRowsStickySuppressed();
    const suppressGroupsSticky = this.gos.get("suppressGroupRowsSticky");
    const isRowSticky = (row) => {
      if (!row.displayed) {
        return false;
      }
      if (row.footer) {
        if (suppressFootersSticky === true) {
          return false;
        }
        if (suppressFootersSticky === "grand" && row.level === -1) {
          return false;
        }
        if (suppressFootersSticky === "group" && row.level > -1) {
          return false;
        }
        const isFooterFirstRowInGroup = row.sibling.rowIndex ? row.sibling.rowIndex + 1 === row.rowIndex : false;
        if (container === "bottom" && isFooterFirstRowInGroup) {
          return false;
        }
        const alreadySticking = newStickyRows.has(row);
        return !alreadySticking;
      }
      if (row.isExpandable()) {
        if (suppressGroupsSticky === true) {
          return false;
        }
        if (container === "bottom") {
          return false;
        }
        const alreadySticking = newStickyRows.has(row);
        return !alreadySticking && row.expanded;
      }
      return false;
    };
    for (let i = 0; i < 100; i++) {
      let firstPixelAfterStickyRows = pixelAtContainerBoundary + newStickyContainerHeight;
      if (!isTop) {
        firstPixelAfterStickyRows = pixelAtContainerBoundary - newStickyContainerHeight;
      }
      const firstIndex = rowModel.getRowIndexAtPixel(firstPixelAfterStickyRows);
      const firstRow = rowModel.getRow(firstIndex);
      if (firstRow == null) {
        break;
      }
      const ancestors = this.getStickyAncestors(firstRow);
      const firstMissingParent = ancestors.find(
        (parent) => (isTop ? parent.rowIndex < firstIndex : parent.rowIndex > firstIndex) && isRowSticky(parent)
      );
      if (firstMissingParent) {
        addStickyRow(firstMissingParent);
        continue;
      }
      const isFirstRowOutsideViewport = isTop ? firstRow.rowTop < firstPixelAfterStickyRows : firstRow.rowTop + firstRow.rowHeight > firstPixelAfterStickyRows;
      if (isFirstRowOutsideViewport && isRowSticky(firstRow)) {
        addStickyRow(firstRow);
        continue;
      }
      break;
    }
    if (!isTop) {
      newStickyRows.forEach((rowNode) => {
        rowNode.stickyRowTop = newStickyContainerHeight - (rowNode.stickyRowTop + rowNode.rowHeight);
      });
    }
    return this.refreshNodesAndContainerHeight(container, newStickyRows, newStickyContainerHeight);
  }
  areFooterRowsStickySuppressed() {
    const suppressFootersSticky = this.gos.get("suppressStickyTotalRow");
    if (suppressFootersSticky === true) {
      return true;
    }
    const suppressGroupRows = suppressFootersSticky === "group";
    const suppressGrandRows = suppressFootersSticky === "grand";
    if (suppressGroupRows && suppressGrandRows) {
      return true;
    }
    if (suppressGrandRows) {
      return "grand";
    }
    if (suppressGroupRows) {
      return "group";
    }
    return false;
  }
  canRowsBeSticky() {
    const isStickyEnabled = (0, import_ag_grid_community127._isGroupRowsSticky)(this.gos);
    const suppressFootersSticky = this.areFooterRowsStickySuppressed();
    const suppressGroupsSticky = this.gos.get("suppressGroupRowsSticky");
    return isStickyEnabled && (!suppressFootersSticky || !suppressGroupsSticky);
  }
  getStickyAncestors(rowNode) {
    const ancestors = [];
    let p = rowNode.footer ? rowNode.sibling : rowNode.parent;
    while (p) {
      if (p.sibling) {
        ancestors.push(p.sibling);
      }
      ancestors.push(p);
      p = p.parent;
    }
    return ancestors.reverse();
  }
  checkStickyRows() {
    const hasTopUpdated = this.updateStickyRows("top");
    const hasBottomUpdated = this.updateStickyRows("bottom");
    return hasTopUpdated || hasBottomUpdated;
  }
  destroyStickyCtrls() {
    this.resetStickyContainers();
  }
  resetStickyContainers() {
    this.refreshNodesAndContainerHeight("top", /* @__PURE__ */ new Set(), 0);
    this.refreshNodesAndContainerHeight("bottom", /* @__PURE__ */ new Set(), 0);
  }
  refreshStickyNode(stickRowNode) {
    const allStickyNodes = /* @__PURE__ */ new Set();
    if (this.stickyTopRowCtrls.some((ctrl) => ctrl.rowNode === stickRowNode)) {
      for (let i = 0; i < this.stickyTopRowCtrls.length; i++) {
        const currentNode = this.stickyTopRowCtrls[i].rowNode;
        if (currentNode !== stickRowNode) {
          allStickyNodes.add(currentNode);
        }
      }
      if (this.refreshNodesAndContainerHeight("top", allStickyNodes, this.topContainerHeight)) {
        this.checkStickyRows();
      }
      return;
    }
    for (let i = 0; i < this.stickyBottomRowCtrls.length; i++) {
      const currentNode = this.stickyBottomRowCtrls[i].rowNode;
      if (currentNode !== stickRowNode) {
        allStickyNodes.add(currentNode);
      }
    }
    if (this.refreshNodesAndContainerHeight("bottom", allStickyNodes, this.bottomContainerHeight)) {
      this.checkStickyRows();
    }
  }
  /**
   * Destroy old ctrls and create new ctrls where necessary.
   */
  refreshNodesAndContainerHeight(container, newStickyNodes, height) {
    const isTop = container === "top";
    const previousCtrls = isTop ? this.stickyTopRowCtrls : this.stickyBottomRowCtrls;
    const removedCtrlsMap = {};
    const remainingCtrls = [];
    for (let i = 0; i < previousCtrls.length; i++) {
      const node = previousCtrls[i].rowNode;
      const hasBeenRemoved = !newStickyNodes.has(node);
      if (hasBeenRemoved) {
        removedCtrlsMap[node.id] = previousCtrls[i];
        node.sticky = false;
        continue;
      }
      remainingCtrls.push(previousCtrls[i]);
    }
    const existingNodes = /* @__PURE__ */ new Set();
    for (let i = 0; i < remainingCtrls.length; i++) {
      existingNodes.add(remainingCtrls[i].rowNode);
    }
    const newCtrls = [];
    newStickyNodes.forEach((node) => {
      if (existingNodes.has(node)) {
        return;
      }
      node.sticky = true;
      newCtrls.push(this.createRowCon(node, false, false));
    });
    let hasSomethingChanged = !!newCtrls.length || remainingCtrls.length !== previousCtrls.length;
    if (isTop) {
      if (this.topContainerHeight !== height) {
        this.topContainerHeight = height;
        this.gridBodyCtrl.setStickyTopHeight(height);
        hasSomethingChanged = true;
      }
    } else {
      if (this.bottomContainerHeight !== height) {
        this.bottomContainerHeight = height;
        this.gridBodyCtrl.setStickyBottomHeight(height);
        hasSomethingChanged = true;
      }
    }
    this.destroyRowCtrls(removedCtrlsMap, false);
    const newCtrlsList = [...remainingCtrls, ...newCtrls];
    newCtrlsList.sort((a, b) => b.rowNode.rowIndex - a.rowNode.rowIndex);
    if (!isTop) {
      newCtrlsList.reverse();
    }
    newCtrlsList.forEach((ctrl) => ctrl.setRowTop(ctrl.rowNode.stickyRowTop));
    const pageBounds = this.beans.pageBounds;
    let extraHeight = 0;
    if (isTop) {
      newStickyNodes.forEach((node) => {
        if (node.rowIndex < pageBounds.getFirstRow()) {
          extraHeight += node.rowHeight;
        }
      });
      if (extraHeight > this.topContainerHeight) {
        extraHeight = this.topContainerHeight;
      }
      this.setOffsetTop(extraHeight);
    } else {
      newStickyNodes.forEach((node) => {
        if (node.rowIndex > pageBounds.getLastRow()) {
          extraHeight += node.rowHeight;
        }
      });
      if (extraHeight > this.bottomContainerHeight) {
        extraHeight = this.bottomContainerHeight;
      }
      this.setOffsetBottom(extraHeight);
    }
    if (!hasSomethingChanged) {
      return false;
    }
    if (isTop) {
      this.stickyTopRowCtrls = newCtrlsList;
    } else {
      this.stickyBottomRowCtrls = newCtrlsList;
    }
    return true;
  }
  ensureRowHeightsValid() {
    let anyChange = false;
    const updateRowHeight = (ctrl) => {
      const rowNode = ctrl.rowNode;
      if (rowNode.rowHeightEstimated) {
        const rowHeight = (0, import_ag_grid_community127._getRowHeightForNode)(this.beans, rowNode);
        rowNode.setRowHeight(rowHeight.height);
        anyChange = true;
      }
    };
    this.stickyTopRowCtrls.forEach(updateRowHeight);
    this.stickyBottomRowCtrls.forEach(updateRowHeight);
    return anyChange;
  }
};
function getServerSideLastPixelOfGroup(row) {
  if (row.isExpandable() || row.footer) {
    if (row.master && row.detailNode) {
      return row.detailNode.rowTop + row.detailNode.rowHeight;
    }
    const noOrContiguousSiblings = !row.sibling || Math.abs(row.sibling.rowIndex - row.rowIndex) === 1;
    if (noOrContiguousSiblings) {
      let storeBounds = row.childStore?.getStoreBounds();
      if (row.footer) {
        storeBounds = row.sibling.childStore?.getStoreBounds();
      }
      return (storeBounds?.heightPx ?? 0) + (storeBounds?.topPx ?? 0);
    }
    if (row.footer) {
      return row.rowTop + row.rowHeight;
    }
    return row.sibling.rowTop + row.sibling.rowHeight;
  }
  return Number.MAX_SAFE_INTEGER;
}
function getClientSideLastPixelOfGroup(row) {
  if (row.isExpandable() || row.footer) {
    const grandTotalAtTop = row.footer && row.rowIndex === 0;
    if (grandTotalAtTop) {
      return Number.MAX_SAFE_INTEGER;
    }
    const noOrContiguousSiblings = !row.sibling || Math.abs(row.sibling.rowIndex - row.rowIndex) === 1;
    if (noOrContiguousSiblings) {
      let lastAncestor = row.footer ? row.sibling : row;
      while (lastAncestor.isExpandable() && lastAncestor.expanded) {
        if (lastAncestor.master && lastAncestor.detailNode) {
          lastAncestor = lastAncestor.detailNode;
        } else if (lastAncestor.childrenAfterSort) {
          if (lastAncestor.childrenAfterSort.length === 0) {
            break;
          }
          lastAncestor = (0, import_ag_grid_community127._last)(lastAncestor.childrenAfterSort);
        }
      }
      return lastAncestor.rowTop + lastAncestor.rowHeight;
    }
    if (row.footer) {
      return row.rowTop + row.rowHeight;
    }
    return row.sibling.rowTop + row.sibling.rowHeight;
  }
  return Number.MAX_SAFE_INTEGER;
}

// packages/ag-grid-enterprise/src/rowHierarchy/stickyRowService.ts
var StickyRowService = class extends import_ag_grid_community128.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "stickyRowSvc";
  }
  createStickyRowFeature(ctrl, createRowCon, destroyRowCtrls) {
    const gos = this.gos;
    if ((0, import_ag_grid_community128._isGroupRowsSticky)(gos) && (0, import_ag_grid_community128._isClientSideRowModel)(gos) || (0, import_ag_grid_community128._isServerSideRowModel)(gos)) {
      return ctrl.createManagedBean(new StickyRowFeature(createRowCon, destroyRowCtrls));
    }
    return void 0;
  }
};

// packages/ag-grid-enterprise/src/rowHierarchy/rowHierarchyModule.ts
var GroupCellRendererModule = {
  moduleName: "GroupCellRenderer",
  version: VERSION,
  userComponents: {
    agGroupRowRenderer: GroupCellRenderer,
    agGroupCellRenderer: GroupCellRenderer
  },
  dynamicBeans: { groupCellRendererCtrl: GroupCellRendererCtrl },
  icons: {
    // shown on row group when contracted (click to expand)
    groupContracted: "tree-closed",
    // shown on row group when expanded (click to contract)
    groupExpanded: "tree-open"
  },
  dependsOn: [EnterpriseCoreModule]
};
var GroupColumnModule = {
  moduleName: "GroupColumn",
  version: VERSION,
  beans: [AutoColService, ShowRowGroupColsService, RowGroupColsSvc, PivotColsSvc, ValueColsSvc],
  dependsOn: [EnterpriseCoreModule, GroupCellRendererModule]
};
var ClientSideRowModelHierarchyModule = {
  moduleName: "ClientSideRowModelHierarchy",
  version: VERSION,
  rowModels: ["clientSide"],
  beans: [FlattenStage, ClientSideExpansionService],
  dependsOn: [EnterpriseCoreModule]
};
var StickyRowModule = {
  moduleName: "StickyRow",
  version: VERSION,
  beans: [StickyRowService]
};

// packages/ag-grid-enterprise/src/rowGrouping/columnDropZones/agGridHeaderDropZones.ts
var import_ag_grid_community129 = require("ag-grid-community");
var AgGridHeaderDropZones = class extends import_ag_grid_community129.Component {
  constructor() {
    super();
  }
  postConstruct() {
    this.setGui(this.createNorthPanel());
    const onRowGroupChanged = this.onRowGroupChanged.bind(this);
    this.addManagedEventListeners({
      columnRowGroupChanged: onRowGroupChanged,
      newColumnsLoaded: onRowGroupChanged
    });
    this.addManagedPropertyListener("rowGroupPanelShow", onRowGroupChanged);
    this.addManagedPropertyListener("pivotPanelShow", () => this.onPivotPanelShow());
    this.onRowGroupChanged();
  }
  createNorthPanel() {
    const topPanelGui = document.createElement("div");
    topPanelGui.classList.add("ag-column-drop-wrapper");
    (0, import_ag_grid_community129._setAriaRole)(topPanelGui, "presentation");
    const rowGroupComp = new RowGroupDropZonePanel(true);
    this.rowGroupComp = this.createManagedBean(rowGroupComp);
    const pivotComp = new PivotDropZonePanel(true);
    this.pivotComp = this.createManagedBean(pivotComp);
    topPanelGui.appendChild(rowGroupComp.getGui());
    topPanelGui.appendChild(pivotComp.getGui());
    const listener = this.onDropPanelVisible.bind(this);
    this.addManagedListeners(rowGroupComp, {
      displayChanged: listener
    });
    this.addManagedListeners(pivotComp, {
      displayChanged: listener
    });
    this.onDropPanelVisible();
    return topPanelGui;
  }
  onDropPanelVisible() {
    const { rowGroupComp, pivotComp } = this;
    const bothDisplayed = rowGroupComp.isDisplayed() && pivotComp.isDisplayed();
    const classStr = "ag-column-drop-horizontal-half-width";
    rowGroupComp.addOrRemoveCssClass(classStr, bothDisplayed);
    pivotComp.addOrRemoveCssClass(classStr, bothDisplayed);
  }
  onRowGroupChanged() {
    const rowGroupComp = this.rowGroupComp;
    if (!rowGroupComp) {
      return;
    }
    const rowGroupPanelShow = this.gos.get("rowGroupPanelShow");
    if (rowGroupPanelShow === "always") {
      rowGroupComp.setDisplayed(true);
    } else if (rowGroupPanelShow === "onlyWhenGrouping") {
      const grouping = this.beans.rowGroupColsSvc?.columns?.length !== 0;
      rowGroupComp.setDisplayed(grouping);
    } else {
      rowGroupComp.setDisplayed(false);
    }
  }
  onPivotPanelShow() {
    const pivotComp = this.pivotComp;
    if (!pivotComp) {
      return;
    }
    const pivotPanelShow = this.gos.get("pivotPanelShow");
    if (pivotPanelShow === "always") {
      pivotComp.setDisplayed(true);
    } else if (pivotPanelShow === "onlyWhenPivoting") {
      const pivoting = this.beans.colModel.isPivotActive();
      pivotComp.setDisplayed(pivoting);
    } else {
      pivotComp.setDisplayed(false);
    }
  }
};
var AgGridHeaderDropZonesSelector = {
  selector: "AG-GRID-HEADER-DROP-ZONES",
  component: AgGridHeaderDropZones
};

// packages/ag-grid-enterprise/src/rowGrouping/groupFilter/groupFilter.ts
var import_ag_grid_community130 = require("ag-grid-community");
var GroupFilter = class extends import_ag_grid_community130.TabGuardComp {
  constructor() {
    super(
      /* html */
      `
            <div class="ag-group-filter">
                <div data-ref="eGroupField"></div>
                <div data-ref="eUnderlyingFilter"></div>
            </div>
        `
    );
    this.filterType = "group";
    this.eGroupField = import_ag_grid_community130.RefPlaceholder;
    this.eUnderlyingFilter = import_ag_grid_community130.RefPlaceholder;
  }
  wireBeans(beans) {
    this.filterManager = beans.filterManager;
    this.showRowGroupCols = beans.showRowGroupCols;
  }
  postConstruct() {
    this.initialiseTabGuard({});
  }
  init(params) {
    return this.updateParams(params).then(() => {
      this.addManagedEventListeners({
        columnRowGroupChanged: () => this.onColumnRowGroupChanged(),
        filterDestroyed: (event) => this.onFilterDestroyed(event)
      });
    });
  }
  refresh(params) {
    this.updateParams(params);
    return true;
  }
  updateParams(params) {
    this.params = params;
    this.validateParams();
    return this.updateGroups();
  }
  validateParams() {
    const { colDef } = this.params;
    if (colDef.field) {
      (0, import_ag_grid_community130._warn)(234);
    }
    if (colDef.filterValueGetter) {
      (0, import_ag_grid_community130._warn)(235);
    }
    if (colDef.filterParams) {
      (0, import_ag_grid_community130._warn)(236);
    }
  }
  updateGroups() {
    const sourceColumns = this.updateGroupField();
    return this.getUnderlyingFilters(sourceColumns);
  }
  getSourceColumns() {
    this.groupColumn = this.params.column;
    if (this.gos.get("treeData")) {
      (0, import_ag_grid_community130._warn)(237);
      return [];
    }
    const sourceColumns = this.showRowGroupCols?.getSourceColumnsForGroupColumn(this.groupColumn);
    if (!sourceColumns) {
      (0, import_ag_grid_community130._warn)(183);
      return [];
    }
    return sourceColumns;
  }
  updateGroupField() {
    const eGroupField = this.eGroupField;
    (0, import_ag_grid_community130._clearElement)(eGroupField);
    if (this.eGroupFieldSelect) {
      this.destroyBean(this.eGroupFieldSelect);
    }
    const allSourceColumns = this.getSourceColumns();
    const sourceColumns = allSourceColumns.filter((sourceColumn) => sourceColumn.isFilterAllowed());
    if (!sourceColumns.length) {
      this.selectedColumn = void 0;
      (0, import_ag_grid_community130._setDisplayed)(eGroupField, false);
      return null;
    }
    if (allSourceColumns.length === 1) {
      this.selectedColumn = sourceColumns[0];
      (0, import_ag_grid_community130._setDisplayed)(eGroupField, false);
    } else {
      if (!this.selectedColumn || !sourceColumns.some((column) => column.getId() === this.selectedColumn.getId())) {
        this.selectedColumn = sourceColumns[0];
      }
      this.createGroupFieldSelectElement(sourceColumns);
      eGroupField.appendChild(this.eGroupFieldSelect.getGui());
      eGroupField.appendChild((0, import_ag_grid_community130._loadTemplate)(
        /* html */
        `<div class="ag-filter-separator"></div>`
      ));
      (0, import_ag_grid_community130._setDisplayed)(eGroupField, true);
    }
    return sourceColumns;
  }
  createGroupFieldSelectElement(sourceColumns) {
    const eGroupFieldSelect = this.createManagedBean(new import_ag_grid_community130.AgSelect());
    this.eGroupFieldSelect = eGroupFieldSelect;
    const localeTextFunc = this.getLocaleTextFunc();
    eGroupFieldSelect.setLabel(localeTextFunc("groupFilterSelect", "Select field:"));
    eGroupFieldSelect.setLabelAlignment("top");
    eGroupFieldSelect.addOptions(
      sourceColumns.map((sourceColumn) => ({
        value: sourceColumn.getId(),
        text: this.beans.colNames.getDisplayNameForColumn(sourceColumn, "groupFilter", false) ?? void 0
      }))
    );
    eGroupFieldSelect.setValue(this.selectedColumn.getId());
    eGroupFieldSelect.onValueChange((newValue) => this.updateSelectedColumn(newValue));
    eGroupFieldSelect.addCssClass("ag-group-filter-field-select-wrapper");
    if (sourceColumns.length === 1) {
      eGroupFieldSelect.setDisabled(true);
    }
  }
  getUnderlyingFilters(sourceColumns) {
    if (!sourceColumns) {
      this.filterColumnPairs = void 0;
      this.selectedFilter = void 0;
      this.beans.colFilter?.setColFilterActive(this.groupColumn, false, "columnRowGroupChanged");
      return import_ag_grid_community130.AgPromise.resolve();
    }
    const filterPromises = [];
    const filterColumnPairs = [];
    sourceColumns.forEach((column) => {
      const filterWrapper = this.filterManager.getOrCreateFilterWrapper(column);
      if (filterWrapper?.filterPromise) {
        filterPromises.push(
          filterWrapper.filterPromise.then((filter) => {
            if (filter) {
              filterColumnPairs.push({
                filter,
                column
              });
            }
            if (column.getId() === this.selectedColumn.getId()) {
              this.selectedFilter = filter ?? void 0;
            }
            return filter;
          })
        );
      }
    });
    return import_ag_grid_community130.AgPromise.all(filterPromises).then(() => {
      this.filterColumnPairs = filterColumnPairs;
      this.beans.colFilter?.setColFilterActive(this.groupColumn, this.isFilterActive(), "columnRowGroupChanged");
    });
  }
  addUnderlyingFilterElement() {
    (0, import_ag_grid_community130._clearElement)(this.eUnderlyingFilter);
    if (!this.selectedColumn) {
      return import_ag_grid_community130.AgPromise.resolve();
    }
    const comp = this.createManagedBean(new import_ag_grid_community130.FilterWrapperComp(this.selectedColumn, "COLUMN_MENU"));
    this.filterWrapperComp = comp;
    if (!comp.hasFilter()) {
      return import_ag_grid_community130.AgPromise.resolve();
    }
    this.eUnderlyingFilter.appendChild(comp.getGui());
    return comp.getFilter()?.then(() => {
      comp.afterGuiAttached?.(this.afterGuiAttachedParams);
      if (!this.afterGuiAttachedParams?.suppressFocus && this.eGroupFieldSelect && !this.eGroupFieldSelect.isDisabled()) {
        this.eGroupFieldSelect.getFocusableElement().focus();
      }
    }) ?? import_ag_grid_community130.AgPromise.resolve();
  }
  updateSelectedColumn(columnId) {
    if (!columnId) {
      return;
    }
    this.filterWrapperComp?.afterGuiDetached();
    this.destroyBean(this.filterWrapperComp);
    const selectedFilterColumnPair = this.getFilterColumnPair(columnId);
    this.selectedColumn = selectedFilterColumnPair?.column;
    this.selectedFilter = selectedFilterColumnPair?.filter;
    this.dispatchLocalEvent({
      type: "selectedColumnChanged"
    });
    this.addUnderlyingFilterElement();
  }
  isFilterActive() {
    return !!this.filterColumnPairs?.some(({ filter }) => filter.isFilterActive());
  }
  doesFilterPass() {
    return true;
  }
  getModel() {
    return null;
  }
  setModel() {
    return import_ag_grid_community130.AgPromise.resolve();
  }
  afterGuiAttached(params) {
    this.afterGuiAttachedParams = params;
    this.addUnderlyingFilterElement();
  }
  afterGuiDetached() {
    (0, import_ag_grid_community130._clearElement)(this.eUnderlyingFilter);
    this.selectedFilter?.afterGuiDetached?.();
  }
  onColumnRowGroupChanged() {
    this.updateGroups().then(() => {
      this.dispatchLocalEvent({
        type: "columnRowGroupChanged"
      });
    });
  }
  onFilterDestroyed({ column: eventColumn, source }) {
    if (source === "gridDestroyed") {
      return;
    }
    const colId = eventColumn.getColId();
    if (this.filterColumnPairs?.some(({ column }) => column.getColId() === colId)) {
      setTimeout(() => {
        if (this.isAlive()) {
          this.updateGroups();
        }
      });
    }
  }
  getFilterColumnPair(columnId) {
    if (!columnId) {
      return void 0;
    }
    return this.filterColumnPairs?.find(({ column }) => column.getId() === columnId);
  }
  getSelectedFilter() {
    return this.selectedFilter;
  }
  getSelectedColumn() {
    return this.selectedColumn;
  }
  isFilterAllowed() {
    return !!this.selectedColumn;
  }
};

// packages/ag-grid-enterprise/src/rowGrouping/groupFilter/groupFloatingFilter.ts
var import_ag_grid_community131 = require("ag-grid-community");
var GroupFloatingFilterComp = class extends import_ag_grid_community131.Component {
  constructor() {
    super(
      /* html */
      `
            <div data-ref="eFloatingFilter" class="ag-group-floating-filter ag-floating-filter-input" role="presentation"></div>
        `
    );
    this.eFloatingFilter = import_ag_grid_community131.RefPlaceholder;
    this.haveAddedColumnListeners = false;
  }
  wireBeans(beans) {
    this.filterManager = beans.filterManager;
  }
  init(params) {
    this.params = params;
    const canShowUnderlyingFloatingFilter = this.gos.get("groupDisplayType") === "multipleColumns";
    return new import_ag_grid_community131.AgPromise((resolve) => {
      this.params.parentFilterInstance((parentFilterInstance) => {
        this.parentFilterInstance = parentFilterInstance;
        if (canShowUnderlyingFloatingFilter) {
          this.setupUnderlyingFloatingFilterElement().then(() => resolve());
        } else {
          this.setupReadOnlyFloatingFilterElement();
          resolve();
        }
      });
    }).then(() => {
      const onColChange = this.onColChange.bind(this);
      this.addManagedListeners(this.parentFilterInstance, {
        selectedColumnChanged: onColChange,
        columnRowGroupChanged: onColChange
      });
    });
  }
  refresh(params) {
    this.params = params;
    this.setParams();
  }
  setParams() {
    const displayName = this.beans.colNames.getDisplayNameForColumn(this.params.column, "header", true);
    const translate = this.getLocaleTextFunc();
    this.eFloatingFilterText?.setInputAriaLabel(`${displayName} ${translate("ariaFilterInput", "Filter Input")}`);
  }
  setupReadOnlyFloatingFilterElement() {
    if (!this.eFloatingFilterText) {
      this.eFloatingFilterText = this.createManagedBean(new import_ag_grid_community131.AgInputTextField());
      this.eFloatingFilterText.setDisabled(true).addGuiEventListener("click", () => this.params.showParentFilter());
      this.setParams();
    }
    this.updateDisplayedValue();
    this.eFloatingFilter.appendChild(this.eFloatingFilterText.getGui());
  }
  setupUnderlyingFloatingFilterElement() {
    this.showingUnderlyingFloatingFilter = false;
    this.underlyingFloatingFilter = void 0;
    (0, import_ag_grid_community131._clearElement)(this.eFloatingFilter);
    const column = this.parentFilterInstance.getSelectedColumn();
    if (column && !column.isVisible()) {
      const compDetails = this.filterManager.getFloatingFilterCompDetails(column, this.params.showParentFilter);
      if (compDetails) {
        if (!this.haveAddedColumnListeners) {
          this.haveAddedColumnListeners = true;
          this.addManagedListeners(column, {
            visibleChanged: this.onColumnVisibleChanged.bind(this),
            colDefChanged: this.onColDefChanged.bind(this)
          });
        }
        return compDetails.newAgStackInstance().then((floatingFilter) => {
          this.underlyingFloatingFilter = floatingFilter;
          this.underlyingFloatingFilter?.onParentModelChanged(
            this.parentFilterInstance.getSelectedFilter()?.getModel()
          );
          this.appendChild(floatingFilter.getGui());
          this.showingUnderlyingFloatingFilter = true;
        });
      }
    }
    this.setupReadOnlyFloatingFilterElement();
    return import_ag_grid_community131.AgPromise.resolve();
  }
  onColumnVisibleChanged() {
    this.setupUnderlyingFloatingFilterElement();
  }
  onColDefChanged(event) {
    if (!event.column) {
      return;
    }
    const compDetails = this.filterManager.getFloatingFilterCompDetails(
      event.column,
      this.params.showParentFilter
    );
    if (compDetails) {
      this.underlyingFloatingFilter?.refresh?.(compDetails.params);
    }
  }
  onParentModelChanged(_model, event) {
    if (this.showingUnderlyingFloatingFilter) {
      this.underlyingFloatingFilter?.onParentModelChanged(
        this.parentFilterInstance.getSelectedFilter()?.getModel(),
        event
      );
    } else {
      this.updateDisplayedValue();
    }
  }
  updateDisplayedValue() {
    const { eFloatingFilterText, parentFilterInstance } = this;
    if (!parentFilterInstance || !eFloatingFilterText) {
      return;
    }
    const selectedFilter = parentFilterInstance.getSelectedFilter();
    if (!selectedFilter) {
      eFloatingFilterText.setValue("");
      eFloatingFilterText.setDisplayed(false);
      return;
    }
    eFloatingFilterText.setDisplayed(true);
    if (selectedFilter.getModelAsString) {
      const filterModel = selectedFilter.getModel();
      eFloatingFilterText.setValue(filterModel == null ? "" : selectedFilter.getModelAsString(filterModel));
    } else {
      eFloatingFilterText.setValue("");
    }
  }
  onColChange() {
    if (!this.showingUnderlyingFloatingFilter) {
      this.updateDisplayedValue();
    }
  }
};

// packages/ag-grid-enterprise/src/rowGrouping/groupHideOpenParentsService.ts
var import_ag_grid_community132 = require("ag-grid-community");
var GroupHideOpenParentsService = class extends import_ag_grid_community132.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "groupHideOpenParentsSvc";
  }
  updateGroupDataForHideOpenParents(changedPath) {
    if (!this.gos.get("groupHideOpenParents") || this.gos.get("treeData")) {
      return;
    }
    const callback = (rowNode) => {
      this.pullDownGroupDataForHideOpenParents(rowNode.childrenAfterSort, false);
      rowNode.childrenAfterSort.forEach((child) => {
        if (child.hasChildren()) {
          callback(child);
        }
      });
    };
    if (changedPath) {
      changedPath.executeFromRootNode((rowNode) => callback(rowNode));
    }
  }
  pullDownGroupDataForHideOpenParents(rowNodes, clearOperation) {
    if (!this.gos.get("groupHideOpenParents") || (0, import_ag_grid_community132._missing)(rowNodes)) {
      return;
    }
    const { colModel, showRowGroupCols } = this.beans;
    rowNodes.forEach((childRowNode) => {
      const groupDisplayCols = showRowGroupCols?.getShowRowGroupCols() ?? [];
      groupDisplayCols.forEach((groupDisplayCol) => {
        const showRowGroup = groupDisplayCol.getColDef().showRowGroup;
        if (typeof showRowGroup !== "string") {
          (0, import_ag_grid_community132._error)(110);
          return;
        }
        const displayingGroupKey = showRowGroup;
        const rowGroupColumn = colModel.getColDefCol(displayingGroupKey);
        const thisRowNodeMatches = rowGroupColumn === childRowNode.rowGroupColumn;
        if (thisRowNodeMatches) {
          return;
        }
        if (clearOperation) {
          setRowNodeGroupValue(childRowNode, colModel, groupDisplayCol.getId(), void 0);
        } else {
          const parentToStealFrom = this.getFirstChildOfFirstChild(childRowNode, rowGroupColumn);
          if (parentToStealFrom) {
            setRowNodeGroupValue(childRowNode, colModel, groupDisplayCol.getId(), parentToStealFrom.key);
          }
        }
      });
    });
  }
  isShowingValueForOpenedParent(rowNode, column) {
    if (!this.gos.get("groupHideOpenParents")) {
      return false;
    }
    if (!rowNode.groupData) {
      return false;
    }
    const showingGroupNode = rowNode.rowGroupColumn != null;
    if (showingGroupNode) {
      const keyOfGroupingColumn = rowNode.rowGroupColumn.getId();
      const configuredToShowThisGroupLevel = column.isRowGroupDisplayed(keyOfGroupingColumn);
      if (configuredToShowThisGroupLevel) {
        return false;
      }
    }
    return rowNode.groupData[column.getId()] != null;
  }
  getFirstChildOfFirstChild(node, rowGroupColumn) {
    let currentRowNode = node;
    while (currentRowNode) {
      const parentRowNode = currentRowNode.parent;
      if (parentRowNode?.childrenAfterSort && currentRowNode === parentRowNode.childrenAfterSort[0]) {
        if (parentRowNode.rowGroupColumn === rowGroupColumn) {
          return parentRowNode;
        }
      } else {
        return null;
      }
      currentRowNode = parentRowNode;
    }
    return null;
  }
};

// packages/ag-grid-enterprise/src/rowGrouping/groupStage/groupStage.ts
var import_ag_grid_community133 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/rowGrouping/groupStage/batchRemover.ts
var BatchRemover = class {
  constructor() {
    this.allSets = {};
    this.allParents = [];
  }
  removeFromChildrenAfterGroup(parent, child) {
    const set2 = this.getSet(parent);
    set2.removeFromChildrenAfterGroup[child.id] = true;
  }
  isRemoveFromAllLeafChildren(parent, child) {
    const set2 = this.getSet(parent);
    return !!set2.removeFromAllLeafChildren[child.id];
  }
  preventRemoveFromAllLeafChildren(parent, child) {
    const set2 = this.getSet(parent);
    delete set2.removeFromAllLeafChildren[child.id];
  }
  removeFromAllLeafChildren(parent, child) {
    const set2 = this.getSet(parent);
    set2.removeFromAllLeafChildren[child.id] = true;
  }
  getSet(parent) {
    if (!this.allSets[parent.id]) {
      this.allSets[parent.id] = {
        removeFromAllLeafChildren: {},
        removeFromChildrenAfterGroup: {}
      };
      this.allParents.push(parent);
    }
    return this.allSets[parent.id];
  }
  getAllParents() {
    return this.allParents;
  }
  flush() {
    this.allParents.forEach((parent) => {
      const nodeDetails = this.allSets[parent.id];
      parent.childrenAfterGroup = parent.childrenAfterGroup.filter(
        (child) => !nodeDetails.removeFromChildrenAfterGroup[child.id]
      );
      parent.allLeafChildren = parent.allLeafChildren?.filter((child) => !nodeDetails.removeFromAllLeafChildren[child.id]) ?? null;
      parent.updateHasChildren();
      const sibling = parent.sibling;
      if (sibling) {
        sibling.childrenAfterGroup = parent.childrenAfterGroup;
        sibling.allLeafChildren = parent.allLeafChildren;
      }
    });
    this.allSets = {};
    this.allParents.length = 0;
  }
};

// packages/ag-grid-enterprise/src/rowGrouping/groupStage/sortGroupChildren.ts
function sortGroupChildren(rowNodes) {
  if (!rowNodes) {
    return false;
  }
  const length = rowNodes.length;
  if (length < 2) {
    return false;
  }
  let atLeastOneOutOfOrder = false;
  for (let i = 1; i < length; i++) {
    if (compareGroupChildren(rowNodes[i - 1], rowNodes[i]) > 0) {
      atLeastOneOutOfOrder = true;
      break;
    }
  }
  if (!atLeastOneOutOfOrder) {
    return false;
  }
  rowNodes.sort(compareGroupChildren);
  return true;
}
function compareGroupChildren(nodeA, nodeB) {
  const positionA = nodeA.sourceRowIndex;
  const positionB = nodeB.sourceRowIndex;
  const aHasIndex = positionA >= 0;
  const bHasIndex = positionB >= 0;
  const bothNodesAreUserNodes = aHasIndex && bHasIndex;
  const bothNodesAreFillerNodes = !aHasIndex && !bHasIndex;
  if (bothNodesAreUserNodes) {
    return positionA - positionB;
  }
  if (bothNodesAreFillerNodes) {
    return nodeA.__objectId - nodeB.__objectId;
  }
  if (aHasIndex) {
    return 1;
  }
  return -1;
}

// packages/ag-grid-enterprise/src/rowGrouping/groupStage/groupStage.ts
var GroupStage = class extends import_ag_grid_community133.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "groupStage";
    this.refreshProps = /* @__PURE__ */ new Set([
      "groupDefaultExpanded",
      "groupAllowUnbalanced",
      "initialGroupOrderComparator",
      "groupHideOpenParents",
      "groupDisplayType"
    ]);
    this.step = "group";
  }
  wireBeans(beans) {
    this.colModel = beans.colModel;
    this.rowGroupColsSvc = beans.rowGroupColsSvc;
    this.valueSvc = beans.valueSvc;
    this.selectionSvc = beans.selectionSvc;
    this.showRowGroupCols = beans.showRowGroupCols;
  }
  execute(params) {
    const details = this.createGroupingDetails(params);
    const changedRowNodes = params.changedRowNodes;
    if (changedRowNodes) {
      this.handleDeltaUpdate(details, changedRowNodes);
    } else {
      this.shotgunResetEverything(details, !!params.afterColumnsChanged);
    }
    const changedPath = params.changedPath;
    this.positionLeafsAndGroups(changedPath);
    this.orderGroups(details);
    this.selectionSvc?.updateSelectableAfterGrouping(changedPath);
  }
  positionLeafsAndGroups(changedPath) {
    changedPath.forEachChangedNodeDepthFirst((group) => {
      if (group.childrenAfterGroup) {
        const leafNodes = [];
        const groupNodes = [];
        let unbalancedNode;
        group.childrenAfterGroup.forEach((row) => {
          if (!row.childrenAfterGroup?.length) {
            leafNodes.push(row);
          } else {
            if (row.key === "" && !unbalancedNode) {
              unbalancedNode = row;
            } else {
              groupNodes.push(row);
            }
          }
        });
        if (unbalancedNode) {
          groupNodes.push(unbalancedNode);
        }
        group.childrenAfterGroup = [...leafNodes, ...groupNodes];
      }
    }, false);
  }
  createGroupingDetails(params) {
    const { rowNode, changedPath, rowNodesOrderChanged } = params;
    const groupedCols = this.rowGroupColsSvc?.columns;
    const details = {
      expandByDefault: this.gos.get("groupDefaultExpanded"),
      groupedCols,
      rootNode: rowNode,
      pivotMode: this.colModel.isPivotMode(),
      groupedColCount: groupedCols?.length ?? 0,
      rowNodesOrderChanged: !!rowNodesOrderChanged,
      // if no transaction and not immutable row data set, then it's shotgun, changed path would be 'not active' at this point anyway
      changedPath,
      groupAllowUnbalanced: this.gos.get("groupAllowUnbalanced"),
      isGroupOpenByDefault: this.gos.getCallback("isGroupOpenByDefault"),
      initialGroupOrderComparator: this.gos.getCallback("initialGroupOrderComparator"),
      keyCreators: groupedCols?.map((column) => column.getColDef().keyCreator) ?? []
    };
    return details;
  }
  handleDeltaUpdate(details, { removals, updates, adds }) {
    const batchRemover = new BatchRemover();
    if (removals.size) {
      this.removeNodes(removals, details, batchRemover);
    }
    for (const rowNode of updates) {
      this.moveNodeInWrongPath(rowNode, details, batchRemover);
    }
    const changedPath = details.changedPath;
    for (const rowNode of adds) {
      this.insertOneNode(rowNode, details);
      if (changedPath.active) {
        changedPath.addParentNode(rowNode.parent);
      }
    }
    const parentsWithChildrenRemoved = batchRemover.getAllParents().slice();
    batchRemover.flush();
    this.removeEmptyGroups(parentsWithChildrenRemoved, details);
    if (details.rowNodesOrderChanged) {
      this.sortChildren(details);
    }
  }
  // this is used when doing delta updates, eg Redux, keeps nodes in right order
  sortChildren(details) {
    details.changedPath.forEachChangedNodeDepthFirst(
      (node) => {
        const didSort = sortGroupChildren(node.childrenAfterGroup);
        if (didSort) {
          details.changedPath.addParentNode(node);
        }
      },
      false,
      true
    );
  }
  orderGroups(details) {
    const comparator = details.initialGroupOrderComparator;
    if ((0, import_ag_grid_community133._exists)(comparator)) {
      recursiveSort(details.rootNode);
    }
    function recursiveSort(rowNode) {
      const doSort = (0, import_ag_grid_community133._exists)(rowNode.childrenAfterGroup) && // we only want to sort groups, so we do not sort leafs (a leaf group has leafs as children)
      !rowNode.leafGroup;
      if (doSort) {
        rowNode.childrenAfterGroup.sort((nodeA, nodeB) => comparator({ nodeA, nodeB }));
        rowNode.childrenAfterGroup.forEach((childNode) => recursiveSort(childNode));
      }
    }
  }
  getExistingPathForNode(node, details) {
    const res = [];
    let pointer = node.parent;
    while (pointer && pointer !== details.rootNode) {
      res.push({
        key: pointer.key,
        rowGroupColumn: pointer.rowGroupColumn,
        field: pointer.field
      });
      pointer = pointer.parent;
    }
    res.reverse();
    return res;
  }
  moveNodeInWrongPath(childNode, details, batchRemover) {
    if (details.changedPath.active) {
      details.changedPath.addParentNode(childNode.parent);
    }
    const infoToKeyMapper = (item) => item.key;
    const oldPath = this.getExistingPathForNode(childNode, details).map(infoToKeyMapper);
    const newPath = this.getGroupInfo(childNode, details).map(infoToKeyMapper);
    const nodeInCorrectPath = (0, import_ag_grid_community133._areEqual)(oldPath, newPath);
    if (!nodeInCorrectPath) {
      this.moveNode(childNode, details, batchRemover);
    }
  }
  moveNode(childNode, details, batchRemover) {
    this.removeNodesFromParents([childNode], details, batchRemover);
    this.insertOneNode(childNode, details, batchRemover);
    childNode.setData(childNode.data);
    if (details.changedPath.active) {
      const newParent = childNode.parent;
      details.changedPath.addParentNode(newParent);
    }
  }
  removeNodes(leafRowNodes, details, batchRemover) {
    this.removeNodesFromParents(leafRowNodes, details, batchRemover);
    if (details.changedPath.active) {
      for (const rowNode of leafRowNodes) {
        details.changedPath.addParentNode(rowNode.parent);
      }
    }
  }
  forEachParentGroup(details, group, callback) {
    let pointer = group;
    while (pointer && pointer !== details.rootNode) {
      callback(pointer);
      pointer = pointer.parent;
    }
  }
  removeNodesFromParents(nodesToRemove, details, provided) {
    const batchRemoverIsLocal = provided == null;
    const batchRemoverToUse = provided ? provided : new BatchRemover();
    for (const nodeToRemove of nodesToRemove) {
      this.removeFromParent(nodeToRemove, batchRemoverToUse);
      this.forEachParentGroup(details, nodeToRemove.parent, (parentNode) => {
        batchRemoverToUse.removeFromAllLeafChildren(parentNode, nodeToRemove);
      });
    }
    if (batchRemoverIsLocal) {
      batchRemoverToUse.flush();
    }
  }
  removeEmptyGroups(possibleEmptyGroups, details) {
    let checkAgain = true;
    const groupShouldBeRemoved = (rowNode) => {
      const mapKey = this.getChildrenMappedKey(rowNode.key, rowNode.rowGroupColumn);
      const parentRowNode = rowNode.parent;
      const groupAlreadyRemoved = parentRowNode?.childrenMapped ? !parentRowNode.childrenMapped[mapKey] : true;
      if (groupAlreadyRemoved) {
        return false;
      }
      return !!rowNode.group && (rowNode.childrenAfterGroup?.length ?? 0) === 0;
    };
    while (checkAgain) {
      checkAgain = false;
      const batchRemover = new BatchRemover();
      possibleEmptyGroups.forEach((possibleEmptyGroup) => {
        this.forEachParentGroup(details, possibleEmptyGroup, (rowNode) => {
          if (groupShouldBeRemoved(rowNode)) {
            checkAgain = true;
            this.removeFromParent(rowNode, batchRemover);
            this.selectionSvc?.setNodesSelected({
              nodes: [rowNode],
              newValue: false,
              source: "rowGroupChanged"
            });
          }
        });
      });
      batchRemover.flush();
    }
  }
  // removes the node from the parent by:
  // a) removing from childrenAfterGroup (using batchRemover if present, otherwise immediately)
  // b) removing from childrenMapped (immediately)
  // c) setRowTop(null) - as the rowRenderer uses this to know the RowNode is no longer needed
  // d) setRowIndex(null) - as the rowNode will no longer be displayed.
  removeFromParent(child, batchRemover) {
    if (child.parent) {
      if (batchRemover) {
        batchRemover.removeFromChildrenAfterGroup(child.parent, child);
      } else {
        (0, import_ag_grid_community133._removeFromArray)(child.parent.childrenAfterGroup, child);
        child.parent.updateHasChildren();
      }
    }
    const mapKey = this.getChildrenMappedKey(child.key, child.rowGroupColumn);
    if (child.parent?.childrenMapped) {
      delete child.parent.childrenMapped[mapKey];
    }
    child.setRowTop(null);
    child.setRowIndex(null);
  }
  /**
   * This is idempotent, but relies on the `key` field being the same throughout a RowNode's lifetime
   */
  addToParent(child, parent) {
    const mapKey = this.getChildrenMappedKey(child.key, child.rowGroupColumn);
    if (parent?.childrenMapped) {
      if (parent.childrenMapped[mapKey] !== child) {
        parent.childrenMapped[mapKey] = child;
        parent.childrenAfterGroup.push(child);
        setRowNodeGroup(parent, this.beans, true);
      }
    }
  }
  areGroupColsEqual(d1, d2) {
    if (d1 == null || d2 == null || d1.pivotMode !== d2.pivotMode) {
      return false;
    }
    return (0, import_ag_grid_community133._areEqual)(d1.groupedCols, d2.groupedCols) && (0, import_ag_grid_community133._areEqual)(d1.keyCreators, d2.keyCreators);
  }
  checkAllGroupDataAfterColsChanged(details) {
    const recurse = (rowNodes) => {
      if (!rowNodes) {
        return;
      }
      rowNodes.forEach((rowNode) => {
        const isLeafNode = !rowNode.group;
        if (isLeafNode) {
          return;
        }
        const groupInfo = {
          field: rowNode.field,
          key: rowNode.key,
          rowGroupColumn: rowNode.rowGroupColumn,
          leafNode: rowNode.allLeafChildren?.[0]
        };
        this.setGroupData(rowNode, groupInfo);
        recurse(rowNode.childrenAfterGroup);
      });
    };
    recurse(details.rootNode.childrenAfterGroup);
  }
  shotgunResetEverything(details, afterColumnsChanged) {
    if (this.noChangeInGroupingColumns(details, afterColumnsChanged)) {
      return;
    }
    this.selectionSvc?.filterFromSelection?.((node) => !node.group);
    const { groupedCols } = details;
    const rootNode = details.rootNode;
    rootNode.leafGroup = groupedCols.length === 0;
    rootNode.childrenAfterGroup = [];
    rootNode.childrenMapped = {};
    rootNode.updateHasChildren();
    const sibling = rootNode.sibling;
    if (sibling) {
      sibling.childrenAfterGroup = rootNode.childrenAfterGroup;
      sibling.childrenMapped = rootNode.childrenMapped;
    }
    this.insertNodes(rootNode.allLeafChildren, details);
  }
  noChangeInGroupingColumns(details, afterColumnsChanged) {
    let noFurtherProcessingNeeded = false;
    const groupDisplayColumns = this.showRowGroupCols.getShowRowGroupCols();
    const newGroupDisplayColIds = groupDisplayColumns ? groupDisplayColumns.map((c) => c.getId()).join("-") : "";
    if (afterColumnsChanged) {
      noFurtherProcessingNeeded = this.areGroupColsEqual(details, this.oldGroupingDetails);
      if (this.oldGroupDisplayColIds !== newGroupDisplayColIds) {
        this.checkAllGroupDataAfterColsChanged(details);
      }
    }
    this.oldGroupingDetails = details;
    this.oldGroupDisplayColIds = newGroupDisplayColIds;
    return noFurtherProcessingNeeded;
  }
  insertNodes(newRowNodes, details) {
    newRowNodes.forEach((rowNode) => {
      this.insertOneNode(rowNode, details);
      if (details.changedPath.active) {
        details.changedPath.addParentNode(rowNode.parent);
      }
    });
  }
  insertOneNode(childNode, details, batchRemover) {
    const path = this.getGroupInfo(childNode, details);
    const parentGroup = this.findParentForNode(childNode, path, details, batchRemover);
    if (!parentGroup.group) {
      (0, import_ag_grid_community133._warn)(184, { parentGroupData: parentGroup.data, childNodeData: childNode.data });
    }
    childNode.parent = parentGroup;
    childNode.level = path.length;
    parentGroup.childrenAfterGroup.push(childNode);
    parentGroup.updateHasChildren();
  }
  findParentForNode(childNode, path, details, batchRemover) {
    let nextNode = details.rootNode;
    path.forEach((groupInfo, level) => {
      nextNode = this.getOrCreateNextNode(nextNode, groupInfo, level, details);
      if (!batchRemover?.isRemoveFromAllLeafChildren(nextNode, childNode)) {
        nextNode.allLeafChildren.push(childNode);
      } else {
        batchRemover?.preventRemoveFromAllLeafChildren(nextNode, childNode);
      }
    });
    return nextNode;
  }
  getOrCreateNextNode(parentGroup, groupInfo, level, details) {
    const key = this.getChildrenMappedKey(groupInfo.key, groupInfo.rowGroupColumn);
    let nextNode = parentGroup?.childrenMapped?.[key];
    if (!nextNode) {
      nextNode = this.createGroup(groupInfo, parentGroup, level, details);
      this.addToParent(nextNode, parentGroup);
    }
    return nextNode;
  }
  createGroup(groupInfo, parent, level, details) {
    const groupNode = new import_ag_grid_community133.RowNode(this.beans);
    groupNode.group = true;
    groupNode.field = groupInfo.field;
    groupNode.rowGroupColumn = groupInfo.rowGroupColumn;
    this.setGroupData(groupNode, groupInfo);
    groupNode.key = groupInfo.key;
    groupNode.id = this.createGroupId(groupNode, parent, level);
    groupNode.level = level;
    groupNode.leafGroup = level === details.groupedColCount - 1;
    groupNode.allLeafChildren = [];
    groupNode.setAllChildrenCount(0);
    groupNode.rowGroupIndex = level;
    groupNode.childrenAfterGroup = [];
    groupNode.childrenMapped = {};
    groupNode.updateHasChildren();
    groupNode.parent = parent;
    this.setExpandedInitialValue(details, groupNode);
    return groupNode;
  }
  createGroupId(node, parent, level) {
    const createGroupId = (node2, parent2) => {
      if (!node2.rowGroupColumn) {
        return null;
      }
      const parentId = parent2 ? createGroupId(parent2, parent2.parent, 0) : null;
      return `${parentId == null ? "" : parentId + "-"}${node2.rowGroupColumn.getColId()}-${node2.key}`;
    };
    return import_ag_grid_community133._ROW_ID_PREFIX_ROW_GROUP + createGroupId(node, parent, level);
  }
  setGroupData(groupNode, groupInfo) {
    groupNode.groupData = {};
    const groupDisplayCols = this.showRowGroupCols.getShowRowGroupCols();
    groupDisplayCols.forEach((col) => {
      const groupColumn = groupNode.rowGroupColumn;
      const isRowGroupDisplayed = groupColumn !== null && col.isRowGroupDisplayed(groupColumn.getId());
      if (isRowGroupDisplayed) {
        groupNode.groupData[col.getColId()] = this.valueSvc.getValue(groupColumn, groupInfo.leafNode);
      }
    });
  }
  getChildrenMappedKey(key, rowGroupColumn) {
    return rowGroupColumn ? rowGroupColumn.getId() + "-" + key : key;
  }
  setExpandedInitialValue(details, groupNode) {
    if (details.pivotMode && groupNode.leafGroup) {
      groupNode.expanded = false;
      return;
    }
    const userCallback = details.isGroupOpenByDefault;
    if (userCallback) {
      const params = {
        rowNode: groupNode,
        field: groupNode.field,
        key: groupNode.key,
        level: groupNode.level,
        rowGroupColumn: groupNode.rowGroupColumn
      };
      groupNode.expanded = userCallback(params) == true;
      return;
    }
    if (details.expandByDefault === -1) {
      groupNode.expanded = true;
      return;
    }
    groupNode.expanded = groupNode.level < details.expandByDefault;
  }
  getGroupInfo(rowNode, details) {
    const res = [];
    details.groupedCols.forEach((groupCol) => {
      let key = this.valueSvc.getKeyForNode(groupCol, rowNode);
      let keyExists = key !== null && key !== void 0 && key !== "";
      const createGroupForEmpty = details.pivotMode || !details.groupAllowUnbalanced;
      if (createGroupForEmpty && !keyExists) {
        key = "";
        keyExists = true;
      }
      if (keyExists) {
        const item = {
          key,
          field: groupCol.getColDef().field,
          rowGroupColumn: groupCol,
          leafNode: rowNode
        };
        res.push(item);
      }
    });
    return res;
  }
};

// packages/ag-grid-enterprise/src/rowGrouping/rowGroupingApi.ts
function setRowGroupColumns(beans, colKeys) {
  beans.rowGroupColsSvc?.setColumns(colKeys, "api");
}
function removeRowGroupColumns(beans, colKeys) {
  beans.rowGroupColsSvc?.removeColumns(colKeys, "api");
}
function addRowGroupColumns(beans, colKeys) {
  beans.rowGroupColsSvc?.addColumns(colKeys, "api");
}
function moveRowGroupColumn(beans, fromIndex, toIndex) {
  beans.rowGroupColsSvc?.moveColumn?.(fromIndex, toIndex, "api");
}
function getRowGroupColumns(beans) {
  return beans.rowGroupColsSvc?.columns ?? [];
}

// packages/ag-grid-enterprise/src/rowGrouping/rowGroupingModule.ts
var SharedRowGroupingModule = {
  moduleName: "SharedRowGrouping",
  version: VERSION,
  beans: [GroupHideOpenParentsService],
  apiFunctions: {
    setRowGroupColumns,
    removeRowGroupColumns,
    addRowGroupColumns,
    getRowGroupColumns,
    moveRowGroupColumn
  },
  dependsOn: [EnterpriseCoreModule, SharedAggregationModule, GroupColumnModule, StickyRowModule]
};
var RowGroupingModule = {
  moduleName: "RowGrouping",
  version: VERSION,
  beans: [GroupStage],
  rowModels: ["clientSide"],
  dependsOn: [SharedRowGroupingModule, AggregationModule, ClientSideRowModelHierarchyModule]
};
var RowGroupingPanelModule = {
  moduleName: "RowGroupingPanel",
  version: VERSION,
  selectors: [AgGridHeaderDropZonesSelector],
  icons: {
    // identifies the pivot drop zone
    pivotPanel: "pivot",
    // "Row groups" drop zone in column tool panel
    rowGroupPanel: "group",
    // separator between column 'pills' when you add multiple columns to the header drop zone
    panelDelimiter: "small-right",
    // version of panelDelimiter used in RTL mode
    panelDelimiterRtl: "small-left"
  },
  dependsOn: [EnterpriseCoreModule, import_ag_grid_community134._PopupModule]
};
var GroupFilterModule = {
  moduleName: "GroupFilter",
  version: VERSION,
  userComponents: { agGroupColumnFilter: GroupFilter, agGroupColumnFloatingFilter: GroupFloatingFilterComp },
  dependsOn: [EnterpriseCoreModule, import_ag_grid_community134._ColumnFilterModule]
};

// packages/ag-grid-enterprise/src/viewportRowModel/viewportRowModel.ts
var import_ag_grid_community135 = require("ag-grid-community");
var ViewportRowModel = class extends import_ag_grid_community135.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "rowModel";
    // rowRenderer tells us these
    this.firstRow = -1;
    this.lastRow = -1;
    // datasource tells us this
    this.rowCount = -1;
    this.rowNodesByIndex = {};
  }
  // we don't implement as lazy row heights is not supported in this row model
  ensureRowHeightsValid(_startPixel, _endPixel, _startLimitIndex, _endLimitIndex) {
    return false;
  }
  postConstruct() {
    const beans = this.beans;
    this.rowHeight = (0, import_ag_grid_community135._getRowHeightAsNumber)(beans);
    this.addManagedEventListeners({ viewportChanged: this.onViewportChanged.bind(this) });
    this.addManagedPropertyListener("viewportDatasource", () => this.updateDatasource());
    this.addManagedPropertyListener("rowHeight", () => {
      this.rowHeight = (0, import_ag_grid_community135._getRowHeightAsNumber)(beans);
      this.updateRowHeights();
    });
  }
  start() {
    this.updateDatasource();
  }
  isLastRowIndexKnown() {
    return true;
  }
  destroy() {
    this.destroyDatasource();
    super.destroy();
  }
  destroyDatasource() {
    const datasource = this.datasource;
    if (!datasource) {
      return;
    }
    datasource.destroy?.();
    this.beans.rowRenderer.datasourceChanged();
    this.firstRow = -1;
    this.lastRow = -1;
  }
  updateDatasource() {
    const datasource = this.gos.get("viewportDatasource");
    if (datasource) {
      this.setViewportDatasource(datasource);
    }
  }
  getPageSize() {
    return this.gos.get("viewportRowModelPageSize");
  }
  getBufferSize() {
    return this.gos.get("viewportRowModelBufferSize");
  }
  calculateFirstRow(firstRenderedRow) {
    const bufferSize = this.getBufferSize();
    const pageSize = this.getPageSize();
    const afterBuffer = firstRenderedRow - bufferSize;
    if (afterBuffer < 0) {
      return 0;
    }
    return Math.floor(afterBuffer / pageSize) * pageSize;
  }
  calculateLastRow(lastRenderedRow) {
    if (lastRenderedRow === -1) {
      return lastRenderedRow;
    }
    const bufferSize = this.getBufferSize();
    const pageSize = this.getPageSize();
    const afterBuffer = lastRenderedRow + bufferSize;
    const result = Math.ceil(afterBuffer / pageSize) * pageSize;
    const lastRowIndex = this.rowCount - 1;
    return Math.min(result, lastRowIndex);
  }
  onViewportChanged(event) {
    const newFirst = this.calculateFirstRow(event.firstRow);
    const newLast = this.calculateLastRow(event.lastRow);
    if (this.firstRow !== newFirst || this.lastRow !== newLast) {
      this.firstRow = newFirst;
      this.lastRow = newLast;
      this.purgeRowsNotInViewport();
      this.datasource?.setViewportRange(this.firstRow, this.lastRow);
    }
  }
  purgeRowsNotInViewport() {
    const rowNodesByIndex = this.rowNodesByIndex;
    Object.keys(rowNodesByIndex).forEach((indexStr) => {
      const index = parseInt(indexStr, 10);
      if (index < this.firstRow || index > this.lastRow) {
        if (this.isRowFocused(index)) {
          return;
        }
        delete rowNodesByIndex[index];
      }
    });
  }
  isRowFocused(rowIndex) {
    const focusedCell = this.beans.focusSvc.getFocusCellToUseAfterRefresh();
    if (!focusedCell) {
      return false;
    }
    if (focusedCell.rowPinned != null) {
      return false;
    }
    const hasFocus = focusedCell.rowIndex === rowIndex;
    return hasFocus;
  }
  setViewportDatasource(viewportDatasource) {
    this.destroyDatasource();
    this.datasource = viewportDatasource;
    this.rowCount = -1;
    if (!viewportDatasource.init) {
      (0, import_ag_grid_community135._warn)(226);
    } else {
      viewportDatasource.init({
        setRowCount: this.setRowCount.bind(this),
        setRowData: this.setRowData.bind(this),
        getRow: this.getRow.bind(this)
      });
    }
  }
  getType() {
    return "viewport";
  }
  getRow(rowIndex) {
    if (!this.rowNodesByIndex[rowIndex]) {
      this.rowNodesByIndex[rowIndex] = this.createBlankRowNode(rowIndex);
    }
    return this.rowNodesByIndex[rowIndex];
  }
  getRowNode(id) {
    let result;
    this.forEachNode((rowNode) => {
      if (rowNode.id === id) {
        result = rowNode;
      }
    });
    return result;
  }
  getRowCount() {
    return this.rowCount === -1 ? 0 : this.rowCount;
  }
  getRowIndexAtPixel(pixel) {
    if (this.rowHeight !== 0) {
      return Math.floor(pixel / this.rowHeight);
    }
    return 0;
  }
  getRowBounds(index) {
    const rowHeight = this.rowHeight;
    return {
      rowHeight,
      rowTop: rowHeight * index
    };
  }
  updateRowHeights() {
    const rowHeight = this.rowHeight;
    this.forEachNode((node) => {
      node.setRowHeight(rowHeight);
      node.setRowTop(rowHeight * node.rowIndex);
    });
    this.eventSvc.dispatchEvent({
      type: "modelUpdated",
      newData: false,
      newPage: false,
      keepRenderedRows: true,
      animate: false
    });
  }
  getTopLevelRowCount() {
    return this.getRowCount();
  }
  getTopLevelRowDisplayedIndex(topLevelIndex) {
    return topLevelIndex;
  }
  isEmpty() {
    return this.rowCount > 0;
  }
  isRowsToRender() {
    return this.rowCount > 0;
  }
  getNodesInRangeForSelection(firstInRange, lastInRange) {
    const firstIndex = firstInRange.rowIndex;
    const lastIndex = lastInRange.rowIndex;
    const firstNodeOutOfRange = firstIndex < this.firstRow || firstIndex > this.lastRow;
    const lastNodeOutOfRange = lastIndex < this.firstRow || lastIndex > this.lastRow;
    if (firstNodeOutOfRange || lastNodeOutOfRange) {
      return [];
    }
    const result = [];
    const startIndex = firstIndex <= lastIndex ? firstIndex : lastIndex;
    const endIndex = firstIndex <= lastIndex ? lastIndex : firstIndex;
    for (let i = startIndex; i <= endIndex; i++) {
      result.push(this.rowNodesByIndex[i]);
    }
    return result;
  }
  forEachNode(callback) {
    let callbackCount = 0;
    Object.keys(this.rowNodesByIndex).forEach((indexStr) => {
      const index = parseInt(indexStr, 10);
      const rowNode = this.rowNodesByIndex[index];
      callback(rowNode, callbackCount);
      callbackCount++;
    });
  }
  setRowData(rowData) {
    const rowNodesByIndex = this.rowNodesByIndex;
    for (const indexStr of Object.keys(rowData)) {
      const dataItem = rowData[indexStr];
      const index = parseInt(indexStr, 10);
      if (index >= this.firstRow && index <= this.lastRow) {
        let rowNode = rowNodesByIndex[index];
        if ((0, import_ag_grid_community135._missing)(rowNode)) {
          rowNode = this.createBlankRowNode(index);
          rowNodesByIndex[index] = rowNode;
        }
        rowNode.setDataAndId(dataItem, index.toString());
      }
    }
  }
  createBlankRowNode(rowIndex) {
    const rowNode = new import_ag_grid_community135.RowNode(this.beans);
    const rowHeight = this.rowHeight;
    rowNode.setRowHeight(rowHeight);
    rowNode.setRowTop(rowHeight * rowIndex);
    rowNode.setRowIndex(rowIndex);
    return rowNode;
  }
  setRowCount(rowCount, keepRenderedRows = false) {
    if (rowCount === this.rowCount) {
      return;
    }
    this.rowCount = rowCount;
    const eventSvc = this.eventSvc;
    eventSvc.dispatchEventOnce({
      type: "rowCountReady"
    });
    eventSvc.dispatchEvent({
      type: "modelUpdated",
      newData: false,
      newPage: false,
      keepRenderedRows,
      animate: false
    });
  }
  isRowPresent(rowNode) {
    const foundRowNode = this.getRowNode(rowNode.id);
    return !!foundRowNode;
  }
};

// packages/ag-grid-enterprise/src/viewportRowModel/viewportRowModelModule.ts
var ViewportRowModelModule = {
  moduleName: "ViewportRowModel",
  version: VERSION,
  rowModels: ["viewport"],
  beans: [ViewportRowModel],
  dependsOn: [EnterpriseCoreModule]
};

// packages/ag-grid-enterprise/src/clipboard/clipboardModule.ts
var import_ag_grid_community137 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/clipboard/clipboardApi.ts
function copyToClipboard(beans, params) {
  beans.clipboardSvc?.copyToClipboard(params);
}
function cutToClipboard(beans, params) {
  beans.clipboardSvc?.cutToClipboard(params);
}
function copySelectedRowsToClipboard(beans, params) {
  beans.clipboardSvc?.copySelectedRowsToClipboard(params);
}
function copySelectedRangeToClipboard(beans, params) {
  beans.clipboardSvc?.copySelectedRangeToClipboard(params);
}
function copySelectedRangeDown(beans) {
  beans.clipboardSvc?.copyRangeDown();
}
function pasteFromClipboard(beans) {
  beans.clipboardSvc?.pasteFromClipboard();
}

// packages/ag-grid-enterprise/src/clipboard/clipboardService.ts
var import_ag_grid_community136 = require("ag-grid-community");
var SOURCE_PASTE = "paste";
var EXPORT_TYPE_DRAG_COPY = "dragCopy";
var EXPORT_TYPE_CLIPBOARD = "clipboard";
function stringToArray(strData, delimiter = ",") {
  const data = [];
  const isNewline = (char) => char === "\r" || char === "\n";
  let insideQuotedField = false;
  if (strData === "") {
    return [[""]];
  }
  for (let row = 0, column = 0, position = 0; position < strData.length; position++) {
    const previousChar = strData[position - 1];
    const currentChar = strData[position];
    const nextChar = strData[position + 1];
    const ensureDataExists = () => {
      if (!data[row]) {
        data[row] = [];
      }
      if (!data[row][column]) {
        data[row][column] = "";
      }
    };
    ensureDataExists();
    if (currentChar === '"') {
      if (insideQuotedField) {
        if (nextChar === '"') {
          data[row][column] += '"';
          position++;
        } else {
          insideQuotedField = false;
        }
      } else if (previousChar === void 0 || previousChar === delimiter || isNewline(previousChar)) {
        insideQuotedField = true;
      }
    }
    if (!insideQuotedField && currentChar !== '"') {
      if (currentChar === delimiter) {
        column++;
        ensureDataExists();
        continue;
      } else if (isNewline(currentChar)) {
        column = 0;
        row++;
        ensureDataExists();
        if (currentChar === "\r" && nextChar === "\n") {
          position++;
        }
        continue;
      }
    }
    data[row][column] += currentChar;
  }
  return data;
}
var ClipboardService = class extends import_ag_grid_community136.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "clipboardSvc";
    this.clientSideRowModel = null;
    this.gridCtrl = null;
    this.lastPasteOperationTime = 0;
    this.navigatorApiFailed = false;
  }
  postConstruct() {
    const { gos, rowModel, ctrlsSvc } = this.beans;
    if ((0, import_ag_grid_community136._isClientSideRowModel)(gos, rowModel)) {
      this.clientSideRowModel = rowModel;
    }
    ctrlsSvc.whenReady(this, (p) => {
      this.gridCtrl = p.gridCtrl;
    });
  }
  destroy() {
    super.destroy();
    this.clientSideRowModel = null;
    this.gridCtrl = null;
  }
  pasteFromClipboard() {
    const allowNavigator = !this.gos.get("suppressClipboardApi");
    if (allowNavigator && !this.navigatorApiFailed && navigator.clipboard && navigator.clipboard.readText) {
      navigator.clipboard.readText().then(this.processClipboardData.bind(this)).catch((e) => {
        (0, import_ag_grid_community136._warn)(40, { e, method: "readText" });
        this.navigatorApiFailed = true;
        this.pasteFromClipboardLegacy();
      });
    } else {
      this.pasteFromClipboardLegacy();
    }
  }
  pasteFromClipboardLegacy() {
    let defaultPrevented = false;
    const handlePasteEvent = (e) => {
      const currentPastOperationTime = (/* @__PURE__ */ new Date()).getTime();
      if (currentPastOperationTime - this.lastPasteOperationTime < 50) {
        defaultPrevented = true;
        e.preventDefault();
      }
      this.lastPasteOperationTime = currentPastOperationTime;
    };
    this.executeOnTempElement(
      (textArea) => {
        textArea.addEventListener("paste", handlePasteEvent);
        textArea.focus({ preventScroll: true });
      },
      (element) => {
        const data = element.value;
        if (!defaultPrevented) {
          this.processClipboardData(data);
        } else {
          this.refocusLastFocusedCell();
        }
        element.removeEventListener("paste", handlePasteEvent);
      }
    );
  }
  refocusLastFocusedCell() {
    const { focusSvc } = this.beans;
    const focusedCell = focusSvc.getFocusedCell();
    if (focusedCell) {
      focusSvc.setFocusedCell({
        rowIndex: focusedCell.rowIndex,
        column: focusedCell.column,
        rowPinned: focusedCell.rowPinned,
        forceBrowserFocus: true
      });
    }
  }
  getClipboardDelimiter() {
    const delimiter = this.gos.get("clipboardDelimiter");
    return (0, import_ag_grid_community136._exists)(delimiter) ? delimiter : "	";
  }
  processClipboardData(data) {
    if (data == null) {
      return;
    }
    let parsedData = stringToArray(data, this.getClipboardDelimiter());
    const userFunc = this.gos.getCallback("processDataFromClipboard");
    if (userFunc) {
      parsedData = userFunc({ data: parsedData });
    }
    if (parsedData == null) {
      return;
    }
    if (this.gos.get("suppressLastEmptyLineOnPaste")) {
      this.removeLastLineIfBlank(parsedData);
    }
    const { rangeSvc } = this.beans;
    const pasteOperation = (cellsToFlash, updatedRowNodes, focusedCell, changedPath) => {
      const rangeActive = rangeSvc?.isMoreThanOneCell();
      const pasteIntoRange = rangeActive && !this.hasOnlyOneValueToPaste(parsedData);
      if (pasteIntoRange) {
        this.pasteIntoActiveRange(rangeSvc, parsedData, cellsToFlash, updatedRowNodes, changedPath);
      } else {
        this.pasteStartingFromFocusedCell(parsedData, cellsToFlash, updatedRowNodes, focusedCell, changedPath);
      }
    };
    this.doPasteOperation(pasteOperation);
  }
  // common code to paste operations, e.g. paste to cell, paste to range, and copy range down
  doPasteOperation(pasteOperationFunc) {
    const source = "clipboard";
    const { eventSvc, focusSvc, rowRenderer, gos } = this.beans;
    eventSvc.dispatchEvent({
      type: "pasteStart",
      source
    });
    const { clientSideRowModel } = this;
    const rootNode = clientSideRowModel?.rootNode;
    const changedPath = rootNode && new import_ag_grid_community136.ChangedPath(gos.get("aggregateOnlyChangedColumns"), rootNode);
    const cellsToFlash = {};
    const updatedRowNodes = [];
    const focusedCell = focusSvc.getFocusedCell();
    pasteOperationFunc(cellsToFlash, updatedRowNodes, focusedCell, changedPath);
    const nodesToRefresh = [...updatedRowNodes];
    if (changedPath) {
      clientSideRowModel.doAggregate(changedPath);
      changedPath.forEachChangedNodeDepthFirst((rowNode) => {
        nodesToRefresh.push(rowNode);
      });
    }
    rowRenderer.refreshCells({ rowNodes: nodesToRefresh });
    this.dispatchFlashCells(cellsToFlash);
    this.fireRowChanged(updatedRowNodes);
    this.refocusLastFocusedCell();
    eventSvc.dispatchEvent({
      type: "pasteEnd",
      source
    });
  }
  pasteIntoActiveRange(rangeSvc, clipboardData, cellsToFlash, updatedRowNodes, changedPath) {
    const abortRepeatingPasteIntoRows = this.getRangeSize(rangeSvc) % clipboardData.length != 0;
    let indexOffset = 0;
    let dataRowIndex = 0;
    const rowCallback = (currentRow, rowNode, columns, index) => {
      const atEndOfClipboardData = index - indexOffset >= clipboardData.length;
      if (atEndOfClipboardData) {
        if (abortRepeatingPasteIntoRows) {
          return;
        }
        indexOffset += dataRowIndex;
        dataRowIndex = 0;
      }
      const currentRowData = clipboardData[index - indexOffset];
      updatedRowNodes.push(rowNode);
      const processCellFromClipboardFunc = this.gos.getCallback("processCellFromClipboard");
      columns.forEach((column, idx) => {
        if (!column.isCellEditable(rowNode) || column.isSuppressPaste(rowNode)) {
          return;
        }
        if (idx >= currentRowData.length) {
          idx = idx % currentRowData.length;
        }
        const newValue = this.processCell(
          rowNode,
          column,
          currentRowData[idx],
          EXPORT_TYPE_DRAG_COPY,
          processCellFromClipboardFunc,
          true
        );
        rowNode.setDataValue(column, newValue, SOURCE_PASTE);
        if (changedPath) {
          changedPath.addParentNode(rowNode.parent, [column]);
        }
        const { rowIndex, rowPinned } = currentRow;
        const cellId = (0, import_ag_grid_community136._createCellId)({ rowIndex, column, rowPinned });
        cellsToFlash[cellId] = true;
      });
      dataRowIndex++;
    };
    this.iterateActiveRanges(false, rowCallback);
  }
  getDisplayedColumnsStartingAt(column) {
    let currentColumn = column;
    const columns = [];
    const visibleCols = this.beans.visibleCols;
    while (currentColumn != null) {
      columns.push(currentColumn);
      currentColumn = visibleCols.getColAfter(currentColumn);
    }
    return columns;
  }
  pasteStartingFromFocusedCell(parsedData, cellsToFlash, updatedRowNodes, focusedCell, changedPath) {
    if (!focusedCell) {
      return;
    }
    const currentRow = { rowIndex: focusedCell.rowIndex, rowPinned: focusedCell.rowPinned };
    const columnsToPasteInto = this.getDisplayedColumnsStartingAt(focusedCell.column);
    if (this.isPasteSingleValueIntoRange(parsedData)) {
      this.pasteSingleValueIntoRange(parsedData, updatedRowNodes, cellsToFlash, changedPath);
    } else {
      this.pasteMultipleValues(
        parsedData,
        currentRow,
        updatedRowNodes,
        columnsToPasteInto,
        cellsToFlash,
        EXPORT_TYPE_CLIPBOARD,
        changedPath
      );
    }
  }
  // if range is active, and only one cell, then we paste this cell into all cells in the active range.
  isPasteSingleValueIntoRange(parsedData) {
    const rangeSvc = this.beans.rangeSvc;
    return this.hasOnlyOneValueToPaste(parsedData) && !!rangeSvc && !rangeSvc.isEmpty();
  }
  pasteSingleValueIntoRange(parsedData, updatedRowNodes, cellsToFlash, changedPath) {
    const value = parsedData[0][0];
    const rowCallback = (currentRow, rowNode, columns) => {
      updatedRowNodes.push(rowNode);
      columns.forEach(
        (column) => this.updateCellValue(rowNode, column, value, cellsToFlash, EXPORT_TYPE_CLIPBOARD, changedPath)
      );
    };
    this.iterateActiveRanges(false, rowCallback);
  }
  hasOnlyOneValueToPaste(parsedData) {
    return parsedData.length === 1 && parsedData[0].length === 1;
  }
  copyRangeDown() {
    const { rangeSvc, gos, valueSvc } = this.beans;
    if (!rangeSvc || rangeSvc.isEmpty()) {
      return;
    }
    const firstRowValues = [];
    const pasteOperation = (cellsToFlash, updatedRowNodes, focusedCell, changedPath) => {
      const processCellForClipboardFunc = gos.getCallback("processCellForClipboard");
      const processCellFromClipboardFunc = gos.getCallback("processCellFromClipboard");
      const rowCallback = (currentRow, rowNode, columns) => {
        if (!firstRowValues.length) {
          columns.forEach((column) => {
            const value = this.processCell(
              rowNode,
              column,
              valueSvc.getValue(column, rowNode),
              EXPORT_TYPE_DRAG_COPY,
              processCellForClipboardFunc,
              false,
              true
            );
            firstRowValues.push(value);
          });
        } else {
          updatedRowNodes.push(rowNode);
          columns.forEach((column, index) => {
            if (!column.isCellEditable(rowNode) || column.isSuppressPaste(rowNode)) {
              return;
            }
            const firstRowValue = this.processCell(
              rowNode,
              column,
              firstRowValues[index],
              EXPORT_TYPE_DRAG_COPY,
              processCellFromClipboardFunc,
              true
            );
            rowNode.setDataValue(column, firstRowValue, SOURCE_PASTE);
            if (changedPath) {
              changedPath.addParentNode(rowNode.parent, [column]);
            }
            const { rowIndex, rowPinned } = currentRow;
            const cellId = (0, import_ag_grid_community136._createCellId)({ rowIndex, column, rowPinned });
            cellsToFlash[cellId] = true;
          });
        }
      };
      this.iterateActiveRanges(true, rowCallback);
    };
    this.doPasteOperation(pasteOperation);
  }
  removeLastLineIfBlank(parsedData) {
    const lastLine = (0, import_ag_grid_community136._last)(parsedData);
    const lastLineIsBlank = lastLine && lastLine.length === 1 && lastLine[0] === "";
    if (lastLineIsBlank) {
      if (parsedData.length === 1) {
        return;
      }
      (0, import_ag_grid_community136._removeFromArray)(parsedData, lastLine);
    }
  }
  fireRowChanged(rowNodes) {
    if (this.gos.get("editType") !== "fullRow") {
      return;
    }
    rowNodes.forEach((rowNode) => {
      this.eventSvc.dispatchEvent({
        type: "rowValueChanged",
        node: rowNode,
        data: rowNode.data,
        rowIndex: rowNode.rowIndex,
        rowPinned: rowNode.rowPinned
      });
    });
  }
  pasteMultipleValues(clipboardGridData, currentRow, updatedRowNodes, columnsToPasteInto, cellsToFlash, type, changedPath) {
    let rowPointer = currentRow;
    const beans = this.beans;
    const { gos, cellNavigation } = beans;
    const skipGroupRows = this.clientSideRowModel != null && !gos.get("enableGroupEdit") && !gos.get("treeData");
    const getNextGoodRowNode = () => {
      while (true) {
        if (!rowPointer) {
          return null;
        }
        const res = (0, import_ag_grid_community136._getRowNode)(beans, rowPointer);
        rowPointer = cellNavigation.getRowBelow({
          rowPinned: rowPointer.rowPinned,
          rowIndex: rowPointer.rowIndex
        });
        if (res == null) {
          return null;
        }
        const skipRow = res.detail || res.footer || skipGroupRows && res.group;
        if (!skipRow) {
          return res;
        }
      }
    };
    clipboardGridData.forEach((clipboardRowData) => {
      const rowNode = getNextGoodRowNode();
      if (!rowNode) {
        return;
      }
      clipboardRowData.forEach(
        (value, index) => this.updateCellValue(rowNode, columnsToPasteInto[index], value, cellsToFlash, type, changedPath)
      );
      updatedRowNodes.push(rowNode);
    });
  }
  updateCellValue(rowNode, column, value, cellsToFlash, type, changedPath) {
    if (!rowNode || !column || !column.isCellEditable(rowNode) || column.isSuppressPaste(rowNode)) {
      return;
    }
    const processedValue = this.processCell(
      rowNode,
      column,
      value,
      type,
      this.gos.getCallback("processCellFromClipboard"),
      true
    );
    rowNode.setDataValue(column, processedValue, SOURCE_PASTE);
    const { rowIndex, rowPinned } = rowNode;
    const cellId = (0, import_ag_grid_community136._createCellId)({ rowIndex, column, rowPinned });
    cellsToFlash[cellId] = true;
    if (changedPath) {
      changedPath.addParentNode(rowNode.parent, [column]);
    }
  }
  copyToClipboard(params = {}) {
    this.copyOrCutToClipboard(params);
  }
  cutToClipboard(params = {}, source = "api") {
    if (this.gos.get("suppressCutToClipboard")) {
      return;
    }
    this.eventSvc.dispatchEvent({
      type: "cutStart",
      source
    });
    this.copyOrCutToClipboard(params, true);
    this.eventSvc.dispatchEvent({
      type: "cutEnd",
      source
    });
  }
  copyOrCutToClipboard(params, cut) {
    let { includeHeaders, includeGroupHeaders } = params;
    const { gos, focusSvc } = this.beans;
    if (includeHeaders == null) {
      includeHeaders = gos.get("copyHeadersToClipboard");
    }
    if (includeGroupHeaders == null) {
      includeGroupHeaders = gos.get("copyGroupHeadersToClipboard");
    }
    const copyParams = { includeHeaders, includeGroupHeaders };
    const rowSelection = gos.get("rowSelection");
    const cellSelection = gos.get("cellSelection");
    let cellClearType = null;
    if (this.shouldCopyCells(cellSelection, rowSelection)) {
      this.copySelectedRangeToClipboard(copyParams);
      cellClearType = 0 /* CellRange */;
    } else if (this.shouldCopyRows(rowSelection)) {
      this.copySelectedRowsToClipboard(copyParams);
      cellClearType = 1 /* SelectedRows */;
    } else if (focusSvc.isAnyCellFocused()) {
      this.copyFocusedCellToClipboard(copyParams);
      cellClearType = 2 /* FocusedCell */;
    }
    if (cut && cellClearType !== null) {
      this.clearCellsAfterCopy(cellClearType);
    }
  }
  shouldCopyCells(cellSelection, rowSelection) {
    const { rangeSvc, selectionSvc, gos } = this.beans;
    if (!rangeSvc || rangeSvc.isEmpty()) {
      return false;
    }
    if (cellSelection) {
      const shouldCopyRowsInstead = typeof rowSelection === "object" && rowSelection.copySelectedRows && !selectionSvc?.isEmpty();
      return !shouldCopyRowsInstead;
    } else {
      const suppressCopySingleCellRanges = gos.get("suppressCopySingleCellRanges");
      const shouldSkip = !rangeSvc.isMoreThanOneCell() && suppressCopySingleCellRanges;
      return !shouldSkip;
    }
  }
  shouldCopyRows(rowSelection) {
    const { selectionSvc, gos } = this.beans;
    if (selectionSvc?.isEmpty() ?? true) {
      return false;
    }
    if (rowSelection && typeof rowSelection !== "string") {
      return rowSelection.copySelectedRows ?? false;
    } else {
      return !gos.get("suppressCopyRowsToClipboard");
    }
  }
  clearCellsAfterCopy(type) {
    const beans = this.beans;
    const { rangeSvc, focusSvc, eventSvc } = beans;
    eventSvc.dispatchEvent({ type: "keyShortcutChangedCellStart" });
    if (type === 0 /* CellRange */) {
      rangeSvc.clearCellRangeCellValues({ cellEventSource: "clipboardSvc" });
    } else if (type === 1 /* SelectedRows */) {
      this.clearSelectedRows();
    } else {
      const focusedCell = focusSvc.getFocusedCell();
      if (focusedCell == null) {
        return;
      }
      const rowNode = (0, import_ag_grid_community136._getRowNode)(beans, focusedCell);
      if (rowNode) {
        this.clearCellValue(rowNode, focusedCell.column);
      }
    }
    eventSvc.dispatchEvent({ type: "keyShortcutChangedCellEnd" });
  }
  clearSelectedRows() {
    const { selectionSvc, visibleCols } = this.beans;
    const selected = selectionSvc?.getSelectedNodes() ?? [];
    const columns = visibleCols.allCols;
    for (const row of selected) {
      for (const col of columns) {
        this.clearCellValue(row, col);
      }
    }
  }
  clearCellValue(rowNode, column) {
    if (!column.isCellEditable(rowNode)) {
      return;
    }
    const emptyValue = this.beans.valueSvc.getDeleteValue(column, rowNode);
    rowNode.setDataValue(column, emptyValue, "clipboardSvc");
  }
  iterateActiveRanges(onlyFirst, rowCallback, columnCallback) {
    const rangeSvc = this.beans.rangeSvc;
    if (!rangeSvc || rangeSvc.isEmpty()) {
      return;
    }
    const cellRanges = rangeSvc.getCellRanges();
    if (onlyFirst) {
      this.iterateActiveRange(cellRanges[0], rowCallback, columnCallback, true);
    } else {
      cellRanges.forEach(
        (range, idx) => this.iterateActiveRange(range, rowCallback, columnCallback, idx === cellRanges.length - 1)
      );
    }
  }
  iterateActiveRange(range, rowCallback, columnCallback, isLastRange) {
    const { rangeSvc, cellNavigation } = this.beans;
    if (!rangeSvc) {
      return;
    }
    let currentRow = rangeSvc.getRangeStartRow(range);
    const lastRow = rangeSvc.getRangeEndRow(range);
    if (columnCallback && range.columns) {
      columnCallback(range.columns);
    }
    let rangeIndex = 0;
    let isLastRow = false;
    while (!isLastRow && currentRow != null) {
      const rowNode = (0, import_ag_grid_community136._getRowNode)(this.beans, currentRow);
      isLastRow = (0, import_ag_grid_community136._isSameRow)(currentRow, lastRow);
      rowCallback(currentRow, rowNode, range.columns, rangeIndex++, isLastRow && isLastRange);
      currentRow = cellNavigation.getRowBelow(currentRow);
    }
  }
  copySelectedRangeToClipboard(params = {}) {
    const rangeSvc = this.beans.rangeSvc;
    if (!rangeSvc || rangeSvc.isEmpty()) {
      return;
    }
    const allRangesMerge = rangeSvc.areAllRangesAbleToMerge();
    const { data, cellsToFlash } = allRangesMerge ? this.buildDataFromMergedRanges(rangeSvc, params) : this.buildDataFromRanges(rangeSvc, params);
    this.copyDataToClipboard(data);
    this.dispatchFlashCells(cellsToFlash);
  }
  buildDataFromMergedRanges(rangeSvc, params) {
    const columnsSet = /* @__PURE__ */ new Set();
    const ranges = rangeSvc.getCellRanges();
    const rowPositionsMap = /* @__PURE__ */ new Map();
    const allRowPositions = [];
    const allCellsToFlash = {};
    ranges.forEach((range) => {
      range.columns.forEach((col) => columnsSet.add(col));
      const { rowPositions, cellsToFlash } = this.getRangeRowPositionsAndCellsToFlash(rangeSvc, range);
      rowPositions.forEach((rowPosition) => {
        const rowPositionAsString = `${rowPosition.rowIndex}-${rowPosition.rowPinned || "null"}`;
        if (!rowPositionsMap.get(rowPositionAsString)) {
          rowPositionsMap.set(rowPositionAsString, true);
          allRowPositions.push(rowPosition);
        }
      });
      Object.assign(allCellsToFlash, cellsToFlash);
    });
    const allColumns = this.beans.visibleCols.allCols;
    const exportedColumns = Array.from(columnsSet);
    exportedColumns.sort((a, b) => {
      const posA = allColumns.indexOf(a);
      const posB = allColumns.indexOf(b);
      return posA - posB;
    });
    const data = this.buildExportParams({
      columns: exportedColumns,
      rowPositions: allRowPositions,
      includeHeaders: params.includeHeaders,
      includeGroupHeaders: params.includeGroupHeaders
    });
    return { data, cellsToFlash: allCellsToFlash };
  }
  buildDataFromRanges(rangeSvc, params) {
    const ranges = rangeSvc.getCellRanges();
    const data = [];
    const allCellsToFlash = {};
    ranges.forEach((range) => {
      const { rowPositions, cellsToFlash } = this.getRangeRowPositionsAndCellsToFlash(rangeSvc, range);
      Object.assign(allCellsToFlash, cellsToFlash);
      data.push(
        this.buildExportParams({
          columns: range.columns,
          rowPositions,
          includeHeaders: params.includeHeaders,
          includeGroupHeaders: params.includeGroupHeaders
        })
      );
    });
    return { data: data.join("\n"), cellsToFlash: allCellsToFlash };
  }
  getRangeRowPositionsAndCellsToFlash(rangeSvc, range) {
    const rowPositions = [];
    const cellsToFlash = {};
    const startRow = rangeSvc.getRangeStartRow(range);
    const lastRow = rangeSvc.getRangeEndRow(range);
    let node = startRow;
    while (node) {
      rowPositions.push(node);
      range.columns.forEach((column) => {
        const { rowIndex, rowPinned } = node;
        const cellId = (0, import_ag_grid_community136._createCellId)({ rowIndex, column, rowPinned });
        cellsToFlash[cellId] = true;
      });
      if ((0, import_ag_grid_community136._isSameRow)(node, lastRow)) {
        break;
      }
      node = this.beans.cellNavigation.getRowBelow(node);
    }
    return { rowPositions, cellsToFlash };
  }
  getCellsToFlashFromRowNodes(rowNodes) {
    const allDisplayedColumns = this.beans.visibleCols.allCols;
    const cellsToFlash = {};
    for (let i = 0; i < rowNodes.length; i++) {
      const { level, rowIndex: index, rowPinned, sibling } = rowNodes[i];
      const rowIndex = level === -1 ? sibling.rowIndex : index;
      if (rowIndex == null) {
        continue;
      }
      for (let j = 0; j < allDisplayedColumns.length; j++) {
        const column = allDisplayedColumns[j];
        const cellId = (0, import_ag_grid_community136._createCellId)({ rowIndex, column, rowPinned });
        cellsToFlash[cellId] = true;
      }
    }
    return cellsToFlash;
  }
  copyFocusedCellToClipboard(params = {}) {
    let focusedCell = this.beans.focusSvc.getFocusedCell();
    if (focusedCell == null) {
      return;
    }
    focusedCell = this.beans.rowSpanSvc?.getCellStart(focusedCell) ?? focusedCell;
    const cellId = (0, import_ag_grid_community136._createCellId)(focusedCell);
    const currentRow = { rowPinned: focusedCell.rowPinned, rowIndex: focusedCell.rowIndex };
    const column = focusedCell.column;
    const data = this.buildExportParams({
      columns: [column],
      rowPositions: [currentRow],
      includeHeaders: params.includeHeaders,
      includeGroupHeaders: params.includeGroupHeaders
    });
    this.copyDataToClipboard(data);
    this.dispatchFlashCells({ [cellId]: true });
  }
  copySelectedRowsToClipboard(params = {}) {
    const { columnKeys, includeHeaders, includeGroupHeaders } = params;
    const data = this.buildExportParams({
      columns: columnKeys,
      includeHeaders,
      includeGroupHeaders
    });
    this.copyDataToClipboard(data);
    const rowNodes = this.beans.selectionSvc?.getSelectedNodes() || [];
    this.dispatchFlashCells(this.getCellsToFlashFromRowNodes(rowNodes));
  }
  buildExportParams(params) {
    const { columns, rowPositions, includeHeaders = false, includeGroupHeaders = false } = params;
    const { gos, csvCreator } = this.beans;
    const exportParams = {
      columnKeys: columns,
      rowPositions,
      skipColumnHeaders: !includeHeaders,
      skipColumnGroupHeaders: !includeGroupHeaders,
      suppressQuotes: true,
      columnSeparator: this.getClipboardDelimiter(),
      onlySelected: !rowPositions,
      processCellCallback: gos.getCallback("processCellForClipboard"),
      processRowGroupCallback: (params2) => this.processRowGroupCallback(params2),
      processHeaderCallback: gos.getCallback("processHeaderForClipboard"),
      processGroupHeaderCallback: gos.getCallback("processGroupHeaderForClipboard")
    };
    return csvCreator.getDataAsCsv(exportParams, true);
  }
  getValueFromNode(node, column) {
    const { gos, valueSvc } = this.beans;
    const isTreeData = gos.get("treeData");
    const isGroupRows = gos.get("groupDisplayType") === "groupRows";
    if (isTreeData || isGroupRows || !column) {
      return node.key;
    }
    const value = node.groupData?.[column.getId()];
    if (!value || !node.rowGroupColumn || node.rowGroupColumn.getColDef().useValueFormatterForExport === false) {
      return value;
    }
    return valueSvc.formatValue(node.rowGroupColumn, node, value) ?? value;
  }
  processRowGroupCallback({ node, column }) {
    let value = this.getValueFromNode(node, column);
    const translate = this.getLocaleTextFunc();
    if (node.footer) {
      let suffix = "";
      if (value && value.length) {
        suffix = ` ${value}`;
      }
      value = `${translate("footerTotal", "Total")}${suffix}`;
    }
    return value || "";
  }
  // eslint-disable-next-line @typescript-eslint/ban-types
  dispatchFlashCells(cellsToFlash) {
    window.setTimeout(() => {
      this.eventSvc.dispatchEvent({
        type: "flashCells",
        cells: cellsToFlash
      });
    }, 0);
  }
  processCell(rowNode, column, value, type, func, canParse, canFormat) {
    const valueSvc = this.beans.valueSvc;
    if (func) {
      const params = {
        column,
        node: rowNode,
        value,
        type,
        formatValue: (valueToFormat) => valueSvc.formatValue(column, rowNode ?? null, valueToFormat) ?? valueToFormat,
        parseValue: (valueToParse) => valueSvc.parseValue(column, rowNode ?? null, valueToParse, valueSvc.getValue(column, rowNode))
      };
      return func(params);
    }
    if (canParse && column.getColDef().useValueParserForImport !== false) {
      return valueSvc.parseValue(column, rowNode ?? null, value, valueSvc.getValue(column, rowNode));
    }
    if (canFormat && column.getColDef().useValueFormatterForExport !== false) {
      return valueSvc.formatValue(column, rowNode ?? null, value) ?? value;
    }
    return value;
  }
  copyDataToClipboard(data) {
    const userProvidedFunc = this.gos.getCallback("sendToClipboard");
    if (userProvidedFunc) {
      userProvidedFunc({ data });
      return;
    }
    const allowNavigator = !this.gos.get("suppressClipboardApi");
    if (allowNavigator && navigator.clipboard) {
      navigator.clipboard.writeText(data).catch((e) => {
        (0, import_ag_grid_community136._warn)(40, { e, method: "writeText" });
        this.copyDataToClipboardLegacy(data);
      });
      return;
    }
    this.copyDataToClipboardLegacy(data);
  }
  copyDataToClipboardLegacy(data) {
    this.executeOnTempElement((element) => {
      const eDocument = (0, import_ag_grid_community136._getDocument)(this.beans);
      const focusedElementBefore = (0, import_ag_grid_community136._getActiveDomElement)(this.beans);
      element.value = data || " ";
      element.select();
      element.focus({ preventScroll: true });
      const result = eDocument.execCommand("copy");
      if (!result) {
        (0, import_ag_grid_community136._warn)(41);
      }
      if (focusedElementBefore != null && focusedElementBefore.focus != null) {
        focusedElementBefore.focus({ preventScroll: true });
      }
    });
  }
  executeOnTempElement(callbackNow, callbackAfter) {
    if (!this.gridCtrl) {
      return;
    }
    const eDoc = (0, import_ag_grid_community136._getDocument)(this.beans);
    const eTempInput = eDoc.createElement("textarea");
    const style = eTempInput.style;
    style.width = "1px";
    style.height = "1px";
    const documentElement = eDoc.documentElement;
    style.top = documentElement.scrollTop + "px";
    style.left = documentElement.scrollLeft + "px";
    style.position = "absolute";
    style.opacity = "0";
    const guiRoot = this.gridCtrl.getGui();
    guiRoot.appendChild(eTempInput);
    try {
      callbackNow(eTempInput);
    } catch (err) {
      (0, import_ag_grid_community136._warn)(42);
    }
    if (callbackAfter) {
      window.setTimeout(() => {
        callbackAfter(eTempInput);
        guiRoot.removeChild(eTempInput);
      }, 100);
    } else {
      guiRoot.removeChild(eTempInput);
    }
  }
  getRangeSize(rangeSvc) {
    const ranges = rangeSvc.getCellRanges();
    let startRangeIndex = 0;
    let endRangeIndex = 0;
    if (ranges.length > 0) {
      startRangeIndex = rangeSvc.getRangeStartRow(ranges[0]).rowIndex;
      endRangeIndex = rangeSvc.getRangeEndRow(ranges[0]).rowIndex;
    }
    return startRangeIndex - endRangeIndex + 1;
  }
};

// packages/ag-grid-enterprise/src/clipboard/clipboardModule.ts
var ClipboardModule = {
  moduleName: "Clipboard",
  version: VERSION,
  beans: [ClipboardService],
  apiFunctions: {
    copyToClipboard,
    cutToClipboard,
    copySelectedRowsToClipboard,
    copySelectedRangeToClipboard,
    copySelectedRangeDown,
    pasteFromClipboard
  },
  dependsOn: [EnterpriseCoreModule, import_ag_grid_community137.CsvExportModule, import_ag_grid_community137._KeyboardNavigationModule, import_ag_grid_community137.HighlightChangesModule]
};

// packages/ag-grid-enterprise/src/rowNumbers/rowNumbersModule.ts
var import_ag_grid_community139 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/rowNumbers/rowNumbers.css-GENERATED.ts
var rowNumbersCSS = (
  /*css*/
  `.ag-row-number-cell{background-color:var(--ag-header-background-color);color:var(--ag-header-text-color);font-family:var(--ag-header-font-family);font-size:var(--ag-header-font-size);font-weight:var(--ag-header-font-weight);overflow:hidden;-webkit-user-select:none;-moz-user-select:none;user-select:none;white-space:nowrap;width:100%}:where(.ag-ltr) .ag-row-number-cell{text-align:right}:where(.ag-rtl) .ag-row-number-cell{text-align:left}:where(.ag-row-number-header.ag-row-number-selection-enabled){cursor:cell}.ag-row-number-range-highlight{background-color:var(--ag-range-header-highlight-color)}.ag-row-number-range-selected{background-color:var(--ag-row-numbers-selected-color)}:where(.ag-ltr){.ag-row-number-header,:where(.ag-cell.ag-row-number-cell):not(.ag-cell-last-left-pinned){border-right:var(--ag-pinned-column-border)}:where(.ag-cell.ag-row-number-cell.ag-row-number-selection-enabled){cursor:url("data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbDpzcGFjZT0icHJlc2VydmUiIHdpZHRoPSIxNiIgaGVpZ2h0PSIxNiIgc3R5bGU9ImZpbGwtcnVsZTpldmVub2RkO2NsaXAtcnVsZTpldmVub2RkO3N0cm9rZS1saW5lY2FwOnJvdW5kO3N0cm9rZS1saW5lam9pbjpyb3VuZDtzdHJva2UtbWl0ZXJsaW1pdDoxLjUiPjxwYXRoIGQ9Ik0zLjQ0NSA4LjkxMVY3LjQwOUg5Ljc1VjYuMDE0bDIuNTM1IDIuMTQ2LTIuNTM1IDIuMTQ2VjguOTExeiIgc3R5bGU9InN0cm9rZTojZmZmO3N0cm9rZS13aWR0aDouNDFweCIgdHJhbnNmb3JtPSJtYXRyaXgoMS41Nzg0IDAgMCAxLjg2NDI5IC00LjQxMyAtNy4yMTIpIi8+PC9zdmc+"),auto}}:where(.ag-rtl){.ag-row-number-header,:where(.ag-cell.ag-row-number-cell):not(.ag-cell-first-right-pinned){border-left:var(--ag-pinned-column-border)}:where(.ag-cell.ag-row-number-cell.ag-row-number-selection-enabled){cursor:url("data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbDpzcGFjZT0icHJlc2VydmUiIHdpZHRoPSIxNiIgaGVpZ2h0PSIxNiIgc3R5bGU9ImZpbGwtcnVsZTpldmVub2RkO2NsaXAtcnVsZTpldmVub2RkO3N0cm9rZS1saW5lY2FwOnJvdW5kO3N0cm9rZS1saW5lam9pbjpyb3VuZDtzdHJva2UtbWl0ZXJsaW1pdDoxLjUiPjxwYXRoIGQ9Ik01Ljk3OSA4LjkxMXYxLjM5NUwzLjQ0NSA4LjE2bDIuNTM0LTIuMTQ2djEuMzk1aDYuMzA2djEuNTAyeiIgc3R5bGU9InN0cm9rZTojZmZmO3N0cm9rZS13aWR0aDouNDFweCIgdHJhbnNmb3JtPSJtYXRyaXgoMS41Nzg0IDAgMCAxLjg2NDI5IC00LjQxMyAtNy4yMTIpIi8+PC9zdmc+"),auto}}`
);

// packages/ag-grid-enterprise/src/rowNumbers/rowNumbersService.ts
var import_ag_grid_community138 = require("ag-grid-community");
var RowNumbersService = class extends import_ag_grid_community138.BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "rowNumbersSvc";
    this.isIntegratedWithSelection = false;
  }
  postConstruct() {
    const refreshCells_debounced = (0, import_ag_grid_community138._debounce)(this, this.refreshCells.bind(this, false, true), 10);
    this.addManagedEventListeners({
      modelUpdated: refreshCells_debounced,
      rangeSelectionChanged: () => this.refreshCells(true)
    });
    this.addManagedPropertyListeners(["rowNumbers", "cellSelection"], (e) => {
      this.refreshSelectionIntegration();
      this.updateColumns(e);
    });
    this.refreshSelectionIntegration();
  }
  addColumns(cols) {
    if (this.columns == null) {
      return;
    }
    cols.list = this.columns.list.concat(cols.list);
    cols.tree = this.columns.tree.concat(cols.tree);
    (0, import_ag_grid_community138._updateColsMap)(cols);
  }
  createColumns(cols, updateOrders) {
    const destroyCollection = () => {
      (0, import_ag_grid_community138._destroyColumnTree)(this.beans, this.columns?.tree);
      this.columns = null;
    };
    const newTreeDepth = cols.treeDepth;
    const oldTreeDepth = this.columns?.treeDepth ?? -1;
    const treeDepthSame = oldTreeDepth == newTreeDepth;
    const list = this.generateRowNumberCols();
    const areSame = (0, import_ag_grid_community138._areColIdsEqual)(list, this.columns?.list ?? []);
    if (areSame && treeDepthSame) {
      return;
    }
    destroyCollection();
    const { colGroupSvc } = this.beans;
    const treeDepth = colGroupSvc?.findDepth(cols.tree) ?? 0;
    const tree = colGroupSvc?.balanceTreeForAutoCols(list, treeDepth) ?? [];
    this.columns = {
      list,
      tree,
      treeDepth,
      map: {}
    };
    updateOrders(this.putRowNumbersColsFirstInList);
  }
  handleMouseDownOnCell(cellPosition, mouseEvent) {
    if (!this.isIntegratedWithSelection) {
      return false;
    }
    if (!mouseEvent.shiftKey) {
      setTimeout(() => {
        this.focusFirstRenderedCellAtRowPosition(cellPosition);
      });
    }
    return true;
  }
  updateColumns(event) {
    const source = (0, import_ag_grid_community138._convertColumnEventSourceType)(event.source);
    this.refreshSelectionIntegration();
    this.columns?.list.forEach((col) => {
      const newColDef = this.createRowNumbersColDef();
      col.setColDef(newColDef, null, source);
      (0, import_ag_grid_community138._applyColumnState)(this.beans, { state: [{ colId: col.getColId(), ...newColDef }] }, source);
    });
  }
  getColumn() {
    return this.columns?.list.find(import_ag_grid_community138.isRowNumberCol) ?? null;
  }
  getColumns() {
    return this.columns?.list ?? null;
  }
  setupForHeader(comp) {
    const { column, eGridHeader } = comp.params;
    if (!(0, import_ag_grid_community138.isRowNumberCol)(column)) {
      return;
    }
    (0, import_ag_grid_community138._setAriaLabel)(eGridHeader, "Row Number");
    this.addManagedElementListeners(eGridHeader, {
      click: this.onHeaderClick.bind(this),
      keydown: this.onHeaderKeyDown.bind(this),
      focus: this.onHeaderFocus.bind(this)
    });
  }
  refreshSelectionIntegration() {
    const { beans } = this;
    const { gos, rangeSvc } = beans;
    const cellSelection = gos.get("cellSelection");
    this.refreshRowNumberOverrides();
    this.isIntegratedWithSelection = !!rangeSvc && !!cellSelection && !this.isSuppressCellSelectionIntegration;
  }
  refreshRowNumberOverrides() {
    const rowNumbers = this.gos.get("rowNumbers");
    this.rowNumberOverrides = {};
    if (!rowNumbers || typeof rowNumbers !== "object") {
      return;
    }
    if (rowNumbers.suppressCellSelectionIntegration) {
      this.isSuppressCellSelectionIntegration = true;
    }
    const colDefValidProps = [
      "contextMenuItems",
      "context",
      "onCellClicked",
      "onCellContextMenu",
      "onCellDoubleClicked",
      "headerTooltip",
      "headerStyle",
      "headerComponent",
      "headerComponentParams",
      "suppressHeaderKeyboardEvent",
      "tooltipField",
      "tooltipValueGetter",
      "tooltipComponent",
      "tooltipComponentParams",
      "valueGetter",
      "valueFormatter",
      "width",
      "maxWidth",
      "minWidth",
      "resizable"
    ];
    for (const prop of colDefValidProps) {
      if (rowNumbers[prop] != null) {
        this.rowNumberOverrides[prop] = rowNumbers[prop];
      }
    }
  }
  onHeaderFocus() {
    this.beans.ariaAnnounce?.announceValue("Press Space to select all cells", "ariaSelectAllCells");
  }
  onHeaderKeyDown(e) {
    if (!this.isIntegratedWithSelection || e.key !== import_ag_grid_community138.KeyCode.SPACE) {
      return;
    }
    (0, import_ag_grid_community138._selectAllCells)(this.beans);
  }
  onHeaderClick() {
    if (!this.isIntegratedWithSelection) {
      return;
    }
    (0, import_ag_grid_community138._selectAllCells)(this.beans);
  }
  refreshCells(force, runAutoSize) {
    const column = this.getColumn();
    if (!column) {
      return;
    }
    if (runAutoSize) {
      const width = this.beans.autoWidthCalc?.getPreferredWidthForElements([this.createDummyElement(column)], 2);
      if (width != null) {
        this.beans.colResize?.setColumnWidths(
          [{ key: column, newWidth: width }],
          false,
          true,
          "rowNumbersService"
        );
      }
    }
    this.beans.rowRenderer.refreshCells({
      columns: [column],
      force
    });
  }
  createDummyElement(column) {
    const div = document.createElement("div");
    div.classList.add("ag-cell-value", "ag-cell");
    let value = String(this.beans.rowModel.getRowCount() + 1);
    if (typeof this.rowNumberOverrides.valueFormatter === "function") {
      const valueFormatterParams = (0, import_ag_grid_community138._addGridCommonParams)(this.beans.gos, {
        data: void 0,
        value,
        node: null,
        column,
        colDef: column.colDef
      });
      value = this.rowNumberOverrides.valueFormatter(valueFormatterParams);
    }
    div.textContent = value;
    return div;
  }
  putRowNumbersColsFirstInList(list, cols) {
    if (!cols) {
      return null;
    }
    const colsFiltered = cols.filter((col) => !(0, import_ag_grid_community138.isRowNumberCol)(col));
    return [...list, ...colsFiltered];
  }
  createRowNumbersColDef() {
    const { gos, contextMenuSvc } = this.beans;
    const enableRTL = gos.get("enableRtl");
    return {
      // overridable properties
      minWidth: 60,
      width: 60,
      resizable: false,
      valueGetter: this.valueGetter,
      contextMenuItems: this.isIntegratedWithSelection || !contextMenuSvc ? void 0 : () => [],
      // overrides
      ...this.rowNumberOverrides,
      // non-overridable properties
      colId: import_ag_grid_community138.ROW_NUMBERS_COLUMN_ID,
      suppressHeaderMenuButton: true,
      sortable: false,
      suppressMovable: true,
      lockPinned: true,
      pinned: enableRTL ? "right" : "left",
      lockPosition: enableRTL ? "right" : "left",
      editable: false,
      suppressFillHandle: true,
      suppressAutoSize: true,
      suppressSizeToFit: true,
      suppressHeaderContextMenu: true,
      suppressNavigable: true,
      headerClass: this.getHeaderClass(),
      cellClass: this.getCellClass.bind(this),
      cellAriaRole: "rowheader"
    };
  }
  valueGetter(params) {
    return String((params.node?.rowIndex || 0) + 1);
  }
  getHeaderClass() {
    const cssClass = ["ag-row-number-header"];
    if (this.isIntegratedWithSelection) {
      cssClass.push("ag-row-number-selection-enabled");
    }
    return cssClass;
  }
  getCellClass(params) {
    const { beans } = this;
    const { rangeSvc, gos } = beans;
    const { node } = params;
    const cssClasses = ["ag-row-number-cell"];
    const cellSelection = gos.get("cellSelection");
    if (!rangeSvc || !cellSelection) {
      return cssClasses;
    }
    if (this.isIntegratedWithSelection) {
      cssClasses.push("ag-row-number-selection-enabled");
    }
    const ranges = rangeSvc.getCellRanges();
    if (!ranges.length) {
      return cssClasses;
    }
    const allColsLen = this.beans.visibleCols.allCols.length - 1;
    const shouldHighlight = typeof cellSelection === "object" && cellSelection.enableHeaderHighlight;
    for (const range of ranges) {
      if (rangeSvc.isRowInRange(node.rowIndex, node.rowPinned, range)) {
        if (shouldHighlight) {
          cssClasses.push("ag-row-number-range-highlight");
        }
        if (range.columns.length === allColsLen) {
          cssClasses.push("ag-row-number-range-selected");
        }
      }
    }
    return cssClasses;
  }
  generateRowNumberCols() {
    const { gos, beans } = this;
    if (!gos.get("rowNumbers")) {
      return [];
    }
    const colDef = this.createRowNumbersColDef();
    const colId = colDef.colId;
    beans.validation?.validateColDef(colDef, colId, true);
    const col = new import_ag_grid_community138.AgColumn(colDef, null, colId, false);
    this.createBean(col);
    return [col];
  }
  // focus is disabled on the Row Numbers cells, when a click happens on it,
  // it should focus the first cell of that row.
  focusFirstRenderedCellAtRowPosition(rowPosition) {
    const { beans, gos } = this;
    const { visibleCols, colViewport } = beans;
    const pinnedCols = gos.get("enableRtl") ? visibleCols.rightCols : visibleCols.leftCols;
    let columns;
    if (pinnedCols.length == 1) {
      const rowNode = (0, import_ag_grid_community138._getRowNode)(beans, rowPosition);
      if (!rowNode) {
        return;
      }
      columns = colViewport.getColsWithinViewport(rowNode);
    } else {
      columns = pinnedCols;
    }
    const column = columns.find((col) => !(0, import_ag_grid_community138.isRowNumberCol)(col));
    if (!column) {
      return;
    }
    const { rowPinned, rowIndex } = rowPosition;
    beans.focusSvc.setFocusedCell({
      rowIndex,
      rowPinned,
      column,
      forceBrowserFocus: true,
      preventScrollOnBrowserFocus: true
    });
  }
  destroy() {
    (0, import_ag_grid_community138._destroyColumnTree)(this.beans, this.columns?.tree);
    this.rowNumberOverrides = null;
    super.destroy();
  }
};

// packages/ag-grid-enterprise/src/rowNumbers/rowNumbersModule.ts
var RowNumbersModule = {
  moduleName: "RowNumbers",
  version: VERSION,
  beans: [RowNumbersService],
  dependsOn: [EnterpriseCoreModule, import_ag_grid_community139.CellStyleModule],
  css: [rowNumbersCSS]
};

// packages/ag-grid-enterprise/src/filterToolPanel/filtersToolPanelModule.ts
var import_ag_grid_community145 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/filterToolPanel/filtersToolPanel.ts
var import_ag_grid_community144 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/filterToolPanel/agFiltersToolPanelHeader.ts
var import_ag_grid_community140 = require("ag-grid-community");
var AgFiltersToolPanelHeader = class extends import_ag_grid_community140.Component {
  constructor() {
    super(...arguments);
    this.eExpand = import_ag_grid_community140.RefPlaceholder;
    this.eFilterTextField = import_ag_grid_community140.RefPlaceholder;
  }
  postConstruct() {
    this.setTemplate(
      /* html */
      `<div class="ag-filter-toolpanel-search" role="presentation">
                <div data-ref="eExpand" class="ag-filter-toolpanel-expand"></div>
                <ag-input-text-field data-ref="eFilterTextField" class="ag-filter-toolpanel-search-input"></ag-input-text-field>
            </div>`,
      [import_ag_grid_community140.AgInputTextFieldSelector]
    );
    const translate = this.getLocaleTextFunc();
    this.eFilterTextField.setAutoComplete(false).setInputAriaLabel(translate("ariaFilterColumnsInput", "Filter Columns Input")).onValueChange(this.onSearchTextChanged.bind(this));
    this.createExpandIcons();
    this.setExpandState(0 /* EXPANDED */);
    this.addManagedElementListeners(this.eExpand, { click: this.onExpandClicked.bind(this) });
    this.addManagedEventListeners({ newColumnsLoaded: this.showOrHideOptions.bind(this) });
  }
  init(params) {
    this.params = params;
    if (this.beans.colModel.ready) {
      this.showOrHideOptions();
    }
  }
  createExpandIcons() {
    const { eExpand, beans } = this;
    eExpand.appendChild(this.eExpandChecked = (0, import_ag_grid_community140._createIconNoSpan)("accordionOpen", beans));
    eExpand.appendChild(this.eExpandUnchecked = (0, import_ag_grid_community140._createIconNoSpan)("accordionClosed", beans));
    eExpand.appendChild(this.eExpandIndeterminate = (0, import_ag_grid_community140._createIconNoSpan)("accordionIndeterminate", beans));
  }
  // we only show expand / collapse if we are showing filters
  showOrHideOptions() {
    const { params, eFilterTextField } = this;
    const showFilterSearch = !params.suppressFilterSearch;
    const showExpand = !params.suppressExpandAll;
    const translate = this.getLocaleTextFunc();
    eFilterTextField.setInputPlaceholder(translate("searchOoo", "Search..."));
    const isFilterGroupPresent = (col) => col.getOriginalParent() && col.isFilterAllowed();
    const filterGroupsPresent = this.beans.colModel.getCols().some(isFilterGroupPresent);
    (0, import_ag_grid_community140._setDisplayed)(eFilterTextField.getGui(), showFilterSearch);
    (0, import_ag_grid_community140._setDisplayed)(this.eExpand, showExpand && filterGroupsPresent);
  }
  onSearchTextChanged() {
    if (!this.onSearchTextChangedDebounced) {
      this.onSearchTextChangedDebounced = (0, import_ag_grid_community140._debounce)(
        this,
        () => this.dispatchLocalEvent({ type: "searchChanged", searchText: this.eFilterTextField.getValue() }),
        300
      );
    }
    this.onSearchTextChangedDebounced();
  }
  onExpandClicked() {
    const event = this.currentExpandState === 0 /* EXPANDED */ ? { type: "collapseAll" } : { type: "expandAll" };
    this.dispatchLocalEvent(event);
  }
  setExpandState(state) {
    this.currentExpandState = state;
    (0, import_ag_grid_community140._setDisplayed)(this.eExpandChecked, state === 0 /* EXPANDED */);
    (0, import_ag_grid_community140._setDisplayed)(this.eExpandUnchecked, state === 1 /* COLLAPSED */);
    (0, import_ag_grid_community140._setDisplayed)(this.eExpandIndeterminate, state === 2 /* INDETERMINATE */);
  }
};
var AgFiltersToolPanelHeaderSelector = {
  selector: "AG-FILTERS-TOOL-PANEL-HEADER",
  component: AgFiltersToolPanelHeader
};

// packages/ag-grid-enterprise/src/filterToolPanel/agFiltersToolPanelList.ts
var import_ag_grid_community143 = require("ag-grid-community");

// packages/ag-grid-enterprise/src/filterToolPanel/toolPanelFilterComp.ts
var import_ag_grid_community141 = require("ag-grid-community");
var ToolPanelFilterComp = class extends import_ag_grid_community141.Component {
  constructor(hideHeader, expandedCallback) {
    super(
      /* html */
      `
            <div class="ag-filter-toolpanel-instance">
                <div class="ag-filter-toolpanel-header ag-filter-toolpanel-instance-header" data-ref="eFilterToolPanelHeader" role="button" aria-expanded="false">
                    <div data-ref="eExpand" class="ag-filter-toolpanel-expand"></div>
                    <span data-ref="eFilterName" class="ag-header-cell-text"></span>
                    <span data-ref="eFilterIcon" class="ag-header-icon ag-filter-icon ag-filter-toolpanel-instance-header-icon" aria-hidden="true"></span>
                </div>
                <div class="ag-filter-toolpanel-instance-body ag-filter" data-ref="agFilterToolPanelBody"></div>
            </div>`
    );
    this.hideHeader = hideHeader;
    this.expandedCallback = expandedCallback;
    this.eFilterToolPanelHeader = import_ag_grid_community141.RefPlaceholder;
    this.eFilterName = import_ag_grid_community141.RefPlaceholder;
    this.agFilterToolPanelBody = import_ag_grid_community141.RefPlaceholder;
    this.eFilterIcon = import_ag_grid_community141.RefPlaceholder;
    this.eExpand = import_ag_grid_community141.RefPlaceholder;
    this.expanded = false;
  }
  postConstruct() {
    const { beans, eExpand } = this;
    const eExpandChecked = (0, import_ag_grid_community141._createIconNoSpan)("accordionOpen", beans);
    this.eExpandChecked = eExpandChecked;
    const eExpandUnchecked = (0, import_ag_grid_community141._createIconNoSpan)("accordionClosed", beans);
    this.eExpandUnchecked = eExpandUnchecked;
    eExpand.appendChild(eExpandChecked);
    eExpand.appendChild(eExpandUnchecked);
  }
  setColumn(column) {
    this.column = column;
    const { beans, eFilterToolPanelHeader, eFilterIcon, eExpandChecked, hideHeader } = this;
    this.eFilterName.innerText = beans.colNames.getDisplayNameForColumn(column, "filterToolPanel", false) || "";
    this.addManagedListeners(eFilterToolPanelHeader, {
      click: this.toggleExpanded.bind(this),
      keydown: this.onKeyDown.bind(this)
    });
    this.addManagedEventListeners({ filterOpened: this.onFilterOpened.bind(this) });
    this.addInIcon("filterActive", eFilterIcon, column);
    (0, import_ag_grid_community141._setDisplayed)(eFilterIcon, this.isFilterActive(), { skipAriaHidden: true });
    (0, import_ag_grid_community141._setDisplayed)(eExpandChecked, false);
    if (hideHeader) {
      (0, import_ag_grid_community141._setDisplayed)(eFilterToolPanelHeader, false);
      eFilterToolPanelHeader.removeAttribute("tabindex");
    } else {
      eFilterToolPanelHeader.setAttribute("tabindex", "0");
    }
    this.addManagedListeners(column, { filterChanged: this.onFilterChanged.bind(this) });
  }
  onKeyDown(e) {
    const { key } = e;
    const { ENTER, SPACE, LEFT, RIGHT } = import_ag_grid_community141.KeyCode;
    if (key !== ENTER && key !== SPACE && key !== LEFT && key !== RIGHT) {
      return;
    }
    e.preventDefault();
    if (key === ENTER || key === SPACE) {
      this.toggleExpanded();
    } else if (key === import_ag_grid_community141.KeyCode.LEFT) {
      this.collapse();
    } else {
      this.expand();
    }
  }
  getColumn() {
    return this.column;
  }
  getColumnFilterName() {
    return this.beans.colNames.getDisplayNameForColumn(this.column, "filterToolPanel", false);
  }
  addCssClassToTitleBar(cssClass) {
    this.eFilterToolPanelHeader.classList.add(cssClass);
  }
  addInIcon(iconName, eParent, column) {
    if (eParent == null) {
      return;
    }
    const eIcon = (0, import_ag_grid_community141._createIconNoSpan)(iconName, this.beans, column);
    eParent.appendChild(eIcon);
  }
  isFilterActive() {
    return !!this.beans.filterManager?.isFilterActive(this.column);
  }
  onFilterChanged() {
    (0, import_ag_grid_community141._setDisplayed)(this.eFilterIcon, this.isFilterActive(), { skipAriaHidden: true });
    this.dispatchLocalEvent({ type: "filterChanged" });
  }
  toggleExpanded() {
    this.expanded ? this.collapse() : this.expand();
  }
  expand() {
    if (this.expanded) {
      return;
    }
    this.expanded = true;
    (0, import_ag_grid_community141._setAriaExpanded)(this.eFilterToolPanelHeader, true);
    (0, import_ag_grid_community141._setDisplayed)(this.eExpandChecked, true);
    (0, import_ag_grid_community141._setDisplayed)(this.eExpandUnchecked, false);
    this.addFilterElement();
    this.expandedCallback();
  }
  addFilterElement(suppressFocus) {
    const filterPanelWrapper = (0, import_ag_grid_community141._loadTemplate)(
      /* html */
      `<div class="ag-filter-toolpanel-instance-filter"></div>`
    );
    const comp = this.createManagedBean(new import_ag_grid_community141.FilterWrapperComp(this.column, "TOOLBAR"));
    this.filterWrapperComp = comp;
    if (!comp.hasFilter()) {
      return;
    }
    comp.getFilter()?.then((filter) => {
      this.underlyingFilter = filter;
      if (!filter) {
        return;
      }
      filterPanelWrapper.appendChild(comp.getGui());
      this.agFilterToolPanelBody.appendChild(filterPanelWrapper);
      comp.afterGuiAttached({ container: "toolPanel", suppressFocus });
    });
  }
  collapse() {
    if (!this.expanded) {
      return;
    }
    this.expanded = false;
    (0, import_ag_grid_community141._setAriaExpanded)(this.eFilterToolPanelHeader, false);
    this.removeFilterElement();
    (0, import_ag_grid_community141._setDisplayed)(this.eExpandChecked, false);
    (0, import_ag_grid_community141._setDisplayed)(this.eExpandUnchecked, true);
    const filterWrapperComp = this.filterWrapperComp;
    filterWrapperComp?.afterGuiDetached();
    this.destroyBean(filterWrapperComp);
    this.expandedCallback();
  }
  removeFilterElement() {
    (0, import_ag_grid_community141._clearElement)(this.agFilterToolPanelBody);
  }
  isExpanded() {
    return this.expanded;
  }
  refreshFilter(isDisplayed) {
    if (!this.expanded) {
      return;
    }
    const filter = this.underlyingFilter;
    if (!filter) {
      return;
    }
    if (isDisplayed) {
      if (typeof filter.refreshVirtualList === "function") {
        filter.refreshVirtualList();
      }
    } else {
      filter.afterGuiDetached?.();
    }
  }
  onFilterOpened(event) {
    if (event.source !== "COLUMN_MENU") {
      return;
    }
    if (event.column !== this.column) {
      return;
    }
    if (!this.expanded) {
      return;
    }
    this.collapse();
  }
};

// packages/ag-grid-enterprise/src/filterToolPanel/toolPanelFilterGroupComp.ts
var import_ag_grid_community142 = require("ag-grid-community");
var ToolPanelFilterGroupComp = class _ToolPanelFilterGroupComp extends import_ag_grid_community142.Component {
  constructor(columnGroup, childFilterComps, expandedCallback, depth, showingColumn) {
    super();
    this.columnGroup = columnGroup;
    this.childFilterComps = childFilterComps;
    this.expandedCallback = expandedCallback;
    this.depth = depth;
    this.showingColumn = showingColumn;
    this.filterGroupComp = import_ag_grid_community142.RefPlaceholder;
  }
  postConstruct() {
    const groupParams = {
      cssIdentifier: "filter-toolpanel",
      direction: "vertical"
    };
    this.setTemplate(
      /* html */
      `<div class="ag-filter-toolpanel-group-wrapper">
            <ag-group-component data-ref="filterGroupComp"></ag-group-component>
        </div>`,
      [AgGroupComponentSelector],
      { filterGroupComp: groupParams }
    );
    this.setGroupTitle();
    const { filterGroupComp, depth, childFilterComps, gos } = this;
    filterGroupComp.setAlignItems("stretch");
    filterGroupComp.addCssClass(`ag-filter-toolpanel-group-level-${depth}`);
    filterGroupComp.getGui().style.setProperty("--ag-indentation-level", String(depth));
    filterGroupComp.addCssClassToTitleBar(`ag-filter-toolpanel-group-level-${depth}-header`);
    childFilterComps.forEach((filterComp) => {
      filterGroupComp.addItem(filterComp);
      filterComp.addCssClassToTitleBar(`ag-filter-toolpanel-group-level-${depth + 1}-header`);
      filterComp.getGui().style.setProperty("--ag-indentation-level", String(depth + 1));
    });
    this.tooltipFeature = this.createOptionalManagedBean(
      this.beans.registry.createDynamicBean("tooltipFeature", false, {
        getGui: () => this.getGui(),
        getLocation: () => "filterToolPanelColumnGroup",
        shouldDisplayTooltip: (0, import_ag_grid_community142._getShouldDisplayTooltip)(
          gos,
          () => filterGroupComp.getGui().querySelector(".ag-group-title")
        )
      })
    );
    this.refreshFilterClass();
    this.addExpandCollapseListeners();
    this.addFilterChangedListeners();
    this.setupTooltip();
    this.addInIcon("filterActive");
  }
  setupTooltip() {
    if (!this.showingColumn) {
      return;
    }
    const refresh = () => {
      this.tooltipFeature?.setTooltipAndRefresh(this.columnGroup.getColDef().headerTooltip);
    };
    refresh();
    this.addManagedEventListeners({ newColumnsLoaded: refresh });
  }
  addCssClassToTitleBar(cssClass) {
    this.filterGroupComp.addCssClassToTitleBar(cssClass);
  }
  refreshFilters(isDisplayed) {
    this.childFilterComps.forEach((filterComp) => {
      if (filterCo