import { type FillOptions, type LineDashOptions, type StrokeOptions, _ModuleSupport } from 'ag-charts-community';
import { FlowProportionSeries } from '../flow-proportion/flowProportionSeries';
import { SankeyLink } from './sankeyLink';
import { type SankeyDatum, type SankeyLinkDatum, type SankeyNodeDatum, type SankeyNodeLabelDatum, SankeySeriesProperties } from './sankeySeriesProperties';
type NodeStyle = Pick<FillOptions & StrokeOptions & LineDashOptions, 'fill' | 'stroke'> & Omit<Required<FillOptions & StrokeOptions & LineDashOptions>, 'fill' | 'stroke'>;
type LinkStyle = NodeStyle;
export declare class SankeySeries extends FlowProportionSeries<SankeyNodeDatum, SankeyLinkDatum, SankeyNodeLabelDatum, SankeySeriesProperties, _ModuleSupport.Rect, SankeyLink> {
    static readonly className = "SankeySeries";
    static readonly type: "sankey";
    properties: SankeySeriesProperties;
    constructor(moduleCtx: _ModuleSupport.ModuleContext);
    private isLabelEnabled;
    protected linkFactory(): SankeyLink<any>;
    protected nodeFactory(): _ModuleSupport.Rect<any>;
    createNodeData(): {
        itemId: string;
        nodeData: SankeyDatum[];
        labelData: SankeyNodeLabelDatum[];
    } | undefined;
    protected updateLabelSelection(opts: {
        labelData: SankeyNodeLabelDatum[];
        labelSelection: _ModuleSupport.Selection<_ModuleSupport.TransformableText, SankeyNodeLabelDatum>;
    }): _ModuleSupport.Selection<_ModuleSupport.TransformableText, SankeyNodeLabelDatum>;
    protected updateLabelNodes(opts: {
        labelSelection: _ModuleSupport.Selection<_ModuleSupport.TransformableText, SankeyNodeLabelDatum>;
    }): void;
    protected updateNodeSelection(opts: {
        nodeData: SankeyNodeDatum[];
        datumSelection: _ModuleSupport.Selection<_ModuleSupport.Rect, SankeyNodeDatum>;
    }): _ModuleSupport.Selection<_ModuleSupport.Rect<any>, SankeyNodeDatum>;
    protected getBaseNodeStyle(highlighted: boolean): NodeStyle;
    protected getNodeStyleOverrides(datumId: string, datum: any, datumIndex: number, size: number, label: string | undefined, format: NodeStyle, highlighted: boolean): Partial<NodeStyle>;
    protected updateNodeNodes(opts: {
        datumSelection: _ModuleSupport.Selection<_ModuleSupport.Rect, SankeyNodeDatum>;
        isHighlight: boolean;
    }): void;
    protected updateLinkSelection(opts: {
        nodeData: SankeyLinkDatum[];
        datumSelection: _ModuleSupport.Selection<SankeyLink, SankeyLinkDatum>;
    }): _ModuleSupport.Selection<SankeyLink<any>, SankeyLinkDatum>;
    protected getBaseLinkStyle(highlighted: boolean): LinkStyle;
    protected getLinkStyleOverrides(datumId: string, datum: any, datumIndex: number, format: LinkStyle, highlighted: boolean): Partial<NodeStyle>;
    protected updateLinkNodes(opts: {
        datumSelection: _ModuleSupport.Selection<SankeyLink, SankeyLinkDatum>;
        isHighlight: boolean;
    }): void;
    getTooltipContent(seriesDatum: SankeyDatum): _ModuleSupport.TooltipContent | undefined;
    protected computeFocusBounds(node: _ModuleSupport.Rect | SankeyLink): _ModuleSupport.BBox | _ModuleSupport.Path | undefined;
}
export {};
