import { type AgMarkerShape, type FillOptions, type LineDashOptions, type StrokeOptions, _ModuleSupport } from 'ag-charts-community';
import { type RangeAreaMarkerDatum, RangeAreaProperties } from './rangeAreaProperties';
import { type RangeAreaContext, type RangeAreaLabelDatum } from './rangeAreaUtil';
declare class RangeAreaSeriesNodeEvent<TEvent extends string = _ModuleSupport.SeriesNodeEventTypes> extends _ModuleSupport.SeriesNodeEvent<RangeAreaMarkerDatum, TEvent> {
    readonly xKey?: string;
    readonly yLowKey?: string;
    readonly yHighKey?: string;
    constructor(type: TEvent, nativeEvent: Event, datum: RangeAreaMarkerDatum, series: RangeAreaSeries);
}
type ItemStyle = Required<FillOptions & StrokeOptions & LineDashOptions & {
    shape: AgMarkerShape;
    size: number;
}>;
export declare class RangeAreaSeries extends _ModuleSupport.CartesianSeries<_ModuleSupport.Group, RangeAreaProperties, RangeAreaMarkerDatum, RangeAreaLabelDatum, RangeAreaContext> {
    static readonly className = "RangeAreaSeries";
    static readonly type: "range-area";
    properties: RangeAreaProperties;
    protected readonly NodeEvent: typeof RangeAreaSeriesNodeEvent;
    private dataAggregationFilters;
    constructor(moduleCtx: _ModuleSupport.ModuleContext);
    processData(dataController: _ModuleSupport.DataController): Promise<void>;
    private aggregateData;
    xCoordinateRange(xValue: any): [number, number];
    yCoordinateRange(yValues: any[]): [number, number];
    getSeriesDomain(direction: _ModuleSupport.ChartAxisDirection): any[];
    getSeriesRange(_direction: _ModuleSupport.ChartAxisDirection, visibleRange: [any, any]): any[];
    createNodeData(): RangeAreaContext | undefined;
    private createLabelData;
    protected isPathOrSelectionDirty(): boolean;
    protected updatePathNodes(opts: {
        paths: _ModuleSupport.Path[];
        opacity: number;
        visible: boolean;
        animationEnabled: boolean;
    }): void;
    protected updatePaths(opts: {
        contextData: RangeAreaContext;
        paths: _ModuleSupport.Path[];
    }): void;
    private updateAreaPaths;
    private updateFillPath;
    private updateStrokePath;
    protected updateMarkerSelection(opts: {
        nodeData: RangeAreaMarkerDatum[];
        markerSelection: _ModuleSupport.Selection<_ModuleSupport.Marker, RangeAreaMarkerDatum>;
    }): _ModuleSupport.Selection<_ModuleSupport.Marker, RangeAreaMarkerDatum>;
    private getMarkerItemBaseStyle;
    protected getMarkerItemStyleOverrides(datumId: string, datum: any, format: ItemStyle, highlighted: boolean): import("ag-charts-community").AgSeriesMarkerStyle | undefined;
    protected updateMarkerNodes(opts: {
        markerSelection: _ModuleSupport.Selection<_ModuleSupport.Marker, RangeAreaMarkerDatum>;
        isHighlight: boolean;
    }): void;
    protected updateLabelSelection(opts: {
        labelData: RangeAreaLabelDatum[];
        labelSelection: _ModuleSupport.Selection<_ModuleSupport.Text, RangeAreaLabelDatum>;
    }): _ModuleSupport.Selection<_ModuleSupport.Text<any>, RangeAreaLabelDatum>;
    protected updateLabelNodes(opts: {
        labelSelection: _ModuleSupport.Selection<_ModuleSupport.Text, RangeAreaLabelDatum>;
    }): void;
    protected getHighlightLabelData(labelData: RangeAreaLabelDatum[], highlightedItem: RangeAreaMarkerDatum): RangeAreaLabelDatum[] | undefined;
    protected getHighlightData(nodeData: RangeAreaMarkerDatum[], highlightedItem: RangeAreaMarkerDatum): RangeAreaMarkerDatum[] | undefined;
    getTooltipContent(nodeDatum: RangeAreaMarkerDatum): _ModuleSupport.TooltipContent | undefined;
    private legendItemSymbol;
    getLegendData(legendType: _ModuleSupport.ChartLegendType): _ModuleSupport.CategoryLegendDatum[];
    protected isLabelEnabled(): boolean;
    onDataChange(): void;
    protected nodeFactory(): _ModuleSupport.Group<any>;
    animateEmptyUpdateReady(animationData: _ModuleSupport.CartesianAnimationData<_ModuleSupport.Group, RangeAreaMarkerDatum, RangeAreaLabelDatum, RangeAreaContext>): void;
    protected animateReadyResize(animationData: _ModuleSupport.CartesianAnimationData<_ModuleSupport.Group, RangeAreaMarkerDatum, RangeAreaLabelDatum, RangeAreaContext>): void;
    animateWaitingUpdateReady(animationData: _ModuleSupport.CartesianAnimationData<_ModuleSupport.Group, RangeAreaMarkerDatum, RangeAreaLabelDatum, RangeAreaContext>): void;
    getFormattedMarkerStyle(datum: RangeAreaMarkerDatum): import("ag-charts-community").AgSeriesMarkerStyle & {
        size: number;
    };
    protected computeFocusBounds(opts: _ModuleSupport.PickFocusInputs): _ModuleSupport.BBox | undefined;
    protected computeFocusDatumIndex(opts: _ModuleSupport.PickFocusInputs, nodeData: RangeAreaMarkerDatum[]): number | undefined;
}
export {};
