import { _ModuleSupport } from 'ag-charts-community';
declare class RadiusAxisLabel extends _ModuleSupport.AxisLabel {
    autoRotate?: boolean;
    autoRotateAngle: number;
}
export declare abstract class RadiusAxis<S extends _ModuleSupport.Scale<D, number, _ModuleSupport.TickInterval<S>> = _ModuleSupport.Scale<any, number, any>, D = any> extends _ModuleSupport.PolarAxis<S, D, _ModuleSupport.TickDatum, _ModuleSupport.LabelNodeDatum> {
    protected static CrossLineConstructor: new () => _ModuleSupport.CrossLine<any>;
    positionAngle: number;
    private readonly tickGenerator;
    private generatedTicks;
    protected readonly lineNode: _ModuleSupport.Line;
    protected readonly gridPathGroup: _ModuleSupport.Group<any>;
    protected gridPathSelection: _ModuleSupport.Selection<_ModuleSupport.Path<unknown>, any>;
    get direction(): _ModuleSupport.ChartAxisDirection;
    constructor(moduleCtx: _ModuleSupport.ModuleContext, scale: S);
    protected getAxisTransform(): {
        translationX: number;
        translationY: number;
        rotation: number;
        rotationCenterX: number;
        rotationCenterY: number;
    };
    update(): void;
    calculateTickLayout(domain: D[], niceMode: _ModuleSupport.NiceMode, _visibleRange: [number, number], initialPrimaryTickCount?: number): {
        niceDomain: D[];
        primaryTickCount: number | undefined;
        tickDomain: D[];
        ticks: D[];
        fractionDigits: number;
        bbox: undefined;
    };
    protected abstract prepareGridPathTickData(tickData: _ModuleSupport.TickDatum[]): _ModuleSupport.TickDatum[];
    protected abstract getTickRadius(tickDatum: _ModuleSupport.TickDatum): number;
    protected updateSelections(): void;
    protected updateLabels(): void;
    protected updateGridLines(): void;
    private updateTitle;
    protected updateCrossLines(): void;
    protected createLabel(): RadiusAxisLabel;
    private getTickLabelProps;
}
export {};
