import { type AgRadialSeriesStyle, _ModuleSupport } from 'ag-charts-community';
import { RadialBarSeriesProperties } from './radialBarSeriesProperties';
declare class RadialBarSeriesNodeEvent<TEvent extends string = _ModuleSupport.SeriesNodeEventTypes> extends _ModuleSupport.SeriesNodeEvent<RadialBarNodeDatum, TEvent> {
    readonly angleKey?: string;
    readonly radiusKey?: string;
    constructor(type: TEvent, nativeEvent: Event, datum: RadialBarNodeDatum, series: RadialBarSeries);
}
interface RadialBarLabelNodeDatum {
    text: string;
    x: number;
    y: number;
    textAlign: CanvasTextAlign;
    textBaseline: CanvasTextBaseline;
}
interface RadialBarNodeDatum extends _ModuleSupport.DataModelSeriesNodeDatum {
    readonly label?: RadialBarLabelNodeDatum;
    readonly angleValue: any;
    readonly radiusValue: any;
    readonly innerRadius: number;
    readonly outerRadius: number;
    readonly startAngle: number;
    readonly endAngle: number;
    readonly clipSector: _ModuleSupport.SectorBox;
    readonly reversed: boolean;
    readonly index: number;
}
type ItemStyle = Required<AgRadialSeriesStyle>;
export declare class RadialBarSeries extends _ModuleSupport.PolarSeries<RadialBarNodeDatum, RadialBarSeriesProperties<any>, _ModuleSupport.Sector> {
    static readonly className = "RadialBarSeries";
    static readonly type: "radial-bar";
    properties: RadialBarSeriesProperties<import("ag-charts-community").AgRadialBarSeriesOptions<any>>;
    protected readonly NodeEvent: typeof RadialBarSeriesNodeEvent;
    private readonly groupScale;
    constructor(moduleCtx: _ModuleSupport.ModuleContext);
    protected nodeFactory(): _ModuleSupport.Sector;
    getSeriesDomain(direction: _ModuleSupport.ChartAxisDirection): any[];
    processData(dataController: _ModuleSupport.DataController): Promise<void>;
    protected circleCache: {
        r: number;
        cx: number;
        cy: number;
    };
    protected didCircleChange(): boolean;
    protected maybeRefreshNodeData(): void;
    protected getAxisInnerRadius(): number;
    createNodeData(): {
        itemId: string;
        nodeData: RadialBarNodeDatum[];
        labelData: RadialBarNodeDatum[];
    } | undefined;
    update({ seriesRect }: {
        seriesRect?: _ModuleSupport.BBox;
    }): void;
    private getItemBaseStyle;
    protected getItemStyleOverrides(datumId: string, datum: any, format: ItemStyle, highlighted: boolean): AgRadialSeriesStyle | undefined;
    protected updateSectorSelection(selection: _ModuleSupport.Selection<_ModuleSupport.Sector, RadialBarNodeDatum>, highlighted: boolean): void;
    protected updateLabels(): void;
    private getBarTransitionFunctions;
    protected animateEmptyUpdateReady(): void;
    animateClearingUpdateEmpty(): void;
    getTooltipContent(nodeDatum: RadialBarNodeDatum): _ModuleSupport.TooltipContent | undefined;
    protected pickNodeClosestDatum(point: _ModuleSupport.Point): _ModuleSupport.SeriesNodePickMatch | undefined;
    private legendItemSymbol;
    getLegendData(legendType: _ModuleSupport.ChartLegendType): _ModuleSupport.CategoryLegendDatum[];
    private getDatumId;
    computeLabelsBBox(): null;
    protected getStackId(): string;
}
export {};
