import { _ModuleSupport } from 'ag-charts-community';
import { type AnnotationType } from './annotationTypes';
declare const ToolbarButtonProperties: typeof _ModuleSupport.ToolbarButtonProperties;
interface EventMap {
    'cancel-create-annotation': void;
    'pressed-create-annotation': {
        annotation: AnnotationType;
    };
    'pressed-clear': void;
    'pressed-show-menu': void;
    'pressed-unrelated': void;
}
type AnnotationsToolbarButtonValue = 'line-menu' | 'fibonacci-menu' | 'text-menu' | 'shape-menu' | 'measurer-menu' | 'clear';
declare class AnnotationsToolbarButtonProperties extends ToolbarButtonProperties {
    value: AnnotationsToolbarButtonValue;
}
export declare class AnnotationsToolbar extends _ModuleSupport.BaseProperties {
    private readonly ctx;
    enabled?: boolean;
    /**
     * The padding between the toolbar and the chart area.
     */
    padding: number;
    buttons: _ModuleSupport.PropertiesArray<AnnotationsToolbarButtonProperties>;
    private readonly events;
    private readonly toolbar;
    private readonly annotationMenu;
    private readonly destroyFns;
    constructor(ctx: _ModuleSupport.ModuleContext);
    destroy(): void;
    addListener<K extends keyof EventMap>(eventType: K, handler: (event: EventMap[K]) => void): () => void;
    toggleVisibility(visible: boolean): void;
    toggleClearButtonEnabled(enabled: boolean): void;
    resetButtonIcons(): void;
    hideOverlays(): void;
    clearActiveButton(): void;
    private dispatch;
    private onLayoutStart;
    refreshButtonsEnabled(enabled: boolean): void;
    private onToolbarButtonPress;
    private onToolbarButtonPressShowMenu;
    private onButtonPressMenuCreateAnnotation;
    private onKeyDown;
    private updateButtonByIndex;
}
export {};
