import type { AgAngleAxisLabelOrientation } from 'ag-charts-community';
import { _ModuleSupport } from 'ag-charts-community';
export interface AngleAxisLabelDatum {
    text: string;
    x: number;
    y: number;
    hidden: boolean;
    rotation: number;
    textAlign: CanvasTextAlign;
    textBaseline: CanvasTextBaseline;
    box: _ModuleSupport.BBox | undefined;
}
interface AngleAxisTickDatum<TDatum> {
    value: TDatum;
    visible: boolean;
}
declare class AngleAxisLabel extends _ModuleSupport.AxisLabel {
    orientation: AgAngleAxisLabelOrientation;
}
export declare abstract class AngleAxis<TDomain, TScale extends _ModuleSupport.Scale<TDomain, any>> extends _ModuleSupport.PolarAxis<TScale> {
    protected static CrossLineConstructor: new () => _ModuleSupport.CrossLine<any>;
    startAngle: number;
    endAngle: number | undefined;
    protected labelData: AngleAxisLabelDatum[];
    protected tickData: AngleAxisTickDatum<TDomain>[];
    protected radiusLine: _ModuleSupport.Path;
    constructor(moduleCtx: _ModuleSupport.ModuleContext, scale: TScale);
    get direction(): _ModuleSupport.ChartAxisDirection;
    protected createLabel(): AngleAxisLabel;
    calculateTickLayout(domain: TDomain[]): {
        niceDomain: any[];
        primaryTickCount: number | undefined;
        tickDomain: TDomain[];
        ticks: TDomain[];
        fractionDigits: number;
        bbox: _ModuleSupport.BBox;
    };
    update(): void;
    private normalizedAngles;
    computeRange(): void;
    protected abstract generateAngleTicks(domain: TDomain[]): AngleAxisTickDatum<TDomain>[];
    protected updateSelections(): void;
    updatePosition(): void;
    protected updateRadiusLine(): void;
    getAxisLinePoints(): {
        points: ({
            x: number;
            y: number;
            moveTo: boolean;
            radius?: undefined;
            startAngle?: undefined;
            endAngle?: undefined;
            arc?: undefined;
        } | {
            x: number;
            y: number;
            radius: number;
            startAngle: number;
            endAngle: number;
            arc: boolean;
            moveTo: boolean;
        })[];
        closePath: boolean;
    };
    protected updateGridLines(): void;
    protected updateLabels(): void;
    protected updateTickLines(): void;
    protected createLabelNodeData(ticks: any[], options: {
        hideWhenNecessary: boolean;
    }, seriesRect: _ModuleSupport.BBox): AngleAxisLabelDatum[];
    protected abstract avoidLabelCollisions(labelData: AngleAxisLabelDatum[]): void;
    computeLabelsBBox(options: {
        hideWhenNecessary: boolean;
    }, seriesRect: _ModuleSupport.BBox): _ModuleSupport.BBox | null;
    protected getLabelOrientation(): AgAngleAxisLabelOrientation;
    protected getLabelRotation(tickAngle: number): number;
    protected getLabelAlign(tickAngle: number): {
        textAlign: "left" | "right" | "center";
        textBaseline: "top" | "bottom" | "middle";
    };
    protected updateCrossLines(): void;
}
export {};
