import type { BBox } from '../bbox';
import type { GradientColorStop } from './stops';
export type ColorSpace = 'rgb' | 'oklch';
export declare abstract class Gradient {
    colorSpace: ColorSpace;
    stops: GradientColorStop[];
    private readonly bbox?;
    constructor(colorSpace: ColorSpace, stops?: GradientColorStop[], bbox?: BBox | undefined);
    protected abstract createCanvasGradient(ctx: CanvasRenderingContext2D, bbox: BBox): CanvasGradient | undefined;
    private _cache;
    createGradient(ctx: CanvasRenderingContext2D, shapeBbox: BBox): CanvasGradient | string | undefined;
}
