import { AbstractScale } from './abstractScale';
import type { NormalizedDomain } from './scale';
export declare abstract class ContinuousScale<D extends number | Date, I = number> extends AbstractScale<D, number, I> {
    domain: D[];
    range: number[];
    static is(value: unknown): value is ContinuousScale<any, any>;
    static readonly defaultTickCount = 5;
    protected defaultClamp: boolean;
    protected constructor(domain?: D[], range?: number[]);
    abstract toDomain(value: number): D;
    normalizeDomains(...domains: D[][]): NormalizedDomain<D>;
    protected transform(x: D): D;
    protected transformInvert(x: D): D;
    calcBandwidth(smallestInterval?: number): number;
    convert(value: D, clamp?: boolean): number;
    invert(x: number, _nearest?: boolean): D;
    protected getPixelRange(): number;
}
