import { BandScale } from './bandScale';
import type { NormalizedDomain } from './scale';
export declare class CategoryScale<D, I = number> extends BandScale<D, I> {
    readonly type: "band";
    /**
     * Maps datum to its index in the {@link domain} array.
     * Used to check for duplicate data (not allowed).
     */
    protected index: Map<D, number> | undefined;
    /**
     * Contains unique data only.
     */
    protected _domain: D[];
    set domain(values: D[]);
    get domain(): D[];
    normalizeDomains(...domains: D[][]): NormalizedDomain<D>;
    toDomain(_value: number): D | undefined;
    invert(position: number, nearest?: boolean): D | undefined;
    protected getIndex(value: D): number | undefined;
}
