import type { DataService } from '../data/dataService';
import type { AnimationManager } from '../interaction/animationManager';
import type { ZoomManager } from '../interaction/zoomManager';
import type { UpdateService } from '../updateService';
import type { ChartLike, UpdateProcessor } from './processor';
export declare class DataWindowProcessor<D extends object> implements UpdateProcessor {
    private readonly chart;
    private readonly dataService;
    private readonly updateService;
    private readonly zoomManager;
    private readonly animationManager;
    private dirtyZoom;
    private dirtyDataSource;
    private readonly lastAxisZooms;
    private readonly destroyFns;
    constructor(chart: ChartLike, dataService: DataService<D>, updateService: UpdateService, zoomManager: ZoomManager, animationManager: AnimationManager);
    destroy(): void;
    private onDataLoad;
    private onDataError;
    private onDataSourceChange;
    private onUpdateComplete;
    private onZoomChange;
    private updateWindow;
    private getValidAxis;
    private shouldRefresh;
    private getAxisWindow;
}
