import type { RequireOptional } from 'ag-charts-core';
import type { AgMarkerShape, AgSeriesMarkerStyle, AgSeriesMarkerStylerParams, ISeriesMarker, Styler } from 'ag-charts-types';
import { ChangeDetectableProperties } from '../../scene/util/changeDetectableProperties';
export declare const MARKER_SHAPE: import("../../util/validation").ValidatePredicate;
export declare class SeriesMarker<TParams = never> extends ChangeDetectableProperties implements ISeriesMarker<RequireOptional<TParams>> {
    enabled: boolean;
    /** One of the predefined marker names, or a marker shape function (for user-defined markers). */
    shape: AgMarkerShape;
    size: number;
    fill?: string;
    fillOpacity: number;
    stroke?: string;
    strokeWidth: number;
    strokeOpacity: number;
    lineDash: number[];
    lineDashOffset: number;
    itemStyler?: Styler<AgSeriesMarkerStylerParams<unknown> & RequireOptional<TParams>, AgSeriesMarkerStyle>;
    getStyle(): AgSeriesMarkerStyle;
    getDiameter(): number;
}
