import { FocusIndicator } from '../../dom/focusIndicator';
import type { TranslatableGroup } from '../../scene/group';
import { BaseManager } from '../../util/baseManager';
import type { TypedEvent } from '../../util/observable';
import type { ChartContext } from '../chartContext';
import type { ChartHighlight } from '../chartHighlight';
import type { ChartMode } from '../chartMode';
import { ChartUpdateType } from '../chartUpdateType';
import type { ChartType } from '../factory/chartTypes';
import type { ChartOverlays } from '../overlay/chartOverlays';
import { Tooltip } from '../tooltip/tooltip';
import { type Series } from './series';
import type { SeriesProperties } from './seriesProperties';
import type { SeriesNodeDatum } from './seriesTypes';
export interface SeriesAreaChartDependencies {
    fireEvent<TEvent extends TypedEvent>(event: TEvent): void;
    getUpdateType(): ChartUpdateType;
    chartType: ChartType;
    seriesRoot: TranslatableGroup;
    ctx: ChartContext;
    tooltip: Tooltip;
    highlight: ChartHighlight;
    overlays: ChartOverlays;
    mode: ChartMode;
}
export declare class SeriesAreaManager extends BaseManager {
    private readonly chart;
    readonly id: string;
    private series;
    private seriesRect?;
    private hoverRect?;
    readonly focusIndicator: FocusIndicator;
    private readonly swapChain;
    private readonly highlight;
    private readonly tooltip;
    /**
     * A11y Requirements for Tooltip/Highlight (see AG-13051 for details):
     *
     *   -   When the series-area is blurred, always the mouse to update the tooltip/highlight.
     *
     *   -   When the series-area receives a `focus` event, use `:focus-visible` to guess the input device.
     *       (this is decided by the browser).
     *
     *   -   For keyboard users, `focus` and `keydown` events always updates & shows the tooltip/highlight on
     *       the currently (or newly) focused datum.
     *
     *   -   For keyboard users, `mousemove` events update the tooltip/highlight iff `pickNode` finds a match
     *       for the mouse event offsets.
     */
    private hoverDevice;
    /**
     * This is the "second last" input event. It can be useful for keydown
     * events that for which don't to set the isFocusVisible state
     * (e.g. Backspace/Delete key on FC annotations, see AG-13041).
     *
     * Use with caution! The focus indicator must ALWAYS be visible for
     * keyboard-only users.
     */
    private previousInputDevice;
    private readonly focus;
    constructor(chart: SeriesAreaChartDependencies);
    private isState;
    private isIgnoredTouch;
    dataChanged(): void;
    private preSceneRender;
    private updateComplete;
    private update;
    seriesChanged(series: Series<unknown, SeriesNodeDatum<unknown>, SeriesProperties<object>>[]): void;
    private layoutComplete;
    private onContextMenu;
    private onLeave;
    private onWheel;
    private onDragMove;
    private onHover;
    private onHoverLikeEvent;
    private onClick;
    private onFocus;
    private onBlur;
    private onKeyDown;
    private onArrow;
    private onSubmit;
    private checkSeriesNodeClick;
    private handleFocus;
    private handleSeriesFocus;
    private handleSoloSeriesFocus;
    private updatePickedFocus;
    private getDatumAriaText;
    private clearHighlight;
    private clearTooltip;
    private clearAll;
    private readonly hoverScheduler;
    private handleHoverHighlight;
    private handleHoverTooltip;
    private changeHighlightDatum;
    private pickNode;
}
