import type { ApplyFn, FromToMotionPropFn } from '../../../motion/fromToMotion';
import type { Scale } from '../../../scale/scale';
import { BBox } from '../../../scene/bbox';
import type { Rect } from '../../../scene/shape/rect';
import type { ChartAxis } from '../../chartAxis';
import { ChartAxisDirection } from '../../chartAxisDirection';
import type { ISeries } from '../seriesTypes';
export declare function checkCrisp(scale: Scale<any, any> | undefined, visibleRange: number[] | undefined, smallestDataInterval: number | undefined, largestDataInterval: number | undefined): boolean;
export type InitialPosition<T> = {
    isVertical: boolean;
    mode: 'normal' | 'fade';
    calculate: (datum: T, prevDatum?: T) => T;
};
export declare function collapsedStartingBarPosition(isVertical: boolean, axes: Record<ChartAxisDirection, ChartAxis | undefined>, mode: 'normal' | 'fade'): InitialPosition<AnimatableBarDatum>;
export declare function midpointStartingBarPosition(isVertical: boolean, mode: 'normal' | 'fade'): InitialPosition<AnimatableBarDatum>;
type AnimatableBarDatum = {
    x: number;
    y: number;
    height: number;
    width: number;
    clipBBox?: BBox;
    opacity?: number;
};
type RectDatum = {
    crisp: boolean;
};
type BarRect = Rect<RectDatum>;
export declare function prepareBarAnimationFunctions<T extends AnimatableBarDatum>(initPos: InitialPosition<T>): {
    toFn: FromToMotionPropFn<BarRect, AnimatableBarDatum, T>;
    fromFn: FromToMotionPropFn<BarRect, AnimatableBarDatum, T>;
    applyFn: ApplyFn<BarRect, AnimatableBarDatum>;
};
export declare function resetBarSelectionsFn(rect: BarRect, { x, y, width, height, clipBBox, opacity }: AnimatableBarDatum): {
    x: number;
    y: number;
    width: number;
    height: number;
    clipBBox: BBox | undefined;
    opacity: number;
    crisp: any;
};
export declare function computeBarFocusBounds(series: ISeries<unknown, unknown>, datum: {
    x: number;
    y: number;
    width: number;
    height: number;
} | undefined): BBox | undefined;
export {};
