import type { AgAutoScaledAxes, AgZoomRange, AgZoomRatio } from 'ag-charts-types';
import type { MementoOriginator } from '../../api/state/memento';
import type { Scale } from '../../scale/scale';
import type { BBox } from '../../scene/bbox';
import { BaseManager } from '../../util/baseManager';
import type { BBoxValues } from '../../util/bboxinterface';
import type { TypedEvent } from '../../util/observable';
import { ChartAxisDirection } from '../chartAxisDirection';
import type { LayoutManager } from '../layout/layoutManager';
import type { ISeries } from '../series/seriesTypes';
export interface ZoomState {
    min: number;
    max: number;
}
export interface AxisZoomState {
    x?: ZoomState;
    y?: ZoomState;
    autoScaleYAxis?: boolean;
}
export interface DefinedZoomState {
    x: ZoomState;
    y: ZoomState;
}
export type ZoomMemento = {
    rangeX?: AgZoomRange;
    rangeY?: AgZoomRange;
    ratioX?: AgZoomRatio;
    ratioY?: AgZoomRatio;
    autoScaledAxes?: AgAutoScaledAxes;
};
export interface ZoomChangeEvent extends AxisZoomState {
    readonly type: 'zoom-change';
    readonly x?: Readonly<ZoomState>;
    readonly y?: Readonly<ZoomState>;
    readonly callerId: string;
    readonly axes: Record<string, Readonly<ZoomState> | undefined>;
}
export interface ZoomPanStartEvent {
    readonly type: 'zoom-pan-start';
    readonly callerId: string;
}
export type ChartAxisLike = {
    id: string;
    direction: ChartAxisDirection;
    visibleRange: [number, number];
    scale: Scale<any, any>;
    range: [number, number];
    boundSeries: ISeries<any, any>[];
    min?: number;
    max?: number;
};
type ZoomEvents = ZoomChangeEvent | ZoomPanStartEvent;
/**
 * Manages the current zoom state for a chart. Tracks the requested zoom from distinct dependents
 * and handles conflicting zoom requests.
 */
export declare class ZoomManager extends BaseManager<ZoomEvents['type'], ZoomEvents> implements MementoOriginator<ZoomMemento> {
    private readonly fireChartEvent;
    mementoOriginatorKey: "zoom";
    private readonly axisZoomManagers;
    private readonly state;
    private axes;
    private didLayoutAxes;
    private readonly autoScaleYAxis;
    private lastRestoredState;
    private independentAxes;
    private navigatorModule;
    private zoomModule;
    private pendingMemento;
    constructor(fireChartEvent: <TEvent extends TypedEvent>(event: TEvent) => void, layoutManager: LayoutManager);
    createMemento(): ZoomMemento;
    guardMemento(blob: unknown, messages: Array<string>): blob is ZoomMemento | undefined;
    restoreMemento(version: string, mementoVersion: string, memento: ZoomMemento | undefined): void;
    updateAxes(axes: Array<ChartAxisLike>): void;
    setIndependentAxes(independent?: boolean): void;
    setAutoScaleYAxis(enabled: boolean, padding: number): void;
    setNavigatorEnabled(enabled?: boolean): void;
    setZoomModuleEnabled(enabled?: boolean): void;
    isZoomEnabled(): boolean;
    updateZoom(callerId: string, newZoom?: AxisZoomState): void;
    updateAxisZoom(callerId: string, axisId: string, newZoom?: ZoomState): void;
    resetZoom(callerId: string): void;
    resetAxisZoom(callerId: string, axisId: string): void;
    setAxisManuallyAdjusted(_callerId: string, axisId: string): void;
    updatePrimaryAxisZoom(callerId: string, direction: ChartAxisDirection, newZoom?: ZoomState): void;
    panToBBox(callerId: string, seriesRect: BBox, target: BBoxValues): boolean;
    fireZoomPanStartEvent(callerId: string): void;
    extendToEnd(callerId: string, direction: ChartAxisDirection, extent: number): void;
    extendWith(callerId: string, direction: ChartAxisDirection, fn: (end: Date | number) => Date | number): void;
    updateWith(callerId: string, direction: ChartAxisDirection, fn: (start: Date | number, end: Date | number) => [Date | number, Date | number]): void;
    getZoom(): AxisZoomState | undefined;
    getAxisZoom(axisId: string): ZoomState;
    getAxisZooms(): Record<string, {
        direction: ChartAxisDirection;
        zoom: ZoomState | undefined;
    }>;
    getRestoredZoom(): AxisZoomState | undefined;
    getPrimaryAxisId(direction: ChartAxisDirection): string | undefined;
    isVisibleItemsCountAtLeast(zoom: DefinedZoomState, minVisibleItems: number): boolean;
    private getMementoRanges;
    private autoScaleYZoom;
    private applyChanges;
    private getRangeDirection;
    private rangeToRatio;
    private getPrimaryAxis;
    private getDomainExtents;
    private getDomainPixelExtents;
    private getDefinedZoom;
    private zoomBounds;
    private primaryAxisZoom;
    private combinedAxisZoom;
}
export {};
