import type { SeriesModule, SeriesTooltipDefaults } from '../../module/coreModules';
import type { SeriesPaletteFactory } from '../../module/coreModulesTypes';
import type { ModuleContext } from '../../module/moduleContext';
import type { SeriesType } from '../mapping/types';
import type { ISeries } from '../series/seriesTypes';
declare class SeriesRegistry {
    private readonly seriesMap;
    private readonly themeTemplates;
    register(seriesType: NonNullable<SeriesType>, { chartTypes: [chartType], moduleFactory, tooltipDefaults, defaultAxes, themeTemplate, paletteFactory, solo, stackable, groupable, stackedByDefault, hidden, }: SeriesModule<any, any>): void;
    create(seriesType: SeriesType, moduleContext: ModuleContext): ISeries<any, any>;
    cloneDefaultAxes(seriesType: SeriesType, options: object): {
        axes: object[];
    } | null;
    isDerivedDefaultAxes(seriesType: SeriesType): boolean;
    setThemeTemplate(seriesType: NonNullable<SeriesType>, themeTemplate: object): void;
    getThemeTemplate(seriesType: string): object | undefined;
    getPaletteFactory(seriesType: SeriesType): SeriesPaletteFactory<unknown> | undefined;
    getTooltipDefauls(seriesType: SeriesType): SeriesTooltipDefaults | undefined;
    isSolo(seriesType: SeriesType): boolean;
    isGroupable(seriesType: SeriesType): boolean;
    isStackable(seriesType: SeriesType): boolean;
    isStackedByDefault(seriesType: SeriesType): boolean;
}
export declare const seriesRegistry: SeriesRegistry;
export {};
