import { ChartTypeOriginator } from '../api/preset/chartTypeOriginator';
import { HistoryManager } from '../api/state/historyManager';
import { StateManager } from '../api/state/stateManager';
import { DOMManager } from '../dom/domManager';
import { ProxyInteractionService } from '../dom/proxyInteractionService';
import { LocaleManager } from '../locale/localeManager';
import type { ModuleContext } from '../module/moduleContext';
import type { Group } from '../scene/group';
import { Scene } from '../scene/scene';
import { CallbackCache } from '../util/callbackCache';
import type { Mutex } from '../util/mutex';
import type { TypedEvent } from '../util/observable';
import { AnnotationManager } from './annotation/annotationManager';
import { AxisManager } from './axis/axisManager';
import type { ChartService } from './chartService';
import { DataService } from './data/dataService';
import type { ChartType } from './factory/chartTypes';
import { AnimationManager } from './interaction/animationManager';
import { ChartEventManager } from './interaction/chartEventManager';
import { ContextMenuRegistry } from './interaction/contextMenuRegistry';
import { HighlightManager } from './interaction/highlightManager';
import { InteractionManager } from './interaction/interactionManager';
import type { SyncManager } from './interaction/syncManager';
import { TooltipManager } from './interaction/tooltipManager';
import { WidgetSet } from './interaction/widgetSet';
import { ZoomManager } from './interaction/zoomManager';
import { LayoutManager } from './layout/layoutManager';
import { SeriesLabelLayoutManager } from './layout/seriesLabelLayoutManager';
import { LegendManager } from './legend/legendManager';
import { SeriesStateManager } from './series/seriesStateManager';
import type { Tooltip } from './tooltip/tooltip';
import { type UpdateCallback, UpdateService } from './updateService';
export declare class ChartContext implements ModuleContext {
    readonly callbackCache: CallbackCache;
    readonly chartEventManager: ChartEventManager;
    readonly highlightManager: HighlightManager;
    readonly layoutManager: LayoutManager;
    readonly localeManager: LocaleManager;
    readonly seriesStateManager: SeriesStateManager;
    readonly stateManager: StateManager;
    readonly seriesLabelLayoutManager: SeriesLabelLayoutManager;
    animationManager: AnimationManager;
    annotationManager: AnnotationManager;
    axisManager: AxisManager;
    legendManager: LegendManager;
    chartService: ChartService;
    chartTypeOriginator: ChartTypeOriginator;
    contextMenuRegistry: ContextMenuRegistry;
    dataService: DataService<any>;
    domManager: DOMManager;
    historyManager: HistoryManager;
    interactionManager: InteractionManager;
    proxyInteractionService: ProxyInteractionService;
    scene: Scene;
    syncManager: SyncManager;
    tooltipManager: TooltipManager;
    updateService: UpdateService;
    widgets: WidgetSet;
    zoomManager: ZoomManager;
    private readonly contextModules;
    constructor(chart: ChartService & {
        annotationRoot: Group;
        tooltip: Tooltip;
    }, vars: {
        chartType: ChartType;
        scene?: Scene;
        root: Group;
        syncManager: SyncManager;
        container?: HTMLElement;
        styleContainer?: HTMLElement;
        fireEvent: <TEvent extends TypedEvent>(event: TEvent) => void;
        updateCallback: UpdateCallback;
        updateMutex: Mutex;
    });
    destroy(): void;
}
