import type { Intersection, PlainObject } from 'ag-charts-core';
type FalsyType = false | null | undefined;
export declare function objectsEqual(a: unknown, b: unknown): boolean;
export declare function objectsEqualWith<T extends PlainObject>(a: T, b: T, cmp: (a: T, b: T) => boolean): boolean;
export declare function mergeDefaults<TSource extends PlainObject, TArgs extends (TSource | FalsyType)[]>(...sources: TArgs): Intersection<Exclude<TArgs[number], FalsyType>>;
export declare function mergeArrayDefaults<T extends PlainObject>(dataArray: T[], ...itemDefaults: T[]): T[] | Intersection<Exclude<T, FalsyType>>[];
export declare function mapValues<T extends PlainObject, R>(object: T, mapper: (value: T[keyof T], key: keyof T, object: T) => R): Record<keyof T, R>;
export declare function without(object: object | undefined, keys: string[]): {};
export declare function getPath(object: object, path: string | string[]): any;
export declare const SKIP_JS_BUILTINS: Set<string>;
export declare function setPath(object: object, path: string | string[], newValue: unknown): any;
export declare function partialAssign<T>(keysToCopy: (keyof T)[], target: T, source?: Partial<T>): T;
export declare function deepFreeze<T>(obj: T): T;
export {};
