type OffscreenCanvasRenderingContext2D = any;
export interface CanvasOptions {
    width?: number;
    height?: number;
    pixelRatio?: number;
    willReadFrequently?: boolean;
    canvasElement?: HTMLCanvasElement;
}
/**
 * Wraps the native Canvas element and overrides its CanvasRenderingContext2D to
 * provide resolution independent rendering based on `window.devicePixelRatio`.
 */
export declare class HdpiCanvas {
    readonly element: HTMLCanvasElement;
    readonly context: CanvasRenderingContext2D & {
        verifyDepthZero?: () => void;
    };
    enabled: boolean;
    width: number;
    height: number;
    pixelRatio: number;
    constructor(options: CanvasOptions);
    drawImage(context: CanvasRenderingContext2D | OffscreenCanvasRenderingContext2D, dx?: number, dy?: number): any;
    toDataURL(type?: string): string;
    resize(width: number, height: number, pixelRatio: number): void;
    clear(): void;
    destroy(): void;
    private onEnabledChange;
}
export {};
