import { ContinuousScale } from './continuousScale';
import type { ScaleFormatParams, ScaleTickParams } from './scale';
/**
 * Maps continuous domain to a continuous range.
 */
export declare class LinearScale extends ContinuousScale<number> {
    protected static getTickStep(start: number, stop: number, ticks: ScaleTickParams<number>): number;
    readonly type = "number";
    constructor();
    toDomain(d: number): number;
    ticks({ interval, tickCount, minTickCount, maxTickCount }: ScaleTickParams<number>, domain?: number[], visibleRange?: [number, number]): number[];
    niceDomain(ticks: ScaleTickParams<number>, domain?: number[]): number[];
    tickFormatter({ ticks: specifiedTicks, fractionDigits, specifier }: ScaleFormatParams<number>): (x: number) => string;
    datumFormatter({ ticks: specifiedTicks, fractionDigits, specifier }: ScaleFormatParams<number>): (x: number) => string;
}
