import type { Direction } from 'ag-charts-types';
import type { LocaleManager } from '../locale/localeManager';
import { type BaseStyleTypeMap } from '../util/attributeUtil';
import { BoundedTextWidget } from '../widget/boundedTextWidget';
import { ButtonWidget } from '../widget/buttonWidget';
import { GroupWidget } from '../widget/groupWidget';
import { ListWidget } from '../widget/listWidget';
import { NativeWidget } from '../widget/nativeWidget';
import { SliderWidget } from '../widget/sliderWidget';
import { SwitchWidget } from '../widget/switchWidget';
import { ToolbarWidget } from '../widget/toolbarWidget';
import type { DOMManager } from './domManager';
type ParentProperties<T = NativeWidget<HTMLDivElement>> = {
    readonly parent: T;
} | {
    readonly domManagerId: string;
    readonly where: 'beforebegin' | 'afterend';
};
type ElemParams<T extends ProxyElementType> = {
    readonly type: T;
    readonly id?: string;
    readonly cursor?: BaseStyleTypeMap['cursor'];
};
type InteractParams<T extends ProxyElementType> = ElemParams<T> & {
    readonly tabIndex?: number;
    readonly domIndex?: number;
};
type TranslationKey = {
    id: string;
    params?: Record<string, any>;
};
type ContainerParams<T extends ProxyContainerType> = {
    readonly type: T;
    readonly domManagerId: string;
    readonly classList: string[];
    readonly ariaLabel: TranslationKey;
};
type ProxyMeta = {
    button: {
        params: ParentProperties<GroupWidget> & InteractParams<'button'> & {
            readonly textContent: string | TranslationKey;
        };
        result: ButtonWidget;
    };
    slider: {
        params: ParentProperties<ToolbarWidget> & InteractParams<'slider'> & {
            readonly ariaLabel: TranslationKey;
        };
        result: SliderWidget;
    };
    text: {
        params: ParentProperties & ElemParams<'text'>;
        result: BoundedTextWidget;
    };
    listswitch: {
        params: ParentProperties<ListWidget> & InteractParams<'listswitch'> & {
            readonly textContent: string;
            readonly ariaChecked: boolean;
            readonly ariaDescribedBy: string;
        };
        result: SwitchWidget;
    };
    region: {
        params: ParentProperties & ElemParams<'region'>;
        result: NativeWidget<HTMLDivElement>;
    };
    toolbar: {
        params: ContainerParams<'toolbar'> & {
            readonly orientation: Direction;
        };
        result: ToolbarWidget;
    };
    group: {
        params: ContainerParams<'group'> & {
            readonly ariaOrientation: Direction;
        };
        result: GroupWidget;
    };
    list: {
        params: ContainerParams<'list'>;
        result: ListWidget;
    };
};
type ProxyElementType = 'button' | 'slider' | 'text' | 'listswitch' | 'region';
type ProxyContainerType = 'toolbar' | 'group' | 'list';
export declare class ProxyInteractionService {
    private readonly localeManager;
    private readonly domManager;
    private readonly destroyFns;
    constructor(localeManager: LocaleManager, domManager: DOMManager);
    destroy(): void;
    private addLocalisation;
    createProxyContainer<T extends ProxyContainerType>(args: {
        type: T;
    } & ProxyMeta[T]['params']): ProxyMeta[T]['result'];
    createProxyElement<T extends ProxyElementType>(args: {
        type: T;
    } & ProxyMeta[T]['params']): ProxyMeta[T]['result'];
    private initElement;
    private initInteract;
    private setParent;
}
export {};
