/**
 * Creates an HTML element with optional class names and inline styles.
 * @param tagName - The name of the HTML element to create.
 * @param className - A space-separated string of class names or a style object (optional).
 * @param style - An object representing CSS styles (optional).
 * @returns The created HTML element.
 */
export declare function createElement<K extends keyof HTMLElementTagNameMap>(tagName: K, className?: string, style?: Partial<CSSStyleDeclaration>): HTMLElementTagNameMap[K];
export declare function createElement<K extends keyof HTMLElementTagNameMap>(tagName: K, style?: Partial<CSSStyleDeclaration>): HTMLElementTagNameMap[K];
/**
 * Creates an SVG element.
 * @param elementName - The name of the SVG element to create.
 * @returns The created SVG element.
 */
export declare function createSvgElement<K extends keyof SVGElementTagNameMap>(elementName: K): SVGElementTagNameMap[K];
