import type { AgDonutSeriesStyle } from 'ag-charts-types';
import type { ModuleContext } from '../../../module/moduleContext';
import { BBox } from '../../../scene/bbox';
import { Group, TranslatableGroup } from '../../../scene/group';
import { Node } from '../../../scene/node';
import type { Point } from '../../../scene/point';
import { Selection } from '../../../scene/selection';
import { Sector } from '../../../scene/shape/sector';
import { Text } from '../../../scene/shape/text';
import { ChartAxisDirection } from '../../chartAxisDirection';
import type { DataController } from '../../data/dataController';
import type { CategoryLegendDatum, ChartLegendType } from '../../legend/legendDatum';
import { Marker } from '../../marker/marker';
import { type TooltipContent } from '../../tooltip/tooltip';
import type { DataModelSeriesNodeDatum } from '../dataModelSeries';
import { SeriesNodeEvent, type SeriesNodeEventTypes, type SeriesNodePickMatch } from '../series';
import type { DonutInnerLabel } from './donutSeriesProperties';
import { DonutSeriesProperties } from './donutSeriesProperties';
import { type PolarAnimationData, PolarSeries } from './polarSeries';
declare class DonutSeriesNodeEvent<TEvent extends string = SeriesNodeEventTypes> extends SeriesNodeEvent<DonutNodeDatum, TEvent> {
    readonly angleKey: string;
    readonly radiusKey?: string;
    readonly calloutLabelKey?: string;
    readonly sectorLabelKey?: string;
    constructor(type: TEvent, nativeEvent: Event, datum: DonutNodeDatum, series: DonutSeries);
}
interface DonutLabelDatum {
    readonly text: string;
    readonly textAlign: CanvasTextAlign;
    readonly textBaseline: CanvasTextBaseline;
    hidden: boolean;
    collisionTextAlign?: CanvasTextAlign;
    collisionOffsetY: number;
    box?: BBox;
}
interface DonutNodeDatum extends DataModelSeriesNodeDatum {
    readonly radius: number;
    readonly innerRadius: number;
    readonly outerRadius: number;
    readonly angleValue: number;
    readonly radiusValue?: number;
    readonly startAngle: number;
    readonly endAngle: number;
    readonly midAngle: number;
    readonly midCos: number;
    readonly midSin: number;
    readonly calloutLabel?: DonutLabelDatum;
    readonly sectorLabel?: {
        readonly text: string;
    };
    readonly sectorFormat: {
        [key in keyof Required<AgDonutSeriesStyle>]: AgDonutSeriesStyle[key];
    };
    readonly legendItem?: {
        key: string;
        text: string;
    };
    readonly legendItemValue?: string;
    enabled: boolean;
}
export declare class DonutSeries extends PolarSeries<DonutNodeDatum, DonutSeriesProperties, Sector> {
    static readonly className = "DonutSeries";
    static readonly type: "donut";
    properties: DonutSeriesProperties;
    private phantomNodeData;
    private get calloutNodeData();
    readonly backgroundGroup: TranslatableGroup;
    private noVisibleData;
    private readonly previousRadiusScale;
    private readonly radiusScale;
    protected phantomGroup: Group<any>;
    private readonly phantomSelection;
    private readonly calloutLabelGroup;
    private readonly calloutLabelSelection;
    readonly zerosumRingsGroup: Group<any>;
    readonly zerosumOuterRing: Marker;
    readonly zerosumInnerRing: Marker;
    readonly innerLabelsGroup: Group<any>;
    readonly innerCircleGroup: Group<any>;
    readonly innerLabelsSelection: Selection<Text, DonutInnerLabel>;
    readonly innerCircleSelection: Selection<Marker, {
        radius: number;
    }>;
    private readonly angleScale;
    private oldTitle?;
    surroundingRadius?: number;
    constructor(moduleCtx: ModuleContext);
    attachSeries(seriesContentNode: Node, seriesNode: Node, annotationNode: Node | undefined): void;
    detachSeries(seriesContentNode: Node | undefined, seriesNode: Node, annotationNode: Node | undefined): void;
    setSeriesIndex(index: number): boolean;
    protected nodeFactory(): Sector;
    getSeriesDomain(direction: ChartAxisDirection): any[];
    processData(dataController: DataController): Promise<void>;
    maybeRefreshNodeData(): void;
    private getProcessedDataValues;
    createNodeData(): {
        itemId: string;
        nodeData: never[];
        labelData: never[];
        phantomNodeData?: undefined;
    } | {
        itemId: string;
        nodeData: DonutNodeDatum[];
        labelData: DonutNodeDatum[];
        phantomNodeData: DonutNodeDatum[] | undefined;
    } | undefined;
    private getLabels;
    private getTextAlignment;
    private getSectorFormat;
    getInnerRadius(): number;
    getOuterRadius(): number;
    updateRadiusScale(resize: boolean): void;
    private getTitleTranslationY;
    update({ seriesRect }: {
        seriesRect: BBox;
    }): void;
    private updateTitleNodes;
    private updateNodeMidPoint;
    private updateSelections;
    private updateGroupSelection;
    private updateInnerCircleSelection;
    private updateNodes;
    updateCalloutLineNodes(): void;
    private getLabelOverflow;
    private bboxIntersectsSurroundingSeries;
    private computeCalloutLabelCollisionOffsets;
    private updateCalloutLabelNodes;
    computeLabelsBBox(options: {
        hideWhenNecessary: boolean;
    }, seriesRect: BBox): BBox | null;
    private updateSectorLabelNodes;
    private updateInnerLabelNodes;
    private updateZerosumRings;
    protected readonly NodeEvent: typeof DonutSeriesNodeEvent;
    protected pickNodeClosestDatum(point: Point): SeriesNodePickMatch | undefined;
    getTooltipContent(nodeDatum: DonutNodeDatum): TooltipContent | undefined;
    private legendItemSymbol;
    getLegendData(legendType: ChartLegendType): CategoryLegendDatum[];
    setLegendState(enabledItems: boolean[]): void;
    animateEmptyUpdateReady(_data?: PolarAnimationData): void;
    animateWaitingUpdateReady(): void;
    animateClearingUpdateEmpty(): void;
    getDatumId(datum: any, datumIndex: number): any;
}
export {};
