import type { ModuleContext } from '../../../module/moduleContext';
import type { BBox } from '../../../scene/bbox';
import type { Point } from '../../../scene/point';
import type { Selection } from '../../../scene/selection';
import { Rect } from '../../../scene/shape/rect';
import type { Text } from '../../../scene/shape/text';
import type { QuadtreeNearest } from '../../../scene/util/quadtree';
import { ChartAxisDirection } from '../../chartAxisDirection';
import type { DataController } from '../../data/dataController';
import type { CategoryLegendDatum, ChartLegendType } from '../../legend/legendDatum';
import { type TooltipContent } from '../../tooltip/tooltip';
import { type PickFocusInputs, type SeriesNodePickMatch } from '../series';
import { type CartesianAnimationData, CartesianSeries } from './cartesianSeries';
import { type HistogramNodeDatum, HistogramSeriesProperties } from './histogramSeriesProperties';
type HistogramAnimationData = CartesianAnimationData<Rect<HistogramNodeDatum>, HistogramNodeDatum>;
export declare class HistogramSeries extends CartesianSeries<Rect<HistogramNodeDatum>, HistogramSeriesProperties, HistogramNodeDatum> {
    static readonly className = "HistogramSeries";
    static readonly type: "histogram";
    properties: HistogramSeriesProperties;
    constructor(moduleCtx: ModuleContext);
    calculatedBins: [number, number][];
    private deriveBins;
    private calculateNiceBins;
    private getBins;
    private calculatePrecision;
    private calculateNiceStart;
    processData(dataController: DataController): Promise<void>;
    xCoordinateRange(): [number, number];
    yCoordinateRange(): [number, number];
    getSeriesDomain(direction: ChartAxisDirection): any[];
    getSeriesRange(_direction: ChartAxisDirection, [r0, r1]: [any, any]): [number, number];
    createNodeData(): {
        itemId: string;
        nodeData: HistogramNodeDatum[];
        labelData: HistogramNodeDatum[];
        scales: {
            x?: import("./scaling").Scaling | undefined;
            y?: import("./scaling").Scaling | undefined;
        };
        animationValid: boolean;
        visible: boolean;
    } | undefined;
    protected nodeFactory(): Rect<any>;
    protected updateDatumSelection(opts: {
        nodeData: HistogramNodeDatum[];
        datumSelection: Selection<Rect, HistogramNodeDatum>;
    }): Selection<Rect<any>, HistogramNodeDatum>;
    private getItemBaseStyle;
    protected updateDatumNodes(opts: {
        datumSelection: Selection<Rect, HistogramNodeDatum>;
        isHighlight: boolean;
    }): void;
    protected updateLabelSelection(opts: {
        labelData: HistogramNodeDatum[];
        labelSelection: Selection<Text, HistogramNodeDatum>;
    }): Selection<Text<any>, HistogramNodeDatum>;
    protected updateLabelNodes(opts: {
        labelSelection: Selection<Text, HistogramNodeDatum>;
    }): void;
    protected initQuadTree(quadtree: QuadtreeNearest<HistogramNodeDatum>): void;
    protected pickNodeClosestDatum(point: Point): SeriesNodePickMatch | undefined;
    getTooltipContent(nodeDatum: HistogramNodeDatum): TooltipContent | undefined;
    private legendItemSymbol;
    getLegendData(legendType: ChartLegendType): CategoryLegendDatum[];
    animateEmptyUpdateReady({ datumSelection, labelSelection }: HistogramAnimationData): void;
    animateWaitingUpdateReady(data: HistogramAnimationData): void;
    protected isLabelEnabled(): boolean;
    protected computeFocusBounds({ datumIndex }: PickFocusInputs): BBox | undefined;
}
export {};
