import { BaseManager } from '../../util/baseManager';
import type { KeyboardWidgetEvent } from '../../widget/widgetEvents';
import type { ChartAxisDirection } from '../chartAxisDirection';
import type { ChartLegendType } from '../legend/legendDatum';
type ChartEventType = 'series-focus-change' | 'series-keynav-zoom' | 'series-redo' | 'series-undo' | 'legend-item-click' | 'legend-item-double-click' | 'axis-hover';
type ChartEvents = ChartEvent<'series-focus-change'> | SeriesKeyNavZoomChartEvent | ChartEvent<'series-redo'> | ChartEvent<'series-undo'> | LegendItemClickChartEvent | LegendItemDoubleClickChartEvent | AxisHoverChartEvent;
interface ChartEvent<T> {
    readonly type: T;
}
export interface SeriesKeyNavZoomChartEvent extends ChartEvent<'series-keynav-zoom'> {
    readonly delta: -1 | 0 | 1;
    readonly widgetEvent: KeyboardWidgetEvent<'keydown'>;
}
export interface LegendItemClickChartEvent extends ChartEvent<'legend-item-click'> {
    readonly legendType: ChartLegendType;
    readonly series: any;
    readonly itemId: any;
    readonly enabled: boolean;
    readonly legendItemName?: string;
}
export interface LegendItemDoubleClickChartEvent extends ChartEvent<'legend-item-double-click'> {
    readonly legendType: ChartLegendType;
    readonly series: any;
    readonly itemId: any;
    readonly enabled: boolean;
    readonly legendItemName?: string;
    readonly numVisibleItems: number;
}
export interface AxisHoverChartEvent extends ChartEvent<'axis-hover'> {
    readonly axisId: string;
    readonly direction: ChartAxisDirection;
}
export declare class ChartEventManager extends BaseManager<ChartEventType, ChartEvents> {
    seriesEvent(type: 'series-focus-change' | 'series-redo' | 'series-undo'): void;
    seriesKeyNavZoom(delta: -1 | 0 | 1, widgetEvent: KeyboardWidgetEvent<'keydown'>): void;
    legendItemClick(legendType: ChartLegendType, series: any, itemId: any, enabled: boolean, legendItemName?: string): void;
    legendItemDoubleClick(legendType: ChartLegendType, series: any, itemId: any, enabled: boolean, numVisibleItems: number, legendItemName?: string): void;
}
export {};
