import type { AgCartesianAxisPosition } from 'ag-charts-types';
import type { BBox } from '../../scene/bbox';
import type { Point } from '../../scene/point';
import { ChartAxisDirection } from '../chartAxisDirection';
export type CrossLineLabelPosition = 'top' | 'left' | 'right' | 'bottom' | 'top-left' | 'top-right' | 'bottom-left' | 'bottom-right' | 'inside' | 'inside-left' | 'inside-right' | 'inside-top' | 'inside-bottom' | 'inside-top-left' | 'inside-bottom-left' | 'inside-top-right' | 'inside-bottom-right';
type CoordinatesFnOpts = {
    direction: ChartAxisDirection;
    xStart: number;
    xEnd: number;
    yStart: number;
    yEnd: number;
};
type CoordinatesFn = ({ direction, xStart, xEnd, yStart, yEnd }: CoordinatesFnOpts) => Point;
type PositionCalcFns = {
    c: CoordinatesFn;
};
export declare function calculateLabelTranslation({ yDirection, padding, position, bbox, }: {
    yDirection: boolean;
    padding: number;
    position: CrossLineLabelPosition;
    bbox: BBox;
}): {
    xTranslation: number;
    yTranslation: number;
};
export declare function calculateLabelChartPadding({ yDirection, bbox, padding, position, }: {
    yDirection: boolean;
    padding: number;
    position: CrossLineLabelPosition;
    bbox: BBox;
}): Partial<Record<AgCartesianAxisPosition, number>>;
export declare const POSITION_TOP_COORDINATES: CoordinatesFn;
export declare const labelDirectionHandling: Record<CrossLineLabelPosition, PositionCalcFns>;
export {};
