import type { AgChartLegendPosition, CssColor, FontFamily, FontSize, FontStyle, FontWeight } from 'ag-charts-types';
import { LinearScale } from '../../scale/linearScale';
import { BBox } from '../../scene/bbox';
import { TranslatableGroup } from '../../scene/group';
import type { Node } from '../../scene/node';
import { Selection } from '../../scene/selection';
import { Text } from '../../scene/shape/text';
import { AxisInterval } from './axisInterval';
import { AxisLabel } from './axisLabel';
interface LabelNodeDatum {
    visible: boolean;
    tickId: string;
    x: number;
    y: number;
    fill?: CssColor;
    fontFamily?: FontFamily;
    fontSize?: FontSize;
    fontStyle?: FontStyle;
    fontWeight?: FontWeight;
    text: string;
    textAlign: CanvasTextAlign;
    textBaseline: CanvasTextBaseline;
    rotation: number;
    rotationCenterX: number;
}
export declare class AxisTicks {
    static readonly DefaultTickCount = 5;
    static readonly DefaultMinSpacing = 10;
    readonly id: string;
    protected readonly axisGroup: TranslatableGroup;
    protected readonly labelSelection: Selection<Text<any>, LabelNodeDatum>;
    readonly interval: AxisInterval<unknown>;
    readonly label: AxisLabel;
    readonly scale: LinearScale;
    position: AgChartLegendPosition;
    translationX: number;
    translationY: number;
    attachAxis(axisNode: Node): void;
    calculateLayout(): BBox;
    private getLabelParams;
    private inRange;
    padding: number;
    private createLabelDatum;
    private generateTicks;
    private getTicksData;
}
export {};
