import type { AgAxisBoundSeries, AgBaseAxisLabelStyleOptions, CssColor, FontFamily, FontSize, FontStyle, FontWeight } from 'ag-charts-types';
import type { AxisContext } from '../../module/axisContext';
import type { AxisOptionModule } from '../../module/axisOptionModule';
import type { ModuleInstance } from '../../module/baseModule';
import type { ModuleContext, ModuleContextWithParent } from '../../module/moduleContext';
import { ModuleMap } from '../../module/moduleMap';
import type { Scale, ScaleFormatParams } from '../../scale/scale';
import { BBox } from '../../scene/bbox';
import { Group, TransformableGroup } from '../../scene/group';
import type { Node } from '../../scene/node';
import { Selection } from '../../scene/selection';
import { Line } from '../../scene/shape/line';
import { TransformableText } from '../../scene/shape/text';
import { Caption } from '../caption';
import type { ChartAnimationPhase } from '../chartAnimationPhase';
import type { AxisGroups, ChartAxis } from '../chartAxis';
import { ChartAxisDirection } from '../chartAxisDirection';
import type { CrossLine } from '../crossline/crossLine';
import type { AxisLayout } from '../layout/layoutManager';
import type { ISeries } from '../series/seriesTypes';
import { AxisGridLine } from './axisGridLine';
import { AxisInterval } from './axisInterval';
import { AxisLabel } from './axisLabel';
import { AxisLine } from './axisLine';
import { AxisTick, type TickInterval } from './axisTick';
import { AxisTitle } from './axisTitle';
import { type AxisLineDatum, NiceMode } from './axisUtil';
export interface LabelNodeDatum {
    tickId: string;
    fill?: CssColor;
    fontFamily?: FontFamily;
    fontSize?: FontSize;
    fontStyle?: FontStyle;
    fontWeight?: FontWeight;
    rotation: number;
    rotationCenterX: number;
    text: string;
    textAlign?: CanvasTextAlign;
    textBaseline: CanvasTextBaseline;
    visible: boolean;
    x: number;
    y: number;
    translationX?: number;
    translationY: number;
    range: number[];
}
type AxisModuleMap = ModuleMap<AxisOptionModule, ModuleInstance, ModuleContextWithParent<AxisContext>>;
declare const TranslatableLine_base: new (...args: any[]) => import("../../scene/transformable").TranslatableType<Line>;
export declare class TranslatableLine extends TranslatableLine_base {
}
export declare enum AxisGroupZIndexMap {
    TickLines = 0,
    AxisLine = 1,
    TickLabels = 2
}
export type CrosslineFormatterParams<D> = Omit<ScaleFormatParams<D>, 'specifier'> | undefined;
/**
 * A general purpose linear axis with no notion of orientation.
 * The axis is always rendered vertically, with horizontal labels positioned to the left
 * of the axis line by default. The axis can be {@link rotation | rotated} by an arbitrary angle,
 * so that it can be used as a top, right, bottom, left, radial or any other kind
 * of linear axis.
 * The generic `D` parameter is the type of the domain of the axis' scale.
 * The output range of the axis' scale is always numeric (screen coordinates).
 */
export declare abstract class Axis<S extends Scale<D, number, TickInterval<S>> = Scale<any, number, any>, D = any, TickDatum = any, TickLabelDatum = TickDatum> implements ChartAxis {
    protected readonly moduleCtx: ModuleContext;
    readonly scale: S;
    static readonly defaultTickMinSpacing = 50;
    protected static CrossLineConstructor: new () => CrossLine<any>;
    readonly id: string;
    nice: boolean;
    /** Reverse the axis scale domain. */
    reverse: boolean;
    keys: string[];
    readonly interval: AxisInterval<unknown>;
    dataDomain: {
        domain: D[];
        clipped: boolean;
    };
    get type(): string;
    abstract get direction(): ChartAxisDirection;
    layoutConstraints: ChartAxis['layoutConstraints'];
    boundSeries: ISeries<unknown, unknown>[];
    includeInvisibleDomains: boolean;
    interactionEnabled: boolean;
    readonly axisGroup: TransformableGroup;
    protected readonly tickLineGroup: Group<any>;
    protected readonly tickLabelGroup: Group<any>;
    protected readonly labelGroup: Group<any>;
    readonly gridGroup: TransformableGroup;
    protected readonly gridLineGroup: Group<any>;
    protected readonly crossLineRangeGroup: TransformableGroup;
    protected readonly crossLineLineGroup: TransformableGroup;
    protected readonly crossLineLabelGroup: TransformableGroup;
    protected tickLineGroupSelection: Selection<TranslatableLine, TickDatum>;
    protected tickLabelGroupSelection: Selection<TransformableText, TickLabelDatum>;
    protected gridLineGroupSelection: Selection<TranslatableLine, TickDatum>;
    get labelNodes(): TransformableText[];
    private _crossLines;
    set crossLines(value: CrossLine[]);
    get crossLines(): CrossLine[];
    readonly line: AxisLine;
    readonly tick: AxisTick;
    readonly gridLine: AxisGridLine;
    readonly label: AxisLabel;
    defaultTickMinSpacing: number;
    readonly translation: {
        x: number;
        y: number;
    };
    rotation: number;
    protected readonly layout: Pick<AxisLayout, 'label'>;
    protected axisContext: AxisContext | undefined;
    private labelFormatter;
    private datumFormatter;
    private scaleFormatterParams;
    protected readonly destroyFns: Array<() => void>;
    constructor(moduleCtx: ModuleContext, scale: S);
    resetAnimation(_phase: ChartAnimationPhase): void;
    private attachCrossLine;
    private detachCrossLine;
    destroy(): void;
    protected updateScale(): void;
    setCrossLinesVisible(visible: boolean): void;
    attachAxis(groups: AxisGroups): void;
    detachAxis(groups: AxisGroups): void;
    attachLabel(axisLabelNode: Node): void;
    range: [number, number];
    visibleRange: [number, number];
    /**
     * Checks if a point or an object is in range.
     * @param value A point (or object's starting point).
     * @param tolerance Expands the range on both ends by this amount.
     */
    inRange(value: number, tolerance?: number): boolean;
    protected defaultDatumFormatter(datum: unknown, fractionDigits: number): string;
    protected defaultLabelFormatter(datum: unknown, fractionDigits: number): string;
    readonly title: AxisTitle;
    /**
     * The length of the grid. The grid is only visible in case of a non-zero value.
     */
    gridLength: number;
    /**
     * The distance between the grid ticks and the axis ticks.
     */
    gridPadding: number;
    /**
     * Is used to avoid collisions between axis labels and series.
     */
    seriesAreaPadding: number;
    protected onGridLengthChange(value: number, prevValue: number): void;
    protected onGridVisibilityChange(): void;
    protected createLabel(): AxisLabel;
    /**
     * Creates/removes/updates the scene graph nodes that constitute the axis.
     */
    update(): void;
    protected getAxisLineCoordinates(): AxisLineDatum;
    protected getLabelStyles(params: {
        value: string;
        depth?: number;
    }, additionalStyles?: AgBaseAxisLabelStyleOptions): {
        fill: string | undefined;
        fontFamily: string | undefined;
        fontSize: number | undefined;
        fontStyle: FontStyle | undefined;
        fontWeight: FontWeight | undefined;
        spacing: number | undefined;
    };
    protected getTickSize(): number;
    protected setTitleProps(caption: Caption, params: {
        spacing: number;
    }): void;
    processData(): void;
    protected animatable: boolean;
    setDomains(...domains: D[][]): void;
    _scaleNiceDomainInputDomain: D[] | undefined;
    _scaleNiceDomainRangeExtent: number;
    calculateLayout(initialPrimaryTickCount?: number): {
        primaryTickCount: number | undefined;
        bbox: BBox | undefined;
    };
    abstract calculateTickLayout(domain: D[], niceMode: NiceMode, visibleRange: [number, number], primaryTickCount?: number): {
        niceDomain: D[];
        primaryTickCount: number | undefined;
        tickDomain: D[];
        ticks: D[];
        fractionDigits: number;
        bbox: BBox | undefined;
    };
    protected getTransformBox(bbox: BBox): BBox;
    protected calculateRotations(): {
        rotation: number;
        parallelFlipRotation: number;
        regularFlipRotation: number;
    };
    protected updateCrossLines(): void;
    protected updateTickLines(): void;
    protected getAxisTransform(): {
        rotation: number;
        translationX: number;
        translationY: number;
    };
    protected updatePosition(): void;
    protected abstract updateSelections(): void;
    protected updateGridLines(): void;
    protected abstract updateLabels(): void;
    formatTick(value: unknown, index: number, fractionDigits?: number, defaultFormatter?: (datum: unknown) => string): string;
    formatDatum(value: unknown): string;
    private getScaleValueFormatter;
    getBBox(): BBox;
    private initCrossLine;
    private isAnySeriesActive;
    clipTickLines(x: number, y: number, width: number, height: number): void;
    clipGrid(x: number, y: number, width: number, height: number): void;
    protected getTitleFormatterParams(): {
        direction: ChartAxisDirection;
        boundSeries: AgAxisBoundSeries[];
        defaultValue: string | undefined;
    };
    protected normaliseDataDomain(d: D[]): {
        domain: D[];
        clipped: boolean;
    };
    getLayoutState(): AxisLayout;
    private readonly moduleMap;
    getModuleMap(): AxisModuleMap;
    createModuleContext(): ModuleContextWithParent<AxisContext>;
    createAxisContext(): AxisContext;
    isReversed(): boolean;
}
export {};
