import type { TooltipRootProps, TooltipRootEmits, TooltipContentProps, TooltipContentEmits, TooltipArrowProps } from 'reka-ui';
import type { AppConfig } from '@nuxt/schema';
import theme from '#build/ui/tooltip';
import type { KbdProps } from '../types';
import type { EmitsToProps, ComponentConfig } from '../types/utils';
type Tooltip = ComponentConfig<typeof theme, AppConfig, 'tooltip'>;
export interface TooltipProps extends TooltipRootProps {
    /** The text content of the tooltip. */
    text?: string;
    /** The keyboard keys to display in the tooltip. */
    kbds?: KbdProps['value'][] | KbdProps[];
    /**
     * The content of the tooltip.
     * @defaultValue { side: 'bottom', sideOffset: 8, collisionPadding: 8 }
     */
    content?: Omit<TooltipContentProps, 'as' | 'asChild'> & Partial<EmitsToProps<TooltipContentEmits>>;
    /**
     * Display an arrow alongside the tooltip.
     * @defaultValue false
     */
    arrow?: boolean | Omit<TooltipArrowProps, 'as' | 'asChild'>;
    /**
     * Render the tooltip in a portal.
     * @defaultValue true
     */
    portal?: boolean | string | HTMLElement;
    class?: any;
    ui?: Tooltip['slots'];
}
export interface TooltipEmits extends TooltipRootEmits {
}
export interface TooltipSlots {
    default(props: {
        open: boolean;
    }): any;
    content(props?: {}): any;
}
declare const _default: __VLS_WithSlots<import("vue").DefineComponent<TooltipProps, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {
    "update:open": (value: boolean) => any;
}, string, import("vue").PublicProps, Readonly<TooltipProps> & Readonly<{
    "onUpdate:open"?: ((value: boolean) => any) | undefined;
}>, {
    portal: boolean | string | HTMLElement;
}, {}, {}, {}, string, import("vue").ComponentProvideOptions, false, {}, any>, TooltipSlots>;
export default _default;
type __VLS_WithSlots<T, S> = T & {
    new (): {
        $slots: S;
    };
};
