import type { AppConfig } from '@nuxt/schema';
import type { AvatarProps, ChipProps, LinkProps, ComponentConfig } from '@nuxt/ui';
import theme from '#build/ui-pro/user';
type User = ComponentConfig<typeof theme, AppConfig, 'user', 'uiPro'>;
export interface UserProps {
    /**
     * The element or component this component should render as.
     * @defaultValue 'div'
     */
    as?: any;
    name?: string;
    description?: string;
    avatar?: Omit<AvatarProps, 'size'> & {
        [key: string]: any;
    };
    chip?: boolean | Omit<ChipProps, 'size' | 'inset'>;
    /**
     * @defaultValue 'md'
     */
    size?: User['variants']['size'];
    /**
     * The orientation of the user.
     * @defaultValue 'horizontal'
     */
    orientation?: User['variants']['orientation'];
    to?: LinkProps['to'];
    target?: LinkProps['target'];
    onClick?: (event: MouseEvent) => void | Promise<void>;
    class?: any;
    ui?: User['slots'];
}
export interface UserSlots {
    avatar(props?: {}): any;
    name(props?: {}): any;
    description(props?: {}): any;
    default(props?: {}): any;
}
declare const _default: __VLS_WithSlots<import("vue").DefineComponent<UserProps, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<UserProps> & Readonly<{}>, {
    orientation: User["variants"]["orientation"];
}, {}, {}, {}, string, import("vue").ComponentProvideOptions, false, {}, any>, UserSlots>;
export default _default;
type __VLS_WithSlots<T, S> = T & {
    new (): {
        $slots: S;
    };
};
