import type { AppConfig } from '@nuxt/schema';
import type { LinkProps, ComponentConfig } from '@nuxt/ui';
import theme from '#build/ui-pro/page-card';
type PageCard = ComponentConfig<typeof theme, AppConfig, 'pageCard', 'uiPro'>;
export interface PageCardProps {
    /**
     * The element or component this component should render as.
     * @defaultValue 'div'
     */
    as?: any;
    /**
     * The icon displayed above the title.
     * @IconifyIcon
     */
    icon?: string;
    title?: string;
    description?: string;
    /**
     * The orientation of the page card.
     * @defaultValue 'vertical'
     */
    orientation?: PageCard['variants']['orientation'];
    /**
     * Reverse the order of the default slot.
     * @defaultValue false
     */
    reverse?: boolean;
    /**
     * Display a line around the page card.
     */
    highlight?: boolean;
    /**
     * @defaultValue 'primary'
     */
    highlightColor?: PageCard['variants']['highlightColor'];
    /**
     * Display a spotlight effect that follows your mouse cursor and highlights borders on hover.
     */
    spotlight?: boolean;
    /**
     * @defaultValue 'primary'
     */
    spotlightColor?: PageCard['variants']['spotlightColor'];
    /**
     * @defaultValue 'outline'
     */
    variant?: PageCard['variants']['variant'];
    to?: LinkProps['to'];
    target?: LinkProps['target'];
    onClick?: (event: MouseEvent) => void | Promise<void>;
    class?: any;
    ui?: PageCard['slots'];
}
export interface PageCardSlots {
    header(props?: {}): any;
    body(props?: {}): any;
    leading(props?: {}): any;
    title(props?: {}): any;
    description(props?: {}): any;
    footer(props?: {}): any;
    default(props?: {}): any;
}
declare const _default: __VLS_WithSlots<import("vue").DefineComponent<PageCardProps, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<PageCardProps> & Readonly<{}>, {
    orientation: PageCard["variants"]["orientation"];
}, {}, {}, {}, string, import("vue").ComponentProvideOptions, false, {}, any>, PageCardSlots>;
export default _default;
type __VLS_WithSlots<T, S> = T & {
    new (): {
        $slots: S;
    };
};
