import type { AppConfig } from '@nuxt/schema';
import type { ButtonProps, ComponentConfig } from '@nuxt/ui';
import type { NuxtError } from '#app';
import theme from '#build/ui-pro/error';
type Error = ComponentConfig<typeof theme, AppConfig, 'error', 'uiPro'>;
export interface ErrorProps {
    /**
     * The element or component this component should render as.
     * @defaultValue 'div'
     */
    as?: any;
    error?: Partial<NuxtError & {
        message: string;
    }>;
    /**
     * The URL to redirect to when the error is cleared.
     * @defaultValue '/'
     */
    redirect?: string;
    /**
     * Display a button to clear the error in the links slot.
     * `{ size: 'lg', color: 'primary', variant: 'solid', label: 'Back to home' }`{lang="ts-type"}
     * @defaultValue true
     */
    clear?: boolean | Partial<ButtonProps>;
    class?: any;
    ui?: Error['slots'];
}
export interface ErrorSlots {
    default(props?: {}): any;
    statusCode(props?: {}): any;
    statusMessage(props?: {}): any;
    links(props?: {}): any;
}
declare const _default: __VLS_WithSlots<import("vue").DefineComponent<ErrorProps, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<ErrorProps> & Readonly<{}>, {
    clear: boolean | Partial<ButtonProps>;
    as: any;
    redirect: string;
}, {}, {}, {}, string, import("vue").ComponentProvideOptions, false, {}, any>, ErrorSlots>;
export default _default;
type __VLS_WithSlots<T, S> = T & {
    new (): {
        $slots: S;
    };
};
