import type { AppConfig } from '@nuxt/schema';
import type { LinkProps, ComponentConfig } from '@nuxt/ui';
import theme from '#build/ui-pro/page-feature';
type PageFeature = ComponentConfig<typeof theme, AppConfig, 'pageFeature', 'uiPro'>;
export interface PageFeatureProps {
    /**
     * The element or component this component should render as.
     * @defaultValue 'div'
     */
    as?: any;
    /**
     * The icon displayed next to the title when `orientation` is `horizontal` and above the title when `orientation` is `vertical`.
     * @IconifyIcon
     */
    icon?: string;
    title?: string;
    description?: string;
    /**
     * The orientation of the page feature.
     * @defaultValue 'horizontal'
     */
    orientation?: PageFeature['variants']['orientation'];
    to?: LinkProps['to'];
    target?: LinkProps['target'];
    onClick?: (event: MouseEvent) => void | Promise<void>;
    class?: any;
    ui?: PageFeature['slots'];
}
export interface PageFeatureSlots {
    leading(props?: {}): any;
    title(props?: {}): any;
    description(props?: {}): any;
    default(props?: {}): any;
}
declare const _default: __VLS_WithSlots<import("vue").DefineComponent<PageFeatureProps, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<PageFeatureProps> & Readonly<{}>, {
    orientation: PageFeature["variants"]["orientation"];
}, {}, {}, {}, string, import("vue").ComponentProvideOptions, false, {}, any>, PageFeatureSlots>;
export default _default;
type __VLS_WithSlots<T, S> = T & {
    new (): {
        $slots: S;
    };
};
