import type { ExtractPropTypes, ImgHTMLAttributes } from 'vue';
export declare const baseImageProps: {
    src: {
        type: StringConstructor;
        required: boolean;
    };
    format: {
        type: StringConstructor;
        required: boolean;
    };
    quality: {
        type: (NumberConstructor | StringConstructor)[];
        required: boolean;
    };
    background: {
        type: StringConstructor;
        required: boolean;
    };
    fit: {
        type: StringConstructor;
        required: boolean;
    };
    modifiers: {
        type: () => Record<string, any>;
        required: boolean;
    };
    preset: {
        type: StringConstructor;
        required: boolean;
    };
    provider: {
        type: StringConstructor;
        required: boolean;
    };
    sizes: {
        type: () => string | Record<string, any>;
        required: boolean;
    };
    densities: {
        type: StringConstructor;
        required: boolean;
    };
    preload: {
        type: () => boolean | {
            fetchPriority: "auto" | "high" | "low";
        };
        required: boolean;
    };
    width: {
        type: (NumberConstructor | StringConstructor)[];
        required: boolean;
    };
    height: {
        type: (NumberConstructor | StringConstructor)[];
        required: boolean;
    };
    alt: {
        type: StringConstructor;
        required: boolean;
    };
    referrerpolicy: {
        type: () => ImgHTMLAttributes["referrerpolicy"];
        required: boolean;
    };
    usemap: {
        type: StringConstructor;
        required: boolean;
    };
    longdesc: {
        type: StringConstructor;
        required: boolean;
    };
    ismap: {
        type: BooleanConstructor;
        required: boolean;
    };
    loading: {
        type: () => "lazy" | "eager";
        required: boolean;
        validator: (val: any) => boolean;
    };
    crossorigin: {
        type: () => "anonymous" | "use-credentials" | boolean;
        required: boolean;
        validator: (val: any) => boolean;
    };
    decoding: {
        type: () => "async" | "auto" | "sync";
        required: boolean;
        validator: (val: any) => boolean;
    };
    nonce: {
        type: StringConstructor[];
        required: boolean;
    };
};
export interface BaseImageAttrs {
    width?: number;
    height?: number;
    alt?: string;
    referrerpolicy?: ImgHTMLAttributes['referrerpolicy'];
    usemap?: string;
    longdesc?: string;
    ismap?: boolean;
    crossorigin?: '' | 'anonymous' | 'use-credentials';
    loading?: 'lazy' | 'eager';
    decoding?: 'async' | 'auto' | 'sync';
    nonce?: string;
}
export interface BaseImageModifiers {
    width?: number;
    height?: number;
    format?: string;
    quality?: string | number;
    background?: string;
    fit?: string;
    [key: string]: any;
}
export declare const useBaseImage: (props: ExtractPropTypes<typeof baseImageProps>) => {
    options: import("vue").ComputedRef<{
        provider: string | undefined;
        preset: string | undefined;
    }>;
    attrs: import("vue").ComputedRef<BaseImageAttrs>;
    modifiers: import("vue").ComputedRef<BaseImageModifiers>;
};
export declare const pictureProps: {
    legacyFormat: {
        type: StringConstructor;
        default: null;
    };
    imgAttrs: {
        type: ObjectConstructor;
        default: null;
    };
    src: {
        type: StringConstructor;
        required: boolean;
    };
    format: {
        type: StringConstructor;
        required: boolean;
    };
    quality: {
        type: (NumberConstructor | StringConstructor)[];
        required: boolean;
    };
    background: {
        type: StringConstructor;
        required: boolean;
    };
    fit: {
        type: StringConstructor;
        required: boolean;
    };
    modifiers: {
        type: () => Record<string, any>;
        required: boolean;
    };
    preset: {
        type: StringConstructor;
        required: boolean;
    };
    provider: {
        type: StringConstructor;
        required: boolean;
    };
    sizes: {
        type: () => string | Record<string, any>;
        required: boolean;
    };
    densities: {
        type: StringConstructor;
        required: boolean;
    };
    preload: {
        type: () => boolean | {
            fetchPriority: "auto" | "high" | "low";
        };
        required: boolean;
    };
    width: {
        type: (NumberConstructor | StringConstructor)[];
        required: boolean;
    };
    height: {
        type: (NumberConstructor | StringConstructor)[];
        required: boolean;
    };
    alt: {
        type: StringConstructor;
        required: boolean;
    };
    referrerpolicy: {
        type: () => ImgHTMLAttributes["referrerpolicy"];
        required: boolean;
    };
    usemap: {
        type: StringConstructor;
        required: boolean;
    };
    longdesc: {
        type: StringConstructor;
        required: boolean;
    };
    ismap: {
        type: BooleanConstructor;
        required: boolean;
    };
    loading: {
        type: () => "lazy" | "eager";
        required: boolean;
        validator: (val: any) => boolean;
    };
    crossorigin: {
        type: () => "anonymous" | "use-credentials" | boolean;
        required: boolean;
        validator: (val: any) => boolean;
    };
    decoding: {
        type: () => "async" | "auto" | "sync";
        required: boolean;
        validator: (val: any) => boolean;
    };
    nonce: {
        type: StringConstructor[];
        required: boolean;
    };
};
export declare const imgProps: {
    placeholder: {
        type: (ArrayConstructor | BooleanConstructor | NumberConstructor | StringConstructor)[];
        required: boolean;
    };
    placeholderClass: {
        type: StringConstructor;
        required: boolean;
    };
    custom: {
        type: BooleanConstructor;
        required: boolean;
    };
    src: {
        type: StringConstructor;
        required: boolean;
    };
    format: {
        type: StringConstructor;
        required: boolean;
    };
    quality: {
        type: (NumberConstructor | StringConstructor)[];
        required: boolean;
    };
    background: {
        type: StringConstructor;
        required: boolean;
    };
    fit: {
        type: StringConstructor;
        required: boolean;
    };
    modifiers: {
        type: () => Record<string, any>;
        required: boolean;
    };
    preset: {
        type: StringConstructor;
        required: boolean;
    };
    provider: {
        type: StringConstructor;
        required: boolean;
    };
    sizes: {
        type: () => string | Record<string, any>;
        required: boolean;
    };
    densities: {
        type: StringConstructor;
        required: boolean;
    };
    preload: {
        type: () => boolean | {
            fetchPriority: "auto" | "high" | "low";
        };
        required: boolean;
    };
    width: {
        type: (NumberConstructor | StringConstructor)[];
        required: boolean;
    };
    height: {
        type: (NumberConstructor | StringConstructor)[];
        required: boolean;
    };
    alt: {
        type: StringConstructor;
        required: boolean;
    };
    referrerpolicy: {
        type: () => ImgHTMLAttributes["referrerpolicy"];
        required: boolean;
    };
    usemap: {
        type: StringConstructor;
        required: boolean;
    };
    longdesc: {
        type: StringConstructor;
        required: boolean;
    };
    ismap: {
        type: BooleanConstructor;
        required: boolean;
    };
    loading: {
        type: () => "lazy" | "eager";
        required: boolean;
        validator: (val: any) => boolean;
    };
    crossorigin: {
        type: () => "anonymous" | "use-credentials" | boolean;
        required: boolean;
        validator: (val: any) => boolean;
    };
    decoding: {
        type: () => "async" | "auto" | "sync";
        required: boolean;
        validator: (val: any) => boolean;
    };
    nonce: {
        type: StringConstructor[];
        required: boolean;
    };
};
