import { getModuleName } from '../../utils/module.js';
const LOCAL_IMPORT_REGEXP = /^(\.|\/)/;
// we tree shake direct local requires to bundle only relevant code
// we don't tree shake external dependencies since they can break our tree shaking logic by:
// 1. doing dynamic requires (e.g. require(dynamicPath))
// 2. reading files (e.g. fs.readFileSync(someNonJsFile))
// an exception is when the function was generated by `next-on-netlify` to avoid bundling the entire `Next.js` framework
export const shouldTreeShake = function (dependency, treeShakeNext) {
    if (LOCAL_IMPORT_REGEXP.test(dependency)) {
        return true;
    }
    return treeShakeNext && getModuleName(dependency) === 'next';
};
