import type { IIndicatorEditableSetting } from "./Indicator";
import type { Color } from "../../../core/util/Color";
import { Indicator, IIndicatorSettings, IIndicatorPrivate, IIndicatorEvents } from "./Indicator";
import { LineSeries } from "../../xy/series/LineSeries";
export interface IAccelerationBandsSettings extends IIndicatorSettings {
    /**
     * A color for upper section.
     */
    upperColor?: Color;
    /**
     * A color for lower section.
     */
    lowerColor?: Color;
    factor?: number;
}
export interface IAccelerationBandsPrivate extends IIndicatorPrivate {
}
export interface IAccelerationBandsEvents extends IIndicatorEvents {
}
/**
 * An implementation of a [[StockChart]] indicator.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/stock/indicators/} for more info
 */
export declare class AccelerationBands extends Indicator {
    static className: string;
    static classNames: Array<string>;
    _settings: IAccelerationBandsSettings;
    _privateSettings: IAccelerationBandsPrivate;
    _events: IAccelerationBandsEvents;
    /**
     * Indicator series for the upper band.
     */
    upperBandSeries: LineSeries;
    /**
     * Indicator series for the lower band.
     */
    lowerBandSeries: LineSeries;
    _editableSettings: IIndicatorEditableSetting[];
    protected _afterNew(): void;
    _prepareChildren(): void;
    _updateChildren(): void;
    /**
     * @ignore
     */
    prepareData(): void;
    protected _dispose(): void;
    hide(duration?: number): Promise<any>;
    show(duration?: number): Promise<any>;
}
//# sourceMappingURL=AccelerationBands.d.ts.map