import { PolylineSeries } from "./PolylineSeries";
import { EditableLabel } from "../../../core/render/EditableLabel";
import { Template } from "../../../core/util/Template";
import * as $array from "../../../core/util/Array";
import * as $object from "../../../core/util/Object";
export class LabelSeries extends PolylineSeries {
    constructor() {
        super(...arguments);
        Object.defineProperty(this, "spriteResizer", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "_tag", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: "label"
        });
        Object.defineProperty(this, "_isEditing", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        Object.defineProperty(this, "_isSelected", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
    }
    _afterNew() {
        super._afterNew();
        this.spriteResizer = this._getStockChart().spriteResizer;
        this.strokes.template.set("visible", false);
        this.fills.template.set("visible", false);
        this.addTag(this._tag);
    }
    _dispatchAdded() {
    }
    _setContextSprite(_context) { }
    _tweakBullet(container, dataItem) {
        const dataContext = dataItem.dataContext;
        const text = dataContext.text;
        const template = dataContext.settings;
        if (template) {
            const label = container.children.push(EditableLabel.new(this._root, {
                themeTags: ["label"],
                text: text,
                editOn: "none"
            }, template));
            label.on("text", (text) => {
                dataContext.text = text;
            });
            this.setPrivate("label", label);
            label.on("active", () => {
                this.setTimeout(() => {
                    this._isEditing = label.get("active", false);
                }, 200);
                if (!label.get("active")) {
                    this.setTimeout(() => {
                        if (label) {
                            if (label.get("text") == "") {
                                this._disposeIndex(dataContext.index);
                            }
                        }
                    }, 100);
                    // Trigger a drawing updated event so that updated text is saved if
                    // necessary
                    const stockChart = this._getStockChart();
                    const type = "drawingsupdated";
                    if (stockChart.events.isEnabled(type)) {
                        stockChart.events.dispatch(type, { type: type, target: stockChart });
                    }
                }
            });
            container.events.on("click", (e) => {
                const spriteResizer = this.spriteResizer;
                if (spriteResizer.get("sprite") == label) {
                    this._isEditing = true;
                    label.set("active", true);
                    this._selectDrawing(dataContext.index, e.originalEvent.ctrlKey, true);
                    spriteResizer.set("sprite", undefined);
                }
                else {
                    this._isEditing = false;
                    this._isSelected = true;
                    spriteResizer.set("sprite", label);
                }
            });
            container.events.on("pointerover", () => {
                this._isHover = true;
            });
            container.events.on("pointerout", () => {
                this._isHover = false;
            });
            label.on("scale", (scale) => {
                template.set("scale", scale);
            });
            label.on("rotation", (rotation) => {
                template.set("rotation", rotation);
            });
            label.events.on("boundschanged", () => {
                this.markDirty();
            });
            dataContext.sprite = container;
            dataContext.label = label;
            this._tweakBullet2(label, dataItem);
        }
    }
    _tweakBullet2(_label, _dataItem) {
    }
    _handlePointerClick(event) {
        if (this._isEditing) {
            return;
        }
        if (this._selected.length > 0 || this._isSelected) {
            this._isSelected = false;
            this._hideResizer();
            this.unselectAllDrawings();
        }
        else if (this._drawingEnabled) {
            if (!this._isHover) {
                this.isDrawing(true);
                this._increaseIndex();
                this._di[this._index] = {};
                this._addPoint(event);
                const dataContext = this.data.getIndex(this.data.length - 1);
                dataContext.text = "";
                dataContext.index = this._index;
                dataContext.corner = 0;
                dataContext.settings = this._getLabelTemplate();
                this._afterTextSave(dataContext);
                this._root.events.once("frameended", () => {
                    dataContext.label.set("active", true);
                    this._isEditing = true;
                });
                this.spriteResizer.set("sprite", undefined);
                this._dispatchStockEvent("drawingadded", this._drawingId, this._index);
            }
        }
        this.isDrawing(false);
    }
    _afterTextSave(_dataContext) {
    }
    _getLabelTemplate() {
        const template = {};
        const labelFontSize = this.get("labelFontSize");
        if (labelFontSize != null) {
            template.fontSize = labelFontSize;
        }
        const labelFontFamily = this.get("labelFontFamily");
        if (labelFontFamily != null) {
            template.fontFamily = labelFontFamily;
        }
        const labelFontWeight = this.get("labelFontWeight");
        if (labelFontWeight != null) {
            template.fontWeight = labelFontWeight;
        }
        const labelFontStyle = this.get("labelFontStyle");
        if (labelFontStyle != null) {
            template.fontStyle = labelFontStyle;
        }
        const labelFill = this.get("labelFill");
        if (labelFill != null) {
            template.fill = labelFill;
        }
        return Template.new(template);
    }
    disposeDataItem(dataItem) {
        super.disposeDataItem(dataItem);
        this.spriteResizer.set("sprite", undefined);
        this._isHover = false;
    }
    _hideAllBullets() {
    }
    _updateSelector(selector, index) {
        var _a;
        const context = this._getContext(index);
        if (context) {
            const sprite = context.sprite;
            if (sprite) {
                if (sprite.dataItem == ((_a = this.spriteResizer.get("sprite")) === null || _a === void 0 ? void 0 : _a.dataItem)) {
                    selector.hide(0);
                }
                else {
                    if (this._selected.indexOf(index) != -1) {
                        selector.show(0);
                    }
                }
                const selectorPadding = this.get("selectorPadding", 5);
                let bounds = sprite.bounds();
                let w = (bounds.right - bounds.left) + selectorPadding * 2;
                let h = (bounds.bottom - bounds.top) + selectorPadding * 2;
                selector.setAll({
                    width: w,
                    height: h,
                    x: bounds.left - selectorPadding,
                    y: bounds.top - selectorPadding
                });
            }
        }
    }
    _prepareChildren() {
        super._prepareChildren();
        if (this.isDirty("labelFontSize") || this.isDirty("labelFontFamily") || this.isDirty("labelFontWeight") || this.isDirty("labelFontStyle") || this.isDirty("labelFill")) {
            $array.each(this._selected, (i) => {
                this._applySettings(i);
            });
        }
    }
    _applySettings(index, settings) {
        super._applySettings(index, settings);
        let context = this._getContext(index);
        if (context) {
            let label = context.label;
            if (label) {
                let template = context.settings;
                const labelSettings = {
                    fontSize: this.get("labelFontSize"),
                    fontFamily: this.get("labelFontFamily"),
                    fontWeight: this.get("labelFontWeight"),
                    fontStyle: this.get("labelFontStyle"),
                    fill: this.get("labelFill"),
                    fillColor: this.get("fillColor")
                };
                const defaultState = label.states.lookup("default");
                if (labelSettings) {
                    $object.each(labelSettings, (key, value) => {
                        label.set(key, value);
                        defaultState.set(key, value);
                        if (template) {
                            template.set(key, value);
                        }
                    });
                }
            }
        }
    }
    _handleBulletDragStart(event) {
        // don't call super		
        const stockChart = this._getStockChart();
        if (stockChart) {
            stockChart._dragStartDrawing(event);
        }
    }
    _handleBulletDragStop(event) {
        const stockChart = this._getStockChart();
        if (stockChart) {
            stockChart._dragStopDrawing(event);
        }
        this._root.events.once("frameended", () => {
            this._positionBullets(event.target.dataItem);
        });
    }
    toggleDrawing(enabled) {
        this.grips.each((grip) => {
            grip.set("forceInactive", !enabled);
        });
    }
}
Object.defineProperty(LabelSeries, "className", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: "LabelSeries"
});
Object.defineProperty(LabelSeries, "classNames", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: PolylineSeries.classNames.concat([LabelSeries.className])
});
//# sourceMappingURL=LabelSeries.js.map