import { PolylineSeries } from "./PolylineSeries";
import { Bullet } from "../../../core/render/Bullet";
import { Graphics } from "../../../core/render/Graphics";
import { Template } from "../../../core/util/Template";
import * as $array from "../../../core/util/Array";
import * as $object from "../../../core/util/Object";
export class IconSeries extends PolylineSeries {
    constructor() {
        super(...arguments);
        Object.defineProperty(this, "spriteResizer", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "_tag", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: "icon"
        });
    }
    _afterNew() {
        super._afterNew();
        this.spriteResizer = this._getStockChart().spriteResizer;
        this.bullets.clear();
        this.strokes.template.set("visible", false);
        this.fills.template.set("visible", false);
        this.bullets.push((root, _series, dataItem) => {
            const dataContext = dataItem.dataContext;
            const template = dataContext.settings;
            if (template) {
                const sprite = Graphics.new(root, {
                    draggable: true,
                    themeTags: ["icon"]
                }, template);
                dataContext.sprite = sprite;
                this._addBulletInteraction(sprite);
                sprite.events.on("click", (_e) => {
                    const spriteResizer = this.spriteResizer;
                    if (spriteResizer.get("sprite") == sprite) {
                        spriteResizer.set("sprite", undefined);
                    }
                    else {
                        spriteResizer.set("sprite", sprite);
                    }
                });
                sprite.events.on("pointerover", () => {
                    this._isHover = true;
                });
                sprite.events.on("pointerout", () => {
                    this._isHover = false;
                });
                this.spriteResizer.set("sprite", undefined);
                sprite.on("scale", (scale) => {
                    template.set("scale", scale);
                });
                sprite.on("rotation", (rotation) => {
                    template.set("rotation", rotation);
                });
                return Bullet.new(this._root, {
                    locationX: undefined,
                    sprite: sprite
                });
            }
        });
    }
    _setContextSprite(_context) { }
    _handlePointerClick(event) {
        if (this._selected.length > 0) {
            this._hideResizer();
            this.unselectAllDrawings();
        }
        else if (this._drawingEnabled) {
            if (!this._isHover) {
                super._handlePointerClick(event);
                const dataObject = this.data.getIndex(this.data.length - 1);
                dataObject.settings = this._getIconTemplate();
                this._increaseIndex();
                this._di[this._index] = {};
                this._dispatchStockEvent("drawingadded", this._drawingId, this._index);
            }
        }
        this.isDrawing(false);
    }
    disposeDataItem(dataItem) {
        super.disposeDataItem(dataItem);
        this.spriteResizer.set("sprite", undefined);
        this._isHover = false;
    }
    _applySettings(index, settings) {
        super._applySettings(index, settings);
        let template;
        let sprite;
        let context = this._getContext(index);
        if (context) {
            sprite = context.sprite;
            template = context.settings;
            if (sprite) {
                const svgPath = this.get("iconSvgPath");
                const centerX = this.get("iconCenterX");
                const centerY = this.get("iconCenterY");
                sprite.set("svgPath", svgPath);
                sprite.set("centerX", centerX);
                sprite.set("centerY", centerY);
                const defaultState = sprite.states.lookup("default");
                defaultState.set("svgPath", svgPath);
                defaultState.set("centerX", centerX);
                defaultState.set("centerY", centerY);
                if (template) {
                    template.set("svgPath", svgPath);
                    template.set("centerX", centerX);
                    template.set("centerY", centerY);
                }
                if (settings) {
                    $object.each(settings, (key, value) => {
                        sprite.set(key, value);
                        defaultState.set(key, value);
                        if (template) {
                            template.set(key, value);
                        }
                    });
                }
            }
        }
    }
    _dispatchAdded() {
    }
    _getIconTemplate() {
        const template = {};
        const iconSvgPath = this.get("iconSvgPath");
        if (iconSvgPath != null) {
            template.svgPath = iconSvgPath;
        }
        const iconScale = this.get("iconScale");
        if (iconScale != null) {
            template.scale = iconScale;
        }
        const iconCenterX = this.get("iconCenterX");
        if (iconCenterX != null) {
            template.centerX = iconCenterX;
        }
        const iconCenterY = this.get("iconCenterY");
        if (iconCenterY != null) {
            template.centerY = iconCenterY;
        }
        const strokeColor = this.get("strokeColor");
        if (strokeColor != null) {
            template.stroke = strokeColor;
        }
        const strokeOpacity = this.get("strokeOpacity");
        if (strokeOpacity != null) {
            template.strokeOpacity = strokeOpacity;
        }
        const fillColor = this.get("fillColor");
        if (fillColor != null) {
            template.fill = fillColor;
        }
        const fillOpacity = this.get("fillOpacity");
        if (fillOpacity != null) {
            template.fillOpacity = fillOpacity;
        }
        return Template.new(template);
    }
    setInteractive(value) {
        super.setInteractive(value);
        $array.each(this.dataItems, (dataItem) => {
            const bullets = dataItem.bullets;
            if (bullets) {
                $array.each(bullets, (bullet) => {
                    const sprite = bullet.get("sprite");
                    if (sprite) {
                        sprite.set("forceInactive", !value);
                    }
                });
            }
        });
    }
    _prepareChildren() {
        super._prepareChildren();
        if (this.isDirty("iconSvgPath")) {
            $array.each(this._selected, (i) => {
                this._applySettings(i);
            });
        }
    }
    _updateSelector(selector, index) {
        var _a;
        const context = this._getContext(index);
        if (context) {
            const sprite = context.sprite;
            if (sprite) {
                if (sprite.dataItem == ((_a = this.spriteResizer.get("sprite")) === null || _a === void 0 ? void 0 : _a.dataItem)) {
                    selector.hide(0);
                }
                else {
                    if (this._selected.indexOf(index) != -1) {
                        selector.show(0);
                    }
                }
                const selectorPadding = this.get("selectorPadding", 5);
                let bounds = sprite.bounds();
                let w = (bounds.right - bounds.left) + selectorPadding * 2;
                let h = (bounds.bottom - bounds.top) + selectorPadding * 2;
                selector.setAll({
                    width: w,
                    height: h,
                    x: bounds.left - selectorPadding,
                    y: bounds.top - selectorPadding
                });
            }
        }
    }
    toggleDrawing(enabled) {
        $array.each(this.dataItems, (dataItem) => {
            const bullets = dataItem.bullets;
            if (bullets) {
                $array.each(bullets, (bullet) => {
                    const sprite = bullet.get("sprite");
                    if (sprite) {
                        sprite.set("forceInactive", !enabled);
                    }
                });
            }
        });
    }
    _handleBulletDragStart(event) {
        // don't call super
        this._hideResizer(event.target);
        const stockChart = this._getStockChart();
        if (stockChart) {
            stockChart._dragStartDrawing(event);
        }
    }
    _handleBulletDragStop(event) {
        const stockChart = this._getStockChart();
        if (stockChart) {
            stockChart._dragStopDrawing(event);
        }
        this._root.events.once("frameended", () => {
            this._positionBullets(event.target.dataItem);
        });
    }
}
Object.defineProperty(IconSeries, "className", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: "IconSeries"
});
Object.defineProperty(IconSeries, "classNames", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: PolylineSeries.classNames.concat([IconSeries.className])
});
//# sourceMappingURL=IconSeries.js.map