import type { Percent } from "../../../core/util/Percent";
import type { ISpritePointerEvent } from "../../../core/render/Sprite";
import type { DataItem } from "../../../core/render/Component";
import type { SpriteResizer } from "../../../core/render/SpriteResizer";
import { PolylineSeries, IPolylineSeriesSettings, IPolylineSeriesPrivate, IPolylineSeriesDataItem } from "./PolylineSeries";
import { Graphics } from "../../../core/render/Graphics";
import { Template } from "../../../core/util/Template";
export interface IIconSeriesDataItem extends IPolylineSeriesDataItem {
    /**
     * An SVG path of the icon.
     */
    svgPath: string;
}
export interface IIconSeriesSettings extends IPolylineSeriesSettings {
    /**
     * An SVG path of the icon.
     */
    iconSvgPath: string;
    /**
     * Scale (0-X).
     */
    iconScale?: number;
    /**
     * Relative horizontal center.
     */
    iconCenterX?: Percent;
    /**
     * Relative vertical center.
     */
    iconCenterY?: Percent;
    /**
     * Should icon snap to closest data item?
     */
    snapToData?: boolean;
}
export interface IIconSeriesPrivate extends IPolylineSeriesPrivate {
}
export declare class IconSeries extends PolylineSeries {
    static className: string;
    static classNames: Array<string>;
    _settings: IIconSeriesSettings;
    _privateSettings: IIconSeriesPrivate;
    _dataItemSettings: IIconSeriesDataItem;
    spriteResizer: SpriteResizer;
    protected _tag: string;
    protected _afterNew(): void;
    protected _setContextSprite(_context: any): void;
    protected _handlePointerClick(event: ISpritePointerEvent): void;
    disposeDataItem(dataItem: DataItem<this["_dataItemSettings"]>): void;
    protected _applySettings(index: number, settings?: {
        [index: string]: any;
    }): void;
    protected _dispatchAdded(): void;
    protected _getIconTemplate(): Template<any>;
    setInteractive(value: boolean): void;
    _prepareChildren(): void;
    protected _updateSelector(selector: Graphics, index: number): void;
    toggleDrawing(enabled: boolean): void;
    protected _handleBulletDragStart(event: ISpritePointerEvent): void;
    protected _handleBulletDragStop(event: ISpritePointerEvent): void;
}
//# sourceMappingURL=IconSeries.d.ts.map