import * as $array from "../../../core/util/Array";
import { SimpleLineSeries } from "./SimpleLineSeries";
export class HorizontalLineSeries extends SimpleLineSeries {
    constructor() {
        super(...arguments);
        Object.defineProperty(this, "_tag", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: "horizontal"
        });
    }
    _afterNew() {
        super._afterNew();
        this.lines.template.set("forceHidden", true);
    }
    _handleBulletDragged(event) {
        super._handleBulletDragged(event);
        const dataItem = event.target.dataItem;
        const dataContext = dataItem.dataContext;
        if (dataContext) {
            const index = dataContext.index;
            const diP1 = this._di[index]["p1"];
            const diP2 = this._di[index]["p2"];
            const diP3 = this._di[index]["p3"];
            const movePoint = this._movePointerPoint;
            if (diP1 && diP2 && diP3 && movePoint) {
                const yAxis = this.get("yAxis");
                const xAxis = this.get("xAxis");
                const valueX = this._getXValue(xAxis.positionToValue(xAxis.coordinateToPosition(movePoint.x)));
                const valueY = this._getYValue(yAxis.positionToValue(yAxis.coordinateToPosition(movePoint.y)), valueX);
                const min = xAxis.getPrivate("min", 0);
                const max = xAxis.getPrivate("max", 1);
                this._setContext(diP1, "valueY", valueY, true);
                this._setContext(diP2, "valueY", valueY, true);
                this._setContext(diP3, "valueY", valueY, true);
                this._setContext(diP1, "valueX", min - (max - min));
                this._setContext(diP2, "valueX", valueX);
                this._setContext(diP3, "valueX", max + (max - min));
                this._setXLocation(diP2, diP2.get("valueX", 0));
                this._positionBullets(diP2);
            }
        }
    }
    _handlePointerMoveReal() {
    }
    _prepareChildren() {
        super._prepareChildren();
        const xAxis = this.get("xAxis");
        const min = xAxis.getPrivate("min", 0);
        const max = xAxis.getPrivate("max", 1);
        $array.each(this._di, (di) => {
            if (di) {
                this._setContext(di["p1"], "valueX", min - (max - min), true);
                this._setContext(di["p3"], "valueX", max + (max - min), true);
            }
        });
    }
    _updateSegment(index) {
        if (this._di[index]) {
            const diP1 = this._di[index]["p1"];
            const diP3 = this._di[index]["p3"];
            if (diP1 && diP3) {
                const xAxis = this.get("xAxis");
                const min = xAxis.getPrivate("min", 0);
                const max = xAxis.getPrivate("max", 1);
                this._setContext(diP1, "valueX", min - (max - min), true);
                this._setContext(diP3, "valueX", max + (max - min), true);
            }
        }
    }
    _handlePointerClickReal(event) {
        if (this._drawingEnabled) {
            if (!this._isDragging) {
                if (this.unselectAllDrawings() == 0) {
                    this._increaseIndex();
                    this._addPoints(event, this._index);
                    this.isDrawing(false);
                    this._updateSegment(this._index);
                    this._dispatchStockEvent("drawingadded", this._drawingId, this._index);
                }
            }
        }
    }
    _addPointsReal(valueX, valueY, index) {
        super._addPointsReal(valueX, valueY, index);
        this._addPoint(valueX, valueY, "p3", index);
    }
}
Object.defineProperty(HorizontalLineSeries, "className", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: "HorizontalLineSeries"
});
Object.defineProperty(HorizontalLineSeries, "classNames", {
    enumerable: true,
    configurable: true,
    writable: true,
    value: SimpleLineSeries.classNames.concat([HorizontalLineSeries.className])
});
//# sourceMappingURL=HorizontalLineSeries.js.map