import type { IIndicatorEditableSetting } from "./Indicator";
import { ChartIndicator, IChartIndicatorSettings, IChartIndicatorPrivate, IChartIndicatorEvents } from "./ChartIndicator";
import { LineSeries } from "../../xy/series/LineSeries";
import type { XYSeries } from "../../xy/series/XYSeries";
export interface IChaikinMoneyFlowSettings extends IChartIndicatorSettings {
    /**
     * A volume series indicator will be based on, if it reaquires one.
     */
    volumeSeries: XYSeries;
}
export interface IChaikinMoneyFlowPrivate extends IChartIndicatorPrivate {
}
export interface IChaikinMoneyFlowEvents extends IChartIndicatorEvents {
}
/**
 * An implementation of a [[StockChart]] indicator.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/stock/indicators/} for more info
 */
export declare class ChaikinMoneyFlow extends ChartIndicator {
    static className: string;
    static classNames: Array<string>;
    _settings: IChaikinMoneyFlowSettings;
    _privateSettings: IChaikinMoneyFlowPrivate;
    _events: IChaikinMoneyFlowEvents;
    /**
     * Indicator series.
     */
    series: LineSeries;
    _editableSettings: IIndicatorEditableSetting[];
    _afterNew(): void;
    _createSeries(): LineSeries;
    /**
     * @ignore
     */
    prepareData(): void;
}
//# sourceMappingURL=ChaikinMoneyFlow.d.ts.map