import { Component } from "./component";
import { DragAndDropService, DraggingEvent, DragItem, DragSourceType, DropTarget } from "../dragAndDrop/dragAndDropService";
import { PillDragComp } from "./pillDragComp";
export interface PillDropZonePanelParams {
    emptyMessage?: string;
    title?: string;
    icon?: Element;
}
export declare abstract class PillDropZonePanel<TPill extends PillDragComp<TItem>, TItem> extends Component {
    private horizontal;
    private readonly focusService;
    protected readonly dragAndDropService: DragAndDropService;
    private static STATE_NOT_DRAGGING;
    private static STATE_NEW_ITEMS_IN;
    private static STATE_REARRANGE_ITEMS;
    private state;
    private dropTarget;
    private potentialDndItems;
    private guiDestroyFunctions;
    private params;
    private childPillComponents;
    private insertIndex;
    private ePillDropList;
    private positionableFeature;
    private resizeEnabled;
    protected abstract isItemDroppable(item: TItem, draggingEvent: DraggingEvent): boolean;
    protected abstract updateItems(items: TItem[]): void;
    protected abstract getExistingItems(): TItem[];
    protected abstract getIconName(): string;
    protected abstract getAriaLabel(): string;
    protected abstract createPillComponent(item: TItem, dropTarget: DropTarget, ghost: boolean, horizontal: boolean): TPill;
    protected abstract getItems(dragItem: DragItem<TItem>): TItem[];
    protected abstract isInterestedIn(type: DragSourceType): boolean;
    constructor(horizontal: boolean);
    isHorizontal(): boolean;
    toggleResizable(resizable: boolean): void;
    protected isSourceEventFromTarget(draggingEvent: DraggingEvent): boolean;
    protected destroy(): void;
    private destroyGui;
    init(params?: PillDropZonePanelParams): void;
    private handleKeyDown;
    private addElementClasses;
    private setupDropTarget;
    protected minimumAllowedNewInsertIndex(): number;
    private checkInsertIndex;
    private getNewInsertIndex;
    private checkDragStartedBySelf;
    private onDragging;
    protected handleDragEnterEnd(draggingEvent: DraggingEvent): void;
    private onDragEnter;
    protected isPotentialDndItems(): boolean;
    protected handleDragLeaveEnd(draggingEvent: DraggingEvent): void;
    private onDragLeave;
    protected refreshOnDragStop(): boolean;
    private onDragStop;
    private removeItems;
    private addItems;
    addItem(item: TItem): void;
    private rearrangeItems;
    refreshGui(): void;
    private getFocusedItem;
    private restoreFocus;
    focusList(fromBottom?: boolean): void;
    private getNonGhostItems;
    private addItemsToGui;
    private addAriaLabelsToComponents;
    private createItemComponent;
    private addIconAndTitleToGui;
    private isExistingItemsEmpty;
    private addEmptyMessageToGui;
    private addArrow;
}
