import shared from './shared.js'

export default (lang) => {
  const translatedText = {
    'en-US': {
      ...shared('en-US'),
      product: 'Product',
      bpartner: 'Business Partner',
      sales_order: 'Sales Order',
      purchase_order: 'Purchase Order',
      request: 'Request',
      customer_rma: 'Customer RMA',
      vendor_rma: 'Vendor RMA',
      notifications: 'Notifications',
      delivery_processing: 'Delivery Processing',
      order_completed: 'Order Completed',
      guest: 'Guest',
      user: 'User',
      account: 'Account',
      inbox: 'Inbox',
      german: 'German',
      english: 'English',
      log_out: 'Log out',
      admin_panel: 'Admin Panel',
      setup: 'Setup',
      configuration: 'Configuration',
      marketplaces: 'Marketplaces',
      price_portals: 'Price Portals',
      import_export: 'Import/Export',
      status: 'Status',
      view_all_versions: 'View all versions',
      quick_access: 'Quick Access',
      update: 'Update',
      manage: 'Manage',
      show_all_bpartner: 'Show all BPartner',
      create: 'Create',
      create_new_bartner: 'Create New BPartner',
      communicate: 'Communicate',
      sent_message: 'Sent Message',
      show_all_products: 'Show all Products',
      create_new_products: 'Create new Products',
      orders: 'Orders',
      show_all_orders: 'Show all Orders',
      create_new_sales_order: 'Create new Sales-Order',
      erp_menu: 'ERP Menu',
      overview: 'Overview',
      modifiers: 'Modifiers',
      columns: 'Columns',
      layout: 'Layout',
      stay_up_to_date: 'Stay up to date!',
      subscribe: 'Subscribe',
      upgrade: 'Upgrade',
      change_subscription: 'Change Subscription',
      upgrade_or_downgrade_account: 'Upgrade or Downgrade Account',
      upcoming: 'Upcoming'
    },
    'de-DE': {
      ...shared('de-DE'),
      product: 'Produkt',
      bpartner: 'Geschäftspartner',
      sales_order: 'Kundenauftrag',
      purchase_order: 'Auftragsbestätigung',
      request: 'Anfrage',
      customer_rma: 'Kunden RMA',
      vendor_rma: 'Lieferanten RMA',
      notifications: 'Benachrichtigungen',
      delivery_processing: 'Lieferabwicklung',
      order_completed: 'Bestellung abgeschlossen',
      guest: 'Gast',
      user: 'Benutzer',
      account: 'Konto',
      inbox: 'Posteingang',
      german: 'Deutsch',
      english: 'Englisch',
      log_out: 'Abmelden',
      admin_panel: 'Admin-Panel',
      setup: 'Aufstellen',
      configuration: 'Konfiguration',
      marketplaces: 'Marktplätze',
      price_portals: 'Preisportale',
      import_export: 'Import/Export',
      status: 'Status',
      view_all_versions: 'Alle Versionen anzeigen',
      quick_access: 'Schnellzugriff',
      update: 'Aktualisieren',
      manage: 'Verwalten',
      show_all_bpartner: 'Alle Partner anzeigen',
      create: 'Erstellen',
      create_new_bartner: 'Neuen Partner erstellen',
      communicate: 'Kommunizieren',
      sent_message: 'Gesendete Nachricht',
      show_all_products: 'Alle Produkte anzeigen',
      create_new_products: 'Erstellen Sie neue Produkte',
      orders: 'Bestellungen',
      show_all_orders: 'Alle Bestellungen anzeigen',
      create_new_sales_order: 'Neuen Kundenauftrag erstellen',
      erp_menu: 'ERP-Menü',
      overview: 'Überblick',
      modifiers: 'Modifikatoren',
      columns: 'Spalten',
      layout: 'Layout',
      stay_up_to_date: 'Bleiben Sie auf dem Laufenden!',
      subscribe: 'Abonnieren',
      upgrade: 'Upgrade',
      change_subscription: 'Abonnement ändern',
      upgrade_or_downgrade_account: 'Konto upgraden oder downgraden',
      upcoming: 'Demnächst'
    }
  }

  return translatedText[lang]
}