/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barcode4j;

import net.sf.jasperreports.components.barcode4j.Barcode4jComponent;
import net.sf.jasperreports.components.barcode4j.BarcodeComponent;
import net.sf.jasperreports.components.barcode4j.EAN128Component;
import net.sf.jasperreports.components.barcode4j.UniformBarcodeVisitor;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class CompiledBarcodeFactory
extends UniformBarcodeVisitor {
    private final JRBaseObjectFactory baseFactory;
    private BarcodeComponent compiledComponent;

    public CompiledBarcodeFactory(JRBaseObjectFactory baseFactory) {
        this.baseFactory = baseFactory;
    }

    public BarcodeComponent toCompiledComponent(BarcodeComponent barcode) {
        barcode.receive(this);
        return this.compiledComponent;
    }

    @Override
    protected void visitBarcode(BarcodeComponent barcode) {
        this.compiledComponent = barcode.cloneObject();
        JRExpression compiledCodeExpression = this.baseFactory.getExpression(barcode.getCodeExpression());
        this.compiledComponent.setCodeExpression(compiledCodeExpression);
    }

    @Override
    protected void visitBarcode(Barcode4jComponent barcode) {
        this.visitBarcode((BarcodeComponent)barcode);
        JRExpression compiledPatternExpression = this.baseFactory.getExpression(barcode.getPatternExpression());
        ((Barcode4jComponent)this.compiledComponent).setPatternExpression(compiledPatternExpression);
    }

    @Override
    public void visitEANCode128(EAN128Component ean128) {
        super.visitEANCode128(ean128);
        JRExpression compiledTemplateExpression = this.baseFactory.getExpression(ean128.getTemplateExpression());
        ((EAN128Component)this.compiledComponent).setTemplateExpression(compiledTemplateExpression);
    }
}

