/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.xel;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.zkoss.web.servlet.xel.AttributesMap;
import org.zkoss.web.servlet.xel.PageContext;
import org.zkoss.web.servlet.xel.ParameterMap;
import org.zkoss.web.servlet.xel.RequestScope;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.XelException;

public abstract class RequestXelResolver
implements VariableResolver {
    private final ServletContext _ctx;
    private final ServletRequest _request;
    private final ServletResponse _response;
    private HttpSession _sess;
    private Map<String, Object> _reqScope;
    private Map<String, Object> _sessScope;
    private Map<String, Object> _appScope;
    private PageContext _pc;
    private Map<String, Cookie> _cookies;

    public RequestXelResolver(ServletContext ctx, ServletRequest request, ServletResponse response) {
        this._ctx = ctx;
        this._request = request;
        this._response = response;
    }

    public RequestXelResolver(ServletContext ctx, ServletRequest request) {
        this(ctx, request, null);
    }

    public RequestXelResolver(ServletRequest request) {
        this(null, request, null);
    }

    public abstract ExpressionFactory getExpressionFactory();

    public PageContext getPageContext() {
        if (this._pc == null) {
            this._pc = new PageContextImpl();
        }
        return this._pc;
    }

    public ServletRequest getRequest() {
        return this._request;
    }

    public ServletResponse getResponse() {
        return this._response;
    }

    public ServletContext getServletContext() {
        return this._ctx;
    }

    public Object resolveVariable(String name) throws XelException {
        if ("pageContext".equals(name)) {
            return this.getPageContext();
        }
        if ("pageScope".equals(name)) {
            return Collections.EMPTY_MAP;
        }
        if ("requestScope".equals(name)) {
            return this.getRequestScope();
        }
        if ("sessionScope".equals(name)) {
            return this.getSessionScope();
        }
        if ("applicationScope".equals(name)) {
            return this.getApplicationScope();
        }
        if ("param".equals(name)) {
            return this._request != null ? new ParameterMap(this._request) : Collections.EMPTY_MAP;
        }
        if ("paramValues".equals(name)) {
            return this._request != null ? this._request.getParameterMap() : Collections.EMPTY_MAP;
        }
        if ("header".equals(name)) {
            if (!(this._request instanceof HttpServletRequest)) {
                return Collections.EMPTY_MAP;
            }
            final HttpServletRequest hreq = (HttpServletRequest)this._request;
            return new AttributesMap(){

                @Override
                protected Enumeration getKeys() {
                    return hreq.getHeaderNames();
                }

                @Override
                protected Object getValue(String key) {
                    return hreq.getHeader(key);
                }

                @Override
                protected void setValue(String key, Object val) {
                    throw new UnsupportedOperationException("readonly");
                }

                @Override
                protected void removeValue(String key) {
                    throw new UnsupportedOperationException("readonly");
                }
            };
        }
        if ("headerValues".equals(name)) {
            if (!(this._request instanceof HttpServletRequest)) {
                return Collections.EMPTY_MAP;
            }
            final HttpServletRequest hreq = (HttpServletRequest)this._request;
            return new AttributesMap(){
                private final Map _values = new HashMap();

                @Override
                protected Enumeration getKeys() {
                    return hreq.getHeaderNames();
                }

                @Override
                protected Object getValue(String key) {
                    Object o = this._values.get(key);
                    if (o == null) {
                        Enumeration e = hreq.getHeaders(key);
                        if (e == null || !e.hasMoreElements()) {
                            return null;
                        }
                        LinkedList l = new LinkedList();
                        do {
                            l.add(e.nextElement());
                        } while (e.hasMoreElements());
                        o = l.toArray(new String[l.size()]);
                        this._values.put(key, o);
                    }
                    return o;
                }

                @Override
                protected void setValue(String key, Object val) {
                    throw new UnsupportedOperationException("readonly");
                }

                @Override
                protected void removeValue(String key) {
                    throw new UnsupportedOperationException("readonly");
                }
            };
        }
        if ("initParam".equals(name)) {
            if (this._ctx == null) {
                return Collections.EMPTY_MAP;
            }
            return new AttributesMap(){

                @Override
                protected Enumeration getKeys() {
                    return RequestXelResolver.this._ctx.getInitParameterNames();
                }

                @Override
                protected Object getValue(String key) {
                    return RequestXelResolver.this._ctx.getInitParameter(key);
                }

                @Override
                protected void setValue(String key, Object val) {
                    throw new UnsupportedOperationException("readonly");
                }

                @Override
                protected void removeValue(String key) {
                    throw new UnsupportedOperationException("readonly");
                }
            };
        }
        if ("cookie".equals(name)) {
            Cookie[] cookies;
            if (this._cookies != null) {
                return this._cookies;
            }
            if (!(this._request instanceof HttpServletRequest) || (cookies = ((HttpServletRequest)this._request).getCookies()) == null || cookies.length == 0) {
                return Collections.EMPTY_MAP;
            }
            this._cookies = new HashMap<String, Cookie>();
            int j = cookies.length;
            while (--j >= 0) {
                this._cookies.put(cookies[j].getName(), cookies[j]);
            }
        }
        return this.findAttribute(name);
    }

    private HttpSession getSession() {
        if (this._sess != null) {
            return this._sess;
        }
        if (!(this._request instanceof HttpServletRequest)) {
            return null;
        }
        this._sess = ((HttpServletRequest)this._request).getSession(false);
        return this._sess;
    }

    private Object findAttribute(String name) {
        Object o = this.getRequestScope().get(name);
        if (o != null) {
            return o;
        }
        o = this.getSessionScope().get(name);
        return o != null ? o : this.getApplicationScope().get(name);
    }

    private Map<String, Object> getRequestScope() {
        if (this._reqScope != null) {
            return this._reqScope;
        }
        if (this._request == null) {
            return Collections.emptyMap();
        }
        this._reqScope = new RequestScope(this._request);
        return this._reqScope;
    }

    private Map<String, Object> getSessionScope() {
        if (this._sessScope != null) {
            return this._sessScope;
        }
        final HttpSession sess = this.getSession();
        if (sess == null) {
            this._sessScope = Collections.emptyMap();
            return this._sessScope;
        }
        this._sessScope = new AttributesMap(){

            @Override
            protected Enumeration<String> getKeys() {
                return sess.getAttributeNames();
            }

            @Override
            protected Object getValue(String key) {
                return sess.getAttribute(key);
            }

            @Override
            protected void setValue(String key, Object val) {
                sess.setAttribute(key, val);
            }

            @Override
            protected void removeValue(String key) {
                sess.removeAttribute(key);
            }
        };
        return this._sessScope;
    }

    private Map<String, Object> getApplicationScope() {
        if (this._appScope != null) {
            return this._appScope;
        }
        if (this._ctx == null) {
            this._appScope = Collections.emptyMap();
            return this._appScope;
        }
        this._appScope = new AttributesMap(){

            @Override
            protected Enumeration<String> getKeys() {
                return RequestXelResolver.this._ctx.getAttributeNames();
            }

            @Override
            protected Object getValue(String key) {
                return RequestXelResolver.this._ctx.getAttribute(key);
            }

            @Override
            protected void setValue(String key, Object val) {
                RequestXelResolver.this._ctx.setAttribute(key, val);
            }

            @Override
            protected void removeValue(String key) {
                RequestXelResolver.this._ctx.removeAttribute(key);
            }
        };
        return this._appScope;
    }

    private class PageContextImpl
    implements PageContext {
        private PageContextImpl() {
        }

        @Override
        public ServletRequest getRequest() {
            return RequestXelResolver.this._request;
        }

        @Override
        public ServletResponse getResponse() {
            return RequestXelResolver.this._response;
        }

        @Override
        public ServletConfig getServletConfig() {
            return null;
        }

        @Override
        public ServletContext getServletContext() {
            return RequestXelResolver.this._ctx;
        }

        @Override
        public HttpSession getSession() {
            return RequestXelResolver.this.getSession();
        }

        @Override
        public VariableResolver getVariableResolver() {
            return RequestXelResolver.this;
        }
    }
}

